/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.util.ui.HelpUtils;
import com.stratadata.util.ui.table.ColumnSortResetHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultCellEditor;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.border.LineBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableRowSorter;
import jsbchart.core.ChartManager;
import jsbugs.ComboCellRenderer;
import jsbugs.DialogMatch;
import jsbugs.DialogVersionHeader;
import jsbugs.FrameOrganiser;
import jsbugs.TableModelSB;
import jsbugs.table.ArrowCellRenderer;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.InterpHdr;
import model3.SBdb;
import model3.Well;
import model3.WellInterp;
import model3.WsWell;
import net.miginfocom.swing.MigLayout;
import util.InvalidFieldException;
import util.SB;
import util.SBException;

public class DialogMatchInterp
extends JDialog {
    private static final String[] COL_TITLES = new String[]{"Name", "", "Name"};
    private static final int[] COL_WIDTHS = new int[]{100, 20, 100};
    private static final int COL_DONOR = 0;
    private static final int COL_ARROW = 1;
    private static final int COL_HOST = 2;
    private final JComboBox interpComboBox = new JComboBox();
    private static final String NULL_DEFAULT = "<Select>";
    private static final Logger LOGGER = Logger.getLogger(DialogMatchInterp.class.getName());
    private final SBdb ws;
    private final SBdb db;
    private final TableModelMatchInterp model = new TableModelMatchInterp(this);
    private Image backgroundImage;
    private final FrameOrganiser parent;
    private final boolean inWizard;
    public boolean isOK = false;
    private List<InterpHdr> wsInterps;
    private JPanel jPanel1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private JTable jTableInterps;
    private JButton jButtonMatchAll;
    private JButton jButtonAdd;
    private JButton jButtonOK;
    private JButton jButtonHelp;
    private JButton jButtonAddAll;

    public DialogMatchInterp(FrameOrganiser parent, boolean modal, SBdb ws, SBdb db, ChartManager wsCM, boolean inWizard) throws SQLException {
        super((Frame)parent, modal);
        this.parent = parent;
        this.db = db;
        this.ws = ws;
        this.inWizard = inWizard;
        this.initComponents();
        this.init(wsCM);
    }

    private void init(ChartManager wsCM) throws SQLException {
        this.setTitle("Match Versions");
        this.model.setupTable(this.jTableInterps);
        this.interpComboBox.removeAllItems();
        Iterator<InterpHdr> it = this.db.getInterps().iterator();
        while (it.hasNext()) {
            this.interpComboBox.addItem(it.next().getDescription());
        }
        this.interpComboBox.insertItemAt(NULL_DEFAULT, 0);
        this.initHdrs(wsCM);
        this.jTableInterps.setRowSorter(new TableRowSorter<TableModelMatchInterp>(this.model));
        new ColumnSortResetHandler(this.jTableInterps).attach();
        this.model.fireTableDataChanged();
        this.jTableInterps.getTableHeader().setReorderingAllowed(false);
        this.backgroundImage = DialogMatch.getBackgroundImage();
        this.getRootPane().setDefaultButton(this.jButtonOK);
        this.jButtonOK.setText(this.inWizard ? "Continue" : "Close");
    }

    private void jButtonAddAll(ActionEvent e) {
        try {
            for (InterpHdr hdr : this.wsInterps) {
                InterpHdr dbHdr;
                if (hdr.getLink() != null || (dbHdr = this.db.getInterp(hdr.getDescription())) != null) continue;
                dbHdr = this.db.addInterp(hdr.getDescription(), null);
                hdr.setLink(dbHdr);
                this.interpComboBox.insertItemAt(dbHdr.getDescription(), 1);
                hdr.setLink(dbHdr);
            }
            this.db.commit();
            this.model.fireTableDataChanged();
        }
        catch (SQLException | InvalidFieldException sql) {
            SbugsExceptionHandler.showStackError(sql, this);
            this.db.doRollback();
        }
    }

    private void initHdrs(ChartManager wsCM) throws SQLException {
        this.wsInterps = new ArrayList<InterpHdr>();
        block2: for (InterpHdr hdr : this.ws.getInterps()) {
            Iterator<Well> wellIterator = this.ws.getWellIterator();
            while (wellIterator.hasNext()) {
                Well well = wellIterator.next();
                try {
                    WellInterp interp = well.getInterp(hdr.getInterpID());
                    if (!interp.hasData()) continue;
                    this.wsInterps.add(hdr);
                    continue block2;
                }
                catch (SBException sBException) {
                }
            }
            if (wsCM == null || !wsCM.hasInterpOccs(hdr.getInterpID())) continue;
            this.wsInterps.add(hdr);
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel(this){
            final /* synthetic */ DialogMatchInterp this$0;
            {
                DialogMatchInterp dialogMatchInterp = this$0;
                Objects.requireNonNull(dialogMatchInterp);
                this.this$0 = dialogMatchInterp;
            }

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.drawImage(this.this$0.backgroundImage, 0, 0, this.getWidth(), this.getHeight(), this);
            }
        };
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTableInterps = new JTable();
        this.jButtonMatchAll = new JButton();
        this.jButtonAdd = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonAddAll = new JButton();
        this.setDefaultCloseOperation(0);
        this.setMinimumSize(new Dimension(400, 250));
        this.addWindowListener(new WindowAdapter(this){
            final /* synthetic */ DialogMatchInterp this$0;
            {
                DialogMatchInterp dialogMatchInterp = this$0;
                Objects.requireNonNull(dialogMatchInterp);
                this.this$0 = dialogMatchInterp;
            }

            @Override
            public void windowClosing(WindowEvent e) {
                this.this$0.windowClosing(e);
            }
        });
        Container contentPane = this.getContentPane();
        contentPane.setLayout((LayoutManager)new MigLayout("fill,insets 0,hidemode 3", "[fill]", "[fill]"));
        this.jLabel1.setFont(this.jLabel1.getFont().deriveFont(this.jLabel1.getFont().getStyle() | 1, (float)this.jLabel1.getFont().getSize() + 2.0f));
        this.jLabel1.setForeground(Color.white);
        this.jLabel1.setText("Workspace...");
        this.jLabel2.setFont(this.jLabel2.getFont().deriveFont(this.jLabel2.getFont().getStyle() | 1, (float)this.jLabel2.getFont().getSize() + 2.0f));
        this.jLabel2.setText("...Database");
        this.jScrollPane1.setToolTipText("Select the database abbreviation to match");
        this.jScrollPane1.setViewportBorder(new LineBorder(Color.white));
        this.jTableInterps.setModel(this.model);
        this.jScrollPane1.setViewportView(this.jTableInterps);
        this.jButtonMatchAll.setText("Match all");
        this.jButtonMatchAll.addActionListener(e -> this.jButtonMatchAllActionPerformed(e));
        this.jButtonAdd.setText("Add...");
        this.jButtonAdd.addActionListener(e -> this.jButtonAddActionPerformed(e));
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(e -> this.jButtonOKActionPerformed(e));
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(e -> this.jButtonHelpActionPerformed(e));
        this.jButtonAddAll.setText("Add all...");
        this.jButtonAddAll.addActionListener(e -> this.jButtonAddAll(e));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup().addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup().addComponent(this.jScrollPane1, -1, 417, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jLabel2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jButtonAdd, GroupLayout.Alignment.LEADING).addComponent(this.jButtonOK, GroupLayout.Alignment.LEADING).addComponent(this.jButtonHelp, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonAddAll, GroupLayout.Alignment.LEADING)).addComponent(this.jButtonMatchAll)).addContainerGap()));
        jPanel1Layout.linkSize(0, this.jButtonAdd, this.jButtonAddAll, this.jButtonHelp, this.jButtonMatchAll, this.jButtonOK);
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup().addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1, -2, 21, -2).addComponent(this.jLabel2, -2, 27, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup().addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jButtonMatchAll).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonAdd).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonAddAll).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 121, Short.MAX_VALUE).addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonOK)).addComponent(this.jScrollPane1, -1, 249, Short.MAX_VALUE)).addContainerGap()));
        contentPane.add((Component)this.jPanel1, "cell 0 0");
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    private void jButtonMatchAllActionPerformed(ActionEvent evt) {
        try {
            for (InterpHdr hdr : this.wsInterps) {
                InterpHdr dbHdr;
                if (hdr.getLink() != null || (dbHdr = this.db.getInterp(hdr.getDescription())) == null) continue;
                hdr.setLink(dbHdr);
            }
            this.model.fireTableDataChanged();
        }
        catch (SQLException sql) {
            SbugsExceptionHandler.showStackError(sql, this);
        }
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        if (this.jTableInterps.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "Select one row from the table to add.", this.getTitle(), 1);
            return;
        }
        try {
            InterpHdr hdr = this.wsInterps.get(this.jTableInterps.convertRowIndexToModel(this.jTableInterps.getSelectedRow()));
            if (hdr.getLink() != null) {
                JOptionPane.showMessageDialog(this, "Item to be added is already linked.", this.getTitle(), 1);
                return;
            }
            DialogVersionHeader dialog = new DialogVersionHeader((JDialog)this, true, this.db, hdr.getDescription());
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.isOK) {
                this.interpComboBox.insertItemAt(dialog.interpHdr.getDescription(), 1);
                hdr.setLink(dialog.interpHdr);
                this.model.fireTableDataChanged();
            }
        }
        catch (RuntimeException | SQLException | SBException ex) {
            SbugsExceptionHandler.showStackError(ex, this);
        }
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.inWizard) {
            for (InterpHdr hdr : this.wsInterps) {
                if (hdr.getLink() != null) continue;
                JOptionPane.showMessageDialog(this, "You must match all versions.", this.getTitle(), 2);
                return;
            }
        }
        if (this.checkLinks() && this.resetMonitors()) {
            this.isOK = true;
            this.dispose();
        }
    }

    private boolean resetMonitors() {
        try {
            Iterator<Well> it = this.ws.getWellIterator();
            while (it.hasNext()) {
                WsWell well = (WsWell)it.next();
                for (InterpHdr hdr : this.ws.getInterps()) {
                    if (hdr.getLink() == null) continue;
                    try {
                        WellInterp wellInterp = well.getInterp(hdr.getInterpID());
                        well.resetInterpDataMonitors(this.parent.dataTypes, hdr.getLink().getInterpID());
                        well.updateInterpStatus(wellInterp, well.getWellUnits());
                    }
                    catch (SBException se) {
                        LOGGER.log(Level.WARNING, "Error getting well interp from ", se);
                    }
                }
            }
            return true;
        }
        catch (NullPointerException | SQLException e) {
            SbugsExceptionHandler.showStackError(e, this);
            return false;
        }
    }

    private boolean checkLinks() {
        try {
            HashSet<InterpHdr> set = new HashSet<InterpHdr>();
            for (InterpHdr hdr : this.ws.getInterps()) {
                if (hdr.getLink() == null || set.add(hdr.getLink())) continue;
                JOptionPane.showMessageDialog(this, "You cannot match more than one version to the same database version.", this.getTitle(), 2);
                return false;
            }
            return true;
        }
        catch (SQLException sql) {
            SbugsExceptionHandler.showStackError(sql, this);
            return false;
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        HelpUtils.openHelp((String)"dialogmatchinterp.html");
    }

    private void windowClosing(WindowEvent evt) {
        int opt;
        if (this.inWizard && (opt = JOptionPane.showConfirmDialog(this, "Exit guided import?", this.getTitle(), 0)) != 0) {
            return;
        }
        if (this.checkLinks()) {
            this.resetMonitors();
            this.dispose();
        }
    }

    private class TableModelMatchInterp
    extends AbstractTableModel {
        final /* synthetic */ DialogMatchInterp this$0;

        private TableModelMatchInterp(DialogMatchInterp dialogMatchInterp) {
            DialogMatchInterp dialogMatchInterp2 = dialogMatchInterp;
            Objects.requireNonNull(dialogMatchInterp2);
            this.this$0 = dialogMatchInterp2;
        }

        @Override
        public int getColumnCount() {
            return COL_TITLES.length;
        }

        @Override
        public int getRowCount() {
            if (this.this$0.ws == null || this.this$0.wsInterps == null) {
                return 0;
            }
            return this.this$0.wsInterps.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (this.this$0.ws == null || this.this$0.wsInterps == null) {
                return null;
            }
            InterpHdr hdr = this.this$0.wsInterps.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return hdr.getDescription();
                }
                case 2: {
                    return hdr.getLink() == null ? DialogMatchInterp.NULL_DEFAULT : hdr.getLink().getDescription();
                }
                case 1: {
                    return hdr.getLink() != null ? TableModelSB.linked : TableModelSB.unlinked;
                }
            }
            return "";
        }

        public Class getColumnClass(int c) {
            switch (c) {
                case 0: {
                    return String.class;
                }
                case 2: {
                    return String.class;
                }
                case 1: {
                    return Boolean.class;
                }
            }
            return Object.class;
        }

        @Override
        public boolean isCellEditable(int row, int columnIndex) {
            switch (columnIndex) {
                case 2: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public void setValueAt(Object obj, int row, int col) {
            try {
                switch (col) {
                    default: {
                        break;
                    }
                    case 2: {
                        InterpHdr hdr = this.this$0.wsInterps.get(row);
                        InterpHdr dbHdr = this.this$0.db.getInterp((String)obj);
                        if (dbHdr != null) {
                            hdr.setLink(dbHdr);
                            break;
                        }
                        hdr.setLink(null);
                        break;
                    }
                }
            }
            catch (Exception pe) {
                pe.printStackTrace();
            }
        }

        private void setupTable(JTable table) throws SQLException {
            for (int i = 0; i < COL_TITLES.length; ++i) {
                table.getColumnModel().getColumn(i).setHeaderValue(COL_TITLES[i]);
                table.getColumnModel().getColumn(i).setPreferredWidth(COL_WIDTHS[i]);
            }
            table.getColumnModel().getColumn(1).setMaxWidth(COL_WIDTHS[1]);
            table.setDefaultRenderer(Boolean.class, new ArrowCellRenderer());
            table.getColumnModel().getColumn(2).setCellEditor(new DefaultCellEditor(this.this$0.interpComboBox));
            table.getColumnModel().getColumn(2).setCellRenderer(new ComboCellRenderer());
            SB.setTableHeaderBold((JTable)table);
        }
    }
}

