/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.util.ui.table.ColumnSortResetHandler;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Objects;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import jsbugs.DialogFilePreviewSelect;
import jsbugs.DialogMatch;
import jsbugs.FrameJsbugs;
import jsbugs.table.ArrowCellRenderer;
import jsbugs.table.SampleRenderer;
import jsbugs.table.SampleStatusRenderer;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.IGDIntervalZone;
import model3.IGDScheme;
import model3.InterpHdr;
import model3.Lastval;
import model3.SBdb;
import model3.SQPick;
import model3.Sample;
import model3.Surface;
import model3.Well;
import model3.WellInterp;
import model3.WsWell;
import util.DepthUtils;
import util.InvalidFieldException;
import util.MatchData;
import util.SB;
import util.SBException;
import util.SBPermissionException;
import util.SbugsFileFilter;
import util.exception.StackError;
import util.status.SbugsStatusRenderer;
import util.status.StringStatus;

public class DialogMatchSqpick
extends JDialog {
    private final WsWell wsWell;
    private final TableModelMatchSqpick model = new TableModelMatchSqpick();
    private Image backgroundImage;
    private WellInterp wsInterp;
    private WellInterp dbInterp;
    private final SBdb dbDB;
    private final SBdb wsDB;
    private JButton jButtonClose;
    private JButton jButtonDelete;
    private JButton jButtonExclude;
    private JButton jButtonRead;
    private JButton jButtonSave;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JTable jTableMatchSqpick;

    public DialogMatchSqpick(Frame parent, boolean modal, SBdb ws, SBdb db, WsWell well, char units, InterpHdr hdr) throws SBException, SQLException {
        super(parent, modal);
        this.wsWell = well;
        this.dbDB = db;
        this.wsDB = ws;
        this.model.units = units;
        this.initComponents();
        this.init(hdr);
    }

    private void init(InterpHdr hdr) throws SBException, SQLException {
        this.backgroundImage = DialogMatch.getBackgroundImage();
        this.setTitle("Match Sequence Picks");
        this.getRootPane().setDefaultButton(this.jButtonClose);
        int interpID = hdr.getInterpID();
        if (this.wsWell.hasInterpLoaded(interpID)) {
            this.wsInterp = this.wsWell.getInterp(interpID);
        }
        this.checkLinks();
        if (this.wsWell.getLink() != null && hdr.getLink() != null) {
            this.wsWell.getLink().loadInterps();
            int linkInterpID = hdr.getLink().getInterpID();
            if (this.wsWell.getLink().hasInterpLoaded(linkInterpID)) {
                this.dbInterp = this.wsWell.getLink().getInterp(linkInterpID);
                this.wsWell.getLink().loadInterp(this.dbInterp);
            }
        }
        this.model.data.init(this.wsInterp != null ? this.wsInterp.getSQPicks() : null, this.dbInterp != null ? this.dbInterp.getSQPicks() : null);
        SB.setTableHeaderBold((JTable)this.jTableMatchSqpick);
        TableColumnModel columnModel = this.jTableMatchSqpick.getTableHeader().getColumnModel();
        columnModel.getColumn(9).setMaxWidth(TableModelMatchSqpick.colWidths[9]);
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            columnModel.getColumn(i).setHeaderValue(TableModelMatchSqpick.colTitles[i]);
            columnModel.getColumn(i).setPreferredWidth(TableModelMatchSqpick.colWidths[i]);
        }
        columnModel.getColumn(1).setCellRenderer((TableCellRenderer)((Object)new SampleStatusRenderer(this.model.units)));
        columnModel.getColumn(11).setCellRenderer(new SampleRenderer(this.model.units));
        this.jTableMatchSqpick.setDefaultRenderer(StringStatus.class, (TableCellRenderer)new SbugsStatusRenderer());
        this.jTableMatchSqpick.setDefaultRenderer(Boolean.class, new ArrowCellRenderer());
        this.jTableMatchSqpick.setRowSorter(new TableRowSorter<TableModelMatchSqpick>(this.model));
        new ColumnSortResetHandler(this.jTableMatchSqpick).attach();
        this.jTableMatchSqpick.getTableHeader().setReorderingAllowed(false);
    }

    private void checkLinks() throws SQLException, SBException {
        if (this.wsWell.getLink() != null) {
            for (InterpHdr interpHdr : this.wsDB.getInterps()) {
                if (interpHdr.getLink() != null) continue;
                throw new SBException("Cannot open dialog, Versions not Matched");
            }
            for (SQPick pick : this.wsInterp.getSQPicks()) {
                if (pick.getSurface() == null || pick.getSurface().getScheme().getLink() != null) continue;
                throw new SBException("Cannot open dialog, Stratigraphic Schemes not Matched");
            }
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel(this){
            final /* synthetic */ DialogMatchSqpick this$0;
            {
                DialogMatchSqpick dialogMatchSqpick = this$0;
                Objects.requireNonNull(dialogMatchSqpick);
                this.this$0 = dialogMatchSqpick;
            }

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.drawImage(this.this$0.backgroundImage, 0, 0, this.getWidth(), this.getHeight(), this);
            }
        };
        this.jScrollPane1 = new JScrollPane();
        this.jTableMatchSqpick = new JTable();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jButtonExclude = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonClose = new JButton();
        this.jButtonRead = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jButtonSave = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(400, 300));
        this.setModal(true);
        this.jTableMatchSqpick.setModel(this.model);
        this.jScrollPane1.setViewportView(this.jTableMatchSqpick);
        this.jLabel1.setFont(this.jLabel1.getFont().deriveFont(this.jLabel1.getFont().getStyle() | 1, this.jLabel1.getFont().getSize() + 2));
        this.jLabel1.setForeground(new Color(255, 255, 255));
        this.jLabel1.setText("Workspace...");
        this.jLabel2.setFont(this.jLabel2.getFont().deriveFont(this.jLabel2.getFont().getStyle() | 1, this.jLabel2.getFont().getSize() + 2));
        this.jLabel2.setText("...Database");
        this.jButtonExclude.setText("Exclude");
        this.jButtonExclude.setToolTipText("Exclude selected data from workspace");
        this.jButtonExclude.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchSqpick this$0;
            {
                DialogMatchSqpick dialogMatchSqpick = this$0;
                Objects.requireNonNull(dialogMatchSqpick);
                this.this$0 = dialogMatchSqpick;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonExcludeActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.setToolTipText("Delete selected data from database");
        this.jButtonDelete.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchSqpick this$0;
            {
                DialogMatchSqpick dialogMatchSqpick = this$0;
                Objects.requireNonNull(dialogMatchSqpick);
                this.this$0 = dialogMatchSqpick;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchSqpick this$0;
            {
                DialogMatchSqpick dialogMatchSqpick = this$0;
                Objects.requireNonNull(dialogMatchSqpick);
                this.this$0 = dialogMatchSqpick;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCloseActionPerformed(evt);
            }
        });
        this.jButtonRead.setText("Read...");
        this.jButtonRead.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchSqpick this$0;
            {
                DialogMatchSqpick dialogMatchSqpick = this$0;
                Objects.requireNonNull(dialogMatchSqpick);
                this.this$0 = dialogMatchSqpick;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonReadActionPerformed(evt);
            }
        });
        this.jButtonSave.setText("Save");
        this.jButtonSave.setToolTipText("Save ALL unsaved intervals from workspace into database");
        this.jButtonSave.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchSqpick this$0;
            {
                DialogMatchSqpick dialogMatchSqpick = this$0;
                Objects.requireNonNull(dialogMatchSqpick);
                this.this$0 = dialogMatchSqpick;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSaveActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 380, Short.MAX_VALUE).addComponent(this.jLabel2)).addComponent(this.jScrollPane1, -1, 559, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButtonClose, -1, 78, Short.MAX_VALUE).addComponent(this.jButtonDelete, -1, 78, Short.MAX_VALUE).addComponent(this.jButtonExclude, -1, 78, Short.MAX_VALUE).addComponent(this.jButtonRead, -1, 78, Short.MAX_VALUE).addComponent(this.jSeparator1, -1, 78, Short.MAX_VALUE).addComponent(this.jButtonSave, -1, 78, Short.MAX_VALUE)).addGap(13, 13, 13)));
        jPanel1Layout.linkSize(0, this.jButtonClose, this.jButtonDelete, this.jButtonExclude, this.jButtonRead, this.jButtonSave, this.jSeparator1);
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jButtonExclude).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonDelete).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSave).addGap(13, 13, 13).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonRead).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 224, Short.MAX_VALUE).addComponent(this.jButtonClose)).addComponent(this.jScrollPane1, -1, 410, Short.MAX_VALUE)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonExcludeActionPerformed(ActionEvent evt) {
        this.deleteSqpick(false);
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        this.deleteSqpick(true);
    }

    private void jButtonReadActionPerformed(ActionEvent evt) {
        SbugsFileFilter filterAll = new SbugsFileFilter();
        JFileChooser jFileChooser = new JFileChooser();
        File setDir = null;
        try {
            setDir = new File(Lastval.getString(this.dbDB, "JIGDFILE"));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (setDir == null || !setDir.exists()) {
            setDir = new File(".");
        }
        jFileChooser.setCurrentDirectory(setDir);
        SbugsFileFilter filter = new SbugsFileFilter();
        filter.addExtension("txt");
        filter.addExtension("csv");
        filter.addExtension("lst");
        filter.addExtension("prn");
        jFileChooser.setFileFilter((FileFilter)filter);
        if (jFileChooser.showOpenDialog(this) == 0) {
            String fileName = jFileChooser.getSelectedFile().getPath();
            String[] types = new String[]{"CSV well | depth | pick (no header)", "CSV well | depth | pick | boundary/confidence (no header)", "CSV depth | pick (1 header lines)", "CSV well | pick | depth | age (1 header line)", "Tabbed well | well | * | * | pick | age | depth"};
            try {
                Lastval.putString(this.dbDB, "JIGDFILE", fileName);
                this.dbDB.commit();
                DialogFilePreviewSelect selector = new DialogFilePreviewSelect(this, true, fileName, types);
                selector.setLocationRelativeTo(this);
                selector.setVisible(true);
                if (!selector.isOK()) {
                    return;
                }
                int selectedFileType = selector.selectedItem;
                BufferedReader in = new BufferedReader(new FileReader(fileName));
                String schemeName = jFileChooser.getSelectedFile().getName();
                schemeName = schemeName.substring(0, schemeName.indexOf(46) - 1);
                IGDScheme scheme = this.wsDB.addIGDScheme(10, schemeName, "");
                HashSet<Integer> dummy = new HashSet<Integer>();
                dummy.add(1);
                this.wsWell.fillData(dummy, 0);
                switch (selectedFileType) {
                    case 0: {
                        this.importTextFile(in, scheme, ',', 0, 3, 0, 1, -1, 2, -1, -1);
                        break;
                    }
                    case 1: {
                        this.importTextFile(in, scheme, ',', 0, 4, 0, 1, -1, 2, -1, 3);
                        break;
                    }
                    case 2: {
                        this.importTextFile(in, scheme, ',', 1, 2, -1, 0, -1, 1, -1, -1);
                        break;
                    }
                    case 3: {
                        this.importTextFile(in, scheme, ',', 1, 4, 0, 2, -1, 1, 3, -1);
                        break;
                    }
                    case 4: {
                        this.importTextFile(in, scheme, '\t', 1, 7, 0, 6, -1, 4, 5, -1);
                        break;
                    }
                    default: {
                        JOptionPane.showMessageDialog(this, "Cannot recognise file type. Please select a file type from the list of types at the base of the dialog", "Import", 2);
                    }
                }
                in.close();
                if (this.wsInterp != null) {
                    this.wsInterp.updateSQPickStatus(this.wsWell.getMonitor(this.wsInterp.getHeader().getInterpID(), 14), this.wsWell.getLink(), this.wsWell.getWellUnits());
                    this.wsWell.updateSQPickStatus(this.wsInterp, this.dbInterp != null ? this.dbInterp.getHeader() : null, this.model.units, true);
                }
                this.model.data.init(this.wsInterp != null ? this.wsInterp.getSQPicks() : null, this.dbInterp != null ? this.dbInterp.getSQPicks() : null);
                this.model.fireTableDataChanged();
            }
            catch (IOException eio) {
                JOptionPane.showMessageDialog(null, "Problem reading file: " + eio.getMessage());
                eio.printStackTrace();
            }
            catch (SQLException sql) {
                FrameJsbugs.showStackError("SQL Error", sql, this.dbDB);
            }
            catch (SBException sbe) {
                StackError.showStackError((String)"Error", (Throwable)sbe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void jButtonSaveActionPerformed(ActionEvent evt) {
        block27: {
            if (this.wsWell.getLink() == null) {
                JOptionPane.showMessageDialog(this, "No linked well - use Match | Wells from main menu.", this.getTitle(), 2);
                return;
            }
            if (this.dbInterp == null) {
                JOptionPane.showMessageDialog(this, "Version not linked - use Match | Versions from main menu.", this.getTitle(), 2);
                return;
            }
            boolean samplesCreated = false;
            SQPick added = null;
            Well dbWell = this.wsWell.getLink();
            Statement stmt = null;
            for (int row = 0; row < this.model.data.size(); ++row) {
                MatchData.MatchPair pair = this.model.data.get(row);
                SQPick ws = (SQPick)pair.getWs();
                SQPick db = (SQPick)pair.getDb();
                if (ws == null) continue;
                if (db == null) {
                    if (ws.getSurface().getSchID() == 0) {
                        JOptionPane.showMessageDialog(this, "Interval: " + ws.toString() + " not linked to a scheme. Use Match | Stratigraphic intervals from menu.");
                        break;
                    }
                    IGDScheme wsScheme = this.wsDB.getIGDScheme(ws.getSurface().getSchID());
                    if (wsScheme == null) {
                        JOptionPane.showMessageDialog(this, "Scheme for pick: " + ws.toString() + " not found in workspace. Use Match | Stratigraphic intervals from menu.");
                        break;
                    }
                    IGDScheme dbScheme = wsScheme.getLink();
                    if (dbScheme == null) {
                        JOptionPane.showMessageDialog(this, "Pick: " + ws.toString() + " scheme not found in workspace. Use Match | Stratigraphic intervals from menu.");
                        break;
                    }
                    if (ws.getSurface().getLink() == null) {
                        JOptionPane.showMessageDialog(this, "Pick: " + ws.toString() + " surface not linked to database. Use Match | Stratigraphic intervals from menu.");
                        break;
                    }
                    Sample sample = dbWell.getSample(ws.getSample().getTopDepth(), ws.getSample().getBaseDepth(), ws.getSample().getType());
                    if (sample == null) {
                        int opt = JOptionPane.showConfirmDialog(this, "Sample: " + String.valueOf(ws.getSample()) + " does not exist: create it?", this.getTitle(), 1, 3);
                        if (opt == 1) continue;
                        if (opt == 2 || opt == -1) break;
                        if (stmt == null) {
                            stmt = dbWell.getDataModel().getDatabase().createStatement();
                        }
                        sample = dbWell.addSampleCopy(stmt, ws.getSample());
                        samplesCreated = true;
                    }
                    SQPick.Builder pickBuilder = new SQPick.Builder(this.dbDB, ws.getSurface().getLink(), sample, ws.getBndInt()).informalName(ws.getInfName()).questionable(ws.isQuestionable()).observed(ws.isObserved());
                    added = this.dbInterp.addSQPick(dbWell, pickBuilder);
                    dbWell.getDataModel().commit();
                    continue;
                }
                if (ws.getStatus() != Sample.PARTSTORED) continue;
                JOptionPane.showMessageDialog(null, "Not implemented - can't update picks from workspace.");
            }
            if (stmt != null) {
                stmt.close();
            }
            this.wsWell.getLink().getDataModel().commit();
            try {
                this.model.data.init(this.wsInterp != null ? this.wsInterp.getSQPicks() : null, this.dbInterp != null ? this.dbInterp.getSQPicks() : null);
                this.model.fireTableDataChanged();
                if (added != null) {
                    this.dbInterp.notifyObservers(added);
                }
                if (samplesCreated) {
                    this.wsWell.getLink().notifyObservers(Sample.class);
                }
                break block27;
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            break block27;
            catch (Exception e) {
                try {
                    JOptionPane.showMessageDialog(this, "Error saving interval: " + e.getMessage(), this.getTitle(), 0);
                    e.printStackTrace();
                    this.wsWell.getLink().getDataModel().doRollback();
                }
                catch (Throwable throwable) {
                    try {
                        this.model.data.init(this.wsInterp != null ? this.wsInterp.getSQPicks() : null, this.dbInterp != null ? this.dbInterp.getSQPicks() : null);
                        this.model.fireTableDataChanged();
                        if (added != null) {
                            this.dbInterp.notifyObservers(added);
                        }
                        if (samplesCreated) {
                            this.wsWell.getLink().notifyObservers(Sample.class);
                        }
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                    throw throwable;
                }
                try {
                    this.model.data.init(this.wsInterp != null ? this.wsInterp.getSQPicks() : null, this.dbInterp != null ? this.dbInterp.getSQPicks() : null);
                    this.model.fireTableDataChanged();
                    if (added != null) {
                        this.dbInterp.notifyObservers(added);
                    }
                    if (samplesCreated) {
                        this.wsWell.getLink().notifyObservers(Sample.class);
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
    }

    void importTextFile(BufferedReader in, IGDScheme scheme, char delim, int nHeaders, int nColumns, int wellColumn, int topColumn, int baseColumn, int pickColumn, int ageColumn, int boundaryColumn) throws IOException, SBException, SQLException {
        String buff;
        for (int i = 0; i < nHeaders; ++i) {
            buff = in.readLine();
        }
        buff = in.readLine();
        if (delim == ',') {
            String[] splitComma = buff.split(",");
            String[] splitSemiColon = buff.split(";");
            if (splitSemiColon.length > splitComma.length) {
                delim = (char)59;
            }
        }
        String wellUWI = null;
        while (buff != null) {
            block30: {
                if (buff.indexOf(delim) > 0) {
                    Sample sample = null;
                    Surface surface = null;
                    double age = 0.0;
                    double depth = 0.0;
                    int column = 0;
                    int bnd = -1;
                    while (column < nColumns && buff != null && !buff.isEmpty()) {
                        String strg = buff.indexOf(delim) > 0 ? buff.substring(0, buff.indexOf(delim)).trim() : buff.trim();
                        if (column == wellColumn) {
                            if (wellUWI == null) {
                                wellUWI = strg;
                            }
                            if (!wellUWI.equals(strg)) {
                                throw new SBException("Well identifier changes in file - edit file to separate");
                            }
                        } else if (column == topColumn) {
                            depth = DepthUtils.parseDepthString((String)strg, (char)this.model.units);
                            if (depth < (double)0.0029f) {
                                buff = null;
                                continue;
                            }
                            sample = this.wsWell.getSample(depth, null, true);
                            if (sample == null) {
                                sample = this.wsWell.addSample(this.dbDB.useSampleTops() ? Double.valueOf(depth) : null, this.dbDB.useSampleTops() ? null : Double.valueOf(depth), "LOG", null);
                            }
                        } else {
                            if (column == baseColumn) {
                                throw new SBException("Base column reading not supported");
                            }
                            if (column == pickColumn) {
                                String pickName = buff.substring(0).trim();
                                if (pickName.indexOf(delim) >= 0) {
                                    pickName = pickName.substring(0, pickName.indexOf(delim)).trim();
                                }
                                if ((surface = scheme.getSurface(pickName, null)) == null) {
                                    try {
                                        surface = scheme.addSurface(new Surface.Builder(scheme.getDatabase()).name(pickName).age(age).type(Surface.SurfaceType.parseType(pickName, Surface.SurfaceType.MFS)));
                                    }
                                    catch (InvalidFieldException ife) {
                                        ife.printStackTrace();
                                    }
                                }
                            } else if (column == ageColumn) {
                                age = Double.parseDouble(strg);
                                if (surface != null) {
                                    surface.setAge(age);
                                }
                            } else if (column == boundaryColumn && strg != null && !strg.isEmpty()) {
                                bnd = IGDIntervalZone.getBoundaryTypeFromString(strg);
                            }
                        }
                        if (buff.indexOf(delim) < 0) break;
                        buff = buff.substring(buff.indexOf(delim) + 1);
                        ++column;
                    }
                    if (sample != null && surface != null) {
                        try {
                            this.wsInterp.addSQPick(this.wsWell, sample, surface, surface.getName(), false, bnd >= 0 ? bnd : surface.getBndDefault());
                            break block30;
                        }
                        catch (IllegalStateException | InvalidFieldException ex) {
                            if (!this.handleException((Exception)ex)) {
                                break;
                            }
                            break block30;
                        }
                        catch (SBPermissionException pe) {
                            throw new IllegalStateException(pe);
                        }
                    }
                    System.out.println("Can't add pick for depth: " + depth + ", surface: " + String.valueOf(surface));
                }
            }
            buff = in.readLine();
        }
    }

    private boolean handleException(Exception ex) {
        int opt = JOptionPane.showConfirmDialog(this, "Error reading file: " + ex.getMessage() + "\nContinue reading?", this.getTitle(), 0, 3);
        return opt == 0;
    }

    private void deleteSqpick(boolean fromDatabase) {
        if (fromDatabase && this.wsWell.getLink() == null) {
            JOptionPane.showMessageDialog(this, "No well data - use Exclude to remove from workspace", this.getTitle(), 2);
            return;
        }
        if (this.jTableMatchSqpick.getSelectedRowCount() == 0) {
            JOptionPane.showMessageDialog(this, "No rows selected", this.getTitle(), 2);
            return;
        }
        int[] selected = this.jTableMatchSqpick.getSelectedRows();
        LinkedList<SQPick> toRemove = new LinkedList<SQPick>();
        for (int i : selected) {
            SQPick sqpick = fromDatabase ? (SQPick)this.model.data.get(this.jTableMatchSqpick.convertRowIndexToModel(i)).getDb() : (SQPick)this.model.data.get(this.jTableMatchSqpick.convertRowIndexToModel(i)).getWs();
            if (sqpick == null) continue;
            toRemove.add(sqpick);
        }
        if (fromDatabase && toRemove.size() > 0) {
            Object msg = "Really delete ";
            msg = (String)msg + (String)(toRemove.size() == 1 ? "this pick" : "these " + toRemove.size() + " pick");
            if (JOptionPane.showConfirmDialog(this, msg = (String)msg + (toRemove.size() == 1 ? "?" : "s?"), this.getTitle(), 0, 3) != 0) {
                return;
            }
        }
        try {
            Well deleteFromWell = fromDatabase ? this.wsWell.getLink() : this.wsWell;
            WellInterp deleteFromInterp = fromDatabase ? this.dbInterp : this.wsInterp;
            deleteFromInterp.delete(toRemove, deleteFromWell.getWellID());
            if (fromDatabase) {
                this.wsWell.getLink().getDataModel().commit();
            }
            String text = fromDatabase ? "deleted" : "excluded";
            JOptionPane.showMessageDialog(this, "Picks " + text + ": " + toRemove.size(), this.getTitle(), 1);
            if (fromDatabase) {
                deleteFromWell.getDataModel().commit();
                deleteFromInterp.notifyObservers(21);
            } else {
                this.wsWell.updateSQPickStatus(this.wsInterp, this.dbInterp != null ? this.dbInterp.getHeader() : null, this.model.units, true);
            }
            this.model.data.init(this.wsInterp != null ? this.wsInterp.getSQPicks() : null, this.dbInterp != null ? this.dbInterp.getSQPicks() : null);
            this.model.fireTableDataChanged();
        }
        catch (SQLException | SBException e) {
            if (fromDatabase) {
                this.wsWell.getLink().getDataModel().doRollback();
            }
            FrameJsbugs.showStackError("Error " + (fromDatabase ? "deleting" : "excluding") + " picks", (Exception)e, this.wsWell.getLink().getDataModel());
        }
        catch (SBPermissionException p) {
            SbugsExceptionHandler.showStackError(p);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private static class TableModelMatchSqpick
    extends AbstractTableModel {
        static final int COL_WS_SCHEME = 0;
        static final int COL_WS_SAMPLE = 1;
        static final int COL_WS_SURFACE = 2;
        static final int COL_WS_TYPE = 3;
        static final int COL_WS_INFNAME = 4;
        static final int COL_WS_AGE = 5;
        static final int COL_WS_BND = 6;
        static final int COL_WS_OBS = 7;
        static final int COL_WS_QUAL = 8;
        static final int COL_ARROW = 9;
        static final int COL_DB_SCHEME = 10;
        static final int COL_DB_SAMPLE = 11;
        static final int COL_DB_SURFACE = 12;
        static final int COL_DB_TYPE = 13;
        static final int COL_DB_INFNAME = 14;
        static final int COL_DB_AGE = 15;
        static final int COL_DB_BND = 16;
        static final int COL_DB_OBS = 17;
        static final int COL_DB_QUAL = 18;
        static final String[] colTitles = new String[]{"Scheme", "Depth", "Surface", "Type", "Informal name", "Age", "Boundary", "Observed", "Qualifier", "", "Scheme", "Depth", "Surface", "Type", "Informal name", "Age", "Boundary", "Observed", "Qualifier"};
        static final int[] colWidths = new int[]{30, 60, 60, 20, 25, 20, 30, 20, 20, 20, 30, 60, 60, 20, 25, 20, 30, 20, 20};
        char units = (char)77;
        MatchData data = new MatchData();

        private TableModelMatchSqpick() {
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public int getColumnCount() {
            return colTitles.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            MatchData.MatchPair pair = this.data.get(rowIndex);
            if (pair == null) {
                return "";
            }
            SQPick ws = (SQPick)pair.getWs();
            SQPick db = (SQPick)pair.getDb();
            if (ws != null) {
                ws.getSample().displayUnits = this.units;
            }
            if (db != null) {
                db.getSample().displayUnits = this.units;
            }
            try {
                switch (columnIndex) {
                    case 0: {
                        return ws == null ? null : new StringStatus(ws.getSchemeName(true), ws.getStatus());
                    }
                    case 1: {
                        return ws == null ? null : ws.getSample();
                    }
                    case 2: {
                        return ws == null ? null : new StringStatus(ws.getSurface().toString(), ws.getStatus());
                    }
                    case 3: {
                        return ws == null ? null : new StringStatus(ws.getSurface().getTypeString(), ws.getStatus());
                    }
                    case 4: {
                        return ws == null ? null : new StringStatus(ws.getInfName(), ws.getStatus());
                    }
                    case 5: {
                        return ws == null ? null : new StringStatus(SB.floatString((double)ws.getSurface().getAge(), (int)2), ws.getStatus());
                    }
                    case 6: {
                        return ws == null ? null : new StringStatus(ws.getBnd(), ws.getStatus());
                    }
                    case 7: {
                        return ws == null ? null : new StringStatus(ws.isObserved() ? "Yes" : "No", ws.getStatus());
                    }
                    case 8: {
                        return ws == null ? null : new StringStatus(ws.getQualifier(), ws.getStatus());
                    }
                    case 9: {
                        return ws != null && db != null && ws.getStatus() == Sample.STORED;
                    }
                    case 10: {
                        return db != null ? db.getSurface().getScheme().toString() : null;
                    }
                    case 11: {
                        return db != null ? db.getSample() : null;
                    }
                    case 12: {
                        return db != null ? db.getSurface().toString() : null;
                    }
                    case 13: {
                        return db != null ? db.getSurface().getTypeString() : null;
                    }
                    case 14: {
                        return db != null ? db.getInfName() : null;
                    }
                    case 15: {
                        return db != null ? SB.floatString((double)db.getSurface().getAge(), (int)2) : null;
                    }
                    case 16: {
                        return db != null ? db.getBnd() : null;
                    }
                    case 17: {
                        return db != null ? (db.isObserved() ? "Yes" : "No") : null;
                    }
                    case 18: {
                        return db != null ? db.getQualifier() : null;
                    }
                }
                return "";
            }
            catch (Exception e) {
                e.printStackTrace();
                return e.getMessage();
            }
        }

        public Class getColumnClass(int c) {
            switch (c) {
                case 1: {
                    return Sample.class;
                }
                case 0: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    return StringStatus.class;
                }
                case 9: {
                    return Boolean.class;
                }
                case 11: {
                    return Sample.class;
                }
            }
            return String.class;
        }
    }
}

