/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.util.ui.SBDialog;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Objects;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import model3.SBdb;
import model3.Taxon;
import org.jdesktop.layout.GroupLayout;
import util.exception.StackError;

public class DialogMatchTaxaEdit
extends SBDialog {
    private final List<Taxon> list;
    private final SBdb ws;
    private ButtonGroup buttonGroup1;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JCheckBox jCheckBoxClearCat;
    private JCheckBox jCheckBoxConvertCase;
    private JRadioButton jRadioButtonSpSp;
    private JRadioButton jRadioButtonSpSpp;
    private JSeparator jSeparator1;

    public DialogMatchTaxaEdit(JDialog parent, boolean modal, SBdb ws, List<Taxon> list) {
        super((Window)parent, modal);
        this.list = list;
        this.ws = ws;
        this.setTitle("Match Taxon : Edit List");
        this.getRootPane().setDefaultButton(this.jButtonOK);
        this.initComponents();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jRadioButtonSpSpp = new JRadioButton();
        this.jRadioButtonSpSp = new JRadioButton();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jCheckBoxConvertCase = new JCheckBox();
        this.jCheckBoxClearCat = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.buttonGroup1.add(this.jRadioButtonSpSpp);
        this.jRadioButtonSpSpp.setText("<html><strong>Use spp.</strong> Change all unmatched instances of \"Genus sp\" and \"Genus sp.\" to \"Genus spp.\"</html>");
        this.buttonGroup1.add(this.jRadioButtonSpSp);
        this.jRadioButtonSpSp.setText("<html><strong>Keep sp. & spp.</strong> Change all unmatched instances of \"Genus sp\" to \"Genus sp.\" & \"spp\" to \"spp.\"</html>");
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchTaxaEdit this$0;
            {
                DialogMatchTaxaEdit dialogMatchTaxaEdit = this$0;
                Objects.requireNonNull(dialogMatchTaxaEdit);
                this.this$0 = dialogMatchTaxaEdit;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchTaxaEdit this$0;
            {
                DialogMatchTaxaEdit dialogMatchTaxaEdit = this$0;
                Objects.requireNonNull(dialogMatchTaxaEdit);
                this.this$0 = dialogMatchTaxaEdit;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jCheckBoxConvertCase.setText("Convert all unmatched taxa to standard upper/lower case");
        this.jCheckBoxClearCat.setText("Clear categories from all unmatched taxa");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jCheckBoxClearCat, -1, -1, Short.MAX_VALUE).addContainerGap()).add((Component)this.jCheckBoxConvertCase, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jRadioButtonSpSpp, -1, 544, Short.MAX_VALUE).add(19, 19, 19)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jRadioButtonSpSp, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jSeparator1).addContainerGap())).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonCancel).addContainerGap()))));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jRadioButtonSpSpp, -2, -1, -2).addPreferredGap(1).add((Component)this.jRadioButtonSpSp, -2, -1, -2).addPreferredGap(1).add((Component)this.jCheckBoxConvertCase).addPreferredGap(1).add((Component)this.jCheckBoxClearCat).addPreferredGap(1).add((Component)this.jSeparator1, -2, 12, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonOK)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.buttonGroup1.getSelection() == null && !this.jCheckBoxClearCat.isSelected() && !this.jCheckBoxConvertCase.isSelected()) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No option selected", this.getTitle(), 2);
            return;
        }
        Boolean spSpp = null;
        if (this.jRadioButtonSpSpp.isSelected()) {
            spSpp = true;
        }
        if (this.jRadioButtonSpSp.isSelected()) {
            spSpp = false;
        }
        try {
            for (Taxon taxon : this.list) {
                if (taxon.getLink() != null) continue;
                this.ws.cleanTaxon(taxon.getSpecID(), this.jCheckBoxConvertCase.isSelected(), this.jCheckBoxClearCat.isSelected(), spSpp);
            }
            this.setOK();
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }
}

