/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.util.ui.table.TableUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import jsbugs.DialogMatchDict;
import jsbugs.FrameJsbugs;
import jsbugs.table.ArrowCellRenderer;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.Genus;
import model3.SBdb;
import model3.Taxon;
import model3.TxGroup;
import util.MatchData;
import util.SBException;
import util.SBPermissionException;
import util.SortEntry;
import util.status.SbugsStatusRenderer;
import util.status.StringStatus;

public class DialogMatchTxGroup
extends DialogMatchDict {
    private final TxGroup wsGroup;
    private final SBdb db;
    private final TableModelMatchGroup model = new TableModelMatchGroup();
    private final int projID;
    private LinkedList<MatchGroupMember> wsList;
    private static final String NOGROUPSTRING = "<Press OK to store new group>";

    public DialogMatchTxGroup(JDialog parent, boolean modal, TxGroup wsGroup, SBdb db, int projID, boolean inWizard) throws SQLException, SBException {
        super(parent, modal, inWizard);
        if (wsGroup == null) {
            throw new IllegalArgumentException("Null workspace group is not allowed");
        }
        this.wsGroup = wsGroup;
        this.db = db;
        this.projID = projID;
        this.init();
    }

    public DialogMatchTxGroup(JFrame parent, boolean modal, TxGroup wsGroup, SBdb db, int projID, boolean inWizard) throws SQLException, SBException {
        super(parent, modal, inWizard);
        this.wsGroup = wsGroup;
        if (wsGroup == null) {
            throw new IllegalArgumentException("Null workspace group is not allowed");
        }
        this.db = db;
        this.projID = projID;
        this.init();
    }

    private void init() throws SQLException, SBException {
        super.init(this.model, "Match Group : " + this.wsGroup.getName(), this.wsGroup.getName());
        this.dbModel.addElement("<Select>");
        LinkedList<TxGroup> txGroups = new LinkedList<TxGroup>(this.db.getTxGroups(this.projID, true));
        Collections.sort(txGroups, new Comparator<TxGroup>(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public int compare(TxGroup o1, TxGroup o2) {
                if (o1.getProjID() > 0 && o2.getProjID() == 0) {
                    return -1;
                }
                if (o2.getProjID() > 0 && o1.getProjID() == 0) {
                    return 1;
                }
                return o1.compareTo(o2);
            }
        });
        for (TxGroup group : txGroups) {
            this.dbModel.addElement(group);
        }
        if (this.wsGroup.getLink() != null) {
            this.dbModel.setSelectedItem(this.wsGroup.getLink());
        } else {
            TxGroup match = this.db.getTxGroup(this.wsGroup.getName(), this.projID);
            if (match != null) {
                this.wsGroup.setLink(match);
                this.dbModel.setSelectedItem(match);
            }
        }
        JButton jButtonExclude = new JButton("Exclude");
        jButtonExclude.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchTxGroup this$0;
            {
                DialogMatchTxGroup dialogMatchTxGroup = this$0;
                Objects.requireNonNull(dialogMatchTxGroup);
                this.this$0 = dialogMatchTxGroup;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.jButtonExcludeActionPerformed(e);
            }
        });
        this.addSidebarButton(jButtonExclude);
        JButton jButtonSave = new JButton("Save");
        jButtonSave.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchTxGroup this$0;
            {
                DialogMatchTxGroup dialogMatchTxGroup = this$0;
                Objects.requireNonNull(dialogMatchTxGroup);
                this.this$0 = dialogMatchTxGroup;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.saveTaxa();
            }
        });
        this.addSidebarButton(jButtonSave);
        this.model.setUpTable(this.jTableMatch);
        if (this.wsGroup != null) {
            LinkedList<Taxon> tempList = new LinkedList<Taxon>(this.wsGroup.getDatabase().getTxGroupTaxa(this.wsGroup, false));
            this.wsList = new LinkedList();
            for (Taxon t : tempList) {
                if (t.getLink() == null) {
                    throw new SBException("Unmatched taxon found in group match");
                }
                this.wsList.add(new MatchGroupTaxon(t));
            }
            ArrayList<Genus> gList = new ArrayList<Genus>(this.wsGroup.getDatabase().getTxGroupGenera(this.wsGroup));
            for (Genus genus : gList) {
                if (genus.getLink() == null) {
                    throw new SBException("Unmatched genus found in group match");
                }
                this.wsList.add(new MatchGroupGenus(genus));
            }
        }
        this.model.data.init(this.wsList, this.getDBList());
        this.jTableMatch.setDefaultRenderer(String.class, new DefaultTableCellRenderer(this){
            final /* synthetic */ DialogMatchTxGroup this$0;
            {
                DialogMatchTxGroup dialogMatchTxGroup = this$0;
                Objects.requireNonNull(dialogMatchTxGroup);
                this.this$0 = dialogMatchTxGroup;
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (column == 4 && this.this$0.model.data.get(row).getDb() != null && this.this$0.model.data.get(row).getDb() instanceof MatchGroupGenus) {
                    c.setFont(table.getFont().deriveFont(2));
                } else {
                    c.setFont(table.getFont());
                }
                return c;
            }
        });
        this.jTableMatch.getTableHeader().setReorderingAllowed(false);
    }

    private boolean checkDuplicates() {
        HashSet<Taxon> dbTaxa = new HashSet<Taxon>();
        HashSet<Taxon> duplicates = new HashSet<Taxon>();
        try {
            for (Taxon ws : this.wsGroup.getDatabase().getTxGroupTaxa(this.wsGroup, false)) {
                if (dbTaxa.add(ws.getLink())) continue;
                duplicates.add(ws.getLink());
            }
        }
        catch (SQLException sql) {
            SbugsExceptionHandler.showStackError(sql);
            return false;
        }
        if (!duplicates.isEmpty()) {
            Object strg = "You must exclude one of the pairs of the following duplicate taxa, before proceeding: ";
            for (Taxon taxon : duplicates) {
                strg = (String)strg + "\n" + taxon.toString();
            }
            JOptionPane.showMessageDialog((Component)((Object)this), strg, this.getTitle(), 1);
            return false;
        }
        return true;
    }

    @Override
    void add() {
        if (!this.checkDuplicates()) {
            return;
        }
        try {
            if (this.db.getTxGroup(this.wsGroup.getName(), this.projID) != null) {
                String newName = JOptionPane.showInputDialog((Component)((Object)this), "Database already contains a group called " + this.wsGroup.getName() + ".\nEnter name for new group:", "New group", 2);
                if (newName == null || newName.isEmpty()) {
                    return;
                }
                this.wsGroup.setName(newName);
                this.updateDonorName(newName);
            }
            TxGroup newGroup = this.db.copyToDatabase(this.wsGroup.getDatabase(), this.wsGroup, this.projID);
            this.db.commit();
            JOptionPane.showMessageDialog((Component)((Object)this), "Group: " + this.wsGroup.getName() + " added", this.getTitle(), 1);
            this.dbModel.addElement(newGroup);
            this.dbModel.setSelectedItem(newGroup);
        }
        catch (SBPermissionException pe) {
            JOptionPane.showMessageDialog((Component)((Object)this), pe.getMessage(), this.getTitle(), 2);
        }
        catch (SQLException | SBException sql) {
            SbugsExceptionHandler.showStackError(sql);
        }
    }

    @Override
    void comboModelActionPerformed() {
        TxGroup selected;
        TxGroup txGroup = selected = this.dbModel.getSelectedItem() instanceof TxGroup ? (TxGroup)this.dbModel.getSelectedItem() : null;
        if (this.wsGroup.getLink() != selected) {
            this.wsGroup.setLink(selected);
        }
        try {
            this.model.data.init(this.wsList, this.getDBList());
            this.model.fireTableDataChanged();
        }
        catch (SQLException | SBException sql) {
            FrameJsbugs.showStackError("SQL Error", (Exception)sql, this.db);
        }
    }

    List<MatchGroupMember> getDBList() throws SQLException, SBException {
        LinkedList<Object> dbGenList;
        LinkedList<Object> dbList;
        if (this.wsGroup.getLink() != null) {
            dbList = new LinkedList<Taxon>(this.db.getTxGroupTaxa(this.wsGroup.getLink(), false));
            dbGenList = new LinkedList<Genus>(this.db.getTxGroupGenera(this.wsGroup.getLink()));
        } else {
            dbList = new LinkedList();
            dbGenList = new LinkedList();
        }
        LinkedList<MatchGroupMember> retList = new LinkedList<MatchGroupMember>();
        for (Taxon taxon : dbList) {
            retList.add(new MatchGroupTaxon(taxon));
        }
        for (Genus genus : dbGenList) {
            retList.add(new MatchGroupGenus(genus));
        }
        return retList;
    }

    private void jButtonExcludeActionPerformed(ActionEvent evt) {
        int[] selected = this.jTableMatch.getSelectedRows();
        LinkedList<MatchGroupMember> toRemove = new LinkedList<MatchGroupMember>();
        for (int i : selected) {
            MatchGroupMember taxon = (MatchGroupMember)this.model.data.get(i).getWs();
            if (taxon == null) continue;
            toRemove.add(taxon);
        }
        LinkedList<Taxon> wsRemovals = new LinkedList<Taxon>();
        LinkedList<Genus> wsGenRemovals = new LinkedList<Genus>();
        for (MatchGroupMember m : toRemove) {
            this.wsList.remove(m);
            if (m.getObject(false) instanceof Taxon) {
                wsRemovals.add((Taxon)m.getObject(false));
                continue;
            }
            if (!(m.getObject(false) instanceof Genus)) continue;
            wsGenRemovals.add((Genus)m.getObject(false));
        }
        try {
            this.wsGroup.deleteTaxa(wsRemovals);
            this.wsGroup.deleteGenera(wsGenRemovals);
            this.model.data.init(this.wsList, this.getDBList());
            this.model.fireTableDataChanged();
        }
        catch (SQLException | SBException | SBPermissionException e) {
            SbugsExceptionHandler.showStackError(e, (Component)((Object)this));
        }
    }

    @Override
    void jTableMouseDoubleClick() {
    }

    @Override
    String getHelpPage() {
        return "dialogmatchgroup.html";
    }

    private void saveTaxa() {
        if (this.wsGroup.getLink() == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "You must link the group first. Use 'Add' to create new database group.", this.getTitle(), 2);
            return;
        }
        if (!this.checkDuplicates()) {
            return;
        }
        Boolean deleteUnlinkedDB = null;
        LinkedList<Taxon> groupTaxa = new LinkedList<Taxon>();
        LinkedList<Taxon> dbExtras = new LinkedList<Taxon>();
        LinkedList<Genus> groupGenera = new LinkedList<Genus>();
        LinkedList<Genus> dbExtrasGen = new LinkedList<Genus>();
        for (int i = 0; i < this.model.data.size(); ++i) {
            SortEntry o;
            MatchData.MatchPair pair = this.model.data.get(i);
            if (pair.getWs() != null) {
                o = ((MatchGroupMember)pair.getWs()).getObject(true);
                if (o instanceof Taxon) {
                    groupTaxa.add((Taxon)o);
                    continue;
                }
                if (!(o instanceof Genus)) continue;
                groupGenera.add((Genus)o);
                continue;
            }
            if (deleteUnlinkedDB == null) {
                int opt = JOptionPane.showConfirmDialog((Component)((Object)this), "Do you want to delete group membership of taxa/genera that are NOT in the workspace group?", this.getTitle(), 0, 3);
                deleteUnlinkedDB = opt == 0;
            }
            if ((o = ((MatchGroupMember)pair.getDb()).getObject(false)) instanceof Taxon) {
                dbExtras.add((Taxon)o);
                continue;
            }
            if (!(o instanceof Genus)) continue;
            dbExtrasGen.add((Genus)o);
        }
        try {
            Statement dbStmt = this.db.getDatabase().createStatement();
            if (!dbExtras.isEmpty() || !dbExtrasGen.isEmpty()) {
                if (deleteUnlinkedDB.booleanValue()) {
                    this.wsGroup.getLink().deleteTaxa(dbExtras);
                    this.wsGroup.getLink().deleteGenera(dbExtrasGen);
                } else {
                    LinkedList<Taxon> newWsTaxa = new LinkedList<Taxon>();
                    for (Taxon taxon : dbExtras) {
                        newWsTaxa.add(this.wsGroup.getDatabase().fillTaxon(this.db, taxon));
                    }
                    this.wsGroup.addTaxa(newWsTaxa);
                }
            }
            dbStmt.close();
            this.wsGroup.getLink().addTaxa(groupTaxa);
            this.wsGroup.getLink().addGenera(groupGenera);
            this.db.commit();
            this.wsGroup.updateStatus();
            this.model.data.init(this.wsList, this.getDBList());
            this.model.fireTableDataChanged();
            JOptionPane.showMessageDialog((Component)((Object)this), "Group: " + this.wsGroup.getName() + " updated", this.getTitle(), 1);
        }
        catch (SBPermissionException pe) {
            JOptionPane.showMessageDialog((Component)((Object)this), pe.getMessage(), this.getTitle(), 2);
        }
        catch (SQLException | SBException sql) {
            SbugsExceptionHandler.showStackError(sql, (Component)((Object)this));
        }
    }

    @Override
    void OK() {
        if (this.inWizard && this.wsGroup.getLink() == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "You must match this group", this.getTitle(), 2);
            return;
        }
        try {
            this.wsGroup.updateStatus();
        }
        catch (SQLException sql) {
            SbugsExceptionHandler.showStackError("Error updating group status", sql, (Component)((Object)this));
        }
        this.setOK();
    }

    private static class TableModelMatchGroup
    extends AbstractTableModel {
        static final int COL_WSCAT = 0;
        static final int COL_WSTAXON = 1;
        static final int COL_ARROW = 2;
        static final int COL_DBCAT = 3;
        static final int COL_DBTAXON = 4;
        static final String[] colTitles = new String[]{"Cat.", "Taxon/Genus", " ", "Cat.", "Taxon/Genus"};
        static final int[] colWidths = new int[]{20, 130, 20, 20, 130};
        MatchData<MatchGroupMember> data = new MatchData();
        Boolean linked = true;
        Boolean unlinked = false;

        private TableModelMatchGroup() {
        }

        @Override
        public int getColumnCount() {
            return colTitles.length;
        }

        @Override
        public int getRowCount() {
            return this.data != null ? this.data.size() : 0;
        }

        @Override
        public Object getValueAt(int row, int col) {
            MatchData.MatchPair pair = this.data.get(row);
            MatchGroupMember ws = (MatchGroupMember)pair.getWs();
            MatchGroupMember db = (MatchGroupMember)pair.getDb();
            switch (col) {
                case 0: {
                    if (ws == null) {
                        return null;
                    }
                    return new StringStatus(ws.getCat(true), pair.getDb() != null ? Taxon.STORED : Taxon.NOTSTORED);
                }
                case 1: {
                    if (ws == null) {
                        return null;
                    }
                    return new ObjectStringStatus(ws.getString(true), pair.getDb() != null ? Taxon.STORED : Taxon.NOTSTORED, ws.getObject(false));
                }
                case 2: {
                    return ws != null && db != null ? this.linked : this.unlinked;
                }
                case 3: {
                    if (db != null) {
                        return db.getCat(false);
                    }
                    return null;
                }
                case 4: {
                    if (db == null) {
                        return null;
                    }
                    return db.getString(false);
                }
            }
            return "";
        }

        public Class getColumnClass(int c) {
            switch (c) {
                case 3: {
                    return String.class;
                }
                case 0: 
                case 1: 
                case 4: {
                    return StringStatus.class;
                }
                case 2: {
                    return Boolean.class;
                }
            }
            return Object.class;
        }

        void setUpTable(JTable table) {
            TableUtils.setTableHeaderBold((JTable)table);
            TableColumnModel columnModel = table.getTableHeader().getColumnModel();
            for (int i = 0; i < columnModel.getColumnCount(); ++i) {
                columnModel.getColumn(i).setHeaderValue(colTitles[i]);
                columnModel.getColumn(i).setPreferredWidth(colWidths[i]);
            }
            columnModel.getColumn(2).setMaxWidth(colWidths[2]);
            table.setDefaultRenderer(StringStatus.class, (TableCellRenderer)new SbugsStatusRenderer(this){
                final /* synthetic */ TableModelMatchGroup this$0;
                {
                    TableModelMatchGroup tableModelMatchGroup = this$0;
                    Objects.requireNonNull(tableModelMatchGroup);
                    this.this$0 = tableModelMatchGroup;
                }

                public Component getTableCellRendererComponent(JTable table, Object dbItem, boolean isSelected, boolean hasFocus, int row, int column) {
                    if (dbItem instanceof ObjectStringStatus && ((ObjectStringStatus)((Object)dbItem)).obj instanceof Genus) {
                        this.setFont(table.getFont().deriveFont(2));
                    } else {
                        this.setFont(table.getFont());
                    }
                    return super.getTableCellRendererComponent(table, dbItem, isSelected, hasFocus, row, column);
                }
            });
            table.setDefaultRenderer(Boolean.class, new ArrowCellRenderer());
        }
    }

    private static class MatchGroupTaxon
    extends MatchGroupMember {
        final Taxon taxon;

        public MatchGroupTaxon(Taxon taxon) {
            this.taxon = taxon;
        }

        public String getSortEntry() {
            if (this.taxon == null) {
                System.out.println("Taxon null in MatchGroupWsTaxon");
                return null;
            }
            if (this.taxon.getLink() == null) {
                return this.taxon.getSortEntry();
            }
            return this.taxon.getLink().getSortEntry();
        }

        public boolean isFuncEquivalent(SortEntry e) {
            if (this.taxon == null) {
                System.out.println("Taxon null in MatchGroupWsTaxon");
                return false;
            }
            if (this.taxon.getLink() == null) {
                return this.taxon.isFuncEquivalent(e);
            }
            return this.taxon.getLink().isFuncEquivalent(e);
        }

        @Override
        SortEntry getObject(boolean linked) {
            return linked ? this.taxon.getLink() : this.taxon;
        }

        @Override
        String getCat(boolean link) {
            return link ? (this.taxon.getLink() != null ? this.taxon.getLink().getCatMnem() : "") : this.taxon.getCatMnem();
        }

        @Override
        String getString(boolean link) {
            return link ? (this.taxon.getLink() != null ? this.taxon.getLink().toString(true, false, false) : "") : this.taxon.toString(true, false, false);
        }
    }

    private static class MatchGroupGenus
    extends MatchGroupMember {
        final Genus genus;

        MatchGroupGenus(Genus genus) {
            this.genus = genus;
        }

        public String getSortEntry() {
            if (this.genus.getLink() != null) {
                return this.genus.getLink().getSortEntry();
            }
            return this.genus.getSortEntry();
        }

        public boolean isFuncEquivalent(SortEntry e) throws SBException, SQLException {
            if (this.genus.getLink() != null) {
                return this.genus.getLink().isFuncEquivalent(e);
            }
            return this.genus.isFuncEquivalent(e);
        }

        @Override
        SortEntry getObject(boolean linked) {
            return linked ? this.genus.getLink() : this.genus;
        }

        @Override
        String getCat(boolean link) {
            return link ? (this.genus.getLink() != null ? this.genus.getLink().getCategoryMnemonic() : "") : this.genus.getCategoryMnemonic();
        }

        @Override
        String getString(boolean link) {
            return link ? (this.genus.getLink() != null ? this.genus.getLink().toString(false) : "") : this.genus.toString(false);
        }
    }

    private static abstract class MatchGroupMember
    implements SortEntry {
        private MatchGroupMember() {
        }

        abstract SortEntry getObject(boolean var1);

        abstract String getCat(boolean var1);

        abstract String getString(boolean var1);
    }

    private static class ObjectStringStatus
    extends StringStatus {
        final Object obj;

        public ObjectStringStatus(String string, Color colour, Object obj) {
            super(string, colour);
            this.obj = obj;
        }
    }
}

