/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.table.AbstractTableModel;
import jsbchart.core.ChartManager;
import jsbugs.FrameJsbugs;
import model3.SBEvent;
import model3.SBRestrictable;
import model3.SBdb;
import util.SB;
import util.SBException;
import util.SBPermissionException;
import util.exception.StackError;

public class DialogMergeEvents
extends JDialog {
    private static final String[] columnTitles = new String[]{"ID", "Prefix", "Name", "Well Events", "Composite Events"};
    private static final int[] columnWidths = new int[]{25, 50, 150, 50, 50};
    private final MergeEventsTableModel model = new MergeEventsTableModel(this);
    private final LinkedList<EventCount> events = new LinkedList();
    SBEvent target;
    boolean isOK = false;
    SBdb db;
    ChartManager chartManager = null;
    private JButton jButtonCancel;
    private JButton jButtonHelp;
    private JButton jButtonMerge;
    private JButton jButtonSetTarget;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JTable jTableMerge;
    private JTextField jTextFieldReplace;

    public DialogMergeEvents(Frame parent, boolean modal, List<SBEvent> events, SBdb db, ChartManager chartManager) {
        super(parent, modal);
        this.db = db;
        this.chartManager = chartManager;
        this.initComponents();
        this.init(events);
    }

    private void init(List<SBEvent> events) {
        this.setTitle("Merge Events");
        this.getRootPane().setDefaultButton(this.jButtonMerge);
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            this.jTableMerge.getColumnModel().getColumn(i).setHeaderValue(columnTitles[i]);
            this.jTableMerge.getColumnModel().getColumn(i).setPreferredWidth(columnWidths[i]);
        }
        SB.setTableHeaderBold((JTable)this.jTableMerge);
        try {
            for (SBEvent event : events) {
                this.events.add(new EventCount(event, event.getNoccs(true), event.getNcmpStdOccs()));
            }
        }
        catch (SQLException sql) {
            sql.printStackTrace();
        }
        this.model.fireTableDataChanged();
        if (!SBRestrictable.canWrite(this.db)) {
            this.jButtonMerge.setEnabled(false);
            this.jButtonMerge.setToolTipText(SBRestrictable.getDeniedReason(false));
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jTextFieldReplace = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.jTableMerge = new JTable();
        this.jButtonCancel = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonMerge = new JButton();
        this.jButtonSetTarget = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(360, 175));
        this.jLabel1.setText("Replace with:");
        this.jTextFieldReplace.setBackground(new Color(255, 255, 204));
        this.jTableMerge.setModel(this.model);
        this.jScrollPane1.setViewportView(this.jTableMerge);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMergeEvents this$0;
            {
                DialogMergeEvents dialogMergeEvents = this$0;
                Objects.requireNonNull(dialogMergeEvents);
                this.this$0 = dialogMergeEvents;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonMerge.setText("Merge");
        this.jButtonMerge.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMergeEvents this$0;
            {
                DialogMergeEvents dialogMergeEvents = this$0;
                Objects.requireNonNull(dialogMergeEvents);
                this.this$0 = dialogMergeEvents;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonMergeActionPerformed(evt);
            }
        });
        this.jButtonSetTarget.setText("Set Keeper");
        this.jButtonSetTarget.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMergeEvents this$0;
            {
                DialogMergeEvents dialogMergeEvents = this$0;
                Objects.requireNonNull(dialogMergeEvents);
                this.this$0 = dialogMergeEvents;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSetTargetActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 444, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldReplace, -1, 375, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jButtonSetTarget).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 151, Short.MAX_VALUE).addComponent(this.jButtonMerge).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel))).addContainerGap()));
        layout.linkSize(0, this.jButtonCancel, this.jButtonHelp, this.jButtonMerge);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jTextFieldReplace, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jScrollPane1, -1, 94, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonHelp).addComponent(this.jButtonMerge).addComponent(this.jButtonSetTarget)).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonSetTargetActionPerformed(ActionEvent evt) {
        if (this.jTableMerge.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "Select one row only", this.getTitle(), 1);
            return;
        }
        this.target = this.events.get((int)this.jTableMerge.getSelectedRow()).sbEvent;
        this.jTextFieldReplace.setText(this.target.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonMergeActionPerformed(ActionEvent evt) {
        if (this.target == null) {
            JOptionPane.showMessageDialog(this, "Select a target event to which the displayed event(s) will be merged.", this.getTitle(), 1);
            return;
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            for (EventCount ec : this.events) {
                if (ec.sbEvent == this.target) continue;
                this.db.mergeEvents(ec.sbEvent, this.target);
                if (this.chartManager == null) continue;
                this.chartManager.mergeEventCorrelationLines(ec.sbEvent, this.target);
            }
            this.db.commit();
            JOptionPane.showMessageDialog(this, "Merge complete", this.getTitle(), 1);
            this.db.notifyObservers(this.target);
            this.isOK = true;
            this.dispose();
        }
        catch (SBPermissionException pe) {
            JOptionPane.showMessageDialog(this, pe.getMessage(), this.getTitle(), 2);
        }
        catch (SQLException | SBException sql) {
            this.db.doRollback();
            FrameJsbugs.showStackError("SQL Error", (Exception)sql, this.db);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    class MergeEventsTableModel
    extends AbstractTableModel {
        final /* synthetic */ DialogMergeEvents this$0;

        MergeEventsTableModel(DialogMergeEvents this$0) {
            DialogMergeEvents dialogMergeEvents = this$0;
            Objects.requireNonNull(dialogMergeEvents);
            this.this$0 = dialogMergeEvents;
        }

        @Override
        public int getColumnCount() {
            return columnTitles.length;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (this.this$0.events == null) {
                return "";
            }
            EventCount event = this.this$0.events.get(row);
            switch (col) {
                case 0: {
                    return event.sbEvent.getEvID();
                }
                case 1: {
                    return event.sbEvent.getCombinedPrefix();
                }
                case 2: {
                    return event.sbEvent.getName();
                }
                case 3: {
                    return event.nWellOccs;
                }
                case 4: {
                    return event.nStdOccs;
                }
            }
            return "";
        }

        @Override
        public int getRowCount() {
            if (this.this$0.events == null) {
                return 0;
            }
            return this.this$0.events.size();
        }

        public Class getColumnClass(int col) {
            switch (col) {
                default: 
            }
            return String.class;
        }
    }

    private static class EventCount {
        SBEvent sbEvent;
        int nWellOccs;
        int nStdOccs;

        EventCount(SBEvent sbEvent, int nWellOccs, int nStdOccs) {
            this.sbEvent = sbEvent;
            this.nWellOccs = nWellOccs;
            this.nStdOccs = nStdOccs;
        }
    }
}

