/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.util.ui.HelpUtils;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.table.AbstractTableModel;
import jsbugs.DialogSelectVersion;
import jsbugs.FrameJsbugs;
import model3.Biocom;
import model3.IGDInterval;
import model3.IGDIntervalEnv;
import model3.IGDIntervalZone;
import model3.Intcom;
import model3.LOC;
import model3.SBdb;
import model3.SQPick;
import model3.Well;
import model3.WellEvent;
import model3.WellInterp;
import util.DepthUnits;
import util.DepthUtils;
import util.InvalidFieldException;
import util.SB;
import util.SBException;
import util.exception.StackError;

public class DialogMoveInterp
extends JDialog {
    private static final String[] titles = new String[]{"Data Type", "Source Records", "Target Records", "Select"};
    private static final int COL_DATATYPE = 0;
    private static final int COL_SOURCEROW = 1;
    private static final int COL_TARGETROWS = 2;
    private static final int COL_SELECT = 3;
    private static final int[] widths = new int[]{50, 35, 35, 20};
    private static final int N_DATA_TYPES = 9;
    MoveInterp[] dataTypes = new MoveInterp[9];
    char units;
    boolean dataSet = false;
    TableModelMoveInterp model = new TableModelMoveInterp(this);
    SBdb db;
    Well well;
    WellInterp sourceInterp;
    WellInterp targetInterp;
    boolean isOK = false;
    private JButton jButtonClose;
    private JButton jButtonHelp;
    private JButton jButtonMove;
    private JButton jButtonVersionSelect;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private JTable jTableMoveInterp;
    private JTextField jTextFieldSource;
    private JTextField jTextFieldTarget;

    public DialogMoveInterp(Frame parent, boolean modal, SBdb db, Well well, WellInterp sourceInterp, char units) {
        super(parent, modal);
        this.db = db;
        this.well = well;
        this.sourceInterp = sourceInterp;
        this.units = units;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.jTextFieldSource.setText(this.sourceInterp.toString());
        this.model.setupTable(this.jTableMoveInterp);
        this.setTitle("Move Interpreted Data");
    }

    private void setTarget() {
        this.jTextFieldTarget.setText("");
        if (this.targetInterp == null) {
            return;
        }
        this.jTextFieldTarget.setText(this.targetInterp.toString());
        this.model.setData(this.db, this.sourceInterp, this.targetInterp);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jTextFieldSource = new JTextField();
        this.jLabel2 = new JLabel();
        this.jTextFieldTarget = new JTextField();
        this.jButtonVersionSelect = new JButton();
        this.jButtonClose = new JButton();
        this.jButtonMove = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTableMoveInterp = new JTable();
        this.jButtonHelp = new JButton();
        this.setDefaultCloseOperation(2);
        this.jLabel1.setText("Move all interpreted data (publish) from:");
        this.jTextFieldSource.setEditable(false);
        this.jLabel2.setText("To version:");
        this.jTextFieldTarget.setEditable(false);
        this.jButtonVersionSelect.setText("...");
        this.jButtonVersionSelect.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMoveInterp this$0;
            {
                DialogMoveInterp dialogMoveInterp = this$0;
                Objects.requireNonNull(dialogMoveInterp);
                this.this$0 = dialogMoveInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonVersionSelectActionPerformed(evt);
            }
        });
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMoveInterp this$0;
            {
                DialogMoveInterp dialogMoveInterp = this$0;
                Objects.requireNonNull(dialogMoveInterp);
                this.this$0 = dialogMoveInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCloseActionPerformed(evt);
            }
        });
        this.jButtonMove.setText("Move");
        this.jButtonMove.setToolTipText("Move all data from selected types");
        this.jButtonMove.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMoveInterp this$0;
            {
                DialogMoveInterp dialogMoveInterp = this$0;
                Objects.requireNonNull(dialogMoveInterp);
                this.this$0 = dialogMoveInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonMoveActionPerformed(evt);
            }
        });
        this.jTableMoveInterp.setModel(this.model);
        this.jScrollPane1.setViewportView(this.jTableMoveInterp);
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMoveInterp this$0;
            {
                DialogMoveInterp dialogMoveInterp = this$0;
                Objects.requireNonNull(dialogMoveInterp);
                this.this$0 = dialogMoveInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jTextFieldSource, -1, 175, Short.MAX_VALUE).addComponent(this.jTextFieldTarget)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonVersionSelect).addContainerGap(-1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 467, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButtonMove, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonClose, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonHelp, -1, -1, Short.MAX_VALUE)).addGap(24, 24, 24)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jTextFieldSource, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jTextFieldTarget, -2, -1, -2).addComponent(this.jButtonVersionSelect)).addGap(16, 16, 16).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jButtonMove).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonClose)).addComponent(this.jScrollPane1, -1, 320, Short.MAX_VALUE)).addContainerGap()));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonMoveActionPerformed(ActionEvent evt) {
        try {
            for (MoveInterp d : this.dataTypes) {
                if (!d.select) continue;
                switch (d.igdType) {
                    case 2: 
                    case 3: 
                    case 4: {
                        List<Object> listSource = this.sourceInterp.getIGDList(d.igdType);
                        LinkedList<IGDIntervalEnv> toMove = new LinkedList<IGDIntervalEnv>(listSource);
                        for (IGDIntervalZone iGDIntervalZone : toMove) {
                            this.sourceInterp.moveZone(this.well, iGDIntervalZone, this.targetInterp);
                        }
                        break;
                    }
                    case 5: {
                        List<Object> listSource = this.sourceInterp.getEnvs();
                        LinkedList<IGDIntervalEnv> toMove = new LinkedList<IGDIntervalEnv>(listSource);
                        for (IGDIntervalEnv iGDIntervalEnv : toMove) {
                            this.sourceInterp.moveEnv(this.well, iGDIntervalEnv, this.targetInterp);
                        }
                        break;
                    }
                    case 22: {
                        List<Object> listSource = this.sourceInterp.getIntcoms();
                        LinkedList<IGDIntervalEnv> toMove = new LinkedList<IGDIntervalEnv>(listSource);
                        for (Intcom intcom : toMove) {
                            this.sourceInterp.copyIntcom(this.well, intcom, this.targetInterp, true);
                        }
                        break;
                    }
                    case 21: {
                        List<Object> listSource = this.sourceInterp.getSQPicks();
                        LinkedList<IGDIntervalEnv> toMove = new LinkedList<IGDIntervalEnv>(listSource);
                        for (SQPick sQPick : toMove) {
                            this.sourceInterp.copy(sQPick, this.well, this.targetInterp);
                        }
                        break;
                    }
                    case 19: {
                        List<Object> listSource = this.sourceInterp.getComments();
                        LinkedList<IGDIntervalEnv> toMove = new LinkedList<IGDIntervalEnv>(listSource);
                        for (Biocom biocom : toMove) {
                            this.sourceInterp.moveBiocom(this.well, biocom, this.targetInterp);
                        }
                        break;
                    }
                    case 20: {
                        List<Object> listSource = this.sourceInterp.getEvents();
                        LinkedList<IGDIntervalEnv> toMove = new LinkedList<IGDIntervalEnv>(listSource);
                        for (WellEvent wellEvent : toMove) {
                            this.sourceInterp.copyEvent(this.well, wellEvent, this.targetInterp, true);
                        }
                        break;
                    }
                    case 23: {
                        this.sourceInterp.copyLOC(this.well.getWellID(), this.targetInterp, true);
                    }
                }
                this.db.commit();
            }
            JOptionPane.showMessageDialog(this, "All selected data moved", "Move Version", 1);
            this.isOK = true;
            this.targetInterp.notifyObservers();
            this.dispose();
        }
        catch (SQLException | InvalidFieldException | SBException e) {
            StackError.showStackError((Exception)e);
            this.db.doRollback();
        }
        catch (RuntimeException e) {
            StackError.showStackError((Exception)e);
            this.db.doRollback();
        }
    }

    private void jButtonVersionSelectActionPerformed(ActionEvent evt) {
        List<Well> list = Arrays.asList(this.well);
        try {
            DialogSelectVersion dialog = new DialogSelectVersion((Dialog)this, true, this.db, list);
            dialog.setLocation(this.jButtonVersionSelect.getLocationOnScreen());
            dialog.setVisible(true);
            if (dialog.selection != null) {
                if (dialog.selection.get(0) == this.sourceInterp.getHeader()) {
                    JOptionPane.showMessageDialog(this, "Source and target version cannot be the same", "Move Interp", 2);
                    return;
                }
                this.targetInterp = this.well.getAddInterp(dialog.selection.get(0));
                this.setTarget();
            }
        }
        catch (SQLException sqlex) {
            FrameJsbugs.showStackError(null, sqlex, this.db);
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        HelpUtils.openHelp((String)"dialogmoveinterp.html");
    }

    private class MoveInterp {
        int igdType;
        int sourceRows;
        double sourceFrom;
        double sourceTo;
        int targetRows;
        double targetFrom;
        double targetTo;
        boolean select;

        MoveInterp(DialogMoveInterp dialogMoveInterp, int i) {
            Objects.requireNonNull(dialogMoveInterp);
            this.sourceRows = 0;
            this.targetRows = 0;
            this.igdType = i;
        }

        boolean isSelectable() {
            if (this.igdType == 23) {
                if (this.sourceRows == 0) {
                    return false;
                }
                return this.targetRows == 0;
            }
            boolean selectable = this.sourceRows == 0 ? false : (this.targetRows == 0 ? true : this.sourceTo < this.targetFrom || this.sourceFrom > this.targetTo);
            return selectable;
        }
    }

    private class TableModelMoveInterp
    extends AbstractTableModel {
        final /* synthetic */ DialogMoveInterp this$0;

        private TableModelMoveInterp(DialogMoveInterp dialogMoveInterp) {
            DialogMoveInterp dialogMoveInterp2 = dialogMoveInterp;
            Objects.requireNonNull(dialogMoveInterp2);
            this.this$0 = dialogMoveInterp2;
        }

        @Override
        public int getColumnCount() {
            return titles.length;
        }

        @Override
        public int getRowCount() {
            if (!this.this$0.dataSet) {
                return 0;
            }
            return this.this$0.dataTypes.length;
        }

        @Override
        public Object getValueAt(int row, int col) {
            MoveInterp dataType = this.this$0.dataTypes[row];
            switch (col) {
                case 0: {
                    return IGDInterval.getIGDName(dataType.igdType);
                }
                case 1: {
                    if (dataType.sourceRows > 0) {
                        return dataType.sourceRows + ", from " + DepthUtils.convFromM((double)dataType.sourceFrom, (char)this.this$0.units) + " to " + DepthUtils.convFromM((double)dataType.sourceTo, (char)this.this$0.units) + DepthUnits.getUnits((char)this.this$0.units).getAbr();
                    }
                    return "None";
                }
                case 2: {
                    if (dataType.targetRows > 0) {
                        return dataType.targetRows + ", from " + DepthUtils.convFromM((double)dataType.targetFrom, (char)this.this$0.units) + " to " + DepthUtils.convFromM((double)dataType.targetTo, (char)this.this$0.units) + DepthUnits.getUnits((char)this.this$0.units).getAbr();
                    }
                    return "None";
                }
                case 3: {
                    return dataType.select;
                }
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int r, int c) {
            MoveInterp dataType = this.this$0.dataTypes[r];
            if (dataType.sourceRows == 0 || dataType.targetRows > 0) {
                return false;
            }
            return c == 3;
        }

        @Override
        public void setValueAt(Object obj, int row, int col) {
            MoveInterp dataType = this.this$0.dataTypes[row];
            switch (col) {
                default: {
                    break;
                }
                case 3: {
                    if (!dataType.isSelectable()) break;
                    dataType.select = (Boolean)obj;
                }
            }
        }

        public Class getColumnClass(int c) {
            switch (c) {
                case 0: 
                case 1: 
                case 2: {
                    return String.class;
                }
                case 3: {
                    return Boolean.class;
                }
            }
            return Object.class;
        }

        void setupTable(JTable table) {
            SB.setTableHeaderBold((JTable)table);
            for (int i = 0; i < this.getColumnCount(); ++i) {
                table.getColumnModel().getColumn(i).setHeaderValue(titles[i]);
                table.getColumnModel().getColumn(i).setPreferredWidth(widths[i]);
            }
            int n = 0;
            this.this$0.dataTypes[n++] = new MoveInterp(this.this$0, 2);
            this.this$0.dataTypes[n++] = new MoveInterp(this.this$0, 3);
            this.this$0.dataTypes[n++] = new MoveInterp(this.this$0, 4);
            this.this$0.dataTypes[n++] = new MoveInterp(this.this$0, 5);
            this.this$0.dataTypes[n++] = new MoveInterp(this.this$0, 19);
            this.this$0.dataTypes[n++] = new MoveInterp(this.this$0, 22);
            this.this$0.dataTypes[n++] = new MoveInterp(this.this$0, 21);
            this.this$0.dataTypes[n++] = new MoveInterp(this.this$0, 20);
            this.this$0.dataTypes[n++] = new MoveInterp(this.this$0, 23);
        }

        void setData(SBdb db, WellInterp source, WellInterp target) {
            for (MoveInterp d : this.this$0.dataTypes) {
                switch (d.igdType) {
                    case 2: 
                    case 3: 
                    case 4: {
                        List<Object> listSource = source.getIGDList(d.igdType);
                        if (listSource.isEmpty()) {
                            d.sourceRows = 0;
                        } else {
                            d.sourceFrom = ((IGDIntervalZone)listSource.get(0)).getTopSample().getDepth();
                            d.sourceTo = ((IGDIntervalZone)listSource.get(listSource.size() - 1)).getBaseSample().getDepth();
                            d.sourceRows = listSource.size();
                        }
                        List<Object> listTarget = target.getIGDList(d.igdType);
                        if (listTarget.isEmpty()) {
                            d.targetRows = 0;
                            break;
                        }
                        d.targetFrom = ((IGDIntervalZone)listTarget.get(0)).getTopSample().getDepth();
                        d.targetTo = ((IGDIntervalZone)listTarget.get(listTarget.size() - 1)).getBaseSample().getDepth();
                        d.targetRows = listTarget.size();
                        break;
                    }
                    case 5: {
                        List<Object> listSource = source.getEnvs();
                        if (listSource.isEmpty()) {
                            d.sourceRows = 0;
                        } else {
                            d.sourceFrom = ((IGDIntervalEnv)listSource.get(0)).getTopSample().getDepth();
                            d.sourceTo = ((IGDIntervalEnv)listSource.get(listSource.size() - 1)).getBaseSample().getDepth();
                            d.sourceRows = listSource.size();
                        }
                        List<Object> listTarget = target.getEnvs();
                        if (listTarget.isEmpty()) {
                            d.targetRows = 0;
                            break;
                        }
                        d.targetFrom = ((IGDIntervalEnv)listTarget.get(0)).getTopSample().getDepth();
                        d.targetTo = ((IGDIntervalEnv)listTarget.get(listTarget.size() - 1)).getBaseSample().getDepth();
                        d.targetRows = listTarget.size();
                        break;
                    }
                    case 22: {
                        List<Object> listSource = source.getIntcoms();
                        if (listSource.isEmpty()) {
                            d.sourceRows = 0;
                        } else {
                            d.sourceFrom = ((Intcom)listSource.get(0)).getTopDepth();
                            d.sourceTo = ((Intcom)listSource.get(listSource.size() - 1)).getBaseDepth();
                            d.sourceRows = listSource.size();
                        }
                        List<Object> listTarget = target.getIntcoms();
                        if (listTarget.isEmpty()) {
                            d.targetRows = 0;
                            break;
                        }
                        d.targetFrom = ((Intcom)listTarget.get(0)).getTopDepth();
                        d.targetTo = ((Intcom)listTarget.get(listTarget.size() - 1)).getBaseDepth();
                        d.targetRows = listTarget.size();
                        break;
                    }
                    case 21: {
                        List<Object> listSource = source.getSQPicks();
                        if (listSource.isEmpty()) {
                            d.sourceRows = 0;
                        } else {
                            d.sourceFrom = ((SQPick)listSource.get(0)).getSample().getDepth();
                            d.sourceTo = ((SQPick)listSource.get(listSource.size() - 1)).getSample().getDepth();
                            d.sourceRows = listSource.size();
                        }
                        List<Object> listTarget = target.getSQPicks();
                        if (listTarget.isEmpty()) {
                            d.targetRows = 0;
                            break;
                        }
                        d.targetFrom = ((SQPick)listTarget.get(0)).getSample().getDepth();
                        d.targetTo = ((SQPick)listTarget.get(listTarget.size() - 1)).getSample().getDepth();
                        d.targetRows = listTarget.size();
                        break;
                    }
                    case 19: {
                        List<Object> listSource = source.getComments();
                        if (listSource.isEmpty()) {
                            d.sourceRows = 0;
                        } else {
                            d.sourceFrom = ((Biocom)listSource.get(0)).getSample().getDepth();
                            d.sourceTo = ((Biocom)listSource.get(listSource.size() - 1)).getSample().getDepth();
                            d.sourceRows = listSource.size();
                        }
                        List<Object> listTarget = target.getComments();
                        if (listTarget.isEmpty()) {
                            d.targetRows = 0;
                            break;
                        }
                        d.targetFrom = ((Biocom)listTarget.get(0)).getSample().getDepth();
                        d.targetTo = ((Biocom)listTarget.get(listTarget.size() - 1)).getSample().getDepth();
                        d.targetRows = listTarget.size();
                        break;
                    }
                    case 20: {
                        List<Object> listSource = source.getEvents();
                        if (listSource.isEmpty()) {
                            d.sourceRows = 0;
                        } else {
                            d.sourceFrom = ((WellEvent)listSource.get(0)).getSample().getDepth();
                            d.sourceTo = ((WellEvent)listSource.get(listSource.size() - 1)).getSample().getDepth();
                            d.sourceRows = listSource.size();
                        }
                        List<Object> listTarget = target.getEvents();
                        if (listTarget.isEmpty()) {
                            d.targetRows = 0;
                            break;
                        }
                        d.targetFrom = ((WellEvent)listTarget.get(0)).getSample().getDepth();
                        d.targetTo = ((WellEvent)listTarget.get(listTarget.size() - 1)).getSample().getDepth();
                        d.targetRows = listTarget.size();
                        break;
                    }
                    case 23: {
                        LOC sourceLOC = source.getLOC();
                        if (sourceLOC == null || sourceLOC.getNodes().isEmpty()) {
                            d.sourceRows = 0;
                        } else {
                            d.sourceFrom = sourceLOC.getNode(0).getDepth();
                            d.sourceTo = sourceLOC.getNode(sourceLOC.getSize() - 1).getDepth();
                            d.sourceRows = sourceLOC.getSize();
                        }
                        LOC targetLOC = target.getLOC();
                        if (targetLOC == null || targetLOC.getNodes().isEmpty()) {
                            d.targetRows = 0;
                            break;
                        }
                        d.targetFrom = targetLOC.getNode(0).getDepth();
                        d.targetTo = targetLOC.getNode(targetLOC.getSize() - 1).getDepth();
                        d.targetRows = targetLOC.getSize();
                        break;
                    }
                }
                d.select = d.isSelectable();
            }
            this.this$0.dataSet = true;
            this.fireTableDataChanged();
        }
    }
}

