/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import jsbugs.DialogTable;
import jsbugs.FrameJsbugs;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.SBRestrictable;
import model3.SBdb;
import model3.Taxon;
import util.SB;
import util.SBException;
import util.SBPermissionException;

public class DialogNumericDicts
extends JDialog {
    DefaultListModel model = new DefaultListModel();
    SBdb sbdb;
    private JButton jButtonAdd;
    private JButton jButtonClose;
    private JButton jButtonCodes;
    private JButton jButtonDelete;
    private JList jListDicts;
    private JScrollPane jScrollPane1;

    public DialogNumericDicts(Frame parent, boolean modal, SBdb sbdb) throws SQLException {
        super(parent, modal);
        this.sbdb = sbdb;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException {
        this.setTitle("Numeric Code Dictionaries");
        this.getRootPane().setDefaultButton(this.jButtonClose);
        this.initModel();
        if (!SBRestrictable.canWrite(this.sbdb)) {
            this.jButtonAdd.setEnabled(false);
            this.jButtonDelete.setEnabled(false);
        }
    }

    private void initModel() throws SQLException {
        HashMap<Integer, String> dicts = this.sbdb.getSIPMDicts();
        Set<Map.Entry<Integer, String>> set = dicts.entrySet();
        for (Map.Entry<Integer, String> entry : set) {
            ListItem row = new ListItem(entry.getKey(), entry.getValue());
            this.model.addElement(row);
        }
    }

    private void initComponents() {
        this.jButtonAdd = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jListDicts = new JList();
        this.jButtonDelete = new JButton();
        this.jButtonCodes = new JButton();
        this.jButtonClose = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(250, 200));
        this.jButtonAdd.setText("Add...");
        this.jButtonAdd.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogNumericDicts this$0;
            {
                DialogNumericDicts dialogNumericDicts = this$0;
                Objects.requireNonNull(dialogNumericDicts);
                this.this$0 = dialogNumericDicts;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAddActionPerformed(evt);
            }
        });
        this.jListDicts.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jListDicts.setModel(this.model);
        this.jScrollPane1.setViewportView(this.jListDicts);
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogNumericDicts this$0;
            {
                DialogNumericDicts dialogNumericDicts = this$0;
                Objects.requireNonNull(dialogNumericDicts);
                this.this$0 = dialogNumericDicts;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonCodes.setText("Codes...");
        this.jButtonCodes.setMargin(new Insets(2, 10, 2, 10));
        this.jButtonCodes.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogNumericDicts this$0;
            {
                DialogNumericDicts dialogNumericDicts = this$0;
                Objects.requireNonNull(dialogNumericDicts);
                this.this$0 = dialogNumericDicts;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCodesActionPerformed(evt);
            }
        });
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogNumericDicts this$0;
            {
                DialogNumericDicts dialogNumericDicts = this$0;
                Objects.requireNonNull(dialogNumericDicts);
                this.this$0 = dialogNumericDicts;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCloseActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 183, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButtonCodes, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonAdd, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonDelete, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonClose, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.jButtonCodes).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonAdd).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonDelete).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonClose)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 150, Short.MAX_VALUE))).addContainerGap()));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        String name = JOptionPane.showInputDialog(this, (Object)"Name of new Dictionary: ");
        if (name == null || name.length() == 0) {
            return;
        }
        for (int i = 0; i < this.model.size(); ++i) {
            ListItem item = (ListItem)this.model.getElementAt(i);
            if (!item.dictionary.equalsIgnoreCase(name)) continue;
            JOptionPane.showMessageDialog(this, "Dictionary already exists", this.getTitle(), 2);
            return;
        }
        try {
            ListItem row = new ListItem(this.sbdb.addSipmDict(name), name);
            this.sbdb.commit();
            this.model.addElement(row);
        }
        catch (SQLException | SBException ex) {
            this.sbdb.doRollback();
            FrameJsbugs.showStackError("Error adding dictionary", (Exception)ex, this.sbdb);
        }
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        if (this.jListDicts.getSelectedIndex() < 0) {
            JOptionPane.showMessageDialog(this, "Select one row from the table", this.getTitle(), 2);
            return;
        }
        ListItem row = (ListItem)this.model.get(this.jListDicts.getSelectedIndex());
        try {
            int opt;
            int nEntries = this.sbdb.getSipmDictEntryCount(row.ccode);
            if (nEntries > 0 && (opt = JOptionPane.showConfirmDialog(this, "Warning: this dictionary contains codes for " + nEntries + " taxa. Are you sure you want to delete it?", this.getTitle(), 0, 3)) != 0) {
                return;
            }
            this.sbdb.deleteSipmDict(row.ccode);
            this.sbdb.commit();
            this.model.removeElement(row);
        }
        catch (SQLException | SBException | SBPermissionException ex) {
            FrameJsbugs.showStackError("Error deleting dictionary", (Exception)ex, this.sbdb);
            this.sbdb.doRollback();
        }
    }

    private void jButtonCodesActionPerformed(ActionEvent evt) {
        if (this.jListDicts.getSelectedIndex() < 0) {
            JOptionPane.showMessageDialog(this, "Select one row from the table", this.getTitle(), 2);
            return;
        }
        int ccode = ((ListItem)this.model.getElementAt((int)this.jListDicts.getSelectedIndex())).ccode;
        try {
            class TaxonCode
            implements Comparable {
                final Taxon taxon;
                final int code;

                TaxonCode(DialogNumericDicts this$0, Taxon taxon, int code) {
                    Objects.requireNonNull(this$0);
                    this.taxon = taxon;
                    this.code = code;
                }

                public int compareTo(Object o) {
                    if (o instanceof TaxonCode) {
                        TaxonCode comp = (TaxonCode)o;
                        return this.taxon.toString().compareTo(comp.taxon.toString());
                    }
                    assert (false);
                    return 0;
                }
            }
            final LinkedList<TaxonCode> list = new LinkedList<TaxonCode>();
            HashMap<Integer, Integer> sipmDictEntries = this.sbdb.getSipmDictEntries(ccode, true);
            for (Map.Entry<Integer, Integer> entry : sipmDictEntries.entrySet()) {
                list.add(new TaxonCode(this, this.sbdb.getTaxon(entry.getKey()), entry.getValue()));
            }
            Collections.sort(list);
            boolean CAT_COL = false;
            boolean TAXON_COL = true;
            int CODE_COL = 2;
            AbstractTableModel dialogModel = new AbstractTableModel(this){
                final /* synthetic */ DialogNumericDicts this$0;
                {
                    DialogNumericDicts dialogNumericDicts = this$0;
                    Objects.requireNonNull(dialogNumericDicts);
                    this.this$0 = dialogNumericDicts;
                }

                @Override
                public int getRowCount() {
                    if (list == null) {
                        return 0;
                    }
                    return list.size();
                }

                @Override
                public int getColumnCount() {
                    return 3;
                }

                @Override
                public Object getValueAt(int rowIndex, int columnIndex) {
                    TaxonCode code = (TaxonCode)list.get(rowIndex);
                    switch (columnIndex) {
                        case 0: {
                            return code.taxon.getCatMnem();
                        }
                        case 1: {
                            return code.taxon;
                        }
                        case 2: {
                            return code.code;
                        }
                    }
                    return null;
                }
            };
            DialogTable dialog = new DialogTable(this, true, dialogModel, "Numeric codes : " + this.sbdb.getSipmDict(ccode), false);
            SB.setTableHeaderBold((JTable)dialog.getTable());
            TableColumnModel columnModel = dialog.getTable().getTableHeader().getColumnModel();
            columnModel.getColumn(0).setHeaderValue("Category");
            columnModel.getColumn(0).setPreferredWidth(20);
            columnModel.getColumn(1).setHeaderValue("Taxon");
            columnModel.getColumn(1).setPreferredWidth(150);
            columnModel.getColumn(2).setHeaderValue("Code");
            columnModel.getColumn(2).setPreferredWidth(30);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }
        catch (SQLException sql) {
            SbugsExceptionHandler.showStackError(sql);
        }
    }

    private static class ListItem {
        final int ccode;
        final String dictionary;

        ListItem(int ccode, String name) {
            this.ccode = ccode;
            this.dictionary = name;
        }

        public String toString() {
            return this.dictionary;
        }
    }
}

