/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import jsbugs.DialogOverlay;
import jsbugs.FrameJsbugs;
import jsbugs.FrameOverlay;
import model3.Overlay;
import model3.SBRestrictable;
import model3.SBdb;
import org.jdesktop.layout.GroupLayout;
import util.SBException;
import util.SBPermissionException;
import util.exception.StackError;

public class DialogOverlays
extends JDialog {
    private final SBdb db;
    private final DefaultListModel model = new DefaultListModel();
    private final FrameJsbugs frameJsbugs;
    Overlay selection = null;
    private JButton jButtonAdd;
    private JButton jButtonCancel;
    private JButton jButtonDelete;
    private JButton jButtonDesign;
    private JButton jButtonEdit;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JList jListOverlays;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;

    public DialogOverlays(Frame parent, FrameJsbugs f, boolean modal, SBdb db, boolean hasOKCancel) throws SQLException {
        super(parent, modal);
        this.frameJsbugs = f;
        this.db = db;
        this.initComponents();
        this.init(hasOKCancel);
    }

    private void init(boolean hasOKCancel) throws SQLException {
        this.setTitle("Overlays");
        this.getRootPane().setDefaultButton(this.jButtonOK);
        LinkedList<Overlay> overlays = new LinkedList<Overlay>();
        Iterator<Overlay> it = this.db.getOverlays().iterator();
        while (it.hasNext()) {
            overlays.add(it.next());
        }
        Collections.sort(overlays);
        for (Overlay overlay : overlays) {
            this.model.addElement(overlay);
        }
        this.jListOverlays.repaint();
        if (hasOKCancel) {
            this.jButtonCancel.setText("Cancel");
            this.jButtonDesign.setEnabled(false);
        } else {
            this.jButtonOK.setVisible(false);
        }
        if (!SBRestrictable.canWrite(this.db)) {
            this.jButtonDelete.setEnabled(false);
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jListOverlays = new JList();
        this.jButtonCancel = new JButton();
        this.jButtonEdit = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonAdd = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jButtonDesign = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonHelp = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(300, 400));
        this.jListOverlays.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.jListOverlays.setFont(this.jListOverlays.getFont());
        this.jListOverlays.setModel(this.model);
        this.jListOverlays.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ DialogOverlays this$0;
            {
                DialogOverlays dialogOverlays = this$0;
                Objects.requireNonNull(dialogOverlays);
                this.this$0 = dialogOverlays;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.this$0.jListOverlaysMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jListOverlays);
        this.jButtonCancel.setText("Close");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogOverlays this$0;
            {
                DialogOverlays dialogOverlays = this$0;
                Objects.requireNonNull(dialogOverlays);
                this.this$0 = dialogOverlays;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonEdit.setText("Edit...");
        this.jButtonEdit.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogOverlays this$0;
            {
                DialogOverlays dialogOverlays = this$0;
                Objects.requireNonNull(dialogOverlays);
                this.this$0 = dialogOverlays;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonEditActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogOverlays this$0;
            {
                DialogOverlays dialogOverlays = this$0;
                Objects.requireNonNull(dialogOverlays);
                this.this$0 = dialogOverlays;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonAdd.setText("Add...");
        this.jButtonAdd.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogOverlays this$0;
            {
                DialogOverlays dialogOverlays = this$0;
                Objects.requireNonNull(dialogOverlays);
                this.this$0 = dialogOverlays;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAddActionPerformed(evt);
            }
        });
        this.jButtonDesign.setText("Design...");
        this.jButtonDesign.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogOverlays this$0;
            {
                DialogOverlays dialogOverlays = this$0;
                Objects.requireNonNull(dialogOverlays);
                this.this$0 = dialogOverlays;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDesignActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogOverlays this$0;
            {
                DialogOverlays dialogOverlays = this$0;
                Objects.requireNonNull(dialogOverlays);
                this.this$0 = dialogOverlays;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogOverlays this$0;
            {
                DialogOverlays dialogOverlays = this$0;
                Objects.requireNonNull(dialogOverlays);
                this.this$0 = dialogOverlays;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -1, 289, Short.MAX_VALUE).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jButtonAdd).add((Component)this.jButtonDelete).add((Component)this.jSeparator1, -2, 50, -2).add((Component)this.jButtonDesign).add((Component)this.jButtonEdit, -2, 77, Short.MAX_VALUE))).add((GroupLayout.Group)layout.createSequentialGroup().add(10, 10, 10).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.jButtonCancel, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonHelp, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonOK, -1, -1, Short.MAX_VALUE)))).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonAdd, this.jButtonCancel, this.jButtonDelete, this.jButtonDesign, this.jButtonEdit, this.jButtonOK, this.jSeparator1}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonAdd).add(5, 5, 5).add((Component)this.jButtonEdit).addPreferredGap(0).add((Component)this.jButtonDelete).addPreferredGap(0).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0).add((Component)this.jButtonDesign).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel)).add(1, (Component)this.jScrollPane1, -1, 391, Short.MAX_VALUE)).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.selection = null;
        this.dispose();
    }

    private void jListOverlaysMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            if (this.jButtonOK.isVisible()) {
                this.jButtonOKActionPerformed(null);
            } else {
                this.jButtonDesignActionPerformed(null);
            }
        }
    }

    private void jButtonEditActionPerformed(ActionEvent evt) {
        if (this.jListOverlays.getSelectedValue() == null) {
            JOptionPane.showMessageDialog(this, "No overlay selected", this.getTitle(), 1);
            return;
        }
        this.selection = (Overlay)this.jListOverlays.getSelectedValue();
        try {
            this.selection.load();
            DialogOverlay dialog = new DialogOverlay(this, true, this.db, this.selection);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.isOK()) {
                this.refreshList();
            }
        }
        catch (SQLException ex) {
            FrameJsbugs.showStackError("Error loading overlay", ex, this.db);
        }
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        if (this.jListOverlays.getSelectedValue() == null) {
            JOptionPane.showMessageDialog(this, "No overlay selected", this.getTitle(), 1);
            return;
        }
        this.selection = (Overlay)this.jListOverlays.getSelectedValue();
        if (this.selection.countObservers() > 0) {
            JOptionPane.showMessageDialog(this, "Overlay in use, close before deleting.", this.getTitle(), 1);
            return;
        }
        if (JOptionPane.showConfirmDialog(this, "Delete overlay '" + this.selection.getName() + "'?", this.getTitle(), 0, 3) == 0) {
            try {
                this.db.deleteOverlay(this.selection);
                this.selection = null;
                this.db.commit();
                this.refreshList();
            }
            catch (SBPermissionException pe) {
                JOptionPane.showMessageDialog(this, pe.getMessage(), this.getTitle(), 2);
            }
            catch (SBException sbe) {
                StackError.showStackError((String)"Error", (Throwable)sbe);
            }
            catch (SQLException sql) {
                this.db.doRollback();
                FrameJsbugs.showStackError("SQL Error", sql, this.db);
            }
        }
    }

    private void jButtonDesignActionPerformed(ActionEvent evt) {
        if (this.jListOverlays.getSelectedValue() == null) {
            JOptionPane.showMessageDialog(this, "No overlay selected", this.getTitle(), 1);
            return;
        }
        try {
            this.selection = (Overlay)this.jListOverlays.getSelectedValue();
            this.selection.load();
            if (this.frameJsbugs.getFrameOverlay() != null) {
                if (this.frameJsbugs.getFrameOverlay().getOverlay().getOvrID() == this.selection.getOvrID()) {
                    this.frameJsbugs.getFrameOverlay().requestFocus();
                    this.frameJsbugs.getFrameOverlay().setExtendedState(6);
                    this.dispose();
                    return;
                }
                this.frameJsbugs.getFrameOverlay().dispose();
            }
            FrameOverlay overlay = new FrameOverlay(this.frameJsbugs.getAltGC(), this.frameJsbugs, this.db, null, null, this.selection, false, this.frameJsbugs.samplesFrame);
            overlay.setDesignMode();
            this.frameJsbugs.setFrameOverlay(overlay);
            this.frameJsbugs.getFrameOverlay().setExtendedState(6);
            this.dispose();
        }
        catch (Exception ex) {
            StackError.showStackError((String)("Error loading overlay:" + ex.getMessage()), (Throwable)ex);
        }
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        if (this.frameJsbugs.getFrameOverlay() != null) {
            JOptionPane.showMessageDialog(this, "An overlay is curently being displayed.", this.getTitle(), 2);
            return;
        }
        try {
            DialogOverlay dialog = new DialogOverlay(this, true, this.db, null);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.overlay != null) {
                this.refreshList();
            }
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.jListOverlays.getSelectedValue() == null) {
            JOptionPane.showMessageDialog(this, "No overlay selected", this.getTitle(), 1);
            return;
        }
        this.selection = (Overlay)this.jListOverlays.getSelectedValue();
        this.dispose();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogoverlays.html");
    }

    private void refreshList() {
        try {
            Iterator<Overlay> it = this.db.getOverlays().iterator();
            this.model.clear();
            while (it.hasNext()) {
                this.model.addElement(it.next());
            }
            this.jListOverlays.repaint();
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL error loading overlays", sql, this.db);
        }
    }
}

