/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.db.DBType;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Objects;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.LayoutStyle;
import model3.SBdb;
import util.SBException;

public class DialogPasswordChange
extends JDialog {
    SBdb db;
    SimpleDateFormat df = new SimpleDateFormat("dd-MMM-yyyy");
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabelExpiry;
    private JPasswordField jPasswordFieldNew1;
    private JPasswordField jPasswordFieldNew2;
    private JPasswordField jPasswordFieldOld;

    public DialogPasswordChange(Frame parent, boolean modal, SBdb sbdb) throws SBException, SQLException {
        super(parent, modal);
        this.db = sbdb;
        this.initComponents();
        this.init();
    }

    private void init() throws SBException, SQLException {
        if (this.db.getDBType() != DBType.ORACLE) {
            throw new SBException("Only implemented for Oracle");
        }
        int daysToExpiration = this.db.getDaysToPwExpiry();
        this.jLabelExpiry.setText(daysToExpiration + " days");
        this.jPasswordFieldOld.setText("");
        this.jPasswordFieldOld.setEnabled(true);
        this.setTitle("Password");
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabelExpiry = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jPasswordFieldOld = new JPasswordField();
        this.jPasswordFieldNew1 = new JPasswordField();
        this.jPasswordFieldNew2 = new JPasswordField();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jLabel1.setHorizontalAlignment(11);
        this.jLabel1.setText("Password expires in/on: ");
        this.jLabelExpiry.setFont(new Font("Tahoma", 1, 11));
        this.jLabelExpiry.setText("xxxxxxxxxxxxxxx");
        this.jLabel2.setHorizontalAlignment(11);
        this.jLabel2.setText("Old password:");
        this.jLabel3.setHorizontalAlignment(11);
        this.jLabel3.setText("New password:");
        this.jLabel4.setHorizontalAlignment(11);
        this.jLabel4.setText("Repeat:");
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogPasswordChange this$0;
            {
                DialogPasswordChange dialogPasswordChange = this$0;
                Objects.requireNonNull(dialogPasswordChange);
                this.this$0 = dialogPasswordChange;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Not now");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogPasswordChange this$0;
            {
                DialogPasswordChange dialogPasswordChange = this$0;
                Objects.requireNonNull(dialogPasswordChange);
                this.this$0 = dialogPasswordChange;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, GroupLayout.Alignment.TRAILING, -2, 120, -2).addComponent(this.jLabel2, GroupLayout.Alignment.TRAILING, -2, 118, -2).addComponent(this.jLabel4, GroupLayout.Alignment.TRAILING, -2, 118, -2)).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3, -2, 118, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 10, Short.MAX_VALUE))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(layout.createSequentialGroup().addComponent(this.jButtonOK, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelExpiry, -2, 128, -2).addComponent(this.jPasswordFieldOld, -2, 128, -2).addComponent(this.jPasswordFieldNew1, -2, 143, -2).addComponent(this.jPasswordFieldNew2, -2, 128, -2))).addContainerGap(21, Short.MAX_VALUE)));
        layout.linkSize(0, this.jLabelExpiry, this.jPasswordFieldNew1, this.jPasswordFieldNew2, this.jPasswordFieldOld);
        layout.linkSize(0, this.jLabel1, this.jLabel2, this.jLabel3, this.jLabel4);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(21, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelExpiry).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jPasswordFieldOld, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jPasswordFieldNew1, -2, -1, -2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jPasswordFieldNew2, -2, -1, -2).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonOK).addComponent(this.jButtonCancel)).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        char[] newPwCheck;
        char[] oldPw = this.jPasswordFieldOld.getPassword();
        char[] newPw = this.jPasswordFieldNew1.getPassword();
        if (!Arrays.equals(newPw, newPwCheck = this.jPasswordFieldNew2.getPassword())) {
            JOptionPane.showMessageDialog(this, "New passwords do not match");
            return;
        }
        try (Statement stmt = this.db.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery("SELECT user FROM dual");
            if (rs.next()) {
                String user = rs.getString("user");
                Object pw = "";
                for (char c : newPw) {
                    pw = (String)pw + c;
                }
                Object old = "";
                for (char c : oldPw) {
                    old = (String)old + c;
                }
                String sql = "ALTER USER " + user + " IDENTIFIED BY " + (String)pw + " REPLACE " + (String)old;
                stmt.executeUpdate(sql);
                JOptionPane.showMessageDialog(this, "Password changed successfully", "StrataBugs", 1);
                this.dispose();
            }
        }
        catch (SQLException e) {
            JOptionPane.showMessageDialog(this, "Error setting password: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

