/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.db.DBType;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.StringTokenizer;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.SBdb;
import util.SBException;

public class DialogSBChartLogPath
extends JDialog {
    DefaultListModel listModel = new DefaultListModel();
    SBdb db;
    private JButton jButton4;
    private JButton jButtonCancel;
    private JButton jButtonClear;
    private JButton jButtonExplore;
    private JButton jButtonOK;
    private JButton jButtonSelectFolder;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JList jListPaths;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JTextField jTextFieldPath;
    private JTextField jTextFieldPathStem;

    public DialogSBChartLogPath(Frame parent, boolean modal, SBdb db) throws SQLException, SBException {
        super(parent, modal);
        this.db = db;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException, SBException {
        this.setTitle("Edit Wireline Log Paths");
        this.jListPaths.setCellRenderer(new LogRenderer(this));
        LinkedList paths = new LinkedList();
        this.queryPaths(paths, null, null, null);
        Collections.sort(paths);
        Iterator it = paths.iterator();
        while (it.hasNext()) {
            LogPath path = new LogPath(this, (String)it.next(), false);
            File dir = new File(path.toString());
            if (dir.exists()) {
                path.exists = true;
            }
            this.listModel.addElement(path);
        }
        this.jListPaths.repaint();
    }

    private int queryPaths(List paths, Object[] toBeReplaced, String replacement, String pathStem) throws SQLException, SBException {
        String sql = "SELECT chart_id,panel_no,attributes FROM " + this.db.DBTableName("SBCHPANL");
        Statement stmt = this.db.getDBType() != DBType.ORACLE ? this.db.getDatabase().createStatement(1004, 1008) : this.db.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(this.db.modQuery(sql));
        int nUpdates = 0;
        Statement updateStmt = this.db.getDatabase().createStatement();
        block4: while (rs.next()) {
            int chartID = rs.getInt("chart_id");
            int panelNO = rs.getInt("panel_no");
            String atts = rs.getString("attributes");
            StringTokenizer tok = new StringTokenizer(atts, "|");
            int fieldNo = 0;
            int panelType = 0;
            String filePath = null;
            while (tok.hasMoreTokens()) {
                String field = tok.nextToken();
                switch (fieldNo++) {
                    case 0: {
                        panelType = Integer.parseInt(field.trim());
                        break;
                    }
                    case 12: {
                        filePath = field;
                    }
                }
            }
            if (panelType != 18 || filePath == null) continue;
            int fileChar = 92;
            String dirPath = null;
            if (filePath.lastIndexOf(fileChar) > 0) {
                dirPath = filePath.substring(0, filePath.lastIndexOf(fileChar));
            } else {
                fileChar = 47;
                if (filePath.lastIndexOf(fileChar) > 0) {
                    dirPath = filePath.substring(0, filePath.lastIndexOf(fileChar));
                }
            }
            if (toBeReplaced != null) {
                if (dirPath == null) continue;
                for (int i = 0; i < toBeReplaced.length; ++i) {
                    if (!dirPath.equals(((LogPath)toBeReplaced[i]).path)) continue;
                    if (atts.lastIndexOf(filePath) == atts.indexOf(filePath)) {
                        Object newAtts = atts.substring(0, atts.lastIndexOf(filePath));
                        int dirPathRemovalLength = dirPath.length();
                        if (pathStem != null && pathStem.length() > 0 && dirPath.startsWith(pathStem)) {
                            dirPathRemovalLength = pathStem.length();
                        }
                        if (replacement.length() > 0) {
                            newAtts = (String)newAtts + replacement;
                            newAtts = (String)newAtts + atts.substring(atts.lastIndexOf(filePath) + dirPathRemovalLength);
                        } else {
                            newAtts = (String)newAtts + atts.substring(atts.lastIndexOf(filePath) + dirPathRemovalLength + 1);
                        }
                        System.out.println("Replacing: " + atts);
                        System.out.println("With     : " + (String)newAtts);
                        if (this.db.getDBType() == DBType.ORACLE) {
                            String upsql = "update " + this.db.DBTableName("SBCHPANL") + " SET attributes='" + (String)newAtts + "' WHERE chart_id=" + chartID + " AND panel_no=" + panelNO;
                            updateStmt.executeUpdate(this.db.modQuery(upsql));
                        } else {
                            rs.updateString("attributes", (String)newAtts);
                            rs.updateRow();
                        }
                        ++nUpdates;
                        continue block4;
                    }
                    System.out.println("NOT replaced: " + atts + " - ambiguous reference");
                    throw new SBException("Could not complete task because of ambiguous reference to new path string.");
                }
                continue;
            }
            if (dirPath == null || paths.contains(dirPath)) continue;
            paths.add(dirPath);
        }
        stmt.close();
        return nUpdates;
    }

    private void initComponents() {
        this.jButton4 = new JButton();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jListPaths = new JList();
        this.jButtonExplore = new JButton();
        this.jLabel2 = new JLabel();
        this.jTextFieldPathStem = new JTextField();
        this.jButtonClear = new JButton();
        this.jLabel3 = new JLabel();
        this.jTextFieldPath = new JTextField();
        this.jButtonSelectFolder = new JButton();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jButton4.setText("jButton4");
        this.setDefaultCloseOperation(2);
        this.jLabel1.setText("External Wireline log paths in charts (non existent folders in red):");
        this.jListPaths.setModel(this.listModel);
        this.jListPaths.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ DialogSBChartLogPath this$0;
            {
                DialogSBChartLogPath dialogSBChartLogPath = this$0;
                Objects.requireNonNull(dialogSBChartLogPath);
                this.this$0 = dialogSBChartLogPath;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.this$0.jListPathsMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jListPaths);
        this.jButtonExplore.setText("Show...");
        this.jButtonExplore.setToolTipText("Show the files in selected folder/directory");
        this.jButtonExplore.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSBChartLogPath this$0;
            {
                DialogSBChartLogPath dialogSBChartLogPath = this$0;
                Objects.requireNonNull(dialogSBChartLogPath);
                this.this$0 = dialogSBChartLogPath;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonExploreActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Replace:");
        this.jTextFieldPathStem.setEditable(false);
        this.jButtonClear.setText("Clear");
        this.jButtonClear.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSBChartLogPath this$0;
            {
                DialogSBChartLogPath dialogSBChartLogPath = this$0;
                Objects.requireNonNull(dialogSBChartLogPath);
                this.this$0 = dialogSBChartLogPath;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonClearActionPerformed(evt);
            }
        });
        this.jLabel3.setText("With path (can be blank):");
        this.jButtonSelectFolder.setText("...");
        this.jButtonSelectFolder.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSBChartLogPath this$0;
            {
                DialogSBChartLogPath dialogSBChartLogPath = this$0;
                Objects.requireNonNull(dialogSBChartLogPath);
                this.this$0 = dialogSBChartLogPath;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSelectFolderActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSBChartLogPath this$0;
            {
                DialogSBChartLogPath dialogSBChartLogPath = this$0;
                Objects.requireNonNull(dialogSBChartLogPath);
                this.this$0 = dialogSBChartLogPath;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.setToolTipText("Proceed with edit");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSBChartLogPath this$0;
            {
                DialogSBChartLogPath dialogSBChartLogPath = this$0;
                Objects.requireNonNull(dialogSBChartLogPath);
                this.this$0 = dialogSBChartLogPath;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel3).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldPathStem).addComponent(this.jTextFieldPath)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonSelectFolder).addComponent(this.jButtonClear)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonExplore, -2, 71, -2)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1, GroupLayout.Alignment.TRAILING, -2, 598, -2).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonCancel))))).addContainerGap()));
        layout.linkSize(0, this.jButtonClear, this.jButtonSelectFolder);
        layout.linkSize(0, this.jButtonCancel, this.jButtonOK);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonExplore).addComponent(this.jScrollPane1, -1, 249, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jTextFieldPathStem, -2, -1, -2).addComponent(this.jButtonClear)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jTextFieldPath, -2, -1, -2).addComponent(this.jButtonSelectFolder)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonOK)).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonOKActionPerformed(ActionEvent evt) {
        if ((this.db.getUser().getPriv() & 0x40) == 0) {
            JOptionPane.showMessageDialog(this, "No privilege - you need to be a super user to do this", "StrataBugs", 1);
            return;
        }
        if (this.jListPaths.getSelectedValue() == null) {
            JOptionPane.showMessageDialog(this, "No path(s) selected", this.getTitle(), 2);
            return;
        }
        Object[] entries = this.jListPaths.getSelectedValues();
        String replacement = this.jTextFieldPath.getText();
        if (replacement.length() == 0 && JOptionPane.showConfirmDialog(this, "You will remove the folder path for these entries, do you want to proceed?", "File Path Update", 0, 3) != 0) {
            return;
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            int nUpdated = this.queryPaths(null, entries, replacement, this.jTextFieldPathStem.getText());
            this.setCursor(Cursor.getDefaultCursor());
            if (nUpdated > 0) {
                if (JOptionPane.showConfirmDialog(this, "Updating : " + nUpdated + " panels, OK to commit?", "File Path Update", 0, 3) != 0) {
                    this.db.doRollback();
                    this.dispose();
                    return;
                }
                this.db.commit();
                this.jListPaths.clearSelection();
                for (int i = 0; i < entries.length; ++i) {
                    this.listModel.removeElement(entries[i]);
                }
                this.jListPaths.repaint();
                this.jTextFieldPathStem.setText("");
            }
        }
        catch (RuntimeException | SQLException | SBException ex) {
            SbugsExceptionHandler.showStackError(ex, this);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jButtonSelectFolderActionPerformed(ActionEvent evt) {
        if (this.jListPaths.getSelectedValue() == null) {
            JOptionPane.showMessageDialog(this, "No path selected", this.getTitle(), 2);
            return;
        }
        String dirPath = ((LogPath)this.jListPaths.getSelectedValue()).path;
        JFileChooser dirChooser = new JFileChooser(dirPath);
        dirChooser.setFileSelectionMode(1);
        int returnVal = dirChooser.showOpenDialog(this);
        if (returnVal == 0) {
            this.jTextFieldPath.setText(dirChooser.getSelectedFile().toString());
        }
    }

    private void jButtonExploreActionPerformed(ActionEvent evt) {
        if (this.jListPaths.getSelectedValue() == null) {
            JOptionPane.showMessageDialog(this, "No path selected", this.getTitle(), 2);
            return;
        }
        String dirPath = ((LogPath)this.jListPaths.getSelectedValue()).path;
        File dir = new File(dirPath);
        if (dir.exists()) {
            ((LogPath)this.jListPaths.getSelectedValue()).exists = true;
            JFileChooser dirChooser = new JFileChooser(dirPath);
            dirChooser.setFileSelectionMode(2);
            int n = dirChooser.showOpenDialog(this);
        } else {
            JOptionPane.showMessageDialog(this, "The selected folder does not exist", this.getTitle(), 2);
        }
    }

    private void jListPathsMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonExploreActionPerformed(null);
        } else {
            String stem = null;
            for (int i = 0; i < this.jListPaths.getSelectedValues().length; ++i) {
                String dirPath = ((LogPath)this.jListPaths.getSelectedValues()[i]).path;
                if (stem == null) {
                    stem = dirPath;
                    continue;
                }
                while (!dirPath.startsWith(stem) && (stem = stem.substring(0, stem.length() - 1)).length() != 0) {
                }
            }
            this.jTextFieldPathStem.setText(stem);
        }
    }

    private void jButtonClearActionPerformed(ActionEvent evt) {
        this.jTextFieldPathStem.setText("");
    }

    class LogRenderer
    extends DefaultListCellRenderer {
        final /* synthetic */ DialogSBChartLogPath this$0;

        LogRenderer(DialogSBChartLogPath this$0) {
            DialogSBChartLogPath dialogSBChartLogPath = this$0;
            Objects.requireNonNull(dialogSBChartLogPath);
            this.this$0 = dialogSBChartLogPath;
        }

        @Override
        public void repaint(Rectangle r) {
            super.repaint(r);
        }

        @Override
        public void repaint(long tm, int x, int y, int width, int height) {
            super.repaint(tm, x, y, width, height);
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setComponentOrientation(list.getComponentOrientation());
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                LogPath path = (LogPath)value;
                if (path.exists) {
                    this.setBackground(list.getBackground());
                } else {
                    System.out.println(path);
                    this.setBackground(Color.pink);
                }
                this.setForeground(list.getForeground());
            }
            if (value instanceof Icon) {
                this.setIcon((Icon)value);
                this.setText("");
            } else {
                this.setIcon(null);
                this.setText(value == null ? "" : value.toString());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setBorder(cellHasFocus ? UIManager.getBorder("List.focusCellHighlightBorder") : noFocusBorder);
            return this;
        }
    }

    class LogPath {
        String path;
        boolean exists;

        LogPath(DialogSBChartLogPath this$0, String p, boolean e) {
            Objects.requireNonNull(this$0);
            this.path = p;
            this.exists = e;
        }

        public String toString() {
            return this.path;
        }
    }
}

