/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.util.ui.table.ColumnSortResetHandler;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;
import jsbugs.table.ColourRenderer;
import model3.IGDInterval;
import model3.IGDScheme;
import model3.SBdb;
import util.ColourUtils;
import util.SB;

public class DialogSearchUnit
extends JDialog {
    static String[] colTitles = new String[]{"Type", "Scheme", "Unit name", "Upper Age", "Lower Age", "Colour"};
    static int[] colWidths = new int[]{50, 50, 50, 30, 30, 10};
    static final int COL_TYPE = 0;
    static final int COL_SCHEME = 1;
    static final int COL_NAME = 2;
    static final int COL_UAGE = 3;
    static final int COL_LAGE = 4;
    static final int COL_COLOUR = 5;
    private final TableModelSearchUnit model = new TableModelSearchUnit(this);
    private final SBdb db;
    private LinkedList<UnitSearchResult> entries;
    private JButton jButtonClose;
    private JButton jButtonSearch;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JTable jTableSearchUnit;
    private JTextField jTextFieldUnitName;

    public DialogSearchUnit(Frame parent, boolean modal, SBdb db, String searchTerm) {
        super(parent, modal);
        this.db = db;
        this.initComponents();
        this.init(searchTerm);
    }

    public DialogSearchUnit(JDialog parent, boolean modal, SBdb db, String searchTerm) {
        super((Dialog)parent, modal);
        this.db = db;
        this.initComponents();
        this.init(searchTerm);
    }

    private void init(String searchTerm) {
        this.setTitle("Unit : Search");
        this.model.setupTable(this.jTableSearchUnit);
        this.jTableSearchUnit.setRowSorter(new TableRowSorter<TableModelSearchUnit>(this.model));
        new ColumnSortResetHandler(this.jTableSearchUnit).attach();
        if (searchTerm != null) {
            this.jTextFieldUnitName.setText(searchTerm);
            this.doSearch(searchTerm);
        }
        if (this.jTextFieldUnitName.getText().endsWith("%")) {
            this.jTextFieldUnitName.setCaretPosition(this.jTextFieldUnitName.getText().length() - 1);
        } else {
            this.jTextFieldUnitName.setCaretPosition(this.jTextFieldUnitName.getText().length());
        }
        this.getRootPane().setDefaultButton(this.jButtonSearch);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jTextFieldUnitName = new JTextField();
        this.jButtonSearch = new JButton();
        this.jButtonClose = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTableSearchUnit = new JTable();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(445, 337));
        this.jLabel1.setText("Find Unit: ");
        this.jTextFieldUnitName.setText("%");
        this.jTextFieldUnitName.setToolTipText("Enter a search term, or multiple terms separated by \";\". Wildards are _ and %");
        this.jButtonSearch.setText("Search");
        this.jButtonSearch.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSearchUnit this$0;
            {
                DialogSearchUnit dialogSearchUnit = this$0;
                Objects.requireNonNull(dialogSearchUnit);
                this.this$0 = dialogSearchUnit;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSearchActionPerformed(evt);
            }
        });
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSearchUnit this$0;
            {
                DialogSearchUnit dialogSearchUnit = this$0;
                Objects.requireNonNull(dialogSearchUnit);
                this.this$0 = dialogSearchUnit;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCloseActionPerformed(evt);
            }
        });
        this.jTableSearchUnit.setModel(this.model);
        this.jScrollPane1.setViewportView(this.jTableSearchUnit);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 595, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldUnitName, -2, 214, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSearch).addGap(0, 0, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonClose))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jTextFieldUnitName, -2, -1, -2).addComponent(this.jButtonSearch)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jScrollPane1, -1, 268, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonClose).addContainerGap()));
        this.pack();
    }

    private void jButtonSearchActionPerformed(ActionEvent evt) {
        String searchTerm = this.jTextFieldUnitName.getText();
        if (searchTerm.isEmpty() || searchTerm.equals("%")) {
            JOptionPane.showMessageDialog(this, "No search term specified", this.getTitle(), 2);
            return;
        }
        this.doSearch(searchTerm);
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void doSearch(String searchTerm) {
        String[] terms = searchTerm.split(";");
        this.entries = new LinkedList();
        try {
            Statement stmt = this.db.getDatabase().createStatement();
            for (String term : terms) {
                this.doSearchTable(stmt, this.entries, "IGD_DICT", term);
                this.doSearchTable(stmt, this.entries, "IGD_DICT_LSTRAT", term);
            }
            if (this.entries.isEmpty()) {
                String msg = "No exact matching units found";
                if (searchTerm.contains("%")) {
                    msg = msg.replace(" exact", "");
                }
                JOptionPane.showMessageDialog(this, msg, this.getTitle(), 1);
            }
            this.model.fireTableDataChanged();
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            JOptionPane.showMessageDialog(this, sqle.toString(), this.getTitle(), 0);
        }
    }

    private void doSearchTable(Statement stmt, List entries, String tableName, String term) throws SQLException {
        Object sql = "SELECT sch_id, name, ";
        String orderBy = "u_age";
        if (tableName.equalsIgnoreCase("IGD_DICT_LSTRAT")) {
            sql = (String)sql + " ue_age, uw_age, le_age, lw_age, colour FROM " + this.db.DBTableName(tableName);
            orderBy = "ue_age DESC, uw_age";
        } else {
            sql = (String)sql + "u_age, l_age, colour FROM " + this.db.DBTableName(tableName);
        }
        sql = (String)sql + " WHERE ucase(name) like " + SB.DBString((String)term.toUpperCase()) + " ORDER BY sch_id, " + orderBy + " DESC";
        ResultSet rs = stmt.executeQuery(this.db.modQuery((String)sql));
        while (rs.next()) {
            UnitSearchResult item = new UnitSearchResult();
            item.scheme = this.db.getIGDScheme(rs.getInt("sch_id"));
            item.unitName = rs.getString("name");
            if (tableName.equalsIgnoreCase("IGD_DICT_LSTRAT")) {
                item.uAge = Math.min(rs.getDouble("ue_age"), rs.getDouble("uw_age"));
                item.lAge = Math.min(rs.getDouble("le_age"), rs.getDouble("lw_age"));
            } else {
                item.uAge = rs.getDouble("u_age");
                item.lAge = rs.getDouble("l_age");
            }
            item.colour = ColourUtils.getDBColour((String)rs.getString("colour"));
            entries.add(item);
        }
    }

    private class TableModelSearchUnit
    extends AbstractTableModel {
        final /* synthetic */ DialogSearchUnit this$0;

        private TableModelSearchUnit(DialogSearchUnit dialogSearchUnit) {
            DialogSearchUnit dialogSearchUnit2 = dialogSearchUnit;
            Objects.requireNonNull(dialogSearchUnit2);
            this.this$0 = dialogSearchUnit2;
        }

        @Override
        public int getRowCount() {
            if (this.this$0.entries == null) {
                return 0;
            }
            return this.this$0.entries.size();
        }

        @Override
        public int getColumnCount() {
            return colTitles.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (this.this$0.entries == null) {
                return null;
            }
            UnitSearchResult entry = this.this$0.entries.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return IGDInterval.getIGDName(entry.scheme.getIGDType());
                }
                case 1: {
                    return entry.scheme.getName();
                }
                case 2: {
                    return entry.unitName;
                }
                case 3: {
                    return entry.uAge;
                }
                case 4: {
                    return entry.lAge;
                }
                case 5: {
                    return entry.colour;
                }
            }
            return null;
        }

        public Class getColumnClass(int c) {
            switch (c) {
                case 1: 
                case 2: {
                    return String.class;
                }
                case 3: 
                case 4: {
                    return Double.class;
                }
                case 5: {
                    return Color.class;
                }
            }
            return Object.class;
        }

        void setupTable(JTable table) {
            SB.setTableHeaderBold((JTable)table);
            for (int i = 0; i < this.getColumnCount(); ++i) {
                TableColumn column = table.getColumnModel().getColumn(table.convertColumnIndexToView(i));
                column.setHeaderValue(colTitles[i]);
                column.setPreferredWidth(colWidths[i]);
                if (i != 5) continue;
                column.setCellRenderer(new ColourRenderer(false));
            }
        }
    }

    private static class UnitSearchResult {
        IGDScheme scheme;
        String unitName;
        double uAge;
        double lAge;
        Color colour;

        private UnitSearchResult() {
        }
    }
}

