/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.event.EventContext;
import com.stratadata.model3.event.EventType;
import com.stratadata.util.ui.SBDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableRowSorter;
import model3.SBEvent;
import model3.Surface;

public class DialogSelectCorrelationLines
extends SBDialog {
    private final TableModelCorrelationLines model = new TableModelCorrelationLines(this);
    private final List<CorrelativeObject> list;
    private final boolean[] checks;
    private static final String[] COL_TITLES = new String[]{"Line", "Type", "Select?"};
    private static final int[] COL_WIDTHS = new int[]{120, 40, 55};
    private int[] selectedRowsBeforeEdit;
    private boolean finishedMultiEdit = false;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JScrollPane jScrollPane1;
    private JTable jTable;

    public DialogSelectCorrelationLines(Frame parent, boolean modal, Collection<CorrelativeObject> objects) {
        super(parent, modal);
        this.initComponents();
        this.list = new ArrayList<CorrelativeObject>(objects);
        Collections.sort(this.list);
        this.checks = new boolean[this.list.size()];
        this.init();
    }

    private void init() {
        this.setTitle("Select Correlation Lines");
        this.getRootPane().setDefaultButton(this.jButtonOK);
        TableCellRenderer centreRenderer = new TableCellRenderer(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel label = (JLabel)((Object)table.getTableHeader().getDefaultRenderer());
                label.setHorizontalAlignment(0);
                label.setText(COL_TITLES[column]);
                return label;
            }
        };
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            this.jTable.getColumnModel().getColumn(i).setHeaderValue(COL_TITLES[i]);
            this.jTable.getColumnModel().getColumn(i).setWidth(COL_WIDTHS[i]);
            if (i != 2) continue;
            this.jTable.getColumnModel().getColumn(i).setMaxWidth(COL_WIDTHS[i]);
            this.jTable.getColumnModel().getColumn(i).setMinWidth(COL_WIDTHS[i]);
            this.jTable.getColumnModel().getColumn(i).setPreferredWidth(COL_WIDTHS[i]);
            this.jTable.getColumnModel().getColumn(i).setHeaderRenderer(centreRenderer);
        }
        this.jTable.setGridColor(Color.LIGHT_GRAY);
        this.jTable.getTableHeader().setReorderingAllowed(false);
        this.jTable.setRowSorter(new TableRowSorter<TableModelCorrelationLines>(this.model));
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTable = new JTable();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.setDefaultCloseOperation(2);
        this.jTable.setModel(this.model);
        this.jTable.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ DialogSelectCorrelationLines this$0;
            {
                DialogSelectCorrelationLines dialogSelectCorrelationLines = this$0;
                Objects.requireNonNull(dialogSelectCorrelationLines);
                this.this$0 = dialogSelectCorrelationLines;
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                this.this$0.jTableMouseReleased(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTable);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectCorrelationLines this$0;
            {
                DialogSelectCorrelationLines dialogSelectCorrelationLines = this$0;
                Objects.requireNonNull(dialogSelectCorrelationLines);
                this.this$0 = dialogSelectCorrelationLines;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectCorrelationLines this$0;
            {
                DialogSelectCorrelationLines dialogSelectCorrelationLines = this$0;
                Objects.requireNonNull(dialogSelectCorrelationLines);
                this.this$0 = dialogSelectCorrelationLines;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -2, 0, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 161, Short.MAX_VALUE).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel))).addContainerGap()));
        layout.linkSize(0, this.jButtonCancel, this.jButtonOK);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 301, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonOK)).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        this.setOK();
    }

    private void jTableMouseReleased(MouseEvent evt) {
        if (this.finishedMultiEdit && this.selectedRowsBeforeEdit != null) {
            ListSelectionModel selectionModel = this.jTable.getSelectionModel();
            selectionModel.clearSelection();
            int[] nArray = this.selectedRowsBeforeEdit;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                Integer modelRow = nArray[i];
                int viewRow = this.jTable.convertRowIndexToView(modelRow);
                selectionModel.addSelectionInterval(viewRow, viewRow);
            }
            this.finishedMultiEdit = false;
            return;
        }
        if (this.jTable.getSelectedRowCount() > 1) {
            int[] selection = this.jTable.getSelectedRows();
            for (int i = 0; i < selection.length; ++i) {
                selection[i] = this.jTable.convertRowIndexToModel(selection[i]);
            }
            this.selectedRowsBeforeEdit = selection;
        } else {
            this.selectedRowsBeforeEdit = null;
        }
    }

    List<CorrelativeObject> getSelection() {
        ArrayList<CorrelativeObject> coll = new ArrayList<CorrelativeObject>();
        for (int i = 0; i < this.checks.length; ++i) {
            if (!this.checks[i]) continue;
            coll.add(this.list.get(i));
        }
        return coll;
    }

    private class TableModelCorrelationLines
    extends AbstractTableModel {
        final /* synthetic */ DialogSelectCorrelationLines this$0;

        private TableModelCorrelationLines(DialogSelectCorrelationLines dialogSelectCorrelationLines) {
            DialogSelectCorrelationLines dialogSelectCorrelationLines2 = dialogSelectCorrelationLines;
            Objects.requireNonNull(dialogSelectCorrelationLines2);
            this.this$0 = dialogSelectCorrelationLines2;
        }

        @Override
        public int getRowCount() {
            if (this.this$0.list == null) {
                return 0;
            }
            return this.this$0.list.size();
        }

        @Override
        public int getColumnCount() {
            return COL_TITLES.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    Comparable object = this.this$0.list.get((int)rowIndex).o;
                    if (object instanceof SBEvent) {
                        SBEvent event = (SBEvent)object;
                        return event.toString(false, false, true, true);
                    }
                    return Objects.toString(this.this$0.list.get((int)rowIndex).o);
                }
                case 1: {
                    Comparable comparable;
                    Enum o = this.this$0.list.get((int)rowIndex).type;
                    if (o instanceof EventType) {
                        EventType eventType = (EventType)o;
                        return eventType.toString(EventContext.WELL);
                    }
                    if (o == null && (comparable = this.this$0.list.get((int)rowIndex).o) instanceof Surface) {
                        Surface surface = (Surface)comparable;
                        o = surface.getType();
                    }
                    return Objects.toString(o);
                }
                case 2: {
                    return this.this$0.checks[rowIndex];
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 2;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                default: {
                    return String.class;
                }
                case 2: 
            }
            return Boolean.class;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (col != 2) {
                return;
            }
            Boolean select = (Boolean)value;
            if (this.this$0.selectedRowsBeforeEdit != null) {
                boolean found = false;
                for (int rowi : this.this$0.selectedRowsBeforeEdit) {
                    if (rowi != row) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    this.this$0.selectedRowsBeforeEdit = null;
                    this.this$0.checks[row] = select;
                    return;
                }
                int[] nArray = this.this$0.selectedRowsBeforeEdit;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    Integer rowi = nArray[i];
                    this.this$0.checks[rowi.intValue()] = select;
                }
                this.this$0.finishedMultiEdit = true;
            } else {
                this.this$0.checks[row] = select;
            }
        }
    }

    public static class CorrelativeObject
    implements Comparable<CorrelativeObject> {
        final Comparable o;
        final Enum type;

        CorrelativeObject(Comparable o, Enum type) {
            this.o = o;
            this.type = type;
        }

        public int hashCode() {
            int hash = 3;
            hash = 11 * hash + (this.o != null ? this.o.hashCode() : 0);
            hash = 11 * hash + (this.type != null ? this.type.hashCode() : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CorrelativeObject other = (CorrelativeObject)obj;
            if (this.o == null ^ other.o == null) {
                return false;
            }
            if (this.type == null ^ other.type == null) {
                return false;
            }
            return this.type == other.type && this.o == other.o;
        }

        @Override
        public int compareTo(CorrelativeObject o) {
            int comp = this.o.compareTo(o.o);
            if (comp == 0 && this.type != null && o.type != null) {
                return this.type.compareTo(o.type);
            }
            return comp;
        }
    }
}

