/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.taxon.Taxon;
import com.stratadata.model3.taxon.TaxonFactory;
import com.stratadata.util.ui.HelpUtils;
import com.stratadata.util.ui.table.ColumnSortResetHandler;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.table.TableRowSorter;
import jsbugs.DialogEvent;
import jsbugs.DialogSelectTaxa;
import jsbugs.SBEventsTableModel;
import jsbugs.userconnect.SbugsExceptionHandler;
import jsbugs.util.ItemSelectorDialog;
import model3.CompositeStandard;
import model3.Lastval;
import model3.SBEvent;
import model3.SBdb;
import org.jdesktop.layout.GroupLayout;
import util.SB;
import util.SBException;
import util.SbugsOptionToggle;

public class DialogSelectEvent
extends ItemSelectorDialog<SBEvent> {
    private static final int NAMELEN = 100;
    private static final String NO_FILTER_SELECTED = "<No filter selected>";
    private static final Logger LOGGER = Logger.getLogger(DialogSelectEvent.class.getName());
    private final SBEventsTableModel model = new SBEventsTableModel();
    private final SBdb db;
    private Taxon searchedTaxon = null;
    private static boolean showButtons = false;
    private static Integer dialogWidth;
    private static Integer dialogHeight;
    DefaultComboBoxModel modelCmpStd = new DefaultComboBoxModel();
    private boolean inInit = true;
    SBEvent selection;
    List<SBEvent> selected = null;
    boolean multiSelect = false;
    private ButtonGroup buttonGroup1;
    private JButton jButtonAdd;
    private JButton jButtonCancel;
    private JButton jButtonEdit;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JButton jButtonSearch;
    private JButton jButtonSelectTaxa;
    private JButton jButtonTrim;
    private JComboBox<String> jComboBoxCmpStd;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JRadioButton jRadioButtonExcludeCSEvents;
    private JRadioButton jRadioButtonIncludeCSEvents;
    private JScrollPane jScrollPane1;
    private JTable jTableSBEvents;
    private JTextField jTextFieldSearch;
    private JTextField jTextFieldSearchTaxa;
    private JToggleButton jToggleButton1;

    public DialogSelectEvent(Frame parent, boolean modal, SBdb db, boolean allowCmpStdFilter) throws SQLException, SBException {
        super(parent, modal);
        this.db = db;
        this.multiSelect = false;
        this.initComponents();
        this.init(null, null, true, allowCmpStdFilter);
    }

    public DialogSelectEvent(Frame parent, boolean modal, SBdb db, boolean multiSelect, boolean allowCmpStdFilter) throws SQLException, SBException {
        super(parent, modal);
        this.db = db;
        this.initComponents();
        this.multiSelect = multiSelect;
        this.init(null, null, false, allowCmpStdFilter);
    }

    public DialogSelectEvent(Frame parent, boolean modal, SBdb db, List<SBEvent> eventList) throws SQLException, SBException {
        super(parent, modal);
        this.db = db;
        this.initComponents();
        this.init(eventList, null, false, true);
    }

    public DialogSelectEvent(JDialog parent, boolean modal, SBdb db, SBEvent selection, String searchString, boolean allowCmpStdFilter) throws SQLException, SBException {
        super(parent, modal);
        this.db = db;
        this.selection = selection;
        this.initComponents();
        this.init(null, searchString, false, allowCmpStdFilter);
    }

    private void init(List<SBEvent> eventList, String searchString, boolean displayOnly, boolean allowCmpStdFilter) throws SQLException, SBException {
        List<SBEvent> events;
        this.setTitle("Event : Select");
        if (dialogWidth != null && dialogHeight != null) {
            this.setSize(dialogWidth, dialogHeight);
        }
        if (searchString != null) {
            this.jTextFieldSearch.setText(searchString + "%");
        }
        if (this.multiSelect) {
            DefaultListSelectionModel model = new DefaultListSelectionModel();
            model.setSelectionMode(2);
            this.jTableSBEvents.setSelectionModel(model);
        }
        this.jTableSBEvents.setRowSorter(new TableRowSorter<SBEventsTableModel>(this.model));
        new ColumnSortResetHandler(this.jTableSBEvents).attach();
        this.model.setupTable(this.jTableSBEvents);
        if (eventList != null) {
            events = eventList;
        } else if (this.selection != null && this.selection.getName() != null) {
            String string = this.selection.getName().length() < 10 ? this.selection.getName() : this.selection.getName().substring(0, 10) + "%";
            this.jTextFieldSearch.setText(string);
            events = SBEvent.search(this.db, string);
        } else {
            events = new LinkedList<SBEvent>();
        }
        this.model.setEvents(events);
        if (allowCmpStdFilter) {
            List<CompositeStandard> list = this.db.getCompositeStandards();
            Collections.sort(list);
            this.modelCmpStd.addElement(NO_FILTER_SELECTED);
            this.modelCmpStd.addAll(list);
            int cmpStdID = Lastval.getInt(this.db, "CMPSTDFILT");
            if (cmpStdID > 0) {
                CompositeStandard cmpStd = this.db.getCompositeStandard(cmpStdID);
                if (cmpStd == null) {
                    Lastval.delete(this.db, "CMPSTDFILT");
                } else {
                    this.jComboBoxCmpStd.setSelectedItem(cmpStd);
                    cmpStd.loadEvents();
                    this.model.filterEvents(cmpStd, true);
                }
            }
            this.jRadioButtonIncludeCSEvents.setSelected(true);
        } else {
            this.jComboBoxCmpStd.removeAllItems();
            this.jComboBoxCmpStd.setEnabled(false);
            this.jRadioButtonExcludeCSEvents.setEnabled(false);
            this.jRadioButtonIncludeCSEvents.setEnabled(false);
        }
        this.model.fireTableDataChanged();
        if (this.selection != null && this.model.getEvents().indexOf(this.selection) >= 0) {
            int index = this.jTableSBEvents.convertRowIndexToView(this.model.getEvents().indexOf(this.selection));
            this.jTableSBEvents.setRowSelectionInterval(index, index);
            this.jTableSBEvents.scrollRectToVisible(this.jTableSBEvents.getCellRect(index, 0, true));
        }
        if (displayOnly) {
            this.jButtonCancel.setText("Close");
            this.jButtonOK.setVisible(false);
            this.setTitle("Events");
        } else {
            this.getRootPane().setDefaultButton(this.jButtonSearch);
        }
        this.jTextFieldSearch.addFocusListener(new FocusAdapter(this){
            final /* synthetic */ DialogSelectEvent this$0;
            {
                DialogSelectEvent dialogSelectEvent = this$0;
                Objects.requireNonNull(dialogSelectEvent);
                this.this$0 = dialogSelectEvent;
            }

            @Override
            public void focusGained(FocusEvent arg0) {
                EventQueue.invokeLater(() -> {
                    if (this.this$0.jTextFieldSearch.getText().endsWith("%")) {
                        this.this$0.jTextFieldSearch.setCaretPosition(this.this$0.jTextFieldSearch.getText().length() - 1);
                    }
                });
            }
        });
        ((SbugsOptionToggle)this.jToggleButton1).addComponents(showButtons, new JComponent[]{this.jButtonAdd, this.jButtonEdit});
        this.inInit = false;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jButtonCancel = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonOK = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTableSBEvents = new JTable();
        this.jButtonAdd = new JButton();
        this.jButtonEdit = new JButton();
        this.jLabel1 = new JLabel();
        this.jTextFieldSearch = new JTextField();
        this.jButtonSearch = new JButton();
        this.jLabel2 = new JLabel();
        this.jTextFieldSearchTaxa = new JTextField();
        this.jButtonSelectTaxa = new JButton();
        this.jToggleButton1 = new SbugsOptionToggle();
        this.jButtonTrim = new JButton();
        this.jLabel3 = new JLabel();
        this.jComboBoxCmpStd = new JComboBox();
        this.jRadioButtonIncludeCSEvents = new JRadioButton();
        this.jRadioButtonExcludeCSEvents = new JRadioButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(325, 375));
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectEvent this$0;
            {
                DialogSelectEvent dialogSelectEvent = this$0;
                Objects.requireNonNull(dialogSelectEvent);
                this.this$0 = dialogSelectEvent;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectEvent this$0;
            {
                DialogSelectEvent dialogSelectEvent = this$0;
                Objects.requireNonNull(dialogSelectEvent);
                this.this$0 = dialogSelectEvent;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectEvent this$0;
            {
                DialogSelectEvent dialogSelectEvent = this$0;
                Objects.requireNonNull(dialogSelectEvent);
                this.this$0 = dialogSelectEvent;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jTableSBEvents.setModel(this.model);
        this.jTableSBEvents.setSelectionMode(0);
        this.jTableSBEvents.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ DialogSelectEvent this$0;
            {
                DialogSelectEvent dialogSelectEvent = this$0;
                Objects.requireNonNull(dialogSelectEvent);
                this.this$0 = dialogSelectEvent;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.this$0.jTableSBEventsMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTableSBEvents);
        this.jButtonAdd.setText("Add...");
        this.jButtonAdd.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectEvent this$0;
            {
                DialogSelectEvent dialogSelectEvent = this$0;
                Objects.requireNonNull(dialogSelectEvent);
                this.this$0 = dialogSelectEvent;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAddActionPerformed(evt);
            }
        });
        this.jButtonEdit.setText("Edit...");
        this.jButtonEdit.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectEvent this$0;
            {
                DialogSelectEvent dialogSelectEvent = this$0;
                Objects.requireNonNull(dialogSelectEvent);
                this.this$0 = dialogSelectEvent;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonEditActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Search event name:");
        this.jTextFieldSearch.setText("%");
        this.jTextFieldSearch.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogSelectEvent this$0;
            {
                DialogSelectEvent dialogSelectEvent = this$0;
                Objects.requireNonNull(dialogSelectEvent);
                this.this$0 = dialogSelectEvent;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldSearchKeyTyped(evt);
            }
        });
        this.jButtonSearch.setText("Search");
        this.jButtonSearch.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectEvent this$0;
            {
                DialogSelectEvent dialogSelectEvent = this$0;
                Objects.requireNonNull(dialogSelectEvent);
                this.this$0 = dialogSelectEvent;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSearchActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Search taxon/taxa:");
        this.jTextFieldSearchTaxa.setEditable(false);
        this.jButtonSelectTaxa.setText("...");
        this.jButtonSelectTaxa.setToolTipText("Select taxa and search for events");
        this.jButtonSelectTaxa.putClientProperty("JComponent.sizeVariant", "small");
        this.jButtonSelectTaxa.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectEvent this$0;
            {
                DialogSelectEvent dialogSelectEvent = this$0;
                Objects.requireNonNull(dialogSelectEvent);
                this.this$0 = dialogSelectEvent;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSelectTaxaActionPerformed(evt);
            }
        });
        this.jToggleButton1.setText(">");
        this.jButtonTrim.setText("(trim)");
        this.jButtonTrim.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectEvent this$0;
            {
                DialogSelectEvent dialogSelectEvent = this$0;
                Objects.requireNonNull(dialogSelectEvent);
                this.this$0 = dialogSelectEvent;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonTrimActionPerformed(evt);
            }
        });
        this.jLabel3.setText("Filter by Composite:");
        this.jComboBoxCmpStd.setModel(this.modelCmpStd);
        this.jComboBoxCmpStd.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectEvent this$0;
            {
                DialogSelectEvent dialogSelectEvent = this$0;
                Objects.requireNonNull(dialogSelectEvent);
                this.this$0 = dialogSelectEvent;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jComboBoxCmpStdActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioButtonIncludeCSEvents);
        this.jRadioButtonIncludeCSEvents.setText("<html><strong>Include</strong> only from Composite</html>");
        this.jRadioButtonIncludeCSEvents.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectEvent this$0;
            {
                DialogSelectEvent dialogSelectEvent = this$0;
                Objects.requireNonNull(dialogSelectEvent);
                this.this$0 = dialogSelectEvent;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonIncludeCSEventsActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioButtonExcludeCSEvents);
        this.jRadioButtonExcludeCSEvents.setText("<html><strong>Exclude</strong> if in Composite</html>");
        this.jRadioButtonExcludeCSEvents.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectEvent this$0;
            {
                DialogSelectEvent dialogSelectEvent = this$0;
                Objects.requireNonNull(dialogSelectEvent);
                this.this$0 = dialogSelectEvent;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonExcludeCSEventsActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jScrollPane1, -1, 647, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jButtonCancel).add((Component)this.jButtonHelp).add((Component)this.jButtonOK)).add((Component)this.jToggleButton1, -2, 40, -2).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jButtonAdd).add((Component)this.jButtonEdit))).addContainerGap()).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jLabel2).add((Component)this.jLabel1)).add((Component)this.jLabel3)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jRadioButtonIncludeCSEvents, -2, 207, -2).add(18, 18, 18).add((Component)this.jRadioButtonExcludeCSEvents)).add((Component)this.jTextFieldSearchTaxa).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jTextFieldSearch).addPreferredGap(0).add((Component)this.jButtonTrim, -2, 62, -2)).add(this.jComboBoxCmpStd, 0, -1, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jButtonSearch).add((Component)this.jButtonSelectTaxa, -2, 30, -2)).add(58, 58, 58)))));
        layout.linkSize(new Component[]{this.jButtonAdd, this.jButtonCancel, this.jButtonEdit, this.jButtonHelp, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jTextFieldSearch, -2, -1, -2).add((Component)this.jButtonSearch).add((Component)this.jButtonTrim)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.jTextFieldSearchTaxa, -2, -1, -2).add((Component)this.jButtonSelectTaxa)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel3).add(this.jComboBoxCmpStd, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jRadioButtonIncludeCSEvents, -2, -1, -2).add((Component)this.jRadioButtonExcludeCSEvents, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jToggleButton1).addPreferredGap(0).add((Component)this.jButtonAdd).addPreferredGap(0).add((Component)this.jButtonEdit).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel)).add((Component)this.jScrollPane1, -1, 387, Short.MAX_VALUE)).addContainerGap()));
        this.pack();
    }

    private void jTableSBEventsMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonOKActionPerformed(null);
        }
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        SBEvent selectedEvent = null;
        int selectedRow = this.jTableSBEvents.getSelectedRow();
        if (selectedRow >= 0) {
            selectedEvent = this.model.getEvents().get(this.jTableSBEvents.convertRowIndexToModel(selectedRow));
        }
        Taxon taxon = selectedEvent != null && selectedEvent.getTaxon() != null ? selectedEvent.getTaxon().getTaxonCopy() : this.searchedTaxon;
        model3.Taxon modelTx = null;
        if (taxon != null) {
            try {
                modelTx = this.db.getTaxon(taxon.getSpecID());
            }
            catch (SQLException sqlException) {
                SbugsExceptionHandler.showStackError(sqlException);
                return;
            }
        }
        DialogEvent dialog = new DialogEvent((JDialog)((Object)this), true, this.db, null, modelTx);
        if (taxon == null) {
            dialog.setEventName(this.jTextFieldSearch.getText().replaceAll("%", ""));
        }
        dialog.setLocationRelativeTo((Component)((Object)this));
        dialog.setVisible(true);
        if (dialog.sbEvent != null) {
            this.selection = dialog.sbEvent;
            int size = this.model.getEvents().size();
            this.model.getEvents().add(this.selection);
            this.model.fireTableDataChanged();
            int index = this.jTableSBEvents.convertRowIndexToView(size);
            this.jTableSBEvents.setRowSelectionInterval(index, index);
            this.dispose();
        }
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.jTableSBEvents.getSelectedRowCount() < 1) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Select an event", this.getTitle(), 1);
            return;
        }
        if (this.multiSelect) {
            this.selected = new LinkedList<SBEvent>();
            for (int i : this.jTableSBEvents.getSelectedRows()) {
                this.selected.add(this.model.getEvents().get(this.jTableSBEvents.convertRowIndexToModel(i)));
            }
        } else if (this.jTableSBEvents.getSelectedRowCount() == 1) {
            this.selection = this.model.getEvents().get(this.jTableSBEvents.convertRowIndexToModel(this.jTableSBEvents.getSelectedRow()));
        }
        showButtons = this.jToggleButton1.isSelected();
        dialogWidth = this.getWidth();
        dialogHeight = this.getHeight();
        this.setOK();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonEditActionPerformed(ActionEvent evt) {
        int row = this.jTableSBEvents.getSelectedRow();
        if (row < 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Select an event", this.getTitle(), 1);
            return;
        }
        SBEvent event = this.model.getEvents().get(this.jTableSBEvents.convertRowIndexToModel(row));
        DialogEvent dialog = new DialogEvent((JDialog)((Object)this), true, this.db, event);
        dialog.setLocationRelativeTo((Component)((Object)this));
        dialog.setVisible(true);
        this.model.fireTableDataChanged();
        this.jTableSBEvents.getSelectionModel().setSelectionInterval(row, row);
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        HelpUtils.openHelp((String)"dialogselectevent.html");
    }

    private void jButtonSearchActionPerformed(ActionEvent evt) {
        this.search();
    }

    private void jTextFieldSearchKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldSearch, (int)100, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jButtonSelectTaxaActionPerformed(ActionEvent evt) {
        this.searchedTaxon = null;
        try {
            Taxon taxon = null;
            if (!this.jTextFieldSearch.getText().isEmpty()) {
                String searchString = this.jTextFieldSearch.getText().trim();
                if (searchString.indexOf("%") > 0) {
                    searchString = searchString.substring(0, searchString.indexOf("%"));
                }
                taxon = TaxonFactory.parse((String)searchString);
            }
            DialogSelectTaxa dialog = new DialogSelectTaxa((JDialog)((Object)this), true, this.db, Lastval.getInt(this.db, "SYNSCHID", 1), false, taxon);
            dialog.setLocationRelativeTo((Component)((Object)this));
            dialog.setVisible(true);
            if (!dialog.getSelectedItems().isEmpty()) {
                this.setEventsFromSpecies(dialog.getSelectedItems(), false);
            }
        }
        catch (RuntimeException ex) {
            SbugsExceptionHandler.showStackError(ex);
        }
        catch (SQLException ex) {
            SbugsExceptionHandler.showStackError(ex);
        }
    }

    private void jButtonTrimActionPerformed(ActionEvent evt) {
        Object searchText = this.jTextFieldSearch.getText().trim();
        if (((String)searchText).endsWith("%")) {
            searchText = ((String)searchText).substring(0, ((String)searchText).length() - 1);
        }
        if (((String)searchText).matches(".*\\(.*\\).*")) {
            searchText = ((String)searchText).substring(0, ((String)searchText).indexOf(40));
        } else if (((String)searchText).matches(".*\\[.*\\].*")) {
            searchText = ((String)searchText).substring(0, ((String)searchText).indexOf(91));
        } else if (!((String)searchText).isEmpty()) {
            searchText = ((String)searchText).substring(0, ((String)searchText).length() - 1);
        }
        searchText = ((String)searchText).trim() + "%";
        this.jTextFieldSearch.setText((String)searchText);
        this.jTextFieldSearch.requestFocusInWindow();
    }

    private void jComboBoxCmpStdActionPerformed(ActionEvent evt) {
        if (!this.inInit && this.jComboBoxCmpStd.getSelectedItem() != null) {
            try {
                if (this.jComboBoxCmpStd.getSelectedItem() instanceof CompositeStandard) {
                    CompositeStandard cmpStd = (CompositeStandard)this.jComboBoxCmpStd.getSelectedItem();
                    cmpStd.loadEvents();
                    this.model.filterEvents(cmpStd, this.jRadioButtonIncludeCSEvents.isSelected());
                    this.model.fireTableDataChanged();
                    Lastval.putInt(this.db, "CMPSTDFILT", cmpStd.getStdID());
                    this.db.commit();
                    this.enableRadioButtons(true);
                } else {
                    this.model.filterClear();
                    this.model.fireTableDataChanged();
                    Lastval.putInt(this.db, "CMPSTDFILT", 0);
                    this.db.commit();
                    this.enableRadioButtons(false);
                }
            }
            catch (SQLException se) {
                SbugsExceptionHandler.showStackError(se);
                LOGGER.log(Level.WARNING, MessageFormat.format("Error in: {0}", se));
                this.db.doRollback();
            }
        }
    }

    private void jRadioButtonIncludeCSEventsActionPerformed(ActionEvent evt) {
        this.jComboBoxCmpStdActionPerformed(null);
    }

    private void jRadioButtonExcludeCSEventsActionPerformed(ActionEvent evt) {
        this.jComboBoxCmpStdActionPerformed(null);
    }

    private void enableRadioButtons(boolean b) {
        this.jRadioButtonIncludeCSEvents.setEnabled(b);
        this.jRadioButtonExcludeCSEvents.setEnabled(b);
    }

    public void setEventsFromSpecies(List<Taxon> selection, boolean limitSpeciesNames) {
        int[] specIDs = selection.stream().mapToInt(Taxon::getSpecID).toArray();
        try {
            this.model.setEvents(SBEvent.search(this.db, specIDs));
        }
        catch (RuntimeException | SQLException | SBException e) {
            SbugsExceptionHandler.showStackError("Error searching for events", e, (Component)((Object)this));
            this.jTextFieldSearchTaxa.setText("");
            return;
        }
        if (this.model.getEvents().isEmpty()) {
            String msg = "No events linked to " + (selection.size() > 1 ? "these taxa." : "this taxon.");
            JOptionPane.showMessageDialog((Component)((Object)this), msg, this.getTitle(), 2);
        }
        Object species = "";
        if (selection.size() == 1) {
            this.searchedTaxon = selection.get(0);
        }
        for (Taxon t : selection) {
            if (limitSpeciesNames && ((String)species).length() > 100) {
                species = (String)species + "...";
                break;
            }
            if (!((String)species).isEmpty()) {
                species = (String)species + ", ";
            }
            species = (String)species + t.toString(false, false, false);
        }
        this.jTextFieldSearchTaxa.setText((String)species);
        if (this.jComboBoxCmpStd.getSelectedItem() instanceof CompositeStandard) {
            this.model.filterEvents((CompositeStandard)this.jComboBoxCmpStd.getSelectedItem(), this.jRadioButtonIncludeCSEvents.isSelected());
        }
        this.model.fireTableDataChanged();
    }

    private void search() {
        String text = this.jTextFieldSearch.getText();
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.model.setEvents(SBEvent.search(this.db, text));
            if (this.jComboBoxCmpStd.getSelectedItem() instanceof CompositeStandard) {
                this.model.filterEvents((CompositeStandard)this.jComboBoxCmpStd.getSelectedItem(), this.jRadioButtonIncludeCSEvents.isSelected());
            }
            this.model.fireTableDataChanged();
            this.jTextFieldSearchTaxa.setText("");
            this.searchedTaxon = null;
        }
        catch (RuntimeException | SQLException | SBException ex) {
            SbugsExceptionHandler.showStackError(ex);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    @Override
    public SBEvent getSelectedItem() {
        return this.selection;
    }

    @Override
    public List<SBEvent> getSelectedItems() {
        if (this.selected == null) {
            return Collections.emptyList();
        }
        return this.selected;
    }
}

