/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.util.ui.SBDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import jsbchart.block.WellBlock;
import jsbchart.core.ChartManager;
import jsbchart.core.PanelOcc;
import jsbchart.core.PanelTemplate;
import jsbchart.panel.PanelFactory;
import jsbchart.panel.PanelType;
import jsbchart.panel.SBPanel;
import jsbugs.ChartJPanelAHD;
import jsbugs.FrameJsbugs;
import model3.IGDScheme;
import model3.SBdb;
import model3.WellInterp;
import util.SBException;
import util.SBPermissionException;
import util.exception.StackError;

public class DialogSelectIGDPanel
extends SBDialog {
    private final SBdb db;
    private final ChartManager chartManager;
    private final DefaultListModel panelModel = new DefaultListModel();
    private final WellBlock block;
    private final WellInterp interp;
    SBPanel panel;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JList jListPanels;
    private JScrollPane jScrollPane1;

    public DialogSelectIGDPanel(SBDialog parent, boolean modal, SBdb db, WellBlock block, String title, WellInterp interp, ChartManager chartManager) {
        super((Window)parent, modal);
        this.block = block;
        this.db = db;
        this.interp = interp;
        this.chartManager = chartManager;
        this.setTitle(title);
        this.initComponents();
        this.init();
    }

    private void init() {
        this.getRootPane().setDefaultButton(this.jButtonOK);
        this.createPanelList();
    }

    private List<IGDScheme> getBiozoneSchemes() {
        LinkedList<IGDScheme> biozoneSchemes = new LinkedList<IGDScheme>();
        try {
            for (IGDScheme scheme : this.interp.getIGDSchemes(4)) {
                scheme.loadUnits();
                biozoneSchemes.add(scheme);
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        return biozoneSchemes;
    }

    private void createPanelList() {
        this.panelModel.clear();
        try {
            this.block.getWell().loadInterp(this.interp);
            for (PanelType type : ChartJPanelAHD.panelTypes) {
                if (!ChartJPanelAHD.hasData(type, this.block, this.interp)) continue;
                if (PanelType.isBiozonePanel(type)) {
                    for (IGDScheme scheme : this.getBiozoneSchemes()) {
                        if (scheme.getDiscipline() != type.getDiscipine()) continue;
                        this.panelModel.addElement(new PanelListElement(PanelType.getBiozoneType(scheme.getDiscipline()), scheme));
                    }
                    continue;
                }
                this.panelModel.addElement(new PanelListElement(type, null));
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (SBException sbe) {
            StackError.showStackError((String)"Error", (Throwable)sbe);
        }
    }

    private void initComponents() {
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jListPanels = new JList();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(285, 300));
        this.setModal(true);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectIGDPanel this$0;
            {
                DialogSelectIGDPanel dialogSelectIGDPanel = this$0;
                Objects.requireNonNull(dialogSelectIGDPanel);
                this.this$0 = dialogSelectIGDPanel;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectIGDPanel this$0;
            {
                DialogSelectIGDPanel dialogSelectIGDPanel = this$0;
                Objects.requireNonNull(dialogSelectIGDPanel);
                this.this$0 = dialogSelectIGDPanel;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jListPanels.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.jListPanels.setModel(this.panelModel);
        this.jListPanels.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ DialogSelectIGDPanel this$0;
            {
                DialogSelectIGDPanel dialogSelectIGDPanel = this$0;
                Objects.requireNonNull(dialogSelectIGDPanel);
                this.this$0 = dialogSelectIGDPanel;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.this$0.jListPanelsMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jListPanels);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 250, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel))).addContainerGap()));
        layout.linkSize(0, this.jButtonCancel, this.jButtonOK);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 300, Short.MAX_VALUE).addGap(11, 11, 11).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonOK)).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.jListPanels.getSelectedValue() == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Select an item from the list", this.getTitle(), 2);
            return;
        }
        try {
            for (Object o : this.jListPanels.getSelectedValuesList()) {
                PanelListElement element = (PanelListElement)o;
                PanelTemplate defaultPanelTemplate = this.chartManager.getDefaultPanelTemplate(element.panelType);
                PanelOcc panelOcc = null;
                if (element.scheme != null) {
                    panelOcc = new PanelOcc(defaultPanelTemplate.getID());
                    panelOcc.setProperty(5, element.scheme.getID());
                }
                this.panel = (SBPanel)PanelFactory.createPanel(this.block, defaultPanelTemplate, panelOcc);
            }
        }
        catch (SQLException | SBException | SBPermissionException sql) {
            FrameJsbugs.showStackError("Error", (Exception)sql, this.db);
            this.dispose();
        }
        this.setOK();
    }

    private void jListPanelsMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonOKActionPerformed(null);
        }
    }

    private static class PanelListElement {
        final PanelType panelType;
        final IGDScheme scheme;

        public PanelListElement(PanelType panelType, IGDScheme scheme) {
            this.panelType = panelType;
            this.scheme = scheme;
        }

        public String toString() {
            Object string = this.panelType.toString();
            if (this.scheme != null) {
                string = (String)string + " : " + String.valueOf(this.scheme);
            }
            return string;
        }
    }
}

