/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import jsbchart.core.ChartManager;
import jsbugs.DialogList;
import jsbugs.FrameJsbugs;
import jsbugs.list.RestrictableListRenderer;
import jsbugs.model2.igdscheme.DialogIGDScheme;
import jsbugs.userconnect.SbugsExceptionHandler;
import jsbugs.util.UserPrefsHelper;
import model3.CompositeStandard;
import model3.IGDScheme;
import model3.SBdb;
import model3.WellInterp;
import org.jdesktop.layout.GroupLayout;
import util.SBException;
import util.exception.StackError;

public class DialogSelectScheme
extends JDialog {
    private final SBdb db;
    private final DefaultListModel listModel = new DefaultListModel();
    private final int igdType;
    IGDScheme selection = null;
    private JButton jButtonAdd;
    private JButton jButtonCancel;
    private JButton jButtonDelete;
    private JButton jButtonEdit;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JButton jButtonShowArchived;
    private JButton jButtonShowUsage;
    private JList jListScheme;
    private JScrollPane jScrollPane1;

    public DialogSelectScheme(JFrame parent, boolean modal, SBdb db, int igdType) throws SQLException, SBException {
        super((Frame)parent, modal);
        this.db = db;
        this.igdType = igdType;
        this.initComponents();
        this.init(null);
    }

    public DialogSelectScheme(JDialog parent, boolean modal, SBdb db, int igdType, WellInterp wellInterp) throws SQLException, SBException {
        super((Dialog)parent, modal);
        this.db = db;
        this.igdType = igdType;
        this.initComponents();
        this.init(wellInterp);
        if (db.getShowArchivedSchemes()) {
            this.jButtonShowArchived.setEnabled(false);
        }
    }

    private void init(WellInterp wellInterp) throws SQLException, SBException {
        this.setTitle("Scheme : Select");
        List<IGDScheme> schemes = null;
        if (wellInterp != null) {
            schemes = wellInterp.getIGDSchemes(this.igdType);
            this.jButtonShowArchived.setEnabled(false);
        }
        if (schemes == null) {
            schemes = new LinkedList<IGDScheme>(this.db.getIGDSchemes(this.igdType));
        }
        this.showSchemes(schemes);
        this.getRootPane().setDefaultButton(this.jButtonOK);
        this.jListScheme.setCellRenderer(new RestrictableListRenderer());
    }

    private void showSchemes(List<IGDScheme> schemes) {
        Collections.sort(schemes);
        this.listModel.clear();
        for (IGDScheme scheme : schemes) {
            this.listModel.addElement(scheme);
        }
        this.jListScheme.setModel(this.listModel);
        this.jListScheme.repaint();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jListScheme = new JList();
        this.jButtonAdd = new JButton();
        this.jButtonEdit = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonShowUsage = new JButton();
        this.jButtonCancel = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonShowArchived = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(325, 300));
        this.setModal(true);
        this.setName("Select Scheme");
        this.addWindowListener(new WindowAdapter(this){
            final /* synthetic */ DialogSelectScheme this$0;
            {
                DialogSelectScheme dialogSelectScheme = this$0;
                Objects.requireNonNull(dialogSelectScheme);
                this.this$0 = dialogSelectScheme;
            }

            @Override
            public void windowClosing(WindowEvent evt) {
                this.this$0.formWindowClosing(evt);
            }
        });
        this.jListScheme.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.jListScheme.setModel(new AbstractListModel(this){
            String[] strings;
            final /* synthetic */ DialogSelectScheme this$0;
            {
                DialogSelectScheme dialogSelectScheme = this$0;
                Objects.requireNonNull(dialogSelectScheme);
                this.this$0 = dialogSelectScheme;
                this.strings = new String[]{"model"};
            }

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jListScheme.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ DialogSelectScheme this$0;
            {
                DialogSelectScheme dialogSelectScheme = this$0;
                Objects.requireNonNull(dialogSelectScheme);
                this.this$0 = dialogSelectScheme;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.this$0.jListSchemeMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jListScheme);
        this.jButtonAdd.setText("Add...");
        this.jButtonAdd.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectScheme this$0;
            {
                DialogSelectScheme dialogSelectScheme = this$0;
                Objects.requireNonNull(dialogSelectScheme);
                this.this$0 = dialogSelectScheme;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAddActionPerformed(evt);
            }
        });
        this.jButtonEdit.setText("Edit...");
        this.jButtonEdit.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectScheme this$0;
            {
                DialogSelectScheme dialogSelectScheme = this$0;
                Objects.requireNonNull(dialogSelectScheme);
                this.this$0 = dialogSelectScheme;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonEditActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectScheme this$0;
            {
                DialogSelectScheme dialogSelectScheme = this$0;
                Objects.requireNonNull(dialogSelectScheme);
                this.this$0 = dialogSelectScheme;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonShowUsage.setText("Show Usage...");
        this.jButtonShowUsage.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonShowUsage.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectScheme this$0;
            {
                DialogSelectScheme dialogSelectScheme = this$0;
                Objects.requireNonNull(dialogSelectScheme);
                this.this$0 = dialogSelectScheme;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonShowUsageActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectScheme this$0;
            {
                DialogSelectScheme dialogSelectScheme = this$0;
                Objects.requireNonNull(dialogSelectScheme);
                this.this$0 = dialogSelectScheme;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectScheme this$0;
            {
                DialogSelectScheme dialogSelectScheme = this$0;
                Objects.requireNonNull(dialogSelectScheme);
                this.this$0 = dialogSelectScheme;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectScheme this$0;
            {
                DialogSelectScheme dialogSelectScheme = this$0;
                Objects.requireNonNull(dialogSelectScheme);
                this.this$0 = dialogSelectScheme;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonShowArchived.setText("Show Archived");
        this.jButtonShowArchived.setToolTipText("Include archived schemes in list");
        this.jButtonShowArchived.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonShowArchived.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectScheme this$0;
            {
                DialogSelectScheme dialogSelectScheme = this$0;
                Objects.requireNonNull(dialogSelectScheme);
                this.this$0 = dialogSelectScheme;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonShowArchivedActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -1, 202, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createParallelGroup(2, false).add((Component)this.jButtonCancel, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonHelp, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonOK, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonAdd, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonEdit, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonDelete, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonShowUsage, -1, -1, Short.MAX_VALUE)).add(2, (Component)this.jButtonShowArchived)).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonAdd, this.jButtonCancel, this.jButtonDelete, this.jButtonEdit, this.jButtonHelp, this.jButtonOK, this.jButtonShowArchived, this.jButtonShowUsage}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.jScrollPane1, -1, 308, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonAdd).addPreferredGap(0).add((Component)this.jButtonEdit).addPreferredGap(0).add((Component)this.jButtonDelete).addPreferredGap(0).add((Component)this.jButtonShowUsage).addPreferredGap(1).add((Component)this.jButtonShowArchived).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel))).addContainerGap()));
        this.pack();
    }

    private void jListSchemeMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonOKActionPerformed(null);
        }
    }

    private void jButtonEditActionPerformed(ActionEvent evt) {
        IGDScheme scheme = (IGDScheme)this.jListScheme.getSelectedValue();
        if (scheme == null) {
            JOptionPane.showMessageDialog(this, "Select a scheme", this.getTitle(), 1);
            return;
        }
        try {
            DialogIGDScheme dialog = new DialogIGDScheme(this, true, this.db, scheme, scheme.getIGDType(), null);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            this.jListScheme.repaint();
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (SBException sbe) {
            StackError.showStackError((String)"Error", (Throwable)sbe);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.selection = null;
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        this.selection = (IGDScheme)this.jListScheme.getSelectedValue();
        if (this.selection == null) {
            JOptionPane.showMessageDialog(this, "Select a scheme", this.getTitle(), 1);
            return;
        }
        this.dispose();
    }

    private void jButtonShowUsageActionPerformed(ActionEvent evt) {
        List<String> occs;
        Object object = this.jListScheme.getSelectedValue();
        if (object == null) {
            JOptionPane.showMessageDialog(this, "No scheme selected", this.getTitle(), 1);
            return;
        }
        try {
            if (object instanceof IGDScheme) {
                IGDScheme scheme = (IGDScheme)object;
                occs = scheme.getOccs();
            } else {
                CompositeStandard scheme = (CompositeStandard)object;
                occs = scheme.getOccs();
            }
        }
        catch (RuntimeException | SQLException | SBException e) {
            SbugsExceptionHandler.showStackError("Error searching for usages", e);
            return;
        }
        if (occs == null || occs.isEmpty()) {
            JOptionPane.showMessageDialog(this, "Scheme does not occur in any wells or outcrops.", object.toString(), 1);
        } else {
            DialogList.displayListDialog(this, object.toString(), new UserPrefsHelper(this.db), occs, null);
        }
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        try {
            DialogIGDScheme dialog = new DialogIGDScheme(this, true, this.db, null, this.igdType, null);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.isOK()) {
                this.init(null);
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (SBException sbe) {
            StackError.showStackError((String)"Error", (Throwable)sbe);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        if (this.jListScheme.getSelectedValue() == null) {
            JOptionPane.showMessageDialog(this, "No scheme selected", this.getTitle(), 2);
            return;
        }
        IGDScheme scheme = (IGDScheme)this.jListScheme.getSelectedValue();
        try {
            String msg = "";
            int occs = scheme.getNoccs();
            if (occs > 0) {
                JOptionPane.showMessageDialog(this, "You cannot delete this scheme because it occurs " + occs + " times in well intervals.", this.getTitle(), 2);
                return;
            }
            Object parents = "";
            Collection<Integer>[] parentOccs = scheme.getParentOccs();
            for (int schID : parentOccs[0]) {
                parents = (String)parents + "\n" + String.valueOf(this.db.getIGDScheme(schID));
            }
            for (int stdID : parentOccs[1]) {
                parents = (String)parents + "\n" + String.valueOf(this.db.getCompositeStandard(stdID));
            }
            for (int curveID : parentOccs[2]) {
                parents = (String)parents + "\n" + String.valueOf(this.db.getAgeCurve(curveID));
            }
            if (!((String)parents).isEmpty()) {
                String pMsg = "You can't delete this scheme because it is the parent of schemes/composites/curves:\n" + (String)parents;
                JOptionPane.showMessageDialog(this, pMsg, this.getTitle(), 2);
                return;
            }
            if (!ChartManager.checkDeleteIGDScheme(this.db, scheme.getID())) {
                JOptionPane.showMessageDialog(this, "You can't delete this scheme because it is used in charts.", "Delete Scheme", 2);
                return;
            }
            if (JOptionPane.showConfirmDialog(this, msg + "Really delete scheme: " + String.valueOf(scheme) + "?", this.getTitle(), 0, 3) == 0) {
                this.db.deleteIGDScheme(scheme);
                this.db.commit();
                scheme.notifyObservers();
                scheme.deleteObservers();
                this.listModel.removeElement(scheme);
            }
        }
        catch (SQLException sql) {
            this.db.doRollback();
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (SBException sbe) {
            StackError.showStackError((String)"Error", (Throwable)sbe);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogselectscheme.html");
    }

    private void formWindowClosing(WindowEvent evt) {
        this.jButtonCancelActionPerformed(null);
    }

    private void jButtonShowArchivedActionPerformed(ActionEvent evt) {
        try {
            LinkedList<IGDScheme> schemes = new LinkedList<IGDScheme>(this.db.getIGDSchemes(this.igdType, true));
            this.jButtonShowArchived.setEnabled(false);
            if (schemes.size() == this.jListScheme.getModel().getSize()) {
                JOptionPane.showMessageDialog(this, "There are no archived schemes in the database.", "Archive Schemes", 2);
                return;
            }
            this.showSchemes(schemes);
        }
        catch (Exception ex) {
            StackError.showStackError((String)"Error fetching schemes", (Throwable)ex);
        }
    }

    public IGDScheme getSelection() {
        return this.selection;
    }
}

