/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.Discipline;
import com.stratadata.model3.taxon.Category;
import com.stratadata.model3.taxon.CategoryService;
import com.stratadata.model3.taxon.Genus;
import com.stratadata.model3.taxon.GenusService;
import com.stratadata.model3.taxon.SearchMode;
import com.stratadata.model3.taxon.Taxon;
import com.stratadata.model3.taxon.TaxonFactory;
import com.stratadata.model3.taxon.TaxonService;
import com.stratadata.model3.taxon.process.TaxonAdd;
import com.stratadata.model3.validation.FieldLengthProperties;
import com.stratadata.model3.validation.SbugsValidator;
import com.stratadata.util.ui.HelpUtils;
import com.stratadata.util.ui.SBDialog;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableColumn;
import jsbugs.DialogTaxon;
import jsbugs.TaxonTableModel;
import jsbugs.WebSearch;
import jsbugs.list.CategoryComboBox;
import jsbugs.uiutil.TextFieldUtils;
import jsbugs.uiutil.icon.IconFactory;
import jsbugs.userconnect.SbugsExceptionHandler;
import jsbugs.userconnect.SbugsSession;
import jsbugs.util.DontAskMeAgainFactory;
import jsbugs.util.ItemSelectorDialog;
import jsbugs.webservices.DialogConfigureWebCitationServices;
import jsbugs.webservices.WebCitationService;
import model3.Lastval;
import model3.SBdb;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.layout.GroupLayout;

public class DialogSelectTaxa
extends ItemSelectorDialog<Taxon> {
    private static final int GEN_LEN = FieldLengthProperties.getFieldLength(Genus.class, (String)"genusName", (int)30);
    private static final int SPEC_LEN = FieldLengthProperties.getFieldLength(Taxon.class, (String)"species", (int)30);
    private static Integer dialogWidth;
    private static Integer dialogHeight;
    private static Discipline discFilter;
    private static SearchOptionStyle NO_TEMPLATE_SEARCH_STYLE;
    private final TaxonTableModel model;
    private final SBdb db;
    private final Taxon template;
    private Discipline disc;
    private int synSchID;
    private List<Taxon> selection = null;
    private static final Logger LOGGER;
    private WebCitationService webCitationService;
    private SearchOptionStyle searchOptionStyle = null;
    private Timer timer = null;
    private ButtonGroup buttonGroupDiscipline;
    private ButtonGroup buttonGroupSearchMode;
    private CategoryComboBox categoryComboBox;
    private JButton jButtonAdd;
    private JButton jButtonCancel;
    private JButton jButtonClear;
    private JButton jButtonDisc;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JButton jButtonSearch;
    private JButton jButtonSearchGenus;
    private JButton jButtonSearchSpecies;
    private JButton jButtonSwap;
    private JButton jButtonTrim;
    private JButton jButtonWebSearchEngine;
    private JButton jButtonWebServices;
    private JButton jButtonWsOptions;
    private JCheckBox jCheckBox1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabelQuickSearchStatus;
    private JPanel jPanel2;
    private JPanel jPanelSearchDetail;
    private JPanel jPanelSearchQuick;
    private JPopupMenu jPopupMenuDisc;
    private JRadioButtonMenuItem jRadioButtonMenuItemA;
    private JRadioButtonMenuItem jRadioButtonMenuItemDiscNone;
    private JRadioButtonMenuItem jRadioButtonMenuItemM;
    private JRadioButtonMenuItem jRadioButtonMenuItemN;
    private JRadioButtonMenuItem jRadioButtonMenuItemP;
    private JScrollPane jScrollPane1;
    private JToolBar.Separator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JToolBar.Separator jSeparator3;
    private JToolBar.Separator jSeparator4;
    private JTable jTableTaxa;
    private JTextField jTextFieldAlphaCode;
    private JTextField jTextFieldGenus;
    private JTextField jTextFieldKeyword;
    private JTextField jTextFieldSpecies;
    private JTextField jTextFieldSubGenus;
    private JTextField jTextFieldSubSpecies;
    private JTextField jTextFieldTaxon;
    private JToggleButton jToggleButtonSearchDetails;
    private JToggleButton jToggleButtonSearchQuick;
    private JToolBar jToolBar1;

    public DialogSelectTaxa(Frame parent, boolean modal, SBdb db, int synSchID, boolean singleSelection, Taxon initial) {
        super(parent, modal);
        this.db = db;
        this.template = initial;
        this.synSchID = synSchID;
        this.model = new TaxonTableModel(db.getTaxonService(), db.getSynonymService(), db.getUserService(), db.getTaxonImageService());
        this.initComponents();
        SBDialog.centreWindow((Window)((Object)this));
        this.init(singleSelection);
    }

    public DialogSelectTaxa(JDialog parent, boolean modal, SBdb db, int synSchID, boolean singleSelection, Taxon initial) {
        super(parent, modal);
        this.db = db;
        this.template = initial;
        this.synSchID = synSchID;
        this.model = new TaxonTableModel(db.getTaxonService(), db.getSynonymService(), db.getUserService(), db.getTaxonImageService());
        this.initComponents();
        this.init(singleSelection);
    }

    private void init(boolean singleSelection) {
        this.setTitle("Taxa : Select");
        if (dialogWidth != null && dialogHeight != null) {
            this.setSize(dialogWidth, dialogHeight);
        }
        this.setIcons();
        this.jPanel2.setLayout(new CardLayout());
        this.jPanel2.add("quick", this.jPanelSearchQuick);
        this.jPanel2.add("detail", this.jPanelSearchDetail);
        this.jToolBar1.setFloatable(false);
        this.getRootPane().setDefaultButton(this.jButtonSearch);
        this.model.setupTable(this.jTableTaxa, false, this.db);
        this.model.setSynSchemeID(this.synSchID);
        this.categoryComboBox.setCategoryService(this.db.getCategoryService());
        this.setDiscipline(discFilter);
        if (singleSelection) {
            this.jTableTaxa.setSelectionMode(0);
        }
        if (this.template != null) {
            if (this.template.getGenus().getCategory() != null) {
                this.categoryComboBox.setSelectedCategory(this.template.getGenus().getCategory().getMnemonic());
            }
            this.jTextFieldGenus.setText(StringUtils.stripToEmpty((String)this.template.getGenus().getGenusName()) + "%");
            this.jTextFieldSubGenus.setText(StringUtils.stripToEmpty((String)this.template.getGenus().getSubGenus()) + "%");
            this.jTextFieldSpecies.setText(StringUtils.stripToEmpty((String)this.template.getSpecies()) + "%");
            this.jTextFieldSubSpecies.setText(StringUtils.stripToEmpty((String)this.template.getSubSpecies()) + "%");
            this.jTextFieldAlphaCode.setText(StringUtils.stripToEmpty((String)this.template.getAlphaCode()) + "%");
            this.jTextFieldTaxon.setText(this.template.toString(true, true));
            this.jTextFieldKeyword.setText(this.template.toString(false, true));
            this.jToggleButtonSearchDetails.setSelected(true);
            this.setSearchOptionStyle(SearchOptionStyle.DETAIL);
        } else {
            this.jTextFieldTaxon.setBackground(Color.lightGray);
            String params = Lastval.tryGetString(this.db, "TSEARCH");
            if (params != null) {
                StringTokenizer tok = new StringTokenizer(params, "|");
                if (tok.hasMoreTokens()) {
                    this.jTextFieldGenus.setText(tok.nextToken());
                }
                if (tok.hasMoreTokens()) {
                    this.jTextFieldSubGenus.setText(tok.nextToken());
                }
                if (tok.hasMoreTokens()) {
                    this.jTextFieldSpecies.setText(tok.nextToken());
                }
                if (tok.hasMoreTokens()) {
                    this.jTextFieldSubSpecies.setText(tok.nextToken());
                }
                if (tok.hasMoreTokens()) {
                    this.categoryComboBox.setSelectedCategory(tok.nextToken());
                }
                String discID = Lastval.tryGetString(this.db, "TSEARCHCT");
                this.setDiscipline(Discipline.getDisc((String)discID));
            }
            switch (NO_TEMPLATE_SEARCH_STYLE.ordinal()) {
                case 0: {
                    this.jToggleButtonSearchQuick.setSelected(true);
                    break;
                }
                case 1: {
                    this.jToggleButtonSearchDetails.setSelected(true);
                }
            }
            this.setSearchOptionStyle(NO_TEMPLATE_SEARCH_STYLE);
            this.jTextFieldKeyword.requestFocusInWindow();
        }
        this.initKeywordListener();
        this.jLabelQuickSearchStatus.setText("");
    }

    private void setIcons() {
        if (SbugsSession.getSession().useHiResIcons()) {
            IconFactory.setButtonIconsInBackground(List.of(new IconFactory.ButtonIconInfo(this.jButtonAdd, "FrameTaxa_AddTaxon.svg", 16), new IconFactory.ButtonIconInfo(this.jButtonSearch, "search.svg", 16), new IconFactory.ButtonIconInfo(this.jButtonWsOptions, "cog.svg", 16)));
        } else {
            this.jButtonAdd.setIcon(IconFactory.getIcon("FrameTaxa_AddTaxon.svg", 16));
        }
    }

    private void initComponents() {
        this.buttonGroupDiscipline = new ButtonGroup();
        this.jCheckBox1 = new JCheckBox();
        this.jPopupMenuDisc = new JPopupMenu();
        this.jRadioButtonMenuItemDiscNone = new JRadioButtonMenuItem();
        this.jRadioButtonMenuItemM = new JRadioButtonMenuItem();
        this.jRadioButtonMenuItemP = new JRadioButtonMenuItem();
        this.jRadioButtonMenuItemN = new JRadioButtonMenuItem();
        this.jRadioButtonMenuItemA = new JRadioButtonMenuItem();
        this.jPanelSearchDetail = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jTextFieldGenus = TextFieldUtils.buildLimitedLengthTextField(GEN_LEN);
        this.jLabel3 = new JLabel();
        this.jTextFieldSubGenus = TextFieldUtils.buildLimitedLengthTextField(GEN_LEN);
        this.jLabel6 = new JLabel();
        this.jTextFieldAlphaCode = TextFieldUtils.buildLimitedLengthTextField(SPEC_LEN);
        this.jLabel4 = new JLabel();
        this.jTextFieldSpecies = TextFieldUtils.buildLimitedLengthTextField(SPEC_LEN);
        this.jLabel5 = new JLabel();
        this.jTextFieldSubSpecies = TextFieldUtils.buildLimitedLengthTextField(SPEC_LEN);
        this.categoryComboBox = new CategoryComboBox();
        this.jPanelSearchQuick = new JPanel();
        this.jTextFieldKeyword = TextFieldUtils.buildLimitedLengthTextField(150);
        this.jLabelQuickSearchStatus = new JLabel();
        this.buttonGroupSearchMode = new ButtonGroup();
        this.jTextFieldTaxon = new JTextField();
        this.jButtonCancel = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonOK = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTableTaxa = new JTable();
        this.jToolBar1 = new JToolBar();
        this.jToggleButtonSearchQuick = new JToggleButton();
        this.jToggleButtonSearchDetails = new JToggleButton();
        this.jSeparator3 = new JToolBar.Separator();
        this.jButtonDisc = new JButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.jButtonClear = new JButton();
        this.jButtonTrim = new JButton();
        this.jButtonSwap = new JButton();
        this.jButtonSearchGenus = new JButton();
        this.jButtonSearchSpecies = new JButton();
        this.jButtonSearch = new JButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.jButtonWebServices = new JButton();
        this.jButtonWsOptions = new JButton();
        this.jButtonWebSearchEngine = new JButton();
        this.jSeparator4 = new JToolBar.Separator();
        this.jButtonAdd = new JButton();
        this.jPanel2 = new JPanel();
        this.jCheckBox1.setText("jCheckBox1");
        this.buttonGroupDiscipline.add(this.jRadioButtonMenuItemDiscNone);
        this.jRadioButtonMenuItemDiscNone.setSelected(true);
        this.jRadioButtonMenuItemDiscNone.setText("No discipline restriction");
        this.jRadioButtonMenuItemDiscNone.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectTaxa this$0;
            {
                DialogSelectTaxa dialogSelectTaxa = this$0;
                Objects.requireNonNull(dialogSelectTaxa);
                this.this$0 = dialogSelectTaxa;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonMenuItemDiscNoneActionPerformed(evt);
            }
        });
        this.jPopupMenuDisc.add(this.jRadioButtonMenuItemDiscNone);
        this.buttonGroupDiscipline.add(this.jRadioButtonMenuItemM);
        this.jRadioButtonMenuItemM.setFont(new Font("Segoe UI", 1, 12));
        this.jRadioButtonMenuItemM.setText("Micro");
        this.jRadioButtonMenuItemM.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectTaxa this$0;
            {
                DialogSelectTaxa dialogSelectTaxa = this$0;
                Objects.requireNonNull(dialogSelectTaxa);
                this.this$0 = dialogSelectTaxa;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonMenuItemMActionPerformed(evt);
            }
        });
        this.jPopupMenuDisc.add(this.jRadioButtonMenuItemM);
        this.buttonGroupDiscipline.add(this.jRadioButtonMenuItemP);
        this.jRadioButtonMenuItemP.setFont(new Font("Segoe UI", 1, 12));
        this.jRadioButtonMenuItemP.setText("Paly");
        this.jRadioButtonMenuItemP.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectTaxa this$0;
            {
                DialogSelectTaxa dialogSelectTaxa = this$0;
                Objects.requireNonNull(dialogSelectTaxa);
                this.this$0 = dialogSelectTaxa;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonMenuItemPActionPerformed(evt);
            }
        });
        this.jPopupMenuDisc.add(this.jRadioButtonMenuItemP);
        this.buttonGroupDiscipline.add(this.jRadioButtonMenuItemN);
        this.jRadioButtonMenuItemN.setFont(new Font("Segoe UI", 1, 12));
        this.jRadioButtonMenuItemN.setText("Nanno");
        this.jRadioButtonMenuItemN.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectTaxa this$0;
            {
                DialogSelectTaxa dialogSelectTaxa = this$0;
                Objects.requireNonNull(dialogSelectTaxa);
                this.this$0 = dialogSelectTaxa;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonMenuItemNActionPerformed(evt);
            }
        });
        this.jPopupMenuDisc.add(this.jRadioButtonMenuItemN);
        this.buttonGroupDiscipline.add(this.jRadioButtonMenuItemA);
        this.jRadioButtonMenuItemA.setFont(new Font("Segoe UI", 1, 12));
        this.jRadioButtonMenuItemA.setText("Macro");
        this.jRadioButtonMenuItemA.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectTaxa this$0;
            {
                DialogSelectTaxa dialogSelectTaxa = this$0;
                Objects.requireNonNull(dialogSelectTaxa);
                this.this$0 = dialogSelectTaxa;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonMenuItemAActionPerformed(evt);
            }
        });
        this.jPopupMenuDisc.add(this.jRadioButtonMenuItemA);
        this.jPanelSearchDetail.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204)));
        this.jLabel1.setText("Category:");
        this.jLabel2.setText("Genus:");
        this.jTextFieldGenus.setText("%");
        this.jTextFieldGenus.addFocusListener(new FocusAdapter(this){
            final /* synthetic */ DialogSelectTaxa this$0;
            {
                DialogSelectTaxa dialogSelectTaxa = this$0;
                Objects.requireNonNull(dialogSelectTaxa);
                this.this$0 = dialogSelectTaxa;
            }

            @Override
            public void focusGained(FocusEvent evt) {
                this.this$0.jTextFieldGenusFocusGained(evt);
            }
        });
        this.jLabel3.setText("Sub-genus:");
        this.jTextFieldSubGenus.setText("%");
        this.jTextFieldSubGenus.addFocusListener(new FocusAdapter(this){
            final /* synthetic */ DialogSelectTaxa this$0;
            {
                DialogSelectTaxa dialogSelectTaxa = this$0;
                Objects.requireNonNull(dialogSelectTaxa);
                this.this$0 = dialogSelectTaxa;
            }

            @Override
            public void focusGained(FocusEvent evt) {
                this.this$0.jTextFieldSubGenusFocusGained(evt);
            }
        });
        this.jLabel6.setText("Alpha Code:");
        this.jTextFieldAlphaCode.setText("%");
        this.jTextFieldAlphaCode.addFocusListener(new FocusAdapter(this){
            final /* synthetic */ DialogSelectTaxa this$0;
            {
                DialogSelectTaxa dialogSelectTaxa = this$0;
                Objects.requireNonNull(dialogSelectTaxa);
                this.this$0 = dialogSelectTaxa;
            }

            @Override
            public void focusGained(FocusEvent evt) {
                this.this$0.jTextFieldAlphaCodeFocusGained(evt);
            }
        });
        this.jLabel4.setText("Species:");
        this.jTextFieldSpecies.setText("%");
        this.jTextFieldSpecies.addFocusListener(new FocusAdapter(this){
            final /* synthetic */ DialogSelectTaxa this$0;
            {
                DialogSelectTaxa dialogSelectTaxa = this$0;
                Objects.requireNonNull(dialogSelectTaxa);
                this.this$0 = dialogSelectTaxa;
            }

            @Override
            public void focusGained(FocusEvent evt) {
                this.this$0.jTextFieldSpeciesFocusGained(evt);
            }
        });
        this.jLabel5.setText("Sub-species:");
        this.jTextFieldSubSpecies.setText("%");
        this.jTextFieldSubSpecies.addFocusListener(new FocusAdapter(this){
            final /* synthetic */ DialogSelectTaxa this$0;
            {
                DialogSelectTaxa dialogSelectTaxa = this$0;
                Objects.requireNonNull(dialogSelectTaxa);
                this.this$0 = dialogSelectTaxa;
            }

            @Override
            public void focusGained(FocusEvent evt) {
                this.this$0.jTextFieldSubSpeciesFocusGained(evt);
            }
        });
        GroupLayout jPanelSearchDetailLayout = new GroupLayout((Container)this.jPanelSearchDetail);
        this.jPanelSearchDetail.setLayout((LayoutManager)jPanelSearchDetailLayout);
        jPanelSearchDetailLayout.setHorizontalGroup((GroupLayout.Group)jPanelSearchDetailLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelSearchDetailLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelSearchDetailLayout.createParallelGroup(2).add((Component)this.jLabel3).add((Component)this.jLabel2).add((Component)this.jLabel1)).addPreferredGap(0).add((GroupLayout.Group)jPanelSearchDetailLayout.createParallelGroup(1, false).add((Component)this.categoryComboBox, -2, 235, -2).add((Component)this.jTextFieldGenus).add((Component)this.jTextFieldSubGenus)).add(18, 18, 18).add((GroupLayout.Group)jPanelSearchDetailLayout.createParallelGroup(1, false).add((GroupLayout.Group)jPanelSearchDetailLayout.createSequentialGroup().add((Component)this.jLabel5).addPreferredGap(0).add((Component)this.jTextFieldSubSpecies, -1, 223, Short.MAX_VALUE)).add((GroupLayout.Group)jPanelSearchDetailLayout.createSequentialGroup().add((GroupLayout.Group)jPanelSearchDetailLayout.createParallelGroup(2).add((Component)this.jLabel6).add((Component)this.jLabel4)).addPreferredGap(0).add((GroupLayout.Group)jPanelSearchDetailLayout.createParallelGroup(1, false).add((Component)this.jTextFieldAlphaCode, -1, 224, Short.MAX_VALUE).add((Component)this.jTextFieldSpecies)))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanelSearchDetailLayout.linkSize(new Component[]{this.jTextFieldAlphaCode, this.jTextFieldSpecies, this.jTextFieldSubSpecies}, 1);
        jPanelSearchDetailLayout.setVerticalGroup((GroupLayout.Group)jPanelSearchDetailLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelSearchDetailLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelSearchDetailLayout.createParallelGroup(2).add((GroupLayout.Group)jPanelSearchDetailLayout.createSequentialGroup().add((GroupLayout.Group)jPanelSearchDetailLayout.createParallelGroup(3).add((Component)this.jLabel6).add((Component)this.jTextFieldAlphaCode, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanelSearchDetailLayout.createParallelGroup(3).add((Component)this.jLabel4).add((Component)this.jTextFieldSpecies, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanelSearchDetailLayout.createParallelGroup(3).add((Component)this.jLabel5).add((Component)this.jTextFieldSubSpecies, -2, -1, -2))).add((GroupLayout.Group)jPanelSearchDetailLayout.createSequentialGroup().add((GroupLayout.Group)jPanelSearchDetailLayout.createParallelGroup(1).add((Component)this.jLabel1).add((Component)this.categoryComboBox, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanelSearchDetailLayout.createParallelGroup(3).add((Component)this.jTextFieldGenus, -2, -1, -2).add((Component)this.jLabel2)).addPreferredGap(0).add((GroupLayout.Group)jPanelSearchDetailLayout.createParallelGroup(3).add((Component)this.jTextFieldSubGenus, -2, -1, -2).add((Component)this.jLabel3)))).addContainerGap(-1, Short.MAX_VALUE)));
        this.jTextFieldKeyword.setFont(new Font("Segoe UI", 0, 18));
        this.jLabelQuickSearchStatus.setFont(new Font("Segoe UI", 2, 12));
        this.jLabelQuickSearchStatus.setForeground(new Color(102, 102, 102));
        this.jLabelQuickSearchStatus.setText("jLabel7");
        GroupLayout jPanelSearchQuickLayout = new GroupLayout((Container)this.jPanelSearchQuick);
        this.jPanelSearchQuick.setLayout((LayoutManager)jPanelSearchQuickLayout);
        jPanelSearchQuickLayout.setHorizontalGroup((GroupLayout.Group)jPanelSearchQuickLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelSearchQuickLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelSearchQuickLayout.createParallelGroup(1).add((Component)this.jTextFieldKeyword).add((Component)this.jLabelQuickSearchStatus, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanelSearchQuickLayout.setVerticalGroup((GroupLayout.Group)jPanelSearchQuickLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelSearchQuickLayout.createSequentialGroup().addContainerGap().add((Component)this.jTextFieldKeyword, -2, 35, -2).addPreferredGap(0, 47, Short.MAX_VALUE).add((Component)this.jLabelQuickSearchStatus).addContainerGap()));
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(730, 400));
        this.setModal(true);
        this.jTextFieldTaxon.setEditable(false);
        this.jTextFieldTaxon.setBackground(new Color(255, 255, 204));
        this.jTextFieldTaxon.setFont(new Font("Segoe UI", 1, 12));
        this.jTextFieldTaxon.setFocusable(false);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectTaxa this$0;
            {
                DialogSelectTaxa dialogSelectTaxa = this$0;
                Objects.requireNonNull(dialogSelectTaxa);
                this.this$0 = dialogSelectTaxa;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectTaxa this$0;
            {
                DialogSelectTaxa dialogSelectTaxa = this$0;
                Objects.requireNonNull(dialogSelectTaxa);
                this.this$0 = dialogSelectTaxa;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectTaxa this$0;
            {
                DialogSelectTaxa dialogSelectTaxa = this$0;
                Objects.requireNonNull(dialogSelectTaxa);
                this.this$0 = dialogSelectTaxa;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jTableTaxa.setModel(this.model);
        this.jTableTaxa.setAutoResizeMode(4);
        this.jTableTaxa.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ DialogSelectTaxa this$0;
            {
                DialogSelectTaxa dialogSelectTaxa = this$0;
                Objects.requireNonNull(dialogSelectTaxa);
                this.this$0 = dialogSelectTaxa;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.this$0.jTableTaxaMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTableTaxa);
        this.jToolBar1.setRollover(true);
        this.buttonGroupSearchMode.add(this.jToggleButtonSearchQuick);
        this.jToggleButtonSearchQuick.setFont(new Font("Segoe UI", 1, 12));
        this.jToggleButtonSearchQuick.setText("Quick");
        this.jToggleButtonSearchQuick.setFocusable(false);
        this.jToggleButtonSearchQuick.setHorizontalTextPosition(0);
        this.jToggleButtonSearchQuick.setVerticalTextPosition(3);
        this.jToggleButtonSearchQuick.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectTaxa this$0;
            {
                DialogSelectTaxa dialogSelectTaxa = this$0;
                Objects.requireNonNull(dialogSelectTaxa);
                this.this$0 = dialogSelectTaxa;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jToggleButtonSearchQuickActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jToggleButtonSearchQuick);
        this.buttonGroupSearchMode.add(this.jToggleButtonSearchDetails);
        this.jToggleButtonSearchDetails.setFont(new Font("Segoe UI", 1, 12));
        this.jToggleButtonSearchDetails.setText("Detailed");
        this.jToggleButtonSearchDetails.setFocusable(false);
        this.jToggleButtonSearchDetails.setHorizontalTextPosition(0);
        this.jToggleButtonSearchDetails.setVerticalTextPosition(3);
        this.jToggleButtonSearchDetails.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectTaxa this$0;
            {
                DialogSelectTaxa dialogSelectTaxa = this$0;
                Objects.requireNonNull(dialogSelectTaxa);
                this.this$0 = dialogSelectTaxa;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jToggleButtonSearchDetailsActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jToggleButtonSearchDetails);
        this.jToolBar1.add(this.jSeparator3);
        this.jButtonDisc.setText("No discipline restriction");
        this.jButtonDisc.setFocusable(false);
        this.jButtonDisc.setHorizontalTextPosition(0);
        this.jButtonDisc.setVerticalTextPosition(3);
        this.jButtonDisc.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectTaxa this$0;
            {
                DialogSelectTaxa dialogSelectTaxa = this$0;
                Objects.requireNonNull(dialogSelectTaxa);
                this.this$0 = dialogSelectTaxa;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDiscActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonDisc);
        this.jToolBar1.add(this.jSeparator2);
        this.jButtonClear.setText("Clear ");
        this.jButtonClear.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectTaxa this$0;
            {
                DialogSelectTaxa dialogSelectTaxa = this$0;
                Objects.requireNonNull(dialogSelectTaxa);
                this.this$0 = dialogSelectTaxa;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonClearActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonClear);
        this.jButtonTrim.setText("Trim");
        this.jButtonTrim.setToolTipText("Trim the species field name to remove endings");
        this.jButtonTrim.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectTaxa this$0;
            {
                DialogSelectTaxa dialogSelectTaxa = this$0;
                Objects.requireNonNull(dialogSelectTaxa);
                this.this$0 = dialogSelectTaxa;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonTrimActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonTrim);
        this.jButtonSwap.setText("Swap");
        this.jButtonSwap.setToolTipText("Swap terms in genus and speices fields");
        this.jButtonSwap.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectTaxa this$0;
            {
                DialogSelectTaxa dialogSelectTaxa = this$0;
                Objects.requireNonNull(dialogSelectTaxa);
                this.this$0 = dialogSelectTaxa;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSwapActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonSwap);
        this.jButtonSearchGenus.setText("Search genus");
        this.jButtonSearchGenus.setToolTipText("Search for matches from GENUS fields only");
        this.jButtonSearchGenus.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectTaxa this$0;
            {
                DialogSelectTaxa dialogSelectTaxa = this$0;
                Objects.requireNonNull(dialogSelectTaxa);
                this.this$0 = dialogSelectTaxa;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSearchGenusActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonSearchGenus);
        this.jButtonSearchSpecies.setText("Search species");
        this.jButtonSearchSpecies.setToolTipText("Search for matches from SPECIES fields only");
        this.jButtonSearchSpecies.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectTaxa this$0;
            {
                DialogSelectTaxa dialogSelectTaxa = this$0;
                Objects.requireNonNull(dialogSelectTaxa);
                this.this$0 = dialogSelectTaxa;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSearchSpeciesActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonSearchSpecies);
        this.jButtonSearch.setFont(new Font("Segoe UI", 1, 12));
        this.jButtonSearch.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/resources/icon/search16.png")));
        this.jButtonSearch.setText("Search");
        this.jButtonSearch.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectTaxa this$0;
            {
                DialogSelectTaxa dialogSelectTaxa = this$0;
                Objects.requireNonNull(dialogSelectTaxa);
                this.this$0 = dialogSelectTaxa;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSearchActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonSearch);
        this.jToolBar1.add(this.jSeparator1);
        this.jButtonWebServices.setText("Search webservices...");
        this.jButtonWebServices.setToolTipText("Send query to selected webservices (e.g. Mikrotax/Nannotax, WoRMs, PBDB)");
        this.jButtonWebServices.setFocusable(false);
        this.jButtonWebServices.setHorizontalTextPosition(0);
        this.jButtonWebServices.setVerticalTextPosition(3);
        this.jButtonWebServices.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectTaxa this$0;
            {
                DialogSelectTaxa dialogSelectTaxa = this$0;
                Objects.requireNonNull(dialogSelectTaxa);
                this.this$0 = dialogSelectTaxa;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonWebServicesActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonWebServices);
        this.jButtonWsOptions.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/resources/icon/cog.png")));
        this.jButtonWsOptions.setFocusable(false);
        this.jButtonWsOptions.setHorizontalTextPosition(0);
        this.jButtonWsOptions.setVerticalTextPosition(3);
        this.jButtonWsOptions.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectTaxa this$0;
            {
                DialogSelectTaxa dialogSelectTaxa = this$0;
                Objects.requireNonNull(dialogSelectTaxa);
                this.this$0 = dialogSelectTaxa;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonWsOptionsActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonWsOptions);
        this.jButtonWebSearchEngine.setText("Web...");
        this.jButtonWebSearchEngine.setToolTipText("Send taxon search or selected results to search engine");
        this.jButtonWebSearchEngine.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectTaxa this$0;
            {
                DialogSelectTaxa dialogSelectTaxa = this$0;
                Objects.requireNonNull(dialogSelectTaxa);
                this.this$0 = dialogSelectTaxa;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonWebSearchEngineActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonWebSearchEngine);
        this.jToolBar1.add(this.jSeparator4);
        this.jButtonAdd.setText("Add...");
        this.jButtonAdd.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectTaxa this$0;
            {
                DialogSelectTaxa dialogSelectTaxa = this$0;
                Objects.requireNonNull(dialogSelectTaxa);
                this.this$0 = dialogSelectTaxa;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAddActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonAdd);
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add(0, 1112, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add(0, 107, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jToolBar1, -1, 1112, Short.MAX_VALUE).add((Component)this.jScrollPane1).add(1, (Component)this.jTextFieldTaxon).add((Component)this.jPanel2, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel))).add(10, 10, 10)));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonHelp, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jTextFieldTaxon, -2, -1, -2).addPreferredGap(0).add((Component)this.jToolBar1, -2, 25, -2).addPreferredGap(1).add((Component)this.jPanel2, -2, -1, -2).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 424, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonHelp).add((Component)this.jButtonOK)).addContainerGap()));
        this.pack();
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        Taxon taxon;
        TaxonService taxonService = this.db.getTaxonService();
        if (!(this.template == null || this.template.getSpecID() > 0 && this.template.equivalent((Taxon)taxonService.findTaxon(this.template.getSpecID()).orElse(null)))) {
            taxon = this.template;
        } else if (this.jTableTaxa.getSelectedRow() >= 0) {
            taxon = this.model.getTaxon(this.jTableTaxa.convertRowIndexToModel(this.jTableTaxa.getSelectedRow()));
        } else if (this.searchOptionStyle == SearchOptionStyle.DETAIL) {
            String genus = this.jTextFieldGenus.getText().replace('%', ' ').trim();
            if (this.template != null && this.template.getGenus().getGenusName().length() > genus.length()) {
                genus = this.template.getGenus().getGenusName();
            }
            String species = this.jTextFieldSpecies.getText().replace('%', ' ').trim();
            if (this.template != null && this.template.getSpecies().length() > species.length()) {
                species = this.template.getSpecies();
            }
            String subGenus = this.jTextFieldSubGenus.getText().replace('%', ' ').trim();
            if (this.template != null && this.template.getGenus().getSubGenus().length() > subGenus.length()) {
                subGenus = this.template.getGenus().getGenusName();
            }
            String subSpecies = this.jTextFieldSubSpecies.getText().replace('%', ' ').trim();
            if (this.template != null && this.template.getSubSpecies().length() > subSpecies.length()) {
                subSpecies = this.template.getSubSpecies();
            }
            String alphaCode = this.jTextFieldAlphaCode.getText().replace('%', ' ').trim();
            Category cat = this.categoryComboBox.getSelectedCategory().orElse(null);
            if (this.template != null && this.template.getGenus().getCategory() != null) {
                cat = this.template.getGenus().getCategory();
            }
            Genus g = new Genus();
            g.setCategory(cat);
            g.setGenusName(genus);
            g.setSubGenus(subGenus);
            taxon = new Taxon();
            taxon.setGenus(g);
            taxon.setSpecies(species);
            taxon.setSubSpecies(subSpecies);
            taxon.setAlphaCode(alphaCode);
            if (this.template != null) {
                if (this.template.getAuthor() != null && !this.template.getAuthor().isBlank()) {
                    taxon.setAuthor(this.template.getAuthor());
                }
                for (int pos = 0; pos < 7; ++pos) {
                    if (!this.template.getQualifier(pos).hasQuals()) continue;
                    if (pos > 3) {
                        taxon.setQualifier(pos, this.template.getQualifier(pos).copy());
                        continue;
                    }
                    taxon.getGenus().setQualifier(pos, this.template.getQualifier(pos).copy());
                }
            }
        } else {
            String text = this.jTextFieldKeyword.getText().trim();
            taxon = TaxonFactory.parse((String)text, (int)0, (TaxonFactory.ParseMode)TaxonFactory.ParseMode.LENIENT, (CategoryService)this.db.getCategoryService());
            if (taxon == null) {
                return;
            }
        }
        DialogTaxon dialog = DialogTaxon.newDialogTaxonToAddDomainTaxon((JDialog)((Object)this), true, this.db, taxon);
        dialog.setLocationRelativeTo((Component)((Object)this));
        dialog.setVisible(true);
        if (dialog.taxon != null) {
            this.selection = new ArrayList<Taxon>();
            this.selection.add(dialog.taxon.getTaxonCopy());
            this.dispose();
        }
    }

    private void jTableTaxaMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonOKActionPerformed(null);
        }
    }

    private void jButtonSearchActionPerformed(ActionEvent evt) {
        try {
            this.search(true, true);
        }
        catch (RuntimeException e) {
            SbugsExceptionHandler.showDialogStackError(e, (Component)((Object)this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void search(boolean useGenus, boolean useSpecies) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            String alphaCode;
            Category cat = useGenus ? (Category)this.categoryComboBox.getSelectedCategory().orElse(null) : null;
            String genus = useGenus ? this.jTextFieldGenus.getText() : "%";
            String species = useSpecies ? this.jTextFieldSpecies.getText() : "%";
            String subGenus = useGenus ? this.jTextFieldSubGenus.getText() : "%";
            String subSpecies = useSpecies ? this.jTextFieldSubSpecies.getText() : "%";
            String string = alphaCode = useGenus && useSpecies ? this.jTextFieldAlphaCode.getText() : "%";
            if (cat == null && genus.equals("%") && species.equals("%") && subGenus.equals("%") && subSpecies.equals("%") && alphaCode.equals("%")) {
                Object msg = "No search parameters specified. \nEntire ";
                msg = (String)msg + (this.disc != null ? "discipline" : "database");
                if (JOptionPane.showConfirmDialog((Component)((Object)this), msg = (String)msg + " search may take a long time. \nContinue?", this.getTitle(), 0) != 0) {
                    return;
                }
            }
            Taxon taxon = new Taxon();
            Genus g = new Genus();
            g.setCategory(cat);
            g.setGenusName(genus);
            g.setSubGenus(subGenus);
            taxon.setGenus(g);
            taxon.setSpecies(species);
            taxon.setSubSpecies(subSpecies);
            taxon.setAlphaCode(alphaCode);
            List matchingTaxa = this.db.getTaxonService().findMatchingTaxa(taxon, this.disc, SearchMode.SEARCH);
            if (matchingTaxa.isEmpty() && this.db.hasSoundex()) {
                String message = "No exact matches found. Search for similar sounding taxa?";
                int opt = DontAskMeAgainFactory.getConfirmOption("TXSOUNDEX", (Window)((Object)this), 0, message, this.getTitle(), 1);
                if (opt == 0) {
                    matchingTaxa = this.db.getTaxonService().findMatchingTaxa(taxon, this.disc, SearchMode.SOUNDEX);
                } else {
                    return;
                }
            }
            if (matchingTaxa.isEmpty()) {
                JOptionPane.showMessageDialog((Component)((Object)this), "No taxa found", this.getTitle(), 1);
                return;
            }
            this.model.setTaxa(matchingTaxa);
            this.model.fireTableDataChanged();
        }
        finally {
            this.getRootPane().setDefaultButton(this.jButtonOK);
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.jTableTaxa.getSelectedRowCount() == 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No selection", this.getTitle(), 2);
            return;
        }
        if (this.selectAndAddTaxa()) {
            String params = this.jTextFieldGenus.getText() + "|" + this.jTextFieldSubGenus.getText() + "|" + this.jTextFieldSpecies.getText() + "|" + this.jTextFieldSubSpecies.getText() + "|" + this.categoryComboBox.getSelectedMnemonic() + "|true";
            try {
                Lastval.putString(this.db, "TSEARCH", params);
                Lastval.putString(this.db, "TSEARCHCT", String.valueOf(this.disc != null ? Character.valueOf(this.disc.getChar()) : ""));
                this.model.putTableColumnWidths(this.db, this.jTableTaxa);
                this.db.commit();
            }
            catch (SQLException sql) {
                SbugsExceptionHandler.showStackError(sql, (Component)((Object)this));
            }
            dialogWidth = this.getWidth();
            dialogHeight = this.getHeight();
            this.setOK();
        }
    }

    private void jTextFieldAlphaCodeFocusGained(FocusEvent evt) {
        this.jTextFieldAlphaCode.setCaretPosition(0);
    }

    private void jTextFieldSubSpeciesFocusGained(FocusEvent evt) {
        this.jTextFieldSubSpecies.setCaretPosition(0);
    }

    private void jTextFieldSpeciesFocusGained(FocusEvent evt) {
        this.jTextFieldSpecies.setCaretPosition(0);
    }

    private void jTextFieldSubGenusFocusGained(FocusEvent evt) {
        this.jTextFieldSubGenus.setCaretPosition(0);
    }

    private void jTextFieldGenusFocusGained(FocusEvent evt) {
        this.jTextFieldGenus.setCaretPosition(0);
    }

    private void jButtonClearActionPerformed(ActionEvent evt) {
        this.categoryComboBox.setSelectedIndex(0);
        this.jTextFieldSpecies.setText("%");
        this.jTextFieldSubSpecies.setText("%");
        this.jTextFieldGenus.setText("%");
        this.jTextFieldSubGenus.setText("%");
        this.jTextFieldAlphaCode.setText("%");
    }

    private void jButtonSearchSpeciesActionPerformed(ActionEvent evt) {
        try {
            this.search(false, true);
        }
        catch (RuntimeException e) {
            SbugsExceptionHandler.showStackError(e, (Component)((Object)this));
        }
    }

    private void jButtonSearchGenusActionPerformed(ActionEvent evt) {
        try {
            this.search(true, false);
        }
        catch (RuntimeException e) {
            SbugsExceptionHandler.showStackError(e, (Component)((Object)this));
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        HelpUtils.openHelp((String)"dialogselecttaxa.html");
    }

    private void jButtonSwapActionPerformed(ActionEvent evt) {
        String gen = this.jTextFieldGenus.getText();
        String subGen = this.jTextFieldSubGenus.getText();
        String spec = this.jTextFieldSpecies.getText();
        String subSpec = this.jTextFieldSubSpecies.getText();
        this.jTextFieldGenus.setText(spec);
        this.jTextFieldSubGenus.setText(subSpec);
        this.jTextFieldSpecies.setText(gen);
        this.jTextFieldSubSpecies.setText(subGen);
    }

    private void jButtonTrimActionPerformed(ActionEvent evt) {
        String[] names = new String[]{this.jTextFieldSpecies.getText(), this.jTextFieldSubSpecies.getText()};
        String[] endings = new String[]{"ensis", "iorum", "iae", "us", "um", "is", "or", "us", "ii", "i", "ae", "a", "e"};
        for (int i = 0; i < names.length; ++i) {
            Object name = names[i];
            name = ((String)name).replace("%", "");
            for (String ending : endings) {
                if (((String)name).length() <= ending.length() || !((String)name).endsWith(ending)) continue;
                name = ((String)name).substring(0, ((String)name).length() - ending.length());
                break;
            }
            names[i] = name = (String)name + "%";
        }
        this.jTextFieldSpecies.setText(names[0]);
        this.jTextFieldSubSpecies.setText(names[1]);
    }

    private void jButtonWebSearchEngineActionPerformed(ActionEvent evt) {
        try {
            WebSearch webSearch = new WebSearch();
            int nRows = this.jTableTaxa.getSelectedRowCount();
            if (nRows == 0) {
                Object name = this.jTextFieldGenus.getText() + " " + this.jTextFieldSubGenus.getText() + " " + this.jTextFieldSpecies.getText() + " " + this.jTextFieldSubSpecies.getText();
                name = ((String)name).replaceAll("%", "").replaceAll("  ", " ");
                Desktop.getDesktop().browse(new URI(webSearch.getURL(this.db, (String)name)));
            } else {
                for (int row : this.jTableTaxa.getSelectedRows()) {
                    int index = this.jTableTaxa.convertRowIndexToModel(row);
                    String name = this.model.taxonList.get(index).taxon().toString(true, false);
                    name = webSearch.getURL(this.db, name);
                    URI uri = new URI(name);
                    Desktop.getDesktop().browse(uri);
                }
            }
        }
        catch (IOException | URISyntaxException | SQLException ex) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Error: " + ex.getMessage(), this.getTitle(), 2);
            LOGGER.log(Level.WARNING, "Error in taxon search: ", ex);
        }
    }

    private void jButtonWebServicesActionPerformed(ActionEvent evt) {
        if (this.webCitationService == null) {
            this.webCitationService = new WebCitationService(Lastval.tryGetString(this.db, "TXWEBSRV"), this.db.getCategoryService(), this.db.getGenusService());
        }
        try {
            List<WebCitationService.CitedTaxon> results = this.webCitationService.findTaxa(this.jTextFieldKeyword.getText());
            this.jLabelQuickSearchStatus.setText("Results from " + this.webCitationService.getSelectedServiceNames() + " (" + results.size() + ")");
            TableColumn column = this.jTableTaxa.getColumnModel().getColumn(9);
            if (results.size() > 0) {
                column.setMaxWidth(1000);
                if (column.getPreferredWidth() == 0) {
                    column.setPreferredWidth(150);
                }
            }
            this.model.setCitedTaxa(results);
            this.model.fireTableDataChanged();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jButtonWsOptionsActionPerformed(ActionEvent evt) {
        DialogConfigureWebCitationServices dialog = new DialogConfigureWebCitationServices((Dialog)((Object)this), true, this.db);
        dialog.setLocationRelativeTo((Component)((Object)this));
        dialog.setVisible(true);
        if (this.webCitationService != null) {
            this.webCitationService.updateServices(Lastval.tryGetString(this.db, "TXWEBSRV"));
        }
    }

    private void jButtonDiscActionPerformed(ActionEvent evt) {
        this.jPopupMenuDisc.show(this.jButtonDisc, 0, this.jButtonDisc.getHeight());
    }

    private void jToggleButtonSearchDetailsActionPerformed(ActionEvent evt) {
        this.setSearchOptionStyle(SearchOptionStyle.DETAIL);
    }

    private void jToggleButtonSearchQuickActionPerformed(ActionEvent evt) {
        this.setSearchOptionStyle(SearchOptionStyle.QUICK);
    }

    private void jRadioButtonMenuItemDiscNoneActionPerformed(ActionEvent evt) {
        this.setDiscipline(null);
    }

    private void jRadioButtonMenuItemMActionPerformed(ActionEvent evt) {
        this.setDiscipline(Discipline.MICRO);
    }

    private void jRadioButtonMenuItemPActionPerformed(ActionEvent evt) {
        this.setDiscipline(Discipline.PALY);
    }

    private void jRadioButtonMenuItemNActionPerformed(ActionEvent evt) {
        this.setDiscipline(Discipline.NANNO);
    }

    private void jRadioButtonMenuItemAActionPerformed(ActionEvent evt) {
        this.setDiscipline(Discipline.MACRO);
    }

    private void setSearchOptionStyle(SearchOptionStyle style) {
        if (style == this.searchOptionStyle) {
            return;
        }
        CardLayout layout = (CardLayout)this.jPanel2.getLayout();
        this.jButtonClear.setVisible(style == SearchOptionStyle.DETAIL);
        this.jButtonSwap.setVisible(style == SearchOptionStyle.DETAIL);
        this.jButtonTrim.setVisible(style == SearchOptionStyle.DETAIL);
        this.jButtonSearchGenus.setVisible(style == SearchOptionStyle.DETAIL);
        this.jButtonSearchSpecies.setVisible(style == SearchOptionStyle.DETAIL);
        this.jButtonSearch.setVisible(style == SearchOptionStyle.DETAIL);
        this.jButtonWebSearchEngine.setVisible(style == SearchOptionStyle.DETAIL);
        this.jSeparator1.setVisible(style == SearchOptionStyle.DETAIL);
        this.jButtonWebServices.setVisible(style == SearchOptionStyle.QUICK);
        this.jButtonWsOptions.setVisible(style == SearchOptionStyle.QUICK);
        if (style == SearchOptionStyle.QUICK) {
            layout.show(this.jPanel2, "quick");
        } else {
            layout.show(this.jPanel2, "detail");
        }
        this.searchOptionStyle = style;
        if (this.template == null) {
            NO_TEMPLATE_SEARCH_STYLE = style;
        }
    }

    private void initKeywordListener() {
        this.jTextFieldKeyword.getDocument().addDocumentListener(new DocumentListener(this){
            final /* synthetic */ DialogSelectTaxa this$0;
            {
                DialogSelectTaxa dialogSelectTaxa = this$0;
                Objects.requireNonNull(dialogSelectTaxa);
                this.this$0 = dialogSelectTaxa;
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.this$0.keywordsUpdated();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.this$0.keywordsUpdated();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
    }

    private void keywordsUpdated() {
        String text = this.jTextFieldKeyword.getText().trim();
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
        if (text.length() < 5) {
            return;
        }
        this.timer = new Timer(1500, new ActionListener(this){
            final /* synthetic */ DialogSelectTaxa this$0;
            {
                DialogSelectTaxa dialogSelectTaxa = this$0;
                Objects.requireNonNull(dialogSelectTaxa);
                this.this$0 = dialogSelectTaxa;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.searchKeyword();
            }
        });
        this.timer.setRepeats(false);
        this.timer.start();
    }

    private void searchKeyword() {
        Taxon taxon = TaxonFactory.parseForSearch((String)this.jTextFieldKeyword.getText(), (CategoryService)this.db.getCategoryService());
        if (taxon == null) {
            return;
        }
        this.jLabelQuickSearchStatus.setText("Searching dictionary: " + taxon.toString(false, true));
        LOGGER.info("Searching dictionary: " + taxon.toString(false, true));
        this.setCursor(Cursor.getPredefinedCursor(3));
        List matchingTaxa = null;
        try {
            matchingTaxa = this.db.getTaxonService().findMatchingTaxa(taxon, this.disc, SearchMode.SEARCH);
            this.model.setTaxa(matchingTaxa);
            this.model.fireTableDataChanged();
        }
        finally {
            this.jLabelQuickSearchStatus.setText("Results from local dictionary for \"" + taxon.toString(false, true) + "\" (" + matchingTaxa.size() + ")");
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private boolean selectAndAddTaxa() {
        ArrayList<Taxon> selectedTaxa = new ArrayList<Taxon>();
        for (int row : this.jTableTaxa.getSelectedRows()) {
            selectedTaxa.add(this.model.getTaxon(this.jTableTaxa.convertRowIndexToModel(row)));
        }
        this.selection = new ArrayList<Taxon>();
        this.selection.addAll(selectedTaxa.stream().filter(t -> t.getSpecID() > 0).toList());
        List<Taxon> taxaToAdd = selectedTaxa.stream().filter(t -> t.getSpecID() == 0).toList();
        if (!taxaToAdd.isEmpty()) {
            int opt = JOptionPane.showConfirmDialog((Component)((Object)this), "Add " + (String)(taxaToAdd.size() > 1 ? taxaToAdd.size() + " taxa" : "taxon") + " to dictionary?", "Import Taxa", 0, 3);
            if (opt != 0) {
                return false;
            }
            boolean exitStatus = true;
            for (Taxon taxon : taxaToAdd) {
                if (SbugsValidator.validate((Object)taxon, (SbugsValidator.ValidationStrategy)SbugsValidator.ValidationStrategy.IGNORE_ID).isValid()) {
                    TaxonAdd process = TaxonAdd.attemptAddWithoutConfirmations((TaxonService)this.db.getTaxonService(), (GenusService)this.db.getGenusService(), (Taxon)taxon);
                    switch (process.getResult().result()) {
                        case SUCCESS: {
                            this.selection.add((Taxon)this.db.getTaxonService().findTaxon(process.getSpecID()).get());
                            break;
                        }
                        case FAIL: {
                            JOptionPane.showMessageDialog((Component)((Object)this), process.getResult().resultMessage(), this.getTitle(), 2);
                            exitStatus = false;
                        }
                    }
                    continue;
                }
                DialogTaxon dialog = DialogTaxon.newDialogTaxonToAddDomainTaxon((JDialog)((Object)this), true, this.db, taxon);
                dialog.setLocationRelativeTo((Component)((Object)this));
                dialog.setVisible(true);
                if (dialog.taxon != null) {
                    this.selection.add(dialog.taxon.getTaxonCopy());
                    continue;
                }
                exitStatus = false;
                break;
            }
            return exitStatus;
        }
        return true;
    }

    private void setDiscipline(Discipline discID) {
        Category selectedCategory = this.categoryComboBox.getSelectedCategory().orElse(null);
        this.disc = discID;
        this.categoryComboBox.fill(discID);
        if (selectedCategory != null && (discID == null || selectedCategory.getDiscipline() == discID)) {
            this.categoryComboBox.setSelectedItem(selectedCategory);
        } else {
            this.categoryComboBox.setSelectedIndex(0);
        }
        if (discID == null) {
            this.jRadioButtonMenuItemDiscNone.setSelected(true);
            this.jButtonDisc.setText("All disciplines");
        } else {
            switch (discID) {
                case MICRO: {
                    this.jRadioButtonMenuItemM.setSelected(true);
                    break;
                }
                case NANNO: {
                    this.jRadioButtonMenuItemN.setSelected(true);
                    break;
                }
                case PALY: {
                    this.jRadioButtonMenuItemP.setSelected(true);
                    break;
                }
                case MACRO: {
                    this.jRadioButtonMenuItemA.setSelected(true);
                }
            }
            this.jButtonDisc.setText("Restricted to " + discID.getAbr(false));
        }
        discFilter = discID;
    }

    private ButtonModel getButtonModel(Discipline discID) {
        if (discID != null) {
            return switch (discID) {
                default -> throw new MatchException(null, null);
                case Discipline.MICRO -> this.jRadioButtonMenuItemM.getModel();
                case Discipline.NANNO -> this.jRadioButtonMenuItemN.getModel();
                case Discipline.PALY -> this.jRadioButtonMenuItemP.getModel();
                case Discipline.MACRO -> this.jRadioButtonMenuItemA.getModel();
            };
        }
        return null;
    }

    @Override
    public List<Taxon> getSelectedItems() {
        if (this.selection == null) {
            return Collections.emptyList();
        }
        return this.selection;
    }

    public int getSynSchID() {
        return this.model.getSynSchemeID();
    }

    static {
        discFilter = null;
        NO_TEMPLATE_SEARCH_STYLE = SearchOptionStyle.QUICK;
        LOGGER = Logger.getLogger(DialogSelectTaxa.class.getName());
    }

    private static enum SearchOptionStyle {
        QUICK,
        DETAIL;

    }
}

