/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import jsbugs.FrameJsbugs;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.SBdb;
import model3.Taxon;
import util.SB;
import util.exception.StackError;

public class DialogSelectTaxaCode
extends JDialog {
    SBdb db;
    HashMap<String, Integer> dictsMod = new HashMap();
    List<Taxon> selection = null;
    private JButton jButtonCancel;
    private JButton jButtonSearch;
    private JComboBox jComboBoxDict;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JTextField jTextFieldLower;
    private JTextField jTextFieldUpper;

    public DialogSelectTaxaCode(Frame parent, boolean modal, SBdb db) {
        super(parent, modal);
        this.initComponents();
        this.db = db;
        this.init();
    }

    private void init() {
        this.setTitle("Select Taxa by Numeric Code");
        this.getRootPane().setDefaultButton(this.jButtonSearch);
        try {
            HashMap<Integer, String> dicts = this.db.getSIPMDicts();
            Set<Map.Entry<Integer, String>> set = dicts.entrySet();
            for (Map.Entry<Integer, String> entry : set) {
                this.jComboBoxDict.addItem(entry.getValue());
                this.dictsMod.put(entry.getValue(), entry.getKey());
            }
        }
        catch (SQLException sql) {
            SbugsExceptionHandler.showStackError(sql, null);
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jComboBoxDict = new JComboBox();
        this.jButtonCancel = new JButton();
        this.jButtonSearch = new JButton();
        this.jPanel1 = new JPanel();
        this.jTextFieldUpper = new JTextField();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jTextFieldLower = new JTextField();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jLabel1.setText("Dictionary:");
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectTaxaCode this$0;
            {
                DialogSelectTaxaCode dialogSelectTaxaCode = this$0;
                Objects.requireNonNull(dialogSelectTaxaCode);
                this.this$0 = dialogSelectTaxaCode;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonSearch.setText("Search");
        this.jButtonSearch.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectTaxaCode this$0;
            {
                DialogSelectTaxaCode dialogSelectTaxaCode = this$0;
                Objects.requireNonNull(dialogSelectTaxaCode);
                this.this$0 = dialogSelectTaxaCode;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSearchActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Search between codes:", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.jTextFieldUpper.setToolTipText("Leave one field blank to find exact match");
        this.jTextFieldUpper.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogSelectTaxaCode this$0;
            {
                DialogSelectTaxaCode dialogSelectTaxaCode = this$0;
                Objects.requireNonNull(dialogSelectTaxaCode);
                this.this$0 = dialogSelectTaxaCode;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldUpperKeyTyped(evt);
            }
        });
        this.jLabel2.setText("Upper:");
        this.jLabel3.setText("Lower:");
        this.jTextFieldLower.setToolTipText("Leave one field blank to find exact match");
        this.jTextFieldLower.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogSelectTaxaCode this$0;
            {
                DialogSelectTaxaCode dialogSelectTaxaCode = this$0;
                Objects.requireNonNull(dialogSelectTaxaCode);
                this.this$0 = dialogSelectTaxaCode;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldLowerKeyTyped(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldLower)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldUpper))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldLower, -2, -1, -2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldUpper, -2, -1, -2).addComponent(this.jLabel2)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxDict, 0, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 97, -2).addComponent(this.jButtonSearch).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jComboBoxDict, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonSearch)).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jTextFieldUpperKeyTyped(KeyEvent evt) {
        if (SB.intFieldVal((JTextField)this.jTextFieldUpper, (int)10, (KeyEvent)evt, (boolean)false)) {
            this.getToolkit().beep();
        }
    }

    private void jButtonSearchActionPerformed(ActionEvent evt) {
        if (this.jTextFieldUpper.getText().trim().isEmpty() && this.jTextFieldLower.getText().trim().isEmpty()) {
            JOptionPane.showMessageDialog(this, "Enter at least one code", this.getTitle(), 2);
            return;
        }
        int upperCode = -1;
        if (!this.jTextFieldUpper.getText().trim().isEmpty()) {
            upperCode = Integer.parseInt(this.jTextFieldUpper.getText().trim());
        }
        int lowerCode = -1;
        if (!this.jTextFieldLower.getText().trim().isEmpty()) {
            lowerCode = Integer.parseInt(this.jTextFieldLower.getText().trim());
        }
        if (upperCode < 0 && lowerCode < 0) {
            JOptionPane.showMessageDialog(this, "Enter at least one code", this.getTitle(), 2);
            return;
        }
        int ccode = this.dictsMod.get((String)this.jComboBoxDict.getSelectedItem());
        try {
            this.selection = Taxon.search(this.db, upperCode, lowerCode, ccode);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("Error searching for taxa: ", sql, this.db);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
        if (this.selection == null || this.selection.isEmpty()) {
            JOptionPane.showMessageDialog(this, "No taxa found", this.getTitle(), 1);
        }
        this.dispose();
    }

    private void jTextFieldLowerKeyTyped(KeyEvent evt) {
        if (SB.intFieldVal((JTextField)this.jTextFieldLower, (int)10, (KeyEvent)evt, (boolean)false)) {
            this.getToolkit().beep();
        }
    }
}

