/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.util.ui.SBDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import jsbugs.DialogUnit;
import jsbugs.FrameJsbugs;
import model3.IGDScheme;
import model3.IGDUnitBase;
import org.jdesktop.layout.GroupLayout;
import util.SbugsOptionToggle;
import util.exception.StackError;

public class DialogSelectUnit
extends SBDialog {
    private final IGDScheme scheme;
    private final DefaultListModel model = new DefaultListModel();
    private static HashMap<Integer, IGDUnitBase> last = new HashMap();
    IGDUnitBase selection = null;
    private JButton jButtonAdd;
    private JButton jButtonCancel;
    private JButton jButtonDelete;
    private JButton jButtonEdit;
    private JButton jButtonOK;
    private JList jListUnits;
    private JScrollPane jScrollPane1;
    private JToggleButton jToggleButton1;

    public DialogSelectUnit(JDialog parent, boolean modal, IGDScheme scheme, IGDUnitBase initialSelection) throws SQLException {
        super((Window)parent, modal);
        this.scheme = scheme;
        this.setTitle("Unit : Select");
        this.initComponents();
        this.init(initialSelection);
    }

    public DialogSelectUnit(JFrame parent, boolean modal, IGDScheme scheme, IGDUnitBase initialSelection) throws SQLException {
        super((Frame)parent, modal);
        this.scheme = scheme;
        this.setTitle("Unit : Select");
        this.initComponents();
        this.init(initialSelection);
    }

    private void init(IGDUnitBase initialSelection) throws SQLException {
        this.scheme.loadUnits();
        this.jListUnits.setSelectionMode(0);
        this.loadUnits(initialSelection == null ? last.get(this.scheme.getID()) : initialSelection);
        this.getRootPane().setDefaultButton(this.jButtonOK);
        ((SbugsOptionToggle)this.jToggleButton1).addComponents(false, new JComponent[]{this.jButtonAdd, this.jButtonEdit, this.jButtonDelete});
    }

    private void loadUnits(IGDUnitBase initialSelection) {
        String selector = null;
        this.model.clear();
        this.model.addElement(" ");
        for (IGDUnitBase unit : this.scheme.getUnitBases()) {
            Object hier = "";
            for (int i = 0; i < unit.getHier(); ++i) {
                hier = (String)hier + "  ";
            }
            if (initialSelection == unit) {
                selector = (String)hier + String.valueOf(unit);
            }
            this.model.addElement((String)hier + String.valueOf(unit));
        }
        this.jListUnits.setSelectedValue(selector, true);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jListUnits = new JList();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonAdd = new JButton();
        this.jButtonEdit = new JButton();
        this.jButtonDelete = new JButton();
        this.jToggleButton1 = new SbugsOptionToggle();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(325, 375));
        this.setModal(true);
        this.jListUnits.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.jListUnits.setModel(this.model);
        this.jListUnits.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ DialogSelectUnit this$0;
            {
                DialogSelectUnit dialogSelectUnit = this$0;
                Objects.requireNonNull(dialogSelectUnit);
                this.this$0 = dialogSelectUnit;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.this$0.jListUnitsMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jListUnits);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectUnit this$0;
            {
                DialogSelectUnit dialogSelectUnit = this$0;
                Objects.requireNonNull(dialogSelectUnit);
                this.this$0 = dialogSelectUnit;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectUnit this$0;
            {
                DialogSelectUnit dialogSelectUnit = this$0;
                Objects.requireNonNull(dialogSelectUnit);
                this.this$0 = dialogSelectUnit;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonAdd.setText("Add...");
        this.jButtonAdd.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectUnit this$0;
            {
                DialogSelectUnit dialogSelectUnit = this$0;
                Objects.requireNonNull(dialogSelectUnit);
                this.this$0 = dialogSelectUnit;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAddActionPerformed(evt);
            }
        });
        this.jButtonEdit.setText("Edit...");
        this.jButtonEdit.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectUnit this$0;
            {
                DialogSelectUnit dialogSelectUnit = this$0;
                Objects.requireNonNull(dialogSelectUnit);
                this.this$0 = dialogSelectUnit;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonEditActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectUnit this$0;
            {
                DialogSelectUnit dialogSelectUnit = this$0;
                Objects.requireNonNull(dialogSelectUnit);
                this.this$0 = dialogSelectUnit;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jToggleButton1.setText(">");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -1, 238, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(3, 3, 3).add((Component)this.jToggleButton1, -2, 40, -2)).add((GroupLayout.Group)layout.createSequentialGroup().add(2, 2, 2).add((GroupLayout.Group)layout.createParallelGroup(1, false).add(2, (Component)this.jButtonAdd, -1, -1, Short.MAX_VALUE).add(2, (Component)this.jButtonDelete, -1, 85, Short.MAX_VALUE).add(2, (Component)this.jButtonEdit, -1, -1, Short.MAX_VALUE))).add((GroupLayout.Group)layout.createParallelGroup(2, false).add(1, (Component)this.jButtonCancel, -1, -1, Short.MAX_VALUE).add(1, (Component)this.jButtonOK, -1, 86, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jToggleButton1).addPreferredGap(0).add((Component)this.jButtonAdd).addPreferredGap(0).add((Component)this.jButtonEdit).addPreferredGap(0).add((Component)this.jButtonDelete).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonCancel)).add((Component)this.jScrollPane1, -1, 338, Short.MAX_VALUE)).addContainerGap()));
        this.pack();
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        if (this.jListUnits.getSelectedIndex() < 1) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Select a unit from the list", this.getTitle(), 2);
            return;
        }
        try {
            this.selection = this.scheme.getUnitBases().get(this.jListUnits.getSelectedIndex() - 1);
            if (this.selection.getNoccs(true) > 0) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Unit occurs " + this.selection.getNoccs(false) + " times, you cannot delete this unit here", this.getTitle(), 2);
                return;
            }
            if (JOptionPane.showConfirmDialog((Component)((Object)this), "Are you sure you want to delete " + this.selection.getName() + "?", this.getTitle(), 0, 2) != 0) {
                return;
            }
            this.scheme.deleteUnit(this.selection);
            this.scheme.getDatabase().commit();
            this.loadUnits(null);
        }
        catch (SQLException sql) {
            this.scheme.getDatabase().doRollback();
            FrameJsbugs.showStackError("SQL Error", sql, this.scheme.getDatabase());
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void jListUnitsMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonOKActionPerformed(null);
        }
    }

    private void jButtonEditActionPerformed(ActionEvent evt) {
        if (this.jListUnits.getSelectedIndex() < 1) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Select a unit from the list", this.getTitle(), 2);
            return;
        }
        try {
            this.selection = this.scheme.getUnitBases().get(this.jListUnits.getSelectedIndex() - 1);
            if (this.selection.getNoccs(true) > 0 && JOptionPane.showConfirmDialog((Component)((Object)this), "Unit occurs " + this.selection.getNoccs(false) + " times, are you sure you want to edit it?", this.getTitle(), 0, 2) != 0) {
                return;
            }
            DialogUnit dialog = new DialogUnit((JDialog)((Object)this), true, this.scheme, this.selection);
            dialog.setLocationRelativeTo((Component)((Object)this));
            dialog.setVisible(true);
            if (dialog.isOK()) {
                this.loadUnits(dialog.unit);
            }
        }
        catch (SQLException sql) {
            this.scheme.getDatabase().doRollback();
            FrameJsbugs.showStackError("SQL Error", sql, this.scheme.getDatabase());
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        DialogUnit dialog = new DialogUnit((JDialog)((Object)this), true, this.scheme, null);
        dialog.setLocationRelativeTo((Component)((Object)this));
        dialog.setVisible(true);
        if (dialog.unit != null) {
            this.loadUnits(dialog.unit);
        }
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.jListUnits.getSelectedIndex() < 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Select a unit from the list", this.getTitle(), 2);
            return;
        }
        int index = this.jListUnits.getSelectedIndex();
        if (index == 0) {
            this.selection = null;
        } else {
            this.selection = this.scheme.getUnitBases().get(index - 1);
            last.put(this.scheme.getID(), this.selection);
        }
        this.setOK();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.selection = null;
        this.dispose();
    }
}

