/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.util.ui.SBDialog;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import jsbchart.util.colour.ColourSpectrum;

public class DialogSpectrum
extends SBDialog {
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JSlider jSliderBrightness;
    private JSlider jSliderHueL;
    private JSlider jSliderHueR;
    private JSlider jSliderSaturation;
    private JPanel previewPanel;

    public DialogSpectrum(Frame parent, boolean modal, ColourSpectrum spectrum, boolean showSaturationAndBrightness) {
        super(parent, modal);
        this.initComponents();
        this.jSliderHueL.setValue((int)(spectrum.hueLeft() * 360.0f));
        this.jSliderHueR.setValue((int)(spectrum.hueRight() * 360.0f));
        this.jSliderSaturation.setValue((int)(spectrum.saturation() * 360.0f));
        this.jSliderBrightness.setValue((int)(spectrum.brightness() * 360.0f));
        ChangeListener changeListener = e -> this.refreshPreview();
        this.jSliderHueL.addChangeListener(changeListener);
        this.jSliderHueR.addChangeListener(changeListener);
        this.jSliderBrightness.addChangeListener(changeListener);
        this.jSliderSaturation.addChangeListener(changeListener);
        if (!showSaturationAndBrightness) {
            this.jSliderSaturation.setEnabled(false);
            this.jSliderBrightness.setEnabled(false);
        }
        this.refreshPreview();
        this.setTitle("Colour Spectrum");
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    private void refreshPreview() {
        ((SpectrumPanel)this.previewPanel).setHues();
        this.previewPanel.repaint();
    }

    public ColourSpectrum getSpectrum() {
        return new ColourSpectrum((float)this.jSliderHueL.getValue() / 360.0f, (float)this.jSliderHueR.getValue() / 360.0f, (float)this.jSliderSaturation.getValue() / 360.0f, (float)this.jSliderBrightness.getValue() / 360.0f);
    }

    private void initComponents() {
        this.jPanel4 = new JPanel();
        this.previewPanel = new SpectrumPanel(this);
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jPanel5 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jSliderSaturation = new JSlider();
        this.jLabel4 = new JLabel();
        this.jSliderBrightness = new JSlider();
        this.jSliderHueL = new JSlider();
        this.jSliderHueR = new JSlider();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createTitledBorder(""), "Preview", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.previewPanel.setBorder(BorderFactory.createEtchedBorder());
        GroupLayout previewPanelLayout = new GroupLayout(this.previewPanel);
        this.previewPanel.setLayout(previewPanelLayout);
        previewPanelLayout.setHorizontalGroup(previewPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        previewPanelLayout.setVerticalGroup(previewPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 26, Short.MAX_VALUE));
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addComponent(this.previewPanel, -1, -1, Short.MAX_VALUE).addGap(11, 11, 11)));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addComponent(this.previewPanel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSpectrum this$0;
            {
                DialogSpectrum dialogSpectrum = this$0;
                Objects.requireNonNull(dialogSpectrum);
                this.this$0 = dialogSpectrum;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSpectrum this$0;
            {
                DialogSpectrum dialogSpectrum = this$0;
                Objects.requireNonNull(dialogSpectrum);
                this.this$0 = dialogSpectrum;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jLabel3.setText("Saturation:");
        this.jSliderSaturation.setMaximum(360);
        this.jLabel4.setText("Brightness:");
        this.jSliderBrightness.setMaximum(360);
        this.jSliderHueL.setMaximum(360);
        this.jSliderHueR.setMaximum(360);
        this.jLabel5.setText("Left hue:");
        this.jLabel6.setText("Right hue:");
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addGap(10, 10, 10).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel5).addComponent(this.jLabel6).addComponent(this.jLabel3).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSliderBrightness, -1, 288, Short.MAX_VALUE).addComponent(this.jSliderSaturation, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jSliderHueL, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jSliderHueR, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel5Layout.createSequentialGroup().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel5)).addComponent(this.jSliderHueL, -2, 30, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSliderHueR, -2, 30, -2).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSliderSaturation, -2, 28, -2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSliderBrightness, -2, 28, -2).addComponent(this.jLabel4)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel5Layout.linkSize(1, this.jSliderBrightness, this.jSliderHueL, this.jSliderHueR, this.jSliderSaturation);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel5, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel))).addContainerGap()));
        layout.linkSize(0, this.jButtonCancel, this.jButtonOK);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel5, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel4, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonOK)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        this.setOK();
    }

    private class SpectrumPanel
    extends JPanel {
        private Color[] hues;
        final /* synthetic */ DialogSpectrum this$0;

        private SpectrumPanel(DialogSpectrum dialogSpectrum) {
            DialogSpectrum dialogSpectrum2 = dialogSpectrum;
            Objects.requireNonNull(dialogSpectrum2);
            this.this$0 = dialogSpectrum2;
        }

        void setHues() {
            ColourSpectrum spectrum = this.this$0.getSpectrum();
            this.hues = spectrum.getColours();
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.hues == null) {
                return;
            }
            int sectionWidth = this.getWidth() / 12;
            int margin = this.getWidth() - sectionWidth * 12;
            margin /= 2;
            for (int i = 0; i < 12; ++i) {
                g.setColor(this.hues[i]);
                g.fillRect(margin + i * sectionWidth, margin, sectionWidth, this.getHeight() - margin * 2);
            }
        }
    }
}

