/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.util.ui.SBDialog;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.util.Objects;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import jsbugs.FrameJsbugs;
import model3.IGDScheme;
import model3.SBdb;
import model3.Surface;
import util.InvalidFieldException;
import util.SB;
import util.SBException;
import util.exception.StackError;

public class DialogSurface
extends SBDialog {
    private final SBdb sbdb;
    private final Surface surface;
    private final IGDScheme scheme;
    private final DefaultComboBoxModel typeModel = new DefaultComboBoxModel<Surface.SurfaceType>(Surface.SurfaceType.values());
    private final DefaultComboBoxModel magModel = new DefaultComboBoxModel<Surface.Magnitude>(Surface.Magnitude.values());
    private static final int AGELEN = 8;
    private static final int NAMELEN = 80;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JComboBox jComboBoxMagnitude;
    private JComboBox jComboBoxType;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabelMag;
    private JSeparator jSeparator1;
    private JTextField jTextFieldAge;
    private JTextField jTextFieldName;

    public DialogSurface(Frame parent, boolean modal, Surface surface, IGDScheme scheme) {
        super(parent, modal);
        this.initComponents();
        this.surface = surface;
        this.scheme = scheme;
        this.sbdb = scheme.getDatabase();
        this.init();
    }

    private void init() {
        this.setTitle("Edit Surface : " + String.valueOf(this.surface));
        this.jTextFieldName.setText(this.surface.getName());
        this.jComboBoxType.setSelectedItem((Object)this.surface.getType());
        this.enableMag();
        if (this.jComboBoxMagnitude.isEnabled()) {
            this.jComboBoxMagnitude.setSelectedItem((Object)Surface.Magnitude.getMagnitude(this.surface.getMagnitude()));
        }
        this.jTextFieldAge.setText("" + this.surface.getAge());
        try {
            if (!this.scheme.canWrite(this.sbdb, null)) {
                this.jButtonOK.setEnabled(false);
                this.jButtonOK.setToolTipText("This scheme is read-only");
            } else {
                this.getRootPane().setDefaultButton(this.jButtonOK);
            }
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
        }
    }

    private void enableMag() {
        boolean enable = this.jComboBoxType.getSelectedItem() == Surface.SurfaceType.MFS;
        this.jComboBoxMagnitude.setEnabled(enable);
        this.jLabelMag.setEnabled(enable);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jLabel2 = new JLabel();
        this.jComboBoxType = new JComboBox();
        this.jLabelMag = new JLabel();
        this.jLabel4 = new JLabel();
        this.jComboBoxMagnitude = new JComboBox();
        this.jTextFieldAge = new JTextField();
        this.jSeparator1 = new JSeparator();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jLabel5 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jLabel1.setText("Name:");
        this.jTextFieldName.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogSurface this$0;
            {
                DialogSurface dialogSurface = this$0;
                Objects.requireNonNull(dialogSurface);
                this.this$0 = dialogSurface;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldNameKeyTyped(evt);
            }
        });
        this.jLabel2.setText("Type:");
        this.jComboBoxType.setModel(this.typeModel);
        this.jComboBoxType.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSurface this$0;
            {
                DialogSurface dialogSurface = this$0;
                Objects.requireNonNull(dialogSurface);
                this.this$0 = dialogSurface;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jComboBoxTypeActionPerformed(evt);
            }
        });
        this.jLabelMag.setText("Magnitude:");
        this.jLabel4.setText("Age:");
        this.jComboBoxMagnitude.setModel(this.magModel);
        this.jTextFieldAge.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogSurface this$0;
            {
                DialogSurface dialogSurface = this$0;
                Objects.requireNonNull(dialogSurface);
                this.this$0 = dialogSurface;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldAgeKeyTyped(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSurface this$0;
            {
                DialogSurface dialogSurface = this$0;
                Objects.requireNonNull(dialogSurface);
                this.this$0 = dialogSurface;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSurface this$0;
            {
                DialogSurface dialogSurface = this$0;
                Objects.requireNonNull(dialogSurface);
                this.this$0 = dialogSurface;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jLabel5.setText("Ma");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jTextFieldName).addComponent(this.jComboBoxType, -2, 104, -2))).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel4).addComponent(this.jLabelMag)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jComboBoxMagnitude, -2, 104, -2).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jTextFieldAge).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel5)))).addComponent(this.jSeparator1))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.linkSize(0, this.jButtonCancel, this.jButtonOK);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jTextFieldName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jComboBoxType, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelMag).addComponent(this.jComboBoxMagnitude, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.jTextFieldAge, -2, -1, -2).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonOK)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        try {
            Surface.Builder builder = Surface.Builder.copyOf(this.sbdb, this.surface);
            String name = this.jTextFieldName.getText();
            if (name.isEmpty()) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Enter a surface name", "Warning", 2);
                return;
            }
            builder.name(name);
            builder.type((Surface.SurfaceType)((Object)this.jComboBoxType.getSelectedItem()));
            builder.magnitude(((Surface.Magnitude)((Object)this.jComboBoxMagnitude.getSelectedItem())).getValue());
            builder.age(Double.parseDouble(this.jTextFieldAge.getText()));
            this.scheme.updateSurface(builder);
            this.setOK();
        }
        catch (InvalidFieldException ife) {
            JOptionPane.showMessageDialog((Component)((Object)this), ife.getMessage(), this.getTitle(), 2);
        }
        catch (SQLException sql) {
            this.sbdb.doRollback();
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
        catch (SBException sbe) {
            this.sbdb.doRollback();
            StackError.showStackError((String)"Error", (Throwable)sbe);
        }
    }

    private void jComboBoxTypeActionPerformed(ActionEvent evt) {
        this.enableMag();
    }

    private void jTextFieldNameKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldName, (int)80, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldAgeKeyTyped(KeyEvent evt) {
        if (SB.floatFieldVal((JTextField)this.jTextFieldAge, (int)8, (KeyEvent)evt, (boolean)false)) {
            this.getToolkit().beep();
        }
    }
}

