/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Dialog;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import model3.IGDIntervalZone;
import model3.IGDScheme;
import model3.IGDUnitBase;
import model3.SBdb;
import model3.Well;
import model3.WellInterp;
import util.SBException;
import util.exception.StackError;

public class DialogSwitchIGDterms
extends JDialog {
    DefaultListModel<String> model = new DefaultListModel();
    boolean isOK = false;
    SBdb db;
    private ButtonGroup buttonGroup1;
    private JButton jButtonAdd;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JButton jButtonRemove;
    private JCheckBox jCheckBoxBiozone;
    private JCheckBox jCheckBoxChrono;
    private JCheckBox jCheckBoxInformal;
    private JCheckBox jCheckBoxLstrat;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabelExample;
    private JList<String> jListTerms;
    private JPanel jPanel1;
    private JRadioButton jRadioButtonPrefix;
    private JRadioButton jRadioButtonSuffix;
    private JScrollPane jScrollPane2;

    public DialogSwitchIGDterms(JDialog parent, boolean modal, SBdb db) {
        super((Dialog)parent, modal);
        this.db = db;
        this.initComponents();
        this.init();
    }

    private void init() {
        String[] strings;
        this.setTitle("IGD Term Switcher");
        for (String s : strings = new String[]{"Middle", "Early", "Late", "Upper", "Lower"}) {
            this.model.addElement(s);
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jLabel3 = new JLabel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jCheckBoxChrono = new JCheckBox();
        this.jCheckBoxBiozone = new JCheckBox();
        this.jCheckBoxLstrat = new JCheckBox();
        this.jButtonAdd = new JButton();
        this.jButtonRemove = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jRadioButtonPrefix = new JRadioButton();
        this.jRadioButtonSuffix = new JRadioButton();
        this.jScrollPane2 = new JScrollPane();
        this.jListTerms = new JList();
        this.jCheckBoxInformal = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.jLabelExample = new JLabel();
        this.jLabel3.setText("jLabel3");
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jLabel1.setText("Switch between prefixes and suffixes for workspace units:");
        this.jLabel2.setText("Apply to:");
        this.jCheckBoxChrono.setText("Chronostratigraphy");
        this.jCheckBoxBiozone.setText("Biozones");
        this.jCheckBoxLstrat.setText("Lithostratigraphy");
        this.jButtonAdd.setText("Add term...");
        this.jButtonAdd.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSwitchIGDterms this$0;
            {
                DialogSwitchIGDterms dialogSwitchIGDterms = this$0;
                Objects.requireNonNull(dialogSwitchIGDterms);
                this.this$0 = dialogSwitchIGDterms;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAddActionPerformed(evt);
            }
        });
        this.jButtonRemove.setText("Remove term");
        this.jButtonRemove.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSwitchIGDterms this$0;
            {
                DialogSwitchIGDterms dialogSwitchIGDterms = this$0;
                Objects.requireNonNull(dialogSwitchIGDterms);
                this.this$0 = dialogSwitchIGDterms;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonRemoveActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSwitchIGDterms this$0;
            {
                DialogSwitchIGDterms dialogSwitchIGDterms = this$0;
                Objects.requireNonNull(dialogSwitchIGDterms);
                this.this$0 = dialogSwitchIGDterms;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSwitchIGDterms this$0;
            {
                DialogSwitchIGDterms dialogSwitchIGDterms = this$0;
                Objects.requireNonNull(dialogSwitchIGDterms);
                this.this$0 = dialogSwitchIGDterms;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioButtonPrefix);
        this.jRadioButtonPrefix.setText("<html>Use terms as <strrong>Prefixes</strong></html>");
        this.jRadioButtonPrefix.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSwitchIGDterms this$0;
            {
                DialogSwitchIGDterms dialogSwitchIGDterms = this$0;
                Objects.requireNonNull(dialogSwitchIGDterms);
                this.this$0 = dialogSwitchIGDterms;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonPrefixActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioButtonSuffix);
        this.jRadioButtonSuffix.setText("Use terms as Suffixes");
        this.jRadioButtonSuffix.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSwitchIGDterms this$0;
            {
                DialogSwitchIGDterms dialogSwitchIGDterms = this$0;
                Objects.requireNonNull(dialogSwitchIGDterms);
                this.this$0 = dialogSwitchIGDterms;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonSuffixActionPerformed(evt);
            }
        });
        this.jListTerms.setModel(this.model);
        this.jListTerms.setSelectionMode(0);
        this.jScrollPane2.setViewportView(this.jListTerms);
        this.jCheckBoxInformal.setSelected(true);
        this.jCheckBoxInformal.setText("Include informal terms");
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Example", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.jLabelExample.setFont(new Font("Tahoma", 1, 11));
        this.jLabelExample.setText("Late Cretaceous");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelExample, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGap(0, 17, Short.MAX_VALUE).addComponent(this.jLabelExample)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxBiozone, GroupLayout.Alignment.TRAILING).addComponent(this.jCheckBoxLstrat, GroupLayout.Alignment.TRAILING).addComponent(this.jCheckBoxInformal).addComponent(this.jCheckBoxChrono)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addGap(93, 93, 93))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addGap(112, 112, 112).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonCancel).addComponent(this.jButtonOK))).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)))).addComponent(this.jLabel1))).addGroup(layout.createSequentialGroup().addGap(18, 18, 18).addComponent(this.jScrollPane2, -2, 129, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButtonSuffix).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButtonRemove, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonAdd, -1, -1, Short.MAX_VALUE).addComponent(this.jRadioButtonPrefix, -2, -1, -2))))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.linkSize(0, this.jButtonCancel, this.jButtonOK);
        layout.linkSize(0, this.jCheckBoxBiozone, this.jCheckBoxChrono, this.jCheckBoxInformal, this.jCheckBoxLstrat);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jButtonAdd).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonRemove).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonPrefix, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonSuffix)).addComponent(this.jScrollPane2, -2, 141, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxChrono).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxBiozone).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxLstrat).addGap(14, 14, 14).addComponent(this.jCheckBoxInformal)).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonCancel))).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButtonRemoveActionPerformed(ActionEvent evt) {
        String term = this.jListTerms.getSelectedValue();
        if (term == null) {
            JOptionPane.showMessageDialog(this, "Select an item in the list to remove", this.getTitle(), 1);
            return;
        }
        DefaultListModel m = (DefaultListModel)this.jListTerms.getModel();
        m.removeElement(term);
        this.jListTerms.repaint();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.buttonGroup1.getSelection() == null) {
            JOptionPane.showMessageDialog(this, "Select prefix/suffix option");
            return;
        }
        if (!(this.jCheckBoxBiozone.isSelected() || this.jCheckBoxChrono.isSelected() || this.jCheckBoxLstrat.isSelected())) {
            JOptionPane.showMessageDialog(this, "No data types selected for switching!");
            return;
        }
        LinkedList<Integer> typesSelected = new LinkedList<Integer>();
        if (this.jCheckBoxBiozone.isSelected()) {
            typesSelected.add(4);
        }
        if (this.jCheckBoxChrono.isSelected()) {
            typesSelected.add(3);
        }
        if (this.jCheckBoxLstrat.isSelected()) {
            typesSelected.add(2);
        }
        try {
            int nWellTermsSwitched = 0;
            Iterator<Well> wells = this.db.getWellIterator();
            while (wells.hasNext()) {
                Well well = wells.next();
                Iterator<WellInterp> it = well.getInterpIterator();
                while (it.hasNext()) {
                    WellInterp wellInterp = it.next();
                    Iterator<Object> iterator = typesSelected.iterator();
                    while (iterator.hasNext()) {
                        int igdType = (Integer)iterator.next();
                        List<IGDIntervalZone> zones = wellInterp.getIGDList(igdType);
                        if (zones == null) continue;
                        for (IGDIntervalZone zone : zones) {
                            String newName;
                            String unitName;
                            IGDScheme scheme = this.db.getIGDScheme(zone.getSchID());
                            IGDUnitBase unit = scheme.findUnitBase(zone.getUppZone());
                            String string = unitName = unit != null ? unit.getName() : "";
                            if (zone.getUppInf() != null && zone.getUppInf().length() > 0 && (zone.getUppInf().equalsIgnoreCase(unitName) || this.jCheckBoxInformal.isSelected()) && (newName = this.switchTerm(zone.getUppInf())) != null) {
                                zone.setUppInf(newName);
                                ++nWellTermsSwitched;
                            }
                            String string2 = unitName = (unit = scheme.findUnitBase(zone.getLowZone())) != null ? unit.getName() : "";
                            if (zone.getLowInf() == null || zone.getLowInf().length() <= 0 || !zone.getLowInf().equalsIgnoreCase(unitName) && !this.jCheckBoxInformal.isSelected() || (newName = this.switchTerm(zone.getUppInf())) == null) continue;
                            zone.setLowInf(newName);
                            ++nWellTermsSwitched;
                        }
                    }
                }
            }
            JOptionPane.showMessageDialog(this, "Number of terms switched in well(s): " + nWellTermsSwitched, this.getTitle(), 1);
            Iterator<IGDScheme> schIt = this.db.getIGDSchemes().iterator();
            int nSchemeTermsSwitched = 0;
            while (schIt.hasNext()) {
                IGDScheme scheme = schIt.next();
                if (!typesSelected.contains(scheme.getIGDType())) continue;
                System.out.println("Processing: " + IGDIntervalZone.getIGDName(scheme.getIGDType()));
                for (IGDUnitBase unit : scheme.getIGDType() == 2 ? scheme.getLithostratUnits() : scheme.getUnits()) {
                    String newName = this.switchTerm(unit.getName());
                    if (newName == null) continue;
                    unit.updateWsName(newName);
                    ++nSchemeTermsSwitched;
                }
            }
            JOptionPane.showMessageDialog(this, "Number of terms switched in scheme(s): " + nSchemeTermsSwitched, this.getTitle(), 1);
            this.isOK = true;
            this.dispose();
        }
        catch (SQLException | SBException e) {
            StackError.showStackError((Exception)e);
        }
    }

    private String switchTerm(String unitName) {
        String newName = null;
        for (int i = 0; i < this.model.getSize(); ++i) {
            String term = this.model.getElementAt(i);
            if (this.jRadioButtonSuffix.isSelected()) {
                if (!unitName.startsWith(term + " ")) continue;
                newName = unitName.substring(term.length() + 1) + " " + term;
                continue;
            }
            if (!unitName.endsWith(" " + term)) continue;
            newName = term + " " + unitName.substring(0, unitName.length() - term.length());
        }
        return newName;
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        String term = JOptionPane.showInputDialog(this, "New term to add to the list: ", this.getTitle(), 1);
        if (term == null || term.isEmpty()) {
            return;
        }
        for (int i = 0; i < this.jListTerms.getModel().getSize(); ++i) {
            if (!term.equalsIgnoreCase(this.jListTerms.getModel().getElementAt(i))) continue;
            JOptionPane.showMessageDialog(this, "Term already exists in list!", this.getTitle(), 1);
            return;
        }
        DefaultListModel m = (DefaultListModel)this.jListTerms.getModel();
        m.addElement(term);
        this.jListTerms.repaint();
    }

    private void jRadioButtonPrefixActionPerformed(ActionEvent evt) {
        String newTerm = this.switchTerm(this.jLabelExample.getText());
        if (newTerm != null) {
            this.jLabelExample.setText(newTerm);
        }
    }

    private void jRadioButtonSuffixActionPerformed(ActionEvent evt) {
        String newTerm = this.switchTerm(this.jLabelExample.getText());
        if (newTerm != null) {
            this.jLabelExample.setText(newTerm);
        }
    }
}

