/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.taxon.Taxon;
import com.stratadata.model3.taxon.TaxonFactory;
import com.stratadata.model3.taxon.process.SynonymyUpdate;
import com.stratadata.util.ui.HelpUtils;
import com.stratadata.util.ui.SBDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.border.TitledBorder;
import jsbugs.DialogSelectSynonymScheme;
import jsbugs.DialogSelectTaxa;
import jsbugs.table.TaxonNameRenderer;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.SBRestrictable;
import model3.SBdb;
import model3.SynonymScheme;
import model3.exception.SuppressedSQLException;
import org.jdesktop.layout.GroupLayout;

public class DialogSynonymy
extends SBDialog {
    private final DefaultListModel<Taxon> listModel = new DefaultListModel();
    private final SBdb db;
    private final SynonymyUpdate process;
    private JButton jButtonAddJuniors;
    private JButton jButtonCancel;
    private JButton jButtonClearPref;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JButton jButtonPreferred;
    private JButton jButtonRemoveJunior;
    private JButton jButtonScheme;
    private JButton jButtonSwitch;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JList jListJunior;
    private JPanel jPanelSyn;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JTextPane jTextPanePreferredName;
    private JTextPane jTextPaneTaxonName;

    public DialogSynonymy(Frame parent, boolean modal, SBdb db, Taxon taxon, int synSchID) throws SQLException, SuppressedSQLException {
        super(parent, modal);
        this.db = db;
        this.process = new SynonymyUpdate(db.getSynonymService(), db.getTaxonService(), taxon, synSchID == 0 ? 1 : synSchID, this::showConfirmDialog);
        this.setLocation(parent.getLocation().x + 25, parent.getLocation().y + 25);
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException {
        this.setTitle("Synonymy");
        this.jTextPanePreferredName.setContentType("text/html");
        this.jTextPaneTaxonName.setContentType("text/html");
        this.jTextPaneTaxonName.setText(TaxonNameRenderer.getHtmlFormattedTaxonName(this.process.getSubjectTaxon(), true));
        this.setSynPanelTitle();
        this.jListJunior.setCellRenderer(new TaxonNameRenderer(taxon -> taxon.getSpecID() == this.process.getSubjectTaxon().getSpecID()));
        this.jListJunior.setPrototypeCellValue(TaxonFactory.parse((String)"SP Genus Species"));
        this.updateFromProcess();
        if (!SBRestrictable.canWrite(this.db)) {
            this.jButtonOK.setEnabled(false);
            this.jButtonOK.setToolTipText(SBRestrictable.getDeniedReason(false));
            this.getRootPane().setDefaultButton(this.jButtonCancel);
        } else {
            this.getRootPane().setDefaultButton(this.jButtonOK);
        }
    }

    private boolean showConfirmDialog(String message) {
        int opt = JOptionPane.showConfirmDialog((Component)((Object)this), message, this.getTitle(), 0);
        return opt == 0;
    }

    private void setSynPanelTitle() throws SQLException {
        ((TitledBorder)this.jPanelSyn.getBorder()).setTitle("Synonymy for scheme '" + this.db.getSynSch(this.process.getSynSchID()).getName() + "'");
    }

    private void updateFromProcess() {
        this.jTextPanePreferredName.setText(this.process.getPreferredTerm() != null ? TaxonNameRenderer.getHtmlFormattedTaxonName(this.process.getPreferredTerm(), this.process.getPreferredTerm().getSpecID() == this.process.getSubjectTaxon().getSpecID()) : "<html><i>no preferred name</i></html>");
        this.listModel.clear();
        this.process.getSynonyms().forEach(this.listModel::addElement);
        this.jListJunior.updateUI();
    }

    private void initComponents() {
        this.jButtonCancel = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonScheme = new JButton();
        this.jPanelSyn = new JPanel();
        this.jLabel2 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jListJunior = new JList();
        this.jLabel3 = new JLabel();
        this.jButtonPreferred = new JButton();
        this.jButtonRemoveJunior = new JButton();
        this.jButtonAddJuniors = new JButton();
        this.jButtonSwitch = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.jTextPanePreferredName = new JTextPane();
        this.jButtonClearPref = new JButton();
        this.jScrollPane3 = new JScrollPane();
        this.jTextPaneTaxonName = new JTextPane();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(553, 300));
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSynonymy this$0;
            {
                DialogSynonymy dialogSynonymy = this$0;
                Objects.requireNonNull(dialogSynonymy);
                this.this$0 = dialogSynonymy;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSynonymy this$0;
            {
                DialogSynonymy dialogSynonymy = this$0;
                Objects.requireNonNull(dialogSynonymy);
                this.this$0 = dialogSynonymy;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSynonymy this$0;
            {
                DialogSynonymy dialogSynonymy = this$0;
                Objects.requireNonNull(dialogSynonymy);
                this.this$0 = dialogSynonymy;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonScheme.setText("Select synonym scheme...");
        this.jButtonScheme.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSynonymy this$0;
            {
                DialogSynonymy dialogSynonymy = this$0;
                Objects.requireNonNull(dialogSynonymy);
                this.this$0 = dialogSynonymy;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSchemeActionPerformed(evt);
            }
        });
        this.jPanelSyn.setBorder(BorderFactory.createTitledBorder("Synonymy in <scheme name>"));
        this.jLabel2.setText("Preferred name:");
        this.jListJunior.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.jListJunior.setModel(this.listModel);
        this.jScrollPane1.setViewportView(this.jListJunior);
        this.jLabel3.setText("Junior synonyms:");
        this.jButtonPreferred.setText("...");
        this.jButtonPreferred.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSynonymy this$0;
            {
                DialogSynonymy dialogSynonymy = this$0;
                Objects.requireNonNull(dialogSynonymy);
                this.this$0 = dialogSynonymy;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonPreferredActionPerformed(evt);
            }
        });
        this.jButtonRemoveJunior.setText("Remove");
        this.jButtonRemoveJunior.setMargin(new Insets(2, 10, 2, 10));
        this.jButtonRemoveJunior.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSynonymy this$0;
            {
                DialogSynonymy dialogSynonymy = this$0;
                Objects.requireNonNull(dialogSynonymy);
                this.this$0 = dialogSynonymy;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonRemoveJuniorActionPerformed(evt);
            }
        });
        this.jButtonAddJuniors.setText("Add...");
        this.jButtonAddJuniors.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSynonymy this$0;
            {
                DialogSynonymy dialogSynonymy = this$0;
                Objects.requireNonNull(dialogSynonymy);
                this.this$0 = dialogSynonymy;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAddJuniorsActionPerformed(evt);
            }
        });
        this.jButtonSwitch.setText("Make preferred");
        this.jButtonSwitch.setToolTipText("Make this junior synonym the preferred term (current preferred name becomes a junior synonym)");
        this.jButtonSwitch.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonSwitch.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSynonymy this$0;
            {
                DialogSynonymy dialogSynonymy = this$0;
                Objects.requireNonNull(dialogSynonymy);
                this.this$0 = dialogSynonymy;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSwitchActionPerformed(evt);
            }
        });
        this.jScrollPane2.setMinimumSize(new Dimension(16, 20));
        this.jTextPanePreferredName.setEditable(false);
        this.jTextPanePreferredName.setBackground(new Color(255, 255, 204));
        this.jScrollPane2.setViewportView(this.jTextPanePreferredName);
        this.jButtonClearPref.setText("Clear");
        this.jButtonClearPref.setMargin(new Insets(2, 10, 2, 10));
        this.jButtonClearPref.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSynonymy this$0;
            {
                DialogSynonymy dialogSynonymy = this$0;
                Objects.requireNonNull(dialogSynonymy);
                this.this$0 = dialogSynonymy;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonClearPrefActionPerformed(evt);
            }
        });
        GroupLayout jPanelSynLayout = new GroupLayout((Container)this.jPanelSyn);
        this.jPanelSyn.setLayout((LayoutManager)jPanelSynLayout);
        jPanelSynLayout.setHorizontalGroup((GroupLayout.Group)jPanelSynLayout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanelSynLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelSynLayout.createParallelGroup(2).add((Component)this.jLabel2).add((Component)this.jLabel3)).addPreferredGap(0).add((GroupLayout.Group)jPanelSynLayout.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 317, Short.MAX_VALUE).add((Component)this.jScrollPane2, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)jPanelSynLayout.createParallelGroup(1, false).add((Component)this.jButtonAddJuniors, -2, 98, -2).add((GroupLayout.Group)jPanelSynLayout.createSequentialGroup().add((Component)this.jButtonPreferred).addPreferredGap(0).add((Component)this.jButtonClearPref, -1, -1, Short.MAX_VALUE)).add((Component)this.jButtonRemoveJunior, -2, 98, -2).add((Component)this.jButtonSwitch)).addContainerGap()));
        jPanelSynLayout.setVerticalGroup((GroupLayout.Group)jPanelSynLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelSynLayout.createSequentialGroup().add(9, 9, 9).add((GroupLayout.Group)jPanelSynLayout.createParallelGroup(2).add((GroupLayout.Group)jPanelSynLayout.createParallelGroup(3).add((Component)this.jButtonPreferred).add((Component)this.jLabel2).add((Component)this.jButtonClearPref)).add((Component)this.jScrollPane2, -2, -1, -2)).add(8, 8, 8).add((GroupLayout.Group)jPanelSynLayout.createParallelGroup(1).add((Component)this.jScrollPane1, -2, 0, Short.MAX_VALUE).add((GroupLayout.Group)jPanelSynLayout.createSequentialGroup().add((GroupLayout.Group)jPanelSynLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelSynLayout.createSequentialGroup().add((Component)this.jButtonAddJuniors).addPreferredGap(0).add((Component)this.jButtonRemoveJunior)).add((Component)this.jLabel3)).addPreferredGap(0).add((Component)this.jButtonSwitch).add(0, 45, Short.MAX_VALUE))).addContainerGap()));
        this.jTextPaneTaxonName.setEditable(false);
        this.jScrollPane3.setViewportView(this.jTextPaneTaxonName);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonScheme).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel)).add((Component)this.jPanelSyn, -1, -1, Short.MAX_VALUE).add(2, (Component)this.jScrollPane3)).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonHelp, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane3, -2, -1, -2).addPreferredGap(1).add((Component)this.jPanelSyn, -1, -1, Short.MAX_VALUE).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonHelp).add((Component)this.jButtonOK).add((Component)this.jButtonScheme)).addContainerGap()));
        this.pack();
    }

    private void jButtonRemoveJuniorActionPerformed(ActionEvent evt) {
        if (this.jListJunior.getSelectedValue() == null) {
            return;
        }
        for (Object taxon : this.jListJunior.getSelectedValuesList()) {
            this.process.removeSynonym(((Taxon)taxon).getSpecID());
        }
        this.updateFromProcess();
    }

    private void jButtonClearPrefActionPerformed(ActionEvent evt) {
        if (this.process.getPreferredTerm() != null) {
            this.process.clearSynonymyWithConfirm();
            this.updateFromProcess();
        }
    }

    private void jButtonSwitchActionPerformed(ActionEvent evt) {
        if (this.jListJunior.getSelectedValue() == null) {
            return;
        }
        Taxon selected = (Taxon)this.jListJunior.getSelectedValue();
        this.process.swapPreferredTermWithSynonym(selected);
        this.updateFromProcess();
    }

    private void jButtonSchemeActionPerformed(ActionEvent evt) {
        try {
            DialogSelectSynonymScheme dialog = new DialogSelectSynonymScheme((JDialog)((Object)this), true, this.db);
            dialog.setLocation(this.getLocation().x + 25, this.getLocation().y + 25);
            dialog.setVisible(true);
            if (dialog.getSelectedItem() != null) {
                SynonymScheme scheme = (SynonymScheme)((Object)dialog.getSelectedItem());
                this.process.setSynSchID(scheme.getSchID());
                this.setSynPanelTitle();
                this.updateFromProcess();
                this.jPanelSyn.repaint();
            }
        }
        catch (RuntimeException | SQLException e) {
            SbugsExceptionHandler.showStackError(e, (Component)((Object)this));
        }
    }

    private void jButtonAddJuniorsActionPerformed(ActionEvent evt) {
        try {
            DialogSelectTaxa dialog = new DialogSelectTaxa((JDialog)((Object)this), true, this.db, this.process.getSynSchID(), false, this.process.getSubjectTaxon());
            dialog.setLocationRelativeTo((Component)((Object)this));
            dialog.setVisible(true);
            for (Taxon t : dialog.getSelectedItems()) {
                try {
                    this.process.addSynonym(t);
                }
                catch (SynonymyUpdate.SynUpdateException ex) {
                    JOptionPane.showMessageDialog((Component)((Object)this), ex.getMessage(), "Cannot Add Synonym", 2);
                }
            }
            this.updateFromProcess();
        }
        catch (RuntimeException e) {
            SbugsExceptionHandler.showStackError(e, (Component)((Object)this));
        }
    }

    private void jButtonPreferredActionPerformed(ActionEvent evt) {
        DialogSelectTaxa dialog = new DialogSelectTaxa((JDialog)((Object)this), true, this.db, this.process.getSynSchID(), true, null);
        dialog.setLocationRelativeTo((Component)((Object)this));
        dialog.setVisible(true);
        Taxon selectedItem = (Taxon)dialog.getSelectedItem();
        if (selectedItem != null) {
            this.process.setPreferredTerm(selectedItem);
            this.updateFromProcess();
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        try {
            this.process.commitUpdate();
        }
        catch (RuntimeException re) {
            SbugsExceptionHandler.showStackError(re, (Component)((Object)this));
            return;
        }
        this.setOK();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        HelpUtils.openHelp((String)"dialogsynonymy.html");
    }
}

