/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import jsbugs.LOCTableModel;
import jsbugs.TableModelOccurrences;
import jsbugs.TablePair;
import org.jdesktop.layout.GroupLayout;

public class DialogTableOptions
extends JDialog {
    JCheckBox[] boxes;
    int nBoxes;
    static final int TOTAL_BOXES = TableModelOccurrences.columnTitles.length;
    LinkedList<TablePair> tables;
    private ButtonGroup buttonGroupColumn;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JCheckBox jCheckBox1;
    private JCheckBox jCheckBox10;
    private JCheckBox jCheckBox11;
    private JCheckBox jCheckBox12;
    private JCheckBox jCheckBox13;
    private JCheckBox jCheckBox14;
    private JCheckBox jCheckBox15;
    private JCheckBox jCheckBox16;
    private JCheckBox jCheckBox17;
    private JCheckBox jCheckBox2;
    private JCheckBox jCheckBox3;
    private JCheckBox jCheckBox4;
    private JCheckBox jCheckBox5;
    private JCheckBox jCheckBox6;
    private JCheckBox jCheckBox7;
    private JCheckBox jCheckBox8;
    private JCheckBox jCheckBox9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JRadioButton jRadioButtonResizeAll;
    private JRadioButton jRadioButtonResizeNext;
    private JRadioButton jRadioButtonScroll;

    DialogTableOptions(Frame parent, boolean modal, LinkedList<TablePair> tables) {
        super(parent, modal);
        this.initComponents();
        this.tables = tables;
        this.init();
    }

    private void init() {
        this.initBoxes();
        String[] titles = this.tables.get((int)0).model.getColumnTitles();
        TableColumnModel columnModel = this.tables.get((int)0).table.getColumnModel();
        for (int i = 0; i < TOTAL_BOXES; ++i) {
            if (i < titles.length) {
                this.boxes[i].setText(titles[i]);
                TableColumn column = columnModel.getColumn(this.tables.get((int)0).table.convertColumnIndexToView(i));
                this.boxes[i].setSelected(column.getPreferredWidth() > 0);
                ++this.nBoxes;
                continue;
            }
            this.boxes[i].setVisible(false);
        }
        if (this.tables.get((int)0).table.getAutoResizeMode() == 0) {
            this.jRadioButtonScroll.setSelected(true);
        } else if (this.tables.get((int)0).table.getAutoResizeMode() == 1) {
            this.jRadioButtonResizeNext.setSelected(true);
        } else {
            this.jRadioButtonResizeAll.setSelected(true);
        }
        if (this.tables.get((int)0).model instanceof TableModelOccurrences) {
            this.boxes[8].setEnabled(false);
            this.boxes[10].setEnabled(false);
        } else if (this.tables.get((int)0).model instanceof LOCTableModel) {
            this.boxes[1].setEnabled(false);
        }
        this.pack();
        this.setTitle("Table Options");
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    private void initBoxes() {
        this.boxes = new JCheckBox[TOTAL_BOXES];
        this.boxes[0] = this.jCheckBox1;
        this.boxes[1] = this.jCheckBox2;
        this.boxes[2] = this.jCheckBox3;
        this.boxes[3] = this.jCheckBox4;
        this.boxes[4] = this.jCheckBox5;
        this.boxes[5] = this.jCheckBox6;
        this.boxes[6] = this.jCheckBox7;
        this.boxes[7] = this.jCheckBox8;
        this.boxes[8] = this.jCheckBox9;
        this.boxes[9] = this.jCheckBox10;
        this.boxes[10] = this.jCheckBox11;
        this.boxes[11] = this.jCheckBox12;
        this.boxes[12] = this.jCheckBox13;
        this.boxes[13] = this.jCheckBox14;
        this.boxes[14] = this.jCheckBox15;
        this.boxes[15] = this.jCheckBox16;
        this.boxes[16] = this.jCheckBox17;
    }

    private void initComponents() {
        this.buttonGroupColumn = new ButtonGroup();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jPanel1 = new JPanel();
        this.jRadioButtonResizeNext = new JRadioButton();
        this.jRadioButtonScroll = new JRadioButton();
        this.jRadioButtonResizeAll = new JRadioButton();
        this.jPanel2 = new JPanel();
        this.jCheckBox2 = new JCheckBox();
        this.jCheckBox3 = new JCheckBox();
        this.jCheckBox1 = new JCheckBox();
        this.jCheckBox4 = new JCheckBox();
        this.jCheckBox5 = new JCheckBox();
        this.jCheckBox6 = new JCheckBox();
        this.jCheckBox7 = new JCheckBox();
        this.jCheckBox8 = new JCheckBox();
        this.jCheckBox9 = new JCheckBox();
        this.jCheckBox10 = new JCheckBox();
        this.jCheckBox11 = new JCheckBox();
        this.jCheckBox12 = new JCheckBox();
        this.jCheckBox13 = new JCheckBox();
        this.jCheckBox14 = new JCheckBox();
        this.jCheckBox15 = new JCheckBox();
        this.jCheckBox16 = new JCheckBox();
        this.jCheckBox17 = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTableOptions this$0;
            {
                DialogTableOptions dialogTableOptions = this$0;
                Objects.requireNonNull(dialogTableOptions);
                this.this$0 = dialogTableOptions;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTableOptions this$0;
            {
                DialogTableOptions dialogTableOptions = this$0;
                Objects.requireNonNull(dialogTableOptions);
                this.this$0 = dialogTableOptions;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Column View", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.buttonGroupColumn.add(this.jRadioButtonResizeNext);
        this.jRadioButtonResizeNext.setText("Resize next column");
        this.jRadioButtonResizeNext.setToolTipText("Resize occurrences table columns to fit table width");
        this.jRadioButtonResizeNext.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonResizeNext.setMargin(new Insets(0, 0, 0, 0));
        this.buttonGroupColumn.add(this.jRadioButtonScroll);
        this.jRadioButtonScroll.setText("Scroll columns");
        this.jRadioButtonScroll.setToolTipText("Scroll columns within window to see more data");
        this.jRadioButtonScroll.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonScroll.setMargin(new Insets(0, 0, 0, 0));
        this.buttonGroupColumn.add(this.jRadioButtonResizeAll);
        this.jRadioButtonResizeAll.setSelected(true);
        this.jRadioButtonResizeAll.setText("Resize all columns");
        this.jRadioButtonResizeAll.setToolTipText("Resize occurrences table columns to fit table width");
        this.jRadioButtonResizeAll.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonResizeAll.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jRadioButtonResizeNext).add((Component)this.jRadioButtonScroll).add((Component)this.jRadioButtonResizeAll));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jRadioButtonScroll).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jRadioButtonResizeNext).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jRadioButtonResizeAll)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(null, "Visible columns", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.jCheckBox2.setText("jCheckBox2");
        this.jCheckBox3.setText("jCheckBox3");
        this.jCheckBox1.setText("jCheckBox1");
        this.jCheckBox4.setText("jCheckBox4");
        this.jCheckBox5.setText("jCheckBox5");
        this.jCheckBox6.setText("jCheckBox6");
        this.jCheckBox7.setText("jCheckBox7");
        this.jCheckBox8.setText("jCheckBox8");
        this.jCheckBox9.setText("jCheckBox9");
        this.jCheckBox10.setText("jCheckBox10");
        this.jCheckBox11.setText("jCheckBox11");
        this.jCheckBox12.setText("jCheckBox12");
        this.jCheckBox13.setText("jCheckBox13");
        this.jCheckBox14.setText("jCheckBox14");
        this.jCheckBox15.setText("jCheckBox15");
        this.jCheckBox16.setText("jCheckBox16");
        this.jCheckBox17.setText("jCheckBox17");
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.jCheckBox3).add((Component)this.jCheckBox2).add((Component)this.jCheckBox1).add((Component)this.jCheckBox4).add((Component)this.jCheckBox5).add((Component)this.jCheckBox6).add((Component)this.jCheckBox7).add((Component)this.jCheckBox8).add((Component)this.jCheckBox9).add((Component)this.jCheckBox10).add((Component)this.jCheckBox11).add((Component)this.jCheckBox12).add((Component)this.jCheckBox13).add((Component)this.jCheckBox14).add((Component)this.jCheckBox15).add((Component)this.jCheckBox16).add((Component)this.jCheckBox17)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.jCheckBox1).addPreferredGap(0).add((Component)this.jCheckBox2).addPreferredGap(0).add((Component)this.jCheckBox3).addPreferredGap(0).add((Component)this.jCheckBox4).addPreferredGap(0).add((Component)this.jCheckBox5).addPreferredGap(0).add((Component)this.jCheckBox6).addPreferredGap(0).add((Component)this.jCheckBox7).addPreferredGap(0).add((Component)this.jCheckBox8).addPreferredGap(0).add((Component)this.jCheckBox9).addPreferredGap(0).add((Component)this.jCheckBox10).addPreferredGap(0).add((Component)this.jCheckBox11).addPreferredGap(0).add((Component)this.jCheckBox12).addPreferredGap(0).add((Component)this.jCheckBox13).addPreferredGap(0).add((Component)this.jCheckBox14).addPreferredGap(0).add((Component)this.jCheckBox15).addPreferredGap(0).add((Component)this.jCheckBox16).addPreferredGap(0).add((Component)this.jCheckBox17).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jPanel2, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(2, false).add((Component)this.jButtonCancel, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonOK, -1, -1, Short.MAX_VALUE).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel2, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jPanel1, -2, -1, -2).addPreferredGap(0, 324, Short.MAX_VALUE).add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonCancel))).addContainerGap()));
        this.pack();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        this.setColumns();
        for (TablePair tp : this.tables) {
            JTable table = tp.table;
            if (this.jRadioButtonScroll.isSelected()) {
                table.setAutoResizeMode(0);
                continue;
            }
            if (this.jRadioButtonResizeAll.isSelected()) {
                table.setAutoResizeMode(4);
                continue;
            }
            table.setAutoResizeMode(1);
        }
        this.dispose();
    }

    private void setColumns() {
        for (TablePair tp : this.tables) {
            TableColumnModel columns = tp.table.getColumnModel();
            for (int i = 0; i < this.nBoxes; ++i) {
                if (this.boxes[i].isSelected()) {
                    TableColumn column = columns.getColumn(tp.table.convertColumnIndexToView(i));
                    if (column.getPreferredWidth() != 0) continue;
                    int maxwidth = Integer.MAX_VALUE;
                    int minWidth = 15;
                    column.setMaxWidth(maxwidth);
                    column.setMinWidth(minWidth);
                    column.setPreferredWidth(tp.model.getDefaultColumnWidths()[i]);
                    continue;
                }
                columns.getColumn(tp.table.convertColumnIndexToView(i)).setMinWidth(0);
                columns.getColumn(tp.table.convertColumnIndexToView(i)).setMaxWidth(0);
            }
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }
}

