/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.Discipline;
import com.stratadata.model3.taxon.Category;
import com.stratadata.model3.taxon.Genus;
import com.stratadata.model3.taxon.Qualifier;
import com.stratadata.model3.taxon.SearchMode;
import com.stratadata.model3.taxon.Taxon;
import com.stratadata.model3.taxon.TaxonQual;
import com.stratadata.model3.taxon.process.TaxonAdd;
import com.stratadata.model3.user.UserService;
import com.stratadata.model3.validation.FieldLengthProperties;
import com.stratadata.model3.validation.SbugsValidator;
import com.stratadata.util.process.ProcessMessage;
import com.stratadata.util.ui.HelpUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import jsbchart.core.ChartManager;
import jsbugs.DialogGenusUpdate;
import jsbugs.DialogList;
import jsbugs.DialogMergeTaxa;
import jsbugs.DialogTaxonAdded;
import jsbugs.InternalFrameTaxa;
import jsbugs.list.CategoryComboBox;
import jsbugs.uiutil.TextFieldUtils;
import jsbugs.userconnect.SbugsExceptionHandler;
import jsbugs.util.UserPrefsHelper;
import model3.SBEvent;
import model3.SBRestrictable;
import model3.SBdb;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.layout.GroupLayout;
import util.SBException;
import util.SBPermissionException;

public class DialogTaxon
extends JDialog {
    private static final int GEN_LEN = FieldLengthProperties.getFieldLength(Genus.class, (String)"genusName", (int)50);
    private static final int SUB_GEN_LEN = FieldLengthProperties.getFieldLength(Genus.class, (String)"subGenus", (int)30);
    private static final int SPEC_LEN = FieldLengthProperties.getFieldLength(Taxon.class, (String)"species", (int)50);
    private static final int SUB_SPEC_LEN = FieldLengthProperties.getFieldLength(Taxon.class, (String)"subSpecies", (int)50);
    private static final int AUTH_LEN = FieldLengthProperties.getFieldLength(Taxon.class, (String)"author", (int)100);
    private static final int ALPHA_CODE_LEN = FieldLengthProperties.getFieldLength(Taxon.class, (String)"alphaCode", (int)30);
    model3.Taxon taxon;
    private final SBdb db;
    private static final int NFIELDS = 8;
    private final Object[] fields = new Object[8];
    private static String lastCatSelection = null;
    private final ChartManager chartManager;
    private RefsAndNotes refsAndNotes;
    private ButtonGroup buttonGroupDiscipline;
    private CategoryComboBox categoryComboBox;
    private JButton jButtonBlankSpecies;
    private JButton jButtonBlankTaxon;
    private JButton jButtonCancel;
    private JButton jButtonConvertCase;
    private JButton jButtonGenera;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JButton jButtonSpecies;
    private JButton jButtonUseLastCat;
    private JComboBox jComboBoxGenusQualifier1;
    private JComboBox jComboBoxGenusQualifier2;
    private JComboBox jComboBoxSpeciesQualifier1;
    private JComboBox jComboBoxSpeciesQualifier2;
    private JComboBox jComboBoxSubGenusQualifier1;
    private JComboBox jComboBoxSubGenusQualifier2;
    private JComboBox jComboBoxSubSpeciesQualifier1;
    private JComboBox jComboBoxSubSpeciesQualifier2;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel13;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JLabel jLabelAudit;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JRadioButton jRadioButtonMacro;
    private JRadioButton jRadioButtonMicro;
    private JRadioButton jRadioButtonNanno;
    private JRadioButton jRadioButtonPaly;
    private JSeparator jSeparator1;
    private JTextField jTextFieldAlphanumericCode;
    private JTextField jTextFieldAuthor;
    private JTextField jTextFieldCurrentTaxon;
    private JTextField jTextFieldGenus;
    private JTextField jTextFieldID;
    private JTextField jTextFieldSpecies;
    private JTextField jTextFieldSubGenus;
    private JTextField jTextFieldSubSpecies;

    public DialogTaxon(Frame parent, boolean modal, SBdb db, model3.Taxon taxon, boolean useAsTemplate, ChartManager chartManager) {
        super(parent, modal);
        this.taxon = taxon;
        this.db = db;
        this.chartManager = chartManager;
        this.initComponents();
        this.init(useAsTemplate);
    }

    public static DialogTaxon newDialogTaxonToAddDomainTaxon(JDialog parent, boolean modal, SBdb db, Taxon taxon) {
        return new DialogTaxon(parent, modal, db, taxon);
    }

    private DialogTaxon(JDialog parent, boolean modal, SBdb db, Taxon taxon) {
        super((Dialog)parent, modal);
        this.db = db;
        this.chartManager = null;
        this.taxon = null;
        this.initComponents();
        this.init(false);
        if (taxon.getGenus().getCategory() != null) {
            this.categoryComboBox.setSelectedCategory(taxon.getGenus().getCategory().getMnemonic());
        }
        if (this.categoryComboBox.getSelectedCategory().isEmpty() && !StringUtils.isBlank((CharSequence)taxon.getGenus().getGenusName())) {
            Genus lookup = new Genus();
            lookup.setGenusName(taxon.getGenus().getGenusName());
            List matchingGenera = db.getGenusService().findMatchingGenera(lookup, SearchMode.SEARCH);
            if (!matchingGenera.isEmpty()) {
                this.categoryComboBox.setSelectedCategory(((Genus)matchingGenera.get(0)).getCategory().getMnemonic());
            }
        }
        this.jTextFieldGenus.setText(taxon.getGenus().getGenusName());
        this.jTextFieldSubGenus.setText(taxon.getGenus().getSubGenus());
        this.jTextFieldSpecies.setText(taxon.getSpecies());
        this.jTextFieldSubSpecies.setText(taxon.getSubSpecies());
        this.jTextFieldAlphanumericCode.setText(taxon.getAlphaCode());
        this.jTextFieldAuthor.setText(taxon.getAuthor());
        this.selectQualifier(this.jComboBoxGenusQualifier1, taxon.getGenus().getQ1());
        this.selectQualifier(this.jComboBoxGenusQualifier2, taxon.getGenus().getQ2());
        this.selectQualifier(this.jComboBoxSubGenusQualifier1, taxon.getGenus().getQ3());
        this.selectQualifier(this.jComboBoxSubGenusQualifier2, taxon.getGenus().getQ4());
        this.selectQualifier(this.jComboBoxSpeciesQualifier1, taxon.getQ1());
        this.selectQualifier(this.jComboBoxSpeciesQualifier2, taxon.getQ2());
        this.selectQualifier(this.jComboBoxSubSpeciesQualifier1, taxon.getQ3());
        this.selectQualifier(this.jComboBoxSubSpeciesQualifier2, taxon.getQ4());
        this.refsAndNotes = new RefsAndNotes(taxon.getReference(), taxon.getNotes(), taxon.getUrl());
    }

    private void init(boolean useAsTemplate) {
        this.fillQualifiers();
        this.categoryComboBox.setCategoryService(this.db.getCategoryService());
        this.categoryComboBox.fill();
        this.categoryComboBox.setSelectedIndex(0);
        this.setTitle("Taxon : Add");
        if (this.taxon != null) {
            if (this.taxon.getGenus() != null) {
                this.setDiscipline(this.taxon.getDisc());
                this.jTextFieldGenus.setText(this.taxon.getGenus().getGenus());
                this.jTextFieldSubGenus.setText(this.taxon.getGenus().getSubGenus());
                this.categoryComboBox.setSelectedCategory(this.taxon.getGenus().getCategoryMnemonic());
            }
            this.jTextFieldSpecies.setText(this.taxon.getSpecies());
            this.jTextFieldSubSpecies.setText(this.taxon.getSubSpecies());
            this.jTextFieldAuthor.setText(this.taxon.getAuthor());
            this.selectQualifier(this.jComboBoxGenusQualifier1, this.taxon.getGenus() == null ? null : this.taxon.getGenus().getQ1());
            this.selectQualifier(this.jComboBoxGenusQualifier2, this.taxon.getGenus() == null ? null : this.taxon.getGenus().getQ2());
            this.selectQualifier(this.jComboBoxSubGenusQualifier1, this.taxon.getGenus() == null ? null : this.taxon.getGenus().getQ3());
            this.selectQualifier(this.jComboBoxSubGenusQualifier2, this.taxon.getGenus() == null ? null : this.taxon.getGenus().getQ4());
            this.selectQualifier(this.jComboBoxSpeciesQualifier1, this.taxon.getQ1());
            this.selectQualifier(this.jComboBoxSpeciesQualifier2, this.taxon.getQ2());
            this.selectQualifier(this.jComboBoxSubSpeciesQualifier1, this.taxon.getQ3());
            this.selectQualifier(this.jComboBoxSubSpeciesQualifier2, this.taxon.getQ4());
            this.jTextFieldAlphanumericCode.setText(this.taxon.getAlphaCode());
            if (useAsTemplate) {
                this.taxon = null;
                this.jLabelAudit.setText("");
            } else {
                this.jTextFieldCurrentTaxon.setText(this.taxon.toString(true));
                this.jTextFieldID.setText("" + this.taxon.getSpecID());
                this.setTitle("Taxon : Edit - " + String.valueOf(this.taxon));
                this.jLabelAudit.setText(this.taxon.getAudit().toString((UserService)this.db, true));
            }
        } else {
            this.jTextFieldCurrentTaxon.setBackground(Color.lightGray);
            this.jTextFieldID.setBackground(Color.gray);
            this.jLabelAudit.setText("");
        }
        if (!SBRestrictable.canWrite(this.db)) {
            this.jButtonOK.setEnabled(false);
            this.getRootPane().setDefaultButton(this.jButtonCancel);
        } else {
            this.getRootPane().setDefaultButton(this.jButtonOK);
        }
        this.pack();
    }

    private void selectQualifier(JComboBox combo, Qualifier qual) {
        combo.setSelectedItem(qual);
        if (combo.getSelectedIndex() < 0 && qual != null && qual.hasQuals()) {
            if (qual.getSingle() != null) {
                combo.setSelectedItem(qual.getSingle());
                return;
            }
            Qualifier copy = qual.copy();
            combo.addItem(copy);
            combo.setSelectedItem(copy);
        }
    }

    private void fillQualifiers() {
        JComboBox[] qualBoxes = new JComboBox[]{this.jComboBoxGenusQualifier1, this.jComboBoxGenusQualifier2, this.jComboBoxSubGenusQualifier1, this.jComboBoxSubGenusQualifier2, this.jComboBoxSpeciesQualifier1, this.jComboBoxSpeciesQualifier2, this.jComboBoxSubSpeciesQualifier1, this.jComboBoxSubSpeciesQualifier2};
        for (int i = 0; i < 8; ++i) {
            JComboBox box = qualBoxes[i];
            box.addItem(null);
            for (TaxonQual q : TaxonQual.values()) {
                if (!q.useAt(i)) continue;
                box.addItem(q);
            }
            this.fields[i] = null;
        }
    }

    private void handleQualifierSelection(JComboBox combo, int index) {
        Object item = combo.getSelectedItem();
        Object field = this.fields[index];
        if (item != null) {
            if (field instanceof Qualifier) {
                if (item instanceof TaxonQual) {
                    TaxonQual newQual = (TaxonQual)item;
                    Qualifier existingQualifier = (Qualifier)field;
                    existingQualifier.addQual(newQual);
                    for (int i = 0; i < combo.getItemCount(); ++i) {
                        Object existing = combo.getItemAt(i);
                        if (!(existing instanceof Qualifier) || existing == existingQualifier || !((Qualifier)existing).equals((Object)existingQualifier)) continue;
                        combo.removeItem(existing);
                    }
                    item = field;
                }
            } else if (field instanceof TaxonQual && item instanceof TaxonQual && item != field) {
                Qualifier qualifier = new Qualifier(index);
                qualifier.addQual((TaxonQual)field);
                if (qualifier.addQual((TaxonQual)item)) {
                    boolean exists = false;
                    for (int i = 0; i < combo.getItemCount(); ++i) {
                        if (!(combo.getItemAt(i) instanceof Qualifier) || !((Qualifier)combo.getItemAt(i)).equals((Object)qualifier)) continue;
                        qualifier = (Qualifier)combo.getItemAt(i);
                        exists = true;
                    }
                    if (!exists) {
                        combo.addItem(qualifier);
                    }
                    item = qualifier;
                }
            }
        }
        this.fields[index] = item;
        combo.setSelectedItem(item);
    }

    void setSpecies(String species) {
        this.jTextFieldSpecies.setText(species);
    }

    void setSq1(TaxonQual tq) {
        Qualifier q = new Qualifier(4, tq);
        this.selectQualifier(this.jComboBoxSpeciesQualifier1, q);
    }

    void setSq2(TaxonQual tq) {
        Qualifier q = new Qualifier(5, tq);
        this.selectQualifier(this.jComboBoxSpeciesQualifier2, q);
    }

    private void initComponents() {
        this.buttonGroupDiscipline = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.jTextFieldAuthor = TextFieldUtils.buildLimitedLengthTextField(AUTH_LEN);
        this.jLabel10 = new JLabel();
        this.jTextFieldAlphanumericCode = TextFieldUtils.buildLimitedLengthTextField(ALPHA_CODE_LEN);
        this.jLabel13 = new JLabel();
        this.jButtonCancel = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonConvertCase = new JButton();
        this.jButtonOK = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jButtonBlankTaxon = new JButton();
        this.jButtonBlankSpecies = new JButton();
        this.jPanel2 = new JPanel();
        this.jButtonSpecies = new JButton();
        this.jComboBoxSpeciesQualifier2 = new JComboBox();
        this.jComboBoxSpeciesQualifier2.putClientProperty("JComboBox.isPopDown", Boolean.TRUE);
        this.jTextFieldSpecies = TextFieldUtils.buildLimitedLengthTextField(SPEC_LEN);
        this.jComboBoxSpeciesQualifier1 = new JComboBox();
        this.jComboBoxSpeciesQualifier1.putClientProperty("JComboBox.isPopDown", Boolean.TRUE);
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jComboBoxSubSpeciesQualifier1 = new JComboBox();
        this.jComboBoxSubSpeciesQualifier1.putClientProperty("JComboBox.isPopDown", Boolean.TRUE);
        this.jTextFieldSubSpecies = TextFieldUtils.buildLimitedLengthTextField(SUB_SPEC_LEN);
        this.jComboBoxSubSpeciesQualifier2 = new JComboBox();
        this.jComboBoxSubSpeciesQualifier2.putClientProperty("JComboBox.isPopDown", Boolean.TRUE);
        this.jComboBoxSubGenusQualifier2 = new JComboBox();
        this.jComboBoxSubGenusQualifier2.putClientProperty("JComboBox.isPopDown", Boolean.TRUE);
        this.jTextFieldSubGenus = TextFieldUtils.buildLimitedLengthTextField(SUB_GEN_LEN);
        this.jComboBoxSubGenusQualifier1 = new JComboBox();
        this.jComboBoxSubGenusQualifier1.putClientProperty("JComboBox.isPopDown", Boolean.TRUE);
        this.jLabel4 = new JLabel();
        this.jTextFieldGenus = TextFieldUtils.buildLimitedLengthTextField(GEN_LEN);
        this.jComboBoxGenusQualifier2 = new JComboBox();
        this.jComboBoxGenusQualifier2.putClientProperty("JComboBox.isPopDown", Boolean.TRUE);
        this.jButtonGenera = new JButton();
        this.jComboBoxGenusQualifier1 = new JComboBox();
        this.jComboBoxGenusQualifier1.putClientProperty("JComboBox.isPopDown", Boolean.TRUE);
        this.jLabel3 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jRadioButtonPaly = new JRadioButton();
        this.jButtonUseLastCat = new JButton();
        this.jRadioButtonMacro = new JRadioButton();
        this.jRadioButtonNanno = new JRadioButton();
        this.jRadioButtonMicro = new JRadioButton();
        this.jLabel2 = new JLabel();
        this.categoryComboBox = new CategoryComboBox();
        this.jLabel11 = new JLabel();
        this.jPanel3 = new JPanel();
        this.jLabelAudit = new JLabel();
        this.jTextFieldCurrentTaxon = new JTextField();
        this.jLabel1 = new JLabel();
        this.jTextFieldID = new JTextField();
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.setResizable(false);
        this.jPanel1.setPreferredSize(new Dimension(490, 100));
        this.jLabel10.setText("Author/year:");
        this.jLabel13.setText("Alphanumeric code:");
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(2).add((Component)this.jLabel13).add((Component)this.jLabel10)).addPreferredGap(1).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jTextFieldAlphanumericCode, -2, 133, -2).add((Component)this.jTextFieldAuthor, -2, 515, -2))));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel10).add((Component)this.jTextFieldAuthor, -2, -1, -2)).addPreferredGap(1).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel13).add((Component)this.jTextFieldAlphanumericCode, -2, -1, -2)).add(30, 30, 30)));
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTaxon this$0;
            {
                DialogTaxon dialogTaxon = this$0;
                Objects.requireNonNull(dialogTaxon);
                this.this$0 = dialogTaxon;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTaxon this$0;
            {
                DialogTaxon dialogTaxon = this$0;
                Objects.requireNonNull(dialogTaxon);
                this.this$0 = dialogTaxon;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonConvertCase.setText("Convert case");
        this.jButtonConvertCase.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTaxon this$0;
            {
                DialogTaxon dialogTaxon = this$0;
                Objects.requireNonNull(dialogTaxon);
                this.this$0 = dialogTaxon;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonConvertCaseActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTaxon this$0;
            {
                DialogTaxon dialogTaxon = this$0;
                Objects.requireNonNull(dialogTaxon);
                this.this$0 = dialogTaxon;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonBlankTaxon.setText("Clear taxon");
        this.jButtonBlankTaxon.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTaxon this$0;
            {
                DialogTaxon dialogTaxon = this$0;
                Objects.requireNonNull(dialogTaxon);
                this.this$0 = dialogTaxon;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonBlankTaxonActionPerformed(evt);
            }
        });
        this.jButtonBlankSpecies.setText("Clear species");
        this.jButtonBlankSpecies.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTaxon this$0;
            {
                DialogTaxon dialogTaxon = this$0;
                Objects.requireNonNull(dialogTaxon);
                this.this$0 = dialogTaxon;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonBlankSpeciesActionPerformed(evt);
            }
        });
        this.jButtonSpecies.setText("Species...");
        this.jButtonSpecies.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTaxon this$0;
            {
                DialogTaxon dialogTaxon = this$0;
                Objects.requireNonNull(dialogTaxon);
                this.this$0 = dialogTaxon;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSpeciesActionPerformed(evt);
            }
        });
        this.jComboBoxSpeciesQualifier2.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTaxon this$0;
            {
                DialogTaxon dialogTaxon = this$0;
                Objects.requireNonNull(dialogTaxon);
                this.this$0 = dialogTaxon;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jComboBoxSpeciesQualifier2ActionPerformed(evt);
            }
        });
        this.jTextFieldSpecies.getInputMap(0).put(KeyStroke.getKeyStroke(32, 128), "species");
        this.jTextFieldSpecies.getActionMap().put("species", new AbstractAction(this){
            final /* synthetic */ DialogTaxon this$0;
            {
                DialogTaxon dialogTaxon = this$0;
                Objects.requireNonNull(dialogTaxon);
                this.this$0 = dialogTaxon;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.jButtonSpeciesActionPerformed(e);
                this.this$0.jTextFieldSpecies.setText(this.this$0.jTextFieldSpecies.getText().trim());
            }
        });
        this.jComboBoxSpeciesQualifier1.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTaxon this$0;
            {
                DialogTaxon dialogTaxon = this$0;
                Objects.requireNonNull(dialogTaxon);
                this.this$0 = dialogTaxon;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jComboBoxSpeciesQualifier1ActionPerformed(evt);
            }
        });
        this.jLabel8.setText("Species:");
        this.jLabel9.setText("Sub-species:");
        this.jComboBoxSubSpeciesQualifier1.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTaxon this$0;
            {
                DialogTaxon dialogTaxon = this$0;
                Objects.requireNonNull(dialogTaxon);
                this.this$0 = dialogTaxon;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jComboBoxSubSpeciesQualifier1ActionPerformed(evt);
            }
        });
        this.jComboBoxSubSpeciesQualifier2.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTaxon this$0;
            {
                DialogTaxon dialogTaxon = this$0;
                Objects.requireNonNull(dialogTaxon);
                this.this$0 = dialogTaxon;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jComboBoxSubSpeciesQualifier2ActionPerformed(evt);
            }
        });
        this.jComboBoxSubGenusQualifier2.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTaxon this$0;
            {
                DialogTaxon dialogTaxon = this$0;
                Objects.requireNonNull(dialogTaxon);
                this.this$0 = dialogTaxon;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jComboBoxSubGenusQualifier2ActionPerformed(evt);
            }
        });
        this.jComboBoxSubGenusQualifier1.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTaxon this$0;
            {
                DialogTaxon dialogTaxon = this$0;
                Objects.requireNonNull(dialogTaxon);
                this.this$0 = dialogTaxon;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jComboBoxSubGenusQualifier1ActionPerformed(evt);
            }
        });
        this.jLabel4.setText("Sub-genus:");
        this.jTextFieldGenus.getInputMap(0).put(KeyStroke.getKeyStroke(32, 128), "genus");
        this.jTextFieldGenus.getActionMap().put("genus", new AbstractAction(this){
            final /* synthetic */ DialogTaxon this$0;
            {
                DialogTaxon dialogTaxon = this$0;
                Objects.requireNonNull(dialogTaxon);
                this.this$0 = dialogTaxon;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.jButtonGeneraActionPerformed(e);
                this.this$0.jTextFieldGenus.setText(this.this$0.jTextFieldGenus.getText().trim());
            }
        });
        this.jComboBoxGenusQualifier2.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTaxon this$0;
            {
                DialogTaxon dialogTaxon = this$0;
                Objects.requireNonNull(dialogTaxon);
                this.this$0 = dialogTaxon;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jComboBoxGenusQualifier2ActionPerformed(evt);
            }
        });
        this.jButtonGenera.setText("Genera...");
        this.jButtonGenera.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTaxon this$0;
            {
                DialogTaxon dialogTaxon = this$0;
                Objects.requireNonNull(dialogTaxon);
                this.this$0 = dialogTaxon;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonGeneraActionPerformed(evt);
            }
        });
        this.jComboBoxGenusQualifier1.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTaxon this$0;
            {
                DialogTaxon dialogTaxon = this$0;
                Objects.requireNonNull(dialogTaxon);
                this.this$0 = dialogTaxon;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jComboBoxGenusQualifier1ActionPerformed(evt);
            }
        });
        this.jLabel3.setText("Genus:");
        this.jLabel7.setText("Name:");
        this.jLabel6.setText("Qualifiers:");
        this.jLabel5.setText("Qualifiers:");
        this.buttonGroupDiscipline.add(this.jRadioButtonPaly);
        this.jRadioButtonPaly.setText("Paly");
        this.jRadioButtonPaly.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTaxon this$0;
            {
                DialogTaxon dialogTaxon = this$0;
                Objects.requireNonNull(dialogTaxon);
                this.this$0 = dialogTaxon;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonPalyActionPerformed(evt);
            }
        });
        this.jButtonUseLastCat.setText("Use last");
        this.jButtonUseLastCat.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTaxon this$0;
            {
                DialogTaxon dialogTaxon = this$0;
                Objects.requireNonNull(dialogTaxon);
                this.this$0 = dialogTaxon;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonUseLastCatActionPerformed(evt);
            }
        });
        this.buttonGroupDiscipline.add(this.jRadioButtonMacro);
        this.jRadioButtonMacro.setText("Macro");
        this.jRadioButtonMacro.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTaxon this$0;
            {
                DialogTaxon dialogTaxon = this$0;
                Objects.requireNonNull(dialogTaxon);
                this.this$0 = dialogTaxon;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonMacroActionPerformed(evt);
            }
        });
        this.buttonGroupDiscipline.add(this.jRadioButtonNanno);
        this.jRadioButtonNanno.setText("Nanno");
        this.jRadioButtonNanno.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTaxon this$0;
            {
                DialogTaxon dialogTaxon = this$0;
                Objects.requireNonNull(dialogTaxon);
                this.this$0 = dialogTaxon;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonNannoActionPerformed(evt);
            }
        });
        this.buttonGroupDiscipline.add(this.jRadioButtonMicro);
        this.jRadioButtonMicro.setText("Micro");
        this.jRadioButtonMicro.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTaxon this$0;
            {
                DialogTaxon dialogTaxon = this$0;
                Objects.requireNonNull(dialogTaxon);
                this.this$0 = dialogTaxon;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonMicroActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Category:");
        this.jLabel11.setText("Category filter:");
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(2).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add(0, 0, Short.MAX_VALUE).add((Component)this.jLabel11).addPreferredGap(1).add((Component)this.jRadioButtonMicro).addPreferredGap(1).add((Component)this.jRadioButtonNanno).addPreferredGap(1).add((Component)this.jRadioButtonPaly).addPreferredGap(1).add((Component)this.jRadioButtonMacro)).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(2).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add(2, (Component)this.jLabel3).add(2, (Component)this.jLabel4).add((Component)this.jLabel9)).add((Component)this.jLabel8).add((Component)this.jLabel2)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(2, false).add((Component)this.jComboBoxSubSpeciesQualifier1, 0, -1, Short.MAX_VALUE).add(1, (Component)this.jComboBoxSpeciesQualifier1, 0, -1, Short.MAX_VALUE).add(1, (Component)this.jLabel6, -1, -1, Short.MAX_VALUE).add(1, (Component)this.jComboBoxGenusQualifier1, 0, -1, Short.MAX_VALUE).add(1, (Component)this.jComboBoxSubGenusQualifier1, 0, -1, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add(2, (Component)this.jTextFieldSubGenus).add((Component)this.jTextFieldSubSpecies).add(2, (Component)this.jTextFieldSpecies).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.jLabel7).add(0, 0, Short.MAX_VALUE)).add((Component)this.jTextFieldGenus)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(2, false).add((Component)this.jComboBoxSpeciesQualifier2, 0, -1, Short.MAX_VALUE).add(1, (Component)this.jComboBoxSubGenusQualifier2, 0, -1, Short.MAX_VALUE).add((Component)this.jComboBoxGenusQualifier2, 0, -1, Short.MAX_VALUE).add((Component)this.jLabel5, -1, -1, Short.MAX_VALUE).add((Component)this.jComboBoxSubSpeciesQualifier2, 0, -1, Short.MAX_VALUE))).add((Component)this.categoryComboBox, -1, -1, Short.MAX_VALUE)))).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1, false).add((Component)this.jButtonUseLastCat, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonGenera, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonSpecies, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel2Layout.createSequentialGroup().add(8, 8, 8).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jRadioButtonPaly).add((Component)this.jRadioButtonMacro).add((Component)this.jRadioButtonNanno).add((Component)this.jRadioButtonMicro).add((Component)this.jLabel11)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(2).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jButtonUseLastCat).add((Component)this.jLabel2)).add((Component)this.categoryComboBox, -2, -1, -2)).addPreferredGap(0, -1, Short.MAX_VALUE).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jLabel7).add((Component)this.jLabel6).add((Component)this.jLabel5)).addPreferredGap(1).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jTextFieldGenus, -2, -1, -2).add((Component)this.jComboBoxGenusQualifier2, -2, -1, -2).add((Component)this.jButtonGenera).add((Component)this.jComboBoxGenusQualifier1, -2, -1, -2).add((Component)this.jLabel3)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jComboBoxSubGenusQualifier2, -2, -1, -2).add((Component)this.jTextFieldSubGenus, -2, -1, -2).add((Component)this.jComboBoxSubGenusQualifier1, -2, -1, -2).add((Component)this.jLabel4)).add(18, 18, 18).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jButtonSpecies).add((Component)this.jComboBoxSpeciesQualifier2, -2, -1, -2).add((Component)this.jTextFieldSpecies, -2, -1, -2).add((Component)this.jComboBoxSpeciesQualifier1, -2, -1, -2).add((Component)this.jLabel8)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jLabel9).add((Component)this.jComboBoxSubSpeciesQualifier1, -2, -1, -2).add((Component)this.jTextFieldSubSpecies, -2, -1, -2).add((Component)this.jComboBoxSubSpeciesQualifier2, -2, -1, -2)).add(12, 12, 12)));
        this.jLabelAudit.setForeground(new Color(153, 153, 153));
        this.jLabelAudit.setText("Created by: on:; Modified by: on:");
        this.jTextFieldCurrentTaxon.setEditable(false);
        this.jTextFieldCurrentTaxon.setBackground(new Color(255, 255, 204));
        this.jLabel1.setText("Current taxon:");
        this.jTextFieldID.setEditable(false);
        this.jTextFieldID.setBackground(new Color(255, 255, 204));
        this.jTextFieldID.setText("No ID");
        GroupLayout jPanel3Layout = new GroupLayout((Container)this.jPanel3);
        this.jPanel3.setLayout((LayoutManager)jPanel3Layout);
        jPanel3Layout.setHorizontalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).addPreferredGap(0, -1, Short.MAX_VALUE).add((GroupLayout.Group)jPanel3Layout.createParallelGroup(2).add((Component)this.jLabelAudit).add((Component)this.jTextFieldCurrentTaxon, -2, 497, -2)).addPreferredGap(0).add((Component)this.jTextFieldID, -2, 83, -2).addContainerGap()));
        jPanel3Layout.setVerticalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel3Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add((GroupLayout.Group)jPanel3Layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jTextFieldCurrentTaxon, -2, -1, -2).add((Component)this.jTextFieldID, -2, -1, -2)).addPreferredGap(0).add((Component)this.jLabelAudit)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel3, -1, -1, Short.MAX_VALUE).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jPanel2, -1, -1, Short.MAX_VALUE).add(1, (Component)this.jPanel1, -1, 674, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jSeparator1).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonBlankTaxon).addPreferredGap(0).add((Component)this.jButtonBlankSpecies).addPreferredGap(0).add((Component)this.jButtonConvertCase).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel))))).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonHelp, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jPanel3, -2, -1, -2).addPreferredGap(1).add((Component)this.jPanel2, -2, -1, -2).addPreferredGap(0).add((Component)this.jPanel1, -2, 73, -2).addPreferredGap(0).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonHelp).add((Component)this.jButtonConvertCase).add((Component)this.jButtonBlankTaxon).add((Component)this.jButtonBlankSpecies).add((Component)this.jButtonOK)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButtonBlankSpeciesActionPerformed(ActionEvent evt) {
        this.jTextFieldSpecies.setText("");
        this.jTextFieldSubSpecies.setText("");
        this.jComboBoxSpeciesQualifier1.setSelectedItem("");
        this.jComboBoxSpeciesQualifier2.setSelectedItem("");
        this.jComboBoxSubSpeciesQualifier1.setSelectedItem("");
        this.jComboBoxSubSpeciesQualifier2.setSelectedItem("");
    }

    private void jButtonBlankTaxonActionPerformed(ActionEvent evt) {
        this.jTextFieldGenus.setText("");
        this.jTextFieldSubGenus.setText("");
        this.jTextFieldAuthor.setText("");
        this.jTextFieldAlphanumericCode.setText("");
        this.jComboBoxGenusQualifier1.setSelectedItem("");
        this.jComboBoxGenusQualifier2.setSelectedItem("");
        this.jComboBoxSubGenusQualifier1.setSelectedItem("");
        this.jComboBoxSubGenusQualifier2.setSelectedItem("");
        this.jButtonBlankSpeciesActionPerformed(null);
    }

    private void jButtonConvertCaseActionPerformed(ActionEvent evt) {
        this.jTextFieldGenus.setText(Genus.toGenusCase((String)this.jTextFieldGenus.getText()));
        this.jTextFieldSubGenus.setText(Genus.toGenusCase((String)this.jTextFieldSubGenus.getText()));
        this.jTextFieldSpecies.setText(Taxon.toSpeciesCase((String)this.jTextFieldSpecies.getText()));
        this.jTextFieldSubSpecies.setText(Taxon.toSpeciesCase((String)this.jTextFieldSubSpecies.getText()));
    }

    private void jComboBoxSubSpeciesQualifier2ActionPerformed(ActionEvent evt) {
        this.handleQualifierSelection(this.jComboBoxSubSpeciesQualifier2, 7);
    }

    private void jComboBoxSpeciesQualifier2ActionPerformed(ActionEvent evt) {
        this.handleQualifierSelection(this.jComboBoxSpeciesQualifier2, 5);
    }

    private void jComboBoxSubSpeciesQualifier1ActionPerformed(ActionEvent evt) {
        this.handleQualifierSelection(this.jComboBoxSubSpeciesQualifier1, 6);
    }

    private void jComboBoxSpeciesQualifier1ActionPerformed(ActionEvent evt) {
        this.handleQualifierSelection(this.jComboBoxSpeciesQualifier1, 4);
    }

    private void jComboBoxSubGenusQualifier2ActionPerformed(ActionEvent evt) {
        this.handleQualifierSelection(this.jComboBoxSubGenusQualifier2, 3);
    }

    private void jComboBoxGenusQualifier2ActionPerformed(ActionEvent evt) {
        this.handleQualifierSelection(this.jComboBoxGenusQualifier2, 1);
    }

    private void jComboBoxSubGenusQualifier1ActionPerformed(ActionEvent evt) {
        this.handleQualifierSelection(this.jComboBoxSubGenusQualifier1, 2);
    }

    private void jComboBoxGenusQualifier1ActionPerformed(ActionEvent evt) {
        this.handleQualifierSelection(this.jComboBoxGenusQualifier1, 0);
    }

    private void jButtonSpeciesActionPerformed(ActionEvent evt) {
        try {
            String cat_mnem = this.categoryComboBox.getSelectedMnemonic();
            if (cat_mnem.isEmpty()) {
                JOptionPane.showMessageDialog(this, "Select a category", this.getTitle(), 2);
                return;
            }
            String genus = this.jTextFieldGenus.getText().trim();
            if (genus.isEmpty()) {
                JOptionPane.showMessageDialog(this, "Enter start of genus name to look up", this.getTitle(), 1);
                return;
            }
            String species = this.jTextFieldSpecies.getText();
            List<String> list = model3.Taxon.lookupSpecies(this.db, cat_mnem, genus, species);
            if (list.isEmpty()) {
                JOptionPane.showMessageDialog(this, "No species found", this.getTitle(), 1);
                return;
            }
            DialogList<String> dialog = new DialogList<String>(this, true, "Select Species", new UserPrefsHelper(this.db), list, true, false);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.getSelection() != null) {
                String item = dialog.getSelection();
                String subsp = null;
                String ss = " subsp. ";
                if (item.contains(ss)) {
                    int index = item.lastIndexOf(ss);
                    subsp = item.substring(index + ss.length());
                    item = item.substring(0, index);
                }
                this.jTextFieldSpecies.setText(item);
                if (subsp != null) {
                    this.jTextFieldSubSpecies.setText(subsp);
                }
            }
        }
        catch (SQLException sql) {
            SbugsExceptionHandler.showStackError("Error looking up species", sql, this);
        }
    }

    private void setFields() {
        for (int i = 0; i < 8; ++i) {
            Object o = this.fields[i];
            if (o != null) {
                if (!(o instanceof TaxonQual)) continue;
                this.fields[i] = new Qualifier(i, (TaxonQual)o);
                continue;
            }
            this.fields[i] = new Qualifier(i);
        }
    }

    private Taxon getTaxonFromFields() {
        this.setFields();
        Genus genus = new Genus();
        genus.setCategory((Category)this.categoryComboBox.getSelectedCategory().orElse(null));
        genus.setGenusName(this.jTextFieldGenus.getText().trim());
        genus.setSubGenus(this.jTextFieldSubGenus.getText().trim());
        for (int i = 0; i < 4; ++i) {
            genus.setQualifier(i, (Qualifier)this.fields[i]);
        }
        Taxon taxon = new Taxon();
        taxon.setGenus(genus);
        taxon.setSpecies(this.jTextFieldSpecies.getText().trim());
        taxon.setSubSpecies(this.jTextFieldSubSpecies.getText().trim());
        for (int i = 4; i < 8; ++i) {
            taxon.setQualifier(i, (Qualifier)this.fields[i]);
        }
        taxon.setAuthor(this.jTextFieldAuthor.getText());
        taxon.setAlphaCode(this.jTextFieldAlphanumericCode.getText());
        return taxon;
    }

    private void jButtonGeneraActionPerformed(ActionEvent evt) {
        try {
            class CatGen {
                final Genus genus;

                CatGen(DialogTaxon this$0, Genus genus) {
                    Objects.requireNonNull(this$0);
                    this.genus = genus;
                }

                public String toString() {
                    return this.genus.toString(true);
                }
            }
            this.setFields();
            Genus lookup = new Genus();
            lookup.setCategory((Category)this.categoryComboBox.getSelectedCategory().orElse(null));
            lookup.setGenusName(this.jTextFieldGenus.getText().trim() + "%");
            lookup.setSubGenus(this.jTextFieldSubGenus.getText().trim() + "%");
            for (int i = 0; i < 4; ++i) {
                lookup.setQualifier(i, (Qualifier)this.fields[i]);
            }
            List list = this.db.getGenusService().findMatchingGenera(lookup, SearchMode.SEARCH);
            if (list.isEmpty()) {
                JOptionPane.showMessageDialog(this, "No genera found", this.getTitle(), 1);
                return;
            }
            List newList = list.stream().map(g -> new CatGen(this, (Genus)g)).collect(Collectors.toList());
            DialogList dialog = new DialogList(this, true, "Select Genus", new UserPrefsHelper(this.db), newList, true, false);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.getSelection() != null) {
                Genus genus = ((CatGen)dialog.getSelection()).genus;
                this.categoryComboBox.setSelectedCategory(genus.getCategory().getMnemonic());
                this.jTextFieldGenus.setText(genus.getGenusName());
                this.jTextFieldSubGenus.setText(genus.getSubGenus());
                this.selectQualifier(this.jComboBoxGenusQualifier1, genus.getQ1());
                this.selectQualifier(this.jComboBoxGenusQualifier2, genus.getQ2());
                this.selectQualifier(this.jComboBoxSubGenusQualifier1, genus.getQ3());
                this.selectQualifier(this.jComboBoxSubGenusQualifier2, genus.getQ4());
            }
        }
        catch (RuntimeException e) {
            SbugsExceptionHandler.showStackError(e, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonOKActionPerformed(ActionEvent evt) {
        String msg;
        int opt2;
        String otherCategoriesWithGenus;
        Taxon t = this.getTaxonFromFields();
        if (this.taxon != null) {
            if (this.taxon.getTaxonCopy().equivalent(t) && StringUtils.equals((CharSequence)this.taxon.getAlphaCode(), (CharSequence)t.getAlphaCode()) && StringUtils.equals((CharSequence)this.taxon.getAuthor(), (CharSequence)t.getAuthor())) {
                this.dispose();
                return;
            }
        } else {
            if (this.refsAndNotes != null) {
                t.setReference(this.refsAndNotes.reference);
                t.setNotes(this.refsAndNotes.notes);
                t.setUrl(this.refsAndNotes.url);
            }
            this.doTaxonAdd(t);
            return;
        }
        t.setReference(this.taxon.getReference());
        t.setNotes(this.taxon.getNotes());
        t.setUrl(this.taxon.getURL());
        SbugsValidator validator = SbugsValidator.validate((Object)t, (SbugsValidator.ValidationStrategy)SbugsValidator.ValidationStrategy.IGNORE_ID);
        List validatorMessages = validator.getMessages();
        if (!validatorMessages.isEmpty()) {
            Object message = "Invalid fields:\n";
            message = (String)message + StringUtils.join((Iterable)validator.getMessages(), (String)"\n");
            JOptionPane.showMessageDialog(this, message, this.getTitle(), 2);
            return;
        }
        boolean hasQ = false;
        for (int i = 0; i < 8; ++i) {
            hasQ = i < 4 ? t.getQualifier(i).hasQual(TaxonQual.Q) : t.getGenus().getQualifier(i - 4).hasQual(TaxonQual.Q);
            if (!hasQ) continue;
            if (JOptionPane.showConfirmDialog(this, "The name contains a '?'. Consider using questionable occurrences rather than creating new species.\nDo you want to continue?", this.getTitle(), 0, 3) == 0) break;
            return;
        }
        Category category = t.getGenus().getCategory();
        t.getGenus().setCategory(null);
        List matchingTaxaInAllCategories = this.db.getTaxonService().findMatchingTaxa(t, null, SearchMode.LOOKUP);
        if (!matchingTaxaInAllCategories.isEmpty()) {
            String msg2;
            int opt;
            ArrayList<Category> existingCats = new ArrayList<Category>();
            for (Taxon match : matchingTaxaInAllCategories) {
                if (this.taxon != null && match.getSpecID() == this.taxon.getSpecID()) continue;
                if (match.getGenus().getCategory().equals((Object)category)) {
                    Object existsMsg = "This taxon already exists.";
                    if (this.taxon == null) {
                        JOptionPane.showMessageDialog(this, existsMsg, this.getTitle(), 2);
                        return;
                    }
                    int opt3 = JOptionPane.showConfirmDialog(this, existsMsg = (String)existsMsg + "\nWould you like to merge '" + this.taxon.toString(false, false) + "' with '" + String.valueOf(match) + "'?", this.getTitle(), 0);
                    if (opt3 != 0) {
                        return;
                    }
                    this.merge(match);
                    this.dispose();
                    return;
                }
                existingCats.add(match.getGenus().getCategory());
            }
            if (!existingCats.isEmpty() && (opt = JOptionPane.showConfirmDialog(this, msg2 = "This taxon already exists in categor" + (existingCats.size() > 1 ? "ies: " : "y: ") + StringUtils.join(existingCats, (String)", ") + "\nDo you still want to add it?", this.getTitle(), 0, 3)) != 0) {
                return;
            }
        }
        Genus existingMatchingGenus = null;
        List matchingGeneraInAllCategories = this.db.getGenusService().findMatchingGenera(t.getGenus(), SearchMode.LOOKUP);
        if (!matchingGeneraInAllCategories.isEmpty() && (existingMatchingGenus = (Genus)matchingGeneraInAllCategories.stream().filter(matchingGenus -> matchingGenus.getCategory().equals((Object)category)).findAny().orElse(null)) == null && !(otherCategoriesWithGenus = matchingGeneraInAllCategories.stream().map(matchingGenus -> matchingGenus.getCategory()).filter(categoryOfMatchingGenus -> !categoryOfMatchingGenus.equals((Object)category)).map(Category::getMnemonic).collect(Collectors.joining(", "))).isEmpty() && (opt2 = JOptionPane.showConfirmDialog(this, msg = "Genus already exists in categor" + (otherCategoriesWithGenus.contains(",") ? "ies: " : "y: ") + otherCategoriesWithGenus + "\nDo you still want to add it to " + category.getName() + "?", this.getTitle(), 0, 3)) != 0) {
            return;
        }
        t.getGenus().setCategory(category);
        String originalName = this.taxon != null ? this.taxon.toString(false, false) : "";
        int synSchID = InternalFrameTaxa.getSynSchID(this.db);
        Taxon juniorSynonym = null;
        if (this.taxon != null) {
            int nOcc;
            try {
                this.setCursor(Cursor.getPredefinedCursor(3));
                nOcc = this.taxon.checkOcc(false);
            }
            catch (SQLException ex) {
                SbugsExceptionHandler.showStackError("Error checking occurrences of existing taxon", ex, this);
                return;
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
            if (nOcc != 0) {
                String confirmMessage = "There " + (nOcc > 1 ? "are " + nOcc + " sample occurrences (maybe from different wells)" : "is " + nOcc + " sample occurrence") + " of this taxon. Are you sure you want to update it?";
                if (!this.taxon.getTaxonCopy().equivalent(t)) {
                    String synSchName;
                    try {
                        synSchName = this.db.getSynSch(synSchID).getName();
                    }
                    catch (SQLException e) {
                        SbugsExceptionHandler.showStackError("Error getting synonym scheme name", e, this);
                        return;
                    }
                    confirmMessage = confirmMessage + "\nYou can also create a new junior synonym for: " + originalName + " in scheme: " + synSchName;
                    Object[] buttons = new String[]{"Yes (no synonym)", "Yes (create synonym)", "No"};
                    int opt = JOptionPane.showOptionDialog(this, confirmMessage, "Update taxon", 0, 3, null, buttons, buttons[1]);
                    switch (opt) {
                        case 2: {
                            return;
                        }
                        case 1: {
                            juniorSynonym = this.taxon.getTaxonCopy();
                            juniorSynonym.setGenus(this.taxon.getGenus().getGenusCopy());
                        }
                    }
                } else {
                    int opt = JOptionPane.showConfirmDialog(this, confirmMessage, "Update Taxon", 0, 3);
                    if (opt != 0) {
                        return;
                    }
                }
            }
        }
        Genus targetGenus = existingMatchingGenus;
        try {
            if (targetGenus == null) {
                targetGenus = this.taxon == null ? this.db.getGenusService().addGenus(t.getGenus()) : this.taxon.getGenus().getGenusCopy();
            }
            if (!targetGenus.equivalent(t.getGenus(), false)) {
                int nSpeciesOfGenus = this.db.getTaxonService().getTaxonCountForGenus(targetGenus.getGenID());
                boolean update = true;
                if (nSpeciesOfGenus > 1) {
                    DialogGenusUpdate dialog = new DialogGenusUpdate(this, true, targetGenus, nSpeciesOfGenus, !targetGenus.equivalent(t.getGenus(), true));
                    dialog.setLocationRelativeTo(this);
                    dialog.setVisible(true);
                    if (!dialog.isOK()) {
                        return;
                    }
                    update = dialog.updateAll;
                }
                if (update) {
                    this.db.getGenusService().updateGenus(targetGenus.getGenID(), t.getGenus());
                    targetGenus = (Genus)this.db.getGenusService().findGenus(targetGenus.getGenID()).get();
                } else {
                    targetGenus = this.db.getGenusService().addGenus(t.getGenus());
                }
            }
        }
        catch (RuntimeException ex) {
            SbugsExceptionHandler.showStackError("Error storing genus", ex);
            return;
        }
        t.setGenus(targetGenus);
        assert (t.getGenus().getGenID() > 0);
        if (this.taxon != null) {
            try {
                this.db.getTaxonService().updateTaxon(this.taxon.getSpecID(), t);
                if (DialogTaxonAdded.showUpdated) {
                    DialogTaxonAdded dialog = new DialogTaxonAdded((Dialog)this, true, this.taxon.getSpecID(), true);
                    dialog.setLocationRelativeTo(this);
                    dialog.setVisible(true);
                }
            }
            catch (RuntimeException ex) {
                SbugsExceptionHandler.showStackError("Error updating taxon", ex, this);
                return;
            }
            if (juniorSynonym != null) {
                List matchingGenera = this.db.getGenusService().findMatchingGenera(juniorSynonym.getGenus(), SearchMode.LOOKUP);
                Genus juniorSynonymGenus = !matchingGenera.isEmpty() ? (Genus)matchingGenera.get(0) : this.db.getGenusService().addGenus(juniorSynonym.getGenus());
                juniorSynonym.setGenus(juniorSynonymGenus);
                try {
                    juniorSynonym = this.db.getTaxonService().addTaxon(juniorSynonym);
                    this.db.getSynonymService().addSynonym(synSchID, juniorSynonym.getSpecID(), this.taxon.getSpecID());
                }
                catch (RuntimeException e) {
                    SbugsExceptionHandler.showStackError("Error updating synonymy - but taxon update applied", e);
                }
            }
        } else {
            try {
                this.taxon = this.db.getTaxon(this.db.getTaxonService().addTaxon(t).getSpecID());
            }
            catch (RuntimeException | SQLException e) {
                SbugsExceptionHandler.showStackError("Error adding taxon", e, this);
                return;
            }
            if (DialogTaxonAdded.showAdded) {
                DialogTaxonAdded dialog = new DialogTaxonAdded((Dialog)this, true, this.taxon.getSpecID(), false);
                dialog.setLocationRelativeTo(this);
                dialog.setVisible(true);
            }
        }
        if (!originalName.isEmpty() && !originalName.equals(this.taxon.toString(false, false))) {
            try {
                this.setCursor(Cursor.getPredefinedCursor(3));
                int id = SBEvent.getSBEventSQL(this.db, originalName);
                SBEvent event = null;
                if (id > 0) {
                    event = this.db.getSBEvent(id);
                }
                if (event != null && event.getSpecID() == this.taxon.getSpecID() && JOptionPane.showConfirmDialog(this, "Do you want to update the Event Dictionary name associated with this taxon as well? (recommended)", "Update taxon", 0) == 0) {
                    this.db.updateSBEventName(event, this.taxon.toString(false, false));
                    this.db.commit();
                }
            }
            catch (SQLException | SBException | SBPermissionException ex) {
                SbugsExceptionHandler.showStackError("Error updating event names", ex);
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
        lastCatSelection = category.getMnemonic();
        this.dispose();
    }

    private void doTaxonAdd(Taxon toAdd) {
        TaxonAdd process = new TaxonAdd(this.db.getTaxonService(), this.db.getGenusService(), toAdd);
        while (process.isReady()) {
            process.go();
            if (process.getCurrentMessage() == null) continue;
            int opt = JOptionPane.showConfirmDialog(this, process.getCurrentMessage().message, this.getTitle(), 0, 3);
            if (opt == 0) {
                process.setResponse(ProcessMessage.Response.YES);
                continue;
            }
            return;
        }
        switch (process.getResult().result()) {
            case SUCCESS: {
                if (DialogTaxonAdded.showAdded) {
                    DialogTaxonAdded dialog = new DialogTaxonAdded((Dialog)this, true, process.getSpecID(), false);
                    dialog.setLocationRelativeTo(this);
                    dialog.setVisible(true);
                }
                try {
                    this.taxon = this.db.getTaxon(process.getSpecID());
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
                lastCatSelection = this.taxon.getCatMnem();
                this.dispose();
                break;
            }
            case FAIL: {
                JOptionPane.showMessageDialog(this, process.getResult().resultMessage(), this.getTitle(), 2);
            }
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        HelpUtils.openHelp((String)"dialogtaxon.html");
    }

    private void jButtonUseLastCatActionPerformed(ActionEvent evt) {
        if (lastCatSelection != null) {
            this.categoryComboBox.setSelectedCategory(lastCatSelection);
        }
    }

    private void jRadioButtonMicroActionPerformed(ActionEvent evt) {
        this.setDiscipline(Discipline.MICRO);
    }

    private void jRadioButtonNannoActionPerformed(ActionEvent evt) {
        this.setDiscipline(Discipline.NANNO);
    }

    private void jRadioButtonPalyActionPerformed(ActionEvent evt) {
        this.setDiscipline(Discipline.PALY);
    }

    private void jRadioButtonMacroActionPerformed(ActionEvent evt) {
        this.setDiscipline(Discipline.MACRO);
    }

    private void setDiscipline(Discipline discID) {
        this.categoryComboBox.removeAllItems();
        try {
            this.categoryComboBox.fill(discID);
        }
        catch (RuntimeException e) {
            SbugsExceptionHandler.showStackError(e);
        }
        this.categoryComboBox.setSelectedIndex(0);
        ButtonModel bm = this.buttonGroupDiscipline.getSelection();
        if (bm == null || bm != this.getButtonModel(discID)) {
            switch (discID) {
                case MICRO: {
                    this.jRadioButtonMicro.setSelected(true);
                    break;
                }
                case NANNO: {
                    this.jRadioButtonNanno.setSelected(true);
                    break;
                }
                case PALY: {
                    this.jRadioButtonPaly.setSelected(true);
                    break;
                }
                case MACRO: {
                    this.jRadioButtonMacro.setSelected(true);
                }
            }
        }
    }

    private ButtonModel getButtonModel(Discipline discID) {
        switch (discID) {
            case MICRO: {
                return this.jRadioButtonMicro.getModel();
            }
            case NANNO: {
                return this.jRadioButtonNanno.getModel();
            }
            case PALY: {
                return this.jRadioButtonPaly.getModel();
            }
            case MACRO: {
                return this.jRadioButtonMacro.getModel();
            }
        }
        return null;
    }

    private void merge(Taxon target) {
        if (this.taxon == null || this.taxon.getSpecID() == target.getSpecID()) {
            assert (false);
            return;
        }
        try {
            model3.Taxon modelTarget = this.db.getTaxon(target.getSpecID());
            LinkedList<model3.Taxon> list = new LinkedList<model3.Taxon>();
            list.add(this.taxon);
            list.add(modelTarget);
            DialogMergeTaxa dialog = new DialogMergeTaxa(this, true, this.db, list, modelTarget, this.chartManager);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }
        catch (SQLException sql) {
            SbugsExceptionHandler.showStackError("Error merging taxa", sql, this);
        }
    }

    private record RefsAndNotes(String reference, String notes, String url) {
    }
}

