/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.well.analysis.Situation;
import com.stratadata.model3.well.analysis.hdr.AbundanceScheme;
import com.stratadata.util.ui.HelpUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import jsbugs.DictItem;
import jsbugs.FrameSamples;
import jsbugs.JPanelPicklist;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.Lastval;
import model3.SBdb;
import model3.Taxon;
import model3.TaxonOcc;
import model3.TxGroup;
import util.SB;
import util.SBException;
import util.exception.StackError;

public class DialogTaxonCodeInput
extends JDialog {
    private final SBdb sbdb;
    private final DefaultComboBoxModel dictModel = new DefaultComboBoxModel();
    private final DefaultComboBoxModel groupModel = new DefaultComboBoxModel();
    private final FrameSamples parent;
    private HashMap<Integer, Integer> dictEntries = null;
    private Integer dictID = null;
    private boolean pointCountMode = false;
    private boolean hasEnteredTaxon = false;
    private ButtonGroup buttonGroupMode;
    private ButtonGroup buttonGroupSituation;
    private JButton jButtonAddToSample;
    private JButton jButtonClose;
    private JButton jButtonHelp;
    private JCheckBox jCheckBoxQ;
    private JComboBox jComboBoxDictionary;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JLabel jLabelCount;
    private JPanel jPanel1;
    private JRadioButton jRadioButtonCaved;
    private JRadioButton jRadioButtonInSitu;
    private JRadioButton jRadioButtonPointCount;
    private JRadioButton jRadioButtonReworked;
    private JRadioButton jRadioButtonTotals;
    private JRadioButton jRadioButtonTransported;
    private JTextField jTextFieldCode;
    private JTextField jTextFieldCount;

    public DialogTaxonCodeInput(FrameSamples parent, boolean modal, SBdb sbdb) {
        super((Frame)parent, modal);
        this.initComponents();
        this.sbdb = sbdb;
        this.parent = parent;
        this.init();
    }

    public void refreshDict() {
        this.dictModel.removeAllElements();
        this.groupModel.removeAllElements();
        this.init();
    }

    private void init() {
        this.setTitle("Input logging sheet");
        try {
            HashMap<Integer, String> dicts = this.sbdb.getSIPMDicts();
            Set<Map.Entry<Integer, String>> set = dicts.entrySet();
            int dictPref = Lastval.getInt(this.sbdb, "SIPMDICT");
            DictItem pref = null;
            for (Map.Entry<Integer, String> entry : set) {
                DictItem item = new DictItem(entry.getKey(), entry.getValue());
                this.dictModel.addElement(item);
                if (entry.getKey() != dictPref) continue;
                pref = item;
            }
            if (pref != null) {
                this.dictModel.setSelectedItem(pref);
            }
            for (TxGroup group : this.sbdb.getTxGroups()) {
                this.groupModel.addElement(group);
            }
            int groupPref = Lastval.getInt(this.sbdb, "SIPMGROUP");
            if (groupPref > 0) {
                this.groupModel.setSelectedItem(this.sbdb.getTxGroup(groupPref));
            }
            if (Lastval.getInt(this.sbdb, "LOGPTCT") > 0) {
                this.pointCountMode = true;
                this.jRadioButtonPointCount.setSelected(true);
                this.setFields(this.pointCountMode);
            }
        }
        catch (SQLException ex) {
            SbugsExceptionHandler.showStackError(ex, this);
        }
        Vector<Component> order = new Vector<Component>(4);
        order.add(this.jTextFieldCode);
        order.add(this.jTextFieldCount);
        order.add(this.jButtonAddToSample);
        this.setNumeric();
        SBugsFocusTraversalPolicy focusPolicy = new SBugsFocusTraversalPolicy(this, order);
        this.setFocusTraversalPolicy(focusPolicy);
    }

    private void initComponents() {
        this.buttonGroupMode = new ButtonGroup();
        this.buttonGroupSituation = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.jComboBoxDictionary = new JComboBox();
        this.jPanel1 = new JPanel();
        this.jTextFieldCount = new JTextField();
        this.jTextFieldCode = new JTextField();
        this.jLabel3 = new JLabel();
        this.jLabelCount = new JLabel();
        this.jCheckBoxQ = new JCheckBox();
        this.jButtonAddToSample = new JButton();
        this.jRadioButtonReworked = new JRadioButton();
        this.jRadioButtonTransported = new JRadioButton();
        this.jRadioButtonCaved = new JRadioButton();
        this.jRadioButtonInSitu = new JRadioButton();
        this.jButtonClose = new JButton();
        this.jButtonHelp = new JButton();
        this.jRadioButtonTotals = new JRadioButton();
        this.jRadioButtonPointCount = new JRadioButton();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jLabel1.setText("Dictionary:");
        this.jComboBoxDictionary.setModel(this.dictModel);
        this.jComboBoxDictionary.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTaxonCodeInput this$0;
            {
                DialogTaxonCodeInput dialogTaxonCodeInput = this$0;
                Objects.requireNonNull(dialogTaxonCodeInput);
                this.this$0 = dialogTaxonCodeInput;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jComboBoxDictionaryActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jTextFieldCount.setFont(new Font("Tahoma", 1, 13));
        this.jTextFieldCount.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogTaxonCodeInput this$0;
            {
                DialogTaxonCodeInput dialogTaxonCodeInput = this$0;
                Objects.requireNonNull(dialogTaxonCodeInput);
                this.this$0 = dialogTaxonCodeInput;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldCountKeyTyped(evt);
            }
        });
        this.jTextFieldCode.setFont(new Font("Tahoma", 1, 13));
        this.jTextFieldCode.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogTaxonCodeInput this$0;
            {
                DialogTaxonCodeInput dialogTaxonCodeInput = this$0;
                Objects.requireNonNull(dialogTaxonCodeInput);
                this.this$0 = dialogTaxonCodeInput;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldCodeKeyTyped(evt);
            }
        });
        this.jLabel3.setHorizontalAlignment(11);
        this.jLabel3.setText("Code:");
        this.jLabelCount.setHorizontalAlignment(11);
        this.jLabelCount.setText("Count:");
        this.jCheckBoxQ.setText("?");
        this.jButtonAddToSample.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/FrameSamples_AddTaxon.png")));
        this.jButtonAddToSample.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTaxonCodeInput this$0;
            {
                DialogTaxonCodeInput dialogTaxonCodeInput = this$0;
                Objects.requireNonNull(dialogTaxonCodeInput);
                this.this$0 = dialogTaxonCodeInput;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAddToSampleActionPerformed(evt);
            }
        });
        this.buttonGroupSituation.add(this.jRadioButtonReworked);
        this.jRadioButtonReworked.setText("Rw");
        this.jRadioButtonReworked.setToolTipText("Reworked");
        this.buttonGroupSituation.add(this.jRadioButtonTransported);
        this.jRadioButtonTransported.setText("Tr");
        this.jRadioButtonTransported.setToolTipText("Transported");
        this.buttonGroupSituation.add(this.jRadioButtonCaved);
        this.jRadioButtonCaved.setText("Cv");
        this.jRadioButtonCaved.setToolTipText("Caved");
        this.buttonGroupSituation.add(this.jRadioButtonInSitu);
        this.jRadioButtonInSitu.setText("In-situ");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabelCount).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonAddToSample).addComponent(this.jTextFieldCount, -2, 93, -2))).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldCode, -2, 93, -2))).addGap(6, 6, 6).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButtonInSitu).addComponent(this.jRadioButtonTransported)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButtonCaved).addComponent(this.jRadioButtonReworked))).addComponent(this.jCheckBoxQ)).addContainerGap()));
        jPanel1Layout.linkSize(0, this.jLabel3, this.jLabelCount);
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(14, 14, 14).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jTextFieldCode, -2, -1, -2).addComponent(this.jRadioButtonReworked).addComponent(this.jRadioButtonInSitu)).addGap(4, 4, 4).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldCount, -2, -1, -2).addComponent(this.jLabelCount).addComponent(this.jRadioButtonTransported).addComponent(this.jRadioButtonCaved)).addGap(9, 9, 9).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonAddToSample).addComponent(this.jCheckBoxQ)).addContainerGap(14, Short.MAX_VALUE)));
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTaxonCodeInput this$0;
            {
                DialogTaxonCodeInput dialogTaxonCodeInput = this$0;
                Objects.requireNonNull(dialogTaxonCodeInput);
                this.this$0 = dialogTaxonCodeInput;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCloseActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTaxonCodeInput this$0;
            {
                DialogTaxonCodeInput dialogTaxonCodeInput = this$0;
                Objects.requireNonNull(dialogTaxonCodeInput);
                this.this$0 = dialogTaxonCodeInput;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        this.buttonGroupMode.add(this.jRadioButtonTotals);
        this.jRadioButtonTotals.setSelected(true);
        this.jRadioButtonTotals.setText("Enter counts");
        this.jRadioButtonTotals.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTaxonCodeInput this$0;
            {
                DialogTaxonCodeInput dialogTaxonCodeInput = this$0;
                Objects.requireNonNull(dialogTaxonCodeInput);
                this.this$0 = dialogTaxonCodeInput;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonTotalsActionPerformed(evt);
            }
        });
        this.buttonGroupMode.add(this.jRadioButtonPointCount);
        this.jRadioButtonPointCount.setText("Point count");
        this.jRadioButtonPointCount.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTaxonCodeInput this$0;
            {
                DialogTaxonCodeInput dialogTaxonCodeInput = this$0;
                Objects.requireNonNull(dialogTaxonCodeInput);
                this.this$0 = dialogTaxonCodeInput;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonPointCountActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxDictionary, 0, -1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonClose)).addGroup(layout.createSequentialGroup().addComponent(this.jRadioButtonTotals).addGap(18, 18, 18).addComponent(this.jRadioButtonPointCount, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        layout.linkSize(0, this.jButtonClose, this.jButtonHelp);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBoxDictionary, -2, -1, -2).addComponent(this.jLabel1)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButtonTotals).addComponent(this.jRadioButtonPointCount)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonClose).addComponent(this.jButtonHelp)).addContainerGap()));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        try {
            Lastval.putInt(this.sbdb, "LOGPTCT", this.pointCountMode ? 1 : 0);
            this.sbdb.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.dispose();
    }

    private void jButtonAddToSampleActionPerformed(ActionEvent evt) {
        if (this.jTextFieldCode.getText().isEmpty()) {
            JOptionPane.showMessageDialog(this, "Enter a numeric code", this.getTitle(), 2);
            return;
        }
        int code = Integer.parseInt(this.jTextFieldCode.getText());
        if (this.jTextFieldCount.getText().isEmpty()) {
            JOptionPane.showMessageDialog(this, "Enter count", this.getTitle(), 2);
            return;
        }
        String count = this.jTextFieldCount.getText();
        try {
            this.addToSample(code, count);
        }
        catch (SBException sbe) {
            this.sbdb.doRollback();
            JOptionPane.showMessageDialog(this, sbe.getMessage(), "Error", 2);
            sbe.printStackTrace();
            this.jTextFieldCode.setSelectionStart(0);
            this.jTextFieldCode.setSelectionEnd(this.jTextFieldCode.getText().length() - 1);
            this.jTextFieldCode.requestFocusInWindow();
        }
        catch (SQLException sql) {
            SbugsExceptionHandler.showStackError(sql, this);
        }
        this.jTextFieldCode.setText("");
        this.jTextFieldCount.setText("");
        this.jRadioButtonInSitu.setSelected(true);
        this.jCheckBoxQ.setSelected(false);
        this.jTextFieldCode.requestFocusInWindow();
    }

    private void jTextFieldCodeKeyTyped(KeyEvent evt) {
        if (this.pointCountMode) {
            if (this.checkEnter(evt.getKeyChar())) {
                this.hasEnteredTaxon = true;
                return;
            }
            if (this.hasEnteredTaxon) {
                this.jTextFieldCode.setText(null);
                this.hasEnteredTaxon = false;
            }
        }
        if (SB.intFieldVal((JTextField)this.jTextFieldCode, (int)10, (KeyEvent)evt, (boolean)false) && !this.toggleCheckbox(evt.getKeyChar())) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldCountKeyTyped(KeyEvent evt) {
        if (this.parent.isNumeric()) {
            if (SB.intFieldVal((JTextField)this.jTextFieldCount, (int)10, (KeyEvent)evt, (boolean)false) && !this.toggleCheckbox(evt.getKeyChar())) {
                this.getToolkit().beep();
            }
        } else {
            char c = evt.getKeyChar();
            AbundanceScheme abnScheme = this.sbdb.getAbundanceSchemeService().findAbundanceScheme(this.parent.getTableModelOcc().smpdtl.getHeader().getAbnSchID()).orElse(null);
            if (abnScheme == null) {
                JOptionPane.showMessageDialog(this, "No abundance scheme set for selected analysis suite.\nSet an abundance scheme for this suite, or switch to quantitative mode.", this.getTitle(), 2);
                evt.consume();
                return;
            }
            if (Character.isDigit(c)) {
                int nClass = Character.getNumericValue(c) - 1;
                if (nClass > -1 && nClass < abnScheme.getEntryCount()) {
                    this.jTextFieldCount.setText(abnScheme.getEntry(nClass).abr());
                } else {
                    this.getToolkit().beep();
                }
            } else {
                int index = abnScheme.getIndex(String.valueOf(c));
                if (index < 0) {
                    this.getToolkit().beep();
                } else {
                    this.jTextFieldCount.setText(abnScheme.getEntry(index).abr());
                }
            }
            evt.consume();
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        HelpUtils.openHelp((String)"howtousenumericcodes.html");
    }

    private void jComboBoxDictionaryActionPerformed(ActionEvent evt) {
        this.setDictEntries();
    }

    private void jRadioButtonTotalsActionPerformed(ActionEvent evt) {
        if (this.pointCountMode) {
            this.pointCountMode = false;
            this.setFields(this.pointCountMode);
        }
    }

    private void jRadioButtonPointCountActionPerformed(ActionEvent evt) {
        if (!this.pointCountMode) {
            this.pointCountMode = true;
            this.setFields(this.pointCountMode);
        }
    }

    private void setFields(boolean pointCountMode) {
        this.jTextFieldCount.setEnabled(!pointCountMode);
        this.jButtonAddToSample.setEnabled(!pointCountMode);
    }

    private void setDictEntries() {
        int newID = ((DictItem)this.dictModel.getSelectedItem()).code;
        if (this.dictID != null && newID == this.dictID) {
            return;
        }
        try {
            this.dictID = newID;
            System.out.println("Loading SIPM dictionary " + this.dictID + "...");
            this.dictEntries = this.sbdb.getSipmDictEntries(this.dictID, false);
        }
        catch (Exception e) {
            StackError.showStackError((String)"Error setting SIPM dictionary", (Throwable)e);
        }
    }

    boolean toggleCheckbox(char c) {
        if (c == 'r') {
            this.jRadioButtonReworked.setSelected(true);
            return true;
        }
        if (c == 'c') {
            this.jRadioButtonCaved.setSelected(true);
            return true;
        }
        if (c == 't') {
            this.jRadioButtonTransported.setSelected(true);
            return true;
        }
        if (c == 'q') {
            this.jCheckBoxQ.setSelected(!this.jCheckBoxQ.isSelected());
            return true;
        }
        return false;
    }

    private boolean checkEnter(int keyCode) {
        try {
            if (keyCode == 10 && this.pointCountMode) {
                int code = Integer.parseInt(this.jTextFieldCode.getText());
                if (code == 0) {
                    return false;
                }
                this.addToSample(code, "1");
                return true;
            }
        }
        catch (SBException sbe) {
            this.sbdb.doRollback();
            JOptionPane.showMessageDialog(this, sbe.getMessage(), "Error", 2);
            sbe.printStackTrace();
            this.jTextFieldCode.setSelectionStart(0);
            this.jTextFieldCode.setSelectionEnd(this.jTextFieldCode.getText().length() - 1);
            this.jTextFieldCode.requestFocusInWindow();
        }
        catch (SQLException sql) {
            SbugsExceptionHandler.showStackError(sql, this);
        }
        return false;
    }

    private void addToSample(int code, String abund) throws SQLException, SBException {
        TaxonOcc existing;
        int count = 0;
        String subjAbund = "";
        if (Character.isDigit(abund.charAt(0))) {
            count = Integer.parseInt(abund);
        } else {
            subjAbund = abund;
        }
        Integer specID = this.dictEntries.get(code);
        if (specID == null) {
            this.getToolkit().beep();
            JOptionPane.showMessageDialog(this, "No taxon found", this.getTitle(), 2);
            this.jTextFieldCode.setSelectionStart(0);
            this.jTextFieldCode.setSelectionEnd(this.jTextFieldCode.getText().length());
            this.jTextFieldCode.requestFocusInWindow();
            return;
        }
        Taxon taxon = this.sbdb.getTaxon(specID);
        if (this.pointCountMode && (existing = this.parent.getTableModelOcc().smpdtl.getFss(taxon, this.getSituation(), this.jCheckBoxQ.isSelected() ? (char)'?' : 'P', 0)) != null && !existing.getSubAbund().isEmpty() && JOptionPane.showConfirmDialog(this, "Overwrite existing semi-quant data?", this.getTitle(), 0) != 0) {
            return;
        }
        JPanelPicklist.addToSample(taxon, count, subjAbund, this.getSituation(), this.jCheckBoxQ.isSelected(), this.parent, this.sbdb);
    }

    Situation getSituation() {
        if (this.jRadioButtonTransported.isSelected()) {
            return Situation.TR;
        }
        if (this.jRadioButtonReworked.isSelected()) {
            return Situation.RW;
        }
        if (this.jRadioButtonCaved.isSelected()) {
            return Situation.CV;
        }
        return Situation.INSITU;
    }

    void setNumeric() {
        if (this.parent.isNumeric()) {
            this.jLabelCount.setText("Count:");
        } else {
            this.jLabelCount.setText("Abund:");
        }
    }

    class SBugsFocusTraversalPolicy
    extends FocusTraversalPolicy {
        Vector<Component> order;

        SBugsFocusTraversalPolicy(DialogTaxonCodeInput this$0, Vector<Component> order) {
            Objects.requireNonNull(this$0);
            this.order = new Vector(order.size());
            this.order.addAll(order);
        }

        @Override
        public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
            int idx = (this.order.indexOf(aComponent) + 1) % this.order.size();
            return this.order.get(idx);
        }

        @Override
        public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
            int idx = this.order.indexOf(aComponent) - 1;
            if (idx < 0) {
                idx = this.order.size() - 1;
            }
            return this.order.get(idx);
        }

        @Override
        public Component getDefaultComponent(Container focusCycleRoot) {
            return this.order.get(0);
        }

        @Override
        public Component getLastComponent(Container focusCycleRoot) {
            return this.order.lastElement();
        }

        @Override
        public Component getFirstComponent(Container focusCycleRoot) {
            return this.order.get(0);
        }
    }
}

