/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.util.ui.SBDialog;
import com.stratadata.util.ui.table.ColumnSortResetHandler;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.table.TableRowSorter;
import jsbugs.DictItem;
import jsbugs.FrameJsbugs;
import jsbugs.TableModelCodes;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.Lastval;
import model3.SBdb;
import model3.TxGroup;
import util.SBException;
import util.SBPermissionException;
import util.table.SbugsTable;

public class DialogTaxonCodePrint
extends SBDialog {
    SBdb sbdb;
    LinkedList<TxGroup> groups;
    DefaultComboBoxModel dictModel = new DefaultComboBoxModel();
    TableModelCodes model = new TableModelCodes();
    HashMap<Integer, String> dicts;
    int nEmpty = 0;
    private JButton jButtonCancel;
    private JButton jButtonGenerate;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JComboBox jComboBoxDict;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSpinner jSpinnerBlanks;
    private JSpinner jSpinnerGenerate;
    private JTable jTableCodes;

    public DialogTaxonCodePrint(Frame parent, boolean modal, SBdb sbdb, LinkedList<TxGroup> groups) {
        super(parent, modal);
        this.sbdb = sbdb;
        this.groups = groups;
        this.initComponents();
        this.init();
    }

    private void init() {
        try {
            this.dicts = this.sbdb.getSIPMDicts();
            this.model.initTable(this.jTableCodes);
            this.jTableCodes.setRowSorter(new TableRowSorter<TableModelCodes>(this.model));
            new ColumnSortResetHandler(this.jTableCodes).attach();
            Set<Map.Entry<Integer, String>> set = this.dicts.entrySet();
            int dictPref = Lastval.getInt(this.sbdb, "SIPMDICT");
            DictItem pref = null;
            for (Map.Entry<Integer, String> entry : set) {
                DictItem item = new DictItem(entry.getKey(), entry.getValue());
                this.dictModel.addElement(item);
                if (item.code != dictPref) continue;
                pref = item;
            }
            if (pref != null) {
                this.dictModel.setSelectedItem(pref);
            }
        }
        catch (SQLException sql) {
            SbugsExceptionHandler.showDialogStackError(sql, null);
        }
        Object title = "Numeric Codes";
        if (this.groups.size() == 1) {
            title = (String)title + " : " + this.groups.get(0).getName();
        }
        this.setTitle((String)title);
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTableCodes = new SbugsTable();
        this.jLabel1 = new JLabel();
        this.jComboBoxDict = new JComboBox();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jLabel2 = new JLabel();
        this.jSpinnerBlanks = new JSpinner();
        this.jSeparator1 = new JSeparator();
        this.jLabel3 = new JLabel();
        this.jButtonGenerate = new JButton();
        this.jSpinnerGenerate = new JSpinner();
        this.jButtonHelp = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(300, 350));
        this.jTableCodes.setModel(this.model);
        this.jScrollPane1.setViewportView(this.jTableCodes);
        this.jLabel1.setText("Dictionary:");
        this.jComboBoxDict.setModel(this.dictModel);
        this.jComboBoxDict.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTaxonCodePrint this$0;
            {
                DialogTaxonCodePrint dialogTaxonCodePrint = this$0;
                Objects.requireNonNull(dialogTaxonCodePrint);
                this.this$0 = dialogTaxonCodePrint;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jComboBoxDictActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTaxonCodePrint this$0;
            {
                DialogTaxonCodePrint dialogTaxonCodePrint = this$0;
                Objects.requireNonNull(dialogTaxonCodePrint);
                this.this$0 = dialogTaxonCodePrint;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("Save and Print");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTaxonCodePrint this$0;
            {
                DialogTaxonCodePrint dialogTaxonCodePrint = this$0;
                Objects.requireNonNull(dialogTaxonCodePrint);
                this.this$0 = dialogTaxonCodePrint;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Additional blank rows:");
        this.jSpinnerBlanks.setModel(new SpinnerNumberModel((Number)0, null, Integer.valueOf(30), (Number)1));
        this.jLabel3.setText("Generate codes starting from:");
        this.jButtonGenerate.setText("Generate");
        this.jButtonGenerate.setMargin(new Insets(2, 10, 2, 10));
        this.jButtonGenerate.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTaxonCodePrint this$0;
            {
                DialogTaxonCodePrint dialogTaxonCodePrint = this$0;
                Objects.requireNonNull(dialogTaxonCodePrint);
                this.this$0 = dialogTaxonCodePrint;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonGenerateActionPerformed(evt);
            }
        });
        this.jSpinnerGenerate.setModel(new SpinnerNumberModel((Number)1, Integer.valueOf(1), null, (Number)1));
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTaxonCodePrint this$0;
            {
                DialogTaxonCodePrint dialogTaxonCodePrint = this$0;
                Objects.requireNonNull(dialogTaxonCodePrint);
                this.this$0 = dialogTaxonCodePrint;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSpinnerGenerate, -1, 56, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonGenerate)).addComponent(this.jScrollPane1, -2, 0, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxDict, 0, -1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSpinnerBlanks, -2, 45, -2)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel))))).addContainerGap()));
        layout.linkSize(0, this.jButtonCancel, this.jButtonHelp);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jComboBoxDict, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jButtonGenerate).addComponent(this.jSpinnerGenerate, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jScrollPane1, -1, 260, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jSpinnerBlanks, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 10, -2).addGap(1, 1, 1).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonOK).addComponent(this.jButtonHelp)).addContainerGap()));
        this.pack();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.jTableCodes.isEditing()) {
            this.jTableCodes.getCellEditor().stopCellEditing();
        }
        LinkedList<Integer> codes = new LinkedList<Integer>();
        for (TableModelCodes.TableItem item : this.model.taxa) {
            if (item.code == null) {
                JOptionPane.showMessageDialog((Component)((Object)this), "All taxa must be given a numeric code", this.getTitle(), 2);
                return;
            }
            if (codes.contains(item.code)) {
                JOptionPane.showMessageDialog((Component)((Object)this), "The table contains duplicate codes", this.getTitle(), 2);
                return;
            }
            codes.add(item.code);
        }
        LinkedList<TableModelCodes.TableItem> toUpdate = new LinkedList<TableModelCodes.TableItem>();
        int nUpdates = 0;
        try {
            for (TableModelCodes.TableItem item : this.model.taxa) {
                Integer initialCode = item.taxon.getSipmCode(this.model.dict);
                if (initialCode != null && initialCode.equals(item.code)) continue;
                nUpdates += initialCode != null ? 1 : 0;
                toUpdate.add(item);
            }
            if (nUpdates > 0) {
                Object msg = nUpdates + " code" + (nUpdates == 1 ? "" : "s") + " to be updated.\n";
                if ((this.sbdb.getUser().getPriv() & 0x40) == 0) {
                    msg = (String)msg + "Only super users can update existing numeric codes.";
                    msg = (String)msg + "\nOriginal codes will be retained";
                    JOptionPane.showMessageDialog((Component)((Object)this), msg, this.getTitle(), 2);
                    Iterator<Object> it = toUpdate.iterator();
                    while (it.hasNext()) {
                        TableModelCodes.TableItem item = (TableModelCodes.TableItem)it.next();
                        if (item.taxon.getSipmCode(this.model.dict) == null) continue;
                        it.remove();
                    }
                } else if (JOptionPane.showConfirmDialog((Component)((Object)this), msg = (String)msg + "This might affect logging sheets already printed.\nAre you sure you want to continue?", this.getTitle(), 0) != 0) {
                    return;
                }
                this.sbdb.clearSipmDict(this.model.dict);
                for (TableModelCodes.TableItem item : this.model.taxa) {
                    item.taxon.storeSipmCode(this.model.dict, item.code);
                }
            } else {
                for (TableModelCodes.TableItem item : toUpdate) {
                    item.taxon.storeSipmCode(this.model.dict, item.code);
                }
            }
            if (this.groups.size() == 1) {
                Lastval.putInt(this.sbdb, "SIPMGROUP", this.groups.get(0).getID());
            }
            Lastval.putInt(this.sbdb, "SIPMDICT", this.model.dict);
            this.sbdb.commit();
            this.setOK();
        }
        catch (SBPermissionException pe) {
            JOptionPane.showMessageDialog((Component)((Object)this), pe.getMessage(), this.getTitle(), 2);
        }
        catch (SQLException | SBException ex) {
            FrameJsbugs.showStackError("Error", (Exception)ex, this.sbdb);
            this.sbdb.doRollback();
        }
        this.nEmpty = (Integer)this.jSpinnerBlanks.getModel().getValue();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jComboBoxDictActionPerformed(ActionEvent evt) {
        try {
            this.model.setData(((DictItem)this.jComboBoxDict.getSelectedItem()).code, this.groups, this.sbdb);
        }
        catch (SQLException | SBException ex) {
            SbugsExceptionHandler.showStackError(ex, (Component)((Object)this));
        }
        this.model.fireTableDataChanged();
    }

    private void jButtonGenerateActionPerformed(ActionEvent evt) {
        HashMap<Integer, Integer> dictEntries;
        try {
            dictEntries = this.sbdb.getSipmDictEntries(this.model.dict, true);
        }
        catch (SQLException sql) {
            SbugsExceptionHandler.showStackError(sql, (Component)((Object)this));
            return;
        }
        for (TableModelCodes.TableItem item : this.model.taxa) {
            if (item.code == null) continue;
            dictEntries.put(item.taxon.getSpecID(), item.code);
        }
        int value = (Integer)this.jSpinnerGenerate.getValue();
        for (TableModelCodes.TableItem item : this.model.taxa) {
            if (item.code != null) continue;
            while (dictEntries.containsValue(value)) {
                ++value;
            }
            item.code = value;
            dictEntries.put(item.taxon.getSpecID(), value);
        }
        this.model.fireTableDataChanged();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("howtousenumericcodes.html");
    }
}

