/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.taxon.Taxon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import jsbugs.DialogSelectTaxa;
import jsbugs.DialogcoOccurrences;
import jsbugs.FrameJsbugs;
import model3.SBdb;
import model3.TaxonOcc;
import model3.Well;
import org.jdesktop.layout.GroupLayout;
import util.SBException;
import util.exception.StackError;

public class DialogTaxonReassign
extends JDialog {
    private final SBdb db;
    private final Well well;
    private final model3.Taxon orig;
    model3.Taxon target;
    private final int synSchID;
    boolean isOK;
    private JButton jButtonCancel;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JButton jButtonSelectTaxon;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabelInsitu;
    private JLabel jLabelNQ;
    private JLabel jLabelNRw;
    private JLabel jLabelNTr;
    private JLabel jLabelNinSitu;
    private JLabel jLabelQuestionable;
    private JLabel jLabelReworked;
    private JLabel jLabelTotalOcc;
    private JLabel jLabelTransported;
    private JSeparator jSeparator1;
    private JTextField jTextFieldOrig;
    private JTextField jTextFieldTarget;

    public DialogTaxonReassign(Frame parent, boolean modal, SBdb db, int synSchID, Well well, model3.Taxon taxon) throws SQLException {
        super(parent, modal);
        this.db = db;
        this.well = well;
        this.orig = taxon;
        this.synSchID = synSchID;
        this.initComponents();
        this.init();
    }

    public DialogTaxonReassign(JDialog parent, boolean modal, SBdb db, int synSchID, Well well, model3.Taxon taxon) throws SQLException {
        super((Dialog)parent, modal);
        this.db = db;
        this.well = well;
        this.orig = taxon;
        this.synSchID = synSchID;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException {
        this.jTextFieldOrig.setText(this.orig.toString(true, true));
        int total = TaxonOcc.getNOcc(this.db, this.well, this.orig, '\u0000', false);
        int nInSitu = TaxonOcc.getNOcc(this.db, this.well, this.orig, 'I', false);
        int nTransported = TaxonOcc.getNOcc(this.db, this.well, this.orig, 'T', false);
        int nRw = TaxonOcc.getNOcc(this.db, this.well, this.orig, 'R', false);
        int nQuestionable = TaxonOcc.getNOcc(this.db, this.well, this.orig, '\u0000', true);
        if (nInSitu > 0) {
            this.jLabelNinSitu.setText("" + nInSitu);
        } else {
            this.jLabelNinSitu.setText(null);
            this.jLabelInsitu.setEnabled(false);
        }
        if (nTransported > 0) {
            this.jLabelNTr.setText("" + nTransported);
        } else {
            this.jLabelNTr.setText(null);
            this.jLabelNTr.setEnabled(false);
        }
        if (nRw > 0) {
            this.jLabelNRw.setText("" + nRw);
        } else {
            this.jLabelNRw.setText(null);
            this.jLabelReworked.setEnabled(false);
        }
        if (nQuestionable > 0) {
            this.jLabelNQ.setText("" + nQuestionable);
        } else {
            this.jLabelNQ.setText(null);
            this.jLabelQuestionable.setEnabled(false);
        }
        this.jLabelTotalOcc.setText("Total occurrences: " + total);
        this.setTitle("Reassign Taxa");
        if (!this.well.canWrite(this.db, null)) {
            this.jButtonOK.setEnabled(false);
            this.jButtonOK.setToolTipText(this.well.getDeniedReason(this.db, "well", false));
            this.getRootPane().setDefaultButton(this.jButtonCancel);
        } else {
            this.getRootPane().setDefaultButton(this.jButtonOK);
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jTextFieldOrig = new JTextField();
        this.jLabel3 = new JLabel();
        this.jTextFieldTarget = new JTextField();
        this.jButtonSelectTaxon = new JButton();
        this.jLabelNinSitu = new JLabel();
        this.jLabelNRw = new JLabel();
        this.jLabelNQ = new JLabel();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jLabelTotalOcc = new JLabel();
        this.jLabelInsitu = new JLabel();
        this.jLabelReworked = new JLabel();
        this.jLabelQuestionable = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jButtonHelp = new JButton();
        this.jLabelNTr = new JLabel();
        this.jLabelTransported = new JLabel();
        this.jLabel1.setText("jLabel1");
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jLabel2.setHorizontalAlignment(11);
        this.jLabel2.setText("Original taxon:");
        this.jTextFieldOrig.setEditable(false);
        this.jTextFieldOrig.setBackground(new Color(255, 255, 204));
        this.jTextFieldOrig.setText("jTextField1");
        this.jLabel3.setHorizontalAlignment(11);
        this.jLabel3.setText("New taxon:");
        this.jTextFieldTarget.setEditable(false);
        this.jButtonSelectTaxon.setText("...");
        this.jButtonSelectTaxon.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTaxonReassign this$0;
            {
                DialogTaxonReassign dialogTaxonReassign = this$0;
                Objects.requireNonNull(dialogTaxonReassign);
                this.this$0 = dialogTaxonReassign;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSelectTaxonActionPerformed(evt);
            }
        });
        this.jLabelNinSitu.setText("jLabel4");
        this.jLabelNRw.setText("jLabel5");
        this.jLabelNQ.setText("jLabel6");
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTaxonReassign this$0;
            {
                DialogTaxonReassign dialogTaxonReassign = this$0;
                Objects.requireNonNull(dialogTaxonReassign);
                this.this$0 = dialogTaxonReassign;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTaxonReassign this$0;
            {
                DialogTaxonReassign dialogTaxonReassign = this$0;
                Objects.requireNonNull(dialogTaxonReassign);
                this.this$0 = dialogTaxonReassign;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jLabelTotalOcc.setFont(new Font("Tahoma", 1, 11));
        this.jLabelTotalOcc.setText("total occ");
        this.jLabelInsitu.setText("In-situ occurrences");
        this.jLabelReworked.setText("Reworked occurrences");
        this.jLabelQuestionable.setText("Questionable occurrences");
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTaxonReassign this$0;
            {
                DialogTaxonReassign dialogTaxonReassign = this$0;
                Objects.requireNonNull(dialogTaxonReassign);
                this.this$0 = dialogTaxonReassign;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        this.jLabelNTr.setText("jLabel4");
        this.jLabelTransported.setText("Transported occurrences");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.jTextFieldOrig, -1, 404, Short.MAX_VALUE).addContainerGap()).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jSeparator1, -1, 475, Short.MAX_VALUE).add(14, 14, 14)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel3).addPreferredGap(0).add((Component)this.jTextFieldTarget, -1, 365, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jButtonSelectTaxon, -2, 33, -2).addContainerGap()))).add((GroupLayout.Group)layout.createSequentialGroup().add(45, 45, 45).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jLabelNTr).add((Component)this.jLabelNinSitu).add((Component)this.jLabelNRw).add((Component)this.jLabelNQ)).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabelQuestionable).add((Component)this.jLabelReworked).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabelInsitu).add(64, 64, 64).add((Component)this.jLabelTotalOcc, -2, 173, -2)).add((Component)this.jLabelTransported)).addContainerGap(-1, Short.MAX_VALUE)).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel).addContainerGap()));
        layout.linkSize(new Component[]{this.jLabel2, this.jLabel3}, 1);
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonHelp, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.jTextFieldOrig, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jTextFieldTarget, -2, -1, -2).add((Component)this.jButtonSelectTaxon).add((Component)this.jLabel3)).add(18, 18, 18).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabelNinSitu).add((Component)this.jLabelTotalOcc).add((Component)this.jLabelInsitu)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabelNTr).add((Component)this.jLabelTransported)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabelNRw).add((Component)this.jLabelReworked)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabelNQ).add((Component)this.jLabelQuestionable)).addPreferredGap(0).add((Component)this.jSeparator1, -2, -1, -2).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonOK).add((Component)this.jButtonHelp)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.target == null) {
            JOptionPane.showMessageDialog(this, "No target taxon selected", this.getTitle(), 1);
            return;
        }
        if (this.target.getSpecID() == this.orig.getSpecID()) {
            JOptionPane.showMessageDialog(this, "Target taxon same as original!", this.getTitle(), 1);
            return;
        }
        try {
            model3.Taxon.checkCoOccurrences(this.db, this.orig.getSpecID(), this.target.getSpecID(), -1, 0, this.well.getWellID());
            this.well.mergeTaxa(this.orig, this.target);
            this.db.commit();
            JOptionPane.showMessageDialog(this, "Taxon reassigned");
            this.isOK = true;
            this.dispose();
        }
        catch (SBException se) {
            if (se.getData() != null) {
                DialogcoOccurrences dialog = new DialogcoOccurrences(this, true, "Co-Occurrences", this.well, this.target, this.orig, this.db, (List)se.getData());
                dialog.setLocationRelativeTo(this);
                dialog.setVisible(true);
                if (dialog.isOK) {
                    try {
                        this.well.mergeTaxa(this.orig, this.target);
                        this.db.commit();
                        JOptionPane.showMessageDialog(this, "Taxon merged/reassigned");
                        this.isOK = true;
                        this.dispose();
                    }
                    catch (Exception ex) {
                        StackError.showStackError((String)ex.getMessage(), (Throwable)ex);
                        this.db.doRollback();
                    }
                }
            } else {
                JOptionPane.showMessageDialog(this, se.getMessage(), this.getTitle(), 0);
            }
        }
        catch (SQLException sql) {
            this.db.doRollback();
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (RuntimeException re) {
            this.db.doRollback();
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void jButtonSelectTaxonActionPerformed(ActionEvent evt) {
        try {
            DialogSelectTaxa dialog = new DialogSelectTaxa(this, true, this.db, this.synSchID, true, this.orig.getTaxonCopy());
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.getSelectedItem() != null) {
                this.target = this.db.getTaxon(((Taxon)dialog.getSelectedItem()).getSpecID());
                this.jTextFieldTarget.setText(this.target.toString(true, true));
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error opening dialog", sql, this.db);
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("samples_menu.html#analyses");
    }
}

