/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.user.Userdef;
import com.stratadata.util.ui.table.ColumnSortResetHandler;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.TableRowSorter;
import jsbugs.BiocomTableModel;
import jsbugs.FrameJsbugs;
import jsbugs.TableModelAnalyses;
import jsbugs.ZonesTableModel;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.AnalystHeader;
import model3.Biocom;
import model3.IGDInterval;
import model3.IGDIntervalZone;
import model3.SBdb;
import model3.Sample;
import model3.Smpdtl;
import model3.Well;
import model3.WellInterp;
import org.jdesktop.layout.GroupLayout;
import util.SBException;

public class DialogUserData
extends JDialog {
    TableModelAnalyses modelAnalyses = new TableModelAnalyses();
    ZonesTableModel modelIGD = new ZonesTableModel();
    BiocomTableModel modelBiocom = new BiocomTableModel();
    List<Well> wells = null;
    Userdef user = null;
    Well well;
    WellInterp wellInterp;
    List<WellInterp> versions = new LinkedList<WellInterp>();
    List<Smpdtl> analyses = new LinkedList<Smpdtl>();
    List<Smpdtl> discAnalyses = new LinkedList<Smpdtl>();
    DefaultListModel suiteModel = new DefaultListModel();
    List<Suite> suites = new LinkedList<Suite>();
    private ButtonGroup buttonGroupDiscipline;
    private JButton jButtonClose;
    private JButton jButtonDelete;
    private JButton jButtonDelete2;
    private JButton jButtonDelete3;
    private JButton jButtonDeleteSuite;
    private JButton jButtonHelp;
    private JButton jButtonShow;
    private JButton jButtonShowBiocom;
    private JButton jButtonShowIGD;
    private JList jListSuites;
    private JList jListVersion;
    private JList jListVersionComments;
    private JList jListWell;
    private JPanel jPanelAnalyses;
    private JPanel jPanelBiostratComments;
    private JPanel jPanelIGD;
    private JPanel jPanelSuites;
    private JRadioButton jRadioButtonMacro;
    private JRadioButton jRadioButtonMicro;
    private JRadioButton jRadioButtonNanno;
    private JRadioButton jRadioButtonPaly;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JScrollPane jScrollPane5;
    private JScrollPane jScrollPane6;
    private JScrollPane jScrollPane7;
    private JTabbedPane jTabbedPane1;
    private JTable jTableAnalyses;
    private JTable jTableComments;
    private JTable jTableIGD;

    public DialogUserData(JDialog parent, boolean modal, Userdef user) throws SQLException, SBException {
        super((Dialog)parent, modal);
        this.setTitle("Analyst Data : " + user.getName());
        this.user = user;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException, SBException {
        this.modelAnalyses.setupTable(this.jTableAnalyses, null);
        this.modelIGD.setupTable(this.jTableIGD, null);
        this.modelBiocom.setupTable(this.jTableComments, null);
        this.jTableAnalyses.setRowSorter(new TableRowSorter<TableModelAnalyses>(this.modelAnalyses));
        new ColumnSortResetHandler(this.jTableAnalyses).attach();
        this.jTableIGD.setRowSorter(new TableRowSorter<ZonesTableModel>(this.modelIGD));
        new ColumnSortResetHandler(this.jTableIGD).attach();
        this.jTableComments.setRowSorter(new TableRowSorter<BiocomTableModel>(this.modelBiocom));
        new ColumnSortResetHandler(this.jTableComments).attach();
        this.wells = this.user.getWellOccs();
        Collections.sort(this.wells);
        this.jListWell.setListData(this.wells.toArray());
        this.getRootPane().setDefaultButton(this.jButtonClose);
    }

    private void setupSuiteList() throws SQLException, SBException {
        List<Well> suiteWells = this.user.getAnalystHeaders();
        this.suiteModel.clear();
        this.suites.clear();
        for (Well suiteWell : suiteWells) {
            if (suiteWell != this.well) continue;
            Iterator<AnalystHeader> h = suiteWell.getAnalystHeaderIterator();
            while (h.hasNext()) {
                AnalystHeader hdr = h.next();
                if (hdr.getAnalystUsrid() != this.user.getUsrID()) continue;
                this.suites.add(new Suite(this, suiteWell, hdr));
                this.suiteModel.addElement(suiteWell.getWellName() + " (" + suiteWell.getWellCode() + ") " + hdr.getDiscipline().getAbr(true) + " " + hdr.getAnalyst() + " (" + hdr.getAnalyNumber() + ")");
            }
        }
        this.jListSuites.repaint();
    }

    private void initComponents() {
        this.buttonGroupDiscipline = new ButtonGroup();
        this.jButtonShow = new JButton();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanelAnalyses = new JPanel();
        this.jRadioButtonMicro = new JRadioButton();
        this.jRadioButtonNanno = new JRadioButton();
        this.jRadioButtonPaly = new JRadioButton();
        this.jRadioButtonMacro = new JRadioButton();
        this.jButtonDelete = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.jTableAnalyses = new JTable();
        this.jPanelSuites = new JPanel();
        this.jScrollPane7 = new JScrollPane();
        this.jListSuites = new JList();
        this.jButtonDeleteSuite = new JButton();
        this.jPanelIGD = new JPanel();
        this.jButtonShowIGD = new JButton();
        this.jScrollPane4 = new JScrollPane();
        this.jTableIGD = new JTable();
        this.jButtonDelete2 = new JButton();
        this.jScrollPane3 = new JScrollPane();
        this.jListVersion = new JList();
        this.jPanelBiostratComments = new JPanel();
        this.jButtonShowBiocom = new JButton();
        this.jScrollPane6 = new JScrollPane();
        this.jTableComments = new JTable();
        this.jButtonDelete3 = new JButton();
        this.jScrollPane5 = new JScrollPane();
        this.jListVersionComments = new JList();
        this.jButtonClose = new JButton();
        this.jButtonHelp = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jListWell = new JList();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(800, 400));
        this.jButtonShow.setText("Show >");
        this.jButtonShow.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonShow.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogUserData this$0;
            {
                DialogUserData dialogUserData = this$0;
                Objects.requireNonNull(dialogUserData);
                this.this$0 = dialogUserData;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonShowActionPerformed(evt);
            }
        });
        this.buttonGroupDiscipline.add(this.jRadioButtonMicro);
        this.jRadioButtonMicro.setText("Micro.");
        this.jRadioButtonMicro.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonMicro.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioButtonMicro.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogUserData this$0;
            {
                DialogUserData dialogUserData = this$0;
                Objects.requireNonNull(dialogUserData);
                this.this$0 = dialogUserData;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonMicroActionPerformed(evt);
            }
        });
        this.buttonGroupDiscipline.add(this.jRadioButtonNanno);
        this.jRadioButtonNanno.setText("Nanno.");
        this.jRadioButtonNanno.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonNanno.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioButtonNanno.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogUserData this$0;
            {
                DialogUserData dialogUserData = this$0;
                Objects.requireNonNull(dialogUserData);
                this.this$0 = dialogUserData;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonNannoActionPerformed(evt);
            }
        });
        this.buttonGroupDiscipline.add(this.jRadioButtonPaly);
        this.jRadioButtonPaly.setText("Paly.");
        this.jRadioButtonPaly.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonPaly.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioButtonPaly.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogUserData this$0;
            {
                DialogUserData dialogUserData = this$0;
                Objects.requireNonNull(dialogUserData);
                this.this$0 = dialogUserData;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonPalyActionPerformed(evt);
            }
        });
        this.buttonGroupDiscipline.add(this.jRadioButtonMacro);
        this.jRadioButtonMacro.setText("Macro.");
        this.jRadioButtonMacro.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonMacro.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioButtonMacro.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogUserData this$0;
            {
                DialogUserData dialogUserData = this$0;
                Objects.requireNonNull(dialogUserData);
                this.this$0 = dialogUserData;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonMacroActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogUserData this$0;
            {
                DialogUserData dialogUserData = this$0;
                Objects.requireNonNull(dialogUserData);
                this.this$0 = dialogUserData;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jTableAnalyses.setModel(this.modelAnalyses);
        this.jScrollPane2.setViewportView(this.jTableAnalyses);
        GroupLayout jPanelAnalysesLayout = new GroupLayout((Container)this.jPanelAnalyses);
        this.jPanelAnalyses.setLayout((LayoutManager)jPanelAnalysesLayout);
        jPanelAnalysesLayout.setHorizontalGroup((GroupLayout.Group)jPanelAnalysesLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelAnalysesLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelAnalysesLayout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanelAnalysesLayout.createSequentialGroup().add((Component)this.jScrollPane2, -1, 495, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jButtonDelete)).add((GroupLayout.Group)jPanelAnalysesLayout.createSequentialGroup().add((Component)this.jRadioButtonMicro).addPreferredGap(0).add((Component)this.jRadioButtonNanno).addPreferredGap(0).add((Component)this.jRadioButtonPaly).addPreferredGap(0).add((Component)this.jRadioButtonMacro))).addContainerGap()));
        jPanelAnalysesLayout.setVerticalGroup((GroupLayout.Group)jPanelAnalysesLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelAnalysesLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelAnalysesLayout.createParallelGroup(3).add((Component)this.jRadioButtonMicro).add((Component)this.jRadioButtonNanno).add((Component)this.jRadioButtonPaly).add((Component)this.jRadioButtonMacro)).addPreferredGap(0).add((GroupLayout.Group)jPanelAnalysesLayout.createParallelGroup(1).add((Component)this.jButtonDelete).add((Component)this.jScrollPane2, -1, 401, Short.MAX_VALUE)).addContainerGap()));
        this.jTabbedPane1.addTab("Analyses", this.jPanelAnalyses);
        this.jListSuites.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.jListSuites.setModel(this.suiteModel);
        this.jScrollPane7.setViewportView(this.jListSuites);
        this.jButtonDeleteSuite.setText("Delete");
        this.jButtonDeleteSuite.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogUserData this$0;
            {
                DialogUserData dialogUserData = this$0;
                Objects.requireNonNull(dialogUserData);
                this.this$0 = dialogUserData;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDeleteSuiteActionPerformed(evt);
            }
        });
        GroupLayout jPanelSuitesLayout = new GroupLayout((Container)this.jPanelSuites);
        this.jPanelSuites.setLayout((LayoutManager)jPanelSuitesLayout);
        jPanelSuitesLayout.setHorizontalGroup((GroupLayout.Group)jPanelSuitesLayout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanelSuitesLayout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane7, -1, 491, Short.MAX_VALUE).addPreferredGap(1).add((Component)this.jButtonDeleteSuite).addContainerGap()));
        jPanelSuitesLayout.setVerticalGroup((GroupLayout.Group)jPanelSuitesLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelSuitesLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelSuitesLayout.createParallelGroup(1).add((Component)this.jScrollPane7, -1, 422, Short.MAX_VALUE).add((Component)this.jButtonDeleteSuite)).addContainerGap()));
        this.jTabbedPane1.addTab("Analysis Suites", this.jPanelSuites);
        this.jButtonShowIGD.setText("Show >");
        this.jButtonShowIGD.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogUserData this$0;
            {
                DialogUserData dialogUserData = this$0;
                Objects.requireNonNull(dialogUserData);
                this.this$0 = dialogUserData;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonShowIGDActionPerformed(evt);
            }
        });
        this.jTableIGD.setModel(this.modelIGD);
        this.jScrollPane4.setViewportView(this.jTableIGD);
        this.jButtonDelete2.setText("Delete");
        this.jButtonDelete2.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogUserData this$0;
            {
                DialogUserData dialogUserData = this$0;
                Objects.requireNonNull(dialogUserData);
                this.this$0 = dialogUserData;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDelete2ActionPerformed(evt);
            }
        });
        this.jListVersion.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ DialogUserData this$0;
            {
                DialogUserData dialogUserData = this$0;
                Objects.requireNonNull(dialogUserData);
                this.this$0 = dialogUserData;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.this$0.jListVersionMouseClicked(evt);
            }
        });
        this.jScrollPane3.setViewportView(this.jListVersion);
        GroupLayout jPanelIGDLayout = new GroupLayout((Container)this.jPanelIGD);
        this.jPanelIGD.setLayout((LayoutManager)jPanelIGDLayout);
        jPanelIGDLayout.setHorizontalGroup((GroupLayout.Group)jPanelIGDLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelIGDLayout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane3, -2, 137, -2).addPreferredGap(1).add((Component)this.jButtonShowIGD).addPreferredGap(0).add((Component)this.jScrollPane4, -1, 273, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jButtonDelete2).addContainerGap()));
        jPanelIGDLayout.setVerticalGroup((GroupLayout.Group)jPanelIGDLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelIGDLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelIGDLayout.createParallelGroup(1).add((Component)this.jButtonDelete2).add((Component)this.jScrollPane3, -1, 422, Short.MAX_VALUE).add((Component)this.jButtonShowIGD).add((Component)this.jScrollPane4, -1, 422, Short.MAX_VALUE)).addContainerGap()));
        this.jTabbedPane1.addTab("Zones", this.jPanelIGD);
        this.jButtonShowBiocom.setText("Show >");
        this.jButtonShowBiocom.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogUserData this$0;
            {
                DialogUserData dialogUserData = this$0;
                Objects.requireNonNull(dialogUserData);
                this.this$0 = dialogUserData;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonShowBiocomActionPerformed(evt);
            }
        });
        this.jTableComments.setModel(this.modelBiocom);
        this.jScrollPane6.setViewportView(this.jTableComments);
        this.jButtonDelete3.setText("Delete");
        this.jButtonDelete3.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogUserData this$0;
            {
                DialogUserData dialogUserData = this$0;
                Objects.requireNonNull(dialogUserData);
                this.this$0 = dialogUserData;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDelete3ActionPerformed(evt);
            }
        });
        this.jListVersionComments.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ DialogUserData this$0;
            {
                DialogUserData dialogUserData = this$0;
                Objects.requireNonNull(dialogUserData);
                this.this$0 = dialogUserData;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.this$0.jListVersionCommentsMouseClicked(evt);
            }
        });
        this.jScrollPane5.setViewportView(this.jListVersionComments);
        GroupLayout jPanelBiostratCommentsLayout = new GroupLayout((Container)this.jPanelBiostratComments);
        this.jPanelBiostratComments.setLayout((LayoutManager)jPanelBiostratCommentsLayout);
        jPanelBiostratCommentsLayout.setHorizontalGroup((GroupLayout.Group)jPanelBiostratCommentsLayout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanelBiostratCommentsLayout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane5, -2, 150, -2).addPreferredGap(0).add((Component)this.jButtonShowBiocom).addPreferredGap(0).add((Component)this.jScrollPane6, -1, 264, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jButtonDelete3).addContainerGap()));
        jPanelBiostratCommentsLayout.setVerticalGroup((GroupLayout.Group)jPanelBiostratCommentsLayout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanelBiostratCommentsLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelBiostratCommentsLayout.createParallelGroup(2).add(1, (Component)this.jScrollPane5, -1, 422, Short.MAX_VALUE).add(1, (Component)this.jScrollPane6, -1, 422, Short.MAX_VALUE).add(1, (Component)this.jButtonDelete3).add(1, (Component)this.jButtonShowBiocom)).addContainerGap()));
        this.jTabbedPane1.addTab("Biostrat Comments", this.jPanelBiostratComments);
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogUserData this$0;
            {
                DialogUserData dialogUserData = this$0;
                Objects.requireNonNull(dialogUserData);
                this.this$0 = dialogUserData;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCloseActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogUserData this$0;
            {
                DialogUserData dialogUserData = this$0;
                Objects.requireNonNull(dialogUserData);
                this.this$0 = dialogUserData;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        this.jListWell.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ DialogUserData this$0;
            {
                DialogUserData dialogUserData = this$0;
                Objects.requireNonNull(dialogUserData);
                this.this$0 = dialogUserData;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.this$0.jListWellMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jListWell);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jScrollPane1, -2, 134, -2).addPreferredGap(0).add((Component)this.jButtonShow).addPreferredGap(0).add((Component)this.jTabbedPane1)).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonClose))).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonClose, this.jButtonHelp}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jButtonShow).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jScrollPane1).add((Component)this.jTabbedPane1)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonClose).add((Component)this.jButtonHelp)))).addContainerGap()));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialoguserdata.html");
    }

    private void jButtonShowActionPerformed(ActionEvent evt) {
        if (this.jListWell.getSelectedIndex() < 0) {
            JOptionPane.showMessageDialog(this, "No well selected", this.getTitle(), 2);
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.versions.clear();
            this.well = (Well)this.jListWell.getSelectedValue();
            this.versions = this.user.getWellIGDInterps(this.well);
            this.jListVersion.setListData(this.versions.toArray());
            this.jListVersion.repaint();
            this.versions = this.user.getWellBiocomInterps(this.well);
            this.jListVersionComments.setListData(this.versions.toArray());
            this.jListVersionComments.repaint();
            this.analyses.clear();
            this.analyses = this.user.getWellAnalyses(this.well);
            Iterator<Smpdtl> it = this.analyses.iterator();
            this.jRadioButtonMacro.setSelected(false);
            this.jRadioButtonMacro.setEnabled(false);
            this.jRadioButtonMicro.setSelected(false);
            this.jRadioButtonMicro.setEnabled(false);
            this.jRadioButtonNanno.setSelected(false);
            this.jRadioButtonNanno.setEnabled(false);
            this.jRadioButtonPaly.setSelected(false);
            this.jRadioButtonPaly.setEnabled(false);
            boolean selectionMade = false;
            int selectedDiscipline = 0;
            for (Smpdtl smpdtl : this.analyses) {
                switch (smpdtl.getDiscID()) {
                    case 'M': {
                        this.jRadioButtonMicro.setEnabled(true);
                        if (selectionMade) break;
                        this.jRadioButtonMicro.setSelected(true);
                        selectionMade = true;
                        selectedDiscipline = 77;
                        break;
                    }
                    case 'N': {
                        this.jRadioButtonNanno.setEnabled(true);
                        if (selectionMade) break;
                        this.jRadioButtonNanno.setSelected(true);
                        selectionMade = true;
                        selectedDiscipline = 78;
                        break;
                    }
                    case 'P': {
                        this.jRadioButtonPaly.setEnabled(true);
                        if (selectionMade) break;
                        this.jRadioButtonPaly.setSelected(true);
                        selectionMade = true;
                        selectedDiscipline = 80;
                        break;
                    }
                    case 'A': {
                        this.jRadioButtonMacro.setEnabled(true);
                        if (selectionMade) break;
                        this.jRadioButtonMacro.setSelected(true);
                        selectionMade = true;
                        selectedDiscipline = 65;
                    }
                }
            }
            if (selectionMade) {
                this.loadAnalyses((char)selectedDiscipline, this.well.getWellUnits());
            } else {
                this.discAnalyses.clear();
                if (this.modelAnalyses.getSmpdtls() != null) {
                    this.modelAnalyses.getSmpdtls().clear();
                }
                this.modelAnalyses.fireTableDataChanged();
            }
            this.setupSuiteList();
            boolean canWrite = this.well.canWrite(this.well.getDataModel(), null);
            for (JButton deleteButton : new JButton[]{this.jButtonDelete, this.jButtonDeleteSuite, this.jButtonDelete2, this.jButtonDelete3}) {
                deleteButton.setEnabled(canWrite);
            }
        }
        catch (RuntimeException | SQLException | SBException ex) {
            SbugsExceptionHandler.showStackError(ex, this);
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    void loadAnalyses(char discID, char units) {
        this.discAnalyses.clear();
        for (Smpdtl smpdtl : this.analyses) {
            if (smpdtl.getDiscID() != discID) continue;
            this.discAnalyses.add(smpdtl);
        }
        this.modelAnalyses.setSmpdtls(this.discAnalyses, null);
        this.modelAnalyses.units = units;
        Iterator<Smpdtl> it = this.analyses.iterator();
        this.modelAnalyses.fireTableDataChanged();
    }

    private void jListWellMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonShowActionPerformed(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonShowBiocomActionPerformed(ActionEvent evt) {
        if (this.jListVersionComments.getModel().getSize() == 0) {
            JOptionPane.showMessageDialog(this, "No data to display.", "User Data", 2);
            return;
        }
        if (this.jListWell.getSelectedIndex() < 0) {
            JOptionPane.showMessageDialog(this, "Select a well name from the list", "User Data", 2);
            return;
        }
        if (this.jListVersionComments.getSelectedValue() == null) {
            JOptionPane.showMessageDialog(this, "Select a version from the list", "User Data", 2);
            return;
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            WellInterp interp = (WellInterp)this.jListVersionComments.getSelectedValue();
            this.well = (Well)this.jListWell.getSelectedValue();
            this.well.loadInterp(interp);
            LinkedList<Biocom> biocoms = new LinkedList<Biocom>();
            for (Biocom biocom : interp.getComments()) {
                if (biocom.getAnalyst() != this.user.getUsrID()) continue;
                biocoms.add(biocom);
            }
            this.modelBiocom.comments = biocoms;
            this.modelBiocom.fireTableDataChanged();
        }
        catch (RuntimeException | SQLException | SBException ex) {
            SbugsExceptionHandler.showStackError(ex, this);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jListVersionCommentsMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonShowBiocomActionPerformed(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonShowIGDActionPerformed(ActionEvent evt) {
        if (this.jListVersion.getModel().getSize() == 0) {
            JOptionPane.showMessageDialog(this, "No data to display.", "User Data", 2);
            return;
        }
        if (this.jListWell.getSelectedIndex() < 0) {
            JOptionPane.showMessageDialog(this, "Select a well name from the list", "User Data", 2);
            return;
        }
        if (this.jListVersion.getSelectedValue() == null) {
            JOptionPane.showMessageDialog(this, "Select a version from the list", "User Data", 2);
            return;
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            WellInterp interp = (WellInterp)this.jListVersion.getSelectedValue();
            this.well = (Well)this.jListWell.getSelectedValue();
            this.well.loadInterp(interp);
            LinkedList<IGDIntervalZone> zones = new LinkedList<IGDIntervalZone>();
            for (IGDIntervalZone zone : interp.getIGDList(4, 0)) {
                if (zone.getTopAnalyst() != this.user.getUsrID() && zone.getBaseAnalyst() != this.user.getUsrID()) continue;
                zones.add(zone);
            }
            this.modelIGD.setZones(zones, this.well);
            this.modelIGD.fireTableDataChanged();
        }
        catch (RuntimeException | SQLException | SBException ex) {
            SbugsExceptionHandler.showStackError(ex, this);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jListVersionMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonShowIGDActionPerformed(null);
        }
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        int[] selection = this.jTableAnalyses.getSelectedRows();
        if (selection.length == 0) {
            JOptionPane.showMessageDialog(this, "No analyses selected", this.getTitle(), 2);
            return;
        }
        LinkedList<Smpdtl> toDelete = new LinkedList<Smpdtl>();
        for (int i = 0; i < selection.length; ++i) {
            toDelete.add(this.modelAnalyses.getSmpdtls().get(this.jTableAnalyses.convertRowIndexToModel(selection[i])));
        }
        if (JOptionPane.showConfirmDialog(this, "Really delete these: " + toDelete.size() + " analyses?", this.getTitle(), 0, 3) == 0) {
            try {
                Sample lastSample = null;
                for (Smpdtl smpdtl : toDelete) {
                    Sample sample = smpdtl.getSample();
                    sample.deleteDtl(this.well.getWellID(), smpdtl.getAnalyID(), smpdtl);
                    this.modelAnalyses.getSmpdtls().remove((Object)smpdtl);
                    lastSample = sample;
                }
                this.well.getDataModel().commit();
                this.well.getDataModel().updateAuditTrail("ANALYSES", "DELETE " + toDelete.size() + " from " + this.well.toString() + " [" + this.well.getWellID() + "]");
                lastSample.notifyObservers();
                this.modelAnalyses.fireTableDataChanged();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "Error deleting: " + e.getMessage(), this.getTitle(), 0);
                e.printStackTrace();
                this.well.getDataModel().doRollback();
            }
        }
    }

    private void jButtonDelete2ActionPerformed(ActionEvent evt) {
        int[] selection = this.jTableIGD.getSelectedRows();
        if (selection.length == 0) {
            JOptionPane.showMessageDialog(this, "No zones selected", this.getTitle(), 2);
            return;
        }
        LinkedList<IGDIntervalZone> toDelete = new LinkedList<IGDIntervalZone>();
        for (int i = 0; i < selection.length; ++i) {
            toDelete.add(this.modelIGD.getZones().get(this.jTableIGD.convertRowIndexToModel(selection[i])));
        }
        if (JOptionPane.showConfirmDialog(this, "Really delete these: " + toDelete.size() + " zones?", this.getTitle(), 0, 3) == 0) {
            try {
                WellInterp interp = (WellInterp)this.jListVersion.getSelectedValue();
                Object arg = null;
                for (IGDIntervalZone zone : toDelete) {
                    if (arg == null || arg instanceof IGDIntervalZone && ((IGDInterval)arg).getIGDType() == zone.getIGDType() && (zone.getIGDType() != 4 || ((IGDIntervalZone)arg).getSchID() == zone.getSchID())) {
                        arg = zone;
                        continue;
                    }
                    arg = zone.getIGDType();
                }
                interp.deleteZones(this.well, toDelete);
                this.modelIGD.getZones().removeAll(toDelete);
                this.well.getDataModel().commit();
                interp.notifyObservers(arg);
                this.modelIGD.fireTableDataChanged();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "Error deleting: " + e.getMessage(), this.getTitle(), 0);
                e.printStackTrace();
                this.well.getDataModel().doRollback();
            }
        }
    }

    private void jButtonDelete3ActionPerformed(ActionEvent evt) {
        int[] selection = this.jTableComments.getSelectedRows();
        if (selection.length == 0) {
            JOptionPane.showMessageDialog(this, "No zones selected", this.getTitle(), 2);
            return;
        }
        LinkedList<Biocom> toDelete = new LinkedList<Biocom>();
        for (int i = 0; i < selection.length; ++i) {
            toDelete.add(this.modelBiocom.comments.get(this.jTableComments.convertRowIndexToModel(selection[i])));
        }
        if (JOptionPane.showConfirmDialog(this, "Really delete these: " + toDelete.size() + " comments?", this.getTitle(), 0, 3) == 0) {
            try {
                WellInterp interp = (WellInterp)this.jListVersionComments.getSelectedValue();
                Biocom last = null;
                interp.deleteBiocoms(toDelete, this.well.getWellID());
                for (Biocom biocom : toDelete) {
                    this.modelBiocom.comments.remove(biocom);
                    last = biocom;
                }
                this.well.getDataModel().commit();
                interp.notifyObservers(last);
                this.modelBiocom.fireTableDataChanged();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "Error deleting: " + e.getMessage(), this.getTitle(), 0);
                e.printStackTrace();
                this.well.getDataModel().doRollback();
            }
        }
    }

    private void jButtonDeleteSuiteActionPerformed(ActionEvent evt) {
        if (this.jListSuites.getSelectedIndices().length != 1) {
            JOptionPane.showMessageDialog(this, "Select a suite to delete", this.getTitle(), 1);
            return;
        }
        int index = this.jListSuites.getSelectedIndex();
        Suite suite = this.suites.get(index);
        Well suiteWell = suite.well;
        SBdb db = suiteWell.getDataModel();
        try {
            int option;
            AnalystHeader hdr = suite.hdr;
            int nAnalyses = suiteWell.getAnalysesOccs(hdr);
            if (nAnalyses > 0 && (option = JOptionPane.showConfirmDialog(this, "There are " + nAnalyses + " analyses in this suite.\nDo you want to delete them all?", this.getTitle(), 0, 3)) != 0) {
                return;
            }
            suiteWell.deleteAnalyses(hdr);
            this.suites.remove(suite);
            this.suiteModel.remove(index);
            db.commit();
            this.jButtonShowActionPerformed(null);
        }
        catch (RuntimeException | SQLException | SBException ex) {
            SbugsExceptionHandler.showStackError(ex, this);
        }
    }

    private void jRadioButtonMicroActionPerformed(ActionEvent evt) {
        this.loadAnalyses('M', this.modelAnalyses.units);
    }

    private void jRadioButtonNannoActionPerformed(ActionEvent evt) {
        this.loadAnalyses('N', this.modelAnalyses.units);
    }

    private void jRadioButtonPalyActionPerformed(ActionEvent evt) {
        this.loadAnalyses('P', this.modelAnalyses.units);
    }

    private void jRadioButtonMacroActionPerformed(ActionEvent evt) {
        this.loadAnalyses('A', this.modelAnalyses.units);
    }

    class Suite {
        Well well;
        AnalystHeader hdr;

        Suite(DialogUserData this$0, Well well, AnalystHeader hdr) {
            Objects.requireNonNull(this$0);
            this.well = well;
            this.hdr = hdr;
        }
    }
}

