/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.well.sample.SampleType;
import com.stratadata.util.depth.DepthUnits;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import javax.swing.JTable;
import jsbugs.EventsTableModel;
import jsbugs.table.CorrectedDepthRenderer;
import jsbugs.table.IGetValue;
import jsbugs.table.SimpleTableColumn;
import model3.SBdb;
import model3.Sample;
import model3.SampleDepth;
import model3.Well;
import model3.WellEvent;

public class EventsTableModelWithCorrection
extends EventsTableModel {
    private Well well = null;
    private boolean displayCuttingSampleCorrections = false;
    private CorrectedDepthRenderer correctedRenderer = new CorrectedDepthRenderer(DepthUnits.M);
    private SimpleTableColumn<WellEvent> correctionColumn = new SimpleTableColumn<WellEvent>("Corrected", 55, SampleDepth.class, new IGetValue<WellEvent>(this){
        final /* synthetic */ EventsTableModelWithCorrection this$0;
        {
            EventsTableModelWithCorrection eventsTableModelWithCorrection = this$0;
            Objects.requireNonNull(eventsTableModelWithCorrection);
            this.this$0 = eventsTableModelWithCorrection;
        }

        @Override
        public Object getValue(WellEvent event) {
            if (this.this$0.well != null) {
                return this.this$0.getSampleDepth(event.getSample());
            }
            return null;
        }
    });

    private Object getSampleDepth(Sample sample) {
        try {
            if (this.displayCuttingSampleCorrections || !sample.getType().equals((Object)SampleType.CU)) {
                return SampleDepth.BuildCorrectedSampleDepth(this.well, sample);
            }
            return new SampleDepth(sample.getDepth());
        }
        catch (SQLException ex) {
            return ex.getMessage();
        }
    }

    public EventsTableModelWithCorrection() {
        this.columns.add(2, this.correctionColumn);
    }

    @Override
    public void setupTable(JTable jTable, SBdb sbdb) {
        super.setupTable(jTable, sbdb);
        jTable.setDefaultRenderer(SampleDepth.class, this.correctedRenderer);
    }

    @Override
    public void setEvents(List<WellEvent> events, Well well) {
        super.setEvents(events, well);
        this.well = well;
    }

    @Override
    void setUnits(char units) {
        super.setUnits(units);
        this.correctedRenderer.setUnits(DepthUnits.getUnits((char)units));
    }

    public void setDisplayCuttingCorrections(boolean value) {
        this.displayCuttingSampleCorrections = value;
        this.fireTableDataChanged();
    }

    @Override
    public String getPrefString() {
        return "TMEVESWC";
    }

    @Override
    public String getPrefOrderString() {
        return "TOEVTSWC";
    }

    @Override
    public String getAutoResizeString() {
        return "TAREVESWC";
    }
}

