/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.event.EventType;
import com.stratadata.sblicense.SbugsLicense;
import com.stratadata.util.io.FileChooserUtils;
import com.stratadata.util.ui.HelpUtils;
import com.stratadata.util.ui.SbugsLookAndFeelSetup;
import com.stratadata.util.ui.table.TableUtils;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterJob;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Observable;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import jsbchart.block.BlockType;
import jsbchart.block.ChartBlock;
import jsbchart.block.ChartBlockBase;
import jsbchart.block.MapBlock;
import jsbchart.block.SchemeBlock;
import jsbchart.block.WellBlock;
import jsbchart.core.BlockTemplate;
import jsbchart.core.BlockTemplateChildException;
import jsbchart.core.BlockTemplateInfo;
import jsbchart.core.BlockTemplateParent;
import jsbchart.core.Chart;
import jsbchart.core.ChartContainer;
import jsbchart.core.ChartFactory;
import jsbchart.core.ChartManager;
import jsbchart.core.ChartProperties;
import jsbchart.core.ChartPropertiesFactory;
import jsbchart.core.ChartTemplate;
import jsbchart.core.ChartTemplateBase;
import jsbchart.core.PanelOcc;
import jsbchart.core.PanelTemplate;
import jsbchart.core.TemplateDescr;
import jsbchart.core.TemplateFactory;
import jsbchart.core.TemplateType;
import jsbchart.core.UnknownPanelTypeException;
import jsbchart.core.WellBlockOrder;
import jsbchart.core.process.BlockTemplateMerge;
import jsbchart.correlation.CorrLineStyle;
import jsbchart.correlation.Correlation;
import jsbchart.correlation.CorrelationLine;
import jsbchart.correlation.CorrelationStandard;
import jsbchart.correlation.CorrelationTemplate;
import jsbchart.correlation.CorrelationType;
import jsbchart.correlation.EventLine;
import jsbchart.correlation.IGDUnitLine;
import jsbchart.correlation.SurfaceLine;
import jsbchart.legacy.LegacyChart;
import jsbchart.listener.ChartEvent;
import jsbchart.listener.ChartNode;
import jsbchart.panel.ChartPanel;
import jsbchart.panel.PanelBiozones;
import jsbchart.panel.PanelFactory;
import jsbchart.panel.PanelTaxonBase;
import jsbchart.panel.PanelTaxonGroup;
import jsbchart.panel.PanelType;
import jsbchart.panel.SBPanel;
import jsbchart.panel.spatial.SBLayer;
import jsbchart.tag.ChartTag;
import jsbugs.ChartActions;
import jsbugs.ChartExporter;
import jsbugs.ChartJPanel;
import jsbugs.DialogChartBlockDepthRange;
import jsbugs.DialogChartBlockImport;
import jsbugs.DialogChartDesc;
import jsbugs.DialogChartTemplates;
import jsbugs.DialogCorrelationLine;
import jsbugs.DialogLegacyCharts;
import jsbugs.DialogList;
import jsbugs.DialogPanelTemplates;
import jsbugs.DialogPermissions;
import jsbugs.DialogSelectCorrelationLines;
import jsbugs.DialogSelectEvent;
import jsbugs.DialogSelectGroup;
import jsbugs.DialogSelectProject;
import jsbugs.DialogSelectUnit;
import jsbugs.DialogTable;
import jsbugs.FrameJsbugs;
import jsbugs.HintSequence;
import jsbugs.JScrollPaneChart;
import jsbugs.SBChartTransferHandler;
import jsbugs.SbugsIO;
import jsbugs.TableModelPanelTemplates;
import jsbugs.TableModelSurfaces;
import jsbugs.chart.ChartListLabel;
import jsbugs.chart.DialogBlockList;
import jsbugs.chart.DialogChartProperties;
import jsbugs.chart.DialogTemplateChildren;
import jsbugs.chart.JPanelChartShortcuts;
import jsbugs.chart.TreeModelChart;
import jsbugs.chart.component.JScrollPaneChartBase;
import jsbugs.chart.mouse.ChartMouseListenerManager;
import jsbugs.chart.properties.AbstractBlockPropertiesTableModel;
import jsbugs.chart.properties.BlockPropertiesTableModel;
import jsbugs.chart.properties.CorrelationPropertiesTableModel;
import jsbugs.chart.properties.DialogPanelProperties;
import jsbugs.chart.properties.MapBlockPropertiesTableModel;
import jsbugs.chart.properties.PanelPropertiesTableModel;
import jsbugs.chart.properties.PropertiesTable;
import jsbugs.chart.properties.taxon.PanelTaxonPropertiesPanel;
import jsbugs.chart.spatial.DialogSBShapeStores;
import jsbugs.chart.tag.ChartTagPropertiesTableModel;
import jsbugs.chart.tag.DialogChartTagList;
import jsbugs.list.RestrictableProjectListCellRenderer;
import jsbugs.uiutil.JOptionPaneUtils;
import jsbugs.uiutil.RunWithCursorDecorator;
import jsbugs.uiutil.SBTabbedPane;
import jsbugs.uiutil.TabTitleContextMenuMouseListener;
import jsbugs.uiutil.icon.IconFactory;
import jsbugs.userconnect.SbugsExceptionHandler;
import jsbugs.userconnect.SbugsSession;
import jsbugs.util.BasicMultiStageProcessHandler;
import jsbugs.util.SBFrame;
import jsbugs.util.UserPrefsHelper;
import model3.AgeCurve;
import model3.DataType;
import model3.IGDIntervalZone;
import model3.IGDScheme;
import model3.IGDUnitBase;
import model3.Lastval;
import model3.SBEvent;
import model3.SBRestrictable;
import model3.SBdb;
import model3.SQPick;
import model3.Surface;
import model3.Taxon;
import model3.TxGroup;
import model3.Well;
import model3.WellEvent;
import model3.WellHeader;
import model3.WellInterp;
import model3.project.Project;
import model3.project.ProjectMember;
import model3.project.ProjectObserver;
import model3.project.WellList;
import net.java.balloontip.BalloonTip;
import net.java.balloontip.TreeNodeBalloonTip;
import net.java.balloontip.positioners.BalloonTipPositioner;
import net.java.balloontip.positioners.LeftBelowPositioner;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.layout.GroupLayout;
import util.InvalidFieldException;
import util.SB;
import util.SBException;
import util.SBPermissionException;
import util.SbugsFileFilter;
import util.exception.StackError;

public class FrameChart
extends SBFrame
implements ChangeListener,
ChartActions,
ProjectObserver {
    static final float zoomIncrement = 1.5f;
    private static final String ICON_PATH = "/resources/icon/";
    private static final Logger LOGGER = Logger.getLogger(FrameChart.class.getName());
    private final FrameJsbugs parent;
    private final SBdb sbdb;
    private final ChartManager chartManager;
    private final TreeModelChart treeModel;
    private final PanelPropertiesTableModel panelPropModel;
    private final BlockPropertiesTableModel blockPropModel;
    private final MapBlockPropertiesTableModel mapBlockPropModel;
    private final ChartTagPropertiesTableModel tagPropModel;
    private final DefaultTableModel nullModel = new DefaultTableModel(0, 0);
    private final DefaultListModel panelListModel = new DefaultListModel();
    private final JList jListPanels = new JList(this.panelListModel);
    private final DefaultListModel corrListModel = new DefaultListModel();
    private final JPanel jPanelCorrList;
    private final PanelTaxonPropertiesPanel jListPTG;
    private Border jScrollPaneTablePropertiesBorder;
    private PageFormat outlinePf = null;
    private JPanelChartShortcuts startPane;
    private BalloonTip hint;
    private final JPanel jPanelCards = new JPanel(new CardLayout());
    private final JTabbedPaneChart jTabbedPaneChart = new JTabbedPaneChart(this);
    private final JLabel jLabelTooltip = new JLabel("");
    private final JLabel jLabelChartSize = new JLabel();
    private final JLabel jLabelProcess = new JLabel(this){
        final /* synthetic */ FrameChart this$0;
        {
            FrameChart frameChart = this$0;
            Objects.requireNonNull(frameChart);
            this.this$0 = frameChart;
        }

        @Override
        public void setText(String text) {
            if (text != null && !text.isEmpty()) {
                this.setIcon(IconFactory.getIcon("ajax-loader.gif"));
            } else {
                this.setIcon(null);
            }
            super.setText(text);
        }
    };
    private Project project;
    private final JList jListCorrLines;
    private final JToolBar jToolbarCorr;
    private final JButton jButtonCorrAddDict;
    private final JButton jButtonCorrAddWells;
    private final JButton jButtonCorrDelete;
    private final JButton jButtonCorrSave;
    private final JButton jButtonCorrRestore;
    private final JPanel jPanelMap;
    private final DefaultListModel listModelMap;
    private final JList jListMap;
    private final JTable jTableMap;
    private final JSplitPane jSplitPaneMap;
    private final JPanel jPanelCorrOcc;
    private final DefaultListModel listModelCorrOcc;
    private final JList jListCorrOcc;
    private CorrelationPropertiesTableModel tableModelCorrOcc;
    private JTable jTableCorrOcc;
    private JScrollPane jsp2;
    private Boolean updatePanels;
    private ButtonGroup buttonGroupMenuOutline;
    private ButtonGroup buttonGroupSort;
    private JButton jButtonChartProperties;
    private JButton jButtonCheckUpdatePanelNo;
    private JButton jButtonCheckUpdatePanelYes;
    private JButton jButtonExportChart;
    private JButton jButtonExportChartBitmap;
    private JButton jButtonLeft;
    private JButton jButtonOpen;
    private JButton jButtonPrintChart;
    private JButton jButtonRemove;
    private JButton jButtonRight;
    private JButton jButtonSaveChart;
    private JButton jButtonZoomIn;
    private JButton jButtonZoomOut;
    private JCheckBox jCheckBoxCheckUpdatePanel;
    private JCheckBoxMenuItem jCheckBoxMenuItemViewGlobal;
    private JDialog jDialogCheckUpdatePanel;
    private JLabel jLabelCheckUpdatePanel;
    private JLabel jLabelProject;
    private JMenu jMenu1;
    private JMenuBar jMenuBar1;
    private JMenu jMenuBlockTabRecouple;
    private JMenu jMenuChart;
    private JMenu jMenuChartBlockNew;
    private JMenu jMenuChartExport;
    private JMenu jMenuFile;
    private JMenu jMenuHelp;
    private JMenuItem jMenuItemAddPanelTemplate;
    private JMenuItem jMenuItemBlockList;
    private JMenuItem jMenuItemBlockNewMap;
    private JMenuItem jMenuItemBlockNewProject;
    private JMenuItem jMenuItemBlockNewScheme;
    private JMenuItem jMenuItemBlockNewWell;
    private JMenuItem jMenuItemBlockTabDecouple;
    private JMenuItem jMenuItemBlockTabRecoupleSuggest;
    private JMenuItem jMenuItemBlockTabRecoupleToExisting;
    private JMenuItem jMenuItemBlockTabRecoupleToNew;
    private JMenuItem jMenuItemBlockTabSelectPanelTemplate;
    private JMenuItem jMenuItemBlockUsage;
    private JMenuItem jMenuItemChartDelete;
    private JMenuItem jMenuItemChartEdit;
    private JMenuItem jMenuItemChartExportBitmap;
    private JMenuItem jMenuItemChartExportFile;
    private JMenuItem jMenuItemChartExportHelp;
    private JMenuItem jMenuItemChartExportKML;
    private JMenuItem jMenuItemChartExportVector;
    private JMenuItem jMenuItemChartOpen;
    private JMenuItem jMenuItemChartPermissions;
    private JMenuItem jMenuItemChartPrint;
    private JMenuItem jMenuItemChartRestore;
    private JMenuItem jMenuItemChartSave;
    private JMenuItem jMenuItemChartTabPopupBlockDefaultDepths;
    private JMenuItem jMenuItemChartTabPopupBlockDepth;
    private JMenuItem jMenuItemChartTabPopupBringTagToFront;
    private JMenuItem jMenuItemChartTabPopupDiscardOverrides;
    private JMenuItem jMenuItemChartTabPopupEditBlock;
    private JMenuItem jMenuItemChartTabPopupNewTag;
    private JMenuItem jMenuItemChartTabPopupOverrideToTemplate;
    private JMenuItem jMenuItemChartTabPopupPanelDepthSnap;
    private JMenuItem jMenuItemChartTabPopupPanelProperties;
    private JMenuItem jMenuItemChartTabPopupReorganiseWellBlocks;
    private JMenuItem jMenuItemChartTabPopupSelectBlockTemplate;
    private JMenuItem jMenuItemChartTabPopupSendTagToBack;
    private JMenuItem jMenuItemCloseAllTabs;
    private JMenuItem jMenuItemCorrOccCreateTemplate;
    private JMenuItem jMenuItemCorrOccCreateTxGroup;
    private JMenuItem jMenuItemCorrOccEdit;
    private JMenuItem jMenuItemCorrOccRemove;
    private JMenuItem jMenuItemDeletePanelTemplate;
    private JMenuItem jMenuItemEditPanelTemplate;
    private JMenuItem jMenuItemExit;
    private JMenuItem jMenuItemExportPanel;
    private JMenuItem jMenuItemExportToShapefile;
    private JMenuItem jMenuItemHelp;
    private JMenuItem jMenuItemLayerDown;
    private JMenuItem jMenuItemLayerUp;
    private JMenuItem jMenuItemOpenLegacy;
    private JMenuItem jMenuItemOpenProject;
    private JMenuItem jMenuItemOverrides;
    private JMenuItem jMenuItemPanelHelp;
    private JMenuItem jMenuItemPanelManager;
    private JMenuItem jMenuItemPanelRestore;
    private JMenuItem jMenuItemPanelSimilar;
    private JMenuItem jMenuItemPanelTemplateDefault;
    private JMenuItem jMenuItemPanelTemplatePermissions;
    private JMenuItem jMenuItemPanelUsages;
    private JMenuItem jMenuItemRemoveLayer;
    private JMenuItem jMenuItemSaveAs;
    private JMenuItem jMenuItemShapeStores;
    private JMenuItem jMenuItemTabUsage;
    private JMenuItem jMenuItemTagList;
    private JMenuItem jMenuItemTemplateNew;
    private JMenuItem jMenuItemTemplatePermissions;
    private JMenu jMenuSort;
    private JMenu jMenuView;
    private JPanel jPanelProject;
    private JPanel jPanelProperties;
    private JPanel jPanelTree;
    private JPopupMenu jPopupMenuBlockCorr;
    private JPopupMenu jPopupMenuBlockTab;
    private JPopupMenu jPopupMenuChartTab;
    private JPopupMenu jPopupMenuCorrLine;
    private JPopupMenu jPopupMenuCorrOcc;
    private JMenuItem jPopupMenuItemAddBlockCorrTemplate;
    private JMenuItem jPopupMenuItemBlockCorrAddTxGroup;
    private JMenuItem jPopupMenuItemBlockCorrUsages;
    private JMenuItem jPopupMenuItemBlockTemplateTabs;
    private JMenuItem jPopupMenuItemCorrLineEdit;
    private JMenuItem jPopupMenuItemDeleteBlockCorrTemplate;
    private JMenuItem jPopupMenuItemEditBlockCorrTemplate;
    private JMenuItem jPopupMenuItemTemplateOverrides;
    private JPopupMenu jPopupMenuMapLayers;
    private JPopupMenu jPopupMenuPanels;
    private JRadioButtonMenuItem jRadioButtonMenuItemAlpha;
    private JRadioButtonMenuItem jRadioButtonMenuItemCustomOutline;
    private JRadioButtonMenuItem jRadioButtonMenuItemMod;
    private JRadioButtonMenuItem jRadioButtonMenuItemNoOutline;
    private JRadioButtonMenuItem jRadioButtonMenuItemShowA4;
    private JRadioButtonMenuItem jRadioButtonMenuItemShowA5;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPanePanelDetails;
    private JScrollPane jScrollPaneTableProperties;
    private JPopupMenu.Separator jSeparator1;
    private JPopupMenu.Separator jSeparator10;
    private JPopupMenu.Separator jSeparator11;
    private JPopupMenu.Separator jSeparator2;
    private JPopupMenu.Separator jSeparator3;
    private JPopupMenu.Separator jSeparator4;
    private JToolBar.Separator jSeparator5;
    private JPopupMenu.Separator jSeparator6;
    private JPopupMenu.Separator jSeparator7;
    private JPopupMenu.Separator jSeparator8;
    private JPopupMenu.Separator jSeparator9;
    private JPopupMenu.Separator jSeparatorChartTabPopup1;
    private JPopupMenu.Separator jSeparatorChartTabPopup2;
    private JPopupMenu.Separator jSeparatorChartTabPopup3;
    private JToolBar.Separator jSeparatorElements;
    private JPopupMenu.Separator jSeparatorPanelHelp;
    private JPopupMenu.Separator jSeparatorPanelRestore;
    private JPopupMenu.Separator jSeparatorPanelSearch;
    private JSplitPane jSplitPaneMain;
    private JSplitPane jSplitPanePalette;
    private JSplitPane jSplitPanePropertiesTable;
    private JTable jTableProperties;
    private JTextPane jTextPanePanelDetails;
    private JToggleButton jToggleButtonMagnifier;
    private JToggleButton jToggleButtonXHairs;
    private JToolBar jToolBarMain;
    private JTree jTreePanels;
    private static final String HINT_START = "Start by creating a new well block template.";

    public FrameChart(FrameJsbugs parent, SBdb sbdb) {
        this.jPanelCorrList = new JPanel();
        this.jPanelCorrList.setLayout(new BoxLayout(this.jPanelCorrList, 3));
        this.jToolbarCorr = new JToolBar();
        this.jToolbarCorr.setFloatable(false);
        this.jToolbarCorr.setBackground(PropertiesTable.TITLE_COLOUR);
        this.jButtonCorrAddDict = new JButton();
        this.jToolbarCorr.add(this.jButtonCorrAddDict);
        this.jButtonCorrAddWells = new JButton(IconFactory.getIcon("addCorrWell"));
        this.jToolbarCorr.add(this.jButtonCorrAddWells);
        this.jButtonCorrDelete = new JButton(IconFactory.getIcon("deleteCorrLine.png"));
        this.jToolbarCorr.add(this.jButtonCorrDelete);
        this.jToolbarCorr.add(Box.createHorizontalGlue());
        this.jButtonCorrRestore = new JButton(IconFactory.getIcon("restore24"));
        this.jToolbarCorr.add(this.jButtonCorrRestore);
        this.jButtonCorrSave = new JButton(IconFactory.getIcon("save24.png"));
        this.jToolbarCorr.add(this.jButtonCorrSave);
        this.jButtonCorrSave.setRolloverIcon(IconFactory.getIcon("save24rollover.png"));
        this.jButtonCorrRestore.setVisible(false);
        this.jButtonCorrSave.setVisible(false);
        JButton[] buttons = new JButton[]{this.jButtonCorrAddDict, this.jButtonCorrAddWells, this.jButtonCorrDelete, this.jButtonCorrSave, this.jButtonCorrRestore};
        String[] tooltips = new String[]{"Add from dictionary", "Add from chart wells", "Delete selected line", "Save correlation template", "Undo changes"};
        for (int i = 0; i < buttons.length; ++i) {
            buttons[i].setFocusable(false);
            buttons[i].setOpaque(false);
            buttons[i].setBorderPainted(false);
            buttons[i].setToolTipText(tooltips[i]);
        }
        this.jToolbarCorr.setAlignmentX(0.0f);
        this.jPanelCorrList.add(this.jToolbarCorr);
        this.jPanelCorrList.add(Box.createVerticalStrut(6));
        this.jListCorrLines = new JList(this.corrListModel);
        JScrollPane jScrollPane = new JScrollPane(this.jListCorrLines);
        jScrollPane.setAlignmentX(0.0f);
        this.jPanelCorrList.add(jScrollPane);
        this.jButtonCorrAddDict.addActionListener(e -> this.addCorrFromDict());
        this.jButtonCorrAddWells.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.addCorrFromWells();
            }
        });
        this.jButtonCorrDelete.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.deleteCorrLine();
            }
        });
        this.jButtonCorrSave.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.saveCorrLines();
            }
        });
        this.jButtonCorrRestore.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.restoreCorrTemplate();
            }
        });
        this.jListCorrLines.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void mousePressed(MouseEvent evt) {
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                this.evaluatePopup(evt);
            }

            private void evaluatePopup(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    this.this$0.jListCorrLines.setSelectedIndex(this.this$0.jListCorrLines.locationToIndex(evt.getPoint()));
                    if (this.this$0.jListCorrLines.getSelectedIndex() >= 0) {
                        this.this$0.jPopupMenuCorrLine.show(this.this$0.jListCorrLines, evt.getX(), evt.getY());
                    }
                } else if (evt.getClickCount() > 1 && SwingUtilities.isLeftMouseButton(evt) && this.this$0.jListCorrLines.getSelectedValue() != null) {
                    this.this$0.openCorrelationLineEditDialog();
                }
            }
        });
        this.jPanelMap = new JPanel();
        this.listModelMap = new DefaultListModel();
        this.jListMap = new JList(this.listModelMap);
        this.jTableMap = new PropertiesTable();
        this.jSplitPaneMap = new JSplitPane(0);
        this.jPanelCorrOcc = new JPanel();
        this.listModelCorrOcc = new DefaultListModel();
        this.jListCorrOcc = new JList(this.listModelCorrOcc);
        this.updatePanels = null;
        this.sbdb = sbdb;
        this.parent = parent;
        this.chartManager = parent.getChartManager();
        this.treeModel = new TreeModelChart(this.chartManager);
        this.treeModel.setRunnableDecorator(new RunWithCursorDecorator(this));
        this.jListPTG = new PanelTaxonPropertiesPanel(this, sbdb);
        this.panelPropModel = new PanelPropertiesTableModel(this, sbdb);
        this.blockPropModel = new BlockPropertiesTableModel(this, sbdb);
        this.mapBlockPropModel = new MapBlockPropertiesTableModel(this, sbdb);
        this.tagPropModel = new ChartTagPropertiesTableModel(this, sbdb);
        this.chartManager.preloadBlockTemplates();
        this.initComponents();
        this.init();
    }

    private void init() {
        SbugsLookAndFeelSetup.LAF laf;
        this.setTitle("Charts & Templates - StrataBugs");
        SB.centreWindow((Frame)this);
        this.jToolBarMain.setFloatable(false);
        if (FrameJsbugs.isMacPlatform()) {
            this.jMenuHelp.setText("Help ");
            this.jMenuItemExit.setText("Close Charts");
        }
        this.initStartPane(true);
        this.jPanelCards.add("startPane", this.startPane);
        JPanel jPanelTabbedPane = new JPanel();
        jPanelTabbedPane.setLayout(new BoxLayout(jPanelTabbedPane, 1));
        jPanelTabbedPane.add(this.jTabbedPaneChart);
        JToolBar jToolbarChartInfo = new JToolBar();
        jToolbarChartInfo.setFloatable(false);
        jToolbarChartInfo.add(this.jLabelTooltip);
        jToolbarChartInfo.add(this.jLabelProcess);
        jToolbarChartInfo.add(Box.createVerticalStrut(18));
        jToolbarChartInfo.add(Box.createHorizontalGlue());
        this.jLabelChartSize.setForeground(Color.DARK_GRAY);
        jToolbarChartInfo.add(this.jLabelChartSize);
        this.jLabelProcess.setForeground(Color.DARK_GRAY);
        jPanelTabbedPane.add(jToolbarChartInfo);
        this.jTabbedPaneChart.setAlignmentX(0.0f);
        jToolbarChartInfo.setAlignmentX(0.0f);
        this.jPanelCards.add("tabbedPane", jPanelTabbedPane);
        this.jPanelCards.setPreferredSize(new Dimension(200, 200));
        this.jSplitPaneMain.setLeftComponent(this.jPanelCards);
        this.jTabbedPaneChart.addChangeListener(this);
        this.chartManager.addChartListener(this.jTabbedPaneChart);
        ((CardLayout)this.jPanelCards.getLayout()).show(this.jPanelCards, "startPane");
        this.initKeyBindings();
        this.initJList();
        this.initJTree();
        this.jTreePanels.setDragEnabled(true);
        new DragSource().createDefaultDragGestureRecognizer(this.jTreePanels, 3, this.jTabbedPaneChart);
        try {
            this.jTreePanels.setTransferHandler(new SBChartTransferHandler(this, this.sbdb, this.chartManager));
            this.jTabbedPaneChart.setTransferHandler(new SBChartTransferHandler(this, this.sbdb, this.chartManager));
        }
        catch (SBException sbe) {
            StackError.showStackError((String)"Error initialising transfer handlers", (Throwable)sbe);
        }
        this.jSplitPanePalette.setVisible(false);
        this.jScrollPaneTablePropertiesBorder = this.jScrollPaneTableProperties.getBorder();
        this.jScrollPaneTableProperties.setBorder(null);
        this.initTextPanePanelDetails();
        this.initCorrOccPanel();
        this.jListCorrLines.setCellRenderer(new ChartListLabel(this.sbdb));
        this.initMapPanel();
        this.jLabelProject.setVisible(false);
        this.restoreGUISession();
        this.enableToolbar(false);
        if (this.parent.showHints()) {
            this.hint = HintSequence.showHint(this.parent, this.startPane.getNewWellBlockButton(), HINT_START, false);
        }
        UIManager.put("ProgressBar.selectionForeground", Color.black);
        UIManager.put("ProgressBar.selectionBackground", Color.black);
        this.setIcons();
        if (FrameJsbugs.isMacPlatform() && (laf = SbugsLookAndFeelSetup.getLAF()) == SbugsLookAndFeelSetup.LAF.NATIVE) {
            this.jMenuItemTemplateNew.setText("New Named Chart...");
        }
        LOGGER.log(Level.CONFIG, "jTableMap {0} jTableProperties {1}", new Object[]{System.identityHashCode(this.jTableMap), System.identityHashCode(this.jTableProperties)});
    }

    private void setIcons() {
        this.setMultiResIconImage("frameChart.svg");
        if (SbugsSession.getSession().useHiResIcons()) {
            IconFactory.setButtonIconsInBackground(List.of(new IconFactory.ButtonIconInfo(this.jButtonOpen, "openFile.svg"), new IconFactory.ButtonIconInfo(this.jButtonSaveChart, "save.svg"), new IconFactory.ButtonIconInfo(this.jButtonPrintChart, "print.svg"), new IconFactory.ButtonIconInfo(this.jButtonExportChart, "exportVector.svg"), new IconFactory.ButtonIconInfo(this.jButtonExportChartBitmap, "exportBitmap.svg"), new IconFactory.ButtonIconInfo(this.jButtonChartProperties, "chartProperties.svg"), new IconFactory.ButtonIconInfo(this.jButtonZoomIn, "zoomIn.svg"), new IconFactory.ButtonIconInfo(this.jButtonZoomOut, "zoomOut.svg"), new IconFactory.ButtonIconInfo(this.jToggleButtonMagnifier, "magnifier.svg"), new IconFactory.ButtonIconInfo(this.jToggleButtonXHairs, "crosshair.svg"), new IconFactory.ButtonIconInfo(this.jButtonLeft, "moveBlockLeft.svg"), new IconFactory.ButtonIconInfo(this.jButtonRight, "moveBlockRight.svg"), new IconFactory.ButtonIconInfo(this.jButtonRemove, "removeBlock.svg")));
        }
    }

    public ChartManager getChartManager() {
        return this.chartManager;
    }

    private void initJList() {
        this.jListPanels.setCellRenderer(new ChartListLabel(this.sbdb));
    }

    private void initStartPane(boolean initial) {
        if (initial) {
            JPanelChartShortcuts.NewBlockTemplateListener newBlockTemplateListener = blockType -> this.createAndOpenNewBlockTemplate(blockType);
            ActionListener newChartListener = e -> this.createNewChart();
            JPanelChartShortcuts.TemplateHandler templateHandler = template -> this.openTemplates(List.of(template));
            this.startPane = new JPanelChartShortcuts(newBlockTemplateListener, newChartListener, templateHandler);
        }
        this.updateRecentButtons(null);
    }

    private void updateRecentButtons(ChartTemplateBase willBeDeleted) {
        ChartTemplateBase[] templates;
        int nTemplates = 15;
        int nButtons = 10;
        try {
            templates = this.chartManager.getRecentTemplates(15);
        }
        catch (SQLException sql) {
            SbugsExceptionHandler.showStackError("Error getting recently used templates", sql);
            templates = new ChartTemplateBase[]{};
        }
        ArrayList<ChartTemplateBase> templatesForButtons = new ArrayList<ChartTemplateBase>();
        for (ChartTemplateBase template : templates) {
            BlockTemplate bTemplate;
            if (template == willBeDeleted || template instanceof BlockTemplate && (bTemplate = (BlockTemplate)template).getType() == BlockType.MAP) continue;
            if (templatesForButtons.size() > 10) break;
            templatesForButtons.add(template);
        }
        this.startPane.initRecentButtons(templatesForButtons.toArray(new ChartTemplateBase[templatesForButtons.size()]));
    }

    private void initJTree() {
        this.jTreePanels.getSelectionModel().setSelectionMode(1);
        this.jTreePanels.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                Object o = this.getSelectObject(evt);
                if (o == null) {
                    return;
                }
                if (evt.isPopupTrigger()) {
                    if (o instanceof BlockTemplateInfo) {
                        BlockTemplateInfo blockTemplateInfo = (BlockTemplateInfo)o;
                        o = this.this$0.chartManager.getBlockTemplateFromInfo(blockTemplateInfo);
                    }
                    this.doTreePopup(evt, o);
                    return;
                }
                if (evt.getClickCount() > 1) {
                    BlockTemplate bTemp;
                    if (o instanceof BlockTemplateInfo) {
                        BlockTemplateInfo blockTemplateInfo = (BlockTemplateInfo)o;
                        o = this.this$0.chartManager.getBlockTemplateFromInfo(blockTemplateInfo);
                    }
                    if (o instanceof BlockTemplate && !this.this$0.jTabbedPaneChart.selectTemplate(bTemp = (BlockTemplate)o)) {
                        this.this$0.initBlockTemplateTab(bTemp, true);
                    }
                } else {
                    this.this$0.reInitTab(o);
                }
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                Object o = this.getSelectObject(evt);
                if (o == null) {
                    return;
                }
                if (evt.isPopupTrigger()) {
                    this.doTreePopup(evt, o);
                }
            }

            private Object getSelectObject(MouseEvent evt) {
                int row = this.this$0.jTreePanels.getRowForLocation(evt.getX(), evt.getY());
                if (row < 0) {
                    return null;
                }
                if (evt.getClickCount() < 2) {
                    this.this$0.jTreePanels.setSelectionRow(row);
                }
                return this.this$0.jTreePanels.getSelectionPath().getLastPathComponent();
            }

            private void doTreePopup(MouseEvent evt, Object o) {
                if (o instanceof PanelTemplate || o instanceof PanelType) {
                    if (o instanceof PanelTemplate) {
                        PanelTemplate panelTemplate = (PanelTemplate)o;
                        this.this$0.jMenuItemAddPanelTemplate.setText("Copy...");
                        this.this$0.jMenuItemPanelTemplateDefault.setText("Set as default '" + String.valueOf(panelTemplate.getType()) + "' template");
                    } else {
                        this.this$0.jMenuItemAddPanelTemplate.setText("New " + ((PanelType)o).toString() + " panel template");
                    }
                    this.this$0.jMenuItemDeletePanelTemplate.setVisible(o instanceof PanelTemplate && !((PanelTemplate)o).isDefaultTemplate());
                    this.this$0.jMenuItemPanelTemplateDefault.setVisible(o instanceof PanelTemplate && !((PanelTemplate)o).isDefaultTemplate() && ((PanelTemplate)o).getProjID() == 0 && !PanelType.requiresScheme(((PanelTemplate)o).getType()));
                    this.this$0.jMenuItemPanelTemplatePermissions.setVisible(o instanceof PanelTemplate);
                    this.this$0.jMenuItemEditPanelTemplate.setVisible(o instanceof PanelTemplate);
                    this.this$0.jMenuItemPanelRestore.setVisible(o instanceof PanelTemplate && ((PanelTemplate)o).isEditing());
                    this.this$0.jSeparatorPanelRestore.setVisible(o instanceof PanelTemplate && ((PanelTemplate)o).isEditing());
                    this.this$0.jSeparatorPanelSearch.setVisible(o instanceof PanelTemplate);
                    this.this$0.jMenuItemPanelUsages.setVisible(o instanceof PanelTemplate);
                    this.this$0.jMenuItemPanelSimilar.setVisible(o instanceof PanelTemplate);
                    boolean helpVisible = o instanceof PanelTemplate && ((PanelTemplate)o).getType().getHtml() != null || o instanceof PanelType && ((PanelType)o).getHtml() != null;
                    this.this$0.jMenuItemPanelHelp.setVisible(helpVisible);
                    this.this$0.jSeparatorPanelHelp.setVisible(helpVisible);
                    this.this$0.jPopupMenuPanels.show(evt.getComponent(), evt.getX(), evt.getY());
                } else {
                    if (o instanceof TemplateDescr) {
                        TemplateDescr template = (TemplateDescr)o;
                        this.this$0.jPopupMenuItemDeleteBlockCorrTemplate.setText("Delete '" + template.getName() + "'");
                        this.this$0.jPopupMenuItemEditBlockCorrTemplate.setText("Edit '" + template.getName() + "' details...");
                    }
                    if (!(o instanceof BlockTemplate)) {
                        if (o instanceof CorrelationType) {
                            CorrelationType corrType = (CorrelationType)o;
                            this.this$0.jPopupMenuItemAddBlockCorrTemplate.setText("New " + corrType.toString());
                        } else if (o instanceof CorrelationTemplate) {
                            CorrelationTemplate corrTempl = (CorrelationTemplate)o;
                            this.this$0.jPopupMenuItemAddBlockCorrTemplate.setText("New " + corrTempl.getType().toString());
                        } else if (o instanceof BlockType) {
                            BlockType blockType = (BlockType)o;
                            this.this$0.jPopupMenuItemAddBlockCorrTemplate.setText("New " + String.valueOf(blockType) + " Template");
                        } else {
                            return;
                        }
                    }
                    this.this$0.jPopupMenuItemAddBlockCorrTemplate.setVisible(o instanceof CorrelationType || o instanceof CorrelationTemplate || o instanceof BlockType);
                    this.this$0.jPopupMenuItemEditBlockCorrTemplate.setVisible(o instanceof TemplateDescr);
                    this.this$0.jPopupMenuItemDeleteBlockCorrTemplate.setVisible(o instanceof TemplateDescr);
                    this.this$0.jMenuItemTemplatePermissions.setVisible(o instanceof BlockTemplate || o instanceof CorrelationTemplate);
                    this.this$0.jPopupMenuItemTemplateOverrides.setVisible(o instanceof BlockTemplate);
                    this.this$0.jPopupMenuItemBlockCorrAddTxGroup.setVisible(o instanceof CorrelationTemplate && ((CorrelationTemplate)o).getType() == CorrelationType.EVENT);
                    this.this$0.jSeparator11.setVisible(o instanceof TemplateDescr);
                    this.this$0.jPopupMenuItemBlockCorrUsages.setVisible(o instanceof TemplateDescr);
                    this.this$0.jPopupMenuItemBlockTemplateTabs.setVisible(o instanceof BlockTemplate);
                    this.this$0.jPopupMenuBlockCorr.show(evt.getComponent(), evt.getX(), evt.getY());
                }
            }
        });
        this.jTreePanels.addTreeSelectionListener(e -> {
            AWTEvent event = EventQueue.getCurrentEvent();
            if (event instanceof KeyEvent) {
                this.reInitTab(e.getPath().getLastPathComponent());
            }
        });
        this.jTreePanels.setCellRenderer(new DefaultTreeCellRenderer(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                JLabel label;
                block20: {
                    if (this.getFont() != null) {
                        this.setFont(this.getFont().deriveFont(0));
                    }
                    label = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                    if (value instanceof PanelType) {
                        PanelType panelType = (PanelType)value;
                        label.setIcon(panelType.getIcon());
                    } else if (value instanceof TemplateDescr) {
                        CorrelationTemplate cTemp;
                        if (value instanceof PanelTemplate) {
                            PanelTemplate pTemp = (PanelTemplate)value;
                            if (pTemp.isEditing()) {
                                this.setFont(this.getFont().deriveFont(1));
                            }
                        } else if (value instanceof CorrelationTemplate && (cTemp = (CorrelationTemplate)value).isDirty()) {
                            this.setFont(this.getFont().deriveFont(1));
                        }
                        try {
                            if (((ProjectMember)value).getProjID() == 0) {
                                if (((SBRestrictable)((Object)value)).isReadOnly()) {
                                    label.setIcon(IconFactory.getIconGlobalLocked());
                                } else {
                                    label.setIcon(IconFactory.getIconGlobalUnlocked());
                                }
                                break block20;
                            }
                            if (((SBRestrictable)((Object)value)).isReadOnly()) {
                                label.setIcon(IconFactory.getIconProjectLocked());
                                break block20;
                            }
                            label.setIcon(IconFactory.getIconProjectUnlocked());
                        }
                        catch (SBException e) {
                            e.printStackTrace();
                        }
                    } else if (value instanceof BlockType) {
                        BlockType blockType = (BlockType)value;
                        label.setIcon(blockType.getIconFolder());
                    } else if (value instanceof CorrelationType) {
                        CorrelationType corrType = (CorrelationType)value;
                        label.setIcon(corrType.getIconFolder());
                    } else if (value instanceof CorrelationStandard) {
                        label.setFont(label.getFont().deriveFont(2));
                        label.setIcon(IconFactory.getIcon("panelStandard"));
                    }
                }
                return label;
            }
        });
    }

    private void initKeyBindings() {
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(61, 128), "zoomIn");
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(107, 128), "zoomIn");
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(45, 128), "zoomOut");
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(109, 128), "zoomOut");
        this.getRootPane().getActionMap().put("zoomIn", new AbstractAction(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ((JScrollPaneChartTemplate)this.this$0.jTabbedPaneChart.getSelectedComponent()).zoomSelection(true);
            }
        });
        this.getRootPane().getActionMap().put("zoomOut", new AbstractAction(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ((JScrollPaneChartTemplate)this.this$0.jTabbedPaneChart.getSelectedComponent()).zoomSelection(false);
            }
        });
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(49, 128), "zoomToNatural");
        this.getRootPane().getActionMap().put("zoomToNatural", new AbstractAction(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.jTabbedPaneChart.getSelectedScrollPaneChart().zoomToNatural();
            }
        });
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(81, 0, false), "magnify");
        this.getRootPane().getActionMap().put("magnify", new AbstractAction(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.jToggleButtonMagnifier.setSelected(true);
                this.this$0.jToggleButtonMagnifierActionPerformed(e);
            }
        });
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(81, 0, true), "unmagnify");
        this.getRootPane().getActionMap().put("unmagnify", new AbstractAction(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.jToggleButtonMagnifier.setSelected(false);
                this.this$0.jToggleButtonMagnifierActionPerformed(e);
            }
        });
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(48, 128), "fitToScreen");
        this.getRootPane().getActionMap().put("fitToScreen", new AbstractAction(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ((JScrollPaneChartBase)this.this$0.jTabbedPaneChart.getSelectedComponent()).fitToScreen();
            }
        });
        this.jTabbedPaneChart.getInputMap(2).put(KeyStroke.getKeyStroke(37, 0, true), "moveleft");
        this.jTabbedPaneChart.getActionMap().put("moveleft", new AbstractAction(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.jButtonLeftActionPerformed(e);
            }
        });
        this.jTabbedPaneChart.getInputMap(2).put(KeyStroke.getKeyStroke(39, 0, true), "moveright");
        this.jTabbedPaneChart.getActionMap().put("moveright", new AbstractAction(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.jButtonRightActionPerformed(e);
            }
        });
    }

    private void initTextPanePanelDetails() {
        StyledDocument doc = this.jTextPanePanelDetails.getStyledDocument();
        Style defaultStyle = StyleContext.getDefaultStyleContext().getStyle("default");
        Style regular = doc.addStyle("regular", defaultStyle);
        StyleConstants.setForeground(regular, Color.DARK_GRAY);
        Style decoupled = doc.addStyle("decoupled", regular);
        StyleConstants.setForeground(decoupled, new Color(51, 102, 204));
        StyleConstants.setBold(decoupled, true);
        StyleConstants.setLineSpacing(decoupled, 1.5f);
        Style blockOverride = doc.addStyle("blockOverride", regular);
        StyleConstants.setForeground(blockOverride, new Color(51, 102, 204));
        Style proj = doc.addStyle("project", regular);
        StyleConstants.setForeground(proj, new Color(128, 130, 133));
        Style projectIcon = doc.addStyle("projectIcon", proj);
        StyleConstants.setIcon(projectIcon, IconFactory.getIconGlobal());
        Style boldProject = doc.addStyle("boldProject", proj);
        StyleConstants.setBold(boldProject, true);
        Style boldProjectIcon = doc.addStyle("boldProjectIcon", boldProject);
        StyleConstants.setIcon(boldProjectIcon, IconFactory.getIconProject());
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.reInitTopLevelWindow();
    }

    private void jTabbedPaneChartStateChanged(ChangeEvent evt) {
        this.reInitTab(null);
    }

    private void setChartSizeLabel() {
        JScrollPaneChartTemplate scrollPane = (JScrollPaneChartTemplate)this.jTabbedPaneChart.getSelectedComponent();
        Object text = "";
        if (scrollPane.blockType == null) {
            text = (String)text + (int)Math.floor(scrollPane.getChart().getMMwidth()) + " x " + (int)Math.floor(scrollPane.getChart().getMMheight()) + " mm";
        }
        this.jLabelChartSize.setText((String)text);
    }

    private void setProject(int projID) {
        if (this.project != null && this.project.getID() == projID) {
            return;
        }
        if (projID == 0) {
            this.jLabelProject.setText("Global");
            this.jLabelProject.setIcon(IconFactory.getIconGlobal());
            this.project = null;
        } else {
            try {
                Project proj = this.sbdb.getProject(projID);
                if (proj == null) {
                    this.project = null;
                    throw new IllegalArgumentException("No project for projID " + projID);
                }
                this.project = proj;
                this.project.addListener(this);
                this.jLabelProject.setText(this.project.getName());
                this.jLabelProject.setIcon(IconFactory.getIconProject());
            }
            catch (SQLException sql) {
                SbugsExceptionHandler.showStackError(sql, this);
            }
        }
        TreePath selection = this.jTreePanels.getSelectionPath();
        if (this.treeModel.setProjID(projID)) {
            this.jTreePanels.setSelectionPath(selection);
        }
    }

    private int getProjID() {
        if (this.project == null) {
            return 0;
        }
        return this.project.getID();
    }

    @Override
    public void projectDetailsChanged(Project project) {
        if (project.getID() == this.project.getID()) {
            this.jLabelProject.setText(project.getName());
        }
    }

    private void enableToolbar(boolean enable) {
        this.jButtonRemove.setEnabled(enable);
        this.jButtonRight.setEnabled(enable);
        this.jButtonLeft.setEnabled(enable);
        this.jButtonChartProperties.setEnabled(enable);
        this.jMenuItemChartEdit.setEnabled(enable);
        this.jMenuItemChartDelete.setEnabled(enable);
        this.jMenuItemChartSave.setEnabled(enable);
        this.jMenuItemSaveAs.setEnabled(enable);
        this.jMenuItemChartPrint.setEnabled(enable);
        this.jMenuItemChartPermissions.setEnabled(enable);
        this.jMenuItemChartRestore.setEnabled(enable);
        this.jMenuChartExport.setEnabled(enable);
        this.jMenuItemBlockUsage.setEnabled(enable);
        this.jMenuItemChartExportFile.setEnabled(enable);
        this.jMenuItemTabUsage.setEnabled(enable);
        this.jMenuItemOverrides.setEnabled(enable);
    }

    @Override
    public void chartProperties() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void zoom(boolean in) {
        if (this.jTabbedPaneChart.getSelectedIndex() > -1) {
            JScrollPaneChartTemplate scrollPane = this.jTabbedPaneChart.getSelectedScrollPaneChart();
            scrollPane.zoom(in);
        }
    }

    @Override
    public void undoRedo(boolean undo) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private void reInitTopLevelWindow() {
        CardLayout cl = (CardLayout)this.jPanelCards.getLayout();
        if (this.jTabbedPaneChart.getTabCount() > 0) {
            cl.show(this.jPanelCards, "tabbedPane");
            this.enableToolbar(true);
            if (!this.jSplitPanePalette.isVisible()) {
                this.jSplitPanePalette.setVisible(true);
                if (this.jPanelCards.getPreferredSize().width + this.jSplitPanePalette.getPreferredSize().width > this.jSplitPaneMain.getPreferredSize().width) {
                    this.jPanelCards.setPreferredSize(new Dimension(this.jSplitPaneMain.getPreferredSize().width - this.jSplitPanePalette.getPreferredSize().width - 10, this.jPanelCards.getPreferredSize().height));
                }
                this.jSplitPaneMain.resetToPreferredSizes();
            }
            this.reInitWindow(null);
            return;
        }
        this.jMenuItemTagList.setEnabled(false);
        this.jMenuItemBlockList.setEnabled(false);
        this.jMenuItemExportToShapefile.setEnabled(false);
        this.initStartPane(false);
        cl.show(this.jPanelCards, "startPane");
        this.jSplitPanePalette.setVisible(false);
        this.enableToolbar(false);
    }

    public void reInitWindow(Object selection) {
        JScrollPaneChartTemplate scrollPane = (JScrollPaneChartTemplate)this.jTabbedPaneChart.getSelectedComponent();
        this.setProject(scrollPane.getTemplate().getProjID());
        this.jLabelProject.setVisible(true);
        BlockType mode = scrollPane.blockType;
        boolean canWrite = this.checkCanWrite(scrollPane.getTemplate(), false);
        this.reInitToolbar(mode, canWrite);
        this.jMenuItemBlockList.setEnabled(mode == null);
        this.jMenuItemTagList.setEnabled(mode == null);
        this.jMenuItemExportToShapefile.setEnabled(mode == null);
        this.setChartSizeLabel();
        if (selection == null) {
            selection = scrollPane.getSelectedChartObject();
        }
        this.reInitTab(selection);
    }

    private void reInitToolbar(BlockType mode, boolean canWrite) {
        this.jToggleButtonXHairs.setSelected(((JScrollPaneChartBase)this.jTabbedPaneChart.getSelectedComponent()).showingXHairs());
        if (mode != null) {
            this.jButtonRemove.setIcon(IconFactory.getIcon("removePanel.svg"));
            this.jButtonLeft.setIcon(IconFactory.getIcon("movePanelLeft.svg"));
            this.jButtonRight.setIcon(IconFactory.getIcon("movePanelRight.svg"));
        } else {
            this.jButtonRemove.setIcon(IconFactory.getIcon("removeBlock.svg"));
            this.jButtonLeft.setIcon(IconFactory.getIcon("moveBlockLeft.svg"));
            this.jButtonRight.setIcon(IconFactory.getIcon("moveBlockRight.svg"));
        }
        this.jButtonRemove.setEnabled(canWrite);
        this.jButtonLeft.setEnabled(canWrite);
        this.jButtonRight.setEnabled(canWrite);
        this.jButtonChartProperties.setEnabled(mode == null);
    }

    private void reInitTab(Object selection) {
        LOGGER.log(Level.FINE, "ReInitTab with {0}", new Object[]{selection});
        if (this.jTabbedPaneChart.getSelectedComponent() == null) {
            return;
        }
        SelectedObject selectedObject = this.getSelectedObject(selection);
        this.reInitTree(selectedObject);
        this.reInitChartComponents(selectedObject);
        this.reInitPropertiesPane(selectedObject);
        this.reInitDetailsPane();
    }

    private void reInitTree(SelectedObject s) {
        BlockType mode = ((JScrollPaneChartTemplate)this.jTabbedPaneChart.getSelectedComponent()).blockType;
        this.treeModel.setMode(mode);
        Object objectToSelect = Stream.of(s.panelTemplate, s.blockTemplate, s.corrTemplate, s.corrStd, s.original).filter(Objects::nonNull).findFirst().orElse(null);
        if (s.original != null && s.original instanceof BlockTemplateInfo) {
            objectToSelect = s.original;
        }
        if (objectToSelect != null) {
            this.jTreePanels.isFocusOwner();
            TreePath path = this.treeModel.getPath(objectToSelect);
            this.jTreePanels.setSelectionPath(path);
            this.jTreePanels.scrollPathToVisible(path);
            this.jTreePanels.expandPath(path);
        } else {
            this.jTreePanels.setSelectionPath(null);
        }
    }

    private void reInitChartComponents(SelectedObject selection) {
        JScrollPaneChartTemplate scrollPane = (JScrollPaneChartTemplate)this.jTabbedPaneChart.getSelectedComponent();
        BlockType mode = scrollPane.blockType;
        if (mode != null) {
            ChartBlockBase block = scrollPane.getActiveBlock();
            block.setSelectedPanel(selection.chartPanel);
            if (selection.chartPanel != null && selection.chartPanel instanceof PanelTaxonGroup && selection.innerPanel != null) {
                ((PanelTaxonGroup)selection.chartPanel).setSelectedPanels(selection.innerPanel.getPanelTaxonOcc());
            }
            if (selection.chartPanel == null && selection.panelTemplate != null) {
                block.setSelectedPanels(selection.panelTemplate);
            }
            block.useEditingPanelProperties();
        } else {
            scrollPane.view.chart.getSelectedBlock().ifPresent(b -> b.setSelectedPanel(null));
            scrollPane.view.chart.setSelectedBlock(selection.block);
            if (selection.block == null && selection.blockTemplate != null) {
                scrollPane.view.chart.setSelectedBlocks(selection.blockTemplate);
            }
            scrollPane.view.chart.setSelectedCorrelation(selection.correlation);
            scrollPane.view.chart.setSelectedTag(selection.tag);
        }
        scrollPane.repaint();
    }

    private void reInitPropertiesPane(SelectedObject selection) {
        JComponent comp;
        Object o = selection.original;
        boolean repeat = false;
        if (o instanceof CorrelationTemplate) {
            CorrelationTemplate correlationTemplate = (CorrelationTemplate)o;
            comp = this.jPanelCorrList;
            this.reInitCorrelationListPanel(correlationTemplate);
        } else if (o instanceof Correlation || o instanceof Chart && ((Chart)o).hasCorrelations()) {
            comp = this.jPanelCorrOcc;
            Chart chart = o instanceof Chart ? (Chart)o : this.getSelectedChart();
            Correlation correlation = o instanceof Correlation ? (Correlation)o : chart.getSelectedCorrelation();
            this.reInitCorrelationOccPanel(chart, correlation);
        } else if (o instanceof PanelTemplate && PanelType.isTaxonPanel(((PanelTemplate)o).getType()) || o instanceof ChartPanel && PanelType.isTaxonPanel(((ChartPanel)o).getPanelType()) || o instanceof PanelTaxonBase) {
            comp = this.jListPTG;
            this.reInitJListPTG(selection.panelTemplate, selection.chartPanel, selection.innerPanel);
            if (this.jListPTG.hasGroupDisplayViewportWithNoDimensions()) {
                repeat = true;
            }
        } else if (o instanceof SBLayer) {
            SBLayer layer = (SBLayer)o;
            comp = this.jPanelMap;
            this.reInitMapPanel(layer.getBlock(), selection.panelTemplate, selection.chartPanel);
        } else {
            comp = this.jScrollPaneTableProperties;
            this.reInitPropertiesScrollPane(selection);
        }
        this.jSplitPanePropertiesTable.setLeftComponent(comp);
        if (repeat) {
            this.jSplitPanePropertiesTable.setLeftComponent(comp);
        }
    }

    private SelectedObject getSelectedObject(Object o) {
        PanelTemplate pt = null;
        ChartPanel cp = null;
        PanelTaxonBase ip = null;
        BlockTemplate bt = null;
        ChartBlockBase cbb = null;
        CorrelationTemplate ct = null;
        CorrelationStandard cs = null;
        Correlation c = null;
        ChartTag t = null;
        if (o instanceof PanelTemplate) {
            pt = (PanelTemplate)o;
        } else if (o instanceof ChartPanel) {
            cp = (ChartPanel)o;
            pt = cp.getTemplate();
        } else if (o instanceof PanelTaxonBase) {
            ip = (PanelTaxonBase)o;
            cp = ip.getParent();
            pt = cp.getTemplate();
        } else if (o instanceof BlockTemplateInfo) {
            bt = this.chartManager.getBlockTemplateFromInfo((BlockTemplateInfo)o);
        } else if (o instanceof BlockTemplate) {
            bt = (BlockTemplate)o;
        } else if (o instanceof ChartBlockBase) {
            cbb = (ChartBlockBase)o;
            bt = cbb.getTemplate();
            if (bt.getParentID() != null) {
                try {
                    bt = this.chartManager.getBlockTemplate(bt.getParentID());
                }
                catch (SQLException sql) {
                    SbugsExceptionHandler.showStackError("Error loading parent block template", sql, this);
                }
            }
        } else if (o instanceof CorrelationTemplate) {
            ct = (CorrelationTemplate)o;
        } else if (o instanceof Correlation) {
            c = (Correlation)o;
        } else if (o instanceof Chart) {
            Chart chart = (Chart)o;
            if (chart.hasCorrelations() && (c = chart.getSelectedCorrelation()) == null) {
                c = chart.getCorrelations().get(0);
            }
        } else if (o instanceof ChartTag) {
            t = (ChartTag)((Object)o);
        }
        if (c != null) {
            if (c.getTemplateID() > 0) {
                try {
                    ct = this.chartManager.getCorrTemplate(c.getTemplateID());
                }
                catch (SQLException sql) {
                    SbugsExceptionHandler.showStackError("Error loading correlation template", sql, this);
                }
            } else {
                cs = ChartManager.getCorrStd(c.getCorrType(), c.getScope());
            }
        }
        return new SelectedObject(o, pt, cp, ip, bt, cbb, ct, cs, c, t);
    }

    private void reInitPropertiesScrollPane(SelectedObject selection) {
        this.jScrollPaneTableProperties.setBorder(this.jScrollPaneTablePropertiesBorder);
        if (selection.block == null && selection.blockTemplate != null) {
            this.reInitPanelList(selection.blockTemplate);
            this.jScrollPaneTableProperties.setViewportView(this.jListPanels);
            return;
        }
        if (this.jTableProperties.isEditing() && !this.jTableProperties.getCellEditor().stopCellEditing()) {
            this.jTableProperties.getCellEditor().cancelCellEditing();
        }
        if (selection.panelTemplate != null) {
            if (this.panelPropModel.setTemplate(selection.panelTemplate, selection.chartPanel)) {
                ((PropertiesTable)this.jTableProperties).fireTableDataChanged();
                ((PropertiesTable)this.jTableMap).fireTableDataChanged();
            }
            this.jTableProperties.setModel(this.panelPropModel);
        } else if (selection.block != null) {
            AbstractBlockPropertiesTableModel blockModel = switch (selection.block.getBlockType()) {
                case BlockType.MAP -> {
                    this.mapBlockPropModel.setBlock((MapBlock)selection.block);
                    yield this.mapBlockPropModel;
                }
                default -> {
                    this.blockPropModel.setBlock((ChartBlock)selection.block);
                    yield this.blockPropModel;
                }
            };
            blockModel.fireTableDataChanged();
            this.jTableProperties.setModel(blockModel);
        } else if (selection.tag != null) {
            if (this.tagPropModel.setTag(selection.tag)) {
                this.tagPropModel.fireTableDataChanged();
            }
            this.jTableProperties.setModel(this.tagPropModel);
        } else {
            this.nullModel.fireTableDataChanged();
            this.jTableProperties.setModel(this.nullModel);
            this.jScrollPaneTableProperties.setBorder(null);
        }
        this.jScrollPaneTableProperties.setViewportView(this.jTableProperties);
    }

    private void reInitPanelList(BlockTemplate bTemp) {
        this.panelListModel.clear();
        bTemp.getPanelIDs().forEach(i -> {
            try {
                this.panelListModel.addElement(bTemp.getPanelTemplate((int)i));
            }
            catch (UnknownPanelTypeException ex) {
                Logger.getLogger(FrameChart.class.getName()).log(Level.WARNING, "Unknown panel type exception while opening block template, template {0}, panel type {1}", new Object[]{bTemp.getName(), ex.getPanelTypeString()});
                JOptionPane.showMessageDialog(this, "The block " + bTemp.getName() + " contains an unkown panel type " + ex.getPanelTypeString() + " and can't be opened. \r\n\r\nThis problem usually occurrs when attempting to open a block with an older version of Stratabugs than the one used to create it. \r\nPlease try updating to the latest version of StrataBugs. If the problem persists please contact StrataBugs support.", "Problem opening block template", 2);
            }
            catch (SQLException | SBException e) {
                this.panelListModel.addElement(e);
            }
        });
    }

    private void reInitJListPTG(PanelTemplate panelTemplate, ChartPanel chartPanel, PanelTaxonBase innerPanel) {
        if (this.panelPropModel.setTemplate(panelTemplate, chartPanel)) {
            this.jListPTG.getTable().fireTableDataChanged();
            ((PropertiesTable)this.jTableMap).fireTableDataChanged();
        }
        this.jListPTG.setModelTemplate(this.panelPropModel, panelTemplate);
        if (innerPanel != null) {
            this.jListPTG.setSelectedValue(innerPanel.getPanelTaxonOcc());
        }
    }

    private void reInitCorrelationListPanel(CorrelationTemplate cTempl) {
        this.corrListModel.clear();
        cTempl.getLineList().forEach(l -> this.corrListModel.addElement(l));
        this.jButtonCorrAddDict.setIcon(cTempl.getType().getIconDict());
        this.jButtonCorrSave.setVisible(cTempl.isDirty());
        this.jButtonCorrRestore.setVisible(cTempl.isDirty());
    }

    private void reInitCorrelationOccPanel(Chart chart, Correlation correlation) {
        this.listModelCorrOcc.clear();
        chart.getCorrelations().forEach(c -> this.listModelCorrOcc.addElement(c));
        this.jListCorrOcc.setSelectedValue(correlation, true);
        if (this.jListCorrOcc.getSelectedValue() == null) {
            this.jListCorrOcc.setSelectedIndex(0);
        }
    }

    private void reInitMapPanel(MapBlock block, PanelTemplate template, ChartPanel layer) {
        this.listModelMap.clear();
        block.getLayers().forEach(l -> this.listModelMap.addElement(l));
        this.jListMap.setSelectedValue(block.getSelectedPanel().orElse(null), true);
        if (this.jListMap.getSelectedValue() == null && !this.listModelMap.isEmpty()) {
            this.jListMap.setSelectedIndex(0);
        }
        if (this.panelPropModel.setTemplate(template, layer)) {
            ((PropertiesTable)this.jTableMap).fireTableDataChanged();
        }
    }

    public void fireChartMightHaveChanged() {
        int index = this.jTabbedPaneChart.getSelectedIndex();
        LOGGER.log(Level.FINE, "Chart may have changed at tab index{0}", index);
        this.runOnSelectedScrollPaneChartTemplate(s -> s.chartMightHaveChanged());
    }

    public void selectedChartWellMightHaveChanged() {
        int index = this.jTabbedPaneChart.getSelectedIndex();
        LOGGER.log(Level.FINE, "Chart well may have changed at tab index {0}", index);
        this.runOnSelectedScrollPaneChartTemplate(s -> s.wellMightHaveChanged());
    }

    private void runOnSelectedScrollPaneChartTemplate(Consumer<JScrollPaneChartTemplate> action) {
        int index = this.jTabbedPaneChart.getSelectedIndex();
        LOGGER.log(Level.FINE, "Chart may have changed at tab index {0}", index);
        if (index >= 0) {
            JScrollPaneChartTemplate selected = (JScrollPaneChartTemplate)this.jTabbedPaneChart.getComponentAt(index);
            if (selected != null) {
                action.accept(selected);
            }
            this.jTabbedPaneChart.updateTitleAt(index);
        }
    }

    void fireChartComponentAdded(Object added) {
        int index = this.jTabbedPaneChart.getSelectedIndex();
        if (index >= 0) {
            Set chartWells;
            Set wellListWells;
            int chartDefaultWellListID;
            WellBlock wBlock;
            JScrollPaneChartTemplate selected = (JScrollPaneChartTemplate)this.jTabbedPaneChart.getComponentAt(index);
            if (selected != null) {
                selected.chartComponentAdded(added);
            }
            this.jTabbedPaneChart.updateTitleAt(index);
            if (added instanceof WellBlock && (wBlock = (WellBlock)added).getWell() != null && (chartDefaultWellListID = selected.getChart().getTemplate().getWellListID()) > 0 && (wellListWells = this.sbdb.getWellService().getWellStream(chartDefaultWellListID).map(Well::getWellID).collect(Collectors.toSet())).equals(chartWells = selected.getChart().getBlocks().stream().filter(block -> block instanceof WellBlock && block.getWell() != null && block != added).map(block -> block.getWell().getWellID()).collect(Collectors.toSet()))) {
                WellList wellList = (WellList)this.sbdb.getWellListService().getWellList(chartDefaultWellListID);
                int opt = JOptionPane.showConfirmDialog(this, "Do you want to add '" + wBlock.getWell().getWellName() + "' to well list '" + wellList.getName() + "'?", "Add Well Block", 0, 3);
                if (opt == 0) {
                    try {
                        this.sbdb.addWellsToWellList(List.of(wBlock.getWell()), chartDefaultWellListID);
                        this.sbdb.commit();
                    }
                    catch (SQLException | SBPermissionException e) {
                        SbugsExceptionHandler.showStackError("Error adding well to well list", e);
                    }
                }
            }
            try {
                if (added instanceof SBPanel && !this.chartManager.getPanelTemplate(((SBPanel)added).getTemplateID()).isVisible()) {
                    HintSequence.showTimedBalloon(this.jTextPanePanelDetails, "New panel is decoupled.", BalloonTip.Orientation.RIGHT_ABOVE, BalloonTip.AttachLocation.NORTH);
                }
            }
            catch (SQLException | SBException e) {
                SbugsExceptionHandler.showStackError(e, this);
            }
        }
    }

    public void fireChartSelectionChange(Object selection) {
        JScrollPaneChartTemplate scrollPane = (JScrollPaneChartTemplate)this.jTabbedPaneChart.getSelectedComponent();
        if (scrollPane != null) {
            // empty if block
        }
    }

    private boolean checkCanWrite(SBRestrictable template, boolean showMessage) {
        try {
            if (!template.canWrite(this.sbdb, null)) {
                if (showMessage) {
                    JOptionPane.showMessageDialog(this, template.getDeniedReason(this.sbdb, "template", false), this.getTitle(), 2);
                }
                return false;
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
            return false;
        }
        return true;
    }

    private void addCorrFromDict() {
        Object o = this.jTreePanels.getLastSelectedPathComponent();
        if (!(o instanceof CorrelationTemplate)) {
            return;
        }
        CorrelationTemplate template = (CorrelationTemplate)o;
        if (!this.checkCanWrite(template, true)) {
            return;
        }
        CorrelationLine line = null;
        try {
            switch (template.getType()) {
                case EVENT: {
                    line = this.getEventLine(null);
                    break;
                }
                case SURFACE: {
                    List<IGDScheme> sList = this.sbdb.getIGDSchemes(DataType.SEQUENCE);
                    Collections.sort(sList);
                    DialogList<IGDScheme> schListDialog = new DialogList<IGDScheme>(this, true, "Select Sequence Scheme", null, sList, true, false);
                    schListDialog.setLocationRelativeTo(this);
                    schListDialog.setVisible(true);
                    if (schListDialog.getSelection() != null) {
                        line = this.getSurfaceLine(schListDialog.getSelection());
                    }
                    break;
                }
                case CHRONO: 
                case LITHO: 
                case BIOZONE: {
                    List<IGDScheme> list = this.sbdb.getIGDSchemes(template.getType().getDataType());
                    Collections.sort(list);
                    DialogList<IGDScheme> schemeListDialog = new DialogList<IGDScheme>(this, true, "Select Scheme", null, list, true, false);
                    schemeListDialog.setLocationRelativeTo(this);
                    schemeListDialog.setVisible(true);
                    if (schemeListDialog.getSelection() != null) {
                        DialogSelectUnit unitDialog = new DialogSelectUnit(this, true, schemeListDialog.getSelection(), null);
                        unitDialog.setLocationRelativeTo(this);
                        unitDialog.setVisible(true);
                        if (unitDialog.selection != null) {
                            DialogCorrelationLine d3 = new DialogCorrelationLine(this, template.getType(), unitDialog.selection, null, true);
                            d3.setLocationRelativeTo(this);
                            d3.setVisible(true);
                            if (d3.isOK()) {
                                line = new IGDUnitLine(template.getType(), unitDialog.selection, (IGDIntervalZone.BoundaryType)((Object)d3.getSelectedType()), d3.getStyle(), null);
                            }
                        }
                    }
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
        catch (SBException sbe) {
            StackError.showStackError((String)"Error", (Throwable)sbe);
        }
        if (line != null && template.addCorrelationLine(line)) {
            this.treeModel.fireTreeNodeChanged(o);
            this.reInitTab(template);
        }
    }

    private void addCorrFromWells() {
        Object o = this.jTreePanels.getLastSelectedPathComponent();
        if (!(o instanceof CorrelationTemplate)) {
            return;
        }
        CorrelationTemplate template = (CorrelationTemplate)o;
        if (!this.checkCanWrite(template, true)) {
            return;
        }
        HashSet<Integer> appliedInterpIDs = new HashSet<Integer>();
        for (Correlation c : this.getSelectedChart().getCorrelations()) {
            if (c.getTemplateID() != template.getID()) continue;
            appliedInterpIDs.add(c.getInterpID());
            break;
        }
        if (appliedInterpIDs.isEmpty()) {
            appliedInterpIDs = null;
        }
        LinkedList<CorrelationLine> lines = new LinkedList<CorrelationLine>();
        try {
            switch (template.getType()) {
                case EVENT: {
                    HashSet<DialogSelectCorrelationLines.CorrelativeObject> evSet = new HashSet<DialogSelectCorrelationLines.CorrelativeObject>();
                    for (ChartBlockBase block : this.getSelectedChart().getBlocks()) {
                        if (!(block instanceof WellBlock)) continue;
                        block.getWell().loadInterps();
                        Iterator<WellInterp> it = block.getWell().getInterpIterator();
                        while (it.hasNext()) {
                            WellInterp interp = it.next();
                            if (appliedInterpIDs != null && !appliedInterpIDs.contains(interp.getHeader().getInterpID())) continue;
                            for (WellEvent event : interp.getEvents()) {
                                if (template.containsLine(event.getEvent(), event.getTypeObj())) continue;
                                evSet.add(new DialogSelectCorrelationLines.CorrelativeObject(event.getEvent(), (Enum)event.getTypeObj()));
                            }
                        }
                    }
                    if (evSet.isEmpty()) {
                        JOptionPane.showMessageDialog(this, "Chart data has no events to add", this.getTitle(), 2);
                        return;
                    }
                    lines.addAll(this.getCorrelationLines(evSet, CorrelationType.EVENT));
                    break;
                }
                case SURFACE: 
                case CHRONO: 
                case LITHO: 
                case BIOZONE: {
                    HashSet<IGDScheme> schemes = new HashSet<IGDScheme>();
                    ArrayList<WellInterp> interps = new ArrayList<WellInterp>();
                    for (ChartBlockBase block : this.getSelectedChart().getBlocks()) {
                        if (!(block instanceof WellBlock) || block.getWell() == null) continue;
                        block.getWell().loadInterps();
                        Iterator<WellInterp> it = block.getWell().getInterpIterator();
                        while (it.hasNext()) {
                            WellInterp interp = it.next();
                            if (appliedInterpIDs != null && !appliedInterpIDs.contains(interp.getHeader().getInterpID())) continue;
                            block.getWell().loadInterp(interp);
                            schemes.addAll(interp.getIGDSchemes(DataType.getIGDType(template.getType().getDataType())));
                            interps.add(interp);
                        }
                    }
                    IGDScheme scheme = null;
                    if (schemes.size() == 1) {
                        scheme = (IGDScheme)schemes.toArray()[0];
                    } else {
                        LinkedList sortedSchemes = new LinkedList(schemes);
                        Collections.sort(sortedSchemes);
                        DialogList schListDialog = new DialogList(this, true, "Select Scheme", null, sortedSchemes, true, false);
                        schListDialog.setLocationRelativeTo(this);
                        schListDialog.setVisible(true);
                        if (schListDialog.getSelection() != null) {
                            scheme = (IGDScheme)schListDialog.getSelection();
                        }
                    }
                    if (scheme != null) {
                        HashSet<DialogSelectCorrelationLines.CorrelativeObject> set = new HashSet<DialogSelectCorrelationLines.CorrelativeObject>();
                        block16: for (WellInterp i : interps) {
                            switch (template.getType()) {
                                case SURFACE: {
                                    for (SQPick pick : i.getSQPicks(scheme.getID())) {
                                        if (template.containsLine(pick.getSurface(), null)) continue;
                                        set.add(new DialogSelectCorrelationLines.CorrelativeObject(pick.getSurface(), null));
                                    }
                                    continue block16;
                                }
                                case CHRONO: 
                                case LITHO: 
                                case BIOZONE: {
                                    int igdType = DataType.getIGDType(template.getType().getDataType());
                                    for (IGDIntervalZone zone : i.getIGDList(igdType, scheme.getID())) {
                                        if (zone.getUppZone() > 0) {
                                            IGDUnitBase uppZone = scheme.findUnitBase(zone.getUppZone());
                                            if (!template.containsLine(uppZone, (Object)IGDIntervalZone.BoundaryType.TOP)) {
                                                set.add(new DialogSelectCorrelationLines.CorrelativeObject(uppZone, IGDIntervalZone.BoundaryType.TOP));
                                            }
                                            if (!template.containsLine(uppZone, (Object)IGDIntervalZone.BoundaryType.BASE)) {
                                                set.add(new DialogSelectCorrelationLines.CorrelativeObject(uppZone, IGDIntervalZone.BoundaryType.BASE));
                                            }
                                        }
                                        if (zone.getLowZone() <= 0) continue;
                                        IGDUnitBase lowZone = scheme.findUnitBase(zone.getLowZone());
                                        if (!template.containsLine(lowZone, (Object)IGDIntervalZone.BoundaryType.TOP)) {
                                            set.add(new DialogSelectCorrelationLines.CorrelativeObject(lowZone, IGDIntervalZone.BoundaryType.TOP));
                                        }
                                        if (template.containsLine(lowZone, (Object)IGDIntervalZone.BoundaryType.BASE)) continue;
                                        set.add(new DialogSelectCorrelationLines.CorrelativeObject(lowZone, IGDIntervalZone.BoundaryType.BASE));
                                    }
                                    continue block16;
                                }
                                default: {
                                    assert (false);
                                    continue block16;
                                }
                            }
                        }
                        lines.addAll(this.getCorrelationLines(set, template.getType()));
                        Collections.sort(lines);
                    }
                    break;
                }
                default: {
                    JOptionPane.showMessageDialog(this, "Not implemented", this.getTitle(), 2);
                    break;
                }
            }
        }
        catch (SQLException | SBException ex) {
            SbugsExceptionHandler.showStackError(ex);
        }
        if (!lines.isEmpty() && template.addCorrelationLines(lines)) {
            this.reInitTab(template);
            this.treeModel.fireTreeNodeChanged(template);
        }
    }

    private List<CorrelationLine> getCorrelationLines(Set<DialogSelectCorrelationLines.CorrelativeObject> set, CorrelationType corrType) {
        LinkedList<CorrelationLine> lines = new LinkedList<CorrelationLine>();
        DialogSelectCorrelationLines dialogSelect = new DialogSelectCorrelationLines(this, true, set);
        dialogSelect.setLocationRelativeTo(this);
        dialogSelect.setVisible(true);
        if (dialogSelect.isOK()) {
            List<DialogSelectCorrelationLines.CorrelativeObject> selection = dialogSelect.getSelection();
            CorrLineStyle style = null;
            if (selection.size() == 1) {
                DialogCorrelationLine d2 = new DialogCorrelationLine(this, corrType, selection.get((int)0).o, null, false);
                d2.setLocationRelativeTo(this);
                d2.setVisible(true);
                if (d2.isOK()) {
                    style = d2.getStyle();
                } else {
                    return lines;
                }
            }
            block5: for (DialogSelectCorrelationLines.CorrelativeObject co : selection) {
                switch (corrType) {
                    case SURFACE: {
                        lines.add(new SurfaceLine((Surface)co.o, style, null));
                        continue block5;
                    }
                    case EVENT: {
                        lines.add(new EventLine((SBEvent)co.o, (EventType)co.type, style, null));
                        continue block5;
                    }
                    case CHRONO: 
                    case LITHO: 
                    case BIOZONE: {
                        lines.add(new IGDUnitLine(corrType, (IGDUnitBase)co.o, (IGDIntervalZone.BoundaryType)co.type, style, null));
                        continue block5;
                    }
                }
                assert (false);
            }
        }
        return lines;
    }

    private EventLine getEventLine(List<SBEvent> fromThisList) throws SQLException, SBException {
        DialogSelectEvent dialog = new DialogSelectEvent((Frame)this, true, this.sbdb, fromThisList);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.selection != null) {
            DialogCorrelationLine d2 = new DialogCorrelationLine(this, CorrelationType.EVENT, dialog.selection, null, true);
            d2.setLocationRelativeTo(this);
            d2.setVisible(true);
            if (d2.isOK()) {
                return new EventLine(dialog.selection, (EventType)d2.getSelectedType(), d2.getStyle(), null);
            }
        }
        return null;
    }

    private SurfaceLine getSurfaceLine(IGDScheme scheme) throws SQLException, SBException {
        assert (scheme.getIGDType() == 10);
        TableModelSurfaces model = new TableModelSurfaces(scheme);
        DialogTable surfaceDialog = new DialogTable(this, true, (AbstractTableModel)model, "Select Surface", true);
        model.setupTable(surfaceDialog.getTable());
        surfaceDialog.setLocationRelativeTo(this);
        surfaceDialog.setVisible(true);
        if (surfaceDialog.isOK()) {
            Surface surface = model.scheme.getSurfaces().get(surfaceDialog.getSelectedRow());
            DialogCorrelationLine d2 = new DialogCorrelationLine(this, CorrelationType.SURFACE, surface, null, true);
            d2.setLocationRelativeTo(this);
            d2.setVisible(true);
            if (d2.isOK()) {
                return new SurfaceLine(surface, d2.getStyle(), null);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteCorrLine() {
        if (this.jListCorrLines.getSelectedValue() == null) {
            return;
        }
        Object o = this.jTreePanels.getLastSelectedPathComponent();
        if (!(o instanceof CorrelationTemplate)) {
            return;
        }
        CorrelationTemplate template = (CorrelationTemplate)o;
        if (!this.checkCanWrite(template, true)) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        boolean fireChange = false;
        try {
            for (Object obj : this.jListCorrLines.getSelectedValuesList()) {
                CorrelationLine line = (CorrelationLine)obj;
                if (!template.deleteCorrelationLine(line)) continue;
                fireChange = true;
            }
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
            if (fireChange) {
                this.treeModel.fireTreeNodeChanged(o);
                this.reInitTab(template);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveCorrLines() {
        Object o = this.jTreePanels.getLastSelectedPathComponent();
        if (!(o instanceof CorrelationTemplate)) {
            return;
        }
        CorrelationTemplate template = (CorrelationTemplate)o;
        if (!template.isDirty()) {
            return;
        }
        if (template.hasBeenRefreshed()) {
            int opt = this.getOverwriteOption();
            if (opt == 2) {
                return;
            }
            if (opt == 1) {
                template.restoreSavedProperties();
                this.treeModel.fireTreeNodeChanged(o);
                this.reInitTab(template);
                return;
            }
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            template.storeLines(this.sbdb);
            this.sbdb.commit();
        }
        catch (SQLException | SBPermissionException sql) {
            SbugsExceptionHandler.showStackError(sql);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
        this.jButtonCorrSave.setVisible(template.isDirty());
        this.jButtonCorrRestore.setVisible(template.isDirty());
        this.treeModel.fireTreeNodeChanged(o);
    }

    private void restoreCorrTemplate() {
        Object o = this.jTreePanels.getLastSelectedPathComponent();
        if (!(o instanceof CorrelationTemplate)) {
            return;
        }
        CorrelationTemplate template = (CorrelationTemplate)o;
        if (!template.isDirty()) {
            return;
        }
        template.restoreSavedProperties();
        this.treeModel.fireTreeNodeChanged(o);
        this.reInitTab(template);
    }

    private void initMapPanel() {
        this.jPanelMap.setLayout(new BoxLayout(this.jPanelMap, 3));
        JLabel label = new JLabel("Map layers:");
        label.setAlignmentX(0.0f);
        JScrollPane jspList = new JScrollPane(this.jListMap);
        jspList.setMinimumSize(new Dimension(100, 100));
        this.jSplitPaneMap.setLeftComponent(jspList);
        this.jTableMap.setModel(this.panelPropModel);
        JScrollPane jspTable = new JScrollPane(this.jTableMap);
        this.jSplitPaneMap.setRightComponent(jspTable);
        this.jSplitPaneMap.setBorder(null);
        this.jPanelMap.add(Box.createVerticalStrut(4));
        this.jPanelMap.add(label);
        this.jPanelMap.add(Box.createVerticalStrut(6));
        this.jPanelMap.add(this.jSplitPaneMap);
        this.jPanelMap.setPreferredSize(new Dimension(452, 150));
        this.jListMap.setCellRenderer(new ChartListLabel(this.sbdb));
        this.jListMap.addListSelectionListener(new ListSelectionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                SBLayer layer = (SBLayer)this.this$0.jListMap.getSelectedValue();
                if (layer == null) {
                    return;
                }
                this.this$0.panelPropModel.setTemplate(layer.getTemplate(), layer);
                ((PropertiesTable)this.this$0.jTableMap).fireTableDataChanged();
                ((JScrollPaneChartTemplate)this.this$0.jTabbedPaneChart.getSelectedComponent()).getActiveBlock().setSelectedPanel(layer);
                TreePath path = this.this$0.treeModel.getPath(layer.getTemplate());
                this.this$0.jTreePanels.setSelectionPath(path);
                this.this$0.reInitDetailsPane();
            }
        });
        this.jListMap.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                this.doMapLayerPopup(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                this.doMapLayerPopup(evt);
            }

            private void doMapLayerPopup(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    this.this$0.jListMap.setSelectedIndex(this.this$0.jListMap.locationToIndex(evt.getPoint()));
                    if (this.this$0.jListMap.getSelectedIndex() >= 0) {
                        this.this$0.jPopupMenuMapLayers.show(this.this$0.jListMap, evt.getX(), evt.getY());
                    }
                }
            }
        });
    }

    private void initCorrOccPanel() {
        this.jTableCorrOcc = new PropertiesTable();
        this.tableModelCorrOcc = new CorrelationPropertiesTableModel(this, this.sbdb);
        this.jTableCorrOcc.setModel(this.tableModelCorrOcc);
        this.jPanelCorrOcc.setLayout(new BoxLayout(this.jPanelCorrOcc, 3));
        JScrollPane jsp1 = new JScrollPane(this.jListCorrOcc);
        jsp1.setAlignmentX(0.0f);
        this.jsp2 = new JScrollPane(this.jTableCorrOcc);
        this.jsp2.setAlignmentX(0.0f);
        JLabel label = new JLabel("Applied correlation templates:");
        label.setAlignmentX(0.0f);
        this.jPanelCorrOcc.add(Box.createVerticalStrut(4));
        this.jPanelCorrOcc.add(label);
        this.jPanelCorrOcc.add(Box.createVerticalStrut(6));
        this.jPanelCorrOcc.add(jsp1);
        this.jPanelCorrOcc.add(Box.createVerticalStrut(6));
        this.jPanelCorrOcc.add(this.jsp2);
        this.jPanelCorrOcc.setPreferredSize(new Dimension(452, 150));
        this.jListCorrOcc.addListSelectionListener(new ListSelectionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                Correlation correlation = (Correlation)this.this$0.jListCorrOcc.getSelectedValue();
                this.this$0.tableModelCorrOcc.setCorrelation(correlation);
                this.this$0.tableModelCorrOcc.fireTableDataChanged();
                ((JScrollPaneChartTemplate)this.this$0.jTabbedPaneChart.getSelectedComponent()).setCorrelation(correlation);
                if (correlation == null) {
                    return;
                }
                try {
                    TreePath path = correlation.getTemplateID() > 0 ? this.this$0.treeModel.getPath(this.this$0.chartManager.getCorrTemplate(correlation.getTemplateID())) : this.this$0.treeModel.getPath(ChartManager.getCorrStd(correlation.getCorrType(), correlation.getScope()));
                    this.this$0.reInitDetailsPane();
                    this.this$0.jTreePanels.setSelectionPath(path);
                    int height = this.this$0.jTableCorrOcc.getPreferredSize().height + 2;
                    this.this$0.jsp2.setMaximumSize(new Dimension(Integer.MAX_VALUE, height));
                    this.this$0.jsp2.setPreferredSize(new Dimension(this.this$0.jsp2.getPreferredSize().width, height));
                    this.this$0.jsp2.setMinimumSize(new Dimension(this.this$0.jsp2.getMinimumSize().width, height));
                }
                catch (SQLException sql) {
                    sql.printStackTrace();
                }
            }
        });
        this.jListCorrOcc.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                this.doCorrPopup(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                this.doCorrPopup(evt);
            }

            private void doCorrPopup(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    this.this$0.jListCorrOcc.setSelectedIndex(this.this$0.jListCorrOcc.locationToIndex(evt.getPoint()));
                    if (this.this$0.jListCorrOcc.getSelectedIndex() >= 0) {
                        Correlation c = (Correlation)this.this$0.jListCorrOcc.getSelectedValue();
                        this.this$0.jMenuItemCorrOccCreateTemplate.setVisible(c.getTemplateID() == 0);
                        this.this$0.jMenuItemCorrOccCreateTxGroup.setVisible(c.getCorrType() == CorrelationType.EVENT);
                        this.this$0.jPopupMenuCorrOcc.show(this.this$0.jListCorrOcc, evt.getX(), evt.getY());
                    }
                }
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() > 1) {
                    this.this$0.editCorrelation();
                }
            }
        });
        this.jListCorrOcc.setCellRenderer(new ChartListLabel(this.sbdb));
    }

    private void initComponents() {
        this.jPopupMenuPanels = new JPopupMenu();
        this.jMenuItemPanelRestore = new JMenuItem();
        this.jSeparatorPanelRestore = new JPopupMenu.Separator();
        this.jMenuItemAddPanelTemplate = new JMenuItem();
        this.jMenuItemEditPanelTemplate = new JMenuItem();
        this.jMenuItemPanelTemplatePermissions = new JMenuItem();
        this.jMenuItemPanelTemplateDefault = new JMenuItem();
        this.jMenuItemDeletePanelTemplate = new JMenuItem();
        this.jSeparatorPanelSearch = new JPopupMenu.Separator();
        this.jMenuItemPanelUsages = new JMenuItem();
        this.jMenuItemPanelSimilar = new JMenuItem();
        this.jMenuItemExportPanel = new JMenuItem();
        this.jSeparatorPanelHelp = new JPopupMenu.Separator();
        this.jMenuItemPanelHelp = new JMenuItem();
        this.jPopupMenuBlockCorr = new JPopupMenu();
        this.jPopupMenuItemAddBlockCorrTemplate = new JMenuItem();
        this.jPopupMenuItemEditBlockCorrTemplate = new JMenuItem();
        this.jPopupMenuItemDeleteBlockCorrTemplate = new JMenuItem();
        this.jMenuItemTemplatePermissions = new JMenuItem();
        this.jPopupMenuItemTemplateOverrides = new JMenuItem();
        this.jPopupMenuItemBlockCorrAddTxGroup = new JMenuItem();
        this.jSeparator11 = new JPopupMenu.Separator();
        this.jPopupMenuItemBlockCorrUsages = new JMenuItem();
        this.jPopupMenuItemBlockTemplateTabs = new JMenuItem();
        this.jPopupMenuCorrOcc = new JPopupMenu();
        this.jMenuItemCorrOccEdit = new JMenuItem();
        this.jMenuItemCorrOccRemove = new JMenuItem();
        this.jMenuItemCorrOccCreateTemplate = new JMenuItem();
        this.jMenuItemCorrOccCreateTxGroup = new JMenuItem();
        this.jPopupMenuCorrLine = new JPopupMenu();
        this.jPopupMenuItemCorrLineEdit = new JMenuItem();
        this.buttonGroupSort = new ButtonGroup();
        this.jPopupMenuChartTab = new JPopupMenu();
        this.jMenuItemChartTabPopupNewTag = new JMenuItem();
        this.jMenuItemChartTabPopupBringTagToFront = new JMenuItem();
        this.jMenuItemChartTabPopupSendTagToBack = new JMenuItem();
        this.jSeparator9 = new JPopupMenu.Separator();
        this.jMenuItemChartTabPopupEditBlock = new JMenuItem();
        this.jMenuItemChartTabPopupSelectBlockTemplate = new JMenuItem();
        this.jSeparatorChartTabPopup1 = new JPopupMenu.Separator();
        this.jMenuItemChartTabPopupPanelProperties = new JMenuItem();
        this.jMenuItemChartTabPopupOverrideToTemplate = new JMenuItem();
        this.jMenuItemChartTabPopupDiscardOverrides = new JMenuItem();
        this.jSeparatorChartTabPopup2 = new JPopupMenu.Separator();
        this.jMenuItemChartTabPopupPanelDepthSnap = new JMenuItem();
        this.jMenuItemChartTabPopupBlockDefaultDepths = new JMenuItem();
        this.jSeparatorChartTabPopup3 = new JPopupMenu.Separator();
        this.jMenuItemChartTabPopupBlockDepth = new JMenuItem();
        this.jMenuItemChartTabPopupReorganiseWellBlocks = new JMenuItem();
        this.jPopupMenuBlockTab = new JPopupMenu();
        this.jMenuItemBlockTabSelectPanelTemplate = new JMenuItem();
        this.jMenuItemBlockTabDecouple = new JMenuItem();
        this.jMenuBlockTabRecouple = new JMenu();
        this.jMenuItemBlockTabRecoupleToExisting = new JMenuItem();
        this.jMenuItemBlockTabRecoupleSuggest = new JMenuItem();
        this.jMenuItemBlockTabRecoupleToNew = new JMenuItem();
        this.jDialogCheckUpdatePanel = new JDialog();
        this.jLabelCheckUpdatePanel = new JLabel();
        this.jCheckBoxCheckUpdatePanel = new JCheckBox();
        this.jButtonCheckUpdatePanelNo = new JButton();
        this.jButtonCheckUpdatePanelYes = new JButton();
        this.buttonGroupMenuOutline = new ButtonGroup();
        this.jPopupMenuMapLayers = new JPopupMenu();
        this.jMenuItemRemoveLayer = new JMenuItem();
        this.jMenuItemLayerUp = new JMenuItem();
        this.jMenuItemLayerDown = new JMenuItem();
        this.jToolBarMain = new JToolBar();
        this.jButtonOpen = new JButton();
        this.jButtonSaveChart = new JButton();
        this.jButtonExportChart = new JButton();
        this.jButtonExportChartBitmap = new JButton();
        this.jButtonPrintChart = new JButton();
        this.jSeparator5 = new JToolBar.Separator();
        this.jButtonZoomIn = new JButton();
        this.jButtonZoomOut = new JButton();
        this.jToggleButtonXHairs = new JToggleButton();
        this.jToggleButtonMagnifier = new JToggleButton();
        this.jSeparatorElements = new JToolBar.Separator();
        this.jButtonChartProperties = new JButton();
        this.jButtonLeft = new JButton();
        this.jButtonRight = new JButton();
        this.jButtonRemove = new JButton();
        this.jSplitPaneMain = new JSplitPane();
        this.jSplitPanePalette = new JSplitPane();
        this.jPanelProperties = new JPanel();
        this.jSplitPanePropertiesTable = new JSplitPane();
        this.jScrollPaneTableProperties = new JScrollPane();
        this.jTableProperties = new PropertiesTable();
        this.jScrollPanePanelDetails = new JScrollPane();
        this.jTextPanePanelDetails = new JTextPane();
        this.jPanelTree = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTreePanels = new JTree(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            protected void setExpandedState(TreePath path, boolean state) {
                TreeModelChart model;
                if (!state && !(model = (TreeModelChart)this.getModel()).allowCollapse(path)) {
                    return;
                }
                super.setExpandedState(path, state);
            }

            @Override
            public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (this.getModel() instanceof TreeModelChart) {
                    return ((TreeModelChart)this.getModel()).convertValueToText(value);
                }
                return value.toString();
            }
        };
        this.jPanelProject = new JPanel();
        this.jLabelProject = new JLabel();
        this.jMenuBar1 = new JMenuBar();
        this.jMenuFile = new JMenu();
        this.jMenuItemChartOpen = new JMenuItem();
        this.jMenuItemOpenProject = new JMenuItem();
        this.jSeparator4 = new JPopupMenu.Separator();
        this.jMenuChartBlockNew = new JMenu();
        this.jMenuItemBlockNewWell = new JMenuItem();
        this.jMenuItemBlockNewProject = new JMenuItem();
        this.jMenuItemBlockNewScheme = new JMenuItem();
        this.jMenuItemBlockNewMap = new JMenuItem();
        this.jMenuItemTemplateNew = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.jMenuItemPanelManager = new JMenuItem();
        this.jMenuItemShapeStores = new JMenuItem();
        this.jSeparator7 = new JPopupMenu.Separator();
        this.jMenuItemOpenLegacy = new JMenuItem();
        this.jSeparator6 = new JPopupMenu.Separator();
        this.jMenuItemExit = new JMenuItem();
        this.jMenuChart = new JMenu();
        this.jMenuItemChartSave = new JMenuItem();
        this.jMenuItemSaveAs = new JMenuItem();
        this.jMenuItemChartRestore = new JMenuItem();
        this.jSeparator10 = new JPopupMenu.Separator();
        this.jMenuItemChartEdit = new JMenuItem();
        this.jMenuItemChartPermissions = new JMenuItem();
        this.jMenuItemOverrides = new JMenuItem();
        this.jMenuItemChartDelete = new JMenuItem();
        this.jMenuItemBlockList = new JMenuItem();
        this.jMenuItemTagList = new JMenuItem();
        this.jSeparator8 = new JPopupMenu.Separator();
        this.jMenuItemBlockUsage = new JMenuItem();
        this.jMenuItemTabUsage = new JMenuItem();
        this.jSeparator2 = new JPopupMenu.Separator();
        this.jMenuItemChartPrint = new JMenuItem();
        this.jMenuChartExport = new JMenu();
        this.jMenuItemChartExportVector = new JMenuItem();
        this.jMenuItemChartExportBitmap = new JMenuItem();
        this.jSeparator3 = new JPopupMenu.Separator();
        this.jMenuItemChartExportHelp = new JMenuItem();
        this.jMenuItemChartExportFile = new JMenuItem();
        this.jMenuItemChartExportKML = new JMenuItem();
        this.jMenuItemExportToShapefile = new JMenuItem();
        this.jMenuView = new JMenu();
        this.jMenuItemCloseAllTabs = new JMenuItem();
        this.jMenuSort = new JMenu();
        this.jRadioButtonMenuItemAlpha = new JRadioButtonMenuItem();
        this.jRadioButtonMenuItemMod = new JRadioButtonMenuItem();
        this.jCheckBoxMenuItemViewGlobal = new JCheckBoxMenuItem();
        this.jMenu1 = new JMenu();
        this.jRadioButtonMenuItemNoOutline = new JRadioButtonMenuItem();
        this.jRadioButtonMenuItemShowA4 = new JRadioButtonMenuItem();
        this.jRadioButtonMenuItemShowA5 = new JRadioButtonMenuItem();
        this.jRadioButtonMenuItemCustomOutline = new JRadioButtonMenuItem();
        this.jMenuHelp = new JMenu();
        this.jMenuItemHelp = new JMenuItem();
        this.jMenuItemPanelRestore.setText("Restore saved properties");
        this.jMenuItemPanelRestore.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemPanelRestoreActionPerformed(evt);
            }
        });
        this.jPopupMenuPanels.add(this.jMenuItemPanelRestore);
        this.jPopupMenuPanels.add(this.jSeparatorPanelRestore);
        this.jMenuItemAddPanelTemplate.setText("New...");
        this.jMenuItemAddPanelTemplate.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemAddPanelTemplateActionPerformed(evt);
            }
        });
        this.jPopupMenuPanels.add(this.jMenuItemAddPanelTemplate);
        this.jMenuItemEditPanelTemplate.setText("Edit details...");
        this.jMenuItemEditPanelTemplate.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemEditPanelTemplateActionPerformed(evt);
            }
        });
        this.jPopupMenuPanels.add(this.jMenuItemEditPanelTemplate);
        this.jMenuItemPanelTemplatePermissions.setText("Permissions...");
        this.jMenuItemPanelTemplatePermissions.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemPanelTemplatePermissionsActionPerformed(evt);
            }
        });
        this.jPopupMenuPanels.add(this.jMenuItemPanelTemplatePermissions);
        this.jMenuItemPanelTemplateDefault.setText("Set as default template");
        this.jMenuItemPanelTemplateDefault.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemPanelTemplateDefaultActionPerformed(evt);
            }
        });
        this.jPopupMenuPanels.add(this.jMenuItemPanelTemplateDefault);
        this.jMenuItemDeletePanelTemplate.setText("Delete");
        this.jMenuItemDeletePanelTemplate.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemDeletePanelTemplateActionPerformed(evt);
            }
        });
        this.jPopupMenuPanels.add(this.jMenuItemDeletePanelTemplate);
        this.jPopupMenuPanels.add(this.jSeparatorPanelSearch);
        this.jMenuItemPanelUsages.setText("Find usages...");
        this.jMenuItemPanelUsages.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemPanelUsagesActionPerformed(evt);
            }
        });
        this.jPopupMenuPanels.add(this.jMenuItemPanelUsages);
        this.jMenuItemPanelSimilar.setText("Find similar...");
        this.jMenuItemPanelSimilar.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemPanelSimilarActionPerformed(evt);
            }
        });
        this.jPopupMenuPanels.add(this.jMenuItemPanelSimilar);
        this.jMenuItemExportPanel.setText("Export...");
        this.jMenuItemExportPanel.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemExportPanelActionPerformed(evt);
            }
        });
        this.jPopupMenuPanels.add(this.jMenuItemExportPanel);
        this.jPopupMenuPanels.add(this.jSeparatorPanelHelp);
        this.jMenuItemPanelHelp.setText("Help...");
        this.jMenuItemPanelHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemPanelHelpActionPerformed(evt);
            }
        });
        this.jPopupMenuPanels.add(this.jMenuItemPanelHelp);
        this.jPopupMenuItemAddBlockCorrTemplate.setText("jMenuItem1");
        this.jPopupMenuItemAddBlockCorrTemplate.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jPopupMenuItemAddBlockCorrTemplateActionPerformed(evt);
            }
        });
        this.jPopupMenuBlockCorr.add(this.jPopupMenuItemAddBlockCorrTemplate);
        this.jPopupMenuItemEditBlockCorrTemplate.setText("jMenuItem1");
        this.jPopupMenuItemEditBlockCorrTemplate.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jPopupMenuItemEditBlockCorrTemplateActionPerformed(evt);
            }
        });
        this.jPopupMenuBlockCorr.add(this.jPopupMenuItemEditBlockCorrTemplate);
        this.jPopupMenuItemDeleteBlockCorrTemplate.setText("jMenuItem1");
        this.jPopupMenuItemDeleteBlockCorrTemplate.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jPopupMenuItemDeleteBlockCorrTemplateActionPerformed(evt);
            }
        });
        this.jPopupMenuBlockCorr.add(this.jPopupMenuItemDeleteBlockCorrTemplate);
        this.jMenuItemTemplatePermissions.setText("Permissions...");
        this.jMenuItemTemplatePermissions.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemTemplatePermissionsActionPerformed(evt);
            }
        });
        this.jPopupMenuBlockCorr.add(this.jMenuItemTemplatePermissions);
        this.jPopupMenuItemTemplateOverrides.setText("Overrides...");
        this.jPopupMenuItemTemplateOverrides.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jPopupMenuItemTemplateOverridesActionPerformed(evt);
            }
        });
        this.jPopupMenuBlockCorr.add(this.jPopupMenuItemTemplateOverrides);
        this.jPopupMenuItemBlockCorrAddTxGroup.setText("Add to taxon group...");
        this.jPopupMenuItemBlockCorrAddTxGroup.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jPopupMenuItemBlockCorrAddTxGroupActionPerformed(evt);
            }
        });
        this.jPopupMenuBlockCorr.add(this.jPopupMenuItemBlockCorrAddTxGroup);
        this.jPopupMenuBlockCorr.add(this.jSeparator11);
        this.jPopupMenuItemBlockCorrUsages.setText("Find usages...");
        this.jPopupMenuItemBlockCorrUsages.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jPopupMenuItemBlockCorrUsagesActionPerformed(evt);
            }
        });
        this.jPopupMenuBlockCorr.add(this.jPopupMenuItemBlockCorrUsages);
        this.jPopupMenuItemBlockTemplateTabs.setText("Find tabs...");
        this.jPopupMenuItemBlockTemplateTabs.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jPopupMenuItemBlockTemplateTabsActionPerformed(evt);
            }
        });
        this.jPopupMenuBlockCorr.add(this.jPopupMenuItemBlockTemplateTabs);
        this.jMenuItemCorrOccEdit.setText("Edit...");
        this.jMenuItemCorrOccEdit.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemCorrOccEditActionPerformed(evt);
            }
        });
        this.jPopupMenuCorrOcc.add(this.jMenuItemCorrOccEdit);
        this.jMenuItemCorrOccRemove.setText("Remove this correlation");
        this.jMenuItemCorrOccRemove.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemCorrOccRemoveActionPerformed(evt);
            }
        });
        this.jPopupMenuCorrOcc.add(this.jMenuItemCorrOccRemove);
        this.jMenuItemCorrOccCreateTemplate.setText("Create template...");
        this.jMenuItemCorrOccCreateTemplate.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemCorrOccCreateTemplateActionPerformed(evt);
            }
        });
        this.jPopupMenuCorrOcc.add(this.jMenuItemCorrOccCreateTemplate);
        this.jMenuItemCorrOccCreateTxGroup.setText("Add to taxon group...");
        this.jMenuItemCorrOccCreateTxGroup.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemCorrOccCreateTxGroupActionPerformed(evt);
            }
        });
        this.jPopupMenuCorrOcc.add(this.jMenuItemCorrOccCreateTxGroup);
        this.jPopupMenuItemCorrLineEdit.setText("Edit");
        this.jPopupMenuItemCorrLineEdit.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jPopupMenuItemCorrLineEditActionPerformed(evt);
            }
        });
        this.jPopupMenuCorrLine.add(this.jPopupMenuItemCorrLineEdit);
        this.jMenuItemChartTabPopupNewTag.setFont(new Font("Segoe UI", 1, 12));
        this.jMenuItemChartTabPopupNewTag.setText("Add annotation here...");
        this.jMenuItemChartTabPopupNewTag.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemChartTabPopupNewTagActionPerformed(evt);
            }
        });
        this.jPopupMenuChartTab.add(this.jMenuItemChartTabPopupNewTag);
        this.jMenuItemChartTabPopupBringTagToFront.setFont(new Font("Segoe UI", 1, 12));
        this.jMenuItemChartTabPopupBringTagToFront.setText("Bring to front");
        this.jMenuItemChartTabPopupBringTagToFront.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemChartTabPopupBringTagToFrontActionPerformed(evt);
            }
        });
        this.jPopupMenuChartTab.add(this.jMenuItemChartTabPopupBringTagToFront);
        this.jMenuItemChartTabPopupSendTagToBack.setFont(new Font("Segoe UI", 1, 12));
        this.jMenuItemChartTabPopupSendTagToBack.setText("Send to back");
        this.jMenuItemChartTabPopupSendTagToBack.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemChartTabPopupSendTagToBackActionPerformed(evt);
            }
        });
        this.jPopupMenuChartTab.add(this.jMenuItemChartTabPopupSendTagToBack);
        this.jPopupMenuChartTab.add(this.jSeparator9);
        this.jMenuItemChartTabPopupEditBlock.setText("Edit block template...");
        this.jMenuItemChartTabPopupEditBlock.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemChartTabPopupEditBlockActionPerformed(evt);
            }
        });
        this.jPopupMenuChartTab.add(this.jMenuItemChartTabPopupEditBlock);
        this.jMenuItemChartTabPopupSelectBlockTemplate.setText("Select block template...");
        this.jMenuItemChartTabPopupSelectBlockTemplate.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemChartTabPopupSelectBlockTemplateActionPerformed(evt);
            }
        });
        this.jPopupMenuChartTab.add(this.jMenuItemChartTabPopupSelectBlockTemplate);
        this.jPopupMenuChartTab.add(this.jSeparatorChartTabPopup1);
        this.jMenuItemChartTabPopupPanelProperties.setFont(new Font("Segoe UI", 1, 12));
        this.jMenuItemChartTabPopupPanelProperties.setText("Override panel properties in this well...");
        this.jMenuItemChartTabPopupPanelProperties.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemChartTabPopupPanelPropertiesActionPerformed(evt);
            }
        });
        this.jPopupMenuChartTab.add(this.jMenuItemChartTabPopupPanelProperties);
        this.jMenuItemChartTabPopupOverrideToTemplate.setText("Save override as new block template...");
        this.jMenuItemChartTabPopupOverrideToTemplate.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemChartTabPopupOverrideToTemplateActionPerformed(evt);
            }
        });
        this.jPopupMenuChartTab.add(this.jMenuItemChartTabPopupOverrideToTemplate);
        this.jMenuItemChartTabPopupDiscardOverrides.setText("Discard all unsaved panel overrides");
        this.jMenuItemChartTabPopupDiscardOverrides.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemChartTabPopupDiscardOverridesActionPerformed(evt);
            }
        });
        this.jPopupMenuChartTab.add(this.jMenuItemChartTabPopupDiscardOverrides);
        this.jPopupMenuChartTab.add(this.jSeparatorChartTabPopup2);
        this.jMenuItemChartTabPopupPanelDepthSnap.setText("Snap block depth to panel contents");
        this.jMenuItemChartTabPopupPanelDepthSnap.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemChartTabPopupPanelDepthSnapActionPerformed(evt);
            }
        });
        this.jPopupMenuChartTab.add(this.jMenuItemChartTabPopupPanelDepthSnap);
        this.jMenuItemChartTabPopupBlockDefaultDepths.setText("Restore default block depth range");
        this.jMenuItemChartTabPopupBlockDefaultDepths.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemChartTabPopupBlockDefaultDepthsActionPerformed(evt);
            }
        });
        this.jPopupMenuChartTab.add(this.jMenuItemChartTabPopupBlockDefaultDepths);
        this.jPopupMenuChartTab.add(this.jSeparatorChartTabPopup3);
        this.jMenuItemChartTabPopupBlockDepth.setText("Select depth/age range for all well blocks...");
        this.jMenuItemChartTabPopupBlockDepth.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemChartTabPopupBlockDepthActionPerformed(evt);
            }
        });
        this.jPopupMenuChartTab.add(this.jMenuItemChartTabPopupBlockDepth);
        this.jMenuItemChartTabPopupReorganiseWellBlocks.setText("Re-order well blocks...");
        this.jMenuItemChartTabPopupReorganiseWellBlocks.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemChartTabPopupReorganiseWellBlocksActionPerformed(evt);
            }
        });
        this.jPopupMenuChartTab.add(this.jMenuItemChartTabPopupReorganiseWellBlocks);
        this.jMenuItemBlockTabSelectPanelTemplate.setText("Select panel template...");
        this.jMenuItemBlockTabSelectPanelTemplate.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemBlockTabSelectPanelTemplateActionPerformed(evt);
            }
        });
        this.jPopupMenuBlockTab.add(this.jMenuItemBlockTabSelectPanelTemplate);
        this.jMenuItemBlockTabDecouple.setText("Decouple from panel template");
        this.jMenuItemBlockTabDecouple.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemBlockTabDecoupleActionPerformed(evt);
            }
        });
        this.jPopupMenuBlockTab.add(this.jMenuItemBlockTabDecouple);
        this.jMenuBlockTabRecouple.setText("Recouple to panel template");
        this.jMenuItemBlockTabRecoupleToExisting.setText("Choose existing template...");
        this.jMenuItemBlockTabRecoupleToExisting.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemBlockTabRecoupleToExistingActionPerformed(evt);
            }
        });
        this.jMenuBlockTabRecouple.add(this.jMenuItemBlockTabRecoupleToExisting);
        this.jMenuItemBlockTabRecoupleSuggest.setText("Suggest existing template...");
        this.jMenuItemBlockTabRecoupleSuggest.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemBlockTabRecoupleSuggestActionPerformed(evt);
            }
        });
        this.jMenuBlockTabRecouple.add(this.jMenuItemBlockTabRecoupleSuggest);
        this.jMenuItemBlockTabRecoupleToNew.setText("Create new template...");
        this.jMenuItemBlockTabRecoupleToNew.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemBlockTabRecoupleToNewActionPerformed(evt);
            }
        });
        this.jMenuBlockTabRecouple.add(this.jMenuItemBlockTabRecoupleToNew);
        this.jPopupMenuBlockTab.add(this.jMenuBlockTabRecouple);
        this.jDialogCheckUpdatePanel.setTitle("Update Panel Template");
        this.jDialogCheckUpdatePanel.setIconImage(null);
        this.jDialogCheckUpdatePanel.setModal(true);
        this.jDialogCheckUpdatePanel.setResizable(false);
        this.jLabelCheckUpdatePanel.setText("jLabel1");
        this.jCheckBoxCheckUpdatePanel.setText("Don't show this message again");
        this.jCheckBoxCheckUpdatePanel.setFocusPainted(false);
        this.jButtonCheckUpdatePanelNo.setText("No");
        this.jButtonCheckUpdatePanelNo.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCheckUpdatePanelNoActionPerformed(evt);
            }
        });
        this.jButtonCheckUpdatePanelYes.setText("Yes");
        this.jButtonCheckUpdatePanelYes.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCheckUpdatePanelYesActionPerformed(evt);
            }
        });
        GroupLayout jDialogCheckUpdatePanelLayout = new GroupLayout(this.jDialogCheckUpdatePanel.getContentPane());
        this.jDialogCheckUpdatePanel.getContentPane().setLayout((LayoutManager)jDialogCheckUpdatePanelLayout);
        jDialogCheckUpdatePanelLayout.setHorizontalGroup((GroupLayout.Group)jDialogCheckUpdatePanelLayout.createParallelGroup(1).add((GroupLayout.Group)jDialogCheckUpdatePanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jDialogCheckUpdatePanelLayout.createParallelGroup(1).add((GroupLayout.Group)jDialogCheckUpdatePanelLayout.createSequentialGroup().add((Component)this.jCheckBoxCheckUpdatePanel).add(0, 47, Short.MAX_VALUE)).add((Component)this.jLabelCheckUpdatePanel, -1, -1, Short.MAX_VALUE).add(2, (GroupLayout.Group)jDialogCheckUpdatePanelLayout.createSequentialGroup().add(0, 0, Short.MAX_VALUE).add((Component)this.jButtonCheckUpdatePanelYes).addPreferredGap(0).add((Component)this.jButtonCheckUpdatePanelNo))).addContainerGap()));
        jDialogCheckUpdatePanelLayout.linkSize(new Component[]{this.jButtonCheckUpdatePanelNo, this.jButtonCheckUpdatePanelYes}, 1);
        jDialogCheckUpdatePanelLayout.setVerticalGroup((GroupLayout.Group)jDialogCheckUpdatePanelLayout.createParallelGroup(1).add((GroupLayout.Group)jDialogCheckUpdatePanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add((Component)this.jLabelCheckUpdatePanel).addPreferredGap(1).add((Component)this.jCheckBoxCheckUpdatePanel).add(18, 18, 18).add((GroupLayout.Group)jDialogCheckUpdatePanelLayout.createParallelGroup(3).add((Component)this.jButtonCheckUpdatePanelNo).add((Component)this.jButtonCheckUpdatePanelYes)).addContainerGap()));
        this.jMenuItemRemoveLayer.setText("Remove this layer");
        this.jMenuItemRemoveLayer.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemRemoveLayerActionPerformed(evt);
            }
        });
        this.jPopupMenuMapLayers.add(this.jMenuItemRemoveLayer);
        this.jMenuItemLayerUp.setText("Move up");
        this.jMenuItemLayerUp.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemLayerUpActionPerformed(evt);
            }
        });
        this.jPopupMenuMapLayers.add(this.jMenuItemLayerUp);
        this.jMenuItemLayerDown.setText("Move down");
        this.jMenuItemLayerDown.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemLayerDownActionPerformed(evt);
            }
        });
        this.jPopupMenuMapLayers.add(this.jMenuItemLayerDown);
        this.setDefaultCloseOperation(0);
        this.setMinimumSize(new Dimension(500, 500));
        this.addWindowListener(new WindowAdapter(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void windowClosing(WindowEvent evt) {
                this.this$0.windowClosing(evt);
            }
        });
        this.jButtonOpen.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/openFile.png")));
        this.jButtonOpen.setToolTipText("Open...");
        this.jButtonOpen.setFocusable(false);
        this.jButtonOpen.setHorizontalTextPosition(0);
        this.jButtonOpen.setVerticalTextPosition(3);
        this.jButtonOpen.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOpenActionPerformed(evt);
            }
        });
        this.jToolBarMain.add(this.jButtonOpen);
        this.jButtonSaveChart.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/save24.png")));
        this.jButtonSaveChart.setToolTipText("Save selected chart");
        this.jButtonSaveChart.setFocusable(false);
        this.jButtonSaveChart.setHorizontalTextPosition(0);
        this.jButtonSaveChart.setVerticalTextPosition(3);
        this.jButtonSaveChart.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSaveChartActionPerformed(evt);
            }
        });
        this.jToolBarMain.add(this.jButtonSaveChart);
        this.jButtonExportChart.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/export24.png")));
        this.jButtonExportChart.setToolTipText("Export vector image of selected chart");
        this.jButtonExportChart.setFocusable(false);
        this.jButtonExportChart.setHorizontalTextPosition(0);
        this.jButtonExportChart.setVerticalTextPosition(3);
        this.jButtonExportChart.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonExportChartActionPerformed(evt);
            }
        });
        this.jToolBarMain.add(this.jButtonExportChart);
        this.jButtonExportChartBitmap.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/exportbit24.png")));
        this.jButtonExportChartBitmap.setToolTipText("Export bitmap image of selected chart");
        this.jButtonExportChartBitmap.setFocusable(false);
        this.jButtonExportChartBitmap.setHorizontalTextPosition(0);
        this.jButtonExportChartBitmap.setVerticalTextPosition(3);
        this.jButtonExportChartBitmap.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonExportChartBitmapActionPerformed(evt);
            }
        });
        this.jToolBarMain.add(this.jButtonExportChartBitmap);
        this.jButtonPrintChart.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/print24.png")));
        this.jButtonPrintChart.setToolTipText("Print selected chart");
        this.jButtonPrintChart.setFocusable(false);
        this.jButtonPrintChart.setHorizontalTextPosition(0);
        this.jButtonPrintChart.setVerticalTextPosition(3);
        this.jButtonPrintChart.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonPrintChartActionPerformed(evt);
            }
        });
        this.jToolBarMain.add(this.jButtonPrintChart);
        this.jToolBarMain.add(this.jSeparator5);
        this.jButtonZoomIn.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/ZoomIn24.png")));
        this.jButtonZoomIn.setToolTipText("Zoom in");
        this.jButtonZoomIn.setFocusable(false);
        this.jButtonZoomIn.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonZoomInActionPerformed(evt);
            }
        });
        this.jToolBarMain.add(this.jButtonZoomIn);
        this.jButtonZoomOut.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/ZoomOut24.png")));
        this.jButtonZoomOut.setToolTipText("Zoom out");
        this.jButtonZoomOut.setFocusable(false);
        this.jButtonZoomOut.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonZoomOutActionPerformed(evt);
            }
        });
        this.jToolBarMain.add(this.jButtonZoomOut);
        this.jToggleButtonXHairs.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/FrameSamples_xHair.png")));
        this.jToggleButtonXHairs.setToolTipText("Toggle cross-hair");
        this.jToggleButtonXHairs.setFocusable(false);
        this.jToggleButtonXHairs.setHorizontalTextPosition(0);
        this.jToggleButtonXHairs.setVerticalTextPosition(3);
        this.jToggleButtonXHairs.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jToggleButtonXHairsActionPerformed(evt);
            }
        });
        this.jToolBarMain.add(this.jToggleButtonXHairs);
        this.jToggleButtonMagnifier.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/magnifier.png")));
        this.jToggleButtonMagnifier.setToolTipText("Toggle magnifier (hold down Q)");
        this.jToggleButtonMagnifier.setFocusable(false);
        this.jToggleButtonMagnifier.setHorizontalTextPosition(0);
        this.jToggleButtonMagnifier.setVerticalTextPosition(3);
        this.jToggleButtonMagnifier.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jToggleButtonMagnifierActionPerformed(evt);
            }
        });
        this.jToolBarMain.add(this.jToggleButtonMagnifier);
        this.jToolBarMain.add(this.jSeparatorElements);
        this.jButtonChartProperties.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/FrameSamples_ChartProperties.png")));
        this.jButtonChartProperties.setToolTipText("Chart properties");
        this.jButtonChartProperties.setFocusable(false);
        this.jButtonChartProperties.setHorizontalTextPosition(0);
        this.jButtonChartProperties.setVerticalTextPosition(3);
        this.jButtonChartProperties.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonChartPropertiesActionPerformed(evt);
            }
        });
        this.jToolBarMain.add(this.jButtonChartProperties);
        this.jButtonLeft.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/movePanelLeft.png")));
        this.jButtonLeft.setToolTipText("Move left (left arrow key)");
        this.jButtonLeft.setFocusable(false);
        this.jButtonLeft.setHorizontalTextPosition(0);
        this.jButtonLeft.setVerticalTextPosition(3);
        this.jButtonLeft.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonLeftActionPerformed(evt);
            }
        });
        this.jToolBarMain.add(this.jButtonLeft);
        this.jButtonRight.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/movePanelRight.png")));
        this.jButtonRight.setToolTipText("Move right (right arrow key)");
        this.jButtonRight.setFocusable(false);
        this.jButtonRight.setHorizontalTextPosition(0);
        this.jButtonRight.setVerticalTextPosition(3);
        this.jButtonRight.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonRightActionPerformed(evt);
            }
        });
        this.jToolBarMain.add(this.jButtonRight);
        this.jButtonRemove.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/removePanel.png")));
        this.jButtonRemove.setToolTipText("Remove");
        this.jButtonRemove.setFocusable(false);
        this.jButtonRemove.setHorizontalTextPosition(0);
        this.jButtonRemove.setVerticalTextPosition(3);
        this.jButtonRemove.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonRemoveActionPerformed(evt);
            }
        });
        this.jToolBarMain.add(this.jButtonRemove);
        this.jSplitPaneMain.setBorder(null);
        this.jSplitPaneMain.setDividerLocation(670);
        this.jSplitPaneMain.setResizeWeight(1.0);
        ((BasicSplitPaneUI)this.jSplitPaneMain.getUI()).getDivider().setBorder(null);
        this.jSplitPanePalette.setBorder(null);
        this.jSplitPanePalette.setDividerLocation(250);
        this.jSplitPanePalette.setOrientation(0);
        this.jSplitPanePalette.setMinimumSize(new Dimension(150, 28));
        ((BasicSplitPaneUI)this.jSplitPanePalette.getUI()).getDivider().setBorder(null);
        this.jPanelProperties.setBorder(BorderFactory.createEmptyBorder(0, 0, 3, 3));
        this.jSplitPanePropertiesTable.setBorder(null);
        this.jSplitPanePropertiesTable.setDividerLocation(250);
        this.jSplitPanePropertiesTable.setOrientation(0);
        this.jSplitPanePropertiesTable.setResizeWeight(1.0);
        ((BasicSplitPaneUI)this.jSplitPanePropertiesTable.getUI()).getDivider().setBorder(null);
        this.jScrollPaneTableProperties.setPreferredSize(new Dimension(452, 150));
        this.jTableProperties.setFont(this.jTableProperties.getFont());
        this.jTableProperties.setModel(this.nullModel);
        this.jScrollPaneTableProperties.setViewportView(this.jTableProperties);
        this.jSplitPanePropertiesTable.setTopComponent(this.jScrollPaneTableProperties);
        this.jScrollPanePanelDetails.setHorizontalScrollBarPolicy(31);
        this.jScrollPanePanelDetails.setVerticalScrollBarPolicy(21);
        this.jTextPanePanelDetails.setEditable(false);
        this.jTextPanePanelDetails.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.jTextPanePanelDetails.setFont(this.jTextPanePanelDetails.getFont());
        this.jScrollPanePanelDetails.setViewportView(this.jTextPanePanelDetails);
        this.jSplitPanePropertiesTable.setRightComponent(this.jScrollPanePanelDetails);
        GroupLayout jPanelPropertiesLayout = new GroupLayout((Container)this.jPanelProperties);
        this.jPanelProperties.setLayout((LayoutManager)jPanelPropertiesLayout);
        jPanelPropertiesLayout.setHorizontalGroup((GroupLayout.Group)jPanelPropertiesLayout.createParallelGroup(1).add((Component)this.jSplitPanePropertiesTable, -1, 222, Short.MAX_VALUE));
        jPanelPropertiesLayout.setVerticalGroup((GroupLayout.Group)jPanelPropertiesLayout.createParallelGroup(1).add((Component)this.jSplitPanePropertiesTable, -1, 298, Short.MAX_VALUE));
        this.jSplitPanePalette.setRightComponent(this.jPanelProperties);
        this.jPanelTree.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 3));
        this.jTreePanels.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jTreePanels.setFont(this.jTreePanels.getFont());
        this.jTreePanels.setModel(this.treeModel);
        this.jTreePanels.setRootVisible(false);
        this.jScrollPane1.setViewportView(this.jTreePanels);
        GroupLayout jPanelTreeLayout = new GroupLayout((Container)this.jPanelTree);
        this.jPanelTree.setLayout((LayoutManager)jPanelTreeLayout);
        jPanelTreeLayout.setHorizontalGroup((GroupLayout.Group)jPanelTreeLayout.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 222, Short.MAX_VALUE));
        jPanelTreeLayout.setVerticalGroup((GroupLayout.Group)jPanelTreeLayout.createParallelGroup(1).add(2, (Component)this.jScrollPane1, -1, 250, Short.MAX_VALUE));
        this.jSplitPanePalette.setLeftComponent(this.jPanelTree);
        this.jSplitPaneMain.setRightComponent(this.jSplitPanePalette);
        this.jLabelProject.setFont(this.jLabelProject.getFont().deriveFont(this.jLabelProject.getFont().getStyle() | 1, this.jLabelProject.getFont().getSize() + 2));
        this.jLabelProject.setForeground(new Color(51, 51, 51));
        this.jLabelProject.setHorizontalAlignment(11);
        this.jLabelProject.setText("Project:");
        GroupLayout jPanelProjectLayout = new GroupLayout((Container)this.jPanelProject);
        this.jPanelProject.setLayout((LayoutManager)jPanelProjectLayout);
        jPanelProjectLayout.setHorizontalGroup((GroupLayout.Group)jPanelProjectLayout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanelProjectLayout.createSequentialGroup().add(0, 0, 0).add((Component)this.jLabelProject, -2, 408, -2).addContainerGap()));
        jPanelProjectLayout.setVerticalGroup((GroupLayout.Group)jPanelProjectLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelProjectLayout.createSequentialGroup().addContainerGap().add((Component)this.jLabelProject).addContainerGap(-1, Short.MAX_VALUE)));
        this.jMenuFile.setText("File");
        this.jMenuItemChartOpen.setAccelerator(KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.jMenuItemChartOpen.setText("Open...");
        this.jMenuItemChartOpen.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemChartOpenActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemChartOpen);
        this.jMenuItemOpenProject.setAccelerator(KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 0x40));
        this.jMenuItemOpenProject.setText("Open Project...");
        this.jMenuItemOpenProject.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemOpenProjectActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemOpenProject);
        this.jMenuFile.add(this.jSeparator4);
        this.jMenuChartBlockNew.setText("New Block Template");
        this.jMenuItemBlockNewWell.setAccelerator(KeyStroke.getKeyStroke(78, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 0x40));
        this.jMenuItemBlockNewWell.setText("Well block...");
        this.jMenuItemBlockNewWell.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemBlockNewWellActionPerformed(evt);
            }
        });
        this.jMenuChartBlockNew.add(this.jMenuItemBlockNewWell);
        this.jMenuItemBlockNewProject.setText("Project block...");
        this.jMenuItemBlockNewProject.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemBlockNewProjectActionPerformed(evt);
            }
        });
        this.jMenuChartBlockNew.add(this.jMenuItemBlockNewProject);
        this.jMenuItemBlockNewScheme.setText("Scheme block...");
        this.jMenuItemBlockNewScheme.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemBlockNewSchemeActionPerformed(evt);
            }
        });
        this.jMenuChartBlockNew.add(this.jMenuItemBlockNewScheme);
        this.jMenuItemBlockNewMap.setText("Map block...");
        this.jMenuItemBlockNewMap.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemBlockNewMapActionPerformed(evt);
            }
        });
        this.jMenuChartBlockNew.add(this.jMenuItemBlockNewMap);
        this.jMenuFile.add(this.jMenuChartBlockNew);
        this.jMenuItemTemplateNew.setAccelerator(KeyStroke.getKeyStroke(78, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.jMenuItemTemplateNew.setText("<html>New Named <strong>Chart</strong>...</html>");
        this.jMenuItemTemplateNew.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemTemplateNewActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemTemplateNew);
        this.jMenuFile.add(this.jSeparator1);
        this.jMenuItemPanelManager.setText("Manage Panels...");
        this.jMenuItemPanelManager.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemPanelManagerActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemPanelManager);
        this.jMenuItemShapeStores.setText("Manage Shape Data Sources...");
        this.jMenuItemShapeStores.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemShapeStoresActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemShapeStores);
        this.jMenuFile.add(this.jSeparator7);
        this.jMenuItemOpenLegacy.setText("Convert Legacy Charts...");
        this.jMenuItemOpenLegacy.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemOpenLegacyActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemOpenLegacy);
        this.jMenuFile.add(this.jSeparator6);
        this.jMenuItemExit.setText("Exit");
        this.jMenuItemExit.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemExitActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemExit);
        this.jMenuBar1.add(this.jMenuFile);
        this.jMenuChart.setText("Chart/Template");
        this.jMenuItemChartSave.setAccelerator(KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.jMenuItemChartSave.setText("Save");
        this.jMenuItemChartSave.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemChartSaveActionPerformed(evt);
            }
        });
        this.jMenuChart.add(this.jMenuItemChartSave);
        this.jMenuItemSaveAs.setText("Save as...");
        this.jMenuItemSaveAs.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemSaveAsActionPerformed(evt);
            }
        });
        this.jMenuChart.add(this.jMenuItemSaveAs);
        this.jMenuItemChartRestore.setText("Restore saved properties");
        this.jMenuItemChartRestore.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemChartRestoreActionPerformed(evt);
            }
        });
        this.jMenuChart.add(this.jMenuItemChartRestore);
        this.jMenuChart.add(this.jSeparator10);
        this.jMenuItemChartEdit.setText("Edit details...");
        this.jMenuItemChartEdit.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemChartEditActionPerformed(evt);
            }
        });
        this.jMenuChart.add(this.jMenuItemChartEdit);
        this.jMenuItemChartPermissions.setText("Permissions...");
        this.jMenuItemChartPermissions.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemChartPermissionsActionPerformed(evt);
            }
        });
        this.jMenuChart.add(this.jMenuItemChartPermissions);
        this.jMenuItemOverrides.setText("Overrides...");
        this.jMenuItemOverrides.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemOverridesActionPerformed(evt);
            }
        });
        this.jMenuChart.add(this.jMenuItemOverrides);
        this.jMenuItemChartDelete.setText("Delete");
        this.jMenuItemChartDelete.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemChartDeleteActionPerformed(evt);
            }
        });
        this.jMenuChart.add(this.jMenuItemChartDelete);
        this.jMenuItemBlockList.setText("Show chart blocks...");
        this.jMenuItemBlockList.setEnabled(false);
        this.jMenuItemBlockList.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemBlockListActionPerformed(evt);
            }
        });
        this.jMenuChart.add(this.jMenuItemBlockList);
        this.jMenuItemTagList.setText("Show annotations...");
        this.jMenuItemTagList.setEnabled(false);
        this.jMenuItemTagList.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemTagListActionPerformed(evt);
            }
        });
        this.jMenuChart.add(this.jMenuItemTagList);
        this.jMenuChart.add(this.jSeparator8);
        this.jMenuItemBlockUsage.setText("Find Usages...");
        this.jMenuItemBlockUsage.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemBlockUsageActionPerformed(evt);
            }
        });
        this.jMenuChart.add(this.jMenuItemBlockUsage);
        this.jMenuItemTabUsage.setText("Find Tabs...");
        this.jMenuItemTabUsage.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemTabUsageActionPerformed(evt);
            }
        });
        this.jMenuChart.add(this.jMenuItemTabUsage);
        this.jMenuChart.add(this.jSeparator2);
        this.jMenuItemChartPrint.setAccelerator(KeyStroke.getKeyStroke(80, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.jMenuItemChartPrint.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/print16.png")));
        this.jMenuItemChartPrint.setText("Print...");
        this.jMenuItemChartPrint.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemChartPrintActionPerformed(evt);
            }
        });
        this.jMenuChart.add(this.jMenuItemChartPrint);
        this.jMenuChartExport.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/export16.png")));
        this.jMenuChartExport.setText("Export Image");
        this.jMenuItemChartExportVector.setText("As PDF/vector image...");
        this.jMenuItemChartExportVector.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemChartExportVectorActionPerformed(evt);
            }
        });
        this.jMenuChartExport.add(this.jMenuItemChartExportVector);
        this.jMenuItemChartExportBitmap.setText("As bitmap...");
        this.jMenuItemChartExportBitmap.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemChartExportBitmapActionPerformed(evt);
            }
        });
        this.jMenuChartExport.add(this.jMenuItemChartExportBitmap);
        this.jMenuChartExport.add(this.jSeparator3);
        this.jMenuItemChartExportHelp.setText("Help...");
        this.jMenuChartExport.add(this.jMenuItemChartExportHelp);
        this.jMenuChart.add(this.jMenuChartExport);
        this.jMenuItemChartExportFile.setText("Export to File...");
        this.jMenuItemChartExportFile.setToolTipText("Export tab to StrataBugs SBG file");
        this.jMenuItemChartExportFile.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemChartExportFileActionPerformed(evt);
            }
        });
        this.jMenuChart.add(this.jMenuItemChartExportFile);
        this.jMenuItemChartExportKML.setText("Export locations to KML ...");
        this.jMenuItemChartExportKML.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemChartExportKMLActionPerformed(evt);
            }
        });
        this.jMenuChart.add(this.jMenuItemChartExportKML);
        this.jMenuItemExportToShapefile.setText("Export to Shapefile...");
        this.jMenuItemExportToShapefile.setEnabled(false);
        this.jMenuItemExportToShapefile.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemExportToShapefileActionPerformed(evt);
            }
        });
        this.jMenuChart.add(this.jMenuItemExportToShapefile);
        this.jMenuBar1.add(this.jMenuChart);
        this.jMenuView.setText("View");
        this.jMenuItemCloseAllTabs.setText("Close all tabs");
        this.jMenuItemCloseAllTabs.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemCloseAllTabsActionPerformed(evt);
            }
        });
        this.jMenuView.add(this.jMenuItemCloseAllTabs);
        this.jMenuSort.setText("Sorting");
        this.buttonGroupSort.add(this.jRadioButtonMenuItemAlpha);
        this.jRadioButtonMenuItemAlpha.setSelected(true);
        this.jRadioButtonMenuItemAlpha.setText("Alphabetical");
        this.jRadioButtonMenuItemAlpha.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonMenuItemAlphaActionPerformed(evt);
            }
        });
        this.jMenuSort.add(this.jRadioButtonMenuItemAlpha);
        this.buttonGroupSort.add(this.jRadioButtonMenuItemMod);
        this.jRadioButtonMenuItemMod.setText("Modified date");
        this.jRadioButtonMenuItemMod.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonMenuItemModActionPerformed(evt);
            }
        });
        this.jMenuSort.add(this.jRadioButtonMenuItemMod);
        this.jMenuView.add(this.jMenuSort);
        this.jCheckBoxMenuItemViewGlobal.setSelected(true);
        this.jCheckBoxMenuItemViewGlobal.setText("Show global templates");
        this.jCheckBoxMenuItemViewGlobal.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jCheckBoxMenuItemViewGlobalActionPerformed(evt);
            }
        });
        this.jMenuView.add(this.jCheckBoxMenuItemViewGlobal);
        this.jMenu1.setText("Outlines");
        this.buttonGroupMenuOutline.add(this.jRadioButtonMenuItemNoOutline);
        this.jRadioButtonMenuItemNoOutline.setSelected(true);
        this.jRadioButtonMenuItemNoOutline.setText("Don't show paper outline");
        this.jRadioButtonMenuItemNoOutline.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonMenuItemNoOutlineActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jRadioButtonMenuItemNoOutline);
        this.buttonGroupMenuOutline.add(this.jRadioButtonMenuItemShowA4);
        this.jRadioButtonMenuItemShowA4.setText("A4 (landscape) paper outline");
        this.jRadioButtonMenuItemShowA4.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonMenuItemShowA4ActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jRadioButtonMenuItemShowA4);
        this.buttonGroupMenuOutline.add(this.jRadioButtonMenuItemShowA5);
        this.jRadioButtonMenuItemShowA5.setText("A5 (landscape) paper outline");
        this.jRadioButtonMenuItemShowA5.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonMenuItemShowA5ActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jRadioButtonMenuItemShowA5);
        this.buttonGroupMenuOutline.add(this.jRadioButtonMenuItemCustomOutline);
        this.jRadioButtonMenuItemCustomOutline.setText("Custom paper outline...");
        this.jRadioButtonMenuItemCustomOutline.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonMenuItemCustomOutlineActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jRadioButtonMenuItemCustomOutline);
        this.jMenuView.add(this.jMenu1);
        this.jMenuBar1.add(this.jMenuView);
        this.jMenuHelp.setText("Help");
        this.jMenuItemHelp.setText("Charts Help...");
        this.jMenuItemHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemHelpActionPerformed(evt);
            }
        });
        this.jMenuHelp.add(this.jMenuItemHelp);
        this.jMenuBar1.add(this.jMenuHelp);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jToolBarMain, -2, -1, -2).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jPanelProject, -2, -1, -2)).add((Component)this.jSplitPaneMain));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.jPanelProject, -1, -1, Short.MAX_VALUE).add((Component)this.jToolBarMain, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.jSplitPaneMain, -1, 559, Short.MAX_VALUE)));
        this.pack();
    }

    private void jMenuItemExitActionPerformed(ActionEvent evt) {
        this.encodeGUISession();
        this.jMenuItemCloseAllTabsActionPerformed(null);
        if (this.jTabbedPaneChart.getTabCount() == 0) {
            this.dispose();
        }
    }

    private void jMenuItemBlockNewWellActionPerformed(ActionEvent evt) {
        this.createAndOpenNewBlockTemplate(BlockType.WELL);
    }

    private void jMenuItemChartOpenActionPerformed(ActionEvent evt) {
        this.openTemplate();
    }

    private void jMenuItemBlockNewProjectActionPerformed(ActionEvent evt) {
        this.createAndOpenNewBlockTemplate(BlockType.PROJECT);
    }

    private void jMenuItemBlockNewSchemeActionPerformed(ActionEvent evt) {
        this.createAndOpenNewBlockTemplate(BlockType.SCHEME);
    }

    private void jMenuItemTemplateNewActionPerformed(ActionEvent evt) {
        this.createNewChart();
    }

    private void jMenuItemChartSaveActionPerformed(ActionEvent evt) {
        this.saveSelection();
    }

    private void jMenuItemChartEditActionPerformed(ActionEvent evt) {
        this.editTemplate();
    }

    private void jButtonZoomInActionPerformed(ActionEvent evt) {
        this.zoom(true);
    }

    private void jButtonZoomOutActionPerformed(ActionEvent evt) {
        this.zoom(false);
    }

    private void jButtonRemoveActionPerformed(ActionEvent evt) {
        ((JScrollPaneChartTemplate)this.jTabbedPaneChart.getSelectedComponent()).removeSelectedChartElement();
    }

    private void jButtonLeftActionPerformed(ActionEvent evt) {
        if (!this.isEditingAPropertyValue()) {
            ((JScrollPaneChartTemplate)this.jTabbedPaneChart.getSelectedComponent()).moveSelectedChartElement(true);
        }
    }

    private void jButtonRightActionPerformed(ActionEvent evt) {
        if (!this.isEditingAPropertyValue()) {
            ((JScrollPaneChartTemplate)this.jTabbedPaneChart.getSelectedComponent()).moveSelectedChartElement(false);
        }
    }

    private void jMenuItemAddPanelTemplateActionPerformed(ActionEvent evt) {
        String name;
        PanelType type = null;
        Object o = this.jTreePanels.getSelectionPath().getLastPathComponent();
        if (o instanceof PanelTemplate) {
            type = ((PanelTemplate)o).getType();
        } else if (o instanceof PanelType) {
            type = (PanelType)o;
        }
        if (type != null && (name = this.getNewTemplateName(type, this.getSelectedProjectID())) != null) {
            this.addPanelTemplate(o, name);
        }
    }

    private void jMenuItemEditPanelTemplateActionPerformed(ActionEvent evt) {
        PanelTemplate template = null;
        Object o = this.jTreePanels.getSelectionPath().getLastPathComponent();
        if (o instanceof PanelTemplate) {
            template = (PanelTemplate)o;
        }
        if (template != null) {
            try {
                DialogChartDesc dialog = new DialogChartDesc(this, "Panel Template : Edit : " + template.getName(), (TemplateDescr)template, template.canWrite(this.sbdb, null), false);
                dialog.restrictProjectToProject(this.getSelectedProjectID(), true);
                dialog.setLocationRelativeTo(this);
                dialog.setVisible(true);
                if (dialog.isOK() && template.updateDescr(this.sbdb, dialog.name, dialog.comments, dialog.projID)) {
                    this.sbdb.commit();
                    this.treeModel.fireTreeNodeChanged(o);
                    this.reInitDetailsPane();
                }
            }
            catch (InvalidFieldException ife) {
                JOptionPane.showMessageDialog(this, ife.getMessage(), "Edit Panel Template", 2);
            }
            catch (SQLException | SBPermissionException sql) {
                this.sbdb.doRollback();
                FrameJsbugs.showStackError("SQL Error", (Exception)sql, this.sbdb);
            }
        }
    }

    private void jMenuItemDeletePanelTemplateActionPerformed(ActionEvent evt) {
        PanelTemplate template = null;
        Object o = this.jTreePanels.getSelectionPath().getLastPathComponent();
        if (o instanceof PanelTemplate) {
            template = (PanelTemplate)o;
        }
        if (template != null) {
            if (JOptionPane.showConfirmDialog(this, "Are you sure you want to delete this template?", this.getTitle(), 0) != 0) {
                return;
            }
            try {
                this.chartManager.deletePanelTemplate(template.getID());
                this.sbdb.commit();
                this.treeModel.fireTreeStructureChanged();
                TreePath path = this.treeModel.getPath(template.getType());
                this.jTreePanels.setSelectionPath(path);
                this.jTreePanels.expandPath(path);
            }
            catch (SBException | SBPermissionException sbe) {
                JOptionPane.showMessageDialog(this, "Can't delete: " + sbe.getMessage(), "Delete Template", 2);
            }
            catch (SQLException sql) {
                this.sbdb.doRollback();
                FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
            }
        }
    }

    private void jButtonChartPropertiesActionPerformed(ActionEvent evt) {
        JScrollPaneChartTemplate scrollPane = (JScrollPaneChartTemplate)this.jTabbedPaneChart.getSelectedComponent();
        scrollPane.chartProperties();
    }

    private void jPopupMenuItemEditBlockCorrTemplateActionPerformed(ActionEvent evt) {
        Object o = this.jTreePanels.getSelectionPath().getLastPathComponent();
        BlockTemplateInfo info = null;
        if (o instanceof BlockTemplateInfo) {
            info = (BlockTemplateInfo)o;
            o = this.chartManager.getBlockTemplateFromInfo((BlockTemplateInfo)o);
        }
        if (o != null && o instanceof TemplateDescr) {
            TemplateDescr template = (TemplateDescr)o;
            try {
                DialogChartDesc dialog = new DialogChartDesc(this, "Template : Edit : " + template.getName(), template, ((SBRestrictable)((Object)o)).canWrite(this.sbdb, null), false);
                dialog.restrictProjectToProject(this.getSelectedProjectID(), true);
                dialog.setLocationRelativeTo(this);
                dialog.setVisible(true);
                if (dialog.isOK()) {
                    if (template instanceof BlockTemplate) {
                        if (!((BlockTemplate)template).updateDescr(this.sbdb, dialog.name, dialog.comments, dialog.projID, 0)) {
                            return;
                        }
                    } else if (template instanceof CorrelationTemplate) {
                        ((CorrelationTemplate)template).updateDescr(this.sbdb, dialog.name, dialog.comments, dialog.projID);
                    }
                    this.sbdb.commit();
                    if (info != null) {
                        info.updateDescr(dialog.name, dialog.comments, dialog.projID);
                        this.treeModel.fireTreeNodeChanged(info);
                    } else {
                        this.treeModel.fireTreeNodeChanged(o);
                    }
                    this.reInitDetailsPane();
                }
            }
            catch (InvalidFieldException ife) {
                JOptionPane.showMessageDialog(this, ife.getMessage(), this.getTitle(), 2);
            }
            catch (SQLException | SBException | SBPermissionException sql) {
                this.sbdb.doRollback();
                FrameJsbugs.showStackError("SQL Error", (Exception)sql, this.sbdb);
            }
        }
    }

    private void jPopupMenuItemAddBlockCorrTemplateActionPerformed(ActionEvent evt) {
        CorrelationType corrType = null;
        Object o = this.jTreePanels.getSelectionPath().getLastPathComponent();
        if (o instanceof CorrelationTemplate) {
            CorrelationTemplate correlationTemplate = (CorrelationTemplate)o;
            corrType = correlationTemplate.getType();
        } else if (o instanceof CorrelationType) {
            corrType = (CorrelationType)o;
        } else if (o instanceof BlockType) {
            BlockType blockType = (BlockType)o;
            this.createAndAddNewBlockTemplate(blockType);
            return;
        }
        if (corrType != null) {
            try {
                DialogChartDesc dialog = new DialogChartDesc(this, "New Correlation Template", "", null, true, false);
                dialog.restrictProjectToProject(this.getSelectedProjectID(), true);
                dialog.setLocationRelativeTo(this);
                dialog.setVisible(true);
                if (dialog.isOK()) {
                    this.addCorrelationTemplate(corrType, dialog.name, dialog.comments, dialog.projID);
                }
            }
            catch (SQLException e) {
                SbugsExceptionHandler.showStackError("Error loading projects", e);
            }
        }
    }

    private void jPopupMenuItemDeleteBlockCorrTemplateActionPerformed(ActionEvent evt) {
        Object o = this.jTreePanels.getSelectionPath().getLastPathComponent();
        if (o instanceof BlockTemplateInfo) {
            o = this.chartManager.getBlockTemplateFromInfo((BlockTemplateInfo)o);
        }
        if (o == null || !(o instanceof TemplateDescr)) {
            return;
        }
        int opt = JOptionPane.showConfirmDialog(this, "Are you sure you want to delete this template?", "Delete Template", 0);
        if (opt != 0) {
            return;
        }
        Enum objectForTreePath = null;
        try {
            if (o instanceof CorrelationTemplate) {
                CorrelationTemplate corrTemplate = (CorrelationTemplate)o;
                this.chartManager.deleteCorrTemplate(corrTemplate);
                objectForTreePath = corrTemplate.getType();
            } else if (o instanceof BlockTemplate) {
                BlockTemplate blockTemplate = (BlockTemplate)o;
                try {
                    this.chartManager.deleteTemplate(blockTemplate);
                    objectForTreePath = blockTemplate.getType();
                }
                catch (SBException e) {
                    String message = e.getMessage() + ".\n\nYou can attempt to merge with another template instead.";
                    Object[] selectionValues = new String[]{"OK", "Attempt merge"};
                    int selection = JOptionPane.showOptionDialog(this, message, "Delete Block Template", 0, 2, null, selectionValues, null);
                    if (selection == 1) {
                        ArrayList<BlockTemplate> targetOptions = new ArrayList<BlockTemplate>(this.chartManager.getBlocks(blockTemplate.getType(), blockTemplate.getProjID(), true, new ChartManager.TemplateComparator(), false));
                        targetOptions.remove(blockTemplate);
                        DialogList<BlockTemplate> dialog = new DialogList<BlockTemplate>(this, true, "Select Target Template", null, targetOptions, true, false, null);
                        dialog.setLocationRelativeTo(this);
                        dialog.setVisible(true);
                        if (dialog.getOptionalSelection().isEmpty()) {
                            return;
                        }
                        BlockTemplateParent target = (BlockTemplateParent)dialog.getSelection();
                        BlockTemplateMerge process = new BlockTemplateMerge(this.chartManager, this.sbdb, target, List.of((BlockTemplateParent)blockTemplate));
                        BasicMultiStageProcessHandler handler = new BasicMultiStageProcessHandler(process, this, "Merge Block Templates");
                        handler.runProcess();
                    }
                    return;
                }
            }
            this.sbdb.commit();
            this.treeModel.fireTreeStructureChanged();
            if (objectForTreePath != null) {
                TreePath path = this.treeModel.getPath(objectForTreePath);
                this.jTreePanels.setSelectionPath(path);
                this.jTreePanels.expandPath(path);
            }
        }
        catch (SBException | SBPermissionException sbe) {
            JOptionPane.showMessageDialog(this, sbe.getMessage(), "Delete Correlation Template", 2);
        }
        catch (SQLException sql) {
            this.sbdb.doRollback();
            SbugsExceptionHandler.showStackError(sql, this);
        }
    }

    private void jMenuItemCorrOccRemoveActionPerformed(ActionEvent evt) {
        Object o = this.jListCorrOcc.getSelectedValue();
        if (o == null) {
            return;
        }
        Correlation correlation = (Correlation)o;
        JScrollPaneChartTemplate scrollPane = (JScrollPaneChartTemplate)this.jTabbedPaneChart.getSelectedComponent();
        assert (scrollPane.blockType == null);
        if (JOptionPane.showConfirmDialog(this, "Really remove this correlation?", "Remove Correlation", 0) != 0) {
            return;
        }
        try {
            scrollPane.view.chart.removeCorrelation(correlation);
            this.reInitTab(scrollPane.view.chart);
        }
        catch (RuntimeException | SQLException | SBException e) {
            SbugsExceptionHandler.showStackError(e, this);
        }
    }

    private void jMenuItemCorrOccEditActionPerformed(ActionEvent evt) {
        this.editCorrelation();
    }

    private void jPopupMenuItemCorrLineEditActionPerformed(ActionEvent evt) {
        this.openCorrelationLineEditDialog();
    }

    private void jButtonSaveChartActionPerformed(ActionEvent evt) {
        this.saveSelection();
    }

    private void jButtonPrintChartActionPerformed(ActionEvent evt) {
        this.printChart();
    }

    private void jButtonExportChartActionPerformed(ActionEvent evt) {
        this.exportChartImage(true);
    }

    private void jMenuItemChartPrintActionPerformed(ActionEvent evt) {
        this.printChart();
    }

    private void jMenuItemChartExportVectorActionPerformed(ActionEvent evt) {
        this.exportChartImage(true);
    }

    private void jMenuItemChartExportBitmapActionPerformed(ActionEvent evt) {
        this.exportChartImage(false);
    }

    private void jMenuItemCorrOccCreateTemplateActionPerformed(ActionEvent evt) {
        CorrelationType type = null;
        Object o = this.jTreePanels.getSelectionPath().getLastPathComponent();
        Correlation c = (Correlation)this.jListCorrOcc.getSelectedValue();
        if (o instanceof CorrelationStandard) {
            type = ((CorrelationStandard)o).type;
        }
        if (type == null || c == null) {
            return;
        }
        DialogChartDesc dialog = new DialogChartDesc(this, "New Correlation Template", "", null, true, false);
        try {
            dialog.restrictProjectToProject(this.getSelectedProjectID(), true);
        }
        catch (SQLException ex) {
            SbugsExceptionHandler.showStackError("SQL error loading projects", ex, this);
            return;
        }
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.isOK()) {
            try {
                if (!this.chartManager.checkNewTemplateName(dialog.name, type, dialog.projID)) {
                    JOptionPane.showMessageDialog(this, "That name is in use.", "New " + type.getNoun() + " Template", 2);
                    dialog.name = this.getNewTemplateName(type, dialog.projID);
                    if (dialog.name == null) {
                        return;
                    }
                }
            }
            catch (SQLException sql) {
                SbugsExceptionHandler.showStackError("SQL error", sql, this);
            }
            CorrelationTemplate template = this.addCorrelationTemplate(type, dialog.name, dialog.comments, dialog.projID);
            LinkedList<CorrelationLine> lines = new LinkedList<CorrelationLine>();
            block11: for (CorrelationLine l : c.getLines()) {
                switch (type) {
                    case EVENT: {
                        lines.add(new EventLine((SBEvent)l.getObject(), (EventType)l.getObjectType(), null));
                        continue block11;
                    }
                    case SURFACE: {
                        lines.add(new SurfaceLine((Surface)((SurfaceLine)l).getObject(), null));
                        continue block11;
                    }
                    case CHRONO: 
                    case LITHO: 
                    case BIOZONE: {
                        lines.add(new IGDUnitLine(type, (IGDUnitBase)l.getObject(), (IGDIntervalZone.BoundaryType)((Object)l.getObjectType()), null));
                        continue block11;
                    }
                }
                assert (false);
            }
            template.addCorrelationLines(lines);
            try {
                template.storeLines(this.sbdb);
                this.sbdb.commit();
            }
            catch (SQLException | SBPermissionException sql) {
                this.sbdb.doRollback();
                SbugsExceptionHandler.showStackError("Error", sql, this);
            }
            this.reInitTab(template);
        }
    }

    private void windowClosing(WindowEvent evt) {
        this.jMenuItemExitActionPerformed(null);
    }

    private void jMenuItemPanelTemplateDefaultActionPerformed(ActionEvent evt) {
        PanelTemplate template = null;
        Object o = this.jTreePanels.getSelectionPath().getLastPathComponent();
        if (o instanceof PanelTemplate) {
            template = (PanelTemplate)o;
        }
        if (template != null) {
            if (template.isDefaultTemplate()) {
                return;
            }
            try {
                PanelTemplate existingDefault = this.chartManager.setDefaultPanelTemplate(template);
                this.treeModel.fireTreeNodeChanged(template);
                if (existingDefault != null) {
                    this.treeModel.fireTreeNodeChanged(existingDefault);
                }
            }
            catch (SQLException | SBException | SBPermissionException e) {
                FrameJsbugs.showStackError("Error", (Exception)e, this.sbdb);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jMenuItemOpenProjectActionPerformed(ActionEvent evt) {
        try {
            DialogSelectProject dialog = new DialogSelectProject(this, true, this.sbdb, false, this.chartManager);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.selection != null) {
                Project proj = dialog.selection;
                this.setCursor(Cursor.getPredefinedCursor(3));
                LinkedList<ChartTemplateBase> bases = new LinkedList<ChartTemplateBase>();
                bases.addAll(this.chartManager.searchBlocks(null, null, proj.getID(), null, null, null));
                int nBlocks = bases.size();
                bases.addAll(this.chartManager.searchCharts(null, proj.getID()));
                if (bases.size() > 12 && JOptionPane.showConfirmDialog(this, "Warning: there are " + nBlocks + " blocks, and " + (bases.size() - nBlocks) + " charts in this project, are you sure you want to open it?", this.getTitle(), 0, 3) == 1) {
                    return;
                }
                this.openTemplates(bases);
            }
        }
        catch (SQLException | SBException e) {
            SbugsExceptionHandler.showStackError(e, this);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jMenuItemPanelUsagesActionPerformed(ActionEvent evt) {
        Object o = this.jTreePanels.getSelectionPath().getLastPathComponent();
        if (!(o instanceof PanelTemplate)) {
            return;
        }
        PanelTemplate template = (PanelTemplate)o;
        this.findPanelUsages(template);
    }

    private boolean isEditingAPropertyValue() {
        return this.getFocusOwner() instanceof JTextField && (this.getFocusOwner().getParent() instanceof PropertiesTable || this.getFocusOwner().getParent() != null && this.getFocusOwner().getParent().getParent() instanceof PropertiesTable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openCorrelationLineEditDialog() {
        CorrelationLine line = (CorrelationLine)this.jListCorrLines.getSelectedValue();
        if (line == null) {
            return;
        }
        Object o = this.jTreePanels.getLastSelectedPathComponent();
        if (!(o instanceof CorrelationTemplate)) {
            return;
        }
        CorrelationTemplate template = (CorrelationTemplate)o;
        DialogCorrelationLine dialog = new DialogCorrelationLine(this, line.getCorrelationType(), line.getObject(), line, true);
        dialog.setLocationRelativeTo(this.jListCorrLines);
        dialog.setVisible(true);
        if (dialog.isOK()) {
            CorrLineStyle style = dialog.getStyle();
            Object lineType = dialog.getSelectedType();
            try {
                if (template.updateCorrelationLine(line, lineType, style)) {
                    this.treeModel.fireTreeNodeChanged(o);
                    this.reInitTab(template);
                }
            }
            catch (RuntimeException re) {
                SbugsExceptionHandler.showStackError(re);
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    private void findPanelUsages(PanelTemplate template) {
        try {
            List<BlockTemplate> blocks = this.chartManager.searchBlocks(template.getID());
            if (blocks.isEmpty()) {
                JOptionPane.showMessageDialog(this, "This panel is not used in any blocks.", "Find Panel Usages", 1);
                return;
            }
            DialogChartTemplates dialog = new DialogChartTemplates(this, true, this.sbdb, this.chartManager, new LinkedList<ChartTemplateBase>(blocks));
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.selection != null) {
                this.openTemplates(dialog.selection);
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
    }

    private void findSimilarPanels(PanelTemplate templ) {
        try {
            List<PanelTemplate> list = this.chartManager.findSimilar(templ, null);
            if (list.isEmpty()) {
                JOptionPane.showMessageDialog(this, "No similar panel templates!", "Find Similar", 1);
                return;
            }
            DialogList.displayListDialog(this, "Similar to : " + templ.getName(), new UserPrefsHelper(this.sbdb), list, (ListCellRenderer)new RestrictableProjectListCellRenderer());
        }
        catch (SQLException | SBException sql) {
            SbugsExceptionHandler.showStackError(sql, this);
        }
    }

    public boolean checkPanelSave(PanelTemplate templ) throws SQLException {
        JScrollPaneChartTemplate scrollPane;
        if (!templ.isVisible()) {
            return true;
        }
        if (this.jCheckBoxCheckUpdatePanel.isSelected()) {
            return true;
        }
        List<BlockTemplate> blockTemplatesUsingPanel = this.chartManager.searchBlocks(templ.getID());
        if (blockTemplatesUsingPanel.isEmpty()) {
            return true;
        }
        if (blockTemplatesUsingPanel.size() == 1 && (scrollPane = (JScrollPaneChartTemplate)this.jTabbedPaneChart.getSelectedComponent()).getActiveBlock().getTemplate() == blockTemplatesUsingPanel.get(0)) {
            return true;
        }
        String msg = "This panel is used in " + blockTemplatesUsingPanel.size() + " saved block templates. Are you sure you want to edit it?";
        this.jLabelCheckUpdatePanel.setText(msg);
        this.updatePanels = null;
        this.jDialogCheckUpdatePanel.setLocationRelativeTo(this);
        this.jDialogCheckUpdatePanel.pack();
        this.jDialogCheckUpdatePanel.setVisible(true);
        boolean ret = Objects.equals(this.updatePanels, Boolean.TRUE);
        this.updatePanels = null;
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jMenuItemOpenLegacyActionPerformed(ActionEvent evt) {
        DialogLegacyCharts dialog = new DialogLegacyCharts((Frame)this, true, this.chartManager, this.sbdb);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.selection == null) {
            return;
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            LinkedList<Chart> charts = new LinkedList<Chart>();
            LinkedList<BlockTemplate> newBlockTemplates = new LinkedList<BlockTemplate>();
            for (LegacyChart leg : dialog.selection) {
                Object added = null;
                try {
                    this.jLabelProcess.setText("Processing chart: " + leg.name + "...");
                    added = this.chartManager.convertLegacyChart(leg, dialog.panelOption, dialog.convertToProjID);
                }
                catch (SBPermissionException pe) {
                    JOptionPane.showMessageDialog(this, pe.getMessage(), this.getTitle(), 2);
                }
                catch (InvalidFieldException ife) {
                    JOptionPane.showMessageDialog(this, ife.getMessage(), this.getTitle(), 2);
                    if (ife.resolution != null) {
                        added = ife.resolution;
                    }
                }
                catch (SQLException | SBException sql) {
                    FrameJsbugs.showStackError("Error", (Exception)sql, this.sbdb);
                }
                catch (RuntimeException re) {
                    StackError.showStackError((String)"", (Throwable)re);
                }
                if (added instanceof Chart) {
                    charts.add((Chart)added);
                    continue;
                }
                if (!(added instanceof BlockTemplate)) continue;
                newBlockTemplates.add((BlockTemplate)added);
            }
            try {
                for (Chart chart : charts) {
                    chart.getProperties().margin = 5.0f;
                    chart.getProperties().setPanelHeaderHeight(81.0f);
                    chart.getProperties().setPanelCaptionHeight(9.0f);
                    chart.setData();
                    chart.doLayout();
                    this.addTab(chart, null, false);
                    for (ChartBlockBase block : chart.getBlocks()) {
                        boolean found = false;
                        for (BlockTemplate t : newBlockTemplates) {
                            if (block.getTemplate() != t) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        newBlockTemplates.add(block.getTemplate());
                    }
                }
                for (BlockTemplate newBlockTemplate : newBlockTemplates) {
                    this.initBlockTemplateTab(newBlockTemplate, false);
                }
            }
            catch (IOException | SQLException | SBException sql) {
                FrameJsbugs.showStackError("SQL Error", (Exception)sql, this.sbdb);
            }
            catch (RuntimeException re) {
                StackError.showStackError((String)"", (Throwable)re);
            }
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
            this.jLabelProcess.setText(null);
        }
    }

    private void jButtonOpenActionPerformed(ActionEvent evt) {
        this.openTemplate();
    }

    private void jMenuItemChartDeleteActionPerformed(ActionEvent evt) {
        this.deleteTab();
    }

    private void jPopupMenuItemBlockCorrUsagesActionPerformed(ActionEvent evt) {
        Object o = this.jTreePanels.getSelectionPath().getLastPathComponent();
        if (o instanceof TemplateDescr) {
            this.searchUsages((TemplateDescr)o);
        }
    }

    private void searchUsages(TemplateDescr o) {
        int templID;
        if (o instanceof BlockTemplate) {
            templID = ((BlockTemplate)o).getID();
            if (templID == 0) {
                JOptionPane.showMessageDialog(this, "Template is not saved!", this.getTitle(), 2);
                return;
            }
        } else if (o instanceof BlockTemplateInfo) {
            templID = ((BlockTemplateInfo)o).getBlockID();
            if (templID == 0) {
                JOptionPane.showMessageDialog(this, "Template is not saved!", this.getTitle(), 2);
                return;
            }
        } else if (o instanceof CorrelationTemplate) {
            templID = ((CorrelationTemplate)o).getID();
        } else {
            return;
        }
        try {
            List<ChartTemplate> charts = this.chartManager.searchCharts(templID, o instanceof BlockTemplate || o instanceof BlockTemplateInfo);
            List<PanelTemplate> panels = null;
            if (o instanceof BlockTemplate) {
                panels = this.chartManager.searchPanels(templID);
            }
            if (charts.isEmpty() && (panels == null || panels.isEmpty())) {
                JOptionPane.showMessageDialog(this, "Not used in any charts" + (panels == null ? "." : " or panels."), "Find Usages", 1);
            } else {
                if (!charts.isEmpty()) {
                    DialogChartTemplates dialog = new DialogChartTemplates(this, true, this.sbdb, this.chartManager, new LinkedList<ChartTemplateBase>(charts));
                    dialog.setLocationRelativeTo(this);
                    dialog.setVisible(true);
                    if (dialog.selection != null) {
                        this.openTemplates(dialog.selection);
                    }
                }
                if (panels != null && !panels.isEmpty()) {
                    TableModelPanelTemplates model = new TableModelPanelTemplates(this.sbdb, this.chartManager);
                    model.setTemplates(panels);
                    DialogTable dialog = new DialogTable(this, true, (AbstractTableModel)model, "Panel Templates Using Block : " + String.valueOf(o), false);
                    model.setupTable(dialog.getTable());
                    dialog.setLocationRelativeTo(this.parent);
                    dialog.setVisible(true);
                }
            }
        }
        catch (SQLException | SBException sql) {
            FrameJsbugs.showStackError("Error", (Exception)sql, this.sbdb);
        }
    }

    private void searchTabs(final ChartTemplateBase templ) {
        try {
            final List<String[]> list = this.chartManager.getTabs(templ);
            if (list.isEmpty()) {
                JOptionPane.showMessageDialog(this, "No users have tabs open for this template.", this.getTitle(), 1);
                return;
            }
            final AbstractTableModel model = new AbstractTableModel(this){
                final /* synthetic */ FrameChart this$0;
                {
                    FrameChart frameChart = this$0;
                    Objects.requireNonNull(frameChart);
                    this.this$0 = frameChart;
                }

                @Override
                public int getRowCount() {
                    return list.size();
                }

                @Override
                public int getColumnCount() {
                    return 2;
                }

                @Override
                public Object getValueAt(int row, int column) {
                    return ((String[])list.get(row))[column];
                }
            };
            final DialogTable dialog = new DialogTable(this, true, model, "Open Tabs For Template : " + String.valueOf(templ), false);
            dialog.getTable().getColumnModel().getColumn(0).setHeaderValue(templ instanceof BlockTemplate && ((BlockTemplate)templ).getType() == BlockType.SCHEME ? "Location" : "Well");
            dialog.getTable().getColumnModel().getColumn(1).setHeaderValue("User");
            TableUtils.setTableHeaderBold((JTable)dialog.getTable());
            dialog.getTable().getTableHeader().setReorderingAllowed(false);
            if (!(templ instanceof BlockTemplate) || ((BlockTemplate)templ).getType() != BlockType.SCHEME) {
                JPopupMenu popup = new JPopupMenu();
                JMenuItem item = new JMenuItem("Remove selected tabs");
                item.addActionListener(new ActionListener(){
                    final /* synthetic */ FrameChart this$0;
                    {
                        FrameChart frameChart = this$0;
                        Objects.requireNonNull(frameChart);
                        this.this$0 = frameChart;
                    }

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int opt;
                        boolean warnedOtherUser = false;
                        if (dialog.getSelectedRows().length > 0 && (opt = JOptionPane.showConfirmDialog(this.this$0, "Really close these tabs?\nSettings for these tabs will be lost.", "Close tabs", 0)) != 0) {
                            return;
                        }
                        for (int i : dialog.getSelectedRows()) {
                            String[] info = (String[])list.get(i);
                            if (!info[1].equalsIgnoreCase(this.this$0.sbdb.getUser().getAbr())) {
                                if (warnedOtherUser) continue;
                                JOptionPane.showMessageDialog(this.this$0, "You can only remove your own tabs.", this.this$0.getTitle(), 2);
                                warnedOtherUser = true;
                                continue;
                            }
                            this.this$0.parent.samplesFrame.removeChartTemplateTab(templ, Integer.parseInt(info[2]));
                        }
                        list.clear();
                        try {
                            list.addAll(this.this$0.chartManager.getTabs(templ));
                        }
                        catch (SQLException sql) {
                            FrameJsbugs.showStackError("SQL Error", sql, this.this$0.sbdb);
                            dialog.dispose();
                        }
                        model.fireTableDataChanged();
                    }
                });
                popup.add(item);
                dialog.registerPopupMenu(popup);
                dialog.getTable().setSelectionMode(2);
            }
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void jMenuItemPanelManagerActionPerformed(ActionEvent evt) {
        DialogPanelTemplates dialog = new DialogPanelTemplates(this, true, this.sbdb, this.chartManager);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        TreePath path = this.jTreePanels.getSelectionPath();
        this.treeModel.fireTreeStructureChanged();
        this.jTreePanels.setSelectionPath(path);
        this.jTreePanels.expandPath(path);
    }

    private void jMenuItemBlockUsageActionPerformed(ActionEvent evt) {
        JScrollPaneChartTemplate scrollPane = (JScrollPaneChartTemplate)this.jTabbedPaneChart.getSelectedComponent();
        if (scrollPane.blockType == null) {
            JOptionPane.showMessageDialog(this, "Select a block template tab", "Block Usages", 2);
            return;
        }
        this.searchUsages(scrollPane.getChart().getBlockSingle().getTemplate());
    }

    private void jMenuItemPanelTemplatePermissionsActionPerformed(ActionEvent evt) {
        PanelTemplate template = null;
        Object o = this.jTreePanels.getSelectionPath().getLastPathComponent();
        if (o instanceof PanelTemplate) {
            template = (PanelTemplate)o;
        }
        if (template != null) {
            try {
                DialogPermissions dialog = new DialogPermissions(this, true, this.sbdb, (SBRestrictable)template, this.chartManager);
                dialog.setLocationRelativeTo(this);
                dialog.setVisible(true);
                if (dialog.isOK()) {
                    this.fireTreeNodeChanged(template);
                }
            }
            catch (SBException sbe) {
                JOptionPane.showMessageDialog(this, sbe.getMessage(), "Template Permissions", 2);
            }
            catch (SQLException sql) {
                FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
            }
        }
    }

    private void jMenuItemTemplatePermissionsActionPerformed(ActionEvent evt) {
        SBRestrictable template = null;
        Object o = this.jTreePanels.getSelectionPath().getLastPathComponent();
        if (o instanceof SBRestrictable) {
            template = (SBRestrictable)((Object)o);
        }
        if (template != null) {
            try {
                DialogPermissions dialog = new DialogPermissions(this, true, this.sbdb, template, this.chartManager);
                dialog.setLocationRelativeTo(this);
                dialog.setVisible(true);
            }
            catch (SBException sbe) {
                JOptionPane.showMessageDialog(this, sbe.getMessage(), "Correlation Permissions", 2);
            }
            catch (SQLException sql) {
                FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
            }
        }
    }

    private void jMenuItemChartPermissionsActionPerformed(ActionEvent evt) {
        JScrollPaneChartTemplate scrollPane = (JScrollPaneChartTemplate)this.jTabbedPaneChart.getSelectedComponent();
        ChartTemplateBase template = scrollPane.blockType != null ? scrollPane.getChart().getBlockSingle().getTemplate() : scrollPane.getChart().getTemplate();
        if (template != null) {
            if (template.getID() == 0) {
                int opt = JOptionPane.showConfirmDialog(this, "You must save the chart before setting permissions. Save now?", this.getTitle(), 0);
                if (opt == 0) {
                    this.saveTab(scrollPane);
                } else {
                    return;
                }
            }
            try {
                DialogPermissions dialog = new DialogPermissions(this, true, this.sbdb, (SBRestrictable)template, this.chartManager);
                dialog.setLocationRelativeTo(this);
                dialog.setVisible(true);
                if (dialog.isOK()) {
                    this.jTabbedPaneChartStateChanged(null);
                    this.jTabbedPaneChart.updateTitleAt(this.jTabbedPaneChart.getSelectedIndex());
                }
            }
            catch (SBException sbe) {
                JOptionPane.showMessageDialog(this, sbe.getMessage(), "Chart/block Permissions", 2);
            }
            catch (SQLException sql) {
                FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
            }
        }
    }

    private void jMenuItemCorrOccCreateTxGroupActionPerformed(ActionEvent evt) {
        Correlation c = (Correlation)this.jListCorrOcc.getSelectedValue();
        if (c == null || c.getCorrType() != CorrelationType.EVENT) {
            return;
        }
        this.createTaxonGroup(c.getLines());
    }

    private void jPopupMenuItemBlockCorrAddTxGroupActionPerformed(ActionEvent evt) {
        Object o = this.jTreePanels.getSelectionPath().getLastPathComponent();
        if (!(o instanceof CorrelationTemplate)) {
            return;
        }
        CorrelationTemplate templ = (CorrelationTemplate)o;
        assert (templ.getType() == CorrelationType.EVENT);
        this.createTaxonGroup(templ.getLineList());
    }

    private void jMenuItemPanelRestoreActionPerformed(ActionEvent evt) {
        Object o = this.jTreePanels.getSelectionPath().getLastPathComponent();
        if (!(o instanceof PanelTemplate)) {
            return;
        }
        PanelTemplate pTempl = (PanelTemplate)o;
        pTempl.restoreSavedProperties();
        this.fireTreeNodeChanged(pTempl);
    }

    private void jMenuItemHelpActionPerformed(ActionEvent evt) {
        HelpUtils.openHelp((String)"charts.html");
    }

    private void jMenuItemPanelHelpActionPerformed(ActionEvent evt) {
        Object o = this.jTreePanels.getSelectionPath().getLastPathComponent();
        PanelType panelType = null;
        if (o instanceof PanelTemplate) {
            panelType = ((PanelTemplate)o).getType();
        } else if (o instanceof PanelType) {
            panelType = (PanelType)o;
        }
        if (panelType == null) {
            return;
        }
        FrameJsbugs.openHelp(panelType.getHtml());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jMenuItemChartTabPopupPanelDepthSnapActionPerformed(ActionEvent evt) {
        JScrollPaneChartTemplate sPane = (JScrollPaneChartTemplate)this.jTabbedPaneChart.getSelectedComponent();
        if (sPane == null) {
            return;
        }
        try {
            ChartPanel cpanel = sPane.getSelectedPanel(sPane.chartPopupPoint);
            if (!(cpanel instanceof SBPanel)) {
                return;
            }
            SBPanel panel = (SBPanel)cpanel;
            Float topMD = panel.getDataBound(true);
            Float baseMD = panel.getDataBound(false);
            if (topMD == null && baseMD == null) {
                return;
            }
            ChartBlock block = panel.getBlock();
            try {
                block.setScaleLimits(topMD, baseMD);
                this.firePropertiesTableDataChanged();
                this.fireChartMightHaveChanged();
            }
            catch (InvalidFieldException ife) {
                JOptionPane.showMessageDialog(this, ife.getMessage(), this.getTitle(), 1);
            }
        }
        finally {
            sPane.chartPopupPoint = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jMenuItemChartTabPopupBlockDefaultDepthsActionPerformed(ActionEvent evt) {
        JScrollPaneChartTemplate sPane = (JScrollPaneChartTemplate)this.jTabbedPaneChart.getSelectedComponent();
        if (sPane == null) {
            return;
        }
        try {
            ChartBlockBase blockBase = sPane.getSelectedPanel(sPane.chartPopupPoint).getBlock();
            if (!(blockBase instanceof WellBlock) || blockBase.getWell() == null) {
                return;
            }
            WellBlock block = (WellBlock)blockBase;
            try {
                float[] bounds = ChartBlock.getDefaultDepthBounds(block.getWell(), block.getScale());
                block.setScaleLimits(Float.valueOf(bounds[0]), Float.valueOf(bounds[1]));
                this.firePropertiesTableDataChanged();
                this.fireChartMightHaveChanged();
            }
            catch (InvalidFieldException ife) {
                JOptionPane.showMessageDialog(this, ife.getMessage(), this.getTitle(), 1);
            }
            catch (SQLException e) {
                FrameJsbugs.showStackError("Error", e, this.sbdb);
            }
        }
        finally {
            sPane.chartPopupPoint = null;
        }
    }

    private void jMenuItemSaveAsActionPerformed(ActionEvent evt) {
        Chart chart;
        ChartBlockBase block;
        JScrollPaneChartTemplate sPane = (JScrollPaneChartTemplate)this.jTabbedPaneChart.getSelectedComponent();
        ChartTemplateBase orig = sPane.getTemplate();
        if (!(orig instanceof ChartTemplate) && (block = (chart = sPane.getChart()).getBlockSingle()) instanceof MapBlock) {
            JOptionPane.showMessageDialog(this, "This option is not available here.", "Charts", 1);
            return;
        }
        try {
            boolean detailsOK;
            ChartTemplateBase copiedTemplate = null;
            int targetProjectID = 0;
            do {
                DialogChartDesc dialog = new DialogChartDesc(this, "Template : Copy : " + orig.getName(), "Copy of " + orig.getName(), ("(Copied from " + orig.getName() + ") " + (orig.getComments() == null ? "" : orig.getComments())).trim(), true, false);
                dialog.restrictProjectToAny(orig.getProjID());
                dialog.setLocationRelativeTo(this);
                dialog.setVisible(true);
                if (!dialog.isOK()) {
                    return;
                }
                try {
                    targetProjectID = dialog.projID;
                    copiedTemplate = this.chartManager.copyTemplate(sPane.getTemplate(), dialog.name, dialog.comments, targetProjectID);
                    this.sbdb.commit();
                    detailsOK = true;
                }
                catch (InvalidFieldException e) {
                    JOptionPane.showMessageDialog(this, e.getMessage(), this.getTitle(), 2);
                    detailsOK = false;
                }
            } while (!detailsOK);
            Chart chart2 = sPane.getChart();
            if (copiedTemplate instanceof ChartTemplate) {
                chart2.setTemplate((ChartTemplate)copiedTemplate);
            } else {
                ChartBlockBase block2 = chart2.getBlockSingle();
                block2.setTemplate((BlockTemplate)copiedTemplate);
                if (block2 instanceof ChartBlock) {
                    ChartBlock chartBlock = (ChartBlock)block2;
                    for (SBPanel panel : chartBlock.getPanels()) {
                        if (panel.getTemplate().isVisible()) continue;
                        String descr = "Local to " + block2.getTemplate().getType().getShortDescr() + " block template [" + block2.getTemplate().getName() + "]";
                        PanelTemplate invisiblePanelCopy = this.chartManager.addPanelTemplate("", descr, targetProjectID, this.chartManager.getPanelTemplate(panel.getTemplateID()), false);
                        SBPanel replacePanel = chartBlock.replacePanel(panel, invisiblePanelCopy);
                        block2.notifyListeners();
                    }
                } else if (block2 instanceof MapBlock) {
                    return;
                }
            }
            this.setProject(copiedTemplate.getProjID());
            this.saveTab(sPane);
            this.jTabbedPaneChart.setTitleAt(this.jTabbedPaneChart.getSelectedIndex(), copiedTemplate.getName());
            this.jTabbedPaneChartStateChanged(null);
        }
        catch (SQLException e) {
            this.sbdb.doRollback();
            FrameJsbugs.showStackError("SQL Error", e, this.sbdb);
        }
        catch (SBException sbe) {
            this.sbdb.doRollback();
            StackError.showStackError((String)"Error", (Throwable)sbe);
        }
    }

    private void jMenuItemTabUsageActionPerformed(ActionEvent evt) {
        JScrollPaneChartTemplate scrollPane = (JScrollPaneChartTemplate)this.jTabbedPaneChart.getSelectedComponent();
        this.searchTabs(scrollPane.getTemplate());
    }

    private void jMenuItemBlockTabDecoupleActionPerformed(ActionEvent evt) {
        JScrollPaneChartTemplate scrollPane = (JScrollPaneChartTemplate)this.jTabbedPaneChart.getSelectedComponent();
        SBPanel panel = (SBPanel)scrollPane.getSelectedPanel(scrollPane.chartPopupPoint);
        ChartBlock activeBlock = (ChartBlock)scrollPane.getActiveBlock();
        BlockTemplate blockTemplate = activeBlock.getTemplate();
        try {
            String descr = "Local to " + blockTemplate.getType().getShortDescr() + " block template [" + blockTemplate.getName() + "]";
            PanelTemplate invisibleTemplate = this.chartManager.addPanelTemplate("", descr, this.getSelectedProjectID(), this.chartManager.getPanelTemplate(panel.getTemplateID()), false);
            SBPanel newPanel = activeBlock.replacePanel(panel, invisibleTemplate);
            activeBlock.notifyListeners();
            this.reInitTab(newPanel);
            this.fireChartMightHaveChanged();
        }
        catch (SQLException | SBException sql) {
            SbugsExceptionHandler.showStackError(sql, this);
        }
        scrollPane.chartPopupPoint = null;
    }

    private void jMenuItemBlockTabRecoupleToNewActionPerformed(ActionEvent evt) {
        this.recouplePanel(true, false);
    }

    private void jMenuItemBlockTabRecoupleToExistingActionPerformed(ActionEvent evt) {
        this.recouplePanel(false, false);
    }

    private void jButtonCheckUpdatePanelYesActionPerformed(ActionEvent evt) {
        this.updatePanels = true;
        this.jDialogCheckUpdatePanel.setVisible(false);
    }

    private void jButtonCheckUpdatePanelNoActionPerformed(ActionEvent evt) {
        this.updatePanels = false;
        this.jDialogCheckUpdatePanel.setVisible(false);
    }

    private void jMenuItemChartTabPopupBlockDepthActionPerformed(ActionEvent evt) {
        DialogChartBlockDepthRange dialog = new DialogChartBlockDepthRange(this, true, this.sbdb, this.getSelectedChart());
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.isOK()) {
            this.fireChartMightHaveChanged();
        }
    }

    private void jMenuItemBlockTabRecoupleSuggestActionPerformed(ActionEvent evt) {
        this.recouplePanel(false, true);
    }

    private void jMenuItemPanelSimilarActionPerformed(ActionEvent evt) {
        Object o = this.jTreePanels.getSelectionPath().getLastPathComponent();
        if (!(o instanceof PanelTemplate)) {
            return;
        }
        PanelTemplate template = (PanelTemplate)o;
        this.findSimilarPanels(template);
    }

    private void jMenuItemChartExportFileActionPerformed(ActionEvent evt) {
        this.exportChart();
    }

    private void jMenuItemChartTabPopupSelectBlockTemplateActionPerformed(ActionEvent evt) {
        JScrollPaneChartTemplate sPane = (JScrollPaneChartTemplate)this.jTabbedPaneChart.getSelectedComponent();
        if (sPane == null) {
            return;
        }
        try {
            ChartBlockBase block = sPane.getSelectedBlock(sPane.chartPopupPoint);
            List<BlockTemplate> availableBlocks = this.chartManager.getBlocks(block.getBlockType(), this.getSelectedProjectID(), true, new ChartManager.TemplateComparator(), false);
            DialogList<BlockTemplate> dialog = new DialogList<BlockTemplate>(this, true, "Select Block Template", null, availableBlocks, true, false, (ListCellRenderer)new RestrictableProjectListCellRenderer());
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.getSelection() == null) {
                return;
            }
            if (dialog.getSelection() == block.getTemplate()) {
                JOptionPane.showMessageDialog(this, "The block is already based on that template!", this.getTitle(), 1);
                return;
            }
            Object[] buttons = new String[]{"Change this block template only", "Change all blocks that use this template"};
            int opt = JOptionPane.showOptionDialog(this, "Apply new template to other blocks?", this.getTitle(), 1, 3, null, buttons, null);
            if (opt == -1) {
                return;
            }
            LinkedList<ChartBlockBase> blocksToChange = new LinkedList<ChartBlockBase>();
            if (opt == 0) {
                blocksToChange.add(block);
            } else {
                for (ChartBlock cb : sPane.getChart().getChartBlocks()) {
                    if (cb.getTemplate() != block.getTemplate()) continue;
                    blocksToChange.add(cb);
                }
            }
            BlockTemplate newTemplate = dialog.getSelection();
            ChartBlockBase toSelect = null;
            for (ChartBlockBase toChange : blocksToChange) {
                ChartTemplate.BlockOcc blockOcc = new ChartTemplate.BlockOcc(newTemplate.getID(), toChange.getWells().size() == 1 ? toChange.getWell().getID() : 0, toChange.getWellListID(), toChange.getInterpID(), toChange.getProperties(), toChange.getCaption());
                ChartBlockBase newBlock = ChartFactory.createBlock(this.sbdb, newTemplate, blockOcc);
                int index = sPane.getChart().getBlocks().indexOf(toChange);
                sPane.getChart().removeBlock(toChange);
                sPane.getChart().insertBlock(newBlock, index);
                if (toSelect != null) continue;
                toSelect = newBlock;
            }
            sPane.getChart().setData();
            sPane.refreshView();
            this.reInitTab(toSelect);
            this.fireChartMightHaveChanged();
        }
        catch (IOException | RuntimeException | SQLException | SBException e) {
            SbugsExceptionHandler.showStackError(e, this);
        }
    }

    private void jMenuItemChartRestoreActionPerformed(ActionEvent evt) {
        JScrollPaneChartTemplate sPane = (JScrollPaneChartTemplate)this.jTabbedPaneChart.getSelectedComponent();
        sPane.restoreFromTemplate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jMenuItemExportPanelActionPerformed(ActionEvent evt) {
        Object o = this.jTreePanels.getSelectionPath().getLastPathComponent();
        if (!(o instanceof PanelTemplate)) {
            return;
        }
        PanelTemplate template = (PanelTemplate)o;
        String defaultFileName = template.getName();
        String[] extensions = new String[]{"sbg"};
        String[] descriptions = new String[]{"StrataBugs XML/SBG"};
        File file = FileChooserUtils.chooseFileToWrite((SBdb)this.sbdb, (Component)this, (String)"WINFILE", (String)"UNXFILE", (String[])extensions, (String[])descriptions, (String)defaultFileName);
        if (file == null) {
            return;
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            SBdb ws = new SBdb(this.sbdb);
            ChartManager wsCM = new ChartManager(ws);
            ChartManager.copyToWs(this.chartManager, wsCM, template);
            SbugsIO.saveSBGfile(this.sbdb, wsCM, null, file, this, null, false);
        }
        catch (SBPermissionException pe) {
            JOptionPane.showMessageDialog(this, pe.getMessage(), this.getTitle(), 2);
        }
        catch (SQLException | SBException sql) {
            FrameJsbugs.showStackError("Error", (Exception)sql, this.sbdb);
        }
        catch (IOException fnf) {
            StackError.showStackError((String)"Error writing file", (Throwable)fnf);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jToggleButtonMagnifierActionPerformed(ActionEvent evt) {
        JScrollPaneChartTemplate scrollPane = this.jTabbedPaneChart.getSelectedScrollPaneChart();
        if (scrollPane == null) {
            return;
        }
        if (this.jToggleButtonMagnifier.isSelected()) {
            scrollPane.initMagnifier();
        } else {
            scrollPane.decommissionMagnifier();
        }
    }

    private void jMenuItemBlockTabSelectPanelTemplateActionPerformed(ActionEvent evt) {
        JScrollPaneChartTemplate sPane = (JScrollPaneChartTemplate)this.jTabbedPaneChart.getSelectedComponent();
        if (sPane == null) {
            return;
        }
        SBPanel panel = (SBPanel)sPane.getSelectedPanel(sPane.chartPopupPoint);
        try {
            if (panel == null || !this.chartManager.getPanelTemplate(panel.getTemplateID()).isVisible()) {
                return;
            }
            PanelTemplate templ = this.chartManager.getPanelTemplate(panel.getTemplateID());
            List<PanelTemplate> availablePanels = this.chartManager.getPanels(templ.getType(), this.getSelectedProjectID(), true, new ChartManager.TemplateComparator());
            DialogList<PanelTemplate> dialog = new DialogList<PanelTemplate>(this, true, "Select Panel Template", null, availablePanels, true, false, (ListCellRenderer)new RestrictableProjectListCellRenderer());
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.getSelection() == null) {
                return;
            }
            if (dialog.getSelection() == templ) {
                JOptionPane.showMessageDialog(this, "The panel is already based on that template!", this.getTitle(), 1);
                return;
            }
            PanelTemplate newTemplate = dialog.getSelection();
            ChartBlock block = panel.getBlock();
            int index = block.getPanels().indexOf(panel);
            block.removePanel(panel);
            PanelOcc oldOcc = panel.getPanelOcc();
            SBPanel newPanel = (SBPanel)PanelFactory.createPanel(block, newTemplate, new PanelOcc(newTemplate.getID(), oldOcc.getInterpID(), oldOcc.getCaption(), oldOcc.getSubCaption(), oldOcc.getCapOrient(), oldOcc.getSchID()));
            block.addPanelAt(index, newPanel);
            sPane.getChart().setData();
            sPane.refreshView();
            this.reInitTab(newPanel);
            this.fireChartMightHaveChanged();
            this.checkClearOverridesForPanel(index);
        }
        catch (IOException | RuntimeException | SQLException | SBException e) {
            SbugsExceptionHandler.showStackError(e, this);
        }
    }

    private void jToggleButtonXHairsActionPerformed(ActionEvent evt) {
        JScrollPaneChartBase scrollPane = (JScrollPaneChartBase)this.jTabbedPaneChart.getSelectedComponent();
        if (scrollPane == null) {
            return;
        }
        scrollPane.setXHairs(this.jToggleButtonXHairs.isSelected());
    }

    private void jMenuItemChartTabPopupReorganiseWellBlocksActionPerformed(ActionEvent evt) {
        JScrollPaneChartBase sPane = (JScrollPaneChartBase)this.jTabbedPaneChart.getSelectedComponent();
        Chart chart = sPane.getChart();
        if (chart.getBlocks().size() < 2) {
            return;
        }
        Object choice = JOptionPane.showInputDialog(this, "Choose order:", "Re-Order Well Blocks", -1, null, (Object[])WellBlockOrder.values(), null);
        if (choice == null) {
            return;
        }
        if (chart.organiseBlocks((WellBlockOrder)((Object)choice))) {
            try {
                chart.setData();
                sPane.refreshView();
                this.fireChartMightHaveChanged();
            }
            catch (IOException | SQLException | SBException e) {
                FrameJsbugs.showStackError("Error", (Exception)e, this.sbdb);
            }
            catch (RuntimeException re) {
                StackError.showStackError((String)"", (Throwable)re);
            }
        }
    }

    private void jButtonExportChartBitmapActionPerformed(ActionEvent evt) {
        this.exportChartImage(false);
    }

    private void jCheckBoxMenuItemViewGlobalActionPerformed(ActionEvent evt) {
        if (this.treeModel.setShowGlobal(this.jCheckBoxMenuItemViewGlobal.isSelected())) {
            TreePath path = this.jTreePanels.getSelectionPath();
            this.treeModel.fireTreeStructureChanged();
            this.jTreePanels.setSelectionPath(path);
            this.jTreePanels.expandPath(path);
        }
    }

    private void jRadioButtonMenuItemModActionPerformed(ActionEvent evt) {
        this.setTreeSort(ChartManager.TemplateComparator.Sort.MODIFIED);
    }

    private void jRadioButtonMenuItemAlphaActionPerformed(ActionEvent evt) {
        this.setTreeSort(ChartManager.TemplateComparator.Sort.ALPHA);
    }

    private void jMenuItemCloseAllTabsActionPerformed(ActionEvent evt) {
        this.closeAllTabs(-1);
    }

    private void jPopupMenuItemTemplateOverridesActionPerformed(ActionEvent evt) {
        BlockTemplateParent template = null;
        Object o = this.jTreePanels.getSelectionPath().getLastPathComponent();
        if (o instanceof BlockTemplateInfo) {
            o = this.chartManager.getBlockTemplateFromInfo((BlockTemplateInfo)o);
        }
        if (o instanceof BlockTemplateParent) {
            template = (BlockTemplateParent)o;
        }
        this.openOverridesDialog(template);
    }

    private void openOverridesDialog(BlockTemplate template) {
        if (template != null && template instanceof BlockTemplateParent) {
            BlockTemplateParent parentTemplate = (BlockTemplateParent)template;
            if (parentTemplate.getChildWellIDs().isEmpty()) {
                JOptionPane.showMessageDialog(this, "There are no wells which override panels in this block template.", "Block Template Overrides", 1);
                return;
            }
            try {
                DialogTemplateChildren dialog = new DialogTemplateChildren(this, parentTemplate);
                dialog.setLocationRelativeTo(this);
                dialog.setVisible(true);
            }
            catch (SQLException | SBException sql) {
                SbugsExceptionHandler.showDialogStackError(sql, this);
            }
        }
    }

    private void jMenuItemOverridesActionPerformed(ActionEvent evt) {
        JScrollPaneChartTemplate scrollPane = (JScrollPaneChartTemplate)this.jTabbedPaneChart.getSelectedComponent();
        if (scrollPane.blockType == null) {
            JOptionPane.showMessageDialog(this, "Open a block template", "Block Template Overrides", 2);
            return;
        }
        BlockTemplate template = scrollPane.getChart().getBlockSingle().getTemplate();
        this.openOverridesDialog(template);
    }

    private void jPopupMenuItemBlockTemplateTabsActionPerformed(ActionEvent evt) {
        Object o = this.jTreePanels.getSelectionPath().getLastPathComponent();
        if (o instanceof BlockTemplateInfo) {
            o = this.chartManager.getBlockTemplateFromInfo((BlockTemplateInfo)o);
        }
        if (o instanceof BlockTemplate) {
            this.searchTabs((BlockTemplate)o);
        }
    }

    private void jMenuItemChartTabPopupPanelPropertiesActionPerformed(ActionEvent evt) {
        JScrollPaneChartTemplate scrollPane = (JScrollPaneChartTemplate)this.jTabbedPaneChart.getSelectedComponent();
        if (scrollPane == null) {
            return;
        }
        ChartPanel cpanel = scrollPane.getSelectedPanel(scrollPane.chartPopupPoint);
        if (cpanel == null || !(cpanel instanceof SBPanel)) {
            return;
        }
        SBPanel panel = (SBPanel)cpanel;
        try {
            PanelTemplate template = panel.getTemplate();
            if (panel instanceof PanelBiozones) {
                JOptionPane.showMessageDialog(this, "You cannot override biozone panels.", "Biozones Panel Properties", 2);
                return;
            }
            if (panel.getProperties() == template.getProperties()) {
                panel.setProperties(panel.getProperties().copy());
                panel.doPropertyChangeNotify();
                if (panel instanceof PanelTaxonGroup) {
                    panel.setExpectingUrgentChange();
                    panel.doDataChangeNotify();
                }
            }
            panel.setPanelOccSelected(true);
            scrollPane.repaint();
            DialogPanelProperties dialog = new DialogPanelProperties(this, true, this.sbdb, null, panel);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            panel.setPanelOccSelected(false);
            panel.doPropertyChangeNotify();
            if (panel.getProperties().equals(template.getProperties())) {
                panel.setProperties(template.getProperties());
                if (panel instanceof PanelTaxonGroup) {
                    panel.setExpectingUrgentChange();
                    panel.doDataChangeNotify();
                }
                return;
            }
            this.fireChartMightHaveChanged();
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void jMenuItemChartTabPopupOverrideToTemplateActionPerformed(ActionEvent evt) {
        JScrollPaneChartTemplate scrollPane = (JScrollPaneChartTemplate)this.jTabbedPaneChart.getSelectedComponent();
        if (scrollPane == null) {
            return;
        }
        ChartPanel cpanel = scrollPane.getSelectedPanel(scrollPane.chartPopupPoint);
        if (cpanel == null || !(cpanel instanceof SBPanel)) {
            return;
        }
        ChartBlock block = (ChartBlock)cpanel.getBlock();
        if (block.getTemplate().getParentID() == null) {
            return;
        }
        String dialogTitle = "Save As New Block Template";
        try {
            boolean detailsOK;
            int opt;
            BlockTemplate origParent = this.chartManager.getBlockTemplate(block.getTemplate().getParentID());
            String msg = "Warning: your override of '" + origParent.getName() + "' for " + block.getWell().getWellName() + " will be lost!";
            if (!scrollPane.isSaved) {
                msg = msg + "\nChanges to this chart will be saved.";
            }
            if ((opt = JOptionPane.showConfirmDialog(this, msg, dialogTitle, 2, 2)) != 0) {
                return;
            }
            ChartTemplateBase copiedTemplate = null;
            Object newTemplateName = origParent.getName();
            newTemplateName = this.project != null ? (String)newTemplateName + " : " + this.project.getName() : block.getWell().getWellName() + " copy of " + (String)newTemplateName;
            do {
                DialogChartDesc dialog = new DialogChartDesc(this.parent, dialogTitle, (String)newTemplateName, ("(Copied from " + origParent.getName() + ") " + (origParent.getComments() == null ? "" : origParent.getComments())).trim(), true, false);
                dialog.restrictProjectToWell(block.getWell(), true, this.getSelectedProjectID());
                dialog.setLocationRelativeTo(this);
                dialog.setVisible(true);
                if (!dialog.isOK()) {
                    return;
                }
                try {
                    copiedTemplate = this.chartManager.copyTemplate(origParent, dialog.name, dialog.comments, dialog.projID);
                    this.sbdb.commit();
                    detailsOK = true;
                }
                catch (InvalidFieldException e) {
                    JOptionPane.showMessageDialog(this, e.getMessage(), this.parent.getTitle(), 2);
                    detailsOK = false;
                }
            } while (!detailsOK);
            this.chartManager.updateBlockTemplate(block);
            block.setTemplate((BlockTemplate)copiedTemplate);
            for (SBPanel panel : block.getPanels()) {
                if (panel.getTemplate().isVisible()) continue;
                String descr = "Local to " + block.getTemplate().getType().getShortDescr() + " block template [" + copiedTemplate.getName() + "]";
                PanelTemplate invisiblePanelCopy = this.chartManager.addPanelTemplate("", descr, 0, this.chartManager.getPanelTemplate(panel.getTemplateID()), false);
                block.replacePanel(panel, invisiblePanelCopy);
                panel.setData(scrollPane.getChart().getProperties(), null);
            }
            block.updateTemplate(this.sbdb, false);
            this.sbdb.commit();
            TreePath path = this.treeModel.getPath(copiedTemplate);
            this.treeModel.fireTreeStructureChanged();
            this.jTreePanels.setSelectionPath(path);
            this.jTreePanels.expandPath(path);
            this.saveTab(scrollPane);
            this.chartManager.deleteBlockChild((BlockTemplateParent)origParent, block.getWell().getWellID());
            this.sbdb.commit();
        }
        catch (IOException | SQLException | SBException sql) {
            this.sbdb.doRollback();
            FrameJsbugs.showStackError("Error", (Exception)sql, this.sbdb);
        }
        catch (SBPermissionException pe) {
            this.sbdb.doRollback();
            throw new RuntimeException(pe);
        }
    }

    private void jMenuItemBlockListActionPerformed(ActionEvent evt) {
        JScrollPaneChartTemplate spChart = (JScrollPaneChartTemplate)this.jTabbedPaneChart.getSelectedComponent();
        if (spChart.view.chart.getTemplate() == null) {
            JOptionPane.showMessageDialog(this, "Can't open the block list for a block template.");
            return;
        }
        DialogBlockList dialog = new DialogBlockList(this, true);
        dialog.updateBlockList();
        dialog.setLocationRelativeTo(this);
        dialog.pack();
        dialog.setVisible(true);
        this.reInitTab(spChart.getSelectedChartObject());
    }

    public void setSelectedChartChanged() {
        JScrollPaneChartTemplate temp = (JScrollPaneChartTemplate)this.jTabbedPaneChart.getSelectedComponent();
        temp.isSaved = false;
        this.jTabbedPaneChart.updateTitleAt(this.jTabbedPaneChart.indexOfComponent(temp));
        this.repaint();
    }

    private void jRadioButtonMenuItemShowA4ActionPerformed(ActionEvent evt) {
        this.updatePageOutline();
    }

    private void jRadioButtonMenuItemNoOutlineActionPerformed(ActionEvent evt) {
        this.updatePageOutline();
    }

    private void jRadioButtonMenuItemShowA5ActionPerformed(ActionEvent evt) {
        this.updatePageOutline();
    }

    private void jRadioButtonMenuItemCustomOutlineActionPerformed(ActionEvent evt) {
        this.updatePageOutline();
    }

    /*
     * WARNING - void declaration
     */
    private void jMenuItemChartExportKMLActionPerformed(ActionEvent evt) {
        JScrollPaneChartTemplate sPane = (JScrollPaneChartTemplate)this.jTabbedPaneChart.getSelectedComponent();
        if (sPane == null) {
            return;
        }
        if (sPane.blockType != null) {
            JOptionPane.showMessageDialog(this, "You can only export a chart.", this.getTitle(), 1);
            return;
        }
        int nWellBlocks = 0;
        for (ChartBlockBase b : sPane.getChart().getBlocks()) {
            WellBlock wb;
            if (!(b instanceof WellBlock) || (wb = (WellBlock)b).getWell().getHeader().getLat_dec() == null || wb.getWell().getHeader().getLong_dec() == null) continue;
            ++nWellBlocks;
        }
        if (nWellBlocks < 3) {
            JOptionPane.showMessageDialog(this, "You can only export a file with 2 or more wells which have coordinates assigned.", this.getTitle(), 1);
            return;
        }
        JFileChooser jFileChooser1 = new JFileChooser();
        SbugsFileFilter filter = new SbugsFileFilter();
        filter.addExtension("kml");
        filter.setDescription("KML files");
        jFileChooser1.setFileFilter((FileFilter)filter);
        jFileChooser1.setAcceptAllFileFilterUsed(false);
        File setDir = null;
        try {
            setDir = new File(Lastval.getString(this.sbdb, "WINKMLFILE", "UNXKMLFILE"));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (setDir == null || setDir.getParent() == null || !setDir.getParentFile().exists()) {
            setDir = new File(".");
        }
        try {
            jFileChooser1.setCurrentDirectory(setDir);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (0 == jFileChooser1.showSaveDialog(this)) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                String fileName = jFileChooser1.getSelectedFile().getName();
                String fileType = fileName.substring(fileName.lastIndexOf(46) + 1).toLowerCase().trim();
                Object filePath = jFileChooser1.getSelectedFile().getPath();
                if (!fileType.toLowerCase().equals("kml")) {
                    filePath = (String)filePath + ".kml";
                }
                File file = new File((String)filePath);
                int insertPoint = -1;
                LinkedList<Object> kmlBuff = new LinkedList<Object>();
                if (file.exists()) {
                    Object[] options = new String[]{"Add to file", "Overwrite", "Cancel"};
                    int opt = JOptionPane.showOptionDialog(this, "File exists, do you want to overwrite file, or add new line to file?", this.getTitle(), -1, 3, null, options, options[0]);
                    if (opt == -1 || opt == 2) {
                        return;
                    }
                    if (opt == 0) {
                        try (BufferedReader in = new BufferedReader(new FileReader((String)filePath));){
                            Object buff;
                            boolean bl = false;
                            while ((buff = in.readLine()) != null) {
                                void var17_26;
                                kmlBuff.add(buff);
                                if (((String)buff).contains("</Document>")) {
                                    insertPoint = var17_26;
                                }
                                ++var17_26;
                            }
                        }
                        catch (Exception ex) {
                            StackError.showStackError((String)"Error during file write: ", (Throwable)ex);
                        }
                    }
                }
                try (BufferedWriter out = new BufferedWriter(new FileWriter((String)filePath, false));){
                    String eol = "\r\n";
                    if (insertPoint < 0) {
                        out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + eol + "<kml xmlns=\"http://www.opengis.net/kml/2.2\">" + eol + "<Document>" + eol);
                    } else {
                        int lineNumber = 0;
                        for (String string : kmlBuff) {
                            out.write(string + eol);
                            if (++lineNumber != insertPoint) continue;
                            break;
                        }
                    }
                    out.write("\t<Placemark>" + eol + "\t<name>" + sPane.getChart().getTemplate().getName() + "</name>" + eol + "\t\t<LineString>" + eol + "\t\t<tessellate>1</tessellate>" + eol + "\t\t<coordinates>" + eol);
                    for (ChartBlockBase b : sPane.getChart().getBlocks()) {
                        WellBlock wellBlock;
                        if (!(b instanceof WellBlock) || (wellBlock = (WellBlock)b).getWell().getHeader().getLat_dec() == null || wellBlock.getWell().getHeader().getLong_dec() == null) continue;
                        out.write("\t\t\t" + wellBlock.getWell().getHeader().getLong_dec() + "," + wellBlock.getWell().getHeader().getLat_dec() + eol);
                    }
                    out.write("\t\t</coordinates>" + eol + "\t\t</LineString>" + eol);
                    Color lineColour = JColorChooser.showDialog(this, "Select Colour", Color.BLACK);
                    out.write("\t\t<Style>" + eol + "\t\t\t<LineStyle>" + eol + "\t\t\t<color>" + String.format("#%02x%02x%02x%02x", lineColour.getAlpha(), lineColour.getBlue(), lineColour.getGreen(), lineColour.getRed()) + "</color>" + eol + "\t\t\t<colorMode>normal</colorMode>" + eol + "\t\t\t<width>4</width>" + eol + "\t\t\t</LineStyle>" + eol + "\t\t</Style>" + eol);
                    out.write("\t</Placemark>" + eol);
                    if (insertPoint < 0) {
                        out.write("</Document>" + eol + "</kml>" + eol);
                    } else {
                        int lineNumber = insertPoint;
                        while (lineNumber < kmlBuff.size()) {
                            out.write((String)kmlBuff.get(lineNumber++) + eol);
                        }
                    }
                }
                JOptionPane.showMessageDialog(this, "File written.", this.getTitle(), 1);
            }
            catch (Exception ex) {
                StackError.showStackError((String)"Error during file write: ", (Throwable)ex);
            }
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jMenuItemChartTabPopupEditBlockActionPerformed(ActionEvent evt) {
        JScrollPaneChartTemplate scrollPane = (JScrollPaneChartTemplate)this.jTabbedPaneChart.getSelectedComponent();
        scrollPane.view.chart.getSelectedBlock().ifPresent(block -> {
            try {
                if (block instanceof WellBlock && block.hasLocalChanges() && !block.getTemplate().hasEditingPanels()) {
                    JOptionPane.showMessageDialog(this, "There are unsaved panel overrides in this block. Save or discard to continue.", this.jMenuItemChartTabPopupEditBlock.getText(), 2);
                    return;
                }
                if (block.getTemplate().getParentID() != null) {
                    this.openTemplate(block.getTemplate());
                } else {
                    scrollPane.setMode(block.getBlockType());
                }
            }
            catch (SQLException | SBException e) {
                SbugsExceptionHandler.showStackError("Error getting template editing panels: ", e);
                return;
            }
        });
    }

    private void jButtonStartMapBlockActionPerformed(ActionEvent evt) {
        this.createAndOpenNewBlockTemplate(BlockType.MAP);
    }

    private void jButtonStartRecent1ActionPerformed(ActionEvent evt) {
    }

    private void jMenuItemTagListActionPerformed(ActionEvent evt) {
        JScrollPaneChartTemplate spChart = (JScrollPaneChartTemplate)this.jTabbedPaneChart.getSelectedComponent();
        if (spChart.view.chart.getTemplate() == null) {
            JOptionPane.showMessageDialog(this, "Can't open the annotation list for a block template.");
            return;
        }
        if (spChart.getChart().getTags().isEmpty()) {
            JOptionPane.showMessageDialog(this, "This chart has no annotations.\nYou can add annotations by right-clicking on the chart.", "No annotations", 1);
            return;
        }
        DialogChartTagList dlg = new DialogChartTagList(this, true, spChart.getChart());
        dlg.setLocationRelativeTo(this);
        dlg.pack();
        dlg.setVisible(true);
    }

    private void jMenuItemChartTabPopupNewTagActionPerformed(ActionEvent evt) {
        JScrollPaneChartTemplate spChart = (JScrollPaneChartTemplate)this.jTabbedPaneChart.getSelectedComponent();
        if (spChart == null) {
            return;
        }
        if (spChart.view.chart.getTemplate() == null) {
            JOptionPane.showMessageDialog(this, "You cannot add annotations to a block template.");
            return;
        }
        String result = JOptionPaneUtils.showEditTextDialog("Annotation text");
        if (result == null) {
            return;
        }
        Point2D.Float mmPoint = spChart.view.getPoint(spChart.chartPopupPoint);
        Rectangle2D.Float tagRect = new Rectangle2D.Float(mmPoint.x, mmPoint.y, 50.0f, 30.0f);
        ChartBlockBase blockForTag = spChart.getSelectedBlock(spChart.chartPopupPoint);
        int order = spChart.view.chart.getTags().size();
        ChartTag newTag = new ChartTag(blockForTag, order, tagRect, null, null, null, null, null, result, ChartProperties.FontSizeExtended.PANEL);
        spChart.view.chart.addTag(newTag);
        spChart.view.chart.onChartEvent(ChartEvent.createSoftChangeChartEvent(null));
        this.fireChartMightHaveChanged();
        this.reInitTab((Object)newTag);
    }

    private void jMenuItemChartTabPopupBringTagToFrontActionPerformed(ActionEvent evt) {
        JScrollPaneChartTemplate sPane = (JScrollPaneChartTemplate)this.jTabbedPaneChart.getSelectedComponent();
        if (sPane == null) {
            return;
        }
        Object o = sPane.view.getObject(sPane.chartPopupPoint);
        if (o instanceof ChartTag) {
            sPane.view.chart.bringChartTagToFront((ChartTag)((Object)o));
            this.fireChartMightHaveChanged();
        }
    }

    private void jMenuItemChartTabPopupSendTagToBackActionPerformed(ActionEvent evt) {
        JScrollPaneChartTemplate sPane = (JScrollPaneChartTemplate)this.jTabbedPaneChart.getSelectedComponent();
        if (sPane == null) {
            return;
        }
        Object o = sPane.view.getObject(sPane.chartPopupPoint);
        if (o instanceof ChartTag) {
            sPane.view.chart.sendChartTagToBack((ChartTag)((Object)o));
            this.fireChartMightHaveChanged();
        }
    }

    private void jMenuItemRemoveLayerActionPerformed(ActionEvent evt) {
        ((JScrollPaneChartTemplate)this.jTabbedPaneChart.getSelectedComponent()).removeSelectedChartElement();
    }

    private void jMenuItemLayerUpActionPerformed(ActionEvent evt) {
        if (!this.isEditingAPropertyValue()) {
            ((JScrollPaneChartTemplate)this.jTabbedPaneChart.getSelectedComponent()).moveSelectedChartElement(true);
        }
    }

    private void jMenuItemLayerDownActionPerformed(ActionEvent evt) {
        if (!this.isEditingAPropertyValue()) {
            ((JScrollPaneChartTemplate)this.jTabbedPaneChart.getSelectedComponent()).moveSelectedChartElement(false);
        }
    }

    private void jMenuItemExportToShapefileActionPerformed(ActionEvent evt) {
        this.exportShapefile();
    }

    private void jMenuItemBlockNewMapActionPerformed(ActionEvent evt) {
        this.createAndOpenNewBlockTemplate(BlockType.MAP);
    }

    private void jMenuItemChartTabPopupDiscardOverridesActionPerformed(ActionEvent evt) {
        JScrollPaneChartTemplate scrollPane = (JScrollPaneChartTemplate)this.jTabbedPaneChart.getSelectedComponent();
        if (scrollPane == null) {
            return;
        }
        ChartBlockBase b = scrollPane.getSelectedBlock(scrollPane.chartPopupPoint);
        if (b == null || !(b instanceof ChartBlock)) {
            return;
        }
        ChartBlock block = (ChartBlock)b;
        try {
            block.clearLocalChanges();
            block.notifyListeners();
            this.fireChartMightHaveChanged();
        }
        catch (RuntimeException re) {
            SbugsExceptionHandler.showStackError(re, this);
        }
    }

    private void jMenuItemShapeStoresActionPerformed(ActionEvent evt) {
        try {
            DialogSBShapeStores dialog = new DialogSBShapeStores(this, true, this.chartManager.getShapeStoreService());
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }
        catch (SQLException e) {
            SbugsExceptionHandler.showStackError(e, this);
        }
    }

    private void updatePageOutline() {
        if (this.jRadioButtonMenuItemNoOutline.isSelected()) {
            this.outlinePf = null;
        } else if (this.jRadioButtonMenuItemCustomOutline.isSelected()) {
            PrinterJob pj = PrinterJob.getPrinterJob();
            if (this.outlinePf == null) {
                PageFormat defaultFormat = pj.defaultPage();
                Paper defaultPaper = defaultFormat.getPaper();
                defaultPaper.setImageableArea(0.0, 0.0, defaultPaper.getWidth(), defaultPaper.getHeight());
                defaultFormat.setPaper(defaultPaper);
                this.outlinePf = defaultFormat;
            }
            this.outlinePf = pj.pageDialog(this.outlinePf);
        } else {
            Paper p = new Paper();
            if (this.jRadioButtonMenuItemShowA4.isSelected()) {
                p.setSize(595.2755905511812, 841.8897637795276);
            } else {
                p.setSize(419.5275590551181, 595.2755905511812);
            }
            p.setImageableArea(0.0, 0.0, p.getWidth(), p.getHeight());
            PageFormat pf = new PageFormat();
            pf.setPaper(p);
            pf.setOrientation(0);
            this.outlinePf = pf;
        }
        int count = this.jTabbedPaneChart.getTabCount();
        for (int i = 0; i < count; ++i) {
            Component c = this.jTabbedPaneChart.getComponentAt(i);
            if (!(c instanceof JScrollPaneChartTemplate)) continue;
            JScrollPaneChartTemplate panel = (JScrollPaneChartTemplate)c;
            if (panel.view == null || panel.view.chart == null || panel.view.chart.getTemplate() == null) continue;
            panel.view.setPf(this.outlinePf);
            panel.view.setPageFit(ChartJPanel.PageFit.SINGLE);
            panel.repaint();
        }
    }

    private void closeAllTabs(int excludedIndex) {
        this.jTabbedPaneChart.closeAllTabs(excludedIndex);
        if (this.jTabbedPaneChart.getTabCount() == 0 && excludedIndex < 0) {
            try {
                this.chartManager.deleteOrphanedInvisiblePanels();
                this.sbdb.commit();
            }
            catch (SQLException sql) {
                this.sbdb.doRollback();
                FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
            }
            catch (SBException | SBPermissionException sql) {
                FrameJsbugs.showStackError("SQL Error", (Exception)sql, this.sbdb);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void recouplePanel(boolean toNew, boolean suggest) {
        JScrollPaneChartTemplate scrollPane = (JScrollPaneChartTemplate)this.jTabbedPaneChart.getSelectedComponent();
        SBPanel panel = (SBPanel)scrollPane.getSelectedPanel(scrollPane.chartPopupPoint);
        try {
            PanelTemplate coupledTemplate;
            PanelTemplate invisibleTemplate = this.chartManager.getPanelTemplate(panel.getTemplateID());
            if (invisibleTemplate.isVisible()) {
                throw new IllegalStateException("Attempt to recouple coupled panel!");
            }
            if (toNew) {
                String name = this.getNewTemplateName(invisibleTemplate.getType(), this.getSelectedProjectID());
                if (name == null) return;
                coupledTemplate = this.addPanelTemplate(invisibleTemplate, name);
            } else {
                List<PanelTemplate> panels;
                if (suggest) {
                    panels = this.chartManager.findSimilar(invisibleTemplate, (Integer)this.getSelectedProjectID());
                    if (panels.isEmpty()) {
                        JOptionPane.showMessageDialog(this, "No similar panels!", "Recouple panel", 1);
                        return;
                    }
                } else {
                    panels = this.chartManager.getPanels(invisibleTemplate.getType(), this.getSelectedProjectID(), true, new ChartManager.TemplateComparator());
                }
                DialogList<PanelTemplate> dialog = new DialogList<PanelTemplate>(this, true, "Select Panel Template", null, panels, true, false, (ListCellRenderer)new RestrictableProjectListCellRenderer());
                dialog.setLocationRelativeTo(this);
                dialog.setVisible(true);
                if (dialog.getSelection() == null) {
                    return;
                }
                int opt = JOptionPane.showConfirmDialog(this, "Settings for this panel will be lost. Do you want to continue?", this.getTitle(), 0);
                if (opt != 0) {
                    return;
                }
                coupledTemplate = dialog.getSelection();
            }
            int panelIndex = scrollPane.getChart().getChartBlockSingle().getPanels().indexOf(panel);
            SBPanel newPanel = scrollPane.getChart().getChartBlockSingle().replacePanel(panel, coupledTemplate);
            this.sbdb.commit();
            scrollPane.getChart().getBlockSingle().notifyListeners();
            this.reInitTab(newPanel);
            scrollPane.refreshView();
            this.fireChartMightHaveChanged();
            this.checkClearOverridesForPanel(panelIndex);
            return;
        }
        catch (RuntimeException | SQLException | SBException e) {
            SbugsExceptionHandler.showStackError("SQL Error", e);
        }
    }

    private void checkClearOverridesForPanel(int panelIndex) {
        BlockTemplateParent parentBlock;
        Set<Integer> overridingWellIDs;
        JScrollPaneChartTemplate scrollPane = (JScrollPaneChartTemplate)this.jTabbedPaneChart.getSelectedComponent();
        BlockTemplate template = scrollPane.getChart().getChartBlockSingle().getTemplate();
        if (template instanceof BlockTemplateParent && !(overridingWellIDs = (parentBlock = (BlockTemplateParent)template).getOverridingWellIDsForPanel(panelIndex)).isEmpty()) {
            Object[] options;
            String message = "This panel has overrides for " + overridingWellIDs.size() + " well" + (overridingWellIDs.size() > 1 ? "s" : "") + ".\nDo you want to delete these overrides? (This block will be saved first.)";
            int opt = JOptionPane.showOptionDialog(this, message, "Panel Overrides", 0, 3, null, options = new String[]{"Yes, save and delete overrides", "No", "Show overrides dialog"}, null);
            if (opt == 0) {
                this.saveTab(scrollPane);
                overridingWellIDs = parentBlock.getOverridingWellIDsForPanel(panelIndex);
                for (int wellID : overridingWellIDs) {
                    try {
                        this.chartManager.resetBlockChildPanel(parentBlock, wellID, panelIndex);
                        this.sbdb.commit();
                    }
                    catch (RuntimeException | SQLException | SBException | SBPermissionException e) {
                        SbugsExceptionHandler.showStackError("Error deleting override for well " + wellID + " at panel index " + panelIndex, e);
                    }
                }
            } else if (opt == 2) {
                this.jMenuItemOverridesActionPerformed(null);
            }
        }
    }

    private void createTaxonGroup(Collection<CorrelationLine> corrLines) {
        if (!SBRestrictable.canWrite(this.sbdb)) {
            JOptionPane.showMessageDialog(this, SBRestrictable.getDeniedReason(false), this.getTitle(), 2);
            return;
        }
        HashSet<Taxon> taxa = new HashSet<Taxon>();
        for (CorrelationLine line : corrLines) {
            Object o = line.getObject();
            if (!(o instanceof SBEvent) || ((SBEvent)o).getTaxon() == null) continue;
            taxa.add(((SBEvent)o).getTaxon());
        }
        if (taxa.isEmpty()) {
            JOptionPane.showMessageDialog(this, "No taxa found", this.getTitle(), 1);
            return;
        }
        try {
            DialogSelectGroup dialog = new DialogSelectGroup(this, true, this.sbdb, null, true, false);
            dialog.setLocationRelativeTo(this.jPanelCorrOcc);
            dialog.setVisible(true);
            if (dialog.selection != null) {
                int opt;
                TxGroup group = dialog.selection;
                if (!group.canWrite(this.sbdb, null)) {
                    JOptionPane.showMessageDialog(this, group.getDeniedReason(this.sbdb, "add taxa", "group", false), this.getTitle(), 2);
                    return;
                }
                int initialSize = group.getSize();
                if (initialSize > 0 && (opt = JOptionPane.showConfirmDialog(this, "Really add " + taxa.size() + " taxa to this group,\nwhich already contains " + initialSize + " taxa?", this.getTitle(), 0)) != 0) {
                    return;
                }
                group.addTaxa(new ArrayList<Taxon>(taxa));
                int newSize = group.getSize();
                if (initialSize == newSize) {
                    JOptionPane.showMessageDialog(this, "All taxa were already in the group!", this.getTitle(), 1);
                } else {
                    assert (newSize > initialSize);
                    JOptionPane.showMessageDialog(this, newSize - initialSize + " taxa added.", this.getTitle(), 1);
                }
                this.sbdb.commit();
            }
        }
        catch (SQLException | SBPermissionException sql) {
            this.sbdb.doRollback();
            FrameJsbugs.showStackError("Error", (Exception)sql, this.sbdb);
        }
    }

    private void setTreeSort(ChartManager.TemplateComparator.Sort sort) {
        this.treeModel.setComparatorSort(sort);
        TreePath path = this.jTreePanels.getSelectionPath();
        this.treeModel.fireTreeStructureChanged();
        this.jTreePanels.setSelectionPath(path);
        this.jTreePanels.expandPath(path);
    }

    private void deleteTab() {
        String msg3;
        int opt3;
        Set<Integer> childWellIDs;
        JScrollPaneChartTemplate sPane = (JScrollPaneChartTemplate)this.jTabbedPaneChart.getSelectedComponent();
        if (sPane == null) {
            return;
        }
        ChartTemplateBase template = sPane.blockType == null ? sPane.getChart().getTemplate() : sPane.getChart().getBlockSingle().getTemplate();
        String msg = "Really delete '" + template.getName() + "'?";
        int opt = JOptionPane.showConfirmDialog(this, msg, this.getTitle(), 0);
        if (opt != 0) {
            return;
        }
        if (template.getID() == 0) {
            this.jTabbedPaneChart.closeTabAt(this.jTabbedPaneChart.indexOfComponent(sPane), false);
            return;
        }
        try {
            String msg2;
            int opt2;
            Point p = this.chartManager.isChartOpen(template);
            if (p != null && p.x > 0 && (opt2 = JOptionPane.showConfirmDialog(this, msg2 = "<html><strong>" + p.x + " users have this template open for " + p.y + " wells.</strong></html>\nIf you delete this template then all users will lose their chart tabs and settings.\nAre you sure you want to continue?", "Delete Template", 0)) != 0) {
                return;
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
            return;
        }
        if (template instanceof BlockTemplateParent && !(childWellIDs = ((BlockTemplateParent)template).getChildWellIDs()).isEmpty() && (opt3 = JOptionPane.showConfirmDialog(this, msg3 = "This template has panels overridden in " + childWellIDs.size() + " well" + (childWellIDs.size() > 1 ? "s" : "") + ".\nAre you sure you want to continue?", "Delete Template", 0)) != 0) {
            return;
        }
        sPane.isSaved = true;
        try {
            this.chartManager.deleteTemplate(template);
            this.sbdb.commit();
        }
        catch (SBPermissionException pe) {
            JOptionPane.showMessageDialog(this, pe.getMessage(), this.getTitle(), 2);
        }
        catch (SBException sbe) {
            JOptionPane.showMessageDialog(this, sbe.getMessage(), this.getTitle(), 2);
            if (template instanceof BlockTemplate) {
                this.searchUsages((BlockTemplate)template);
            }
        }
        catch (SQLException sql) {
            this.sbdb.doRollback();
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
        if (this.jTabbedPaneChart.getTabCount() == 0) {
            this.initStartPane(false);
        }
    }

    private void printChart() {
        JScrollPaneChartTemplate scrollPane = (JScrollPaneChartTemplate)this.jTabbedPaneChart.getSelectedComponent();
        if (scrollPane == null) {
            return;
        }
        if (scrollPane.blockType != null) {
            JOptionPane.showMessageDialog(this, "You can't print a block template.", this.getTitle(), 2);
            return;
        }
        Object selected = scrollPane.getSelectedChartObject();
        SelectedObject selection = this.getSelectedObject(scrollPane.getSelectedChartObject());
        this.reInitChartComponents(this.getSelectedObject(null));
        ChartExporter.printChart(scrollPane.getChart(), this, this.sbdb, SbugsLicense.isDemoLicense());
        if (selected != null) {
            this.reInitChartComponents(selection);
        }
    }

    private void exportShapefile() {
        JScrollPaneChartTemplate scrollPane = (JScrollPaneChartTemplate)this.jTabbedPaneChart.getSelectedComponent();
        if (scrollPane == null) {
            JOptionPane.showMessageDialog(this, "No chart selected.", this.getTitle(), 2);
            return;
        }
        if (scrollPane.blockType != null) {
            JOptionPane.showMessageDialog(this, "You can't export from a block template.", this.getTitle(), 2);
            return;
        }
        Object selected = scrollPane.getSelectedChartObject();
        SelectedObject selection = this.getSelectedObject(scrollPane.getSelectedChartObject());
        this.reInitChartComponents(SelectedObject.nullSelection());
        try {
            Chart c = scrollPane.getChart();
            ChartExporter.saveShapefileData(this, this.sbdb, c);
        }
        catch (Exception sbe) {
            StackError.showStackError((String)"Error", (Throwable)sbe);
        }
        if (selected != null) {
            this.reInitChartComponents(selection);
        }
    }

    private void exportChartImage(boolean vector) {
        JScrollPaneChartTemplate scrollPane = (JScrollPaneChartTemplate)this.jTabbedPaneChart.getSelectedComponent();
        if (scrollPane == null) {
            return;
        }
        if (scrollPane.blockType != null) {
            JOptionPane.showMessageDialog(this, "You can't print a block template.", this.getTitle(), 2);
            return;
        }
        Object selected = scrollPane.getSelectedChartObject();
        SelectedObject selection = this.getSelectedObject(scrollPane.getSelectedChartObject());
        this.reInitChartComponents(SelectedObject.nullSelection());
        try {
            ChartExporter.saveChart(scrollPane.getChart(), null, vector, this, this.sbdb, SbugsLicense.isDemoLicense());
        }
        catch (SBException sbe) {
            StackError.showStackError((String)"Error", (Throwable)sbe);
        }
        if (selected != null) {
            this.reInitChartComponents(selection);
        }
    }

    private void editCorrelation() {
        Object o = this.jListCorrOcc.getSelectedValue();
        if (o == null) {
            return;
        }
        Correlation correlation = (Correlation)o;
        if (correlation.getTemplateID() == 0) {
            JOptionPane.showMessageDialog((Component)this.hint, "You can't edit a standard correlation.\nCreate a correlation template to make changes.");
            return;
        }
        try {
            this.reInitTab(this.chartManager.getCorrTemplate(correlation.getTemplateID()));
        }
        catch (SQLException sql) {
            SbugsExceptionHandler.showStackError(sql, this);
        }
    }

    private String getNewTemplateName(TemplateType type, int projID) {
        String name = null;
        do {
            if ((name = JOptionPane.showInputDialog(this, "Enter name: ", "New " + type.getNoun() + " Template", 1)) == null) {
                return null;
            }
            if ((name = name.trim()).isEmpty()) {
                JOptionPane.showMessageDialog(this, "You must enter a name!", "New " + type.getNoun() + " Template", 2);
                name = null;
                continue;
            }
            try {
                if (this.chartManager.checkNewTemplateName(name, type, projID)) continue;
                JOptionPane.showMessageDialog(this, "That name is in use.", "New " + type.getNoun() + " Template", 2);
                name = null;
            }
            catch (SQLException sql) {
                SbugsExceptionHandler.showStackError("SQL Error", sql, this);
                return null;
            }
        } while (name == null);
        return name;
    }

    private PanelTemplate addPanelTemplate(Object o, String name) {
        try {
            PanelTemplate template;
            if (o instanceof PanelType) {
                PanelType type = (PanelType)o;
                SBRestrictable scheme = null;
                if (PanelType.requiresScheme(type)) {
                    List<SBRestrictable> list;
                    String noType = "schemes";
                    switch (type) {
                        case SURFACE: 
                        case SEQUENCE: {
                            list = this.sbdb.getIGDSchemes(DataType.SEQUENCE);
                            break;
                        }
                        case CHRONOSCHEME: 
                        case LITHOSCHEME: 
                        case BIOSCHEME: {
                            list = this.sbdb.getIGDSchemes(PanelType.getDataType(type));
                            break;
                        }
                        case CMPSTD: 
                        case RANGE: {
                            list = this.sbdb.getCompositeStandards();
                            noType = "composite standards";
                            break;
                        }
                        case MAGNETOSCHEME: {
                            list = new LinkedList<IGDScheme>(this.sbdb.getMagnetoSchemes());
                            break;
                        }
                        case AGECURVE: {
                            list = new LinkedList<AgeCurve>(this.sbdb.getAgeCurves());
                            noType = "age curves";
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Not catered for requiresScheme");
                        }
                    }
                    if (list.isEmpty()) {
                        JOptionPane.showMessageDialog(this, "There are no suitable " + noType + " to use for this panel!", "Create Panel Template", 1);
                        return null;
                    }
                    Collections.sort(list);
                    DialogList<SBRestrictable> schemeListDialog = new DialogList<SBRestrictable>(this, true, "Select Scheme", null, list, true, false);
                    schemeListDialog.setLocationRelativeTo(this);
                    schemeListDialog.setVisible(true);
                    if (schemeListDialog.getSelection() == null) {
                        return null;
                    }
                    scheme = schemeListDialog.getSelection();
                }
                template = this.chartManager.addPanelTemplate((PanelType)o, name, null, this.getSelectedProjectID(), null, (Object)scheme, true);
            } else if (o instanceof PanelTemplate) {
                template = this.chartManager.addPanelTemplate(name, null, this.getSelectedProjectID(), (PanelTemplate)o, true);
            } else {
                return null;
            }
            this.treeModel.fireTreeStructureChanged();
            this.reInitTab(template);
            return template;
        }
        catch (SQLException | SBException | SBPermissionException e) {
            SbugsExceptionHandler.showStackError("Error", e, this);
            return null;
        }
    }

    private CorrelationTemplate addCorrelationTemplate(CorrelationType type, String descr, String comments, int projID) {
        try {
            if (!this.chartManager.checkNewTemplateName(descr, type, projID)) {
                JOptionPane.showMessageDialog(this, "That name is in use.", "New Correlation Template", 2);
                descr = this.getNewTemplateName(type, projID);
                if (descr == null) {
                    return null;
                }
            }
            CorrelationTemplate template = this.chartManager.addCorrTemplate(type, descr, comments, projID);
            this.treeModel.fireTreeStructureChanged();
            this.jTreePanels.setSelectionPath(this.treeModel.getPath(template));
            return template;
        }
        catch (InvalidFieldException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), this.getTitle(), 2);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
        return null;
    }

    private boolean saveTab(JScrollPaneChartTemplate scrollPane) {
        block18: {
            if (scrollPane == null) {
                return true;
            }
            try {
                if (scrollPane.blockType != null) {
                    final ChartBlockBase block = scrollPane.getActiveBlock();
                    if (block.getTemplate().getID() == 0) {
                        block.updateTemplate(this.sbdb, true);
                        this.chartManager.addBlockTemplate(block.getTemplate());
                    } else {
                        if (block.hasBeenRefreshed()) {
                            int opt = this.getOverwriteOption();
                            if (opt == 2) {
                                return false;
                            }
                            if (opt == 1) {
                                block.update((Observable)((Object)block.getTemplate()), null);
                                return true;
                            }
                        }
                        try {
                            block.updateTemplate(this.sbdb, false);
                            this.chartManager.deleteRedundantBlockChildren((BlockTemplateParent)block.getTemplate());
                        }
                        catch (BlockTemplateChildException ex) {
                            String title = "Error Saving Template";
                            String msg = "This template has a corrupted override for well '" + String.valueOf(this.sbdb.getWell(ex.getWellID())) + "'.\nThe override template may have been edited by a user with an older version of StrataBugs.\nYou cannot save changes unless you delete the override.\nDo you want to do this?";
                            int opt = JOptionPane.showConfirmDialog(this, msg, title, 0, 0);
                            if (opt == 0) {
                                this.chartManager.deleteBlockChild((BlockTemplateParent)block.getTemplate(), ex.getWellID());
                                JOptionPane.showMessageDialog(this, "Override deleted.", title, 1);
                            }
                            return false;
                        }
                    }
                    this.sbdb.commit();
                    SwingWorker notifyTask = new SwingWorker(this){
                        {
                            Objects.requireNonNull(this$0);
                        }

                        protected Object doInBackground() {
                            block.getTemplate().notifyObservers();
                            return null;
                        }
                    };
                    notifyTask.execute();
                    if (scrollPane.getChart().getTemplate() != null) {
                        scrollPane.setMode(null);
                    }
                    break block18;
                }
                Chart chart = scrollPane.getChart();
                if (chart.getTemplate().getID() == 0) {
                    for (ChartBlockBase block : chart.getBlocks()) {
                        if (block.getTemplate().getID() != 0) continue;
                        JOptionPane.showMessageDialog(this, "You must save blocks first.", "Save Chart", 2);
                        return false;
                    }
                    this.chartManager.addChartTemplate(chart.getTemplate());
                    this.sbdb.commit();
                }
                for (ChartBlockBase b : chart.getBlocks()) {
                    String msg;
                    int opt;
                    ChartBlock block;
                    if (!(b instanceof ChartBlock) || !(block = (ChartBlock)b).hasLocalChanges() || block.getTemplate().getParentID() != null || (opt = JOptionPane.showConfirmDialog(this, msg = "You are about to save panel properties override for '" + block.getWell().getWellName() + "' only.\nAre you sure you want to do this instead of editing the block template?", "Save Chart", 0)) == 0) continue;
                    return false;
                }
                this.chartManager.updateChartTemplate(chart);
                this.sbdb.commit();
            }
            catch (InvalidFieldException sbe) {
                JOptionPane.showMessageDialog(this, sbe.getMessage(), this.getTitle(), 2);
                if (this.editTemplate(scrollPane)) {
                    return this.saveTab(scrollPane);
                }
                return false;
            }
            catch (IOException | SQLException | SBException | SBPermissionException e) {
                this.sbdb.doRollback();
                SbugsExceptionHandler.showStackError(e);
                return false;
            }
        }
        scrollPane.isSaved = true;
        this.jTabbedPaneChart.updateTitleAt(this.jTabbedPaneChart.getSelectedIndex());
        this.reInitDetailsPane();
        return true;
    }

    private void saveSelection() {
        JScrollPaneChartTemplate scrollPane = (JScrollPaneChartTemplate)this.jTabbedPaneChart.getSelectedComponent();
        this.saveTab(scrollPane);
    }

    private void editTemplate() {
        JScrollPaneChartTemplate scrollPane = (JScrollPaneChartTemplate)this.jTabbedPaneChart.getSelectedComponent();
        this.editTemplate(scrollPane);
    }

    private boolean editTemplate(JScrollPaneChartTemplate scrollPane) {
        DialogChartDesc dialog;
        ChartTemplateBase templ;
        boolean requiresSave = false;
        if (scrollPane.blockType != null) {
            templ = scrollPane.getActiveBlock().getTemplate();
            scrollPane.getActiveBlock().members().toList();
            for (ChartPanel panel : scrollPane.getActiveBlock().members().toList()) {
                PanelTemplate pTempl = panel.getTemplate();
                if (pTempl.isVisible() || !pTempl.isEditing()) continue;
                requiresSave = true;
                break;
            }
        } else {
            templ = scrollPane.getChart().getTemplate();
            requiresSave = !scrollPane.getChart().equalsTemplate();
        }
        try {
            String typeTitle = templ instanceof ChartTemplate ? "Chart" : "Template";
            dialog = new DialogChartDesc(this, typeTitle + " : Edit : " + templ.getName(), (TemplateDescr)templ, templ.canWrite(this.sbdb, null), templ instanceof ChartTemplate);
            dialog.restrictProjectToAny(this.getSelectedProjectID());
            dialog.setWellList(templ.getWellListID());
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (!dialog.isOK()) {
                return false;
            }
        }
        catch (SQLException sqle) {
            SbugsExceptionHandler.showStackError(sqle, this);
            return false;
        }
        if (dialog.projID != templ.getProjID() && dialog.projID > 0 && requiresSave) {
            int opt = JOptionPane.showConfirmDialog(this, "You must save the chart before changing the project. Save now?", this.getTitle(), 0);
            if (opt == 0) {
                this.saveTab(scrollPane);
            } else {
                return false;
            }
        }
        try {
            templ.updateDescr(this.sbdb, dialog.name, dialog.comments, dialog.projID, dialog.wellListID);
            if (templ instanceof BlockTemplate) {
                this.chartManager.updateBlockTemplateInfo(((BlockTemplate)templ).getID(), dialog.name, dialog.comments, dialog.projID);
            }
            this.sbdb.commit();
            this.setProject(templ.getProjID());
            return true;
        }
        catch (InvalidFieldException ife) {
            this.sbdb.doRollback();
            JOptionPane.showMessageDialog(this, ife.getMessage(), "Update Template", 2);
            this.editTemplate(scrollPane);
        }
        catch (SQLException | SBException | SBPermissionException sql) {
            this.sbdb.doRollback();
            SbugsExceptionHandler.showDialogStackError(sql, this);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
        return false;
    }

    private BlockTemplate createNewBlockTemplate(BlockType type) {
        DialogChartDesc dialog = new DialogChartDesc(this, "Template : Add : " + String.valueOf(type), "New " + String.valueOf(type), null, true, false);
        try {
            dialog.restrictProjectToAny(this.getSelectedProjectID());
        }
        catch (SQLException sql) {
            SbugsExceptionHandler.showStackError("SQL loading projects", sql);
            return null;
        }
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (!dialog.isOK()) {
            return null;
        }
        try {
            if (!this.chartManager.checkNewTemplateName(dialog.name, type, dialog.projID)) {
                JOptionPane.showMessageDialog(this, "That name is in use.", "New Template", 2);
                dialog.name = this.getNewTemplateName(type, dialog.projID);
                if (dialog.name == null) {
                    return null;
                }
            }
        }
        catch (SQLException sql) {
            SbugsExceptionHandler.showStackError("SQL error checking name", sql);
            return null;
        }
        return TemplateFactory.newBlockTemplate(this.chartManager, type, dialog.name, dialog.comments, dialog.projID);
    }

    private void createAndOpenNewBlockTemplate(BlockType type) {
        BlockTemplate template;
        if (this.hint != null) {
            this.hint.closeBalloon();
            this.hint = null;
        }
        if ((template = this.createNewBlockTemplate(type)) == null) {
            return;
        }
        this.initBlockTemplateTab(template, true);
        if (template.getType() == BlockType.WELL && this.parent.showHints() && this.jTabbedPaneChart.getTabCount() == 1) {
            this.startPanelHintSequence();
        }
    }

    private void createAndAddNewBlockTemplate(BlockType type) {
        if (type != BlockType.MAP) {
            this.createAndOpenNewBlockTemplate(type);
            return;
        }
        Chart chart = this.getSelectedChart();
        if (chart == null) {
            return;
        }
        BlockTemplate blockTemplate = this.createNewBlockTemplate(type);
        if (blockTemplate == null) {
            return;
        }
        try {
            this.chartManager.addBlockTemplate(blockTemplate);
            this.sbdb.commit();
            this.treeModel.fireTreeStructureChanged();
            this.jTreePanels.setSelectionPath(this.treeModel.getPath(blockTemplate));
        }
        catch (SQLException | InvalidFieldException | SBException e) {
            SbugsExceptionHandler.showStackError("Error storing new block template", e, this);
            return;
        }
        int opt = JOptionPane.showConfirmDialog(this, "Do you want to add this block to the chart?", "Add Block", 0);
        if (opt != 0) {
            return;
        }
        int wellListID = 0;
        int wellID = 0;
        WellList defaultWellList = chart.getTemplate() != null && chart.getTemplate().getWellListID() > 0 ? (WellList)this.sbdb.getWellListService().getWellList(chart.getTemplate().getWellListID()) : null;
        DialogChartBlockImport dialog = new DialogChartBlockImport(this, true, this.sbdb, blockTemplate.getType(), this.project, defaultWellList, blockTemplate.getType() == BlockType.WELL);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (!dialog.isOK()) {
            return;
        }
        Object o = dialog.getObject();
        if (o instanceof WellList) {
            WellList wellList = (WellList)((Object)o);
            wellListID = wellList.getID();
        } else if (o instanceof List) {
            List list = (List)o;
            wellID = ((Well)list.get(0)).getID();
        }
        ChartTemplate.BlockOcc blockOcc = new ChartTemplate.BlockOcc(blockTemplate.getID(), wellID, wellListID, 0, null, null);
        try {
            ChartBlockBase block = ChartFactory.createBlock(this.sbdb, blockTemplate, blockOcc);
            chart.addBlock(block);
            chart.setSelectedBlock(block);
            this.fireChartMightHaveChanged();
            this.reInitTab(block);
        }
        catch (SQLException | SBException e) {
            SbugsExceptionHandler.showStackError(e);
        }
    }

    private void openTemplate() {
        DialogChartTemplates dialog = new DialogChartTemplates((Frame)this, true, this.sbdb, this.chartManager);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.selection != null) {
            this.openTemplates(dialog.selection);
        }
    }

    private int getSelectedProjectID() {
        if (this.project == null) {
            return 0;
        }
        return this.project.getID();
    }

    void openTemplate(ChartTemplateBase template) {
        if (template instanceof BlockTemplate && ((BlockTemplate)template).getParentID() != null) {
            try {
                template = this.chartManager.getBlockTemplate(((BlockTemplate)template).getParentID());
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
        }
        if (this.jTabbedPaneChart.selectTemplate(template)) {
            return;
        }
        if (template instanceof BlockTemplate) {
            BlockTemplate bTemplate = (BlockTemplate)template;
            if (bTemplate.getParentID() != null) {
                try {
                    template = this.chartManager.getBlockTemplate(bTemplate.getParentID());
                }
                catch (SQLException ex) {
                    SbugsExceptionHandler.showStackError("Error loading parent template", ex, this);
                }
            }
            this.initBlockTemplateTab((BlockTemplate)template, true);
        } else if (template instanceof ChartTemplate) {
            ChartTemplate cTemplate = (ChartTemplate)template;
            this.initChartTemplateTab(cTemplate, true);
        }
    }

    private JScrollPaneChartTemplate initBlockTemplateTab(BlockTemplate template, boolean selectTab) {
        try {
            ChartBlockBase block = ChartFactory.createBlock(this.sbdb, template);
            Chart chart = new Chart();
            chart.getProperties().margin = 5.0f;
            chart.getProperties().setPanelHeaderHeight(75.0f);
            chart.getProperties().setPanelCaptionHeight(9.0f);
            chart.getProperties().setTemplateColourScheme();
            chart.getProperties().plotBlockCaptions = false;
            chart.getProperties().hideAdjacentBlankPanels = false;
            chart.addBlock(block);
            chart.setData();
            return this.addTab(chart, template.getType(), selectTab);
        }
        catch (UnknownPanelTypeException ex) {
            Logger.getLogger(FrameChart.class.getName()).log(Level.WARNING, "Unknown panel type exception while opening block template, template {0}, panel type {1}", new Object[]{template.getName(), ex.getPanelTypeString()});
            JOptionPane.showMessageDialog(this, "The block " + template.getName() + " contains an unknown panel type " + ex.getPanelTypeString() + " and can't be opened. \r\n\r\nThis problem usually occurrs when attempting to open a block with an older version of Stratabugs than the one used to create it. \r\nPlease try updating to the latest version of StrataBugs. If the problem persists please contact StrataBugs support.", "Problem opening block template", 2);
        }
        catch (WellHeader.MissingWellException e) {
            JOptionPane.showMessageDialog(this, "The block " + template.getName() + " contains a reference to a well which you do not have access to.\n" + e.getMessage(), "Problem opening block template", 2);
        }
        catch (IGDScheme.MissingSchemeException e) {
            JOptionPane.showMessageDialog(this, "The block " + template.getName() + " contains a reference to a scheme which you do not have access to.\n" + e.getMessage(), "Problem opening block template", 2);
        }
        catch (IOException | RuntimeException | SQLException | SBException e) {
            SbugsExceptionHandler.showStackError("Error setting panel data", e, this);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JScrollPaneChartTemplate initChartTemplateTab(ChartTemplate templ, final boolean selectTab) {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            final Chart chart = ChartFactory.createChart(templ, this.sbdb, this.chartManager);
            chart.setData();
            class JScrollPaneChartWrapper {
                private JScrollPaneChartTemplate jspc;

                JScrollPaneChartWrapper(FrameChart this$0) {
                    Objects.requireNonNull(this$0);
                }

                public void set(JScrollPaneChartTemplate j) {
                    this.jspc = j;
                }

                public JScrollPaneChartTemplate get() {
                    return this.jspc;
                }
            }
            final JScrollPaneChartWrapper wrapper = new JScrollPaneChartWrapper(this);
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeAndWait(new Runnable(){
                    final /* synthetic */ FrameChart this$0;
                    {
                        FrameChart frameChart = this$0;
                        Objects.requireNonNull(frameChart);
                        this.this$0 = frameChart;
                    }

                    @Override
                    public void run() {
                        wrapper.set(this.this$0.addTab(chart, null, selectTab));
                    }
                });
            } else {
                this.addTab(chart, null, selectTab);
            }
            JScrollPaneChartTemplate jScrollPaneChartTemplate = wrapper.get();
            return jScrollPaneChartTemplate;
        }
        catch (UnknownPanelTypeException ex) {
            Logger.getLogger(FrameChart.class.getName()).log(Level.WARNING, "Unknown panel type exception while opening chart template, template {0}, panel type {1}", new Object[]{templ.getName(), ex.getPanelTypeString()});
            JOptionPane.showMessageDialog(this, "The chart " + templ.getName() + " contains an unknown panel type " + ex.getPanelTypeString() + " and can't be opened. \r\n\r\nThis problem usually occurs when attempting to open a chart with an older version of StrataBugs than the one used to create it. \r\nPlease try updating to the latest version of StrataBugs. If the problem persists please contact StrataBugs support.", "Problem opening chart template", 2);
        }
        catch (WellHeader.MissingWellException e) {
            JOptionPane.showMessageDialog(this, "The chart " + templ.getName() + " contains a reference to a well which you do not have access to.\n" + e.getMessage(), "Problem opening chart template", 2);
        }
        catch (IGDScheme.MissingSchemeException e) {
            JOptionPane.showMessageDialog(this, "The chart " + templ.getName() + " contains a reference to a scheme which you do not have access to.\n" + e.getMessage(), "Problem opening chart template", 2);
        }
        catch (IOException | InterruptedException | RuntimeException | InvocationTargetException | SQLException | SBException e) {
            SbugsExceptionHandler.showStackError("Error setting panel data", e, this);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
        return null;
    }

    private void createNewChart() {
        DialogChartDesc dialog = new DialogChartDesc(this, "New Named Chart", "New Named Chart", null, true, true);
        try {
            int wellListID;
            dialog.restrictProjectToAny(this.getSelectedProjectID());
            if (this.getSelectedProjectID() > 0 && (wellListID = Lastval.getInt(this.sbdb, "CHTWELLST", 0)) > 0) {
                dialog.setWellList(wellListID);
            }
        }
        catch (SQLException ex) {
            SbugsExceptionHandler.showStackError("Error selecting project", ex, this);
        }
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (!dialog.isOK()) {
            return;
        }
        ChartProperties cp = ChartPropertiesFactory.newDecodedInstance(this.sbdb);
        try {
            ChartTemplate template = new ChartTemplate(this.chartManager, 0, dialog.name, dialog.comments, dialog.projID, dialog.wellListID, cp.getProperties(), 0, cp.getHeader(), cp.getKey(), null, 0);
            this.initChartTemplateTab(template, true);
            if (dialog.wellListID > 0) {
                Lastval.putInt(this.sbdb, "CHTWELLST", dialog.wellListID);
                this.sbdb.commit();
            }
        }
        catch (RuntimeException ex) {
            SbugsExceptionHandler.showStackError(ex);
        }
        catch (SQLException ex) {
            this.sbdb.doRollback();
            SbugsExceptionHandler.showStackError(ex);
        }
    }

    void openTemplates(final List<ChartTemplateBase> list) {
        if (list.isEmpty()) {
            return;
        }
        SwingWorker<Void, ChartTemplateBase> worker = new SwingWorker<Void, ChartTemplateBase>(this){
            private JScrollPaneChartTemplate lastAdded;
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
                this.lastAdded = null;
            }

            @Override
            protected Void doInBackground() throws Exception {
                for (ChartTemplateBase template : list) {
                    this.publish(template);
                    if (template instanceof ChartTemplate) {
                        this.lastAdded = this.this$0.initChartTemplateTab((ChartTemplate)template, false);
                        continue;
                    }
                    if (!(template instanceof BlockTemplate)) continue;
                    this.lastAdded = this.this$0.initBlockTemplateTab((BlockTemplate)template, false);
                }
                return null;
            }

            @Override
            protected void process(List<ChartTemplateBase> chunks) {
                this.this$0.jLabelProcess.setText("Processing: " + chunks.get(chunks.size() - 1).getName() + "...");
            }

            @Override
            public void done() {
                try {
                    this.get();
                }
                catch (ExecutionException e) {
                    Throwable throwable = e.getCause();
                    if (throwable instanceof RuntimeException) {
                        RuntimeException re = (RuntimeException)throwable;
                        LOGGER.log(Level.WARNING, "RuntimeException during template tab opening", re);
                    } else {
                        throwable = e.getCause();
                        if (throwable instanceof Exception) {
                            Exception ex = (Exception)throwable;
                            SbugsExceptionHandler.showStackError(ex, this.this$0);
                        } else {
                            e.printStackTrace();
                        }
                    }
                }
                catch (InterruptedException ex) {
                    SbugsExceptionHandler.showStackError("Template opening interrupted", ex);
                }
                this.this$0.jLabelProcess.setText(null);
                if (this.lastAdded != null) {
                    this.this$0.jTabbedPaneChart.setSelectedComponent(this.lastAdded);
                }
                this.this$0.setCursor(Cursor.getDefaultCursor());
            }
        };
        this.setCursor(Cursor.getPredefinedCursor(3));
        worker.execute();
    }

    void setProcessLabel(String text) {
        this.jLabelProcess.setText(text);
    }

    public Chart getSelectedChart() {
        JScrollPaneChartTemplate cpane = this.jTabbedPaneChart.getSelectedScrollPaneChart();
        if (cpane != null) {
            return cpane.getChart();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JScrollPaneChartTemplate addTab(Chart chart, BlockType blockType, boolean selectTab) {
        ChartJPanel chartPanel = new ChartJPanel(chart);
        if (this.outlinePf != null && chart.getTemplate() != null) {
            chartPanel.setPf(this.outlinePf);
            chartPanel.setPageFit(ChartJPanel.PageFit.SINGLE);
        }
        JScrollPaneChartTemplate scrollPane = new JScrollPaneChartTemplate(this, chartPanel, blockType);
        scrollPane.setBorder(null);
        scrollPane.refreshView();
        JTabbedPaneChart jTabbedPaneChart = this.jTabbedPaneChart;
        synchronized (jTabbedPaneChart) {
            this.jTabbedPaneChart.addChartTab(scrollPane);
            if (selectTab) {
                this.jTabbedPaneChart.setSelectedComponent(scrollPane);
            }
        }
        return scrollPane;
    }

    private void reInitDetailsPane() {
        TemplateDescr template;
        block16: {
            Object node = this.jTreePanels.getLastSelectedPathComponent();
            template = null;
            if (node instanceof BlockTemplateInfo) {
                node = this.chartManager.getBlockTemplateFromInfo((BlockTemplateInfo)node);
            }
            if (node instanceof TemplateDescr) {
                template = (TemplateDescr)node;
            }
            StyledDocument doc = this.jTextPanePanelDetails.getStyledDocument();
            try {
                if (template != null) {
                    Object projString;
                    if (template instanceof PanelTemplate && !((PanelTemplate)template).isVisible()) {
                        doc.remove(0, doc.getLength());
                        doc.insertString(0, "Panel properties are local to block template", doc.getStyle("decoupled"));
                        break block16;
                    }
                    if (template.getProjID() > 0) {
                        try {
                            projString = String.valueOf((Object)this.sbdb.getProject(template.getProjID()));
                        }
                        catch (Exception e) {
                            projString = "Error: " + e.getMessage();
                        }
                    } else {
                        projString = "Global";
                    }
                    doc.remove(0, doc.getLength());
                    doc.insertString(0, " ", doc.getStyle(template.getProjID() > 0 ? "boldProjectIcon" : "projectIcon"));
                    doc.insertString(doc.getLength(), " " + (String)projString + "\n", doc.getStyle(template.getProjID() > 0 ? "boldProject" : "project"));
                    if (template.getComments() != null && !template.getComments().isEmpty()) {
                        doc.insertString(doc.getLength(), template.getComments(), doc.getStyle("regular"));
                    }
                    if (!(template instanceof BlockTemplateParent) || ((BlockTemplateParent)template).getChildWellIDs().isEmpty()) break block16;
                    Set<Integer> childWellIDs = ((BlockTemplateParent)template).getChildWellIDs();
                    LinkedList<Object> wellNames = new LinkedList<Object>();
                    try {
                        for (Integer wellID : childWellIDs) {
                            try {
                                wellNames.add(this.sbdb.getWell(wellID).getWellName());
                            }
                            catch (WellHeader.MissingWellException e) {
                                wellNames.add("Well ID: " + wellID);
                            }
                        }
                    }
                    catch (SQLException | SBException ex) {
                        LOGGER.log(Level.WARNING, "Error loading block template well overrides.", ex);
                        wellNames.clear();
                        wellNames.add("some wells");
                    }
                    String wellNameString = "\nPanels are overridden for " + StringUtils.join(wellNames, (String)", ") + ".";
                    doc.insertString(doc.getLength(), wellNameString, doc.getStyle("blockOverride"));
                    break block16;
                }
                doc.remove(0, doc.getLength());
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
        this.jScrollPanePanelDetails.setVisible(template != null);
        this.jSplitPanePropertiesTable.resetToPreferredSizes();
        this.jSplitPanePalette.repaint();
    }

    public void fireTreeNodeChanged(Object object) {
        if (object == null) {
            return;
        }
        this.treeModel.fireTreeNodeChanged(object);
        this.jTreePanels.repaint();
    }

    public void firePanelTaxonSaveButtonChange(PanelTemplate p) {
        this.jListPTG.firePanelTaxonSaveButtonChange(p);
    }

    public void firePropertiesTableDataChanged() {
        ((PropertiesTable)this.jTableProperties).fireTableDataChanged();
        ((PropertiesTable)this.jTableMap).fireTableDataChanged();
    }

    JComponent getBalloonTipComponent() {
        if (this.jListPTG == null) {
            return null;
        }
        return this.jListPTG.getBalloonTipComponent();
    }

    private void encodeGUISession() {
        Object gui = "";
        if (this.getExtendedState() == 6) {
            gui = (String)gui + "1";
        } else {
            Dimension size = this.getSize();
            gui = (String)gui + size.width + "," + size.height;
        }
        gui = (String)gui + "|" + this.jSplitPanePalette.getWidth();
        try {
            Lastval.putString(this.sbdb, "CHTSESSION", (String)gui);
            this.sbdb.commit();
        }
        catch (SQLException sql) {
            SbugsExceptionHandler.showStackError(sql, this);
        }
    }

    private void restoreGUISession() {
        String params;
        try {
            params = Lastval.getString(this.sbdb, "CHTSESSION");
            if (params.isEmpty()) {
                return;
            }
        }
        catch (SQLException sql) {
            return;
        }
        String[] split = params.split("\\|");
        block6: for (int i = 0; i < split.length; ++i) {
            switch (i) {
                case 0: {
                    String size = split[i];
                    if (size.equals("1")) {
                        this.setExtendedState(6);
                        continue block6;
                    }
                    String[] split2 = size.split(",");
                    int width = Integer.parseInt(split2[0]);
                    int height = Integer.parseInt(split2[1]);
                    this.setSize(width, height);
                    continue block6;
                }
                case 1: {
                    int prefSize = Integer.parseInt(split[i]);
                    this.jSplitPanePalette.setPreferredSize(new Dimension(prefSize, this.jSplitPanePalette.getPreferredSize().height));
                }
            }
        }
    }

    private int getOverwriteOption() {
        String msg = "This template has been changed by another user.\nSaving your changes will overwrite theirs.\nContinue?";
        Object[] buttons = new String[]{"Save", "Discard changes", "Cancel"};
        return JOptionPane.showOptionDialog(this, msg, "Save Template", 1, 3, null, buttons, null);
    }

    private void startPanelHintSequence() {
        final HintSequence hintSequence = HintSequence.createHintSequence(this.parent);
        class SimpleStep
        implements Runnable {
            private final String hintString;
            final JComponent attach;
            final BalloonTip.Orientation orientation;
            final BalloonTip.AttachLocation attachLocation;

            SimpleStep(String hint, JComponent attach, BalloonTip.Orientation orientation, BalloonTip.AttachLocation attachLocation) {
                Objects.requireNonNull(this$0);
                this.hintString = hint;
                this.attach = attach;
                this.orientation = orientation;
                this.attachLocation = attachLocation;
            }

            @Override
            public void run() {
                hintSequence.setHintText(this.hintString);
                hintSequence.setHint(new BalloonTip(this.attach, hintSequence.getHintComponent(), HintSequence.chartHintStyle, this.orientation, this.attachLocation, 0, 20, true));
            }
        }
        Runnable[] steps = new Runnable[]{new SimpleStep("The blue background to this tab indicates a block template. You will see the general layout of the block but it will not display any real data.", (JTabbedPaneChart.TabTitle)this.jTabbedPaneChart.getTabComponentAt(this.jTabbedPaneChart.getSelectedIndex()), BalloonTip.Orientation.LEFT_ABOVE, BalloonTip.AttachLocation.EAST), new SimpleStep("This tree shows all the panel types available to " + ((JScrollPaneChartTemplate)this.jTabbedPaneChart.getSelectedComponent()).blockType.getShortDescr() + " blocks.", this.jScrollPane1, BalloonTip.Orientation.RIGHT_BELOW, BalloonTip.AttachLocation.WEST), new Runnable(){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void run() {
                hintSequence.setHintText("Expand a node to see panel templates for that type.\n\nYou can create a new template by right-clicking on the panel type.");
                this.this$0.jTreePanels.setSelectionPath(this.this$0.treeModel.getPath(PanelType.SCALE));
                this.this$0.jTreePanels.expandPath(this.this$0.treeModel.getPath(PanelType.SCALE));
                hintSequence.setHint((BalloonTip)new TreeNodeBalloonTip(this.this$0.jTreePanels, hintSequence.getHintComponent(), this.this$0.treeModel.getPath(this.this$0.treeModel.getChild(PanelType.SCALE, this.this$0.treeModel.getChildCount(PanelType.SCALE) - 1)), HintSequence.chartHintStyle, BalloonTip.Orientation.RIGHT_BELOW, BalloonTip.AttachLocation.WEST, 0, 20, true));
            }
        }, new Runnable(){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void run() {
                hintSequence.setHintText("Click on a template to see its properties in the pane below.");
                this.this$0.reInitTab(this.this$0.treeModel.getChild(PanelType.SCALE, 0));
                hintSequence.setHint((BalloonTip)new TreeNodeBalloonTip(this.this$0.jTreePanels, hintSequence.getHintComponent(), this.this$0.treeModel.getPath(this.this$0.treeModel.getChild(PanelType.SCALE, 0)), HintSequence.chartHintStyle, BalloonTip.Orientation.RIGHT_BELOW, BalloonTip.AttachLocation.WEST, 0, 20, true));
            }
        }, new SimpleStep("This pane shows the panel's description, and which project it belongs to.", this.jScrollPanePanelDetails, BalloonTip.Orientation.RIGHT_ABOVE, BalloonTip.AttachLocation.NORTH), new Runnable(){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void run() {
                hintSequence.setHintText("Add panels to your block template by dragging a panel template from the tree and dropping it onto the block template.");
                if (this.this$0.jTreePanels.getSelectionPath() == null || !(this.this$0.jTreePanels.getSelectionPath().getLastPathComponent() instanceof PanelTemplate)) {
                    this.this$0.jTreePanels.setSelectionPath(this.this$0.treeModel.getPath(this.this$0.treeModel.getChild(PanelType.SCALE, 0)));
                }
                Transferable transferable = ((SBChartTransferHandler)this.this$0.jTreePanels.getTransferHandler()).createTransferable(this.this$0.jTreePanels);
                TransferHandler.TransferSupport support = new TransferHandler.TransferSupport((Component)this.this$0.jTabbedPaneChart, transferable);
                ((SBChartTransferHandler)this.this$0.jTabbedPaneChart.getTransferHandler()).importData(support);
                hintSequence.setHint((BalloonTip)new TreeNodeBalloonTip(this.this$0.jTreePanels, hintSequence.getHintComponent(), this.this$0.jTreePanels.getLeadSelectionPath(), HintSequence.chartHintStyle, BalloonTip.Orientation.RIGHT_BELOW, BalloonTip.AttachLocation.WEST, 0, 20, true));
            }
        }, new SimpleStep("The * after the block template name shows that it is now unsaved. You can press the \"Save\" button above to save the current tab.", (JTabbedPaneChart.TabTitle)this.jTabbedPaneChart.getTabComponentAt(this.jTabbedPaneChart.getSelectedIndex()), BalloonTip.Orientation.LEFT_ABOVE, BalloonTip.AttachLocation.EAST), new Runnable(){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void run() {
                hintSequence.setHintText("The bold outline shows that this panel is selected. Its template is highlighed in the tree.\n\nThe panel is displaying dummy data, to give you an idea of the panel template's properties.");
                SBPanel panel = (SBPanel)this.this$0.jTabbedPaneChart.getSelectedScrollPaneChart().getSelectedPanel();
                if (panel == null) {
                    panel = this.this$0.jTabbedPaneChart.getSelectedScrollPaneChart().getChart().getChartBlockSingle().getPanels().get(0);
                    if (panel == null) {
                        hintSequence.hideHint();
                        return;
                    }
                    this.this$0.reInitTab(panel);
                }
                Point2D.Float selectedPanelOrigin = this.this$0.jTabbedPaneChart.getSelectedScrollPaneChart().getSelectedPanelOrigin();
                selectedPanelOrigin.x += panel.getWidth(panel.getBlock().getProp());
                selectedPanelOrigin.y += this.this$0.jTabbedPaneChart.getSelectedScrollPaneChart().getChart().getProperties().panelCaptionHeight;
                final Point point = this.this$0.jTabbedPaneChart.getSelectedScrollPaneChart().getPosition(selectedPanelOrigin);
                LeftBelowPositioner positioner = new LeftBelowPositioner(this, 0, 10){
                    {
                        Objects.requireNonNull(this$1);
                        super(arg0, arg1);
                    }

                    protected void determineLocation(Rectangle attached) {
                        this.flipX = false;
                        this.flipY = true;
                        this.hOffset = this.preferredHorizontalOffset;
                        this.x = attached.x + point.x;
                        this.y = attached.y + point.y;
                        if (this.offsetCorrection) {
                            this.applyOffsetCorrection();
                        }
                    }
                };
                hintSequence.setHint(new BalloonTip((JComponent)this.this$0.jTabbedPaneChart.getSelectedScrollPaneChart(), hintSequence.getHintComponent(), HintSequence.chartHintStyle, (BalloonTipPositioner)positioner, BalloonTip.getDefaultCloseButton()));
            }
        }, new SimpleStep("When a panel is selected you can edit its caption. The caption belongs block template, not the panel template!\n\nMore than one panel in a block could share the same panel template, but have different captions.", this.jScrollPaneTableProperties, BalloonTip.Orientation.RIGHT_BELOW, BalloonTip.AttachLocation.NORTHWEST), new SimpleStep("You can change the template's properties by clicking in the right-hand table column.\n\nPanels in the block which are using this template show you what the changes look like.\n\nCommit changes to the panel template by clicking the save button. Remember that this panel template might be used in other blocks, and they will all be updated when you save the panel template!", this.jTableProperties, BalloonTip.Orientation.RIGHT_BELOW, BalloonTip.AttachLocation.SOUTH), new Runnable(){
            final /* synthetic */ FrameChart this$0;
            {
                FrameChart frameChart = this$0;
                Objects.requireNonNull(frameChart);
                this.this$0 = frameChart;
            }

            @Override
            public void run() {
                hintSequence.setHintText("To display data from a well in your block template, open it on the Charts tab in Samples & Interpretations.");
                hintSequence.setFinalHint("Click here for more about panel templates...", new ActionListener(){
                    {
                        Objects.requireNonNull(this$1);
                    }

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        FrameJsbugs.openHelp("charts_panels.html");
                        hintSequence.hideHint();
                    }
                });
                this.this$0.jTreePanels.setSelectionPath(this.this$0.treeModel.getPath(this.this$0.treeModel.getChild(PanelType.SCALE, 0)));
                hintSequence.setHint(new BalloonTip((JComponent)this.this$0.jTableProperties, hintSequence.getHintComponent(), HintSequence.chartHintStyle, BalloonTip.Orientation.RIGHT_BELOW, BalloonTip.AttachLocation.SOUTH, 0, 20, true));
            }
        }};
        hintSequence.initSequence(steps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportChart() {
        JScrollPaneChartTemplate sPane = (JScrollPaneChartTemplate)this.jTabbedPaneChart.getSelectedComponent();
        if (sPane == null) {
            return;
        }
        if (!sPane.isSaved) {
            JOptionPane.showMessageDialog(this, "You must save this template before exporting", "Export Chart", 2);
            return;
        }
        ChartTemplateBase template = sPane.blockType == null ? sPane.getChart().getTemplate() : sPane.getChart().getBlockSingle().getTemplate();
        if (template == null) {
            assert (false);
            return;
        }
        String[] extensions = new String[]{"sbg"};
        String[] descriptions = new String[]{"StrataBugs XML/SBG"};
        String defaultFileName = ChartExporter.getDefaultExportFileName(template);
        File file = FileChooserUtils.chooseFileToWrite((SBdb)this.sbdb, (Component)this, (String)"WINFILE", (String)"UNXFILE", (String[])extensions, (String[])descriptions, (String)defaultFileName);
        if (file == null) {
            return;
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            SBdb ws = new SBdb(this.sbdb);
            ChartManager wsCM = new ChartManager(ws);
            HashSet<Integer> dataTypes = null;
            if (template instanceof BlockTemplate) {
                ChartManager.copyToWs(this.chartManager, wsCM, template.getID());
            } else {
                dataTypes = new HashSet<Integer>();
                ChartManager.copyToWs(this.chartManager, wsCM, sPane.getChart(), dataTypes);
            }
            SbugsIO.saveSBGfile(this.sbdb, wsCM, null, file, this, dataTypes, false);
        }
        catch (SBPermissionException pe) {
            JOptionPane.showMessageDialog(this, pe.getMessage(), this.getTitle(), 2);
        }
        catch (SQLException | SBException sql) {
            FrameJsbugs.showStackError("Error", (Exception)sql, this.sbdb);
        }
        catch (IOException fnf) {
            StackError.showStackError((String)"Error writing file", (Throwable)fnf);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    class JTabbedPaneChart
    extends SBTabbedPane
    implements DragGestureListener,
    ChartContainer,
    TemplateDescr.Listener {
        final /* synthetic */ FrameChart this$0;

        JTabbedPaneChart(FrameChart this$0) {
            FrameChart frameChart = this$0;
            Objects.requireNonNull(frameChart);
            this.this$0 = frameChart;
            this.setFocusable(false);
            this.addChangeListener(this.this$0::jTabbedPaneChartStateChanged);
            this.addMouseListener(new TabTitleContextMenuMouseListener(this, true));
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
            SBChartTransferHandler h = (SBChartTransferHandler)this.getTransferHandler();
            Transferable trans = h.createTransferable(this.this$0.jTreePanels);
            if (trans != null) {
                dge.startDrag(null, trans);
            }
        }

        void addChartTab(JScrollPaneChartTemplate scrollPane) {
            String title = scrollPane.getTabTitle();
            if (this.indexOfTab(title) > -1) {
                Object title2 = title;
                int i = 2;
                while (this.indexOfTab((String)title2) > -1) {
                    title2 = title + "(" + i + ")";
                    ++i;
                }
                title = title2;
            }
            this.addTab(title, scrollPane);
            int index = this.indexOfTab(title);
            TabTitle tabTitle = new TabTitle(this, title, scrollPane.blockType);
            scrollPane.getTemplate().addListener(this);
            tabTitle.updateLock(scrollPane.isReadOnly());
            this.setTabComponentAt(index, tabTitle);
        }

        public JScrollPaneChartTemplate getSelectedScrollPaneChart() {
            Component component = this.getSelectedComponent();
            if (component instanceof JScrollPaneChartTemplate) {
                JScrollPaneChartTemplate t = (JScrollPaneChartTemplate)component;
                return t;
            }
            return null;
        }

        void updateTitleAt(int index) {
            JScrollPaneChartTemplate sPane = (JScrollPaneChartTemplate)this.getComponentAt(index);
            TabTitle tabTitle = (TabTitle)this.getTabComponentAt(index);
            if (sPane == null || tabTitle == null) {
                assert (false);
                return;
            }
            tabTitle.updateLabel(sPane.getTabTitle());
            tabTitle.updateLock(sPane.isReadOnly());
        }

        @Override
        public void chartWillBeDeleted(int chartTemplateID) {
            LinkedList<JScrollPaneChartTemplate> toRemove = new LinkedList<JScrollPaneChartTemplate>();
            for (int i = 0; i < this.getTabCount(); ++i) {
                JScrollPaneChartTemplate sPane = (JScrollPaneChartTemplate)this.getComponentAt(i);
                if (sPane.view.chart.getTemplate() == null || sPane.view.chart.getTemplate().getID() != chartTemplateID) continue;
                toRemove.add(sPane);
            }
            this.removeTabs(toRemove);
            try {
                this.this$0.updateRecentButtons(this.this$0.chartManager.getChartTemplate(chartTemplateID));
            }
            catch (SQLException sql) {
                SbugsExceptionHandler.showStackError(sql, this);
            }
        }

        @Override
        public void blockWillBeDeleted(int blockTemplateID, boolean fromRefresh) {
            LinkedList<JScrollPaneChartTemplate> toRemove = new LinkedList<JScrollPaneChartTemplate>();
            for (int i = 0; i < this.getTabCount(); ++i) {
                JScrollPaneChartTemplate sPane = (JScrollPaneChartTemplate)this.getComponentAt(i);
                if (sPane.view.chart.getTemplate() == null) {
                    if (sPane.view.chart.getBlockSingle().getTemplate().getID() != blockTemplateID) continue;
                    if (fromRefresh) {
                        try {
                            BlockTemplate existing = sPane.view.chart.getBlockSingle().getTemplate();
                            BlockTemplate unsaved = TemplateFactory.newBlockTemplate(this.this$0.chartManager, existing.getType(), existing.getName(), (existing.getComments() + " **Deleted by remote user**").trim(), existing.getProjID());
                            unsaved.updatePanels(this.this$0.sbdb, BlockTemplate.createPanelOccUpdates(existing.getPanels()));
                            sPane.view.chart.removeBlock(sPane.view.chart.getBlockSingle());
                            sPane.view.chart.addBlock(ChartFactory.createBlock(this.this$0.sbdb, unsaved));
                            sPane.view.chart.setData();
                            sPane.isSaved = false;
                            this.updateTitleAt(i);
                        }
                        catch (IOException | SQLException | SBException | SBPermissionException sql) {
                            FrameJsbugs.showStackError("Error in blockWillBeDeleted", (Exception)sql, this.this$0.sbdb);
                        }
                        continue;
                    }
                    toRemove.add(sPane);
                    continue;
                }
                boolean repaint = false;
                for (ChartBlockBase block : sPane.view.chart.getBlocks()) {
                    if (block.getTemplate().getID() != blockTemplateID) continue;
                    if (block.getTemplate().getParentID() != null) {
                        try {
                            BlockTemplate parentBlock = this.this$0.chartManager.getBlockTemplate(block.getTemplate().getParentID());
                            ChartBlock replacementBlock = (ChartBlock)ChartFactory.createBlock(parentBlock, this.this$0.sbdb, block.getWellID(), block.getWellListID(), block.getInterpID(), block.getProperties(), block.getCaption());
                            int index = sPane.getChart().getBlocks().indexOf(block);
                            sPane.getChart().removeBlock(block);
                            sPane.getChart().insertBlock(replacementBlock, index);
                            sPane.getChart().setData(replacementBlock);
                        }
                        catch (IOException | SQLException | SBException ex) {
                            FrameJsbugs.showStackError("Error removing chart tab", (Exception)ex, this.this$0.sbdb);
                        }
                    } else {
                        sPane.view.chart.removeBlock(block);
                    }
                    repaint = true;
                }
                if (!repaint) continue;
                sPane.refreshView();
                sPane.repaint();
                this.this$0.setChartSizeLabel();
            }
            this.removeTabs(toRemove);
            try {
                this.this$0.updateRecentButtons(this.this$0.chartManager.getBlockTemplate(blockTemplateID));
                BlockTemplate deletedNode = this.this$0.chartManager.getBlockTemplate(blockTemplateID);
                if (deletedNode != null) {
                    this.this$0.treeModel.templateInsertedOrRemoved(deletedNode, false);
                }
                this.this$0.jTreePanels.repaint();
                this.this$0.reInitDetailsPane();
            }
            catch (RuntimeException | SQLException sql) {
                FrameJsbugs.showStackError("Error", sql, this.this$0.sbdb);
            }
        }

        @Override
        public void templateWellBlockRemovedFromChart(int chartTemplateID) {
        }

        private void removeTabs(List<JScrollPaneChartTemplate> toRemove) {
            toRemove.forEach(sPane -> this.remove((Component)sPane));
        }

        @Override
        public void wellWillBeDeleted(int wellID) {
            for (int i = 0; i < this.getTabCount(); ++i) {
                JScrollPaneChartTemplate sPane = (JScrollPaneChartTemplate)this.getComponentAt(i);
                if (sPane.view.chart.getTemplate() == null || sPane.view.chart.getTemplate().getID() != 0) continue;
                sPane.getChart().wellDeleted(wellID);
            }
        }

        @Override
        public void panelTemplateWillBeDeleted(int panelTemplateID) {
            for (Component c : this.getComponents()) {
                ChartBlockBase block;
                if (!(c instanceof JScrollPaneChart)) continue;
                JScrollPaneChartTemplate sPane = (JScrollPaneChartTemplate)c;
                if (sPane.blockType == null || (block = sPane.getActiveBlock()) == null) continue;
                List panelsToRemove = block.members().filter(m -> Objects.equals(panelTemplateID, m.getTemplateID())).collect(Collectors.toList());
                for (ChartPanel p : panelsToRemove) {
                    block.removePanel(p);
                }
            }
            try {
                this.this$0.treeModel.templateInsertedOrRemoved(this.this$0.chartManager.getPanelTemplate(panelTemplateID), false);
                this.this$0.jTreePanels.repaint();
            }
            catch (RuntimeException | SQLException | SBException e) {
                SbugsExceptionHandler.showStackError(e);
            }
        }

        @Override
        public void templateDescrUpdated(TemplateDescr template) {
            if (this.getTabCount() == 0) {
                return;
            }
            if (template instanceof PanelTemplate && ((JScrollPaneChartTemplate)this.getSelectedComponent()).blockType != null) {
                this.this$0.fireTreeNodeChanged(template);
            } else if (template instanceof ChartTemplateBase) {
                for (int i = 0; i < this.this$0.jTabbedPaneChart.getTabCount(); ++i) {
                    JScrollPaneChartTemplate comp = (JScrollPaneChartTemplate)this.this$0.jTabbedPaneChart.getComponentAt(i);
                    if ((!(template instanceof BlockTemplate) || comp.blockType == null || comp.getChart().getBlockSingle().getTemplate() != template) && (!(template instanceof ChartTemplate) || comp.blockType != null || comp.getChart().getTemplate() != template)) continue;
                    this.this$0.jTabbedPaneChart.updateTitleAt(i);
                    comp.refreshView();
                    if (this.this$0.jTabbedPaneChart.getSelectedIndex() != i) continue;
                    comp.repaint();
                    this.this$0.setProject(template.getProjID());
                }
                if (template instanceof BlockTemplate && ((JScrollPaneChartTemplate)this.getSelectedComponent()).blockType == null) {
                    this.this$0.fireTreeNodeChanged(template);
                }
            } else if (template instanceof CorrelationTemplate && ((JScrollPaneChartTemplate)this.getSelectedComponent()).blockType == null) {
                this.this$0.fireTreeNodeChanged(template);
            }
        }

        @Override
        public void onTemplateDescriptionChanged(TemplateDescr templateDescr) {
            this.templateDescrUpdated(templateDescr);
        }

        @Override
        public void templateAdded(TemplateDescr template) {
            if (template == null) {
                return;
            }
            this.this$0.treeModel.templateInsertedOrRemoved(template, true);
            this.this$0.jTreePanels.repaint();
            if (template instanceof BlockTemplate && ((BlockTemplate)template).getParentID() != null) {
                try {
                    BlockTemplate parent = this.this$0.chartManager.getBlockTemplate(((BlockTemplate)template).getParentID());
                    for (int i = 0; i < this.getTabCount(); ++i) {
                        JScrollPaneChartTemplate sPane = (JScrollPaneChartTemplate)this.getComponentAt(i);
                        if (sPane.blockType != null) continue;
                        ChartFactory.replaceBlock(sPane.getChart(), parent, ((BlockTemplate)template).getWellID(), this.this$0.sbdb);
                    }
                }
                catch (IOException | SQLException | SBException sql) {
                    FrameJsbugs.showStackError("Error", (Exception)sql, this.this$0.sbdb);
                }
            }
        }

        @Override
        public void corrTemplateWillBeDeleted(int corrID) {
            for (Component c : this.getComponents()) {
                if (!(c instanceof JScrollPaneChart)) continue;
                JScrollPaneChartTemplate sPane = (JScrollPaneChartTemplate)c;
                if (sPane.blockType != null) continue;
                for (Correlation corr : sPane.view.chart.getCorrelations()) {
                    if (corr.getTemplateID() != corrID) continue;
                    try {
                        sPane.view.chart.removeCorrelation(corr);
                    }
                    catch (SQLException | SBException sql) {
                        FrameJsbugs.showStackError("Error", (Exception)sql, this.this$0.sbdb);
                    }
                }
            }
            try {
                this.this$0.treeModel.templateInsertedOrRemoved(this.this$0.chartManager.getCorrTemplate(corrID), false);
                this.this$0.jTreePanels.repaint();
            }
            catch (RuntimeException | SQLException sql) {
                FrameJsbugs.showStackError("Error", sql, this.this$0.sbdb);
            }
        }

        @Override
        public void wellWillbeRemovedFromProject(int wellID, int projID) {
        }

        @Override
        public boolean closeTabAt(int index, boolean force) {
            JScrollPaneChartTemplate tab = (JScrollPaneChartTemplate)this.getComponentAt(index);
            if (tab.getTemplate() instanceof BlockTemplate) {
                try {
                    int opt;
                    boolean hasEditingPanels = ((BlockTemplate)tab.getTemplate()).hasEditingPanels();
                    if (hasEditingPanels && (opt = JOptionPane.showConfirmDialog(this, "There are unsaved panel templates.\nContinue to close?", "Close tab", 0)) == 1) {
                        return false;
                    }
                }
                catch (SQLException | SBException e) {
                    SbugsExceptionHandler.showStackError("Error getting editing panels from block template", e);
                    return false;
                }
            }
            if (!tab.isSaved) {
                int opt = JOptionPane.showConfirmDialog(this, "Save " + (tab.getTemplate().getID() > 0 ? "changes to " : "") + tab.getTemplate().getName() + "?", "Close tab", 1);
                switch (opt) {
                    case 2: {
                        return false;
                    }
                    case 0: {
                        if (!this.this$0.saveTab(tab)) {
                            return false;
                        }
                    }
                    case 1: {
                        this.remove(tab);
                    }
                }
                return true;
            }
            tab.terminate();
            tab.getChart().terminate();
            this.remove(tab);
            return true;
        }

        boolean selectTemplate(ChartTemplateBase templ) {
            for (Component c : this.getComponents()) {
                if (!(c instanceof JScrollPaneChartTemplate)) continue;
                JScrollPaneChartTemplate sPane = (JScrollPaneChartTemplate)c;
                if (templ instanceof BlockTemplate) {
                    if (sPane.blockType != ((BlockTemplate)templ).getType() || sPane.view.chart.getBlockSingle().getTemplate() != templ) continue;
                    this.setSelectedComponent(c);
                    return true;
                }
                if (!(templ instanceof ChartTemplate) || sPane.blockType != null || sPane.view.chart.getTemplate() != templ) continue;
                this.setSelectedComponent(c);
                return true;
            }
            return false;
        }

        private class TabTitle
        extends JPanel {
            final JButton lockButton;
            final JLabel label;
            final /* synthetic */ JTabbedPaneChart this$1;

            TabTitle(JTabbedPaneChart jTabbedPaneChart, String labelText, BlockType blockType) {
                JTabbedPaneChart jTabbedPaneChart2 = jTabbedPaneChart;
                Objects.requireNonNull(jTabbedPaneChart2);
                this.this$1 = jTabbedPaneChart2;
                super(new BorderLayout(5, 0));
                this.setOpaque(false);
                this.label = new JLabel(labelText);
                if (blockType != null) {
                    this.label.setIcon(blockType.getIcon());
                } else {
                    this.label.setIcon(IconFactory.getIcon("chartTab"));
                }
                this.add((Component)this.label, "Center");
                Icon closeTabIcon = IconFactory.getIcon("closeTab");
                JButton closeButton = new JButton(closeTabIcon);
                closeButton.setRolloverIcon(IconFactory.getIcon("closeTabRollover"));
                closeButton.setRolloverEnabled(true);
                closeButton.setFocusable(false);
                closeButton.setBorderPainted(false);
                closeButton.addActionListener(new ActionListener(this){
                    final /* synthetic */ TabTitle this$2;
                    {
                        TabTitle tabTitle = this$2;
                        Objects.requireNonNull(tabTitle);
                        this.this$2 = tabTitle;
                    }

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        this.this$2.this$1.closeTabAt(this.this$2.this$1.this$0.jTabbedPaneChart.indexOfTabComponent(this.this$2), false);
                    }
                });
                closeButton.setPreferredSize(new Dimension(closeTabIcon.getIconWidth(), closeTabIcon.getIconHeight()));
                closeButton.setContentAreaFilled(false);
                this.add((Component)closeButton, "East");
                this.lockButton = new JButton();
                this.lockButton.setContentAreaFilled(false);
                this.lockButton.setBorderPainted(false);
                Icon linkedIcon = IconFactory.getIcon("linked");
                this.lockButton.setIcon(linkedIcon);
                this.lockButton.setPreferredSize(new Dimension(linkedIcon.getIconWidth(), linkedIcon.getIconHeight()));
                this.lockButton.setMinimumSize(new Dimension(linkedIcon.getIconWidth(), linkedIcon.getIconHeight()));
                this.lockButton.setMaximumSize(new Dimension(linkedIcon.getIconWidth(), linkedIcon.getIconHeight()));
                this.lockButton.setFocusable(false);
            }

            void updateLabel(String newLabel) {
                this.label.setText(newLabel);
            }

            void updateLock(boolean locked) {
                if (locked) {
                    this.add((Component)this.lockButton, "West");
                } else {
                    this.remove(this.lockButton);
                }
            }
        }
    }

    class JScrollPaneChartTemplate
    extends JScrollPaneChartBase {
        private final ChartJPanel view;
        private BlockType blockType;
        private boolean isSaved;
        private final ChartMouseListenerManager mouseListenerManager;
        Point chartPopupPoint;
        private Correlation lastCorrelationSelection;
        final /* synthetic */ FrameChart this$0;

        JScrollPaneChartTemplate(FrameChart this$0, ChartJPanel view, BlockType blockType) {
            FrameChart frameChart = this$0;
            Objects.requireNonNull(frameChart);
            this.this$0 = frameChart;
            super(view);
            this.isSaved = false;
            this.view = view;
            view.setBackground(view.chart.getProperties().background);
            view.setOpaque(true);
            this.blockType = blockType;
            if (blockType != null) {
                if (view.chart.getBlockSingle().getTemplate().getID() > 0) {
                    this.isSaved = true;
                }
            } else if (view.chart.getTemplate().getID() > 0) {
                this.isSaved = true;
            }
            super.initXHairListeners();
            super.initResolutionZoomListener();
            this.mouseListenerManager = new ChartMouseListenerManager(view);
            this.mouseListenerManager.setChartChangeNotifyRunnable(() -> {
                this$0.fireChartMightHaveChanged();
                view.chart.updateTagAnchorBlocks();
            });
            this.addJPanelMouseListener(this.mouseListenerManager);
            this.addJPanelMouseMotionListener(this.mouseListenerManager);
            this.addJPanelMouseWheelListener(this.mouseListenerManager);
            this.addJPanelMouseMotionListener(new MouseMotionAdapter(this){
                final /* synthetic */ JScrollPaneChartTemplate this$1;
                {
                    JScrollPaneChartTemplate jScrollPaneChartTemplate = this$1;
                    Objects.requireNonNull(jScrollPaneChartTemplate);
                    this.this$1 = jScrollPaneChartTemplate;
                }

                @Override
                public void mouseMoved(MouseEvent evt) {
                    this.this$1.mMoved(evt);
                }
            });
            this.addJPanelMouseListener(new MouseAdapter(this){
                final /* synthetic */ JScrollPaneChartTemplate this$1;
                {
                    JScrollPaneChartTemplate jScrollPaneChartTemplate = this$1;
                    Objects.requireNonNull(jScrollPaneChartTemplate);
                    this.this$1 = jScrollPaneChartTemplate;
                }

                @Override
                public void mouseReleased(MouseEvent evt) {
                    this.this$1.popup(evt);
                }

                @Override
                public void mousePressed(MouseEvent evt) {
                    this.this$1.mClicked(evt);
                }
            });
            this.setWheelScrollingEnabled(true);
            this.mouseListenerManager.activateBehavioursForSelection(null);
        }

        @Override
        public void terminate() {
            this.mouseListenerManager.terminate();
            super.terminate();
        }

        private void setMode(BlockType mode) {
            if (mode != this.blockType) {
                this.blockType = mode;
                this.view.chart.notifyListeners();
                ChartPanel selection = null;
                if (mode != null) {
                    this.view.chart.getProperties().setTemplateColourScheme();
                    this.view.chart.disableTags();
                    this.mouseListenerManager.activateBehavioursForSelection(null);
                    selection = this.getSelectedPanel(this.chartPopupPoint);
                } else {
                    this.view.chart.getProperties().restoreCachedColourScheme();
                    this.view.chart.enableTags();
                }
                try {
                    this.view.chart.setData();
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "An error occurred  setting chart data in setMode(BlockType).", e);
                }
                this.refreshView();
                this.this$0.jTabbedPaneChart.updateTitleAt(this.this$0.jTabbedPaneChart.indexOfComponent(this));
                this.this$0.reInitWindow(selection);
            }
        }

        public BlockType getMode() {
            return this.blockType;
        }

        ChartBlockBase getActiveBlock() {
            ChartBlockBase block = this.view.chart.getBlockSingle();
            if (block == null) {
                return this.view.chart.getSelectedBlock().orElse(null);
            }
            return block;
        }

        void scrollMaxRight() {
            this.horizontalScrollBar.setValue(this.horizontalScrollBar.getMaximum());
        }

        public boolean viewHasFocus() {
            return this.view.hasFocus();
        }

        private void mMoved(MouseEvent evt) {
            this.setToolTipText(evt);
            String text = this.view.getToolTipText();
            if (text != null && text.startsWith("<html>") && text.contains("<br>")) {
                text = text.replaceAll("<br>", "; ");
            }
            this.this$0.jLabelTooltip.setText(text);
        }

        private void mClicked(MouseEvent evt) {
            Object toSelect;
            if (this.mouseListenerManager.hasCurrentBehaviour()) {
                return;
            }
            if (evt.isPopupTrigger()) {
                this.popup(evt);
                return;
            }
            ChartBlockBase block = this.getSelectedBlock(evt);
            if (this.blockType == null) {
                toSelect = ObjectUtils.firstNonNull((Object[])new Object[]{this.getSelectedTag(evt), block, this.view.chart});
                this.mouseListenerManager.activateBehavioursForSelection(toSelect);
            } else {
                if (this.view.chart.getTemplate() != null && (block == null || block != this.getActiveBlock())) {
                    this.exitBlockTemplateEditMode();
                    return;
                }
                ChartPanel panel = null;
                if (block != null) {
                    panel = this.getSelectedPanel(evt);
                }
                ChartNode innerPanel = null;
                if (panel != null && PanelType.isTaxonPanel(panel.getPanelType())) {
                    innerPanel = this.getSelectedInnerPanel(evt);
                }
                toSelect = innerPanel != null ? innerPanel : panel;
            }
            this.this$0.reInitTab(toSelect);
        }

        private void exitBlockTemplateEditMode() {
            if (!this.getActiveBlock().equalsTemplate()) {
                String message = "Save or discard changes to this block template?";
                Object[] options = new Object[]{"Save", "Discard", "Cancel"};
                int option = JOptionPane.showOptionDialog(this.this$0, message, "Exit Block Template Editor", 2, 3, null, options, null);
                if (option == 2) {
                    return;
                }
                this.view.chart.getProperties().restoreCachedColourScheme();
                try {
                    this.view.chart.setData();
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Exception setting chart data in exitBlockTemplateEditMode().", e);
                }
                switch (option) {
                    case 0: {
                        this.this$0.saveSelection();
                        break;
                    }
                    case 1: {
                        this.restoreFromTemplate();
                        break;
                    }
                    case 2: {
                        return;
                    }
                }
            } else {
                try {
                    boolean hasEditingPanels = this.getActiveBlock().getTemplate().hasEditingPanels();
                    if (hasEditingPanels && JOptionPane.showConfirmDialog(this.this$0, "Warning: changes to panel templates are not stored.\nDo you still want to close block editor?", "Exit Block Template Edit Mode", 0, 2) == 1) {
                        return;
                    }
                }
                catch (RuntimeException | SQLException | SBException e) {
                    LOGGER.log(Level.WARNING, "Error exiting block template mode", e);
                }
            }
            this.setMode(null);
        }

        private void popup(MouseEvent evt) {
            if (evt.isPopupTrigger()) {
                JPopupMenu menu;
                ChartPanel cPanel = this.getSelectedPanel(evt);
                ChartBlockBase block = this.getSelectedBlock(evt);
                if (this.blockType == null) {
                    menu = this.this$0.jPopupMenuChartTab;
                    Object o = this.view.getObject(evt);
                    this.this$0.jMenuItemChartTabPopupNewTag.setVisible(!(o instanceof ChartTag));
                    this.this$0.jMenuItemChartTabPopupSendTagToBack.setVisible(o instanceof ChartTag);
                    this.this$0.jMenuItemChartTabPopupBringTagToFront.setVisible(o instanceof ChartTag);
                    this.this$0.jMenuItemChartTabPopupEditBlock.setVisible(block != null);
                    this.this$0.jMenuItemChartTabPopupSelectBlockTemplate.setVisible(block != null);
                    this.this$0.jSeparatorChartTabPopup1.setVisible(this.this$0.jMenuItemChartTabPopupEditBlock.isVisible() || this.this$0.jMenuItemChartTabPopupSelectBlockTemplate.isVisible());
                    this.this$0.jMenuItemChartTabPopupPanelProperties.setVisible(cPanel != null && block instanceof WellBlock && cPanel.getBlock().getWell() != null);
                    this.this$0.jMenuItemChartTabPopupOverrideToTemplate.setVisible(cPanel != null && cPanel.getBlock().getWell() != null && cPanel.getBlock().getTemplate().getParentID() != null);
                    this.this$0.jMenuItemChartTabPopupDiscardOverrides.setVisible(cPanel != null && block instanceof WellBlock && cPanel.getBlock().hasLocalChanges());
                    this.this$0.jSeparatorChartTabPopup2.setVisible(this.this$0.jMenuItemChartTabPopupPanelProperties.isVisible() || this.this$0.jMenuItemChartTabPopupOverrideToTemplate.isVisible() || this.this$0.jMenuItemChartTabPopupDiscardOverrides.isVisible());
                    this.this$0.jMenuItemChartTabPopupPanelDepthSnap.setVisible(cPanel != null && cPanel instanceof SBPanel && (((SBPanel)cPanel).getDataBound(true) != null || ((SBPanel)cPanel).getDataBound(false) != null));
                    this.this$0.jMenuItemChartTabPopupBlockDefaultDepths.setVisible(cPanel != null && cPanel.getBlock() instanceof WellBlock);
                    this.this$0.jSeparatorChartTabPopup3.setVisible(this.this$0.jMenuItemChartTabPopupPanelDepthSnap.isVisible() || this.this$0.jMenuItemChartTabPopupBlockDefaultDepths.isVisible());
                } else {
                    if (cPanel == null || this.blockType == BlockType.MAP) {
                        return;
                    }
                    menu = this.this$0.jPopupMenuBlockTab;
                    try {
                        this.this$0.jMenuItemBlockTabSelectPanelTemplate.setVisible(this.this$0.chartManager.getPanelTemplate(cPanel.getTemplateID()).isVisible());
                        this.this$0.jMenuItemBlockTabDecouple.setVisible(cPanel.getBlock() instanceof WellBlock);
                        this.this$0.jMenuBlockTabRecouple.setVisible(cPanel.getBlock() instanceof WellBlock);
                        this.this$0.jMenuItemBlockTabDecouple.setEnabled(this.this$0.chartManager.getPanelTemplate(cPanel.getTemplateID()).isVisible());
                        this.this$0.jMenuBlockTabRecouple.setEnabled(!this.this$0.chartManager.getPanelTemplate(cPanel.getTemplateID()).isVisible());
                    }
                    catch (SQLException | SBException sql) {
                        SbugsExceptionHandler.showStackError(sql, this.this$0);
                    }
                }
                boolean hasVisible = false;
                for (Component child : menu.getComponents()) {
                    if (!child.isVisible()) continue;
                    hasVisible = true;
                    break;
                }
                if (!hasVisible) {
                    return;
                }
                this.chartPopupPoint = evt.getPoint();
                menu.show(evt.getComponent(), evt.getX(), evt.getY());
            }
        }

        private void chartComponentAdded(Object added) {
            this.isSaved = false;
            this.this$0.reInitTab(added);
        }

        String getTabTitle() {
            Object title;
            if (this.view.chart.getTemplate() != null) {
                title = this.view.chart.getTemplate().getName();
                if (this.blockType != null) {
                    title = (String)title + " : " + this.getActiveBlock().getTemplate().getName();
                }
            } else {
                title = this.getActiveBlock().getTemplate().getName();
            }
            title = (String)title + (this.isSaved ? "" : "*");
            return title;
        }

        ChartTemplateBase getTemplate() {
            if (this.blockType != null) {
                return this.getActiveBlock().getTemplate();
            }
            return this.view.chart.getTemplate();
        }

        boolean isReadOnly() {
            try {
                return this.getTemplate().isReadOnly();
            }
            catch (SBException e) {
                e.printStackTrace();
                return false;
            }
        }

        void chartMightHaveChanged() {
            this.isSaved = this.blockType != null ? this.getActiveBlock().equalsTemplate() : this.view.chart.equalsTemplate();
            this.refreshView();
            this.repaint();
            this.this$0.setChartSizeLabel();
        }

        void wellMightHaveChanged() {
            if (this.view.chart.doesBlockNeedRefreshAfterWellChange()) {
                Object selected = this.getSelectedChartObject();
                if (selected instanceof WellBlock) {
                    WellBlock wb = (WellBlock)selected;
                    int selectedBlockIndex = this.view.chart.getBlocks().indexOf(wb);
                    try {
                        ChartFactory.replaceBlock(this.view.chart, wb.getTemplate(), wb.getWellID(), this.this$0.sbdb);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    if (selectedBlockIndex >= 0 && selectedBlockIndex < this.view.chart.getBlocks().size()) {
                        this.this$0.reInitTab(this.view.chart.getBlocks().get(selectedBlockIndex));
                    }
                    this.view.chart.doLayout();
                }
                this.repaint();
            }
        }

        void flagChartAsChanged() {
            this.isSaved = false;
            this.this$0.jTabbedPaneChart.updateTitleAt(this.this$0.jTabbedPaneChart.indexOfComponent(this));
            this.repaint();
        }

        private void removeSelectedChartElement() {
            boolean refresh;
            if (this.blockType != null) {
                refresh = this.getActiveBlock().removeSelectedPanel();
            } else {
                Object o = this.getSelectedChartObject();
                if (o instanceof ChartBlockBase) {
                    ChartBlockBase block = (ChartBlockBase)o;
                    if (block instanceof WellBlock && block.getWell() == null) {
                        try {
                            String msg;
                            int opt;
                            Point p = this.this$0.chartManager.isChartOpen(this.view.chart.getTemplate());
                            if (p.x > 0 && (opt = JOptionPane.showConfirmDialog(this, msg = "<html><strong>" + p.x + " users have this chart open for " + p.y + " wells.</strong></html>\nRemoving the template block will delete the chart tab for all users (on chart save).\nAre you sure you want to continue?", "Remove template block", 0)) != 0) {
                                return;
                            }
                        }
                        catch (SQLException sql) {
                            SbugsExceptionHandler.showStackError(sql);
                            return;
                        }
                    }
                    if (refresh = this.view.chart.removeSelectedBlock()) {
                        try {
                            this.view.chart.setData();
                        }
                        catch (IOException | RuntimeException | SQLException | SBException e) {
                            LOGGER.log(Level.WARNING, "Error setting chart data after removing block", e);
                        }
                    }
                } else if (o instanceof ChartTag) {
                    ChartTag tag = (ChartTag)((Object)o);
                    refresh = this.view.chart.removeTag(tag);
                } else {
                    refresh = false;
                }
            }
            if (refresh) {
                this.isSaved = false;
                if (this.blockType == BlockType.SCHEME) {
                    try {
                        ((SchemeBlock)this.getActiveBlock()).setTemplateProperties();
                    }
                    catch (SQLException sql) {
                        SbugsExceptionHandler.showStackError("SQL Error", sql);
                    }
                }
                this.refreshView();
                this.this$0.jTabbedPaneChart.updateTitleAt(this.this$0.jTabbedPaneChart.indexOfComponent(this));
                this.this$0.setChartSizeLabel();
                this.this$0.reInitTab(this.getSelectedChartObject());
            }
        }

        private void moveSelectedChartElement(boolean left) {
            boolean refresh;
            if (this.blockType != null) {
                ChartBlockBase block = this.getActiveBlock();
                refresh = block.moveSelectedPanel(left);
                if (refresh && block.getBlockType() == BlockType.MAP) {
                    this.this$0.reInitMapPanel((MapBlock)block, block.getSelectedPanel().map(ChartPanel::getTemplate).orElse(null), block.getSelectedPanel().orElse(null));
                }
                if (refresh) {
                    this.this$0.reInitTree(this.this$0.getSelectedObject(block.getSelectedPanel().get()));
                }
            } else {
                refresh = this.view.chart.moveSelectedBlock(left);
                if (refresh) {
                    try {
                        this.view.chart.setData();
                    }
                    catch (IOException | RuntimeException | SQLException | SBException e) {
                        SbugsExceptionHandler.showStackError(e, this.this$0);
                    }
                }
            }
            if (refresh) {
                this.flagChartAsChanged();
            }
        }

        private void chartProperties() {
            if (this.blockType != null) {
                return;
            }
            ChartProperties cp = this.view.chart.getProperties();
            try {
                boolean canWrite = this.view.chart.getTemplate().canWrite(this.this$0.sbdb, null);
                final int tabIndex = this.this$0.jTabbedPaneChart.indexOfComponent(this);
                ActionListener applyListener = new ActionListener(){
                    final /* synthetic */ JScrollPaneChartTemplate this$1;
                    {
                        JScrollPaneChartTemplate jScrollPaneChartTemplate = this$1;
                        Objects.requireNonNull(jScrollPaneChartTemplate);
                        this.this$1 = jScrollPaneChartTemplate;
                    }

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SwingUtilities.invokeLater(new Runnable(){
                            final /* synthetic */ 3 this$2;
                            {
                                3 v0 = this$2;
                                Objects.requireNonNull(v0);
                                this.this$2 = v0;
                            }

                            @Override
                            public void run() {
                                this.this$2.this$1.isSaved = false;
                                this.this$2.this$1.view.setBackground(this.this$2.this$1.view.chart.getProperties().background);
                                this.this$2.this$1.this$0.jTabbedPaneChart.updateTitleAt(tabIndex);
                                try {
                                    this.this$2.this$1.view.chart.setData();
                                }
                                catch (IOException | SQLException | SBException e) {
                                    SbugsExceptionHandler.showStackError("Error applying changes", e, this.this$2.this$1.this$0);
                                }
                                this.this$2.this$1.refreshView();
                                this.this$2.this$1.repaint();
                            }
                        });
                    }
                };
                DialogChartProperties dialog = new DialogChartProperties(this.this$0, true, cp, this.this$0.sbdb, null, false, true, canWrite, false);
                dialog.setLocationRelativeTo(this.this$0);
                dialog.setApplyActionListener(applyListener);
                dialog.setVisible(true);
                if (dialog.isOK()) {
                    this.isSaved = false;
                    this.view.setBackground(this.view.chart.getProperties().background);
                    this.view.chart.setData();
                    this.this$0.jTabbedPaneChart.updateTitleAt(tabIndex);
                    this.view.chart.calcChartSize();
                    this.this$0.setChartSizeLabel();
                }
            }
            catch (IOException | SQLException | SBException e) {
                SbugsExceptionHandler.showStackError("Error applying changes", e, this.this$0);
            }
            this.refreshView();
            this.repaint();
        }

        private Object getSelectedChartObject() {
            if (this.blockType != null) {
                return this.getActiveBlock().getSelectedPanel().orElse(null);
            }
            return ObjectUtils.firstNonNull((Object[])new Object[]{this.view.chart.getSelectedBlock().orElse(null), this.view.chart.getSelectedTag().orElse(null)});
        }

        void setCorrelation(Correlation correlation) {
            this.getChart().setSelectedCorrelation(correlation);
            if (correlation != null) {
                this.lastCorrelationSelection = correlation;
            }
        }

        void setLastCorrelation() {
            this.getChart().setSelectedCorrelation(this.lastCorrelationSelection);
        }

        private void restoreFromTemplate() {
            if (this.blockType != null) {
                ChartBlockBase activeBlock = this.getActiveBlock();
                activeBlock.members().forEach(p -> p.getTemplate().restoreSavedProperties());
                activeBlock.updateFromTemplate();
                activeBlock.notifyListeners();
            } else {
                try {
                    if (!this.getChart().equalsTemplate()) {
                        this.getChart().updateFromTemplate(this.this$0.sbdb);
                        this.getChart().setData();
                    }
                }
                catch (IOException | SQLException | SBException ex) {
                    SbugsExceptionHandler.showStackError(ex);
                    return;
                }
            }
            this.isSaved = true;
            this.this$0.jTabbedPaneChart.updateTitleAt(this.this$0.jTabbedPaneChart.indexOfComponent(this));
            this.refreshView();
            this.repaint();
        }

        void zoomSelection(boolean in) {
            ChartBlockBase chartBlockBase;
            Optional<ChartBlockBase> b = this.view.chart.getSelectedBlock();
            if (this.blockType == null && b.isPresent() && (chartBlockBase = b.get()) instanceof MapBlock) {
                MapBlock mapBlock = (MapBlock)chartBlockBase;
                mapBlock.zoomMapExtent(in);
                this.this$0.fireChartMightHaveChanged();
                return;
            }
            this.zoom(in);
        }
    }

    private record SelectedObject(Object original, PanelTemplate panelTemplate, ChartPanel chartPanel, PanelTaxonBase innerPanel, BlockTemplate blockTemplate, ChartBlockBase block, CorrelationTemplate corrTemplate, CorrelationStandard corrStd, Correlation correlation, ChartTag tag) {
        static SelectedObject nullSelection() {
            return new SelectedObject(null, null, null, null, null, null, null, null, null, null);
        }
    }

    private static class TemplateButton
    extends JButton {
        ChartTemplateBase template;

        private TemplateButton() {
            this.setBorderPainted(false);
        }
    }
}

