/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.sblicense.SbugsLicense;
import com.stratadata.util.ui.HelpUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import jsbchart.block.BlockType;
import jsbchart.core.BlockTemplate;
import jsbchart.core.PanelTemplate;
import jsbchart.panel.PanelType;
import jsbugs.DialogAgeCurves;
import jsbugs.DialogChartTemplates;
import jsbugs.DialogChronSchemes;
import jsbugs.DialogIGD;
import jsbugs.DialogList;
import jsbugs.DialogLithdesc;
import jsbugs.FrameJsbugs;
import jsbugs.InternalFrameChart;
import jsbugs.InternalFrameEnvSchemes;
import jsbugs.InternalFrameIGD;
import jsbugs.InternalFrameIGDSchemes;
import jsbugs.userconnect.SbugsExceptionHandler;
import jsbugs.util.SBFrame;
import jsbugs.wellheader.DialogSelectWell;
import model3.AgeCurve;
import model3.CompositeStandard;
import model3.IGDInterval;
import model3.IGDScheme;
import model3.SBRestrictable;
import model3.SBdb;
import model3.Well;
import model3.project.Project;
import org.jdesktop.layout.GroupLayout;
import util.SB;
import util.SBException;
import util.SBPermissionException;
import util.exception.StackError;

public class FrameInterpretations
extends SBFrame {
    private final SBdb sbdb;
    final FrameJsbugs parent;
    private InternalFrameIGDSchemes frameSchemes = null;
    private InternalFrameEnvSchemes frameEnvSchemes = null;
    private InternalFrameChart frameChart = null;
    private char units = (char)68;
    private ButtonGroup buttonGroupUnits;
    private ButtonGroup buttonGroupWindows;
    private JButton jButtonAddInterval;
    private JButton jButtonCascade;
    private JButton jButtonCloseWindow;
    private JButton jButtonDeleteInterval;
    private JButton jButtonEditInterval;
    private JButton jButtonOpen;
    private JButton jButtonOpenChartTemplates;
    private JButton jButtonTile;
    private JCheckBoxMenuItem jCheckBoxMenuItemEnvScheme;
    private JCheckBoxMenuItem jCheckBoxMenuScheme;
    private JDesktopPane jDesktopPane;
    private JMenuBar jMenuBar;
    private JMenu jMenuFile;
    private JMenu jMenuHelpMenu;
    private JMenuItem jMenuItemAgeCurves;
    private JMenuItem jMenuItemArrangeIcons;
    private JMenuItem jMenuItemCascade;
    private JMenuItem jMenuItemChronSchemes;
    private JMenuItem jMenuItemCloseWindow;
    private JMenuItem jMenuItemExit;
    private JMenuItem jMenuItemHelpMain;
    private JMenuItem jMenuItemHelpMenu;
    private JMenuItem jMenuItemLithdesc;
    private JMenuItem jMenuItemTile;
    private JMenuItem jMenuOpenIGD;
    private JMenu jMenuSchemes;
    private JMenu jMenuUnits;
    private JMenu jMenuWindows;
    private JRadioButtonMenuItem jRadioButtonMenuItemDrilled;
    private JRadioButtonMenuItem jRadioButtonMenuItemFeet;
    private JRadioButtonMenuItem jRadioButtonMenuItemMetres;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JToolBar.Separator jSeparator3;
    private JPopupMenu.Separator jSeparator4;
    private JPopupMenu.Separator jSeparator5;
    private JToolBar jToolBar1;

    public FrameInterpretations(FrameJsbugs parent, SBdb sbdb, Project project) {
        this.initComponents();
        this.sbdb = sbdb;
        this.parent = parent;
        this.init();
    }

    private void init() {
        super.init("Schemes & Interpretations - StrataBugs", new String[]{"48Int.png", "32Int.png", "24Int.png", "16Int.png"});
        this.setMultiResIconImage("frameInt.svg");
        this.jRadioButtonMenuItemDrilled.setSelected(true);
        if (FrameJsbugs.isMacPlatform()) {
            this.jMenuHelpMenu.setText("Help ");
            this.jMenuItemExit.setText("Close Schemes & Interpretations");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openIGDFrame() {
        DialogIGD dialogIGD;
        if (!SbugsLicense.checkRLMlicense()) {
            JOptionPane.showMessageDialog(this, "StrataBugs licence no longer available.", "StrataBugs", 0);
            this.jMenuItemExitActionPerformed(null);
            return;
        }
        try {
            dialogIGD = new DialogIGD(this, true, this.sbdb);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
            return;
        }
        dialogIGD.setLocationRelativeTo(this);
        dialogIGD.setVisible(true);
        if (!dialogIGD.isOK()) {
            return;
        }
        try {
            Iterator<Well> it;
            if (dialogIGD.project == null) {
                DialogSelectWell dialogWells = new DialogSelectWell(this, true, this.sbdb, true);
                dialogWells.setLocationRelativeTo(this);
                dialogWells.setVisible(true);
                if (dialogWells.getSelection() == null) {
                    return;
                }
                it = dialogWells.getSelection().iterator();
            } else {
                it = this.sbdb.getWellIterator(dialogIGD.project.getID());
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            InternalFrameIGD frame = this.createInternalFrame(dialogIGD.igdType, dialogIGD.interpID);
            String title = IGDInterval.getIGDName(dialogIGD.igdType) + " : " + String.valueOf(this.sbdb.getInterp(dialogIGD.interpID));
            if (dialogIGD.project != null) {
                title = title + " : " + dialogIGD.project.toString();
            }
            frame.setTitle(title);
            while (it.hasNext()) {
                Well well = it.next();
                try {
                    frame.addPane(well);
                }
                catch (SBException sbe) {
                    StackError.showStackError((String)("Error loading tab for well '" + String.valueOf(well) + "'"), (Throwable)sbe);
                }
                catch (SQLException sql) {
                    FrameJsbugs.showStackError("SQLError loading tab for well '" + String.valueOf(well) + "'", sql, this.sbdb);
                }
            }
            frame.setUnits(this.getUnitsFromMenu());
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
        catch (SBException sbe) {
            StackError.showStackError((String)"Error", (Throwable)sbe);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    @Override
    public FrameJsbugs getParent() {
        return this.parent;
    }

    private InternalFrameIGD createInternalFrame(int igdType, int interpID) {
        JInternalFrame[] frames = this.jDesktopPane.getAllFrames();
        InternalFrameIGD frame = new InternalFrameIGD(this, igdType, interpID, this.sbdb);
        this.jDesktopPane.add(frame);
        frame.setTitle("Window #" + (frames.length + 1));
        try {
            frame.setSelected(true);
        }
        catch (PropertyVetoException ex) {
            ex.printStackTrace();
        }
        int margin = frames.length * 24;
        int width = this.jDesktopPane.getBounds().width * 2 / 3 - 24;
        int height = this.jDesktopPane.getBounds().height * 2 / 3 - 24;
        frame.setBounds(frames.length + margin, frames.length + margin, width, height);
        frame.addInternalFrameListener(new InternalFrameAdapter(this){
            final /* synthetic */ FrameInterpretations this$0;
            {
                FrameInterpretations frameInterpretations = this$0;
                Objects.requireNonNull(frameInterpretations);
                this.this$0 = frameInterpretations;
            }

            @Override
            public void internalFrameActivated(InternalFrameEvent evt) {
                SB.jInternalFrameActivated((InternalFrameEvent)evt, (JDesktopPane)this.this$0.jDesktopPane, (JMenu)this.this$0.jMenuWindows);
            }

            @Override
            public void internalFrameClosing(InternalFrameEvent evt) {
                SB.jInternalFrameClosing((InternalFrameEvent)evt, (JDesktopPane)this.this$0.jDesktopPane, (JMenu)this.this$0.jMenuWindows);
            }
        });
        return frame;
    }

    char getUnits() {
        return this.units;
    }

    private void initComponents() {
        this.buttonGroupUnits = new ButtonGroup();
        this.buttonGroupWindows = new ButtonGroup();
        this.jToolBar1 = new JToolBar();
        this.jButtonOpen = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jButtonAddInterval = new JButton();
        this.jButtonEditInterval = new JButton();
        this.jButtonDeleteInterval = new JButton();
        this.jSeparator2 = new JSeparator();
        this.jButtonCascade = new JButton();
        this.jButtonTile = new JButton();
        this.jButtonCloseWindow = new JButton();
        this.jSeparator3 = new JToolBar.Separator();
        this.jButtonOpenChartTemplates = new JButton();
        this.jDesktopPane = new JDesktopPane();
        this.jMenuBar = new JMenuBar();
        this.jMenuFile = new JMenu();
        this.jMenuOpenIGD = new JMenuItem();
        this.jSeparator4 = new JPopupMenu.Separator();
        this.jMenuItemExit = new JMenuItem();
        this.jMenuSchemes = new JMenu();
        this.jCheckBoxMenuScheme = new JCheckBoxMenuItem();
        this.jSeparator5 = new JPopupMenu.Separator();
        this.jCheckBoxMenuItemEnvScheme = new JCheckBoxMenuItem();
        this.jMenuItemAgeCurves = new JMenuItem();
        this.jMenuItemChronSchemes = new JMenuItem();
        this.jMenuItemLithdesc = new JMenuItem();
        this.jMenuUnits = new JMenu();
        this.jRadioButtonMenuItemMetres = new JRadioButtonMenuItem();
        this.jRadioButtonMenuItemFeet = new JRadioButtonMenuItem();
        this.jRadioButtonMenuItemDrilled = new JRadioButtonMenuItem();
        this.jMenuWindows = new JMenu();
        this.jMenuItemCascade = new JMenuItem();
        this.jMenuItemTile = new JMenuItem();
        this.jMenuItemCloseWindow = new JMenuItem();
        this.jMenuItemArrangeIcons = new JMenuItem();
        this.jMenuHelpMenu = new JMenu();
        this.jMenuItemHelpMain = new JMenuItem();
        this.jMenuItemHelpMenu = new JMenuItem();
        this.setDefaultCloseOperation(2);
        this.jToolBar1.setBorder(null);
        this.jToolBar1.setFloatable(false);
        this.jButtonOpen.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/FrameInterpretations_Open.png")));
        this.jButtonOpen.setToolTipText("Open project interpretation");
        this.jButtonOpen.setBorderPainted(false);
        this.jButtonOpen.setMargin(new Insets(4, 4, 2, 4));
        this.jButtonOpen.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameInterpretations this$0;
            {
                FrameInterpretations frameInterpretations = this$0;
                Objects.requireNonNull(frameInterpretations);
                this.this$0 = frameInterpretations;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOpenActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonOpen);
        this.jSeparator1.setOrientation(1);
        this.jSeparator1.setMaximumSize(new Dimension(5, 30));
        this.jToolBar1.add(this.jSeparator1);
        this.jButtonAddInterval.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/FrameInterpretations_AddInterval.png")));
        this.jButtonAddInterval.setToolTipText("Add new interval");
        this.jButtonAddInterval.setBorderPainted(false);
        this.jButtonAddInterval.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameInterpretations this$0;
            {
                FrameInterpretations frameInterpretations = this$0;
                Objects.requireNonNull(frameInterpretations);
                this.this$0 = frameInterpretations;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAddIntervalActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonAddInterval);
        this.jButtonEditInterval.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/FrameInterpretations_EditInterval.png")));
        this.jButtonEditInterval.setToolTipText("Edit selected interval");
        this.jButtonEditInterval.setBorderPainted(false);
        this.jButtonEditInterval.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameInterpretations this$0;
            {
                FrameInterpretations frameInterpretations = this$0;
                Objects.requireNonNull(frameInterpretations);
                this.this$0 = frameInterpretations;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonEditIntervalActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonEditInterval);
        this.jButtonDeleteInterval.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/FrameInterpretations_DeleteInterval.png")));
        this.jButtonDeleteInterval.setToolTipText("Delete selected interval(s)");
        this.jButtonDeleteInterval.setBorderPainted(false);
        this.jButtonDeleteInterval.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameInterpretations this$0;
            {
                FrameInterpretations frameInterpretations = this$0;
                Objects.requireNonNull(frameInterpretations);
                this.this$0 = frameInterpretations;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDeleteIntervalActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonDeleteInterval);
        this.jSeparator2.setOrientation(1);
        this.jSeparator2.setMaximumSize(new Dimension(5, 30));
        this.jToolBar1.add(this.jSeparator2);
        this.jButtonCascade.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/FrameInterpretations_Cascade.png")));
        this.jButtonCascade.setToolTipText("Cascade windows");
        this.jButtonCascade.setBorderPainted(false);
        this.jButtonCascade.setMargin(new Insets(4, 4, 2, 4));
        this.jButtonCascade.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameInterpretations this$0;
            {
                FrameInterpretations frameInterpretations = this$0;
                Objects.requireNonNull(frameInterpretations);
                this.this$0 = frameInterpretations;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCascadeActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonCascade);
        this.jButtonTile.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/FrameInterpretations_Tile.png")));
        this.jButtonTile.setToolTipText("Tile windows");
        this.jButtonTile.setBorderPainted(false);
        this.jButtonTile.setMargin(new Insets(4, 4, 2, 4));
        this.jButtonTile.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameInterpretations this$0;
            {
                FrameInterpretations frameInterpretations = this$0;
                Objects.requireNonNull(frameInterpretations);
                this.this$0 = frameInterpretations;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonTileActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonTile);
        this.jButtonCloseWindow.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/FrameInterpretations_CloseWindow.png")));
        this.jButtonCloseWindow.setToolTipText("Close active window");
        this.jButtonCloseWindow.setBorderPainted(false);
        this.jButtonCloseWindow.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameInterpretations this$0;
            {
                FrameInterpretations frameInterpretations = this$0;
                Objects.requireNonNull(frameInterpretations);
                this.this$0 = frameInterpretations;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCloseWindowActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonCloseWindow);
        this.jToolBar1.add(this.jSeparator3);
        this.jButtonOpenChartTemplates.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/openSchemeTemplate.png")));
        this.jButtonOpenChartTemplates.setBorderPainted(false);
        this.jButtonOpenChartTemplates.setFocusable(false);
        this.jButtonOpenChartTemplates.setHorizontalTextPosition(0);
        this.jButtonOpenChartTemplates.setVerticalTextPosition(3);
        this.jButtonOpenChartTemplates.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameInterpretations this$0;
            {
                FrameInterpretations frameInterpretations = this$0;
                Objects.requireNonNull(frameInterpretations);
                this.this$0 = frameInterpretations;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOpenChartTemplatesActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonOpenChartTemplates);
        this.jDesktopPane.setBackground(new Color(102, 102, 102));
        this.jMenuFile.setText("File");
        this.jMenuOpenIGD.setAccelerator(KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.jMenuOpenIGD.setText("Open project interpretation...");
        this.jMenuOpenIGD.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameInterpretations this$0;
            {
                FrameInterpretations frameInterpretations = this$0;
                Objects.requireNonNull(frameInterpretations);
                this.this$0 = frameInterpretations;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuOpenIGDActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuOpenIGD);
        this.jMenuFile.add(this.jSeparator4);
        this.jMenuItemExit.setText("Exit");
        this.jMenuItemExit.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameInterpretations this$0;
            {
                FrameInterpretations frameInterpretations = this$0;
                Objects.requireNonNull(frameInterpretations);
                this.this$0 = frameInterpretations;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemExitActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemExit);
        this.jMenuBar.add(this.jMenuFile);
        this.jMenuSchemes.setText("Schemes");
        this.jCheckBoxMenuScheme.setAccelerator(KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.jCheckBoxMenuScheme.setText("Stratigraphic Schemes...");
        this.jCheckBoxMenuScheme.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameInterpretations this$0;
            {
                FrameInterpretations frameInterpretations = this$0;
                Objects.requireNonNull(frameInterpretations);
                this.this$0 = frameInterpretations;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jCheckBoxMenuSchemeActionPerformed(evt);
            }
        });
        this.jMenuSchemes.add(this.jCheckBoxMenuScheme);
        this.jMenuSchemes.add(this.jSeparator5);
        this.jCheckBoxMenuItemEnvScheme.setText("Palaeoenvironment Schemes...");
        this.jCheckBoxMenuItemEnvScheme.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameInterpretations this$0;
            {
                FrameInterpretations frameInterpretations = this$0;
                Objects.requireNonNull(frameInterpretations);
                this.this$0 = frameInterpretations;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jCheckBoxMenuItemEnvSchemeActionPerformed(evt);
            }
        });
        this.jMenuSchemes.add(this.jCheckBoxMenuItemEnvScheme);
        this.jMenuItemAgeCurves.setText("Age Curves...");
        this.jMenuItemAgeCurves.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameInterpretations this$0;
            {
                FrameInterpretations frameInterpretations = this$0;
                Objects.requireNonNull(frameInterpretations);
                this.this$0 = frameInterpretations;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemAgeCurvesActionPerformed(evt);
            }
        });
        this.jMenuSchemes.add(this.jMenuItemAgeCurves);
        this.jMenuItemChronSchemes.setText("Magnetostratigraphy...");
        this.jMenuItemChronSchemes.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameInterpretations this$0;
            {
                FrameInterpretations frameInterpretations = this$0;
                Objects.requireNonNull(frameInterpretations);
                this.this$0 = frameInterpretations;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemChronSchemesActionPerformed(evt);
            }
        });
        this.jMenuSchemes.add(this.jMenuItemChronSchemes);
        this.jMenuItemLithdesc.setText("Lithology Description and Grain Size...");
        this.jMenuItemLithdesc.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameInterpretations this$0;
            {
                FrameInterpretations frameInterpretations = this$0;
                Objects.requireNonNull(frameInterpretations);
                this.this$0 = frameInterpretations;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemLithdescActionPerformed(evt);
            }
        });
        this.jMenuSchemes.add(this.jMenuItemLithdesc);
        this.jMenuBar.add(this.jMenuSchemes);
        this.jMenuUnits.setText("Units");
        this.buttonGroupUnits.add(this.jRadioButtonMenuItemMetres);
        this.jRadioButtonMenuItemMetres.setText("Metres");
        this.jRadioButtonMenuItemMetres.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameInterpretations this$0;
            {
                FrameInterpretations frameInterpretations = this$0;
                Objects.requireNonNull(frameInterpretations);
                this.this$0 = frameInterpretations;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonMenuItemMetresActionPerformed(evt);
            }
        });
        this.jMenuUnits.add(this.jRadioButtonMenuItemMetres);
        this.buttonGroupUnits.add(this.jRadioButtonMenuItemFeet);
        this.jRadioButtonMenuItemFeet.setText("Feet");
        this.jRadioButtonMenuItemFeet.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameInterpretations this$0;
            {
                FrameInterpretations frameInterpretations = this$0;
                Objects.requireNonNull(frameInterpretations);
                this.this$0 = frameInterpretations;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonMenuItemFeetActionPerformed(evt);
            }
        });
        this.jMenuUnits.add(this.jRadioButtonMenuItemFeet);
        this.buttonGroupUnits.add(this.jRadioButtonMenuItemDrilled);
        this.jRadioButtonMenuItemDrilled.setText("as Drilled");
        this.jRadioButtonMenuItemDrilled.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameInterpretations this$0;
            {
                FrameInterpretations frameInterpretations = this$0;
                Objects.requireNonNull(frameInterpretations);
                this.this$0 = frameInterpretations;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonMenuItemDrilledActionPerformed(evt);
            }
        });
        this.jMenuUnits.add(this.jRadioButtonMenuItemDrilled);
        this.jMenuBar.add(this.jMenuUnits);
        this.jMenuWindows.setText("Windows");
        this.jMenuItemCascade.setText("Cascade");
        this.jMenuItemCascade.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameInterpretations this$0;
            {
                FrameInterpretations frameInterpretations = this$0;
                Objects.requireNonNull(frameInterpretations);
                this.this$0 = frameInterpretations;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemCascadeActionPerformed(evt);
            }
        });
        this.jMenuWindows.add(this.jMenuItemCascade);
        this.jMenuItemTile.setText("Tile");
        this.jMenuItemTile.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameInterpretations this$0;
            {
                FrameInterpretations frameInterpretations = this$0;
                Objects.requireNonNull(frameInterpretations);
                this.this$0 = frameInterpretations;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemTileActionPerformed(evt);
            }
        });
        this.jMenuWindows.add(this.jMenuItemTile);
        this.jMenuItemCloseWindow.setText("Close active window");
        this.jMenuItemCloseWindow.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameInterpretations this$0;
            {
                FrameInterpretations frameInterpretations = this$0;
                Objects.requireNonNull(frameInterpretations);
                this.this$0 = frameInterpretations;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemCloseWindowActionPerformed(evt);
            }
        });
        this.jMenuWindows.add(this.jMenuItemCloseWindow);
        this.jMenuItemArrangeIcons.setText("Arrange icons");
        this.jMenuItemArrangeIcons.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameInterpretations this$0;
            {
                FrameInterpretations frameInterpretations = this$0;
                Objects.requireNonNull(frameInterpretations);
                this.this$0 = frameInterpretations;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemArrangeIconsActionPerformed(evt);
            }
        });
        this.jMenuWindows.add(this.jMenuItemArrangeIcons);
        this.jMenuBar.add(this.jMenuWindows);
        this.jMenuHelpMenu.setText("Help");
        this.jMenuItemHelpMain.setText("Schemes & Interpretations help...");
        this.jMenuItemHelpMain.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameInterpretations this$0;
            {
                FrameInterpretations frameInterpretations = this$0;
                Objects.requireNonNull(frameInterpretations);
                this.this$0 = frameInterpretations;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemHelpMainActionPerformed(evt);
            }
        });
        this.jMenuHelpMenu.add(this.jMenuItemHelpMain);
        this.jMenuItemHelpMenu.setText("Menus...");
        this.jMenuItemHelpMenu.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameInterpretations this$0;
            {
                FrameInterpretations frameInterpretations = this$0;
                Objects.requireNonNull(frameInterpretations);
                this.this$0 = frameInterpretations;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemHelpMenuActionPerformed(evt);
            }
        });
        this.jMenuHelpMenu.add(this.jMenuItemHelpMenu);
        this.jMenuBar.add(this.jMenuHelpMenu);
        this.setJMenuBar(this.jMenuBar);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jDesktopPane, -1, 970, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jToolBar1, -2, 338, -2).add(0, 0, Short.MAX_VALUE)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jToolBar1, -2, 30, -2).add(8, 8, 8).add((Component)this.jDesktopPane, -1, 823, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButtonEditIntervalActionPerformed(ActionEvent evt) {
        JInternalFrame frame = this.jDesktopPane.getSelectedFrame();
        if (!(frame instanceof InternalFrameIGD)) {
            JOptionPane.showMessageDialog(this, "Select an interpretation", this.getTitle(), 0);
            return;
        }
        ((InternalFrameIGD)frame).editInterval();
    }

    private void jButtonDeleteIntervalActionPerformed(ActionEvent evt) {
        JInternalFrame frame = this.jDesktopPane.getSelectedFrame();
        if (!(frame instanceof InternalFrameIGD)) {
            JOptionPane.showMessageDialog(this, "Select an interpretation", this.getTitle(), 0);
            return;
        }
        ((InternalFrameIGD)frame).deleteIntervals();
    }

    private void jButtonAddIntervalActionPerformed(ActionEvent evt) {
        JInternalFrame frame = this.jDesktopPane.getSelectedFrame();
        if (!(frame instanceof InternalFrameIGD)) {
            JOptionPane.showMessageDialog(this, "Select an interpretation", this.getTitle(), 0);
            return;
        }
        ((InternalFrameIGD)frame).addInterval();
    }

    private void jMenuItemArrangeIconsActionPerformed(ActionEvent evt) {
        JInternalFrame[] frames = this.jDesktopPane.getAllFrames();
        if (frames.length == 0) {
            return;
        }
        for (int i = 0; i <= frames.length; ++i) {
            if (!frames[i].isIcon()) continue;
        }
    }

    private void jMenuItemCloseWindowActionPerformed(ActionEvent evt) {
        this.closeActiveFrame();
    }

    private void jButtonCloseWindowActionPerformed(ActionEvent evt) {
        this.closeActiveFrame();
    }

    private void closeActiveFrame() {
        JInternalFrame frame = this.jDesktopPane.getSelectedFrame();
        if (frame == null) {
            return;
        }
        if (frame == this.frameSchemes) {
            frame.setVisible(false);
            this.jCheckBoxMenuScheme.setSelected(false);
        } else if (frame == this.frameChart) {
            frame.setVisible(false);
        } else {
            try {
                frame.setClosed(true);
            }
            catch (PropertyVetoException pve) {
                pve.printStackTrace();
            }
        }
    }

    private void jMenuItemTileActionPerformed(ActionEvent evt) {
        SB.tile((JDesktopPane)this.jDesktopPane);
    }

    private void jMenuItemCascadeActionPerformed(ActionEvent evt) {
        SB.cascade((JDesktopPane)this.jDesktopPane);
    }

    private void jButtonCascadeActionPerformed(ActionEvent evt) {
        SB.cascade((JDesktopPane)this.jDesktopPane);
    }

    private void jButtonTileActionPerformed(ActionEvent evt) {
        SB.tile((JDesktopPane)this.jDesktopPane);
    }

    private void jCheckBoxMenuSchemeActionPerformed(ActionEvent evt) {
        if (this.jCheckBoxMenuScheme.isSelected()) {
            if (this.frameSchemes == null) {
                this.frameSchemes = new InternalFrameIGDSchemes(this, this.sbdb, this.jCheckBoxMenuScheme);
                this.jDesktopPane.add(this.frameSchemes);
            } else {
                this.frameSchemes.reInit();
            }
            this.frameSchemes.setVisible(true);
        } else if (this.frameSchemes != null) {
            this.frameSchemes.setVisible(false);
        }
    }

    private void jMenuOpenIGDActionPerformed(ActionEvent evt) {
        this.openIGDFrame();
    }

    private void jButtonOpenActionPerformed(ActionEvent evt) {
        this.openIGDFrame();
    }

    private void jMenuItemExitActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jCheckBoxMenuItemEnvSchemeActionPerformed(ActionEvent evt) {
        try {
            if (this.jCheckBoxMenuItemEnvScheme.isSelected()) {
                if (this.frameEnvSchemes == null) {
                    this.frameEnvSchemes = new InternalFrameEnvSchemes(this, this.sbdb, this.jCheckBoxMenuItemEnvScheme);
                    this.jDesktopPane.add(this.frameEnvSchemes);
                }
                this.frameEnvSchemes.setVisible(true);
            } else if (this.frameEnvSchemes != null) {
                this.frameEnvSchemes.setVisible(false);
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
        catch (IllegalStateException s) {
            FrameJsbugs.showStackError("Error", s, this.sbdb);
        }
    }

    private void jMenuItemLithdescActionPerformed(ActionEvent evt) {
        try {
            DialogLithdesc dialog = new DialogLithdesc((Frame)this, true, this.sbdb);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error opening frame:" + e.getMessage());
            e.printStackTrace();
        }
    }

    private void jMenuItemHelpMainActionPerformed(ActionEvent evt) {
        HelpUtils.openHelp((String)"schemes.html");
    }

    private void jMenuItemHelpMenuActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("schemes_menu.html");
    }

    private void jRadioButtonMenuItemMetresActionPerformed(ActionEvent evt) {
        this.setUnits('M');
    }

    private void jRadioButtonMenuItemFeetActionPerformed(ActionEvent evt) {
        this.setUnits('F');
    }

    private void jRadioButtonMenuItemDrilledActionPerformed(ActionEvent evt) {
        this.setUnits('D');
    }

    private void jMenuItemAgeCurvesActionPerformed(ActionEvent evt) {
        DialogAgeCurves dialog = new DialogAgeCurves((Frame)this, true, this.sbdb);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }

    private void jButtonOpenChartTemplatesActionPerformed(ActionEvent evt) {
        if (this.frameChart != null) {
            if (!this.frameChart.isVisible()) {
                this.frameChart.setVisible(true);
            } else {
                this.frameChart.openTemplate();
            }
            return;
        }
        this.initFrameChart();
        if (!this.frameChart.hasCharts()) {
            DialogChartTemplates dialog = new DialogChartTemplates(this, true, this.sbdb, this.parent.getChartManager(), BlockType.SCHEME, null, null);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.selection != null && dialog.selection.size() == 1 && dialog.selection.get(0) instanceof BlockTemplate) {
                BlockTemplate templ = (BlockTemplate)dialog.selection.get(0);
                this.frameChart.addBlockTemplateTab(templ, null, null, true, null, null, 0);
            }
        }
        this.frameChart.setVisible(true);
    }

    private void jMenuItemChronSchemesActionPerformed(ActionEvent evt) {
        try {
            DialogChronSchemes dialog = new DialogChronSchemes(this, true, this.sbdb);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
    }

    void setUnits(char units) {
        JInternalFrame[] frames;
        for (JInternalFrame frame : frames = this.jDesktopPane.getAllFrames()) {
            if (!(frame instanceof InternalFrameIGD)) continue;
            InternalFrameIGD frameIGD = (InternalFrameIGD)frame;
            frameIGD.setUnits(units);
        }
        this.units = units;
    }

    private void initFrameChart() {
        if (this.frameChart != null) {
            return;
        }
        AbstractAction lastTabClosedAction = new AbstractAction(this){
            final /* synthetic */ FrameInterpretations this$0;
            {
                FrameInterpretations frameInterpretations = this$0;
                Objects.requireNonNull(frameInterpretations);
                this.this$0 = frameInterpretations;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.frameChart.dispose();
                this.this$0.frameChart = null;
            }
        };
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.frameChart = InternalFrameChart.createLoadedInstance("INTS", this, this.sbdb, this.parent.getChartManager(), "Scheme Chart Blocks", lastTabClosedAction);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
        if (this.frameChart == null) {
            this.frameChart = new InternalFrameChart(this, this.sbdb, this.parent.getChartManager(), "Scheme Chart Blocks", lastTabClosedAction, "INTS");
        }
        this.frameChart.addInternalFrameListener(new InternalFrameAdapter(this){
            final /* synthetic */ FrameInterpretations this$0;
            {
                FrameInterpretations frameInterpretations = this$0;
                Objects.requireNonNull(frameInterpretations);
                this.this$0 = frameInterpretations;
            }

            @Override
            public void internalFrameClosing(InternalFrameEvent e) {
                this.this$0.frameChart.setVisible(false);
            }
        });
        int width = this.jDesktopPane.getWidth() / 2;
        this.frameChart.reshape(this.jDesktopPane.getWidth() - width, this.jDesktopPane.getY(), width, this.jDesktopPane.getHeight());
        this.jDesktopPane.add(this.frameChart);
    }

    void drawScheme(List<Object> schemes) throws SQLException {
        ArrayList<PanelTemplate> panels = new ArrayList<PanelTemplate>();
        Double minAge = null;
        Double maxAge = null;
        try {
            if (schemes != null) {
                for (Object scheme : schemes) {
                    PanelType[] pTypes = null;
                    double min = 0.0;
                    double max = 0.0;
                    int schemeID = 0;
                    if (scheme instanceof IGDScheme) {
                        PanelType type = PanelType.getSchemeType(((IGDScheme)scheme).getIGDType());
                        schemeID = ((IGDScheme)scheme).getID();
                        min = ((IGDScheme)scheme).getMinAge();
                        max = ((IGDScheme)scheme).getMaxAge();
                        pTypes = type == PanelType.SEQUENCE ? new PanelType[]{PanelType.SEQUENCE, PanelType.SURFACE} : new PanelType[]{type};
                    } else if (scheme instanceof CompositeStandard) {
                        pTypes = new PanelType[]{PanelType.CMPSTD};
                        schemeID = ((CompositeStandard)scheme).getStdID();
                        min = ((CompositeStandard)scheme).getMinAge();
                        max = ((CompositeStandard)scheme).getMaxAge();
                    } else if (scheme instanceof AgeCurve) {
                        pTypes = new PanelType[]{PanelType.AGECURVE};
                        schemeID = ((AgeCurve)scheme).getCurveID();
                        min = ((AgeCurve)scheme).getYoungest();
                        max = ((AgeCurve)scheme).getOldest();
                    }
                    if (pTypes == null) {
                        JOptionPane.showMessageDialog(this, String.valueOf(scheme) + " not supported", this.getTitle(), 2);
                        continue;
                    }
                    for (PanelType pType : pTypes) {
                        boolean schemeAdded = false;
                        ArrayList<PanelTemplate> candidates = new ArrayList<PanelTemplate>();
                        for (PanelTemplate panel : this.parent.getChartManager().getPanels(pType, 0, true)) {
                            int panelSchemeID = 0;
                            switch (pType) {
                                case CHRONOSCHEME: 
                                case LITHOSCHEME: 
                                case BIOSCHEME: 
                                case SEQUENCE: 
                                case SURFACE: {
                                    panelSchemeID = panel.getProperties().getIGDSchemeID();
                                    break;
                                }
                                case CMPSTD: {
                                    panelSchemeID = panel.getProperties().getCmpStdID();
                                    break;
                                }
                                case AGECURVE: {
                                    panelSchemeID = panel.getProperties().getAgeCurveID();
                                    break;
                                }
                                default: {
                                    assert (false);
                                    break;
                                }
                            }
                            if (panelSchemeID != schemeID) continue;
                            candidates.add(panel);
                        }
                        if (!candidates.isEmpty()) {
                            if (candidates.size() == 1) {
                                panels.add((PanelTemplate)candidates.get(0));
                            } else {
                                DialogList dialog = new DialogList(this, true, "Select Panel Template", null, candidates, true, false);
                                dialog.setLocationRelativeTo(this);
                                dialog.setVisible(true);
                                dialog.getOptionalSelection().ifPresent(panelTemplate -> panels.add((PanelTemplate)panelTemplate));
                            }
                            schemeAdded = true;
                        }
                        if (!schemeAdded) {
                            if (SBRestrictable.canWrite(this.sbdb)) {
                                int opt = JOptionPane.showConfirmDialog(this, "No global panel template for scheme '" + String.valueOf(scheme) + "'.\nDo you want to create one?", this.getTitle(), 0);
                                if (opt == 0) {
                                    String comments = "Generated in Schemes & Interpretations";
                                    panels.add(this.parent.getChartManager().addPanelTemplate(pType, scheme.toString(), comments, 0, null, scheme, true));
                                    schemeAdded = true;
                                }
                            } else {
                                JOptionPane.showMessageDialog(this, "No global panel template for scheme '" + String.valueOf(scheme) + "'.\nYou do not have permission to create one.", this.getTitle(), 2);
                            }
                        }
                        if (!schemeAdded) continue;
                        if (minAge == null || min < minAge) {
                            minAge = min;
                        }
                        if (maxAge != null && !(max > maxAge)) continue;
                        maxAge = max;
                    }
                }
            }
        }
        catch (SBException | SBPermissionException sbe) {
            SbugsExceptionHandler.showStackError("Error", sbe);
        }
        if (panels.isEmpty()) {
            System.out.println("Panels was empty");
            return;
        }
        if (this.frameChart == null) {
            this.initFrameChart();
        }
        try {
            this.frameChart.addStandardSchemePanels(panels, minAge == null ? 0.0f : minAge.floatValue(), maxAge == null ? 0.0f : maxAge.floatValue());
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
        this.frameChart.setVisible(true);
    }

    private char getUnitsFromMenu() {
        if (this.jRadioButtonMenuItemMetres.isSelected()) {
            return 'M';
        }
        if (this.jRadioButtonMenuItemFeet.isSelected()) {
            return 'F';
        }
        if (this.jRadioButtonMenuItemDrilled.isSelected()) {
            return 'D';
        }
        return 'M';
    }
}

