/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.taxon.SynonymScheme;
import com.stratadata.model3.user.Userdef;
import com.stratadata.model3.well.sample.SampleType;
import com.stratadata.sbconnect.DialogConnectionManager;
import com.stratadata.sblicense.LicenseException;
import com.stratadata.sblicense.SbugsLicense;
import com.stratadata.util.DateUtils;
import com.stratadata.util.io.FileChooserUtils;
import com.stratadata.util.preferences.ProxySettings;
import com.stratadata.util.preferences.RegistryPreferencesHelper;
import com.stratadata.util.script.DialogSQLQuery;
import com.stratadata.util.ui.HelpUtils;
import com.stratadata.util.ui.SbugsLookAndFeelSetup;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.desktop.QuitEvent;
import java.awt.desktop.QuitHandler;
import java.awt.desktop.QuitResponse;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.net.ssl.HttpsURLConnection;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import jsbchart.block.BlockProperties;
import jsbchart.core.ChartManager;
import jsbchart.core.ChartTemplateBase;
import jsbugs.DialogAuditTrail;
import jsbugs.DialogAutoMergeTaxa;
import jsbugs.DialogBackup;
import jsbugs.DialogChartScales;
import jsbugs.DialogDBInfo;
import jsbugs.DialogEventPrefix;
import jsbugs.DialogHelpAbout;
import jsbugs.DialogHierNames;
import jsbugs.DialogList;
import jsbugs.DialogLogDefs;
import jsbugs.DialogMiscColours;
import jsbugs.DialogSBChartLogPath;
import jsbugs.DialogSelectProjectWellList;
import jsbugs.FrameChart;
import jsbugs.FrameInterpretations;
import jsbugs.FrameOrganiser;
import jsbugs.FrameOverlay;
import jsbugs.FrameSamples;
import jsbugs.FrameTaxaDB;
import jsbugs.FrameWells;
import jsbugs.FrameWellsSession;
import jsbugs.JPanelWell;
import jsbugs.abnsch.DialogAbnSchemes;
import jsbugs.chartgen.DialogChartGen;
import jsbugs.imagestorage.DialogManageImages;
import jsbugs.refresh.DialogManualRefresh;
import jsbugs.refresh.DialogRefresh;
import jsbugs.refresh.RefreshHelper;
import jsbugs.tools.DialogLogging;
import jsbugs.tools.DialogMemoryMonitor;
import jsbugs.tools.DialogSbugsServer;
import jsbugs.tools.SbugsServerConfigController;
import jsbugs.uiutil.icon.IconFactory;
import jsbugs.userconnect.DialogProxySettings;
import jsbugs.userconnect.DialogRLMRoam;
import jsbugs.userconnect.DialogSelectAnalyst;
import jsbugs.userconnect.Jsbugs;
import jsbugs.userconnect.SbugsExceptionHandler;
import jsbugs.userconnect.SbugsSession;
import jsbugs.userconnect.UserServiceNotAvailableException;
import jsbugs.util.SBFrame;
import jsbugs.util.UserPrefsHelper;
import jsbugs.wellheader.DialogSelectWell;
import model3.IGDIntervalZone;
import model3.InterpHdr;
import model3.Lastval;
import model3.SBEvent;
import model3.SBdb;
import model3.Smpdtl;
import model3.Taxon;
import model3.Well;
import model3.project.Project;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.xmlbeans.XmlOptions;
import org.jdesktop.layout.GroupLayout;
import util.InvalidFieldException;
import util.SB;
import util.SBException;
import util.exception.SqlCache;
import util.exception.StackError;

public class FrameJsbugs
extends SBFrame {
    SBdb sbdb = null;
    String jarFileRoot = "jsbugs-3.0.";
    FrameSamples samplesFrame = null;
    HashSet<FrameOrganiser> organiserFrames = new HashSet();
    FrameChart chartFrame = null;
    FrameWells wellsFrame = null;
    FrameTaxaDB taxadbFrame = null;
    private FrameOverlay frameOverlay = null;
    FrameInterpretations interpretationsFrame = null;
    private Project project;
    Image backgroundImage;
    private ChartManager chartManager;
    private boolean showHints = true;
    private static final String SHOW_HINTS_PREF = "SHOWHINTS";
    private static final Logger LOGGER = Logger.getLogger(FrameJsbugs.class.getName());
    ResourceBundle bundle = ResourceBundle.getBundle("locale/UiText");
    UserPrefsHelper userPrefsHelper;
    private ButtonGroup buttonGroupEnvPref;
    private ButtonGroup buttonGroupHelpLocation;
    private ButtonGroup buttonGroupLGSSamplePrec;
    private ButtonGroup buttonGroupLandF;
    private ButtonGroup buttonGroupSampleDepths;
    private ButtonGroup buttonGroupSizes;
    private JButton jButtonCharts;
    private JButton jButtonInt;
    private JButton jButtonOrganiser;
    private JButton jButtonSamples;
    private JButton jButtonTaxaDB;
    private JButton jButtonWells;
    private JCheckBoxMenuItem jCheckBoxMenuItemAllowCountryCase;
    private JCheckBoxMenuItem jCheckBoxMenuItemDelayUpdateReminder;
    private JCheckBoxMenuItem jCheckBoxMenuItemExportSingleUser;
    private JCheckBoxMenuItem jCheckBoxMenuItemHelpHints;
    private JCheckBoxMenuItem jCheckBoxMenuItemHiResIcons;
    private JCheckBoxMenuItem jCheckBoxMenuItemQueryPDFfont;
    private JCheckBoxMenuItem jCheckBoxMenuItemSQLtoCmd;
    private JCheckBoxMenuItem jCheckBoxMenuItemShowArchivedSchemes;
    private JCheckBoxMenuItem jCheckBoxMenuItemShowUpdatePopup;
    private JCheckBoxMenuItem jCheckBoxMenuItemWjsbugs;
    private JLabel jLabelCharts;
    private JLabel jLabelDB;
    private JLabel jLabelInt;
    private JLabel jLabelLicencee;
    private JLabel jLabelLiceneType;
    private JLabel jLabelLocation;
    private JLabel jLabelOrganiser;
    private JLabel jLabelRefresh;
    private JLabel jLabelSamples;
    private JLabel jLabelTaxaDB;
    private JLabel jLabelUpdates;
    private JLabel jLabelUser;
    private JLabel jLabelWells;
    private JMenu jMenu1;
    private JMenu jMenu2;
    private JMenu jMenu3;
    private JMenu jMenu4;
    private JMenuBar jMenuBar1;
    private JMenu jMenuConfig;
    private JMenu jMenuDisplay;
    private JMenu jMenuEnvEntry;
    private JMenu jMenuExport;
    private JMenu jMenuFile;
    private JMenu jMenuHelp;
    private JMenuItem jMenuItemAuditTrail;
    private JMenuItem jMenuItemBackup;
    private JMenuItem jMenuItemCentreWindow;
    private JMenuItem jMenuItemChartGen;
    private JMenuItem jMenuItemChartScales;
    private JMenuItem jMenuItemConfigAbn;
    private JMenuItem jMenuItemConfigPersonnel;
    private JMenuItem jMenuItemConnect;
    private JMenuItem jMenuItemContents;
    private JMenuItem jMenuItemDBInfo;
    private JMenuItem jMenuItemEditWirelineLogPaths;
    private JMenuItem jMenuItemEventPrefix;
    private JMenuItem jMenuItemExit;
    private JMenuItem jMenuItemExportABR;
    private JMenuItem jMenuItemHelpAbout;
    private JMenuItem jMenuItemHelpCP;
    private JMenuItem jMenuItemHierNames;
    private JMenuItem jMenuItemImageStorage;
    private JMenuItem jMenuItemLoad;
    private JMenuItem jMenuItemLogDef;
    private JMenuItem jMenuItemLogging;
    private JMenuItem jMenuItemManageConnections;
    private JMenuItem jMenuItemManualRefresh;
    private JMenuItem jMenuItemMemoryMonitor;
    private JMenuItem jMenuItemMergeDuplicateEvents;
    private JMenuItem jMenuItemMiscColours;
    private JMenuItem jMenuItemNullBaseDepths;
    private JMenuItem jMenuItemNullTopDepths;
    private JMenuItem jMenuItemQuery;
    private JMenuItem jMenuItemRLMRoam;
    private JMenuItem jMenuItemRefresh;
    private JMenuItem jMenuItemSBUpdate;
    private JMenuItem jMenuItemSBconvert;
    private JMenuItem jMenuItemSbugsServerConfig;
    private JMenuItem jMenuItemScreen;
    private JMenuItem jMenuItemWjsbugsAbout;
    private JMenuItem jMenuItemWjsbugsProxy;
    private JMenuItem jMenuItemautoMergeTaxa;
    private JMenu jMenuSampleDepths;
    private JMenu jMenuSetHelpLocation;
    private JMenu jMenuTextSizes;
    private JMenu jMenuTools;
    private JMenu jMenuWjsbugs;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanelCharts;
    private JPanel jPanelInfo;
    private JPanel jPanelInt;
    private JPanel jPanelOrganiser;
    private JPanel jPanelSamples;
    private JPanel jPanelTaxaDB;
    private JPanel jPanelWells;
    private JRadioButtonMenuItem jRadioButtonMenuItemDepthsBase;
    private JRadioButtonMenuItem jRadioButtonMenuItemDepthsTop;
    private JRadioButtonMenuItem jRadioButtonMenuItemFlatDarkLAF;
    private JRadioButtonMenuItem jRadioButtonMenuItemFlatLightLAF;
    private JRadioButtonMenuItem jRadioButtonMenuItemGuiSizes100;
    private JRadioButtonMenuItem jRadioButtonMenuItemGuiSystem;
    private JRadioButtonMenuItem jRadioButtonMenuItemHelpLocalFF;
    private JRadioButtonMenuItem jRadioButtonMenuItemHelpLocalFolder;
    private JRadioButtonMenuItem jRadioButtonMenuItemHelpLocalIE;
    private JRadioButtonMenuItem jRadioButtonMenuItemHelpWeb;
    private JRadioButtonMenuItem jRadioButtonMenuItemLOG1;
    private JRadioButtonMenuItem jRadioButtonMenuItemLOG2;
    private JRadioButtonMenuItem jRadioButtonMenuItemLOG3;
    private JRadioButtonMenuItem jRadioButtonMenuItemMultiple;
    private JRadioButtonMenuItem jRadioButtonMenuItemNativeLAF;
    private JRadioButtonMenuItem jRadioButtonMenuItemSingle;
    private JPopupMenu.Separator jSeparator1;
    private JPopupMenu.Separator jSeparator10;
    private JPopupMenu.Separator jSeparator11;
    private JPopupMenu.Separator jSeparator2;
    private JPopupMenu.Separator jSeparator3;
    private JPopupMenu.Separator jSeparator5;
    private JPopupMenu.Separator jSeparator6;
    private JPopupMenu.Separator jSeparator7;
    private JPopupMenu.Separator jSeparator8;
    private JPopupMenu.Separator jSeparator9;

    public FrameJsbugs() {
        this.preComponentInit();
        this.initComponents();
        this.init();
        if (SbugsLicense.isCloseToExpiry()) {
            String string = SbugsLicense.getDaysToExpiration() - 1 + " " + this.bundle.getString("FrameJsbugs.licenceremaining");
            string = SbugsLicense.isRoaming() ? string + "\n" + this.bundle.getString("FrameJsbugs.licenceroaming") : string + "\n" + this.bundle.getString("FrameJsbugs.licencerenewal");
            JOptionPane.showMessageDialog(null, string, "StrataBugs", 2);
        }
        try {
            this.sbdb = SbugsSession.getDb();
            this.chartManager = SbugsSession.getSession().getChartManager();
            this.userPrefsHelper = new UserPrefsHelper(this.sbdb);
            this.afterConnect();
            BlockProperties.loadDefaults(this.sbdb);
        }
        catch (SQLException ex) {
            JOptionPane.showMessageDialog(null, "SQL Error: " + ex.getMessage(), this.getTitle(), 0);
            ex.printStackTrace();
            System.exit(1);
        }
        this.setUpdatesLabel();
        this.setExportDataMenu();
        try {
            String hints = Lastval.getString(this.sbdb, SHOW_HINTS_PREF);
            if (!hints.isEmpty()) {
                this.showHints = Boolean.valueOf(hints);
            }
            boolean which = this.sbdb.getAllowMultipleEnvSchemes();
            this.jRadioButtonMenuItemMultiple.setSelected(which);
            this.jRadioButtonMenuItemSingle.setSelected(!which);
            this.jCheckBoxMenuItemQueryPDFfont.setSelected(Lastval.getInt(this.sbdb, "PDFQEMBED", 0) == 1);
        }
        catch (SQLException sql) {
            sql.printStackTrace();
        }
        this.jCheckBoxMenuItemHelpHints.setSelected(this.showHints());
        this.jCheckBoxMenuItemWjsbugs.setSelected(SbugsSession.getSession().useWjsbugs());
        this.jCheckBoxMenuItemShowArchivedSchemes.setSelected(this.sbdb.getShowArchivedSchemes());
        this.showPOIClasspath();
    }

    public ChartManager getChartManager() {
        return this.chartManager;
    }

    public boolean showHints() {
        return this.showHints;
    }

    public void setHints(boolean on) {
        if (on == this.showHints) {
            return;
        }
        try {
            Lastval.putString(this.sbdb, SHOW_HINTS_PREF, Boolean.toString(on));
            this.sbdb.commit();
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
        this.showHints = on;
        this.jCheckBoxMenuItemHelpHints.setSelected(this.showHints);
    }

    private void setUpdatesLabel() {
        boolean clearUpdateMessage = true;
        int latestRelease = this.checkForUpdate();
        if (latestRelease > 0) {
            File releasedJarFile = new File(this.jarFileRoot + latestRelease + ".jar");
            File dir = new File(".");
            File appFileDir = new File("app");
            if (!FrameJsbugs.isMacPlatform() && appFileDir.exists()) {
                dir = appFileDir;
                releasedJarFile = new File("app" + File.separator + releasedJarFile.getName());
            }
            int localJarVersion = 0;
            for (File f : dir.listFiles()) {
                int j;
                if (!f.getName().startsWith(this.jarFileRoot) || (j = this.parseJarFileVersion(f, this.jarFileRoot)) <= localJarVersion) continue;
                localJarVersion = j;
            }
            LOGGER.log(Level.CONFIG, "Looking for: {0}, installed version is: " + localJarVersion, releasedJarFile.getPath());
            if (localJarVersion > 0 && !releasedJarFile.exists() && localJarVersion < latestRelease) {
                this.jLabelUpdates.setText(this.bundle.getString("FrameJsbugs.updateavailable"));
                Preferences regPrefs = RegistryPreferencesHelper.getPreferences();
                boolean showPopup = regPrefs.getBoolean("update-popup", true);
                this.jLabelUpdates.setForeground(showPopup ? new Color(200, 0, 0) : Color.darkGray);
                this.jLabelUpdates.setToolTipText("<html>Current release: <strong>" + latestRelease + "</strong><br/>Download updates using 'Look for updates' or reinstall</html>");
                clearUpdateMessage = false;
                if (showPopup) {
                    if (appFileDir.exists() || FrameJsbugs.isMacPlatform()) {
                        String instructions = FrameJsbugs.isMacPlatform() ? "You should reinstall StrataBugs v3.0 when convenient" : "You should uninstall StrataBugs v3.0, download installer from StrataData web site, and reinstall when convenient";
                        JOptionPane.showMessageDialog(null, "Update available to v3.0." + latestRelease + ".\n" + instructions, this.getTitle(), 1);
                    } else if (JOptionPane.showConfirmDialog(null, "Update available to v3.0." + latestRelease + ", do you want try to run the updater now?", this.getTitle(), 0, 3) == 0) {
                        this.jMenuItemSBUpdateActionPerformed(null);
                    }
                }
            }
        }
        if (clearUpdateMessage) {
            this.jLabelUpdates.setText(" ");
            this.jLabelUpdates.setToolTipText(null);
        }
    }

    private int parseJarFileVersion(File f, String jarFileRoot) {
        int localJarVersion = 0;
        String appJarVersionStrg = f.getName().substring(jarFileRoot.length());
        for (int i = 0; i < appJarVersionStrg.length(); ++i) {
            if (Character.isDigit(appJarVersionStrg.charAt(i))) continue;
            appJarVersionStrg = appJarVersionStrg.substring(0, i);
            try {
                localJarVersion = Integer.parseInt(appJarVersionStrg);
            }
            catch (NumberFormatException e) {
                LOGGER.log(Level.INFO, "Can't parse installed application version string: {0}", appJarVersionStrg);
            }
            break;
        }
        return localJarVersion;
    }

    void addSamplesWell(Well well, boolean makeVisible) throws SQLException, SBException {
        if (this.samplesFrame == null) {
            this.samplesFrame = new FrameSamples(this, this.sbdb, well, false);
        } else {
            this.samplesFrame.addWellTab(well);
        }
        if (makeVisible) {
            this.samplesFrame.setVisible(true);
        }
    }

    void setSamplesSmpdtl(Well well, Smpdtl smpdtl) throws SQLException, SBException {
        this.addSamplesWell(well, true);
        JPanelWell wellPanel = this.samplesFrame.addWellTab(well);
        this.samplesFrame.setSelectedWellTab(wellPanel);
        wellPanel.setSmpdtl(smpdtl);
    }

    void setSamplesWell(Well well) throws SQLException, SBException {
        this.addSamplesWell(well, true);
        JPanelWell wellPanel = this.samplesFrame.addWellTab(well);
    }

    void setProject(Project project) {
        this.project = project;
    }

    public final void reconnect(boolean force, boolean alwaysShowLoginDialog) throws SQLException {
        if (this.sbdb != null && this.sbdb.isConnected()) {
            if (!force && JOptionPane.showConfirmDialog(this, this.bundle.getString("FrameJsbugs.closeconnection"), this.getTitle(), 0, 3) != 0) {
                return;
            }
            RefreshHelper.stopRefresh();
            SbugsSession.endSession();
            this.sbdb = null;
            if (this.interpretationsFrame != null) {
                this.interpretationsFrame.dispose();
                this.interpretationsFrame = null;
            }
            if (this.wellsFrame != null) {
                this.wellsFrame.dispose();
                this.wellsFrame = null;
            }
            if (this.samplesFrame != null) {
                this.samplesFrame.dispose();
                this.samplesFrame = null;
            }
            if (this.chartFrame != null) {
                this.chartFrame.dispose();
                this.chartFrame = null;
            }
            for (FrameOrganiser frame : this.organiserFrames) {
                frame.dispose();
            }
            this.organiserFrames.clear();
            if (this.frameOverlay != null) {
                this.frameOverlay.dispose();
                this.frameOverlay = null;
            }
            this.chartManager = null;
        }
        SbugsSession.startSession(true);
        SbugsSession.getSession();
        this.sbdb = SbugsSession.getDb();
        this.chartManager = SbugsSession.getSession().getChartManager();
        this.afterConnect();
    }

    private void afterConnect() {
        try {
            this.jLabelUser.setText(this.sbdb.getUser().getNameID());
            this.jLabelLicencee.setText(this.sbdb.getLicenceCustomer().getCompany());
            this.jLabelLocation.setText(this.sbdb.getLicenceCustomer().getLocation());
            Object licenceType = SbugsLicense.isRoaming() ? this.bundle.getString("FrameJsbugs.licenceserver") : this.bundle.getString("FrameJsbugs.licence") + " " + SbugsLicense.getHostType();
            this.jLabelLiceneType.setText((String)licenceType);
            this.jLabelDB.setText(SbugsSession.getConnectionName());
            this.setCurrent();
            Taxon.includeAuthorInString = Lastval.getInt(this.sbdb, "TAXONAUTH") > 0;
            Taxon.includeCategoryInString = Lastval.getInt(this.sbdb, "TAXONCAT") > 0;
            Taxon.includeAlphaInString = Lastval.getInt(this.sbdb, "TAXONALPHA") > 0;
            this.setSampleTops();
            this.initLogDpMenu();
            if (this.sbdb != null) {
                this.jCheckBoxMenuItemAllowCountryCase.setSelected(this.sbdb.getAllowCountryCase());
            }
            this.initIcons();
            try {
                IGDIntervalZone.loadHierNames(this.sbdb);
            }
            catch (SQLException sql) {
                FrameJsbugs.showStackError("SQL Error loading hier names", sql, this.sbdb);
            }
            catch (RuntimeException re) {
                StackError.showStackError((String)"", (Throwable)re);
            }
            this.startRefresh();
        }
        catch (SQLException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "Error getting database connection: " + e.getMessage() + "\nSQL: " + SqlCache.getSql(), this.getTitle(), 0);
            System.exit(1);
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "Error getting database connection: " + e.getMessage(), this.getTitle(), 0);
            System.exit(1);
        }
    }

    private int checkForUpdate() {
        int releasedVersion = 0;
        int libraryVersion = 0;
        String javaVersion = null;
        Date releaseDate = null;
        Preferences regPrefs = RegistryPreferencesHelper.getPreferences();
        boolean delayUpdateNotification = regPrefs.getBoolean("update-delay", true);
        SimpleDateFormat df = new SimpleDateFormat("dd-MM-yyyy");
        String releaseFileLocation = "https://www.stratadata.co.uk/StrataBugs/" + Jsbugs.APP_VERSION + "/update/Release.txt";
        int timeout = 3000;
        try {
            String line;
            URL releasedFileUrl = new URI(releaseFileLocation).toURL();
            LOGGER.log(Level.CONFIG, "Checking for update file at {0}", releaseFileLocation);
            URLConnection con = releasedFileUrl.openConnection();
            con.setConnectTimeout(3000);
            con.setReadTimeout(3000);
            con.connect();
            BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
            int nLine = 0;
            while ((line = in.readLine()) != null) {
                if (line.contains("#") || line.isBlank()) continue;
                switch (++nLine) {
                    case 1: {
                        releasedVersion = Integer.parseInt(line);
                        break;
                    }
                    case 2: {
                        libraryVersion = Integer.parseInt(line);
                        break;
                    }
                    case 3: {
                        javaVersion = line;
                        break;
                    }
                    case 4: {
                        releaseDate = df.parse(line);
                    }
                }
            }
            if (releaseDate != null && delayUpdateNotification) {
                Date today = new Date();
                Date adjustedReleaseDate = DateUtils.businessDaysFrom(releaseDate, (int)2);
                if (DateUtils.businessDaysFrom((Date)releaseDate, (int)2).after(today)) {
                    releasedVersion = 0;
                }
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Error checking for update", ex);
        }
        return releasedVersion;
    }

    private void startRefresh() {
        boolean refreshIsRunning = RefreshHelper.startRefresh(this.jLabelRefresh);
        this.jLabelRefresh.setText(refreshIsRunning ? "Refresh pending..." : "Data refresh off");
        this.jLabelRefresh.setForeground(refreshIsRunning ? Color.BLACK : Color.GRAY);
    }

    private void preComponentInit() {
        this.backgroundImage = Toolkit.getDefaultToolkit().createImage(FrameJsbugs.class.getResource("/resources/icon/ControlPanel.gif"));
    }

    @Deprecated
    public static void openHelp(String page) {
        HelpUtils.openHelp((String)page);
    }

    private void init() {
        super.init("StrataBugs", new String[]{"icon_128x128.png", "icon_48x48.png", "icon_32x32.png", "icon_24x24.png", "icon_16x16.png"});
        this.setTitle("StrataBugs");
        HelpUtils.HelpLocation location = HelpUtils.initHelp();
        switch (location) {
            case IE: {
                this.jRadioButtonMenuItemHelpLocalIE.setSelected(true);
                break;
            }
            case FF: {
                this.jRadioButtonMenuItemHelpLocalFF.setSelected(true);
                break;
            }
            case LOCAL: {
                this.jRadioButtonMenuItemHelpLocalFolder.setSelected(true);
                break;
            }
            default: {
                this.jRadioButtonMenuItemHelpWeb.setSelected(true);
            }
        }
        boolean resizegui = RegistryPreferencesHelper.getGuiResizePreference(true);
        this.jRadioButtonMenuItemGuiSizes100.setSelected(resizegui);
        this.jRadioButtonMenuItemGuiSystem.setSelected(!resizegui);
        LOGGER.log(Level.INFO, "Max Memory: {0}", String.format("%,d", Runtime.getRuntime().maxMemory()));
        UIManager.put("List.timeFactor", 500L);
        if (FrameJsbugs.isMacPlatform()) {
            this.jMenuHelp.remove(this.jMenuItemHelpAbout);
            Desktop desktop = Desktop.getDesktop();
            desktop.setAboutHandler(e -> this.showAbout());
            this.jMenuFile.remove(this.jMenuItemExit);
            desktop.setQuitHandler(new QuitHandler(this){
                final /* synthetic */ FrameJsbugs this$0;
                {
                    FrameJsbugs frameJsbugs = this$0;
                    Objects.requireNonNull(frameJsbugs);
                    this.this$0 = frameJsbugs;
                }

                @Override
                public void handleQuitRequestWith(QuitEvent evt, QuitResponse res) {
                    this.this$0.jMenuItemExitActionPerformed(null);
                    res.cancelQuit();
                }
            });
            this.jMenuHelp.setText("Help ");
            this.setTitle("Control Panel");
        }
        if (SbugsLicense.canRoam()) {
            this.jMenuItemRLMRoam.setEnabled(true);
        }
        if (FrameJsbugs.isMacPlatform()) {
            this.jRadioButtonMenuItemNativeLAF.setText("Use native MacOS look and feel");
        }
        this.setLAFMenuItem();
        this.jCheckBoxMenuItemWjsbugs.setSelected(false);
        this.jCheckBoxMenuItemWjsbugs.setEnabled(false);
        LOGGER.log(Level.INFO, "Locale: {0}", Locale.getDefault());
        Preferences regPrefs = RegistryPreferencesHelper.getPreferences();
        this.jCheckBoxMenuItemShowUpdatePopup.setSelected(regPrefs.getBoolean("update-popup", true));
        this.jCheckBoxMenuItemDelayUpdateReminder.setSelected(regPrefs.getBoolean("update-delay", true));
    }

    private void initIcons() {
        if (SbugsSession.getSession().useHiResIcons()) {
            this.setMultiResIconImage("jsbugs3.svg");
            this.jButtonWells.setIcon(IconFactory.getIcon("/resources/icon/", "FrameJsbugs_jButtonWells.svg"));
            this.jButtonSamples.setIcon(IconFactory.getIcon("/resources/icon/", "FrameJsbugs_jButtonSamples.svg"));
            this.jButtonInt.setIcon(IconFactory.getIcon("/resources/icon/", "FrameJsbugs_jButtonInt.svg"));
            this.jButtonTaxaDB.setIcon(IconFactory.getIcon("/resources/icon/", "FrameJsbugs_jButtonTaxaDB.svg"));
            this.jButtonOrganiser.setIcon(IconFactory.getIcon("/resources/icon/", "FrameJsbugs_jButtonOrganiser.svg"));
            this.jButtonCharts.setIcon(IconFactory.getIcon("/resources/icon/", "FrameJsbugs_jButtonCharts.svg"));
            this.jCheckBoxMenuItemHiResIcons.setSelected(true);
        } else {
            this.jCheckBoxMenuItemHiResIcons.setSelected(false);
        }
    }

    private void setLAFMenuItem() {
        SbugsLookAndFeelSetup.LAF laf = SbugsLookAndFeelSetup.getLAF();
        this.jRadioButtonMenuItemNativeLAF.setSelected(laf == SbugsLookAndFeelSetup.LAF.NATIVE);
        this.jRadioButtonMenuItemFlatLightLAF.setSelected(laf == SbugsLookAndFeelSetup.LAF.FLAT_LIGHT);
        this.jRadioButtonMenuItemFlatDarkLAF.setSelected(laf == SbugsLookAndFeelSetup.LAF.FLAT_DARK);
    }

    private void setLAF(SbugsLookAndFeelSetup.LAF laf) {
        SbugsLookAndFeelSetup.setLAF((SbugsLookAndFeelSetup.LAF)laf);
        JOptionPane.showMessageDialog(this, "Window style changes will be applied when StrataBugs is restarted.");
    }

    void setSampleTops() {
        if (this.sbdb != null) {
            if (this.sbdb.useSampleTops()) {
                this.jRadioButtonMenuItemDepthsTop.setSelected(true);
            } else {
                this.jRadioButtonMenuItemDepthsBase.setSelected(true);
            }
        }
    }

    void initLogDpMenu() {
        switch (SampleType.LOG.getPrecision()) {
            case 1: {
                this.jRadioButtonMenuItemLOG1.setSelected(true);
                break;
            }
            case 2: {
                this.jRadioButtonMenuItemLOG2.setSelected(true);
                break;
            }
            case 3: {
                this.jRadioButtonMenuItemLOG3.setSelected(true);
            }
        }
    }

    void setenvPref() {
        if (this.sbdb != null) {
            if (this.sbdb.allowMultipleEnvSchemes()) {
                this.jRadioButtonMenuItemMultiple.setSelected(true);
            } else {
                this.jRadioButtonMenuItemSingle.setSelected(true);
            }
        }
    }

    private void initComponents() {
        this.jPanel3 = new JPanel();
        this.buttonGroupHelpLocation = new ButtonGroup();
        this.buttonGroupSampleDepths = new ButtonGroup();
        this.buttonGroupLGSSamplePrec = new ButtonGroup();
        this.buttonGroupEnvPref = new ButtonGroup();
        this.buttonGroupSizes = new ButtonGroup();
        this.buttonGroupLandF = new ButtonGroup();
        this.jPanel2 = new JPanel(this){
            final /* synthetic */ FrameJsbugs this$0;
            {
                FrameJsbugs frameJsbugs = this$0;
                Objects.requireNonNull(frameJsbugs);
                this.this$0 = frameJsbugs;
            }

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                boolean fullyLoaded = g.drawImage(this.this$0.backgroundImage, 0, 0, this.getWidth(), this.getHeight(), this);
            }
        };
        this.jButtonTaxaDB = new JButton();
        this.jButtonCharts = new JButton();
        this.jButtonSamples = new JButton();
        this.jButtonWells = new JButton();
        this.jButtonInt = new JButton();
        this.jButtonOrganiser = new JButton();
        this.jLabelRefresh = new JLabel();
        this.jPanelInfo = new JPanel();
        this.jLabelLicencee = new JLabel();
        this.jLabelUser = new JLabel();
        this.jLabelLocation = new JLabel();
        this.jLabelDB = new JLabel();
        this.jLabelLiceneType = new JLabel();
        this.jLabelUpdates = new JLabel();
        this.jPanelTaxaDB = new JPanel();
        this.jLabelTaxaDB = new JLabel();
        this.jPanelInt = new JPanel();
        this.jLabelInt = new JLabel();
        this.jPanelWells = new JPanel();
        this.jLabelWells = new JLabel();
        this.jPanelSamples = new JPanel();
        this.jLabelSamples = new JLabel();
        this.jPanelOrganiser = new JPanel();
        this.jLabelOrganiser = new JLabel();
        this.jPanelCharts = new JPanel();
        this.jLabelCharts = new JLabel();
        this.jMenuBar1 = new JMenuBar();
        this.jMenuFile = new JMenu();
        this.jMenuItemConnect = new JMenuItem();
        this.jMenuItemManageConnections = new JMenuItem();
        this.jMenuItemLoad = new JMenuItem();
        this.jSeparator8 = new JPopupMenu.Separator();
        this.jMenuItemExit = new JMenuItem();
        this.jMenuConfig = new JMenu();
        this.jMenuItemRefresh = new JMenuItem();
        this.jMenuItemManualRefresh = new JMenuItem();
        this.jSeparator9 = new JPopupMenu.Separator();
        this.jMenuItemConfigAbn = new JMenuItem();
        this.jMenuItemConfigPersonnel = new JMenuItem();
        this.jMenuItemLogDef = new JMenuItem();
        this.jMenuItemMiscColours = new JMenuItem();
        this.jMenuItemChartScales = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.jMenuSampleDepths = new JMenu();
        this.jRadioButtonMenuItemDepthsTop = new JRadioButtonMenuItem();
        this.jRadioButtonMenuItemDepthsBase = new JRadioButtonMenuItem();
        this.jMenu3 = new JMenu();
        this.jRadioButtonMenuItemLOG1 = new JRadioButtonMenuItem();
        this.jRadioButtonMenuItemLOG2 = new JRadioButtonMenuItem();
        this.jRadioButtonMenuItemLOG3 = new JRadioButtonMenuItem();
        this.jMenuItemImageStorage = new JMenuItem();
        this.jMenuExport = new JMenu();
        this.jCheckBoxMenuItemExportSingleUser = new JCheckBoxMenuItem();
        this.jMenuItemExportABR = new JMenuItem();
        this.jMenuItemEventPrefix = new JMenuItem();
        this.jMenuEnvEntry = new JMenu();
        this.jRadioButtonMenuItemSingle = new JRadioButtonMenuItem();
        this.jRadioButtonMenuItemMultiple = new JRadioButtonMenuItem();
        this.jMenuItemHierNames = new JMenuItem();
        this.jCheckBoxMenuItemAllowCountryCase = new JCheckBoxMenuItem();
        this.jCheckBoxMenuItemShowArchivedSchemes = new JCheckBoxMenuItem();
        this.jCheckBoxMenuItemQueryPDFfont = new JCheckBoxMenuItem();
        this.jSeparator2 = new JPopupMenu.Separator();
        this.jMenuDisplay = new JMenu();
        this.jMenuTextSizes = new JMenu();
        this.jRadioButtonMenuItemGuiSizes100 = new JRadioButtonMenuItem();
        this.jRadioButtonMenuItemGuiSystem = new JRadioButtonMenuItem();
        this.jCheckBoxMenuItemHiResIcons = new JCheckBoxMenuItem();
        this.jMenu4 = new JMenu();
        this.jRadioButtonMenuItemFlatLightLAF = new JRadioButtonMenuItem();
        this.jRadioButtonMenuItemFlatDarkLAF = new JRadioButtonMenuItem();
        this.jRadioButtonMenuItemNativeLAF = new JRadioButtonMenuItem();
        this.jMenuItemScreen = new JMenuItem();
        this.jMenuItemCentreWindow = new JMenuItem();
        this.jMenuItemRLMRoam = new JMenuItem();
        this.jMenuWjsbugs = new JMenu();
        this.jCheckBoxMenuItemWjsbugs = new JCheckBoxMenuItem();
        this.jMenuItemWjsbugsProxy = new JMenuItem();
        this.jMenuItemWjsbugsAbout = new JMenuItem();
        this.jMenuItemLogging = new JMenuItem();
        this.jMenuItemSbugsServerConfig = new JMenuItem();
        this.jSeparator3 = new JPopupMenu.Separator();
        this.jMenuItemSBUpdate = new JMenuItem();
        this.jCheckBoxMenuItemShowUpdatePopup = new JCheckBoxMenuItem();
        this.jCheckBoxMenuItemDelayUpdateReminder = new JCheckBoxMenuItem();
        this.jMenuTools = new JMenu();
        this.jMenuItemQuery = new JMenuItem();
        this.jMenuItemBackup = new JMenuItem();
        this.jMenuItemAuditTrail = new JMenuItem();
        this.jMenuItemChartGen = new JMenuItem();
        this.jMenuItemSBconvert = new JMenuItem();
        this.jSeparator6 = new JPopupMenu.Separator();
        this.jMenu1 = new JMenu();
        this.jCheckBoxMenuItemSQLtoCmd = new JCheckBoxMenuItem();
        this.jMenu2 = new JMenu();
        this.jMenuItemNullTopDepths = new JMenuItem();
        this.jMenuItemNullBaseDepths = new JMenuItem();
        this.jMenuItemautoMergeTaxa = new JMenuItem();
        this.jMenuItemMergeDuplicateEvents = new JMenuItem();
        this.jSeparator7 = new JPopupMenu.Separator();
        this.jMenuItemEditWirelineLogPaths = new JMenuItem();
        this.jSeparator11 = new JPopupMenu.Separator();
        this.jMenuItemMemoryMonitor = new JMenuItem();
        this.jMenuHelp = new JMenu();
        this.jMenuItemContents = new JMenuItem();
        this.jMenuItemHelpCP = new JMenuItem();
        this.jMenuSetHelpLocation = new JMenu();
        this.jRadioButtonMenuItemHelpWeb = new JRadioButtonMenuItem();
        this.jRadioButtonMenuItemHelpLocalIE = new JRadioButtonMenuItem();
        this.jRadioButtonMenuItemHelpLocalFF = new JRadioButtonMenuItem();
        this.jRadioButtonMenuItemHelpLocalFolder = new JRadioButtonMenuItem();
        this.jSeparator10 = new JPopupMenu.Separator();
        this.jCheckBoxMenuItemHelpHints = new JCheckBoxMenuItem();
        this.jSeparator5 = new JPopupMenu.Separator();
        this.jMenuItemDBInfo = new JMenuItem();
        this.jMenuItemHelpAbout = new JMenuItem();
        GroupLayout jPanel3Layout = new GroupLayout((Container)this.jPanel3);
        this.jPanel3.setLayout((LayoutManager)jPanel3Layout);
        jPanel3Layout.setHorizontalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add(0, 100, Short.MAX_VALUE));
        jPanel3Layout.setVerticalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add(0, 100, Short.MAX_VALUE));
        this.setDefaultCloseOperation(0);
        this.setCursor(new Cursor(0));
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(this){
            final /* synthetic */ FrameJsbugs this$0;
            {
                FrameJsbugs frameJsbugs = this$0;
                Objects.requireNonNull(frameJsbugs);
                this.this$0 = frameJsbugs;
            }

            @Override
            public void windowClosing(WindowEvent evt) {
                this.this$0.formWindowClosing(evt);
            }
        });
        this.jButtonTaxaDB.setFont(new Font("Tahoma", 1, 12));
        this.jButtonTaxaDB.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/FrameJsbugs_jButtonTaxaDB.png")));
        this.jButtonTaxaDB.setHorizontalTextPosition(0);
        this.jButtonTaxaDB.setMargin(new Insets(4, 4, 4, 4));
        this.jButtonTaxaDB.setMultiClickThreshhold(1000L);
        this.jButtonTaxaDB.setPreferredSize(new Dimension(73, 107));
        this.jButtonTaxaDB.setRequestFocusEnabled(false);
        this.jButtonTaxaDB.setVerticalTextPosition(3);
        this.jButtonTaxaDB.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameJsbugs this$0;
            {
                FrameJsbugs frameJsbugs = this$0;
                Objects.requireNonNull(frameJsbugs);
                this.this$0 = frameJsbugs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonTaxaDBActionPerformed(evt);
            }
        });
        this.jButtonCharts.setFont(new Font("Tahoma", 1, 12));
        this.jButtonCharts.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/FrameJsbugs_jButtonCharts.png")));
        this.jButtonCharts.setHorizontalAlignment(2);
        this.jButtonCharts.setHorizontalTextPosition(4);
        this.jButtonCharts.setMargin(new Insets(4, 4, 4, 4));
        this.jButtonCharts.setMultiClickThreshhold(1000L);
        this.jButtonCharts.setPreferredSize(new Dimension(149, 61));
        this.jButtonCharts.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameJsbugs this$0;
            {
                FrameJsbugs frameJsbugs = this$0;
                Objects.requireNonNull(frameJsbugs);
                this.this$0 = frameJsbugs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonChartsActionPerformed(evt);
            }
        });
        this.jButtonSamples.setFont(new Font("Tahoma", 1, 12));
        this.jButtonSamples.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/FrameJsbugs_jButtonSamples.png")));
        this.jButtonSamples.setHorizontalTextPosition(0);
        this.jButtonSamples.setMargin(new Insets(4, 4, 4, 4));
        this.jButtonSamples.setMultiClickThreshhold(1000L);
        this.jButtonSamples.setVerticalTextPosition(3);
        this.jButtonSamples.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameJsbugs this$0;
            {
                FrameJsbugs frameJsbugs = this$0;
                Objects.requireNonNull(frameJsbugs);
                this.this$0 = frameJsbugs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSamplesActionPerformed(evt);
            }
        });
        this.jButtonWells.setFont(new Font("Tahoma", 1, 12));
        this.jButtonWells.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/FrameJsbugs_jButtonWells.png")));
        this.jButtonWells.setHorizontalTextPosition(0);
        this.jButtonWells.setInheritsPopupMenu(true);
        this.jButtonWells.setMargin(new Insets(4, 4, 4, 4));
        this.jButtonWells.setMultiClickThreshhold(1000L);
        this.jButtonWells.setPreferredSize(new Dimension(73, 107));
        this.jButtonWells.setVerticalTextPosition(3);
        this.jButtonWells.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameJsbugs this$0;
            {
                FrameJsbugs frameJsbugs = this$0;
                Objects.requireNonNull(frameJsbugs);
                this.this$0 = frameJsbugs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonWellsActionPerformed(evt);
            }
        });
        this.jButtonInt.setFont(new Font("Tahoma", 1, 12));
        this.jButtonInt.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/FrameJsbugs_jButtonInt.png")));
        this.jButtonInt.setHorizontalTextPosition(4);
        this.jButtonInt.setMargin(new Insets(4, 4, 4, 4));
        this.jButtonInt.setMultiClickThreshhold(1000L);
        this.jButtonInt.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameJsbugs this$0;
            {
                FrameJsbugs frameJsbugs = this$0;
                Objects.requireNonNull(frameJsbugs);
                this.this$0 = frameJsbugs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonIntActionPerformed(evt);
            }
        });
        this.jButtonOrganiser.setFont(new Font("Tahoma", 1, 12));
        this.jButtonOrganiser.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/FrameJsbugs_jButtonOrganiser.png")));
        this.jButtonOrganiser.setHorizontalAlignment(2);
        this.jButtonOrganiser.setMargin(new Insets(2, 2, 2, 14));
        this.jButtonOrganiser.setMultiClickThreshhold(1000L);
        this.jButtonOrganiser.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameJsbugs this$0;
            {
                FrameJsbugs frameJsbugs = this$0;
                Objects.requireNonNull(frameJsbugs);
                this.this$0 = frameJsbugs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOrganiserActionPerformed(evt);
            }
        });
        this.jLabelRefresh.setFont(this.jLabelRefresh.getFont());
        this.jLabelRefresh.setText("Refresh wait...");
        this.jPanelInfo.setBackground(new Color(244, 245, 243));
        this.jPanelInfo.setBorder(BorderFactory.createEtchedBorder());
        this.jPanelInfo.setOpaque(false);
        this.jLabelLicencee.setHorizontalAlignment(0);
        this.jLabelLicencee.setText("licencee");
        this.jLabelUser.setFont(this.jLabelUser.getFont().deriveFont(this.jLabelUser.getFont().getStyle() | 1, this.jLabelUser.getFont().getSize() + 1));
        this.jLabelUser.setHorizontalAlignment(0);
        this.jLabelUser.setText("user");
        this.jLabelLocation.setHorizontalAlignment(0);
        this.jLabelLocation.setText("location");
        this.jLabelDB.setHorizontalAlignment(0);
        this.jLabelDB.setText("database");
        this.jLabelLiceneType.setFont(new Font("Tahoma", 1, 11));
        this.jLabelLiceneType.setHorizontalAlignment(0);
        this.jLabelLiceneType.setText("licence type");
        GroupLayout jPanelInfoLayout = new GroupLayout((Container)this.jPanelInfo);
        this.jPanelInfo.setLayout((LayoutManager)jPanelInfoLayout);
        jPanelInfoLayout.setHorizontalGroup((GroupLayout.Group)jPanelInfoLayout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanelInfoLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelInfoLayout.createParallelGroup(2).add((Component)this.jLabelLocation, -1, -1, Short.MAX_VALUE).add((Component)this.jLabelDB, -1, -1, Short.MAX_VALUE).add((Component)this.jLabelUser, -1, -1, Short.MAX_VALUE).add(1, (Component)this.jLabelLicencee, -1, -1, Short.MAX_VALUE).add(1, (Component)this.jLabelLiceneType, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanelInfoLayout.setVerticalGroup((GroupLayout.Group)jPanelInfoLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelInfoLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add((Component)this.jLabelUser).addPreferredGap(0).add((Component)this.jLabelDB).addPreferredGap(1).add((Component)this.jLabelLicencee, -2, 14, -2).addPreferredGap(0).add((Component)this.jLabelLocation).addPreferredGap(0).add((Component)this.jLabelLiceneType).add(7, 7, 7)));
        jPanelInfoLayout.linkSize(new Component[]{this.jLabelDB, this.jLabelLicencee, this.jLabelLocation, this.jLabelUser}, 2);
        this.jLabelUpdates.setFont(this.jLabelUpdates.getFont().deriveFont(this.jLabelUpdates.getFont().getStyle() | 1));
        this.jLabelUpdates.setText("Application update available");
        this.jLabelUpdates.setHorizontalTextPosition(2);
        this.jPanelTaxaDB.setOpaque(false);
        this.jPanelTaxaDB.setLayout(new BorderLayout());
        this.jLabelTaxaDB.setFont(this.jLabelTaxaDB.getFont().deriveFont(this.jLabelTaxaDB.getFont().getStyle() | 1, this.jLabelTaxaDB.getFont().getSize() + 2));
        this.jLabelTaxaDB.setText("<html>Taxonomic<br>Database</html>");
        this.jPanelTaxaDB.add((Component)this.jLabelTaxaDB, "Center");
        this.jPanelInt.setOpaque(false);
        this.jPanelInt.setLayout(new BorderLayout());
        this.jLabelInt.setFont(this.jLabelInt.getFont().deriveFont(this.jLabelInt.getFont().getStyle() | 1, this.jLabelInt.getFont().getSize() + 2));
        this.jLabelInt.setText("<html>Schemes<br>& Interpretations</html>");
        this.jPanelInt.add((Component)this.jLabelInt, "Center");
        this.jPanelWells.setOpaque(false);
        this.jPanelWells.setLayout(new BorderLayout());
        this.jLabelWells.setFont(this.jLabelWells.getFont().deriveFont(this.jLabelWells.getFont().getStyle() | 1, this.jLabelWells.getFont().getSize() + 2));
        this.jLabelWells.setText("<html> Wells <br> & Outcrops </html>");
        this.jPanelWells.add((Component)this.jLabelWells, "Center");
        this.jPanelSamples.setOpaque(false);
        this.jPanelSamples.setLayout(new BorderLayout());
        this.jLabelSamples.setFont(this.jLabelSamples.getFont().deriveFont(this.jLabelSamples.getFont().getStyle() | 1, this.jLabelSamples.getFont().getSize() + 2));
        this.jLabelSamples.setText("<html> Samples <br> & Interpretations </html>");
        this.jPanelSamples.add((Component)this.jLabelSamples, "Center");
        this.jPanelOrganiser.setOpaque(false);
        this.jPanelOrganiser.setLayout(new BorderLayout());
        this.jLabelOrganiser.setFont(this.jLabelOrganiser.getFont().deriveFont(this.jLabelOrganiser.getFont().getStyle() | 1, this.jLabelOrganiser.getFont().getSize() + 2));
        this.jLabelOrganiser.setText("Organiser");
        this.jPanelOrganiser.add((Component)this.jLabelOrganiser, "Center");
        this.jPanelCharts.setOpaque(false);
        this.jPanelCharts.setLayout(new BorderLayout());
        this.jLabelCharts.setFont(this.jLabelCharts.getFont().deriveFont(this.jLabelCharts.getFont().getStyle() | 1, this.jLabelCharts.getFont().getSize() + 2));
        this.jLabelCharts.setText("<html>Charts<br>& Templates</html>");
        this.jPanelCharts.add((Component)this.jLabelCharts, "Center");
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(2, false).add(1, (Component)this.jButtonTaxaDB, -2, 70, -2).add(1, (Component)this.jButtonWells, -2, 70, -2).add(1, (Component)this.jButtonInt, -2, 70, -2).add(1, (Component)this.jButtonSamples, -2, 70, -2).add((Component)this.jButtonCharts, -2, 70, -2).add(1, (Component)this.jButtonOrganiser, -2, 70, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(2, false).add(1, (Component)this.jPanelOrganiser, -1, -1, Short.MAX_VALUE).add(1, (Component)this.jPanelSamples, -1, -1, Short.MAX_VALUE).add(1, (Component)this.jPanelTaxaDB, -1, -1, Short.MAX_VALUE).add(1, (Component)this.jPanelWells, -1, -1, Short.MAX_VALUE).add(1, (Component)this.jPanelInt, -1, -1, Short.MAX_VALUE).add((Component)this.jPanelCharts, -1, -1, Short.MAX_VALUE)).add(0, 13, Short.MAX_VALUE)).add(2, (GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(2).add(1, (Component)this.jLabelUpdates, -1, -1, Short.MAX_VALUE).add(1, (Component)this.jLabelRefresh, -1, -1, Short.MAX_VALUE).add((Component)this.jPanelInfo, -1, -1, Short.MAX_VALUE)).addContainerGap()))));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1, false).add((Component)this.jButtonWells, -2, 70, -2).add((Component)this.jPanelWells, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1, false).add((Component)this.jButtonSamples, -2, 70, -2).add((Component)this.jPanelSamples, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1, false).add((Component)this.jButtonInt, -2, 70, -2).add((Component)this.jPanelInt, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1, false).add((Component)this.jButtonTaxaDB, -2, 70, -2).add((Component)this.jPanelTaxaDB, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1, false).add((Component)this.jButtonOrganiser, -2, 70, -2).add((Component)this.jPanelOrganiser, -1, -1, Short.MAX_VALUE)).add(5, 5, 5).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1, false).add((Component)this.jButtonCharts, -2, 70, -2).add((Component)this.jPanelCharts, -1, -1, Short.MAX_VALUE)).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jPanelInfo, -2, -1, -2).addPreferredGap(0).add((Component)this.jLabelRefresh).addPreferredGap(0).add((Component)this.jLabelUpdates).add(5, 5, 5)));
        ResourceBundle bundle = ResourceBundle.getBundle("locale/UiText");
        this.jMenuFile.setText(bundle.getString("menu.file"));
        this.jMenuItemConnect.setText(bundle.getString("FrameJsbugs.menu.connect"));
        this.jMenuItemConnect.setToolTipText("Connect to a different StrataBugs database");
        this.jMenuItemConnect.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameJsbugs this$0;
            {
                FrameJsbugs frameJsbugs = this$0;
                Objects.requireNonNull(frameJsbugs);
                this.this$0 = frameJsbugs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemConnectActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemConnect);
        this.jMenuItemManageConnections.setText(bundle.getString("FrameJsbugs.menu.manageconnections"));
        this.jMenuItemManageConnections.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameJsbugs this$0;
            {
                FrameJsbugs frameJsbugs = this$0;
                Objects.requireNonNull(frameJsbugs);
                this.this$0 = frameJsbugs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemManageConnectionsActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemManageConnections);
        this.jMenuItemLoad.setText(bundle.getString("FrameJsbugs.menu.load"));
        this.jMenuItemLoad.setToolTipText("Load the entire database into application (can take a long time)");
        this.jMenuItemLoad.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameJsbugs this$0;
            {
                FrameJsbugs frameJsbugs = this$0;
                Objects.requireNonNull(frameJsbugs);
                this.this$0 = frameJsbugs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemLoadActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemLoad);
        this.jMenuFile.add(this.jSeparator8);
        this.jMenuItemExit.setText(bundle.getString("button.exit"));
        this.jMenuItemExit.setToolTipText("Close ALL StrataBugs windows and exit");
        this.jMenuItemExit.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameJsbugs this$0;
            {
                FrameJsbugs frameJsbugs = this$0;
                Objects.requireNonNull(frameJsbugs);
                this.this$0 = frameJsbugs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemExitActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemExit);
        this.jMenuBar1.add(this.jMenuFile);
        this.jMenuConfig.setText(bundle.getString("menu.config"));
        this.jMenuItemRefresh.setText(bundle.getString("FrameJsbugs.menu.refresh"));
        this.jMenuItemRefresh.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameJsbugs this$0;
            {
                FrameJsbugs frameJsbugs = this$0;
                Objects.requireNonNull(frameJsbugs);
                this.this$0 = frameJsbugs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemRefreshActionPerformed(evt);
            }
        });
        this.jMenuConfig.add(this.jMenuItemRefresh);
        this.jMenuItemManualRefresh.setText(bundle.getString("FrameJsbugs.menu.manualrefresh"));
        this.jMenuItemManualRefresh.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameJsbugs this$0;
            {
                FrameJsbugs frameJsbugs = this$0;
                Objects.requireNonNull(frameJsbugs);
                this.this$0 = frameJsbugs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemManualRefreshActionPerformed(evt);
            }
        });
        this.jMenuConfig.add(this.jMenuItemManualRefresh);
        this.jMenuConfig.add(this.jSeparator9);
        this.jMenuItemConfigAbn.setText(bundle.getString("menu.abundanceschemes"));
        this.jMenuItemConfigAbn.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameJsbugs this$0;
            {
                FrameJsbugs frameJsbugs = this$0;
                Objects.requireNonNull(frameJsbugs);
                this.this$0 = frameJsbugs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemConfigAbnActionPerformed(evt);
            }
        });
        this.jMenuConfig.add(this.jMenuItemConfigAbn);
        this.jMenuItemConfigPersonnel.setText(bundle.getString("menu.personnel"));
        this.jMenuItemConfigPersonnel.setToolTipText("");
        this.jMenuItemConfigPersonnel.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameJsbugs this$0;
            {
                FrameJsbugs frameJsbugs = this$0;
                Objects.requireNonNull(frameJsbugs);
                this.this$0 = frameJsbugs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemConfigPersonnelActionPerformed(evt);
            }
        });
        this.jMenuConfig.add(this.jMenuItemConfigPersonnel);
        this.jMenuItemLogDef.setText(bundle.getString("FrameJsbugs.menu.logdef"));
        this.jMenuItemLogDef.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameJsbugs this$0;
            {
                FrameJsbugs frameJsbugs = this$0;
                Objects.requireNonNull(frameJsbugs);
                this.this$0 = frameJsbugs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemLogDefActionPerformed(evt);
            }
        });
        this.jMenuConfig.add(this.jMenuItemLogDef);
        this.jMenuItemMiscColours.setText(bundle.getString("FrameJsbugs.menu.misccolours"));
        this.jMenuItemMiscColours.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameJsbugs this$0;
            {
                FrameJsbugs frameJsbugs = this$0;
                Objects.requireNonNull(frameJsbugs);
                this.this$0 = frameJsbugs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemMiscColoursActionPerformed(evt);
            }
        });
        this.jMenuConfig.add(this.jMenuItemMiscColours);
        this.jMenuItemChartScales.setText(bundle.getString("FrameJsbugs.menu.depthscales"));
        this.jMenuItemChartScales.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameJsbugs this$0;
            {
                FrameJsbugs frameJsbugs = this$0;
                Objects.requireNonNull(frameJsbugs);
                this.this$0 = frameJsbugs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemChartScalesActionPerformed(evt);
            }
        });
        this.jMenuConfig.add(this.jMenuItemChartScales);
        this.jMenuConfig.add(this.jSeparator1);
        this.jMenuSampleDepths.setText(bundle.getString("FrameJsbugs.menu.sampledepths"));
        this.buttonGroupSampleDepths.add(this.jRadioButtonMenuItemDepthsTop);
        this.jRadioButtonMenuItemDepthsTop.setSelected(true);
        this.jRadioButtonMenuItemDepthsTop.setText(bundle.getString("FrameJsbugs.menu.depths.top"));
        this.jRadioButtonMenuItemDepthsTop.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameJsbugs this$0;
            {
                FrameJsbugs frameJsbugs = this$0;
                Objects.requireNonNull(frameJsbugs);
                this.this$0 = frameJsbugs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonMenuItemDepthsTopActionPerformed(evt);
            }
        });
        this.jMenuSampleDepths.add(this.jRadioButtonMenuItemDepthsTop);
        this.buttonGroupSampleDepths.add(this.jRadioButtonMenuItemDepthsBase);
        this.jRadioButtonMenuItemDepthsBase.setText(bundle.getString("FrameJsbugs.menu.depths.base"));
        this.jRadioButtonMenuItemDepthsBase.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameJsbugs this$0;
            {
                FrameJsbugs frameJsbugs = this$0;
                Objects.requireNonNull(frameJsbugs);
                this.this$0 = frameJsbugs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonMenuItemDepthsBaseActionPerformed(evt);
            }
        });
        this.jMenuSampleDepths.add(this.jRadioButtonMenuItemDepthsBase);
        this.jMenu3.setText(bundle.getString("FrameJsbugs.menu.depths.log"));
        this.buttonGroupLGSSamplePrec.add(this.jRadioButtonMenuItemLOG1);
        this.jRadioButtonMenuItemLOG1.setSelected(true);
        this.jRadioButtonMenuItemLOG1.setText(bundle.getString("FrameJsbugs.menu.depths.log.one"));
        this.jRadioButtonMenuItemLOG1.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameJsbugs this$0;
            {
                FrameJsbugs frameJsbugs = this$0;
                Objects.requireNonNull(frameJsbugs);
                this.this$0 = frameJsbugs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonMenuItemLOG1ActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.jRadioButtonMenuItemLOG1);
        this.buttonGroupLGSSamplePrec.add(this.jRadioButtonMenuItemLOG2);
        this.jRadioButtonMenuItemLOG2.setText(bundle.getString("FrameJsbugs.menu.depths.log.two"));
        this.jRadioButtonMenuItemLOG2.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameJsbugs this$0;
            {
                FrameJsbugs frameJsbugs = this$0;
                Objects.requireNonNull(frameJsbugs);
                this.this$0 = frameJsbugs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonMenuItemLOG2ActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.jRadioButtonMenuItemLOG2);
        this.buttonGroupLGSSamplePrec.add(this.jRadioButtonMenuItemLOG3);
        this.jRadioButtonMenuItemLOG3.setText(bundle.getString("FrameJsbugs.menu.depths.log.three"));
        this.jRadioButtonMenuItemLOG3.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameJsbugs this$0;
            {
                FrameJsbugs frameJsbugs = this$0;
                Objects.requireNonNull(frameJsbugs);
                this.this$0 = frameJsbugs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonMenuItemLOG3ActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.jRadioButtonMenuItemLOG3);
        this.jMenuSampleDepths.add(this.jMenu3);
        this.jMenuConfig.add(this.jMenuSampleDepths);
        this.jMenuItemImageStorage.setText(bundle.getString("FramsJsbugs.menu.imagestorage"));
        this.jMenuItemImageStorage.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameJsbugs this$0;
            {
                FrameJsbugs frameJsbugs = this$0;
                Objects.requireNonNull(frameJsbugs);
                this.this$0 = frameJsbugs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemImageStorageActionPerformed(evt);
            }
        });
        this.jMenuConfig.add(this.jMenuItemImageStorage);
        this.jMenuExport.setText(bundle.getString("FrameJsbugs.menu.export"));
        this.jCheckBoxMenuItemExportSingleUser.setSelected(true);
        this.jCheckBoxMenuItemExportSingleUser.setText(bundle.getString("FrameJsbugs.menu.export.single"));
        this.jCheckBoxMenuItemExportSingleUser.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameJsbugs this$0;
            {
                FrameJsbugs frameJsbugs = this$0;
                Objects.requireNonNull(frameJsbugs);
                this.this$0 = frameJsbugs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jCheckBoxMenuItemExportSingleUserActionPerformed(evt);
            }
        });
        this.jMenuExport.add(this.jCheckBoxMenuItemExportSingleUser);
        this.jMenuItemExportABR.setText(bundle.getString("FrameJabugs.menu.export.abr"));
        this.jMenuItemExportABR.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameJsbugs this$0;
            {
                FrameJsbugs frameJsbugs = this$0;
                Objects.requireNonNull(frameJsbugs);
                this.this$0 = frameJsbugs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemExportABRActionPerformed(evt);
            }
        });
        this.jMenuExport.add(this.jMenuItemExportABR);
        this.jMenuConfig.add(this.jMenuExport);
        this.jMenuItemEventPrefix.setText(bundle.getString("FrameJsbugs.menu.eventprefix"));
        this.jMenuItemEventPrefix.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameJsbugs this$0;
            {
                FrameJsbugs frameJsbugs = this$0;
                Objects.requireNonNull(frameJsbugs);
                this.this$0 = frameJsbugs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemEventPrefixActionPerformed(evt);
            }
        });
        this.jMenuConfig.add(this.jMenuItemEventPrefix);
        this.jMenuEnvEntry.setText(bundle.getString("FrameJsbugs.menu.env"));
        this.buttonGroupEnvPref.add(this.jRadioButtonMenuItemSingle);
        this.jRadioButtonMenuItemSingle.setSelected(true);
        this.jRadioButtonMenuItemSingle.setText(bundle.getString("FrameJsbugs.menu.env.single"));
        this.jRadioButtonMenuItemSingle.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameJsbugs this$0;
            {
                FrameJsbugs frameJsbugs = this$0;
                Objects.requireNonNull(frameJsbugs);
                this.this$0 = frameJsbugs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonMenuItemSingleActionPerformed(evt);
            }
        });
        this.jMenuEnvEntry.add(this.jRadioButtonMenuItemSingle);
        this.buttonGroupEnvPref.add(this.jRadioButtonMenuItemMultiple);
        this.jRadioButtonMenuItemMultiple.setText(bundle.getString("FrameJsbugs.menu.env.multiple"));
        this.jRadioButtonMenuItemMultiple.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameJsbugs this$0;
            {
                FrameJsbugs frameJsbugs = this$0;
                Objects.requireNonNull(frameJsbugs);
                this.this$0 = frameJsbugs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonMenuItemMultipleActionPerformed(evt);
            }
        });
        this.jMenuEnvEntry.add(this.jRadioButtonMenuItemMultiple);
        this.jMenuConfig.add(this.jMenuEnvEntry);
        this.jMenuItemHierNames.setText(bundle.getString("FrameJsbugs.menu.hier"));
        this.jMenuItemHierNames.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameJsbugs this$0;
            {
                FrameJsbugs frameJsbugs = this$0;
                Objects.requireNonNull(frameJsbugs);
                this.this$0 = frameJsbugs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemHierNamesActionPerformed(evt);
            }
        });
        this.jMenuConfig.add(this.jMenuItemHierNames);
        this.jCheckBoxMenuItemAllowCountryCase.setText(bundle.getString("FrameJsbugs.menu.countrycase"));
        this.jCheckBoxMenuItemAllowCountryCase.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameJsbugs this$0;
            {
                FrameJsbugs frameJsbugs = this$0;
                Objects.requireNonNull(frameJsbugs);
                this.this$0 = frameJsbugs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jCheckBoxMenuItemAllowCountryCaseActionPerformed(evt);
            }
        });
        this.jMenuConfig.add(this.jCheckBoxMenuItemAllowCountryCase);
        this.jCheckBoxMenuItemShowArchivedSchemes.setSelected(true);
        this.jCheckBoxMenuItemShowArchivedSchemes.setText(bundle.getString("FrameJsbugs.menu.archivedschemes"));
        this.jCheckBoxMenuItemShowArchivedSchemes.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameJsbugs this$0;
            {
                FrameJsbugs frameJsbugs = this$0;
                Objects.requireNonNull(frameJsbugs);
                this.this$0 = frameJsbugs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jCheckBoxMenuItemShowArchivedSchemesActionPerformed(evt);
            }
        });
        this.jMenuConfig.add(this.jCheckBoxMenuItemShowArchivedSchemes);
        this.jCheckBoxMenuItemQueryPDFfont.setSelected(true);
        this.jCheckBoxMenuItemQueryPDFfont.setText("Query PDF export font embedding");
        this.jCheckBoxMenuItemQueryPDFfont.setToolTipText("When selected, a popup confirmation will appear for each PDF export, giving the option to embed fonts in the output file");
        this.jCheckBoxMenuItemQueryPDFfont.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameJsbugs this$0;
            {
                FrameJsbugs frameJsbugs = this$0;
                Objects.requireNonNull(frameJsbugs);
                this.this$0 = frameJsbugs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jCheckBoxMenuItemQueryPDFfontActionPerformed(evt);
            }
        });
        this.jMenuConfig.add(this.jCheckBoxMenuItemQueryPDFfont);
        this.jMenuConfig.add(this.jSeparator2);
        this.jMenuDisplay.setText(bundle.getString("menu.display"));
        this.jMenuTextSizes.setText(bundle.getString("menu.textsizes"));
        this.buttonGroupSizes.add(this.jRadioButtonMenuItemGuiSizes100);
        this.jRadioButtonMenuItemGuiSizes100.setSelected(true);
        this.jRadioButtonMenuItemGuiSizes100.setText(bundle.getString("FrameJsbugs.menu.text.applicationsize"));
        this.jRadioButtonMenuItemGuiSizes100.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameJsbugs this$0;
            {
                FrameJsbugs frameJsbugs = this$0;
                Objects.requireNonNull(frameJsbugs);
                this.this$0 = frameJsbugs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonMenuItemGuiSizes100ActionPerformed(evt);
            }
        });
        this.jMenuTextSizes.add(this.jRadioButtonMenuItemGuiSizes100);
        this.buttonGroupSizes.add(this.jRadioButtonMenuItemGuiSystem);
        this.jRadioButtonMenuItemGuiSystem.setText(bundle.getString("FrameJsbugs.menu.text.systemsize"));
        this.jRadioButtonMenuItemGuiSystem.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameJsbugs this$0;
            {
                FrameJsbugs frameJsbugs = this$0;
                Objects.requireNonNull(frameJsbugs);
                this.this$0 = frameJsbugs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonMenuItemGuiSystemActionPerformed(evt);
            }
        });
        this.jMenuTextSizes.add(this.jRadioButtonMenuItemGuiSystem);
        this.jMenuDisplay.add(this.jMenuTextSizes);
        this.jCheckBoxMenuItemHiResIcons.setSelected(true);
        this.jCheckBoxMenuItemHiResIcons.setText(bundle.getString("FrameJsbugs.menu.text.icons"));
        this.jCheckBoxMenuItemHiResIcons.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameJsbugs this$0;
            {
                FrameJsbugs frameJsbugs = this$0;
                Objects.requireNonNull(frameJsbugs);
                this.this$0 = frameJsbugs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jCheckBoxMenuItemHiResIconsActionPerformed(evt);
            }
        });
        this.jMenuDisplay.add(this.jCheckBoxMenuItemHiResIcons);
        this.jMenu4.setText(bundle.getString("FrameJsbugs.menu.display.windowstyle"));
        this.buttonGroupLandF.add(this.jRadioButtonMenuItemFlatLightLAF);
        this.jRadioButtonMenuItemFlatLightLAF.setSelected(true);
        this.jRadioButtonMenuItemFlatLightLAF.setText(bundle.getString("FrameJsbugs.menu.display.windowstyle.cross"));
        this.jRadioButtonMenuItemFlatLightLAF.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameJsbugs this$0;
            {
                FrameJsbugs frameJsbugs = this$0;
                Objects.requireNonNull(frameJsbugs);
                this.this$0 = frameJsbugs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonMenuItemFlatLightLAFActionPerformed(evt);
            }
        });
        this.jMenu4.add(this.jRadioButtonMenuItemFlatLightLAF);
        this.buttonGroupLandF.add(this.jRadioButtonMenuItemFlatDarkLAF);
        this.jRadioButtonMenuItemFlatDarkLAF.setText(bundle.getString("FrameJsbugs.menu.display.windowstyle.crossdark"));
        this.jRadioButtonMenuItemFlatDarkLAF.setEnabled(false);
        this.jRadioButtonMenuItemFlatDarkLAF.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameJsbugs this$0;
            {
                FrameJsbugs frameJsbugs = this$0;
                Objects.requireNonNull(frameJsbugs);
                this.this$0 = frameJsbugs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonMenuItemFlatDarkLAFActionPerformed(evt);
            }
        });
        this.jMenu4.add(this.jRadioButtonMenuItemFlatDarkLAF);
        this.buttonGroupLandF.add(this.jRadioButtonMenuItemNativeLAF);
        this.jRadioButtonMenuItemNativeLAF.setText(bundle.getString("FrameJsbugs.menu.display.windowstyle.native"));
        this.jRadioButtonMenuItemNativeLAF.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameJsbugs this$0;
            {
                FrameJsbugs frameJsbugs = this$0;
                Objects.requireNonNull(frameJsbugs);
                this.this$0 = frameJsbugs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonMenuItemNativeLAFActionPerformed(evt);
            }
        });
        this.jMenu4.add(this.jRadioButtonMenuItemNativeLAF);
        this.jMenuDisplay.add(this.jMenu4);
        this.jMenuItemScreen.setText(bundle.getString("FrameJsbugs.menu.display.screen"));
        this.jMenuItemScreen.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameJsbugs this$0;
            {
                FrameJsbugs frameJsbugs = this$0;
                Objects.requireNonNull(frameJsbugs);
                this.this$0 = frameJsbugs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemScreenActionPerformed(evt);
            }
        });
        this.jMenuDisplay.add(this.jMenuItemScreen);
        this.jMenuItemCentreWindow.setText("Centre window...");
        this.jMenuItemCentreWindow.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameJsbugs this$0;
            {
                FrameJsbugs frameJsbugs = this$0;
                Objects.requireNonNull(frameJsbugs);
                this.this$0 = frameJsbugs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemCentreWindowActionPerformed(evt);
            }
        });
        this.jMenuDisplay.add(this.jMenuItemCentreWindow);
        this.jMenuConfig.add(this.jMenuDisplay);
        this.jMenuItemRLMRoam.setText(bundle.getString("FrameJsbugs.menu.licencecheckout"));
        this.jMenuItemRLMRoam.setToolTipText("Allows licence to be temporarily checked out of the server (if available)");
        this.jMenuItemRLMRoam.setEnabled(false);
        this.jMenuItemRLMRoam.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameJsbugs this$0;
            {
                FrameJsbugs frameJsbugs = this$0;
                Objects.requireNonNull(frameJsbugs);
                this.this$0 = frameJsbugs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemRLMRoamActionPerformed(evt);
            }
        });
        this.jMenuConfig.add(this.jMenuItemRLMRoam);
        this.jMenuWjsbugs.setText(bundle.getString("FrameJsbugs.menu.webservices"));
        this.jCheckBoxMenuItemWjsbugs.setSelected(true);
        this.jCheckBoxMenuItemWjsbugs.setText(bundle.getString("FrameJsbugs.menu.webservices.use"));
        this.jCheckBoxMenuItemWjsbugs.setEnabled(false);
        this.jCheckBoxMenuItemWjsbugs.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameJsbugs this$0;
            {
                FrameJsbugs frameJsbugs = this$0;
                Objects.requireNonNull(frameJsbugs);
                this.this$0 = frameJsbugs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jCheckBoxMenuItemWjsbugsActionPerformed(evt);
            }
        });
        this.jMenuWjsbugs.add(this.jCheckBoxMenuItemWjsbugs);
        this.jMenuItemWjsbugsProxy.setText(bundle.getString("FrameJsbugs.menu.webservices.proxy"));
        this.jMenuItemWjsbugsProxy.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameJsbugs this$0;
            {
                FrameJsbugs frameJsbugs = this$0;
                Objects.requireNonNull(frameJsbugs);
                this.this$0 = frameJsbugs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemWjsbugsProxyActionPerformed(evt);
            }
        });
        this.jMenuWjsbugs.add(this.jMenuItemWjsbugsProxy);
        this.jMenuItemWjsbugsAbout.setText(bundle.getString("menu.help.about"));
        this.jMenuItemWjsbugsAbout.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameJsbugs this$0;
            {
                FrameJsbugs frameJsbugs = this$0;
                Objects.requireNonNull(frameJsbugs);
                this.this$0 = frameJsbugs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemWjsbugsAboutActionPerformed(evt);
            }
        });
        this.jMenuWjsbugs.add(this.jMenuItemWjsbugsAbout);
        this.jMenuConfig.add(this.jMenuWjsbugs);
        this.jMenuItemLogging.setText(bundle.getString("FrameJsbugs.menu.logging"));
        this.jMenuItemLogging.setToolTipText("Error and warning message settings");
        this.jMenuItemLogging.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameJsbugs this$0;
            {
                FrameJsbugs frameJsbugs = this$0;
                Objects.requireNonNull(frameJsbugs);
                this.this$0 = frameJsbugs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemLoggingActionPerformed(evt);
            }
        });
        this.jMenuConfig.add(this.jMenuItemLogging);
        this.jMenuItemSbugsServerConfig.setText("StrataBugs Server configuration...");
        this.jMenuItemSbugsServerConfig.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameJsbugs this$0;
            {
                FrameJsbugs frameJsbugs = this$0;
                Objects.requireNonNull(frameJsbugs);
                this.this$0 = frameJsbugs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemSbugsServerConfigActionPerformed(evt);
            }
        });
        this.jMenuConfig.add(this.jMenuItemSbugsServerConfig);
        this.jMenuConfig.add(this.jSeparator3);
        this.jMenuItemSBUpdate.setText(bundle.getString("FrameJsbugs.menu.updates"));
        this.jMenuItemSBUpdate.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameJsbugs this$0;
            {
                FrameJsbugs frameJsbugs = this$0;
                Objects.requireNonNull(frameJsbugs);
                this.this$0 = frameJsbugs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemSBUpdateActionPerformed(evt);
            }
        });
        this.jMenuConfig.add(this.jMenuItemSBUpdate);
        this.jCheckBoxMenuItemShowUpdatePopup.setSelected(true);
        this.jCheckBoxMenuItemShowUpdatePopup.setText("Show update reminder");
        this.jCheckBoxMenuItemShowUpdatePopup.setToolTipText("");
        this.jCheckBoxMenuItemShowUpdatePopup.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameJsbugs this$0;
            {
                FrameJsbugs frameJsbugs = this$0;
                Objects.requireNonNull(frameJsbugs);
                this.this$0 = frameJsbugs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jCheckBoxMenuItemShowUpdatePopupActionPerformed(evt);
            }
        });
        this.jMenuConfig.add(this.jCheckBoxMenuItemShowUpdatePopup);
        this.jCheckBoxMenuItemDelayUpdateReminder.setSelected(true);
        this.jCheckBoxMenuItemDelayUpdateReminder.setText("Delay update reminder");
        this.jCheckBoxMenuItemDelayUpdateReminder.setToolTipText("Setting this option will delay notification of updates for 3 days");
        this.jCheckBoxMenuItemDelayUpdateReminder.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameJsbugs this$0;
            {
                FrameJsbugs frameJsbugs = this$0;
                Objects.requireNonNull(frameJsbugs);
                this.this$0 = frameJsbugs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jCheckBoxMenuItemDelayUpdateReminderActionPerformed(evt);
            }
        });
        this.jMenuConfig.add(this.jCheckBoxMenuItemDelayUpdateReminder);
        this.jMenuBar1.add(this.jMenuConfig);
        this.jMenuTools.setText(bundle.getString("menu.tools"));
        this.jMenuItemQuery.setText("Database query...");
        this.jMenuItemQuery.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameJsbugs this$0;
            {
                FrameJsbugs frameJsbugs = this$0;
                Objects.requireNonNull(frameJsbugs);
                this.this$0 = frameJsbugs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemQueryActionPerformed(evt);
            }
        });
        this.jMenuTools.add(this.jMenuItemQuery);
        this.jMenuItemBackup.setText("Database backup...");
        this.jMenuItemBackup.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameJsbugs this$0;
            {
                FrameJsbugs frameJsbugs = this$0;
                Objects.requireNonNull(frameJsbugs);
                this.this$0 = frameJsbugs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemBackupActionPerformed(evt);
            }
        });
        this.jMenuTools.add(this.jMenuItemBackup);
        this.jMenuItemAuditTrail.setText("Audit trail...");
        this.jMenuItemAuditTrail.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameJsbugs this$0;
            {
                FrameJsbugs frameJsbugs = this$0;
                Objects.requireNonNull(frameJsbugs);
                this.this$0 = frameJsbugs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemAuditTrailActionPerformed(evt);
            }
        });
        this.jMenuTools.add(this.jMenuItemAuditTrail);
        this.jMenuItemChartGen.setText("Chart generator...");
        this.jMenuItemChartGen.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameJsbugs this$0;
            {
                FrameJsbugs frameJsbugs = this$0;
                Objects.requireNonNull(frameJsbugs);
                this.this$0 = frameJsbugs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemChartGenActionPerformed(evt);
            }
        });
        this.jMenuTools.add(this.jMenuItemChartGen);
        this.jMenuItemSBconvert.setText("Database utility ...");
        this.jMenuItemSBconvert.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameJsbugs this$0;
            {
                FrameJsbugs frameJsbugs = this$0;
                Objects.requireNonNull(frameJsbugs);
                this.this$0 = frameJsbugs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemSBconvertActionPerformed(evt);
            }
        });
        this.jMenuTools.add(this.jMenuItemSBconvert);
        this.jMenuTools.add(this.jSeparator6);
        this.jMenu1.setText("Show SQL...");
        this.jCheckBoxMenuItemSQLtoCmd.setText("To Command Window");
        this.jCheckBoxMenuItemSQLtoCmd.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameJsbugs this$0;
            {
                FrameJsbugs frameJsbugs = this$0;
                Objects.requireNonNull(frameJsbugs);
                this.this$0 = frameJsbugs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jCheckBoxMenuItemSQLtoCmdActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jCheckBoxMenuItemSQLtoCmd);
        this.jMenuTools.add(this.jMenu1);
        this.jMenu2.setText("Set ALL single depth samples to null");
        this.jMenuItemNullTopDepths.setText("top depth");
        this.jMenuItemNullTopDepths.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameJsbugs this$0;
            {
                FrameJsbugs frameJsbugs = this$0;
                Objects.requireNonNull(frameJsbugs);
                this.this$0 = frameJsbugs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemNullTopDepthsActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItemNullTopDepths);
        this.jMenuItemNullBaseDepths.setText("base depth");
        this.jMenuItemNullBaseDepths.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameJsbugs this$0;
            {
                FrameJsbugs frameJsbugs = this$0;
                Objects.requireNonNull(frameJsbugs);
                this.this$0 = frameJsbugs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemNullBaseDepthsActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItemNullBaseDepths);
        this.jMenuTools.add(this.jMenu2);
        this.jMenuItemautoMergeTaxa.setText("Auto merge taxa...");
        this.jMenuItemautoMergeTaxa.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameJsbugs this$0;
            {
                FrameJsbugs frameJsbugs = this$0;
                Objects.requireNonNull(frameJsbugs);
                this.this$0 = frameJsbugs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemautoMergeTaxaActionPerformed(evt);
            }
        });
        this.jMenuTools.add(this.jMenuItemautoMergeTaxa);
        this.jMenuItemMergeDuplicateEvents.setText("Merge duplicate events...");
        this.jMenuItemMergeDuplicateEvents.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameJsbugs this$0;
            {
                FrameJsbugs frameJsbugs = this$0;
                Objects.requireNonNull(frameJsbugs);
                this.this$0 = frameJsbugs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemMergeDuplicateEventsActionPerformed(evt);
            }
        });
        this.jMenuTools.add(this.jMenuItemMergeDuplicateEvents);
        this.jMenuTools.add(this.jSeparator7);
        this.jMenuItemEditWirelineLogPaths.setText("Change legacy chart external wireline log paths...");
        this.jMenuItemEditWirelineLogPaths.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameJsbugs this$0;
            {
                FrameJsbugs frameJsbugs = this$0;
                Objects.requireNonNull(frameJsbugs);
                this.this$0 = frameJsbugs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemEditWirelineLogPathsActionPerformed(evt);
            }
        });
        this.jMenuTools.add(this.jMenuItemEditWirelineLogPaths);
        this.jMenuTools.add(this.jSeparator11);
        this.jMenuItemMemoryMonitor.setText("Show memory monitor...");
        this.jMenuItemMemoryMonitor.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameJsbugs this$0;
            {
                FrameJsbugs frameJsbugs = this$0;
                Objects.requireNonNull(frameJsbugs);
                this.this$0 = frameJsbugs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemMemoryMonitorActionPerformed(evt);
            }
        });
        this.jMenuTools.add(this.jMenuItemMemoryMonitor);
        this.jMenuBar1.add(this.jMenuTools);
        this.jMenuHelp.setText(bundle.getString("menu.help"));
        this.jMenuItemContents.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        this.jMenuItemContents.setText(bundle.getString("menu.help.contents"));
        this.jMenuItemContents.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameJsbugs this$0;
            {
                FrameJsbugs frameJsbugs = this$0;
                Objects.requireNonNull(frameJsbugs);
                this.this$0 = frameJsbugs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemContentsActionPerformed(evt);
            }
        });
        this.jMenuHelp.add(this.jMenuItemContents);
        this.jMenuItemHelpCP.setText(bundle.getString("FrameJsbugs.help.controlpanel"));
        this.jMenuItemHelpCP.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameJsbugs this$0;
            {
                FrameJsbugs frameJsbugs = this$0;
                Objects.requireNonNull(frameJsbugs);
                this.this$0 = frameJsbugs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemHelpCPActionPerformed(evt);
            }
        });
        this.jMenuHelp.add(this.jMenuItemHelpCP);
        this.jMenuSetHelpLocation.setText(bundle.getString("FrameJsbugs.menu.help.loc"));
        this.buttonGroupHelpLocation.add(this.jRadioButtonMenuItemHelpWeb);
        this.jRadioButtonMenuItemHelpWeb.setSelected(true);
        this.jRadioButtonMenuItemHelpWeb.setText(bundle.getString("FrameJsbugs.help.menu.loc.web"));
        this.jRadioButtonMenuItemHelpWeb.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameJsbugs this$0;
            {
                FrameJsbugs frameJsbugs = this$0;
                Objects.requireNonNull(frameJsbugs);
                this.this$0 = frameJsbugs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonMenuItemHelpWebActionPerformed(evt);
            }
        });
        this.jMenuSetHelpLocation.add(this.jRadioButtonMenuItemHelpWeb);
        this.buttonGroupHelpLocation.add(this.jRadioButtonMenuItemHelpLocalIE);
        this.jRadioButtonMenuItemHelpLocalIE.setText(bundle.getString("FrameJsbugs.help.menu.loc.localie"));
        this.jRadioButtonMenuItemHelpLocalIE.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameJsbugs this$0;
            {
                FrameJsbugs frameJsbugs = this$0;
                Objects.requireNonNull(frameJsbugs);
                this.this$0 = frameJsbugs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonMenuItemHelpLocalIEActionPerformed(evt);
            }
        });
        this.jMenuSetHelpLocation.add(this.jRadioButtonMenuItemHelpLocalIE);
        this.buttonGroupHelpLocation.add(this.jRadioButtonMenuItemHelpLocalFF);
        this.jRadioButtonMenuItemHelpLocalFF.setText(bundle.getString("FrameJsbugs.help.menu.loc.firefox"));
        this.jRadioButtonMenuItemHelpLocalFF.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameJsbugs this$0;
            {
                FrameJsbugs frameJsbugs = this$0;
                Objects.requireNonNull(frameJsbugs);
                this.this$0 = frameJsbugs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonMenuItemHelpLocalFFActionPerformed(evt);
            }
        });
        this.jMenuSetHelpLocation.add(this.jRadioButtonMenuItemHelpLocalFF);
        this.buttonGroupHelpLocation.add(this.jRadioButtonMenuItemHelpLocalFolder);
        this.jRadioButtonMenuItemHelpLocalFolder.setText(bundle.getString("FrameJsbugs.help.menu.loc.folder"));
        this.jRadioButtonMenuItemHelpLocalFolder.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameJsbugs this$0;
            {
                FrameJsbugs frameJsbugs = this$0;
                Objects.requireNonNull(frameJsbugs);
                this.this$0 = frameJsbugs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonMenuItemHelpLocalFolderActionPerformed(evt);
            }
        });
        this.jMenuSetHelpLocation.add(this.jRadioButtonMenuItemHelpLocalFolder);
        this.jMenuHelp.add(this.jMenuSetHelpLocation);
        this.jMenuHelp.add(this.jSeparator10);
        this.jCheckBoxMenuItemHelpHints.setSelected(true);
        this.jCheckBoxMenuItemHelpHints.setText(bundle.getString("menu.hints"));
        this.jCheckBoxMenuItemHelpHints.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameJsbugs this$0;
            {
                FrameJsbugs frameJsbugs = this$0;
                Objects.requireNonNull(frameJsbugs);
                this.this$0 = frameJsbugs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jCheckBoxMenuItemHelpHintsActionPerformed(evt);
            }
        });
        this.jMenuHelp.add(this.jCheckBoxMenuItemHelpHints);
        this.jMenuHelp.add(this.jSeparator5);
        this.jMenuItemDBInfo.setText(bundle.getString("FrameJsbugs.help.menu.describe"));
        this.jMenuItemDBInfo.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameJsbugs this$0;
            {
                FrameJsbugs frameJsbugs = this$0;
                Objects.requireNonNull(frameJsbugs);
                this.this$0 = frameJsbugs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemDBInfoActionPerformed(evt);
            }
        });
        this.jMenuHelp.add(this.jMenuItemDBInfo);
        this.jMenuItemHelpAbout.setText(bundle.getString("menu.help.about"));
        this.jMenuItemHelpAbout.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameJsbugs this$0;
            {
                FrameJsbugs frameJsbugs = this$0;
                Objects.requireNonNull(frameJsbugs);
                this.this$0 = frameJsbugs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemHelpAboutActionPerformed(evt);
            }
        });
        this.jMenuHelp.add(this.jMenuItemHelpAbout);
        this.jMenuBar1.add(this.jMenuHelp);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel2, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel2, -2, -1, -2));
        this.pack();
    }

    private void jMenuItemHelpAboutActionPerformed(ActionEvent evt) {
        this.showAbout();
    }

    void showAbout() {
        new DialogHelpAbout((Frame)this, true, this.sbdb, SbugsLicense.getExpiration()).setVisible(true);
    }

    private void jMenuItemConfigPersonnelActionPerformed(ActionEvent evt) {
        try {
            DialogSelectAnalyst dialog = new DialogSelectAnalyst((Frame)this, true, this.sbdb, false);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }
        catch (SQLException sqle) {
            SbugsExceptionHandler.showDialogStackError(sqle, this);
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        this.jMenuItemExitActionPerformed(null);
    }

    private void jButtonIntActionPerformed(ActionEvent evt) {
        try {
            if (!SbugsLicense.checkRLMlicense()) {
                JOptionPane.showMessageDialog(this, "StrataBugs licence no longer available.", "StrataBugs", 0);
                return;
            }
            if (this.interpretationsFrame == null) {
                this.interpretationsFrame = new FrameInterpretations(this, this.sbdb, this.project);
                SB.centreWindow((Frame)this.interpretationsFrame);
            } else if (this.interpretationsFrame.getState() == 1) {
                this.interpretationsFrame.setState(0);
            }
            this.interpretationsFrame.setVisible(true);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), this.getTitle(), 2);
            ex.printStackTrace();
        }
    }

    private void jButtonTaxaDBActionPerformed(ActionEvent evt) {
        if (!SbugsLicense.checkRLMlicense()) {
            JOptionPane.showMessageDialog(this, "StrataBugs licence no longer available.", "StrataBugs", 0);
            return;
        }
        this.openTaxaDBFrame(null);
    }

    FrameWells getWellsFrame() {
        return this.wellsFrame;
    }

    public void openTaxaDBFrame(Taxon taxon) {
        try {
            if (this.taxadbFrame == null) {
                this.taxadbFrame = new FrameTaxaDB(this, this.sbdb);
                SB.centreWindow((Frame)this.taxadbFrame);
                this.taxadbFrame.setExtendedState(6);
            } else if (this.taxadbFrame.getState() == 1) {
                this.taxadbFrame.setState(0);
            }
            this.taxadbFrame.setVisible(true);
            if (taxon != null) {
                this.taxadbFrame.setTaxon(taxon);
            }
        }
        catch (Exception ex) {
            FrameJsbugs.showStackError("Error opening TaxaDB Frame: ", ex, this.sbdb);
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createWellsFrame() {
        try {
            GraphicsDevice[] gs;
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (!SbugsLicense.checkRLMlicense()) {
                JOptionPane.showMessageDialog(this, "StrataBugs licence no longer available.", "StrataBugs", 0);
                return;
            }
            if (this.wellsFrame == null) {
                boolean restoreProject = true;
                FrameWellsSession session = this.userPrefsHelper.getFrameWellsSession();
                if (session != null && session.isProjectIdSet()) {
                    Project project = this.sbdb.getProject(session.getProjectId());
                    if (project != null) {
                        String projectName = project.getName();
                        String message = this.bundle.getString("FrameJsbugs.restoresavedproject") + ": " + projectName + "?";
                        int opt = JOptionPane.showOptionDialog(this, message, this.getTitle(), 0, 3, null, null, null);
                        restoreProject = opt == 0;
                    } else {
                        restoreProject = false;
                    }
                }
                this.wellsFrame = new FrameWells(this, this.sbdb, restoreProject);
            }
            this.wellsFrame.setState(0);
            this.wellsFrame.setVisible(true);
            boolean onScreen = false;
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            block6: for (GraphicsDevice curGs : gs = ge.getScreenDevices()) {
                GraphicsConfiguration[] gc;
                for (GraphicsConfiguration curGc : gc = curGs.getConfigurations()) {
                    Rectangle bounds = curGc.getBounds();
                    if (this.wellsFrame.getX() >= bounds.x + bounds.width || this.wellsFrame.getY() + 50 >= bounds.y + bounds.height) continue;
                    onScreen = true;
                    continue block6;
                }
            }
            if (!onScreen) {
                this.wellsFrame.centreOnScreen();
            }
        }
        catch (Exception e) {
            FrameJsbugs.showStackError("Exception starting wells frame: ", e, this.sbdb);
            e.printStackTrace();
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jButtonWellsActionPerformed(ActionEvent evt) {
        this.createWellsFrame();
    }

    void openCharts(ChartTemplateBase template) {
        this.jButtonChartsActionPerformed(null);
        this.chartFrame.openTemplate(template);
    }

    private void jButtonChartsActionPerformed(ActionEvent evt) {
        this.sbdb.clearVersionsInProjectCache();
        if (this.chartFrame == null) {
            this.chartFrame = new FrameChart(this, this.sbdb);
            this.chartFrame.setLocationRelativeTo(this);
        }
        this.chartFrame.setVisible(true);
    }

    private void openSBChart() {
        try {
            SbugsSession.startSBChart(this);
        }
        catch (IOException | SQLException e) {
            FrameJsbugs.showStackError("Error starting charts module", e, this.sbdb);
        }
    }

    void setFrameOverlay(FrameOverlay frameOverlay) throws SBException {
        if (this.frameOverlay != null && this.frameOverlay.isVisible()) {
            throw new SBException("Overlay frame already exists!");
        }
        this.frameOverlay = frameOverlay;
        frameOverlay.setVisible(true);
    }

    FrameOverlay getFrameOverlay() {
        if (this.frameOverlay != null && !this.frameOverlay.isVisible()) {
            return null;
        }
        return this.frameOverlay;
    }

    private void setCurrent() throws SQLException, SBException {
        if (this.wellsFrame != null) {
            this.wellsFrame.dispose();
            this.wellsFrame = null;
        }
        if (this.samplesFrame != null) {
            this.samplesFrame.dispose();
        }
        if (this.interpretationsFrame != null) {
            this.interpretationsFrame.dispose();
            this.interpretationsFrame = null;
        }
        if (this.taxadbFrame != null) {
            this.taxadbFrame.dispose();
            this.taxadbFrame = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonSamplesActionPerformed(ActionEvent evt) {
        block40: {
            try {
                Class.forName("org.apache.batik.svggen.SVGGeneratorContext");
            }
            catch (ClassNotFoundException e) {
                StackError.showStackError((String)"Batik library is missing", (Throwable)e);
                return;
            }
            try {
                this.setCursor(Cursor.getPredefinedCursor(3));
                if (!SbugsLicense.checkRLMlicense()) {
                    JOptionPane.showMessageDialog(this, "StrataBugs licence no longer available.", "StrataBugs", 0);
                    return;
                }
                if (this.samplesFrame == null) {
                    Well well = this.sbdb.getCurrentWell();
                    if (well != null) {
                        this.samplesFrame = new FrameSamples(this, this.sbdb, well, false);
                        this.samplesFrame.setVisible(true);
                        break block40;
                    }
                    boolean hasPrevious = false;
                    try {
                        String session = Lastval.getString(this.sbdb, "SMPSESSION");
                        if (session != null && !session.isEmpty()) {
                            hasPrevious = true;
                        }
                    }
                    catch (Exception session) {
                        // empty catch block
                    }
                    int opt = 1;
                    if (hasPrevious) {
                        Object[] buttons = new String[]{this.bundle.getString("FrameJsbugs.restoresession"), this.bundle.getString("FrameJsbugs.openwell"), this.bundle.getString("FrameJsbugs.openproject")};
                        opt = JOptionPane.showOptionDialog(this, this.bundle.getString("FrameJsbugs.savedsession"), this.getTitle(), 1, 3, null, buttons, null);
                    }
                    if (opt == 0) {
                        this.samplesFrame = new FrameSamples(this, this.sbdb, null, true);
                    } else {
                        Iterator<Well> wellIt = null;
                        if (opt == 1) {
                            dialog = new DialogSelectWell(this, true, this.sbdb, true);
                            dialog.setLocationRelativeTo((Component)this);
                            dialog.setVisible(true);
                            if (((DialogSelectWell)((Object)dialog)).getSelection() != null) {
                                wellIt = ((DialogSelectWell)((Object)dialog)).getSelection().iterator();
                            }
                        } else if (opt == 2) {
                            try {
                                dialog = new DialogSelectProjectWellList((Window)this, this.sbdb, null, null);
                            }
                            catch (RuntimeException e) {
                                SbugsExceptionHandler.showDialogStackError(e, this);
                                this.setCursor(Cursor.getDefaultCursor());
                                return;
                            }
                            ((Window)dialog).setLocationRelativeTo(this);
                            ((Dialog)dialog).setVisible(true);
                            if (((DialogSelectProjectWellList)dialog).getSelection() != null && !(wellIt = this.sbdb.getWellIterator(((DialogSelectProjectWellList)dialog).getSelection().getID())).hasNext()) {
                                JOptionPane.showMessageDialog(this, "Well list has no wells");
                                return;
                            }
                        }
                        if (wellIt == null) {
                            return;
                        }
                        while (wellIt.hasNext()) {
                            well = (Well)wellIt.next();
                            this.addSamplesWell(well, false);
                        }
                    }
                    this.samplesFrame.setVisible(true);
                    break block40;
                }
                int opt = JOptionPane.showConfirmDialog(this, "Samples & Interpretations " + this.bundle.getString("FrameJsbugs.alreadywellloaded"), this.getTitle(), 1, 3);
                if (opt == 2) {
                    return;
                }
                if (opt == 0) {
                    DialogSelectWell dialog = new DialogSelectWell(this, true, this.sbdb, true);
                    dialog.setVisible(true);
                    if (dialog.getSelection() == null) {
                        return;
                    }
                    List<Well> wells = dialog.getSelection();
                    Iterator<Well> itw = wells.iterator();
                    Object p = null;
                    while (itw.hasNext()) {
                        Well well = itw.next();
                        this.samplesFrame.addWellTab(well);
                    }
                }
                if (this.samplesFrame.getState() == 1) {
                    this.samplesFrame.setState(0);
                }
                this.samplesFrame.setVisible(true);
            }
            catch (SBException sbe) {
                StackError.showStackError((String)"Error", (Throwable)sbe);
            }
            catch (SQLException sql) {
                FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
            }
            catch (RuntimeException re) {
                StackError.showStackError((String)"", (Throwable)re);
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jMenuItemLoadActionPerformed(ActionEvent evt) {
        int opt = JOptionPane.showConfirmDialog(this, "Warning: this is not usually necessary, and can take a long time to execute for large databases.\nDo you want to continue?", this.getTitle(), 0, 3);
        if (opt != 0) {
            return;
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.sbdb.load();
            JOptionPane.showMessageDialog(this, "Data loaded.", this.getTitle(), 1);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error loading database", sql, this.sbdb);
        }
        catch (SBException sbe) {
            StackError.showStackError((String)"Error loading database", (Throwable)sbe);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jMenuItemConnectActionPerformed(ActionEvent evt) {
        try {
            this.reconnect(false, true);
        }
        catch (SQLException ex) {
            JOptionPane.showMessageDialog(null, "SQL Error: " + ex.getMessage(), this.getTitle(), 0);
            ex.printStackTrace();
        }
    }

    void exit() {
        this.jMenuItemExitActionPerformed(null);
    }

    private void jMenuItemExitActionPerformed(ActionEvent evt) {
        if (this.checkExit()) {
            LOGGER.config("Exiting from StrataBugs");
            LOGGER.log(Level.CONFIG, "Max memory:   {0}", String.format("%,d", Runtime.getRuntime().maxMemory()));
            LOGGER.log(Level.CONFIG, "Total memory: {0}", String.format("%,d", Runtime.getRuntime().totalMemory()));
            LOGGER.log(Level.CONFIG, "Free memory:  {0}", String.format("%,d", Runtime.getRuntime().freeMemory()));
            LOGGER.log(Level.CONFIG, "Total memory used:  {0}", String.format("%,d", Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()));
            System.exit(0);
        }
    }

    private boolean checkExit() {
        int opt;
        boolean checkClose = false;
        boolean isShowing = false;
        if (this.interpretationsFrame != null) {
            checkClose = true;
            if (this.interpretationsFrame.isShowing()) {
                isShowing = true;
            }
        }
        if (this.taxadbFrame != null) {
            checkClose = true;
            if (this.taxadbFrame.isShowing()) {
                isShowing = true;
            }
        }
        if (this.wellsFrame != null) {
            checkClose = true;
            if (this.wellsFrame.isShowing()) {
                isShowing = true;
            }
        }
        for (FrameOrganiser f : this.organiserFrames) {
            if (!f.isShowing()) continue;
            isShowing = true;
            break;
        }
        if (this.samplesFrame != null) {
            FrameSamples.ExitStatus samplesExitStatus;
            checkClose = true;
            if (this.samplesFrame.isShowing()) {
                isShowing = true;
            }
            if ((samplesExitStatus = this.samplesFrame.checkExit()) == FrameSamples.ExitStatus.NO_EXIT) {
                return false;
            }
            if (samplesExitStatus == FrameSamples.ExitStatus.EXIT_CONFIRMED) {
                isShowing = false;
                checkClose = false;
            }
        }
        if (checkClose && JOptionPane.showConfirmDialog(this, (isShowing ? "Close all Windows and " : "") + "Exit StrataBugs?", this.getTitle(), 0, 2) != 0) {
            return false;
        }
        if (this.samplesFrame != null) {
            this.samplesFrame.exit(true);
        }
        try {
            RefreshHelper.stopRefresh();
            if (this.sbdb == null) {
                return true;
            }
            this.sbdb.commit();
            this.sbdb.close();
        }
        catch (Exception ex) {
            System.out.println("Error closing database: " + ex.getMessage());
            ex.printStackTrace();
        }
        SbugsLicense.checkExit();
        if (SbugsSession.getSession().getParameters().doBackup() && (opt = JOptionPane.showConfirmDialog(this, this.bundle.getString("FrameJsbugs.backup"), this.getTitle(), 0, 3)) == 0) {
            DialogBackup dialog = new DialogBackup((Frame)this, true, SbugsSession.getSession().getParameters());
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }
        return true;
    }

    private void jMenuItemConfigAbnActionPerformed(ActionEvent evt) {
        try {
            DialogAbnSchemes dialog = new DialogAbnSchemes((Frame)this, this.sbdb);
            SB.centreDialog((Dialog)dialog);
            dialog.setVisible(true);
        }
        catch (RuntimeException ex) {
            SbugsExceptionHandler.showDialogStackError(ex, this);
        }
    }

    private void jMenuItemRefreshActionPerformed(ActionEvent evt) {
        if (DialogManualRefresh.isInstantiated()) {
            int opt = JOptionPane.showConfirmDialog(this, "Manual refresh is open. Close it now?", this.getTitle(), 0, 3);
            if (opt != 0) {
                return;
            }
            DialogManualRefresh.close();
        }
        DialogRefresh dialog = new DialogRefresh(this);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.isOK()) {
            this.startRefresh();
        }
    }

    private void jButtonOrganiserActionPerformed(ActionEvent evt) {
        try {
            if (!SbugsLicense.checkRLMlicense()) {
                JOptionPane.showMessageDialog(this, "StrataBugs licence no longer available.", "StrataBugs", 0);
                return;
            }
            String frameTitle = null;
            if (this.organiserFrames.size() > 0) {
                if (JOptionPane.showConfirmDialog(this, this.bundle.getString("FrameJsbugs.organiseropen"), "Organiser", 0, 3) != 0) {
                    for (FrameOrganiser frame : this.organiserFrames) {
                        if (frame.getState() != 1) continue;
                        frame.setState(0);
                    }
                    return;
                }
                frameTitle = "StrataBugs: " + (this.organiserFrames.size() + 1) + " Organiser";
            }
            FrameOrganiser frame = new FrameOrganiser(this, this.sbdb);
            frame.setLocationRelativeTo(this);
            frame.setVisible(true);
            if (frameTitle != null) {
                frame.setTitle(frameTitle);
            }
            this.organiserFrames.add(frame);
        }
        catch (Exception e) {
            FrameJsbugs.showStackError("Exception opening Organiser frame: ", e, this.sbdb);
            StackError.showStackError((String)"Error", (Throwable)e);
        }
    }

    GraphicsConfiguration getAltGC() {
        GraphicsConfiguration defgc = this.getGraphicsConfiguration();
        GraphicsDevice[] gds = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        if (gds.length == 1) {
            return defgc;
        }
        for (GraphicsDevice dev : gds) {
            if (dev == defgc.getDevice()) continue;
            return dev.getDefaultConfiguration();
        }
        return defgc;
    }

    private void jMenuItemScreenActionPerformed(ActionEvent evt) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        GraphicsDevice[] gds = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        Object strg = "You have screens: \n";
        System.out.println("GraphicsDevice length: " + gds.length);
        for (GraphicsDevice dev : gds) {
            GraphicsConfiguration[] gc = dev.getConfigurations();
            System.out.println("GraphicsConfiguration length: " + gc.length);
            for (GraphicsConfiguration fig : gc) {
                strg = (String)strg + dev.getIDstring() + " [of " + gds.length + "], bounds: " + String.valueOf(fig.getBounds()) + "\n";
            }
        }
        this.setCursor(Cursor.getDefaultCursor());
        JOptionPane.showMessageDialog(this, strg, "Screen Configuration", 1);
    }

    private void jMenuItemImageStorageActionPerformed(ActionEvent evt) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            DialogManageImages dialog = new DialogManageImages((Frame)this, false, this.sbdb);
            dialog.setLocationRelativeTo(this);
            this.setCursor(Cursor.getDefaultCursor());
            dialog.setVisible(true);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jCheckBoxMenuItemSQLtoCmdActionPerformed(ActionEvent evt) {
        SqlCache.setShowSql((!SqlCache.isShowingSql() ? 1 : 0) != 0);
        this.jCheckBoxMenuItemSQLtoCmd.setSelected(SqlCache.isShowingSql());
    }

    private void jMenuItemContentsActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("index.html");
    }

    private void jMenuItemMiscColoursActionPerformed(ActionEvent evt) {
        try {
            DialogMiscColours dialog = new DialogMiscColours((Frame)this, true, this.sbdb);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }
        catch (Exception ex) {
            StackError.showStackError((String)ex.getMessage(), (Throwable)ex);
            ex.printStackTrace();
        }
    }

    private void jMenuItemLogDefActionPerformed(ActionEvent evt) {
        try {
            DialogLogDefs dialog = new DialogLogDefs((Frame)this, true, this.sbdb);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }
        catch (Exception ex) {
            StackError.showStackError((String)ex.getMessage(), (Throwable)ex);
            ex.printStackTrace();
        }
    }

    private void jMenuItemSBUpdateActionPerformed(ActionEvent evt) {
        File check = new File(".");
        String exceptionMessage = "";
        try {
            LOGGER.log(Level.INFO, "Current file path is: {0}", check.getCanonicalPath());
        }
        catch (IOException ex) {
            exceptionMessage = ex.getMessage();
        }
        if (!check.canWrite()) {
            JOptionPane.showMessageDialog(this, "You do not have permission to update files in the current folder.\n" + exceptionMessage, "StrataBugs Update", 2);
            return;
        }
        LOGGER.log(Level.INFO, "Path is writeable");
        try {
            URLConnection conn;
            URL updaterURL = new URL("https://www.stratadata.co.uk/StrataBugs/" + Jsbugs.APP_VERSION + "/install/sbupdate.jar");
            Object updaterFileName = "sbupdate.jar";
            if (FrameJsbugs.isMacPlatform() && check.getCanonicalPath().length() == 1) {
                updaterFileName = "/Applications/StrataBugs.app/Contents/app/" + (String)updaterFileName;
            }
            File updaterApp = new File((String)updaterFileName);
            boolean downloadUpdater = true;
            LOGGER.log(Level.INFO, "Updater exists? : {0}", updaterApp.exists());
            System.out.println();
            if (updaterApp.exists()) {
                System.out.println("Connecting to: " + String.valueOf(updaterURL));
                conn = this.getConnection(updaterURL);
                Date currentDate = new Date(updaterApp.lastModified());
                if (conn.getLastModified() != 0L) {
                    Date releasedDate = new Date(conn.getLastModified());
                    downloadUpdater = releasedDate.getTime() > currentDate.getTime() + 3600000L;
                }
            }
            if (downloadUpdater) {
                System.out.println("Downloading from : " + String.valueOf(updaterURL));
                conn = this.getConnection(updaterURL);
                File outFile = File.createTempFile("Sbugs-", ".tmp", null);
                int total = 0;
                try (FileOutputStream fos = new FileOutputStream(outFile);){
                    InputStream ios = conn.getInputStream();
                    byte[] b = new byte[4097];
                    try {
                        int nBytes;
                        while ((nBytes = ios.read(b, 0, b.length)) > 0) {
                            fos.write(b, 0, nBytes);
                            total += nBytes;
                        }
                    }
                    catch (SocketTimeoutException e) {
                        JOptionPane.showMessageDialog(this, "Download of updater timed out.\nPlease check your network connection and try again, or contact StrataData for assistance");
                        fos.close();
                        return;
                    }
                }
                if (total < 10000) {
                    JOptionPane.showMessageDialog(this, "Download of updater retrieved only" + total + " bytes.\nPlease check your network connection and try again, or contact StrataData for assistance");
                    return;
                }
                outFile.setLastModified(conn.getLastModified());
                if (updaterApp.exists()) {
                    updaterApp.delete();
                }
                try {
                    Files.move(Paths.get(outFile.getPath(), new String[0]), Paths.get((String)updaterFileName, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException ex) {
                    LOGGER.log(Level.WARNING, "Cannot rename file: {0} to {1}, Message was: {2}", new Object[]{outFile.getAbsolutePath(), updaterFileName, ex});
                    JOptionPane.showMessageDialog(null, "Unable to copy updater to installation folder.\nUninstall StrataBugs and reinstall latest release to update.\nSee error log for details.", "StrataBugs", 2);
                    return;
                }
            }
            String javaHome = System.getProperty("java.home");
            Object exePath = FrameJsbugs.isMacPlatform() ? "java" : javaHome + File.separator + "bin" + (System.console() == null ? File.separator + "javaw.exe" : File.separator + "java.exe");
            LOGGER.log(Level.INFO, "Running updater using this path {0}", exePath);
            int opt = JOptionPane.showConfirmDialog(this, "You will need to close the control panel and applications before updating.\nClose now?", this.getTitle(), 0, 3);
            if (opt == 1) {
                return;
            }
            boolean exit = false;
            if (opt == 0) {
                exit = this.checkExit();
            }
            Runtime.getRuntime().exec((String)exePath + " -jar " + (String)updaterFileName, null, new File("."));
            if (exit) {
                System.exit(0);
            }
        }
        catch (HeadlessException | IOException ex) {
            StackError.showStackError((String)ex.getMessage(), (Throwable)ex);
            LOGGER.log(Level.WARNING, "Exception running updater", ex);
        }
    }

    URLConnection getConnection(URL url) {
        try {
            return FrameJsbugs.getSecureUrlConnection(url);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "I/O Error opening remote connection to URL: " + String.valueOf(url));
            LOGGER.log(Level.WARNING, "I/O Error opening remote connection to URL: " + String.valueOf(url), e);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Exception opening remote connection to URL: " + String.valueOf(url), e);
        }
        return null;
    }

    public static URLConnection getSecureUrlConnection(URL url) throws IOException {
        HttpsURLConnection uc = (HttpsURLConnection)url.openConnection();
        ProxySettings proxySettings = RegistryPreferencesHelper.getProxySettings();
        if (proxySettings != null) {
            if (proxySettings.getProxyHost() != null && !proxySettings.getProxyHost().isBlank()) {
                System.setProperty("proxySet", "true");
                System.setProperty("https.proxyHost", proxySettings.getProxyHost());
                System.setProperty("https.proxyPort", proxySettings.getProxyPort());
            }
            if (proxySettings.getProxyUser() != null && !proxySettings.getProxyUser().isBlank()) {
                System.setProperty("https.proxyUser", proxySettings.getProxyUser());
                System.setProperty("https.proxyPassword", proxySettings.getProxyPassword());
                String s = proxySettings.getProxyUser() + ":" + proxySettings.getProxyPassword();
                String se = Base64.getEncoder().encodeToString(s.getBytes());
                uc.setRequestProperty("Proxy-Authorization", "Basic " + se);
                uc.connect();
            }
        }
        return uc;
    }

    private void jMenuItemHelpCPActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("control_panel.html");
    }

    private void jRadioButtonMenuItemHelpLocalIEActionPerformed(ActionEvent evt) {
        HelpUtils.setHelpLocation((HelpUtils.HelpLocation)HelpUtils.HelpLocation.IE);
    }

    private void jRadioButtonMenuItemHelpLocalFFActionPerformed(ActionEvent evt) {
        HelpUtils.setHelpLocation((HelpUtils.HelpLocation)HelpUtils.HelpLocation.FF);
    }

    private void jRadioButtonMenuItemHelpWebActionPerformed(ActionEvent evt) {
        HelpUtils.setHelpLocation((HelpUtils.HelpLocation)HelpUtils.HelpLocation.WEB);
    }

    private void jRadioButtonMenuItemHelpLocalFolderActionPerformed(ActionEvent evt) {
        HelpUtils.setHelpLocation((HelpUtils.HelpLocation)HelpUtils.HelpLocation.LOCAL);
    }

    private void jRadioButtonMenuItemDepthsTopActionPerformed(ActionEvent evt) {
        this.setDepthPref(true);
        this.setSampleTops();
    }

    private void jRadioButtonMenuItemDepthsBaseActionPerformed(ActionEvent evt) {
        this.setDepthPref(false);
        this.setSampleTops();
    }

    private void jMenuItemManageConnectionsActionPerformed(ActionEvent evt) {
        DialogConnectionManager dialog = new DialogConnectionManager((Window)this, true, SBdb.MODEL_VERSION);
        dialog.setLocationRelativeTo((Component)this);
        dialog.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jMenuItemNullTopDepthsActionPerformed(ActionEvent evt) {
        try {
            int opt;
            Object warning = "Set all TOP depths to NULL?";
            if (this.sbdb.useSampleTops()) {
                warning = (String)warning + "\nThis is the OPPOSITE of your system preference for using sample top depths!";
            }
            if ((opt = JOptionPane.showConfirmDialog(this, warning, this.getTitle(), 0, 3)) != 0) {
                return;
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            int nRows = this.sbdb.setNullSampleDepths(true);
            this.sbdb.commit();
            JOptionPane.showMessageDialog(this, "Number of rows updated: " + nRows + "\nExit from the control panel and restart.", this.getTitle(), 2);
        }
        catch (Exception ex) {
            StackError.showStackError((String)ex.getMessage(), (Throwable)ex);
            this.sbdb.doRollback();
            ex.printStackTrace();
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jMenuItemNullBaseDepthsActionPerformed(ActionEvent evt) {
        try {
            int opt;
            Object warning = "Set all BASE depths to NULL?";
            if (!this.sbdb.useSampleTops()) {
                warning = (String)warning + "\nThis is the OPPOSITE of your system preference for using sample base depths!";
            }
            if ((opt = JOptionPane.showConfirmDialog(this, warning, this.getTitle(), 0, 3)) != 0) {
                return;
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            int nRows = this.sbdb.setNullSampleDepths(false);
            this.sbdb.commit();
            JOptionPane.showMessageDialog(this, "Number of rows updated: " + nRows + "\nExit from the control panel and restart.", this.getTitle(), 2);
        }
        catch (Exception ex) {
            StackError.showStackError((String)ex.getMessage(), (Throwable)ex);
            this.sbdb.doRollback();
            ex.printStackTrace();
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jMenuItemDBInfoActionPerformed(ActionEvent evt) {
        try {
            DialogDBInfo dialog = new DialogDBInfo((Frame)this, true, this.sbdb);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }
        catch (SQLException e) {
            SbugsExceptionHandler.showStackError("Error getting database info", e, this);
        }
    }

    private void jRadioButtonMenuItemLOG1ActionPerformed(ActionEvent evt) {
        this.setLogPrec(1);
    }

    private void jRadioButtonMenuItemLOG2ActionPerformed(ActionEvent evt) {
        this.setLogPrec(2);
    }

    private void jRadioButtonMenuItemLOG3ActionPerformed(ActionEvent evt) {
        this.setLogPrec(3);
    }

    private void jMenuItemautoMergeTaxaActionPerformed(ActionEvent evt) {
        if ((this.sbdb.getUser().getPriv() & 0x40) == 0) {
            JOptionPane.showMessageDialog(this, "You need to be a super-user to change this setting", "Auto-merge", 2);
            return;
        }
        DialogAutoMergeTaxa dialog = new DialogAutoMergeTaxa((Frame)this, true, this.sbdb);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }

    private void jCheckBoxMenuItemExportSingleUserActionPerformed(ActionEvent evt) {
        try {
            if (this.jCheckBoxMenuItemExportSingleUser.isSelected() && this.sbdb.getExportSingleUserAbr(false).isEmpty()) {
                JOptionPane.showMessageDialog(this, "You must set the single user abbreviation before you export data.", this.getTitle(), 1);
            }
            this.sbdb.setExportSingleUser(this.jCheckBoxMenuItemExportSingleUser.isSelected());
            this.sbdb.commit();
        }
        catch (SQLException ex) {
            SbugsExceptionHandler.showStackError(ex, this);
        }
    }

    private void jMenuItemExportABRActionPerformed(ActionEvent evt) {
        if ((this.sbdb.getUser().getPriv() & 0x40) == 0) {
            JOptionPane.showMessageDialog(this, "You need to be a super-user to change this setting", "Depth Preferences", 2);
            return;
        }
        try {
            String abr = null;
            boolean allowed = false;
            do {
                String msg = "Export all data with user ID: ";
                if (abr != null) {
                    msg = "That ID is not valid - must be less than 5 letters";
                }
                if ((abr = JOptionPane.showInputDialog(this, msg, this.getTitle(), 2)) == null) {
                    return;
                }
                if ((abr = abr.trim()).length() > 5) continue;
                allowed = true;
            } while (!allowed);
            this.sbdb.setExportSingleUserAbr(abr);
            this.sbdb.commit();
            this.setExportDataMenu();
        }
        catch (Exception ex) {
            StackError.showStackError((String)ex.getMessage(), (Throwable)ex);
        }
    }

    private void jMenuItemEventPrefixActionPerformed(ActionEvent evt) {
        if ((this.sbdb.getUser().getPriv() & 0x40) == 0) {
            JOptionPane.showMessageDialog(this, "You need to be a super-user to change this setting", "Depth Preferences", 2);
            return;
        }
        DialogEventPrefix dialog = new DialogEventPrefix((Frame)this, true, this.sbdb);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }

    private void jMenuItemChartScalesActionPerformed(ActionEvent evt) {
        if ((this.sbdb.getUser().getPriv() & 0x40) == 0) {
            JOptionPane.showMessageDialog(this, "You need to be a super-user to change this setting", "Depth Preferences", 2);
            return;
        }
        try {
            DialogChartScales dialog = new DialogChartScales((Frame)this, true, this.sbdb);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
    }

    private void jMenuItemQueryActionPerformed(ActionEvent evt) {
        DialogSQLQuery dialog = new DialogSQLQuery((Frame)this, false, this.sbdb);
        dialog.setLocationRelativeTo((Component)this);
        dialog.setVisible(true);
    }

    private void jMenuItemEditWirelineLogPathsActionPerformed(ActionEvent evt) {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            DialogSBChartLogPath dialog = new DialogSBChartLogPath((Frame)this, true, this.sbdb);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }
        catch (Exception ex) {
            StackError.showStackError((String)ex.toString(), (Throwable)ex);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jMenuItemRLMRoamActionPerformed(ActionEvent evt) {
        try {
            DialogRLMRoam dialog = new DialogRLMRoam(this, true);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.isOK()) {
                System.exit(0);
            }
        }
        catch (LicenseException ex) {
            StackError.showStackError((String)ex.toString(), (Throwable)ex);
        }
    }

    private void jMenuItemMergeDuplicateEventsActionPerformed(ActionEvent evt) {
        if ((this.sbdb.getUser().getPriv() & 0x40) == 0) {
            JOptionPane.showMessageDialog(this, "You need to be a super-user to run this", "Merge events", 2);
            return;
        }
        if (JOptionPane.showConfirmDialog(this, "This process merges duplicate events created by a legacy bug in the event generation process.\nYou will need to close the control panel and reopen afterwards. OK to continue?", "Merge events", 0, 3) != 0) {
            return;
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            int nUpdated = SBEvent.autoMerge(this.sbdb);
            this.sbdb.commit();
            JOptionPane.showMessageDialog(this, "Process complete: number updated: " + nUpdated + "\nClose the control panel and reopen.", "Merge events", 2);
        }
        catch (Exception ex) {
            this.sbdb.doRollback();
            StackError.showStackError((String)ex.toString(), (Throwable)ex);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jRadioButtonMenuItemSingleActionPerformed(ActionEvent evt) {
        if (!this.setEnvPref(false)) {
            this.jRadioButtonMenuItemMultiple.setSelected(false);
            this.jRadioButtonMenuItemSingle.setSelected(true);
        }
    }

    private void jRadioButtonMenuItemMultipleActionPerformed(ActionEvent evt) {
        if (!this.setEnvPref(true)) {
            this.jRadioButtonMenuItemMultiple.setSelected(true);
            this.jRadioButtonMenuItemSingle.setSelected(false);
        }
    }

    private void jRadioButtonMenuItemGuiSystemActionPerformed(ActionEvent evt) {
        this.setGuiResize(false);
    }

    private void jRadioButtonMenuItemGuiSizes100ActionPerformed(ActionEvent evt) {
        this.setGuiResize(true);
    }

    private void setGuiResize(boolean resizegui) {
        boolean current = RegistryPreferencesHelper.getGuiResizePreference(false);
        if (current != resizegui) {
            RegistryPreferencesHelper.putGuiResizePreferece(resizegui);
            JOptionPane.showMessageDialog(this, "Restart StrataBugs to see changes.", this.getTitle(), 1);
        }
    }

    private void jMenuItemHierNamesActionPerformed(ActionEvent evt) {
        if ((this.sbdb.getUser().getPriv() & 0x40) == 0) {
            JOptionPane.showMessageDialog(this, "Only super-users can change this setting", "Hierarchy Level Names", 2);
            return;
        }
        DialogHierNames dialog = new DialogHierNames((Frame)this, true, this.sbdb);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }

    private void jMenuItemAuditTrailActionPerformed(ActionEvent evt) {
        DialogAuditTrail dialog = new DialogAuditTrail((Frame)this, true, this.sbdb);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }

    private void jCheckBoxMenuItemHelpHintsActionPerformed(ActionEvent evt) {
        this.setHints(this.jCheckBoxMenuItemHelpHints.isSelected());
    }

    private void jCheckBoxMenuItemWjsbugsActionPerformed(ActionEvent evt) {
        try {
            SbugsSession.getSession().setWjsbugs(this.jCheckBoxMenuItemWjsbugs.isSelected());
        }
        catch (UserServiceNotAvailableException notAvailableException) {
            JOptionPane.showMessageDialog(this, notAvailableException.getMessage(), "Web Services Not Available", 0);
            this.jCheckBoxMenuItemWjsbugs.setSelected(false);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("Error setting preference", sql, this.sbdb);
        }
    }

    private void jMenuItemWjsbugsAboutActionPerformed(ActionEvent evt) {
        HelpUtils.openBlog((String)"/2016/11/19/wjsbugs-user/");
    }

    private void jMenuItemWjsbugsProxyActionPerformed(ActionEvent evt) {
        DialogProxySettings dialog = new DialogProxySettings(this, RegistryPreferencesHelper.getProxySettings());
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.isOK()) {
            RegistryPreferencesHelper.putProxySettings(dialog.getProxySettings());
        }
    }

    private void jMenuItemMemoryMonitorActionPerformed(ActionEvent evt) {
        DialogMemoryMonitor dialog = DialogMemoryMonitor.getInstance(this);
        dialog.setLocation(this.getX() + this.getWidth(), this.getY());
        dialog.setVisible(true);
    }

    private void jMenuItemLoggingActionPerformed(ActionEvent evt) {
        DialogLogging dialog = new DialogLogging(this, true);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }

    private void jMenuItemChartGenActionPerformed(ActionEvent evt) {
        DialogChartGen dialog = DialogChartGen.getInstance(this);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }

    private void jMenuItemManualRefreshActionPerformed(ActionEvent evt) {
        if (RefreshHelper.getRefreshInterval() > 0L) {
            JOptionPane.showMessageDialog(this, "Auto-refresh is on. Disable this for to use manual refresh.", this.getTitle(), 2);
            return;
        }
        DialogManualRefresh dialog = DialogManualRefresh.getInstance(this, this.sbdb, this.chartManager);
        dialog.setLocation(this.getX() - dialog.getWidth(), this.getY());
        dialog.setVisible(true);
    }

    private void jCheckBoxMenuItemAllowCountryCaseActionPerformed(ActionEvent evt) {
        System.out.println("Item is seleced: " + this.jCheckBoxMenuItemAllowCountryCase.isSelected());
        if (!this.setCountryCase(this.jCheckBoxMenuItemAllowCountryCase.isSelected())) {
            this.jCheckBoxMenuItemAllowCountryCase.setSelected(!this.jCheckBoxMenuItemAllowCountryCase.isSelected());
        }
    }

    private void jMenuItemBackupActionPerformed(ActionEvent evt) {
        try {
            this.sbdb.commit();
            this.sbdb.close();
        }
        catch (SQLException ex) {
            SbugsExceptionHandler.showStackError(ex);
            return;
        }
        DialogBackup dialog = new DialogBackup((Frame)this, true, SbugsSession.getSession().getParameters());
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        SbugsSession.attemptReconnection();
    }

    private void jMenuItemSBconvertActionPerformed(ActionEvent evt) {
        try {
            boolean exit = false;
            int opt = JOptionPane.showConfirmDialog(this, "Close Control Panel?", this.getTitle(), 1, 3);
            if (opt == 2) {
                return;
            }
            if (opt == 0) {
                exit = this.checkExit();
            }
            Jsbugs.runSBconvert(exit, Userdef.isSuperUser(this.sbdb.getUser().getPriv()));
        }
        catch (IOException ex) {
            SbugsExceptionHandler.showStackError(ex);
        }
    }

    private void jCheckBoxMenuItemHiResIconsActionPerformed(ActionEvent evt) {
        this.setUseHighResIcons(this.jCheckBoxMenuItemHiResIcons.isSelected());
    }

    private void jCheckBoxMenuItemShowArchivedSchemesActionPerformed(ActionEvent evt) {
        this.sbdb.putShowArchivedSchemes(this.jCheckBoxMenuItemShowArchivedSchemes.isSelected());
    }

    private void jRadioButtonMenuItemNativeLAFActionPerformed(ActionEvent evt) {
        this.setLAF(SbugsLookAndFeelSetup.LAF.NATIVE);
    }

    private void jRadioButtonMenuItemFlatLightLAFActionPerformed(ActionEvent evt) {
        this.setLAF(SbugsLookAndFeelSetup.LAF.FLAT_LIGHT);
    }

    private void jRadioButtonMenuItemFlatDarkLAFActionPerformed(ActionEvent evt) {
        this.setLAF(SbugsLookAndFeelSetup.LAF.FLAT_DARK);
    }

    private void jMenuItemSbugsServerConfigActionPerformed(ActionEvent evt) {
        ArrayList<SynonymScheme> synSchs;
        List<InterpHdr> interps;
        SbugsServerConfigController.ServerConfig serverConfig;
        if ((this.sbdb.getUser().getPriv() & 0x40) == 0) {
            JOptionPane.showMessageDialog(this, "You need to be a super-user to change this setting", "Depth Preferences", 2);
            return;
        }
        SbugsServerConfigController controller = new SbugsServerConfigController(this.sbdb);
        try {
            serverConfig = controller.loadConfig();
            interps = this.sbdb.getInterps();
            synSchs = new ArrayList<SynonymScheme>(this.sbdb.getSynSchemes());
        }
        catch (RuntimeException | SQLException ex) {
            SbugsExceptionHandler.showStackError("Error loading server configuration", ex);
            return;
        }
        DialogSbugsServer dialog = new DialogSbugsServer(this, true, serverConfig, interps, synSchs);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.isOK()) {
            SbugsServerConfigController.ServerConfig newConfig = dialog.getNewConfig();
            try {
                controller.updateConfig(newConfig);
            }
            catch (SQLException ex) {
                SbugsExceptionHandler.showStackError("Error updating server configuration", ex);
            }
        }
    }

    private void jMenuItemCentreWindowActionPerformed(ActionEvent evt) {
        LinkedList<String> openWindows = new LinkedList<String>();
        static enum FrameName {
            WELLS("Wells  & Outcrops", 0),
            SAMPLES("Samples & Interpretations", 1),
            TAXADB("Taxa DB", 3),
            SCHEMES("Schemes & Interpretations", 4),
            ORGANISER("Organiser", 5),
            CHARTS("Charts & Templates", 6);

            String name;
            int index;

            private FrameName(String name, int index) {
                this.name = name;
                this.index = index;
            }
        }
        block15: for (FrameName frameName : FrameName.values()) {
            switch (frameName.ordinal()) {
                case 0: {
                    if (this.wellsFrame == null) continue block15;
                    openWindows.add(frameName.name);
                    continue block15;
                }
                case 1: {
                    if (this.samplesFrame == null) continue block15;
                    openWindows.add(frameName.name);
                    continue block15;
                }
                case 2: {
                    if (this.taxadbFrame == null) continue block15;
                    openWindows.add(frameName.name);
                    continue block15;
                }
                case 3: {
                    if (this.interpretationsFrame == null) continue block15;
                    openWindows.add(frameName.name);
                    continue block15;
                }
                case 4: {
                    if (this.organiserFrames.isEmpty()) continue block15;
                    openWindows.add(frameName.name);
                    continue block15;
                }
                case 5: {
                    if (this.chartFrame == null) continue block15;
                    openWindows.add(frameName.name);
                }
            }
        }
        if (!openWindows.isEmpty()) {
            DialogList dialog = new DialogList(this, true, "Select Frame", null, openWindows, true, false);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.getSelection() != null) {
                String selectedFrame = (String)dialog.getSelection();
                Window frame = null;
                block16: for (FrameName fName : FrameName.values()) {
                    if (!selectedFrame.equals(fName.name)) continue;
                    switch (fName.ordinal()) {
                        case 0: {
                            frame = this.wellsFrame;
                            continue block16;
                        }
                        case 1: {
                            frame = this.samplesFrame;
                            continue block16;
                        }
                        case 2: {
                            frame = this.taxadbFrame;
                            continue block16;
                        }
                        case 3: {
                            frame = this.interpretationsFrame;
                            continue block16;
                        }
                        case 5: {
                            frame = this.chartFrame;
                        }
                    }
                }
                if (frame != null) {
                    frame.setVisible(true);
                    ((SBFrame)frame).centreOnScreen();
                } else {
                    Iterator<FrameOrganiser> iterator = this.organiserFrames.iterator();
                    Point loc = null;
                    while (iterator.hasNext()) {
                        FrameOrganiser f = iterator.next();
                        f.setVisible(true);
                        f.centreOnScreen();
                        if (loc != null) {
                            f.setLocation(loc.x + 20, loc.y + 20);
                        }
                        loc = f.getLocation();
                    }
                }
            }
        }
    }

    private void jCheckBoxMenuItemQueryPDFfontActionPerformed(ActionEvent evt) {
        try {
            Lastval.putInt(this.sbdb, "PDFQEMBED", this.jCheckBoxMenuItemQueryPDFfont.isSelected() ? 1 : 0);
        }
        catch (SQLException e) {
            SbugsExceptionHandler.showStackError("Error setting PDF font option", e);
        }
    }

    private void jCheckBoxMenuItemShowUpdatePopupActionPerformed(ActionEvent evt) {
        Preferences regPrefs = RegistryPreferencesHelper.getPreferences();
        regPrefs.putBoolean("update-popup", this.jCheckBoxMenuItemShowUpdatePopup.isSelected());
    }

    private void jCheckBoxMenuItemDelayUpdateReminderActionPerformed(ActionEvent evt) {
        Preferences regPrefs = RegistryPreferencesHelper.getPreferences();
        regPrefs.putBoolean("update-delay", this.jCheckBoxMenuItemDelayUpdateReminder.isSelected());
    }

    private void setUseHighResIcons(boolean useHiResIcons) {
        new UserPrefsHelper(this.sbdb).setUseHiResIcons(useHiResIcons);
    }

    private boolean setCountryCase(boolean b) {
        if ((this.sbdb.getUser().getPriv() & 0x40) == 0) {
            JOptionPane.showMessageDialog(this, "You need to be a super-user to change this setting", "Country case", 2);
            return false;
        }
        try {
            if (b && !this.sbdb.allowCountryCase()) {
                this.sbdb.setAllowCountryCase(true);
            } else if (!b && this.sbdb.allowCountryCase()) {
                this.sbdb.setAllowCountryCase(false);
            }
            this.sbdb.commit();
            return true;
        }
        catch (SQLException ex) {
            SbugsExceptionHandler.showStackError(ex);
            return false;
        }
    }

    private void setLogPrec(int dp) {
        try {
            SbugsSession.getSession().setLogDp(dp);
            this.sbdb.commit();
        }
        catch (SQLException | InvalidFieldException ex) {
            SbugsExceptionHandler.showStackError("Error setting LOG precision", ex, this);
        }
    }

    boolean setDepthPref(boolean topDepths) {
        boolean isGlobal = false;
        if (!Userdef.isSuperUser(this.sbdb.getUser().getPriv())) {
            if (JOptionPane.showConfirmDialog(this, "You need to be a super-user to change this for ALL users.\nDo you want to change this for just yourself?", "Depth Preferences", 0, 3) == 1) {
                return false;
            }
        } else {
            Object[] buttons = new String[]{"Just myself", "All database users", "Cancel"};
            int opt = JOptionPane.showOptionDialog(this, "Do you want to set this for ALL database users, or just yourself?", "Depth Preferences", 1, 3, null, buttons, null);
            if (opt == 2) {
                return false;
            }
            if (opt == 1) {
                isGlobal = true;
            }
        }
        try {
            if (topDepths && !this.sbdb.useSampleTops()) {
                this.sbdb.setSampleTops(true, isGlobal);
            } else if (!topDepths && this.sbdb.useSampleTops()) {
                this.sbdb.setSampleTops(false, isGlobal);
            }
            this.sbdb.commit();
            return true;
        }
        catch (SQLException ex) {
            SbugsExceptionHandler.showStackError(ex);
            return false;
        }
    }

    boolean setEnvPref(boolean allowMultipleEnvSchemes) {
        if ((this.sbdb.getUser().getPriv() & 0x40) == 0) {
            JOptionPane.showMessageDialog(this, "You need to be a super-user to change this setting", "Depth Preferences", 2);
            return false;
        }
        try {
            if (allowMultipleEnvSchemes && !this.sbdb.allowMultipleEnvSchemes()) {
                this.sbdb.setAllowMultipleEnvSchemes(true);
            } else if (!allowMultipleEnvSchemes && this.sbdb.allowMultipleEnvSchemes()) {
                this.sbdb.setAllowMultipleEnvSchemes(false);
            }
            this.sbdb.commit();
            return true;
        }
        catch (SQLException sql) {
            SbugsExceptionHandler.showStackError(sql);
            return false;
        }
    }

    static void testDongle(Component parent, String title) {
        if (!new File("spro.exe").exists()) {
            System.out.println("Showing msg:");
            JOptionPane.showMessageDialog(parent, "Sentinel tester not found in StrataBugs folder: " + System.getProperty("user.dir"), title, 0);
            return;
        }
        try {
            Runtime.getRuntime().exec("spro.exe");
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(parent, "Error running command:" + ex.getMessage(), title, 0);
            ex.printStackTrace();
        }
    }

    static File chooseFile(SBdb db, Component parent, String lastValWin, String lastValUnx, String[] extensions, String[] descriptions, String defaultFileName) {
        return FileChooserUtils.chooseFileToWrite((SBdb)db, (Component)parent, (String)lastValWin, (String)lastValUnx, (String[])extensions, (String[])descriptions, (String)defaultFileName);
    }

    private void setExportDataMenu() {
        try {
            String s = "Use abbreviation: ";
            String abr = this.sbdb.getExportSingleUserAbr(true);
            if (abr != null) {
                this.jMenuItemExportABR.setText(s + abr);
            } else {
                this.jMenuItemExportABR.setText(s + "(none set)");
            }
            this.jCheckBoxMenuItemExportSingleUser.setSelected(this.sbdb.getExportSingleUser(true));
        }
        catch (SQLException sql) {
            SbugsExceptionHandler.showStackError(sql, this);
        }
    }

    @Deprecated
    public static void showStackError(String msg, Exception ex, SBdb sbdb) {
        SbugsExceptionHandler.showStackError(msg, ex);
    }

    public static boolean isMacPlatform() {
        return System.getProperty("os.name").startsWith("Mac");
    }

    public static boolean isWindowsPlatform() {
        return System.getProperty("os.name").contains("Windows");
    }

    private void showPOIClasspath() {
        ClassLoader classloader = POIFSFileSystem.class.getClassLoader();
        URL res = classloader.getResource("org/apache/poi/poifs/filesystem/POIFSFileSystem.class");
        String path = res.getPath();
        LOGGER.log(Level.FINE, "POI Core came from {0}", path);
        classloader = XmlOptions.class.getClassLoader();
        res = classloader.getResource("org/apache/xmlbeans/XmlOptions.class");
        path = res.getPath();
        LOGGER.log(Level.FINE, "XmlOptions came from {0}", path);
    }
}

