/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.Discipline;
import com.stratadata.model3.user.Userdef;
import com.stratadata.model3.well.analysis.hdr.AbundanceScheme;
import com.stratadata.model3.well.analysis.hdr.AbundanceSchemeServiceImpl;
import com.stratadata.model3.well.curve.Curve;
import com.stratadata.model3.well.sample.SampleType;
import com.stratadata.sblicense.SbugsLicense;
import com.stratadata.util.io.FileChooserUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Observable;
import java.util.Observer;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipFile;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.ProgressMonitor;
import javax.swing.SwingWorker;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import jsbchart.core.Chart;
import jsbchart.core.ChartFactory;
import jsbchart.core.ChartManager;
import jsbugs.ChartJPanel;
import jsbugs.DialogBugWareReader;
import jsbugs.DialogCSVImport;
import jsbugs.DialogChecklistReader;
import jsbugs.DialogDataTypes;
import jsbugs.DialogDepthUnits;
import jsbugs.DialogExportProjectEvents;
import jsbugs.DialogExportText;
import jsbugs.DialogImportAnalyses;
import jsbugs.DialogList;
import jsbugs.DialogMatchAbundance;
import jsbugs.DialogMatchAgeCurves;
import jsbugs.DialogMatchAnalysts;
import jsbugs.DialogMatchCmpStd;
import jsbugs.DialogMatchEnvScheme;
import jsbugs.DialogMatchEvents;
import jsbugs.DialogMatchGenera;
import jsbugs.DialogMatchIGD;
import jsbugs.DialogMatchIGDScheme;
import jsbugs.DialogMatchInterp;
import jsbugs.DialogMatchLithology;
import jsbugs.DialogMatchLogdef;
import jsbugs.DialogMatchSampleTypes;
import jsbugs.DialogMatchTaxa;
import jsbugs.DialogMatchTxGroup;
import jsbugs.DialogMatchTxGroupSet;
import jsbugs.DialogMatchWellHeader;
import jsbugs.DialogMatchWells;
import jsbugs.DialogODM;
import jsbugs.DialogOWXLSReader;
import jsbugs.DialogSelectEnvScheme;
import jsbugs.DialogSelectProject;
import jsbugs.DialogSelectProjectWellList;
import jsbugs.DialogSelectScheme;
import jsbugs.DialogSelectVersion;
import jsbugs.DialogSource;
import jsbugs.DialogTSCreator;
import jsbugs.DialogWellProjectSelection;
import jsbugs.FrameJsbugs;
import jsbugs.JPanelOrganiser;
import jsbugs.JPanelOrganiserDict;
import jsbugs.JScrollPaneChart;
import jsbugs.OrganiserTransferHandler;
import jsbugs.SbugsIO;
import jsbugs.io.DialogCSVExporOptions;
import jsbugs.io.DialogOrganiserReport;
import jsbugs.io.DialogSampleDetailsExport;
import jsbugs.io.GridBuilderChronoBathy;
import jsbugs.io.GridBuilderSampleDetails;
import jsbugs.io.OrganiserExportHelper;
import jsbugs.io.ReportGenerator;
import jsbugs.organiser.DialogExportWord;
import jsbugs.organiser.DialogImportFile;
import jsbugs.organiser.DialogPaleoImport;
import jsbugs.refresh.RefreshHelper;
import jsbugs.sbdb.ProjectUtils;
import jsbugs.uiutil.FileOverwriteCheck;
import jsbugs.uiutil.icon.IconFactory;
import jsbugs.userconnect.SbugsExceptionHandler;
import jsbugs.userconnect.SbugsSession;
import jsbugs.util.SBFrame;
import jsbugs.util.UserPrefsHelper;
import jsbugs.wellheader.DialogSelectWell;
import model3.AgeCurve;
import model3.AnalystHeader;
import model3.BugWareReader;
import model3.CSVReader;
import model3.ChecklistReader;
import model3.CompositeStandard;
import model3.CompositeStandardEvent;
import model3.DEXFile;
import model3.EnvScheme;
import model3.GenericReader;
import model3.Genus;
import model3.GeoSciReader;
import model3.IGDIntervalEnv;
import model3.IGDScheme;
import model3.IGDXLSReader;
import model3.ImportFileReaderType;
import model3.InterpHdr;
import model3.Lastval;
import model3.LithBase;
import model3.LogDef;
import model3.PDIReader;
import model3.RGReader;
import model3.SBEvent;
import model3.SBdb;
import model3.SISSbugsReader;
import model3.SQPick;
import model3.Sample;
import model3.SampleOccReaderXLS;
import model3.SampleReaderXLS;
import model3.SbugsReader;
import model3.Smpdtl;
import model3.Source;
import model3.SynonymScheme;
import model3.TSCreatorReader;
import model3.Taxon;
import model3.TaxonOcc;
import model3.TxGroup;
import model3.TxGroupSet;
import model3.Well;
import model3.WellChronoPickXLS;
import model3.WellEPaleoReader;
import model3.WellEventBSEEXLS;
import model3.WellEventEquinorXLS;
import model3.WellHeader;
import model3.WellHeaderXLS;
import model3.WellInterp;
import model3.WellLstratBujakXLS;
import model3.WellLstratPetrelXLS;
import model3.WellLstratPickXLS;
import model3.WellSQPickPetrelXLS;
import model3.WsLithology;
import model3.WsWell;
import model3.organiser.AnnotationReader;
import model3.organiser.LithologyImporter;
import model3.organiser.PaleoWorkspaceImporter;
import model3.project.Project;
import model3.project.WellList;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.jdesktop.layout.GroupLayout;
import util.FilePathUtils;
import util.InvalidFieldException;
import util.SB;
import util.SBException;
import util.SBPermissionException;
import util.SbugsFileFilter;
import util.UnmatchedException;
import util.exception.StackError;
import util.gridreader.GridReader;
import util.gridreader.GridReaderException;
import util.gridreader.XLSGridReader;
import util.gridwriter.CSVExportOptions;
import util.gridwriter.GridWriter;
import util.status.SbugsStatus;

public class FrameOrganiser
extends SBFrame
implements PropertyChangeListener {
    private static final String[] FRAME_ICONS = new String[]{"48Org.png", "32Org.png", "24Org.png", "16Org.png"};
    private static final Logger LOGGER = Logger.getLogger(FrameOrganiser.class.getName());
    private final FrameJsbugs parent;
    private final SBdb db;
    private ChartManager wsCM;
    private SBdb ws;
    private char units = (char)68;
    private final DefaultComboBoxModel projectModel = new DefaultComboBoxModel();
    private WsWell wellBeingStored = null;
    private Project project;
    final Set<Integer> dataTypes = new HashSet<Integer>();
    boolean includeReferencesInXML = false;
    private boolean inWizard;
    private boolean autoResize = true;
    private ProgressMonitor pm;
    boolean isSavingData = false;
    private Source autoMatchSource;
    private static final String DICT_TAB_NAME = "Dictionaries";
    private static final String CHART_TAB_NAME = "Charts & Templates";
    private final UserPrefsHelper prefsHelper;
    private OrganiserExportHelper exporter;
    private final ResourceBundle resources = ResourceBundle.getBundle("locale/UiText");
    private int synSchID = 0;
    private JFileChooser jFileChooserCommonOpen;
    private JFileChooser jFileChooserDEX;
    private JFileChooser jFileChooserCSV;
    private JFileChooser jFileChooserXML;
    private JFileChooser jFileChooserXLS;
    private JFileChooser jFileChooserZIP;
    HashMap<Integer, Chart> chartPreviews = new HashMap();
    private ButtonGroup buttonGroupMenuUnits;
    private JButton jButtonDataTypes;
    private JButton jButtonExport;
    private JButton jButtonImport;
    private JButton jButtonOpenFile;
    private JButton jButtonOpenProject;
    private JButton jButtonOpenWells;
    private JButton jButtonProject;
    private JButton jButtonSaveToDatabase;
    private JButton jButtonSaveToFile;
    private JCheckBoxMenuItem jCheckBoxMenuItemAutoMatch;
    private JCheckBoxMenuItem jCheckBoxMenuItemAutoScroll;
    private JComboBox jComboBoxChartProject;
    private JComboBox jComboBoxProject;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JMenu jMenu1;
    private JMenu jMenu2;
    private JMenu jMenu3;
    private JMenu jMenuAutoMatch;
    private JMenuBar jMenuBar1;
    private JMenu jMenuFile;
    private JMenu jMenuHelp;
    private JMenuItem jMenuItem1;
    private JMenuItem jMenuItemAutoMatchSource;
    private JMenuItem jMenuItemDataTypes;
    private JMenuItem jMenuItemEPaleo;
    private JMenuItem jMenuItemExit;
    private JMenuItem jMenuItemExportJSON;
    private JMenuItem jMenuItemExportProjectEvents;
    private JMenuItem jMenuItemExportWordReport;
    private JMenuItem jMenuItemExportXLSInterpretedWorkbook;
    private JMenuItem jMenuItemGuidedExport;
    private JMenuItem jMenuItemGuidedExportBHP;
    private JMenuItem jMenuItemGuidedExportSPDC;
    private JMenuItem jMenuItemGuidedImport;
    private JMenuItem jMenuItemHelpMatch;
    private JMenuItem jMenuItemHelpMenu;
    private JMenuItem jMenuItemIC;
    private JMenuItem jMenuItemLoadWorkspace;
    private JMenuItem jMenuItemMatchAbundance;
    private JMenuItem jMenuItemMatchAgeCurves;
    private JMenuItem jMenuItemMatchAnalysts;
    private JMenuItem jMenuItemMatchCmpStds;
    private JMenuItem jMenuItemMatchEnvSchemes;
    private JMenuItem jMenuItemMatchEvents;
    private JMenuItem jMenuItemMatchGenera;
    private JMenuItem jMenuItemMatchIGDIntervals;
    private JMenuItem jMenuItemMatchIGDSchemes;
    private JMenuItem jMenuItemMatchInterp;
    private JMenuItem jMenuItemMatchLogDef;
    private JMenuItem jMenuItemMatchSets;
    private JMenuItem jMenuItemMatchTaxa;
    private JMenuItem jMenuItemMatchTxGroups;
    private JMenuItem jMenuItemMatchWells;
    private JMenuItem jMenuItemMultiWellFlatFile;
    private JMenuItem jMenuItemOpenAnnotationFiles;
    private JMenuItem jMenuItemOpenBuakLithostrat;
    private JMenuItem jMenuItemOpenBugWare;
    private JMenuItem jMenuItemOpenBugWareDictionary;
    private JMenuItem jMenuItemOpenCSV;
    private JMenuItem jMenuItemOpenChecklist;
    private JMenuItem jMenuItemOpenCommon;
    private JMenuItem jMenuItemOpenDEX;
    private JMenuItem jMenuItemOpenEventsBSEE;
    private JMenuItem jMenuItemOpenEventsGoM;
    private JMenuItem jMenuItemOpenGeoSci;
    private JMenuItem jMenuItemOpenIGDXLS;
    private JMenuItem jMenuItemOpenOWXLS;
    private JMenuItem jMenuItemOpenProject;
    private JMenuItem jMenuItemOpenRG;
    private JMenuItem jMenuItemOpenSISSbugs;
    private JMenuItem jMenuItemOpenSampleOccXLS;
    private JMenuItem jMenuItemOpenSampleOccXLS2;
    private JMenuItem jMenuItemOpenSampleXLS;
    private JMenuItem jMenuItemOpenSbugs;
    private JMenuItem jMenuItemOpenTSCreator;
    private JMenuItem jMenuItemOpenWellHeaderXLS;
    private JMenuItem jMenuItemOpenWells;
    private JMenuItem jMenuItemOpenXLSOWPetrel;
    private JMenuItem jMenuItemOpenXML;
    private JMenuItem jMenuItemOpenZip;
    private JMenuItem jMenuItemOrganiserHelp;
    private JMenuItem jMenuItemPDI;
    private JMenuItem jMenuItemReadPaleoenvironmentIntervals;
    private JMenuItem jMenuItemReadWellLithology;
    private JMenuItem jMenuItemRemoveVersion;
    private JMenuItem jMenuItemReplaceAll;
    private JMenuItem jMenuItemReport;
    private JMenuItem jMenuItemSampleSummaryExport;
    private JMenuItem jMenuItemSaveChartsInDatabase;
    private JMenuItem jMenuItemSaveChronoBathy;
    private JMenuItem jMenuItemSaveDEX;
    private JMenuItem jMenuItemSaveInDatabase;
    private JMenuItem jMenuItemSaveRanges;
    private JMenuItem jMenuItemSaveText;
    private JMenuItem jMenuItemSaveZipFile;
    private JMenuItem jMenuItemViewExclude;
    private JMenuItem jMenuItemViewVersion;
    private JMenu jMenuMatch;
    private JMenu jMenuOpenFile;
    private JMenu jMenuSaveToFile;
    private JMenu jMenuSynonymy;
    private JMenu jMenuView;
    private JPanel jPanelSaveChartsInDatabase;
    private JRadioButtonMenuItem jRadioButtonMenuItemDrilled;
    private JRadioButtonMenuItem jRadioButtonMenuItemFeet;
    private JRadioButtonMenuItem jRadioButtonMenuItemMetres;
    private JPopupMenu.Separator jSeparator1;
    private JPopupMenu.Separator jSeparator10;
    private JPopupMenu.Separator jSeparator11;
    private JPopupMenu.Separator jSeparator12;
    private JPopupMenu.Separator jSeparator13;
    private JPopupMenu.Separator jSeparator14;
    private JPopupMenu.Separator jSeparator15;
    private JPopupMenu.Separator jSeparator2;
    private JToolBar.Separator jSeparator3;
    private JToolBar.Separator jSeparator4;
    private JPopupMenu.Separator jSeparator5;
    private JPopupMenu.Separator jSeparator6;
    private JToolBar.Separator jSeparator7;
    private JPopupMenu.Separator jSeparator8;
    private JPopupMenu.Separator jSeparator9;
    private JTabbedPane jTabbedPane1;
    private JToolBar jToolBar1;

    public FrameOrganiser(FrameJsbugs parent, SBdb db) throws SQLException, SBException {
        this.parent = parent;
        this.db = db;
        this.prefsHelper = new UserPrefsHelper(db);
        this.exporter = new OrganiserExportHelper(this);
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException, SBException {
        super.init("Organiser - StrataBugs", FRAME_ICONS);
        this.setIcons();
        this.initNewWorkspace();
        this.loadUserDefults();
        this.fillProjectCombo();
        this.jComboBoxProject.addItemListener(new ItemListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    int committedToProject;
                    Project project = null;
                    if (this.this$0.jComboBoxProject.getSelectedItem() instanceof Project) {
                        project = (Project)((Object)this.this$0.jComboBoxProject.getSelectedItem());
                    }
                    if ((committedToProject = this.this$0.getWsProject()) > 0 && (project == null || project.getID() != committedToProject)) {
                        JOptionPane.showMessageDialog(this.this$0, "Cannot change project: some items in the workspace are already linked to another project.", this.this$0.getTitle(), 2);
                        if (committedToProject == 0) {
                            this.this$0.jComboBoxProject.setSelectedIndex(0);
                        } else {
                            try {
                                this.this$0.jComboBoxProject.setSelectedItem((Object)this.this$0.db.getProject(committedToProject));
                            }
                            catch (SQLException sql) {
                                FrameJsbugs.showStackError("Error", sql, this.this$0.db);
                            }
                        }
                    }
                }
            }
        });
        if (FrameJsbugs.isMacPlatform()) {
            this.jMenuHelp.setText("Help ");
            this.jMenuItemExit.setText("Close Organiser");
            this.jComboBoxProject.putClientProperty("JComboBox.isPopDown", Boolean.TRUE);
        }
        this.db.addObserver(new Observer(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void update(Observable o, Object arg) {
                if (o == this.this$0.db && arg instanceof Project) {
                    boolean found = false;
                    for (int i = 0; i < this.this$0.jComboBoxProject.getItemCount(); ++i) {
                        if (this.this$0.jComboBoxProject.getItemAt(i) != arg) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        Object item = this.this$0.jComboBoxProject.getSelectedItem();
                        this.this$0.fillProjectCombo();
                        this.this$0.jComboBoxProject.setSelectedItem(item);
                    }
                }
            }
        });
        try {
            String strg = Lastval.getString(this.db, "AUTOMATCH");
            if (strg != null && !strg.equalsIgnoreCase("N")) {
                List<Source> sources = Source.getSources(this.db);
                for (Source source : sources) {
                    if (!source.getID().equalsIgnoreCase(strg)) continue;
                    this.autoMatchSource = source;
                    break;
                }
                this.jCheckBoxMenuItemAutoMatch.setSelected(true);
            }
        }
        catch (SQLException sql) {
            sql.printStackTrace();
            this.jCheckBoxMenuItemAutoMatch.setSelected(false);
        }
        this.setSourceMenuText();
        this.jTabbedPane1.setTransferHandler(new OrganiserTransferHandler(new OrganiserTransferHandler.FileImportAction(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void importFile(File file) {
                if (!this.this$0.checkClear(false)) {
                    return;
                }
                if (this.this$0.openCommon(file)) {
                    this.this$0.startImport();
                }
            }
        }));
        this.initSynonymyMenu();
    }

    private void initWorkspace() {
    }

    private void initSynonymyMenu() {
        try {
            this.synSchID = Lastval.getInt(this.db, "OGSYNSCHID", 0);
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, "Error getting value from Lastval", e);
            this.synSchID = 0;
        }
        final ButtonGroup synonymyButtonGroup = new ButtonGroup();
        class SynSchMenuItem
        extends JRadioButtonMenuItem {
            final /* synthetic */ FrameOrganiser this$0;

            SynSchMenuItem(String text, int synSchID) {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
                this.setText(text);
                this.addActionListener(e -> this$0.setSynonymScheme(synSchID));
                this.setSelected(this$0.synSchID == synSchID);
                buttonGroup.add(this);
            }
        }
        this.jMenuSynonymy.add(new SynSchMenuItem("Do not use synonymy", 0));
        try {
            Collection<SynonymScheme> synSchemes = this.db.getSynSchemes();
            LinkedList<SynonymScheme> synonymSchemes = new LinkedList<SynonymScheme>(synSchemes);
            for (com.stratadata.model3.taxon.SynonymScheme synonymScheme : synonymSchemes) {
                this.jMenuSynonymy.add(new SynSchMenuItem(synonymScheme.getName(), synonymScheme.getSchID()));
            }
        }
        catch (SQLException sql) {
            SbugsExceptionHandler.showStackError("Error loading synonymy for menu", sql, this);
        }
        this.setSynonymScheme(this.synSchID);
    }

    public int getSynSchID() {
        return this.synSchID;
    }

    private void setSynonymScheme(int schemeID) {
        if (schemeID == this.synSchID) {
            return;
        }
        this.synSchID = schemeID;
        try {
            Lastval.putInt(this.db, "OGSYNSCHID", schemeID);
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, "Error setting Lastval for SYNSCHID", e);
        }
    }

    private void setSourceMenuText() {
        Object text = "Auto match [";
        text = !this.jCheckBoxMenuItemAutoMatch.isSelected() ? (String)text + "off" : (this.autoMatchSource != null ? (String)text + "source: " + this.autoMatchSource.getID() : (String)text + "no source");
        this.jMenuAutoMatch.setText((String)text + "]");
    }

    private void fillProjectCombo() {
        this.jComboBoxProject.removeAllItems();
        this.projectModel.addElement("Global");
        try {
            ProjectUtils.loadProjectCombo(this.db, this.projectModel, false);
        }
        catch (RuntimeException e) {
            SbugsExceptionHandler.showStackError(e, this);
        }
    }

    private void setIcons() {
        this.setMultiResIconImage("frameOrganiser.svg");
        if (SbugsSession.getSession().useHiResIcons()) {
            IconFactory.setButtonIconsInBackground(List.of(new IconFactory.ButtonIconInfo(this.jButtonImport, "guidedImport.svg", 45), new IconFactory.ButtonIconInfo(this.jButtonExport, "guidedExport.svg", 45), new IconFactory.ButtonIconInfo(this.jButtonOpenFile, "openFile.svg", 24), new IconFactory.ButtonIconInfo(this.jButtonOpenWells, "FrameJsbugs_jButtonWells.svg", 24), new IconFactory.ButtonIconInfo(this.jButtonOpenProject, "wellProject.svg", 24), new IconFactory.ButtonIconInfo(this.jButtonSaveToDatabase, "FrameOrganiser_SaveToDB.svg", 24), new IconFactory.ButtonIconInfo(this.jButtonSaveToFile, "FrameOrganiser_SaveToFile.svg", 24), new IconFactory.ButtonIconInfo(this.jButtonDataTypes, "FrameOrganiser_ViewDataTypes.svg", 24)));
        }
    }

    private int getWsProject() {
        try {
            for (TxGroup group : this.ws.getTxGroups()) {
                if (group.getLink() == null || group.getLink().getProjID() <= 0) continue;
                return group.getLink().getProjID();
            }
            for (TxGroupSet set : this.ws.getTxGroupSets()) {
                if (set.getLink() == null || set.getLink().getProjID() <= 0) continue;
                return set.getLink().getProjID();
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        return 0;
    }

    static void loadPOIClasses(ClassLoader loader) throws ClassNotFoundException {
        Class.forName("org.apache.poi.poifs.filesystem.POIFSFileSystem");
        Class.forName("org.apache.poi.hssf.usermodel.HSSFWorkbook");
        Class.forName("org.apache.poi.hssf.record.DrawingSelectionRecord", false, loader);
    }

    private void openGeneric(SBdb ws) {
        try {
            GenericReader.ReadBugWareDictionary(ws, this.db);
            this.refreshView();
        }
        catch (IOException | SQLException | SBException | SBPermissionException ex) {
            SbugsExceptionHandler.showStackError(ex, this);
        }
    }

    public ChartManager getWsChartManager() {
        return this.wsCM;
    }

    void importFile() {
        if (!SbugsLicense.checkRLMlicense()) {
            JOptionPane.showMessageDialog(this, "StrataBugs licence no longer available.", "StrataBugs", 0);
            this.jMenuItemExitActionPerformed(null);
            return;
        }
        if (!this.checkClear(false)) {
            return;
        }
        Well.resetQueryDuplicateSamples();
        if (this.openCommon()) {
            this.startImport();
        }
        Well.resetQueryDuplicateSamples();
    }

    private void startImport() {
        if (!(this.ws.getnLoadedWells() != 0 || this.wsCM != null && this.wsCM.hasDataLoaded())) {
            return;
        }
        this.inWizard = true;
        this.jMenuItemDataTypesActionPerformed(null);
        if (this.inWizard) {
            boolean matchAnalysts = false;
            try {
                for (Userdef user : this.ws.getUsers()) {
                    if (user.getLink() != null) continue;
                    matchAnalysts = true;
                    break;
                }
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
                matchAnalysts = true;
            }
            if (matchAnalysts) {
                this.matchAnalysts();
            }
        }
        if (this.inWizard && this.hasFssDataTypes()) {
            try {
                this.ws.checkDefaultAbnScheme();
                for (AbundanceScheme abundanceScheme : this.ws.getAbundanceSchemeService().getAllAbundanceSchemes()) {
                    if (((AbundanceSchemeServiceImpl)this.ws.getAbundanceSchemeService()).getLink(abundanceScheme.getAbnSchID()) == null && this.ws.getAbundanceSchemeInformationService().hasAbnSchemeOccs(abundanceScheme.getAbnSchID())) {
                        this.matchAbnScheme(abundanceScheme);
                    }
                    if (this.inWizard) continue;
                    break;
                }
            }
            catch (Exception e) {
                StackError.showStackError((String)"Error during import", (Throwable)e);
                this.inWizard = false;
            }
        }
        try {
            if (this.inWizard && (this.hasFssDataTypes() || this.dataTypes.contains(16) || !this.ws.getTxGroups().isEmpty()) && this.ws.hasTaxa()) {
                this.matchTaxa(null);
            }
            if (this.inWizard && !this.ws.getIndependentGenera().isEmpty()) {
                this.matchGenera();
            }
            if (this.inWizard && this.dataTypes.contains(16) && this.ws.hasEvents()) {
                this.matchEvents();
            }
            if (this.inWizard && this.wsCM != null) {
                for (CompositeStandard compositeStandard : this.ws.getCompositeStandards()) {
                    if (!this.wsCM.hasOccurrences(compositeStandard)) continue;
                    this.matchCmpStd(compositeStandard);
                    if (this.inWizard) continue;
                    break;
                }
            }
            if (this.inWizard && !this.ws.getLogDefs().isEmpty() && this.dataTypes.contains(23)) {
                this.matchLogDefs();
            }
            if (this.inWizard && (this.ws.getnLoadedWells() > 0 && this.hasIGDDataTypes() || this.wsCM != null && this.wsCM.hasInterpOccs(null))) {
                this.matchInterps();
            }
            if (this.inWizard && this.ws.getnLoadedWells() > 0 && (this.hasIGDZoneDataTypes() || this.dataTypes.contains(14))) {
                this.jMenuItemMatchIGDIntervalsActionPerformed(null);
            }
            if (this.inWizard && this.wsCM != null) {
                for (IGDScheme iGDScheme : this.ws.getIGDSchemes()) {
                    if (iGDScheme.getLink() == null && this.wsCM.hasOccurrences(iGDScheme)) {
                        this.matchIGDScheme(iGDScheme);
                    }
                    if (this.inWizard) continue;
                    break;
                }
            }
            if (this.inWizard && !this.ws.getAgeCurves().isEmpty()) {
                this.matchAgeCurves();
            }
            if (this.inWizard && (this.hasEnvDataType() || this.wsCM != null)) {
                try {
                    for (EnvScheme envScheme : this.ws.getEnvSchemes()) {
                        if (envScheme.getLink() != null) continue;
                        if (this.ws.hasEnvSchemeOccs(envScheme) || this.wsCM != null && this.wsCM.hasOccurrences(envScheme)) {
                            this.matchEnvScheme(envScheme);
                        }
                        if (this.inWizard) continue;
                        break;
                    }
                }
                catch (SQLException | SBException e) {
                    StackError.showStackError((String)e.getMessage(), (Throwable)e);
                    this.inWizard = false;
                }
            }
            if (this.inWizard && this.wsCM != null && this.wsCM.hasDataLoaded()) {
                ArrayList<TxGroup> sortedGroups = new ArrayList<TxGroup>(this.ws.getTxGroups());
                Collections.sort(sortedGroups);
                for (TxGroup group : sortedGroups) {
                    if (!this.ws.hasGrpSetOccurrences(group) && !this.wsCM.hasOccurrences(group)) continue;
                    this.matchTxGroup(group);
                    if (this.inWizard) continue;
                    break;
                }
            }
            if (this.inWizard && this.wsCM != null && this.wsCM.hasDataLoaded()) {
                for (TxGroupSet txGroupSet : this.ws.getTxGroupSets()) {
                    if (!this.wsCM.hasOccurrences(txGroupSet)) continue;
                    this.matchTxGroupSet(txGroupSet);
                    if (this.inWizard) continue;
                    break;
                }
            }
            if (this.inWizard && this.ws.getnLoadedWells() > 0) {
                this.jMenuItemMatchWellsActionPerformed(null);
            }
            if (this.inWizard) {
                if (this.ws.getnLoadedWells() > 0) {
                    if (JOptionPane.showConfirmDialog(this, "Save all well data to database?", this.getTitle(), 0, 3) == 0) {
                        this.saveInDatabase(false);
                    } else {
                        this.inWizard = false;
                    }
                } else {
                    this.saveChartInDatabaseWizard();
                    this.inWizard = false;
                }
            }
        }
        catch (SQLException sbe) {
            SbugsExceptionHandler.showStackError(sbe);
            this.inWizard = false;
        }
        this.refreshView();
    }

    private void saveChartInDatabaseWizard() {
        if (this.inWizard && this.wsCM != null && this.wsCM.hasDataLoaded()) {
            this.jComboBoxChartProject.setSelectedItem(this.jComboBoxProject.getSelectedItem());
            if (JOptionPane.showConfirmDialog(this, this.jPanelSaveChartsInDatabase, this.getTitle(), 0, 3) == 0) {
                this.jComboBoxProject.setSelectedItem(this.jComboBoxChartProject.getSelectedItem());
                this.saveChartsInDatabase();
            } else {
                this.inWizard = false;
            }
        }
        this.refreshView();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void autoMatch() {
        if (!this.jCheckBoxMenuItemAutoMatch.isSelected()) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        LOGGER.log(Level.FINE, "Auto-matching... Source: " + String.valueOf(this.autoMatchSource));
        try {
            for (Userdef userdef : this.ws.getUsers()) {
                Userdef dbUser;
                if (userdef.getLink() != null || (dbUser = this.db.getUser(userdef.getAbr())) == null) continue;
                if (userdef.getName() != null && !userdef.getName().isEmpty()) {
                    if (!userdef.getName().equalsIgnoreCase(dbUser.getName())) continue;
                    userdef.setLink(dbUser);
                    continue;
                }
                userdef.setLink(dbUser);
            }
            this.refreshView(Userdef.class);
            if (this.ws.hasTaxa()) {
                for (Taxon taxon : this.ws.getTaxa()) {
                    this.db.matchTaxon(taxon, false);
                }
                if (this.autoMatchSource != null) {
                    try (Iterator<TxGroup> stmt = this.db.getDatabase().createStatement();){
                        for (Taxon taxon : this.ws.getTaxa()) {
                            if (taxon.getLink() != null) continue;
                            this.autoMatchSource.getTaxon(this.db, (Statement)((Object)stmt), taxon);
                        }
                    }
                }
                this.refreshView(Taxon.class);
            }
            if (!this.ws.getIndependentGenera().isEmpty()) {
                this.ws.matchAllGeneraIndependent(this.db, false);
            }
            if (this.ws.hasEvents()) {
                for (SBEvent sBEvent : this.ws.getEvents()) {
                    if (sBEvent.getLink() != null) continue;
                    sBEvent.findLink(this.db);
                }
                if (this.autoMatchSource != null) {
                    this.autoMatchSource.matchEvents(this.db, this.ws.getEvents());
                }
                this.refreshView(SBEvent.class);
            }
            if (!this.ws.getTxGroups().isEmpty()) {
                block16: for (TxGroup txGroup : this.ws.getTxGroups()) {
                    TxGroup dbGroup;
                    if (txGroup.getLink() != null || (dbGroup = this.db.getTxGroup(txGroup.getName(), this.getProjID())) == null) continue;
                    Collection<Taxon> txGroupTaxa = this.ws.getTxGroupTaxa(txGroup, false);
                    HashSet<Taxon> linkedTaxa = new HashSet<Taxon>();
                    for (Taxon t : txGroupTaxa) {
                        if (t.getLink() == null) continue block16;
                        linkedTaxa.add(t.getLink());
                    }
                    Collection<Genus> txGroupGenera = this.ws.getTxGroupGenera(txGroup);
                    HashSet<Genus> linkedGenera = new HashSet<Genus>();
                    for (Genus g : txGroupGenera) {
                        if (g.getLink() == null) continue block16;
                        linkedGenera.add(g);
                    }
                    HashSet<Taxon> taxa = new HashSet<Taxon>(this.db.getTxGroupTaxa(dbGroup));
                    HashSet<Genus> genera = new HashSet<Genus>(this.db.getTxGroupGenera(dbGroup));
                    if (!taxa.equals(linkedTaxa) || !genera.equals(linkedGenera)) continue;
                    txGroup.setLink(dbGroup);
                }
                this.refreshView(TxGroup.class);
            }
        }
        catch (SQLException | SBException e) {
            FrameJsbugs.showStackError("Error", (Exception)e, this.db);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void refreshView() {
        this.doViewRefresh(null);
    }

    private void refreshView(final Class<?> dataType) {
        new SwingWorker(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            protected Object doInBackground() {
                this.this$0.doViewRefresh(dataType);
                return null;
            }
        }.execute();
    }

    private void doViewRefresh(Class<?> dataType) {
        Object compInError = "";
        try {
            for (Component comp : this.jTabbedPane1.getComponents()) {
                if (dataType == null && comp instanceof JPanelOrganiser) {
                    JPanelOrganiser panel = (JPanelOrganiser)comp;
                    compInError = "Organiser: " + panel.getName();
                    panel.refreshView(true);
                    panel.sort();
                    continue;
                }
                if (!(comp instanceof JPanelOrganiserDict)) continue;
                if (dataType == null) {
                    compInError = "Organiser Dict (no data type) ";
                    ((JPanelOrganiserDict)comp).initTreeData(this.wsCM, this.ws);
                } else {
                    compInError = "Organiser Dict, data type: " + String.valueOf(dataType);
                    ((JPanelOrganiserDict)comp).refresh(dataType, this.ws, this.wsCM);
                }
                comp.repaint();
            }
        }
        catch (RuntimeException | SQLException | SBException e) {
            FrameJsbugs.showStackError("Error refreshing view. Component: " + (String)compInError, (Exception)e, this.db);
        }
    }

    private void finishFileOpen() {
        ArrayList<Component> toRemove = new ArrayList<Component>();
        for (Component component : this.jTabbedPane1.getComponents()) {
            if (component instanceof JPanelOrganiser) {
                if (this.ws.getnLoadedWells() != 0) continue;
                toRemove.add(component);
                continue;
            }
            if (!(component instanceof JPanelOrganiserDict) || !((JPanelOrganiserDict)component).charts || this.wsCM != null && this.wsCM.hasDataLoaded()) continue;
            toRemove.add(component);
        }
        for (Component c : toRemove) {
            this.jTabbedPane1.remove(c);
        }
        if (this.ws.getnLoadedWells() > 0) {
            for (Component component : this.jTabbedPane1.getComponents()) {
                if (!(component instanceof JPanelOrganiser)) continue;
                this.jTabbedPane1.setSelectedComponent(component);
                break;
            }
        } else if (this.wsCM != null && this.wsCM.hasDataLoaded()) {
            for (Component component : this.jTabbedPane1.getComponents()) {
                if (!(component instanceof JPanelOrganiserDict) || !((JPanelOrganiserDict)component).charts) continue;
                this.jTabbedPane1.setSelectedComponent(component);
                break;
            }
        }
        this.autoMatch();
    }

    private void saveUserDefaults() {
        Object dTypes = "";
        for (Integer dataType : this.dataTypes) {
            dTypes = (String)dTypes + dataType.toString() + " ";
        }
        if (((String)dTypes).length() > 0) {
            try {
                Lastval.putString(this.db, "JSDT", (String)dTypes);
                this.db.commit();
            }
            catch (SQLException e) {
                this.db.doRollback();
                e.printStackTrace();
            }
        }
    }

    private void loadUserDefults() {
        try {
            String dTypes;
            char newUnits = Lastval.getChar(this.db, "INDXUNT");
            if (newUnits != '\u0000' && newUnits != this.units) {
                this.jRadioButtonMenuItemFeet.setSelected(this.units == 'F');
                this.jRadioButtonMenuItemMetres.setSelected(this.units == 'M');
                this.jRadioButtonMenuItemDrilled.setSelected(this.units == 'D');
            }
            if ((dTypes = Lastval.getString(this.db, "JSDT")).length() > 0) {
                StringTokenizer st = new StringTokenizer(dTypes);
                while (st.hasMoreTokens()) {
                    this.dataTypes.add(Integer.valueOf(st.nextToken()));
                }
                this.refreshView();
            }
        }
        catch (SQLException sql) {
            SbugsExceptionHandler.showStackError(sql, this);
        }
    }

    private void initComponents() {
        this.buttonGroupMenuUnits = new ButtonGroup();
        this.jPanelSaveChartsInDatabase = new JPanel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jComboBoxChartProject = new JComboBox();
        this.jMenuItem1 = new JMenuItem();
        this.jToolBar1 = new JToolBar();
        this.jButtonImport = new JButton();
        this.jButtonExport = new JButton();
        this.jSeparator3 = new JToolBar.Separator();
        this.jButtonOpenFile = new JButton();
        this.jButtonOpenWells = new JButton();
        this.jButtonOpenProject = new JButton();
        this.jSeparator4 = new JToolBar.Separator();
        this.jButtonSaveToDatabase = new JButton();
        this.jButtonSaveToFile = new JButton();
        this.jSeparator7 = new JToolBar.Separator();
        this.jButtonDataTypes = new JButton();
        this.jTabbedPane1 = new JTabbedPane();
        this.jLabel1 = new JLabel();
        this.jButtonProject = new JButton();
        this.jComboBoxProject = new JComboBox();
        this.jMenuBar1 = new JMenuBar();
        this.jMenuFile = new JMenu();
        this.jMenuItemGuidedImport = new JMenuItem();
        this.jMenuItemGuidedExport = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.jMenuOpenFile = new JMenu();
        this.jMenuItemOpenCommon = new JMenuItem();
        this.jSeparator10 = new JPopupMenu.Separator();
        this.jMenuItemOpenDEX = new JMenuItem();
        this.jMenuItemOpenXML = new JMenuItem();
        this.jMenuItemOpenCSV = new JMenuItem();
        this.jMenuItemOpenZip = new JMenuItem();
        this.jMenuItemOpenBugWare = new JMenuItem();
        this.jMenuItemOpenBugWareDictionary = new JMenuItem();
        this.jMenuItemOpenChecklist = new JMenuItem();
        this.jMenuItemOpenRG = new JMenuItem();
        this.jMenuItemOpenSbugs = new JMenuItem();
        this.jMenuItemOpenSISSbugs = new JMenuItem();
        this.jMenuItemOpenGeoSci = new JMenuItem();
        this.jMenuItemOpenIGDXLS = new JMenuItem();
        this.jMenuItemOpenOWXLS = new JMenuItem();
        this.jMenuItemOpenSampleXLS = new JMenuItem();
        this.jMenuItemOpenSampleOccXLS = new JMenuItem();
        this.jMenuItemOpenSampleOccXLS2 = new JMenuItem();
        this.jMenuItemOpenWellHeaderXLS = new JMenuItem();
        this.jMenuItemOpenEventsBSEE = new JMenuItem();
        this.jMenuItemOpenEventsGoM = new JMenuItem();
        this.jMenuItemOpenBuakLithostrat = new JMenuItem();
        this.jMenuItemOpenXLSOWPetrel = new JMenuItem();
        this.jMenuItemReadPaleoenvironmentIntervals = new JMenuItem();
        this.jMenuItemReadWellLithology = new JMenuItem();
        this.jMenuItemEPaleo = new JMenuItem();
        this.jMenuItemOpenAnnotationFiles = new JMenuItem();
        this.jSeparator12 = new JPopupMenu.Separator();
        this.jMenuItemOpenTSCreator = new JMenuItem();
        this.jMenuItemIC = new JMenuItem();
        this.jMenuItemPDI = new JMenuItem();
        this.jMenuItemOpenWells = new JMenuItem();
        this.jMenuItemOpenProject = new JMenuItem();
        this.jSeparator2 = new JPopupMenu.Separator();
        this.jMenuItemSaveInDatabase = new JMenuItem();
        this.jMenuItemSaveChartsInDatabase = new JMenuItem();
        this.jMenuSaveToFile = new JMenu();
        this.jMenuItemSaveZipFile = new JMenuItem();
        this.jMenuItemSaveDEX = new JMenuItem();
        this.jMenuItemSaveText = new JMenuItem();
        this.jMenu2 = new JMenu();
        this.jMenuItemSaveChronoBathy = new JMenuItem();
        this.jMenuItemSaveRanges = new JMenuItem();
        this.jMenuItemSampleSummaryExport = new JMenuItem();
        this.jMenu3 = new JMenu();
        this.jMenuItemGuidedExportBHP = new JMenuItem();
        this.jMenuItemGuidedExportSPDC = new JMenuItem();
        this.jMenuItemExportXLSInterpretedWorkbook = new JMenuItem();
        this.jMenuItemMultiWellFlatFile = new JMenuItem();
        this.jMenuItemExportProjectEvents = new JMenuItem();
        this.jMenuItemExportWordReport = new JMenuItem();
        this.jMenuItemExportJSON = new JMenuItem();
        this.jSeparator15 = new JPopupMenu.Separator();
        this.jMenuItemReplaceAll = new JMenuItem();
        this.jMenuItemReport = new JMenuItem();
        this.jSeparator6 = new JPopupMenu.Separator();
        this.jMenuItemExit = new JMenuItem();
        this.jMenuView = new JMenu();
        this.jMenuItemDataTypes = new JMenuItem();
        this.jMenuItemViewVersion = new JMenuItem();
        this.jMenuItemRemoveVersion = new JMenuItem();
        this.jMenuItemViewExclude = new JMenuItem();
        this.jSeparator11 = new JPopupMenu.Separator();
        this.jMenuItemLoadWorkspace = new JMenuItem();
        this.jSeparator5 = new JPopupMenu.Separator();
        this.jCheckBoxMenuItemAutoScroll = new JCheckBoxMenuItem();
        this.jMenu1 = new JMenu();
        this.jRadioButtonMenuItemMetres = new JRadioButtonMenuItem();
        this.jRadioButtonMenuItemFeet = new JRadioButtonMenuItem();
        this.jRadioButtonMenuItemDrilled = new JRadioButtonMenuItem();
        this.jMenuMatch = new JMenu();
        this.jMenuAutoMatch = new JMenu();
        this.jCheckBoxMenuItemAutoMatch = new JCheckBoxMenuItem();
        this.jMenuItemAutoMatchSource = new JMenuItem();
        this.jMenuSynonymy = new JMenu();
        this.jSeparator14 = new JPopupMenu.Separator();
        this.jMenuItemMatchInterp = new JMenuItem();
        this.jMenuItemMatchAbundance = new JMenuItem();
        this.jMenuItemMatchAnalysts = new JMenuItem();
        this.jMenuItemMatchTaxa = new JMenuItem();
        this.jMenuItemMatchEvents = new JMenuItem();
        this.jMenuItemMatchIGDIntervals = new JMenuItem();
        this.jMenuItemMatchEnvSchemes = new JMenuItem();
        this.jMenuItemMatchLogDef = new JMenuItem();
        this.jSeparator13 = new JPopupMenu.Separator();
        this.jMenuItemMatchWells = new JMenuItem();
        this.jSeparator9 = new JPopupMenu.Separator();
        this.jMenuItemMatchIGDSchemes = new JMenuItem();
        this.jMenuItemMatchCmpStds = new JMenuItem();
        this.jMenuItemMatchGenera = new JMenuItem();
        this.jMenuItemMatchTxGroups = new JMenuItem();
        this.jMenuItemMatchSets = new JMenuItem();
        this.jMenuItemMatchAgeCurves = new JMenuItem();
        this.jMenuHelp = new JMenu();
        this.jMenuItemOrganiserHelp = new JMenuItem();
        this.jSeparator8 = new JPopupMenu.Separator();
        this.jMenuItemHelpMenu = new JMenuItem();
        this.jMenuItemHelpMatch = new JMenuItem();
        this.jLabel2.setFont(this.jLabel2.getFont().deriveFont(this.jLabel2.getFont().getStyle() | 1));
        this.jLabel2.setText("Save all charts in database?");
        this.jLabel3.setText("All charts will be saved to project:");
        this.jComboBoxChartProject.setMaximumRowCount(50);
        this.jComboBoxChartProject.setModel(this.projectModel);
        GroupLayout jPanelSaveChartsInDatabaseLayout = new GroupLayout((Container)this.jPanelSaveChartsInDatabase);
        this.jPanelSaveChartsInDatabase.setLayout((LayoutManager)jPanelSaveChartsInDatabaseLayout);
        jPanelSaveChartsInDatabaseLayout.setHorizontalGroup((GroupLayout.Group)jPanelSaveChartsInDatabaseLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelSaveChartsInDatabaseLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelSaveChartsInDatabaseLayout.createParallelGroup(1, false).add((Component)this.jLabel2).add((Component)this.jLabel3, -1, -1, Short.MAX_VALUE).add((Component)this.jComboBoxChartProject, 0, -1, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanelSaveChartsInDatabaseLayout.setVerticalGroup((GroupLayout.Group)jPanelSaveChartsInDatabaseLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelSaveChartsInDatabaseLayout.createSequentialGroup().addContainerGap().add((Component)this.jLabel2).add(18, 18, 18).add((Component)this.jLabel3).addPreferredGap(0).add((Component)this.jComboBoxChartProject, -2, -1, -2).addContainerGap(17, Short.MAX_VALUE)));
        this.jMenuItem1.setText("jMenuItem1");
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void windowClosed(WindowEvent evt) {
                this.this$0.formWindowClosed(evt);
            }
        });
        this.jToolBar1.setRollover(true);
        this.jButtonImport.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/FrameOrganiser_GuidedImport.png")));
        this.jButtonImport.setToolTipText("Guided import");
        this.jButtonImport.setBorderPainted(false);
        this.jButtonImport.setFocusable(false);
        this.jButtonImport.setHorizontalTextPosition(0);
        this.jButtonImport.setVerticalTextPosition(3);
        this.jButtonImport.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonImportActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonImport);
        this.jButtonImport.getAccessibleContext().setAccessibleDescription("");
        this.jButtonExport.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/FrameOrganiser_GuidedExport.png")));
        this.jButtonExport.setToolTipText("Guided export");
        this.jButtonExport.setBorderPainted(false);
        this.jButtonExport.setFocusable(false);
        this.jButtonExport.setHorizontalTextPosition(0);
        this.jButtonExport.setVerticalTextPosition(3);
        this.jButtonExport.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonExportActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonExport);
        this.jButtonExport.getAccessibleContext().setAccessibleDescription("");
        this.jToolBar1.add(this.jSeparator3);
        this.jButtonOpenFile.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/openFile.png")));
        this.jButtonOpenFile.setToolTipText("Open common file type");
        this.jButtonOpenFile.setBorderPainted(false);
        this.jButtonOpenFile.setFocusable(false);
        this.jButtonOpenFile.setHorizontalTextPosition(0);
        this.jButtonOpenFile.setVerticalTextPosition(3);
        this.jButtonOpenFile.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOpenFileActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonOpenFile);
        this.jButtonOpenWells.setIcon(new ImageIcon(this.getClass().getResource("/resources/frameicon/24Wells.png")));
        this.jButtonOpenWells.setToolTipText("Open wells");
        this.jButtonOpenWells.setBorderPainted(false);
        this.jButtonOpenWells.setFocusable(false);
        this.jButtonOpenWells.setHorizontalTextPosition(0);
        this.jButtonOpenWells.setVerticalTextPosition(3);
        this.jButtonOpenWells.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOpenWellsActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonOpenWells);
        this.jButtonOpenProject.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/FrameOrganiser_OpenProject.png")));
        this.jButtonOpenProject.setToolTipText("Open project");
        this.jButtonOpenProject.setBorderPainted(false);
        this.jButtonOpenProject.setFocusable(false);
        this.jButtonOpenProject.setHorizontalTextPosition(0);
        this.jButtonOpenProject.setVerticalTextPosition(3);
        this.jButtonOpenProject.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOpenProjectActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonOpenProject);
        this.jToolBar1.add(this.jSeparator4);
        this.jButtonSaveToDatabase.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/FrameOrganiser_SaveToDB.png")));
        this.jButtonSaveToDatabase.setToolTipText("Save workspace to database");
        this.jButtonSaveToDatabase.setBorderPainted(false);
        this.jButtonSaveToDatabase.setFocusable(false);
        this.jButtonSaveToDatabase.setHorizontalTextPosition(0);
        this.jButtonSaveToDatabase.setVerticalTextPosition(3);
        this.jButtonSaveToDatabase.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSaveToDatabaseActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonSaveToDatabase);
        this.jButtonSaveToFile.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/FrameOrganiser_SaveToFile.png")));
        this.jButtonSaveToFile.setToolTipText("Save workspace to a file");
        this.jButtonSaveToFile.setBorderPainted(false);
        this.jButtonSaveToFile.setFocusable(false);
        this.jButtonSaveToFile.setHorizontalTextPosition(0);
        this.jButtonSaveToFile.setVerticalTextPosition(3);
        this.jButtonSaveToFile.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSaveToFileActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonSaveToFile);
        this.jToolBar1.add(this.jSeparator7);
        this.jButtonDataTypes.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/FrameOrganiser_ViewDataTypes.png")));
        this.jButtonDataTypes.setToolTipText("Data types");
        this.jButtonDataTypes.setBorderPainted(false);
        this.jButtonDataTypes.setFocusable(false);
        this.jButtonDataTypes.setHorizontalTextPosition(0);
        this.jButtonDataTypes.setVerticalTextPosition(3);
        this.jButtonDataTypes.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDataTypesActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonDataTypes);
        this.jTabbedPane1.setFocusable(false);
        this.jLabel1.setFont(this.jLabel1.getFont().deriveFont(this.jLabel1.getFont().getStyle() | 1));
        this.jLabel1.setText("Destination Project:");
        this.jButtonProject.setText("...");
        this.jButtonProject.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonProjectActionPerformed(evt);
            }
        });
        this.jComboBoxProject.setMaximumRowCount(30);
        this.jComboBoxProject.setModel(this.projectModel);
        this.jComboBoxProject.setFocusable(false);
        this.jMenuFile.setText("File");
        this.jMenuItemGuidedImport.setAccelerator(KeyStroke.getKeyStroke(73, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.jMenuItemGuidedImport.setText("Guided import...");
        this.jMenuItemGuidedImport.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemGuidedImportActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemGuidedImport);
        this.jMenuItemGuidedExport.setAccelerator(KeyStroke.getKeyStroke(69, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.jMenuItemGuidedExport.setText("Guided export...");
        this.jMenuItemGuidedExport.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemGuidedExportActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemGuidedExport);
        this.jMenuFile.add(this.jSeparator1);
        this.jMenuOpenFile.setText("Open file...");
        this.jMenuItemOpenCommon.setAccelerator(KeyStroke.getKeyStroke(79, 128));
        this.jMenuItemOpenCommon.setFont(new Font("Segoe UI", 1, 12));
        this.jMenuItemOpenCommon.setText("Common types...");
        this.jMenuItemOpenCommon.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemOpenCommonActionPerformed(evt);
            }
        });
        this.jMenuOpenFile.add(this.jMenuItemOpenCommon);
        this.jMenuOpenFile.add(this.jSeparator10);
        this.jMenuItemOpenDEX.setText("DEX...");
        this.jMenuItemOpenDEX.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemOpenDEXActionPerformed(evt);
            }
        });
        this.jMenuOpenFile.add(this.jMenuItemOpenDEX);
        this.jMenuItemOpenXML.setText("XML...");
        this.jMenuItemOpenXML.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemOpenXMLActionPerformed(evt);
            }
        });
        this.jMenuOpenFile.add(this.jMenuItemOpenXML);
        this.jMenuItemOpenCSV.setText("CSV...");
        this.jMenuItemOpenCSV.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemOpenCSVActionPerformed(evt);
            }
        });
        this.jMenuOpenFile.add(this.jMenuItemOpenCSV);
        this.jMenuItemOpenZip.setText("SBG, Zip...");
        this.jMenuItemOpenZip.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemOpenZipActionPerformed(evt);
            }
        });
        this.jMenuOpenFile.add(this.jMenuItemOpenZip);
        this.jMenuItemOpenBugWare.setText("BugWare...");
        this.jMenuItemOpenBugWare.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemOpenBugWareActionPerformed(evt);
            }
        });
        this.jMenuOpenFile.add(this.jMenuItemOpenBugWare);
        this.jMenuItemOpenBugWareDictionary.setText("BugWare dictionary...");
        this.jMenuItemOpenBugWareDictionary.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemOpenBugWareDictionaryActionPerformed(evt);
            }
        });
        this.jMenuOpenFile.add(this.jMenuItemOpenBugWareDictionary);
        this.jMenuItemOpenChecklist.setText("Checklist data set...");
        this.jMenuItemOpenChecklist.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemOpenChecklistActionPerformed(evt);
            }
        });
        this.jMenuOpenFile.add(this.jMenuItemOpenChecklist);
        this.jMenuItemOpenRG.setText("RG...");
        this.jMenuItemOpenRG.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemOpenRGActionPerformed(evt);
            }
        });
        this.jMenuOpenFile.add(this.jMenuItemOpenRG);
        this.jMenuItemOpenSbugs.setText("(old) StrataBugs...");
        this.jMenuItemOpenSbugs.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemOpenSbugsActionPerformed(evt);
            }
        });
        this.jMenuOpenFile.add(this.jMenuItemOpenSbugs);
        this.jMenuItemOpenSISSbugs.setText("SIS \"StrataBugs\" files ...");
        this.jMenuItemOpenSISSbugs.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemOpenSISSbugsActionPerformed(evt);
            }
        });
        this.jMenuOpenFile.add(this.jMenuItemOpenSISSbugs);
        this.jMenuItemOpenGeoSci.setText("GeoSci...");
        this.jMenuItemOpenGeoSci.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemOpenGeoSciActionPerformed(evt);
            }
        });
        this.jMenuOpenFile.add(this.jMenuItemOpenGeoSci);
        this.jMenuItemOpenIGDXLS.setText("XLS interpreted data workbook...");
        this.jMenuItemOpenIGDXLS.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemOpenIGDXLSActionPerformed(evt);
            }
        });
        this.jMenuOpenFile.add(this.jMenuItemOpenIGDXLS);
        this.jMenuItemOpenOWXLS.setText("OpenWorks XLS picks...");
        this.jMenuItemOpenOWXLS.setActionCommand("");
        this.jMenuItemOpenOWXLS.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemOpenOWXLSActionPerformed(evt);
            }
        });
        this.jMenuOpenFile.add(this.jMenuItemOpenOWXLS);
        this.jMenuItemOpenSampleXLS.setText("XLS Sample list...");
        this.jMenuItemOpenSampleXLS.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemOpenSampleXLSActionPerformed(evt);
            }
        });
        this.jMenuOpenFile.add(this.jMenuItemOpenSampleXLS);
        this.jMenuItemOpenSampleOccXLS.setText("XLS Analyses: depth, type, genus, species, counts...");
        this.jMenuItemOpenSampleOccXLS.setToolTipText("");
        this.jMenuItemOpenSampleOccXLS.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemOpenSampleOccXLSActionPerformed(evt);
            }
        });
        this.jMenuOpenFile.add(this.jMenuItemOpenSampleOccXLS);
        this.jMenuItemOpenSampleOccXLS2.setText("XLS Analyses: depth then taxon, count on next rows ...");
        this.jMenuItemOpenSampleOccXLS2.setToolTipText("Sample depth followed by one taxon/count on subsequent rows");
        this.jMenuItemOpenSampleOccXLS2.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemOpenSampleOccXLS2ActionPerformed(evt);
            }
        });
        this.jMenuOpenFile.add(this.jMenuItemOpenSampleOccXLS2);
        this.jMenuItemOpenWellHeaderXLS.setText("XLS Well headers ...");
        this.jMenuItemOpenWellHeaderXLS.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemOpenWellHeaderXLSActionPerformed(evt);
            }
        });
        this.jMenuOpenFile.add(this.jMenuItemOpenWellHeaderXLS);
        this.jMenuItemOpenEventsBSEE.setText("XLS Well events from BSEE (MMS) ...");
        this.jMenuItemOpenEventsBSEE.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemOpenEventsBSEEActionPerformed(evt);
            }
        });
        this.jMenuOpenFile.add(this.jMenuItemOpenEventsBSEE);
        this.jMenuItemOpenEventsGoM.setText("XLS Well events (GoM) ...");
        this.jMenuItemOpenEventsGoM.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemOpenEventsGoMActionPerformed(evt);
            }
        });
        this.jMenuOpenFile.add(this.jMenuItemOpenEventsGoM);
        this.jMenuItemOpenBuakLithostrat.setText("XLS Formations (in columns) ...");
        this.jMenuItemOpenBuakLithostrat.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemOpenBuakLithostratActionPerformed(evt);
            }
        });
        this.jMenuOpenFile.add(this.jMenuItemOpenBuakLithostrat);
        this.jMenuItemOpenXLSOWPetrel.setText("XLS Openworks/Petrel picks ...");
        this.jMenuItemOpenXLSOWPetrel.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemOpenXLSOWPetrelActionPerformed(evt);
            }
        });
        this.jMenuOpenFile.add(this.jMenuItemOpenXLSOWPetrel);
        this.jMenuItemReadPaleoenvironmentIntervals.setText("CSV/XLS Palaeoenvironment intervals...");
        this.jMenuItemReadPaleoenvironmentIntervals.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemReadPaleoenvironmentIntervalsActionPerformed(evt);
            }
        });
        this.jMenuOpenFile.add(this.jMenuItemReadPaleoenvironmentIntervals);
        this.jMenuItemReadWellLithology.setText("CSV/XLS well lithology intervals (ODM/IC)...");
        this.jMenuItemReadWellLithology.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemReadWellLithologyActionPerformed(evt);
            }
        });
        this.jMenuOpenFile.add(this.jMenuItemReadWellLithology);
        this.jMenuItemEPaleo.setText("ePaleo file...");
        this.jMenuItemEPaleo.setToolTipText("Open file which has been exported from ePaleo");
        this.jMenuItemEPaleo.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemEPaleoActionPerformed(evt);
            }
        });
        this.jMenuOpenFile.add(this.jMenuItemEPaleo);
        this.jMenuItemOpenAnnotationFiles.setText("Annotation files in StrataBugs well directory structure...");
        this.jMenuItemOpenAnnotationFiles.setToolTipText("CSV/XLS slide annotation files. Use analyses tab to export prepared analyses into this structure.");
        this.jMenuItemOpenAnnotationFiles.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemOpenAnnotationFilesActionPerformed(evt);
            }
        });
        this.jMenuOpenFile.add(this.jMenuItemOpenAnnotationFiles);
        this.jMenuOpenFile.add(this.jSeparator12);
        this.jMenuItemOpenTSCreator.setText("TSCreator file...");
        this.jMenuItemOpenTSCreator.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemOpenTSCreatorActionPerformed(evt);
            }
        });
        this.jMenuOpenFile.add(this.jMenuItemOpenTSCreator);
        this.jMenuItemIC.setText("IC Database ...");
        this.jMenuItemIC.setToolTipText("Open an IC database from a server for importing data");
        this.jMenuItemIC.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemICActionPerformed(evt);
            }
        });
        this.jMenuOpenFile.add(this.jMenuItemIC);
        this.jMenuItemPDI.setText("PDI Database ...");
        this.jMenuItemPDI.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemPDIActionPerformed(evt);
            }
        });
        this.jMenuOpenFile.add(this.jMenuItemPDI);
        this.jMenuFile.add(this.jMenuOpenFile);
        this.jMenuItemOpenWells.setAccelerator(KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.jMenuItemOpenWells.setText("Open wells...");
        this.jMenuItemOpenWells.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemOpenWellsActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemOpenWells);
        this.jMenuItemOpenProject.setAccelerator(KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 0x40));
        this.jMenuItemOpenProject.setText("Open project / well list...");
        this.jMenuItemOpenProject.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemOpenProjectActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemOpenProject);
        this.jMenuFile.add(this.jSeparator2);
        this.jMenuItemSaveInDatabase.setText("Save wells to database");
        this.jMenuItemSaveInDatabase.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemSaveInDatabaseActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemSaveInDatabase);
        this.jMenuItemSaveChartsInDatabase.setText("Save charts to database");
        this.jMenuItemSaveChartsInDatabase.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemSaveChartsInDatabaseActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemSaveChartsInDatabase);
        this.jMenuSaveToFile.setText("Save to file");
        this.jMenuItemSaveZipFile.setFont(new Font("Tahoma", 1, 11));
        this.jMenuItemSaveZipFile.setText("as StrataBugs SBG file...");
        this.jMenuItemSaveZipFile.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemSaveZipFileActionPerformed(evt);
            }
        });
        this.jMenuSaveToFile.add(this.jMenuItemSaveZipFile);
        this.jMenuItemSaveDEX.setText("as DEX...");
        this.jMenuItemSaveDEX.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemSaveDEXActionPerformed(evt);
            }
        });
        this.jMenuSaveToFile.add(this.jMenuItemSaveDEX);
        this.jMenuItemSaveText.setText("as text/CSV/XLS ...");
        this.jMenuItemSaveText.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemSaveTextActionPerformed(evt);
            }
        });
        this.jMenuSaveToFile.add(this.jMenuItemSaveText);
        this.jMenu2.setText("Other ...");
        this.jMenuItemSaveChronoBathy.setText("Bathymetry by chronostratigraphic interval");
        this.jMenuItemSaveChronoBathy.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemSaveChronoBathyActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItemSaveChronoBathy);
        this.jMenuItemSaveRanges.setText("as summary file of well data ranges for selected data types");
        this.jMenuItemSaveRanges.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemSaveRangesActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItemSaveRanges);
        this.jMenuItemSampleSummaryExport.setText("Sample summary");
        this.jMenuItemSampleSummaryExport.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemSampleSummaryExportActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItemSampleSummaryExport);
        this.jMenuSaveToFile.add(this.jMenu2);
        this.jMenuFile.add(this.jMenuSaveToFile);
        this.jMenu3.setText("Export other");
        this.jMenuItemGuidedExportBHP.setText("Events/Chrono/Biozones to XLS...");
        this.jMenuItemGuidedExportBHP.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemGuidedExportBHPActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.jMenuItemGuidedExportBHP);
        this.jMenuItemGuidedExportSPDC.setText("Chrono/Sequence/Biozones/Envs to XLS (one file per well)...");
        this.jMenuItemGuidedExportSPDC.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemGuidedExportSPDCActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.jMenuItemGuidedExportSPDC);
        this.jMenuItemExportXLSInterpretedWorkbook.setText("XLS interpreted data workbook...");
        this.jMenuItemExportXLSInterpretedWorkbook.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemExportXLSInterpretedWorkbookActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.jMenuItemExportXLSInterpretedWorkbook);
        this.jMenuItemMultiWellFlatFile.setText("Multi-well sample analyses...");
        this.jMenuItemMultiWellFlatFile.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemMultiWellFlatFileActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.jMenuItemMultiWellFlatFile);
        this.jMenuItemExportProjectEvents.setText("Export project events to CONOP/RASC ...");
        this.jMenuItemExportProjectEvents.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemExportProjectEventsActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.jMenuItemExportProjectEvents);
        this.jMenuItemExportWordReport.setText("Report in Word format ...");
        this.jMenuItemExportWordReport.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemExportWordReportActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.jMenuItemExportWordReport);
        this.jMenuItemExportJSON.setText("Chrono/Lithostrat/Palaeoenvs/Events in JSON format ...");
        this.jMenuItemExportJSON.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemExportJSONActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.jMenuItemExportJSON);
        this.jMenuFile.add(this.jMenu3);
        this.jMenuFile.add(this.jSeparator15);
        this.jMenuItemReplaceAll.setText("Replace all in database...");
        this.jMenuItemReplaceAll.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemReplaceAllActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemReplaceAll);
        this.jMenuItemReport.setText("Report...");
        this.jMenuItemReport.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemReportActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemReport);
        this.jMenuFile.add(this.jSeparator6);
        this.jMenuItemExit.setText("Exit");
        this.jMenuItemExit.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemExitActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemExit);
        this.jMenuBar1.add(this.jMenuFile);
        this.jMenuView.setText("View");
        this.jMenuItemDataTypes.setText("Data types...");
        this.jMenuItemDataTypes.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemDataTypesActionPerformed(evt);
            }
        });
        this.jMenuView.add(this.jMenuItemDataTypes);
        this.jMenuItemViewVersion.setText("Version....");
        this.jMenuItemViewVersion.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemViewVersionActionPerformed(evt);
            }
        });
        this.jMenuView.add(this.jMenuItemViewVersion);
        this.jMenuItemRemoveVersion.setText("Remove selected version tab");
        this.jMenuItemRemoveVersion.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemRemoveVersionActionPerformed(evt);
            }
        });
        this.jMenuView.add(this.jMenuItemRemoveVersion);
        this.jMenuItemViewExclude.setText("Exclude selected wells");
        this.jMenuItemViewExclude.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemViewExcludeActionPerformed(evt);
            }
        });
        this.jMenuView.add(this.jMenuItemViewExclude);
        this.jMenuView.add(this.jSeparator11);
        this.jMenuItemLoadWorkspace.setText("Load data from database into workspace");
        this.jMenuItemLoadWorkspace.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemLoadWorkspaceActionPerformed(evt);
            }
        });
        this.jMenuView.add(this.jMenuItemLoadWorkspace);
        this.jMenuView.add(this.jSeparator5);
        this.jCheckBoxMenuItemAutoScroll.setSelected(true);
        this.jCheckBoxMenuItemAutoScroll.setText("Fit main table within frame");
        this.jCheckBoxMenuItemAutoScroll.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jCheckBoxMenuItemAutoScrollActionPerformed(evt);
            }
        });
        this.jMenuView.add(this.jCheckBoxMenuItemAutoScroll);
        this.jMenu1.setText("Units");
        this.buttonGroupMenuUnits.add(this.jRadioButtonMenuItemMetres);
        this.jRadioButtonMenuItemMetres.setText("Metres");
        this.jRadioButtonMenuItemMetres.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonMenuItemMetresActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jRadioButtonMenuItemMetres);
        this.buttonGroupMenuUnits.add(this.jRadioButtonMenuItemFeet);
        this.jRadioButtonMenuItemFeet.setText("Feet");
        this.jRadioButtonMenuItemFeet.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonMenuItemFeetActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jRadioButtonMenuItemFeet);
        this.buttonGroupMenuUnits.add(this.jRadioButtonMenuItemDrilled);
        this.jRadioButtonMenuItemDrilled.setSelected(true);
        this.jRadioButtonMenuItemDrilled.setText("As drilled");
        this.jRadioButtonMenuItemDrilled.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonMenuItemDrilledActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jRadioButtonMenuItemDrilled);
        this.jMenuView.add(this.jMenu1);
        this.jMenuBar1.add(this.jMenuView);
        this.jMenuMatch.setText("Match");
        this.jMenuMatch.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuMatchActionPerformed(evt);
            }
        });
        this.jMenuAutoMatch.setText("Auto match [off]");
        this.jCheckBoxMenuItemAutoMatch.setText("Auto match");
        this.jCheckBoxMenuItemAutoMatch.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jCheckBoxMenuItemAutoMatchActionPerformed(evt);
            }
        });
        this.jMenuAutoMatch.add(this.jCheckBoxMenuItemAutoMatch);
        this.jMenuItemAutoMatchSource.setText("Select data source...");
        this.jMenuItemAutoMatchSource.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemAutoMatchSourceActionPerformed(evt);
            }
        });
        this.jMenuAutoMatch.add(this.jMenuItemAutoMatchSource);
        this.jMenuMatch.add(this.jMenuAutoMatch);
        this.jMenuSynonymy.setText("Synonymy");
        this.jMenuSynonymy.setToolTipText("Set synonym scheme for exporting and importing");
        this.jMenuMatch.add(this.jMenuSynonymy);
        this.jMenuMatch.add(this.jSeparator14);
        this.jMenuItemMatchInterp.setText("Versions...");
        this.jMenuItemMatchInterp.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemMatchInterpActionPerformed(evt);
            }
        });
        this.jMenuMatch.add(this.jMenuItemMatchInterp);
        this.jMenuItemMatchAbundance.setText("Abundance...");
        this.jMenuItemMatchAbundance.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemMatchAbundanceActionPerformed(evt);
            }
        });
        this.jMenuMatch.add(this.jMenuItemMatchAbundance);
        this.jMenuItemMatchAnalysts.setText("Analysts...");
        this.jMenuItemMatchAnalysts.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemMatchAnalystsActionPerformed(evt);
            }
        });
        this.jMenuMatch.add(this.jMenuItemMatchAnalysts);
        this.jMenuItemMatchTaxa.setText("Taxa...");
        this.jMenuItemMatchTaxa.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemMatchTaxaActionPerformed(evt);
            }
        });
        this.jMenuMatch.add(this.jMenuItemMatchTaxa);
        this.jMenuItemMatchEvents.setText("Events...");
        this.jMenuItemMatchEvents.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemMatchEventsActionPerformed(evt);
            }
        });
        this.jMenuMatch.add(this.jMenuItemMatchEvents);
        this.jMenuItemMatchIGDIntervals.setText("Stratigraphic interval units and picked surfaces...");
        this.jMenuItemMatchIGDIntervals.setToolTipText("Match occurring units and surfaces");
        this.jMenuItemMatchIGDIntervals.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemMatchIGDIntervalsActionPerformed(evt);
            }
        });
        this.jMenuMatch.add(this.jMenuItemMatchIGDIntervals);
        this.jMenuItemMatchEnvSchemes.setText("Palaeoenvironment schemes...");
        this.jMenuItemMatchEnvSchemes.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemMatchEnvSchemesActionPerformed(evt);
            }
        });
        this.jMenuMatch.add(this.jMenuItemMatchEnvSchemes);
        this.jMenuItemMatchLogDef.setText("Wireline log headers...");
        this.jMenuItemMatchLogDef.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemMatchLogDefActionPerformed(evt);
            }
        });
        this.jMenuMatch.add(this.jMenuItemMatchLogDef);
        this.jMenuMatch.add(this.jSeparator13);
        this.jMenuItemMatchWells.setText("Wells...");
        this.jMenuItemMatchWells.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemMatchWellsActionPerformed(evt);
            }
        });
        this.jMenuMatch.add(this.jMenuItemMatchWells);
        this.jMenuMatch.add(this.jSeparator9);
        this.jMenuItemMatchIGDSchemes.setText("Stratigraphic schemes...");
        this.jMenuItemMatchIGDSchemes.setToolTipText("Import or compare entire schemes (not necessary for well data import)");
        this.jMenuItemMatchIGDSchemes.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemMatchIGDSchemesActionPerformed(evt);
            }
        });
        this.jMenuMatch.add(this.jMenuItemMatchIGDSchemes);
        this.jMenuItemMatchCmpStds.setText("Composite standards...");
        this.jMenuItemMatchCmpStds.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemMatchCmpStdsActionPerformed(evt);
            }
        });
        this.jMenuMatch.add(this.jMenuItemMatchCmpStds);
        this.jMenuItemMatchGenera.setText("Genera...");
        this.jMenuItemMatchGenera.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemMatchGeneraActionPerformed(evt);
            }
        });
        this.jMenuMatch.add(this.jMenuItemMatchGenera);
        this.jMenuItemMatchTxGroups.setText("Taxon groups...");
        this.jMenuItemMatchTxGroups.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemMatchTxGroupsActionPerformed(evt);
            }
        });
        this.jMenuMatch.add(this.jMenuItemMatchTxGroups);
        this.jMenuItemMatchSets.setText("Group sets...");
        this.jMenuItemMatchSets.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemMatchSetsActionPerformed(evt);
            }
        });
        this.jMenuMatch.add(this.jMenuItemMatchSets);
        this.jMenuItemMatchAgeCurves.setText("Age curves...");
        this.jMenuItemMatchAgeCurves.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemMatchAgeCurvesActionPerformed(evt);
            }
        });
        this.jMenuMatch.add(this.jMenuItemMatchAgeCurves);
        this.jMenuBar1.add(this.jMenuMatch);
        this.jMenuHelp.setText("Help");
        this.jMenuItemOrganiserHelp.setText("Organiser help...");
        this.jMenuItemOrganiserHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemOrganiserHelpActionPerformed(evt);
            }
        });
        this.jMenuHelp.add(this.jMenuItemOrganiserHelp);
        this.jMenuHelp.add(this.jSeparator8);
        this.jMenuItemHelpMenu.setText("Menus...");
        this.jMenuItemHelpMenu.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemHelpMenuActionPerformed(evt);
            }
        });
        this.jMenuHelp.add(this.jMenuItemHelpMenu);
        this.jMenuItemHelpMatch.setText("Matching data...");
        this.jMenuItemHelpMatch.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameOrganiser this$0;
            {
                FrameOrganiser frameOrganiser = this$0;
                Objects.requireNonNull(frameOrganiser);
                this.this$0 = frameOrganiser;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemHelpMatchActionPerformed(evt);
            }
        });
        this.jMenuHelp.add(this.jMenuItemHelpMatch);
        this.jMenuBar1.add(this.jMenuHelp);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jTabbedPane1, -1, 841, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jToolBar1, -2, -1, -2).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.jComboBoxProject, -2, 131, -2).addPreferredGap(0).add((Component)this.jButtonProject, -2, 40, -2).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jToolBar1, -2, 33, -2).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jButtonProject).add((Component)this.jComboBoxProject, -2, -1, -2)))).addPreferredGap(0).add((Component)this.jTabbedPane1, -1, 461, Short.MAX_VALUE)));
        this.pack();
    }

    private void jMenuItemExitActionPerformed(ActionEvent evt) {
        this.parent.organiserFrames.remove(this);
        this.saveUserDefaults();
        this.dispose();
    }

    private void formWindowClosed(WindowEvent evt) {
        this.parent.organiserFrames.remove(this);
        this.saveUserDefaults();
    }

    private void jMenuItemOpenDEXActionPerformed(ActionEvent evt) {
        if (!this.checkClear(true)) {
            return;
        }
        this.setupDEXFileChooser();
        if (0 == this.jFileChooserDEX.showOpenDialog(this)) {
            this.openDEXfile(this.jFileChooserDEX.getSelectedFile());
        }
    }

    private void setupDEXFileChooser() {
        this.jFileChooserDEX = this.setupFileChooser(this.jFileChooserDEX, "WINDEXFILE", "UNXDEXFILE", "DEX files", "dex");
    }

    private void setupZIPFileChooser() {
        this.jFileChooserZIP = this.setupFileChooser(this.jFileChooserZIP, "WINZIPFILE", "UNXZIPFILE", "StrataBugs Biostratigraphy files", "sbg", "zip");
    }

    private void setupCSVFileChooser() {
        this.jFileChooserCSV = this.setupFileChooser(this.jFileChooserCSV, "WINCSVFILE", "UNXCSVFILE", "CSV/Excel taxa matrix", "csv", "xls", "xlsx");
    }

    private void setupXMLFileChooser() {
        this.jFileChooserXML = this.setupFileChooser(this.jFileChooserXML, "JXMLFILE", "UNXXMLFILE", "XML files", "xml");
    }

    private void setupXLSFileChooser() {
        this.jFileChooserXLS = this.setupFileChooser(this.jFileChooserXLS, "JXLSFILE", "UNXXLSFILE", "XLS files", "xls", "xlsx");
    }

    private JFileChooser setupFileChooser(JFileChooser jFileChooser, String winKey, String unxKey, String description, String ... extensions) {
        if (jFileChooser == null) {
            jFileChooser = new JFileChooser();
            File setDir = null;
            try {
                setDir = new File(Lastval.getString(this.db, winKey, unxKey));
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            if (setDir == null || setDir.getParent() == null || !setDir.getParentFile().exists()) {
                setDir = new File(".");
            }
            try {
                jFileChooser.setCurrentDirectory(setDir);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (description != null) {
                SbugsFileFilter filter = new SbugsFileFilter();
                for (String ext : extensions) {
                    filter.addExtension(ext);
                }
                filter.setDescription(description);
                jFileChooser.setFileFilter((FileFilter)filter);
            }
        }
        return jFileChooser;
    }

    private boolean openXMLfile(File xmlFile, ZipFile zipFile) {
        try {
            LinkedList<SBException> exceptions = new LinkedList<SBException>();
            Logger logger = Logger.getLogger(FrameOrganiser.class.getName() + " XML File Read");
            this.wsCM = SbugsIO.parseXMLFile(xmlFile, zipFile, this, this.ws, 0, this.dataTypes, exceptions);
            if (!exceptions.isEmpty()) {
                Object msg = "The following errors were found while reading the file ...";
                int exCount = 0;
                for (SBException sb : exceptions) {
                    if (++exCount < 20) {
                        msg = (String)msg + "\n" + sb.getMessage();
                    }
                    logger.log(Level.WARNING, sb.getMessage(), sb);
                }
                JOptionPane.showMessageDialog(this, msg, this.getTitle(), 2);
            }
            if (!this.wsCM.hasDataLoaded()) {
                this.wsCM = null;
            }
            this.checkVersionPanels();
            this.refreshView();
            this.finishFileOpen();
            return true;
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (ParseException | SBException pe) {
            StackError.showStackError((String)"Error", (Throwable)pe);
        }
        return false;
    }

    private void checkVersionPanels() throws SQLException {
        if (!this.ws.hasInterpsLoaded()) {
            return;
        }
        for (InterpHdr interpHdr : this.ws.getInterps()) {
            boolean found = false;
            for (Component comp : this.jTabbedPane1.getComponents()) {
                if (!(comp instanceof JPanelOrganiser)) continue;
                JPanelOrganiser panel = (JPanelOrganiser)comp;
                if (panel.hdr == null || panel.hdr.getInterpID() != interpHdr.getInterpID()) continue;
                found = true;
                break;
            }
            if (found) continue;
            boolean hasData = false;
            Iterator<Well> wellIterator = this.ws.getWellIterator();
            while (wellIterator.hasNext()) {
                Well well = wellIterator.next();
                try {
                    WellInterp interp = well.getInterp(interpHdr.getInterpID());
                    if (!interp.hasData()) continue;
                    hasData = true;
                    break;
                }
                catch (SBException sBException) {
                }
            }
            if (!hasData) continue;
            JPanelOrganiser panel = new JPanelOrganiser(this, this.ws, this.db, interpHdr);
            this.jTabbedPane1.add(panel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean openDEXfile(File dexFile) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            int interpID = 0;
            if (this.jTabbedPane1.getSelectedComponent() instanceof JPanelOrganiser && ((JPanelOrganiser)this.jTabbedPane1.getSelectedComponent()).hdr != null) {
                interpID = ((JPanelOrganiser)this.jTabbedPane1.getSelectedComponent()).hdr.getInterpID();
            }
            DEXFile dexFile1 = new DEXFile(this.ws, this.db.getUser(), dexFile.getPath(), this.dataTypes, this.db.getLithdesc(), interpID);
            this.checkVersionPanels();
            this.refreshView();
            Lastval.putString(this.db, "WINDEXFILE", "UNXDEXFILE", dexFile.getPath());
            this.db.commit();
            boolean bl = true;
            return bl;
        }
        catch (OutOfMemoryError bounded) {
            Runtime.getRuntime().gc();
            JOptionPane.showMessageDialog(this, "Cannot read file: Memory limit for application exceeded. Total available: " + Runtime.getRuntime().maxMemory() / 1024000L + "MB\nContact StrataData for workaround or reduce size of import file");
        }
        catch (FileNotFoundException ex) {
            JOptionPane.showMessageDialog(this, "Can't find file: " + dexFile.getPath(), "DEX Reader", 2);
            ex.printStackTrace();
        }
        catch (Exception ex) {
            StackError.showStackError((String)"Error during file read.", (Throwable)ex);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openBugWarefile() {
        File bugFile = SbugsIO.chooseFileToOpen(this.db, this, "WINBUGWFIL", "BugWare files", "def", "den", "bwd");
        if (bugFile == null) {
            return;
        }
        this.dataTypes.clear();
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            DialogBugWareReader dialogParam = new DialogBugWareReader((Frame)this, true, this.db, bugFile.getPath());
            dialogParam.setLocationRelativeTo(this);
            dialogParam.setVisible(true);
            if (!dialogParam.isOK) {
                this.inWizard = false;
                return;
            }
            BugWareReader reader = new BugWareReader(this.ws, bugFile.getPath(), this.dataTypes, dialogParam.discID, dialogParam.units, dialogParam.analyst, dialogParam.useBioStratComments, dialogParam.usePrimaryEvents, dialogParam.eventType, dialogParam.useSampleLithology, dialogParam.ignoreSemiQuant, dialogParam.useSampleTops);
            this.viewVersion(this.ws.getInterp(0));
            this.refreshView();
        }
        catch (SQLException | SBException sql) {
            FrameJsbugs.showStackError("SQL Error", (Exception)sql, this.db);
        }
        catch (InvalidFieldException ex) {
            Logger.getLogger(FrameOrganiser.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openGeoSciFile() {
        File geoSciFile = SbugsIO.chooseFileToOpen(this.db, this, "GEOSCIFIL", "GeoSci files", "dat");
        this.dataTypes.clear();
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            DialogImportAnalyses dialogImport = new DialogImportAnalyses((Frame)this, true, this.db, this.ws);
            dialogImport.setLocationRelativeTo(this);
            dialogImport.setVisible(true);
            if (!dialogImport.isOK) {
                return;
            }
            GeoSciReader reader = new GeoSciReader(this.ws, geoSciFile.getPath(), this.dataTypes, dialogImport.discID, dialogImport.units, dialogImport.analyst, this.db.useSampleTops());
            this.refreshView();
        }
        catch (SQLException | SBException sql) {
            FrameJsbugs.showStackError("SQL Error", (Exception)sql, this.db);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void openRGFile() {
        File file = SbugsIO.chooseFileToOpen(this.db, this, "WINRGFILE", "RG files", "rg", "dat");
        if (file == null) {
            return;
        }
        this.dataTypes.clear();
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            RGReader reader = new RGReader(file.getPath(), this.dataTypes, this.ws);
            this.refreshView();
        }
        catch (RuntimeException e) {
            StackError.showStackError((String)"", (Throwable)e);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openXLSFile(File xlsFile, int type) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.dataTypes.clear();
        try {
            Lastval.putString(this.db, "JXLSFILE", "UNXSLXFILE", xlsFile.getPath());
            this.db.commit();
            if (type == 1) {
                dialog = new DialogDepthUnits(this, true, Lastval.getChar(this.db, "XLSUNITS"));
                dialog.setLocationRelativeTo((Component)this);
                dialog.setVisible(true);
                if (!dialog.isOK()) {
                    return;
                }
                Lastval.putChar(this.db, "XLSUNITS", ((DialogDepthUnits)((Object)dialog)).getUnits());
                this.db.commit();
                IGDXLSReader reader = new IGDXLSReader(this.ws, xlsFile, this.dataTypes, ((DialogDepthUnits)((Object)dialog)).getUnits());
                this.checkVersionPanels();
            } else if (type == 2) {
                dialog = new DialogOWXLSReader(this, true, this.db, this.ws, xlsFile, this.dataTypes);
                ((Window)dialog).setLocationRelativeTo(this);
                ((Dialog)dialog).setVisible(true);
                this.checkVersionPanels();
            } else if (type == 3) {
                dialog = new SampleReaderXLS(this.ws, xlsFile, this.dataTypes);
            } else if (type == 4 || type == 5) {
                DialogImportAnalyses dialogImport = new DialogImportAnalyses((Frame)this, true, this.db, this.ws);
                dialogImport.setLocationRelativeTo(this);
                dialogImport.setVisible(true);
                if (!dialogImport.isOK) {
                    this.inWizard = false;
                    return;
                }
                SampleOccReaderXLS e = new SampleOccReaderXLS(type - 3, this.ws, xlsFile, this.dataTypes, dialogImport.analyst, dialogImport.discID, dialogImport.units, dialogImport.sampleType);
            } else if (type == 6) {
                dialog = new DialogDepthUnits(this, true, Lastval.getChar(this.db, "XLSUNITS"));
                dialog.setLocationRelativeTo((Component)this);
                dialog.setVisible(true);
                if (!dialog.isOK()) {
                    return;
                }
                Lastval.putChar(this.db, "XLSUNITS", ((DialogDepthUnits)((Object)dialog)).getUnits());
                this.db.commit();
                this.dataTypes.clear();
                GridReader gridReader = GridReader.getGridReader((String)xlsFile.getPath(), null);
                if (!(gridReader instanceof XLSGridReader)) {
                    JOptionPane.showMessageDialog(this, "Incorrect Excel file: " + xlsFile.getPath());
                    return;
                }
                List sheets = ((XLSGridReader)gridReader).getSheets();
                if (sheets == null || sheets.isEmpty()) {
                    JOptionPane.showMessageDialog(this, "No worksheets in file: " + xlsFile.getPath());
                    return;
                }
                if (sheets.size() > 1) {
                    DialogList dialogList = new DialogList(this, true, "Select Worksheet", null, sheets, true, false);
                    dialogList.setLocationRelativeTo(this);
                    dialogList.setVisible(true);
                    if (dialogList.getSelection() == null) {
                        return;
                    }
                    String sheet = (String)dialogList.getSelection();
                    if (!sheet.equalsIgnoreCase((String)sheets.get(0))) {
                        gridReader = GridReader.getGridReader((String)xlsFile.getPath(), (String)sheet);
                    }
                }
                WellHeaderXLS reader = new WellHeaderXLS(this.ws, gridReader, ((DialogDepthUnits)((Object)dialog)).getUnits());
                gridReader.close();
            } else if (type == 7) {
                dialog = new DialogDepthUnits(this, true, Lastval.getChar(this.db, "XLSUNITS"));
                dialog.setLocationRelativeTo((Component)this);
                dialog.setVisible(true);
                if (!dialog.isOK()) {
                    return;
                }
                Lastval.putChar(this.db, "XLSUNITS", ((DialogDepthUnits)((Object)dialog)).getUnits());
                this.db.commit();
                this.dataTypes.clear();
                WellEventBSEEXLS reader = new WellEventBSEEXLS(this.ws, xlsFile, ((DialogDepthUnits)((Object)dialog)).getUnits(), this.dataTypes);
                this.viewVersion(this.ws.getInterp(0));
            } else if (type == 8) {
                this.dataTypes.clear();
                reader = new WellEventEquinorXLS(this.ws, xlsFile, 'F', this.dataTypes);
                this.viewVersion(this.ws.getInterp(0));
            } else if (type == 9) {
                this.dataTypes.clear();
                reader = new WellLstratBujakXLS(this.ws, xlsFile, 'F', this.dataTypes);
                this.viewVersion(this.ws.getInterp(0));
            } else if (type == 10) {
                IGDScheme scheme = null;
                char units = 'M';
                DialogImportFile dialogType = new DialogImportFile(this, this.db, xlsFile);
                dialogType.setLocationRelativeTo(this);
                dialogType.setVisible(true);
                if (!dialogType.isOK()) {
                    return;
                }
                if (dialogType.getSelected().isNeedsScheme()) {
                    int schemeDataType = switch (dialogType.getSelected()) {
                        case ImportFileReaderType.PETREL_CHRONO -> 3;
                        case ImportFileReaderType.PETREL_SEQUENCE -> 10;
                        default -> 2;
                    };
                    DialogSelectScheme dialogScheme = new DialogSelectScheme(this, true, this.db, schemeDataType);
                    dialogScheme.setLocationRelativeTo(this);
                    dialogScheme.setVisible(true);
                    scheme = dialogScheme.selection;
                    if (scheme == null) {
                        return;
                    }
                }
                if (dialogType.getSelected().isNeedsUnits()) {
                    Lastval.putChar(this.db, "XLSUNITS", dialogType.getDepthUnits());
                    this.db.commit();
                }
                this.dataTypes.clear();
                switch (dialogType.getSelected()) {
                    case PETREL_LSTRAT: {
                        new WellLstratPickXLS(this.ws, xlsFile, dialogType.getDepthUnits(), this.dataTypes, dialogType.getCountry(), scheme);
                        break;
                    }
                    case PETREL_CHRONO: {
                        new WellChronoPickXLS(this.ws, xlsFile, this.dataTypes, scheme);
                        break;
                    }
                    case AKERBP_PETREL_LSTRAT: {
                        new WellLstratPetrelXLS(this.ws, xlsFile, units, this.dataTypes, dialogType.getCountry(), scheme);
                        break;
                    }
                    case PETREL_SEQUENCE: {
                        new WellSQPickPetrelXLS(this.ws, xlsFile, this.dataTypes, dialogType.getCountry(), scheme);
                    }
                }
                this.viewVersion(this.ws.getInterp(0));
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (InvalidFormatException iof) {
            JOptionPane.showMessageDialog(this, "invalid format Exception reading file: " + iof.getMessage(), this.getTitle(), 2);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "Error reading file: " + e.getMessage(), this.getTitle(), 2);
        }
        catch (Exception ex) {
            StackError.showStackError((String)"Error during file read", (Throwable)ex);
            ex.printStackTrace();
        }
        finally {
            try {
                this.refreshView();
            }
            catch (Exception e) {
                StackError.showStackError((String)"Error", (Throwable)e);
            }
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean openSbugsFile(File file) {
        if (file == null) {
            file = SbugsIO.chooseFileToOpen(this.db, this, "WINSBUGFIL", "Old StrataBugs files", "txt", "dat");
        }
        if (file == null) {
            return false;
        }
        this.dataTypes.clear();
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            SbugsReader reader = new SbugsReader(file.getPath(), this.ws, this.dataTypes, "SBUGSANALYST");
            this.refreshView();
            boolean bl = true;
            return bl;
        }
        catch (SBException e) {
            StackError.showStackError((String)"Error parsing workspace", (Throwable)e);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
        return false;
    }

    private void openSISSbugsFile() {
        File file = SbugsIO.chooseFileToOpen(this.db, this, "WINSISSB", null, new String[0]);
        if (file == null) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.dataTypes.clear();
        try {
            SISSbugsReader sISSbugsReader = new SISSbugsReader(file.getPath(), this.ws, this.dataTypes, "SIS");
        }
        catch (SBException e) {
            StackError.showStackError((String)"Error parsing workspace", (Throwable)e);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
        this.refreshView();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openChecklistfile() {
        File file = SbugsIO.chooseFileToOpen(this.db, this, "WINCHECFIL", "Checklist files", "chk");
        if (file == null) {
            return;
        }
        this.dataTypes.clear();
        DialogChecklistReader dialogParam = new DialogChecklistReader((Frame)this, true, this.db, file.getPath());
        dialogParam.setLocationRelativeTo(this);
        dialogParam.setVisible(true);
        if (!dialogParam.isOK) {
            this.inWizard = false;
            return;
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            ChecklistReader reader = new ChecklistReader(this.ws, file.getPath(), this.dataTypes, dialogParam.discID, dialogParam.units, dialogParam.analyst, dialogParam.sampleType, dialogParam.useSampleTops);
            this.showReaderRejectsMessage(reader.rejects);
            this.refreshView();
        }
        catch (IOException ioe) {
            StackError.showStackError((String)"Error reading file", (Throwable)ioe);
        }
        catch (SQLException | SBException ex) {
            FrameJsbugs.showStackError("SQL Error", (Exception)ex, this.db);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean openCSVfile(File csvFile) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            HashSet<String> donorSampleTypes;
            DialogCSVImport dialogParam = new DialogCSVImport(this, true, this.db, csvFile.getPath(), false);
            if (dialogParam.isCancelled) {
                boolean bl = false;
                return bl;
            }
            dialogParam.setLocationRelativeTo(this);
            dialogParam.setVisible(true);
            if (!dialogParam.isOK()) {
                boolean bl = false;
                return bl;
            }
            DialogImportAnalyses dialogImport = new DialogImportAnalyses((Frame)this, true, this.db, this.ws);
            dialogImport.setLocationRelativeTo(this);
            dialogImport.setVisible(true);
            if (!dialogImport.isOK) {
                boolean bl = false;
                return bl;
            }
            CSVReader reader = new CSVReader(this.ws, GridReader.getGridReader((String)csvFile.getPath(), (String)dialogParam.workSheetName), this.dataTypes, dialogImport.discID, dialogImport.units, dialogImport.analyst.getAbr(), dialogParam.titleRow - 1, dialogParam.catRow - 1, dialogParam.startRow - 1, dialogParam.colStart[0], dialogParam.colStart[1], dialogParam.colStart[2], dialogParam.colStart[3], dialogParam.colStart[5], dialogParam.colStart[6], dialogParam.colStart[4], dialogParam.colStart[7], dialogParam.colTaxaEnd, dialogParam.isBiocom, dialogImport.isWell, dialogImport.setEmptyAsBarren, dialogImport.createEmptySmpdtl, SampleType.parseType((String)dialogImport.sampleType));
            this.showReaderRejectsMessage(reader.rejects);
            if (this.hasFssDataTypes()) {
                try {
                    this.ws.checkDefaultAbnScheme();
                }
                catch (SBException sbe) {
                    StackError.showStackError((String)"Error during file read", (Throwable)sbe);
                }
            }
            if ((donorSampleTypes = this.ws.getDonorSampleTypes()) != null) {
                DialogMatchSampleTypes dialogTypes = new DialogMatchSampleTypes(this, true, this.ws, this.db, donorSampleTypes);
                dialogTypes.setLocationRelativeTo(this);
                dialogTypes.setVisible(true);
                if (!dialogTypes.isOK()) {
                    boolean bl = false;
                    return bl;
                }
            }
            Lastval.putString(this.db, "WINCSVFILE", "UNXCSVFILE", csvFile.getPath());
            this.db.commit();
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            StackError.showStackError((String)"Error during file read", (Throwable)ex);
        }
        finally {
            this.refreshView();
            this.finishFileOpen();
            this.setCursor(Cursor.getDefaultCursor());
        }
        return false;
    }

    private void showReaderRejectsMessage(HashSet readerRejects) {
        if (!readerRejects.isEmpty()) {
            Object rejects = "";
            Iterator it = readerRejects.iterator();
            while (it.hasNext()) {
                if (!((String)rejects).isEmpty()) {
                    rejects = (String)rejects + ", ";
                }
                rejects = (String)rejects + String.valueOf(it.next());
            }
            String message = "Warning:\nSome possible semi-quantitative or qualifier tags have been\nignored in favour of numerical data:\n\n" + (String)rejects;
            JOptionPane.showMessageDialog(this, message, this.getTitle(), 2);
        }
    }

    private void openTSCCreatorFile() {
        File file = SbugsIO.chooseFileToOpen(this.db, this, "WINTSCFIL", "TSCreator data files", "jar", "txt");
        if (file == null) {
            return;
        }
        try {
            TSCreatorReader reader = new TSCreatorReader(this.ws, file.getPath());
            if (reader.getLists().isEmpty()) {
                JOptionPane.showMessageDialog(this, "Unable to read any schemes from file", this.getTitle(), 1);
                return;
            }
            DialogTSCreator dialog = new DialogTSCreator(this, true, this.db, this.ws, reader);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (!dialog.isOK) {
                return;
            }
            TSCreatorReader.TSCScheme scheme = dialog.getScheme();
            if (dialog.getEventList() != null) {
                int opt;
                TSCreatorReader.TSCEventList events = dialog.getEventList();
                if (events.needsFilter() && (opt = JOptionPane.showConfirmDialog(this, "Do you want to filter the * * and [ ] contents from the TSC events?", this.getTitle(), 0, 3)) == 0) {
                    events.filterNames();
                }
                events.removeBlankEvents();
                events.getEvents(this.ws);
                DialogMatchEvents dialogMatchEvents = new DialogMatchEvents(this, true, this.ws, this.db, true);
                dialogMatchEvents.setLocationRelativeTo(this);
                dialogMatchEvents.setVisible(true);
                if (dialogMatchEvents.isOK()) {
                    LinkedList<SBException> exceptions = new LinkedList<SBException>();
                    CompositeStandard std = events.getCompositeStandard(exceptions);
                    if (!exceptions.isEmpty()) {
                        DialogList<SBException> dialogl = new DialogList<SBException>(this, true, "Events not added to composite", new UserPrefsHelper(this.db), exceptions, false, false);
                        dialogl.setLocationRelativeTo(this);
                        dialogl.setVisible(true);
                    }
                    DialogMatchCmpStd matchdialog = new DialogMatchCmpStd(this, true, std, this.db, this.inWizard);
                    matchdialog.setLocationRelativeTo(this);
                    matchdialog.setVisible(true);
                }
            }
            if (dialog.useScheme()) {
                IGDScheme igdScheme = scheme.getScheme(this.ws);
                if (igdScheme.getIGDType() > 0) {
                    this.ws.addIGDScheme(igdScheme);
                    DialogMatchIGDScheme dialogMatchScheme = new DialogMatchIGDScheme(this, true, igdScheme, this.db, false);
                    dialogMatchScheme.setLocationRelativeTo(this);
                    dialogMatchScheme.setVisible(true);
                } else {
                    JOptionPane.showMessageDialog(this, "Cannot determine scheme type - scheme not stored.", this.getTitle(), 1);
                }
            }
        }
        catch (IOException ioe) {
            StackError.showStackError((String)"Error reading file", (Throwable)ioe);
        }
        catch (SQLException | InvalidFieldException | SBException e) {
            StackError.showStackError((String)"Error", (Throwable)e);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void jMenuItemMatchWellsActionPerformed(ActionEvent evt) {
        try {
            DialogMatchWells dialog = new DialogMatchWells(this, true, this.ws, this.db);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (!dialog.isOK()) {
                this.inWizard = false;
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.refreshView();
        }
        catch (Exception e) {
            StackError.showStackError((String)"Error matching wells", (Throwable)e);
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private void jCheckBoxMenuItemAutoScrollActionPerformed(ActionEvent evt) {
        for (Component comp : this.jTabbedPane1.getComponents()) {
            if (!(comp instanceof JPanelOrganiser)) continue;
            JPanelOrganiser panel = (JPanelOrganiser)comp;
            if (this.autoResize) {
                panel.getJtableOrg().setAutoResizeMode(0);
                this.autoResize = false;
                continue;
            }
            panel.getJtableOrg().setAutoResizeMode(2);
            this.autoResize = true;
        }
    }

    private void jMenuItemMatchAnalystsActionPerformed(ActionEvent evt) {
        this.matchAnalysts();
    }

    void matchAnalysts() {
        try {
            if (!this.inWizard && (this.ws.getUsers() == null || this.ws.getUsers().isEmpty())) {
                JOptionPane.showMessageDialog(this, "There are no analysts in the workspace", "Match Analysts", 1);
                return;
            }
            DialogMatchAnalysts dialog = new DialogMatchAnalysts(this, true, this.ws, this.db, this.inWizard);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (!dialog.isOK()) {
                this.inWizard = false;
            }
        }
        catch (SQLException e) {
            FrameJsbugs.showStackError("Error opening Match Personnel dialog", e, this.db);
        }
        if (!this.inWizard) {
            this.refreshView(Userdef.class);
        }
    }

    void matchLogDefs() {
        try {
            DialogMatchLogdef dialog = new DialogMatchLogdef(this, true, this.ws, this.db, this.inWizard);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (!dialog.isOK()) {
                this.inWizard = false;
            }
        }
        catch (SQLException e) {
            FrameJsbugs.showStackError("Error opening Dialog", e, this.db);
        }
        if (!this.inWizard) {
            this.refreshView(LogDef.class);
        }
    }

    void matchAgeCurves() {
        try {
            DialogMatchAgeCurves dialog = new DialogMatchAgeCurves(this.parent, true, this.ws, this.db, this.inWizard);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (!dialog.isOK()) {
                this.inWizard = false;
            }
        }
        catch (SQLException e) {
            FrameJsbugs.showStackError("Error opening Dialog", e, this.db);
        }
        if (!this.inWizard) {
            this.refreshView(AgeCurve.class);
        }
    }

    private void jMenuItemMatchTaxaActionPerformed(ActionEvent evt) {
        this.matchTaxa(evt);
    }

    void matchTaxa(ActionEvent evt) {
        if (!this.inWizard && !this.ws.hasTaxa()) {
            JOptionPane.showMessageDialog(this, "There are no taxa in the workspace", "Match Taxa", 1);
            return;
        }
        try {
            DialogMatchTaxa dialog = new DialogMatchTaxa(this, true, this.ws, this.wsCM, this.db, this.inWizard);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (!dialog.isOK()) {
                this.inWizard = false;
            }
            if (evt != null) {
                Iterator<Well> it = this.ws.getWellIterator();
                while (it.hasNext()) {
                    WsWell w = (WsWell)it.next();
                    w.updateSampleStatus(true);
                }
            }
        }
        catch (SQLException | SBException e) {
            StackError.showStackError((String)"Error opening Match Taxa dialog", (Throwable)e);
        }
        if (!this.inWizard) {
            this.refreshView(Taxon.class);
        }
    }

    private void jMenuItemMatchAbundanceActionPerformed(ActionEvent evt) {
        try {
            AbundanceScheme scheme;
            List allAbundanceSchemes = this.ws.getAbundanceSchemeService().getAllAbundanceSchemes();
            if (allAbundanceSchemes.isEmpty()) {
                JOptionPane.showMessageDialog(this, "There are no abundance schemes in the workspace", "Match Abundance", 2);
                return;
            }
            if (allAbundanceSchemes.size() > 1) {
                DialogList dialogSel = new DialogList(this, true, "Abundance Scheme : Select", null, allAbundanceSchemes, true, false);
                dialogSel.setLocationRelativeTo(this);
                dialogSel.setVisible(true);
                AbundanceScheme selection = (AbundanceScheme)dialogSel.getSelection();
                if (selection == null) {
                    return;
                }
                scheme = selection;
            } else {
                scheme = (AbundanceScheme)this.ws.getAbundanceSchemeService().getAllAbundanceSchemes().get(0);
            }
            this.matchAbnScheme(scheme);
        }
        catch (Exception e) {
            StackError.showStackError((String)"Error opening Match abundance dialog.", (Throwable)e);
        }
        if (!this.inWizard) {
            try {
                this.refreshView();
            }
            catch (Exception e) {
                StackError.showStackError((String)"Error matching abundance", (Throwable)e);
            }
        }
    }

    private boolean checkAnalystsMatched() throws SQLException {
        for (Userdef user : this.ws.getUsers()) {
            if (user.getLink() != null) continue;
            JOptionPane.showMessageDialog(this, "Analysts not matched. Use Match | Analysts", this.getTitle(), 2);
            return false;
        }
        return true;
    }

    private void saveAllInDatabase() {
        if (this.ws.getnLoadedWells() > 0) {
            this.saveInDatabase(false);
        }
        if (this.wsCM != null && this.wsCM.hasDataLoaded()) {
            this.saveChartsInDatabase();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveInDatabase(final boolean replace) {
        try {
            this.isSavingData = false;
            boolean conflictCheckingStopped = false;
            if (!this.checkAnalystsMatched()) {
                return;
            }
            boolean isConflict = false;
            boolean resetAllwellheaderfields = false;
            boolean setWellDepthUnitsForAll = false;
            Iterator<Well> it = this.ws.getWellIterator();
            if (!it.hasNext()) {
                JOptionPane.showMessageDialog(this, "No data to save! Open a file.", this.getTitle(), 1);
                return;
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            LinkedList<Well> wells = new LinkedList<Well>();
            while (it.hasNext()) {
                wells.add(it.next());
            }
            Collections.sort(wells);
            block5: for (Well w : wells) {
                Iterator<WellInterp> wit;
                WsWell well = (WsWell)w;
                if (well.getLink() != null) {
                    LOGGER.log(Level.CONFIG, "Checking conflicts for well: " + well.getWellName());
                    if (well.getStatus() == WsWell.CONFLICT && well.getWellUnits() != well.getLink().getWellUnits()) {
                        if (!setWellDepthUnitsForAll) {
                            Object[] buttons = new String[]{"Yes", "Yes to all", "No"};
                            int opt = JOptionPane.showOptionDialog(this, "WARNING: Conflicting well header depth units in workspace for '" + well.getWellName() + "'\nDo you want to continue saving?\n(Resetting to database units might result in sample mis-matches)", this.getTitle(), 0, 3, null, buttons, buttons[1]);
                            if (opt == 2) {
                                isConflict = true;
                                this.setCursor(Cursor.getDefaultCursor());
                                break;
                            }
                            if (opt == 1) {
                                setWellDepthUnitsForAll = true;
                            }
                        }
                        well.getHeader().setWellUnits(well.getLink().getWellUnits());
                        well.updateHeaderStatus();
                    }
                    if (well.getStatus() == WsWell.CONFLICT) {
                        int opt;
                        if (resetAllwellheaderfields) {
                            opt = 0;
                        } else {
                            Object[] buttons = new String[]{"Yes", "Yes to all", "No"};
                            opt = JOptionPane.showOptionDialog(this, "Do you want to ignore conflicting well header details for '" + well.getWellName() + "'?\n(Non-conflicting new values will be saved)", this.getTitle(), 0, 3, null, buttons, buttons[1]);
                            if (opt == 1) {
                                resetAllwellheaderfields = true;
                            }
                        }
                        if (opt == 2) {
                            this.setCursor(Cursor.getDefaultCursor());
                            isConflict = true;
                            break;
                        }
                        DialogMatchWellHeader dialog = new DialogMatchWellHeader(this, true, this.ws, this.db, well);
                        dialog.excludeConflictingFields();
                    }
                }
                Iterator<Object> opt = this.dataTypes.iterator();
                while (opt.hasNext()) {
                    int dType = opt.next();
                    for (Component comp : this.jTabbedPane1.getComponents()) {
                        if (!(comp instanceof JPanelOrganiser)) continue;
                        JPanelOrganiser panel = (JPanelOrganiser)comp;
                        if (SBdb.isInterpDataType(dType) && panel.hdr != null && panel.hdr.getLink() == null) {
                            JOptionPane.showMessageDialog(this, "Version(s) not matched (e.g. '" + panel.hdr.toString() + "'). Use Match | Version, or removed unmatched versions.", this.getTitle(), 2);
                            this.setCursor(Cursor.getDefaultCursor());
                            return;
                        }
                        if (!SBdb.isInterpDataType(dType) ? panel.hdr != null : panel.hdr == null) continue;
                        if (replace && dType != 1 || well.getDataMonitor(dType, 'M', panel.getInterpID()).getStatus() != SbugsStatus.CONFLICT) continue;
                        isConflict = true;
                        Object[] buttons = new String[]{"Stop checking", "Continue"};
                        String msg = "Cannot save: conflicting data in workspace" + (String)(panel.hdr == null ? "" : "\nVersion: " + panel.hdr.getDescription()) + "\nWell/Outcrop: " + well.getWellName() + "\nData: " + SBdb.dTypeNames[dType];
                        int opt2 = JOptionPane.showOptionDialog(this.isVisible() ? this : null, msg, this.getTitle(), 0, 3, null, buttons, buttons[0]);
                        LOGGER.log(Level.INFO, msg);
                        if (opt2 == 1) continue;
                        conflictCheckingStopped = true;
                        break block5;
                    }
                }
                if (this.dataTypes.contains(8) || this.dataTypes.contains(2) || this.dataTypes.contains(4) || this.dataTypes.contains(6)) {
                    for (AnalystHeader hdr : well.getAnalystHeaders()) {
                        if (!(hdr.getDiscipline() == Discipline.MICRO && this.dataTypes.contains(2) || hdr.getDiscipline() == Discipline.MACRO && this.dataTypes.contains(8) || hdr.getDiscipline() == Discipline.PALY && this.dataTypes.contains(6)) && (hdr.getDiscipline() != Discipline.NANNO || !this.dataTypes.contains(4)) || hdr.getStatus() != SbugsStatus.CONFLICT) continue;
                        String msg = "Cannot save: conflict in analyst suite header (" + SBdb.getDiscAbr(hdr.getDiscID()) + ") - match suites from Match Analyses dialog";
                        JOptionPane.showMessageDialog(this, msg, this.getTitle(), 2);
                        this.setCursor(Cursor.getDefaultCursor());
                        return;
                    }
                    for (Sample sample : well.getSamples()) {
                        for (Smpdtl smpdtl : sample.getSmpdtls()) {
                            for (TaxonOcc occ : smpdtl.getOccurUnsorted()) {
                                if (occ.getTaxon() == null) {
                                    JOptionPane.showMessageDialog(this, "Cannot save: unreferenced taxa in workspace, remove '" + smpdtl.getDiscID() + "' analyses before attempting to save data.", this.getTitle(), 2);
                                    this.setCursor(Cursor.getDefaultCursor());
                                    return;
                                }
                                if (occ.getTaxon().getLink() != null) continue;
                                JOptionPane.showMessageDialog(this, "Cannot save: unmatched taxa in workspace, use Match | Taxa", this.getTitle(), 2);
                                this.setCursor(Cursor.getDefaultCursor());
                                return;
                            }
                            if (smpdtl.getProximal() > 0 && this.ws.getEnvScheme(well.getAnalystHeader(smpdtl.getAnalystAbr(), smpdtl.getDiscID(), smpdtl.getAnalyNo(), false).getEnvSchID()).getLink() == null) {
                                JOptionPane.showMessageDialog(this, "Cannot save: unmatched environment schemes in workspace, use Match | Palaeoenvironment schemes", this.getTitle(), 2);
                                this.setCursor(Cursor.getDefaultCursor());
                                return;
                            }
                            if (smpdtl.getHeader().getAbnSchID() <= 0) continue;
                            AbundanceScheme abnScheme = this.ws.getAbundanceSchemeService().findAbundanceScheme(smpdtl.getHeader().getAbnSchID()).orElse(null);
                            AbundanceScheme link = ((AbundanceSchemeServiceImpl)this.ws.getAbundanceSchemeService()).getLinkObject(smpdtl.getHeader().getAbnSchID());
                            if (abnScheme != null && (link != null || !this.ws.getAbundanceSchemeInformationService().hasAbnSchemeOccs(abnScheme.getAbnSchID()))) continue;
                            JOptionPane.showMessageDialog(this, "Cannot save: unmatched abundance schemes in workspace, use Match | Abundance", this.getTitle(), 2);
                            this.setCursor(Cursor.getDefaultCursor());
                            return;
                        }
                    }
                }
                if (this.dataTypes.contains(14)) {
                    wit = well.getInterpIterator();
                    while (wit.hasNext()) {
                        WellInterp wellInterp = wit.next();
                        for (SQPick pick : wellInterp.getSQPicks()) {
                            if (pick.getSurface().getLink() != null) continue;
                            JOptionPane.showMessageDialog(this, "Sequence picks not matched. Use Match | Stratigrahpic intervals and surfaces", this.getTitle(), 2);
                            this.setCursor(Cursor.getDefaultCursor());
                            return;
                        }
                    }
                }
                if (this.dataTypes.contains(15)) {
                    wit = well.getInterpIterator();
                    while (wit.hasNext()) {
                        WellInterp wellInterp = wit.next();
                        for (IGDIntervalEnv env : wellInterp.getEnvs()) {
                            EnvScheme scheme = this.ws.getEnvScheme(env.getSchID());
                            if (scheme != null && scheme.getLink() != null) continue;
                            LOGGER.log(Level.FINE, "Return from getEnvScheme, schemeID=" + env.getSchID() + ", scheme=" + String.valueOf(scheme));
                            JOptionPane.showMessageDialog(this, "Palaeoenvironment scheme(s) not matched. Use Match | Palaeoenvironment schemes", this.getTitle(), 2);
                            this.setCursor(Cursor.getDefaultCursor());
                            return;
                        }
                    }
                }
                if (!this.dataTypes.contains(23)) continue;
                for (Curve curve : well.getCurveService().getCurves()) {
                    if (this.ws.getLogDef(curve.getAbr()).getLink() != null) continue;
                    JOptionPane.showMessageDialog(this, "Wireline log header(s) not matched. Use Match | Wireline log headers", this.getTitle(), 2);
                    this.setCursor(Cursor.getDefaultCursor());
                    return;
                }
            }
            if (isConflict) {
                this.setCursor(Cursor.getDefaultCursor());
                if (!conflictCheckingStopped) {
                    JOptionPane.showMessageDialog(this, "Resolve conflicting data in workspace. Exclude or delete before re-saving.", this.getTitle(), 2);
                }
                return;
            }
            LOGGER.log(Level.CONFIG, "No conflicts, saving data in background task ...");
            if (replace) {
                Object[] options = new String[]{this.resources.getString("button.yes"), this.resources.getString("button.no")};
                String msg = "ALL database data for selected data types will be deleted before saving new data.\nNote: no samples will be deleted.\nAre you sure you want to continue?";
                if (JOptionPane.showOptionDialog(this, msg, this.getTitle(), 0, 3, null, options, options[1]) != 0) {
                    return;
                }
            }
            this.pm = new ProgressMonitor(this, "Saving well data:", "", 0, 100);
            this.pm.setProgress(0);
            this.pm.setMillisToDecideToPopup(1000);
            this.pm.setMillisToPopup(1000);
            this.isSavingData = true;
            final Exception[] storeError = new Exception[1];
            SwingWorker task = new SwingWorker(this){
                final /* synthetic */ FrameOrganiser this$0;
                {
                    FrameOrganiser frameOrganiser = this$0;
                    Objects.requireNonNull(frameOrganiser);
                    this.this$0 = frameOrganiser;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected Object doInBackground() {
                    boolean wellSaved = false;
                    int nWells = 0;
                    int totalWells = this.this$0.ws.getnLoadedWells();
                    Iterator<Well> it = this.this$0.ws.getWellIterator();
                    LinkedList<WsWell> wells = new LinkedList<WsWell>();
                    while (it.hasNext()) {
                        wells.add((WsWell)it.next());
                    }
                    Collections.sort(wells);
                    this.this$0.wellBeingStored = null;
                    Object object = RefreshHelper.REFRESH_LOCK;
                    synchronized (object) {
                        try {
                            for (WsWell w : wells) {
                                if (this.isCancelled()) {
                                    break;
                                }
                                this.this$0.wellBeingStored = w;
                                if (this.this$0.wellBeingStored.getLink() != null) {
                                    this.setProgress(nWells * 100 / totalWells);
                                    if (replace) {
                                        try {
                                            this.this$0.wellBeingStored.deleteLinkData(this.this$0.dataTypes);
                                        }
                                        catch (Exception e) {
                                            LOGGER.log(Level.WARNING, "Error deleting data for well: " + this.this$0.wellBeingStored.getWellName() + " : " + e.getMessage());
                                            e.printStackTrace();
                                            continue;
                                        }
                                    }
                                    LOGGER.log(Level.INFO, "**************** Storing well: " + String.valueOf(this.this$0.wellBeingStored));
                                    this.this$0.wellBeingStored.store(this.this$0.dataTypes);
                                    LOGGER.log(Level.INFO, "**************** Finished storing well: " + String.valueOf(this.this$0.wellBeingStored));
                                    this.this$0.db.commit();
                                    wellSaved = true;
                                }
                                this.setProgress(++nWells * 100 / totalWells);
                            }
                        }
                        catch (IOException | SQLException | SBException | SBPermissionException e) {
                            this.this$0.inWizard = false;
                            wellSaved = false;
                            this.this$0.db.doRollback();
                            this.relinkWell(this.this$0.wellBeingStored);
                            storeError[0] = e;
                            this.cancel(true);
                        }
                        finally {
                            this.this$0.isSavingData = false;
                        }
                        return wellSaved;
                    }
                }

                @Override
                protected void done() {
                    this.this$0.pm.close();
                    try {
                        this.this$0.setCursor(Cursor.getPredefinedCursor(3));
                        if (this.isCancelled()) {
                            this.this$0.db.doRollback();
                            JOptionPane.showMessageDialog(null, "Data saving cancelled or error: wells saved before cancelling might need to be deleted.", this.this$0.getTitle(), 1);
                        } else {
                            this.this$0.db.commit();
                            if (!((Boolean)this.get()).booleanValue()) {
                                JOptionPane.showMessageDialog(null, "No data saved: check wells and data have been Matched to database", this.this$0.getTitle(), 1);
                            } else {
                                JOptionPane.showMessageDialog(null, "Data Saved", this.this$0.getTitle(), 1);
                                this.this$0.saveChartInDatabaseWizard();
                            }
                        }
                        int nWellsToNotify = 500 / this.this$0.jTabbedPane1.getComponents().length;
                        LOGGER.log(Level.FINE, "Updating GUI observers... ");
                        Iterator<Well> it = this.this$0.ws.getWellIterator();
                        try {
                            while (it.hasNext() && nWellsToNotify > 0) {
                                WsWell well = (WsWell)it.next();
                                if (well.getLink() == null) continue;
                                LOGGER.log(Level.FINE, "Updating observers for well: " + well.getWellName());
                                well.getLink().notifyObservers(Sample.class);
                                for (int dType : this.this$0.dataTypes) {
                                    if (!SBdb.isInterpDataType(dType)) {
                                        well.getLink().notifyObservers(dType);
                                        continue;
                                    }
                                    Iterator<WellInterp> wit = well.getLink().getInterpIterator();
                                    while (wit.hasNext()) {
                                        wit.next().notifyObservers(dType);
                                    }
                                }
                                --nWellsToNotify;
                            }
                        }
                        catch (SBException sBException) {
                            // empty catch block
                        }
                        LOGGER.log(Level.FINE, "...done");
                        this.this$0.setCursor(Cursor.getDefaultCursor());
                        this.this$0.isSavingData = false;
                        for (Component comp : this.this$0.jTabbedPane1.getComponents()) {
                            if (!(comp instanceof JPanelOrganiser)) continue;
                            JPanelOrganiser panel = (JPanelOrganiser)comp;
                            panel.fireTableDataChanged();
                        }
                    }
                    catch (InterruptedException | ExecutionException ie) {
                        JOptionPane.showMessageDialog(this.this$0, "Error executing data save task:\n" + ie.getMessage(), this.this$0.getTitle(), 0);
                        ie.printStackTrace();
                    }
                    catch (SQLException sql) {
                        FrameJsbugs.showStackError("SQL Error commiting saved data", sql, this.this$0.db);
                    }
                    catch (RuntimeException re) {
                        StackError.showStackError((String)"", (Throwable)re);
                    }
                    if (storeError[0] != null) {
                        FrameJsbugs.showStackError("SQL Error storing data", storeError[0], this.this$0.db);
                    }
                    if (!this.this$0.inWizard) {
                        try {
                            this.this$0.refreshView();
                        }
                        catch (Exception e) {
                            StackError.showStackError((String)"Error: ", (Throwable)e);
                        }
                    }
                    this.this$0.isSavingData = false;
                    this.this$0.setCursor(Cursor.getDefaultCursor());
                }

                void relinkWell(WsWell well) {
                    LOGGER.log(Level.FINE, "Reloading and linking well data for well: " + String.valueOf(well));
                    if (well.getLink() != null) {
                        try (Statement stmt = this.this$0.db.getDatabase().createStatement();){
                            well.getLink().refresh(stmt);
                        }
                        catch (SQLException | SBException ex) {
                            FrameJsbugs.showStackError("Error in data refresh of StoreData", (Exception)ex, this.this$0.db);
                        }
                    }
                }
            };
            task.addPropertyChangeListener(this);
            task.execute();
        }
        catch (SQLException | SBException e) {
            this.inWizard = false;
            this.setCursor(Cursor.getDefaultCursor());
            this.db.doRollback();
            FrameJsbugs.showStackError("Error saving data", (Exception)e, this.db);
        }
        this.refreshView();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("progress".equals(evt.getPropertyName())) {
            try {
                SwingWorker task = (SwingWorker)evt.getSource();
                if (!task.isDone()) {
                    if (this.pm.isCanceled()) {
                        task.cancel(true);
                    } else {
                        int nWellPercent = (Integer)evt.getNewValue();
                        int nWell = this.ws.getnLoadedWells() * nWellPercent / 100;
                        if (this.wellBeingStored != null) {
                            this.pm.setNote(this.wellBeingStored.getWellName());
                        }
                        this.pm.setProgress(nWellPercent);
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveChartsInDatabase() {
        int opt;
        if (!this.wsCM.hasDataLoaded()) {
            JOptionPane.showMessageDialog(this, "No chart templates to save!", this.getTitle(), 1);
            return;
        }
        try {
            if (!this.checkAnalystsMatched()) {
                return;
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
            return;
        }
        int projID = 0;
        if (this.jComboBoxProject.getSelectedItem() instanceof Project) {
            projID = ((Project)((Object)this.jComboBoxProject.getSelectedItem())).getID();
        }
        if (projID == 0 && (opt = JOptionPane.showConfirmDialog(this, "Selected destination project is 'global'.\nAre you sure?", "Save Charts", 0)) != 0) {
            return;
        }
        JPanel options = new JPanel(new GridLayout(ChartManager.PANEL_STORE_OPTION.values().length + 1, 1));
        options.add(new JLabel("Select an import option for panel templates:"));
        ButtonGroup buttonGroup = new ButtonGroup();
        ButtonModel[] buttons = new ButtonModel[ChartManager.PANEL_STORE_OPTION.values().length];
        for (int i = 0; i < ChartManager.PANEL_STORE_OPTION.values().length; ++i) {
            ChartManager.PANEL_STORE_OPTION option = ChartManager.PANEL_STORE_OPTION.values()[i];
            JRadioButton button = new JRadioButton(option.toString());
            buttonGroup.add(button);
            options.add(button);
            buttons[i] = button.getModel();
            if (option != ChartManager.PANEL_STORE_OPTION.SIMILAR) continue;
            button.setSelected(true);
        }
        ChartManager.PANEL_STORE_OPTION chosen = null;
        int opt2 = -1;
        assert (opt2 != 2);
        block14: while (chosen == null) {
            opt2 = JOptionPane.showConfirmDialog(this, options, "Panel Import Options", 2, -1, null);
            if (opt2 == 2) {
                return;
            }
            if (buttonGroup.getSelection() == null) continue;
            for (int i = 0; i < ChartManager.PANEL_STORE_OPTION.values().length; ++i) {
                if (buttonGroup.getSelection() != buttons[i]) continue;
                chosen = ChartManager.PANEL_STORE_OPTION.values()[i];
                continue block14;
            }
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            ChartManager.copyToDb(this.wsCM, this.parent.getChartManager(), projID, chosen);
            JOptionPane.showMessageDialog(this, "Charts saved.", this.getTitle(), 1);
        }
        catch (UnmatchedException ue) {
            JOptionPane.showMessageDialog(this, ue.getMessage(), "Save Charts", 0);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (SBException sbe) {
            StackError.showStackError((String)"Error", (Throwable)sbe);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void previewChart(int chartTemplateID) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            if (this.chartPreviews.get(chartTemplateID) == null) {
                this.chartPreviews.put(chartTemplateID, ChartFactory.createChart(this.wsCM.getChartTemplate(chartTemplateID), this.ws, this.wsCM));
            }
            Chart chart = this.chartPreviews.get(chartTemplateID);
            chart.setData();
            JScrollPaneChart scrollPane = new JScrollPaneChart(new ChartJPanel(chart));
            scrollPane.refreshView();
            JDialog preview = new JDialog((Frame)this, false);
            preview.add(scrollPane);
            preview.setPreferredSize(this.getSize());
            preview.setTitle("Preview : " + this.wsCM.getChartTemplate(chartTemplateID).getName());
            preview.pack();
            preview.setLocationRelativeTo(this);
            preview.setVisible(true);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (IOException | SBException sbe) {
            StackError.showStackError((String)"Error", (Throwable)sbe);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    void excludePanel(int panelID) {
        if (this.wsCM != null) {
            try {
                this.wsCM.deletePanelTemplate(panelID);
                for (Chart chart : this.chartPreviews.values()) {
                    chart.updateFromTemplate(this.ws);
                }
                this.refreshView();
            }
            catch (SBPermissionException pe) {
                JOptionPane.showMessageDialog(this, "Unexpected permission exception:\n" + pe.getMessage(), this.getTitle(), 2);
            }
            catch (IOException | SQLException | SBException e) {
                FrameJsbugs.showStackError("Error", (Exception)e, this.db);
            }
            catch (RuntimeException re) {
                StackError.showStackError((String)"", (Throwable)re);
            }
        }
    }

    private void jMenuItemSaveInDatabaseActionPerformed(ActionEvent evt) {
        this.saveInDatabase(false);
    }

    private void jMenuItemViewVersionActionPerformed(ActionEvent evt) {
        try {
            DialogSelectVersion dialog = new DialogSelectVersion(this, true, this.db, false, this.ws.getWellIterator());
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.selection != null) {
                for (InterpHdr hdr : dialog.selection) {
                    this.viewVersion(hdr);
                }
            }
        }
        catch (Exception e) {
            this.inWizard = false;
            StackError.showStackError((String)"Error showing version selector: ", (Throwable)e);
        }
    }

    private void jMenuItemMatchIGDIntervalsActionPerformed(ActionEvent evt) {
        try {
            DialogMatchIGD dialog = new DialogMatchIGD(this, true, this.ws, this.db);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (!dialog.isOK()) {
                this.inWizard = false;
            }
        }
        catch (Exception e) {
            StackError.showStackError((String)"Error opening Match Interpreted Geological Intervals dialog.", (Throwable)e);
        }
        if (!this.inWizard) {
            try {
                this.refreshView(IGDScheme.class);
            }
            catch (Exception e) {
                StackError.showStackError((String)"Error matching IGD: ", (Throwable)e);
            }
        }
        try {
            Iterator<Well> it = this.ws.getWellIterator();
            while (it.hasNext()) {
                WsWell well = (WsWell)it.next();
                for (InterpHdr hdr : this.ws.getInterps()) {
                    well.updateAllZonesStatus(well.getAddInterp(hdr), hdr.getLink(), this.units, false);
                }
            }
        }
        catch (SQLException | SBException ex) {
            SbugsExceptionHandler.showStackError(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jMenuItemMatchEnvSchemesActionPerformed(ActionEvent evt) {
        try {
            EnvScheme scheme;
            if (this.ws.getEnvSchemes().isEmpty()) {
                JOptionPane.showMessageDialog(this, "There are no palaeoenvironment schemes in the workspace", "Match Palaeoenvironments", 2);
                return;
            }
            if (this.ws.getEnvSchemes().size() > 1) {
                DialogSelectEnvScheme dialogSel = new DialogSelectEnvScheme((Frame)this, true, this.ws);
                dialogSel.setLocationRelativeTo(this);
                dialogSel.setVisible(true);
                if (dialogSel.scheme == null) {
                    return;
                }
                scheme = dialogSel.scheme;
            } else {
                scheme = this.ws.getEnvSchemes().get(0);
            }
            this.matchEnvScheme(scheme);
        }
        catch (Exception e) {
            StackError.showStackError((String)"Error opening dialog.", (Throwable)e);
            e.printStackTrace();
        }
        finally {
            if (!this.inWizard) {
                try {
                    this.refreshView();
                }
                catch (Exception e) {
                    StackError.showStackError((String)"Error refreshing: ", (Throwable)e);
                }
            }
        }
    }

    void matchAbnScheme(AbundanceScheme scheme) {
        block5: {
            try {
                DialogMatchAbundance dialog = new DialogMatchAbundance(this, true, this.ws, this.db, (AbundanceSchemeServiceImpl)this.ws.getAbundanceSchemeService(), scheme, this.inWizard);
                if (dialog.hasAbundance()) {
                    dialog.setLocationRelativeTo(this);
                    dialog.setVisible(true);
                    if (!dialog.isOK()) {
                        this.inWizard = false;
                        return;
                    }
                    break block5;
                }
                JOptionPane.showMessageDialog(this, "There are no semi-quantitative abundance items to be matched in this scheme", this.getTitle(), 1);
                return;
            }
            catch (SQLException sql) {
                SbugsExceptionHandler.showStackError("SQL Error loading database abundance schemes", sql, this);
            }
        }
        if (!this.inWizard) {
            this.refreshView(AbundanceScheme.class);
        }
    }

    void matchEnvScheme(EnvScheme scheme) {
        try {
            DialogMatchEnvScheme dialog = new DialogMatchEnvScheme(this, true, scheme, this.ws, this.db, this.inWizard);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (!dialog.isOK()) {
                this.inWizard = false;
                return;
            }
            if (!this.inWizard) {
                this.refreshView(EnvScheme.class);
            }
        }
        catch (SQLException | SBException e) {
            SbugsExceptionHandler.showStackError(e, this);
        }
    }

    private void jMenuItemMatchIGDSchemesActionPerformed(ActionEvent evt) {
        try {
            List<IGDScheme> allSchemes = this.ws.getIGDSchemes();
            if (allSchemes.isEmpty()) {
                JOptionPane.showMessageDialog(this, "There are no schemes in the workspace", "Match Schemes", 1);
                return;
            }
            DialogList<IGDScheme> dialog = new DialogList<IGDScheme>(this, true, "Select Workspace scheme", null, allSchemes, true, false);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            dialog.getOptionalSelection().ifPresent(selection -> this.matchIGDScheme((IGDScheme)selection));
        }
        catch (SQLException sql) {
            SbugsExceptionHandler.showStackError(sql, this);
        }
    }

    void matchIGDScheme(IGDScheme scheme) {
        try {
            DialogMatchIGDScheme schemeDialog = new DialogMatchIGDScheme(this, true, scheme, this.db, this.inWizard);
            schemeDialog.setLocationRelativeTo(this);
            schemeDialog.setVisible(true);
            if (!schemeDialog.isOK()) {
                this.inWizard = false;
            }
            if (!this.inWizard) {
                this.refreshView(IGDScheme.class);
            }
        }
        catch (SQLException | SBException sql) {
            FrameJsbugs.showStackError("Error", (Exception)sql, this.db);
        }
    }

    private void jMenuItemDataTypesActionPerformed(ActionEvent evt) {
        block15: {
            DialogDataTypes dialog = new DialogDataTypes(this, true, this.dataTypes, this.includeReferencesInXML);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            try {
                if (dialog.isOK()) {
                    WsWell wsWell;
                    this.includeReferencesInXML = dialog.includeReferences;
                    if (dialog.newDTypes.equals(this.dataTypes)) {
                        return;
                    }
                    Iterator<Well> it = this.ws.getWellIterator();
                    while (it.hasNext()) {
                        wsWell = (WsWell)it.next();
                        boolean shouldUnloadSamples = false;
                        for (int dType : this.dataTypes) {
                            if (dialog.newDTypes.contains(dType)) continue;
                            if (dType == 1) {
                                shouldUnloadSamples = true;
                                continue;
                            }
                            if (SBdb.isInterpDataType(dType)) {
                                for (Component comp : this.jTabbedPane1.getComponents()) {
                                    if (!(comp instanceof JPanelOrganiser)) continue;
                                    JPanelOrganiser panel = (JPanelOrganiser)comp;
                                    wsWell.unloadData(dType, panel.getInterpID());
                                }
                                continue;
                            }
                            wsWell.unloadData(dType, 0);
                        }
                        if (shouldUnloadSamples) {
                            wsWell.unloadData(1, 0);
                        }
                        wsWell.updateStatus();
                    }
                    this.dataTypes.clear();
                    this.dataTypes.addAll(dialog.newDTypes);
                    if (!this.dataTypes.contains(1)) {
                        it = this.ws.getWellIterator();
                        while (it.hasNext()) {
                            wsWell = (WsWell)it.next();
                            if (wsWell.getSamples().isEmpty()) continue;
                            this.dataTypes.add(1);
                            break;
                        }
                    }
                    for (Component comp : this.jTabbedPane1.getComponents()) {
                        if (comp instanceof JPanelOrganiser) {
                            JPanelOrganiser panel = (JPanelOrganiser)comp;
                            panel.refreshView(true);
                            continue;
                        }
                        if (!(comp instanceof JPanelOrganiserDict)) continue;
                        ((JPanelOrganiserDict)comp).initTreeData(this.wsCM, this.ws);
                    }
                    break block15;
                }
                this.inWizard = false;
            }
            catch (SQLException | SBException sql) {
                this.inWizard = false;
                FrameJsbugs.showStackError("SQL Error", (Exception)sql, this.db);
            }
            catch (RuntimeException re) {
                this.inWizard = false;
                StackError.showStackError((String)"", (Throwable)re);
            }
        }
    }

    private void jMenuItemOpenWellsActionPerformed(ActionEvent evt) {
        if (!this.checkClear(true)) {
            return;
        }
        try {
            DialogSelectWell dialog = new DialogSelectWell(this, true, this.db, true);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.getSelection() != null) {
                for (Well well : dialog.getSelection()) {
                    this.addWsWell(well);
                }
                this.refreshView();
            } else {
                this.inWizard = false;
            }
        }
        catch (Exception e) {
            StackError.showStackError((String)"SQL Error: ", (Throwable)e);
        }
    }

    void addWsWell(Well well) throws SQLException, SBException {
        well.loadInterps();
        Iterator<Well> itw = this.ws.getWellIterator();
        boolean found = false;
        while (itw.hasNext()) {
            WsWell wsWell = (WsWell)itw.next();
            if (well != wsWell.getLink()) continue;
            found = true;
            break;
        }
        if (!found) {
            this.ws.addWellToWorkspace(well);
        }
    }

    private void jMenuItemOpenProjectActionPerformed(ActionEvent evt) {
        if (!this.checkClear(true)) {
            return;
        }
        try {
            DialogSelectProjectWellList dialog = new DialogSelectProjectWellList((Window)this, this.db, null, this.wsCM);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.getSelection() == null) {
                return;
            }
            WellList wellList = dialog.getSelection();
            this.project = this.db.getProject(wellList.getProjID());
            Iterator<Well> itw = this.db.getWellIterator(wellList.getID());
            while (itw.hasNext()) {
                this.addWsWell(itw.next());
            }
            this.refreshView();
        }
        catch (RuntimeException | SQLException | SBException e) {
            SbugsExceptionHandler.showStackError(e);
        }
    }

    private void jMenuItemOpenXMLActionPerformed(ActionEvent evt) {
        if (!this.checkClear(true)) {
            return;
        }
        this.setupXMLFileChooser();
        if (0 == this.jFileChooserXML.showOpenDialog(this)) {
            this.openXMLfile(this.jFileChooserXML.getSelectedFile(), null);
        }
    }

    private void jMenuItemOpenCSVActionPerformed(ActionEvent evt) {
        if (!this.checkClear(true)) {
            return;
        }
        this.setupCSVFileChooser();
        if (0 == this.jFileChooserCSV.showOpenDialog(this)) {
            this.openCSVfile(this.jFileChooserCSV.getSelectedFile());
        }
    }

    private void saveCommon() {
        String defaultFileName = null;
        if (this.project != null) {
            defaultFileName = this.project.getName();
        } else {
            try {
                if (this.ws.getnLoadedWells() == 1) {
                    Well well = this.ws.getWellIterator().next();
                    defaultFileName = SB.makeFileName((String)well.getWellCode());
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Exception from getting default well in saveCommon: " + ex.toString());
                ex.printStackTrace();
            }
        }
        String[] extensions = new String[]{"sbg", "zip", "dex"};
        String[] descriptions = new String[]{"StrataBugs XML/SBG", "StrataBugs XML/ZIP files", "DEX"};
        File file = FileChooserUtils.chooseFileToWrite((SBdb)this.db, (Component)this, (String)"WINFILE", (String)"UNXFILE", (String[])extensions, (String[])descriptions, (String)defaultFileName);
        if (file == null) {
            return;
        }
        String extension = file.getName().substring(file.getName().lastIndexOf(".") + 1);
        if (extension.equalsIgnoreCase("zip") || extension.equalsIgnoreCase("sbg")) {
            this.saveZipFile(file);
        } else {
            this.exportDEX(file);
        }
    }

    private void jMenuItemSaveDEXActionPerformed(ActionEvent evt) {
        if (!this.allowExport()) {
            return;
        }
        this.setupDEXFileChooser();
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (0 == this.jFileChooserDEX.showSaveDialog(this)) {
            if (this.jFileChooserDEX.getSelectedFile().exists() && JOptionPane.showConfirmDialog(this, "Overwrite file?", "Confirm File Overwrite", 0, 3) != 0) {
                this.setCursor(Cursor.getDefaultCursor());
                return;
            }
            this.exportDEX(this.jFileChooserDEX.getSelectedFile());
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    private boolean allowExport() {
        if ((this.db.getUser().getPriv() & 0x4000) > 0) {
            JOptionPane.showMessageDialog(this, "You are not allowed to export data.\n(See config | Personnel for privilege options)", this.getTitle(), 2);
            return false;
        }
        return true;
    }

    private void jMenuItemSaveTextActionPerformed(ActionEvent evt) {
        if (!this.allowExport()) {
            return;
        }
        try {
            if (this.ws.getUsers().isEmpty()) {
                this.jMenuItemLoadWorkspaceActionPerformed(null);
            }
            if (!this.checkCSVexport()) {
                return;
            }
            Component comp = this.jTabbedPane1.getSelectedComponent();
            if (!(comp instanceof JPanelOrganiser)) {
                JOptionPane.showMessageDialog(this, "Select a well data panel to export", this.getTitle(), 2);
                return;
            }
            JPanelOrganiser panel = (JPanelOrganiser)comp;
            LinkedList<Well> wells = new LinkedList<Well>();
            Iterator<Well> it = this.ws.getWellIterator();
            while (it.hasNext()) {
                wells.add(it.next());
            }
            Set<InterpHdr> interpHeaders = this.getOpenInterpretations();
            if (interpHeaders.isEmpty()) {
                JOptionPane.showMessageDialog(this, "You can only export interpreted data with this method. Select a version with some interpreted data.", this.getTitle(), 2);
                return;
            }
            DialogExportText dialog = new DialogExportText(this, true, this.db, this.dataTypes, wells, panel.hdr, this.units, interpHeaders);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void jMenuItemOpenCommonActionPerformed(ActionEvent evt) {
        if (!this.checkClear(true)) {
            return;
        }
        this.openCommon();
    }

    private boolean openCommon() {
        File file = SbugsIO.chooseFileToOpen(this.db, this, "WINFILE", "Biostratigraphy files (sbg,dat,txt,csv,xls,dex,xml,zip)", "sbg", "dat", "txt", "csv", "xls", "xlsx", "dex", "xml", "zip");
        if (file == null) {
            return false;
        }
        return this.openCommon(file);
    }

    private boolean openCommon(File file) {
        String fileType;
        String fileName = file.getPath();
        switch (fileType = fileName.substring(fileName.lastIndexOf(46) + 1).toLowerCase().trim()) {
            case "dex": {
                return this.openDEXfile(file);
            }
            case "xml": {
                return this.openXMLfile(file, null);
            }
            case "zip": 
            case "sbg": {
                return this.openZipArchive(file);
            }
            case "csv": 
            case "xls": 
            case "xlsx": {
                return this.openCSVfile(file);
            }
            case "txt": 
            case "dat": {
                return this.openSbugsFile(file);
            }
        }
        JOptionPane.showMessageDialog(this, "File type not supported for file: " + String.valueOf(file), this.getTitle(), 1);
        return false;
    }

    private void jButtonOpenFileActionPerformed(ActionEvent evt) {
        if (!this.checkClear(true)) {
            return;
        }
        this.openCommon();
    }

    private void jButtonOpenWellsActionPerformed(ActionEvent evt) {
        this.jMenuItemOpenWellsActionPerformed(evt);
    }

    private void jButtonOpenProjectActionPerformed(ActionEvent evt) {
        this.jMenuItemOpenProjectActionPerformed(evt);
    }

    private void jButtonExportActionPerformed(ActionEvent evt) {
        this.export();
    }

    private void jMenuItemGuidedImportActionPerformed(ActionEvent evt) {
        this.importFile();
    }

    private void jMenuItemGuidedExportActionPerformed(ActionEvent evt) {
        this.export();
    }

    private void jButtonImportActionPerformed(ActionEvent evt) {
        this.importFile();
    }

    private void jButtonSaveToFileActionPerformed(ActionEvent evt) {
        if (!this.allowExport()) {
            return;
        }
        this.saveCommon();
    }

    private void jMenuItemSaveZipFileActionPerformed(ActionEvent evt) {
        if (!this.allowExport()) {
            return;
        }
        if (this.jFileChooserZIP == null) {
            this.setupZIPFileChooser();
        }
        if (0 == this.jFileChooserZIP.showSaveDialog(this)) {
            File file = this.jFileChooserZIP.getSelectedFile();
            if (file.exists() && JOptionPane.showConfirmDialog(this, "Overwrite file?", "Confirm File Overwrite", 0, 3) != 0) {
                this.setCursor(Cursor.getDefaultCursor());
                return;
            }
            this.saveZipFile(file);
        }
    }

    private void saveZipFile(File file) {
        try {
            SbugsIO.saveSBGfile(this.db, null, this.ws, file, this, this.dataTypes, this.includeReferencesInXML);
        }
        catch (SBPermissionException pe) {
            JOptionPane.showMessageDialog(this, pe.getMessage(), this.getTitle(), 2);
        }
        catch (SQLException | SBException sql) {
            FrameJsbugs.showStackError("SQL Error", (Exception)sql, this.db);
        }
        catch (IOException ioe) {
            StackError.showStackError((String)"Error writing file", (Throwable)ioe);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void jMenuItemViewExcludeActionPerformed(ActionEvent evt) {
        if (!(this.jTabbedPane1.getSelectedComponent() instanceof JPanelOrganiser) || ((JPanelOrganiser)this.jTabbedPane1.getSelectedComponent()).getJtableOrg().getSelectedRowCount() == 0) {
            JOptionPane.showMessageDialog(this, "No wells selected", this.getTitle(), 1);
            return;
        }
        JPanelOrganiser panel = (JPanelOrganiser)this.jTabbedPane1.getSelectedComponent();
        try {
            int[] selection = panel.getJtableOrg().getSelectedRows();
            LinkedList<Well> toExclude = new LinkedList<Well>();
            for (int i = 0; i < selection.length; ++i) {
                Well well = panel.model.wsWells.get(panel.getJtableOrg().convertRowIndexToModel(selection[i]));
                toExclude.add(well);
            }
            for (Well well : toExclude) {
                LOGGER.log(Level.FINE, "Excluding well: " + String.valueOf(well));
                if (this.wsCM != null) {
                    this.wsCM.deleteWell(well.getWellID(), null);
                }
                for (Chart chart : this.chartPreviews.values()) {
                    chart.wellDeleted(well.getWellID());
                }
                this.ws.deleteWell(well);
                if (((WsWell)well).getLink() == null) continue;
                ((WsWell)well).getLink().deleteObserver(panel);
            }
            HashSet<Integer> gone = new HashSet<Integer>();
            for (Integer chartID : this.chartPreviews.keySet()) {
                if (this.wsCM.getChartTemplate(chartID) != null) continue;
                gone.add(chartID);
            }
            for (Integer g : gone) {
                this.chartPreviews.remove(g);
            }
            this.refreshView();
        }
        catch (SBPermissionException pe) {
            JOptionPane.showMessageDialog(this, pe.getMessage(), this.getTitle(), 2);
        }
        catch (SQLException | SBException sql) {
            FrameJsbugs.showStackError("SQL Error", (Exception)sql, this.db);
        }
    }

    private void jRadioButtonMenuItemMetresActionPerformed(ActionEvent evt) {
        this.setUnits();
    }

    private void jRadioButtonMenuItemFeetActionPerformed(ActionEvent evt) {
        this.setUnits();
    }

    private void jRadioButtonMenuItemDrilledActionPerformed(ActionEvent evt) {
        this.setUnits();
    }

    private boolean checkWsEmpty() {
        try {
            if (this.ws.getUsers().size() > 0) {
                JOptionPane.showMessageDialog(this, "You cannot load from database into a non-empty workspace.\nOpen a new Organiser window.", this.getTitle(), 1);
                return false;
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jMenuItemLoadWorkspaceActionPerformed(ActionEvent evt) {
        if (!this.checkWsEmpty()) {
            return;
        }
        try {
            int opt;
            if (this.hasTaxonDataType() && this.synSchID > 0 && (opt = JOptionPane.showConfirmDialog(this, "Continue to export data using selected synonym scheme?\nIf not, turn off scheme usage in Match | Synonymy menu.", this.getTitle(), 0, 3)) == 1) {
                this.inWizard = false;
                return;
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            Iterator<Well> it = this.ws.getWellIterator();
            while (it.hasNext()) {
                WsWell wsWell = (WsWell)it.next();
                if (wsWell.getLink() == null) continue;
                LOGGER.log(Level.FINE, "Filling well: {0}...", wsWell);
                wsWell.fillData(this.dataTypes, this.synSchID);
                LOGGER.log(Level.FINE, "Filled well: {0}", wsWell);
                Component[] componentArray = this.jTabbedPane1.getComponents();
                int n = componentArray.length;
                for (int i = 0; i < n; ++i) {
                    Component comp = componentArray[i];
                    if (!(comp instanceof JPanelOrganiser)) continue;
                    JPanelOrganiser panel = (JPanelOrganiser)comp;
                    if (panel.hdr != null) {
                        if (panel.hdr.getLink() == null) {
                            LOGGER.log(Level.FINE, "Auto-assigning default version to default version in workspace");
                            panel.hdr.setLink(this.db.getInterp(0));
                        }
                        LOGGER.log(Level.FINE, "Filling interp: " + panel.hdr.getDescription() + " for well: " + String.valueOf(wsWell));
                        wsWell.fillData(this.dataTypes, panel.hdr);
                        LOGGER.log(Level.FINE, "Filled interp: " + panel.hdr.getDescription() + " for well: " + String.valueOf(wsWell));
                    }
                    panel.refreshView(false);
                }
                wsWell.getHeader().fillAuditWorkspace(this.db, this.ws);
            }
            for (Component comp : this.jTabbedPane1.getComponents()) {
                if (!(comp instanceof JPanelOrganiserDict)) continue;
                JPanelOrganiserDict jPanelOrganiserDict = (JPanelOrganiserDict)comp;
                jPanelOrganiserDict.initTreeData(this.wsCM, this.ws);
            }
        }
        catch (SBPermissionException pe) {
            JOptionPane.showMessageDialog(this, pe.getMessage(), this.getTitle(), 2);
            pe.printStackTrace();
            this.inWizard = false;
        }
        catch (SQLException | SBException sql) {
            this.inWizard = false;
            FrameJsbugs.showStackError("Error", (Exception)sql, this.db);
        }
        catch (RuntimeException re) {
            this.inWizard = false;
            StackError.showStackError((String)"", (Throwable)re);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jMenuItemMatchInterpActionPerformed(ActionEvent evt) {
        this.matchInterps();
    }

    private boolean hasTaxonDataType() throws SBException {
        for (int dType : this.dataTypes) {
            switch (dType) {
                case 2: 
                case 4: 
                case 6: 
                case 8: 
                case 16: {
                    return true;
                }
            }
        }
        return false;
    }

    void matchInterps() {
        try {
            DialogMatchInterp dialog = new DialogMatchInterp(this, true, this.ws, this.db, this.wsCM, this.inWizard);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (!dialog.isOK) {
                this.inWizard = false;
            }
            int tabIndex = 0;
            for (Component comp : this.jTabbedPane1.getComponents()) {
                if (comp instanceof JPanelOrganiser) {
                    JPanelOrganiser panel = (JPanelOrganiser)comp;
                    panel.setName();
                    this.jTabbedPane1.setTitleAt(tabIndex, panel.getName());
                }
                ++tabIndex;
            }
            this.refreshView(InterpHdr.class);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void jMenuItemMatchEventsActionPerformed(ActionEvent evt) {
        this.matchEvents();
    }

    void matchEvents() {
        try {
            if (!this.inWizard && !this.ws.hasEvents()) {
                JOptionPane.showMessageDialog(this, "There are no events in the workspace", "Match Events", 1);
                return;
            }
            for (SBEvent e : this.ws.getSBEvents(false)) {
                if (e.getTaxon() == null || e.getTaxon().getLink() != null) continue;
                JOptionPane.showMessageDialog(this, "You must match all event taxa first.", this.getTitle(), 2);
                return;
            }
            DialogMatchEvents dialog = new DialogMatchEvents(this, true, this.ws, this.db, this.inWizard);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (!dialog.isOK()) {
                this.inWizard = false;
            }
            if (!this.inWizard) {
                this.refreshView(SBEvent.class);
            }
        }
        catch (SQLException | SBException sql) {
            FrameJsbugs.showStackError("Error", (Exception)sql, this.db);
        }
    }

    private void jMenuItemRemoveVersionActionPerformed(ActionEvent evt) {
        if (!(this.jTabbedPane1.getSelectedComponent() instanceof JPanelOrganiser)) {
            JOptionPane.showMessageDialog(this, "Select a version tab", this.getTitle(), 2);
            return;
        }
        JPanelOrganiser panel = (JPanelOrganiser)this.jTabbedPane1.getSelectedComponent();
        if (panel.hdr == null) {
            JOptionPane.showMessageDialog(this, "You cannot remove non-version data tab", this.getTitle(), 2);
            return;
        }
        if (this.jTabbedPane1.getComponents().length <= 2) {
            JOptionPane.showMessageDialog(this, "You cannot remove the only version tab", this.getTitle(), 2);
            return;
        }
        panel.deleteObserved();
        this.ws.removeInterp(panel.hdr);
        this.jTabbedPane1.remove(panel);
    }

    private void jButtonDataTypesActionPerformed(ActionEvent evt) {
        this.jMenuItemDataTypesActionPerformed(evt);
    }

    private void jButtonSaveToDatabaseActionPerformed(ActionEvent evt) {
        this.saveAllInDatabase();
    }

    private void jMenuItemOpenZipActionPerformed(ActionEvent evt) {
        if (!this.checkClear(true)) {
            return;
        }
        this.setupZIPFileChooser();
        if (0 == this.jFileChooserZIP.showOpenDialog(this)) {
            this.openZipArchive(this.jFileChooserZIP.getSelectedFile());
        }
    }

    private void jMenuItemOrganiserHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("organiser.html");
    }

    private void jMenuItemHelpMenuActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("organiser_menu.html");
    }

    private void jMenuItemHelpMatchActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("matchdialogs.html");
    }

    private void jMenuItemOpenBugWareActionPerformed(ActionEvent evt) {
        if (!this.checkClear(true)) {
            return;
        }
        this.openBugWarefile();
    }

    private void jMenuItemOpenChecklistActionPerformed(ActionEvent evt) {
        if (!this.checkClear(true)) {
            return;
        }
        this.openChecklistfile();
    }

    private void jMenuItemOpenRGActionPerformed(ActionEvent evt) {
        if (!this.checkClear(true)) {
            return;
        }
        this.openRGFile();
    }

    private void jMenuItemOpenSbugsActionPerformed(ActionEvent evt) {
        if (!this.checkClear(true)) {
            return;
        }
        this.openSbugsFile(null);
    }

    private void jMenuItemReplaceAllActionPerformed(ActionEvent evt) {
        this.saveInDatabase(true);
    }

    private void jMenuMatchActionPerformed(ActionEvent evt) {
        this.jMenuItemMatchAnalysts.setForeground(Color.YELLOW);
    }

    private void jMenuItemOpenTSCreatorActionPerformed(ActionEvent evt) {
        this.openTSCCreatorFile();
    }

    private void jMenuItemOpenIGDXLSActionPerformed(ActionEvent evt) {
        if (!this.checkClear(true)) {
            return;
        }
        this.setupXLSFileChooser();
        if (0 == this.jFileChooserXLS.showOpenDialog(this)) {
            this.openXLSFile(this.jFileChooserXLS.getSelectedFile(), 1);
        }
    }

    private void jMenuItemOpenOWXLSActionPerformed(ActionEvent evt) {
        if (!this.checkClear(true)) {
            return;
        }
        this.setupXLSFileChooser();
        if (0 == this.jFileChooserXLS.showOpenDialog(this)) {
            this.openXLSFile(this.jFileChooserXLS.getSelectedFile(), 2);
        }
    }

    private void jMenuItemICActionPerformed(ActionEvent evt) {
        if (this.ws.getnLoadedWells() == 0) {
            int opt = JOptionPane.showConfirmDialog(this, "Do you want to pre-select StrataBugs wells to enable sample matching?", "ODM Import", 1, 3);
            if (opt == 2 || opt == -1) {
                return;
            }
            if (opt == 0) {
                this.jMenuItemOpenWellsActionPerformed(null);
            }
        }
        try {
            DialogODM dialog = new DialogODM(this, true, this.ws, this.db, this.dataTypes);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            this.refreshView();
        }
        catch (SQLException | SBException e) {
            FrameJsbugs.showStackError("Error", (Exception)e, this.db);
        }
    }

    private void jMenuItemOpenSampleXLSActionPerformed(ActionEvent evt) {
        if (!this.checkClear(true)) {
            return;
        }
        this.setupXLSFileChooser();
        if (0 == this.jFileChooserXLS.showOpenDialog(this)) {
            this.openXLSFile(this.jFileChooserXLS.getSelectedFile(), 3);
        }
    }

    private void jMenuItemOpenSISSbugsActionPerformed(ActionEvent evt) {
        if (!this.checkClear(true)) {
            return;
        }
        this.openSISSbugsFile();
    }

    private void jMenuItemOpenSampleOccXLSActionPerformed(ActionEvent evt) {
        if (!this.checkClear(true)) {
            return;
        }
        this.setupXLSFileChooser();
        if (0 == this.jFileChooserXLS.showOpenDialog(this)) {
            this.openXLSFile(this.jFileChooserXLS.getSelectedFile(), 4);
        }
    }

    private void jMenuItemMatchCmpStdsActionPerformed(ActionEvent evt) {
        try {
            CompositeStandard cmpStd;
            if (this.ws.getCompositeStandards().isEmpty()) {
                JOptionPane.showMessageDialog(this, "There are no composite standards to match.", this.getTitle(), 2);
                return;
            }
            if (this.ws.getCompositeStandards().size() > 1) {
                DialogList<CompositeStandard> dialogSel = new DialogList<CompositeStandard>(this, true, "Select Composite Standard", new UserPrefsHelper(this.db), this.ws.getCompositeStandards(), true, false);
                dialogSel.setLocationRelativeTo(this);
                dialogSel.setVisible(true);
                if (dialogSel.getSelection() == null) {
                    return;
                }
                cmpStd = dialogSel.getSelection();
            } else {
                cmpStd = this.ws.getCompositeStandards().get(0);
            }
            this.matchCmpStd(cmpStd);
            if (!this.inWizard) {
                this.refreshView(CompositeStandard.class);
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("Error", sql, this.db);
        }
    }

    private void jMenuItemMatchTxGroupsActionPerformed(ActionEvent evt) {
        try {
            TxGroup group;
            if (this.ws.getTxGroups().isEmpty()) {
                JOptionPane.showMessageDialog(this, "There are no taxon groups to match.", this.getTitle(), 2);
                return;
            }
            if (this.ws.getTxGroups().size() > 1) {
                DialogList<TxGroup> dialogSel = new DialogList<TxGroup>(this, true, "Select Taxon Group", new UserPrefsHelper(this.db), new LinkedList<TxGroup>(this.ws.getTxGroups()), true, false);
                dialogSel.setLocationRelativeTo(this);
                dialogSel.setVisible(true);
                if (dialogSel.getSelection() == null) {
                    return;
                }
                group = dialogSel.getSelection();
            } else {
                group = new LinkedList<TxGroup>(this.ws.getTxGroups()).getFirst();
            }
            this.matchTxGroup(group);
            if (!this.inWizard) {
                this.refreshView(TxGroup.class);
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("Error", sql, this.db);
        }
    }

    private void jButtonProjectActionPerformed(ActionEvent evt) {
        try {
            DialogSelectProject dialog = new DialogSelectProject(this, true, this.db, true, this.parent.getChartManager());
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.selection != null) {
                this.jComboBoxProject.setSelectedItem((Object)dialog.selection);
            }
        }
        catch (SBException sbe) {
            StackError.showStackError((String)"Error", (Throwable)sbe);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
    }

    private void jMenuItemSaveChartsInDatabaseActionPerformed(ActionEvent evt) {
        this.saveChartsInDatabase();
    }

    private void jMenuItemAutoMatchSourceActionPerformed(ActionEvent evt) {
        try {
            DialogSource dialog = new DialogSource(this, true, this.db);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.isOK()) {
                this.autoMatchSource = dialog.selection;
                this.jCheckBoxMenuItemAutoMatch.setSelected(true);
                this.jCheckBoxMenuItemAutoMatchActionPerformed(evt);
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        this.setSourceMenuText();
    }

    private void jCheckBoxMenuItemAutoMatchActionPerformed(ActionEvent evt) {
        try {
            Lastval.putString(this.db, "AUTOMATCH", this.jCheckBoxMenuItemAutoMatch.isSelected() ? (this.autoMatchSource != null ? this.autoMatchSource.getID() : "NOSOURCE") : "N");
            this.db.commit();
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        if (!this.jCheckBoxMenuItemAutoMatch.isSelected()) {
            this.autoMatchSource = null;
        }
        this.setSourceMenuText();
    }

    private void jMenuItemMatchSetsActionPerformed(ActionEvent evt) {
        try {
            TxGroupSet grpSet;
            if (this.ws.getTxGroupSets().isEmpty()) {
                JOptionPane.showMessageDialog(this, "There are no group sets to match.", this.getTitle(), 2);
                return;
            }
            if (this.ws.getTxGroupSets().size() > 1) {
                DialogList<TxGroupSet> dialogSel = new DialogList<TxGroupSet>(this, true, "Select Group Set", new UserPrefsHelper(this.db), new LinkedList<TxGroupSet>(this.ws.getTxGroupSets()), true, false);
                dialogSel.setLocationRelativeTo(this);
                dialogSel.setVisible(true);
                if (dialogSel.getSelection() == null) {
                    return;
                }
                grpSet = dialogSel.getSelection();
            } else {
                grpSet = new LinkedList<TxGroupSet>(this.ws.getTxGroupSets()).getFirst();
            }
            this.matchTxGroupSet(grpSet);
            if (!this.inWizard) {
                this.refreshView(TxGroupSet.class);
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("Error", sql, this.db);
        }
    }

    private void jMenuItemMatchLogDefActionPerformed(ActionEvent evt) {
        try {
            if (this.ws.getLogDefs().isEmpty()) {
                JOptionPane.showMessageDialog(this, "There are no wireline log headers to match.", this.getTitle(), 2);
                return;
            }
            this.matchLogDefs();
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
    }

    private void jMenuItemMatchGeneraActionPerformed(ActionEvent evt) {
        this.matchGenera();
    }

    private void jMenuItemMatchAgeCurvesActionPerformed(ActionEvent evt) {
        try {
            if (this.ws.getAgeCurves().isEmpty()) {
                JOptionPane.showMessageDialog(this, "There are no age curves to match.", this.getTitle(), 2);
                return;
            }
            this.matchAgeCurves();
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
    }

    private void jMenuItemOpenSampleOccXLS2ActionPerformed(ActionEvent evt) {
        if (!this.checkClear(true)) {
            return;
        }
        this.setupXLSFileChooser();
        if (0 == this.jFileChooserXLS.showOpenDialog(this)) {
            this.openXLSFile(this.jFileChooserXLS.getSelectedFile(), 5);
        }
    }

    private void jMenuItemSaveChronoBathyActionPerformed(ActionEvent evt) {
        if (!this.allowExport()) {
            return;
        }
        try {
            Component comp;
            if (this.ws.getUsers().isEmpty()) {
                this.jMenuItemLoadWorkspaceActionPerformed(null);
            }
            if (!((comp = this.jTabbedPane1.getSelectedComponent()) instanceof JPanelOrganiser) || ((JPanelOrganiser)comp).hdr == null) {
                JOptionPane.showMessageDialog(this, "Select a well data tab showing the version to export (View | Version)", this.getTitle(), 2);
                return;
            }
            boolean hasChrono = false;
            boolean hasEnvs = false;
            for (int dType : this.dataTypes) {
                switch (dType) {
                    case 10: {
                        hasChrono = true;
                        break;
                    }
                    case 15: {
                        hasEnvs = true;
                        break;
                    }
                }
            }
            if (!hasChrono || !hasEnvs) {
                JOptionPane.showMessageDialog(this, "You need to select the chronostrat and palaeoenvironments data types", this.getTitle(), 2);
                return;
            }
            File outputFile = FileChooserUtils.saveAsGridDataDialog((Component)this, null);
            if (outputFile == null) {
                return;
            }
            GridWriter gw = new GridWriter();
            if (FilePathUtils.isFileExtension((String)outputFile.getPath(), (String[])new String[]{"xls", "xlsx"})) {
                gw.getXLSOptions().setSheetName("Chrono and Bathy");
                gw.getXLSOptions().setAuthorName(this.db.getUser().getName());
            } else {
                CSVExportOptions options = DialogCSVExporOptions.showNewCSVOptionsDialog(this.parent, (Component)this);
                if (options == null) {
                    return;
                }
                gw.setCSVOptions(options);
            }
            if (!FileOverwriteCheck.checkForGridFileOverwriting(this, (Component)this.parent, outputFile, gw)) {
                return;
            }
            Iterator<Well> wellsIt = this.ws.getWellIterator();
            ArrayList<Well> wellsList = new ArrayList<Well>();
            while (wellsIt.hasNext()) {
                wellsList.add(wellsIt.next());
            }
            JPanelOrganiser jpanel = (JPanelOrganiser)comp;
            Object[][] grid = new GridBuilderChronoBathy().buildGrid(wellsList, jpanel.hdr.getInterpID(), this.units);
            gw.write(outputFile, grid);
            JOptionPane.showMessageDialog(this, "File " + outputFile.getName() + " written", this.getTitle(), 2);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (RuntimeException | SBException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
        catch (IOException ex) {
            FrameJsbugs.showStackError("IO Error", ex, this.db);
        }
    }

    private void jMenuItemOpenGeoSciActionPerformed(ActionEvent evt) {
        if (!this.checkClear(true)) {
            return;
        }
        this.openGeoSciFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jMenuItemSaveRangesActionPerformed(ActionEvent evt) {
        JFileChooser jFileChooser = new JFileChooser();
        SbugsFileFilter filter = new SbugsFileFilter();
        filter.addExtension("csv");
        filter.setDescription("CSV files");
        jFileChooser.setFileFilter((FileFilter)filter);
        jFileChooser.setAcceptAllFileFilterUsed(false);
        File setDir = null;
        try {
            setDir = new File(Lastval.getString(this.db, "WINCSVFILE", "UNXCSVFILE"));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (setDir == null || setDir.getParent() == null || !setDir.getParentFile().exists()) {
            setDir = new File(".");
        }
        try {
            jFileChooser.setCurrentDirectory(setDir);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (jFileChooser.showSaveDialog(this) == 1) {
            return;
        }
        File file = jFileChooser.getSelectedFile();
        if (file == null) {
            return;
        }
        if (!file.getName().toLowerCase().endsWith(".csv")) {
            file = new File(file.getAbsolutePath() + ".csv");
        }
        JPanelOrganiser orgPanel = null;
        for (Component comp : this.jTabbedPane1.getComponents()) {
            if (!(comp instanceof JPanelOrganiser)) continue;
            orgPanel = (JPanelOrganiser)comp;
            break;
        }
        if (orgPanel == null) {
            JOptionPane.showMessageDialog(this, "Select a well data panel with version to export", this.getTitle(), 2);
            return;
        }
        try (BufferedWriter out = new BufferedWriter(new FileWriter(file));){
            this.setCursor(Cursor.getPredefinedCursor(3));
            char delim = ',';
            out.write("Well name" + delim + "Well code" + delim + "Country" + delim + "Latitude" + delim + "Longitude" + delim + "Geodatum" + delim);
            for (Integer dType : this.dataTypes) {
                if (SBdb.isInterpDataType(dType)) continue;
                out.write(SBdb.dTypeNames[dType] + delim);
            }
            for (Component comp : this.jTabbedPane1.getComponents()) {
                JPanelOrganiser panel;
                if (!(comp instanceof JPanelOrganiser) || !(panel = (JPanelOrganiser)comp).hasInterp()) continue;
                for (Integer dType : this.dataTypes) {
                    if (!SBdb.isInterpDataType(dType)) continue;
                    out.write(SBdb.dTypeNames[dType] + " : " + this.db.getInterp(panel.getInterpID()).toString() + delim);
                }
            }
            out.write("\r\n");
            for (WsWell well : orgPanel.model.wsWells) {
                WellHeader h = well.getHeader();
                out.write(well.getWellName() + delim + well.getWellCode() + delim + h.getCountry() + delim + h.getLatString(true) + delim + h.getLongString(true) + delim + h.getGeoDatum() + delim);
                for (Integer dType : this.dataTypes) {
                    if (SBdb.isInterpDataType(dType)) continue;
                    out.write(well.getDataMonitor(dType, this.units, 0).dbStatusString() + delim);
                }
                for (Component comp : this.jTabbedPane1.getComponents()) {
                    JPanelOrganiser panel;
                    if (!(comp instanceof JPanelOrganiser) || !(panel = (JPanelOrganiser)comp).hasInterp()) continue;
                    for (Integer dType : this.dataTypes) {
                        if (!SBdb.isInterpDataType(dType)) continue;
                        out.write(well.getDataMonitor(dType, this.units, panel.getInterpID()).dbStatusString() + delim);
                    }
                }
                out.write("\r\n");
            }
            JOptionPane.showMessageDialog(this, "File written.", this.getTitle(), 2);
        }
        catch (IOException | SQLException | SBException ex) {
            FrameJsbugs.showStackError("Error", (Exception)ex, this.db);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jMenuItemReadPaleoenvironmentIntervalsActionPerformed(ActionEvent evt) {
        if (!this.checkClear(true)) {
            return;
        }
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Excel or CSV file", "csv", "xls", "xlsx");
        File file = FileChooserUtils.chooseReadableFile((Component)this.parent, (FileNameExtensionFilter)filter, (File)this.prefsHelper.getLastPaleoImportFile());
        DialogPaleoImport dlg = new DialogPaleoImport(this, true, this.db);
        boolean fileLoaded = false;
        if (file != null) {
            try {
                dlg.loadFile(file);
                fileLoaded = true;
            }
            catch (IOException | GridReaderException ex) {
                StackError.showStackError((String)("An error occurred while reading the file " + file.getName() + "."), (Throwable)ex);
            }
        }
        if (fileLoaded) {
            dlg.pack();
            dlg.setLocationRelativeTo(this);
            dlg.setVisible(true);
            if (dlg.isOK()) {
                EnvScheme scheme = dlg.getSelectedPaleoScheme();
                PaleoWorkspaceImporter importer = new PaleoWorkspaceImporter();
                try {
                    if (dlg.selectedFormat() == DialogPaleoImport.ImportFormat.SamplePerLine) {
                        importer.addSampleRecords(this.ws, dlg.buildSampleImportRecords(), scheme, dlg.getUnits());
                    } else {
                        importer.addRangeRecords(this.ws, dlg.buildRangeImportRecords(), scheme, dlg.getUnits());
                    }
                    this.checkVersionPanels();
                    this.refreshView();
                    this.prefsHelper.setLastPaleoImportFile(dlg.getCurrentSelectedFile());
                    this.finishFileOpen();
                }
                catch (SQLException | SBException | SBPermissionException ex) {
                    String filename = "";
                    if (file != null) {
                        filename = file.getName();
                    }
                    FrameJsbugs.showStackError("An error occurred while trying to import the paleoenvironment data from the file " + filename + ".", (Exception)ex, this.db);
                }
            }
            dlg.dispose();
        }
    }

    private void jMenuItemOpenWellHeaderXLSActionPerformed(ActionEvent evt) {
        if (!this.checkClear(true)) {
            return;
        }
        this.setupXLSFileChooser();
        if (0 == this.jFileChooserXLS.showOpenDialog(this)) {
            this.openXLSFile(this.jFileChooserXLS.getSelectedFile(), 6);
        }
    }

    private void jMenuItemReportActionPerformed(ActionEvent evt) {
        try {
            List<Well> wells = this.getWorkspaceWells();
            if (wells.isEmpty()) {
                JOptionPane.showMessageDialog(this, "No wells loaded, generated report would be empty. Please load some wells into organiser to genreate a report.", "Report Generation", 1);
                return;
            }
            DialogOrganiserReport dlg = new DialogOrganiserReport(this, true, this.db, wells);
            dlg.setLocationRelativeTo(this);
            dlg.pack();
            dlg.setVisible(true);
            if (dlg.isOK()) {
                ReportGenerator generator = new ReportGenerator(this.db);
                generator.generateOrganiserReport(wells, dlg.getSelectedSettings(), this.db.getUser(), this.units);
                JOptionPane.showMessageDialog(this, "Report generated successfully.", "Report Generation", 1);
            }
            dlg.dispose();
        }
        catch (IOException | SQLException | SBException ex) {
            String msg = "Error occurred while generating organiser report";
            LOGGER.log(Level.SEVERE, msg, ex);
            SbugsExceptionHandler.showStackError(msg, ex);
        }
    }

    private void jMenuItemSampleSummaryExportActionPerformed(ActionEvent evt) {
        try {
            List<Well> wells = this.getWorkspaceWells();
            if (wells.isEmpty()) {
                JOptionPane.showMessageDialog(this, "No wells loaded, generated output would be empty. Please load some wells into organiser to write output.", "Sample Summary", 1);
                return;
            }
            DialogSampleDetailsExport dlg = new DialogSampleDetailsExport(this, true, this.db, this.units, wells, this.getSelectedInterpretation(), this.getOpenInterpretations());
            dlg.setLocationRelativeTo(this);
            dlg.pack();
            dlg.setVisible(true);
            if (dlg.isOK()) {
                File outputFile = dlg.getOutputFile();
                GridWriter gw = new GridWriter();
                if (FilePathUtils.isFileExtension((String)outputFile.getPath(), (String[])new String[]{"xls", "xlsx"})) {
                    gw.getXLSOptions().setSheetName("Sample summary");
                    gw.getXLSOptions().setAuthorName(this.db.getUser().getName());
                } else {
                    gw.setCSVOptions(dlg.getCSVSettings());
                }
                if (!FileOverwriteCheck.checkForGridFileOverwriting(this, (Component)this.parent, outputFile, gw)) {
                    return;
                }
                GridBuilderSampleDetails gb = new GridBuilderSampleDetails();
                gb.setIgnoreLogSamples(dlg.getIgnoreLogSamples());
                gb.setIncludeAnalysisData(dlg.getIncludeAnalysisData());
                Object[][] data = gb.buildSampleDetailsGrid(wells, dlg.getSelectedUnits(), dlg.getSelectedInterpId());
                gw.write(outputFile, data);
                JOptionPane.showMessageDialog(this, "File " + outputFile.getName() + " generated successfully.", "Sample Summary", 1);
            }
            dlg.dispose();
        }
        catch (Exception ex) {
            String msg = "Error occurred while exporting sample details file";
            LOGGER.log(Level.SEVERE, msg, ex);
            SbugsExceptionHandler.showStackError(msg, ex);
        }
    }

    private void jMenuItemReadWellLithologyActionPerformed(ActionEvent evt) {
        if (!this.checkClear(true)) {
            return;
        }
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Excel or CSV file", "csv", "xls", "xlsx");
        File file = FileChooserUtils.chooseReadableFile((Component)this.parent, (FileNameExtensionFilter)filter, (File)this.prefsHelper.getLastLithologyImportFile());
        if (file != null) {
            try {
                LinkedList<WsLithology> wsLiths = new LinkedList<WsLithology>();
                HashMap<WsWell, LinkedList<LithBase>> wells = new HashMap<WsWell, LinkedList<LithBase>>();
                LithologyImporter importer = new LithologyImporter(file, this.ws, this.db, wsLiths, wells);
                DialogMatchLithology dialog = new DialogMatchLithology(this, true, wsLiths, this.db);
                dialog.setLocationRelativeTo(this);
                dialog.setVisible(true);
                if (dialog.isOK) {
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    importer.addIntervals(wells);
                    this.setCursor(Cursor.getDefaultCursor());
                    this.refreshView();
                    if (!this.dataTypes.contains(21)) {
                        this.dataTypes.add(21);
                    }
                }
                this.prefsHelper.setLastLithologyImportFile(file);
                this.finishFileOpen();
            }
            catch (SQLException | SBException | GridReaderException ex) {
                SbugsExceptionHandler.showStackError("An error occurred while trying to import lithology from file " + file.getPath() + ".", ex, this);
            }
        }
    }

    private void jMenuItemGuidedExportBHPActionPerformed(ActionEvent evt) {
        if (!SbugsLicense.checkRLMlicense()) {
            JOptionPane.showMessageDialog(this, "StrataBugs licence no longer available.", "StrataBugs", 0);
            this.jMenuItemExitActionPerformed(null);
            return;
        }
        if (!this.checkClear(false)) {
            return;
        }
        if (!this.allowExport()) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.guidedExportBHP();
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
            this.inWizard = false;
        }
    }

    private void jMenuItemExportXLSInterpretedWorkbookActionPerformed(ActionEvent evt) {
        if (!SbugsLicense.checkRLMlicense()) {
            JOptionPane.showMessageDialog(this, "StrataBugs licence no longer available.", "StrataBugs", 0);
            this.jMenuItemExitActionPerformed(null);
            return;
        }
        if (!this.checkClear(false)) {
            return;
        }
        if (!this.allowExport()) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.exportXLSInterpretedDataWorkbook();
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
            this.inWizard = false;
        }
    }

    private void jMenuItemMultiWellFlatFileActionPerformed(ActionEvent evt) {
        if (!SbugsLicense.checkRLMlicense()) {
            JOptionPane.showMessageDialog(this, "StrataBugs licence no longer available.", "StrataBugs", 0);
            this.jMenuItemExitActionPerformed(null);
            return;
        }
        if (!this.checkClear(false)) {
            return;
        }
        if (!this.allowExport()) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.exportMultiWellFlatFile();
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
            this.inWizard = false;
        }
    }

    private void jMenuItemOpenEventsBSEEActionPerformed(ActionEvent evt) {
        if (!this.checkClear(true)) {
            return;
        }
        this.setupXLSFileChooser();
        if (0 == this.jFileChooserXLS.showOpenDialog(this)) {
            this.openXLSFile(this.jFileChooserXLS.getSelectedFile(), 7);
        }
    }

    private void jMenuItemExportProjectEventsActionPerformed(ActionEvent evt) {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            DialogExportProjectEvents dialog = new DialogExportProjectEvents((Frame)this, true, this.db);
            this.setCursor(Cursor.getDefaultCursor());
            if (dialog.initOK) {
                dialog.setLocationRelativeTo(this);
                dialog.setVisible(true);
            }
        }
        catch (SQLException | SBException ex) {
            StackError.showStackError((Exception)ex);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jMenuItemGuidedExportSPDCActionPerformed(ActionEvent evt) {
        if (!SbugsLicense.checkRLMlicense()) {
            JOptionPane.showMessageDialog(this, "StrataBugs licence no longer available.", "StrataBugs", 0);
            this.jMenuItemExitActionPerformed(null);
            return;
        }
        if (!this.checkClear(false)) {
            return;
        }
        if (!this.allowExport()) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.guidedExportSPDC();
        }
        catch (Exception e) {
            StackError.showStackError((String)"Error exporting: ", (Throwable)e);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
            this.inWizard = false;
        }
    }

    private void jMenuItemExportWordReportActionPerformed(ActionEvent evt) {
        if (!this.allowExport()) {
            return;
        }
        try {
            Component comp;
            if (this.ws.getUsers().isEmpty()) {
                this.jMenuItemLoadWorkspaceActionPerformed(null);
            }
            if (!((comp = this.jTabbedPane1.getSelectedComponent()) instanceof JPanelOrganiser)) {
                JOptionPane.showMessageDialog(this, "Select a well data panel to export", this.getTitle(), 2);
                return;
            }
            JPanelOrganiser panel = (JPanelOrganiser)comp;
            LinkedList<Well> wells = new LinkedList<Well>();
            Iterator<Well> it = this.ws.getWellIterator();
            while (it.hasNext()) {
                wells.add(it.next());
            }
            DialogExportWord dialog = new DialogExportWord(this, true, this.db, this.dataTypes, wells, panel.hdr == null ? this.db.getInterp(0) : panel.hdr, this.units);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }
        catch (SQLException sql) {
            StackError.showStackError((String)"SQL Error", (SQLException)sql);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void jMenuItemOpenEventsGoMActionPerformed(ActionEvent evt) {
        if (!this.checkClear(true)) {
            return;
        }
        this.setupXLSFileChooser();
        if (0 == this.jFileChooserXLS.showOpenDialog(this)) {
            this.openXLSFile(this.jFileChooserXLS.getSelectedFile(), 8);
        }
    }

    private void jMenuItemPDIActionPerformed(ActionEvent evt) {
        if (!this.checkClear(true)) {
            return;
        }
        JFileChooser fileChooser = new JFileChooser(new File("D:\\sbugs\\clients\\Data\\Paleo-Data\\"));
        fileChooser.setDialogType(0);
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Access database files (mdb, accdb)", "mdb", "accdb");
        fileChooser.setFileFilter(filter);
        fileChooser.setAcceptAllFileFilterUsed(false);
        if (fileChooser.showOpenDialog(this) == 0) {
            File accDB = fileChooser.getSelectedFile();
            if (!accDB.exists()) {
                LOGGER.log(Level.FINE, "Looking for: " + String.valueOf(accDB));
                JOptionPane.showMessageDialog(this, "Cannot find database in selected folder", this.getTitle(), 2);
                return;
            }
            try {
                PDIReader reader = new PDIReader(this.ws, this.dataTypes, accDB.getAbsolutePath());
                this.refreshView();
            }
            catch (Exception ex) {
                StackError.showStackError((String)ex.toString(), (Throwable)ex);
            }
        }
    }

    private void jMenuItemOpenBuakLithostratActionPerformed(ActionEvent evt) {
        if (!this.checkClear(true)) {
            return;
        }
        this.setupXLSFileChooser();
        if (0 == this.jFileChooserXLS.showOpenDialog(this)) {
            this.openXLSFile(this.jFileChooserXLS.getSelectedFile(), 9);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jMenuItemEPaleoActionPerformed(ActionEvent evt) {
        if (!this.checkClear(true)) {
            return;
        }
        this.setupCSVFileChooser();
        try {
            if (0 == this.jFileChooserCSV.showOpenDialog(this)) {
                Lastval.putString(this.db, "WINCSVFILE", "UNXCSVFILE", this.jFileChooserCSV.getSelectedFile().getPath());
                this.db.commit();
                this.dataTypes.clear();
                DialogList<EnvScheme> dialog = new DialogList<EnvScheme>(this, true, "Select environment scheme", new UserPrefsHelper(this.db), this.db.getEnvSchemes(), true, false);
                dialog.setLocationRelativeTo(this);
                dialog.setVisible(true);
                if (dialog.getSelection() != null) {
                    WellEPaleoReader reader = new WellEPaleoReader(this.ws, this.jFileChooserCSV.getSelectedFile(), 'F', this.dataTypes, dialog.getSelection());
                    for (InterpHdr interp : reader.interpMap.values()) {
                        this.viewVersion(interp);
                    }
                }
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (Exception ex) {
            StackError.showStackError((String)"Error during file read", (Throwable)ex);
            ex.printStackTrace();
        }
        finally {
            try {
                this.refreshView();
            }
            catch (Exception e) {
                StackError.showStackError((String)"Error", (Throwable)e);
            }
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jMenuItemOpenBugWareDictionaryActionPerformed(ActionEvent evt) {
        File bugFile = SbugsIO.chooseFileToOpen(this.db, this, "WINBUGWDIC", "BugWare dictionaries", "mas");
        if (bugFile == null) {
            return;
        }
        try {
            if (this.ws.getTaxa().size() > 0) {
                if (JOptionPane.showConfirmDialog(this, "There are data in the workspace which will be discarded.\nDo you want to continue?", "Confirm", 0, 3) == 1) {
                    return;
                }
                this.ws = new SBdb(this.db);
            }
            HashMap<Integer, String> dicts = this.db.getSIPMDicts();
            LinkedList<String> dictString = new LinkedList<String>(dicts.values());
            DialogList<String> dialogList = new DialogList<String>(this, true, "Select Dictionary", new UserPrefsHelper(this.db), dictString, true, false);
            dialogList.setLocationRelativeTo(this);
            dialogList.setVisible(true);
            if (dialogList.getSelection() == null) {
                return;
            }
            int dictID = -1;
            for (Map.Entry<Integer, String> entry : dicts.entrySet()) {
                if (!entry.getValue().equals(dialogList.getSelection())) continue;
                dictID = entry.getKey();
                break;
            }
            if (dictID < 0) {
                throw new SBException("Dictionary ID is invalid");
            }
            HashMap<Taxon, Integer> numericCodes = this.ws.parseBugWareDictionary(bugFile, this.db.getCategoryService());
            DialogMatchTaxa dialogMatchTaxa = new DialogMatchTaxa(this, true, this.ws, this.wsCM, this.db, true);
            SB.centreDialog((Dialog)dialogMatchTaxa);
            dialogMatchTaxa.setVisible(true);
            if (!dialogMatchTaxa.isOK()) {
                return;
            }
            HashMap<Integer, Integer> existingDictEntries = this.db.getSipmDictEntries(dictID, true);
            if (existingDictEntries.size() > 0 && JOptionPane.showConfirmDialog(this, "Warning: you will be changing numeric codes for " + existingDictEntries.size() + " dictionary entries.\nDo you want to continue?", "Confirm Overwrite", 0, 3) == 1) {
                return;
            }
            this.db.clearSipmDict(dictID);
            int nCodesUpdated = 0;
            for (Taxon taxon : this.ws.getTaxa()) {
                if (taxon.getLink() == null) continue;
                taxon.getLink().storeSipmCode(dictID, numericCodes.get(taxon));
                ++nCodesUpdated;
            }
            if (nCodesUpdated > 0) {
                if (JOptionPane.showConfirmDialog(this, nCodesUpdated + " codes updated. Commit?", "Confirm Commit", 0, 3) == 1) {
                    this.db.doRollback();
                    return;
                }
                this.db.commit();
            }
        }
        catch (IOException | SQLException | SBException | SBPermissionException ex) {
            SbugsExceptionHandler.showStackError("Error loading dictionary file", ex);
        }
    }

    private void jMenuItemExportJSONActionPerformed(ActionEvent evt) {
        if (!SbugsLicense.checkRLMlicense()) {
            JOptionPane.showMessageDialog(this, "StrataBugs licence no longer available.", "StrataBugs", 0);
            this.jMenuItemExitActionPerformed(null);
            return;
        }
        if (!this.checkClear(false)) {
            return;
        }
        if (!this.allowExport()) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.guidedExportJSON();
        }
        catch (Exception e) {
            StackError.showStackError((String)"Error exporting: ", (Throwable)e);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
            this.inWizard = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jMenuItemOpenAnnotationFilesActionPerformed(ActionEvent evt) {
        int result;
        if (!this.checkClear(true)) {
            return;
        }
        String prefDir = Lastval.tryGetString(this.db, "SLIDEANNODIR");
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(1);
        if (prefDir != null) {
            fc.setCurrentDirectory(new File(prefDir));
        }
        if ((result = fc.showOpenDialog(this.parent)) == 0) {
            File wellDir = fc.getSelectedFile();
            Lastval.tryPutString(this.db, "SLIDEANNODIR", wellDir.getPath());
            try {
                AnnotationReader r = new AnnotationReader(this.ws, wellDir);
                this.dataTypes.clear();
                if (!r.getWell().getSamples().isEmpty()) {
                    this.dataTypes.add(1);
                }
                for (AnalystHeader h : r.getWell().getAnalystHeaders()) {
                    this.dataTypes.add(switch (h.getDiscipline()) {
                        default -> throw new MatchException(null, null);
                        case Discipline.MICRO -> 2;
                        case Discipline.MACRO -> 8;
                        case Discipline.PALY -> 6;
                        case Discipline.NANNO -> 4;
                    });
                }
                r.getWell().loadInterps();
                r.getWell().updateStatus(this.dataTypes);
            }
            catch (IOException | SQLException | SBException | SBPermissionException | GridReaderException e) {
                SbugsExceptionHandler.showStackError("Error reading files", e);
            }
            finally {
                this.refreshView();
                this.finishFileOpen();
            }
        }
    }

    private void jMenuItemOpenXLSOWPetrelActionPerformed(ActionEvent evt) {
        if (!this.checkClear(true)) {
            return;
        }
        this.setupXLSFileChooser();
        if (0 == this.jFileChooserXLS.showOpenDialog(this)) {
            this.openXLSFile(this.jFileChooserXLS.getSelectedFile(), 10);
        }
    }

    private void guidedExportSPDC() throws SQLException, SBException {
        this.inWizard = true;
        this.selectWellsByProjectOrSelectorAndLoadIntoWS();
        if (!this.inWizard) {
            return;
        }
        LinkedHashSet<Integer> exporterDataTypes = new LinkedHashSet<Integer>();
        exporterDataTypes.add(10);
        exporterDataTypes.add(14);
        exporterDataTypes.add(11);
        exporterDataTypes.add(15);
        this.dataTypes.clear();
        this.dataTypes.addAll(exporterDataTypes);
        this.slectAndLoadInterpForExportWells();
        if (!this.inWizard) {
            return;
        }
        this.exporter.writeSPDCSummaryWorkbooks(this.getWorkspaceWells(), this.getSelectedInterpretation().getInterpID(), exporterDataTypes);
    }

    private void guidedExportBHP() {
        this.inWizard = true;
        this.selectWellsByProjectOrSelectorAndLoadIntoWS();
        if (!this.inWizard) {
            return;
        }
        this.dataTypes.clear();
        this.dataTypes.add(16);
        this.dataTypes.add(11);
        this.dataTypes.add(10);
        this.slectAndLoadInterpForExportWells();
        if (!this.inWizard) {
            return;
        }
        this.exporter.writeBHPSummaryWorkbook(this.getWorkspaceWells(), this.getSelectedInterpretation().getInterpID(), this.dataTypes);
    }

    private void guidedExportJSON() {
        this.inWizard = true;
        this.selectWellsByProjectOrSelectorAndLoadIntoWS();
        if (!this.inWizard) {
            return;
        }
        this.dataTypes.clear();
        this.dataTypes.add(10);
        this.dataTypes.add(12);
        this.dataTypes.add(15);
        this.dataTypes.add(16);
        this.slectAndLoadInterpForExportWells();
        if (!this.inWizard) {
            return;
        }
        this.exporter.writeJSON(this.getWorkspaceWells(), this.getSelectedInterpretation().getInterpID(), this.dataTypes);
    }

    private void exportXLSInterpretedDataWorkbook() {
        this.inWizard = true;
        this.selectWellsByProjectOrSelectorAndLoadIntoWS();
        if (!this.inWizard) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.dataTypes.clear();
        this.dataTypes.add(16);
        this.dataTypes.add(12);
        this.dataTypes.add(14);
        this.dataTypes.add(11);
        this.dataTypes.add(10);
        this.dataTypes.add(18);
        this.dataTypes.add(9);
        this.dataTypes.add(3);
        this.dataTypes.add(5);
        this.dataTypes.add(7);
        this.slectAndLoadInterpForExportWells();
        if (!this.inWizard) {
            return;
        }
        this.exporter.writeIGDXLSWorkbook(this.getWorkspaceWells(), this.getSelectedInterpretation().getInterpID());
    }

    private void exportMultiWellFlatFile() {
        this.inWizard = true;
        this.project = null;
        this.selectWellsByProjectOrSelectorAndLoadIntoWS();
        if (!this.inWizard) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.dataTypes.clear();
        this.dataTypes.add(1);
        this.dataTypes.add(8);
        this.dataTypes.add(4);
        this.dataTypes.add(6);
        this.dataTypes.add(2);
        this.jMenuItemLoadWorkspaceActionPerformed(null);
        if (!this.inWizard) {
            return;
        }
        String projectName = null;
        if (this.project != null) {
            projectName = this.project.getName();
        }
        this.exporter.writeMultiWellFlatFile(this.getWorkspaceWells(), projectName);
    }

    private void selectWellsByProjectOrSelectorAndLoadIntoWS() {
        boolean selectByProject = false;
        try {
            if (this.db.getnProjects() > 1) {
                DialogWellProjectSelection dialog = new DialogWellProjectSelection(this, true);
                dialog.setLocationRelativeTo(this);
                dialog.setVisible(true);
                if (!dialog.isOK()) {
                    this.inWizard = false;
                    return;
                }
                selectByProject = dialog.selectByProject;
            }
        }
        catch (Exception se) {
            StackError.showStackError((String)se.toString(), (Throwable)se);
            this.inWizard = false;
            return;
        }
        if (selectByProject) {
            this.project = null;
            this.jButtonOpenProjectActionPerformed(null);
            if (this.project == null) {
                this.inWizard = false;
            }
        } else {
            this.jButtonOpenWellsActionPerformed(null);
        }
    }

    private void slectAndLoadInterpForExportWells() {
        if (this.hasIGDDataTypes()) {
            try {
                if (this.doCurrentWellsHaveNonDefaultInterp()) {
                    List<InterpHdr> exportInterps = this.getExportInterpsViaDialog();
                    if (exportInterps != null) {
                        this.removeAllInterpTabs();
                        this.openInterpTabs(exportInterps.toArray(new InterpHdr[exportInterps.size()]));
                    } else {
                        this.inWizard = false;
                    }
                } else {
                    this.openInterpTabs(this.db.getInterp(0));
                }
            }
            catch (Exception e) {
                this.inWizard = false;
                StackError.showStackError((String)"Error showing version selector: ", (Throwable)e);
            }
            if (!this.inWizard) {
                return;
            }
        }
        this.jMenuItemLoadWorkspaceActionPerformed(null);
    }

    private boolean doCurrentWellsHaveNonDefaultInterp() {
        boolean found = false;
        block2: for (Component comp : this.jTabbedPane1.getComponents()) {
            if (!(comp instanceof JPanelOrganiser)) continue;
            JPanelOrganiser panel = (JPanelOrganiser)comp;
            for (WsWell well : panel.model.wsWells) {
                Iterator<WellInterp> it;
                if (well.getLink() != null) {
                    try {
                        well.getLink().loadInterps();
                    }
                    catch (SQLException | SBException ex) {
                        SbugsExceptionHandler.showStackError("Error loading interps", ex);
                    }
                }
                if (!(it = well.getLink().getInterpIterator()).hasNext()) continue;
                it.next();
                if (!it.hasNext()) continue;
                found = true;
                break block2;
            }
        }
        return found;
    }

    private void removeAllInterpTabs() {
        LinkedList<Component> toRemove = new LinkedList<Component>();
        for (Component comp : this.jTabbedPane1.getComponents()) {
            JPanelOrganiser p;
            if (!(comp instanceof JPanelOrganiser) || !(p = (JPanelOrganiser)comp).hasInterp()) continue;
            toRemove.add(comp);
        }
        for (Component comp : toRemove) {
            this.jTabbedPane1.remove(comp);
        }
    }

    private List<InterpHdr> getExportInterpsViaDialog() throws SQLException {
        DialogSelectVersion dialog = new DialogSelectVersion(this, true, this.db, true, this.ws.getWellIterator());
        dialog.setLocationRelativeTo(this);
        dialog.setTitle("Select Version to Export");
        dialog.setVisible(true);
        return dialog.selection;
    }

    private void openInterpTabs(InterpHdr ... headers) throws SQLException, SBException {
        for (InterpHdr hdr : headers) {
            hdr = this.ws.fillInterp(hdr);
            JPanelOrganiser panel = new JPanelOrganiser(this, this.ws, this.db, hdr);
            this.jTabbedPane1.add(panel);
            panel.refreshView(true);
            this.jTabbedPane1.setSelectedComponent(panel);
        }
    }

    private Set<InterpHdr> getOpenInterpretations() {
        HashSet<InterpHdr> interpHeaders = new HashSet<InterpHdr>();
        for (int i = 0; i < this.jTabbedPane1.getTabCount(); ++i) {
            Component c = this.jTabbedPane1.getComponent(i);
            if (!(c instanceof JPanelOrganiser)) continue;
            JPanelOrganiser p = (JPanelOrganiser)c;
            if (p.hdr == null) continue;
            interpHeaders.add(p.hdr);
        }
        return interpHeaders;
    }

    private InterpHdr getSelectedInterpretation() {
        Component comp = this.jTabbedPane1.getSelectedComponent();
        if (!(comp instanceof JPanelOrganiser)) {
            return null;
        }
        JPanelOrganiser panel = (JPanelOrganiser)comp;
        return panel.hdr;
    }

    private List<Well> getWorkspaceWells() {
        ArrayList<Well> wells = new ArrayList<Well>();
        Iterator<Well> it = this.ws.getWellIterator();
        while (it.hasNext()) {
            wells.add(it.next());
        }
        return wells;
    }

    void matchGenera() {
        if (this.ws.getIndependentGenera().isEmpty()) {
            JOptionPane.showMessageDialog(this, "There are no independent genera in the workspace.", this.getTitle(), 2);
            return;
        }
        DialogMatchGenera dialogMatchGenera = new DialogMatchGenera(this, true, this.ws, this.db, this.inWizard);
        SB.centreDialog((Dialog)((Object)dialogMatchGenera));
        dialogMatchGenera.setVisible(true);
        if (!dialogMatchGenera.isOK()) {
            this.inWizard = false;
        }
        if (!this.inWizard) {
            this.refreshView(Genus.class);
        }
    }

    void matchCmpStd(CompositeStandard cmpStd) {
        try {
            for (CompositeStandardEvent ev : cmpStd.getEvents(false)) {
                if (ev.getEvent().getLink() != null) continue;
                JOptionPane.showMessageDialog(this, "You must match events first.", "Match Composite Standard", 2);
                return;
            }
            DialogMatchCmpStd dialog = new DialogMatchCmpStd(this, true, cmpStd, this.db, this.inWizard);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (!dialog.isOK()) {
                this.inWizard = false;
            }
        }
        catch (SQLException | SBException sql) {
            FrameJsbugs.showStackError("Error", (Exception)sql, this.db);
        }
        if (!this.inWizard) {
            this.refreshView(CompositeStandard.class);
        }
    }

    private int getProjID() {
        return this.jComboBoxProject.getSelectedItem() instanceof Project ? ((Project)((Object)this.jComboBoxProject.getSelectedItem())).getID() : 0;
    }

    void matchTxGroup(TxGroup group) {
        try {
            for (Taxon taxon : this.ws.getTxGroupTaxa(group)) {
                if (taxon.getLink() != null) continue;
                JOptionPane.showMessageDialog(this, "You must match all taxa from this group first.", "Match Group", 2);
                return;
            }
            for (Genus genus : this.ws.getTxGroupGenera(group)) {
                if (genus.getLink() != null) continue;
                JOptionPane.showMessageDialog(this, "You must match all genera from this group first.", "Match Group", 2);
                return;
            }
            DialogMatchTxGroup dialog = new DialogMatchTxGroup(this, true, group, this.db, this.getProjID(), this.inWizard);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (!dialog.isOK()) {
                this.inWizard = false;
            }
        }
        catch (SQLException | SBException sql) {
            FrameJsbugs.showStackError("Error", (Exception)sql, this.db);
        }
        if (!this.inWizard) {
            this.refreshView(TxGroup.class);
        }
    }

    void matchTxGroupSet(TxGroupSet txGroupSet) {
        try {
            DialogMatchTxGroupSet dialog = new DialogMatchTxGroupSet(this, true, this.inWizard, this.ws, this.db, txGroupSet, this.getProjID());
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (!dialog.isOK()) {
                this.inWizard = false;
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        if (!this.inWizard) {
            this.refreshView(TxGroupSet.class);
        }
    }

    void setUnits() {
        char newUnits = this.jRadioButtonMenuItemMetres.isSelected() ? (char)'M' : (this.jRadioButtonMenuItemFeet.isSelected() ? (char)'F' : 'D');
        if (newUnits != this.units) {
            for (Component comp : this.jTabbedPane1.getComponents()) {
                if (!(comp instanceof JPanelOrganiser)) continue;
                JPanelOrganiser panel = (JPanelOrganiser)comp;
                panel.setUnits(newUnits);
            }
            this.units = newUnits;
            this.refreshView();
        }
    }

    boolean checkClear(boolean queryMoreSources) {
        try {
            if (this.isSavingData) {
                JOptionPane.showMessageDialog(this, "Please wait until data saving operation has completed", this.getTitle(), 2);
                return false;
            }
            if (this.ws.getnLoadedWells() > 0 || this.wsCM != null && this.wsCM.hasDataLoaded()) {
                int option2;
                int option = JOptionPane.showConfirmDialog(this, "Clear data from workspace?", this.getTitle(), 1, 3);
                if (option == 2 || option == -1 || option == 1 && !queryMoreSources) {
                    return false;
                }
                if (queryMoreSources && option == 1 && (option2 = JOptionPane.showConfirmDialog(this, "You must ONLY add data from the same data source, or the results will be unpredictable.\nAre you sure you want to continue?", this.getTitle(), 0, 3)) != 0) {
                    return false;
                }
                if (option == 0) {
                    Iterator<Well> it = this.ws.getWellIterator();
                    while (it.hasNext()) {
                        WsWell well = (WsWell)it.next();
                        if (well.getLink() == null) continue;
                        for (Component comp : this.jTabbedPane1.getComponents()) {
                            if (!(comp instanceof JPanelOrganiser)) continue;
                            JPanelOrganiser panel = (JPanelOrganiser)comp;
                            well.getLink().deleteObserver(panel);
                            if (panel.hdr == null) continue;
                            well.getAddInterp(panel.hdr).deleteObserver(panel);
                        }
                    }
                    this.initNewWorkspace();
                    this.refreshView();
                }
            } else {
                this.initNewWorkspace();
            }
            this.project = null;
            return true;
        }
        catch (RuntimeException | SQLException e) {
            SbugsExceptionHandler.showStackError(e, this);
            return false;
        }
    }

    private boolean hasFssDataTypes() {
        for (Integer columnType : this.dataTypes) {
            switch (columnType) {
                case 2: 
                case 4: 
                case 6: 
                case 8: {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean hasIGDZoneDataTypes() {
        for (Integer columnType : this.dataTypes) {
            switch (columnType) {
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean hasEnvDataType() {
        for (Integer columnType : this.dataTypes) {
            switch (columnType) {
                case 2: 
                case 4: 
                case 6: 
                case 8: 
                case 15: {
                    return true;
                }
            }
        }
        return false;
    }

    boolean hasCommentDataTypes() {
        for (Integer columnType : this.dataTypes) {
            switch (columnType) {
                case 3: 
                case 5: 
                case 7: 
                case 9: {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean hasIGDDataTypes() {
        for (Integer columnType : this.dataTypes) {
            try {
                if (!SBdb.isInterpDataType(columnType)) continue;
                return true;
            }
            catch (SBException sbe) {
                StackError.showStackError((String)"Error", (Throwable)sbe);
            }
        }
        return false;
    }

    void export() {
        if (!SbugsLicense.checkRLMlicense()) {
            JOptionPane.showMessageDialog(this, "StrataBugs licence no longer available.", "StrataBugs", 0);
            this.jMenuItemExitActionPerformed(null);
            return;
        }
        if (!this.checkClear(false)) {
            return;
        }
        if (!this.allowExport()) {
            return;
        }
        this.inWizard = true;
        Well.resetQueryDuplicateSamples();
        boolean selectByProject = false;
        try {
            if (this.db.getnProjects() > 1) {
                DialogWellProjectSelection dialog = new DialogWellProjectSelection(this, true);
                dialog.setLocationRelativeTo(this);
                dialog.setVisible(true);
                if (!dialog.isOK()) {
                    this.inWizard = false;
                    return;
                }
                selectByProject = dialog.selectByProject;
            }
        }
        catch (Exception se) {
            StackError.showStackError((String)se.toString(), (Throwable)se);
            this.inWizard = false;
            return;
        }
        if (selectByProject) {
            this.jButtonOpenProjectActionPerformed(null);
        } else {
            this.jButtonOpenWellsActionPerformed(null);
        }
        if (!this.inWizard) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.jMenuItemDataTypesActionPerformed(null);
        if (!this.inWizard) {
            this.setCursor(Cursor.getDefaultCursor());
            return;
        }
        if (this.hasIGDDataTypes()) {
            boolean found = false;
            block6: for (Component comp : this.jTabbedPane1.getComponents()) {
                if (!(comp instanceof JPanelOrganiser)) continue;
                JPanelOrganiser panel = (JPanelOrganiser)comp;
                for (WsWell well : panel.model.wsWells) {
                    Iterator<WellInterp> it;
                    if (well.getLink() != null) {
                        try {
                            well.getLink().loadInterps();
                        }
                        catch (SQLException | SBException ex) {
                            SbugsExceptionHandler.showStackError("Error loading interps", ex);
                        }
                    }
                    if (!(it = well.getLink().getInterpIterator()).hasNext()) continue;
                    it.next();
                    if (!it.hasNext()) continue;
                    found = true;
                    break block6;
                }
            }
            try {
                if (found) {
                    DialogSelectVersion dialog = new DialogSelectVersion(this, true, this.db, false, this.ws.getWellIterator());
                    dialog.setLocationRelativeTo(this);
                    dialog.setTitle("Select Version(s) to Export");
                    dialog.setVisible(true);
                    if (dialog.selection != null) {
                        LinkedList<Component> toRemove = new LinkedList<Component>();
                        for (Component comp : this.jTabbedPane1.getComponents()) {
                            JPanelOrganiser p;
                            if (!(comp instanceof JPanelOrganiser) || !(p = (JPanelOrganiser)comp).hasInterp()) continue;
                            toRemove.add(comp);
                        }
                        for (Component comp : toRemove) {
                            this.jTabbedPane1.remove(comp);
                        }
                        for (InterpHdr hdr : dialog.selection) {
                            LOGGER.log(Level.INFO, "Filling workspace interp: " + hdr.toString());
                            hdr = this.ws.fillInterp(hdr);
                            JPanelOrganiser panel = new JPanelOrganiser(this, this.ws, this.db, hdr);
                            this.jTabbedPane1.add(panel);
                            panel.refreshView(true);
                        }
                    } else {
                        this.inWizard = false;
                    }
                } else {
                    JPanelOrganiser panel = new JPanelOrganiser(this, this.ws, this.db, this.db.getInterp(0));
                    this.jTabbedPane1.add(panel);
                    panel.refreshView(true);
                }
            }
            catch (Exception e) {
                this.inWizard = false;
                StackError.showStackError((String)"Error showing version selector: ", (Throwable)e);
            }
            if (!this.inWizard) {
                this.setCursor(Cursor.getDefaultCursor());
                return;
            }
        }
        this.jMenuItemLoadWorkspaceActionPerformed(null);
        Well.resetQueryDuplicateSamples();
        if (!this.inWizard) {
            this.setCursor(Cursor.getDefaultCursor());
            return;
        }
        this.jButtonSaveToFileActionPerformed(null);
        this.setCursor(Cursor.getDefaultCursor());
        this.inWizard = false;
    }

    private void initNewWorkspace() throws SQLException {
        this.ws = new SBdb(this.db);
        this.ws.setImageLoader(this.db.getImageLoader());
        this.wsCM = null;
        this.jTabbedPane1.removeAll();
        this.jTabbedPane1.addTab(DICT_TAB_NAME, new JPanelOrganiserDict(this, false));
        this.jTabbedPane1.addTab(CHART_TAB_NAME, new JPanelOrganiserDict(this, true));
        JPanelOrganiser panel = new JPanelOrganiser(this, this.ws, this.db, null);
        this.jTabbedPane1.add(panel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean openZipArchive(File file) {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            LinkedList<SBException> exceptions = new LinkedList<SBException>();
            Logger logger = Logger.getLogger(FrameOrganiser.class.getName() + " XML File Read");
            this.wsCM = SbugsIO.parseFile(file, this.parent, this.ws, 0, this.dataTypes, exceptions);
            if (!exceptions.isEmpty()) {
                Object msg = "The following errors were found while reading the file ...";
                int exCount = 0;
                for (SBException sb : exceptions) {
                    if (++exCount < 20) {
                        msg = (String)msg + "\n" + sb.getMessage();
                    }
                    logger.log(Level.WARNING, sb.getMessage(), sb);
                }
                JOptionPane.showMessageDialog(this, msg, this.getTitle(), 2);
            }
            this.checkVersionPanels();
            this.refreshView();
            this.finishFileOpen();
            boolean bl = true;
            return bl;
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (IOException | ParseException ioe) {
            StackError.showStackError((String)("Error opening or parsing file: " + file.getPath() + " - check write access to: " + System.getProperty("java.io.tmpdir")), (Throwable)ioe);
        }
        catch (SBException sbe) {
            StackError.showStackError((String)"Error", (Throwable)sbe);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
        return false;
    }

    private void exportDEX(File file) {
        Object msg = "";
        if (this.dataTypes.contains(14)) {
            msg = (String)msg + "Sequence picks";
        }
        if (this.dataTypes.contains(16)) {
            if (!((String)msg).isEmpty()) {
                msg = (String)msg + " and ";
            }
            msg = (String)msg + "Events";
        }
        if (this.dataTypes.contains(26)) {
            if (!((String)msg).isEmpty()) {
                msg = (String)msg + " and ";
            }
            msg = (String)msg + "Two way time";
        }
        if (JOptionPane.showConfirmDialog(this, (String)(msg = !((String)msg).isEmpty() ? (String)msg + " cannot be exported to DEX and will be ignored. Please use SBG (xml) format." : (String)msg + "The DEX format has been superceded by the SBG format. Please only use DEX to export to v1.8 or earlier.") + "\nContinue?", this.getTitle(), 0, 2) == 1) {
            return;
        }
        try {
            if (!file.getName().toLowerCase().endsWith("dex")) {
                file = new File(file.getPath() + ".dex");
            }
            try (FileWriter out = new FileWriter(file);){
                int interpID = 0;
                if (this.inWizard) {
                    HashSet<Integer> interpIDs = new HashSet<Integer>();
                    for (int i = 0; i < this.jTabbedPane1.getTabCount(); ++i) {
                        Component tab = this.jTabbedPane1.getComponentAt(i);
                        if (!(tab instanceof JPanelOrganiser) || ((JPanelOrganiser)tab).getInterpID() <= -1) continue;
                        interpIDs.add(((JPanelOrganiser)tab).getInterpID());
                    }
                    if (interpIDs.size() > 1) {
                        String msg2 = "DEX file can only write one version. Please select a version to export.";
                        JOptionPane.showMessageDialog(this, msg2, this.getTitle(), 0);
                        DialogSelectVersion dialog = new DialogSelectVersion(this, true, this.ws, true, this.ws.getWellIterator());
                        dialog.setLocationRelativeTo(this);
                        dialog.setVisible(true);
                        if (dialog.selection == null) {
                            this.inWizard = false;
                            return;
                        }
                        interpID = dialog.selection.get(0).getInterpID();
                    }
                } else if (this.jTabbedPane1.getSelectedComponent() instanceof JPanelOrganiser) {
                    JPanelOrganiser panel = (JPanelOrganiser)this.jTabbedPane1.getSelectedComponent();
                    interpID = panel.getInterpID();
                }
                DEXFile dexFile = new DEXFile(out, this.ws, this.db, this.dataTypes, this.units, interpID, false, 0);
                out.flush();
            }
            Lastval.putString(this.db, "WINDEXFILE", "UNXDEXFILE", file.getPath());
            JOptionPane.showMessageDialog(this, "File : '" + file.getPath() + "' written", "Write DEX", 1);
            this.db.commit();
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this, "File error: " + ex.getMessage());
        }
        catch (SBException ex) {
            JOptionPane.showMessageDialog(this, "SB Error : " + ex.getMessage(), "SB Error", 0);
        }
        catch (SQLException ex) {
            JOptionPane.showMessageDialog(this, "SQL Error : " + ex.getMessage(), "SQL Error", 0);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private boolean checkCSVexport() {
        for (int dType : this.dataTypes) {
            switch (dType) {
                case 2: 
                case 4: 
                case 6: 
                case 8: {
                    String suppMsg = "\n(Use File | Export other | Multi-well Analyses, Or Save As... from the Analyses tab in Samples & Interpretations)";
                    String msg = "Sorry, data type " + SBdb.dTypeNames[dType] + " is not currently supported";
                    JOptionPane.showMessageDialog(this, msg + suppMsg, "Data type not supported", 2);
                    return false;
                }
            }
        }
        return true;
    }

    private void viewVersion(InterpHdr hdr) throws SQLException, SBException {
        boolean toAdd = true;
        for (Component comp : this.jTabbedPane1.getComponents()) {
            if (!(comp instanceof JPanelOrganiser)) continue;
            JPanelOrganiser panel = (JPanelOrganiser)comp;
            if (panel.hdr == null || panel.hdr.getLink() != hdr) continue;
            JOptionPane.showMessageDialog(this, "Selected version: " + String.valueOf(hdr) + " is already displayed", this.getTitle(), 2);
            this.jTabbedPane1.setSelectedComponent(comp);
            toAdd = false;
            break;
        }
        if (toAdd) {
            hdr = this.ws.fillInterp(hdr);
            JPanelOrganiser panel = new JPanelOrganiser(this, this.ws, this.db, hdr);
            this.jTabbedPane1.add(panel);
            panel.refreshView(true);
            this.jTabbedPane1.setSelectedComponent(panel);
        }
    }
}

