/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.well.analysis.hdr.AbundanceScheme;
import com.stratadata.sblicense.SbugsLicense;
import com.stratadata.util.depth.DepthUnits;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.geom.Point2D;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jsbchart.block.BlockType;
import jsbchart.block.ChartBlockBase;
import jsbchart.block.SchemeBlock;
import jsbchart.core.BlockTemplate;
import jsbchart.core.Chart;
import jsbchart.core.ChartFactory;
import jsbchart.core.ChartProperties;
import jsbchart.core.ChartPropertiesFactory;
import jsbchart.core.ChartTemplate;
import jsbchart.core.ChartTemplateBase;
import jsbchart.core.PanelTemplate;
import jsbchart.panel.ChartPanel;
import jsbchart.panel.PanelFactory;
import jsbchart.panel.PanelIntLith;
import jsbchart.panel.PanelType;
import jsbchart.panel.SBPanel;
import jsbugs.ChartExporter;
import jsbugs.ChartJPanel;
import jsbugs.DialogChartTemplates;
import jsbugs.DialogList;
import jsbugs.DialogLithPalette;
import jsbugs.DialogOverlay;
import jsbugs.DialogParseSample;
import jsbugs.DialogPicklistHighlight;
import jsbugs.DialogPrintPreview;
import jsbugs.DialogSelectProjectWellList;
import jsbugs.DialogTableOptions;
import jsbugs.DialogTaxonCodeInput;
import jsbugs.DialogTaxonWellOccFiltered;
import jsbugs.DialogWellDisc;
import jsbugs.FrameJsbugs;
import jsbugs.FrameOverlay;
import jsbugs.FrameWellChartsDetached;
import jsbugs.FrameWellDetached;
import jsbugs.ITaxonSelectionChangedListener;
import jsbugs.JPanelCharts;
import jsbugs.JPanelPicklist;
import jsbugs.JPanelWell;
import jsbugs.JTabbedPaneWell;
import jsbugs.LoggingSheet;
import jsbugs.PrintJPanel;
import jsbugs.TableModelOccurrences;
import jsbugs.TableModelSB;
import jsbugs.TablePair;
import jsbugs.abnsch.DialogAbnSchemes;
import jsbugs.chart.DialogChartProperties;
import jsbugs.chart.component.JScrollPaneChartBase;
import jsbugs.samplesandinterps.TabView;
import jsbugs.uiutil.icon.IconFactory;
import jsbugs.userconnect.SbugsExceptionHandler;
import jsbugs.userconnect.SbugsSession;
import jsbugs.util.SBFrame;
import jsbugs.util.UserPrefsHelper;
import jsbugs.wellheader.DialogSelectWell;
import model3.AnalystHeader;
import model3.Biocom;
import model3.CompositeStandard;
import model3.CompositeStandardEvent;
import model3.IGDScheme;
import model3.IGDUnitBase;
import model3.InterpHdr;
import model3.Lastval;
import model3.SBRestrictable;
import model3.SBdb;
import model3.Sample;
import model3.Smpdtl;
import model3.Surface;
import model3.SynonymScheme;
import model3.Taxon;
import model3.TxGroup;
import model3.Well;
import model3.WellHeader;
import model3.WellInterp;
import model3.project.WellList;
import org.jdesktop.layout.GroupLayout;
import util.SB;
import util.SBException;
import util.SBPermissionException;
import util.exception.StackError;

public class FrameSamples
extends SBFrame {
    final SBdb sbdb;
    final FrameJsbugs parent;
    private final ChartJPanel schemeChartJPanel = new ChartJPanel(new Chart());
    private final List<JPanelPicklist> picklists = new LinkedList<JPanelPicklist>();
    static final int PICKLIST_LIMIT = 10;
    List<FrameWellDetached> wellFrames = new LinkedList<FrameWellDetached>();
    HashSet<FrameWellChartsDetached> chartsFrames = new HashSet();
    DialogTaxonCodeInput dialogTaxonCodeInput = null;
    private JTabbedPaneWell jTabbedPaneWell;
    private final ResourceBundle resources = ResourceBundle.getBundle("locale/UiText");
    boolean overlayWindowOnTop = false;
    private static final String SCH_BLK_LOC_FIELD = "SAMP";
    private static final String[] FRAME_ICONS = new String[]{"48Samples.png", "32Samples.png", "24Samples.png", "16Samples.png"};
    private UserPrefsHelper prefs;
    private boolean restrictPicklistToSelectedSamples;
    boolean deriveCvRw = false;
    boolean showOccPopup = false;
    private static final Logger LOGGER = Logger.getLogger(FrameSamples.class.getName());
    boolean schemeChartInit = true;
    PicklistHighlighting picklistHighlighting = null;
    private int picklistTotaliser = 0;
    private int synSchID = 0;
    private Clip soundClip;
    private AudioInputStream audioStream = null;
    private ButtonGroup buttonGroupBiocommTaxaOptions;
    private ButtonGroup buttonGroupClick;
    private ButtonGroup buttonGroupMode;
    private ButtonGroup buttonGroupPickMode;
    private ButtonGroup buttonGroupPicklist;
    private ButtonGroup buttonGroupWellTabTitles;
    private JButton jButtonEditSchemeChart;
    private JButton jButtonSchemePanelProperites;
    private JButton jButtonSchemeZoomIn;
    private JButton jButtonSchemeZoomOut;
    private JButton jButtonSelectSchemePanel;
    private JCheckBoxMenuItem jCheckBoxMenuItemAutoFlagCvRw;
    private JCheckBoxMenuItem jCheckBoxMenuItemExcludeRwCvTotals;
    private JCheckBoxMenuItem jCheckBoxMenuItemGrainSize;
    private JCheckBoxMenuItem jCheckBoxMenuItemOccSound;
    private JCheckBoxMenuItem jCheckBoxMenuItemOverlayOnTop;
    private JCheckBoxMenuItem jCheckBoxMenuItemPickAuthor;
    private JCheckBoxMenuItem jCheckBoxMenuItemPickCat;
    private JCheckBoxMenuItem jCheckBoxMenuItemPickCode;
    private JCheckBoxMenuItem jCheckBoxMenuItemShowOccPopup;
    private JCheckBoxMenuItem jCheckBoxMenuItemTotaliser;
    private JMenu jMenu2;
    private JMenu jMenu3;
    private JMenu jMenu5;
    private JMenu jMenu6;
    private JMenuBar jMenuBar1;
    private JMenu jMenuFile;
    private JMenu jMenuHelp;
    private JMenuItem jMenuItemAbnSchemes;
    private JMenuItem jMenuItemAnalysesWeight;
    private JMenuItem jMenuItemAnlysesMerge;
    private JMenuItem jMenuItemChartExportSBG;
    private JMenuItem jMenuItemClear;
    private JMenuItem jMenuItemClearSelection;
    private JMenuItem jMenuItemCloseWell;
    private JMenuItem jMenuItemCreateVoiceRecognitionFile;
    private JMenuItem jMenuItemDetachChart;
    private JMenuItem jMenuItemDetachPdf;
    private JMenuItem jMenuItemDetachWell;
    private JMenuItem jMenuItemExit;
    private JMenuItem jMenuItemExportChartHelp;
    private JMenuItem jMenuItemExportHTML;
    private JMenuItem jMenuItemExportRastor;
    private JMenuItem jMenuItemExportVector;
    private JMenuItem jMenuItemHelpAnalyses;
    private JMenuItem jMenuItemHelpHome;
    private JMenuItem jMenuItemHelpInterp;
    private JMenuItem jMenuItemHelpMenu;
    private JMenuItem jMenuItemHelpOccurrences;
    private JMenuItem jMenuItemHelpOverlays;
    private JMenuItem jMenuItemHelpPicklist;
    private JMenuItem jMenuItemHelpSamples;
    private JMenuItem jMenuItemHelpSchemes;
    private JMenuItem jMenuItemHelpchart;
    private JMenuItem jMenuItemInsertGroup;
    private JMenuItem jMenuItemInsertTaxa;
    private JMenuItem jMenuItemInsertWellOutcrop;
    private JMenuItem jMenuItemMultiplier;
    private JMenuItem jMenuItemNewOverlay;
    private JMenuItem jMenuItemNumericCode;
    private JMenuItem jMenuItemOpenOverlay;
    private JMenuItem jMenuItemOpenProject;
    private JMenuItem jMenuItemOpenTemplateAll;
    private JMenuItem jMenuItemOpenWellIInWells;
    private JMenuItem jMenuItemOverlayEdit;
    private JMenuItem jMenuItemOverlayWeb;
    private JMenuItem jMenuItemParseSample;
    private JMenuItem jMenuItemPicklistEdit;
    private JMenuItem jMenuItemPicklistHighlighting;
    private JMenuItem jMenuItemPicklistNew;
    private JMenuItem jMenuItemPicklistRemove;
    private JMenuItem jMenuItemPrintAnalyses;
    private JMenuItem jMenuItemPrintChart;
    private JMenuItem jMenuItemPrintScheme;
    private JMenuItem jMenuItemSampleCopy;
    private JMenuItem jMenuItemSampleGenerate;
    private JMenuItem jMenuItemSampleMerge;
    private JMenuItem jMenuItemSampleMergeAll;
    private JMenuItem jMenuItemSampleMove;
    private JMenuItem jMenuItemSaveAsGroup;
    private JMenuItem jMenuItemSaveAsProject;
    private JMenuItem jMenuItemSelectWell;
    private JMenuItem jMenuItemTableDefaults;
    private JMenuItem jMenuItemTableOptions;
    private JMenuItem jMenuItemTaxonReassign;
    private JMenuItem jMenuItemViewFilteredOccs;
    private JMenuItem jMenuItemViewSelectInAllWells;
    private JMenu jMenuMultiClick;
    private JMenu jMenuOccurrences;
    private JMenu jMenuOverlay;
    private JMenu jMenuPicklist;
    private JMenu jMenuPicklistView;
    private JMenu jMenuPrint;
    private JMenu jMenuSample;
    private JMenu jMenuSynonymy;
    private JMenu jMenuView;
    private JPanel jPanelScheme;
    private JRadioButtonMenuItem jRadioButtonMenuItemBiocomAbrGenus;
    private JRadioButtonMenuItem jRadioButtonMenuItemBiocomFullName;
    private JRadioButtonMenuItem jRadioButtonMenuItemBrowsing;
    private JRadioButtonMenuItem jRadioButtonMenuItemContinuousClick;
    private JRadioButtonMenuItem jRadioButtonMenuItemDisplayCuttingCorrections;
    private JRadioButtonMenuItem jRadioButtonMenuItemDoubleClick;
    private JRadioButtonMenuItem jRadioButtonMenuItemLogging;
    private JRadioButtonMenuItem jRadioButtonMenuItemPickHoriz;
    private JRadioButtonMenuItem jRadioButtonMenuItemPickVert;
    private JRadioButtonMenuItem jRadioButtonMenuItemQuant;
    private JRadioButtonMenuItem jRadioButtonMenuItemSemiQuant;
    private JRadioButtonMenuItem jRadioButtonMenuItemWellAltNames;
    private JRadioButtonMenuItem jRadioButtonMenuItemWellCodes;
    private JRadioButtonMenuItem jRadioButtonMenuItemWellNames;
    private JScrollPane jScrollPaneSchemeChart;
    private JPopupMenu.Separator jSeparator1;
    private JPopupMenu.Separator jSeparator10;
    private JPopupMenu.Separator jSeparator11;
    private JPopupMenu.Separator jSeparator12;
    private JPopupMenu.Separator jSeparator13;
    private JPopupMenu.Separator jSeparator14;
    private JPopupMenu.Separator jSeparator15;
    private JPopupMenu.Separator jSeparator16;
    private JPopupMenu.Separator jSeparator17;
    private JPopupMenu.Separator jSeparator18;
    private JToolBar.Separator jSeparator19;
    private JPopupMenu.Separator jSeparator2;
    private JToolBar.Separator jSeparator20;
    private JPopupMenu.Separator jSeparator21;
    private JPopupMenu.Separator jSeparator22;
    private JPopupMenu.Separator jSeparator23;
    private JPopupMenu.Separator jSeparator24;
    private JPopupMenu.Separator jSeparator25;
    private JPopupMenu.Separator jSeparator26;
    private JPopupMenu.Separator jSeparator27;
    private JPopupMenu.Separator jSeparator28;
    private JPopupMenu.Separator jSeparator29;
    private JPopupMenu.Separator jSeparator3;
    private JPopupMenu.Separator jSeparator30;
    private JPopupMenu.Separator jSeparator4;
    private JPopupMenu.Separator jSeparator5;
    private JPopupMenu.Separator jSeparator6;
    private JPopupMenu.Separator jSeparator7;
    private JPopupMenu.Separator jSeparator8;
    private JPopupMenu.Separator jSeparator9;
    private JSplitPane jSplitPane1;
    private JTabbedPane jTabbedPaneSchemes;
    private JToolBar jToolBarSchemeChart;
    private DialogLithPalette lithPalette;

    public FrameSamples(FrameJsbugs parent, SBdb sbdb, Well well, boolean restore) throws SQLException, SBException {
        this.parent = parent;
        this.sbdb = sbdb;
        this.prefs = new UserPrefsHelper(sbdb);
        this.initComponents();
        this.init(well, restore);
    }

    @Override
    public FrameJsbugs getParent() {
        return this.parent;
    }

    JPanelPicklist getSelectedPicklist() {
        Component component = this.jTabbedPaneSchemes.getSelectedComponent();
        if (component instanceof JPanelPicklist) {
            return (JPanelPicklist)component;
        }
        return null;
    }

    JPanelPicklist getSelectedPicklist(JPanelPicklist list) {
        if (list != null) {
            return list;
        }
        if (this.getSelectedPicklist() != null) {
            return this.getSelectedPicklist();
        }
        if (this.picklists.size() == 1) {
            return this.picklists.get(0);
        }
        return null;
    }

    List<JPanelPicklist> getPicklists() {
        return this.picklists;
    }

    void attachTab(FrameWellDetached frame) {
        JPanelWell panel = frame.getPanel();
        this.wellFrames.remove(frame);
        this.jTabbedPaneWell.insertTab(panel, this.jRadioButtonMenuItemLogging.isSelected());
    }

    void setSelectedWellTab(JPanelWell wellPanel) {
        this.jTabbedPaneWell.setSelectedComponent(wellPanel);
    }

    JPanelWell addWellTab(Well well) throws SQLException, SBException {
        boolean found = false;
        JPanelWell wellPanel = null;
        for (Component c : this.jTabbedPaneWell.getComponents()) {
            if (((JPanelWell)c).getWell().getWellID() != well.getWellID()) continue;
            wellPanel = (JPanelWell)c;
            found = true;
            break;
        }
        if (!found) {
            for (FrameWellDetached frame : this.wellFrames) {
                if (frame.getPanel().getWell().getWellID() != well.getWellID()) continue;
                wellPanel = frame.getPanel();
                found = true;
                break;
            }
        }
        if (!found) {
            wellPanel = this.addNewWellPanel(well);
            wellPanel.setDisplayCuttingCorrections(this.jRadioButtonMenuItemDisplayCuttingCorrections.isSelected());
        }
        return wellPanel;
    }

    void setWellTabTitle(Well well) {
        boolean set = false;
        for (int i = 0; i < this.jTabbedPaneWell.getComponents().length; ++i) {
            JPanelWell wellPanel = this.jTabbedPaneWell.getComponentAt(i);
            if (wellPanel.well.getWellID() != well.getWellID()) continue;
            String tabTitleStrg = "";
            switch (JPanelWell.tabTitlePref.ordinal()) {
                case 0: {
                    tabTitleStrg = wellPanel.well.getWellName();
                    break;
                }
                case 1: {
                    tabTitleStrg = wellPanel.getWell().getWellCode();
                    break;
                }
                case 2: {
                    tabTitleStrg = wellPanel.getWell().getHeader().getWellAltName(true);
                }
            }
            this.jTabbedPaneWell.setTitleAt(i, tabTitleStrg);
            set = true;
            break;
        }
        if (!set) {
            for (FrameWellDetached wellFrame : this.wellFrames) {
                if (wellFrame.getPanel().well.getWellID() != well.getWellID()) continue;
                wellFrame.setTitle();
                break;
            }
        }
        for (FrameWellChartsDetached chartFrame : this.chartsFrames) {
            if (chartFrame.getPanel() == null || chartFrame.getPanel().parentPanel.well.getWellID() != well.getWellID()) continue;
            chartFrame.setTitle();
            break;
        }
    }

    AbundanceScheme getAbnScheme() throws SBException, SQLException {
        AbundanceScheme abnScheme;
        Smpdtl smpdtl;
        if (this.getWellPanel() != null) {
            smpdtl = this.getTableModelOcc().smpdtl;
            if (smpdtl == null) {
                smpdtl = this.getWellPanel().getSmpdtl();
            }
        } else {
            return null;
        }
        if (smpdtl != null) {
            AnalystHeader header = this.getWellPanel().getWell().getAnalystHeader(smpdtl.getAnalyID(), true);
            abnScheme = this.sbdb.getAbundanceSchemeService().findAbundanceScheme(header.getAbnSchID()).orElse(null);
        } else {
            abnScheme = this.sbdb.getAbundanceSchemeService().getDefaultAbundanceScheme();
        }
        return abnScheme;
    }

    CompositeStandard getCompositeStandard() {
        if (this.schemeChartJPanel.chart != null && this.schemeChartJPanel.chart.getSchemeBlock() != null) {
            return this.schemeChartJPanel.chart.getSchemeBlock().getCompositeStandard();
        }
        return null;
    }

    IGDScheme getIGDScheme() {
        if (this.schemeChartJPanel.chart != null && this.schemeChartJPanel.chart.getSchemeBlock() != null) {
            return this.schemeChartJPanel.chart.getSchemeBlock().getScheme();
        }
        return null;
    }

    boolean isNumeric() {
        return this.jRadioButtonMenuItemQuant.isSelected();
    }

    boolean getLogging() {
        return this.jRadioButtonMenuItemLogging.isSelected();
    }

    boolean isCMF() {
        return this.jCheckBoxMenuItemGrainSize.isSelected();
    }

    boolean isMultiClick() {
        return this.jRadioButtonMenuItemContinuousClick.isSelected();
    }

    int getPicklistTotaliser() {
        return this.picklistTotaliser;
    }

    TableModelOccurrences getTableModelOcc() {
        if (this.getWellPanel() != null) {
            return this.getWellPanel().tableModelOcc;
        }
        return null;
    }

    boolean occurrencesTabSelected() {
        return this.getWellPanel().occurrencesTabSelected();
    }

    List<Smpdtl> getSelectedSmpdtls() {
        if (!this.getWellPanel().analysesTabSelected()) {
            return null;
        }
        return this.getWellPanel().getSelectedSmpdtls();
    }

    private void loadSchemeBlock(int blockID, int wellID, int wellListID, int interpID, String bProp, String cProp) {
        try {
            BlockTemplate templ = this.parent.getChartManager().getBlockTemplate(blockID);
            if (templ != null) {
                ChartTemplate.BlockOcc occ = new ChartTemplate.BlockOcc(templ.getID(), wellID, wellListID, interpID, bProp, null);
                this.schemeChartJPanel.chart.addBlock(ChartFactory.createBlock(this.sbdb, templ, occ));
                this.schemeChartJPanel.chart.setProperties(new ChartProperties(cProp, 0));
                this.setSchemeChartVersion();
                ((JScrollPaneChartBase)this.jScrollPaneSchemeChart).refreshView();
                this.setSchemeTabTitle();
            }
        }
        catch (RuntimeException | SQLException | SBException e) {
            SbugsExceptionHandler.showStackError(e);
        }
    }

    private void init(Well well, boolean restore) throws SQLException, SBException {
        int biocomAbr;
        String s;
        int logMode;
        int totExRwCv;
        int multiClick;
        this.setTitle("Samples & Interpretations - StrataBugs");
        this.setMultiResIconImage("frameSamples.svg");
        SB.centreWindow((Frame)this);
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.jRadioButtonMenuItemDisplayCuttingCorrections.setSelected(this.prefs.getDisplayCuttingCorrections());
        this.jTabbedPaneWell.setPreRemoveHook(this::beforeCloseTab);
        this.jTabbedPaneWell.addCloseAndCloseOtherContextMenu();
        if (well != null) {
            JPanelWell wellPanel = this.addNewWellPanel(well);
            wellPanel.setDisplayCuttingCorrections(this.jRadioButtonMenuItemDisplayCuttingCorrections.isSelected());
        }
        this.schemeChartInit = false;
        if (restore) {
            this.initSchemeChart(restore);
        }
        this.jToolBarSchemeChart.setFloatable(false);
        boolean isSemiQuant = Lastval.getInt(this.sbdb, "SEMIQUANT") > 0;
        this.jRadioButtonMenuItemQuant.setSelected(!isSemiQuant);
        this.jRadioButtonMenuItemSemiQuant.setSelected(isSemiQuant);
        boolean occSound = Lastval.getInt(this.sbdb, "OCCSOUND") > 0;
        this.jCheckBoxMenuItemOccSound.setSelected(occSound);
        int total = Lastval.getInt(this.sbdb, "PICKTOTAL");
        if (total > 0) {
            this.picklistTotaliser = total;
            this.jCheckBoxMenuItemTotaliser.setText("Count limit set to: " + total);
            this.jCheckBoxMenuItemTotaliser.setSelected(true);
        }
        this.jCheckBoxMenuItemPickAuthor.setSelected(Taxon.includeAuthorInString);
        this.jCheckBoxMenuItemPickCat.setSelected(Taxon.includeCategoryInString);
        this.jCheckBoxMenuItemPickCode.setSelected(Taxon.includeAlphaInString);
        int orientation = Lastval.getInt(this.sbdb, "PICKCOL");
        if (orientation > 0) {
            if (orientation == 1) {
                this.jRadioButtonMenuItemPickHoriz.setSelected(true);
            } else {
                this.jRadioButtonMenuItemPickVert.setSelected(true);
            }
        }
        if (!restore || !this.restoreSession()) {
            this.addPicklist(null, 0);
        }
        this.jRadioButtonMenuItemBiocomFullName.setSelected(true);
        int tabTitles = Lastval.getInt(this.sbdb, "TABTITLES");
        JPanelWell.tabTitlePref = TabTitle.valueOf(tabTitles);
        switch (TabTitle.valueOf(tabTitles).ordinal()) {
            case 0: {
                this.jRadioButtonMenuItemWellNames.setSelected(true);
                break;
            }
            case 1: {
                this.jRadioButtonMenuItemWellCodes.setSelected(true);
                break;
            }
            case 2: {
                this.jRadioButtonMenuItemWellAltNames.setSelected(true);
            }
        }
        if (FrameJsbugs.isMacPlatform()) {
            this.jMenuHelp.setText("Help ");
            this.jMenuItemExit.setText("Close Samples & Interpretations");
        }
        if ((multiClick = Lastval.getInt(this.sbdb, "MULTICLICK")) > 0) {
            this.jRadioButtonMenuItemContinuousClick.setSelected(true);
        }
        if ((totExRwCv = Lastval.getInt(this.sbdb, "TOTEXRWCV")) > 0) {
            this.jCheckBoxMenuItemExcludeRwCvTotals.setSelected(true);
        }
        boolean bl = this.showOccPopup = Lastval.getInt(this.sbdb, "OCCPOPUP", 0) == 1;
        if (this.showOccPopup) {
            this.jCheckBoxMenuItemShowOccPopup.setSelected(this.showOccPopup);
        }
        if ((logMode = Lastval.getInt(this.sbdb, "LOGMODE")) > 0) {
            this.jRadioButtonMenuItemLogging.setSelected(true);
            this.jRadioButtonMenuItemLoggingActionPerformed(null);
        }
        if (!(s = Lastval.getString(this.sbdb, "PKLHLGHT")).isEmpty()) {
            this.picklistHighlighting = new PicklistHighlighting(this);
            this.picklistHighlighting.decode(s);
        }
        if ((biocomAbr = Lastval.getInt(this.sbdb, "BIOCOMABR")) > 0) {
            this.jRadioButtonMenuItemBiocomAbrGenus.setSelected(true);
        }
        this.deriveCvRw = Lastval.getInt(this.sbdb, "DERIVECVRW") == 1;
        this.jCheckBoxMenuItemAutoFlagCvRw.setSelected(this.deriveCvRw);
        this.initHiResIcons();
        this.initSynonymyMenu();
        this.jCheckBoxMenuItemOverlayOnTop.setSelected(this.overlayWindowOnTop);
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void initHiResIcons() {
        if (SbugsSession.getSession().useHiResIcons()) {
            this.jTabbedPaneSchemes.setIconAt(this.jTabbedPaneSchemes.indexOfComponent(this.jPanelScheme), IconFactory.getIcon("FrameSamples_SchemeTab.svg"));
            IconFactory.setButtonIconsInBackground(List.of(new IconFactory.ButtonIconInfo(this.jButtonSchemePanelProperites, "chartProperties.svg", 16), new IconFactory.ButtonIconInfo(this.jButtonSchemeZoomIn, "zoomIn.svg", 16), new IconFactory.ButtonIconInfo(this.jButtonSchemeZoomOut, "zoomOut.svg", 16), new IconFactory.ButtonIconInfo(this.jButtonEditSchemeChart, "FrameSamples_EditTemplate.svg", 16), new IconFactory.ButtonIconInfo(this.jButtonSelectSchemePanel, "openSchemeTemplate.svg", 16)));
        }
    }

    private void initSynonymyMenu() {
        try {
            boolean useSynSch;
            boolean bl = useSynSch = Lastval.getInt(this.sbdb, "SMPSYNSCH", 1) == 1;
            this.synSchID = useSynSch ? Lastval.getInt(this.sbdb, "SYNSCHID", 1) : 0;
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, "Error getting value from Lastval", e);
            this.synSchID = 0;
        }
        final ButtonGroup synonymyButtonGroup = new ButtonGroup();
        class SynSchMenuItem
        extends JRadioButtonMenuItem {
            final /* synthetic */ FrameSamples this$0;

            SynSchMenuItem(String text, int synSchID) {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
                this.setText(text);
                this.addActionListener(e -> this$0.setSynonymScheme(synSchID));
                this.setSelected(this$0.synSchID == synSchID);
                buttonGroup.add(this);
            }
        }
        this.jMenuSynonymy.add(new SynSchMenuItem("Do not show synonymy", 0));
        try {
            Collection<SynonymScheme> synSchemes = this.sbdb.getSynSchemes();
            LinkedList<SynonymScheme> synonymSchemes = new LinkedList<SynonymScheme>(synSchemes);
            for (com.stratadata.model3.taxon.SynonymScheme synonymScheme : synonymSchemes) {
                this.jMenuSynonymy.add(new SynSchMenuItem(synonymScheme.getName(), synonymScheme.getSchID()));
            }
        }
        catch (SQLException sql) {
            SbugsExceptionHandler.showStackError("Error loading synonymy for menu", sql, this);
        }
        this.setSynonymScheme(0);
    }

    public int getSynSchID() {
        return this.synSchID;
    }

    private void setSynonymScheme(int schemeID) {
        if (schemeID == this.synSchID) {
            return;
        }
        this.synSchID = schemeID;
        try {
            if (schemeID == 0) {
                Lastval.putInt(this.sbdb, "SMPSYNSCH", schemeID);
            } else {
                Lastval.putInt(this.sbdb, "SYNSCHID", schemeID);
            }
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, "Error setting Lastval for SYNSCHID", e);
        }
    }

    private void initSchemeChart(boolean restore) {
        if (this.schemeChartInit) {
            return;
        }
        ChartProperties cp = this.schemeChartJPanel.chart.getProperties();
        cp.margin = 5.0f;
        cp.setPanelHeaderHeight(50.0f);
        cp.setPanelCaptionHeight(9.0f);
        cp.plotBlockCaptions = false;
        this.jScrollPaneSchemeChart.getViewport().add((Component)this.schemeChartJPanel, null);
        ((JScrollPaneChartBase)this.jScrollPaneSchemeChart).initListeners();
        this.schemeChartJPanel.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.this$0.schemeChartPanelMouseClicked(evt);
            }
        });
        String sql = "SELECT block_id,well_id,wellist_id,interp_id,b_prop,c_prop FROM " + this.sbdb.DBTableName("CHTPREF_SCH") + " WHERE user_id=" + this.sbdb.getUserID() + " AND location=" + SB.DBString((String)SCH_BLK_LOC_FIELD);
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            if (rs.next()) {
                int blockID = rs.getInt("block_id");
                int wellID = rs.getInt("well_id");
                int wellListID = rs.getInt("wellist_id");
                int interpID = rs.getInt("interp_id");
                String bProp = rs.getString("b_prop");
                String cProp = rs.getString("c_prop");
                rs.close();
                sql = "SELECT descr FROM " + this.sbdb.DBTableName("CHTBLOCK") + " WHERE block_id=" + blockID;
                rs = stmt.executeQuery(this.sbdb.modQuery(sql));
                if (rs.next()) {
                    String blockName = rs.getString("descr");
                    if (restore) {
                        this.loadSchemeBlock(blockID, wellID, wellListID, interpID, bProp, cProp);
                    } else if (JOptionPane.showConfirmDialog(this, "Re-open Stratigraphic Scheme Picklist: " + blockName + "?", "Frame Samples", 0, 3) == 0) {
                        SchemeBlockLoader loader = new SchemeBlockLoader(this, this, blockID, wellID, wellListID, interpID, bProp, cProp);
                        this.setCursor(Cursor.getPredefinedCursor(3));
                        loader.execute();
                    }
                }
            }
        }
        catch (RuntimeException | SQLException e) {
            SbugsExceptionHandler.showStackError(e);
        }
        this.schemeChartInit = true;
    }

    private void writeSchemeChartPref() throws SQLException {
        for (ChartBlockBase block : this.schemeChartJPanel.chart.getBlocks()) {
            if (block.getTemplate() == null) continue;
            String sql1 = "DELETE FROM " + this.sbdb.DBTableName("CHTPREF_SCH") + " WHERE location=" + SB.DBString((String)SCH_BLK_LOC_FIELD) + " AND user_id=" + this.sbdb.getUserID();
            String sql = "INSERT INTO " + this.sbdb.DBTableName("CHTPREF_SCH") + "(block_id,user_id,location,b_prop,c_prop) VALUES (" + block.getTemplate().getID() + "," + this.sbdb.getUserID() + "," + SB.DBString((String)SCH_BLK_LOC_FIELD) + "," + SB.DBString((String)block.getProperties()) + "," + SB.DBString((String)this.schemeChartJPanel.chart.getProperties().getProperties()) + ")";
            try (Statement stmt = this.sbdb.getDatabase().createStatement();){
                stmt.executeUpdate(this.sbdb.modQuery(sql1));
                stmt.executeUpdate(this.sbdb.modQuery(sql));
                this.sbdb.commit();
            }
            return;
        }
    }

    public ChartJPanel getSchemeChart() {
        return this.schemeChartJPanel;
    }

    boolean isAbrBiocom() {
        return this.jRadioButtonMenuItemBiocomAbrGenus.isSelected();
    }

    JPanelWell getWellPanel() {
        return (JPanelWell)this.jTabbedPaneWell.getSelectedComponent();
    }

    private void schemeChartPanelMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            Object obj = this.schemeChartJPanel.getObject(evt);
            if (obj == null) {
                JOptionPane.showMessageDialog(this, "No unit or event found.", this.getTitle(), 1);
            } else if (obj instanceof IGDUnitBase) {
                IGDUnitBase unit = (IGDUnitBase)obj;
                WellInterp wellInterp = this.getWellPanel().getInterp();
                if (wellInterp == null) {
                    JOptionPane.showMessageDialog(this, "No version selected.", this.getTitle(), 1);
                    return;
                }
                try {
                    IGDScheme scheme = this.sbdb.getIGDScheme(unit.getSchID());
                    int igdType = scheme.getIGDType();
                    if (igdType == 10) {
                        JOptionPane.showMessageDialog(this, "Double-click a surface to add sequence picks.", this.getTitle(), 1);
                        return;
                    }
                    this.getWellPanel().addZone(igdType, unit, scheme);
                    this.schemeChartJPanel.repaint();
                }
                catch (SQLException sql) {
                    FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
                }
            } else if (obj instanceof CompositeStandardEvent) {
                CompositeStandardEvent event = (CompositeStandardEvent)obj;
                WellInterp wellInterp = this.getWellPanel().getInterp();
                if (wellInterp == null) {
                    JOptionPane.showMessageDialog(this, "No version selected.", this.getTitle(), 1);
                    return;
                }
                this.getWellPanel().addEvent(event.getEvent(), event.getType());
            } else if (obj instanceof Surface) {
                Surface surface = (Surface)obj;
                WellInterp wellInterp = this.getWellPanel().getInterp();
                if (wellInterp == null) {
                    JOptionPane.showMessageDialog(this, "No version selected.", this.getTitle(), 1);
                    return;
                }
                this.getWellPanel().addSQPick(surface);
            } else {
                System.out.println("Some other object!");
            }
        }
    }

    private void initComponents() {
        JTabbedPaneWell jTabbedPaneWell;
        this.buttonGroupPicklist = new ButtonGroup();
        this.buttonGroupBiocommTaxaOptions = new ButtonGroup();
        this.buttonGroupMode = new ButtonGroup();
        this.buttonGroupPickMode = new ButtonGroup();
        this.buttonGroupWellTabTitles = new ButtonGroup();
        this.buttonGroupClick = new ButtonGroup();
        this.jSplitPane1 = new JSplitPane();
        this.jTabbedPaneWell = jTabbedPaneWell = new JTabbedPaneWell();
        this.jTabbedPaneSchemes = new JTabbedPane();
        this.jPanelScheme = new JPanel();
        this.jScrollPaneSchemeChart = new JScrollPaneChartBase(this.schemeChartJPanel);
        this.jToolBarSchemeChart = new JToolBar();
        this.jButtonSchemeZoomIn = new JButton();
        this.jButtonSchemeZoomOut = new JButton();
        this.jSeparator19 = new JToolBar.Separator();
        this.jButtonSchemePanelProperites = new JButton();
        this.jSeparator20 = new JToolBar.Separator();
        this.jButtonSelectSchemePanel = new JButton();
        this.jButtonEditSchemeChart = new JButton();
        this.jMenuBar1 = new JMenuBar();
        this.jMenuFile = new JMenu();
        this.jMenuItemSelectWell = new JMenuItem();
        this.jMenuItemOpenProject = new JMenuItem();
        this.jSeparator4 = new JPopupMenu.Separator();
        this.jMenuItemOpenWellIInWells = new JMenuItem();
        this.jSeparator30 = new JPopupMenu.Separator();
        this.jMenuItemCloseWell = new JMenuItem();
        this.jMenuItemDetachWell = new JMenuItem();
        this.jMenuItemDetachChart = new JMenuItem();
        this.jMenuItemDetachPdf = new JMenuItem();
        this.jSeparator27 = new JPopupMenu.Separator();
        this.jMenuItemSaveAsProject = new JMenuItem();
        this.jMenuItemOpenTemplateAll = new JMenuItem();
        this.jSeparator5 = new JPopupMenu.Separator();
        this.jMenuPrint = new JMenu();
        this.jMenuItemPrintChart = new JMenuItem();
        this.jMenuItemPrintScheme = new JMenuItem();
        this.jMenuItemPrintAnalyses = new JMenuItem();
        this.jMenu6 = new JMenu();
        this.jMenuItemExportVector = new JMenuItem();
        this.jMenuItemExportRastor = new JMenuItem();
        this.jSeparator26 = new JPopupMenu.Separator();
        this.jMenuItemChartExportSBG = new JMenuItem();
        this.jMenuItemExportHTML = new JMenuItem();
        this.jSeparator21 = new JPopupMenu.Separator();
        this.jMenuItemExportChartHelp = new JMenuItem();
        this.jSeparator6 = new JPopupMenu.Separator();
        this.jMenuOverlay = new JMenu();
        this.jMenuItemOpenOverlay = new JMenuItem();
        this.jMenuItemOverlayWeb = new JMenuItem();
        this.jSeparator29 = new JPopupMenu.Separator();
        this.jCheckBoxMenuItemOverlayOnTop = new JCheckBoxMenuItem();
        this.jSeparator2 = new JPopupMenu.Separator();
        this.jMenuItemNewOverlay = new JMenuItem();
        this.jMenuItemOverlayEdit = new JMenuItem();
        this.jMenuItemAbnSchemes = new JMenuItem();
        this.jMenuItemCreateVoiceRecognitionFile = new JMenuItem();
        this.jMenuItemParseSample = new JMenuItem();
        this.jSeparator7 = new JPopupMenu.Separator();
        this.jMenuItemExit = new JMenuItem();
        this.jMenuSample = new JMenu();
        this.jMenu2 = new JMenu();
        this.jMenuItemSampleCopy = new JMenuItem();
        this.jMenuItemSampleMove = new JMenuItem();
        this.jMenuItemAnlysesMerge = new JMenuItem();
        this.jMenuItemAnalysesWeight = new JMenuItem();
        this.jMenuItemTaxonReassign = new JMenuItem();
        this.jSeparator18 = new JPopupMenu.Separator();
        this.jMenuItemSampleGenerate = new JMenuItem();
        this.jMenuItemSampleMerge = new JMenuItem();
        this.jMenuItemSampleMergeAll = new JMenuItem();
        this.jSeparator17 = new JPopupMenu.Separator();
        this.jMenu3 = new JMenu();
        this.jRadioButtonMenuItemBiocomAbrGenus = new JRadioButtonMenuItem();
        this.jRadioButtonMenuItemBiocomFullName = new JRadioButtonMenuItem();
        this.jMenuOccurrences = new JMenu();
        this.jRadioButtonMenuItemLogging = new JRadioButtonMenuItem();
        this.jRadioButtonMenuItemBrowsing = new JRadioButtonMenuItem();
        this.jSeparator13 = new JPopupMenu.Separator();
        this.jRadioButtonMenuItemQuant = new JRadioButtonMenuItem();
        this.jRadioButtonMenuItemSemiQuant = new JRadioButtonMenuItem();
        this.jSeparator11 = new JPopupMenu.Separator();
        this.jCheckBoxMenuItemGrainSize = new JCheckBoxMenuItem();
        this.jSeparator12 = new JPopupMenu.Separator();
        this.jCheckBoxMenuItemTotaliser = new JCheckBoxMenuItem();
        this.jMenuItemMultiplier = new JMenuItem();
        this.jCheckBoxMenuItemOccSound = new JCheckBoxMenuItem();
        this.jMenuMultiClick = new JMenu();
        this.jRadioButtonMenuItemDoubleClick = new JRadioButtonMenuItem();
        this.jRadioButtonMenuItemContinuousClick = new JRadioButtonMenuItem();
        this.jCheckBoxMenuItemShowOccPopup = new JCheckBoxMenuItem();
        this.jCheckBoxMenuItemExcludeRwCvTotals = new JCheckBoxMenuItem();
        this.jCheckBoxMenuItemAutoFlagCvRw = new JCheckBoxMenuItem();
        this.jSeparator15 = new JPopupMenu.Separator();
        this.jMenuItemNumericCode = new JMenuItem();
        this.jMenuPicklist = new JMenu();
        this.jMenuPicklistView = new JMenu();
        this.jRadioButtonMenuItemPickHoriz = new JRadioButtonMenuItem();
        this.jRadioButtonMenuItemPickVert = new JRadioButtonMenuItem();
        this.jSeparator16 = new JPopupMenu.Separator();
        this.jCheckBoxMenuItemPickAuthor = new JCheckBoxMenuItem();
        this.jCheckBoxMenuItemPickCat = new JCheckBoxMenuItem();
        this.jCheckBoxMenuItemPickCode = new JCheckBoxMenuItem();
        this.jSeparator10 = new JPopupMenu.Separator();
        this.jMenuItemPicklistHighlighting = new JMenuItem();
        this.jMenuSynonymy = new JMenu();
        this.jSeparator28 = new JPopupMenu.Separator();
        this.jMenuItemInsertTaxa = new JMenuItem();
        this.jMenuItemInsertGroup = new JMenuItem();
        this.jMenuItemInsertWellOutcrop = new JMenuItem();
        this.jSeparator8 = new JPopupMenu.Separator();
        this.jMenuItemPicklistNew = new JMenuItem();
        this.jMenuItemPicklistEdit = new JMenuItem();
        this.jMenuItemPicklistRemove = new JMenuItem();
        this.jSeparator23 = new JPopupMenu.Separator();
        this.jMenuItemSaveAsGroup = new JMenuItem();
        this.jSeparator14 = new JPopupMenu.Separator();
        this.jMenuItemClearSelection = new JMenuItem();
        this.jMenuItemClear = new JMenuItem();
        this.jMenuView = new JMenu();
        this.jMenuItemTableOptions = new JMenuItem();
        this.jMenuItemTableDefaults = new JMenuItem();
        this.jSeparator24 = new JPopupMenu.Separator();
        this.jMenu5 = new JMenu();
        this.jRadioButtonMenuItemWellNames = new JRadioButtonMenuItem();
        this.jRadioButtonMenuItemWellCodes = new JRadioButtonMenuItem();
        this.jRadioButtonMenuItemWellAltNames = new JRadioButtonMenuItem();
        this.jSeparator25 = new JPopupMenu.Separator();
        this.jMenuItemViewFilteredOccs = new JMenuItem();
        this.jRadioButtonMenuItemDisplayCuttingCorrections = new JRadioButtonMenuItem();
        this.jSeparator22 = new JPopupMenu.Separator();
        this.jMenuItemViewSelectInAllWells = new JMenuItem();
        this.jMenuHelp = new JMenu();
        this.jMenuItemHelpHome = new JMenuItem();
        this.jMenuItemHelpMenu = new JMenuItem();
        this.jSeparator3 = new JPopupMenu.Separator();
        this.jMenuItemHelpSamples = new JMenuItem();
        this.jMenuItemHelpAnalyses = new JMenuItem();
        this.jMenuItemHelpOccurrences = new JMenuItem();
        this.jMenuItemHelpInterp = new JMenuItem();
        this.jMenuItemHelpchart = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.jMenuItemHelpSchemes = new JMenuItem();
        this.jMenuItemHelpPicklist = new JMenuItem();
        this.jSeparator9 = new JPopupMenu.Separator();
        this.jMenuItemHelpOverlays = new JMenuItem();
        this.setDefaultCloseOperation(0);
        this.setMinimumSize(new Dimension(900, 720));
        this.addWindowFocusListener(new WindowFocusListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void windowGainedFocus(WindowEvent evt) {
                this.this$0.formWindowGainedFocus(evt);
            }

            @Override
            public void windowLostFocus(WindowEvent evt) {
                this.this$0.formWindowLostFocus(evt);
            }
        });
        this.addWindowListener(new WindowAdapter(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void windowClosing(WindowEvent evt) {
                this.this$0.formWindowClosing(evt);
            }
        });
        this.jSplitPane1.setBorder(null);
        this.jSplitPane1.setDividerSize(15);
        this.jSplitPane1.setResizeWeight(0.8);
        this.jSplitPane1.setOneTouchExpandable(true);
        jTabbedPaneWell.setMinimumSize(new Dimension(350, 600));
        jTabbedPaneWell.addChangeListener(new ChangeListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void stateChanged(ChangeEvent evt) {
                this.this$0.jTabbedPaneWellStateChanged(evt);
            }
        });
        this.jSplitPane1.setLeftComponent(jTabbedPaneWell);
        jTabbedPaneWell.getAccessibleContext().setAccessibleName("well");
        this.jTabbedPaneSchemes.setMinimumSize(new Dimension(385, 600));
        this.jTabbedPaneSchemes.addChangeListener(new ChangeListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void stateChanged(ChangeEvent evt) {
                this.this$0.jTabbedPaneSchemesStateChanged(evt);
            }
        });
        this.jToolBarSchemeChart.setRollover(true);
        this.jButtonSchemeZoomIn.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/ZoomIn16.png")));
        this.jButtonSchemeZoomIn.setToolTipText("Zoom in (CTRL +)");
        this.jButtonSchemeZoomIn.setFocusable(false);
        this.jButtonSchemeZoomIn.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSchemeZoomInActionPerformed(evt);
            }
        });
        this.jToolBarSchemeChart.add(this.jButtonSchemeZoomIn);
        this.jButtonSchemeZoomOut.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/ZoomOut16.png")));
        this.jButtonSchemeZoomOut.setToolTipText("Zoom out (CTRL -)");
        this.jButtonSchemeZoomOut.setFocusable(false);
        this.jButtonSchemeZoomOut.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSchemeZoomOutActionPerformed(evt);
            }
        });
        this.jToolBarSchemeChart.add(this.jButtonSchemeZoomOut);
        this.jToolBarSchemeChart.add(this.jSeparator19);
        this.jButtonSchemePanelProperites.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/chartProperties16.png")));
        this.jButtonSchemePanelProperites.setToolTipText("Change scale, header properties");
        this.jButtonSchemePanelProperites.setFocusable(false);
        this.jButtonSchemePanelProperites.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSchemePanelProperitesActionPerformed(evt);
            }
        });
        this.jToolBarSchemeChart.add(this.jButtonSchemePanelProperites);
        this.jToolBarSchemeChart.add(this.jSeparator20);
        this.jButtonSelectSchemePanel.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/openTemplate16.png")));
        this.jButtonSelectSchemePanel.setToolTipText("Open template...");
        this.jButtonSelectSchemePanel.setFocusable(false);
        this.jButtonSelectSchemePanel.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSelectSchemePanelActionPerformed(evt);
            }
        });
        this.jToolBarSchemeChart.add(this.jButtonSelectSchemePanel);
        this.jButtonEditSchemeChart.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/editChart16.png")));
        this.jButtonEditSchemeChart.setToolTipText("Edit template in charts module...");
        this.jButtonEditSchemeChart.setFocusable(false);
        this.jButtonEditSchemeChart.setHorizontalTextPosition(0);
        this.jButtonEditSchemeChart.setVerticalTextPosition(3);
        this.jButtonEditSchemeChart.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonEditSchemeChartActionPerformed(evt);
            }
        });
        this.jToolBarSchemeChart.add(this.jButtonEditSchemeChart);
        GroupLayout jPanelSchemeLayout = new GroupLayout((Container)this.jPanelScheme);
        this.jPanelScheme.setLayout((LayoutManager)jPanelSchemeLayout);
        jPanelSchemeLayout.setHorizontalGroup((GroupLayout.Group)jPanelSchemeLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelSchemeLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelSchemeLayout.createParallelGroup(1).add((Component)this.jToolBarSchemeChart, -2, 253, -2).add((Component)this.jScrollPaneSchemeChart, -1, 736, Short.MAX_VALUE)).addContainerGap()));
        jPanelSchemeLayout.setVerticalGroup((GroupLayout.Group)jPanelSchemeLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelSchemeLayout.createSequentialGroup().add((Component)this.jToolBarSchemeChart, -2, 34, -2).addPreferredGap(0).add((Component)this.jScrollPaneSchemeChart, -1, 886, Short.MAX_VALUE).addContainerGap()));
        this.jTabbedPaneSchemes.addTab("Stratigraphic Schemes", new ImageIcon(this.getClass().getResource("/resources/icon/FrameSamples_SchemeTab.png")), this.jPanelScheme);
        this.jSplitPane1.setRightComponent(this.jTabbedPaneSchemes);
        this.jTabbedPaneSchemes.getAccessibleContext().setAccessibleName("Stratigraphic Schemes");
        this.jMenuFile.setText("File");
        this.jMenuItemSelectWell.setAccelerator(KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.jMenuItemSelectWell.setText("Open well...");
        this.jMenuItemSelectWell.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemSelectWellActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemSelectWell);
        this.jMenuItemOpenProject.setAccelerator(KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 0x40));
        this.jMenuItemOpenProject.setText("Open project...");
        this.jMenuItemOpenProject.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemOpenProjectActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemOpenProject);
        this.jMenuFile.add(this.jSeparator4);
        this.jMenuItemOpenWellIInWells.setText("Open well in wells module ...");
        this.jMenuItemOpenWellIInWells.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemOpenWellIInWellsActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemOpenWellIInWells);
        this.jMenuFile.add(this.jSeparator30);
        this.jMenuItemCloseWell.setText("Close selected well tab");
        this.jMenuItemCloseWell.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemCloseWellActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemCloseWell);
        this.jMenuItemDetachWell.setText("Detach selected well tab");
        this.jMenuItemDetachWell.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemDetachWellActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemDetachWell);
        this.jMenuItemDetachChart.setText("Detach selected well chart tab");
        this.jMenuItemDetachChart.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemDetachChartActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemDetachChart);
        this.jMenuItemDetachPdf.setText("Detach selected well document preview");
        this.jMenuItemDetachPdf.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemDetachPdfActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemDetachPdf);
        this.jMenuFile.add(this.jSeparator27);
        this.jMenuItemSaveAsProject.setText("Save open wells as project / well list...");
        this.jMenuItemSaveAsProject.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemSaveAsProjectActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemSaveAsProject);
        this.jMenuItemOpenTemplateAll.setText("Open chart template tab for all wells...");
        this.jMenuItemOpenTemplateAll.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemOpenTemplateAllActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemOpenTemplateAll);
        this.jMenuFile.add(this.jSeparator5);
        this.jMenuPrint.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/print16.png")));
        this.jMenuPrint.setText("Print");
        this.jMenuItemPrintChart.setText("Chart...");
        this.jMenuItemPrintChart.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemPrintChartActionPerformed(evt);
            }
        });
        this.jMenuPrint.add(this.jMenuItemPrintChart);
        this.jMenuItemPrintScheme.setText("Schemes chart...");
        this.jMenuItemPrintScheme.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemPrintSchemeActionPerformed(evt);
            }
        });
        this.jMenuPrint.add(this.jMenuItemPrintScheme);
        this.jMenuItemPrintAnalyses.setText("Analyses...");
        this.jMenuItemPrintAnalyses.setToolTipText("Print sample logging sheets for selected analyses");
        this.jMenuItemPrintAnalyses.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemPrintAnalysesActionPerformed(evt);
            }
        });
        this.jMenuPrint.add(this.jMenuItemPrintAnalyses);
        this.jMenuFile.add(this.jMenuPrint);
        this.jMenu6.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/export16.png")));
        this.jMenu6.setText("Export chart");
        this.jMenuItemExportVector.setText("As PDF/vector image...");
        this.jMenuItemExportVector.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemExportVectorActionPerformed(evt);
            }
        });
        this.jMenu6.add(this.jMenuItemExportVector);
        this.jMenuItemExportRastor.setText("As bitmap...");
        this.jMenuItemExportRastor.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemExportRastorActionPerformed(evt);
            }
        });
        this.jMenu6.add(this.jMenuItemExportRastor);
        this.jMenu6.add(this.jSeparator26);
        this.jMenuItemChartExportSBG.setText("As StrataBugs file...");
        this.jMenuItemChartExportSBG.setToolTipText("");
        this.jMenuItemChartExportSBG.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemChartExportSBGActionPerformed(evt);
            }
        });
        this.jMenu6.add(this.jMenuItemChartExportSBG);
        this.jMenuItemExportHTML.setText("As HTML...");
        this.jMenuItemExportHTML.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemExportHTMLActionPerformed(evt);
            }
        });
        this.jMenu6.add(this.jMenuItemExportHTML);
        this.jMenu6.add(this.jSeparator21);
        this.jMenuItemExportChartHelp.setText("Help...");
        this.jMenuItemExportChartHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemExportChartHelpActionPerformed(evt);
            }
        });
        this.jMenu6.add(this.jMenuItemExportChartHelp);
        this.jMenuFile.add(this.jMenu6);
        this.jMenuFile.add(this.jSeparator6);
        this.jMenuOverlay.setText("Overlay");
        this.jMenuItemOpenOverlay.setAccelerator(KeyStroke.getKeyStroke(76, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.jMenuItemOpenOverlay.setText("Select...");
        this.jMenuItemOpenOverlay.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemOpenOverlayActionPerformed(evt);
            }
        });
        this.jMenuOverlay.add(this.jMenuItemOpenOverlay);
        this.jMenuItemOverlayWeb.setText("Select for tablet...");
        this.jMenuItemOverlayWeb.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemOverlayWebActionPerformed(evt);
            }
        });
        this.jMenuOverlay.add(this.jMenuItemOverlayWeb);
        this.jMenuOverlay.add(this.jSeparator29);
        this.jCheckBoxMenuItemOverlayOnTop.setSelected(true);
        this.jCheckBoxMenuItemOverlayOnTop.setText("Keep window on top");
        this.jCheckBoxMenuItemOverlayOnTop.setToolTipText("");
        this.jCheckBoxMenuItemOverlayOnTop.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jCheckBoxMenuItemOverlayOnTopActionPerformed(evt);
            }
        });
        this.jMenuOverlay.add(this.jCheckBoxMenuItemOverlayOnTop);
        this.jMenuOverlay.add(this.jSeparator2);
        this.jMenuItemNewOverlay.setText("Add...");
        this.jMenuItemNewOverlay.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemNewOverlayActionPerformed(evt);
            }
        });
        this.jMenuOverlay.add(this.jMenuItemNewOverlay);
        this.jMenuItemOverlayEdit.setText("Edit...");
        this.jMenuItemOverlayEdit.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemOverlayEditActionPerformed(evt);
            }
        });
        this.jMenuOverlay.add(this.jMenuItemOverlayEdit);
        this.jMenuFile.add(this.jMenuOverlay);
        this.jMenuItemAbnSchemes.setText("Abundance Schemes...");
        this.jMenuItemAbnSchemes.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemAbnSchemesActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemAbnSchemes);
        this.jMenuItemCreateVoiceRecognitionFile.setText("Create Voice Recognition File...");
        this.jMenuItemCreateVoiceRecognitionFile.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemCreateVoiceRecognitionFileActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemCreateVoiceRecognitionFile);
        this.jMenuItemParseSample.setText("Parse Sample");
        this.jMenuItemParseSample.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemParseSampleActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemParseSample);
        this.jMenuFile.add(this.jSeparator7);
        this.jMenuItemExit.setText("Exit");
        this.jMenuItemExit.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemExitActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemExit);
        this.jMenuBar1.add(this.jMenuFile);
        this.jMenuSample.setText("Samples");
        this.jMenu2.setText("Analyses");
        this.jMenuItemSampleCopy.setText("Copy occurrences from...");
        this.jMenuItemSampleCopy.setToolTipText("");
        this.jMenuItemSampleCopy.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemSampleCopyActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItemSampleCopy);
        this.jMenuItemSampleMove.setText("Move selected analyses to suite...");
        this.jMenuItemSampleMove.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemSampleMoveActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItemSampleMove);
        this.jMenuItemAnlysesMerge.setText("Merge selected analyses with suite...");
        this.jMenuItemAnlysesMerge.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemAnlysesMergeActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItemAnlysesMerge);
        this.jMenuItemAnalysesWeight.setText("Set sample weight for selection...");
        this.jMenuItemAnalysesWeight.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemAnalysesWeightActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItemAnalysesWeight);
        this.jMenuItemTaxonReassign.setText("Reassign taxon/merge occurrences...");
        this.jMenuItemTaxonReassign.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemTaxonReassignActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItemTaxonReassign);
        this.jMenuSample.add(this.jMenu2);
        this.jMenuSample.add(this.jSeparator18);
        this.jMenuItemSampleGenerate.setText("Generate sample list...");
        this.jMenuItemSampleGenerate.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemSampleGenerateActionPerformed(evt);
            }
        });
        this.jMenuSample.add(this.jMenuItemSampleGenerate);
        this.jMenuItemSampleMerge.setText("Merge selected sample pair...");
        this.jMenuItemSampleMerge.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemSampleMergeActionPerformed(evt);
            }
        });
        this.jMenuSample.add(this.jMenuItemSampleMerge);
        this.jMenuItemSampleMergeAll.setText("Merge ALL single depth samples with equivalent dual depth samples ...");
        this.jMenuItemSampleMergeAll.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemSampleMergeAllActionPerformed(evt);
            }
        });
        this.jMenuSample.add(this.jMenuItemSampleMergeAll);
        this.jMenuSample.add(this.jSeparator17);
        this.jMenu3.setText("Biocomm. taxon name options");
        this.buttonGroupBiocommTaxaOptions.add(this.jRadioButtonMenuItemBiocomAbrGenus);
        this.jRadioButtonMenuItemBiocomAbrGenus.setSelected(true);
        this.jRadioButtonMenuItemBiocomAbrGenus.setText("Abbreviate genus");
        this.jRadioButtonMenuItemBiocomAbrGenus.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonMenuItemBiocomAbrGenusActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.jRadioButtonMenuItemBiocomAbrGenus);
        this.buttonGroupBiocommTaxaOptions.add(this.jRadioButtonMenuItemBiocomFullName);
        this.jRadioButtonMenuItemBiocomFullName.setText("Use full name");
        this.jRadioButtonMenuItemBiocomFullName.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonMenuItemBiocomFullNameActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.jRadioButtonMenuItemBiocomFullName);
        this.jMenuSample.add(this.jMenu3);
        this.jMenuBar1.add(this.jMenuSample);
        this.jMenuOccurrences.setText("Occurrences");
        this.jRadioButtonMenuItemLogging.setAccelerator(KeyStroke.getKeyStroke(77, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.buttonGroupMode.add(this.jRadioButtonMenuItemLogging);
        this.jRadioButtonMenuItemLogging.setText("Click-to-count mode");
        this.jRadioButtonMenuItemLogging.setToolTipText("Click to increment occurrences");
        this.jRadioButtonMenuItemLogging.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonMenuItemLoggingActionPerformed(evt);
            }
        });
        this.jMenuOccurrences.add(this.jRadioButtonMenuItemLogging);
        this.jRadioButtonMenuItemBrowsing.setAccelerator(KeyStroke.getKeyStroke(77, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 0x40));
        this.buttonGroupMode.add(this.jRadioButtonMenuItemBrowsing);
        this.jRadioButtonMenuItemBrowsing.setSelected(true);
        this.jRadioButtonMenuItemBrowsing.setText("Click-to-edit mode");
        this.jRadioButtonMenuItemBrowsing.setToolTipText("Click for Occurrence dialog");
        this.jRadioButtonMenuItemBrowsing.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonMenuItemBrowsingActionPerformed(evt);
            }
        });
        this.jMenuOccurrences.add(this.jRadioButtonMenuItemBrowsing);
        this.jMenuOccurrences.add(this.jSeparator13);
        this.jRadioButtonMenuItemQuant.setAccelerator(KeyStroke.getKeyStroke(81, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.buttonGroupPicklist.add(this.jRadioButtonMenuItemQuant);
        this.jRadioButtonMenuItemQuant.setSelected(true);
        this.jRadioButtonMenuItemQuant.setText("Quantitative");
        this.jRadioButtonMenuItemQuant.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonMenuItemQuantActionPerformed(evt);
            }
        });
        this.jMenuOccurrences.add(this.jRadioButtonMenuItemQuant);
        this.jRadioButtonMenuItemSemiQuant.setAccelerator(KeyStroke.getKeyStroke(81, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 0x40));
        this.buttonGroupPicklist.add(this.jRadioButtonMenuItemSemiQuant);
        this.jRadioButtonMenuItemSemiQuant.setText("Semi-quantitative");
        this.jRadioButtonMenuItemSemiQuant.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonMenuItemSemiQuantActionPerformed(evt);
            }
        });
        this.jMenuOccurrences.add(this.jRadioButtonMenuItemSemiQuant);
        this.jMenuOccurrences.add(this.jSeparator11);
        this.jCheckBoxMenuItemGrainSize.setAccelerator(KeyStroke.getKeyStroke(70, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.jCheckBoxMenuItemGrainSize.setText("Separate size fractions");
        this.jCheckBoxMenuItemGrainSize.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jCheckBoxMenuItemGrainSizeActionPerformed(evt);
            }
        });
        this.jMenuOccurrences.add(this.jCheckBoxMenuItemGrainSize);
        this.jMenuOccurrences.add(this.jSeparator12);
        this.jCheckBoxMenuItemTotaliser.setText("Set count limit");
        this.jCheckBoxMenuItemTotaliser.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jCheckBoxMenuItemTotaliserActionPerformed(evt);
            }
        });
        this.jMenuOccurrences.add(this.jCheckBoxMenuItemTotaliser);
        this.jMenuItemMultiplier.setText("Set count multiplier button");
        this.jMenuItemMultiplier.setEnabled(false);
        this.jMenuItemMultiplier.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemMultiplierActionPerformed(evt);
            }
        });
        this.jMenuOccurrences.add(this.jMenuItemMultiplier);
        this.jCheckBoxMenuItemOccSound.setText("Play confirmation sounds");
        this.jCheckBoxMenuItemOccSound.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jCheckBoxMenuItemOccSoundActionPerformed(evt);
            }
        });
        this.jMenuOccurrences.add(this.jCheckBoxMenuItemOccSound);
        this.jMenuMultiClick.setText("Multi-click behaviour");
        this.buttonGroupClick.add(this.jRadioButtonMenuItemDoubleClick);
        this.jRadioButtonMenuItemDoubleClick.setSelected(true);
        this.jRadioButtonMenuItemDoubleClick.setText("Double-click to count");
        this.jRadioButtonMenuItemDoubleClick.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonMenuItemDoubleClickActionPerformed(evt);
            }
        });
        this.jMenuMultiClick.add(this.jRadioButtonMenuItemDoubleClick);
        this.buttonGroupClick.add(this.jRadioButtonMenuItemContinuousClick);
        this.jRadioButtonMenuItemContinuousClick.setText("Continuous click");
        this.jRadioButtonMenuItemContinuousClick.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonMenuItemContinuousClickActionPerformed(evt);
            }
        });
        this.jMenuMultiClick.add(this.jRadioButtonMenuItemContinuousClick);
        this.jMenuOccurrences.add(this.jMenuMultiClick);
        this.jCheckBoxMenuItemShowOccPopup.setText("Enable pop-up menu");
        this.jCheckBoxMenuItemShowOccPopup.setToolTipText("If this is selected, to decrement counts use Ctrl-Click");
        this.jCheckBoxMenuItemShowOccPopup.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jCheckBoxMenuItemShowOccPopupActionPerformed(evt);
            }
        });
        this.jMenuOccurrences.add(this.jCheckBoxMenuItemShowOccPopup);
        this.jCheckBoxMenuItemExcludeRwCvTotals.setText("Exclude Rw/Cv from displayed totals");
        this.jCheckBoxMenuItemExcludeRwCvTotals.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jCheckBoxMenuItemExcludeRwCvTotalsActionPerformed(evt);
            }
        });
        this.jMenuOccurrences.add(this.jCheckBoxMenuItemExcludeRwCvTotals);
        this.jCheckBoxMenuItemAutoFlagCvRw.setText("Automatically flag caved/reworked \"taxa\"");
        this.jCheckBoxMenuItemAutoFlagCvRw.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jCheckBoxMenuItemAutoFlagCvRwActionPerformed(evt);
            }
        });
        this.jMenuOccurrences.add(this.jCheckBoxMenuItemAutoFlagCvRw);
        this.jMenuOccurrences.add(this.jSeparator15);
        this.jMenuItemNumericCode.setText("Input logging sheet...");
        this.jMenuItemNumericCode.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemNumericCodeActionPerformed(evt);
            }
        });
        this.jMenuOccurrences.add(this.jMenuItemNumericCode);
        this.jMenuBar1.add(this.jMenuOccurrences);
        this.jMenuPicklist.setText("Picklist");
        this.jMenuPicklistView.setText("View");
        this.buttonGroupPickMode.add(this.jRadioButtonMenuItemPickHoriz);
        this.jRadioButtonMenuItemPickHoriz.setText("Multiple columns");
        this.jRadioButtonMenuItemPickHoriz.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonMenuItemPickHorizActionPerformed(evt);
            }
        });
        this.jMenuPicklistView.add(this.jRadioButtonMenuItemPickHoriz);
        this.buttonGroupPickMode.add(this.jRadioButtonMenuItemPickVert);
        this.jRadioButtonMenuItemPickVert.setSelected(true);
        this.jRadioButtonMenuItemPickVert.setText("Single column");
        this.jRadioButtonMenuItemPickVert.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonMenuItemPickVertActionPerformed(evt);
            }
        });
        this.jMenuPicklistView.add(this.jRadioButtonMenuItemPickVert);
        this.jMenuPicklistView.add(this.jSeparator16);
        this.jCheckBoxMenuItemPickAuthor.setSelected(true);
        this.jCheckBoxMenuItemPickAuthor.setText("Include author in taxon names");
        this.jCheckBoxMenuItemPickAuthor.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jCheckBoxMenuItemPickAuthorActionPerformed(evt);
            }
        });
        this.jMenuPicklistView.add(this.jCheckBoxMenuItemPickAuthor);
        this.jCheckBoxMenuItemPickCat.setSelected(true);
        this.jCheckBoxMenuItemPickCat.setText("Include category in taxon names");
        this.jCheckBoxMenuItemPickCat.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jCheckBoxMenuItemPickCatActionPerformed(evt);
            }
        });
        this.jMenuPicklistView.add(this.jCheckBoxMenuItemPickCat);
        this.jCheckBoxMenuItemPickCode.setSelected(true);
        this.jCheckBoxMenuItemPickCode.setText("Include code in taxon names");
        this.jCheckBoxMenuItemPickCode.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jCheckBoxMenuItemPickCodeActionPerformed(evt);
            }
        });
        this.jMenuPicklistView.add(this.jCheckBoxMenuItemPickCode);
        this.jMenuPicklist.add(this.jMenuPicklistView);
        this.jMenuPicklist.add(this.jSeparator10);
        this.jMenuItemPicklistHighlighting.setText("Highlighting...");
        this.jMenuItemPicklistHighlighting.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemPicklistHighlightingActionPerformed(evt);
            }
        });
        this.jMenuPicklist.add(this.jMenuItemPicklistHighlighting);
        this.jMenuSynonymy.setText("Synonymy");
        this.jMenuPicklist.add(this.jMenuSynonymy);
        this.jMenuPicklist.add(this.jSeparator28);
        this.jMenuItemInsertTaxa.setText("Insert taxa...");
        this.jMenuItemInsertTaxa.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemInsertTaxaActionPerformed(evt);
            }
        });
        this.jMenuPicklist.add(this.jMenuItemInsertTaxa);
        this.jMenuItemInsertGroup.setText("Insert group...");
        this.jMenuItemInsertGroup.setToolTipText("Save this list as a text file");
        this.jMenuItemInsertGroup.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemInsertGroupActionPerformed(evt);
            }
        });
        this.jMenuPicklist.add(this.jMenuItemInsertGroup);
        this.jMenuItemInsertWellOutcrop.setText("Insert well/outcrop...");
        this.jMenuItemInsertWellOutcrop.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemInsertWellOutcropActionPerformed(evt);
            }
        });
        this.jMenuPicklist.add(this.jMenuItemInsertWellOutcrop);
        this.jMenuPicklist.add(this.jSeparator8);
        this.jMenuItemPicklistNew.setText("Add new...");
        this.jMenuItemPicklistNew.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemPicklistNewActionPerformed(evt);
            }
        });
        this.jMenuPicklist.add(this.jMenuItemPicklistNew);
        this.jMenuItemPicklistEdit.setText("Edit title...");
        this.jMenuItemPicklistEdit.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemPicklistEditActionPerformed(evt);
            }
        });
        this.jMenuPicklist.add(this.jMenuItemPicklistEdit);
        this.jMenuItemPicklistRemove.setText("Remove selected");
        this.jMenuItemPicklistRemove.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemPicklistRemoveActionPerformed(evt);
            }
        });
        this.jMenuPicklist.add(this.jMenuItemPicklistRemove);
        this.jMenuPicklist.add(this.jSeparator23);
        this.jMenuItemSaveAsGroup.setText("Save as group...");
        this.jMenuItemSaveAsGroup.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemSaveAsGroupActionPerformed(evt);
            }
        });
        this.jMenuPicklist.add(this.jMenuItemSaveAsGroup);
        this.jMenuPicklist.add(this.jSeparator14);
        this.jMenuItemClearSelection.setText("Clear selection");
        this.jMenuItemClearSelection.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemClearSelectionActionPerformed(evt);
            }
        });
        this.jMenuPicklist.add(this.jMenuItemClearSelection);
        this.jMenuItemClear.setText("Clear");
        this.jMenuItemClear.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemClearActionPerformed(evt);
            }
        });
        this.jMenuPicklist.add(this.jMenuItemClear);
        this.jMenuBar1.add(this.jMenuPicklist);
        this.jMenuView.setText("View");
        this.jMenuItemTableOptions.setText("Table options...");
        this.jMenuItemTableOptions.setToolTipText("Options for all instances of selected table");
        this.jMenuItemTableOptions.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemTableOptionsActionPerformed(evt);
            }
        });
        this.jMenuView.add(this.jMenuItemTableOptions);
        this.jMenuItemTableDefaults.setText("Restore table defaults");
        this.jMenuItemTableDefaults.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemTableDefaultsActionPerformed(evt);
            }
        });
        this.jMenuView.add(this.jMenuItemTableDefaults);
        this.jMenuView.add(this.jSeparator24);
        this.jMenu5.setText("Well tab titles");
        this.buttonGroupWellTabTitles.add(this.jRadioButtonMenuItemWellNames);
        this.jRadioButtonMenuItemWellNames.setSelected(true);
        this.jRadioButtonMenuItemWellNames.setText("Well names");
        this.jRadioButtonMenuItemWellNames.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonMenuItemWellNamesActionPerformed(evt);
            }
        });
        this.jMenu5.add(this.jRadioButtonMenuItemWellNames);
        this.buttonGroupWellTabTitles.add(this.jRadioButtonMenuItemWellCodes);
        this.jRadioButtonMenuItemWellCodes.setText("Well codes");
        this.jRadioButtonMenuItemWellCodes.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonMenuItemWellCodesActionPerformed(evt);
            }
        });
        this.jMenu5.add(this.jRadioButtonMenuItemWellCodes);
        this.buttonGroupWellTabTitles.add(this.jRadioButtonMenuItemWellAltNames);
        this.jRadioButtonMenuItemWellAltNames.setText("Alternate well names (if set)");
        this.jRadioButtonMenuItemWellAltNames.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonMenuItemWellAltNamesActionPerformed(evt);
            }
        });
        this.jMenu5.add(this.jRadioButtonMenuItemWellAltNames);
        this.jMenuView.add(this.jMenu5);
        this.jMenuView.add(this.jSeparator25);
        this.jMenuItemViewFilteredOccs.setText("Filtered occurrences...");
        this.jMenuItemViewFilteredOccs.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemViewFilteredOccsActionPerformed(evt);
            }
        });
        this.jMenuView.add(this.jMenuItemViewFilteredOccs);
        this.jRadioButtonMenuItemDisplayCuttingCorrections.setSelected(true);
        this.jRadioButtonMenuItemDisplayCuttingCorrections.setText("Display core corrections for cuttings");
        this.jRadioButtonMenuItemDisplayCuttingCorrections.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonMenuItemDisplayCuttingCorrectionsActionPerformed(evt);
            }
        });
        this.jMenuView.add(this.jRadioButtonMenuItemDisplayCuttingCorrections);
        this.jMenuView.add(this.jSeparator22);
        this.jMenuItemViewSelectInAllWells.setText("Select this tab for all open wells");
        this.jMenuItemViewSelectInAllWells.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemViewSelectInAllWellsActionPerformed(evt);
            }
        });
        this.jMenuView.add(this.jMenuItemViewSelectInAllWells);
        this.jMenuBar1.add(this.jMenuView);
        this.jMenuHelp.setText("Help");
        this.jMenuItemHelpHome.setText("Samples & Interpretations help...");
        this.jMenuItemHelpHome.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemHelpHomeActionPerformed(evt);
            }
        });
        this.jMenuHelp.add(this.jMenuItemHelpHome);
        this.jMenuItemHelpMenu.setText("Menus...");
        this.jMenuItemHelpMenu.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemHelpMenuActionPerformed(evt);
            }
        });
        this.jMenuHelp.add(this.jMenuItemHelpMenu);
        this.jMenuHelp.add(this.jSeparator3);
        this.jMenuItemHelpSamples.setText("Samples tab...");
        this.jMenuItemHelpSamples.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemHelpSamplesActionPerformed(evt);
            }
        });
        this.jMenuHelp.add(this.jMenuItemHelpSamples);
        this.jMenuItemHelpAnalyses.setText("Analyses tab...");
        this.jMenuItemHelpAnalyses.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemHelpAnalysesActionPerformed(evt);
            }
        });
        this.jMenuHelp.add(this.jMenuItemHelpAnalyses);
        this.jMenuItemHelpOccurrences.setText("Occurrences tab...");
        this.jMenuItemHelpOccurrences.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemHelpOccurrencesActionPerformed(evt);
            }
        });
        this.jMenuHelp.add(this.jMenuItemHelpOccurrences);
        this.jMenuItemHelpInterp.setText("Interpretations tab...");
        this.jMenuItemHelpInterp.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemHelpInterpActionPerformed(evt);
            }
        });
        this.jMenuHelp.add(this.jMenuItemHelpInterp);
        this.jMenuItemHelpchart.setText("Charts tab...");
        this.jMenuItemHelpchart.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemHelpchartActionPerformed(evt);
            }
        });
        this.jMenuHelp.add(this.jMenuItemHelpchart);
        this.jMenuHelp.add(this.jSeparator1);
        this.jMenuItemHelpSchemes.setText("Stratigraphic schemes...");
        this.jMenuItemHelpSchemes.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemHelpSchemesActionPerformed(evt);
            }
        });
        this.jMenuHelp.add(this.jMenuItemHelpSchemes);
        this.jMenuItemHelpPicklist.setText("Picklist...");
        this.jMenuItemHelpPicklist.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemHelpPicklistActionPerformed(evt);
            }
        });
        this.jMenuHelp.add(this.jMenuItemHelpPicklist);
        this.jMenuHelp.add(this.jSeparator9);
        this.jMenuItemHelpOverlays.setText("Overlays...");
        this.jMenuItemHelpOverlays.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemHelpOverlaysActionPerformed(evt);
            }
        });
        this.jMenuHelp.add(this.jMenuItemHelpOverlays);
        this.jMenuBar1.add(this.jMenuHelp);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jSplitPane1, -1, 1441, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.jSplitPane1));
        this.jSplitPane1.setRightComponent(this.jTabbedPaneSchemes);
        this.jSplitPane1.setLeftComponent(jTabbedPaneWell);
        this.pack();
    }

    private void jButtonSchemeZoomOutActionPerformed(ActionEvent evt) {
        this.schemeChartJPanel.getZoomManager().zoomOut();
        this.setSchemeScrollPaneSize();
    }

    private void jButtonSchemeZoomInActionPerformed(ActionEvent evt) {
        this.schemeChartJPanel.getZoomManager().zoomIn();
        this.setSchemeScrollPaneSize();
    }

    private void jButtonSchemePanelProperitesActionPerformed(ActionEvent evt) {
        SchemeBlock block = null;
        for (ChartBlockBase b : this.schemeChartJPanel.chart.getBlocks()) {
            if (!(b instanceof SchemeBlock)) continue;
            block = (SchemeBlock)b;
            break;
        }
        if (block != null) {
            DialogChartProperties dialog = new DialogChartProperties(this, true, this.schemeChartJPanel.chart.getProperties(), this.sbdb, block, false, true, true, false);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.isOK()) {
                ((JScrollPaneChartBase)this.jScrollPaneSchemeChart).refreshView();
                try {
                    this.writeSchemeChartPref();
                }
                catch (SQLException sql) {
                    SbugsExceptionHandler.showStackError(sql, this);
                }
            }
        }
    }

    private void jButtonSelectSchemePanelActionPerformed(ActionEvent evt) {
        int opt;
        if (this.schemeChartJPanel.chart.getnBlocks(BlockType.SCHEME) > 1 && (opt = JOptionPane.showConfirmDialog(this, "Panels not belonging to scheme template will be lost. Continue?", this.getTitle(), 0)) != 0) {
            return;
        }
        DialogChartTemplates dialog = new DialogChartTemplates(this, true, this.sbdb, this.parent.getChartManager(), BlockType.SCHEME, null, null);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.selection != null && dialog.selection.size() == 1 && dialog.selection.get(0) instanceof BlockTemplate) {
            BlockTemplate templ = (BlockTemplate)dialog.selection.get(0);
            ChartTemplate.BlockOcc bOcc = this.schemeChartJPanel.chart.getBlocks().isEmpty() ? null : new ChartTemplate.BlockOcc(templ.getID(), 0, 0, 0, this.schemeChartJPanel.chart.getBlocks().get(0).getProperties(), null);
            this.setSchemeBlock(templ, bOcc);
        }
        this.setSchemeChartVersion();
        ((JScrollPaneChartBase)this.jScrollPaneSchemeChart).refreshView();
        try {
            this.writeSchemeChartPref();
        }
        catch (SQLException sql) {
            SbugsExceptionHandler.showStackError(sql, this);
        }
    }

    private void setSchemeBlock(BlockTemplate templ, ChartTemplate.BlockOcc occ) {
        for (ChartBlockBase b : this.schemeChartJPanel.chart.getBlocks()) {
            if (b instanceof SchemeBlock && b.getTemplate() != null && b.getTemplate() == templ) {
                JOptionPane.showMessageDialog(this, "This template is already open.", this.getTitle(), 1);
                return;
            }
            this.schemeChartJPanel.chart.removeBlock(b);
        }
        try {
            this.schemeChartJPanel.chart.addBlock(ChartFactory.createBlock(this.sbdb, templ, occ));
            this.setSchemeTabTitle();
        }
        catch (RuntimeException | SQLException | SBException e) {
            SbugsExceptionHandler.showStackError(e, this);
        }
    }

    void addChartScheme(IGDScheme scheme) throws SQLException, SBException {
        int opt;
        ArrayList<PanelTemplate> panels = new ArrayList<PanelTemplate>();
        PanelType type = PanelType.getSchemeType(scheme.getIGDType());
        int schemeID = scheme.getID();
        PanelType[] pTypes = type == PanelType.SEQUENCE ? new PanelType[]{PanelType.SEQUENCE, PanelType.SURFACE} : new PanelType[]{type};
        for (PanelType pType : pTypes) {
            boolean schemeAdded = false;
            ArrayList<PanelTemplate> candidates = new ArrayList<PanelTemplate>();
            for (PanelTemplate panel : this.parent.getChartManager().getPanels(pType, 0, true)) {
                int panelSchemeID = panel.getProperties().getIGDSchemeID();
                if (panelSchemeID != schemeID) continue;
                candidates.add(panel);
            }
            if (!candidates.isEmpty()) {
                if (candidates.size() == 1) {
                    panels.add((PanelTemplate)candidates.get(0));
                } else {
                    DialogList dialog = new DialogList(this, true, "Select Panel Template", null, candidates, true, false);
                    dialog.setLocationRelativeTo(this);
                    dialog.setVisible(true);
                    dialog.getOptionalSelection().ifPresent(panelTemplate -> panels.add((PanelTemplate)panelTemplate));
                }
                schemeAdded = true;
            }
            if (schemeAdded) continue;
            if (SBRestrictable.canWrite(this.sbdb)) {
                int opt2 = JOptionPane.showConfirmDialog(this, "No global panel template for scheme '" + String.valueOf(scheme) + "'.\nDo you want to create one?", this.getTitle(), 0);
                if (opt2 != 0) continue;
                String comments = "Samples & Interpretations";
                try {
                    panels.add(this.parent.getChartManager().addPanelTemplate(pType, scheme.toString(), comments, 0, null, scheme, true));
                    continue;
                }
                catch (SBPermissionException pe) {
                    JOptionPane.showMessageDialog(this, pe.getMessage(), this.getTitle(), 2);
                    return;
                }
            }
            JOptionPane.showMessageDialog(this, "No global panel template for scheme '" + String.valueOf(scheme) + "'.\nYou do not have permission to create one.", this.getTitle(), 2);
            return;
        }
        SchemeBlock untemplated = null;
        for (ChartBlockBase block : this.schemeChartJPanel.chart.getBlocks()) {
            if (!(block instanceof SchemeBlock) || block.getTemplate() != null) continue;
            untemplated = (SchemeBlock)block;
            break;
        }
        if (untemplated == null) {
            for (ChartBlockBase existing : this.schemeChartJPanel.chart.getBlocks()) {
                if (!(existing instanceof SchemeBlock) || existing.getTemplate() == null) continue;
                untemplated = new SchemeBlock(this.sbdb, null, ((SchemeBlock)existing).getProp());
            }
            if (untemplated == null) {
                untemplated = new SchemeBlock(this.sbdb);
            }
            this.schemeChartJPanel.chart.addBlock(untemplated);
        }
        ListIterator lit = panels.listIterator();
        block9: while (lit.hasNext()) {
            PanelTemplate templ = (PanelTemplate)lit.next();
            for (SBPanel p : untemplated.getPanels()) {
                if (p.getTemplateID().intValue() != templ.getID()) continue;
                JOptionPane.showMessageDialog(this, "'" + templ.getName() + "' is already plotted.", this.getTitle(), 2);
                lit.remove();
                continue block9;
            }
        }
        if (panels.isEmpty()) {
            return;
        }
        float minAge = (float)scheme.getMinAge();
        float maxAge = (float)scheme.getMaxAge();
        if ((untemplated.getProp().getMin() > minAge || untemplated.getProp().getMax() < maxAge) && (opt = JOptionPane.showConfirmDialog(this, "Expand age range to " + minAge + " - " + maxAge + " Ma?", "Plot Schemes", 0)) == 0) {
            untemplated.getProp().setLimits(minAge, maxAge);
        }
        try {
            for (PanelTemplate templ : panels) {
                untemplated.addPanel((SBPanel)PanelFactory.createPanel(untemplated, templ, null));
            }
            this.schemeChartJPanel.chart.setData();
        }
        catch (SQLException | SBException sql) {
            FrameJsbugs.showStackError("Error", (Exception)sql, this.sbdb);
        }
        catch (IOException e) {
            StackError.showStackError((String)"Error", (Throwable)e);
        }
        this.schemeChartJPanel.chart.calcChartSize();
        this.setSchemeScrollPaneSize();
        this.setSchemeTabTitle();
        Point2D p = this.schemeChartJPanel.chart.getSchemeOrigin(scheme);
        Point p2 = this.schemeChartJPanel.getPosition(p);
        Rectangle visible = this.schemeChartJPanel.getVisibleRect();
        Rectangle r = new Rectangle(p2.x, p2.y, visible.width, visible.height);
        this.schemeChartJPanel.scrollRectToVisible(r);
        this.jTabbedPaneSchemes.setSelectedComponent(this.jPanelScheme);
    }

    private void setSchemeScrollPaneSize() {
        this.schemeChartJPanel.setSize();
        this.schemeChartJPanel.revalidate();
        this.schemeChartJPanel.repaint();
    }

    private void setSchemeTabTitle() {
        int index;
        ChartBlockBase chartBlockBase;
        String title = "Stratigraphic Schemes";
        if (this.schemeChartJPanel.chart.getBlocks().size() == 1 && (chartBlockBase = this.schemeChartJPanel.chart.getBlocks().get(0)).getTemplate() != null) {
            title = chartBlockBase.getTemplate().getName();
        }
        if ((index = this.jTabbedPaneSchemes.indexOfComponent(this.jPanelScheme)) > -1) {
            this.jTabbedPaneSchemes.setTitleAt(index, title);
        }
    }

    private void jMenuItemTableOptionsActionPerformed(ActionEvent evt) {
        TableModelSB model = this.getWellPanel().getSelectedTable();
        LinkedList<TablePair> tables = new LinkedList<TablePair>();
        if (model != null) {
            for (JPanelWell wellPanel : this.getWellPanels()) {
                LinkedList<TablePair> tablePairs = wellPanel.getTablePair(model);
                if (tablePairs == null || tablePairs.isEmpty()) continue;
                tables.addAll(tablePairs);
            }
        }
        if (tables.isEmpty()) {
            return;
        }
        DialogTableOptions dialog = new DialogTableOptions((Frame)this, true, tables);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }

    void insertWell(JPanelPicklist list) {
        final JPanelPicklist picklist = this.getSelectedPicklist(list);
        Well well = null;
        JPanelWell wellPanel = this.getWellPanel();
        if (wellPanel != null) {
            well = wellPanel.getWell();
        }
        final DialogWellDisc dialog = new DialogWellDisc(this, true, this.sbdb, well, false);
        dialog.setLocationRelativeTo(this);
        dialog.setAlwaysOnTop(true);
        dialog.setVisible(true);
        if (dialog.isOK) {
            if (well != null && dialog.wells.contains(well)) {
                try {
                    Sample topSample = this.getWellPanel().getSelectedTopSample();
                    Sample baseSample = this.getWellPanel().getSelectedBaseSample();
                    if (baseSample == topSample) {
                        baseSample = null;
                    }
                    if (topSample != null | baseSample != null) {
                        int opt = JOptionPane.showConfirmDialog(this, "Restrict to depth range: " + (String)(topSample != null ? " >= " + topSample.getDepth(this.getWellPanel().units) : "") + (String)(baseSample != null ? " <= " + baseSample.getDepth(this.getWellPanel().units) : "") + "?", this.getTitle(), 0);
                        if (opt == 1) {
                            baseSample = null;
                            topSample = null;
                            this.restrictPicklistToSelectedSamples = false;
                        } else {
                            this.restrictPicklistToSelectedSamples = true;
                        }
                    }
                }
                catch (SQLException | SBException sqle) {
                    sqle.printStackTrace();
                }
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            EventQueue.invokeLater(new Runnable(){
                final /* synthetic */ FrameSamples this$0;
                {
                    FrameSamples frameSamples = this$0;
                    Objects.requireNonNull(frameSamples);
                    this.this$0 = frameSamples;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        TxGroup group;
                        LinkedList<Taxon> wellTaxa = new LinkedList<Taxon>();
                        for (Well well : dialog.wells) {
                            if (this.this$0.getWellPanel() != null && this.this$0.getWellPanel().getWell() == well && this.this$0.restrictPicklistToSelectedSamples) {
                                Sample topSample = this.this$0.getWellPanel().getSelectedTopSample();
                                Sample baseSample = this.this$0.getWellPanel().getSelectedBaseSample();
                                if (baseSample == topSample) {
                                    baseSample = null;
                                }
                                wellTaxa.addAll(this.this$0.sbdb.getWellTaxa(well, dialog.discID, dialog.analyst, topSample, baseSample));
                                continue;
                            }
                            wellTaxa.addAll(this.this$0.sbdb.getWellTaxa(well, dialog.discID, dialog.analyst));
                        }
                        picklist.setTaxa(wellTaxa);
                        if (picklist.getGroupID() > 0 && (group = this.this$0.sbdb.getTxGroup(picklist.getGroupID())) != null && this.this$0.jTabbedPaneSchemes.getTitleAt(this.this$0.jTabbedPaneSchemes.getSelectedIndex()).equals(group.getName())) {
                            this.this$0.jTabbedPaneSchemes.setTitleAt(this.this$0.jTabbedPaneSchemes.getSelectedIndex(), "Picklist");
                        }
                    }
                    catch (Exception e) {
                        StackError.showStackError((String)"Error inserting into picklist", (Throwable)e);
                    }
                    finally {
                        this.this$0.setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
            });
        }
        this.setAlwaysOnTop(true);
        this.setAlwaysOnTop(false);
    }

    private void jMenuItemInsertWellOutcropActionPerformed(ActionEvent evt) {
        this.insertWell(null);
    }

    void setPicklistGroupTitle(TxGroup group) {
        Component[] component = this.jTabbedPaneSchemes.getComponents();
        for (int i = 0; i < component.length; ++i) {
            JPanelPicklist pl;
            if (!(component[i] instanceof JPanelPicklist) || (pl = (JPanelPicklist)component[i]).getGroupID() != group.getID()) continue;
            this.jTabbedPaneSchemes.setTitleAt(i, group.getName());
        }
    }

    private void jMenuItemInsertGroupActionPerformed(ActionEvent evt) {
        if (this.getSelectedPicklist() != null) {
            this.getSelectedPicklist().insertGroup();
        } else {
            JOptionPane.showMessageDialog(this, "Select a picklist", "Add to Picklist", 2);
        }
    }

    void renamePicklist(JPanelPicklist caller, String name) {
        Component[] component = this.jTabbedPaneSchemes.getComponents();
        for (int i = 0; i < component.length; ++i) {
            if (!(component[i] instanceof JPanelPicklist) || component[i] != caller) continue;
            this.jTabbedPaneSchemes.setTitleAt(i, name);
            return;
        }
    }

    private void jMenuItemInsertTaxaActionPerformed(ActionEvent evt) {
        JPanelPicklist picklist = this.getSelectedPicklist();
        if (picklist == null) {
            JOptionPane.showMessageDialog(this, "No picklist selected!", "Add to picklist", 2);
            return;
        }
        picklist.addTaxonPick();
    }

    void exit(boolean force) {
        if (!force && this.checkExit() == ExitStatus.NO_EXIT) {
            return;
        }
        for (FrameWellChartsDetached chartsFrame : this.chartsFrames) {
            chartsFrame.exit();
        }
        for (FrameWellDetached frame : this.wellFrames) {
            frame.dispose();
        }
        if (this.getWellPanel() != null) {
            this.getWellPanel().putTableColumnWidths();
        }
        this.encodeSession();
        this.dispose();
    }

    public ExitStatus checkExit() {
        int nUnsaved = 0;
        ExitStatus exitStatus = ExitStatus.EXIT_UNCONFIRMED;
        for (JPanelPicklist picklist : this.picklists) {
            if (!picklist.isUnsaved()) continue;
            ++nUnsaved;
        }
        if (nUnsaved > 0) {
            String msg = nUnsaved + (nUnsaved > 1 ? " picklists are" : " picklist is") + " unsaved. Exit without saving?";
            if (JOptionPane.showConfirmDialog(this, msg, "Exit", 0) != 0) {
                return ExitStatus.NO_EXIT;
            }
            exitStatus = ExitStatus.EXIT_CONFIRMED;
        }
        return exitStatus;
    }

    private void jMenuItemExitActionPerformed(ActionEvent evt) {
        this.exit(false);
    }

    private LinkedList<JPanelWell> getWellPanels() {
        LinkedList<JPanelWell> wellPanels = new LinkedList<JPanelWell>();
        for (Component c : this.jTabbedPaneWell.getComponents()) {
            if (!(c instanceof JPanelWell)) continue;
            wellPanels.add((JPanelWell)c);
        }
        return wellPanels;
    }

    void updateChartProperties(final int blockTemplateID, final ChartProperties updatedProperties) {
        SwingWorker task = new SwingWorker(this){
            final /* synthetic */ FrameSamples this$0;
            {
                FrameSamples frameSamples = this$0;
                Objects.requireNonNull(frameSamples);
                this.this$0 = frameSamples;
            }

            protected Object doInBackground() {
                try {
                    for (JPanelWell wellPanel : this.this$0.getWellPanels()) {
                        wellPanel.updateChartProperties(blockTemplateID, updatedProperties);
                    }
                }
                catch (SQLException sql) {
                    FrameJsbugs.showStackError("SQL Error - some tabs may not be updated", sql, this.this$0.sbdb);
                }
                catch (IOException | SBException sbe) {
                    StackError.showStackError((String)"Error - some tabs may not be updated", (Throwable)sbe);
                }
                return null;
            }
        };
        task.execute();
    }

    private void jMenuItemParseSampleActionPerformed(ActionEvent evt) {
        JOptionPane.showMessageDialog(this, "Not implemented - dialog for illustration only.\nWe have work in progress that can be completed if it will be of use, contact StrataData for details.", this.getTitle(), 2);
        DialogParseSample dialog = new DialogParseSample((Frame)this, true);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }

    private void jMenuItemClearActionPerformed(ActionEvent evt) {
        if (this.getSelectedPicklist() != null) {
            this.getSelectedPicklist().clear();
        }
    }

    private void jMenuItemClearSelectionActionPerformed(ActionEvent evt) {
        if (this.getSelectedPicklist() != null) {
            this.getSelectedPicklist().clearSelection();
        }
    }

    private void jMenuItemSaveAsGroupActionPerformed(ActionEvent evt) {
        if (this.getSelectedPicklist() == null) {
            JOptionPane.showMessageDialog(this, "Select a picklist", "Save as group", 2);
            return;
        }
        this.getSelectedPicklist().saveAsGroup();
    }

    private void jMenuItemPrintChartActionPerformed(ActionEvent evt) {
        this.getWellPanel().printChart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jMenuItemSelectWellActionPerformed(ActionEvent evt) {
        try {
            if (!SbugsLicense.checkRLMlicense()) {
                JOptionPane.showMessageDialog(this, "StrataBugs licence no longer available.", "StrataBugs", 0);
                this.dispose();
                return;
            }
            Object[] options = new String[]{this.resources.getString("button.yes"), this.resources.getString("button.no"), this.resources.getString("button.cancel")};
            int opt = JOptionPane.showOptionDialog(this, "Clear existing wells?", "Open Well", 1, 3, null, options, options[1]);
            if (opt == 2 || opt == -1) {
                return;
            }
            DialogSelectWell dialog = new DialogSelectWell(this, true, this.sbdb, true);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.getSelection() != null) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                if (opt == 0) {
                    for (JPanelWell wellPanel : this.getWellPanels()) {
                        wellPanel.removeChart();
                        wellPanel.closeOverlayServer();
                    }
                    this.removeAllPicklistListeners();
                    this.jTabbedPaneWell.closeAllTabs();
                }
                for (Well well : dialog.getSelection()) {
                    this.addWellTab(well);
                }
                if (this.getSelectedPicklist() != null) {
                    this.getSelectedPicklist().notifyTaxonSelectionListeners();
                }
            }
        }
        catch (Exception e) {
            StackError.showStackError((String)"Error opening well tab", (Throwable)e);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void formWindowGainedFocus(WindowEvent evt) {
    }

    private void formWindowLostFocus(WindowEvent evt) {
    }

    private void jMenuItemCloseWellActionPerformed(ActionEvent evt) {
        this.jTabbedPaneWell.closeTabAt(this.jTabbedPaneWell.getSelectedIndex(), false);
    }

    private void beforeCloseTab(JPanelWell panel) {
        if (panel != null) {
            this.removeTaxonSelectionListener(panel.tableModelAnalyses);
        }
    }

    public void removeWell(Well well) {
        boolean removed = this.jTabbedPaneWell.removeWell(well);
        if (!removed) {
            for (FrameWellDetached wellFrame : this.wellFrames) {
                if (wellFrame.getPanel().well.getWellID() != well.getWellID()) continue;
                JPanelWell panel = wellFrame.getPanel();
                panel.removeChart();
                panel.closeOverlayServer();
                wellFrame.exit();
                this.jTabbedPaneWell.remove(panel);
                removed = true;
                break;
            }
        }
        if (removed && this.jTabbedPaneWell.getTabCount() == 0) {
            this.dispose();
        }
    }

    private void jMenuItemDetachWellActionPerformed(ActionEvent evt) {
        if (this.getWellPanels().size() == 1) {
            JOptionPane.showMessageDialog(this, "Cannot detach - there is only one well tab.", this.getTitle(), 2);
            return;
        }
        JPanelWell panel = (JPanelWell)this.jTabbedPaneWell.getSelectedComponent();
        this.jTabbedPaneWell.remove(panel);
        FrameWellDetached frame = new FrameWellDetached(this, panel);
        frame.setVisible(true);
        this.wellFrames.add(frame);
    }

    private void formWindowClosing(WindowEvent evt) {
        this.exit(false);
    }

    private void jRadioButtonMenuItemQuantActionPerformed(ActionEvent evt) {
        this.setNumeric();
    }

    private void jRadioButtonMenuItemSemiQuantActionPerformed(ActionEvent evt) {
        this.setNumeric();
    }

    private void setNumeric() {
        for (JPanelPicklist picklist : this.picklists) {
            picklist.setControls(this.isCMF(), this.isNumeric());
        }
        if (this.dialogTaxonCodeInput != null) {
            this.dialogTaxonCodeInput.setNumeric();
        }
        try {
            Lastval.putInt(this.sbdb, "SEMIQUANT", this.isNumeric() ? 0 : 1);
            this.sbdb.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jCheckBoxMenuItemGrainSizeActionPerformed(ActionEvent evt) {
        if (this.parent.getFrameOverlay() != null) {
            this.parent.getFrameOverlay().setCMF(this.isCMF());
        }
        for (JPanelPicklist picklist : this.picklists) {
            picklist.setControls(this.isCMF(), this.isNumeric());
        }
        for (JPanelWell wellPanel : this.getWellPanels()) {
            wellPanel.setCMF(this.isCMF());
        }
    }

    private void jMenuItemOpenOverlayActionPerformed(ActionEvent evt) {
        this.getWellPanel().openOverlay();
    }

    void setOverlayTotaliser() {
        if (this.parent.getFrameOverlay() != null) {
            this.parent.getFrameOverlay().jPanelOverlay.setTotaliser(this.picklistTotaliser);
        }
    }

    private void jMenuItemNewOverlayActionPerformed(ActionEvent evt) {
        if (this.parent.getFrameOverlay() != null) {
            JOptionPane.showMessageDialog(this, "An overlay is currently in use.", this.getTitle(), 2);
            return;
        }
        try {
            DialogOverlay dialog = new DialogOverlay(this, true, this.sbdb, null);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.overlay != null) {
                FrameOverlay frameOverlay = new FrameOverlay(this.parent.getAltGC(), this.parent, this.sbdb, this.getWellPanel().well, this.getWellPanel().getSmpdtl(), dialog.overlay, this.isCMF(), this);
                frameOverlay.setDesignMode();
                this.parent.setFrameOverlay(frameOverlay);
                frameOverlay.getUndoSupport().addUndoableEditListener(this.getWellPanel().undoManagerOccs);
                this.setOverlayTotaliser();
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error creating overlay frame: " + e.getMessage(), this.getTitle(), 0);
            e.printStackTrace();
        }
    }

    private void jTabbedPaneWellStateChanged(ChangeEvent evt) {
        for (Component c : this.jTabbedPaneWell.getComponents()) {
            if (c == this.jTabbedPaneWell.getSelectedComponent()) continue;
            ((JPanelWell)c).hideBlockPropertiesDialog();
        }
        this.setSchemeChartVersion();
    }

    private void jMenuItemOverlayEditActionPerformed(ActionEvent evt) {
        if (this.parent.getFrameOverlay() == null) {
            JOptionPane.showMessageDialog(this, "No overlay currently selected.", this.getTitle(), 2);
            return;
        }
        try {
            DialogOverlay dialog = new DialogOverlay(this, true, this.sbdb, this.parent.getFrameOverlay().getOverlay());
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.overlay != null) {
                this.parent.getFrameOverlay().setVisible(true);
                this.parent.getFrameOverlay().repaint();
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error: " + e.getMessage(), this.getTitle(), 0);
            e.printStackTrace();
        }
    }

    private void jMenuItemHelpMenuActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("samples_menu.html");
    }

    private void jMenuItemHelpSamplesActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("samples_samplestab.html");
    }

    private void jMenuItemHelpAnalysesActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("samples_analysestab.html");
    }

    private void jMenuItemHelpOccurrencesActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("samples_occurrencestab.html");
    }

    private void jMenuItemHelpInterpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("samples_interpretationstab.html");
    }

    private void jMenuItemHelpchartActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("samples_chartstab.html");
    }

    private void jMenuItemHelpSchemesActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("samples_schemestab.html");
    }

    private void jMenuItemHelpPicklistActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("samples_picklisttab.html");
    }

    private void jCheckBoxMenuItemTotaliserActionPerformed(ActionEvent evt) {
        if (this.picklistTotaliser == 0) {
            String strg = JOptionPane.showInputDialog(this, "Enter analysis total", 100);
            if (strg != null) {
                try {
                    int total;
                    this.picklistTotaliser = total = Integer.parseInt(strg);
                    this.jCheckBoxMenuItemTotaliser.setText("Count limit set to: " + total);
                    if (this.parent.getFrameOverlay() != null) {
                        this.parent.getFrameOverlay().jPanelOverlay.setTotaliser(total);
                    }
                    Lastval.putInt(this.sbdb, "PICKTOTAL", total);
                    this.sbdb.commit();
                }
                catch (Exception ex) {
                    this.jCheckBoxMenuItemTotaliser.setSelected(false);
                    this.jCheckBoxMenuItemTotaliser.setText("Set count limit");
                    return;
                }
            } else {
                this.jCheckBoxMenuItemTotaliser.setSelected(false);
            }
            this.getWellPanel().setNTaxaText();
        } else {
            this.picklistTotaliser = 0;
            this.jCheckBoxMenuItemTotaliser.setSelected(false);
            this.jCheckBoxMenuItemTotaliser.setText("Set count limit");
            if (this.parent.getFrameOverlay() != null) {
                this.parent.getFrameOverlay().jPanelOverlay.setTotaliser(0);
            }
            ((JPanelWell)this.jTabbedPaneWell.getSelectedComponent()).setNTaxaText();
            try {
                Lastval.putInt(this.sbdb, "PICKTOTAL", 0);
                this.sbdb.commit();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jMenuItemOpenProjectActionPerformed(ActionEvent evt) {
        DialogSelectProjectWellList dialog;
        int opt = 1;
        if (this.jTabbedPaneWell.getComponentCount() > 0 && ((opt = JOptionPane.showConfirmDialog(this, "Clear existing wells?", "Open project", 1, 3)) == 2 || opt == -1)) {
            return;
        }
        try {
            dialog = new DialogSelectProjectWellList((Window)this, this.sbdb, null, null);
        }
        catch (RuntimeException e) {
            SbugsExceptionHandler.showDialogStackError(e, this);
            return;
        }
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.getSelection() != null) {
            if (opt == 0) {
                this.jTabbedPaneWell.removeAll();
            }
            try {
                this.setCursor(Cursor.getPredefinedCursor(3));
                Iterator<Well> it = this.sbdb.getWellIterator(dialog.getSelection().getID());
                while (it.hasNext()) {
                    this.addWellTab(it.next());
                }
            }
            catch (RuntimeException | SQLException | SBException e) {
                SbugsExceptionHandler.showStackError("Error loading wells", e, this);
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    private void jMenuItemAbnSchemesActionPerformed(ActionEvent evt) {
        try {
            DialogAbnSchemes dialog = new DialogAbnSchemes((Frame)this, this.sbdb);
            SB.centreDialog((Dialog)dialog);
            dialog.setVisible(true);
        }
        catch (RuntimeException ex) {
            SbugsExceptionHandler.showDialogStackError(ex, this);
        }
    }

    private void jMenuItemCreateVoiceRecognitionFileActionPerformed(ActionEvent evt) {
        JOptionPane.showMessageDialog(this, "Not implemented.\nWe have work in progress that can be completed if it will be of use, contact StrataData for details.", this.getTitle(), 1);
    }

    private void jMenuItemMultiplierActionPerformed(ActionEvent evt) {
        JOptionPane.showMessageDialog(this, "Not implemented.", this.getTitle(), 1);
    }

    private void jMenuItemHelpHomeActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("samples.html");
    }

    private void jMenuItemPrintAnalysesActionPerformed(ActionEvent evt) {
        JPanelWell panel = (JPanelWell)this.jTabbedPaneWell.getSelectedComponent();
        List<Smpdtl> smpdtls = panel.getSelectedSmpdtls();
        if (smpdtls == null || smpdtls.isEmpty()) {
            JOptionPane.showMessageDialog(this, "Select one or more analyses", this.getTitle(), 1);
            return;
        }
        PrinterJob job = PrinterJob.getPrinterJob();
        if (!job.printDialog()) {
            return;
        }
        PageFormat pf = job.defaultPage();
        LinkedList<LoggingSheet> logSheets = new LinkedList<LoggingSheet>();
        try {
            block4: for (Smpdtl smpdtl : smpdtls) {
                LoggingSheet logSheet = new LoggingSheet(panel.getWell(), smpdtl, this.sbdb.getUser(), panel.units);
                logSheets.add(logSheet);
                if (panel.getInterp() == null) continue;
                for (Biocom comment : panel.getInterp().getComments()) {
                    if (comment.getDiscID() != smpdtl.getDiscID() || comment.getTopID() != smpdtl.getSample().getSampID() || !comment.getAnalystString().equals(smpdtl.getAnalystAbr())) continue;
                    logSheet.setBSComment(comment.getText());
                    continue block4;
                }
            }
            this.decodeLogSheetPrefs(logSheets);
            PrintJPanel printPanel = new PrintJPanel(logSheets, pf);
            DialogPrintPreview dialog = new DialogPrintPreview(this, true, logSheets, printPanel, job, pf, this.sbdb);
            dialog.setVisible(true);
            if (dialog.isPrint) {
                job.setPrintable(printPanel, dialog.pf);
            }
            try {
                job.print();
            }
            catch (Exception exp) {
                JOptionPane.showMessageDialog(this, "Problem printing");
                exp.printStackTrace();
            }
        }
        catch (SQLException | SBException sql) {
            sql.printStackTrace();
        }
    }

    private void jMenuItemViewFilteredOccsActionPerformed(ActionEvent evt) {
        if (this.getWellPanel().getWell() == null) {
            JOptionPane.showMessageDialog(this, "No well panel selected.", this.getTitle(), 1);
            return;
        }
        DialogTaxonWellOccFiltered dialog = new DialogTaxonWellOccFiltered((Frame)this, true, this.getWellPanel().getWell(), DepthUnits.getUnits((char)this.getWellPanel().units));
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }

    private void jMenuItemDetachChartActionPerformed(ActionEvent evt) {
        JPanelWell panel = (JPanelWell)this.jTabbedPaneWell.getSelectedComponent();
        if (panel == null || !(panel instanceof JPanelWell)) {
            JOptionPane.showMessageDialog(this, "No well panel selected.", this.getTitle(), 1);
            return;
        }
        if (!panel.detachChartTab()) {
            JOptionPane.showMessageDialog(this, "Chart tab already detached for this well", this.getTitle(), 1);
        } else {
            this.chartsFrames.add(panel.chartsFrameDetached);
        }
    }

    private void jMenuItemHelpOverlaysActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("howtouseoverlays.html");
    }

    private void jCheckBoxMenuItemPickAuthorActionPerformed(ActionEvent evt) {
        Taxon.includeAuthorInString = this.jCheckBoxMenuItemPickAuthor.isSelected();
        try {
            Lastval.putInt(this.sbdb, "TAXONAUTH", Taxon.includeAuthorInString ? 1 : 0);
            this.sbdb.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (JPanelPicklist list : this.picklists) {
            list.repaintList();
        }
    }

    private void jCheckBoxMenuItemPickCatActionPerformed(ActionEvent evt) {
        Taxon.includeCategoryInString = this.jCheckBoxMenuItemPickCat.isSelected();
        try {
            Lastval.putInt(this.sbdb, "TAXONCAT", Taxon.includeCategoryInString ? 1 : 0);
            this.sbdb.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (JPanelPicklist list : this.picklists) {
            list.repaintList();
        }
    }

    private void jRadioButtonMenuItemLoggingActionPerformed(ActionEvent evt) {
        this.setLogging(true);
    }

    private void jRadioButtonMenuItemBrowsingActionPerformed(ActionEvent evt) {
        this.setLogging(false);
    }

    private void jRadioButtonMenuItemPickHorizActionPerformed(ActionEvent evt) {
        JPanelPicklist picklist = this.getSelectedPicklist(null);
        if (picklist != null) {
            picklist.setListLayout(1);
        }
    }

    private void jRadioButtonMenuItemPickVertActionPerformed(ActionEvent evt) {
        JPanelPicklist picklist = this.getSelectedPicklist(null);
        if (picklist != null) {
            picklist.setListLayout(0);
        }
    }

    private void jRadioButtonMenuItemWellNamesActionPerformed(ActionEvent evt) {
        this.setWellTabTitles(TabTitle.NAME);
    }

    private void jRadioButtonMenuItemWellCodesActionPerformed(ActionEvent evt) {
        this.setWellTabTitles(TabTitle.CODE);
    }

    private void jMenuItemExportVectorActionPerformed(ActionEvent evt) {
        JPanelWell panel = (JPanelWell)this.jTabbedPaneWell.getSelectedComponent();
        panel.saveChart(true);
    }

    private void jMenuItemExportRastorActionPerformed(ActionEvent evt) {
        JPanelWell panel = (JPanelWell)this.jTabbedPaneWell.getSelectedComponent();
        panel.saveChart(false);
    }

    private void jMenuItemExportChartHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("charts_export.html");
    }

    private void jMenuItemPrintSchemeActionPerformed(ActionEvent evt) {
        Chart chart = this.schemeChartJPanel.chart;
        if (chart == null) {
            JOptionPane.showMessageDialog(this, "Scheme chart not created", this.getTitle(), 2);
            return;
        }
        ChartExporter.printChart(chart, this, this.sbdb, SbugsLicense.isDemoLicense());
    }

    private void jCheckBoxMenuItemPickCodeActionPerformed(ActionEvent evt) {
        Taxon.includeAlphaInString = this.jCheckBoxMenuItemPickCode.isSelected();
        try {
            Lastval.putInt(this.sbdb, "TAXONALPHA", Taxon.includeAlphaInString ? 1 : 0);
            this.sbdb.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (JPanelPicklist list : this.picklists) {
            list.repaintList();
        }
    }

    private void jMenuItemNumericCodeActionPerformed(ActionEvent evt) {
        if (this.dialogTaxonCodeInput == null) {
            this.dialogTaxonCodeInput = new DialogTaxonCodeInput(this, false, this.sbdb);
            this.dialogTaxonCodeInput.setLocationRelativeTo(this.jTabbedPaneSchemes);
            this.dialogTaxonCodeInput.setVisible(true);
        } else if (!this.dialogTaxonCodeInput.isVisible()) {
            this.dialogTaxonCodeInput.refreshDict();
            this.dialogTaxonCodeInput.setVisible(true);
        }
    }

    private void jMenuItemPicklistNewActionPerformed(ActionEvent evt) {
        if (this.picklists.size() == 10) {
            JOptionPane.showMessageDialog(this, "You cannot open any more picklists.", this.getTitle(), 2);
            return;
        }
        String picklistName = null;
        do {
            String input;
            if ((input = JOptionPane.showInputDialog(this, "Enter picklist title: ", "New picklist", 1)) == null) {
                return;
            }
            if (input.isEmpty()) continue;
            if (input.length() > 25) {
                input = input.substring(0, 24);
            }
            boolean found = false;
            for (int i = 0; i < this.jTabbedPaneSchemes.getComponentCount(); ++i) {
                if (!input.equals(this.jTabbedPaneSchemes.getTitleAt(i))) continue;
                JOptionPane.showMessageDialog(this, "That title is in use.", "New picklist", 2);
                found = true;
            }
            if (found) continue;
            picklistName = input;
        } while (picklistName == null);
        this.addPicklist(picklistName, 0);
    }

    private void jMenuItemPicklistRemoveActionPerformed(ActionEvent evt) {
        JPanelPicklist picklist = this.getSelectedPicklist();
        if (picklist == null) {
            JOptionPane.showMessageDialog(this, "Select a picklist", "Remove picklist", 2);
            return;
        }
        if (this.picklists.size() == 1) {
            JOptionPane.showMessageDialog(this, "You cannot remove the last picklist", "Remove picklist", 2);
            return;
        }
        picklist.removeAllTaxonSelectionListeners();
        this.jTabbedPaneSchemes.remove(picklist);
        this.picklists.remove(picklist);
    }

    private void jMenuItemPicklistEditActionPerformed(ActionEvent evt) {
        JPanelPicklist picklist = this.getSelectedPicklist();
        if (picklist == null) {
            JOptionPane.showMessageDialog(this, "Select a picklist", "Edit picklist", 2);
            return;
        }
        String picklistName = null;
        do {
            String input;
            if ((input = JOptionPane.showInputDialog(this, "Enter new picklist title: ", "Edit title", 1)) == null) {
                return;
            }
            if (input.isEmpty()) continue;
            if (input.length() > 25) {
                input = input.substring(0, 24);
            }
            boolean found = false;
            for (int i = 0; i < this.jTabbedPaneSchemes.getComponentCount(); ++i) {
                if (!input.equals(this.jTabbedPaneSchemes.getTitleAt(i))) continue;
                JOptionPane.showMessageDialog(this, "That title is in use.", "Edit title", 2);
                found = true;
            }
            if (found) continue;
            picklistName = input;
        } while (picklistName == null);
        int index = 0;
        for (int i = 0; i < this.jTabbedPaneSchemes.getComponentCount(); ++i) {
            if (this.jTabbedPaneSchemes.getComponentAt(i) != picklist) continue;
            index = i;
            break;
        }
        this.jTabbedPaneSchemes.setTitleAt(index, picklistName);
    }

    private void jMenuItemTableDefaultsActionPerformed(ActionEvent evt) {
        LinkedList<TablePair> tablePairs = this.getWellPanel().getTablePair(this.getWellPanel().getSelectedTable());
        for (TablePair pair : tablePairs) {
            pair.model.setDefaultColumnWidths();
            pair.model.setupColumns(pair.table);
            pair.model.resetColumnOrder(pair.table);
        }
    }

    private void jMenuItemOverlayWebActionPerformed(ActionEvent evt) {
        this.getWellPanel().openOverlayBrowser();
    }

    private void jMenuItemExportHTMLActionPerformed(ActionEvent evt) {
        this.getWellPanel().exportChartHTML();
    }

    private void jCheckBoxMenuItemOccSoundActionPerformed(ActionEvent evt) {
        try {
            Lastval.putInt(this.sbdb, "OCCSOUND", this.jCheckBoxMenuItemOccSound.isSelected() ? 1 : 0);
            this.sbdb.commit();
        }
        catch (SQLException e) {
            SbugsExceptionHandler.showStackError(e);
        }
    }

    private void jMenuItemSaveAsProjectActionPerformed(ActionEvent evt) {
        LinkedList<Well> wellListWells;
        WellList wellList;
        if (!SBRestrictable.canWrite(this.sbdb)) {
            JOptionPane.showMessageDialog(this, SBRestrictable.getDeniedReason(false), "Save as Well List", 2);
            return;
        }
        try {
            DialogSelectProjectWellList dialog = new DialogSelectProjectWellList((Window)this, this.sbdb, null, this.parent.getChartManager());
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.getSelection() == null) {
                return;
            }
            wellList = dialog.getSelection();
            wellListWells = new LinkedList<Well>();
            Iterator<Well> wellIterator = this.sbdb.getWellIterator(wellList.getID());
            while (wellIterator.hasNext()) {
                wellListWells.add(wellIterator.next());
            }
        }
        catch (SQLException | SBException e) {
            SbugsExceptionHandler.showDialogStackError(e, this);
            return;
        }
        LinkedList<Well> selectedWells = new LinkedList<Well>();
        for (JPanelWell jPanelWell : this.getWellPanels()) {
            selectedWells.add(jPanelWell.well);
        }
        if (!wellListWells.isEmpty()) {
            if (Set.of(selectedWells).equals(Set.of(wellListWells))) {
                JOptionPane.showMessageDialog(this, "The selected well list is the same as the open wells", this.getTitle(), 1);
                return;
            }
            ArrayList<Well> unopenWells = new ArrayList<Well>(wellListWells);
            unopenWells.removeAll(selectedWells);
            if (!unopenWells.isEmpty()) {
                String msg = "Project well list '" + wellList.getName() + "' also contains wells: ";
                for (Well w : unopenWells) {
                    msg = msg + "\n" + String.valueOf(w);
                }
                int opt = JOptionPane.showConfirmDialog(this, msg = msg + "\n\nDo you want to remove these wells from the project/well list?", this.getTitle(), 1);
                if (opt == 2 || opt == -1) {
                    return;
                }
                if (opt == 0) {
                    try {
                        this.sbdb.removeWellsFromWellList(unopenWells, wellList.getID());
                        this.sbdb.commit();
                    }
                    catch (SQLException | SBPermissionException e) {
                        SbugsExceptionHandler.showStackError(e, this);
                        return;
                    }
                }
            }
        }
        try {
            selectedWells.removeAll(wellListWells);
            this.sbdb.addWellsToWellList(selectedWells, wellList.getID());
            this.sbdb.commit();
            JOptionPane.showMessageDialog(this, "Well list '" + wellList.getName() + "' updated.", this.getTitle(), 1);
        }
        catch (SQLException | SBPermissionException e) {
            SbugsExceptionHandler.showStackError(e, this);
        }
    }

    private void jRadioButtonMenuItemContinuousClickActionPerformed(ActionEvent evt) {
        try {
            Lastval.putInt(this.sbdb, "MULTICLICK", 1);
            this.sbdb.commit();
        }
        catch (SQLException ex) {
            FrameJsbugs.showStackError("SQL Error", ex, this.sbdb);
        }
    }

    private void jRadioButtonMenuItemDoubleClickActionPerformed(ActionEvent evt) {
        try {
            Lastval.putInt(this.sbdb, "MULTICLICK", 0);
            this.sbdb.commit();
        }
        catch (SQLException ex) {
            FrameJsbugs.showStackError("SQL Error", ex, this.sbdb);
        }
    }

    private void jCheckBoxMenuItemExcludeRwCvTotalsActionPerformed(ActionEvent evt) {
        try {
            Lastval.putInt(this.sbdb, "TOTEXRWCV", this.jCheckBoxMenuItemExcludeRwCvTotals.isSelected() ? 1 : 0);
            this.sbdb.commit();
            for (JPanelWell wellPanel : this.getWellPanels()) {
                wellPanel.updateTotExRwCv();
            }
        }
        catch (SQLException ex) {
            FrameJsbugs.showStackError("SQL Error", ex, this.sbdb);
        }
    }

    boolean getTotExRwCv() {
        return this.jCheckBoxMenuItemExcludeRwCvTotals.isSelected();
    }

    private void jButtonEditSchemeChartActionPerformed(ActionEvent evt) {
        BlockTemplate templ = null;
        Chart chart = ((JScrollPaneChartBase)this.jScrollPaneSchemeChart).getChart();
        if (chart == null) {
            return;
        }
        for (ChartBlockBase block : chart.getBlocks()) {
            if (block.getTemplate() == null) continue;
            templ = block.getTemplate();
        }
        if (templ == null) {
            return;
        }
        this.parent.openCharts(templ);
    }

    private void jMenuItemPicklistHighlightingActionPerformed(ActionEvent evt) {
        DialogPicklistHighlight dialog = new DialogPicklistHighlight(this, true);
        if (this.picklistHighlighting != null) {
            dialog.setParams(this.picklistHighlighting.isPercent, this.picklistHighlighting.nSamples, this.picklistHighlighting.nTaxa);
        } else {
            dialog.setParams(null, 10, 20);
        }
        dialog.setLocationRelativeTo(this.jMenuItemPicklistHighlighting);
        dialog.setVisible(true);
        if (dialog.isOK()) {
            try {
                Component c = this.jTabbedPaneWell.getSelectedComponent();
                JPanelWell wellPanel = (JPanelWell)c;
                if (dialog.isPercent == null) {
                    this.picklistHighlighting = null;
                    Lastval.putString(this.sbdb, "PKLHLGHT", "");
                    wellPanel.clearPicklistHighlighting();
                } else {
                    this.picklistHighlighting = new PicklistHighlighting(this);
                    this.picklistHighlighting.isPercent = dialog.isPercent;
                    this.picklistHighlighting.nSamples = dialog.nSamples;
                    this.picklistHighlighting.nTaxa = dialog.nTaxa;
                    Lastval.putString(this.sbdb, "PKLHLGHT", this.picklistHighlighting.encode());
                    wellPanel.setPicklistHighlighting(null);
                }
                this.sbdb.commit();
            }
            catch (SQLException sqle) {
                FrameJsbugs.showStackError(sqle.getMessage(), sqle, this.sbdb);
                this.sbdb.doRollback();
            }
        }
    }

    private void jMenuItemChartExportSBGActionPerformed(ActionEvent evt) {
        this.getWellPanel().exportChartSBG();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jMenuItemOpenTemplateAllActionPerformed(ActionEvent evt) {
        DialogChartTemplates dialog = new DialogChartTemplates(this, true, this.sbdb, this.parent.getChartManager(), BlockType.WELL, (Boolean)false, null);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.selection == null) {
            return;
        }
        String chartProp = null;
        String hdrProp = null;
        String keyProp = null;
        int schID = 0;
        if (this.getWellPanels().size() > 1) {
            ChartProperties cp = ChartPropertiesFactory.newInstance(this.sbdb);
            DialogChartProperties dialog2 = new DialogChartProperties(this, true, cp, this.sbdb, null, false, true, true, true);
            dialog2.setLocationRelativeTo(this);
            dialog2.setVisible(true);
            if (dialog2.isOK()) {
                chartProp = cp.getProperties();
                hdrProp = cp.getHeader();
                keyProp = cp.getKey();
                schID = cp.bgSchID;
            } else {
                return;
            }
        }
        boolean someWereIllegal = false;
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            for (JPanelWell wellPanel : this.getWellPanels()) {
                for (ChartTemplateBase templ : dialog.selection) {
                    someWereIllegal |= !wellPanel.addChartTemplateTab(templ, chartProp, hdrProp, keyProp, schID);
                }
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
        if (someWereIllegal) {
            JOptionPane.showMessageDialog(this, "Some tabs were not added because the well was not a member of the template's project.", this.getTitle(), 2);
        } else {
            JOptionPane.showMessageDialog(this, "Tabs opened.", this.getTitle(), 2);
        }
    }

    private void jMenuItemSampleMergeActionPerformed(ActionEvent evt) {
        JPanelWell panel = (JPanelWell)this.jTabbedPaneWell.getSelectedComponent();
        panel.mergeSamples();
    }

    private void jMenuItemSampleGenerateActionPerformed(ActionEvent evt) {
        this.getWellPanel().sampleGenerate();
    }

    private void jMenuItemTaxonReassignActionPerformed(ActionEvent evt) {
        JPanelWell panel = (JPanelWell)this.jTabbedPaneWell.getSelectedComponent();
        if (panel == null || !(panel instanceof JPanelWell)) {
            JOptionPane.showMessageDialog(this, "No well panel selected.", this.getTitle(), 1);
            return;
        }
        panel.reassignTaxon();
    }

    private void jMenuItemAnalysesWeightActionPerformed(ActionEvent evt) {
        JPanelWell panel = (JPanelWell)this.jTabbedPaneWell.getSelectedComponent();
        panel.sampleWeight();
    }

    private void jMenuItemAnlysesMergeActionPerformed(ActionEvent evt) {
        JPanelWell panel = (JPanelWell)this.jTabbedPaneWell.getSelectedComponent();
        panel.mergeAnalyses();
    }

    private void jMenuItemSampleMoveActionPerformed(ActionEvent evt) {
        JPanelWell panel = (JPanelWell)this.jTabbedPaneWell.getSelectedComponent();
        panel.moveAnalyses();
    }

    private void jMenuItemSampleCopyActionPerformed(ActionEvent evt) {
        this.getWellPanel().sampleCopy();
    }

    private void jRadioButtonMenuItemDisplayCuttingCorrectionsActionPerformed(ActionEvent evt) {
        this.updateDisplayWellCuttingCorrections();
        this.prefs.setDisplayCuttingCorrections(this.jRadioButtonMenuItemDisplayCuttingCorrections.isSelected());
    }

    private void jRadioButtonMenuItemBiocomAbrGenusActionPerformed(ActionEvent evt) {
        this.updateBiocomAbrPref();
    }

    private void jRadioButtonMenuItemBiocomFullNameActionPerformed(ActionEvent evt) {
        this.updateBiocomAbrPref();
    }

    private void updateBiocomAbrPref() {
        try {
            Lastval.putInt(this.sbdb, "BIOCOMABR", this.jRadioButtonMenuItemBiocomAbrGenus.isSelected() ? 1 : 0);
            this.sbdb.commit();
        }
        catch (SQLException sqle) {
            SbugsExceptionHandler.showStackError(sqle);
            this.sbdb.doRollback();
        }
    }

    private void jTabbedPaneSchemesStateChanged(ChangeEvent evt) {
        if (evt.getSource() != null && evt.getSource() instanceof JTabbedPane) {
            Component component;
            JTabbedPane pane = (JTabbedPane)evt.getSource();
            if (pane.getSelectedComponent() != null && (component = pane.getSelectedComponent()) instanceof JPanelPicklist) {
                JPanelPicklist picklist = (JPanelPicklist)component;
                picklist.notifyTaxonSelectionListeners();
            } else if (pane.getSelectedComponent() != null && pane.getSelectedComponent() instanceof JPanel && !this.schemeChartInit) {
                this.initSchemeChart(false);
            }
        }
    }

    private void jMenuItemViewSelectInAllWellsActionPerformed(ActionEvent evt) {
        this.selectCurrentViewForAllWells();
    }

    private void jMenuItemSampleMergeAllActionPerformed(ActionEvent evt) {
        JPanelWell panel = (JPanelWell)this.jTabbedPaneWell.getSelectedComponent();
        String msg = "This will compare all pairs of samples in section: " + panel.well.toString() + "\nand merge all single depth entries where possible with a sample with a top and base depth.\nWarning: this can take a long time to run on a large list.\nContinue?";
        int opt = JOptionPane.showConfirmDialog(this, msg, this.getTitle(), 0);
        if (opt == 1 || opt == -1) {
            return;
        }
        panel.mergeAllSamples();
    }

    private void jCheckBoxMenuItemAutoFlagCvRwActionPerformed(ActionEvent evt) {
        try {
            this.deriveCvRw = this.jCheckBoxMenuItemAutoFlagCvRw.isSelected();
            Lastval.putInt(this.sbdb, "DERIVECVRW", this.deriveCvRw ? 1 : 0);
            this.sbdb.commit();
            for (JPanelWell wellPanel : this.getWellPanels()) {
                wellPanel.updateTotExRwCv();
            }
        }
        catch (SQLException ex) {
            StackError.showStackError((String)"SQL Error", (SQLException)ex);
            LOGGER.log(Level.WARNING, "SQL Error saving lastval ", ex);
        }
    }

    private void jMenuItemDetachPdfActionPerformed(ActionEvent evt) {
        JPanelWell wellPanel = this.jTabbedPaneWell.getComponentAt(this.jTabbedPaneWell.getSelectedIndex());
        wellPanel.documentPreviewDetach();
    }

    private void jCheckBoxMenuItemShowOccPopupActionPerformed(ActionEvent evt) {
        this.showOccPopup = this.jCheckBoxMenuItemShowOccPopup.isSelected();
        try {
            Lastval.putInt(this.sbdb, "OCCPOPUP", this.showOccPopup ? 1 : 0);
            this.sbdb.commit();
        }
        catch (SQLException ex) {
            LOGGER.log(Level.WARNING, "SQL Error saving lastval ", ex);
        }
    }

    private void jRadioButtonMenuItemWellAltNamesActionPerformed(ActionEvent evt) {
        this.setWellTabTitles(TabTitle.ALT);
    }

    private void jCheckBoxMenuItemOverlayOnTopActionPerformed(ActionEvent evt) {
        if (this.jCheckBoxMenuItemOverlayOnTop.getState() != this.overlayWindowOnTop) {
            this.overlayWindowOnTop = this.jCheckBoxMenuItemOverlayOnTop.isSelected();
            if (this.parent.getFrameOverlay() != null) {
                this.parent.getFrameOverlay().setAlwaysOnTop(this.overlayWindowOnTop);
            }
        }
    }

    private void jMenuItemOpenWellIInWellsActionPerformed(ActionEvent evt) {
        Well well = this.getWellPanel().getWell();
        FrameJsbugs parent = this.getParent();
        if (parent.getWellsFrame() == null) {
            parent.createWellsFrame();
        } else {
            parent.getWellsFrame().setVisible(true);
        }
        ArrayList<Well> list = new ArrayList<Well>();
        list.add(well);
        parent.getWellsFrame().restoreFrame();
        parent.getWellsFrame().addWellSelection(list);
    }

    private void selectCurrentViewForAllWells() {
        JPanelWell wellPanel = this.jTabbedPaneWell.getComponentAt(this.jTabbedPaneWell.getSelectedIndex());
        TabView currentView = wellPanel.getCurrentView();
        for (int i = 0; i < this.jTabbedPaneWell.getComponentCount(); ++i) {
            JPanelWell p = this.jTabbedPaneWell.getComponentAt(i);
            if (p == wellPanel) continue;
            p.applyView(currentView);
        }
    }

    private void updateDisplayWellCuttingCorrections() {
        for (int i = 0; i < this.jTabbedPaneWell.getComponentCount(); ++i) {
            JPanelWell c;
            JPanelWell wellPanel = c = this.jTabbedPaneWell.getComponentAt(i);
            wellPanel.setDisplayCuttingCorrections(this.jRadioButtonMenuItemDisplayCuttingCorrections.isSelected());
        }
    }

    private void addPicklist(String tabTitle, int groupID) {
        if (tabTitle == null) {
            tabTitle = "Picklist";
        }
        JPanelPicklist picklist = new JPanelPicklist(this, this.sbdb);
        picklist.setControls(this.isCMF(), this.isNumeric());
        for (JPanelWell wellPanel : this.getWellPanels()) {
            picklist.addTaxonChangedListener(wellPanel.tableModelAnalyses);
        }
        for (FrameWellDetached frame : this.wellFrames) {
            picklist.addTaxonChangedListener(frame.getPanel().tableModelAnalyses);
        }
        if (groupID > 0) {
            try {
                TxGroup group = this.sbdb.getTxGroup(groupID);
                if (group != null) {
                    picklist.setTaxa(this.sbdb.getTxGroupTaxa(group));
                    picklist.setGroup(group);
                }
            }
            catch (Exception e) {
                StackError.showStackError((String)"Error setting group for picklist", (Throwable)e);
            }
        }
        this.jTabbedPaneSchemes.addTab(tabTitle, IconFactory.getPrefIcon("FrameSamples_PicklistTab"), picklist);
        this.jTabbedPaneSchemes.setSelectedComponent(picklist);
        this.picklists.add(picklist);
    }

    private void setWellTabTitles(TabTitle tabTitle) {
        if (tabTitle == JPanelWell.tabTitlePref) {
            return;
        }
        JPanelWell.tabTitlePref = tabTitle;
        for (int i = 0; i < this.jTabbedPaneWell.getComponentCount(); ++i) {
            JPanelWell c;
            JPanelWell wellPanel = c = this.jTabbedPaneWell.getComponentAt(i);
            this.jTabbedPaneWell.setTitleAt(i, wellPanel.getTabTitle());
        }
        try {
            Lastval.putInt(this.sbdb, "TABTITLES", tabTitle.getID());
            this.sbdb.commit();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    void setLogging(boolean logging) {
        for (JPanelWell wellPanel : this.getWellPanels()) {
            wellPanel.tableModelOcc.setLogging(logging, wellPanel.getOccTable());
            wellPanel.tableModelOcc.fireTableDataChanged();
        }
        try {
            Lastval.putInt(this.sbdb, "LOGMODE", logging ? 1 : 0);
            this.sbdb.commit();
        }
        catch (SQLException ex) {
            LOGGER.log(Level.WARNING, "Error from FrameSamples.setLogging lastval: ", ex);
        }
    }

    private void decodeLogSheetPrefs(List<LoggingSheet> logSheets) {
        String params;
        System.out.println("Decoding Logging sheet properties...");
        try {
            params = Lastval.getString(this.sbdb, "LOGSHTPREF");
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
            return;
        }
        if (params.isEmpty()) {
            System.out.println("No LoggingSheet parameters to decode");
            return;
        }
        boolean wellCode = false;
        boolean images = false;
        boolean comments = true;
        boolean italics = true;
        boolean smallFont = true;
        boolean useCodes = false;
        boolean bsComments = false;
        boolean semiQuant = false;
        boolean specType = true;
        int sort = 3;
        try {
            String[] s = params.split("\\|");
            block16: for (int i = 0; i < s.length; ++i) {
                switch (i) {
                    case 0: {
                        useCodes = Integer.parseInt(s[i]) == 1;
                        continue block16;
                    }
                    case 1: {
                        smallFont = Integer.parseInt(s[i]) == 1;
                        continue block16;
                    }
                    case 2: {
                        comments = Integer.parseInt(s[i]) == 1;
                        continue block16;
                    }
                    case 3: {
                        images = Integer.parseInt(s[i]) == 1;
                        continue block16;
                    }
                    case 4: {
                        wellCode = Integer.parseInt(s[i]) == 1;
                        continue block16;
                    }
                    case 5: {
                        italics = Integer.parseInt(s[i]) == 1;
                        continue block16;
                    }
                    case 6: {
                        sort = Integer.parseInt(s[i]);
                        continue block16;
                    }
                    case 7: {
                        bsComments = Integer.parseInt(s[i]) == 1;
                        continue block16;
                    }
                    case 8: {
                        semiQuant = Integer.parseInt(s[i]) == 1;
                        continue block16;
                    }
                    case 9: {
                        specType = Integer.parseInt(s[i]) == 1;
                    }
                }
            }
        }
        catch (NumberFormatException nfe) {
            nfe.printStackTrace();
        }
        for (LoggingSheet logSheet : logSheets) {
            logSheet.setProperties(wellCode, comments, images, italics, smallFont, useCodes, sort, bsComments, semiQuant, specType);
        }
    }

    private void encodeSession() {
        Object pLists = "";
        for (int i = 0; i < this.jTabbedPaneSchemes.getComponentCount(); ++i) {
            Component c = this.jTabbedPaneSchemes.getComponent(i);
            if (!(c instanceof JPanelPicklist)) continue;
            JPanelPicklist picklist = (JPanelPicklist)c;
            pLists = (String)pLists + this.jTabbedPaneSchemes.getTitleAt(i).replace(",", " ") + " " + (!picklist.isUnsaved() ? picklist.getGroupID() : 0) + ",";
        }
        Object wells = "";
        LinkedList<CallSite> wellTabViews = new LinkedList<CallSite>();
        for (JPanelWell wellPanel : this.getWellPanels()) {
            wells = (String)wells + wellPanel.getWell().getWellID() + ",";
            wellTabViews.add((CallSite)((Object)(wellPanel.getWell().getWellID() + "|" + wellPanel.getCurrentView().encode())));
            if (((String)wells).length() <= 200) continue;
            break;
        }
        Object gui = "";
        if (this.getExtendedState() == 6) {
            gui = (String)gui + "1";
        } else {
            Dimension size = this.getSize();
            gui = (String)gui + size.width + " " + size.height;
        }
        gui = (String)gui + "," + SB.round((double)(((double)this.jSplitPane1.getDividerLocation() + (double)this.jSplitPane1.getDividerSize()) / (double)this.jSplitPane1.getWidth()), (int)3);
        Object wellTab = "";
        JPanelWell selectedWellPanel = this.getWellPanel();
        if (selectedWellPanel != null) {
            wellTab = (String)wellTab + selectedWellPanel.getWell().getWellID();
        }
        String params = (String)pLists + "|" + (String)wells + "|" + (String)gui + "|" + (String)wellTab;
        try {
            Lastval.putString(this.sbdb, "SMPSESSION", params);
            Lastval.deleteLike(this.sbdb, "SMPSS");
            for (String string : wellTabViews) {
                String[] s = string.split("\\|");
                Lastval.putString(this.sbdb, "SMPSS" + s[0], s[1]);
            }
            this.sbdb.commit();
        }
        catch (SQLException sql) {
            SbugsExceptionHandler.showStackError(sql);
        }
    }

    private boolean restoreSession() {
        try {
            String wells;
            Object title;
            String params = Lastval.getString(this.sbdb, "SMPSESSION");
            if (params.isEmpty()) {
                return false;
            }
            String[] tok = params.split("\\|");
            if (tok.length > 0) {
                String pLists = tok[0];
                StringTokenizer pListsTok = new StringTokenizer(pLists, ",");
                while (pListsTok.hasMoreTokens()) {
                    String[] s = pListsTok.nextToken().split(" ");
                    title = "";
                    int groupID = 0;
                    if (s.length > 1) {
                        for (int i = 0; i < s.length - 1; ++i) {
                            title = (String)title + s[i] + " ";
                        }
                        try {
                            groupID = Integer.parseInt(s[s.length - 1]);
                        }
                        catch (NumberFormatException nfe) {
                            LOGGER.log(Level.CONFIG, "Error parsing group ID: " + s[s.length - 1]);
                            continue;
                        }
                    }
                    this.addPicklist((String)(((String)(title = ((String)title).trim())).isEmpty() ? "Picklist" : title), groupID);
                }
            }
            if (tok.length > 1 && !(wells = tok[1]).isEmpty()) {
                StringTokenizer wellsTok = new StringTokenizer(wells, ",");
                while (wellsTok.hasMoreTokens()) {
                    try {
                        Well well = this.sbdb.getWell(Integer.parseInt(wellsTok.nextToken()));
                        title = this.addNewWellPanel(well);
                    }
                    catch (WellHeader.MissingWellException e) {
                        System.out.println("WARNING: " + e.getMessage());
                    }
                }
            }
            if (tok.length > 2) {
                StringTokenizer GUITok = new StringTokenizer(tok[2], ",");
                if (GUITok.hasMoreTokens()) {
                    String size = GUITok.nextToken();
                    if (size.equals("1")) {
                        this.setExtendedState(6);
                    } else {
                        StringTokenizer sizeTok = new StringTokenizer(size);
                        int width = Integer.parseInt(sizeTok.nextToken());
                        int height = Integer.parseInt(sizeTok.nextToken());
                        this.setSize(width, height);
                    }
                }
                if (GUITok.hasMoreTokens()) {
                    final double dividerLocation = Double.parseDouble(GUITok.nextToken());
                    SwingUtilities.invokeLater(new Runnable(){
                        final /* synthetic */ FrameSamples this$0;
                        {
                            FrameSamples frameSamples = this$0;
                            Objects.requireNonNull(frameSamples);
                            this.this$0 = frameSamples;
                        }

                        @Override
                        public void run() {
                            this.this$0.jSplitPane1.setDividerLocation(dividerLocation);
                            this.this$0.jSplitPane1.revalidate();
                        }
                    });
                }
            }
            if (tok.length > 3) {
                String wellIDString = tok[3];
                int selectedWellID = Integer.parseInt(wellIDString);
                for (JPanelWell wellPanel : this.getWellPanels()) {
                    TabView view;
                    String key;
                    String tabViewString;
                    if (wellPanel.getWell().getWellID() == selectedWellID) {
                        this.setSelectedWellTab(wellPanel);
                    }
                    if ((tabViewString = Lastval.getString(this.sbdb, key = "SMPSS" + wellPanel.getWell().getWellID())).isEmpty()) {
                        key = "SMPSS-" + wellPanel.getWell().getWellID();
                        tabViewString = Lastval.getString(this.sbdb, key);
                    }
                    if (tabViewString.isEmpty() || (view = TabView.createDecodedTabView(tabViewString)) == null) continue;
                    wellPanel.applyView(view);
                }
            }
            this.updateDisplayWellCuttingCorrections();
            return true;
        }
        catch (NoSuchElementException nse) {
            nse.printStackTrace();
            return false;
        }
        catch (SBException sbe) {
            StackError.showStackError((String)"Error restoring session", (Throwable)sbe);
            return false;
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error restoring session", sql, this.sbdb);
            return false;
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
            return false;
        }
    }

    boolean playOccSounds() {
        return this.jCheckBoxMenuItemOccSound.isSelected();
    }

    void playOccSound() {
        try {
            if (this.soundClip == null) {
                InputStream audioInputStream = this.getClass().getResourceAsStream("/resources/wav/Swat.wav");
                BufferedInputStream bufferedIn = new BufferedInputStream(audioInputStream);
                this.audioStream = AudioSystem.getAudioInputStream(bufferedIn);
                this.soundClip = AudioSystem.getClip();
                this.soundClip.open(this.audioStream);
            }
            this.soundClip.setFramePosition(1);
            this.soundClip.loop(0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void setSchemeChartVersion(Well well, Integer interpID) {
        LOGGER.log(Level.CONFIG, "Setting scheme chart version: {0} / {1}", new Object[]{well, interpID});
        try {
            if (interpID != null) {
                well.getInterp(interpID);
            }
        }
        catch (SBException e) {
            interpID = null;
            LOGGER.log(Level.CONFIG, "Version deleted? Resetting scheme chart: {0} / {1}", new Object[]{well, interpID});
        }
        ChartBlockBase block = this.schemeChartJPanel.chart.getBlockSingle();
        if (block != null && block instanceof SchemeBlock) {
            SchemeBlock sBlock = (SchemeBlock)block;
            try {
                sBlock.setWell(well);
                if (interpID != null) {
                    sBlock.setInterpID(interpID);
                }
            }
            catch (SQLException | SBException e) {
                SbugsExceptionHandler.showStackError(e, this);
            }
        }
    }

    private void setSchemeChartVersion() {
        if (this.getWellPanel() != null) {
            Integer interpID = this.getWellPanel().getInterp() != null ? Integer.valueOf(this.getWellPanel().getInterp().getHeader().getInterpID()) : null;
            this.setSchemeChartVersion(this.getWellPanel().well, interpID);
        }
    }

    void setTabVersion(JPanelWell sender, InterpHdr header) throws SQLException, SBException {
        for (Component c : this.jTabbedPaneWell.getComponents()) {
            if (c == sender) continue;
            ((JPanelWell)c).setVersion(header);
        }
    }

    JFrame getParentFrame(JPanelCharts jPanelCharts) {
        for (FrameWellChartsDetached frameChart : this.chartsFrames) {
            if (frameChart.getPanel() != jPanelCharts) continue;
            return frameChart;
        }
        for (FrameWellDetached frameWell : this.wellFrames) {
            if (frameWell.getPanel() != jPanelCharts.parentPanel) continue;
            return frameWell;
        }
        return this;
    }

    void showLithPalette(JPanelCharts origin) {
        PanelIntLith lithPanel;
        ChartPanel panel = origin.getSelectedPanel();
        if (panel == null) {
            return;
        }
        if (panel instanceof PanelIntLith && (lithPanel = (PanelIntLith)panel).getProperties().isScaleIntervals()) {
            JOptionPane.showMessageDialog(this, "For editing lithology intervals, switch off the panel option: " + lithPanel.getProperties().getScaleIntervalsPropertyName());
            return;
        }
        if (this.lithPalette == null) {
            try {
                this.lithPalette = new DialogLithPalette((Frame)this, false, this.sbdb);
                this.lithPalette.setLocationRelativeTo(origin);
                this.lithPalette.setVisible(true);
            }
            catch (SQLException | SBException ex) {
                SbugsExceptionHandler.showStackError(ex);
            }
        } else {
            this.lithPalette.setLocationRelativeTo(origin);
            this.lithPalette.setVisible(true);
        }
    }

    DialogLithPalette getLithPalette() {
        if (this.lithPalette != null && this.lithPalette.isVisible()) {
            return this.lithPalette;
        }
        return null;
    }

    void removeChartTemplateTab(ChartTemplateBase templ, int wellID) {
        for (JPanelWell wellPanel : this.getWellPanels()) {
            if (wellPanel.getWell().getWellID() != wellID) continue;
            wellPanel.removeTab(templ);
        }
        for (FrameWellDetached detached : this.wellFrames) {
            if (detached.getPanel().getWell().getWellID() != wellID) continue;
            detached.getPanel().removeTab(templ);
        }
    }

    private void removeAllPicklistListeners() {
        for (JPanelPicklist picklist : this.getPicklists()) {
            picklist.removeAllTaxonSelectionListeners();
        }
    }

    private void removeTaxonSelectionListener(ITaxonSelectionChangedListener listener) {
        for (JPanelPicklist picklist : this.getPicklists()) {
            picklist.removeTaxonSelectionListener(listener);
        }
    }

    private JPanelWell addNewWellPanel(Well well) throws SQLException, SBException {
        JPanelWell wellPanel = new JPanelWell(this, this.sbdb, well);
        this.addNewPanelAsListenerToPicklists(wellPanel);
        this.jTabbedPaneWell.insertTab(wellPanel, this.jRadioButtonMenuItemLogging.isSelected());
        return wellPanel;
    }

    private void addNewPanelAsListenerToPicklists(JPanelWell panel) {
        for (JPanelPicklist picklist : this.getPicklists()) {
            picklist.addTaxonChangedListener(panel.tableModelAnalyses);
        }
    }

    class PicklistHighlighting {
        boolean isPercent;
        int nSamples;
        int nTaxa;

        PicklistHighlighting(FrameSamples this$0) {
            Objects.requireNonNull(this$0);
        }

        void decode(String s) {
            String[] values = s.split("\\|");
            if (values.length >= 3) {
                this.isPercent = Boolean.parseBoolean(values[0]);
                this.nSamples = Integer.parseInt(values[1]);
                this.nTaxa = Integer.parseInt(values[2]);
            }
        }

        String encode() {
            return Boolean.toString(this.isPercent) + "|" + this.nSamples + "|" + this.nTaxa;
        }
    }

    public static enum TabTitle {
        NAME("Well name", 0),
        CODE("Well code", 1),
        ALT("Alternate name", 2);

        final String description;
        final int ID;

        private TabTitle(String description, int ID) {
            this.description = description;
            this.ID = ID;
        }

        public String toString() {
            return this.description;
        }

        public int getID() {
            return this.ID;
        }

        public static TabTitle valueOf(int id) {
            switch (id) {
                default: {
                    return NAME;
                }
                case 1: {
                    return CODE;
                }
                case 2: 
            }
            return ALT;
        }
    }

    private class SchemeBlockLoader
    extends SwingWorker<String, Void> {
        int blockID;
        int wellID;
        int wellListID;
        int interpID;
        String bProp;
        String cProp;
        JFrame frame;
        final /* synthetic */ FrameSamples this$0;

        public SchemeBlockLoader(FrameSamples frameSamples, JFrame frame, int blockID, int wellID, int wellListID, int interpID, String bProp, String cProp) {
            FrameSamples frameSamples2 = frameSamples;
            Objects.requireNonNull(frameSamples2);
            this.this$0 = frameSamples2;
            this.frame = frame;
            this.wellID = wellID;
            this.blockID = blockID;
            this.wellListID = wellListID;
            this.interpID = interpID;
            this.bProp = bProp;
            this.cProp = cProp;
        }

        @Override
        public String doInBackground() {
            this.this$0.loadSchemeBlock(this.blockID, this.wellID, this.wellListID, this.interpID, this.bProp, this.cProp);
            return "Done";
        }

        @Override
        public void done() {
            try {
                this.get();
            }
            catch (InterruptedException | ExecutionException e) {
                SbugsExceptionHandler.showStackError(e);
            }
            finally {
                this.frame.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    public static enum ExitStatus {
        NO_EXIT,
        EXIT_CONFIRMED,
        EXIT_UNCONFIRMED;

    }

    private class SbugsLineListener
    implements LineListener {
        final /* synthetic */ FrameSamples this$0;

        private SbugsLineListener(FrameSamples frameSamples) {
            FrameSamples frameSamples2 = frameSamples;
            Objects.requireNonNull(frameSamples2);
            this.this$0 = frameSamples2;
        }

        @Override
        public void update(LineEvent event) {
            if (event.getType() == LineEvent.Type.START) {
                while (this.this$0.soundClip.isRunning()) {
                }
                this.this$0.soundClip.loop(0);
            }
        }
    }
}

