/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.Discipline;
import com.stratadata.model3.image.ZipFileImageLoader;
import com.stratadata.model3.ws.Workspace;
import com.stratadata.model3.ws.WorkspaceExportHelper;
import com.stratadata.util.io.FileChooserUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Observable;
import java.util.Observer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import jsbchart.block.BlockType;
import jsbchart.core.BlockTemplate;
import jsbugs.DialogChartTemplates;
import jsbugs.DialogEvent;
import jsbugs.DialogList;
import jsbugs.DialogMatchGenera;
import jsbugs.DialogMatchTaxa;
import jsbugs.DialogMatchTxGroup;
import jsbugs.DialogMatchTxGroupSet;
import jsbugs.DialogNumericDicts;
import jsbugs.DialogOverlays;
import jsbugs.DialogPrintPreview;
import jsbugs.DialogSelectCmpStd;
import jsbugs.DialogSelectProject;
import jsbugs.DialogSelectVersion;
import jsbugs.DialogTaxaUnusedDelete;
import jsbugs.DialogTaxonCodePrint;
import jsbugs.DialogWellDisc;
import jsbugs.FrameJsbugs;
import jsbugs.InternalFrameChart;
import jsbugs.InternalFrameEventDict;
import jsbugs.InternalFrameGenera;
import jsbugs.InternalFrameGroup;
import jsbugs.InternalFrameTaxa;
import jsbugs.JPanelGroups;
import jsbugs.JPanelSets;
import jsbugs.LoggingSheetCodes;
import jsbugs.PrintJPanel;
import jsbugs.SbugsIO;
import jsbugs.SbugsMLdocument;
import jsbugs.io.DialogCSVExporOptions;
import jsbugs.model2.event.InternalFrameCmpStd;
import jsbugs.model2.taxon.DialogCategories;
import jsbugs.sbdb.ProjectUtils;
import jsbugs.slidestore.DialogCabinet;
import jsbugs.uiutil.FileOverwriteCheck;
import jsbugs.uiutil.WaitCursorListenerFactory;
import jsbugs.uiutil.icon.IconFactory;
import jsbugs.userconnect.SbugsExceptionHandler;
import jsbugs.userconnect.SbugsSession;
import jsbugs.util.SBFrame;
import jsbugs.util.UserPrefsHelper;
import model3.CompositeStandard;
import model3.CompositeStandardEvent;
import model3.DEXFile;
import model3.InterpHdr;
import model3.Lastval;
import model3.SBEvent;
import model3.SBRestrictable;
import model3.SBdb;
import model3.SynonymScheme;
import model3.Taxon;
import model3.TxGroup;
import model3.TxGroupSet;
import model3.Well;
import model3.WellOccQueryResult;
import model3.project.Project;
import net.java.balloontip.BalloonTip;
import net.java.balloontip.styles.BalloonTipStyle;
import net.java.balloontip.styles.EdgedBalloonStyle;
import net.java.balloontip.utils.TimingUtils;
import org.jdesktop.layout.GroupLayout;
import org.jdom2.Document;
import org.jdom2.JDOMException;
import org.xml.sax.SAXParseException;
import util.FilePathUtils;
import util.InvalidFieldException;
import util.SB;
import util.SBException;
import util.SBPermissionException;
import util.SbugsFileFilter;
import util.exception.StackError;
import util.gridwriter.CSVExportOptions;
import util.gridwriter.CellFormat;
import util.gridwriter.GridSheet;
import util.gridwriter.GridWriter;
import util.status.SbugsStatus;

public class FrameTaxaDB
extends SBFrame {
    private final SBdb sbdb;
    final FrameJsbugs parent;
    private final InternalFrameTaxa frameTaxa;
    private InternalFrameGenera frameGenera = null;
    private InternalFrameEventDict frameEvents = null;
    private InternalFrameChart frameChart = null;
    private final JPanelSets jPanelSets;
    private final JPanelGroups jPanelGroups;
    private JFileChooser jFileChooserZip = null;
    private final DefaultComboBoxModel projectModel = new DefaultComboBoxModel();
    private static final String EXPORT_IMAGE_QUESTION = "Export taxon images for type specimens?";
    private static final String LASTVAL_PROJ_STRING = "TAXADBPROJ";
    private static final String LASTVAL_PROJ_GLOBAL_STRING = "TAXADBPRGL";
    private static final String GLOBAL_PROJECT_OPTION = "Global";
    private static final String ALL_PROJECT_OPTION = "<all>";
    final int IMPORT_GROUP = 1;
    final int IMPORT_SET = 2;
    final int IMPORT_LIST = 3;
    private ButtonGroup buttonGroupGroupDiscFilter;
    private ButtonGroup buttonGroupShowTaxa;
    private ButtonGroup buttonGroupWindows;
    private Box.Filler filler1;
    private JButton jButtonCascade;
    private JButton jButtonCloseWindow;
    private JButton jButtonGroupAdd;
    private JButton jButtonGroupEdit;
    private JButton jButtonOpenTemplate;
    private JButton jButtonOverlay;
    private JButton jButtonProjects;
    private JButton jButtonTaxonAdd;
    private JButton jButtonTaxonEdit;
    private JButton jButtonTaxonSearch;
    private JCheckBoxMenuItem jCheckBoxMenuItemShowProjectColumn;
    private JCheckBoxMenuItem jCheckBoxMenuItemViewGlobal;
    private JComboBox jComboBoxProject;
    private JDesktopPane jDesktopPane;
    private JLabel jLabelProject;
    private JMenuBar jMenuBar1;
    private JMenu jMenuEvents;
    private JMenu jMenuFile;
    private JMenu jMenuGroup;
    private JMenu jMenuGroupDiscFilter;
    private JMenu jMenuHelp;
    private JMenuItem jMenuItem1;
    private JMenuItem jMenuItem2;
    private JMenuItem jMenuItemAddGroup;
    private JMenuItem jMenuItemAddTaxon;
    private JMenuItem jMenuItemAdvancedSearch;
    private JMenuItem jMenuItemAdvancedSearchDict;
    private JMenuItem jMenuItemCascade;
    private JMenuItem jMenuItemCategories;
    private JMenuItem jMenuItemCharts;
    private JMenuItem jMenuItemCloseWindow;
    private JMenuItem jMenuItemCmpStd;
    private JMenuItem jMenuItemCmpStdNew;
    private JMenuItem jMenuItemCmpStdStats;
    private JMenuItem jMenuItemContents;
    private JMenuItem jMenuItemDelete;
    private JMenuItem jMenuItemDeleteAll;
    private JMenuItem jMenuItemDeleteGroup;
    private JMenuItem jMenuItemDeleteNonOccEvents;
    private JMenuItem jMenuItemEditGroup;
    private JMenuItem jMenuItemEditOccTypes;
    private JMenuItem jMenuItemEditTaxon;
    private JMenuItem jMenuItemEventAdd;
    private JMenuItem jMenuItemEventDict;
    private JMenuItem jMenuItemExit;
    private JMenuItem jMenuItemExportGroup;
    private JMenuItem jMenuItemExportGroupText;
    private JMenuItem jMenuItemExportSet;
    private JMenuItem jMenuItemExportTaxa;
    private JMenuItem jMenuItemFileSlideStore;
    private JMenuItem jMenuItemFindSimilar;
    private JMenuItem jMenuItemGenera;
    private JMenuItem jMenuItemGenerateCodes;
    private JMenuItem jMenuItemGroupInsertWell;
    private JMenuItem jMenuItemGroupLogSheet;
    private JMenuItem jMenuItemGroupMembership;
    private JMenuItem jMenuItemGroupPermissions;
    private JMenuItem jMenuItemGroupUsages;
    private JMenuItem jMenuItemHelpGuide;
    private JMenuItem jMenuItemHelpMenu;
    private JMenuItem jMenuItemImages;
    private JMenuItem jMenuItemImportGroup;
    private JMenuItem jMenuItemImportSet;
    private JMenuItem jMenuItemImportTaxa;
    private JMenuItem jMenuItemLinkedEvents;
    private JMenuItem jMenuItemMerge;
    private JMenuItem jMenuItemMergeEvents;
    private JMenuItem jMenuItemNumericalCodes;
    private JMenuItem jMenuItemOccurences;
    private JMenuItem jMenuItemOverlays;
    private JMenuItem jMenuItemPrintImages;
    private JMenuItem jMenuItemReferenceNotes;
    private JMenuItem jMenuItemRename;
    private JMenuItem jMenuItemSIPMCodes;
    private JMenuItem jMenuItemSaveList;
    private JMenuItem jMenuItemSearchCode;
    private JMenuItem jMenuItemSelectTaxa;
    private JMenuItem jMenuItemSelectTaxaFromWell;
    private JMenuItem jMenuItemSelectTaxaImages;
    private JMenuItem jMenuItemSelectTaxaInSlideStore;
    private JMenuItem jMenuItemSetAdd;
    private JMenuItem jMenuItemSetDelete;
    private JMenuItem jMenuItemSetEdit;
    private JMenuItem jMenuItemSetPrintLoggingSheet;
    private JMenuItem jMenuItemSetShowCharts;
    private JMenuItem jMenuItemSetShowGroups;
    private JMenuItem jMenuItemSetUsages;
    private JMenuItem jMenuItemSetsPermissions;
    private JMenuItem jMenuItemShowCharts;
    private JMenuItem jMenuItemShowEventUsage;
    private JMenuItem jMenuItemShowNoCharts;
    private JMenuItem jMenuItemSlideStore;
    private JMenuItem jMenuItemSynonymy;
    private JMenuItem jMenuItemTaxonSearchDB;
    private JMenuItem jMenuItemTaxonURL;
    private JMenuItem jMenuItemTaxonWebLookup;
    private JMenu jMenuSet;
    private JMenu jMenuTaxa;
    private JMenu jMenuTaxon;
    private JMenu jMenuWindows;
    private JPopupMenu jPopupMenu1;
    private JPopupMenu jPopupMenu2;
    private JPopupMenu.Separator jSeparator1;
    private JSeparator jSeparator10;
    private JSeparator jSeparator11;
    private JSeparator jSeparator12;
    private JPopupMenu.Separator jSeparator13;
    private JPopupMenu.Separator jSeparator14;
    private JPopupMenu.Separator jSeparator15;
    private JPopupMenu.Separator jSeparator16;
    private JPopupMenu.Separator jSeparator17;
    private JPopupMenu.Separator jSeparator18;
    private JSeparator jSeparator19;
    private JPopupMenu.Separator jSeparator2;
    private JPopupMenu.Separator jSeparator20;
    private JPopupMenu.Separator jSeparator21;
    private JPopupMenu.Separator jSeparator3;
    private JPopupMenu.Separator jSeparator4;
    private JPopupMenu.Separator jSeparator5;
    private JPopupMenu.Separator jSeparator6;
    private JPopupMenu.Separator jSeparator7;
    private JPopupMenu.Separator jSeparator8;
    private JPopupMenu.Separator jSeparator9;
    private JSplitPane jSplitPane1;
    private JSplitPane jSplitPane2;
    private JToolBar jToolBar1;

    public FrameTaxaDB(FrameJsbugs parent, SBdb sbdb) throws SQLException {
        this.initComponents();
        this.sbdb = sbdb;
        this.parent = parent;
        this.frameTaxa = new InternalFrameTaxa(this, sbdb);
        this.jPanelSets = new JPanelSets(this, sbdb);
        this.jPanelGroups = new JPanelGroups(this, sbdb);
        this.init();
    }

    @Override
    public FrameJsbugs getParent() {
        return this.parent;
    }

    boolean showAllProjects() {
        Object o = this.jComboBoxProject.getSelectedItem();
        if (o instanceof String) {
            return Objects.equals(o, ALL_PROJECT_OPTION);
        }
        return false;
    }

    int getProjID() {
        Object o = this.jComboBoxProject.getSelectedItem();
        if (o instanceof Project) {
            Project project = (Project)((Object)o);
            return project.getID();
        }
        return 0;
    }

    boolean showGlobal() {
        return this.jCheckBoxMenuItemViewGlobal.isSelected();
    }

    private void init() throws SQLException {
        this.setTitle("Taxonomic Database - StrataBugs");
        this.setIcons();
        this.jMenuItemImages.addActionListener(this::jMenuItemImagesActionPerformed);
        this.jSplitPane2.setBottomComponent(this.jPanelSets);
        this.jSplitPane2.setTopComponent(this.jPanelGroups);
        this.setBounds(0, 0, 1000, 728);
        this.setExtendedState(6);
        this.setMinimumSize(new Dimension(850, 420));
        this.jSplitPane2.setMinimumSize(new Dimension(200, 0));
        this.jDesktopPane.setMinimumSize(new Dimension(625, 0));
        this.jSplitPane1.setDividerLocation(0.01);
        this.jDesktopPane.add(this.frameTaxa);
        this.frameTaxa.setVisible(true);
        this.fillProjectCombo();
        int lastProjID = Lastval.getInt(this.sbdb, LASTVAL_PROJ_STRING);
        if (lastProjID > 0) {
            Project project = this.sbdb.getProject(lastProjID);
            if (project != null) {
                this.jComboBoxProject.setSelectedItem((Object)project);
            }
        } else {
            this.jComboBoxProject.setSelectedItem(GLOBAL_PROJECT_OPTION);
        }
        this.jCheckBoxMenuItemShowProjectColumn.setSelected(false);
        String showGlobal = Lastval.getString(this.sbdb, LASTVAL_PROJ_GLOBAL_STRING);
        if (!showGlobal.isEmpty()) {
            this.jCheckBoxMenuItemViewGlobal.setSelected(showGlobal.equals("Y"));
        }
        this.jComboBoxProject.addItemListener(new ItemListener(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void itemStateChanged(ItemEvent ie) {
                if (ie.getStateChange() == 1) {
                    this.this$0.projectChange();
                }
            }
        });
        this.sbdb.addObserver(new Observer(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void update(Observable o, Object arg) {
                if (o == this.this$0.sbdb && arg instanceof Project) {
                    boolean found = false;
                    for (int i = 0; i < this.this$0.jComboBoxProject.getItemCount(); ++i) {
                        if (this.this$0.jComboBoxProject.getItemAt(i) != arg) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        Object item = this.this$0.jComboBoxProject.getSelectedItem();
                        this.this$0.fillProjectCombo();
                        this.this$0.jComboBoxProject.setSelectedItem(item);
                    }
                }
            }
        });
        this.jPanelGroups.loadGroups();
        this.jPanelSets.loadSets();
        if (!SBRestrictable.canWrite(this.sbdb)) {
            this.jMenuItemDelete.setEnabled(false);
            this.jMenuItemImportGroup.setEnabled(false);
            this.jMenuItemImportSet.setEnabled(false);
            this.jMenuItemExportGroup.setEnabled(false);
            this.jMenuItemExportSet.setEnabled(false);
            this.jMenuItemGroupInsertWell.setEnabled(false);
            this.jMenuItemDeleteGroup.setEnabled(false);
            this.jMenuItemAddGroup.setEnabled(false);
            this.jMenuItemSetDelete.setEnabled(false);
        }
        if (FrameJsbugs.isMacPlatform()) {
            this.jComboBoxProject.putClientProperty("JComboBox.isPopDown", Boolean.TRUE);
            this.jMenuHelp.setText("Help ");
            this.jMenuItemExit.setText("Close Taxonomic Database");
        }
        this.initGroupFilterMenu();
    }

    private void initGroupFilterMenu() {
        Discipline[] disciplines = new Discipline[Discipline.values().length + 1];
        System.arraycopy(Discipline.values(), 0, disciplines, 1, Discipline.values().length);
        for (Discipline d : disciplines) {
            final Discipline disc = d;
            JCheckBoxMenuItem discItem = new JCheckBoxMenuItem(disc != null ? disc.getNoun() : "None");
            ActionListener filterAction = new ActionListener(){
                final /* synthetic */ FrameTaxaDB this$0;
                {
                    FrameTaxaDB frameTaxaDB = this$0;
                    Objects.requireNonNull(frameTaxaDB);
                    this.this$0 = frameTaxaDB;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.this$0.filterGroups(disc);
                }
            };
            ActionListener filterActionCurosrWrapper = WaitCursorListenerFactory.createListener(this, filterAction);
            discItem.addActionListener(filterActionCurosrWrapper);
            this.buttonGroupGroupDiscFilter.add(discItem);
            this.jMenuGroupDiscFilter.add(discItem);
            discItem.setSelected(disc == null);
        }
    }

    private void setIcons() {
        this.setMultiResIconImage("frameTaxa.svg");
        if (SbugsSession.getSession().useHiResIcons()) {
            IconFactory.setButtonIconsInBackground(List.of(new IconFactory.ButtonIconInfo(this.jButtonTaxonAdd, "FrameTaxa_AddTaxon.svg"), new IconFactory.ButtonIconInfo(this.jButtonTaxonSearch, "findTaxon.svg", 24), new IconFactory.ButtonIconInfo(this.jButtonTaxonEdit, "FrameTaxa_EditTaxon.svg", 24), new IconFactory.ButtonIconInfo(this.jButtonGroupAdd, "FrameTaxa_AddGroup.svg", 24), new IconFactory.ButtonIconInfo(this.jButtonGroupEdit, "FrameTaxa_EditGroup.svg", 24), new IconFactory.ButtonIconInfo(this.jButtonCloseWindow, "windowClose.svg", 24), new IconFactory.ButtonIconInfo(this.jButtonCascade, "windowCascade.svg", 24), new IconFactory.ButtonIconInfo(this.jButtonOverlay, "overlay.svg", 24), new IconFactory.ButtonIconInfo(this.jButtonOpenTemplate, "openSchemeTemplate.svg", 24)));
        }
    }

    private void fillProjectCombo() {
        this.jComboBoxProject.removeAllItems();
        this.projectModel.addElement(ALL_PROJECT_OPTION);
        this.projectModel.addElement(GLOBAL_PROJECT_OPTION);
        try {
            ProjectUtils.loadProjectCombo(this.sbdb, this.projectModel, false);
        }
        catch (RuntimeException e) {
            SbugsExceptionHandler.showStackError("Error loading projects", e, this);
        }
    }

    private void projectChange() {
        try {
            this.jPanelGroups.loadGroups();
            this.jPanelSets.loadSets();
            Object o = this.jComboBoxProject.getSelectedItem();
            Lastval.putInt(this.sbdb, LASTVAL_PROJ_STRING, o instanceof Project ? ((Project)((Object)o)).getID() : 0);
            Lastval.putString(this.sbdb, LASTVAL_PROJ_GLOBAL_STRING, this.showGlobal() ? "Y" : "N");
            this.sbdb.commit();
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
    }

    public boolean isProjectCurrentlyVisible(int projectId) {
        if (this.showAllProjects()) {
            return true;
        }
        if (projectId == 0 && this.showGlobal()) {
            return true;
        }
        return this.getProjID() == projectId;
    }

    void setProject(int projID) {
        if (projID == this.getProjID()) {
            return;
        }
        try {
            if (projID > 0) {
                this.jComboBoxProject.setSelectedItem((Object)this.sbdb.getProject(projID));
            } else {
                this.jComboBoxProject.setSelectedItem(GLOBAL_PROJECT_OPTION);
            }
            EdgedBalloonStyle style = new EdgedBalloonStyle(new Color(255, 255, 204), Color.BLACK);
            BalloonTip bTip = new BalloonTip((JComponent)this.jComboBoxProject, "Project changed", (BalloonTipStyle)style, false);
            TimingUtils.showTimedBalloon((BalloonTip)bTip, (int)5000);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
    }

    InternalFrameGroup getGroupFrame(TxGroup group) {
        JInternalFrame[] frames;
        for (JInternalFrame frame : frames = this.jDesktopPane.getAllFrames()) {
            InternalFrameGroup groupFrame;
            if (!frame.getClass().equals(InternalFrameGroup.class) || (groupFrame = (InternalFrameGroup)frame).getGroup() != group) continue;
            return groupFrame;
        }
        return null;
    }

    void removeInternalFrameGroup(TxGroup group) {
        try {
            InternalFrameGroup groupFrame = this.getGroupFrame(group);
            if (groupFrame != null) {
                this.jDesktopPane.remove(groupFrame);
                groupFrame.dispose();
                this.jDesktopPane.validate();
                this.jDesktopPane.repaint();
            }
        }
        catch (RuntimeException ex) {
            System.out.println("Exception removing internal group frame: " + ex.getMessage());
        }
    }

    boolean createInternalFrameGroup(TxGroup group) {
        int margin;
        InternalFrameGroup groupFrame = this.getGroupFrame(group);
        if (groupFrame != null && groupFrame.isIcon()) {
            try {
                groupFrame.setIcon(false);
            }
            catch (PropertyVetoException ex) {
                Logger.getLogger(FrameTaxaDB.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        InternalFrameGroup frame = new InternalFrameGroup(this, this.sbdb, group, this.jPanelGroups);
        this.jDesktopPane.add(frame);
        try {
            frame.setSelected(true);
        }
        catch (PropertyVetoException ex) {
            ex.printStackTrace();
        }
        frame.setTitle("Group: " + group.getName());
        JInternalFrame[] frames = this.jDesktopPane.getAllFrames();
        int xMargin = margin = (frames.length - 1) * 24;
        if (this.frameTaxa.isShowing()) {
            xMargin += this.frameTaxa.getWidth();
        }
        int width = this.jDesktopPane.getBounds().width * 1 / 4 - 24;
        int height = this.jDesktopPane.getBounds().height * 2 / 3 - 24;
        frame.setBounds(frames.length + xMargin, frames.length + margin, width, height);
        this.setCursor(Cursor.getDefaultCursor());
        return true;
    }

    private void createMenu() {
        JInternalFrame frame = this.jDesktopPane.getSelectedFrame();
        JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(frame.getTitle(), true);
        this.jMenuWindows.add(menuItem);
        this.buttonGroupWindows.add(menuItem);
        menuItem.addActionListener(this::menuItemActionPerformed);
    }

    private void menuItemActionPerformed(ActionEvent evt) {
        JInternalFrame[] frames = this.jDesktopPane.getAllFrames();
        JCheckBoxMenuItem item = null;
        for (int m = 0; m < this.jMenuWindows.getItemCount(); ++m) {
            JMenuItem menuItem;
            if (this.jMenuWindows.getItem(m) == null || (menuItem = this.jMenuWindows.getItem(m)).getClass() != JCheckBoxMenuItem.class) continue;
            item = (JCheckBoxMenuItem)menuItem;
            if (item.isSelected()) break;
            item = null;
        }
        if (item == null) {
            return;
        }
        for (JInternalFrame frame : frames) {
            if (!item.getText().equals(frame.getTitle())) continue;
            try {
                frame.setSelected(true);
            }
            catch (PropertyVetoException ex) {
                ex.printStackTrace();
            }
        }
    }

    private void filterGroups(Discipline disc) {
        try {
            this.jPanelGroups.setDiscFilter(disc);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("Error filtering groups", sql, this.sbdb);
        }
    }

    private void openGroupFrame() {
        try {
            this.createInternalFrameGroup(null);
            this.createMenu();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), this.getTitle(), 0);
        }
    }

    private void closeActiveWindow() {
        JInternalFrame frame = this.jDesktopPane.getSelectedFrame();
        if (frame == this.frameTaxa) {
            return;
        }
        try {
            frame.setClosed(true);
        }
        catch (PropertyVetoException ex) {
            ex.printStackTrace();
        }
    }

    private void initComponents() {
        this.jPopupMenu1 = new JPopupMenu();
        this.jMenuItem1 = new JMenuItem();
        this.buttonGroupWindows = new ButtonGroup();
        this.buttonGroupShowTaxa = new ButtonGroup();
        this.buttonGroupGroupDiscFilter = new ButtonGroup();
        this.jSeparator19 = new JSeparator();
        this.jPopupMenu2 = new JPopupMenu();
        this.jMenuItem2 = new JMenuItem();
        this.jToolBar1 = new JToolBar();
        this.jButtonTaxonAdd = new JButton();
        this.jButtonTaxonSearch = new JButton();
        this.jButtonTaxonEdit = new JButton();
        this.jSeparator10 = new JSeparator();
        this.jButtonGroupAdd = new JButton();
        this.jButtonGroupEdit = new JButton();
        this.jSeparator11 = new JSeparator();
        this.jButtonCascade = new JButton();
        this.jButtonCloseWindow = new JButton();
        this.jSeparator12 = new JSeparator();
        this.jButtonOverlay = new JButton();
        this.jButtonOpenTemplate = new JButton();
        this.jSplitPane1 = new JSplitPane();
        this.jSplitPane2 = new JSplitPane();
        this.jDesktopPane = new JDesktopPane();
        this.jButtonProjects = new JButton();
        this.jComboBoxProject = new JComboBox();
        this.jLabelProject = new JLabel();
        this.filler1 = new Box.Filler(new Dimension(0, 3), new Dimension(0, 3), new Dimension(Short.MAX_VALUE, 3));
        this.jMenuBar1 = new JMenuBar();
        this.jMenuFile = new JMenu();
        this.jMenuItemOverlays = new JMenuItem();
        this.jMenuItemSIPMCodes = new JMenuItem();
        this.jMenuItemCharts = new JMenuItem();
        this.jMenuItemFileSlideStore = new JMenuItem();
        this.jSeparator6 = new JPopupMenu.Separator();
        this.jMenuItemExit = new JMenuItem();
        this.jMenuTaxa = new JMenu();
        this.jMenuItemSelectTaxa = new JMenuItem();
        this.jMenuItemSelectTaxaFromWell = new JMenuItem();
        this.jMenuItemAdvancedSearch = new JMenuItem();
        this.jMenuItemAdvancedSearchDict = new JMenuItem();
        this.jMenuItemSearchCode = new JMenuItem();
        this.jMenuItemSelectTaxaImages = new JMenuItem();
        this.jMenuItemSelectTaxaInSlideStore = new JMenuItem();
        this.jSeparator21 = new JPopupMenu.Separator();
        this.jMenuItemExportTaxa = new JMenuItem();
        this.jMenuItemSaveList = new JMenuItem();
        this.jMenuItemImportTaxa = new JMenuItem();
        this.jMenuItemPrintImages = new JMenuItem();
        this.jSeparator2 = new JPopupMenu.Separator();
        this.jMenuItemAddTaxon = new JMenuItem();
        this.jMenuItemMerge = new JMenuItem();
        this.jMenuItemDeleteAll = new JMenuItem();
        this.jMenuItemFindSimilar = new JMenuItem();
        this.jSeparator3 = new JPopupMenu.Separator();
        this.jMenuTaxon = new JMenu();
        this.jMenuItemEditTaxon = new JMenuItem();
        this.jMenuItemDelete = new JMenuItem();
        this.jSeparator4 = new JPopupMenu.Separator();
        this.jMenuItemTaxonWebLookup = new JMenuItem();
        this.jMenuItemTaxonURL = new JMenuItem();
        this.jMenuItemOccurences = new JMenuItem();
        this.jMenuItemTaxonSearchDB = new JMenuItem();
        this.jSeparator16 = new JPopupMenu.Separator();
        this.jMenuItemImages = new JMenuItem();
        this.jMenuItemSlideStore = new JMenuItem();
        this.jMenuItemLinkedEvents = new JMenuItem();
        this.jMenuItemNumericalCodes = new JMenuItem();
        this.jMenuItemGroupMembership = new JMenuItem();
        this.jMenuItemReferenceNotes = new JMenuItem();
        this.jMenuItemSynonymy = new JMenuItem();
        this.jMenuItemEditOccTypes = new JMenuItem();
        this.jSeparator20 = new JPopupMenu.Separator();
        this.jMenuItemGenerateCodes = new JMenuItem();
        this.jSeparator15 = new JPopupMenu.Separator();
        this.jMenuItemCategories = new JMenuItem();
        this.jMenuItemGenera = new JMenuItem();
        this.jMenuGroup = new JMenu();
        this.jMenuItemAddGroup = new JMenuItem();
        this.jMenuItemImportGroup = new JMenuItem();
        this.jMenuItemShowNoCharts = new JMenuItem();
        this.jSeparator14 = new JPopupMenu.Separator();
        this.jMenuItemRename = new JMenuItem();
        this.jMenuItemEditGroup = new JMenuItem();
        this.jMenuItemGroupInsertWell = new JMenuItem();
        this.jMenuItemDeleteGroup = new JMenuItem();
        this.jMenuItemGroupPermissions = new JMenuItem();
        this.jSeparator9 = new JPopupMenu.Separator();
        this.jMenuItemGroupLogSheet = new JMenuItem();
        this.jMenuItemExportGroup = new JMenuItem();
        this.jMenuItemExportGroupText = new JMenuItem();
        this.jSeparator8 = new JPopupMenu.Separator();
        this.jMenuGroupDiscFilter = new JMenu();
        this.jSeparator18 = new JPopupMenu.Separator();
        this.jMenuItemGroupUsages = new JMenuItem();
        this.jMenuItemShowCharts = new JMenuItem();
        this.jMenuSet = new JMenu();
        this.jMenuItemSetAdd = new JMenuItem();
        this.jMenuItemImportSet = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.jMenuItemSetEdit = new JMenuItem();
        this.jMenuItemSetDelete = new JMenuItem();
        this.jMenuItemSetsPermissions = new JMenuItem();
        this.jSeparator5 = new JPopupMenu.Separator();
        this.jMenuItemSetPrintLoggingSheet = new JMenuItem();
        this.jMenuItemExportSet = new JMenuItem();
        this.jSeparator13 = new JPopupMenu.Separator();
        this.jMenuItemSetShowGroups = new JMenuItem();
        this.jMenuItemSetUsages = new JMenuItem();
        this.jMenuItemSetShowCharts = new JMenuItem();
        this.jMenuEvents = new JMenu();
        this.jMenuItemEventAdd = new JMenuItem();
        this.jMenuItemEventDict = new JMenuItem();
        this.jMenuItemMergeEvents = new JMenuItem();
        this.jMenuItemShowEventUsage = new JMenuItem();
        this.jMenuItemDeleteNonOccEvents = new JMenuItem();
        this.jMenuItemCmpStd = new JMenuItem();
        this.jMenuItemCmpStdNew = new JMenuItem();
        this.jMenuItemCmpStdStats = new JMenuItem();
        this.jMenuWindows = new JMenu();
        this.jMenuItemCascade = new JMenuItem();
        this.jMenuItemCloseWindow = new JMenuItem();
        this.jSeparator17 = new JPopupMenu.Separator();
        this.jCheckBoxMenuItemViewGlobal = new JCheckBoxMenuItem();
        this.jCheckBoxMenuItemShowProjectColumn = new JCheckBoxMenuItem();
        this.jMenuHelp = new JMenu();
        this.jMenuItemContents = new JMenuItem();
        this.jSeparator7 = new JPopupMenu.Separator();
        this.jMenuItemHelpMenu = new JMenuItem();
        this.jMenuItemHelpGuide = new JMenuItem();
        this.jMenuItem1.setText("Item");
        this.jPopupMenu1.add(this.jMenuItem1);
        this.jMenuItem2.setText("jMenuItem2");
        this.setDefaultCloseOperation(0);
        this.setMinimumSize(new Dimension(850, 420));
        this.addWindowListener(new WindowAdapter(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void windowClosing(WindowEvent evt) {
                this.this$0.windowClosing(evt);
            }
        });
        this.jToolBar1.setBorder(null);
        this.jButtonTaxonAdd.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/FrameTaxa_AddTaxon.png")));
        this.jButtonTaxonAdd.setToolTipText("Add new taxon");
        this.jButtonTaxonAdd.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonTaxonAddActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonTaxonAdd);
        this.jButtonTaxonSearch.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/FrameTaxa_FindTaxon.png")));
        this.jButtonTaxonSearch.setToolTipText("Search for taxa");
        this.jButtonTaxonSearch.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonTaxonSearchActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonTaxonSearch);
        this.jButtonTaxonEdit.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/FrameTaxa_EditTaxon.png")));
        this.jButtonTaxonEdit.setToolTipText("Edit selected taxon");
        this.jButtonTaxonEdit.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonTaxonEditActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonTaxonEdit);
        this.jSeparator10.setBackground(new Color(224, 225, 227));
        this.jSeparator10.setOrientation(1);
        this.jSeparator10.setMaximumSize(new Dimension(5, 30));
        this.jSeparator10.setMinimumSize(new Dimension(5, 10));
        this.jToolBar1.add(this.jSeparator10);
        this.jButtonGroupAdd.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/FrameTaxa_AddGroup.png")));
        this.jButtonGroupAdd.setToolTipText("Add new group");
        this.jButtonGroupAdd.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonGroupAddActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonGroupAdd);
        this.jButtonGroupEdit.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/FrameTaxa_EditGroup.png")));
        this.jButtonGroupEdit.setToolTipText("Edit a group's taxa");
        this.jButtonGroupEdit.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonGroupEditActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonGroupEdit);
        this.jSeparator11.setBackground(new Color(224, 225, 227));
        this.jSeparator11.setOrientation(1);
        this.jSeparator11.setMaximumSize(new Dimension(5, 30));
        this.jSeparator11.setMinimumSize(new Dimension(5, 10));
        this.jToolBar1.add(this.jSeparator11);
        this.jButtonCascade.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/FrameInterpretations_Cascade.png")));
        this.jButtonCascade.setToolTipText("Cascade internal windows");
        this.jButtonCascade.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCascadeActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonCascade);
        this.jButtonCloseWindow.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/FrameInterpretations_CloseWindow.png")));
        this.jButtonCloseWindow.setToolTipText("Close active window");
        this.jButtonCloseWindow.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCloseWindowActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonCloseWindow);
        this.jSeparator12.setBackground(new Color(224, 225, 227));
        this.jSeparator12.setOrientation(1);
        this.jSeparator12.setMaximumSize(new Dimension(5, 30));
        this.jSeparator12.setMinimumSize(new Dimension(5, 10));
        this.jToolBar1.add(this.jSeparator12);
        this.jButtonOverlay.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/FrameTaxa_Overlay.png")));
        this.jButtonOverlay.setToolTipText("Overlays...");
        this.jButtonOverlay.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOverlayActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonOverlay);
        this.jButtonOpenTemplate.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/openSchemeTemplate.png")));
        this.jButtonOpenTemplate.setToolTipText("Open chart template...");
        this.jButtonOpenTemplate.setFocusable(false);
        this.jButtonOpenTemplate.setHorizontalTextPosition(0);
        this.jButtonOpenTemplate.setVerticalTextPosition(3);
        this.jButtonOpenTemplate.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOpenTemplateActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonOpenTemplate);
        this.jSplitPane1.setBorder(null);
        this.jSplitPane1.setDividerSize(10);
        this.jSplitPane1.setResizeWeight(0.33);
        this.jSplitPane1.setOneTouchExpandable(true);
        this.jSplitPane2.setBorder(null);
        this.jSplitPane2.setDividerSize(10);
        this.jSplitPane2.setOrientation(0);
        this.jSplitPane2.setResizeWeight(0.8);
        this.jSplitPane2.setMinimumSize(new Dimension(0, 0));
        this.jSplitPane2.setOneTouchExpandable(true);
        this.jSplitPane1.setLeftComponent(this.jSplitPane2);
        this.jDesktopPane.setBackground(new Color(102, 102, 102));
        this.jSplitPane1.setRightComponent(this.jDesktopPane);
        this.jButtonProjects.setFont(this.jButtonProjects.getFont());
        this.jButtonProjects.setText("...");
        this.jButtonProjects.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonProjectsActionPerformed(evt);
            }
        });
        this.jComboBoxProject.setMaximumRowCount(30);
        this.jComboBoxProject.setModel(this.projectModel);
        this.jLabelProject.setFont(this.jLabelProject.getFont().deriveFont(this.jLabelProject.getFont().getStyle() | 1, this.jLabelProject.getFont().getSize() + 2));
        this.jLabelProject.setText("Project:");
        this.jMenuFile.setText("File");
        this.jMenuItemOverlays.setText("Overlays...");
        this.jMenuItemOverlays.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemOverlaysActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemOverlays);
        this.jMenuItemSIPMCodes.setText("Numeric code dictionaries...");
        this.jMenuItemSIPMCodes.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemSIPMCodesActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemSIPMCodes);
        this.jMenuItemCharts.setText("Open chart template...");
        this.jMenuItemCharts.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemChartsActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemCharts);
        this.jMenuItemFileSlideStore.setText("Slide store...");
        this.jMenuItemFileSlideStore.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemFileSlideStoreActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemFileSlideStore);
        this.jMenuFile.add(this.jSeparator6);
        this.jMenuItemExit.setText("Exit");
        this.jMenuItemExit.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemExitActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemExit);
        this.jMenuBar1.add(this.jMenuFile);
        this.jMenuTaxa.setText("Taxa");
        this.jMenuItemSelectTaxa.setAccelerator(KeyStroke.getKeyStroke(70, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.jMenuItemSelectTaxa.setText("Select taxa...");
        this.jMenuItemSelectTaxa.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemSelectTaxaActionPerformed(evt);
            }
        });
        this.jMenuTaxa.add(this.jMenuItemSelectTaxa);
        this.jMenuItemSelectTaxaFromWell.setText("Select taxa from wells/outcrops...");
        this.jMenuItemSelectTaxaFromWell.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemSelectTaxaFromWellActionPerformed(evt);
            }
        });
        this.jMenuTaxa.add(this.jMenuItemSelectTaxaFromWell);
        this.jMenuItemAdvancedSearch.setText("Advanced search in wells...");
        this.jMenuItemAdvancedSearch.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemAdvancedSearchActionPerformed(evt);
            }
        });
        this.jMenuTaxa.add(this.jMenuItemAdvancedSearch);
        this.jMenuItemAdvancedSearchDict.setText("Search by date entered ...");
        this.jMenuItemAdvancedSearchDict.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemAdvancedSearchDictActionPerformed(evt);
            }
        });
        this.jMenuTaxa.add(this.jMenuItemAdvancedSearchDict);
        this.jMenuItemSearchCode.setText("Search by numeric code...");
        this.jMenuItemSearchCode.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemSearchCodeActionPerformed(evt);
            }
        });
        this.jMenuTaxa.add(this.jMenuItemSearchCode);
        this.jMenuItemSelectTaxaImages.setText("Select all taxa linked to images");
        this.jMenuItemSelectTaxaImages.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemSelectTaxaImagesActionPerformed(evt);
            }
        });
        this.jMenuTaxa.add(this.jMenuItemSelectTaxaImages);
        this.jMenuItemSelectTaxaInSlideStore.setText("Select all taxa in slide store");
        this.jMenuItemSelectTaxaInSlideStore.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemSelectTaxaInSlideStoreActionPerformed(evt);
            }
        });
        this.jMenuTaxa.add(this.jMenuItemSelectTaxaInSlideStore);
        this.jMenuTaxa.add(this.jSeparator21);
        this.jMenuItemExportTaxa.setText("Export list (including synonymy) ...");
        this.jMenuItemExportTaxa.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemExportTaxaActionPerformed(evt);
            }
        });
        this.jMenuTaxa.add(this.jMenuItemExportTaxa);
        this.jMenuItemSaveList.setText("Save list as text...");
        this.jMenuItemSaveList.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemSaveListActionPerformed(evt);
            }
        });
        this.jMenuTaxa.add(this.jMenuItemSaveList);
        this.jMenuItemImportTaxa.setText("Import (synonymy) ...");
        this.jMenuItemImportTaxa.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemImportTaxaActionPerformed(evt);
            }
        });
        this.jMenuTaxa.add(this.jMenuItemImportTaxa);
        this.jMenuItemPrintImages.setText("Image gallery...");
        this.jMenuItemPrintImages.setToolTipText("Review images of selected taxa in list");
        this.jMenuItemPrintImages.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemPrintImagesActionPerformed(evt);
            }
        });
        this.jMenuTaxa.add(this.jMenuItemPrintImages);
        this.jMenuTaxa.add(this.jSeparator2);
        this.jMenuItemAddTaxon.setAccelerator(KeyStroke.getKeyStroke(78, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.jMenuItemAddTaxon.setText("Add...");
        this.jMenuItemAddTaxon.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemAddTaxonActionPerformed(evt);
            }
        });
        this.jMenuTaxa.add(this.jMenuItemAddTaxon);
        this.jMenuItemMerge.setAccelerator(KeyStroke.getKeyStroke(77, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.jMenuItemMerge.setText("Merge...");
        this.jMenuItemMerge.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemMergeActionPerformed(evt);
            }
        });
        this.jMenuTaxa.add(this.jMenuItemMerge);
        this.jMenuItemDeleteAll.setText("Delete all non-occurring taxa...");
        this.jMenuItemDeleteAll.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemDeleteAllActionPerformed(evt);
            }
        });
        this.jMenuTaxa.add(this.jMenuItemDeleteAll);
        this.jMenuItemFindSimilar.setText("Find similar taxa...");
        this.jMenuItemFindSimilar.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemFindSimilarActionPerformed(evt);
            }
        });
        this.jMenuTaxa.add(this.jMenuItemFindSimilar);
        this.jMenuTaxa.add(this.jSeparator3);
        this.jMenuTaxon.setText("Taxon");
        this.jMenuItemEditTaxon.setText("Edit...");
        this.jMenuItemEditTaxon.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemEditTaxonActionPerformed(evt);
            }
        });
        this.jMenuTaxon.add(this.jMenuItemEditTaxon);
        this.jMenuItemDelete.setText("Delete");
        this.jMenuItemDelete.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemDeleteActionPerformed(evt);
            }
        });
        this.jMenuTaxon.add(this.jMenuItemDelete);
        this.jMenuTaxon.add(this.jSeparator4);
        this.jMenuItemTaxonWebLookup.setText("Search web...");
        this.jMenuItemTaxonWebLookup.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemTaxonWebLookupActionPerformed(evt);
            }
        });
        this.jMenuTaxon.add(this.jMenuItemTaxonWebLookup);
        this.jMenuItemTaxonURL.setText("Go to URL...");
        this.jMenuItemTaxonURL.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemTaxonURLActionPerformed(evt);
            }
        });
        this.jMenuTaxon.add(this.jMenuItemTaxonURL);
        this.jMenuItemOccurences.setText("Search wells...");
        this.jMenuItemOccurences.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemOccurencesActionPerformed(evt);
            }
        });
        this.jMenuTaxon.add(this.jMenuItemOccurences);
        this.jMenuItemTaxonSearchDB.setText("Search database...");
        this.jMenuItemTaxonSearchDB.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemTaxonSearchDBActionPerformed(evt);
            }
        });
        this.jMenuTaxon.add(this.jMenuItemTaxonSearchDB);
        this.jMenuTaxon.add(this.jSeparator16);
        this.jMenuItemImages.setText("Images...");
        this.jMenuItemImages.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemImagesActionPerformed(evt);
            }
        });
        this.jMenuTaxon.add(this.jMenuItemImages);
        this.jMenuItemSlideStore.setText("Slide store...");
        this.jMenuItemSlideStore.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemSlideStoreActionPerformed(evt);
            }
        });
        this.jMenuTaxon.add(this.jMenuItemSlideStore);
        this.jMenuItemLinkedEvents.setText("Linked Events...");
        this.jMenuItemLinkedEvents.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemLinkedEventsActionPerformed(evt);
            }
        });
        this.jMenuTaxon.add(this.jMenuItemLinkedEvents);
        this.jMenuItemNumericalCodes.setText("Numeric codes...");
        this.jMenuItemNumericalCodes.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemNumericalCodesActionPerformed(evt);
            }
        });
        this.jMenuTaxon.add(this.jMenuItemNumericalCodes);
        this.jMenuItemGroupMembership.setText("Group membership...");
        this.jMenuItemGroupMembership.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemGroupMembershipActionPerformed(evt);
            }
        });
        this.jMenuTaxon.add(this.jMenuItemGroupMembership);
        this.jMenuItemReferenceNotes.setText("References and Notes...");
        this.jMenuItemReferenceNotes.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemReferenceNotesActionPerformed(evt);
            }
        });
        this.jMenuTaxon.add(this.jMenuItemReferenceNotes);
        this.jMenuItemSynonymy.setText("Synonymy...");
        this.jMenuItemSynonymy.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemSynonymyActionPerformed(evt);
            }
        });
        this.jMenuTaxon.add(this.jMenuItemSynonymy);
        this.jMenuItemEditOccTypes.setText("Edit occurrences...");
        this.jMenuItemEditOccTypes.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemEditOccTypesActionPerformed(evt);
            }
        });
        this.jMenuTaxon.add(this.jMenuItemEditOccTypes);
        this.jMenuTaxon.add(this.jSeparator20);
        this.jMenuItemGenerateCodes.setText("Generate alphanumeric codes...");
        this.jMenuItemGenerateCodes.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemGenerateCodesActionPerformed(evt);
            }
        });
        this.jMenuTaxon.add(this.jMenuItemGenerateCodes);
        this.jMenuTaxa.add(this.jMenuTaxon);
        this.jMenuTaxa.add(this.jSeparator15);
        this.jMenuItemCategories.setText("Categories...");
        this.jMenuItemCategories.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemCategoriesActionPerformed(evt);
            }
        });
        this.jMenuTaxa.add(this.jMenuItemCategories);
        this.jMenuItemGenera.setText("Genera...");
        this.jMenuItemGenera.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemGeneraActionPerformed(evt);
            }
        });
        this.jMenuTaxa.add(this.jMenuItemGenera);
        this.jMenuBar1.add(this.jMenuTaxa);
        this.jMenuGroup.setText("Groups");
        this.jMenuItemAddGroup.setText("Add...");
        this.jMenuItemAddGroup.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemAddGroupActionPerformed(evt);
            }
        });
        this.jMenuGroup.add(this.jMenuItemAddGroup);
        this.jMenuItemImportGroup.setText("Import...");
        this.jMenuItemImportGroup.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemImportGroupActionPerformed(evt);
            }
        });
        this.jMenuGroup.add(this.jMenuItemImportGroup);
        this.jMenuItemShowNoCharts.setText("Show groups not in charts...");
        this.jMenuItemShowNoCharts.setToolTipText("Show groups with NO chart association (or in a set in a chart)...");
        this.jMenuItemShowNoCharts.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemShowNoChartsActionPerformed(evt);
            }
        });
        this.jMenuGroup.add(this.jMenuItemShowNoCharts);
        this.jMenuGroup.add(this.jSeparator14);
        this.jMenuItemRename.setText("Edit details...");
        this.jMenuItemRename.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemRenameActionPerformed(evt);
            }
        });
        this.jMenuGroup.add(this.jMenuItemRename);
        this.jMenuItemEditGroup.setText("Edit taxa...");
        this.jMenuItemEditGroup.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemEditGroupActionPerformed(evt);
            }
        });
        this.jMenuGroup.add(this.jMenuItemEditGroup);
        this.jMenuItemGroupInsertWell.setText("Insert taxa from wells/outcrops...");
        this.jMenuItemGroupInsertWell.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemGroupInsertWellActionPerformed(evt);
            }
        });
        this.jMenuGroup.add(this.jMenuItemGroupInsertWell);
        this.jMenuItemDeleteGroup.setText("Delete");
        this.jMenuItemDeleteGroup.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemDeleteGroupActionPerformed(evt);
            }
        });
        this.jMenuGroup.add(this.jMenuItemDeleteGroup);
        this.jMenuItemGroupPermissions.setText("Permissions...");
        this.jMenuItemGroupPermissions.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemGroupPermissionsActionPerformed(evt);
            }
        });
        this.jMenuGroup.add(this.jMenuItemGroupPermissions);
        this.jMenuGroup.add(this.jSeparator9);
        this.jMenuItemGroupLogSheet.setText("Print logging sheet...");
        this.jMenuItemGroupLogSheet.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemGroupLogSheetActionPerformed(evt);
            }
        });
        this.jMenuGroup.add(this.jMenuItemGroupLogSheet);
        this.jMenuItemExportGroup.setText("Export ...");
        this.jMenuItemExportGroup.setToolTipText("Export the selected group as a StrataBugs file");
        this.jMenuItemExportGroup.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemExportGroupActionPerformed(evt);
            }
        });
        this.jMenuGroup.add(this.jMenuItemExportGroup);
        this.jMenuItemExportGroupText.setText("Export as text...");
        this.jMenuItemExportGroupText.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemExportGroupTextActionPerformed(evt);
            }
        });
        this.jMenuGroup.add(this.jMenuItemExportGroupText);
        this.jMenuGroup.add(this.jSeparator8);
        this.jMenuGroupDiscFilter.setText("Filter by discipline");
        this.jMenuGroup.add(this.jMenuGroupDiscFilter);
        this.jMenuGroup.add(this.jSeparator18);
        this.jMenuItemGroupUsages.setText("Show chart panels...");
        this.jMenuItemGroupUsages.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemGroupUsagesActionPerformed(evt);
            }
        });
        this.jMenuGroup.add(this.jMenuItemGroupUsages);
        this.jMenuItemShowCharts.setText("Show legacy charts...");
        this.jMenuItemShowCharts.setToolTipText("Show which charts include a reference to selected group");
        this.jMenuItemShowCharts.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemShowChartsActionPerformed(evt);
            }
        });
        this.jMenuGroup.add(this.jMenuItemShowCharts);
        this.jMenuBar1.add(this.jMenuGroup);
        this.jMenuSet.setText("Sets");
        this.jMenuItemSetAdd.setText("Add...");
        this.jMenuItemSetAdd.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemSetAddActionPerformed(evt);
            }
        });
        this.jMenuSet.add(this.jMenuItemSetAdd);
        this.jMenuItemImportSet.setText("Import...");
        this.jMenuItemImportSet.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemImportSetActionPerformed(evt);
            }
        });
        this.jMenuSet.add(this.jMenuItemImportSet);
        this.jMenuSet.add(this.jSeparator1);
        this.jMenuItemSetEdit.setText("Edit...");
        this.jMenuItemSetEdit.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemSetEditActionPerformed(evt);
            }
        });
        this.jMenuSet.add(this.jMenuItemSetEdit);
        this.jMenuItemSetDelete.setText("Delete");
        this.jMenuItemSetDelete.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemSetDeleteActionPerformed(evt);
            }
        });
        this.jMenuSet.add(this.jMenuItemSetDelete);
        this.jMenuItemSetsPermissions.setText("Permissions...");
        this.jMenuItemSetsPermissions.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemSetsPermissionsActionPerformed(evt);
            }
        });
        this.jMenuSet.add(this.jMenuItemSetsPermissions);
        this.jMenuSet.add(this.jSeparator5);
        this.jMenuItemSetPrintLoggingSheet.setText("Print logging sheet...");
        this.jMenuItemSetPrintLoggingSheet.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemSetPrintLoggingSheetActionPerformed(evt);
            }
        });
        this.jMenuSet.add(this.jMenuItemSetPrintLoggingSheet);
        this.jMenuItemExportSet.setText("Export...");
        this.jMenuItemExportSet.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemExportSetActionPerformed(evt);
            }
        });
        this.jMenuSet.add(this.jMenuItemExportSet);
        this.jMenuSet.add(this.jSeparator13);
        this.jMenuItemSetShowGroups.setAccelerator(KeyStroke.getKeyStroke(71, 192));
        this.jMenuItemSetShowGroups.setText("Show groups...");
        this.jMenuItemSetShowGroups.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemSetShowGroupsActionPerformed(evt);
            }
        });
        this.jMenuSet.add(this.jMenuItemSetShowGroups);
        this.jMenuItemSetUsages.setText("Show chart panels...");
        this.jMenuItemSetUsages.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemSetUsagesActionPerformed(evt);
            }
        });
        this.jMenuSet.add(this.jMenuItemSetUsages);
        this.jMenuItemSetShowCharts.setText("Show legacy charts...");
        this.jMenuItemSetShowCharts.setToolTipText("Disply a list of charts that reference the selected set");
        this.jMenuItemSetShowCharts.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemSetShowChartsActionPerformed(evt);
            }
        });
        this.jMenuSet.add(this.jMenuItemSetShowCharts);
        this.jMenuBar1.add(this.jMenuSet);
        this.jMenuEvents.setText("Events ");
        this.jMenuItemEventAdd.setText("Add event...");
        this.jMenuItemEventAdd.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemEventAddActionPerformed(evt);
            }
        });
        this.jMenuEvents.add(this.jMenuItemEventAdd);
        this.jMenuItemEventDict.setText("Open event dictionary");
        this.jMenuItemEventDict.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemEventDictActionPerformed(evt);
            }
        });
        this.jMenuEvents.add(this.jMenuItemEventDict);
        this.jMenuItemMergeEvents.setText("Merge...");
        this.jMenuItemMergeEvents.setToolTipText("Select events linked to the same taxon before merging");
        this.jMenuItemMergeEvents.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemMergeEventsActionPerformed(evt);
            }
        });
        this.jMenuEvents.add(this.jMenuItemMergeEvents);
        this.jMenuItemShowEventUsage.setText("Show usage...");
        this.jMenuItemShowEventUsage.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemShowEventUsageActionPerformed(evt);
            }
        });
        this.jMenuEvents.add(this.jMenuItemShowEventUsage);
        this.jMenuItemDeleteNonOccEvents.setText("Delete all non-occurring events...");
        this.jMenuItemDeleteNonOccEvents.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemDeleteNonOccEventsActionPerformed(evt);
            }
        });
        this.jMenuEvents.add(this.jMenuItemDeleteNonOccEvents);
        this.jMenuItemCmpStd.setText("Composite standards...");
        this.jMenuItemCmpStd.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemCmpStdActionPerformed(evt);
            }
        });
        this.jMenuEvents.add(this.jMenuItemCmpStd);
        this.jMenuItemCmpStdNew.setText("New composite standard...");
        this.jMenuItemCmpStdNew.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemCmpStdNewActionPerformed(evt);
            }
        });
        this.jMenuEvents.add(this.jMenuItemCmpStdNew);
        this.jMenuItemCmpStdStats.setText("Composite standard/well age statistics ...");
        this.jMenuItemCmpStdStats.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemCmpStdStatsActionPerformed(evt);
            }
        });
        this.jMenuEvents.add(this.jMenuItemCmpStdStats);
        this.jMenuBar1.add(this.jMenuEvents);
        this.jMenuWindows.setText("View");
        this.jMenuItemCascade.setText("Cascade windows");
        this.jMenuItemCascade.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemCascadeActionPerformed(evt);
            }
        });
        this.jMenuWindows.add(this.jMenuItemCascade);
        this.jMenuItemCloseWindow.setText("Close active window");
        this.jMenuItemCloseWindow.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemCloseWindowActionPerformed(evt);
            }
        });
        this.jMenuWindows.add(this.jMenuItemCloseWindow);
        this.jMenuWindows.add(this.jSeparator17);
        this.jCheckBoxMenuItemViewGlobal.setSelected(true);
        this.jCheckBoxMenuItemViewGlobal.setText("Show global project");
        this.jCheckBoxMenuItemViewGlobal.addItemListener(new ItemListener(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void itemStateChanged(ItemEvent evt) {
                this.this$0.jCheckBoxMenuItemViewGlobalItemStateChanged(evt);
            }
        });
        this.jMenuWindows.add(this.jCheckBoxMenuItemViewGlobal);
        this.jCheckBoxMenuItemShowProjectColumn.setSelected(true);
        this.jCheckBoxMenuItemShowProjectColumn.setText("Show project column");
        this.jCheckBoxMenuItemShowProjectColumn.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jCheckBoxMenuItemShowProjectColumnActionPerformed(evt);
            }
        });
        this.jMenuWindows.add(this.jCheckBoxMenuItemShowProjectColumn);
        this.jMenuBar1.add(this.jMenuWindows);
        this.jMenuHelp.setText("Help");
        this.jMenuItemContents.setText("Taxonomic Database help...");
        this.jMenuItemContents.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemContentsActionPerformed(evt);
            }
        });
        this.jMenuHelp.add(this.jMenuItemContents);
        this.jMenuHelp.add(this.jSeparator7);
        this.jMenuItemHelpMenu.setText("Menus...");
        this.jMenuItemHelpMenu.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemHelpMenuActionPerformed(evt);
            }
        });
        this.jMenuHelp.add(this.jMenuItemHelpMenu);
        this.jMenuItemHelpGuide.setText("Guide to main window...");
        this.jMenuItemHelpGuide.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemHelpGuideActionPerformed(evt);
            }
        });
        this.jMenuHelp.add(this.jMenuItemHelpGuide);
        this.jMenuBar1.add(this.jMenuHelp);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jToolBar1, -2, 394, -2).addPreferredGap(0, 53, Short.MAX_VALUE).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.filler1, -2, 222, -2).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabelProject).addPreferredGap(0).add((Component)this.jComboBoxProject, -2, 141, -2).addPreferredGap(0).add((Component)this.jButtonProjects, -2, 40, -2))).addContainerGap()).add((Component)this.jSplitPane1));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.filler1, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jComboBoxProject, -2, -1, -2).add((Component)this.jLabelProject).add((Component)this.jButtonProjects))).add((Component)this.jToolBar1, -2, 34, -2)).addPreferredGap(0).add((Component)this.jSplitPane1, -1, 367, Short.MAX_VALUE)));
        this.pack();
    }

    private void jMenuItemSelectTaxaActionPerformed(ActionEvent evt) {
        this.jButtonTaxonSearchActionPerformed(null);
    }

    private void jMenuItemCloseWindowActionPerformed(ActionEvent evt) {
        this.closeActiveWindow();
    }

    private void jButtonCloseWindowActionPerformed(ActionEvent evt) {
        this.closeActiveWindow();
    }

    private void jMenuItemCascadeActionPerformed(ActionEvent evt) {
        SB.cascade((JDesktopPane)this.jDesktopPane);
    }

    private void jButtonCascadeActionPerformed(ActionEvent evt) {
        SB.cascade((JDesktopPane)this.jDesktopPane);
    }

    private void jButtonGroupAddActionPerformed(ActionEvent evt) {
        try {
            this.jPanelGroups.addGroup();
        }
        catch (SQLException | SBException | SBPermissionException sql) {
            FrameJsbugs.showStackError("SQL Error", (Exception)sql, this.sbdb);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void jMenuItemDeleteActionPerformed(ActionEvent evt) {
        this.frameTaxa.delete();
    }

    private void jButtonTaxonEditActionPerformed(ActionEvent evt) {
        this.jMenuItemEditTaxonActionPerformed(null);
    }

    private void jButtonTaxonAddActionPerformed(ActionEvent evt) {
        this.jMenuItemAddTaxonActionPerformed(null);
    }

    private void jButtonTaxonSearchActionPerformed(ActionEvent evt) {
        this.frameTaxa.search(null);
    }

    private void jMenuItemAdvancedSearchActionPerformed(ActionEvent evt) {
        this.frameTaxa.searchAdv();
    }

    private void jMenuItemMergeActionPerformed(ActionEvent evt) {
        this.frameTaxa.merge();
    }

    private void jButtonProjectsActionPerformed(ActionEvent evt) {
        try {
            DialogSelectProject dialog = new DialogSelectProject(this, true, this.sbdb, true, this.parent.getChartManager());
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.selection != null) {
                this.jComboBoxProject.setSelectedItem((Object)dialog.selection);
            }
        }
        catch (SBException sbe) {
            StackError.showStackError((String)"Error", (Throwable)sbe);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
    }

    private void jMenuItemCategoriesActionPerformed(ActionEvent evt) {
        try {
            DialogCategories dialog = new DialogCategories((Frame)this, true, this.sbdb);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }
        catch (RuntimeException e) {
            SbugsExceptionHandler.showDialogStackError(e, this);
        }
    }

    private void jMenuItemGroupMembershipActionPerformed(ActionEvent evt) {
        this.frameTaxa.groupMembership();
    }

    private void jMenuItemReferenceNotesActionPerformed(ActionEvent evt) {
        this.frameTaxa.notes();
    }

    private void jMenuItemSynonymyActionPerformed(ActionEvent evt) {
        this.frameTaxa.synonymy();
    }

    private void jMenuItemEditTaxonActionPerformed(ActionEvent evt) {
        this.frameTaxa.edit();
    }

    private void jMenuItemAddTaxonActionPerformed(ActionEvent evt) {
        this.frameTaxa.add();
    }

    private void jMenuItemExitActionPerformed(ActionEvent evt) {
        if (this.checkComposites()) {
            this.dispose();
        }
    }

    private boolean checkComposites() {
        LinkedList<JInternalFrame> frames = new LinkedList<JInternalFrame>();
        for (JInternalFrame frame : this.jDesktopPane.getAllFrames()) {
            if (!(frame instanceof InternalFrameCmpStd) || ((InternalFrameCmpStd)frame).getStatus() == SbugsStatus.STORED) continue;
            int opt = JOptionPane.showConfirmDialog(this, "Exit without saving changes to composite?", this.getTitle(), 0);
            if (opt != 0) {
                return false;
            }
            frames.add(frame);
        }
        for (JInternalFrame frame : frames) {
            frame.dispose();
        }
        return true;
    }

    void setTaxon(Taxon taxon) {
        ArrayList<Taxon> taxa = new ArrayList<Taxon>();
        taxa.add(taxon);
        this.frameTaxa.addTaxa(taxa);
        if (!this.frameTaxa.isVisible()) {
            this.frameTaxa.setVisible(true);
        }
    }

    private void jButtonGroupEditActionPerformed(ActionEvent evt) {
        this.jPanelGroups.editGroup();
    }

    private void jMenuItemEditOccTypesActionPerformed(ActionEvent evt) {
        this.frameTaxa.editOccType();
    }

    private void jMenuItemAddGroupActionPerformed(ActionEvent evt) {
        try {
            this.jPanelGroups.addGroup();
        }
        catch (SQLException | SBException | SBPermissionException sql) {
            FrameJsbugs.showStackError("SQL Error", (Exception)sql, this.sbdb);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void jMenuItemEditGroupActionPerformed(ActionEvent evt) {
        this.jPanelGroups.editGroup();
    }

    private void jMenuItemRenameActionPerformed(ActionEvent evt) {
        this.jPanelGroups.editGroupHeader();
    }

    private void jMenuItemDeleteGroupActionPerformed(ActionEvent evt) {
        this.jPanelGroups.deleteGroup();
    }

    private void jMenuItemGroupInsertWellActionPerformed(ActionEvent evt) {
        TxGroup group = null;
        JInternalFrame frame = this.jDesktopPane.getSelectedFrame();
        if (frame != null && frame.getClass() == InternalFrameGroup.class) {
            group = ((InternalFrameGroup)frame).getGroup();
        }
        TxGroup listGroup = this.jPanelGroups.getSelectedGroup();
        if (group == null) {
            group = listGroup;
        } else if (group != listGroup) {
            JOptionPane.showMessageDialog(this, "Group selection ambiguous: select the same group window as group list selection.", this.getTitle(), 1);
            return;
        }
        if (group == null) {
            JOptionPane.showMessageDialog(this, "Select a group", this.getTitle(), 1);
            return;
        }
        DialogWellDisc dialog = new DialogWellDisc(this, true, this.sbdb, null, false);
        SB.centreDialog((Dialog)dialog);
        dialog.setTitle(dialog.getTitle() + " Group : " + group.getName());
        dialog.setVisible(true);
        if (dialog.isOK) {
            try {
                for (Well well : dialog.wells) {
                    this.sbdb.insertGroupTaxa(group, well, dialog.discID, dialog.analyst);
                }
                this.sbdb.commit();
                group.notifyObservers();
            }
            catch (SQLException | SBException | SBPermissionException e) {
                JOptionPane.showMessageDialog(this, "Error inserting into group: " + e.getMessage(), this.getTitle(), 0);
                e.printStackTrace();
                this.sbdb.doRollback();
            }
        }
    }

    private void jButtonOverlayActionPerformed(ActionEvent evt) {
        this.jMenuItemOverlaysActionPerformed(null);
    }

    private void jMenuItemSetEditActionPerformed(ActionEvent evt) {
        this.jPanelSets.editSet();
    }

    private void jMenuItemSetDeleteActionPerformed(ActionEvent evt) {
        this.jPanelSets.deleteSet();
    }

    private void jMenuItemOpenOverlayActionPerformed(ActionEvent evt) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jMenuItemCmpStdActionPerformed(ActionEvent evt) {
        try {
            DialogSelectCmpStd dialog = new DialogSelectCmpStd((Frame)this, true, this.sbdb, true);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.selection != null) {
                JInternalFrame[] frames;
                this.setCursor(Cursor.getPredefinedCursor(3));
                for (JInternalFrame frame : frames = this.jDesktopPane.getAllFrames()) {
                    InternalFrameCmpStd f;
                    if (!(frame instanceof InternalFrameCmpStd) || (f = (InternalFrameCmpStd)frame).getCmpStd() != dialog.selection) continue;
                    frame.toFront();
                    return;
                }
                InternalFrameCmpStd internalFrame = new InternalFrameCmpStd(dialog.selection, this.sbdb);
                this.jDesktopPane.add(internalFrame);
                internalFrame.setSelected(true);
                internalFrame.setVisible(true);
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
        catch (PropertyVetoException pve) {
            pve.printStackTrace();
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private void jMenuItemContentsActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("taxadb.html");
    }

    private void jMenuItemDeleteAllActionPerformed(ActionEvent evt) {
        DialogTaxaUnusedDelete dialog = new DialogTaxaUnusedDelete((Frame)this, true, this.sbdb);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }

    private void jMenuItemOccurencesActionPerformed(ActionEvent evt) {
        this.frameTaxa.searchWellOcc();
    }

    private void jMenuItemNumericalCodesActionPerformed(ActionEvent evt) {
        this.frameTaxa.numericCodes();
    }

    private void jMenuItemOverlaysActionPerformed(ActionEvent evt) {
        try {
            DialogOverlays dialog = new DialogOverlays(this, this.parent, true, this.sbdb, false);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), this.getTitle(), 0);
            ex.printStackTrace();
        }
    }

    private void jMenuItemSelectTaxaImagesActionPerformed(ActionEvent evt) {
        this.frameTaxa.searchForImages();
    }

    private void jMenuItemHelpMenuActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("taxa_menu.html");
    }

    private void jMenuItemHelpGuideActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("frametaxa_guide.html");
    }

    private void jMenuItemEventAddActionPerformed(ActionEvent evt) {
        DialogEvent dialog = new DialogEvent(this, true, this.sbdb, null, null);
        dialog.setLocationRelativeTo(this);
        Taxon taxon = this.frameTaxa.getSelectedTaxon().orElse(null);
        if (taxon != null) {
            dialog.setTaxon(taxon);
        }
        dialog.setVisible(true);
        if (dialog.isOK() && this.frameEvents != null) {
            this.frameEvents.addEvent(dialog.sbEvent);
        }
    }

    private void jMenuItemExportGroupActionPerformed(ActionEvent evt) {
        TxGroup group = this.jPanelGroups.getSelectedGroup();
        if (group == null) {
            JOptionPane.showMessageDialog(this, "No group selected", this.getTitle(), 2);
            return;
        }
        this.export(group, null, null, -1);
    }

    private void export(TxGroup group, TxGroupSet groupSet, List<Taxon> list, int synSch) {
        if ((this.sbdb.getUser().getPriv() & 0x4000) > 0) {
            JOptionPane.showMessageDialog(this, "You are not allowed to export data.", this.getTitle(), 2);
            return;
        }
        String fileName = list == null ? (group == null ? groupSet.toString() : group.toString()) : "StrataBugsTaxonDictionary";
        File file = FileChooserUtils.chooseFileToWrite((SBdb)this.sbdb, (Component)this, (String)"JZIPFILE", null, (String[])new String[]{"sbg"}, (String[])new String[]{"StrataBugs SBG/XML"}, (String)fileName);
        if (file == null) {
            return;
        }
        try {
            SBdb ws = new SBdb(this.sbdb);
            ws.setImageLoader(this.sbdb.getImageLoader());
            if (group != null) {
                ws.fillTxGroup(this.sbdb, group.getID());
            } else if (groupSet != null) {
                ws.fillTxGroupSet(this.sbdb, groupSet.getID());
            } else {
                ws = new Workspace();
                ws.setImageLoader(this.sbdb.getImageLoader());
                final WorkspaceExportHelper exportHelper = new WorkspaceExportHelper(this.sbdb, ws);
                exportHelper.setRequestTaxonImageOption(new Runnable(){
                    final /* synthetic */ FrameTaxaDB this$0;
                    {
                        FrameTaxaDB frameTaxaDB = this$0;
                        Objects.requireNonNull(frameTaxaDB);
                        this.this$0 = frameTaxaDB;
                    }

                    @Override
                    public void run() {
                        int opt = JOptionPane.showConfirmDialog(this.this$0, FrameTaxaDB.EXPORT_IMAGE_QUESTION, "Export Type Images", 0);
                        exportHelper.setCopyTaxonTypeImages(opt == 0);
                    }
                });
                exportHelper.setRequestReferencesAndNotesOption(new Runnable(){
                    final /* synthetic */ FrameTaxaDB this$0;
                    {
                        FrameTaxaDB frameTaxaDB = this$0;
                        Objects.requireNonNull(frameTaxaDB);
                        this.this$0 = frameTaxaDB;
                    }

                    @Override
                    public void run() {
                        int opt = JOptionPane.showConfirmDialog(this.this$0, "Export references and notes?", "Export References", 0);
                        exportHelper.setCopyReferencesAndNotes(opt == 0);
                    }
                });
                exportHelper.fillTaxonList(list.stream().map(Taxon::getTaxonCopy).toList(), synSch);
            }
            SbugsIO.saveSBGfile(this.sbdb, null, ws, file, this, null, true);
        }
        catch (SBPermissionException pe) {
            JOptionPane.showMessageDialog(this, pe.getMessage(), this.getTitle(), 2);
        }
        catch (SQLException | SBException sql) {
            FrameJsbugs.showStackError("SQL Error", (Exception)sql, this.sbdb);
        }
        catch (IOException sbe) {
            StackError.showStackError((String)"Error writing file", (Throwable)sbe);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SBdb openZipArchive(File file) {
        SBdb sBdb;
        ZipFile zipFile = new ZipFile(file);
        try {
            int nBytes;
            String rootName = file.getName();
            rootName = rootName.substring(0, rootName.lastIndexOf(46));
            System.out.println("File root name: " + rootName);
            ZipEntry entry = null;
            String entryName = rootName + ".xml";
            Enumeration<? extends ZipEntry> en = zipFile.entries();
            while (en.hasMoreElements()) {
                ZipEntry e = en.nextElement();
                if (!e.getName().equalsIgnoreCase(entryName)) continue;
                entry = e;
                break;
            }
            if (entry == null) {
                String msg = "Zip file does not contain XML entry.\n(ensure that zip file contains an XML file of the same name)\nExpected: " + entryName + "\n\nContents: ";
                en = zipFile.entries();
                while (en.hasMoreElements()) {
                    ZipEntry e = en.nextElement();
                    msg = msg + e.getName() + "\n";
                }
                JOptionPane.showMessageDialog(this, msg, this.getTitle(), 2);
            }
            File tempXML = File.createTempFile("SBUGS" + rootName, ".xml");
            FileOutputStream fos = new FileOutputStream(tempXML);
            InputStream fis = zipFile.getInputStream(entry);
            byte[] bytes = new byte[Short.MAX_VALUE];
            while ((nBytes = fis.read(bytes, 0, bytes.length)) > 0) {
                fos.write(bytes, 0, nBytes);
            }
            fis.close();
            fos.close();
            System.out.println("Opening file: " + String.valueOf(tempXML));
            sBdb = this.openXMLfile(tempXML, zipFile);
        }
        catch (Exception ex) {
            SBdb sBdb2;
            try {
                StackError.showStackError((String)ex.getMessage(), (Throwable)ex);
                ex.printStackTrace();
                sBdb2 = null;
            }
            catch (Throwable throwable) {
                try {
                    zipFile.close();
                    throw throwable;
                }
                catch (Exception ex2) {
                    StackError.showStackError((String)ex2.getMessage(), (Throwable)ex2);
                    ex2.printStackTrace();
                    return null;
                }
            }
            zipFile.close();
            return sBdb2;
        }
        zipFile.close();
        return sBdb;
    }

    private void jMenuItemExportSetActionPerformed(ActionEvent evt) {
        TxGroupSet set = this.jPanelSets.getSelectedSet();
        if (set == null) {
            return;
        }
        this.export(null, set, null, -1);
    }

    private void jMenuItemImportSetActionPerformed(ActionEvent evt) {
        this.importFile(2);
    }

    private void jMenuItemImportGroupActionPerformed(ActionEvent evt) {
        this.importFile(1);
    }

    private void jMenuItemShowChartsActionPerformed(ActionEvent evt) {
        this.jPanelGroups.showLegacyCharts();
    }

    private void jMenuItemSetShowChartsActionPerformed(ActionEvent evt) {
        this.jPanelSets.showLegacyCharts();
    }

    private void jMenuItemShowNoChartsActionPerformed(ActionEvent evt) {
        try {
            List<TxGroup> groups = this.parent.getChartManager().getTxGroupsNotInCharts();
            if (groups.isEmpty()) {
                JOptionPane.showMessageDialog(this, "All groups are used in chart panels", "Groups not in charts", 1);
                return;
            }
            DialogList.displayListDialog(this, "Groups Not Associated with Charts", new UserPrefsHelper(this.sbdb), groups, null);
        }
        catch (RuntimeException | SQLException e) {
            SbugsExceptionHandler.showStackError(e, this);
        }
    }

    private void jMenuItemSelectTaxaFromWellActionPerformed(ActionEvent evt) {
        this.frameTaxa.searchWell();
    }

    private void jMenuItemMergeEventsActionPerformed(ActionEvent evt) {
        if (this.frameEvents == null) {
            JOptionPane.showMessageDialog(this, "Show the event dictionary to select events", this.getTitle(), 1);
            return;
        }
        this.frameEvents.merge();
    }

    private void jMenuItemEventDictActionPerformed(ActionEvent evt) {
        try {
            if (this.frameEvents == null) {
                this.frameEvents = new InternalFrameEventDict(this, this.sbdb);
                this.jDesktopPane.add(this.frameEvents);
                this.frameEvents.setVisible(true);
            } else {
                this.frameEvents.setVisible(true);
                this.frameEvents.setIcon(false);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error: " + e.getMessage(), this.getTitle(), 0);
            e.printStackTrace();
        }
    }

    private void jMenuItemShowEventUsageActionPerformed(ActionEvent evt) {
        if (this.frameEvents == null) {
            JOptionPane.showMessageDialog(this, "Show the event dictionary and select an event", this.getTitle(), 1);
            return;
        }
        this.frameEvents.eventUsage();
    }

    private void jMenuItemExportGroupTextActionPerformed(ActionEvent evt) {
        if ((this.sbdb.getUser().getPriv() & 0x4000) > 0) {
            JOptionPane.showMessageDialog(this, "You are not allowed to export data.", this.getTitle(), 2);
            return;
        }
        TxGroup group = this.jPanelGroups.getSelectedGroup();
        if (group == null) {
            JOptionPane.showMessageDialog(this, "No group selected", this.getTitle(), 2);
            return;
        }
        File setDir = null;
        try {
            setDir = new File(Lastval.getString(this.sbdb, "GRPTXTFILE"));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        JFileChooser jFileChooser1 = new JFileChooser();
        jFileChooser1.setCurrentDirectory(setDir);
        SbugsFileFilter filter = new SbugsFileFilter();
        filter.addExtension("txt");
        filter.setDescription("Text files");
        jFileChooser1.addChoosableFileFilter((FileFilter)filter);
        SimpleDateFormat df = new SimpleDateFormat("dd-MMM-yyyy");
        Date date = new Date();
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (0 == jFileChooser1.showSaveDialog(this)) {
            try {
                Object fileName = jFileChooser1.getSelectedFile().getPath();
                if (!((String)fileName).toLowerCase().endsWith(".txt")) {
                    fileName = (String)fileName + ".txt";
                }
                FileWriter out = new FileWriter((String)fileName);
                out.write("StrataBugs output: " + df.format(date) + "\r\n\r\n");
                out.write("Group name: " + group.getName() + "\r\n\r\n");
                Collection<Taxon> c = this.sbdb.getTxGroupTaxa(group);
                LinkedList<Taxon> list = new LinkedList<Taxon>(c);
                Taxon.sort(list, Taxon.SortOrder.SORT_CATEGORY);
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    String text = ((Taxon)it.next()).toString();
                    out.write(text + "\r\n");
                }
                out.close();
                if (JOptionPane.showConfirmDialog(this, "File '" + (String)fileName + "' written", "File Saved", 2) == 0) {
                    Lastval.putString(this.sbdb, "GRPTXTFILE", (String)fileName);
                    this.sbdb.commit();
                }
            }
            catch (IOException | SQLException ex) {
                SbugsExceptionHandler.showStackError(ex, this);
            }
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void jMenuItemSetShowGroupsActionPerformed(ActionEvent evt) {
        this.jPanelSets.showGroups();
    }

    private void jMenuItemSetAddActionPerformed(ActionEvent evt) {
        this.jPanelSets.addSet();
    }

    private void jMenuItemSearchCodeActionPerformed(ActionEvent evt) {
        this.frameTaxa.searchCode();
    }

    private void jMenuItemSaveListActionPerformed(ActionEvent evt) {
        String[] extensions = new String[]{"txt", "csv"};
        String[] descriptions = new String[]{"TAB delimited text files", "Commas Separated Values text files"};
        File file = FrameJsbugs.chooseFile(this.sbdb, this, "CSVFILE", "CSVFILE", extensions, descriptions, null);
        if (file != null) {
            try {
                char delim = '\t';
                Object fileName = file.getPath();
                if (!((String)fileName).toLowerCase().endsWith(".txt")) {
                    if (!((String)fileName).toLowerCase().endsWith(".csv")) {
                        fileName = (String)fileName + ".txt";
                    } else {
                        delim = ',';
                    }
                }
                Lastval.putString(this.sbdb, "CSVFILE", (String)fileName);
                this.sbdb.commit();
                this.frameTaxa.writeCSV(new File((String)fileName), delim);
                JOptionPane.showMessageDialog(this, "File '" + (String)fileName + "' written", this.getTitle(), 1);
            }
            catch (IOException | RuntimeException | SQLException ex) {
                SbugsExceptionHandler.showStackError(ex, this);
            }
        }
    }

    private void jMenuItemFindSimilarActionPerformed(ActionEvent evt) {
        this.frameTaxa.findSimilar();
    }

    private void jMenuItemGroupLogSheetActionPerformed(ActionEvent evt) {
        TxGroup group = this.jPanelGroups.getSelectedGroup();
        if (group == null) {
            JOptionPane.showMessageDialog(this, "Select a group", this.getTitle(), 2);
            return;
        }
        LinkedList<TxGroup> groups = new LinkedList<TxGroup>();
        groups.add(group);
        this.printLoggingSheetCodes(groups, "Group: " + group.getName());
    }

    private void printLoggingSheetCodes(LinkedList<TxGroup> groups, String sheetName) {
        DialogTaxonCodePrint dialog = new DialogTaxonCodePrint(this, true, this.sbdb, groups);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.isOK()) {
            PrinterJob job = PrinterJob.getPrinterJob();
            if (!job.printDialog()) {
                return;
            }
            PageFormat pf = job.defaultPage();
            LinkedList<LoggingSheetCodes> logSheets = new LinkedList<LoggingSheetCodes>();
            try {
                logSheets.add(new LoggingSheetCodes(groups, this.sbdb, dialog.model.dict, dialog.nEmpty, sheetName));
            }
            catch (Exception e) {
                StackError.showStackError((String)"Error creating logging sheet", (Throwable)e);
            }
            PrintJPanel printPanel = new PrintJPanel(logSheets, pf);
            DialogPrintPreview ppdialog = new DialogPrintPreview(this, true, logSheets, printPanel, job, pf, this.sbdb);
            ppdialog.setVisible(true);
            if (ppdialog.isPrint) {
                job.setPrintable(printPanel, ppdialog.pf);
            }
            try {
                job.print();
            }
            catch (Exception exp) {
                JOptionPane.showMessageDialog(this, "Problem printing");
                exp.printStackTrace();
            }
        }
    }

    private void jMenuItemAdvancedSearchDictActionPerformed(ActionEvent evt) {
        this.frameTaxa.searchAdvDict();
    }

    private void jMenuItemSetPrintLoggingSheetActionPerformed(ActionEvent evt) {
        TxGroupSet set = this.jPanelSets.getSelectedSet();
        if (set == null) {
            return;
        }
        try {
            this.printLoggingSheetCodes((LinkedList)set.getGroups(), "Set: " + set.getName());
        }
        catch (Exception e) {
            StackError.showStackError((String)"Error getting groups from set", (Throwable)e);
        }
    }

    private void jMenuItemSIPMCodesActionPerformed(ActionEvent evt) {
        try {
            DialogNumericDicts dialog = new DialogNumericDicts((Frame)this, true, this.sbdb);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }
        catch (SQLException ex) {
            SbugsExceptionHandler.showDialogStackError(ex, this);
        }
    }

    private void jMenuItemCmpStdNewActionPerformed(ActionEvent evt) {
        try {
            InternalFrameCmpStd frame = new InternalFrameCmpStd(null, this.sbdb);
            this.jDesktopPane.add(frame);
            frame.setVisible(true);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void windowClosing(WindowEvent evt) {
        if (!this.checkComposites()) {
            return;
        }
        this.dispose();
    }

    private void jMenuItemTaxonWebLookupActionPerformed(ActionEvent evt) {
        this.frameTaxa.webLookup();
    }

    private void jMenuItemTaxonSearchDBActionPerformed(ActionEvent evt) {
        this.frameTaxa.searchFromList();
    }

    private void jButtonOpenTemplateActionPerformed(ActionEvent evt) {
        if (this.frameChart != null) {
            if (!this.frameChart.isVisible()) {
                this.frameChart.setVisible(true);
            } else {
                this.frameChart.openTemplate();
            }
            return;
        }
        AbstractAction lastTabClosedAction = new AbstractAction(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.frameChart.dispose();
                this.this$0.frameChart = null;
            }
        };
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.frameChart = InternalFrameChart.createLoadedInstance("TXDB", this, this.sbdb, this.parent.getChartManager(), "Scheme Chart Blocks", lastTabClosedAction);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
        if (this.frameChart == null) {
            DialogChartTemplates dialog = new DialogChartTemplates(this, true, this.sbdb, this.parent.getChartManager(), BlockType.SCHEME, null, null);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.selection != null && dialog.selection.size() == 1 && dialog.selection.get(0) instanceof BlockTemplate) {
                BlockTemplate templ = (BlockTemplate)dialog.selection.get(0);
                this.frameChart = new InternalFrameChart(this, this.sbdb, this.parent.getChartManager(), "Scheme Chart Blocks", lastTabClosedAction, "TXDB");
                this.frameChart.addBlockTemplateTab(templ, null, null, true, null, null, 0);
            }
        }
        if (this.frameChart == null) {
            return;
        }
        this.frameChart.addInternalFrameListener(new InternalFrameAdapter(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void internalFrameClosing(InternalFrameEvent e) {
                System.out.println("internal frame closing");
                this.this$0.frameChart.setVisible(false);
            }
        });
        int width = this.jDesktopPane.getWidth() / 2;
        this.frameChart.reshape(this.jDesktopPane.getWidth() - width, this.jDesktopPane.getY(), width, this.jDesktopPane.getHeight());
        this.jDesktopPane.add(this.frameChart);
        this.frameChart.setVisible(true);
    }

    private void jCheckBoxMenuItemViewGlobalItemStateChanged(ItemEvent evt) {
        this.projectChange();
    }

    private void jMenuItemGroupUsagesActionPerformed(ActionEvent evt) {
        this.jPanelGroups.showChartUsages();
    }

    private void jMenuItemSetUsagesActionPerformed(ActionEvent evt) {
        this.jPanelSets.showChartUsages();
    }

    private void jMenuItemTaxonURLActionPerformed(ActionEvent evt) {
        this.frameTaxa.openUrl();
    }

    private void jMenuItemGroupPermissionsActionPerformed(ActionEvent evt) {
        this.jPanelGroups.permissions();
    }

    private void jMenuItemSetsPermissionsActionPerformed(ActionEvent evt) {
        this.jPanelSets.permissions();
    }

    private void jMenuItemChartsActionPerformed(ActionEvent evt) {
        this.jButtonOpenTemplateActionPerformed(evt);
    }

    private void jMenuItemGeneraActionPerformed(ActionEvent evt) {
        if (this.frameGenera == null) {
            this.frameGenera = new InternalFrameGenera(this, this.sbdb);
            this.jDesktopPane.add(this.frameGenera);
            this.frameGenera.setVisible(true);
        } else {
            this.frameGenera.setVisible(true);
            this.frameGenera.moveToFront();
            try {
                this.frameGenera.setIcon(false);
            }
            catch (PropertyVetoException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jMenuItemDeleteNonOccEventsActionPerformed(ActionEvent evt) {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            List<SBEvent> list = this.sbdb.getSBEvents(true);
            int nDeletions = 0;
            for (SBEvent event : list) {
                if (!event.getCmpstdOccs().isEmpty() || !event.getWellOccs().isEmpty() || event.getNcorrOccs() != 0) continue;
                ++nDeletions;
            }
            if (nDeletions > 0) {
                int opt = JOptionPane.showConfirmDialog(this, "This will delete: " + nDeletions + " unused events from the dictionary.\n(Events which are not in wells, Composite Standards or correlations). Continue?", this.getTitle(), 0);
                if (opt == 1) {
                    return;
                }
                for (SBEvent event : list) {
                    if (!event.getCmpstdOccs().isEmpty() || !event.getWellOccs().isEmpty() || event.getNcorrOccs() != 0) continue;
                    this.sbdb.deleteSBEvent(event);
                    this.parent.getChartManager().unloadEventCorrelationLines(event);
                }
                this.sbdb.commit();
                JOptionPane.showMessageDialog(this, nDeletions + " Events deleted.", this.getTitle(), 1);
            } else {
                JOptionPane.showMessageDialog(this, "No events to delete", this.getTitle(), 1);
            }
        }
        catch (SQLException | SBException | SBPermissionException ex) {
            this.sbdb.doRollback();
            FrameJsbugs.showStackError("Error deleting events", (Exception)ex, this.sbdb);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jCheckBoxMenuItemShowProjectColumnActionPerformed(ActionEvent evt) {
        if (this.jCheckBoxMenuItemShowProjectColumn.isSelected()) {
            this.jPanelGroups.showProjectColumn();
        } else {
            this.jPanelGroups.hideProjectColumn();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jMenuItemGenerateCodesActionPerformed(ActionEvent evt) {
        if ((this.sbdb.getUser().getPriv() & 0x40) <= 0) {
            JOptionPane.showMessageDialog(this, "You must be a super user to do this.", this.getTitle(), 2);
            return;
        }
        if (JOptionPane.showConfirmDialog(this, "This option will generate a unique code attribute for every taxon which does not currently have a code.\nProceed?", this.getTitle(), 0) == 1) {
            return;
        }
        boolean limitToEventTaxa = false;
        if (JOptionPane.showConfirmDialog(this, "Do you want to restrict it to taxa linked to events?", this.getTitle(), 0) == 0) {
            limitToEventTaxa = true;
        }
        boolean updateEventNames = false;
        if (JOptionPane.showConfirmDialog(this, "Do you want to update existing event NAMES with the new codes?", this.getTitle(), 0) == 0) {
            updateEventNames = true;
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            System.out.println("Loading taxa...");
            this.sbdb.loadTaxa();
            int nUpdated = 0;
            int nEventsUpdated = 0;
            for (Taxon taxon : this.sbdb.getTaxa()) {
                if (taxon.getAlphaCode() != null && !taxon.getAlphaCode().isEmpty()) continue;
                List<SBEvent> events = this.sbdb.getSBEvents(taxon.getSpecID());
                if (limitToEventTaxa && events.isEmpty()) continue;
                int uqGen = 3;
                int uqSpe = 3;
                boolean codeUnique = false;
                Object newCode = null;
                block6: while (!codeUnique) {
                    newCode = "";
                    if (taxon.getGenus().getQ1() != null) {
                        newCode = taxon.getGenus().getQ1().toString();
                    }
                    newCode = (String)newCode + taxon.getGenusName().substring(0, Math.min(uqGen, taxon.getGenusName().length()));
                    if (taxon.getGenus().getQ2() != null) {
                        newCode = String.valueOf(taxon.getGenus().getQ2()) + (String)newCode;
                    }
                    if (taxon.getGenus().getSubGenus() != null && !taxon.getGenus().getSubGenus().isEmpty()) {
                        if (taxon.getGenus().getQ3() != null) {
                            newCode = String.valueOf(taxon.getGenus().getQ3()) + (String)newCode;
                        }
                        newCode = (String)newCode + taxon.getGenus().getSubGenus().substring(0, Math.min(uqGen, taxon.getGenus().getSubGenus().length()));
                        if (taxon.getGenus().getQ4() != null) {
                            newCode = String.valueOf(taxon.getGenus().getQ4()) + (String)newCode;
                        }
                    }
                    newCode = (String)newCode + " ";
                    if (taxon.getQ1() != null) {
                        newCode = (String)newCode + String.valueOf(taxon.getQ1());
                    }
                    newCode = (String)newCode + taxon.getSpecies().substring(0, Math.min(uqSpe, taxon.getSpecies().length()));
                    if (taxon.getQ2() != null) {
                        newCode = (String)newCode + String.valueOf(taxon.getQ2());
                    }
                    if (taxon.getSubSpecies() != null && !taxon.getSubSpecies().isEmpty()) {
                        if (taxon.getQ3() != null) {
                            newCode = (String)newCode + String.valueOf(taxon.getQ3());
                        }
                        newCode = (String)newCode + taxon.getSubSpecies().substring(0, Math.min(uqSpe, taxon.getSubSpecies().length()));
                        if (taxon.getQ4() != null) {
                            newCode = (String)newCode + String.valueOf(taxon.getQ4());
                        }
                    }
                    if (((String)newCode).length() > 30) {
                        newCode = null;
                        break;
                    }
                    codeUnique = true;
                    for (Taxon t : this.sbdb.getTaxa()) {
                        if (t == taxon || !((String)newCode).equalsIgnoreCase(t.getAlphaCode())) continue;
                        if (uqGen <= uqSpe && uqGen < taxon.getGenusName().length()) {
                            ++uqGen;
                        } else if (uqSpe < taxon.getSpecies().length()) {
                            ++uqSpe;
                        } else {
                            newCode = null;
                            continue block6;
                        }
                        codeUnique = false;
                        continue block6;
                    }
                }
                if (newCode == null) continue;
                System.out.println("Setting code: " + (String)newCode + " for taxon: " + taxon.toString());
                taxon.setAlphaCode((String)newCode);
                ++nUpdated;
                if (!updateEventNames) continue;
                for (SBEvent event : events) {
                    if (!event.getName().equals(taxon.toString(false, false, false))) continue;
                    System.out.println("Updating event name: " + event.toString());
                    ++nEventsUpdated;
                    this.sbdb.updateSBEventName(event, (String)newCode);
                }
            }
            if (nUpdated > 0) {
                if (JOptionPane.showConfirmDialog(this, "Updated " + nUpdated + " taxon codes.\n" + (String)(nEventsUpdated > 0 ? "Updated " + nEventsUpdated + " event names.\n" : "") + "Commit?", this.getTitle(), 0) == 0) {
                    this.sbdb.commit();
                } else {
                    this.sbdb.doRollback();
                    JOptionPane.showMessageDialog(this, "You must close StrataBugs and reopen to refresh taxon codes", this.getTitle(), 1);
                }
            }
        }
        catch (SQLException | SBException | SBPermissionException e) {
            this.sbdb.doRollback();
            FrameJsbugs.showStackError(e.getMessage(), (Exception)e, this.sbdb);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jMenuItemLinkedEventsActionPerformed(ActionEvent evt) {
        this.frameTaxa.openEvents();
    }

    private void jMenuItemImagesActionPerformed(ActionEvent evt) {
        this.frameTaxa.showImages();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jMenuItemExportTaxaActionPerformed(ActionEvent evt) {
        if (this.frameTaxa != null && this.frameTaxa.modelTaxa != null && !this.frameTaxa.modelTaxa.taxonList.isEmpty()) {
            int synSch = this.frameTaxa.modelTaxa.getSynSchemeID();
            boolean exportSynonymy = false;
            try {
                List<Taxon> list = this.frameTaxa.getAllTaxa();
                for (Taxon taxon : list) {
                    if (taxon.getPreferred(synSch) == null) continue;
                    exportSynonymy = true;
                    break;
                }
                if (JOptionPane.showConfirmDialog(this, "Export synonymy?", this.getTitle(), 0) == 1) {
                    exportSynonymy = false;
                }
                this.export(null, null, list, exportSynonymy ? synSch : -1);
            }
            catch (RuntimeException | SQLException | SBException e) {
                SbugsExceptionHandler.showStackError(e);
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
        } else {
            JOptionPane.showMessageDialog(this, "No taxa selected for export. Select the taxa into the taxon window first", this.getTitle(), 1);
        }
    }

    private void jMenuItemImportTaxaActionPerformed(ActionEvent evt) {
        this.importFile(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jMenuItemCmpStdStatsActionPerformed(ActionEvent evt) {
        try {
            DialogSelectCmpStd dialog = new DialogSelectCmpStd((Frame)this, true, this.sbdb, true);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.selection == null) {
                return;
            }
            CompositeStandard cmpStd = dialog.selection;
            Project project = null;
            DialogSelectProject dialogProject = new DialogSelectProject(this, true, this.sbdb, false, null);
            dialogProject.setLocationRelativeTo(this);
            dialogProject.setVisible(true);
            if (dialogProject.getSelection() == null) {
                return;
            }
            project = dialogProject.getSelection();
            DialogSelectVersion dialogVersion = new DialogSelectVersion((Frame)this, true, this.sbdb, new LinkedList<Well>());
            dialogVersion.setLocationRelativeTo(this);
            dialogVersion.setVisible(true);
            if (dialogVersion.selection == null || dialogVersion.selection.isEmpty()) {
                return;
            }
            InterpHdr interp = dialogVersion.selection.get(0);
            File outputFile = FileChooserUtils.saveAsGridDataDialog((Component)this, null);
            if (outputFile == null) {
                return;
            }
            GridWriter gw = new GridWriter();
            if (FilePathUtils.isFileExtension((String)outputFile.getPath(), (String[])new String[]{"xls", "xlsx"})) {
                gw.getXLSOptions().setSheetName("Calculated Ages");
                gw.getXLSOptions().setAuthorName(this.sbdb.getUser().getName());
            } else {
                CSVExportOptions options = DialogCSVExporOptions.showNewCSVOptionsDialog(this, (Component)this);
                if (options == null) {
                    return;
                }
                gw.setCSVOptions(options);
            }
            if (!FileOverwriteCheck.checkForGridFileOverwriting(this, (Component)this, outputFile, gw)) {
                return;
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            GridSheet gb = new GridSheet();
            gb.setFormat(new CellFormat().setBold(true));
            gb.append(new Object[]{"Project", "Version", "Type", "Event", "Error minus", "Cmp. Std. Age", "Error plus", "Project Mean Age", "Project Median Age", "Number of wells with event and depth/age curve in version"});
            gb.clearFormat();
            cmpStd.loadEvents();
            HashMap<Integer, List<WellOccQueryResult>> eventOccs = new HashMap<Integer, List<WellOccQueryResult>>();
            for (CompositeStandardEvent event : cmpStd.getEventsByCSU(true, true)) {
                if (eventOccs.get(event.getEvID()) != null) continue;
                eventOccs.put(event.getEvID(), event.getEvent().getWellOccs(interp.getInterpID(), project.getID()));
            }
            for (CompositeStandardEvent event : cmpStd.getEventsByCSU(true, true)) {
                gb.addRow();
                double[] stats = SBEvent.getAgeStats(this.sbdb, event.getType(), (List)eventOccs.get(event.getEvID()));
                gb.append(new Object[]{project.getName(), interp.getDescription(), event.getType().toString(), event.getName(), event.getErrMinus() != null ? Double.valueOf(cmpStd.getAge(event.getErrMinus())) : null, cmpStd.getAge(event.getCSU()), event.getErrPlus() != null ? Double.valueOf(cmpStd.getAge(event.getErrPlus())) : null});
                if (stats[0] > 0.0 && stats[1] > 0.0) {
                    gb.append(new Object[]{(double)Math.round(stats[0] * 1000.0) / 1000.0, (double)Math.round(stats[1] * 1000.0) / 1000.0, Math.round(stats[2])});
                    continue;
                }
                gb.append(new Object[]{null, null, 0});
            }
            gw.write(outputFile, gb.getObjectArray());
            JOptionPane.showMessageDialog(this, "File " + outputFile.getName() + " written", this.getTitle(), 2);
        }
        catch (IOException | SQLException | SBException sql) {
            FrameJsbugs.showStackError("Error", (Exception)sql, this.sbdb);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jMenuItemPrintImagesActionPerformed(ActionEvent evt) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        SwingUtilities.invokeLater(new Runnable(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void run() {
                this.this$0.frameTaxa.showImageGalleryForSelectedTaxa();
                this.this$0.setCursor(Cursor.getDefaultCursor());
            }
        });
    }

    private void jMenuItemSelectTaxaInSlideStoreActionPerformed(ActionEvent evt) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        SwingUtilities.invokeLater(new Runnable(this){
            final /* synthetic */ FrameTaxaDB this$0;
            {
                FrameTaxaDB frameTaxaDB = this$0;
                Objects.requireNonNull(frameTaxaDB);
                this.this$0 = frameTaxaDB;
            }

            @Override
            public void run() {
                this.this$0.frameTaxa.searchForSlideStoreTaxa();
                this.this$0.setCursor(Cursor.getDefaultCursor());
            }
        });
    }

    private void jMenuItemFileSlideStoreActionPerformed(ActionEvent evt) {
        try {
            DialogCabinet dialog = new DialogCabinet((Window)this, this.sbdb);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }
        catch (RuntimeException e) {
            SbugsExceptionHandler.showDialogStackError(e, this);
        }
    }

    private void jMenuItemSlideStoreActionPerformed(ActionEvent evt) {
        this.frameTaxa.openSlideStore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importFile(int importType) {
        String importFileTypes = switch (importType) {
            case 1 -> "Group files";
            case 2 -> "Group Set files";
            default -> "Taxon dictionary/synonymy files";
        };
        JFileChooser jFileChooserCommon = new JFileChooser();
        FileNameExtensionFilter filter = new FileNameExtensionFilter(importFileTypes + " (sbg, xml, zip, dex, txt)", "sbg", "xml", "zip", "dex", "txt");
        jFileChooserCommon.setFileFilter(filter);
        jFileChooserCommon.setAcceptAllFileFilterUsed(false);
        File setDir = null;
        try {
            setDir = new File(Lastval.getString(this.sbdb, "JZIPFILE"));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (setDir == null || setDir.getParent() == null || !setDir.getParentFile().exists()) {
            setDir = new File(".");
        }
        try {
            jFileChooserCommon.setCurrentDirectory(setDir);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (0 == jFileChooserCommon.showOpenDialog(this)) {
            File file = jFileChooserCommon.getSelectedFile();
            try {
                DialogMatchGenera dialogMatchGenera;
                Lastval.putString(this.sbdb, "JZIPFILE", file.getPath());
                this.sbdb.commit();
                String fileName = file.getPath();
                String fileType = fileName.substring(fileName.lastIndexOf(46) + 1).toLowerCase().trim();
                SBdb ws = null;
                switch (fileType) {
                    case "dex": {
                        ws = this.openDEXfile(file);
                        break;
                    }
                    case "xml": {
                        ws = this.openXMLfile(file, null);
                        break;
                    }
                    case "zip": 
                    case "sbg": {
                        ws = this.openZipArchive(file);
                        break;
                    }
                    case "txt": {
                        ws = this.openTextfile(file);
                    }
                }
                if (ws == null) {
                    return;
                }
                if (importType == 2 && (ws.getTxGroupSets() == null || ws.getTxGroupSets().isEmpty())) {
                    JOptionPane.showMessageDialog(this, "No group sets found in import file", this.getTitle(), 1);
                    return;
                }
                if (importType == 1 && (ws.getTxGroups() == null || ws.getTxGroups().isEmpty())) {
                    JOptionPane.showMessageDialog(this, "No groups found in import file", this.getTitle(), 1);
                    return;
                }
                if (ws.getTxGroups() != null && (dialogMatchGenera = new DialogMatchGenera(this, true, ws, this.sbdb, true)).hasGenera()) {
                    SB.centreDialog((Dialog)((Object)dialogMatchGenera));
                    dialogMatchGenera.setVisible(true);
                    if (!dialogMatchGenera.isOK()) {
                        return;
                    }
                }
                DialogMatchTaxa dialogMatchTaxa = new DialogMatchTaxa(this, true, ws, null, this.sbdb, true);
                SB.centreDialog((Dialog)dialogMatchTaxa);
                dialogMatchTaxa.setVisible(true);
                if (!dialogMatchTaxa.isOK()) {
                    return;
                }
                if (importType == 2) {
                    TxGroupSet set = ws.getTxGroupSets().iterator().next();
                    boolean inWizard = true;
                    for (TxGroup group : set.getGroups()) {
                        DialogMatchTxGroup dialog = new DialogMatchTxGroup(this, true, group, this.sbdb, this.getProjID(), inWizard);
                        SB.centreDialog((Dialog)((Object)dialog));
                        dialog.setVisible(true);
                        if (!dialog.isOK()) {
                            inWizard = false;
                        }
                        if (inWizard) continue;
                        return;
                    }
                    DialogMatchTxGroupSet dialog = new DialogMatchTxGroupSet(this, true, false, ws, this.sbdb, set, this.getProjID());
                    SB.centreDialog((Dialog)((Object)dialog));
                    dialog.setVisible(true);
                    if (set.getLink() != null) {
                        this.sbdb.notifyObservers(set.getLink());
                    }
                } else if (importType == 1) {
                    TxGroup group;
                    LinkedList<TxGroup> groups = new LinkedList<TxGroup>(ws.getTxGroups());
                    if (groups.size() > 1) {
                        DialogList<TxGroup> dialogList = new DialogList<TxGroup>(this, true, "Select Group", null, groups, true, false);
                        SB.centreDialog(dialogList);
                        dialogList.setVisible(true);
                        if (dialogList.getSelection() == null) {
                            return;
                        }
                        group = dialogList.getSelection();
                    } else {
                        group = (TxGroup)groups.get(0);
                    }
                    DialogMatchTxGroup dialog = new DialogMatchTxGroup(this, true, group, this.sbdb, this.getProjID(), false);
                    SB.centreDialog((Dialog)((Object)dialog));
                    dialog.setVisible(true);
                } else if (!ws.getSynSchemes().isEmpty()) {
                    for (SynonymScheme synSch : ws.getSynSchemes()) {
                        int opt;
                        if (synSch.getSynonyms().isEmpty() || (opt = JOptionPane.showConfirmDialog(this, "Import synonym scheme: " + synSch.getName() + "?", this.getTitle(), 0, 3)) != 0) continue;
                        int nUpdated = this.sbdb.addWsSynonymScheme(ws, synSch);
                        if (nUpdated > 0) {
                            JOptionPane.showMessageDialog(this, "Number of synonyms added: " + nUpdated, this.getTitle(), 1);
                        } else {
                            JOptionPane.showMessageDialog(this, "No synonyms added - all synonyms were already in the database.", this.getTitle(), 1);
                        }
                        this.frameTaxa.setSynSchemeCombo();
                    }
                }
                this.sbdb.commit();
            }
            catch (SQLException | InvalidFieldException | SBException | SBPermissionException ex) {
                this.sbdb.doRollback();
                FrameJsbugs.showStackError("Error importing file", (Exception)ex, this.sbdb);
            }
            catch (RuntimeException e) {
                StackError.showStackError((String)"", (Throwable)e);
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SBdb openXMLfile(File xmlFile, ZipFile zipFile) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            Document xmlDocument = SbugsMLdocument.getXmlDocument(xmlFile);
            Object fileName = "";
            if (zipFile != null) {
                String temp = zipFile.getName().substring(zipFile.getName().lastIndexOf(File.separatorChar));
                fileName = temp.length() > 0 ? "..." + temp : zipFile.getName();
            } else if (xmlFile != null) {
                fileName = xmlFile.getName();
            }
            LinkedList<SBException> exceptions = new LinkedList<SBException>();
            Logger logger = Logger.getLogger(FrameTaxaDB.class.getName() + " XML File Read");
            SBdb ws = new SBdb(this.sbdb);
            ws.setImageLoader(new ZipFileImageLoader(zipFile.getName()));
            ws.parseXMLDocument(xmlDocument, new HashSet<Integer>(), zipFile, (String)fileName, 0, exceptions);
            if (!exceptions.isEmpty()) {
                Object msg = "The following errors were found while reading the file ...";
                int exCount = 0;
                for (SBException sb : exceptions) {
                    if (++exCount < 20) {
                        msg = (String)msg + "\n" + sb.getMessage();
                    }
                    logger.log(Level.WARNING, sb.getMessage(), sb);
                }
                JOptionPane.showMessageDialog(this, msg, this.getTitle(), 2);
            }
            System.out.println(String.valueOf(xmlFile) + " is well-formed and valid. Contains: " + xmlDocument.getContentSize() + " elements.");
            Lastval.putString(this.sbdb, "WINXMLFILE", "UNXXMLFILE", xmlFile.getPath());
            this.sbdb.commit();
            SBdb sBdb = ws;
            return sBdb;
        }
        catch (JDOMException e) {
            JOptionPane.showMessageDialog(this, String.valueOf(xmlFile) + " is not well-formed or invalid.\n" + e.getMessage());
            e.printStackTrace();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "Could not check " + String.valueOf(xmlFile) + ".\n" + e.getMessage());
        }
        catch (OutOfMemoryError bounded) {
            Runtime.getRuntime().gc();
            JOptionPane.showMessageDialog(this, "Cannot read file: Memory limit for application exceeded. Total available: " + Runtime.getRuntime().maxMemory() / 1024000L + "MB\nContact StrataData for workaround or reduce size of import file");
        }
        catch (SAXParseException ex) {
            JOptionPane.showMessageDialog(this, "Error during XML parsing: " + ex.getMessage() + "\nCheck that file is a Stratabugs XML file, or send to StrataData for advice.", this.getTitle(), 0);
            ex.printStackTrace();
        }
        catch (Exception ex) {
            StackError.showStackError((String)"Error during file read.", (Throwable)ex);
            ex.printStackTrace();
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SBdb openDEXfile(File dexFile) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            SBdb ws = new SBdb(this.sbdb);
            HashSet dataTypes = new HashSet();
            DEXFile dexReader = new DEXFile(ws, this.sbdb.getUser(), dexFile.getPath(), dataTypes, null, 0);
            SBdb sBdb = ws;
            return sBdb;
        }
        catch (OutOfMemoryError bounded) {
            Runtime.getRuntime().gc();
            JOptionPane.showMessageDialog(this, "Cannot read file: Memory limit for application exceeded. Total available: " + Runtime.getRuntime().maxMemory() / 1024000L + "MB\nContact StrataData for workaround or reduce size of import file");
        }
        catch (Exception ex) {
            StackError.showStackError((String)"Error during file read.", (Throwable)ex);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SBdb openTextfile(File textFile) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            SBdb ws = new SBdb(this.sbdb);
            ws.parseTaxonList(textFile);
            SBdb sBdb = ws;
            return sBdb;
        }
        catch (IOException ioe) {
            StackError.showStackError((String)"Error reading in taxa list file", (Throwable)ioe);
        }
        catch (SQLException | SBException | SBPermissionException e) {
            StackError.showStackError((String)"SQLException parsing taxon list", (Throwable)e);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
        return null;
    }

    public int getSynSchID() {
        if (this.frameTaxa != null && this.frameTaxa.modelTaxa != null) {
            return this.frameTaxa.modelTaxa.getSynSchemeID();
        }
        return 0;
    }
}

