/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.taxon.Genus;
import java.awt.Color;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JTable;
import jsbugs.TableModelSB;
import jsbugs.table.ColourRenderer;
import model3.SBdb;

class GenusTableModel
extends TableModelSB {
    private static final String[] columnTitles = new String[]{"Category", "Genus", "Name", "Colour", "No. Species"};
    private static final int[] defaultColumnWidths = new int[]{40, 60, 60, 20, 30};
    final List<GenusRow> genusList = new LinkedList<GenusRow>();
    static final int COL_CAT = 0;
    static final int COL_GENUS = 1;
    static final int COL_NAME = 2;
    static final int COL_COLOUR = 3;
    static final int COL_NSPECIES = 4;
    private final Consumer<Genus> colourUpdater;

    public GenusTableModel(Consumer<Genus> colourUpdater) {
        this.colourUpdater = colourUpdater;
    }

    @Override
    public int getRowCount() {
        return this.genusList.size();
    }

    @Override
    public int getColumnCount() {
        return columnTitles.length;
    }

    @Override
    public Object getValueAt(int row, int col) {
        GenusRow gRow = this.genusList.get(row);
        return switch (col) {
            case 0 -> gRow.genus.getCategory().getMnemonic();
            case 1 -> gRow.genus.getGenusName();
            case 2 -> gRow.genus.toString();
            case 3 -> gRow.genus.getColour();
            case 4 -> {
                int n = gRow.nTaxa;
                if (n > 0) {
                    yield n;
                }
                yield null;
            }
            default -> null;
        };
    }

    @Override
    public Class<?> getColumnClass(int col) {
        return switch (col) {
            case 4 -> Integer.class;
            case 3 -> Color.class;
            default -> String.class;
        };
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 3 && this.colourUpdater != null;
    }

    @Override
    public void setValueAt(Object obj, int row, int col) {
        if (col != 3 || this.colourUpdater == null || !(obj instanceof Color)) {
            return;
        }
        Color colour = (Color)obj;
        Genus existing = this.genusList.get((int)row).genus;
        Genus updated = new Genus(existing.getGenID());
        Genus.copyFields((Genus)updated, (Genus)existing);
        updated.setColour(colour);
        this.colourUpdater.accept(updated);
    }

    public boolean addGenus(Genus genus, int nTaxa) {
        if (this.genusList.stream().map(GenusRow::genus).anyMatch(g -> g.getGenID() == genus.getGenID())) {
            return false;
        }
        this.genusList.add(new GenusRow(genus, nTaxa));
        return true;
    }

    @Override
    public String getPrefString() {
        return "TMGENUS";
    }

    @Override
    public String getPrefOrderString() {
        return "TOGENUS";
    }

    @Override
    public String getAutoResizeString() {
        return "TARGENUS";
    }

    @Override
    public int[] getDefaultColumnWidths() {
        return defaultColumnWidths;
    }

    @Override
    public String[] getColumnTitles() {
        return columnTitles;
    }

    @Override
    public void setupTable(JTable table, SBdb sbdb) {
        this.init(table, sbdb);
        table.setDefaultRenderer(Color.class, new ColourRenderer(true));
    }

    Genus getGenus(int index) {
        return this.genusList.get((int)index).genus;
    }

    List<Genus> getGenera() {
        return this.genusList.stream().map(GenusRow::genus).toList();
    }

    void remove(List<Integer> toRemove) {
        for (Integer genID : toRemove) {
            this.genusList.stream().filter(genusRow -> genusRow.genus.getGenID() == genID.intValue()).findFirst().ifPresent(this.genusList::remove);
        }
    }

    void updateNTaxa(Genus genus, int nTaxa) {
        for (int i = 0; i < this.genusList.size(); ++i) {
            GenusRow row = this.genusList.get(i);
            if (!row.genus.equals((Object)genus)) continue;
            if (row.nTaxa != nTaxa) {
                this.genusList.set(i, new GenusRow(genus, nTaxa));
            }
            return;
        }
    }

    void updateGenus(Genus updatedGenus) {
        this.genusList.stream().filter(genusRow -> genusRow.genus.equals((Object)updatedGenus)).findFirst().ifPresent(genusRow -> {
            this.genusList.set(this.genusList.indexOf(genusRow), new GenusRow(updatedGenus, genusRow.nTaxa));
            this.fireTableDataChanged();
        });
    }

    void clear() {
        this.genusList.clear();
    }

    record GenusRow(Genus genus, int nTaxa) implements Comparable<GenusRow>
    {
        @Override
        public int compareTo(GenusRow o) {
            return this.genus.compareTo(o.genus);
        }
    }
}

