/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.well.analysis.Situation;
import com.stratadata.util.depth.DepthUnits;
import com.stratadata.util.ui.SBDialog;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;
import jsbchart.block.BlockProperties;
import jsbchart.block.BlockType;
import jsbchart.block.ChartBlock;
import jsbchart.block.ChartBlockBase;
import jsbchart.block.WellBlock;
import jsbchart.core.Chart;
import jsbchart.core.ChartTemplate;
import jsbchart.panel.ChartPanel;
import jsbchart.panel.PanelBiocoms;
import jsbchart.panel.PanelEnv;
import jsbchart.panel.PanelEvents;
import jsbchart.panel.PanelIntLith;
import jsbchart.panel.PanelSQPicks;
import jsbchart.panel.PanelSampleLithology;
import jsbchart.panel.PanelTaxon;
import jsbchart.panel.PanelTaxonGroup;
import jsbchart.panel.PanelWellDepthAge;
import jsbchart.panel.PanelWellVS;
import jsbchart.panel.PanelZoneBoundary;
import jsbchart.panel.PanelZones;
import jsbchart.panel.SBPanel;
import jsbugs.ChartJPanel;
import jsbugs.DialogBiocom;
import jsbugs.DialogEnv;
import jsbugs.DialogInterval;
import jsbugs.DialogIntervalComment;
import jsbugs.DialogLithPalette;
import jsbugs.DialogOccurrence;
import jsbugs.DialogSQPick;
import jsbugs.DialogSampleLithology;
import jsbugs.DialogWellEvent;
import jsbugs.JPanelCharts;
import jsbugs.LithologyTransferHandler;
import jsbugs.chart.component.SbugsUndoManager;
import jsbugs.uiutil.CursorFactory;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.Biocom;
import model3.IGDIntervalEnv;
import model3.IGDIntervalZone;
import model3.Intcom;
import model3.Lastval;
import model3.Lithology;
import model3.SQPick;
import model3.Sample;
import model3.Taxon;
import model3.TaxonOcc;
import model3.WellEvent;
import model3.WellInterp;
import model3.wellinterp.InterpEdit;
import util.DepthUtils;
import util.InvalidFieldException;
import util.SB;
import util.SBException;
import util.SBPermissionException;
import util.SbugsCompoundEdit;

public class InteractiveChartJPanel
extends ChartJPanel {
    final JPanelCharts parent;
    private Sample ZoneBndOrigin = null;
    private SBPanel dragPanelOrigin = null;
    private Double depthBndOrigin = null;
    private Float lithBndOriginDraw = null;
    private Double lithBndOrigin = null;
    private static final Double LITH_BND_DRAG = 0.0;
    private Point2D.Float lastDragPoint;
    private Point2D.Float lastLithMouseLoc;
    private String lastDepthString = null;
    private Point2D.Float LOCorigin = null;
    private Point2D.Float disconfMinOrigin;
    private Point2D.Float disconfMaxOrigin;
    private Point2D.Float dragBaseLOC;
    private Point2D.Float dragTopLOC;
    private static final Logger LOGGER = Logger.getLogger(InteractiveChartJPanel.class.getName());
    private UndoManager undoManager = null;
    private UndoableEditSupport undoSupport = null;

    public InteractiveChartJPanel(Chart chart, JPanelCharts parent, UndoManager undoManager, UndoableEditSupport support) {
        super(chart);
        this.parent = parent;
        this.init(undoManager, support);
    }

    private void init(UndoManager undoManager, UndoableEditSupport support) {
        this.undoManager = undoManager == null ? new SbugsUndoManager() : undoManager;
        this.undoSupport = support == null ? new UndoableEditSupport() : support;
        LithologyTransferHandler lithologyTransferHandler = new LithologyTransferHandler();
        lithologyTransferHandler.undoSupport.addUndoableEditListener(this.undoManager);
        this.setTransferHandler(lithologyTransferHandler);
        this.addMouseMotionListener(new MouseMotionAdapter(this){
            final /* synthetic */ InteractiveChartJPanel this$0;
            {
                InteractiveChartJPanel interactiveChartJPanel = this$0;
                Objects.requireNonNull(interactiveChartJPanel);
                this.this$0 = interactiveChartJPanel;
            }

            @Override
            public void mouseMoved(MouseEvent evt) {
                this.this$0.mMoved(evt);
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(this){
            final /* synthetic */ InteractiveChartJPanel this$0;
            {
                InteractiveChartJPanel interactiveChartJPanel = this$0;
                Objects.requireNonNull(interactiveChartJPanel);
                this.this$0 = interactiveChartJPanel;
            }

            @Override
            public void mouseDragged(MouseEvent evt) {
                this.this$0.mDragged(evt);
            }
        });
        this.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ InteractiveChartJPanel this$0;
            {
                InteractiveChartJPanel interactiveChartJPanel = this$0;
                Objects.requireNonNull(interactiveChartJPanel);
                this.this$0 = interactiveChartJPanel;
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                this.this$0.mReleased(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                this.this$0.mPressed(evt);
            }
        });
        this.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ InteractiveChartJPanel this$0;
            {
                InteractiveChartJPanel interactiveChartJPanel = this$0;
                Objects.requireNonNull(interactiveChartJPanel);
                this.this$0 = interactiveChartJPanel;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.this$0.mClicked(evt);
            }
        });
    }

    private void postEdit(UndoableEdit edit) {
        if (edit != null) {
            this.undoManager.addEdit(edit);
            this.undoSupport.postEdit(edit);
            this.parent.setUndoTooltips();
            this.repaint();
        }
    }

    @Override
    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    @Override
    public UndoableEditSupport getUndoSupport() {
        return this.undoSupport;
    }

    void setVersion(int interpID) throws SQLException, SBException {
        ArrayList<ChartBlock> blocks = new ArrayList<ChartBlock>();
        if (this.chart.getTemplate() == null) {
            for (ChartBlock chartBlock : this.chart.getChartBlocks()) {
                blocks.add(chartBlock);
            }
        } else {
            int i = 0;
            for (ChartTemplate.BlockOcc occ : this.chart.getTemplate().getBlocks()) {
                if (occ.getWellID() == 0 && BlockType.inheritsWell(this.parent.parent.getParent().getChartManager().getBlockTemplate(occ.getBlockID()).getType())) {
                    blocks.add((ChartBlock)this.chart.getBlocks().get(i));
                }
                ++i;
            }
        }
        for (ChartBlock chartBlock : blocks) {
            chartBlock.setInterpID(interpID);
        }
    }

    private void mMoved(MouseEvent evt) {
        Lithology lith;
        ChartPanel panel;
        String text;
        if (this.hasMarquee() || evt.isAltDown() && !evt.isControlDown() && !evt.isShiftDown()) {
            return;
        }
        Point2D.Float mmPoint = this.getPoint(evt.getPoint());
        if (this.parent.getInterp() == null) {
            this.parent.setJLabelInfoColour(Color.RED);
            text = "Warning: no version loaded";
        } else {
            WellBlock wellBlock;
            ChartBlockBase block = this.chart.getBlock(mmPoint, this.hMode(), this.vMode());
            if (!(block instanceof WellBlock) || (wellBlock = (WellBlock)block).getWell() == this.parent.parentPanel.getWell()) {
                if (this.ZoneBndOrigin == null && this.depthBndOrigin == null) {
                    String tooltip = this.getTooltip(evt);
                    if (tooltip != null && tooltip.contains("Bnd: ") || this.getObject(evt) instanceof SQPick) {
                        if (block != null && ((ChartBlock)block).getProp().getScaleType() == BlockProperties.ScaleType.MD) {
                            this.setCursor(Cursor.getPredefinedCursor(12));
                        }
                    } else {
                        Object o = this.getObject(evt);
                        if (o instanceof Point2D.Float) {
                            this.setCursor(Cursor.getPredefinedCursor(12));
                        } else {
                            this.setCursor(Cursor.getDefaultCursor());
                        }
                    }
                }
                if (this.LOCorigin == null && this.disconfMinOrigin == null && this.disconfMaxOrigin == null) {
                    try {
                        Point2D.Float pInPanel = new Point2D.Float();
                        panel = this.chart.getPanel(mmPoint, this.hMode(), this.vMode(), pInPanel);
                        if (panel != null && panel instanceof PanelWellDepthAge) {
                            PanelWellDepthAge wellPanel = (PanelWellDepthAge)panel;
                            if (wellPanel.interactive() && wellPanel.getLOCorigin(pInPanel.x, pInPanel.y, this.zm.getZoom()) != null) {
                                this.setCursor(Cursor.getPredefinedCursor(12));
                            } else if (wellPanel.interactive() && wellPanel.getDisconfNeighbours(pInPanel.x, pInPanel.y) != null) {
                                this.setCursor(Cursor.getPredefinedCursor(12));
                            } else {
                                this.setCursor(Cursor.getDefaultCursor());
                            }
                        }
                    }
                    catch (RuntimeException re) {
                        re.printStackTrace();
                    }
                }
            }
            text = this.getTooltip(evt);
        }
        this.parent.setJLabelInfoText(text);
        this.setToolTipText(text);
        if (this.parent.parent.getLithPalette() != null && (lith = this.parent.parent.getLithPalette().getSelectedLithology()) != null && !lith.isQual()) {
            Point2D.Float pInPanel = new Point2D.Float();
            Point2D.Float panelOrigin = new Point2D.Float();
            panel = this.chart.getPanel(mmPoint, this.hMode(), this.vMode(), pInPanel, panelOrigin);
            if (this.lastLithMouseLoc != null || panel != null && panel instanceof PanelIntLith) {
                Graphics g = this.getGraphics();
                AffineTransform tf = this.setRubberBandMode(g);
                if (this.lastLithMouseLoc != null) {
                    g.setColor(Color.gray);
                    this.drawLine(g, new Point2D.Float(0.0f, this.lastLithMouseLoc.y), new Point2D.Float(this.getMaximumSize().width, this.lastLithMouseLoc.y));
                    g.setColor(Color.black);
                    this.lastLithMouseLoc = null;
                }
                if (panel != null && panel instanceof PanelIntLith) {
                    Point2D.Float target = new Point2D.Float(panelOrigin.x, mmPoint.y);
                    g.setColor(Color.gray);
                    this.drawLine(g, new Point2D.Float(0.0f, mmPoint.y), new Point2D.Float(this.getMaximumSize().width, mmPoint.y));
                    g.setColor(Color.black);
                    this.lastLithMouseLoc = target;
                }
                this.clearRubberBandMode(g, tf);
            }
        }
    }

    private void mDragged(MouseEvent evt) {
        WellBlock wellBlock;
        if (this.hasMarquee()) {
            return;
        }
        Point2D.Float mmPoint = this.getPoint(evt.getPoint());
        ChartBlockBase block = this.chart.getBlock(mmPoint, this.hMode(), this.vMode());
        if (block instanceof WellBlock && (wellBlock = (WellBlock)block).getWell() != this.parent.parentPanel.getWell()) {
            return;
        }
        Point2D.Float pInPanel = new Point2D.Float();
        Point2D.Float panelOrigin = new Point2D.Float();
        ChartPanel pan = this.chart.getPanel(mmPoint, this.hMode(), this.vMode(), pInPanel, panelOrigin);
        if (pan == null || !(pan instanceof SBPanel)) {
            return;
        }
        BlockProperties.ScaleType scaleType = pan.getBlock().getProp().getScaleType();
        if (pan instanceof PanelWellVS ? scaleType != BlockProperties.ScaleType.TVD : scaleType != BlockProperties.ScaleType.MD) {
            return;
        }
        SBPanel panel = (SBPanel)pan;
        if (this.ZoneBndOrigin != null) {
            this.continueZonePanelDrag(pInPanel, panel, mmPoint, evt);
            return;
        }
        if (panel instanceof PanelZones || panel instanceof PanelSQPicks || panel instanceof PanelEnv) {
            if (this.ZoneBndOrigin == null) {
                this.dragPanelOrigin = panel;
                if (panel instanceof PanelZones) {
                    PanelZones p = (PanelZones)panel;
                    this.ZoneBndOrigin = p.getBoundarySample(pInPanel.x, pInPanel.y, this.zm.getZoom(), this.chart.getProperties(), ((ChartBlock)block).getProp());
                } else if (panel instanceof PanelSQPicks) {
                    Object o = this.getObject(evt);
                    if (o instanceof SQPick) {
                        SQPick pick = (SQPick)o;
                        this.ZoneBndOrigin = pick.getSample();
                    }
                } else {
                    this.ZoneBndOrigin = ((PanelEnv)panel).getBoundarySample(pInPanel.y, this.zm.getZoom());
                }
                if (this.ZoneBndOrigin != null) {
                    this.setCursor(CursorFactory.getDragMoveCursor());
                }
            }
        } else if (panel instanceof PanelIntLith) {
            PanelIntLith panelIntLith = (PanelIntLith)panel;
            if (this.depthBndOrigin == null) {
                this.depthBndOrigin = panelIntLith.getBndDepth(pInPanel.y, this.zm.getZoom());
                if (this.depthBndOrigin == null) {
                    if (panelIntLith.isWithinInterval(pInPanel.y)) {
                        this.depthBndOrigin = LITH_BND_DRAG;
                    } else {
                        DialogLithPalette lithPalette = this.parent.parent.getLithPalette();
                        if (lithPalette != null && lithPalette.getSelectedLithology() != null && !lithPalette.getSelectedLithology().isQual()) {
                            this.depthBndOrigin = panelIntLith.getDepth(pInPanel.y);
                            this.lithBndOriginDraw = Float.valueOf(mmPoint.y);
                        } else {
                            this.depthBndOrigin = LITH_BND_DRAG;
                        }
                    }
                }
            } else if (this.depthBndOrigin != LITH_BND_DRAG) {
                Graphics g = this.getGraphics();
                AffineTransform tf = this.setRubberBandMode(g);
                double depth = panelIntLith.getDepth(pInPanel.y);
                depth = SB.round((double)depth, (int)this.getRounding(depth));
                String depthString = DepthUtils.convFromM((double)depth, (char)this.chart.getWellBlock().getProp().getUnits(), (char)this.chart.getWellBlock().getWell().getType()) + DepthUnits.getUnits((char)this.chart.getWellBlock().getProp().getUnits()).getAbr();
                if (this.lithBndOriginDraw != null) {
                    this.drawLine(g, new Point2D.Float(0.0f, this.lithBndOriginDraw.floatValue()), new Point2D.Float(this.getMaximumSize().width, this.lithBndOriginDraw.floatValue()));
                    Point2D.Float lithBndOriginDrawInPanel = new Point2D.Float();
                    this.chart.getPanel(new Point2D.Float(mmPoint.x, this.lithBndOriginDraw.floatValue()), this.hMode(), this.vMode(), lithBndOriginDrawInPanel);
                    double depth1 = panelIntLith.getDepth(lithBndOriginDrawInPanel.y);
                    this.lithBndOrigin = SB.round((double)depth1, (int)this.getRounding(depth1));
                    this.lithBndOriginDraw = null;
                }
                if (this.lastDragPoint != null && this.lastDepthString != null) {
                    this.drawString(g, this.lastDragPoint, this.lastDepthString);
                    g.setColor(Color.gray);
                    this.drawLine(g, new Point2D.Float(0.0f, this.lastDragPoint.y), new Point2D.Float(this.getMaximumSize().width, this.lastDragPoint.y));
                    g.setColor(Color.black);
                }
                Point2D.Float target = new Point2D.Float();
                Point2D.Float panelOriginAsDrawn = this.chart.getMmPanelOrigin(panel, this.hMode(), this.vMode(), 0.0f);
                target.x = panelOriginAsDrawn.x;
                target.y = mmPoint.y;
                this.drawString(g, target, depthString);
                g.setColor(Color.gray);
                this.drawLine(g, new Point2D.Float(0.0f, mmPoint.y), new Point2D.Float(this.getMaximumSize().width, mmPoint.y));
                g.setColor(Color.black);
                this.lastDragPoint = target;
                this.lastDepthString = depthString;
                this.clearRubberBandMode(g, tf);
            }
        } else if (panel instanceof PanelWellDepthAge) {
            PanelWellDepthAge wellPanel = (PanelWellDepthAge)panel;
            if (this.LOCorigin == null && this.disconfMinOrigin == null && this.disconfMaxOrigin == null) {
                if (!wellPanel.interactive()) {
                    return;
                }
                this.LOCorigin = wellPanel.getLOCorigin(pInPanel.x, pInPanel.y, this.zm.getZoom());
                if (this.LOCorigin != null) {
                    this.setCursor(CursorFactory.getDragMoveCursor());
                    this.dragTopLOC = wellPanel.getNeighbourPoint(this.LOCorigin.x, this.LOCorigin.y, true);
                    this.dragBaseLOC = wellPanel.getNeighbourPoint(this.LOCorigin.x, this.LOCorigin.y, false);
                } else if (wellPanel.getDisconfNeighbours(pInPanel.x, pInPanel.y) != null) {
                    this.setCursor(CursorFactory.getDragMoveCursor());
                    Point2D.Float[] disconfNeighbours = wellPanel.getDisconfNeighbours(pInPanel.x, pInPanel.y);
                    this.disconfMinOrigin = disconfNeighbours[0];
                    this.dragTopLOC = wellPanel.getNeighbourPoint(this.disconfMinOrigin.x, this.disconfMinOrigin.y, true);
                    this.disconfMinOrigin = this.chart.getMmPoint(this.disconfMinOrigin, wellPanel, this.hMode(), this.vMode(), pInPanel.x);
                    this.disconfMaxOrigin = disconfNeighbours[1];
                    this.dragBaseLOC = wellPanel.getNeighbourPoint(this.disconfMaxOrigin.x, this.disconfMaxOrigin.y, false);
                    this.disconfMaxOrigin = this.chart.getMmPoint(this.disconfMaxOrigin, wellPanel, this.hMode(), this.vMode(), mmPoint.x);
                }
                if (this.dragTopLOC != null) {
                    this.dragTopLOC = this.chart.getMmPoint(this.dragTopLOC, wellPanel, this.hMode(), this.vMode(), mmPoint.x);
                }
                if (this.dragBaseLOC != null) {
                    this.dragBaseLOC = this.chart.getMmPoint(this.dragBaseLOC, panel, this.hMode(), this.vMode(), mmPoint.x);
                }
            } else {
                Graphics g = this.getGraphics();
                AffineTransform tf = this.setRubberBandMode(g);
                if (this.dragBaseLOC != null && mmPoint.y > this.dragBaseLOC.y) {
                    mmPoint.y = this.dragBaseLOC.y;
                }
                if (this.dragTopLOC != null && mmPoint.y < this.dragTopLOC.y) {
                    mmPoint.y = this.dragTopLOC.y;
                }
                if (this.lastDragPoint != null) {
                    if (this.disconfMinOrigin != null && this.disconfMaxOrigin != null) {
                        this.drawLine(g, new Point2D.Float(this.disconfMinOrigin.x, this.lastDragPoint.y), new Point2D.Float(this.disconfMaxOrigin.x, this.lastDragPoint.y));
                        if (this.dragTopLOC != null) {
                            this.drawLine(g, this.dragTopLOC, new Point2D.Float(this.disconfMinOrigin.x, this.lastDragPoint.y));
                        }
                        if (this.dragBaseLOC != null) {
                            this.drawLine(g, this.dragBaseLOC, new Point2D.Float(this.disconfMaxOrigin.x, this.lastDragPoint.y));
                        }
                    } else {
                        if (this.dragTopLOC != null) {
                            this.drawLine(g, this.dragTopLOC, this.lastDragPoint);
                        }
                        if (this.dragBaseLOC != null) {
                            this.drawLine(g, this.dragBaseLOC, this.lastDragPoint);
                        }
                        g.setColor(Color.gray);
                        this.drawLine(g, new Point2D.Float(this.lastDragPoint.x, 0.0f), new Point2D.Float(this.lastDragPoint.x, this.getMaximumSize().height));
                        this.drawLine(g, new Point2D.Float(0.0f, this.lastDragPoint.y), new Point2D.Float(this.getMaximumSize().width, this.lastDragPoint.y));
                        g.setColor(Color.black);
                    }
                }
                if (this.disconfMinOrigin != null && this.disconfMaxOrigin != null) {
                    this.drawLine(g, new Point2D.Float(this.disconfMinOrigin.x, mmPoint.y), new Point2D.Float(this.disconfMaxOrigin.x, mmPoint.y));
                    if (this.dragTopLOC != null) {
                        this.drawLine(g, this.dragTopLOC, new Point2D.Float(this.disconfMinOrigin.x, mmPoint.y));
                    }
                    if (this.dragBaseLOC != null) {
                        this.drawLine(g, this.dragBaseLOC, new Point2D.Float(this.disconfMaxOrigin.x, mmPoint.y));
                    }
                } else {
                    if (this.dragTopLOC != null) {
                        this.drawLine(g, this.dragTopLOC, mmPoint);
                    }
                    if (this.dragBaseLOC != null) {
                        this.drawLine(g, this.dragBaseLOC, mmPoint);
                    }
                    g.setColor(Color.gray);
                    this.drawLine(g, new Point2D.Float(mmPoint.x, 0.0f), new Point2D.Float(mmPoint.x, this.getMaximumSize().height));
                    this.drawLine(g, new Point2D.Float(0.0f, mmPoint.y), new Point2D.Float(this.getMaximumSize().width, mmPoint.y));
                    g.setColor(Color.black);
                }
                this.clearRubberBandMode(g, tf);
                this.parent.setJLabelInfoText(this.getTooltip(evt));
                this.lastDragPoint = mmPoint;
            }
        } else if (panel instanceof PanelWellVS) {
            PanelWellVS vspanel = (PanelWellVS)panel;
            if (this.lastDragPoint == null && this.getObject(evt) == vspanel.getPredictPoint()) {
                this.lastDragPoint = mmPoint;
                this.setCursor(CursorFactory.getDragMoveCursor());
            } else {
                Point2D.Float p1 = vspanel.getLastNodePoint();
                p1.setLocation(p1.x + panelOrigin.x, p1.y + panelOrigin.y);
                Graphics g = this.getGraphics();
                AffineTransform tf = this.setRubberBandMode(g);
                this.setCursor(Cursor.getPredefinedCursor(12));
                if (this.lastDragPoint != null) {
                    this.drawLine(g, p1, this.lastDragPoint);
                }
                this.drawLine(g, p1, mmPoint);
                this.lastDragPoint = mmPoint;
                this.mMoved(evt);
                this.clearRubberBandMode(g, tf);
            }
        }
    }

    private void continueZonePanelDrag(Point2D.Float pInPanel, SBPanel panel, Point2D.Float mmPoint, MouseEvent evt) {
        Graphics g = this.getGraphics();
        AffineTransform tf = this.setRubberBandMode(g);
        if (this.dragPanelOrigin != null) {
            Sample sample = this.dragPanelOrigin instanceof PanelZones ? ((PanelZones)this.dragPanelOrigin).getNearestSampleWithinBounds(pInPanel.y, this.chart.getProperties()) : (this.dragPanelOrigin instanceof PanelSQPicks ? ((PanelSQPicks)this.dragPanelOrigin).getSample(pInPanel.x, pInPanel.y, this.zm.getZoom(), this.chart.getProperties()) : ((PanelEnv)this.dragPanelOrigin).getSample(pInPanel.x, pInPanel.y, this.zm.getZoom(), this.chart.getProperties()));
            Point2D newDragPoint = null;
            float panelWidth = this.dragPanelOrigin.getWidth(this.chart.getWellBlock().getProp());
            if (sample != null) {
                try {
                    float panelX = 0.0f;
                    if (this.dragPanelOrigin.equals(panel)) {
                        panelX = mmPoint.x;
                    }
                    Point2D.Float panelOriginAsDrawn = this.chart.getMmPanelOrigin(this.dragPanelOrigin, this.hMode(), this.vMode(), 0.0f);
                    newDragPoint = new Point2D.Float();
                    float sampleDepth = (float)this.chart.getWellBlock().getWell().getDepth(sample, this.chart.getProperties().correctDepths, this.chart.getProperties().correctCuttings);
                    ((Point2D.Float)newDragPoint).x = panelOriginAsDrawn.x;
                    ((Point2D.Float)newDragPoint).y = panelOriginAsDrawn.y + this.chart.getWellBlock().scaleDepth(sampleDepth);
                }
                catch (SQLException sql) {
                    sql.printStackTrace();
                    if (this.lastDragPoint != null) {
                        this.drawHozLine(g, this.lastDragPoint, panelWidth);
                    }
                    this.lastDragPoint = null;
                    return;
                }
            }
            if (!(this.lastDragPoint == null || newDragPoint != null && newDragPoint.equals(this.lastDragPoint))) {
                this.drawHozLine(g, this.lastDragPoint, panelWidth);
                this.lastDragPoint = null;
            }
            if (!(newDragPoint == null || this.lastDragPoint != null && newDragPoint.equals(this.lastDragPoint))) {
                this.drawHozLine(g, (Point2D.Float)newDragPoint, panelWidth);
                this.lastDragPoint = newDragPoint;
            }
            this.mMoved(evt);
            String text = sample != null ? sample.toString() : "No sample";
            this.parent.setJLabelInfoText(text);
            this.setToolTipText(text);
        }
        this.clearRubberBandMode(g, tf);
    }

    private void drawHozLine(Graphics g, Point2D.Float point, float width) {
        this.drawLine(g, point, new Point2D.Float(point.x + width, point.y));
    }

    private int getRounding(double depth) {
        Float scale = this.chart.getWellBlock().getProp().getScale((float)depth);
        if (scale == null) {
            scale = Float.valueOf(this.chart.getWellBlock().getProp().getScale(this.chart.getWellBlock().getProp().getLongestSection()));
        }
        double depthRes = this.zm.getZoom() * 2.8346457f / scale.floatValue() * 1000.0f;
        int round = (int)Math.log10(depthRes);
        return round;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mReleased(MouseEvent evt) {
        if (this.hasMarquee()) {
            return;
        }
        Point2D.Float mmPoint = this.getPoint(evt.getPoint());
        if (evt.isPopupTrigger()) {
            ChartBlockBase block = this.chart.getBlock(mmPoint, this.hMode(), this.vMode());
            if (block instanceof WellBlock && ((WellBlock)block).getWell() != this.parent.parentPanel.getWell()) {
                return;
            }
            this.parent.showPopup(evt);
            return;
        }
        Point2D.Float pInPanel = new Point2D.Float();
        Point2D.Float panelOrigin = new Point2D.Float();
        ChartPanel panel = this.chart.getPanel(mmPoint, this.hMode(), this.vMode(), pInPanel, panelOrigin);
        if (!(panel instanceof SBPanel)) {
            return;
        }
        panel.setExpectingUrgentChange();
        try {
            PanelWellVS panelvs;
            if (this.ZoneBndOrigin != null) {
                if (this.dragPanelOrigin == null) {
                    return;
                }
                float xPos = 0.0f;
                if (this.dragPanelOrigin.equals(panel)) {
                    xPos = mmPoint.x;
                }
                if ((panelOrigin = this.chart.getMmPanelOrigin(this.dragPanelOrigin, this.hMode(), this.vMode(), xPos)) == null) {
                    LOGGER.log(Level.WARNING, "PanelOrigin null at {0}", this.dragPanelOrigin);
                    return;
                }
                pInPanel = new Point2D.Float((float)(mmPoint.getX() - panelOrigin.getX()), (float)(mmPoint.getY() - panelOrigin.getY()));
                SBPanel sBPanel = this.dragPanelOrigin;
                if (sBPanel instanceof PanelZones) {
                    PanelZones panelZones = (PanelZones)sBPanel;
                    interp = panelZones.getBlock().getWell().getInterp(panelZones.getInterpID());
                    Sample newSample = panelZones.getSample(pInPanel.x, pInPanel.y, this.zm.getZoom(), this.chart.getProperties());
                    if (newSample != null && !newSample.equals(this.ZoneBndOrigin)) {
                        this.dragPanelOrigin.setExpectingUrgentChange();
                        this.postEdit(((WellInterp)interp).updateIntervalBoundary(this.ZoneBndOrigin, newSample, panelZones.getBlock().getWell().getWellID(), panelZones.getIGDType(), panelZones.getSchID()));
                    }
                } else {
                    interp = this.dragPanelOrigin;
                    if (interp instanceof PanelSQPicks) {
                        PanelSQPicks pickPanel = (PanelSQPicks)interp;
                        interp = pickPanel.getBlock().getWell().getInterp(pickPanel.getInterpID());
                        Sample newSample = pickPanel.getSample(pInPanel.x, pInPanel.y, this.zm.getZoom(), this.chart.getProperties());
                        if (newSample != null && !newSample.equals(this.ZoneBndOrigin)) {
                            this.dragPanelOrigin.setExpectingUrgentChange();
                            InterpEdit<SQPick> edit = ((WellInterp)interp).updateSQPick(pickPanel.getBlock().getWell(), this.ZoneBndOrigin, newSample);
                            this.parent.sbdb.commit();
                            interp.notifyObservers((Object)edit.getNotifier());
                            this.postEdit((UndoableEdit)((Object)edit));
                        }
                    } else {
                        interp = this.dragPanelOrigin;
                        if (interp instanceof PanelEnv) {
                            PanelEnv envPanel = (PanelEnv)interp;
                            interp = envPanel.getBlock().getWell().getInterp(envPanel.getInterpID());
                            Sample newSample = envPanel.getSample(pInPanel.x, pInPanel.y, this.zm.getZoom(), this.chart.getProperties());
                            if (newSample != null && !newSample.equals(this.ZoneBndOrigin)) {
                                this.dragPanelOrigin.setExpectingUrgentChange();
                                this.postEdit(((WellInterp)interp).updateEnvBoundary(this.ZoneBndOrigin, newSample, envPanel.getBlock().getWell().getWellID()));
                            }
                        }
                    }
                }
                this.lastDragPoint = null;
            } else if (this.depthBndOrigin != null && this.depthBndOrigin != LITH_BND_DRAG) {
                if (panel instanceof PanelIntLith) {
                    PanelIntLith lithPanel = (PanelIntLith)panel;
                    double depthTemp = lithPanel.getDepth(pInPanel.y);
                    double newDepth = SB.round((double)depthTemp, (int)this.getRounding(depthTemp));
                    if (this.lithBndOrigin != null) {
                        double origDepth = this.lithBndOrigin;
                        this.postEdit(lithPanel.getBlock().getWell().addLithInterval(this.parent.parent.getLithPalette().getSelectedLithology(), origDepth, newDepth));
                    } else {
                        double origDepth = this.depthBndOrigin;
                        SbugsCompoundEdit edit = lithPanel.getBlock().getWell().updateLithInterval(origDepth, newDepth);
                        edit.doEdits();
                        this.postEdit((UndoableEdit)edit);
                    }
                }
            } else if (panel instanceof PanelWellDepthAge) {
                PanelWellDepthAge wellPanel = (PanelWellDepthAge)panel;
                panelOrigin = this.chart.getMmPanelOrigin(wellPanel, this.hMode(), this.vMode(), 0.0f);
                int bnd = -1;
                if (this.dragBaseLOC != null && mmPoint.y > this.dragBaseLOC.y) {
                    mmPoint.y = this.dragBaseLOC.y;
                    pInPanel.y = mmPoint.y - panelOrigin.y;
                    bnd = 4;
                }
                if (this.dragTopLOC != null && mmPoint.y < this.dragTopLOC.y) {
                    mmPoint.y = this.dragTopLOC.y;
                    pInPanel.y = mmPoint.y - panelOrigin.y;
                }
                if (this.LOCorigin != null) {
                    try {
                        this.postEdit(wellPanel.updateLOCNode(this.LOCorigin, pInPanel, bnd));
                    }
                    catch (RuntimeException | SQLException | InvalidFieldException | SBException ex) {
                        SbugsExceptionHandler.showStackError("Error updating node", ex, this.parent);
                    }
                    finally {
                        this.setCursor(Cursor.getDefaultCursor());
                    }
                } else if (this.disconfMinOrigin != null && this.disconfMaxOrigin != null) {
                    Point2D.Float oldMinPoint = new Point2D.Float();
                    this.chart.getPanel(this.disconfMinOrigin, this.hMode(), this.vMode(), oldMinPoint);
                    Point2D.Float newMinPoint = new Point2D.Float();
                    this.chart.getPanel(new Point2D.Float(this.disconfMinOrigin.x, mmPoint.y), this.hMode(), this.vMode(), newMinPoint);
                    try {
                        this.postEdit(wellPanel.updateDisconf(oldMinPoint.y, newMinPoint.y));
                    }
                    catch (RuntimeException | SQLException | InvalidFieldException | SBException ex) {
                        SbugsExceptionHandler.showStackError("Error updating disconformity", ex, this.parent);
                    }
                    finally {
                        this.setCursor(Cursor.getDefaultCursor());
                    }
                }
                this.lastDragPoint = null;
                this.LOCorigin = null;
                this.disconfMaxOrigin = null;
                this.disconfMinOrigin = null;
            } else if (panel instanceof PanelWellVS && this.lastDragPoint != null && !(panelvs = (PanelWellVS)panel).setPredictPoint(pInPanel)) {
                JOptionPane.showMessageDialog(this, "Vertical section must be greater than last point on deviation survey", this.parent.parent.getTitle(), 0);
            }
            this.parent.sbdb.commit();
        }
        catch (SQLException | InvalidFieldException | SBPermissionException ex) {
            SbugsExceptionHandler.showStackError("Error on mouse release", ex, this.parent.parent);
        }
        catch (SBException ex) {
            JOptionPane.showMessageDialog(this, "Error on mouse release: " + ex.getMessage(), this.parent.parent.getTitle(), 0);
        }
        finally {
            if (this.getCursor() != null && this.getCursor() != Cursor.getPredefinedCursor(12)) {
                this.setCursor(Cursor.getDefaultCursor());
            }
            this.lastDragPoint = null;
            this.ZoneBndOrigin = null;
            this.dragPanelOrigin = null;
            this.depthBndOrigin = null;
            this.lithBndOriginDraw = null;
            this.lithBndOrigin = null;
            this.lastLithMouseLoc = null;
            this.repaint();
        }
    }

    private void mPressed(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            Point2D.Float pTemp = this.getPoint(evt.getPoint());
            Point2D.Float mmPoint = new Point2D.Float((float)((Point2D)pTemp).getX(), (float)((Point2D)pTemp).getY());
            ChartBlockBase block = this.chart.getBlock(mmPoint, this.hMode(), this.vMode());
            if (block instanceof WellBlock && ((WellBlock)block).getWell() != this.parent.parentPanel.getWell()) {
                return;
            }
            this.parent.showPopup(evt);
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void mClicked(MouseEvent evt) {
        if (evt.getClickCount() < 2) {
            return;
        }
        mmPoint = this.getPoint(evt.getPoint());
        block = this.chart.getBlock(mmPoint, this.hMode(), this.vMode());
        if (block instanceof WellBlock && ((WellBlock)block).getWell() != this.parent.parentPanel.getWell()) {
            return;
        }
        dialog /* !! */  = null;
        obj = this.getObject(evt);
        pInPanel = new Point2D.Float();
        panel = this.chart.getPanel(mmPoint, this.hMode(), this.vMode(), pInPanel);
        try {
            block27: {
                block32: {
                    block31: {
                        block30: {
                            block29: {
                                block28: {
                                    block26: {
                                        if (!(panel instanceof PanelZones)) break block26;
                                        zonesPanel = (PanelZones)panel;
                                        if (obj instanceof PanelZoneBoundary) {
                                            panelZoneBoundary = (PanelZoneBoundary)obj;
                                            obj = panelZoneBoundary.getZone();
                                        }
                                        if (obj instanceof IGDIntervalZone) {
                                            zone = (IGDIntervalZone)obj;
                                            dialog /* !! */  = new DialogInterval(this.parent.getParentFrame(), true, zone.getIGDType(), this.parent.sbdb, zonesPanel.getBlock().getWell(), zonesPanel.getBlock().getWell().getInterp(zonesPanel.getInterpID()), this.parent.getUnits(), zone, null, null, null, null, true);
                                        } else if (obj instanceof Intcom) {
                                            intcom = (Intcom)obj;
                                            dialog /* !! */  = new DialogIntervalComment(this.parent.getParentFrame(), true, this.parent.sbdb, zonesPanel.getBlock().getWell(), zonesPanel.getBlock().getWell().getInterp(zonesPanel.getInterpID()), intcom, this.parent.getUnits(), zonesPanel.getIGDType());
                                        } else if (obj == null && zonesPanel.hasData(((ChartBlock)block).getProp()) && (column = zonesPanel.getColumn(pInPanel.x)) > 0) {
                                            interp = zonesPanel.getBlock().getWell().getInterp(zonesPanel.getInterpID());
                                            newIntervalSettings = interp.getNewIntervalSettings(zonesPanel.getBlock().getWell(), zonesPanel.getIGDType(), zonesPanel.getSchID(pInPanel.x), zonesPanel.getPanelType().getDiscipine(), column, zonesPanel.getBlock().getDepth(pInPanel.y));
                                            dialog /* !! */  = new DialogInterval(this.parent.getParentFrame(), true, this.parent.sbdb, zonesPanel.getBlock().getWell(), zonesPanel.getBlock().getWell().getInterp(zonesPanel.getInterpID()), this.parent.getUnits(), newIntervalSettings);
                                        }
                                        break block27;
                                    }
                                    if (!(panel instanceof PanelSQPicks)) break block28;
                                    pickPanel = (PanelSQPicks)panel;
                                    if (!(obj instanceof SQPick)) break block28;
                                    pick = (SQPick)obj;
                                    dialog /* !! */  = new DialogSQPick(this.parent.getParentFrame(), true, this.parent.sbdb, this.parent.sbdb.getIGDScheme(pickPanel.getSchID()), pickPanel.getBlock().getWell(), pickPanel.getBlock().getWell().getInterp(pickPanel.getInterpID(pickPanel.getBlock())), this.parent.getUnits(), pick, null, null);
                                    break block27;
                                }
                                if (!(panel instanceof PanelEnv)) break block29;
                                envPanel = (PanelEnv)panel;
                                if (!(obj instanceof IGDIntervalEnv)) break block29;
                                env = (IGDIntervalEnv)obj;
                                dialog /* !! */  = new DialogEnv(this.parent.getParentFrame(), true, this.parent.sbdb, envPanel.getBlock().getWell(), envPanel.getBlock().getWell().getInterp(envPanel.getInterpID()), this.parent.getUnits(), env, null, null);
                                break block27;
                            }
                            if (!(panel instanceof PanelEvents)) break block30;
                            panelEvents = (PanelEvents)panel;
                            if (!(obj instanceof WellEvent)) break block30;
                            event = (WellEvent)obj;
                            dialog /* !! */  = new DialogWellEvent(this.parent.getParentFrame(), true, this.parent.sbdb, panelEvents.getBlock().getWell(), panelEvents.getBlock().getWell().getInterp(panelEvents.getInterpID(panelEvents.getBlock())), this.parent.getUnits(), event, null, null, null);
                            break block27;
                        }
                        if (!(panel instanceof PanelBiocoms)) break block31;
                        panelBiocoms = (PanelBiocoms)panel;
                        if (!(obj instanceof Biocom) && !(obj instanceof Biocom.Builder)) break block31;
                        biocom = null;
                        if (obj instanceof Biocom) {
                            biocom = (Biocom)obj;
                        } else {
                            builder = (Biocom.Builder)obj;
                            interp = panelBiocoms.getBlock().getWell().getInterp(panelBiocoms.getInterpID(panelBiocoms.getBlock()));
                            for (Biocom b : interp.getComments(builder.getDiscID())) {
                                if (b.getSample() != builder.getTopSample() || b.getAnalyst() != builder.getAnalyst()) continue;
                                biocom = b;
                                break;
                            }
                        }
                        if (biocom == null) {
                            return;
                        }
                        dialog /* !! */  = new DialogBiocom(this.parent.getParentFrame(), true, this.parent.sbdb, panelBiocoms.getBlock().getWell(), panelBiocoms.getBlock().getWell().getInterp(panelBiocoms.getInterpID(panelBiocoms.getBlock())), this.parent.getUnits(), biocom, null, null);
                        break block27;
                    }
                    if (!(obj instanceof Intcom)) break block32;
                    intcom = (Intcom)obj;
                    dialog /* !! */  = new DialogIntervalComment(this.parent.getParentFrame(), true, this.parent.sbdb, panel.getBlock().getWell(), panel.getBlock().getWell().getInterp(((SBPanel)panel).getInterpID((ChartBlock)panel.getBlock())), intcom, this.parent.getUnits(), 0);
                    break block27;
                }
                if (!(panel instanceof PanelSampleLithology)) ** GOTO lbl-1000
                psl = (PanelSampleLithology)panel;
                if (obj instanceof Sample) {
                    sample = (Sample)obj;
                    dialog /* !! */  = new DialogSampleLithology(this.parent.getParentFrame(), true, this.parent.sbdb, psl.getBlock().getWell(), sample);
                } else if (panel instanceof PanelTaxonGroup && obj instanceof PanelTaxon.PanelTaxonObject) {
                    pto = (PanelTaxon.PanelTaxonObject)obj;
                    occs = new ArrayList<TaxonOcc>();
                    if (pto.getObject() instanceof Taxon && pto.getSmpdtl() != null) {
                        if (pto.getEvent() != null) {
                            dialog /* !! */  = new DialogWellEvent(this.parent.getParentFrame(), true, this.parent.sbdb, panel.getBlock().getWell(), panel.getBlock().getWell().getInterp(((SBPanel)panel).getInterpID((ChartBlock)panel.getBlock())), this.parent.getUnits(), pto.getEvent(), null, null, null);
                        } else {
                            for (TaxonOcc occ : pto.getSmpdtl().getOccurUnsorted()) {
                                if (occ.getTaxon() != pto.getObject()) continue;
                                occs.add(occ);
                            }
                        }
                    }
                    if (occs.size() == 1) {
                        dialog /* !! */  = new DialogOccurrence(this.parent.getParentFrame(), true, this.parent.sbdb, Lastval.getInt(this.parent.sbdb, "SYNSCHID", 1), panel.getBlock().getWell(), pto.getSmpdtl(), (TaxonOcc)occs.get(0), null, Situation.INSITU, false, false, false);
                    } else if (occs.size() > 1) {
                        JOptionPane.showMessageDialog(this, "There is more than one occurrence here. Right click and go to analysis to edit.", "Edit Occurrence", 1);
                    }
                }
            }
            if (dialog /* !! */  != null) {
                panel.setExpectingUrgentChange();
                dialog /* !! */ .setLocationRelativeTo(this.parent);
                dialog /* !! */ .setVisible(true);
                if (dialog /* !! */  instanceof DialogOccurrence && ((SBDialog)dialog /* !! */ ).isOK()) {
                    panel.doDataChangeNotify();
                }
            }
        }
        catch (SQLException | SBException e) {
            SbugsExceptionHandler.showStackError(e, this.parent.parent);
        }
    }
}

