/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.sblicense.SbugsLicense;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.undo.UndoManager;
import jsbchart.block.BlockType;
import jsbchart.block.ChartBlock;
import jsbchart.block.ChartBlockBase;
import jsbchart.block.SchemeBlock;
import jsbchart.core.BlockTemplate;
import jsbchart.core.Chart;
import jsbchart.core.ChartContainer;
import jsbchart.core.ChartFactory;
import jsbchart.core.ChartManager;
import jsbchart.core.ChartTemplate;
import jsbchart.core.PanelOcc;
import jsbchart.core.PanelTemplate;
import jsbchart.core.TemplateDescr;
import jsbchart.core.TemplateFactory;
import jsbchart.graphics.SBGraphics;
import jsbchart.panel.ChartPanel;
import jsbchart.panel.PanelFactory;
import jsbchart.panel.PanelRange;
import jsbchart.panel.SBPanel;
import jsbugs.ChartActions;
import jsbugs.ChartExporter;
import jsbugs.ChartJPanel;
import jsbugs.ChartPropertiesAction;
import jsbugs.DialogChartDesc;
import jsbugs.DialogChartTemplates;
import jsbugs.DialogPrintPreviewChart;
import jsbugs.DialogProcessing;
import jsbugs.FrameInterpretations;
import jsbugs.FrameJsbugs;
import jsbugs.FrameTaxaDB;
import jsbugs.InteractiveChartJPanelScheme;
import jsbugs.JScrollPaneChart;
import jsbugs.TaxonTransferHandler;
import jsbugs.UndoRedoAction;
import jsbugs.ZoomAction;
import jsbugs.chart.DialogChartProperties;
import jsbugs.io.ImageFileType;
import jsbugs.uiutil.icon.IconFactory;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.IGDUnit;
import model3.Lastval;
import model3.SBdb;
import model3.Taxon;
import org.apache.batik.transcoder.TranscoderException;
import util.InvalidFieldException;
import util.SB;
import util.SBException;
import util.SBPermissionException;
import util.SbugsFileFilter;
import util.exception.StackError;

public class InternalFrameChart
extends JInternalFrame
implements ChartActions,
DragGestureListener,
ChartContainer {
    final JFrame parent;
    final SBdb sbdb;
    private final ChartManager chartManager;
    private Taxon txDragOrigin;
    Action lastTabClosedAction;
    private final String LOC_FIELD;
    private static PageFormat printFormat = null;
    private Color copiedColour;
    private Point popupPoint;
    private JButton jButtonChartProperties;
    private JButton jButtonEditChart;
    private JButton jButtonExport;
    private JButton jButtonOpenTemplate;
    private JButton jButtonPrint;
    private JButton jButtonRedo;
    private JButton jButtonSaveStandardAsTemplate;
    private JButton jButtonUndo;
    private JButton jButtonZoomIn;
    private JButton jButtonZoomOut;
    private JLabel jLabelTooltip;
    private JMenuItem jMenuItemCopyUnitColour;
    private JMenuItem jMenuItemPasteUnitColour;
    private JPopupMenu jPopupMenu1;
    private JToolBar.Separator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JToolBar.Separator jSeparator3;
    private JToolBar.Separator jSeparator4;
    private JTabbedPane jTabbedPaneChart;
    private JToggleButton jToggleButtonFreezeHeader;
    private JToggleButton jToggleButtonInteractive;
    private JToolBar jToolBar1;

    InternalFrameChart(JFrame parent, SBdb sbdb, ChartManager chartManager, String title, Action lastTabClosedAction, String prefString) {
        this.parent = parent;
        this.sbdb = sbdb;
        this.chartManager = chartManager;
        this.lastTabClosedAction = lastTabClosedAction;
        this.LOC_FIELD = prefString;
        this.initComponents();
        this.initKeyBindings();
        this.init(title);
    }

    private void init(String title) {
        this.setTitle(title);
        this.setTooltip(null);
        this.chartManager.addChartListener(this);
        this.setTransferHandler(new TaxonTransferHandler(this.sbdb, null));
    }

    @Override
    public void zoom(boolean in) {
        JScrollPaneChart scrollPane = (JScrollPaneChart)this.jTabbedPaneChart.getSelectedComponent();
        scrollPane.zoom(in);
    }

    void setTooltip(String tooltip) {
        if (tooltip == null) {
            tooltip = "";
        }
        this.jLabelTooltip.setText(tooltip);
    }

    private void initKeyBindings() {
        this.getInputMap(2).put(KeyStroke.getKeyStroke(61, 128), "zoomIn");
        this.getInputMap(2).put(KeyStroke.getKeyStroke(45, 128), "zoomOut");
        this.getActionMap().put("zoomIn", new ZoomAction(true, this));
        this.getActionMap().put("zoomOut", new ZoomAction(false, this));
        this.getInputMap(2).put(KeyStroke.getKeyStroke(90, 128), "undo");
        this.getActionMap().put("undo", new UndoRedoAction(true, this));
        this.getInputMap(2).put(KeyStroke.getKeyStroke(90, 192), "redo");
        this.getActionMap().put("redo", new UndoRedoAction(false, this));
        this.getInputMap(2).put(KeyStroke.getKeyStroke(80, 128), "chartProperties");
        this.getActionMap().put("chartProperties", new ChartPropertiesAction(this));
        this.getInputMap(2).put(KeyStroke.getKeyStroke(49, 128), "zoomToNatural");
        this.getActionMap().put("zoomToNatural", new AbstractAction(this){
            final /* synthetic */ InternalFrameChart this$0;
            {
                InternalFrameChart internalFrameChart = this$0;
                Objects.requireNonNull(internalFrameChart);
                this.this$0 = internalFrameChart;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ((JScrollPaneChart)this.this$0.jTabbedPaneChart.getSelectedComponent()).zoomToNatural();
            }
        });
        this.getInputMap(2).put(KeyStroke.getKeyStroke(48, 128), "fitToScreen");
        this.getActionMap().put("fitToScreen", new AbstractAction(this){
            final /* synthetic */ InternalFrameChart this$0;
            {
                InternalFrameChart internalFrameChart = this$0;
                Objects.requireNonNull(internalFrameChart);
                this.this$0 = internalFrameChart;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ((JScrollPaneChart)this.this$0.jTabbedPaneChart.getSelectedComponent()).fitToScreen();
            }
        });
    }

    public Taxon getTxDragOrigin() {
        return this.txDragOrigin;
    }

    private Chart getChart() {
        if (this.jTabbedPaneChart.getSelectedComponent() != null) {
            JScrollPaneChart sPane = (JScrollPaneChart)this.jTabbedPaneChart.getSelectedComponent();
            return sPane.getChart();
        }
        return null;
    }

    boolean isInteractive() {
        return this.jToggleButtonInteractive.isSelected();
    }

    @Override
    public void undoRedo(boolean undo) {
        if (this.jTabbedPaneChart.getSelectedComponent() == null) {
            return;
        }
        UndoManager manager = ((JScrollPaneChart)this.jTabbedPaneChart.getSelectedComponent()).getUndoManager();
        if (manager == null || undo && !manager.canUndo() || !undo && !manager.canRedo()) {
            this.getToolkit().beep();
            return;
        }
        if (undo) {
            manager.undo();
        } else {
            manager.redo();
        }
        ((JScrollPaneChart)this.jTabbedPaneChart.getSelectedComponent()).repaint();
    }

    void printChart(SBdb db, JFrame parentFrame) {
        Chart chart = this.getChart();
        PrinterJob job = PrinterJob.getPrinterJob();
        if (!job.printDialog()) {
            return;
        }
        ChartJPanel printPanel = new ChartJPanel(chart, printFormat != null ? printFormat : job.defaultPage(), db.decodeChartPrintPrefs());
        DialogPrintPreviewChart dialog = new DialogPrintPreviewChart(parentFrame, true, printPanel, job, db);
        dialog.setVisible(true);
        if (!dialog.isOK()) {
            return;
        }
        job.setPrintable(printPanel, printPanel.getPf());
        try {
            job.print();
        }
        catch (PrinterException exp) {
            JOptionPane.showMessageDialog(this, "Problem printing: " + exp.getMessage());
            exp.printStackTrace();
        }
        printFormat = printPanel.getPf();
    }

    void exportChart(final SBdb db, JFrame parentFrame) {
        if (!(parentFrame.getParent() instanceof FrameJsbugs)) {
            throw new IllegalArgumentException("Attempt to use wrong type of Frame");
        }
        boolean vector = true;
        Chart chart = this.getChart();
        if (chart == null) {
            JOptionPane.showMessageDialog(this, "No chart selected/created. Use the Chart tab and select chart", "Scheme Chart", 1);
            return;
        }
        JFileChooser jFileChooser = new JFileChooser();
        for (ImageFileType vtype : ImageFileType.values()) {
            if (vtype.isVector() != vector) continue;
            jFileChooser.addChoosableFileFilter((FileFilter)vtype.getFilter());
        }
        jFileChooser.setAcceptAllFileFilterUsed(false);
        File setDir = null;
        try {
            setDir = vector ? new File(Lastval.getString(db, "WINVECIMG", "UNXVECIMG")) : new File(Lastval.getString(db, "WINRASIMG", "UNXRASIMG"));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (setDir == null || setDir.getParent() == null || !setDir.getParentFile().exists()) {
            setDir = new File(".");
        }
        try {
            jFileChooser.setCurrentDirectory(setDir);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (0 == jFileChooser.showSaveDialog(this)) {
            try {
                this.setCursor(Cursor.getPredefinedCursor(3));
                if (jFileChooser.getSelectedFile().exists() && JOptionPane.showConfirmDialog(this, "Overwrite file?", "Confirm File Overwrite", 0, 3) != 0) {
                    return;
                }
                setDir = jFileChooser.getSelectedFile();
                SbugsFileFilter filter = (SbugsFileFilter)jFileChooser.getFileFilter();
                if (filter == null) {
                    ImageFileType type;
                    if (setDir.getName().lastIndexOf(".") > 0 && (type = ImageFileType.getType(setDir.getName().substring(setDir.getName().lastIndexOf(".") + 1))) != null) {
                        filter = type.getFilter();
                    }
                    if (filter == null) {
                        filter = ImageFileType.getDefaultFilter(vector);
                    }
                }
                if (!setDir.getName().endsWith("." + filter.getExtension())) {
                    setDir = new File(setDir.getPath() + "." + filter.getExtension());
                }
                if (vector) {
                    final File dir = setDir;
                    final ImageFileType type = ImageFileType.getType(filter.getExtension());
                    final InternalFrameChart messageParent = this;
                    final DialogProcessing dialog = new DialogProcessing((Frame)parentFrame, true);
                    dialog.setMessage("Writing image file...");
                    dialog.setLocationRelativeTo(this);
                    final Boolean embedFonts = ChartExporter.getEmbedFontsOption(this.sbdb);
                    if (embedFonts == null) {
                        return;
                    }
                    new SwingWorker(this){
                        boolean done;
                        final /* synthetic */ InternalFrameChart this$0;
                        {
                            InternalFrameChart internalFrameChart = this$0;
                            Objects.requireNonNull(internalFrameChart);
                            this.this$0 = internalFrameChart;
                        }

                        protected Object doInBackground() throws IOException, TranscoderException {
                            try {
                                ChartExporter.saveVectorImage(dir, type, this.this$0.getChart(), db, SbugsLicense.isDemoLicense(), embedFonts);
                                dialog.setComplete();
                            }
                            catch (FileNotFoundException fnf) {
                                JOptionPane.showMessageDialog(messageParent, fnf.getMessage(), "Error saving chart", 0);
                                dialog.setMessage(fnf.getMessage());
                            }
                            catch (IOException ioe) {
                                StackError.showStackError((String)"IO Error creating file", (Throwable)ioe);
                            }
                            catch (NoClassDefFoundError c) {
                                JOptionPane.showMessageDialog(messageParent, "A required library may be missing - please contct your system administrator\n" + c.getMessage(), "Error saving chart", 0);
                            }
                            catch (OutOfMemoryError e) {
                                JOptionPane.showMessageDialog(messageParent, "Error writing image - out of memory!\nNote that some chart panels are more memory-intensive than others:\ntry removing lithology and wireline log panels, or save to SVG.", "Memory error", 0);
                            }
                            catch (Exception e) {
                                StackError.showStackError((String)"Error creating file", (Throwable)e);
                            }
                            return null;
                        }

                        @Override
                        protected void done() {
                            dialog.dispose();
                        }
                    }.execute();
                    dialog.setVisible(true);
                    if (!dialog.isTaskComplete()) {
                        return;
                    }
                }
                try {
                    Lastval.putString(db, vector ? "WINVECIMG" : "WINRASIMG", setDir.getPath());
                    db.commit();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
            JOptionPane.showMessageDialog(this, "Image written.", "Export image", 1);
        }
    }

    private void closeTab(JScrollPaneChart sPane, boolean force) {
        int index;
        ChartBlockBase block;
        int opt;
        if (!(force || sPane.getChart().getTemplate() == null && sPane.getChart().getBlockSingle().getTemplate() == null || (opt = JOptionPane.showConfirmDialog(this, "Really close this tab?\nSettings for this template will be lost.", "Close tab", 0)) == 0)) {
            return;
        }
        if (sPane.getChart().getTemplate() == null && (block = sPane.getChart().getBlockSingle()).getTemplate() != null) {
            try {
                String sql = "DELETE FROM " + this.sbdb.DBTableName("CHTPREF_SCH") + " WHERE block_id=" + block.getTemplate().getID() + " AND location=" + SB.DBString((String)this.LOC_FIELD) + " AND user_id=" + this.sbdb.getUserID();
                try (Statement stmt = this.sbdb.getDatabase().createStatement();){
                    stmt.executeUpdate(this.sbdb.modQuery(sql));
                }
                this.sbdb.commit();
            }
            catch (SQLException sql) {
                FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
            }
        }
        if ((index = this.jTabbedPaneChart.indexOfComponent(sPane)) > -1) {
            this.jTabbedPaneChart.removeTabAt(index);
        }
        if (this.jTabbedPaneChart.getTabCount() == 0 && this.lastTabClosedAction != null) {
            this.lastTabClosedAction.actionPerformed(null);
        }
    }

    private void initComponents() {
        this.jPopupMenu1 = new JPopupMenu();
        this.jMenuItemCopyUnitColour = new JMenuItem();
        this.jMenuItemPasteUnitColour = new JMenuItem();
        this.jToolBar1 = new JToolBar();
        this.jButtonZoomIn = new JButton();
        this.jButtonZoomOut = new JButton();
        this.jToggleButtonFreezeHeader = new JToggleButton();
        this.jSeparator3 = new JToolBar.Separator();
        this.jButtonUndo = new JButton();
        this.jButtonRedo = new JButton();
        this.jToggleButtonInteractive = new JToggleButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.jButtonPrint = new JButton();
        this.jButtonExport = new JButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.jButtonChartProperties = new JButton();
        this.jSeparator4 = new JToolBar.Separator();
        this.jButtonOpenTemplate = new JButton();
        this.jButtonEditChart = new JButton();
        this.jButtonSaveStandardAsTemplate = new JButton();
        this.jTabbedPaneChart = new JTabbedPane();
        this.jLabelTooltip = new JLabel();
        this.jMenuItemCopyUnitColour.setText("Copy unit colour");
        this.jMenuItemCopyUnitColour.addActionListener(new ActionListener(this){
            final /* synthetic */ InternalFrameChart this$0;
            {
                InternalFrameChart internalFrameChart = this$0;
                Objects.requireNonNull(internalFrameChart);
                this.this$0 = internalFrameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemCopyUnitColourActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.jMenuItemCopyUnitColour);
        this.jMenuItemPasteUnitColour.setText("Paste unit colour");
        this.jMenuItemPasteUnitColour.addActionListener(new ActionListener(this){
            final /* synthetic */ InternalFrameChart this$0;
            {
                InternalFrameChart internalFrameChart = this$0;
                Objects.requireNonNull(internalFrameChart);
                this.this$0 = internalFrameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemPasteUnitColourActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.jMenuItemPasteUnitColour);
        this.setClosable(true);
        this.setDefaultCloseOperation(0);
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.setFrameIcon(new ImageIcon(this.getClass().getResource("/resources/icon/openTemplate16.png")));
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.jButtonZoomIn.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/ZoomIn16.png")));
        this.jButtonZoomIn.setToolTipText("Zoom in");
        this.jButtonZoomIn.setBorderPainted(false);
        this.jButtonZoomIn.setFocusable(false);
        this.jButtonZoomIn.setHorizontalTextPosition(0);
        this.jButtonZoomIn.setVerticalTextPosition(3);
        this.jButtonZoomIn.addActionListener(new ActionListener(this){
            final /* synthetic */ InternalFrameChart this$0;
            {
                InternalFrameChart internalFrameChart = this$0;
                Objects.requireNonNull(internalFrameChart);
                this.this$0 = internalFrameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonZoomInActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonZoomIn);
        this.jButtonZoomOut.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/ZoomOut16.png")));
        this.jButtonZoomOut.setToolTipText("Zoom out");
        this.jButtonZoomOut.setBorderPainted(false);
        this.jButtonZoomOut.setFocusable(false);
        this.jButtonZoomOut.setHorizontalTextPosition(0);
        this.jButtonZoomOut.setVerticalTextPosition(3);
        this.jButtonZoomOut.addActionListener(new ActionListener(this){
            final /* synthetic */ InternalFrameChart this$0;
            {
                InternalFrameChart internalFrameChart = this$0;
                Objects.requireNonNull(internalFrameChart);
                this.this$0 = internalFrameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonZoomOutActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonZoomOut);
        this.jToggleButtonFreezeHeader.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/freezePanes16.png")));
        this.jToggleButtonFreezeHeader.setToolTipText("Freeze header");
        this.jToggleButtonFreezeHeader.setFocusable(false);
        this.jToggleButtonFreezeHeader.setHorizontalTextPosition(0);
        this.jToggleButtonFreezeHeader.setVerticalTextPosition(3);
        this.jToggleButtonFreezeHeader.addActionListener(new ActionListener(this){
            final /* synthetic */ InternalFrameChart this$0;
            {
                InternalFrameChart internalFrameChart = this$0;
                Objects.requireNonNull(internalFrameChart);
                this.this$0 = internalFrameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jToggleButtonFreezeHeaderActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jToggleButtonFreezeHeader);
        this.jToolBar1.add(this.jSeparator3);
        this.jButtonUndo.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/undo16.png")));
        this.jButtonUndo.setToolTipText("Undo");
        this.jButtonUndo.setBorderPainted(false);
        this.jButtonUndo.setFocusable(false);
        this.jButtonUndo.setHorizontalTextPosition(0);
        this.jButtonUndo.setVerticalTextPosition(3);
        this.jButtonUndo.addActionListener(new ActionListener(this){
            final /* synthetic */ InternalFrameChart this$0;
            {
                InternalFrameChart internalFrameChart = this$0;
                Objects.requireNonNull(internalFrameChart);
                this.this$0 = internalFrameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonUndoActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonUndo);
        this.jButtonRedo.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/redo16.png")));
        this.jButtonRedo.setToolTipText("Redo");
        this.jButtonRedo.setBorderPainted(false);
        this.jButtonRedo.setFocusable(false);
        this.jButtonRedo.setHorizontalTextPosition(0);
        this.jButtonRedo.setVerticalTextPosition(3);
        this.jButtonRedo.addActionListener(new ActionListener(this){
            final /* synthetic */ InternalFrameChart this$0;
            {
                InternalFrameChart internalFrameChart = this$0;
                Objects.requireNonNull(internalFrameChart);
                this.this$0 = internalFrameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonRedoActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonRedo);
        this.jToggleButtonInteractive.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/hand.png")));
        this.jToggleButtonInteractive.setToolTipText("Toggle interactivity");
        this.jToggleButtonInteractive.setFocusable(false);
        this.jToggleButtonInteractive.setHorizontalTextPosition(0);
        this.jToggleButtonInteractive.setVerticalTextPosition(3);
        this.jToggleButtonInteractive.addItemListener(new ItemListener(this){
            final /* synthetic */ InternalFrameChart this$0;
            {
                InternalFrameChart internalFrameChart = this$0;
                Objects.requireNonNull(internalFrameChart);
                this.this$0 = internalFrameChart;
            }

            @Override
            public void itemStateChanged(ItemEvent evt) {
                this.this$0.jToggleButtonInteractiveItemStateChanged(evt);
            }
        });
        this.jToolBar1.add(this.jToggleButtonInteractive);
        this.jToolBar1.add(this.jSeparator1);
        this.jButtonPrint.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/print16.png")));
        this.jButtonPrint.setToolTipText("Print");
        this.jButtonPrint.setBorderPainted(false);
        this.jButtonPrint.setFocusable(false);
        this.jButtonPrint.setHorizontalTextPosition(0);
        this.jButtonPrint.setVerticalTextPosition(3);
        this.jButtonPrint.addActionListener(new ActionListener(this){
            final /* synthetic */ InternalFrameChart this$0;
            {
                InternalFrameChart internalFrameChart = this$0;
                Objects.requireNonNull(internalFrameChart);
                this.this$0 = internalFrameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonPrintActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonPrint);
        this.jButtonExport.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/export16.png")));
        this.jButtonExport.setToolTipText("Export vector image");
        this.jButtonExport.setBorderPainted(false);
        this.jButtonExport.setFocusable(false);
        this.jButtonExport.setHorizontalTextPosition(0);
        this.jButtonExport.setVerticalTextPosition(3);
        this.jButtonExport.addActionListener(new ActionListener(this){
            final /* synthetic */ InternalFrameChart this$0;
            {
                InternalFrameChart internalFrameChart = this$0;
                Objects.requireNonNull(internalFrameChart);
                this.this$0 = internalFrameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonExportActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonExport);
        this.jToolBar1.add(this.jSeparator2);
        this.jButtonChartProperties.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/chartProperties16.png")));
        this.jButtonChartProperties.setToolTipText("Block Layout Properties");
        this.jButtonChartProperties.setBorderPainted(false);
        this.jButtonChartProperties.setFocusable(false);
        this.jButtonChartProperties.setHorizontalTextPosition(0);
        this.jButtonChartProperties.setVerticalTextPosition(3);
        this.jButtonChartProperties.addActionListener(new ActionListener(this){
            final /* synthetic */ InternalFrameChart this$0;
            {
                InternalFrameChart internalFrameChart = this$0;
                Objects.requireNonNull(internalFrameChart);
                this.this$0 = internalFrameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonChartPropertiesActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonChartProperties);
        this.jToolBar1.add(this.jSeparator4);
        this.jButtonOpenTemplate.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/openTemplate16.png")));
        this.jButtonOpenTemplate.setToolTipText("Open chart template");
        this.jButtonOpenTemplate.setBorderPainted(false);
        this.jButtonOpenTemplate.setFocusable(false);
        this.jButtonOpenTemplate.setHorizontalTextPosition(0);
        this.jButtonOpenTemplate.setVerticalTextPosition(3);
        this.jButtonOpenTemplate.addActionListener(new ActionListener(this){
            final /* synthetic */ InternalFrameChart this$0;
            {
                InternalFrameChart internalFrameChart = this$0;
                Objects.requireNonNull(internalFrameChart);
                this.this$0 = internalFrameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOpenTemplateActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonOpenTemplate);
        this.jButtonEditChart.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/editChart16.png")));
        this.jButtonEditChart.setToolTipText("Edit template in Charts module...");
        this.jButtonEditChart.setBorderPainted(false);
        this.jButtonEditChart.setFocusable(false);
        this.jButtonEditChart.setHorizontalTextPosition(0);
        this.jButtonEditChart.setVerticalTextPosition(3);
        this.jButtonEditChart.addActionListener(new ActionListener(this){
            final /* synthetic */ InternalFrameChart this$0;
            {
                InternalFrameChart internalFrameChart = this$0;
                Objects.requireNonNull(internalFrameChart);
                this.this$0 = internalFrameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonEditChartActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonEditChart);
        this.jButtonSaveStandardAsTemplate.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/save16.png")));
        this.jButtonSaveStandardAsTemplate.setToolTipText("Save Untemplated chart as template...");
        this.jButtonSaveStandardAsTemplate.setBorderPainted(false);
        this.jButtonSaveStandardAsTemplate.setFocusable(false);
        this.jButtonSaveStandardAsTemplate.setHorizontalTextPosition(0);
        this.jButtonSaveStandardAsTemplate.setVerticalTextPosition(3);
        this.jButtonSaveStandardAsTemplate.addActionListener(new ActionListener(this){
            final /* synthetic */ InternalFrameChart this$0;
            {
                InternalFrameChart internalFrameChart = this$0;
                Objects.requireNonNull(internalFrameChart);
                this.this$0 = internalFrameChart;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSaveStandardAsTemplateActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonSaveStandardAsTemplate);
        this.jTabbedPaneChart.setFocusable(false);
        this.jTabbedPaneChart.addChangeListener(new ChangeListener(this){
            final /* synthetic */ InternalFrameChart this$0;
            {
                InternalFrameChart internalFrameChart = this$0;
                Objects.requireNonNull(internalFrameChart);
                this.this$0 = internalFrameChart;
            }

            @Override
            public void stateChanged(ChangeEvent evt) {
                this.this$0.jTabbedPaneChartStateChanged(evt);
            }
        });
        this.jLabelTooltip.setText("~~~~~~~~~~~~~");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPaneChart).addGroup(layout.createSequentialGroup().addComponent(this.jToolBar1, -2, 428, -2).addGap(0, 253, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabelTooltip).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jToolBar1, -2, 31, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTabbedPaneChart, -1, 532, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelTooltip, -2, 19, -2)));
        this.pack();
    }

    private void jButtonZoomInActionPerformed(ActionEvent evt) {
        this.zoom(true);
    }

    private void jButtonZoomOutActionPerformed(ActionEvent evt) {
        this.zoom(false);
    }

    private void jButtonOpenTemplateActionPerformed(ActionEvent evt) {
        this.openTemplate();
    }

    private void jButtonChartPropertiesActionPerformed(ActionEvent evt) {
        this.chartProperties();
    }

    private void jButtonPrintActionPerformed(ActionEvent evt) {
        try {
            this.printChart(this.sbdb, this.parent);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void jButtonExportActionPerformed(ActionEvent evt) {
        try {
            this.exportChart(this.sbdb, this.parent);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void jToggleButtonFreezeHeaderActionPerformed(ActionEvent evt) {
        JScrollPaneChart sPane = (JScrollPaneChart)this.jTabbedPaneChart.getSelectedComponent();
        sPane.setHeader(true, this.jToggleButtonFreezeHeader.isSelected());
        sPane.refreshView();
    }

    private void jTabbedPaneChartStateChanged(ChangeEvent evt) {
        if (this.jTabbedPaneChart.getSelectedComponent() != null) {
            JScrollPaneChart sPane = (JScrollPaneChart)this.jTabbedPaneChart.getSelectedComponent();
            this.jToggleButtonFreezeHeader.setSelected(sPane.hasHeader());
            this.jButtonSaveStandardAsTemplate.setVisible(sPane.getChart().getBlockSingle().getTemplate() == null);
            this.jButtonEditChart.setVisible(sPane.getChart().getBlockSingle().getTemplate() != null);
        }
    }

    private void jButtonUndoActionPerformed(ActionEvent evt) {
        this.undoRedo(true);
    }

    private void jButtonRedoActionPerformed(ActionEvent evt) {
        this.undoRedo(false);
    }

    void showPopup(MouseEvent evt) {
        if (!evt.isPopupTrigger()) {
            return;
        }
        this.popupPoint = evt.getPoint();
        JScrollPaneChart scrollPane = (JScrollPaneChart)this.jTabbedPaneChart.getSelectedComponent();
        ChartPanel panel = scrollPane.getSelectedPanel(evt);
        if (panel == null) {
            return;
        }
        Object obj = scrollPane.getObject(evt);
        if (obj instanceof IGDUnit) {
            this.jPopupMenu1.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void jMenuItemCopyUnitColourActionPerformed(ActionEvent evt) {
        JScrollPaneChart scrollPane = (JScrollPaneChart)this.jTabbedPaneChart.getSelectedComponent();
        if (scrollPane == null) {
            return;
        }
        Object o = scrollPane.getObject(this.popupPoint);
        if (o != null && o instanceof IGDUnit) {
            this.copiedColour = ((IGDUnit)o).getColour();
            int d = 10;
            BufferedImage bufferedImage = new BufferedImage(d, d, 1);
            Graphics2D g = bufferedImage.createGraphics();
            AffineTransform tnf = new AffineTransform();
            tnf.scale(0.01f, 0.01f);
            g.transform(tnf);
            SBGraphics sbg = new SBGraphics(g, null, true, true);
            sbg.setColor(this.copiedColour);
            sbg.fillRect(0.0f, 0.0f, d, d);
            ImageIcon icon = new ImageIcon(bufferedImage);
            this.jMenuItemPasteUnitColour.setIcon(icon);
        }
    }

    private void jMenuItemPasteUnitColourActionPerformed(ActionEvent evt) {
        if (this.copiedColour == null) {
            return;
        }
        JScrollPaneChart scrollPane = (JScrollPaneChart)this.jTabbedPaneChart.getSelectedComponent();
        if (scrollPane == null) {
            return;
        }
        Object o = scrollPane.getObject(this.popupPoint);
        if (o != null && o instanceof IGDUnit) {
            IGDUnit unit = (IGDUnit)o;
            try {
                unit.setColour(this.copiedColour);
                this.sbdb.commit();
            }
            catch (SQLException sql) {
                this.sbdb.doRollback();
                FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
            }
            scrollPane.repaint();
        }
    }

    private void jButtonEditChartActionPerformed(ActionEvent evt) {
        BlockTemplate template = null;
        if (this.getChart().getTemplate() != null) {
            assert (false);
        } else if (this.getChart().getBlockSingle() != null) {
            template = this.getChart().getBlockSingle().getTemplate();
        }
        if (template != null) {
            FrameJsbugs parentParent = null;
            if (this.parent instanceof FrameTaxaDB) {
                parentParent = ((FrameTaxaDB)this.parent).getParent();
            } else if (this.parent instanceof FrameInterpretations) {
                parentParent = ((FrameInterpretations)this.parent).getParent();
            }
            if (parentParent != null) {
                parentParent.openCharts(template);
            }
        } else assert (false);
    }

    private void jButtonSaveStandardAsTemplateActionPerformed(ActionEvent evt) {
        Chart chart = this.getChart();
        if (chart.getTemplate() != null || chart.getBlockSingle().getTemplate() != null) {
            return;
        }
        DialogChartDesc dialog = new DialogChartDesc(this.parent, "Template : Add : " + String.valueOf(BlockType.SCHEME), "New " + String.valueOf(BlockType.SCHEME), null, true, false);
        try {
            dialog.restrictProjectToGlobal();
        }
        catch (SQLException ex) {
            FrameJsbugs.showStackError("Error loading projects", ex, this.sbdb);
            return;
        }
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (!dialog.isOK()) {
            return;
        }
        try {
            BlockTemplate template = TemplateFactory.newBlockTemplate(this.chartManager, BlockType.SCHEME, dialog.name, dialog.comments, dialog.projID);
            this.chartManager.addBlockTemplate(template);
            ChartBlock block = (ChartBlock)chart.getBlockSingle();
            ArrayList<PanelOcc> panelOccs = new ArrayList<PanelOcc>();
            for (SBPanel panel : block.getPanels()) {
                panelOccs.add(panel.getPanelOcc());
            }
            template.updatePanels(this.sbdb, BlockTemplate.createPanelOccUpdates(panelOccs));
            this.sbdb.commit();
            template.notifyObservers();
            this.closeTab((JScrollPaneChart)this.jTabbedPaneChart.getSelectedComponent(), true);
            ChartTemplate.BlockOcc occ = new ChartTemplate.BlockOcc(template.getID(), block.getWell() != null ? block.getWell().getWellID() : 0, block.getWellListID(), block.getInterpID(), block.getProperties(), block.getCaption());
            this.addBlockTemplateTab(template, occ, chart.getProperties().getProperties(), true, null, null, 0);
        }
        catch (InvalidFieldException ife) {
            JOptionPane.showMessageDialog(this, ife.getMessage(), this.getTitle(), 0);
        }
        catch (SQLException | SBException | SBPermissionException sql) {
            FrameJsbugs.showStackError("Error", (Exception)sql, this.sbdb);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void jToggleButtonInteractiveItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 2) {
            assert (!this.jToggleButtonInteractive.isSelected());
            System.out.println("Not selected");
            for (int i = 0; i < this.jTabbedPaneChart.getTabCount(); ++i) {
                JScrollPaneChart sPane = (JScrollPaneChart)this.jTabbedPaneChart.getComponentAt(i);
                try {
                    sPane.getChart().setData();
                    sPane.repaint();
                    continue;
                }
                catch (IOException | SQLException | SBException e) {
                    FrameJsbugs.showStackError("Error setting data for " + this.jTabbedPaneChart.getTitleAt(i), (Exception)e, this.sbdb);
                }
            }
        }
    }

    void openTemplate() {
        DialogChartTemplates dialog = new DialogChartTemplates(this.parent, true, this.sbdb, this.chartManager, BlockType.SCHEME, null, null);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.selection != null && dialog.selection.size() == 1 && dialog.selection.get(0) instanceof BlockTemplate) {
            BlockTemplate templ = (BlockTemplate)dialog.selection.get(0);
            this.addBlockTemplateTab(templ, null, null, true, null, null, 0);
        }
    }

    void addBlockTemplateTab(BlockTemplate templ, ChartTemplate.BlockOcc occ, String chartProp, boolean storeDB, String header, String key, int schID) {
        block10: {
            for (Component c : this.jTabbedPaneChart.getComponents()) {
                Chart chart;
                if (!(c instanceof JScrollPaneChart) || (chart = ((JScrollPaneChart)c).getChart()).getBlockSingle() == null || chart.getBlockSingle().getTemplate() != templ) continue;
                this.jTabbedPaneChart.setSelectedComponent(c);
                return;
            }
            try {
                Chart chart = ChartFactory.createChart(templ, this.chartManager, this.sbdb, chartProp, header, key, schID, occ);
                chart.setData();
                JScrollPaneChart scrollPane = new JScrollPaneChart(new InteractiveChartJPanelScheme(chart, this));
                scrollPane.setBorder(null);
                scrollPane.refreshView();
                scrollPane.registerDragRecognizer(this);
                this.jTabbedPaneChart.addTab(templ.toString(), scrollPane);
                int index = this.jTabbedPaneChart.indexOfComponent(scrollPane);
                this.jTabbedPaneChart.setTabComponentAt(index, new TabTitle(this, templ.toString()));
                this.jTabbedPaneChart.setSelectedComponent(scrollPane);
                if (!storeDB) break block10;
                String sql = "INSERT INTO " + this.sbdb.DBTableName("CHTPREF_SCH") + "(block_id,user_id,location,b_prop,c_prop,header,cht_key,sch_id) VALUES (" + templ.getID() + "," + this.sbdb.getUserID() + "," + SB.DBString((String)this.LOC_FIELD) + "," + SB.DBString((String)chart.getBlockSingle().getProperties()) + "," + SB.DBString((String)chart.getProperties().getProperties()) + "," + SB.DBString((String)chart.getProperties().getHeader()) + "," + SB.DBString((String)chart.getProperties().getKey()) + "," + String.valueOf(chart.getProperties().bgSchID > 0 ? Integer.valueOf(chart.getProperties().bgSchID) : "NULL") + ")";
                try (Statement stmt = this.sbdb.getDatabase().createStatement();){
                    stmt.executeUpdate(this.sbdb.modQuery(sql));
                    this.sbdb.commit();
                }
            }
            catch (SQLException sql) {
                FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
            }
            catch (IOException | SBException sbe) {
                StackError.showStackError((String)"Error", (Throwable)sbe);
            }
        }
    }

    @Override
    public void chartProperties() {
        block13: {
            Chart chart = this.getChart();
            if (chart == null) {
                return;
            }
            try {
                ChartBlock block = null;
                if (chart.getTemplate() == null) {
                    block = (ChartBlock)chart.getBlockSingle();
                }
                DialogChartProperties dialog = new DialogChartProperties(this.parent, true, chart.getProperties(), this.sbdb, block, true, true, true, false);
                dialog.setLocationRelativeTo(this.parent);
                dialog.setVisible(true);
                if (!dialog.isOK() || block == null || block.getTemplate() == null) break block13;
                try {
                    chart.setData();
                    ((JScrollPaneChart)this.jTabbedPaneChart.getSelectedComponent()).refreshView();
                    String sql = "UPDATE " + this.sbdb.DBTableName("CHTPREF_SCH") + " set well_id=" + String.valueOf(block.getWellList() == null && block.getWell() != null ? Integer.valueOf(block.getWell().getWellID()) : "NULL") + ",wellist_id=" + String.valueOf(block.getWellList() != null ? Integer.valueOf(block.getWellListID()) : "NULL") + ",interp_id=" + String.valueOf(block.getInterpID() > 0 ? Integer.valueOf(block.getInterpID()) : "NULL") + ",b_prop=" + SB.DBString((String)block.getProperties()) + ",c_prop=" + SB.DBString((String)chart.getProperties().getProperties()) + ",header=" + SB.DBString((String)chart.getProperties().getHeader()) + ",cht_key=" + SB.DBString((String)chart.getProperties().getKey()) + ",sch_id=" + String.valueOf(chart.getProperties().bgSchID > 0 ? Integer.valueOf(chart.getProperties().bgSchID) : "NULL") + " WHERE block_id=" + block.getTemplate().getID() + " AND user_id=" + this.sbdb.getUserID() + " AND location=" + SB.DBString((String)this.LOC_FIELD);
                    try (Statement stmt = this.sbdb.getDatabase().createStatement();){
                        stmt.executeUpdate(this.sbdb.modQuery(sql));
                        this.sbdb.commit();
                    }
                }
                catch (SQLException sql) {
                    FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
                }
                catch (IOException | SBException sbe) {
                    StackError.showStackError((String)"Error", (Throwable)sbe);
                }
            }
            catch (RuntimeException re) {
                StackError.showStackError((String)"", (Throwable)re);
            }
        }
    }

    void addStandardSchemePanels(List<PanelTemplate> panels, float minAge, float maxAge) {
        JScrollPaneChart scrollPane;
        ChartBlock block;
        Chart sChart = null;
        for (Component c : this.jTabbedPaneChart.getComponents()) {
            Chart chart;
            if (!(c instanceof JScrollPaneChart) || (chart = ((JScrollPaneChart)c).getChart()).getBlockSingle() == null || chart.getBlockSingle().getTemplate() != null) continue;
            sChart = chart;
            break;
        }
        if (sChart == null) {
            block = new SchemeBlock(this.sbdb);
            block.getProp().setLimits(minAge, maxAge);
            block.getProp().setScale(SchemeBlock.calcIdealScale(minAge, maxAge));
            sChart = new Chart();
            sChart.getProperties().margin = 5.0f;
            sChart.getProperties().setPanelHeaderHeight(75.0f);
            sChart.getProperties().setPanelCaptionHeight(9.0f);
            sChart.getProperties().plotBlockCaptions = false;
            sChart.addBlock(block);
            scrollPane = new JScrollPaneChart(new InteractiveChartJPanelScheme(sChart, this));
            scrollPane.setBorder(null);
            scrollPane.refreshView();
            scrollPane.registerDragRecognizer(this);
            this.jTabbedPaneChart.insertTab("Untemplated", null, scrollPane, null, 0);
            int index = this.jTabbedPaneChart.indexOfComponent(scrollPane);
            this.jTabbedPaneChart.setTabComponentAt(index, new TabTitle(this, "Untemplated"));
            this.jTabbedPaneChart.setSelectedComponent(scrollPane);
        } else {
            int opt;
            block = (ChartBlock)sChart.getBlockSingle();
            Iterator<PanelTemplate> lit = panels.listIterator();
            block3: while (lit.hasNext()) {
                PanelTemplate templ = lit.next();
                for (SBPanel p : block.getPanels()) {
                    if (p.getTemplateID().intValue() != templ.getID()) continue;
                    JOptionPane.showMessageDialog(this, "'" + templ.getName() + "' is already plotted.", this.getTitle(), 2);
                    lit.remove();
                    continue block3;
                }
            }
            if (panels.isEmpty()) {
                return;
            }
            if ((block.getProp().getMin() > minAge || block.getProp().getMax() < maxAge) && (opt = JOptionPane.showConfirmDialog(this, "Expand age range to " + minAge + " - " + maxAge + " Ma?", "Plot Schemes", 0)) == 0) {
                block.getProp().setLimits(minAge, maxAge);
            }
        }
        try {
            block = (ChartBlock)sChart.getBlockSingle();
            for (PanelTemplate templ : panels) {
                block.addPanel((SBPanel)PanelFactory.createPanel(block, templ, null));
            }
            sChart.setData();
            scrollPane = (JScrollPaneChart)this.jTabbedPaneChart.getSelectedComponent();
            scrollPane.refreshView();
        }
        catch (IOException | SQLException | SBException e) {
            FrameJsbugs.showStackError("Error", (Exception)e, this.sbdb);
        }
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dge) {
        Object o;
        JScrollPaneChart sPane;
        Cursor cursor = null;
        if (dge.getDragAction() == 2) {
            cursor = DragSource.DefaultCopyDrop;
        }
        if ((sPane = (JScrollPaneChart)this.jTabbedPaneChart.getSelectedComponent()) == null || dge.getTriggerEvent().isAltDown()) {
            return;
        }
        ChartPanel panel = sPane.getSelectedPanel(dge.getDragOrigin());
        if (panel != null && panel instanceof PanelRange && (o = sPane.getObject(dge)) instanceof PanelRange.EventRange) {
            PanelRange.EventRange er = (PanelRange.EventRange)o;
            if (er.event.getTaxon() != null) {
                this.txDragOrigin = er.event.getTaxon();
                TaxonTransferHandler h = (TaxonTransferHandler)this.getTransferHandler();
                dge.startDrag(cursor, h.createTransferable(this));
            }
        }
        this.txDragOrigin = null;
    }

    @Override
    public void chartWillBeDeleted(int chartTemplateID) {
        for (int i = 0; i < this.jTabbedPaneChart.getTabCount(); ++i) {
            JScrollPaneChart pane = (JScrollPaneChart)this.jTabbedPaneChart.getComponentAt(i);
            if (pane.getChart().getTemplate() == null || pane.getChart().getTemplate().getID() != chartTemplateID) continue;
            this.jTabbedPaneChart.remove(pane);
            return;
        }
    }

    @Override
    public void blockWillBeDeleted(int blockTemplateID, boolean fromRefresh) {
        for (int i = 1; i < this.jTabbedPaneChart.getTabCount(); ++i) {
            JScrollPaneChart sPane = (JScrollPaneChart)this.jTabbedPaneChart.getComponentAt(i);
            if (sPane.getChart().getTemplate() != null || sPane.getChart().getBlockSingle().getTemplate().getID() != blockTemplateID) continue;
            this.closeTab(sPane, true);
            return;
        }
    }

    @Override
    public void wellWillBeDeleted(int wellID) {
        for (int i = 1; i < this.jTabbedPaneChart.getTabCount(); ++i) {
            JScrollPaneChart sPane = (JScrollPaneChart)this.jTabbedPaneChart.getComponentAt(i);
            if (sPane.getChart().getTemplate() != null) continue;
            sPane.getChart().wellDeleted(wellID);
        }
    }

    @Override
    public void templateWellBlockRemovedFromChart(int chartTemplateID) {
    }

    @Override
    public void panelTemplateWillBeDeleted(int panelTemplateID) {
        ChartBlock standardBlock = null;
        JScrollPaneChart sPane = null;
        for (Component c : this.jTabbedPaneChart.getComponents()) {
            Chart chart;
            if (!(c instanceof JScrollPaneChart) || (chart = ((JScrollPaneChart)c).getChart()).getBlockSingle() == null || chart.getBlockSingle().getTemplate() != null) continue;
            standardBlock = (ChartBlock)chart.getBlockSingle();
            sPane = (JScrollPaneChart)c;
            break;
        }
        if (standardBlock == null) {
            return;
        }
        ArrayList<SBPanel> panelsToRemove = new ArrayList<SBPanel>();
        for (SBPanel p : standardBlock.getPanels()) {
            if (p.getTemplateID() != panelTemplateID) continue;
            panelsToRemove.add(p);
        }
        for (SBPanel p : panelsToRemove) {
            standardBlock.removePanel(p);
        }
        if (standardBlock.getPanels().isEmpty()) {
            this.closeTab(sPane, true);
        }
    }

    @Override
    public void templateDescrUpdated(TemplateDescr template) {
    }

    @Override
    public void templateAdded(TemplateDescr template) {
    }

    @Override
    public void corrTemplateWillBeDeleted(int corrID) {
    }

    @Override
    public void wellWillbeRemovedFromProject(int wellID, int projID) {
    }

    static InternalFrameChart createLoadedInstance(String prefString, JFrame parent, SBdb sbdb, ChartManager chartManager, String title, Action lastTabClosedAction) {
        InternalFrameChart internalFrameChart;
        block10: {
            String sql = "SELECT block_id,well_id,wellist_id,interp_id,b_prop,c_prop,header,cht_key,sch_id FROM " + sbdb.DBTableName("CHTPREF_SCH") + " WHERE user_id=" + sbdb.getUserID() + " AND location=" + SB.DBString((String)prefString.toUpperCase());
            Statement stmt = sbdb.getDatabase().createStatement();
            try {
                ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
                InternalFrameChart frame = null;
                while (rs.next()) {
                    if (frame == null) {
                        frame = new InternalFrameChart(parent, sbdb, chartManager, title, lastTabClosedAction, prefString);
                    }
                    BlockTemplate templ = chartManager.getBlockTemplate(rs.getInt("block_id"));
                    int wellID = rs.getInt("well_id");
                    int wellListID = rs.getInt("wellist_id");
                    int interpID = rs.getInt("interp_id");
                    String bProp = rs.getString("b_prop");
                    String cProp = rs.getString("c_prop");
                    String header = rs.getString("header");
                    String key = rs.getString("cht_key");
                    int schID = rs.getInt("sch_id");
                    if (templ == null) continue;
                    ChartTemplate.BlockOcc occ = new ChartTemplate.BlockOcc(templ.getID(), wellID, wellListID, interpID, bProp, null);
                    frame.addBlockTemplateTab(templ, occ, cProp, false, header, key, schID);
                }
                internalFrameChart = frame;
                if (stmt == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException sqle) {
                    SbugsExceptionHandler.showStackError("Error loading saved chart tabs", sqle, parent);
                    return null;
                }
            }
            stmt.close();
        }
        return internalFrameChart;
    }

    boolean hasCharts() {
        return this.jTabbedPaneChart.getTabCount() > 0;
    }

    private class TabTitle
    extends JPanel {
        final JLabel label;
        final /* synthetic */ InternalFrameChart this$0;

        TabTitle(InternalFrameChart internalFrameChart, String labelText) {
            InternalFrameChart internalFrameChart2 = internalFrameChart;
            Objects.requireNonNull(internalFrameChart2);
            this.this$0 = internalFrameChart2;
            super(new BorderLayout(5, 0));
            this.setOpaque(false);
            this.label = new JLabel(labelText);
            this.add((Component)this.label, "West");
            Icon closeTabIcon = IconFactory.getIcon("closeTab");
            JButton closeButton = new JButton(closeTabIcon);
            closeButton.setRolloverIcon(IconFactory.getIcon("closeTabRollover"));
            closeButton.setRolloverEnabled(true);
            closeButton.setFocusable(false);
            closeButton.setBorderPainted(false);
            closeButton.addActionListener(new ActionListener(this){
                final /* synthetic */ TabTitle this$1;
                {
                    TabTitle tabTitle = this$1;
                    Objects.requireNonNull(tabTitle);
                    this.this$1 = tabTitle;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    int index = this.this$1.this$0.jTabbedPaneChart.indexOfTabComponent(this.this$1);
                    this.this$1.this$0.closeTab((JScrollPaneChart)this.this$1.this$0.jTabbedPaneChart.getComponentAt(index), false);
                }
            });
            closeButton.setPreferredSize(new Dimension(closeTabIcon.getIconWidth(), closeTabIcon.getIconHeight()));
            closeButton.setContentAreaFilled(false);
            this.add((Component)closeButton, "East");
        }

        void updateLabel(String newLabel) {
            this.label.setText(newLabel);
        }
    }
}

