/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.util.ui.table.TableUtils;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JInternalFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import jsbchart.core.ChartManager;
import jsbchart.core.PanelTemplate;
import jsbchart.correlation.CorrelationType;
import jsbchart.panel.PanelType;
import jsbugs.DialogEnvReassign;
import jsbugs.DialogEnvScheme;
import jsbugs.DialogList;
import jsbugs.DialogPermissions;
import jsbugs.DialogTable;
import jsbugs.FrameInterpretations;
import jsbugs.FrameJsbugs;
import jsbugs.list.RestrictableListRenderer;
import jsbugs.userconnect.SbugsExceptionHandler;
import jsbugs.util.UserPrefsHelper;
import model3.EnvScheme;
import model3.SBRestrictable;
import model3.SBdb;
import org.jdesktop.layout.GroupLayout;
import util.SBException;
import util.SBPermissionException;
import util.exception.StackError;

public class InternalFrameEnvSchemes
extends JInternalFrame
implements Observer {
    private final SBdb db;
    private final DefaultListModel model = new DefaultListModel();
    private final JCheckBoxMenuItem menuCheckBox;
    private final FrameInterpretations parent;
    private JButton jButtonAdd;
    private JButton jButtonCharts;
    private JButton jButtonClose;
    private JButton jButtonDelete;
    private JButton jButtonEdit;
    private JButton jButtonPermissions;
    private JButton jButtonReassign;
    private JButton jButtonWells;
    private JList jListSchemes;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;

    public InternalFrameEnvSchemes(FrameInterpretations parent, SBdb db, JCheckBoxMenuItem menuCheckBox) throws SQLException {
        this.db = db;
        this.menuCheckBox = menuCheckBox;
        this.parent = parent;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException {
        this.setTitle("Palaeoenvironment Schemes");
        this.refreshList();
        this.db.addObserver(this);
        if (!SBRestrictable.canWrite(this.db)) {
            this.jButtonDelete.setEnabled(false);
        }
        this.jListSchemes.setCellRenderer(new RestrictableListRenderer());
    }

    private void refreshList() throws SQLException {
        this.model.removeAllElements();
        List<EnvScheme> list = this.db.getEnvSchemes();
        for (EnvScheme scheme : list) {
            this.model.addElement(scheme);
        }
        this.jListSchemes.repaint();
    }

    @Override
    public void update(Observable obs, Object o) {
        if (o instanceof EnvScheme) {
            if (obs == this.db) {
                try {
                    this.refreshList();
                }
                catch (SQLException e) {
                    System.out.println("From InternalFrameEnvScheme.update");
                    e.printStackTrace();
                }
            } else {
                this.jListSchemes.repaint();
            }
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jListSchemes = new JList();
        this.jButtonAdd = new JButton();
        this.jButtonEdit = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonWells = new JButton();
        this.jButtonClose = new JButton();
        this.jButtonReassign = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jButtonPermissions = new JButton();
        this.jButtonCharts = new JButton();
        this.setClosable(true);
        this.setDefaultCloseOperation(0);
        this.setIconifiable(true);
        this.setResizable(true);
        this.setFrameIcon(new ImageIcon(this.getClass().getResource("/resources/icon/InternalFrameEnvScheme.png")));
        this.setMinimumSize(new Dimension(350, 250));
        this.addInternalFrameListener(new InternalFrameListener(this){
            final /* synthetic */ InternalFrameEnvSchemes this$0;
            {
                InternalFrameEnvSchemes internalFrameEnvSchemes = this$0;
                Objects.requireNonNull(internalFrameEnvSchemes);
                this.this$0 = internalFrameEnvSchemes;
            }

            @Override
            public void internalFrameActivated(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameClosed(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameClosing(InternalFrameEvent evt) {
                this.this$0.formInternalFrameClosing(evt);
            }

            @Override
            public void internalFrameDeactivated(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameDeiconified(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameIconified(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameOpened(InternalFrameEvent evt) {
            }
        });
        this.jListSchemes.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.jListSchemes.setModel(this.model);
        this.jListSchemes.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ InternalFrameEnvSchemes this$0;
            {
                InternalFrameEnvSchemes internalFrameEnvSchemes = this$0;
                Objects.requireNonNull(internalFrameEnvSchemes);
                this.this$0 = internalFrameEnvSchemes;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.this$0.jListSchemesMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jListSchemes);
        this.jButtonAdd.setText("Add...");
        this.jButtonAdd.addActionListener(new ActionListener(this){
            final /* synthetic */ InternalFrameEnvSchemes this$0;
            {
                InternalFrameEnvSchemes internalFrameEnvSchemes = this$0;
                Objects.requireNonNull(internalFrameEnvSchemes);
                this.this$0 = internalFrameEnvSchemes;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAddActionPerformed(evt);
            }
        });
        this.jButtonEdit.setText("Edit...");
        this.jButtonEdit.addActionListener(new ActionListener(this){
            final /* synthetic */ InternalFrameEnvSchemes this$0;
            {
                InternalFrameEnvSchemes internalFrameEnvSchemes = this$0;
                Objects.requireNonNull(internalFrameEnvSchemes);
                this.this$0 = internalFrameEnvSchemes;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonEditActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.addActionListener(new ActionListener(this){
            final /* synthetic */ InternalFrameEnvSchemes this$0;
            {
                InternalFrameEnvSchemes internalFrameEnvSchemes = this$0;
                Objects.requireNonNull(internalFrameEnvSchemes);
                this.this$0 = internalFrameEnvSchemes;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonWells.setText("Show wells...");
        this.jButtonWells.setToolTipText("Display wells where selected scheme is used");
        this.jButtonWells.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonWells.addActionListener(new ActionListener(this){
            final /* synthetic */ InternalFrameEnvSchemes this$0;
            {
                InternalFrameEnvSchemes internalFrameEnvSchemes = this$0;
                Objects.requireNonNull(internalFrameEnvSchemes);
                this.this$0 = internalFrameEnvSchemes;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonWellsActionPerformed(evt);
            }
        });
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(this){
            final /* synthetic */ InternalFrameEnvSchemes this$0;
            {
                InternalFrameEnvSchemes internalFrameEnvSchemes = this$0;
                Objects.requireNonNull(internalFrameEnvSchemes);
                this.this$0 = internalFrameEnvSchemes;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCloseActionPerformed(evt);
            }
        });
        this.jButtonReassign.setText("Reassign...");
        this.jButtonReassign.setToolTipText("Reassign the scheme well intervals to another scheme, and delete the scheme");
        this.jButtonReassign.addActionListener(new ActionListener(this){
            final /* synthetic */ InternalFrameEnvSchemes this$0;
            {
                InternalFrameEnvSchemes internalFrameEnvSchemes = this$0;
                Objects.requireNonNull(internalFrameEnvSchemes);
                this.this$0 = internalFrameEnvSchemes;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonReassignActionPerformed(evt);
            }
        });
        this.jButtonPermissions.setText("Permissions...");
        this.jButtonPermissions.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonPermissions.addActionListener(new ActionListener(this){
            final /* synthetic */ InternalFrameEnvSchemes this$0;
            {
                InternalFrameEnvSchemes internalFrameEnvSchemes = this$0;
                Objects.requireNonNull(internalFrameEnvSchemes);
                this.this$0 = internalFrameEnvSchemes;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonPermissionsActionPerformed(evt);
            }
        });
        this.jButtonCharts.setText("<html>Show charts<br>&amp; templates...</html>");
        this.jButtonCharts.setMargin(new Insets(2, 10, 2, 10));
        this.jButtonCharts.addActionListener(new ActionListener(this){
            final /* synthetic */ InternalFrameEnvSchemes this$0;
            {
                InternalFrameEnvSchemes internalFrameEnvSchemes = this$0;
                Objects.requireNonNull(internalFrameEnvSchemes);
                this.this$0 = internalFrameEnvSchemes;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonChartsActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -1, 265, Short.MAX_VALUE).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(2, false).add((Component)this.jButtonClose, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonWells, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonAdd, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonEdit, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonDelete, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonReassign, -1, -1, Short.MAX_VALUE).add((Component)this.jSeparator1).add((Component)this.jButtonPermissions, -1, -1, Short.MAX_VALUE).add(1, (Component)this.jButtonCharts)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.jScrollPane1, -1, 266, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonAdd).addPreferredGap(0).add((Component)this.jButtonEdit).addPreferredGap(0).add((Component)this.jButtonDelete).addPreferredGap(1).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0).add((Component)this.jButtonWells).addPreferredGap(0).add((Component)this.jButtonCharts, -2, -1, -2).addPreferredGap(0, 24, Short.MAX_VALUE).add((Component)this.jButtonReassign).addPreferredGap(0).add((Component)this.jButtonPermissions).addPreferredGap(1).add((Component)this.jButtonClose))).addContainerGap()));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.menuCheckBox.setSelected(false);
        this.setVisible(false);
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        DialogEnvScheme dialog = new DialogEnvScheme(this.parent, true, this.db, null);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.isOK()) {
            EnvScheme envScheme;
            for (int index = 0; index < this.model.getSize() && (envScheme = (EnvScheme)this.model.get(index)).getName().compareToIgnoreCase(dialog.newScheme.getName()) <= 0; ++index) {
            }
            this.jListSchemes.setSelectedValue(dialog.newScheme, true);
            dialog.newScheme.addObserver(this);
        }
    }

    private void jButtonEditActionPerformed(ActionEvent evt) {
        if (this.jListSchemes.getSelectedValue() == null) {
            JOptionPane.showMessageDialog(this, "Select a scheme", this.getTitle(), 2);
            return;
        }
        EnvScheme scheme = (EnvScheme)this.jListSchemes.getSelectedValue();
        DialogEnvScheme dialog = new DialogEnvScheme(this.parent, true, this.db, scheme);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        this.jListSchemes.repaint();
    }

    private void formInternalFrameClosing(InternalFrameEvent evt) {
        this.jButtonCloseActionPerformed(null);
    }

    private void jListSchemesMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonEditActionPerformed(null);
        }
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        if (this.jListSchemes.getSelectedValue() == null) {
            JOptionPane.showMessageDialog(this, "No scheme selected", this.getTitle(), 2);
            return;
        }
        EnvScheme scheme = (EnvScheme)this.jListSchemes.getSelectedValue();
        try {
            if (!scheme.canWrite(this.db, null)) {
                JOptionPane.showMessageDialog(this, scheme.getDeniedReason(this.db, "scheme", false), this.getTitle(), 2);
                return;
            }
            List<ChartManager.ChartOcc> usages = this.parent.parent.getChartManager().getEnvSchemeUsages(scheme.getID());
            if (usages.size() > 0) {
                JOptionPane.showMessageDialog(this, "You can't delete this scheme because it is used in charts.", "Delete Scheme", 2);
                return;
            }
            int occs = scheme.getNoccs();
            int nHdrOccs = scheme.getNAnalyHdrOccs();
            if (nHdrOccs > 0) {
                String msg = "This scheme is referenced by " + nHdrOccs + " analysis suite" + (nHdrOccs > 1 ? "s" : "") + ".\nYou must remove " + (nHdrOccs > 1 ? "these references" : "this reference") + " before you can delete the scheme.";
                JOptionPane.showMessageDialog(this.parent, msg, this.getTitle(), 2);
                return;
            }
            Object msg = occs > 0 ? "This scheme is linked to " + occs + " intervals in the database. Deleting the scheme will delete these entries.\n" : "This scheme is not used in any wells.\n";
            if (JOptionPane.showConfirmDialog(this, (String)(msg = (String)msg + "This scheme is not referenced by any analysis suites.\n") + "Really delete scheme '" + String.valueOf(scheme) + "'?", this.getTitle(), 0, 3) == 0) {
                this.db.deleteEnvScheme(scheme);
                this.db.commit();
                scheme.notifyObservers();
                scheme.deleteObservers();
                this.model.removeElement(scheme);
            }
        }
        catch (SQLException | SBException | SBPermissionException sql) {
            FrameJsbugs.showStackError("SQL Error", (Exception)sql, this.db);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void jButtonWellsActionPerformed(ActionEvent evt) {
        Object object = this.jListSchemes.getSelectedValue();
        if (object == null) {
            JOptionPane.showMessageDialog(this, "No scheme selected", this.parent.getTitle(), 1);
            return;
        }
        try {
            EnvScheme scheme = (EnvScheme)object;
            List occs = scheme.getOccs(0);
            if (occs == null || occs.isEmpty()) {
                JOptionPane.showMessageDialog(this, "Scheme does not occur in any wells or outcrops.", scheme.toString(), 1);
            } else {
                DialogList.displayListDialog(this.parent, scheme.toString(), new UserPrefsHelper(this.db), occs, null);
            }
        }
        catch (SQLException sql) {
            SbugsExceptionHandler.showStackError(sql, this.parent);
        }
    }

    private void jButtonReassignActionPerformed(ActionEvent evt) {
        Object object = this.jListSchemes.getSelectedValue();
        if (object == null) {
            JOptionPane.showMessageDialog(this, "No scheme selected", this.parent.getTitle(), 1);
            return;
        }
        try {
            EnvScheme scheme = (EnvScheme)object;
            this.setCursor(Cursor.getPredefinedCursor(3));
            DialogEnvReassign dialog = new DialogEnvReassign(this.parent, true, this.db, scheme);
            dialog.setLocationRelativeTo(this);
            this.setCursor(Cursor.getDefaultCursor());
            dialog.setVisible(true);
            if (dialog.isOK()) {
                this.refreshList();
            }
        }
        catch (SQLException | SBException sql) {
            FrameJsbugs.showStackError("Error", (Exception)sql, this.db);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void jButtonPermissionsActionPerformed(ActionEvent evt) {
        Object object = this.jListSchemes.getSelectedValue();
        if (object == null) {
            JOptionPane.showMessageDialog(this, "No scheme selected", this.parent.getTitle(), 1);
            return;
        }
        try {
            EnvScheme scheme = (EnvScheme)object;
            DialogPermissions dialog = new DialogPermissions(this.parent, true, this.db, (SBRestrictable)scheme, this.parent.parent.getChartManager());
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.isOK()) {
                this.jListSchemes.repaint();
            }
        }
        catch (SQLException | SBException sql) {
            FrameJsbugs.showStackError("Error", (Exception)sql, this.db);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void jButtonChartsActionPerformed(ActionEvent evt) {
        if (this.jListSchemes.getSelectedValue() == null || this.jListSchemes.getSelectedIndices().length > 1) {
            JOptionPane.showMessageDialog(this, "Select a scheme", this.getTitle(), 2);
            return;
        }
        Object o = this.jListSchemes.getSelectedValue();
        try {
            if (!(o instanceof EnvScheme)) {
                return;
            }
            EnvScheme scheme = (EnvScheme)o;
            final List<ChartManager.ChartOcc> usages = this.parent.parent.getChartManager().getEnvSchemeUsages(scheme.getID());
            if (usages.isEmpty()) {
                JOptionPane.showMessageDialog(this, String.valueOf(o) + " is not used in charts.", this.getTitle(), 1);
                return;
            }
            AbstractTableModel abModel = new AbstractTableModel(this){
                final /* synthetic */ InternalFrameEnvSchemes this$0;
                {
                    InternalFrameEnvSchemes internalFrameEnvSchemes = this$0;
                    Objects.requireNonNull(internalFrameEnvSchemes);
                    this.this$0 = internalFrameEnvSchemes;
                }

                @Override
                public int getRowCount() {
                    return usages.size();
                }

                @Override
                public int getColumnCount() {
                    return 3;
                }

                @Override
                public Object getValueAt(int row, int col) {
                    switch (col) {
                        case 1: {
                            return ((ChartManager.ChartOcc)usages.get((int)row)).type;
                        }
                        case 0: {
                            return ((ChartManager.ChartOcc)usages.get((int)row)).what;
                        }
                        case 2: {
                            return ((ChartManager.ChartOcc)usages.get((int)row)).where;
                        }
                    }
                    return null;
                }
            };
            DialogTable dialog = new DialogTable(this.parent, true, abModel, "Chart & Template Usages : " + String.valueOf(o), false);
            String[] headers = new String[]{"Name", "Type", "Description"};
            for (int i = 0; i < headers.length; ++i) {
                dialog.getTable().getColumnModel().getColumn(i).setHeaderValue(headers[i]);
            }
            TableUtils.setTableHeaderBold((JTable)dialog.getTable());
            dialog.getTable().getTableHeader().setReorderingAllowed(false);
            DefaultTableCellRenderer rend = new DefaultTableCellRenderer(this){
                final /* synthetic */ InternalFrameEnvSchemes this$0;
                {
                    InternalFrameEnvSchemes internalFrameEnvSchemes = this$0;
                    Objects.requireNonNull(internalFrameEnvSchemes);
                    this.this$0 = internalFrameEnvSchemes;
                }

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    PanelTemplate panelTemplate;
                    super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    if (value instanceof PanelType) {
                        this.setIcon(((PanelType)value).getIcon());
                    } else if (value instanceof CorrelationType) {
                        this.setIcon(((CorrelationType)value).getIcon());
                    } else {
                        this.setIcon(null);
                    }
                    if (value instanceof PanelTemplate && ((panelTemplate = (PanelTemplate)value).getName() == null || panelTemplate.getName().isEmpty()) && panelTemplate.getComments() != null) {
                        this.setText(panelTemplate.getComments());
                    }
                    return this;
                }
            };
            dialog.getTable().getColumnModel().getColumn(1).setCellRenderer(rend);
            dialog.getTable().getColumnModel().getColumn(0).setCellRenderer(rend);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }
        catch (RuntimeException | SQLException | SBException ex) {
            SbugsExceptionHandler.showStackError(ex, this.parent);
        }
    }
}

