/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.util.ui.table.ColumnSortResetHandler;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.table.TableRowSorter;
import jsbugs.DialogEvent;
import jsbugs.DialogEventOcc;
import jsbugs.DialogMergeEvents;
import jsbugs.DialogSelectEvent;
import jsbugs.FrameJsbugs;
import jsbugs.FrameTaxaDB;
import jsbugs.SBEventsTableModel;
import jsbugs.TaxonTransferHandler;
import model3.SBEvent;
import model3.SBdb;
import model3.Taxon;
import model3.project.Project;
import org.jdesktop.layout.GroupLayout;
import util.SBException;
import util.SBPermissionException;
import util.exception.StackError;
import util.table.TableEventUtils;

public class InternalFrameEventDict
extends JInternalFrame
implements Observer {
    private final SBEventsTableModel model = new SBEventsTableModel();
    private final SBdb db;
    private final FrameTaxaDB parent;
    private JButton jButtonClear;
    private JButton jButtonLoadAll;
    private JButton jButtonSearch;
    private JButton jButtonSelectAll;
    private JMenuItem jMenuItemDelete;
    private JMenuItem jMenuItemEdit;
    private JMenuItem jMenuItemUsage;
    private JPopupMenu jPopupMenu1;
    private JScrollPane jScrollPane1;
    private JTable jTableSBEvents;

    public InternalFrameEventDict(FrameTaxaDB parent, SBdb db) throws SQLException, SBException {
        this.db = db;
        this.parent = parent;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException, SBException {
        this.setTitle("Events");
        this.model.setupTable(this.jTableSBEvents);
        this.jTableSBEvents.setRowSorter(new TableRowSorter<SBEventsTableModel>(this.model));
        new ColumnSortResetHandler(this.jTableSBEvents).attach();
        this.db.addObserver(this);
        this.jTableSBEvents.add(this.jPopupMenu1);
        this.jTableSBEvents.setDragEnabled(true);
        this.jTableSBEvents.setTransferHandler(new TaxonTransferHandler(this.db, null));
        this.jTableSBEvents.setDropTarget(null);
        this.setTransferHandler(new TaxonTransferHandler(this.db, null));
        this.model.setEvents(new LinkedList<SBEvent>());
    }

    public void load(Project project) throws SQLException {
        this.model.setEvents(new LinkedList<SBEvent>(this.db.getSBEvents(true, project)));
        this.model.fireTableDataChanged();
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg instanceof SBEvent) {
            System.out.println("Updating event list...");
            try {
                List<SBEvent> allEvents = this.db.getSBEvents(false);
                Iterator<SBEvent> it = this.model.getEvents().iterator();
                while (it.hasNext()) {
                    SBEvent event = it.next();
                    if (allEvents.contains(event)) continue;
                    it.remove();
                }
                this.model.fireTableDataChanged();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void initComponents() {
        this.jPopupMenu1 = new JPopupMenu();
        this.jMenuItemEdit = new JMenuItem();
        this.jMenuItemDelete = new JMenuItem();
        this.jMenuItemUsage = new JMenuItem();
        this.jScrollPane1 = new JScrollPane();
        this.jTableSBEvents = new JTable();
        this.jButtonSelectAll = new JButton();
        this.jButtonClear = new JButton();
        this.jButtonSearch = new JButton();
        this.jButtonLoadAll = new JButton();
        this.jMenuItemEdit.setText("Edit...");
        this.jMenuItemEdit.addActionListener(new ActionListener(this){
            final /* synthetic */ InternalFrameEventDict this$0;
            {
                InternalFrameEventDict internalFrameEventDict = this$0;
                Objects.requireNonNull(internalFrameEventDict);
                this.this$0 = internalFrameEventDict;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemEditActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.jMenuItemEdit);
        this.jMenuItemDelete.setText("Delete");
        this.jMenuItemDelete.addActionListener(new ActionListener(this){
            final /* synthetic */ InternalFrameEventDict this$0;
            {
                InternalFrameEventDict internalFrameEventDict = this$0;
                Objects.requireNonNull(internalFrameEventDict);
                this.this$0 = internalFrameEventDict;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemDeleteActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.jMenuItemDelete);
        this.jMenuItemUsage.setText("Usage...");
        this.jMenuItemUsage.addActionListener(new ActionListener(this){
            final /* synthetic */ InternalFrameEventDict this$0;
            {
                InternalFrameEventDict internalFrameEventDict = this$0;
                Objects.requireNonNull(internalFrameEventDict);
                this.this$0 = internalFrameEventDict;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemUsageActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.jMenuItemUsage);
        this.setClosable(true);
        this.setDefaultCloseOperation(1);
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.setFrameIcon(new ImageIcon(this.getClass().getResource("/resources/icon/InternalFrameEvents.png")));
        this.addInternalFrameListener(new InternalFrameListener(this){
            final /* synthetic */ InternalFrameEventDict this$0;
            {
                InternalFrameEventDict internalFrameEventDict = this$0;
                Objects.requireNonNull(internalFrameEventDict);
                this.this$0 = internalFrameEventDict;
            }

            @Override
            public void internalFrameActivated(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameClosed(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameClosing(InternalFrameEvent evt) {
                this.this$0.formInternalFrameClosing(evt);
            }

            @Override
            public void internalFrameDeactivated(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameDeiconified(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameIconified(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameOpened(InternalFrameEvent evt) {
            }
        });
        this.jTableSBEvents.setModel(this.model);
        this.jTableSBEvents.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ InternalFrameEventDict this$0;
            {
                InternalFrameEventDict internalFrameEventDict = this$0;
                Objects.requireNonNull(internalFrameEventDict);
                this.this$0 = internalFrameEventDict;
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                this.this$0.jTableSBEventsMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                this.this$0.jTableSBEventsMouseReleased(evt);
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.this$0.jTableSBEventsMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTableSBEvents);
        this.jButtonSelectAll.setText("Select all");
        this.jButtonSelectAll.addActionListener(new ActionListener(this){
            final /* synthetic */ InternalFrameEventDict this$0;
            {
                InternalFrameEventDict internalFrameEventDict = this$0;
                Objects.requireNonNull(internalFrameEventDict);
                this.this$0 = internalFrameEventDict;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSelectAllActionPerformed(evt);
            }
        });
        this.jButtonClear.setText("Clear selected");
        this.jButtonClear.addActionListener(new ActionListener(this){
            final /* synthetic */ InternalFrameEventDict this$0;
            {
                InternalFrameEventDict internalFrameEventDict = this$0;
                Objects.requireNonNull(internalFrameEventDict);
                this.this$0 = internalFrameEventDict;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonClearActionPerformed(evt);
            }
        });
        this.jButtonSearch.setText("Search...");
        this.jButtonSearch.addActionListener(new ActionListener(this){
            final /* synthetic */ InternalFrameEventDict this$0;
            {
                InternalFrameEventDict internalFrameEventDict = this$0;
                Objects.requireNonNull(internalFrameEventDict);
                this.this$0 = internalFrameEventDict;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSearchActionPerformed(evt);
            }
        });
        this.jButtonLoadAll.setText("Load all");
        this.jButtonLoadAll.addActionListener(new ActionListener(this){
            final /* synthetic */ InternalFrameEventDict this$0;
            {
                InternalFrameEventDict internalFrameEventDict = this$0;
                Objects.requireNonNull(internalFrameEventDict);
                this.this$0 = internalFrameEventDict;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonLoadAllActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.jScrollPane1, -1, 566, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add(6, 6, 6).add((Component)this.jButtonSelectAll).addPreferredGap(1).add((Component)this.jButtonClear).addPreferredGap(0).add((Component)this.jButtonSearch).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jButtonLoadAll).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonSelectAll).add((Component)this.jButtonClear).add((Component)this.jButtonSearch).add((Component)this.jButtonLoadAll)).add(9, 9, 9).add((Component)this.jScrollPane1, -1, 391, Short.MAX_VALUE)));
        this.pack();
    }

    private void jTableSBEventsMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.editEvent();
        }
        if (evt.isPopupTrigger()) {
            this.jPopupMenu1.show(evt.getComponent(), (int)evt.getPoint().getX(), (int)evt.getPoint().getY());
        }
    }

    private void jMenuItemEditActionPerformed(ActionEvent evt) {
        this.editEvent();
    }

    private void jMenuItemDeleteActionPerformed(ActionEvent evt) {
        if (this.jTableSBEvents.getSelectedRowCount() == 0) {
            JOptionPane.showMessageDialog(this, "No rows selected", "Delete Events", 1);
            return;
        }
        LinkedList<SBEvent> toDelete = new LinkedList<SBEvent>();
        int[] selection = this.jTableSBEvents.getSelectedRows();
        for (int i = 0; i < selection.length; ++i) {
            toDelete.add(this.model.getEvents().get(this.jTableSBEvents.convertRowIndexToModel(selection[i])));
        }
        try {
            SBEvent lastEvent = null;
            for (SBEvent event : toDelete) {
                int nWells = event.getNoccs(true);
                int nComp = event.getNcmpStdOccs();
                int nCorr = event.getNcorrOccs();
                if (nWells > 0 || nComp > 0 || nCorr > 0) {
                    if (!this.db.canDeleteSBEvent(event)) {
                        JOptionPane.showMessageDialog(this, "Cannot delete event '" + event.toString() + "' because it occurs in read-only templates, composite standards and/or wells.\nSee event usage.", this.getTitle(), 2);
                        continue;
                    }
                    int opt = JOptionPane.showConfirmDialog(this, "event:" + event.toString() + " Occurs in: " + nWells + " well sections, " + nComp + " Composite Standards and " + nCorr + " Correlation Templates. Are you sure you want to delete it?", "Delete Event", 1, 3);
                    if (opt == 2 || opt == -1) break;
                    if (opt == 1) continue;
                }
                lastEvent = event;
                this.db.deleteSBEvent(event);
                this.db.commit();
                this.parent.parent.getChartManager().unloadEventCorrelationLines(event);
            }
            if (lastEvent != null) {
                this.db.notifyObservers(lastEvent);
            }
        }
        catch (SQLException | SBException | SBPermissionException e) {
            FrameJsbugs.showStackError("SQL Error", (Exception)e, this.db);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
        this.jTableSBEvents.clearSelection();
        this.model.fireTableDataChanged();
    }

    private void jTableSBEventsMouseReleased(MouseEvent evt) {
        TableEventUtils.setRowSelectionPopup((JTable)this.jTableSBEvents, (MouseEvent)evt, (JPopupMenu)this.jPopupMenu1);
    }

    private void jMenuItemUsageActionPerformed(ActionEvent evt) {
        this.eventUsage();
    }

    private void jTableSBEventsMousePressed(MouseEvent evt) {
        TableEventUtils.setRowSelectionPopup((JTable)this.jTableSBEvents, (MouseEvent)evt, (JPopupMenu)this.jPopupMenu1);
    }

    private void jButtonSelectAllActionPerformed(ActionEvent evt) {
        this.jTableSBEvents.selectAll();
    }

    private void jButtonClearActionPerformed(ActionEvent evt) {
        int[] selection = this.jTableSBEvents.getSelectedRows();
        if (selection.length == 0) {
            JOptionPane.showMessageDialog(this, "No events selected.", this.parent.getTitle(), 1);
            return;
        }
        LinkedList<SBEvent> toBeRemoved = new LinkedList<SBEvent>();
        for (int i : selection) {
            toBeRemoved.add(this.model.getEvents().get(this.jTableSBEvents.convertRowIndexToModel(i)));
        }
        this.model.getEvents().removeAll(toBeRemoved);
        this.model.fireTableDataChanged();
    }

    public void addEvent(SBEvent event) {
        List<SBEvent> events = this.model.getEvents();
        if (!events.contains(event)) {
            events.add(event);
        }
        Collections.sort(events);
        this.model.fireTableDataChanged();
    }

    public void addEventsForTaxa(Collection<Taxon> list) {
        try {
            HashSet<SBEvent> newEvents = new HashSet<SBEvent>();
            for (Taxon taxon : list) {
                newEvents.addAll(this.db.getSBEvents(taxon.getSpecID()));
            }
            List<SBEvent> events = this.model.getEvents();
            for (SBEvent event : newEvents) {
                if (events.contains(event)) continue;
                events.add(event);
            }
            Collections.sort(events);
            this.model.fireTableDataChanged();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void jButtonSearchActionPerformed(ActionEvent evt) {
        try {
            DialogSelectEvent dialog = new DialogSelectEvent(this.parent, true, this.db, true, true);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.selected != null) {
                List<SBEvent> events = this.model.getEvents();
                for (SBEvent e : dialog.selected) {
                    if (events.contains(e)) continue;
                    events.add(e);
                }
                Collections.sort(events);
                this.model.fireTableDataChanged();
            }
        }
        catch (SQLException | SBException ex) {
            StackError.showStackError((String)ex.getMessage(), (Throwable)ex);
        }
    }

    private void formInternalFrameClosing(InternalFrameEvent evt) {
        this.model.getEvents().clear();
        this.model.fireTableDataChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonLoadAllActionPerformed(ActionEvent evt) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            int projID = this.parent.getProjID();
            if (projID > 0) {
                Project p = this.db.getProject(projID);
                if (p != null) {
                    int opt = JOptionPane.showConfirmDialog(this, "Restrict events to selected project?", "Project", 1);
                    if (opt == 2) {
                        return;
                    }
                    if (opt == 1) {
                        p = null;
                    }
                }
                this.load(p);
            } else {
                this.load(null);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error: " + e.getMessage(), this.getTitle(), 0);
            e.printStackTrace();
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void eventUsage() {
        int selection = this.jTableSBEvents.getSelectedRow();
        if (selection < 0) {
            JOptionPane.showMessageDialog(this, "Select an event", this.parent.getTitle(), 1);
            return;
        }
        SBEvent event = this.model.getEvents().get(this.jTableSBEvents.convertRowIndexToModel(selection));
        this.setCursor(Cursor.getPredefinedCursor(3));
        DialogEventOcc dialog = new DialogEventOcc((Frame)this.parent, true, 20, this.db);
        dialog.setEvent(event);
        dialog.setLocationRelativeTo(this.parent);
        this.setCursor(Cursor.getDefaultCursor());
        dialog.setVisible(true);
        if (dialog.selectedWellResult != null) {
            try {
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.parent.parent.setSamplesWell(this.db.getWell(dialog.selectedWellResult.wellID));
            }
            catch (SBException sbe) {
                StackError.showStackError((String)"Error", (Throwable)sbe);
            }
            catch (SQLException sql) {
                FrameJsbugs.showStackError("SQL Error", sql, this.db);
            }
            catch (RuntimeException re) {
                StackError.showStackError((String)"", (Throwable)re);
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    private void editEvent() {
        int selection = this.jTableSBEvents.getSelectedRow();
        if (selection < 0) {
            JOptionPane.showMessageDialog(this, "Select an event to edit", this.parent.getTitle(), 1);
            return;
        }
        SBEvent event = this.model.getEvents().get(this.jTableSBEvents.convertRowIndexToModel(selection));
        DialogEvent dialog = new DialogEvent(this.parent, true, this.db, event, null);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.isOK()) {
            this.jTableSBEvents.repaint();
        }
    }

    void merge() {
        if (this.jTableSBEvents.getSelectedRowCount() < 2) {
            JOptionPane.showMessageDialog(this, "You must select at least 2 events from the list to merge", this.getTitle(), 1);
            return;
        }
        LinkedList<SBEvent> events = new LinkedList<SBEvent>();
        int specID = 0;
        Object type = null;
        for (int row : this.jTableSBEvents.getSelectedRows()) {
            SBEvent event = this.model.getEvents().get(this.jTableSBEvents.convertRowIndexToModel(row));
            if (specID > 0 && specID != event.getSpecID()) {
                JOptionPane.showMessageDialog(this, "You can only merge events linked to the same taxon", this.getTitle(), 1);
                return;
            }
            events.add(event);
            if (specID != 0) continue;
            specID = event.getSpecID();
        }
        DialogMergeEvents dialog = new DialogMergeEvents(this.parent, true, events, this.db, this.parent.parent.getChartManager());
        dialog.setLocationRelativeTo(this.parent);
        dialog.setVisible(true);
        if (dialog.isOK) {
            this.jTableSBEvents.clearSelection();
        }
    }
}

