/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.taxon.Genus;
import com.stratadata.model3.taxon.GenusServiceListener;
import com.stratadata.util.ui.table.ColumnSortResetHandler;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Objects;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import javax.swing.table.TableRowSorter;
import jsbchart.graphics.SBGraphics;
import jsbugs.DialogSelectGenus;
import jsbugs.FrameJsbugs;
import jsbugs.FrameTaxaDB;
import jsbugs.GenusTableModel;
import jsbugs.TaxonTransferHandler;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.SBdb;
import model3.taxa.GenusListener;
import util.table.ColorEditor;

public class InternalFrameGenera
extends JInternalFrame
implements GenusListener,
GenusServiceListener {
    private final SBdb sbdb;
    private final GenusTableModel model;
    private final FrameTaxaDB parent;
    private Color copiedColour;
    private JButton jButtonSearch;
    private JMenuItem jMenuItemCopyColour;
    private JMenuItem jMenuItemPasteColour;
    private JPopupMenu jPopupMenuGenera;
    private JScrollPane jScrollPane1;
    private JTable jTableGenera;
    private JToolBar jToolBar1;

    public InternalFrameGenera(FrameTaxaDB parent, SBdb sbdb) {
        this.parent = parent;
        this.sbdb = sbdb;
        this.model = new GenusTableModel(g -> this.updateGenus((Genus)g));
        this.initComponents();
        this.model.setupTable(this.jTableGenera, sbdb);
        this.init();
    }

    private void init() {
        this.jTableGenera.setRowSorter(new TableRowSorter<GenusTableModel>(this.model));
        new ColumnSortResetHandler(this.jTableGenera).attach();
        this.jTableGenera.setDragEnabled(true);
        this.jTableGenera.setTransferHandler(new TaxonTransferHandler(this.sbdb, null));
        this.jTableGenera.setDropTarget(null);
        this.setTransferHandler(new TaxonTransferHandler(this.sbdb, null));
        ColorEditor.setUpColorEditor((JTable)this.jTableGenera);
        this.sbdb.getGenusService().addListener((GenusServiceListener)this);
    }

    void clearSelected() {
        if (this.jTableGenera.getSelectedRowCount() == 0) {
            return;
        }
        LinkedList<Genus> toRemove = new LinkedList<Genus>();
        int[] selection = this.jTableGenera.getSelectedRows();
        for (int i = 0; i < selection.length; ++i) {
            toRemove.add(this.model.getGenus(this.jTableGenera.convertRowIndexToModel(selection[i])));
        }
        try {
            for (Genus genus : toRemove) {
                this.sbdb.getGenus(genus.getGenID()).deleteListener(this);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.model.remove(toRemove.stream().map(Genus::getGenID).toList());
        this.jTableGenera.clearSelection();
        this.model.fireTableDataChanged();
    }

    private void initComponents() {
        this.jPopupMenuGenera = new JPopupMenu();
        this.jMenuItemCopyColour = new JMenuItem();
        this.jMenuItemPasteColour = new JMenuItem();
        this.jToolBar1 = new JToolBar();
        this.jButtonSearch = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTableGenera = new JTable();
        this.jMenuItemCopyColour.setText("Copy colour");
        this.jMenuItemCopyColour.addActionListener(new ActionListener(this){
            final /* synthetic */ InternalFrameGenera this$0;
            {
                InternalFrameGenera internalFrameGenera = this$0;
                Objects.requireNonNull(internalFrameGenera);
                this.this$0 = internalFrameGenera;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemCopyColourActionPerformed(evt);
            }
        });
        this.jPopupMenuGenera.add(this.jMenuItemCopyColour);
        this.jMenuItemPasteColour.setText("Paste colour");
        this.jMenuItemPasteColour.addActionListener(new ActionListener(this){
            final /* synthetic */ InternalFrameGenera this$0;
            {
                InternalFrameGenera internalFrameGenera = this$0;
                Objects.requireNonNull(internalFrameGenera);
                this.this$0 = internalFrameGenera;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemPasteColourActionPerformed(evt);
            }
        });
        this.jPopupMenuGenera.add(this.jMenuItemPasteColour);
        this.setClosable(true);
        this.setDefaultCloseOperation(1);
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.setTitle("Genera");
        this.setFrameIcon(new ImageIcon(this.getClass().getResource("/resources/icon/FrameSamples_OccTab.png")));
        this.jToolBar1.setRollover(true);
        this.jButtonSearch.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/FrameTaxa_FindTaxon.png")));
        this.jButtonSearch.setBorderPainted(false);
        this.jButtonSearch.setFocusable(false);
        this.jButtonSearch.setHorizontalTextPosition(0);
        this.jButtonSearch.setVerticalTextPosition(3);
        this.jButtonSearch.addActionListener(new ActionListener(this){
            final /* synthetic */ InternalFrameGenera this$0;
            {
                InternalFrameGenera internalFrameGenera = this$0;
                Objects.requireNonNull(internalFrameGenera);
                this.this$0 = internalFrameGenera;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSearchActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonSearch);
        this.jTableGenera.setModel(this.model);
        this.jTableGenera.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ InternalFrameGenera this$0;
            {
                InternalFrameGenera internalFrameGenera = this$0;
                Objects.requireNonNull(internalFrameGenera);
                this.this$0 = internalFrameGenera;
            }

            @Override
            public void keyPressed(KeyEvent evt) {
                this.this$0.jTableGeneraKeyPressed(evt);
            }
        });
        this.jTableGenera.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ InternalFrameGenera this$0;
            {
                InternalFrameGenera internalFrameGenera = this$0;
                Objects.requireNonNull(internalFrameGenera);
                this.this$0 = internalFrameGenera;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.this$0.jTableGeneraMouseClicked(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                this.this$0.jTableGeneraMouseReleased(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTableGenera);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jToolBar1, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane1));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jToolBar1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 210, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButtonSearchActionPerformed(ActionEvent evt) {
        this.search();
    }

    private void jTableGeneraMouseClicked(MouseEvent evt) {
        this.evaluatePopup(evt);
    }

    private void evaluatePopup(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            if (this.jTableGenera.getSelectedRowCount() == 0) {
                int rowNumber = this.jTableGenera.rowAtPoint(evt.getPoint());
                this.jTableGenera.getSelectionModel().setSelectionInterval(rowNumber, rowNumber);
            }
            this.jPopupMenuGenera.show(evt.getComponent(), (int)evt.getPoint().getX(), (int)evt.getPoint().getY());
        }
    }

    private void jMenuItemCopyColourActionPerformed(ActionEvent evt) {
        if (this.jTableGenera.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "Select one item to copy", "Genera", 1);
            return;
        }
        int row = this.jTableGenera.getSelectedRow();
        if (row >= 0) {
            Genus genus = this.model.getGenus(this.jTableGenera.getRowSorter().convertRowIndexToModel(row));
            this.copiedColour = genus.getColour();
            int d = 10;
            BufferedImage bufferedImage = new BufferedImage(d, d, 1);
            Graphics2D g = bufferedImage.createGraphics();
            AffineTransform tnf = new AffineTransform();
            tnf.scale(0.01f, 0.01f);
            g.transform(tnf);
            SBGraphics sbg = new SBGraphics(g, null, true, true);
            sbg.setColor(this.copiedColour);
            sbg.fillRect(0.0f, 0.0f, d, d);
            ImageIcon icon = new ImageIcon(bufferedImage);
            this.jMenuItemPasteColour.setIcon(icon);
        }
    }

    private void jMenuItemPasteColourActionPerformed(ActionEvent evt) {
        if (this.copiedColour == null) {
            return;
        }
        int[] rows = this.jTableGenera.getSelectedRows();
        try {
            ArrayList<Genus> toUpdate = new ArrayList<Genus>();
            for (int row : rows) {
                Genus genus = this.model.getGenus(this.jTableGenera.getRowSorter().convertRowIndexToModel(row));
                toUpdate.add(genus);
            }
            Object object = toUpdate.iterator();
            while (object.hasNext()) {
                Genus genus = (Genus)object.next();
                Genus updated = new Genus(genus.getGenID());
                Genus.copyFields((Genus)updated, (Genus)genus);
                updated.setColour(this.copiedColour);
                this.sbdb.getGenusService().updateGenus(genus.getGenID(), updated);
            }
            this.sbdb.commit();
        }
        catch (SQLException sql) {
            this.sbdb.doRollback();
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
        catch (RuntimeException e) {
            SbugsExceptionHandler.showStackError("Error updating genus colour", e, this.parent);
        }
        this.model.fireTableDataChanged();
    }

    private void jTableGeneraMouseReleased(MouseEvent evt) {
        this.evaluatePopup(evt);
    }

    private void jTableGeneraKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 127) {
            this.clearSelected();
        }
    }

    private void search() {
        DialogSelectGenus dialog = new DialogSelectGenus(this.parent, true, this.sbdb, false);
        dialog.setLocation(this.getX() + this.getWidth(), this.getY());
        dialog.setVisible(true);
        this.addGenera(dialog.getSelectedItems());
    }

    void addGenera(Collection<Genus> list) {
        int initialSize = this.model.genusList.size();
        for (Genus genus : list) {
            this.model.addGenus(genus, this.sbdb.getTaxonService().getTaxonCountForGenus(genus.getGenID()));
        }
        if (this.model.genusList.size() > initialSize) {
            this.model.fireTableDataChanged();
        }
        new SwingWorker(this){
            final /* synthetic */ InternalFrameGenera this$0;
            {
                InternalFrameGenera internalFrameGenera = this$0;
                Objects.requireNonNull(internalFrameGenera);
                this.this$0 = internalFrameGenera;
            }

            protected Object doInBackground() throws Exception {
                for (Genus genus : this.this$0.model.getGenera()) {
                    this.this$0.sbdb.getTaxa(genus.getGenID());
                    this.this$0.model.updateNTaxa(genus, this.this$0.sbdb.getTaxonService().getTaxonCountForGenus(genus.getGenID()));
                }
                this.this$0.jTableGenera.repaint();
                return null;
            }
        }.execute();
    }

    private void updateGenus(Genus genus) {
        try {
            this.sbdb.getGenusService().updateGenus(genus.getGenID(), genus);
            this.model.fireTableDataChanged();
        }
        catch (RuntimeException e) {
            SbugsExceptionHandler.showStackError("Error updating genus colour", e, this.parent);
        }
    }

    @Override
    public void onGenusDetailsUpdated(model3.Genus genus) {
    }

    @Override
    public void onGenusSpeciesListUpdated(model3.Genus genus, Collection<Integer> speciesAdded, Collection<Integer> speciesRemoved) {
        if (this.model.genusList.contains(genus)) {
            this.repaint();
        } else {
            genus.deleteListener(this);
        }
    }

    @Override
    public void onGenusDelete(model3.Genus genus) {
        boolean removed = this.model.genusList.remove(genus);
        if (!removed) {
            genus.deleteListener(this);
        } else {
            this.model.fireTableDataChanged();
        }
    }

    public void genusUpdated(Genus updatedGenus) {
        this.model.updateGenus(updatedGenus);
    }

    public void generaDeleted(Collection<Integer> deletedGenera) {
        this.model.remove(new ArrayList<Integer>(deletedGenera));
    }
}

