/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.Discipline;
import com.stratadata.sblicense.SbugsLicense;
import com.stratadata.util.io.FileChooserUtils;
import com.stratadata.util.ui.HelpUtils;
import com.stratadata.util.ui.table.TableUtils;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Observable;
import java.util.Observer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import jsbchart.core.ChartManager;
import jsbchart.core.PanelTemplate;
import jsbchart.correlation.CorrelationType;
import jsbchart.panel.PanelType;
import jsbugs.DialogEventXLSReader;
import jsbugs.DialogIGDHdrOccs;
import jsbugs.DialogList;
import jsbugs.DialogMatchAnalysts;
import jsbugs.DialogMatchCmpStd;
import jsbugs.DialogMatchEvents;
import jsbugs.DialogMatchIGDScheme;
import jsbugs.DialogMatchTaxa;
import jsbugs.DialogPermissions;
import jsbugs.DialogRecalibrate;
import jsbugs.DialogSchemeUsage;
import jsbugs.DialogSearchUnit;
import jsbugs.DialogTable;
import jsbugs.FrameInterpretations;
import jsbugs.FrameJsbugs;
import jsbugs.FrameOrganiser;
import jsbugs.SbugsIO;
import jsbugs.list.RestrictableListRenderer;
import jsbugs.model2.event.DialogCmpStd;
import jsbugs.model2.igdscheme.DialogIGDScheme;
import jsbugs.userconnect.SbugsExceptionHandler;
import jsbugs.util.UserPrefsHelper;
import model3.CompositeStandard;
import model3.DEXFile;
import model3.EventXLSReader;
import model3.IGDInterval;
import model3.IGDScheme;
import model3.IGDSchemeXLSReader;
import model3.SBRestrictable;
import model3.SBdb;
import model3.SequenceXLSReader;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.jdesktop.layout.GroupLayout;
import util.InvalidFieldException;
import util.SB;
import util.SBException;
import util.SBPermissionException;
import util.exception.StackError;

public class InternalFrameIGDSchemes
extends JInternalFrame
implements Observer {
    private final SBdb db;
    private final DefaultListModel model = new DefaultListModel();
    private final DefaultComboBoxModel typeModel = new DefaultComboBoxModel();
    private static final String SELECT_TYPE = "<select>";
    private static final String ALL_TYPES = "All types";
    private static final String CMPSTD_TYPE = "Composite Standards";
    private boolean inStartup = true;
    private final JCheckBoxMenuItem menuCheckBox;
    private final FrameInterpretations parent;
    private JButton jButton3;
    private JButton jButtonAdd;
    private JButton jButtonCharts;
    private JButton jButtonClose;
    private JButton jButtonDelete;
    private JButton jButtonDraw;
    private JButton jButtonEdit;
    private JButton jButtonFindUnit;
    private JButton jButtonHelp;
    private JButton jButtonPermissions;
    private JButton jButtonRead;
    private JButton jButtonRecalibrate;
    private JButton jButtonUsage;
    private JButton jButtonWrite;
    private JComboBox jComboBoxIGDType;
    private JLabel jLabel1;
    private JList jListSchemes;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator6;

    public InternalFrameIGDSchemes(FrameInterpretations parent, SBdb db, JCheckBoxMenuItem menuCheckBox) {
        this.db = db;
        this.menuCheckBox = menuCheckBox;
        this.parent = parent;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.db.addObserver(this);
        this.setTitle("Stratigraphic Schemes");
        this.initSchemeTypeCombo();
        this.jComboBoxIGDType.repaint();
        this.jListSchemes.setCellRenderer(new RestrictableListRenderer());
        this.inStartup = false;
    }

    public void reInit() {
        String selectedSchemeName = null;
        SchemeTypeItem selectedItem = (SchemeTypeItem)this.jComboBoxIGDType.getSelectedItem();
        if (selectedItem != null) {
            selectedSchemeName = selectedItem.name;
        }
        this.inStartup = true;
        this.initSchemeTypeCombo();
        if (selectedSchemeName != null) {
            for (int i = 0; i < this.jComboBoxIGDType.getItemCount(); ++i) {
                SchemeTypeItem item = (SchemeTypeItem)this.jComboBoxIGDType.getItemAt(i);
                if (!item.name.equals(selectedSchemeName)) continue;
                this.jComboBoxIGDType.setSelectedItem(item);
                break;
            }
        }
        this.refreshList();
        this.inStartup = false;
    }

    @Override
    public void update(Observable obs, Object o) {
        if (obs.getClass() == SBdb.class && o != null && (o instanceof IGDScheme || o instanceof CompositeStandard)) {
            this.refreshList();
        } else if (obs instanceof IGDScheme || obs instanceof CompositeStandard) {
            EventQueue.invokeLater(new Runnable(this){
                final /* synthetic */ InternalFrameIGDSchemes this$0;
                {
                    InternalFrameIGDSchemes internalFrameIGDSchemes = this$0;
                    Objects.requireNonNull(internalFrameIGDSchemes);
                    this.this$0 = internalFrameIGDSchemes;
                }

                @Override
                public void run() {
                    this.this$0.jListSchemes.repaint();
                }
            });
        }
    }

    private void initSchemeTypeCombo() {
        int n;
        this.typeModel.removeAllElements();
        this.typeModel.addElement(new SchemeTypeItem(this, SELECT_TYPE){
            {
                Objects.requireNonNull(this$0);
                super(name);
            }

            Collection getSchemes() {
                return new LinkedList();
            }
        });
        this.typeModel.addElement(new SchemeTypeItem(this, ALL_TYPES){
            final /* synthetic */ InternalFrameIGDSchemes this$0;
            {
                InternalFrameIGDSchemes internalFrameIGDSchemes = this$0;
                Objects.requireNonNull(internalFrameIGDSchemes);
                this.this$0 = internalFrameIGDSchemes;
                super(name);
            }

            Collection getSchemes() throws SQLException {
                LinkedList<SBRestrictable> schemes = new LinkedList<SBRestrictable>();
                schemes.addAll(this.this$0.db.getIGDSchemes());
                schemes.addAll(this.this$0.db.getCompositeStandards());
                return schemes;
            }
        });
        int[] schemeTypes = new int[]{3, 2, 10, 4};
        Object object = schemeTypes;
        int n2 = ((int[])object).length;
        for (n = 0; n < n2; ++n) {
            int igdType;
            final int type = igdType = object[n];
            this.typeModel.addElement(new SchemeTypeItem(this, IGDInterval.getIGDName(igdType), type, null){
                final /* synthetic */ InternalFrameIGDSchemes this$0;
                {
                    InternalFrameIGDSchemes internalFrameIGDSchemes = this$0;
                    Objects.requireNonNull(internalFrameIGDSchemes);
                    this.this$0 = internalFrameIGDSchemes;
                    super(name, igdType, discipline);
                }

                Collection getSchemes() throws SQLException {
                    return this.this$0.db.getIGDSchemes(type);
                }
            });
        }
        object = Discipline.values();
        n2 = ((int[])object).length;
        for (n = 0; n < n2; ++n) {
            int disc;
            int discipline = disc = object[n];
            this.typeModel.addElement(new SchemeTypeItem(this, IGDInterval.getIGDName(4) + " - " + disc.getAbr(true), 4, (Discipline)discipline, (Discipline)discipline){
                final /* synthetic */ Discipline val$discipline;
                final /* synthetic */ InternalFrameIGDSchemes this$0;
                {
                    this.val$discipline = discipline2;
                    InternalFrameIGDSchemes internalFrameIGDSchemes = this$0;
                    Objects.requireNonNull(internalFrameIGDSchemes);
                    this.this$0 = internalFrameIGDSchemes;
                    super(name, igdType, discipline);
                }

                Collection getSchemes() throws SQLException {
                    return this.this$0.db.getBiozoneSchemes(this.val$discipline);
                }
            });
        }
        this.typeModel.addElement(new SchemeTypeItem(this, CMPSTD_TYPE){
            final /* synthetic */ InternalFrameIGDSchemes this$0;
            {
                InternalFrameIGDSchemes internalFrameIGDSchemes = this$0;
                Objects.requireNonNull(internalFrameIGDSchemes);
                this.this$0 = internalFrameIGDSchemes;
                super(name);
            }

            Collection getSchemes() throws SQLException {
                return this.this$0.db.getCompositeStandards();
            }
        });
        try {
            object = this.db.getChronoSchemeParents().iterator();
            while (object.hasNext()) {
                IGDScheme parentSch;
                final IGDScheme ps = parentSch = (IGDScheme)object.next();
                this.typeModel.addElement(new SchemeTypeItem(this, parentSch.getName()){
                    final /* synthetic */ InternalFrameIGDSchemes this$0;
                    {
                        InternalFrameIGDSchemes internalFrameIGDSchemes = this$0;
                        Objects.requireNonNull(internalFrameIGDSchemes);
                        this.this$0 = internalFrameIGDSchemes;
                        super(name);
                    }

                    Collection getSchemes() throws SQLException {
                        Collection<Comparable> schemes = this.this$0.db.getSchemeChildren(ps.getID());
                        schemes.add(ps);
                        return schemes;
                    }
                });
            }
        }
        catch (SQLException sql) {
            SbugsExceptionHandler.showStackError(sql, this.parent);
        }
    }

    private void refreshList() {
        try {
            this.model.removeAllElements();
            LinkedList<Comparable> items = new LinkedList<Comparable>(((SchemeTypeItem)this.jComboBoxIGDType.getSelectedItem()).getSchemes());
            Collections.sort(items);
            for (Object e : items) {
                if (e instanceof Observable) {
                    ((Observable)e).addObserver(this);
                }
                this.model.addElement(e);
            }
        }
        catch (SQLException sql) {
            SbugsExceptionHandler.showStackError(sql, this.parent);
        }
        EventQueue.invokeLater(new Runnable(this){
            final /* synthetic */ InternalFrameIGDSchemes this$0;
            {
                InternalFrameIGDSchemes internalFrameIGDSchemes = this$0;
                Objects.requireNonNull(internalFrameIGDSchemes);
                this.this$0 = internalFrameIGDSchemes;
            }

            @Override
            public void run() {
                this.this$0.jListSchemes.repaint();
            }
        });
    }

    private void initComponents() {
        this.jButton3 = new JButton();
        this.jLabel1 = new JLabel();
        this.jComboBoxIGDType = new JComboBox();
        this.jScrollPane1 = new JScrollPane();
        this.jListSchemes = new JList();
        this.jButtonClose = new JButton();
        this.jButtonAdd = new JButton();
        this.jButtonEdit = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonUsage = new JButton();
        this.jButtonDraw = new JButton();
        this.jButtonRead = new JButton();
        this.jButtonWrite = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonRecalibrate = new JButton();
        this.jSeparator6 = new JSeparator();
        this.jButtonPermissions = new JButton();
        this.jButtonFindUnit = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jButtonCharts = new JButton();
        this.jButton3.setText("jButton3");
        this.setClosable(true);
        this.setDefaultCloseOperation(0);
        this.setIconifiable(true);
        this.setResizable(true);
        this.setFrameIcon(new ImageIcon(this.getClass().getResource("/resources/icon/FrameSamples_SchemeTab.png")));
        this.setMinimumSize(new Dimension(400, 500));
        this.addInternalFrameListener(new InternalFrameListener(this){
            final /* synthetic */ InternalFrameIGDSchemes this$0;
            {
                InternalFrameIGDSchemes internalFrameIGDSchemes = this$0;
                Objects.requireNonNull(internalFrameIGDSchemes);
                this.this$0 = internalFrameIGDSchemes;
            }

            @Override
            public void internalFrameActivated(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameClosed(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameClosing(InternalFrameEvent evt) {
                this.this$0.formInternalFrameClosing(evt);
            }

            @Override
            public void internalFrameDeactivated(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameDeiconified(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameIconified(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameOpened(InternalFrameEvent evt) {
            }
        });
        this.jLabel1.setText("Type: ");
        this.jComboBoxIGDType.setMaximumRowCount(16);
        this.jComboBoxIGDType.setModel(this.typeModel);
        this.jComboBoxIGDType.putClientProperty("JComboBox.isPopDown", Boolean.TRUE);
        this.jComboBoxIGDType.addActionListener(new ActionListener(this){
            final /* synthetic */ InternalFrameIGDSchemes this$0;
            {
                InternalFrameIGDSchemes internalFrameIGDSchemes = this$0;
                Objects.requireNonNull(internalFrameIGDSchemes);
                this.this$0 = internalFrameIGDSchemes;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jComboBoxIGDTypeActionPerformed(evt);
            }
        });
        this.jListSchemes.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.jListSchemes.setModel(this.model);
        this.jListSchemes.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ InternalFrameIGDSchemes this$0;
            {
                InternalFrameIGDSchemes internalFrameIGDSchemes = this$0;
                Objects.requireNonNull(internalFrameIGDSchemes);
                this.this$0 = internalFrameIGDSchemes;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.this$0.jListSchemesMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jListSchemes);
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(this){
            final /* synthetic */ InternalFrameIGDSchemes this$0;
            {
                InternalFrameIGDSchemes internalFrameIGDSchemes = this$0;
                Objects.requireNonNull(internalFrameIGDSchemes);
                this.this$0 = internalFrameIGDSchemes;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCloseActionPerformed(evt);
            }
        });
        this.jButtonAdd.setText("Add...");
        this.jButtonAdd.addActionListener(new ActionListener(this){
            final /* synthetic */ InternalFrameIGDSchemes this$0;
            {
                InternalFrameIGDSchemes internalFrameIGDSchemes = this$0;
                Objects.requireNonNull(internalFrameIGDSchemes);
                this.this$0 = internalFrameIGDSchemes;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAddActionPerformed(evt);
            }
        });
        this.jButtonEdit.setText("Edit ...");
        this.jButtonEdit.addActionListener(new ActionListener(this){
            final /* synthetic */ InternalFrameIGDSchemes this$0;
            {
                InternalFrameIGDSchemes internalFrameIGDSchemes = this$0;
                Objects.requireNonNull(internalFrameIGDSchemes);
                this.this$0 = internalFrameIGDSchemes;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonEditActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.addActionListener(new ActionListener(this){
            final /* synthetic */ InternalFrameIGDSchemes this$0;
            {
                InternalFrameIGDSchemes internalFrameIGDSchemes = this$0;
                Objects.requireNonNull(internalFrameIGDSchemes);
                this.this$0 = internalFrameIGDSchemes;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonUsage.setText("Show wells...");
        this.jButtonUsage.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonUsage.addActionListener(new ActionListener(this){
            final /* synthetic */ InternalFrameIGDSchemes this$0;
            {
                InternalFrameIGDSchemes internalFrameIGDSchemes = this$0;
                Objects.requireNonNull(internalFrameIGDSchemes);
                this.this$0 = internalFrameIGDSchemes;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonUsageActionPerformed(evt);
            }
        });
        this.jButtonDraw.setText("Plot...");
        this.jButtonDraw.setToolTipText("Draw selected schemes in separate window");
        this.jButtonDraw.addActionListener(new ActionListener(this){
            final /* synthetic */ InternalFrameIGDSchemes this$0;
            {
                InternalFrameIGDSchemes internalFrameIGDSchemes = this$0;
                Objects.requireNonNull(internalFrameIGDSchemes);
                this.this$0 = internalFrameIGDSchemes;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDrawActionPerformed(evt);
            }
        });
        this.jButtonRead.setText("Read...");
        this.jButtonRead.addActionListener(new ActionListener(this){
            final /* synthetic */ InternalFrameIGDSchemes this$0;
            {
                InternalFrameIGDSchemes internalFrameIGDSchemes = this$0;
                Objects.requireNonNull(internalFrameIGDSchemes);
                this.this$0 = internalFrameIGDSchemes;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonReadActionPerformed(evt);
            }
        });
        this.jButtonWrite.setText("Write...");
        this.jButtonWrite.setToolTipText("Export selected scheme(s) to XML file");
        this.jButtonWrite.addActionListener(new ActionListener(this){
            final /* synthetic */ InternalFrameIGDSchemes this$0;
            {
                InternalFrameIGDSchemes internalFrameIGDSchemes = this$0;
                Objects.requireNonNull(internalFrameIGDSchemes);
                this.this$0 = internalFrameIGDSchemes;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonWriteActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ InternalFrameIGDSchemes this$0;
            {
                InternalFrameIGDSchemes internalFrameIGDSchemes = this$0;
                Objects.requireNonNull(internalFrameIGDSchemes);
                this.this$0 = internalFrameIGDSchemes;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonRecalibrate.setText("Recalibrate...");
        this.jButtonRecalibrate.setToolTipText("change ages on scheme boundaries to new chronostratigraphic scheme");
        this.jButtonRecalibrate.setMargin(new Insets(2, 10, 2, 10));
        this.jButtonRecalibrate.addActionListener(new ActionListener(this){
            final /* synthetic */ InternalFrameIGDSchemes this$0;
            {
                InternalFrameIGDSchemes internalFrameIGDSchemes = this$0;
                Objects.requireNonNull(internalFrameIGDSchemes);
                this.this$0 = internalFrameIGDSchemes;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonRecalibrateActionPerformed(evt);
            }
        });
        this.jButtonPermissions.setText("Permissions...");
        this.jButtonPermissions.setMargin(new Insets(2, 10, 2, 10));
        this.jButtonPermissions.addActionListener(new ActionListener(this){
            final /* synthetic */ InternalFrameIGDSchemes this$0;
            {
                InternalFrameIGDSchemes internalFrameIGDSchemes = this$0;
                Objects.requireNonNull(internalFrameIGDSchemes);
                this.this$0 = internalFrameIGDSchemes;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonPermissionsActionPerformed(evt);
            }
        });
        this.jButtonFindUnit.setText("Find unit...");
        this.jButtonFindUnit.setToolTipText("Search all schemes for a unit name");
        this.jButtonFindUnit.setMargin(new Insets(2, 10, 2, 10));
        this.jButtonFindUnit.addActionListener(new ActionListener(this){
            final /* synthetic */ InternalFrameIGDSchemes this$0;
            {
                InternalFrameIGDSchemes internalFrameIGDSchemes = this$0;
                Objects.requireNonNull(internalFrameIGDSchemes);
                this.this$0 = internalFrameIGDSchemes;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonFindUnitActionPerformed(evt);
            }
        });
        this.jButtonCharts.setText("<html>Show charts<br>&amp; templates...</html>");
        this.jButtonCharts.setMargin(new Insets(2, 10, 2, 10));
        this.jButtonCharts.addActionListener(new ActionListener(this){
            final /* synthetic */ InternalFrameIGDSchemes this$0;
            {
                InternalFrameIGDSchemes internalFrameIGDSchemes = this$0;
                Objects.requireNonNull(internalFrameIGDSchemes);
                this.this$0 = internalFrameIGDSchemes;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonChartsActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.jComboBoxIGDType, 0, -1, Short.MAX_VALUE)).add((Component)this.jScrollPane1, -1, 294, Short.MAX_VALUE)).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(1, false).add(2, (Component)this.jButtonHelp, -1, -1, Short.MAX_VALUE).add(2, (Component)this.jButtonFindUnit, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonRead, -1, -1, Short.MAX_VALUE).add(2, (Component)this.jButtonAdd, -1, -1, Short.MAX_VALUE).add(2, (Component)this.jSeparator6).add(2, (Component)this.jButtonEdit, -1, -1, Short.MAX_VALUE).add(2, (Component)this.jButtonDelete, -1, -1, Short.MAX_VALUE).add(2, (Component)this.jButtonUsage, -1, -1, Short.MAX_VALUE).add(2, (Component)this.jButtonDraw, -1, -1, Short.MAX_VALUE).add(2, (Component)this.jButtonWrite, -1, -1, Short.MAX_VALUE).add(2, (Component)this.jButtonPermissions, -1, -1, Short.MAX_VALUE).add(2, (Component)this.jButtonRecalibrate, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonClose, -1, -1, Short.MAX_VALUE).add((Component)this.jSeparator1).add((Component)this.jButtonCharts)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jComboBoxIGDType, -2, -1, -2)).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(2).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonAdd).addPreferredGap(0).add((Component)this.jButtonEdit).addPreferredGap(0).add((Component)this.jButtonDelete).add(12, 12, 12).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0).add((Component)this.jButtonDraw).addPreferredGap(0).add((Component)this.jButtonUsage).addPreferredGap(0).add((Component)this.jButtonCharts, -2, -1, -2).addPreferredGap(0).add((Component)this.jButtonPermissions).addPreferredGap(0).add((Component)this.jButtonRecalibrate).addPreferredGap(0).add((Component)this.jButtonFindUnit).add(7, 7, 7).add((Component)this.jSeparator6, -2, 10, -2).addPreferredGap(1).add((Component)this.jButtonRead).addPreferredGap(0).add((Component)this.jButtonWrite).addPreferredGap(0, 120, Short.MAX_VALUE).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonClose)).add((Component)this.jScrollPane1, -1, 536, Short.MAX_VALUE)).addContainerGap()));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.menuCheckBox.setSelected(false);
        this.setVisible(false);
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        String type = this.jComboBoxIGDType.getSelectedItem().toString();
        if (type.equals(ALL_TYPES) || type.equals(SELECT_TYPE)) {
            JOptionPane.showMessageDialog(this, "Select the scheme type from the drop-down list", this.getTitle(), 2);
            return;
        }
        try {
            if (type.equals(CMPSTD_TYPE)) {
                DialogCmpStd dialog = new DialogCmpStd(this.parent, true, this.db, null);
                SB.centreDialog((Dialog)((Object)dialog));
                dialog.setVisible(true);
                if (dialog.isOK()) {
                    this.refreshList();
                    dialog.getCmpStdAdded().addObserver(this);
                    this.jListSchemes.setSelectedValue(dialog.getCmpStdAdded(), true);
                }
            } else {
                SchemeTypeItem selectedItem = (SchemeTypeItem)this.jComboBoxIGDType.getSelectedItem();
                Integer igdType = selectedItem.igdType;
                if (igdType != null) {
                    DialogIGDScheme dialog = new DialogIGDScheme(this.parent, true, this.db, null, (int)igdType, this.parent.parent.getChartManager());
                    dialog.setDiscipline(selectedItem.discipline);
                    SB.centreDialog((Dialog)((Object)dialog));
                    dialog.setVisible(true);
                    if (dialog.isOK()) {
                        this.refreshList();
                        dialog.getSchemeAdded().addObserver(this);
                        this.jListSchemes.setSelectedValue(dialog.getSchemeAdded(), true);
                    }
                } else {
                    JOptionPane.showMessageDialog(this.parent, "Select one of the basic, unqualified scheme types first, e.g. Biozones, Chronostratigraphy, etc.", this.getTitle(), 1);
                }
            }
        }
        catch (RuntimeException | SQLException | SBException e) {
            SbugsExceptionHandler.showStackError(e, this.parent);
        }
    }

    private void jComboBoxIGDTypeActionPerformed(ActionEvent evt) {
        if (this.inStartup) {
            return;
        }
        if (!SbugsLicense.checkRLMlicense()) {
            JOptionPane.showMessageDialog(this.parent, "StrataBugs licence no longer available.", "StrataBugs", 0);
            this.parent.dispose();
            return;
        }
        if (SELECT_TYPE.equals(this.typeModel.getElementAt(0).toString())) {
            this.typeModel.removeElementAt(0);
        }
        this.refreshList();
    }

    private void jButtonEditActionPerformed(ActionEvent evt) {
        if (this.jListSchemes.getSelectedValue() == null) {
            JOptionPane.showMessageDialog(this, "Select a scheme", this.getTitle(), 2);
            return;
        }
        Object scheme = this.jListSchemes.getSelectedValue();
        try {
            if (scheme instanceof IGDScheme) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                DialogIGDScheme dialog = new DialogIGDScheme(this.parent, true, this.db, (IGDScheme)scheme, 0, this.parent.parent.getChartManager());
                SB.centreDialog((Dialog)((Object)dialog));
                dialog.setVisible(true);
                this.setCursor(Cursor.getDefaultCursor());
            } else {
                DialogCmpStd dialog = new DialogCmpStd(this.parent, true, this.db, (CompositeStandard)scheme);
                SB.centreDialog((Dialog)((Object)dialog));
                dialog.setVisible(true);
            }
        }
        catch (RuntimeException | SQLException | SBException e) {
            SbugsExceptionHandler.showStackError(e, this.parent);
        }
        this.refreshList();
    }

    private void formInternalFrameClosing(InternalFrameEvent evt) {
        this.jButtonCloseActionPerformed(null);
    }

    private void jListSchemesMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonEditActionPerformed(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        if (this.jListSchemes.getSelectedIndex() < 0) {
            JOptionPane.showMessageDialog(this, "No scheme selected", this.getTitle(), 2);
            return;
        }
        if (!SBRestrictable.canWrite(this.db)) {
            JOptionPane.showMessageDialog(this, SBRestrictable.getDeniedReason(false), "Delete Scheme", 2);
            return;
        }
        LinkedList objects = new LinkedList();
        objects.addAll(this.jListSchemes.getSelectedValuesList());
        for (Object object : objects) {
            try {
                SBRestrictable scheme;
                if (!((SBRestrictable)((Object)object)).canWrite(this.db, null)) {
                    JOptionPane.showMessageDialog(this, ((SBRestrictable)((Object)object)).getDeniedReason(this.db, object instanceof CompositeStandard ? "composite standard" : "scheme", false), "Delete Scheme", 2);
                    return;
                }
                if (object instanceof IGDScheme) {
                    scheme = (IGDScheme)object;
                    String msg = "";
                    int occs = ((IGDScheme)scheme).getNoccs();
                    if (occs > 0) {
                        JOptionPane.showMessageDialog(this, "You cannot delete '" + String.valueOf((Object)scheme) + "' because it occurs " + occs + " times in wells.", this.getTitle(), 2);
                        return;
                    }
                    Object parents = "";
                    Collection<Integer>[] parentOccs = ((IGDScheme)scheme).getParentOccs();
                    for (int schID : parentOccs[0]) {
                        parents = (String)parents + "\n" + String.valueOf(this.db.getIGDScheme(schID));
                    }
                    for (int stdID : parentOccs[1]) {
                        parents = (String)parents + "\n" + String.valueOf(this.db.getCompositeStandard(stdID));
                    }
                    for (int curveID : parentOccs[2]) {
                        parents = (String)parents + "\n" + String.valueOf(this.db.getAgeCurve(curveID));
                    }
                    if (!((String)parents).isEmpty()) {
                        String pMsg = "You can't delete this scheme because it is the parent of schemes/composites/curves:\n" + (String)parents;
                        JOptionPane.showMessageDialog(this, pMsg, this.getTitle(), 2);
                        return;
                    }
                    if (!ChartManager.checkDeleteIGDScheme(this.db, ((IGDScheme)scheme).getID())) {
                        JOptionPane.showMessageDialog(this, "You can't delete this scheme because it is used in charts.", "Delete Scheme", 2);
                        return;
                    }
                    int nHdrs = ((IGDScheme)scheme).getNHdrOccs();
                    if (nHdrs > 0) {
                        DialogIGDHdrOccs dialog = new DialogIGDHdrOccs(this.parent, true, this.db, (IGDScheme)scheme);
                        dialog.setLocationRelativeTo(this);
                        dialog.setVisible(true);
                        if (!dialog.isOK()) {
                            if (dialog.selectedWell != null) {
                                try {
                                    this.setCursor(Cursor.getPredefinedCursor(3));
                                    this.parent.parent.setSamplesWell(this.db.getWell(dialog.selectedWell.getWellID()));
                                }
                                catch (SQLException | SBException sql) {
                                    FrameJsbugs.showStackError("Error", (Exception)sql, this.db);
                                }
                                catch (RuntimeException re) {
                                    StackError.showStackError((String)"", (Throwable)re);
                                }
                                finally {
                                    this.setCursor(Cursor.getDefaultCursor());
                                }
                            }
                            return;
                        }
                    }
                    if (JOptionPane.showConfirmDialog(this, msg + "Really delete scheme: " + String.valueOf((Object)scheme) + "?", this.getTitle(), 0, 3) != 0) continue;
                    this.db.deleteIGDScheme((IGDScheme)scheme);
                    this.db.commit();
                    scheme.notifyObservers();
                    scheme.deleteObservers();
                    this.model.removeElement((Object)scheme);
                    continue;
                }
                scheme = (CompositeStandard)object;
                if (!ChartManager.checkDeleteCmpStd(this.db, ((CompositeStandard)scheme).getID())) {
                    JOptionPane.showMessageDialog(this, "You can't delete this Composite Standard because it is used in charts.", "Delete Comp.", 2);
                    return;
                }
                if (JOptionPane.showConfirmDialog(this, "Really delete '" + ((CompositeStandard)scheme).getName() + "'?", this.getTitle(), 0, 2) != 0) continue;
                this.db.deleteCompositeStandard((CompositeStandard)scheme);
                this.db.commit();
                scheme.notifyObservers();
                scheme.deleteObservers();
                this.model.removeElement((Object)scheme);
            }
            catch (SQLException | SBException sql) {
                this.db.doRollback();
                FrameJsbugs.showStackError("SQL Error", (Exception)sql, this.db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonUsageActionPerformed(ActionEvent evt) {
        Object object = this.jListSchemes.getSelectedValue();
        if (object == null) {
            JOptionPane.showMessageDialog(this, "No scheme selected", this.getTitle(), 1);
            return;
        }
        Window dialog = null;
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (object instanceof IGDScheme) {
                IGDScheme scheme = (IGDScheme)object;
                List<String> occs = scheme.getOccs();
                if (occs == null || occs.isEmpty()) {
                    JOptionPane.showMessageDialog(this, "Scheme does not occur in any wells or outcrops.", scheme.toString(), 1);
                } else {
                    dialog = new DialogSchemeUsage((Frame)this.parent, false, scheme);
                    ((Dialog)dialog).setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
                }
            } else {
                JOptionPane.showMessageDialog(this, "Composite standards are not linked to wells, see 'Show Charts...'", this.getTitle(), 1);
            }
        }
        catch (RuntimeException | SQLException | SBException e) {
            SbugsExceptionHandler.showStackError(e, this.parent);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
        if (dialog != null) {
            dialog.setLocationRelativeTo(this.parent);
            ((Dialog)dialog).setVisible(true);
        }
    }

    private void jButtonDrawActionPerformed(ActionEvent evt) {
        if (this.jListSchemes.getSelectedValue() == null) {
            JOptionPane.showMessageDialog(this, "Select scheme(s)", this.getTitle(), 2);
            return;
        }
        try {
            this.parent.drawScheme(this.jListSchemes.getSelectedValuesList());
        }
        catch (RuntimeException | SQLException e) {
            SbugsExceptionHandler.showStackError("Error loading charts", e, this.parent);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jButtonReadActionPerformed(ActionEvent evt) {
        this.read();
    }

    private void jButtonWriteActionPerformed(ActionEvent evt) {
        if ((this.db.getUser().getPriv() & 0x4000) > 0) {
            JOptionPane.showMessageDialog(this, "You are not allowed to export data.", this.getTitle(), 2);
            return;
        }
        this.writeXML();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        HelpUtils.openHelp((String)"framestratigraphicschemes.html");
    }

    private void jButtonRecalibrateActionPerformed(ActionEvent evt) {
        if (this.jListSchemes.getSelectedValue() == null || this.jListSchemes.getSelectedIndices().length > 1) {
            JOptionPane.showMessageDialog(this, "Select a scheme", this.getTitle(), 2);
            return;
        }
        Object obj = this.jListSchemes.getSelectedValue();
        if (!(obj instanceof IGDScheme) && !(obj instanceof CompositeStandard)) {
            JOptionPane.showMessageDialog(this, "Only zonation schemes and composite standards supported.", this.getTitle(), 2);
            return;
        }
        try {
            IGDScheme scheme;
            if (obj instanceof IGDScheme && (scheme = (IGDScheme)obj).getIGDType() == 3) {
                JOptionPane.showMessageDialog(this, "You can't recalibrate a chronostratigraphy scheme.", this.getTitle(), 2);
                return;
            }
            DialogRecalibrate dialog = new DialogRecalibrate((Frame)this.parent, true, this.db, obj);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            this.refreshList();
        }
        catch (RuntimeException | SQLException sql) {
            SbugsExceptionHandler.showStackError(sql, this.parent);
        }
    }

    private void jButtonPermissionsActionPerformed(ActionEvent evt) {
        if (this.jListSchemes.getSelectedValue() == null || this.jListSchemes.getSelectedIndices().length > 1) {
            JOptionPane.showMessageDialog(this, "Select a scheme", this.getTitle(), 2);
            return;
        }
        SBRestrictable obj = (SBRestrictable)((Object)this.jListSchemes.getSelectedValue());
        try {
            DialogPermissions dialog = new DialogPermissions(this.parent, true, this.db, obj, null);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.isOK()) {
                this.jListSchemes.repaint();
            }
        }
        catch (SBException sbe) {
            JOptionPane.showMessageDialog(this, sbe.toString(), this.getTitle(), 2);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
    }

    private void jButtonFindUnitActionPerformed(ActionEvent evt) {
        DialogSearchUnit dialog = new DialogSearchUnit((Frame)this.parent, true, this.db, null);
        dialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }

    private void jButtonChartsActionPerformed(ActionEvent evt) {
        if (this.jListSchemes.getSelectedValue() == null || this.jListSchemes.getSelectedIndices().length > 1) {
            JOptionPane.showMessageDialog(this, "Select a scheme", this.getTitle(), 2);
            return;
        }
        Object o = this.jListSchemes.getSelectedValue();
        try {
            List<ChartManager.ChartOcc> usages;
            if (o instanceof IGDScheme) {
                IGDScheme scheme = (IGDScheme)o;
                usages = this.parent.parent.getChartManager().getIGDSchemeUsages(scheme.getID());
            } else if (o instanceof CompositeStandard) {
                CompositeStandard std = (CompositeStandard)o;
                usages = this.parent.parent.getChartManager().getCmpStdUsages(std.getID());
            } else {
                JOptionPane.showMessageDialog(this, "This data type is not used in charts.", this.getTitle(), 1);
                return;
            }
            if (usages.isEmpty()) {
                JOptionPane.showMessageDialog(this, String.valueOf(o) + " is not used in charts.", this.getTitle(), 1);
                return;
            }
            AbstractTableModel abModel = new AbstractTableModel(this){
                final /* synthetic */ InternalFrameIGDSchemes this$0;
                {
                    InternalFrameIGDSchemes internalFrameIGDSchemes = this$0;
                    Objects.requireNonNull(internalFrameIGDSchemes);
                    this.this$0 = internalFrameIGDSchemes;
                }

                @Override
                public int getRowCount() {
                    return usages.size();
                }

                @Override
                public int getColumnCount() {
                    return 3;
                }

                @Override
                public Object getValueAt(int row, int col) {
                    switch (col) {
                        case 1: {
                            return ((ChartManager.ChartOcc)usages.get((int)row)).type;
                        }
                        case 0: {
                            return ((ChartManager.ChartOcc)usages.get((int)row)).what;
                        }
                        case 2: {
                            return ((ChartManager.ChartOcc)usages.get((int)row)).where;
                        }
                    }
                    return null;
                }
            };
            DialogTable dialog = new DialogTable(this.parent, true, abModel, "Chart & Template Usages : " + String.valueOf(o), false);
            String[] headers = new String[]{"Name", "Type", "Description"};
            for (int i = 0; i < headers.length; ++i) {
                dialog.getTable().getColumnModel().getColumn(i).setHeaderValue(headers[i]);
            }
            TableUtils.setTableHeaderBold((JTable)dialog.getTable());
            dialog.getTable().getTableHeader().setReorderingAllowed(false);
            DefaultTableCellRenderer rend = new DefaultTableCellRenderer(this){
                final /* synthetic */ InternalFrameIGDSchemes this$0;
                {
                    InternalFrameIGDSchemes internalFrameIGDSchemes = this$0;
                    Objects.requireNonNull(internalFrameIGDSchemes);
                    this.this$0 = internalFrameIGDSchemes;
                }

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    PanelTemplate panelTemplate;
                    super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    if (value instanceof PanelType) {
                        this.setIcon(((PanelType)value).getIcon());
                    } else if (value instanceof CorrelationType) {
                        this.setIcon(((CorrelationType)value).getIcon());
                    } else {
                        this.setIcon(null);
                    }
                    if (value instanceof PanelTemplate && ((panelTemplate = (PanelTemplate)value).getName() == null || panelTemplate.getName().isEmpty()) && panelTemplate.getComments() != null) {
                        this.setText(panelTemplate.getComments());
                    }
                    return this;
                }
            };
            dialog.getTable().getColumnModel().getColumn(1).setCellRenderer(rend);
            dialog.getTable().getColumnModel().getColumn(0).setCellRenderer(rend);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }
        catch (RuntimeException | SQLException | SBException ex) {
            SbugsExceptionHandler.showStackError(ex, this.parent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void read() {
        File file = SbugsIO.chooseFileToOpen(this.db, this.parent, "JXMLFILE", "Scheme files (sbg,xml,dex,xls)", "sbg", "xml", "dex", "xls", "xlsx");
        if (file == null) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            String fileName = file.getPath();
            switch (fileName.substring(fileName.lastIndexOf(46) + 1).toLowerCase().trim()) {
                case "dex": {
                    this.readDEX(fileName);
                    return;
                }
                case "sbg": 
                case "xml": {
                    this.readXML(file);
                    return;
                }
                case "xls": 
                case "xlsx": {
                    this.readXLS(file);
                    return;
                }
            }
            return;
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void readXLS(File file) {
        SchemeTypeItem type = (SchemeTypeItem)this.jComboBoxIGDType.getSelectedItem();
        if (CMPSTD_TYPE.equals(type.toString())) {
            if (this.db.getLicenceCustomer().isStrataData() || this.db.getLicenceCustomer().getCompany().toUpperCase().startsWith("BUJAK")) {
                Object[] buttons = new String[]{"Regular format", "Bujak format XLS file", "Cancel"};
                int opt = JOptionPane.showOptionDialog(this, "Specify format of selected file ...", this.getTitle(), 1, 3, null, buttons, null);
                if (opt == 2) {
                    return;
                }
                if (opt == 1) {
                    this.readXLSBujakEvents(file);
                    return;
                }
            }
            this.readXLSEvents(file);
        } else if (type.name.equals(IGDInterval.getIGDName(10))) {
            int opt = JOptionPane.showConfirmDialog(this, "Do you want to append unit types to unit name to make them uniqiue?", "Sequence Scheme reader", 1);
            if (opt == 2) {
                return;
            }
            this.readXLSSequence(file, opt == 0);
        } else if (type.name.equals(IGDInterval.getIGDName(4)) || type.name.equals(IGDInterval.getIGDName(2)) || type.name.equals(IGDInterval.getIGDName(3))) {
            this.readXLSUnits(IGDInterval.getIGDType(type.name), file);
        } else {
            JOptionPane.showMessageDialog(this, "Select a scheme type", "Read Scheme", 2);
        }
    }

    private void readXLSUnits(int igdType, File file) {
        try {
            SBdb ws = new SBdb(this.db);
            IGDSchemeXLSReader.read(ws, file, igdType, true);
            Iterator<IGDScheme> its = ws.getIGDSchemes(igdType).iterator();
            boolean found = false;
            while (its.hasNext()) {
                IGDScheme scheme = its.next();
                found = true;
                DialogMatchIGDScheme dialog = new DialogMatchIGDScheme(this.parent, true, scheme, this.db, false);
                dialog.setLocationRelativeTo(this.parent);
                dialog.setVisible(true);
            }
            if (!found) {
                JOptionPane.showMessageDialog(this.parent, "Unable to read any schemes from the file", this.getTitle(), 1);
            }
        }
        catch (IOException | SQLException | InvalidFormatException | SBException e) {
            FrameJsbugs.showStackError("Error opening file", (Exception)e, this.db);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void readXLSSequence(File file, boolean appendTypes) {
        try {
            SBdb ws = new SBdb(this.db);
            SequenceXLSReader.read(ws, file, appendTypes);
            for (IGDScheme scheme : ws.getIGDSchemes(10)) {
                DialogMatchIGDScheme dialog = new DialogMatchIGDScheme(this.parent, true, scheme, this.db, false);
                dialog.setLocationRelativeTo(this.parent);
                dialog.setVisible(true);
            }
        }
        catch (IOException | SQLException | InvalidFormatException | SBException e) {
            FrameJsbugs.showStackError("Error opening file", (Exception)e, this.db);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void readXLSEvents(File file) {
        String style = "Expecting 2 column format: 'top/base Event name', 'age' ";
        try {
            SBdb ws = new SBdb(this.db);
            DialogEventXLSReader dialog = new DialogEventXLSReader(this.parent, true, this.db, ws, file);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.isOK()) {
                EventXLSReader reader = dialog.getReader();
                reader.getEvents(ws);
                DialogMatchEvents dialogMatchEvents = new DialogMatchEvents(this.parent, true, ws, this.db, true);
                dialogMatchEvents.setLocationRelativeTo(this);
                dialogMatchEvents.setVisible(true);
                if (dialogMatchEvents.isOK()) {
                    LinkedList<SBException> exceptions = new LinkedList<SBException>();
                    CompositeStandard std = reader.getCompositeStandard(exceptions);
                    if (exceptions.size() > 0) {
                        DialogList<SBException> dialogl = new DialogList<SBException>(this.parent, true, "Events not added to composite", new UserPrefsHelper(this.db), exceptions, false, false);
                        dialogl.setLocationRelativeTo(this);
                        dialogl.setVisible(true);
                    }
                    DialogMatchCmpStd matchdialog = new DialogMatchCmpStd(this.parent, true, std, this.db, false);
                    matchdialog.setLocationRelativeTo(this);
                    matchdialog.setVisible(true);
                    this.refreshList();
                }
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(this, "Error reading file:\n" + ioe.getMessage(), "Read File", 0);
        }
        catch (SBException sbe) {
            StackError.showStackError((String)"Error processing file.\nExpecting 2 column format: 'top/base Event name', 'age' ", (Throwable)sbe);
        }
        catch (IllegalStateException | InvalidFormatException ife) {
            JOptionPane.showMessageDialog(this, "Error reading file:\n" + ife.getMessage() + "\nExpecting 2 column format: 'top/base Event name', 'age' ", "Read File", 0);
        }
    }

    private void readXLSBujakEvents(File file) {
        try {
            SBdb ws = new SBdb(this.db);
            EventXLSReader reader = new EventXLSReader(ws, file);
            reader.getBujakEvents(ws);
            DialogMatchEvents dialogMatchEvents = new DialogMatchEvents(this.parent, true, ws, this.db, true);
            dialogMatchEvents.setLocationRelativeTo(this);
            dialogMatchEvents.setVisible(true);
            if (dialogMatchEvents.isOK()) {
                LinkedList<SBException> exceptions = new LinkedList<SBException>();
                CompositeStandard std = reader.getCompositeStandard(exceptions);
                if (exceptions.size() > 0) {
                    DialogList<SBException> dialogl = new DialogList<SBException>(this.parent, true, "Events not added to composite", new UserPrefsHelper(this.db), exceptions, false, false);
                    dialogl.setLocationRelativeTo(this);
                    dialogl.setVisible(true);
                }
                DialogMatchCmpStd matchdialog = new DialogMatchCmpStd(this.parent, true, std, this.db, false);
                matchdialog.setLocationRelativeTo(this);
                matchdialog.setVisible(true);
                this.refreshList();
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(this, "Error reading file:\n" + ioe.getMessage(), "Read File", 0);
        }
        catch (SBException sbe) {
            StackError.showStackError((String)"Error processing file.\n", (Throwable)sbe);
        }
        catch (IllegalStateException | InvalidFormatException ife) {
            JOptionPane.showMessageDialog(this, "Error reading file:\n" + ife.getMessage() + "\n", "Read File", 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readXML(File file) {
        SBdb ws;
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            ws = new SBdb(this.db);
            HashSet<Integer> dTypes = new HashSet<Integer>();
            LinkedList<SBException> exceptions = new LinkedList<SBException>();
            Logger logger = Logger.getLogger(FrameOrganiser.class.getName() + " XML File Read");
            SbugsIO.parseFile(file, this.parent, ws, 0, dTypes, exceptions);
            if (!exceptions.isEmpty()) {
                Object msg = "The following errors were found while reading the file ...";
                int exCount = 0;
                for (SBException sb : exceptions) {
                    if (++exCount < 20) {
                        msg = (String)msg + "\n" + sb.getMessage();
                    }
                    logger.log(Level.WARNING, sb.getMessage(), sb);
                }
                JOptionPane.showMessageDialog(this, msg, this.getTitle(), 2);
            }
        }
        catch (IOException | SQLException | ParseException | SBException e) {
            FrameJsbugs.showStackError("Error opening file", (Exception)e, this.db);
            return;
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
            return;
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
        System.out.println("File read successful...");
        try {
            if (!ws.getUsers().isEmpty()) {
                DialogMatchAnalysts dialog = new DialogMatchAnalysts(this.parent, true, ws, this.db, true);
                dialog.setLocationRelativeTo(this.parent);
                dialog.setVisible(true);
                if (!dialog.isOK()) {
                    return;
                }
            }
            int[] igdTypes = new int[]{3, 2, 4, 10};
            for (int i = 0; i < igdTypes.length; ++i) {
                for (IGDScheme scheme : ws.getIGDSchemes(igdTypes[i])) {
                    DialogMatchIGDScheme dialog = new DialogMatchIGDScheme(this.parent, true, scheme, this.db, true);
                    dialog.setLocationRelativeTo(this.parent);
                    dialog.setVisible(true);
                }
            }
            if (ws.hasTaxa()) {
                DialogMatchTaxa dialog = new DialogMatchTaxa(this.parent, true, ws, null, this.db, true);
                dialog.setLocationRelativeTo(this.parent);
                dialog.setVisible(true);
                if (!dialog.isOK()) {
                    return;
                }
            }
            if (ws.hasEvents()) {
                DialogMatchEvents dialogMatchEvents = new DialogMatchEvents(this.parent, true, ws, this.db, true);
                dialogMatchEvents.setLocationRelativeTo(this.parent);
                dialogMatchEvents.setVisible(true);
                if (!dialogMatchEvents.isOK()) {
                    return;
                }
            }
            if (!ws.getCompositeStandards().isEmpty()) {
                for (CompositeStandard std : ws.getCompositeStandards()) {
                    DialogMatchCmpStd dialog;
                    this.parent.setCursor(Cursor.getPredefinedCursor(3));
                    try {
                        std.excludeEvents(ws);
                        dialog = new DialogMatchCmpStd(this.parent, true, std, this.db, false);
                    }
                    finally {
                        this.parent.setCursor(Cursor.getDefaultCursor());
                    }
                    dialog.setLocationRelativeTo(this.parent);
                    dialog.setVisible(true);
                }
            }
            this.refreshList();
        }
        catch (SQLException | SBException sql) {
            SbugsExceptionHandler.showStackError(sql, this.parent);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void readDEX(String filePath) {
        try {
            IGDScheme selectedScheme;
            int[] igdTypes;
            SBdb ws = new SBdb(this.db);
            LinkedList<IGDScheme> schemes = new LinkedList<IGDScheme>();
            HashSet dTypes = new HashSet();
            DEXFile reader = new DEXFile(ws, this.db.getUser(), filePath, dTypes, null, 0);
            for (int igdType : igdTypes = new int[]{3, 2, 4, 10}) {
                schemes.addAll(ws.getIGDSchemes(igdType));
            }
            if (schemes.isEmpty()) {
                JOptionPane.showMessageDialog(this, "No schemes found in file", "IGD Scheme", 2);
                return;
            }
            if (schemes.size() > 1) {
                DialogList dialog = new DialogList(this.parent, true, "Select Scheme", new UserPrefsHelper(this.db), schemes, true, false);
                dialog.setLocationRelativeTo(this);
                dialog.setVisible(true);
                if (dialog.getSelection() == null) {
                    return;
                }
                selectedScheme = (IGDScheme)dialog.getSelection();
            } else {
                selectedScheme = (IGDScheme)schemes.get(0);
            }
            IGDScheme duplicate = this.db.getIGDScheme(selectedScheme.toString(), selectedScheme.getIGDType());
            if (duplicate != null) {
                JOptionPane.showMessageDialog(this, "A scheme of that name already exists", "IGD Scheme", 2);
                return;
            }
            this.db.addIGDScheme(IGDScheme.copyToDatabase(this.db, selectedScheme));
            this.db.notifyObservers(selectedScheme);
            this.db.commit();
        }
        catch (IOException | SQLException | SBException e) {
            FrameJsbugs.showStackError("Error", (Exception)e, this.db);
        }
        catch (InvalidFieldException ife) {
            JOptionPane.showMessageDialog(this.parent, ife.getMessage(), this.getTitle(), 2);
        }
    }

    private void writeXML() {
        File file;
        if (this.jListSchemes.getSelectedValue() == null) {
            JOptionPane.showMessageDialog(this, "Select scheme(s)", this.getTitle(), 2);
            return;
        }
        List schemes = this.jListSchemes.getSelectedValuesList();
        String defaultFileName = null;
        if (schemes.size() == 1) {
            defaultFileName = schemes.get(0).toString();
        }
        if ((file = FileChooserUtils.chooseFileToWrite((SBdb)this.db, (Component)this.parent, (String)"JXMLFILE", null, (String[])new String[]{"sbg"}, (String[])new String[]{"StrataBugs SBG/XML"}, (String)defaultFileName)) == null) {
            return;
        }
        try {
            SBdb ws = new SBdb(this.db);
            for (Object o : schemes) {
                if (o instanceof CompositeStandard) {
                    CompositeStandard cmpStd = (CompositeStandard)o;
                    ws.fillCompositeStandard(cmpStd);
                    continue;
                }
                if (!(o instanceof IGDScheme)) continue;
                IGDScheme scheme = (IGDScheme)o;
                ws.fillIGDScheme(this.db, scheme.getID());
            }
            SbugsIO.saveSBGfile(this.db, null, ws, file, this.parent, new HashSet<Integer>(), false);
        }
        catch (IOException | RuntimeException | SQLException | SBException | SBPermissionException e) {
            SbugsExceptionHandler.showStackError(e, this.parent);
        }
    }

    private static abstract class SchemeTypeItem {
        private final String name;
        private final Integer igdType;
        private final Discipline discipline;

        SchemeTypeItem(String name) {
            this(name, null, null);
        }

        public SchemeTypeItem(String name, Integer igdType, Discipline discipline) {
            this.name = name;
            this.igdType = igdType;
            this.discipline = discipline;
        }

        abstract Collection<Comparable> getSchemes() throws SQLException;

        public String toString() {
            return this.name;
        }
    }
}

