/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.taxon.SynonymService;
import com.stratadata.model3.taxon.Taxon;
import com.stratadata.model3.taxon.TaxonService;
import com.stratadata.model3.taxon.TaxonServiceListener;
import com.stratadata.model3.taxon.process.TaxonDelete;
import com.stratadata.model3.validation.FieldLengthProperties;
import com.stratadata.sblicense.SbugsLicense;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import jsbugs.DialogEditOccurrences;
import jsbugs.DialogList;
import jsbugs.DialogMergeTaxa;
import jsbugs.DialogSelectEvent;
import jsbugs.DialogSelectTaxa;
import jsbugs.DialogSelectTaxaCode;
import jsbugs.DialogSynonymy;
import jsbugs.DialogTaxon;
import jsbugs.DialogTaxonCode;
import jsbugs.DialogTaxonNotes;
import jsbugs.DialogTaxonWellOcc;
import jsbugs.DialogWellDisc;
import jsbugs.FrameJsbugs;
import jsbugs.FrameTaxaDB;
import jsbugs.TaxonTableModel;
import jsbugs.TaxonTransferHandler;
import jsbugs.WebSearch;
import jsbugs.imagegallery.DialogTaxonImages;
import jsbugs.slidestore.DialogCabinet;
import jsbugs.taxa.DialogSelectTaxaAdv;
import jsbugs.taxa.DialogSelectTaxaAdvDict;
import jsbugs.userconnect.SbugsExceptionHandler;
import jsbugs.util.UserPrefsHelper;
import jsbugs.webservices.DialogConfigureWebCitationServices;
import jsbugs.webservices.WebCitationService;
import model3.Lastval;
import model3.SBRestrictable;
import model3.SBdb;
import model3.SynonymScheme;
import model3.TxGroup;
import model3.Well;
import model3.exception.SuppressedSQLException;
import model3.taxa.TaxonListener;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.layout.GroupLayout;
import util.SB;
import util.SBException;
import util.exception.StackError;

public class InternalFrameTaxa
extends JInternalFrame
implements TaxonListener,
TaxonServiceListener {
    private static final Logger LOGGER = Logger.getLogger(InternalFrameTaxa.class.getName());
    private final SBdb sbdb;
    final TaxonTableModel modelTaxa;
    private final FrameTaxaDB parent;
    private ButtonGroup buttonGroupSelection;
    private JButton jButtonClear;
    private JButton jButtonSelectAll;
    private JButton jButtonWebRefs;
    private JComboBox jComboBoxSynonymScheme;
    private JLabel jLabel1;
    private JMenuItem jMenuItemCodes;
    private JMenuItem jMenuItemDelete;
    private JMenuItem jMenuItemEdit;
    private JMenuItem jMenuItemEditOccs;
    private JMenuItem jMenuItemGroupMembership;
    private JMenuItem jMenuItemImages;
    private JMenuItem jMenuItemLinkedEvents;
    private JMenuItem jMenuItemRefNotes;
    private JMenuItem jMenuItemSearch;
    private JMenuItem jMenuItemSearchWell;
    private JMenuItem jMenuItemSlideStore;
    private JMenuItem jMenuItemSynonymy;
    private JMenuItem jMenuItemURL;
    private JMenuItem jMenuItemWebLookup;
    private JPanel jPanelTaxa;
    private JPopupMenu jPopupMenuTaxon;
    private JScrollPane jScrollPane4;
    private JPopupMenu.Separator jSeparator1;
    private JPopupMenu.Separator jSeparator2;
    private JTable jTableTaxa;

    public InternalFrameTaxa(FrameTaxaDB parent, SBdb db) {
        this.parent = parent;
        this.sbdb = db;
        this.modelTaxa = new TaxonTableModel(db.getTaxonService(), db.getSynonymService(), db.getUserService(), db.getTaxonImageService());
        this.initComponents();
        this.init();
    }

    private void init() {
        this.modelTaxa.setupTable(this.jTableTaxa, true, this.sbdb);
        this.sbdb.getTaxonService().addListener((TaxonServiceListener)this);
        this.setSynSchemeCombo();
        this.jTableTaxa.setDragEnabled(true);
        this.jTableTaxa.setTransferHandler(new TaxonTransferHandler(this.sbdb, null));
        this.jTableTaxa.setDropTarget(null);
        this.setTransferHandler(new TaxonTransferHandler(this.sbdb, null));
        if (!SBRestrictable.canWrite(this.sbdb)) {
            this.jMenuItemDelete.setEnabled(false);
        }
        if (FrameJsbugs.isMacPlatform()) {
            this.jComboBoxSynonymScheme.putClientProperty("JComboBox.isPopDown", Boolean.TRUE);
            this.jScrollPane4.setHorizontalScrollBarPolicy(32);
            this.jScrollPane4.setVerticalScrollBarPolicy(22);
        }
    }

    @Override
    public void onTaxonDetailsUpdated(model3.Taxon taxon) {
        this.jTableTaxa.repaint();
    }

    public void taxonUpdated(Taxon updatedTaxon) {
        this.modelTaxa.update(updatedTaxon);
        this.jTableTaxa.repaint();
    }

    @Override
    public void onTaxonDelete(model3.Taxon taxon) {
        this.modelTaxa.removeUnmanaged();
    }

    void webLookup() {
        List<model3.Taxon> selectedTaxa = this.getSelectedTaxa();
        if (selectedTaxa.isEmpty()) {
            JOptionPane.showMessageDialog(this, "No taxa selected", this.getTitle(), 2);
            return;
        }
        try {
            WebSearch webSearch = new WebSearch();
            for (model3.Taxon taxon : selectedTaxa) {
                Desktop.getDesktop().browse(new URI(webSearch.getURL(this.sbdb, switch (this.jTableTaxa.getSelectedColumn()) {
                    default -> taxon.toString(false, false);
                    case 1 -> taxon.getGenusName();
                    case 2 -> taxon.getSpecies();
                })));
            }
        }
        catch (Exception ex) {
            StackError.showStackError((String)ex.toString(), (Throwable)ex);
            ex.printStackTrace();
        }
    }

    void openUrl() {
        TaxonTableModel.TaxonRow taxonRow;
        model3.Taxon taxon = this.getSelectedTaxon().orElse(null);
        if (taxon == null) {
            JOptionPane.showMessageDialog(this, "No taxon selected", this.getTitle(), 2);
            return;
        }
        String url = taxon.getURL();
        if (StringUtils.isEmpty((CharSequence)url) && (taxonRow = this.modelTaxa.taxonList.get(this.jTableTaxa.convertRowIndexToModel(this.jTableTaxa.getSelectedRow()))).webCitation() != null) {
            url = taxonRow.webCitation().url();
        }
        if (StringUtils.isEmpty((CharSequence)url)) {
            JOptionPane.showMessageDialog(this, "Open References and Notes to store a URL", this.getTitle(), 2);
            return;
        }
        try {
            Desktop.getDesktop().browse(URI.create(url));
        }
        catch (IOException ioe) {
            SbugsExceptionHandler.showStackError(ioe, this.parent);
        }
    }

    void openEvents() {
        Taxon taxon = this.getSelectedDomainTaxon().orElse(null);
        if (taxon == null) {
            JOptionPane.showMessageDialog(this, "No taxa selected", this.getTitle(), 2);
            return;
        }
        try {
            DialogSelectEvent dialog = new DialogSelectEvent((Frame)this.parent, false, this.sbdb, true);
            dialog.setEventsFromSpecies(List.of(taxon), true);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }
        catch (RuntimeException | SQLException | SBException sql) {
            SbugsExceptionHandler.showStackError(sql, this.parent);
        }
    }

    void openSlideStore() {
        model3.Taxon taxon = this.getSelectedTaxon().orElse(null);
        if (taxon == null) {
            JOptionPane.showMessageDialog(this, "No taxon selected", this.getTitle(), 2);
            return;
        }
        try {
            if (taxon.nSlideStoreEntries() == 0) {
                JOptionPane.showMessageDialog(this, "Selected taxon has no specimens in the slide store.", this.getTitle(), 2);
            }
            DialogCabinet dialog = new DialogCabinet((Window)this.parent, this.sbdb, taxon.getSpecID());
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }
        catch (SQLException sql) {
            SbugsExceptionHandler.showStackError(sql, this.parent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void delete() {
        List<model3.Taxon> selectedTaxa = this.getSelectedTaxa();
        if (selectedTaxa.isEmpty()) {
            JOptionPane.showMessageDialog(this, "No taxa selected", this.getTitle(), 2);
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        ArrayList<Integer> specIDs = new ArrayList<Integer>();
        HashSet<Integer> genIDs = new HashSet<Integer>();
        try {
            for (model3.Taxon taxon : selectedTaxa) {
                if (taxon.hasEvents()) {
                    JOptionPane.showMessageDialog(this, "Taxon '" + String.valueOf(taxon) + "' is linked to Events and cannot be deleted.", "Taxa", 1);
                    continue;
                }
                if (this.sbdb.restrictedToDiscID(taxon.getDisc())) {
                    JOptionPane.showMessageDialog(this, "As a restricted user you can't delete taxon '" + taxon.toString() + "'", "Taxa", 1);
                    continue;
                }
                int nOccs = taxon.checkOcc(false);
                int nGroups = taxon.checkGroupOcc();
                String msg = "Do you want to delete taxon '" + String.valueOf(taxon) + "' which ";
                msg = msg + (String)(nOccs == 0 ? "does not occur" : "occurs " + (String)(nOccs > 1 ? nOccs + " times" : "once"));
                msg = msg + " in samples,\nand ";
                msg = msg + (String)(nGroups == 0 ? "does not occur" : "occurs " + (String)(nGroups > 1 ? nGroups + " times" : "once"));
                if (JOptionPane.showConfirmDialog(this, msg = msg + " in groups?", this.getTitle(), 0, 3) != 0) continue;
                specIDs.add(taxon.getSpecID());
                genIDs.add(taxon.getGenID());
            }
            if (specIDs.isEmpty()) {
                return;
            }
            try {
                TaxonDelete.deleteSpeciesOnly((TaxonService)this.sbdb.getTaxonService(), (SynonymService)this.sbdb.getSynonymService(), specIDs);
            }
            catch (RuntimeException ex) {
                SbugsExceptionHandler.showStackError(ex);
                this.setCursor(Cursor.getDefaultCursor());
                return;
            }
            Set unusedGenIDs = this.sbdb.getTaxonService().getUnusedGenera(genIDs);
            if (!unusedGenIDs.isEmpty()) {
                List genusNames = unusedGenIDs.stream().map(genID -> this.sbdb.getGenusService().findGenus(genID.intValue())).flatMap(Optional::stream).map(genus -> genus.toString(true)).collect(Collectors.toList());
                Object msg = StringUtils.join(genusNames, (String)"\n");
                msg = "Do you want to delete the unused " + (unusedGenIDs.size() == 1 ? "genus '" + (String)msg + "'?" : "genera:\n" + (String)msg + "?");
                int opt = JOptionPane.showConfirmDialog(this, msg, "Delete Taxa", 0);
                if (opt == 0) {
                    this.sbdb.getGenusService().deleteGenera((Collection)unusedGenIDs);
                } else {
                    unusedGenIDs.clear();
                }
            }
            this.sbdb.deleteSpeciesModel(specIDs, unusedGenIDs);
            String msg = (String)(specIDs.size() > 1 ? specIDs.size() + " taxa" : "1 taxon") + " deleted.";
            if (!unusedGenIDs.isEmpty()) {
                msg = msg + "\n" + (String)(unusedGenIDs.size() > 1 ? unusedGenIDs.size() + " genus" : "1 genus") + " deleted.";
            }
            JOptionPane.showMessageDialog(this, msg, "Delete taxa", 1);
        }
        catch (RuntimeException | SQLException ex) {
            SbugsExceptionHandler.showStackError(ex, this.parent);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    void searchAdv() {
        try {
            DialogSelectTaxaAdv dialog = new DialogSelectTaxaAdv(this.parent, this.sbdb);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (!dialog.getSelection().isEmpty()) {
                this.addFound(dialog.getSelection());
            }
        }
        catch (RuntimeException | SQLException ex) {
            SbugsExceptionHandler.showStackError(ex, this.parent);
        }
    }

    void searchAdvDict() {
        DialogSelectTaxaAdvDict dialog = new DialogSelectTaxaAdvDict(this.parent, this.sbdb);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (!dialog.getSelection().isEmpty()) {
            this.addFound(dialog.getSelection());
        }
    }

    void searchCode() {
        DialogSelectTaxaCode dialog = new DialogSelectTaxaCode((Frame)this.parent, true, this.sbdb);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.selection != null && dialog.selection.size() > 0) {
            this.addFound(dialog.selection);
        }
    }

    private void addFound(List<model3.Taxon> list) {
        DialogList<model3.Taxon> dList = new DialogList<model3.Taxon>(this.parent, true, "Taxa", new UserPrefsHelper(this.sbdb), list, true, true);
        dList.setLocationRelativeTo(this);
        dList.setVisible(true);
        if (dList.getSelected() != null) {
            for (model3.Taxon taxon : dList.getSelected()) {
                if (!this.modelTaxa.addTaxonIfAbsent(taxon.getTaxonCopy())) continue;
                taxon.registerListener(this);
            }
            this.sortTaxa();
            this.modelTaxa.fireTableDataChanged();
        }
    }

    void search(model3.Taxon selectedTaxon) {
        if (!SbugsLicense.checkRLMlicense()) {
            JOptionPane.showMessageDialog(this.parent, "StrataBugs licence no longer available.", "StrataBugs", 0);
            this.parent.dispose();
            return;
        }
        try {
            Taxon searchTemplate = selectedTaxon != null ? selectedTaxon.getTaxonCopy() : null;
            DialogSelectTaxa dialog = new DialogSelectTaxa(this.parent, true, this.sbdb, InternalFrameTaxa.getSynSchID(this.sbdb), false, searchTemplate);
            dialog.setVisible(true);
            if (!dialog.getSelectedItems().isEmpty()) {
                int lastIndex = -1;
                for (Taxon taxon : dialog.getSelectedItems()) {
                    if (!this.modelTaxa.addTaxonIfAbsent(taxon)) continue;
                    lastIndex = this.modelTaxa.taxonList.size() - 1;
                    try {
                        this.sbdb.getTaxon(taxon.getSpecID()).registerListener(this);
                    }
                    catch (SQLException ex) {
                        ex.printStackTrace();
                    }
                }
                this.sortTaxa();
                this.modelTaxa.fireTableDataChanged();
                if (lastIndex >= 0) {
                    this.jTableTaxa.scrollRectToVisible(this.jTableTaxa.getCellRect(this.jTableTaxa.convertRowIndexToView(lastIndex), 0, true));
                }
            }
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    void searchFromList() {
        model3.Taxon taxon = this.getSelectedTaxon().orElse(null);
        if (taxon == null) {
            JOptionPane.showMessageDialog(this, "No taxon selected", this.getTitle(), 2);
            return;
        }
        this.search(taxon);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void searchWell() {
        DialogWellDisc dialog = new DialogWellDisc(this.parent, true, this.sbdb, null, true);
        SB.centreDialog((Dialog)dialog);
        dialog.setVisible(true);
        if (dialog.isOK) {
            try {
                this.parent.setCursor(Cursor.getPredefinedCursor(3));
                for (Well well : dialog.wells) {
                    List<model3.Taxon> list = this.sbdb.getWellTaxa(well, dialog.discID, dialog.analyst);
                    for (model3.Taxon t : list) {
                        if (dialog.set != null && dialog.set.isMember(t.getSpecID(), 0)) continue;
                        this.modelTaxa.addTaxonIfAbsent(t.getTaxonCopy());
                        try {
                            this.sbdb.getTaxon(t.getSpecID()).registerListener(this);
                        }
                        catch (SQLException ex) {
                            ex.printStackTrace();
                        }
                    }
                }
                this.sortTaxa();
                this.modelTaxa.fireTableDataChanged();
            }
            catch (SQLException | SBException sql) {
                FrameJsbugs.showStackError("Error", (Exception)sql, this.sbdb);
            }
            finally {
                this.parent.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    void searchForImages() {
        try {
            List<model3.Taxon> list = this.sbdb.getTaxaWithImages();
            if (list.isEmpty()) {
                JOptionPane.showMessageDialog(this, "There are no taxa linked to images in the database", this.parent.getTitle(), 1);
                return;
            }
            Collections.sort(list);
            for (model3.Taxon taxon : list) {
                this.modelTaxa.addTaxonIfAbsent(taxon.getTaxonCopy());
            }
            this.sortTaxa();
            this.modelTaxa.fireTableDataChanged();
        }
        catch (RuntimeException | SQLException ex) {
            SbugsExceptionHandler.showStackError(ex, this.parent);
        }
    }

    void searchForSlideStoreTaxa() {
        try {
            List list = this.sbdb.getSlideStoreService().getAllSlideStoreSpecies();
            if (list.isEmpty()) {
                JOptionPane.showMessageDialog(this, "There are no taxa linked to collections in the database", this.parent.getTitle(), 1);
                return;
            }
            Collections.sort(list);
            for (Integer specID : list) {
                this.sbdb.getTaxonService().findTaxon(specID.intValue()).ifPresent(taxon -> this.modelTaxa.addTaxonIfAbsent((Taxon)taxon));
            }
            this.sortTaxa();
            this.modelTaxa.fireTableDataChanged();
        }
        catch (RuntimeException ex) {
            SbugsExceptionHandler.showStackError(ex, this.parent);
        }
    }

    void searchWellOcc() {
        model3.Taxon taxon = this.getSelectedTaxon().orElse(null);
        if (taxon == null) {
            JOptionPane.showMessageDialog(this, "No taxon selected", this.getTitle(), 2);
            return;
        }
        try {
            DialogTaxonWellOcc dialog = new DialogTaxonWellOcc((Frame)this.parent, true, this.sbdb, taxon);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.selectedItem != null) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.parent.parent.setSamplesSmpdtl(dialog.well, dialog.getSelectedSmpdtl());
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
        catch (SBException sbe) {
            StackError.showStackError((String)"Error", (Throwable)sbe);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    void merge() {
        if (this.jTableTaxa.getSelectedRowCount() < 2) {
            JOptionPane.showMessageDialog(this, "You must select at least 2 taxa from the list to merge", this.getTitle(), 1);
            return;
        }
        List<model3.Taxon> taxa = this.getSelectedTaxa();
        try {
            DialogMergeTaxa dialog = new DialogMergeTaxa(this.parent, true, this.sbdb, taxa, this.parent.parent.getChartManager());
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.isOK()) {
                this.jTableTaxa.clearSelection();
                this.modelTaxa.removeUnmanaged();
                this.modelTaxa.updateAll();
                this.modelTaxa.fireTableDataChanged();
            }
        }
        catch (RuntimeException | SQLException e) {
            SbugsExceptionHandler.showStackError(e, this.parent);
        }
    }

    void setSynSchemeCombo() {
        this.jComboBoxSynonymScheme.removeAllItems();
        try {
            int synSchId = Lastval.getInt(this.sbdb, "SYNSCHID", 1);
            if (synSchId == 0) {
                synSchId = 1;
            }
            SynonymScheme selected = null;
            for (SynonymScheme s : this.sbdb.getSynSchemes()) {
                this.jComboBoxSynonymScheme.addItem(s);
                if (s.getSchID() != synSchId) continue;
                selected = s;
            }
            if (selected != null) {
                this.jComboBoxSynonymScheme.setSelectedItem((Object)selected);
            }
        }
        catch (Exception e) {
            this.jComboBoxSynonymScheme.setEnabled(false);
            e.printStackTrace();
        }
    }

    void synonymy() {
        Taxon taxon = this.getSelectedDomainTaxon().orElse(null);
        if (taxon == null) {
            JOptionPane.showMessageDialog(this, "No taxon selected", this.getTitle(), 2);
            return;
        }
        try {
            DialogSynonymy dialog = new DialogSynonymy(this.parent, true, this.sbdb, taxon, ((SynonymScheme)((Object)this.jComboBoxSynonymScheme.getSelectedItem())).getSchID());
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.isOK()) {
                this.modelTaxa.updateAll();
                this.modelTaxa.fireTableDataChanged();
            }
            this.setSynSchemeCombo();
        }
        catch (RuntimeException | SQLException e) {
            SbugsExceptionHandler.showStackError(e, this.parent);
        }
    }

    void notes() {
        int opt;
        model3.Taxon taxon = this.getSelectedTaxon().orElse(null);
        if (taxon == null) {
            JOptionPane.showMessageDialog(this, "No taxon selected", this.getTitle(), 2);
            return;
        }
        Taxon taxonCopy = taxon.getTaxonCopy();
        TaxonTableModel.TaxonRow taxonRow = this.modelTaxa.taxonList.get(this.jTableTaxa.convertRowIndexToModel(this.jTableTaxa.getSelectedRow()));
        if (taxonRow.webCitation() != null && (opt = JOptionPane.showConfirmDialog(this.parent, "Import web citation (where existing is blank)?", "References and Notes", 0)) == 0) {
            if (StringUtils.isBlank((CharSequence)taxonCopy.getUrl())) {
                taxonCopy.setUrl(taxonRow.webCitation().url());
            }
            if (StringUtils.isBlank((CharSequence)taxonCopy.getReference())) {
                String source = taxonRow.webCitation().source();
                String reference = taxonRow.webCitation().reference();
                String citation = !StringUtils.isBlank((CharSequence)source) && !StringUtils.isBlank((CharSequence)reference) ? source + ": " + reference : source + reference;
                taxonCopy.setReference(citation);
            }
        }
        DialogTaxonNotes dialog = new DialogTaxonNotes(this.parent, true, this.sbdb.getTaxonService(), taxonCopy);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.isOK()) {
            this.jTableTaxa.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void edit() {
        model3.Taxon taxon = this.getSelectedTaxon().orElse(null);
        if (taxon == null) {
            JOptionPane.showMessageDialog(this, "No taxon selected", this.getTitle(), 2);
            return;
        }
        try {
            switch (this.jTableTaxa.getSelectedColumn()) {
                case 6: {
                    if (Runtime.getRuntime().freeMemory() < 0x100000L) {
                        System.out.println("Memory: " + Runtime.getRuntime().freeMemory());
                        JOptionPane.showMessageDialog(null, "Running low on allocated memory - you may want to close the Control Panel now to avoid problems....", "StrataBugs", 0);
                    }
                    this.showImages();
                    break;
                }
                case 5: {
                    this.synonymy();
                    break;
                }
                default: {
                    DialogTaxon dialog = new DialogTaxon(this.parent, true, this.sbdb, taxon, false, this.parent.parent.getChartManager());
                    SB.centreDialog((Dialog)dialog);
                    dialog.setVisible(true);
                    TaxonTableModel taxonTableModel = this.modelTaxa;
                    synchronized (taxonTableModel) {
                        this.modelTaxa.removeUnmanaged();
                    }
                    this.modelTaxa.fireTableDataChanged();
                    int newIndex = this.modelTaxa.getIndex(taxon.getSpecID());
                    if (newIndex <= -1) break;
                    int index = this.jTableTaxa.convertRowIndexToView(newIndex);
                    this.jTableTaxa.setRowSelectionInterval(index, index);
                }
            }
            taxon.notifyListeners();
        }
        catch (RuntimeException e) {
            SbugsExceptionHandler.showStackError(e);
        }
    }

    Optional<model3.Taxon> getSelectedTaxon() {
        if (this.jTableTaxa.getSelectedRow() < 0) {
            return Optional.empty();
        }
        Taxon selectedTaxon = this.modelTaxa.getTaxon(this.jTableTaxa.convertRowIndexToModel(this.jTableTaxa.getSelectedRow()));
        if (selectedTaxon != null) {
            try {
                return Optional.ofNullable(this.sbdb.getTaxon(selectedTaxon.getSpecID()));
            }
            catch (SQLException e) {
                SbugsExceptionHandler.showStackError("Error converting taxon", e);
            }
        }
        return Optional.empty();
    }

    Optional<Taxon> getSelectedDomainTaxon() {
        if (this.jTableTaxa.getSelectedRow() < 0) {
            return Optional.empty();
        }
        return Optional.of(this.modelTaxa.getTaxon(this.jTableTaxa.convertRowIndexToModel(this.jTableTaxa.getSelectedRow())));
    }

    List<model3.Taxon> getSelectedTaxa() {
        if (this.jTableTaxa.getSelectedRow() < 0) {
            Collections.emptyList();
        }
        LinkedList<model3.Taxon> list = new LinkedList<model3.Taxon>();
        try {
            int[] nArray = this.jTableTaxa.getSelectedRows();
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                Integer selectedRowIndex = nArray[i];
                list.add(this.sbdb.getTaxon(this.modelTaxa.getTaxon(this.jTableTaxa.convertRowIndexToModel(selectedRowIndex)).getSpecID()));
            }
        }
        catch (SQLException sql) {
            SbugsExceptionHandler.showStackError("Error converting taxon", sql);
        }
        return list;
    }

    List<model3.Taxon> getAllTaxa() {
        LinkedList<model3.Taxon> list = new LinkedList<model3.Taxon>();
        for (TaxonTableModel.TaxonRow row : this.modelTaxa.taxonList) {
            try {
                list.add(this.sbdb.getTaxon(row.taxon().getSpecID()));
            }
            catch (SQLException sql) {
                throw SuppressedSQLException.withoutRollback(sql);
            }
        }
        return list;
    }

    void numericCodes() {
        model3.Taxon taxon = this.getSelectedTaxon().orElse(null);
        if (taxon == null) {
            JOptionPane.showMessageDialog(this, "No taxon selected", this.getTitle(), 2);
            return;
        }
        try {
            DialogTaxonCode dialog = new DialogTaxonCode((Frame)this.parent, true, this.sbdb, taxon);
            SB.centreDialog((Dialog)dialog);
            dialog.setVisible(true);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
    }

    void showImages() {
        model3.Taxon taxon = this.getSelectedTaxon().orElse(null);
        if (taxon == null) {
            JOptionPane.showMessageDialog(this, "No taxon selected", this.getTitle(), 2);
            return;
        }
        try {
            DialogTaxonImages dialog = DialogTaxonImages.imageGalleryDialogForTaxon(this.parent, taxon, this.sbdb);
            dialog.enableAnalysisSelection();
            dialog.setLocationRelativeTo(this.parent);
            dialog.setVisible(true);
            if (dialog.getSelectedAnalysis() != null) {
                this.parent.parent.setSamplesSmpdtl(dialog.getSelectedAnalysis().well(), dialog.getSelectedAnalysis().smpdtl());
            }
        }
        catch (SQLException | SBException ex) {
            SbugsExceptionHandler.showStackError(ex);
        }
    }

    void editOccType() {
        model3.Taxon taxon = this.getSelectedTaxon().orElse(null);
        if (taxon == null) {
            JOptionPane.showMessageDialog(this, "No taxon selected", this.getTitle(), 2);
            return;
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            DialogEditOccurrences dialog = new DialogEditOccurrences((Frame)this.parent, true, this.sbdb, taxon);
            SB.centreDialog((Dialog)dialog);
            dialog.setVisible(true);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), this.getTitle(), 0);
            ex.printStackTrace();
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private int getRowOf(Object o) {
        for (int i = 0; i < this.modelTaxa.taxonList.size(); ++i) {
            if (this.modelTaxa.taxonList.get(this.jTableTaxa.convertRowIndexToModel(i)) != o) continue;
            return i;
        }
        return -1;
    }

    void add() {
        try {
            DialogTaxon dialog = new DialogTaxon(this.parent, true, this.sbdb, null, false, this.parent.parent.getChartManager());
            SB.centreDialog((Dialog)dialog);
            dialog.setVisible(true);
            if (dialog.taxon != null) {
                dialog.taxon.registerListener(this);
                this.modelTaxa.addTaxonIfAbsent(dialog.taxon.getTaxonCopy());
                this.sortTaxa();
                this.modelTaxa.fireTableDataChanged();
                this.jTableTaxa.scrollRectToVisible(this.jTableTaxa.getCellRect(this.jTableTaxa.convertRowIndexToView(this.modelTaxa.taxonList.size() - 1), 0, true));
                int index = this.getRowOf(dialog.taxon);
                if (index >= 0) {
                    this.jTableTaxa.setRowSelectionInterval(index, index);
                }
            }
        }
        catch (RuntimeException ex) {
            SbugsExceptionHandler.showStackError(ex);
        }
    }

    boolean addTaxa(Collection<model3.Taxon> list) {
        int initialSize = this.modelTaxa.taxonList.size();
        for (model3.Taxon tx : list) {
            if (!this.modelTaxa.addTaxonIfAbsent(tx.getTaxonCopy())) continue;
            tx.registerListener(this);
        }
        if (this.modelTaxa.taxonList.size() > initialSize) {
            this.sortTaxa();
            this.modelTaxa.fireTableDataChanged();
            return true;
        }
        return false;
    }

    private void initComponents() {
        this.buttonGroupSelection = new ButtonGroup();
        this.jPopupMenuTaxon = new JPopupMenu();
        this.jMenuItemEdit = new JMenuItem();
        this.jMenuItemDelete = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.jMenuItemWebLookup = new JMenuItem();
        this.jMenuItemURL = new JMenuItem();
        this.jMenuItemSearchWell = new JMenuItem();
        this.jMenuItemSearch = new JMenuItem();
        this.jSeparator2 = new JPopupMenu.Separator();
        this.jMenuItemImages = new JMenuItem();
        this.jMenuItemSlideStore = new JMenuItem();
        this.jMenuItemLinkedEvents = new JMenuItem();
        this.jMenuItemCodes = new JMenuItem();
        this.jMenuItemSynonymy = new JMenuItem();
        this.jMenuItemGroupMembership = new JMenuItem();
        this.jMenuItemRefNotes = new JMenuItem();
        this.jMenuItemEditOccs = new JMenuItem();
        this.jPanelTaxa = new JPanel();
        this.jScrollPane4 = new JScrollPane();
        this.jTableTaxa = new JTable();
        this.jLabel1 = new JLabel();
        this.jComboBoxSynonymScheme = new JComboBox();
        this.jButtonSelectAll = new JButton();
        this.jButtonClear = new JButton();
        this.jButtonWebRefs = new JButton();
        this.jMenuItemEdit.setText("Edit...");
        this.jMenuItemEdit.addActionListener(new ActionListener(this){
            final /* synthetic */ InternalFrameTaxa this$0;
            {
                InternalFrameTaxa internalFrameTaxa = this$0;
                Objects.requireNonNull(internalFrameTaxa);
                this.this$0 = internalFrameTaxa;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemEditActionPerformed(evt);
            }
        });
        this.jPopupMenuTaxon.add(this.jMenuItemEdit);
        this.jMenuItemDelete.setText("Delete");
        this.jMenuItemDelete.addActionListener(new ActionListener(this){
            final /* synthetic */ InternalFrameTaxa this$0;
            {
                InternalFrameTaxa internalFrameTaxa = this$0;
                Objects.requireNonNull(internalFrameTaxa);
                this.this$0 = internalFrameTaxa;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemDeleteActionPerformed(evt);
            }
        });
        this.jPopupMenuTaxon.add(this.jMenuItemDelete);
        this.jPopupMenuTaxon.add(this.jSeparator1);
        this.jMenuItemWebLookup.setText("Search web...");
        this.jMenuItemWebLookup.setToolTipText("Looks up select genus or species or entire name in your web browser");
        this.jMenuItemWebLookup.addActionListener(new ActionListener(this){
            final /* synthetic */ InternalFrameTaxa this$0;
            {
                InternalFrameTaxa internalFrameTaxa = this$0;
                Objects.requireNonNull(internalFrameTaxa);
                this.this$0 = internalFrameTaxa;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemWebLookupActionPerformed(evt);
            }
        });
        this.jPopupMenuTaxon.add(this.jMenuItemWebLookup);
        this.jMenuItemURL.setText("Go to URL...");
        this.jMenuItemURL.addActionListener(new ActionListener(this){
            final /* synthetic */ InternalFrameTaxa this$0;
            {
                InternalFrameTaxa internalFrameTaxa = this$0;
                Objects.requireNonNull(internalFrameTaxa);
                this.this$0 = internalFrameTaxa;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemURLActionPerformed(evt);
            }
        });
        this.jPopupMenuTaxon.add(this.jMenuItemURL);
        this.jMenuItemSearchWell.setText("Search wells...");
        this.jMenuItemSearchWell.addActionListener(new ActionListener(this){
            final /* synthetic */ InternalFrameTaxa this$0;
            {
                InternalFrameTaxa internalFrameTaxa = this$0;
                Objects.requireNonNull(internalFrameTaxa);
                this.this$0 = internalFrameTaxa;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemSearchWellActionPerformed(evt);
            }
        });
        this.jPopupMenuTaxon.add(this.jMenuItemSearchWell);
        this.jMenuItemSearch.setText("Search database...");
        this.jMenuItemSearch.addActionListener(new ActionListener(this){
            final /* synthetic */ InternalFrameTaxa this$0;
            {
                InternalFrameTaxa internalFrameTaxa = this$0;
                Objects.requireNonNull(internalFrameTaxa);
                this.this$0 = internalFrameTaxa;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemSearchActionPerformed(evt);
            }
        });
        this.jPopupMenuTaxon.add(this.jMenuItemSearch);
        this.jPopupMenuTaxon.add(this.jSeparator2);
        this.jMenuItemImages.setText("Images...");
        this.jMenuItemImages.addActionListener(new ActionListener(this){
            final /* synthetic */ InternalFrameTaxa this$0;
            {
                InternalFrameTaxa internalFrameTaxa = this$0;
                Objects.requireNonNull(internalFrameTaxa);
                this.this$0 = internalFrameTaxa;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemImagesActionPerformed(evt);
            }
        });
        this.jPopupMenuTaxon.add(this.jMenuItemImages);
        this.jMenuItemSlideStore.setText("Slide store...");
        this.jMenuItemSlideStore.addActionListener(new ActionListener(this){
            final /* synthetic */ InternalFrameTaxa this$0;
            {
                InternalFrameTaxa internalFrameTaxa = this$0;
                Objects.requireNonNull(internalFrameTaxa);
                this.this$0 = internalFrameTaxa;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemSlideStoreActionPerformed(evt);
            }
        });
        this.jPopupMenuTaxon.add(this.jMenuItemSlideStore);
        this.jMenuItemLinkedEvents.setText("Linked Events...");
        this.jMenuItemLinkedEvents.addActionListener(new ActionListener(this){
            final /* synthetic */ InternalFrameTaxa this$0;
            {
                InternalFrameTaxa internalFrameTaxa = this$0;
                Objects.requireNonNull(internalFrameTaxa);
                this.this$0 = internalFrameTaxa;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemLinkedEventsActionPerformed(evt);
            }
        });
        this.jPopupMenuTaxon.add(this.jMenuItemLinkedEvents);
        this.jMenuItemCodes.setText("Numeric codes...");
        this.jMenuItemCodes.addActionListener(new ActionListener(this){
            final /* synthetic */ InternalFrameTaxa this$0;
            {
                InternalFrameTaxa internalFrameTaxa = this$0;
                Objects.requireNonNull(internalFrameTaxa);
                this.this$0 = internalFrameTaxa;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemCodesActionPerformed(evt);
            }
        });
        this.jPopupMenuTaxon.add(this.jMenuItemCodes);
        this.jMenuItemSynonymy.setText("Synonymy...");
        this.jMenuItemSynonymy.addActionListener(new ActionListener(this){
            final /* synthetic */ InternalFrameTaxa this$0;
            {
                InternalFrameTaxa internalFrameTaxa = this$0;
                Objects.requireNonNull(internalFrameTaxa);
                this.this$0 = internalFrameTaxa;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemSynonymyActionPerformed(evt);
            }
        });
        this.jPopupMenuTaxon.add(this.jMenuItemSynonymy);
        this.jMenuItemGroupMembership.setText("Group membership...");
        this.jMenuItemGroupMembership.addActionListener(new ActionListener(this){
            final /* synthetic */ InternalFrameTaxa this$0;
            {
                InternalFrameTaxa internalFrameTaxa = this$0;
                Objects.requireNonNull(internalFrameTaxa);
                this.this$0 = internalFrameTaxa;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemGroupMembershipActionPerformed(evt);
            }
        });
        this.jPopupMenuTaxon.add(this.jMenuItemGroupMembership);
        this.jMenuItemRefNotes.setText("References and notes...");
        this.jMenuItemRefNotes.addActionListener(new ActionListener(this){
            final /* synthetic */ InternalFrameTaxa this$0;
            {
                InternalFrameTaxa internalFrameTaxa = this$0;
                Objects.requireNonNull(internalFrameTaxa);
                this.this$0 = internalFrameTaxa;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemRefNotesActionPerformed(evt);
            }
        });
        this.jPopupMenuTaxon.add(this.jMenuItemRefNotes);
        this.jMenuItemEditOccs.setText("Edit occurrences...");
        this.jMenuItemEditOccs.addActionListener(new ActionListener(this){
            final /* synthetic */ InternalFrameTaxa this$0;
            {
                InternalFrameTaxa internalFrameTaxa = this$0;
                Objects.requireNonNull(internalFrameTaxa);
                this.this$0 = internalFrameTaxa;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemEditOccsActionPerformed(evt);
            }
        });
        this.jPopupMenuTaxon.add(this.jMenuItemEditOccs);
        this.setDefaultCloseOperation(0);
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.setTitle("Taxa");
        this.setFrameIcon(new ImageIcon(this.getClass().getResource("/resources/icon/FrameSamples_OccTab.png")));
        this.setMinimumSize(new Dimension(520, 200));
        this.jPanelTaxa.setMaximumSize(new Dimension(500, Short.MAX_VALUE));
        this.jPanelTaxa.setMinimumSize(new Dimension(150, 100));
        this.jPanelTaxa.setPreferredSize(new Dimension(225, 100));
        this.jTableTaxa.setModel(this.modelTaxa);
        this.jTableTaxa.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ InternalFrameTaxa this$0;
            {
                InternalFrameTaxa internalFrameTaxa = this$0;
                Objects.requireNonNull(internalFrameTaxa);
                this.this$0 = internalFrameTaxa;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.this$0.jTableTaxaMouseClicked(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                this.this$0.jTableTaxaMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                this.this$0.jTableTaxaMouseReleased(evt);
            }
        });
        this.jTableTaxa.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ InternalFrameTaxa this$0;
            {
                InternalFrameTaxa internalFrameTaxa = this$0;
                Objects.requireNonNull(internalFrameTaxa);
                this.this$0 = internalFrameTaxa;
            }

            @Override
            public void keyPressed(KeyEvent evt) {
                this.this$0.jTableTaxaKeyPressed(evt);
            }
        });
        this.jScrollPane4.setViewportView(this.jTableTaxa);
        this.jLabel1.setHorizontalAlignment(11);
        this.jLabel1.setText("Synonym Scheme:");
        this.jComboBoxSynonymScheme.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBoxSynonymScheme.addActionListener(new ActionListener(this){
            final /* synthetic */ InternalFrameTaxa this$0;
            {
                InternalFrameTaxa internalFrameTaxa = this$0;
                Objects.requireNonNull(internalFrameTaxa);
                this.this$0 = internalFrameTaxa;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jComboBoxSynonymSchemeActionPerformed(evt);
            }
        });
        this.jButtonSelectAll.setText("Select all");
        this.jButtonSelectAll.addActionListener(new ActionListener(this){
            final /* synthetic */ InternalFrameTaxa this$0;
            {
                InternalFrameTaxa internalFrameTaxa = this$0;
                Objects.requireNonNull(internalFrameTaxa);
                this.this$0 = internalFrameTaxa;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSelectAllActionPerformed(evt);
            }
        });
        this.jButtonClear.setText("Clear selected");
        this.jButtonClear.addActionListener(new ActionListener(this){
            final /* synthetic */ InternalFrameTaxa this$0;
            {
                InternalFrameTaxa internalFrameTaxa = this$0;
                Objects.requireNonNull(internalFrameTaxa);
                this.this$0 = internalFrameTaxa;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonClearActionPerformed(evt);
            }
        });
        this.jButtonWebRefs.setText("Web references ...");
        this.jButtonWebRefs.addActionListener(new ActionListener(this){
            final /* synthetic */ InternalFrameTaxa this$0;
            {
                InternalFrameTaxa internalFrameTaxa = this$0;
                Objects.requireNonNull(internalFrameTaxa);
                this.this$0 = internalFrameTaxa;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonWebRefsActionPerformed(evt);
            }
        });
        GroupLayout jPanelTaxaLayout = new GroupLayout((Container)this.jPanelTaxa);
        this.jPanelTaxa.setLayout((LayoutManager)jPanelTaxaLayout);
        jPanelTaxaLayout.setHorizontalGroup((GroupLayout.Group)jPanelTaxaLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelTaxaLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelTaxaLayout.createParallelGroup(1).add((Component)this.jScrollPane4, -1, 692, Short.MAX_VALUE).add((GroupLayout.Group)jPanelTaxaLayout.createSequentialGroup().add((Component)this.jButtonSelectAll).addPreferredGap(0).add((Component)this.jButtonClear).addPreferredGap(0, 125, Short.MAX_VALUE).add((Component)this.jButtonWebRefs).addPreferredGap(1).add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.jComboBoxSynonymScheme, -2, 150, -2))).addContainerGap()));
        jPanelTaxaLayout.setVerticalGroup((GroupLayout.Group)jPanelTaxaLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelTaxaLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelTaxaLayout.createParallelGroup(3).add((Component)this.jComboBoxSynonymScheme, -2, -1, -2).add((Component)this.jLabel1).add((Component)this.jButtonSelectAll).add((Component)this.jButtonClear).add((Component)this.jButtonWebRefs)).add(11, 11, 11).add((Component)this.jScrollPane4, -1, 487, Short.MAX_VALUE).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanelTaxa, -1, 704, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanelTaxa, -1, 595, Short.MAX_VALUE));
        this.pack();
    }

    private void jComboBoxSynonymSchemeActionPerformed(ActionEvent evt) {
        SynonymScheme scheme = (SynonymScheme)((Object)this.jComboBoxSynonymScheme.getSelectedItem());
        if (scheme != null && this.modelTaxa != null && scheme.getSchID() != this.modelTaxa.getSynSchemeID()) {
            this.modelTaxa.setSynSchemeID(scheme.getSchID());
            this.modelTaxa.updateAll();
            try {
                Lastval.putInt(this.sbdb, "SYNSCHID", this.modelTaxa.getSynSchemeID());
                this.sbdb.commit();
            }
            catch (SQLException sqle) {
                sqle.printStackTrace();
                this.sbdb.doRollback();
            }
            this.modelTaxa.fireTableDataChanged();
        }
    }

    private void jTableTaxaMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.edit();
        }
    }

    private void jButtonClearActionPerformed(ActionEvent evt) {
        List<model3.Taxon> toRemove = this.getSelectedTaxa();
        if (this.jTableTaxa.getSelectedRowCount() == 0) {
            JOptionPane.showMessageDialog(this, "No taxa selected", this.parent.getTitle(), 2);
            return;
        }
        for (model3.Taxon t : toRemove) {
            t.deleteListener(this);
        }
        this.modelTaxa.remove(toRemove.stream().map(taxon -> taxon.getTaxonCopy()).toList());
        this.jTableTaxa.clearSelection();
        this.sortTaxa();
        this.modelTaxa.fireTableDataChanged();
    }

    private void jButtonSelectAllActionPerformed(ActionEvent evt) {
        this.jTableTaxa.selectAll();
    }

    private void jTableTaxaKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 127) {
            this.jButtonClearActionPerformed(null);
        }
    }

    private void jMenuItemDeleteActionPerformed(ActionEvent evt) {
        this.delete();
    }

    private void jTableTaxaMouseReleased(MouseEvent evt) {
        this.evaluatePopup(evt);
    }

    private void evaluatePopup(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            int rowNumber = this.jTableTaxa.rowAtPoint(evt.getPoint());
            this.jTableTaxa.getSelectionModel().setSelectionInterval(rowNumber, rowNumber);
            this.jPopupMenuTaxon.show(evt.getComponent(), (int)evt.getPoint().getX(), (int)evt.getPoint().getY());
        }
    }

    private void jMenuItemWebLookupActionPerformed(ActionEvent evt) {
        this.webLookup();
    }

    private void jMenuItemSearchWellActionPerformed(ActionEvent evt) {
        this.searchWellOcc();
    }

    private void jMenuItemSearchActionPerformed(ActionEvent evt) {
        this.searchFromList();
    }

    private void jMenuItemEditActionPerformed(ActionEvent evt) {
        this.edit();
    }

    private void jMenuItemImagesActionPerformed(ActionEvent evt) {
        this.showImages();
    }

    private void jMenuItemSynonymyActionPerformed(ActionEvent evt) {
        this.synonymy();
    }

    private void jMenuItemCodesActionPerformed(ActionEvent evt) {
        this.numericCodes();
    }

    private void jMenuItemGroupMembershipActionPerformed(ActionEvent evt) {
        this.groupMembership();
    }

    private void jMenuItemRefNotesActionPerformed(ActionEvent evt) {
        this.notes();
    }

    private void jMenuItemEditOccsActionPerformed(ActionEvent evt) {
        this.editOccType();
    }

    private void jMenuItemURLActionPerformed(ActionEvent evt) {
        this.openUrl();
    }

    private void jTableTaxaMousePressed(MouseEvent evt) {
        this.evaluatePopup(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonWebRefsActionPerformed(ActionEvent evt) {
        DialogConfigureWebCitationServices dialog = new DialogConfigureWebCitationServices((Frame)this.parent, true, this.sbdb);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.getSelectedServices().isEmpty()) {
            return;
        }
        try {
            String messageTitle = "Web Citations Query";
            this.setCursor(Cursor.getPredefinedCursor(3));
            int found = 0;
            this.jTableTaxa.clearSelection();
            try {
                for (TaxonTableModel.TaxonRow taxonRow : this.modelTaxa.taxonList) {
                    WebCitationService.WebCitation citation = WebCitationService.wsQueryTaxon(dialog.getSelectedServices(), taxonRow.taxon());
                    if (citation != null) {
                        ++found;
                    }
                    this.modelTaxa.setCitation(taxonRow.taxon(), citation);
                }
            }
            catch (IOException ioe) {
                SbugsExceptionHandler.showStackError("Error running query", ioe, this.parent);
                this.setCursor(Cursor.getDefaultCursor());
                return;
            }
            TableColumn column = this.jTableTaxa.getColumnModel().getColumn(9);
            if (found > 0) {
                if (column.getMaxWidth() == 0) {
                    column.setMaxWidth(1000);
                    column.setPreferredWidth(150);
                }
                this.modelTaxa.fireTableDataChanged();
            } else {
                column.setPreferredWidth(0);
            }
            String message = found + " of " + this.modelTaxa.taxonList.size() + " taxa were found.";
            if (found > 0 && dialog.getSelectedServices().contains(0)) {
                int nUpdated = 0;
                Object[] buttons = new String[]{"Add if new", "Add and replace existing", "Do not change"};
                int opt = JOptionPane.showOptionDialog(this, message + "\nDo you want to update the Author in your database for these taxa using citations from Mikrotax?", "Web Citations Query", 1, 3, null, buttons, null);
                if (opt != 2) {
                    int authorFieldLength = FieldLengthProperties.getFieldLength(Taxon.class, (String)"author", (int)100);
                    for (TaxonTableModel.TaxonRow taxonRow : this.modelTaxa.taxonList) {
                        if (taxonRow.webCitation() == null || taxonRow.webCitation().serviceID() == 0 || "(no citation)".equals(taxonRow.webCitation().reference())) continue;
                        String newAuthorString = StringUtils.truncate((String)taxonRow.webCitation().reference(), (int)authorFieldLength);
                        if (opt != 1 && !taxonRow.taxon().getAuthor().isEmpty() || newAuthorString.equals(taxonRow.taxon().getAuthorString(true).trim())) continue;
                        taxonRow.taxon().setAuthor(newAuthorString);
                        try {
                            this.sbdb.getTaxonService().updateTaxon(taxonRow.taxon().getSpecID(), taxonRow.taxon());
                            ++nUpdated;
                        }
                        catch (RuntimeException ex) {
                            SbugsExceptionHandler.showStackError(ex, this.parent);
                        }
                    }
                    JOptionPane.showMessageDialog(this.parent, nUpdated + " taxa updated.", "Web Citations Query", 1);
                    this.modelTaxa.fireTableDataChanged();
                }
            } else {
                JOptionPane.showMessageDialog(this.parent, message, "Web Citations Query", 1);
            }
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jMenuItemLinkedEventsActionPerformed(ActionEvent evt) {
        this.openEvents();
    }

    private void jMenuItemSlideStoreActionPerformed(ActionEvent evt) {
        this.openSlideStore();
    }

    void groupMembership() {
        model3.Taxon taxon = this.getSelectedTaxon().orElse(null);
        if (taxon == null) {
            JOptionPane.showMessageDialog(this, "No taxon selected", this.getTitle(), 2);
            return;
        }
        try {
            List<TxGroup> list = taxon.getGroups();
            DialogList.displayListDialog(this.parent, "Groups : " + taxon.toString(false, false), new UserPrefsHelper(this.sbdb), list, null);
        }
        catch (RuntimeException | SQLException | SBException ex) {
            SbugsExceptionHandler.showStackError(ex, this.parent);
        }
    }

    void writeCSV(File file, char delim) throws IOException {
        try (FileWriter out = new FileWriter(file);){
            for (int row = 0; row < this.modelTaxa.getRowCount(); ++row) {
                for (int col = 0; col < this.modelTaxa.getColumnCount(); ++col) {
                    Object obj = this.modelTaxa.getValueAt(row, col);
                    if (obj != null) {
                        if (obj.toString().contains("" + delim)) {
                            out.write("\"" + String.valueOf(obj) + "\"");
                        } else {
                            out.write(String.valueOf(obj));
                        }
                    }
                    out.write(delim);
                }
                out.write("\r\n");
            }
            out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void findSimilar() {
        if (this.jTableTaxa.getRowCount() > 0) {
            opt = JOptionPane.showConfirmDialog(this, "This option will search for all similar taxa, from the entire dictionary, for potential merging.\nIt may take several minutes to load the list.\nClear existing taxa list first?", this.parent.getTitle(), 1, 3);
            if (opt == 2 || opt == -1) {
                return;
            }
            if (opt == 0) {
                this.modelTaxa.taxonList.clear();
                this.jTableTaxa.clearSelection();
                this.sortTaxa();
                this.modelTaxa.fireTableDataChanged();
            }
        } else {
            opt = JOptionPane.showConfirmDialog(this, "This option will search for all similar taxa, from the entire dictionary, for potential merging.\nIt may take several minutes to load the list.\nContinue?", this.parent.getTitle(), 0, 3);
            if (opt != 0) {
                return;
            }
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.sbdb.loadTaxa();
            for (model3.Taxon taxon : this.sbdb.getTaxa()) {
                for (model3.Taxon taxon2 : this.sbdb.getTaxa()) {
                    if (taxon == taxon2 || !taxon.toString(false, false).equalsIgnoreCase(taxon2.toString(false, false))) continue;
                    this.modelTaxa.addTaxonIfAbsent(taxon.getTaxonCopy());
                    this.modelTaxa.addTaxonIfAbsent(taxon2.getTaxonCopy());
                }
            }
            this.sortTaxa();
            this.modelTaxa.fireTableDataChanged();
        }
        catch (Exception ex) {
            StackError.showStackError((String)ex.toString(), (Throwable)ex);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void sortTaxa() {
    }

    public static int getSynSchID(SBdb db) {
        try {
            SynonymScheme selected;
            int synSchId = Lastval.getInt(db, "SYNSCHID", 1);
            if (synSchId == 0) {
                synSchId = 1;
            }
            if ((selected = db.getSynSch(synSchId)) == null) {
                synSchId = 1;
            }
            return synSchId;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showImageGalleryForSelectedTaxa() {
        if (this.modelTaxa.getRowCount() == 0) {
            JOptionPane.showMessageDialog(this, "Populate the taxon list with one or more taxa", this.parent.getTitle(), 1);
            return;
        }
        try {
            List<model3.Taxon> selectedTaxa = this.getSelectedTaxa();
            if (selectedTaxa.isEmpty()) {
                for (int i = 0; i < this.modelTaxa.getRowCount(); ++i) {
                    Taxon iTaxon = this.modelTaxa.getTaxon(this.jTableTaxa.getRowSorter().convertRowIndexToModel(i));
                    model3.Taxon taxon = this.sbdb.getTaxon(iTaxon.getSpecID());
                    selectedTaxa.add(taxon);
                }
            }
            this.parent.setCursor(Cursor.getPredefinedCursor(3));
            DialogTaxonImages dialog = DialogTaxonImages.imageGalleryDialogForTaxa(this.parent, selectedTaxa, this.sbdb);
            dialog.setLocationRelativeTo(this.parent);
            dialog.enableAnalysisSelection();
            this.parent.setCursor(Cursor.getDefaultCursor());
            dialog.setVisible(true);
            if (dialog.getSelectedAnalysis() != null) {
                this.parent.parent.setSamplesSmpdtl(dialog.getSelectedAnalysis().well(), dialog.getSelectedAnalysis().smpdtl());
            }
        }
        catch (RuntimeException | SQLException | SBException e) {
            SbugsExceptionHandler.showStackError(e, this.parent);
        }
        finally {
            this.parent.setCursor(Cursor.getDefaultCursor());
        }
    }
}

