/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.util.Date;
import java.util.List;
import javax.swing.JTable;
import jsbugs.TableModelSB;
import jsbugs.table.DepthRenderer;
import model3.Intcom;
import model3.SBdb;
import util.DepthUtils;

public class IntervalCommentsTableModel
extends TableModelSB {
    private char units = (char)77;
    private char type = (char)87;
    static String[] columnTitles = new String[]{"Top Depth", "Base Depth", "Comment", "Mod. By", "Modified"};
    private static final int[] defaultColumnWidths = new int[]{30, 30, 200, 30, 30};
    static final int COL_TOP = 0;
    static final int COL_BASE = 1;
    static final int COL_TEXT = 2;
    static final int COL_MODIFIER = 3;
    static final int COL_MODIFIED = 4;
    List<Intcom> comments = null;

    @Override
    public int getColumnCount() {
        return columnTitles.length;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (this.comments == null || row > this.comments.size() - 1) {
            return null;
        }
        Intcom intcom = this.comments.get(row);
        switch (col) {
            case 0: {
                return DepthUtils.convFromM((double)intcom.getTopDepth(), (char)this.units, (char)this.type);
            }
            case 1: {
                return DepthUtils.convFromM((double)intcom.getBaseDepth(), (char)this.units, (char)this.type);
            }
            case 2: {
                return intcom.getComments();
            }
            case 3: {
                try {
                    return intcom.getModifierString();
                }
                catch (Exception ex) {
                    return ex.getMessage();
                }
            }
            case 4: {
                return intcom.getModified();
            }
        }
        return "";
    }

    @Override
    public int getRowCount() {
        if (this.comments == null) {
            return 0;
        }
        return this.comments.size();
    }

    public Class getColumnClass(int col) {
        switch (col) {
            default: {
                return String.class;
            }
            case 0: 
            case 1: {
                return Double.class;
            }
            case 4: 
        }
        return Date.class;
    }

    @Override
    public void setupTable(JTable table, SBdb sbdb) {
        this.init(table, sbdb);
        table.getColumnModel().getColumn(0).setCellRenderer(new DepthRenderer());
        table.getColumnModel().getColumn(1).setCellRenderer(new DepthRenderer());
        this.restoreColumnOrder(table);
    }

    @Override
    public String[] getColumnTitles() {
        return columnTitles;
    }

    @Override
    public int[] getDefaultColumnWidths() {
        return defaultColumnWidths;
    }

    @Override
    public String getPrefString() {
        return "TMINTCOM";
    }

    @Override
    void setUnits(char units) {
        this.units = units;
    }

    void setWellType(char wellType) {
        this.type = wellType;
    }

    @Override
    public String getPrefOrderString() {
        return "TOINTCOM";
    }

    @Override
    public final String getAutoResizeString() {
        return "TARINTCOM";
    }
}

