/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.util.ui.SBDialog;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import jsbchart.block.BlockProperties;
import jsbchart.block.ChartBlock;
import jsbchart.block.WellBlock;
import jsbchart.panel.PanelRange;
import jsbchart.panel.PanelWellDepthAge;
import jsbchart.panel.PanelWellVS;
import jsbchart.panel.SBPanel;
import model3.SBdb;
import util.InvalidFieldException;

public abstract class JPanelChartBlock
extends JPanel {
    SBDialog parent;
    DefaultListModel panelModel = new DefaultListModel();
    SBdb sbdb;
    private final LinkedList<SBPanel> originalPanels = new LinkedList();
    private JButton jButtonAdd;
    private JButton jButtonMoveDown;
    private JButton jButtonMoveUp;
    private JButton jButtonProperties;
    private JButton jButtonRemove;
    private JList jListPanels;
    private JScrollPane jScrollPane1;

    public JPanelChartBlock() {
    }

    public JPanelChartBlock(SBdb sbdb, SBDialog parent) {
        this.initComponents();
        this.sbdb = sbdb;
        this.parent = parent;
    }

    final void init() {
        this.createPanelList(this.getBlock());
        this.createOrigPanelList(this.getBlock());
    }

    final void init(SBdb sbdb, SBDialog parent) {
        this.initComponents();
        this.sbdb = sbdb;
        this.parent = parent;
    }

    abstract void addPanel();

    abstract void panelProperties(SBPanel var1);

    abstract ChartBlock getBlock();

    void createPanelList(ChartBlock block) {
        this.panelModel.clear();
        for (SBPanel panel : block.getPanels()) {
            this.panelModel.addElement(panel);
        }
        this.jListPanels.repaint();
    }

    void createOrigPanelList(ChartBlock block) {
        for (SBPanel panel : block.getPanels()) {
            this.originalPanels.add(panel);
        }
    }

    void removePanel() {
        Object[] panels;
        if (this.jListPanels.getSelectedValue() == null) {
            JOptionPane.showMessageDialog(this, "No panel selected", "Remove panels", 1);
            return;
        }
        for (Object o : panels = this.jListPanels.getSelectedValues()) {
            if (o instanceof SBPanel) {
                try {
                    this.removePanel((SBPanel)o);
                }
                catch (InvalidFieldException e) {
                    JOptionPane.showMessageDialog(this, e.getMessage(), "Remove panels", 2);
                    continue;
                }
            }
            this.panelModel.remove(this.jListPanels.getSelectedIndex());
        }
        this.jListPanels.repaint();
    }

    void removePanel(SBPanel panel) throws InvalidFieldException {
        if (panel instanceof PanelWellVS) {
            throw new InvalidFieldException("You cannot remove the TVD/Offset panel");
        }
        if (panel instanceof PanelWellDepthAge) {
            throw new InvalidFieldException("You cannot remove the " + panel.toString());
        }
        if (panel instanceof PanelRange) {
            throw new InvalidFieldException("You cannot remove the Stratigraphic Range panel");
        }
        this.getBlock().removePanel(panel);
        if (this.getBlock() instanceof WellBlock) {
            ((WellBlock)this.getBlock()).removedPanels.add(panel);
        }
    }

    private void movePanel(boolean up, int index) {
        if (index < 0) {
            JOptionPane.showMessageDialog(this, "No panel selected", "Move panel", 2);
            return;
        }
        if (index == this.panelModel.size() - 1 && !up) {
            JOptionPane.showMessageDialog(this, "Can't move down", "MovePanel", 2);
            return;
        }
        if (index == 0 && up) {
            JOptionPane.showMessageDialog(this, "Can't move up", "MovePanel", 2);
            return;
        }
        Object p = this.panelModel.get(index);
        this.panelModel.remove(index);
        this.panelModel.add(up ? index - 1 : index + 1, p);
        this.jListPanels.repaint();
        this.jListPanels.setSelectedIndex(up ? index - 1 : index + 1);
    }

    void movePanelToTop(SBPanel panel) {
        if (!this.panelModel.contains(panel)) {
            throw new IllegalArgumentException("Panel is not in block");
        }
        this.panelModel.remove(this.panelModel.indexOf(panel));
        this.panelModel.add(0, panel);
    }

    void confirm() {
        SBPanel panel;
        Object o;
        int i;
        this.getBlock().clearPanels();
        if (this.getBlock().getProp().getScaleType() != BlockProperties.ScaleType.MD) {
            for (i = 0; i < this.panelModel.size(); ++i) {
                o = this.panelModel.getElementAt(i);
                panel = (SBPanel)o;
                if (panel.pipe()) continue;
                this.getBlock().addPanel(panel);
            }
        }
        for (i = 0; i < this.panelModel.size(); ++i) {
            o = this.panelModel.getElementAt(i);
            panel = (SBPanel)o;
            if (this.getBlock().getProp().getScaleType() != BlockProperties.ScaleType.MD && !panel.pipe()) continue;
            this.getBlock().addPanel(panel);
        }
    }

    void cancel() {
        this.getBlock().clearPanels();
        this.getBlock().addPanels(this.originalPanels);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jListPanels = new JList();
        this.jButtonAdd = new JButton();
        this.jButtonRemove = new JButton();
        this.jButtonMoveUp = new JButton();
        this.jButtonMoveDown = new JButton();
        this.jButtonProperties = new JButton();
        this.jListPanels.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.jListPanels.setModel(this.panelModel);
        this.jScrollPane1.setViewportView(this.jListPanels);
        this.jButtonAdd.setText("Add...");
        this.jButtonAdd.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelChartBlock this$0;
            {
                JPanelChartBlock jPanelChartBlock = this$0;
                Objects.requireNonNull(jPanelChartBlock);
                this.this$0 = jPanelChartBlock;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAddActionPerformed(evt);
            }
        });
        this.jButtonRemove.setText("Remove");
        this.jButtonRemove.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelChartBlock this$0;
            {
                JPanelChartBlock jPanelChartBlock = this$0;
                Objects.requireNonNull(jPanelChartBlock);
                this.this$0 = jPanelChartBlock;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonRemoveActionPerformed(evt);
            }
        });
        this.jButtonMoveUp.setText("Move up");
        this.jButtonMoveUp.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelChartBlock this$0;
            {
                JPanelChartBlock jPanelChartBlock = this$0;
                Objects.requireNonNull(jPanelChartBlock);
                this.this$0 = jPanelChartBlock;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonMoveUpActionPerformed(evt);
            }
        });
        this.jButtonMoveDown.setText("Move down");
        this.jButtonMoveDown.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonMoveDown.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelChartBlock this$0;
            {
                JPanelChartBlock jPanelChartBlock = this$0;
                Objects.requireNonNull(jPanelChartBlock);
                this.this$0 = jPanelChartBlock;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonMoveDownActionPerformed(evt);
            }
        });
        this.jButtonProperties.setText("Properties...");
        this.jButtonProperties.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonProperties.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelChartBlock this$0;
            {
                JPanelChartBlock jPanelChartBlock = this$0;
                Objects.requireNonNull(jPanelChartBlock);
                this.this$0 = jPanelChartBlock;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonPropertiesActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 234, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jButtonAdd).addComponent(this.jButtonRemove).addComponent(this.jButtonMoveUp).addComponent(this.jButtonMoveDown)).addComponent(this.jButtonProperties)).addContainerGap()));
        layout.linkSize(0, this.jButtonAdd, this.jButtonMoveDown, this.jButtonMoveUp, this.jButtonProperties, this.jButtonRemove);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 151, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jButtonAdd).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonRemove).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonMoveUp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonMoveDown).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 18, Short.MAX_VALUE).addComponent(this.jButtonProperties))).addContainerGap()));
    }

    private void jButtonMoveUpActionPerformed(ActionEvent evt) {
        this.movePanel(true, this.jListPanels.getSelectedIndex());
    }

    private void jButtonMoveDownActionPerformed(ActionEvent evt) {
        this.movePanel(false, this.jListPanels.getSelectedIndex());
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        this.addPanel();
    }

    private void jButtonRemoveActionPerformed(ActionEvent evt) {
        this.removePanel();
    }

    private void jButtonPropertiesActionPerformed(ActionEvent evt) {
        SBPanel selection = (SBPanel)this.jListPanels.getSelectedValue();
        if (selection == null) {
            JOptionPane.showMessageDialog((Component)this.parent, "Select a panel", "Panel properties", 2);
            return;
        }
        this.panelProperties(selection);
    }
}

