/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.user.Userdef;
import com.stratadata.model3.well.analysis.hdr.AbundanceScheme;
import com.stratadata.model3.well.analysis.hdr.AbundanceSchemeServiceImpl;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import jsbchart.core.BlockTemplate;
import jsbchart.core.ChartManager;
import jsbchart.core.ChartTemplate;
import jsbchart.core.PanelTemplate;
import jsbchart.correlation.CorrelationTemplate;
import jsbugs.FrameOrganiser;
import jsbugs.chart.properties.DialogPanelProperties;
import model3.AgeCurve;
import model3.CompositeStandard;
import model3.EnvScheme;
import model3.Genus;
import model3.IGDScheme;
import model3.InterpHdr;
import model3.LogDef;
import model3.SBEvent;
import model3.SBdb;
import model3.Smpdtl;
import model3.Taxon;
import model3.TxGroup;
import model3.TxGroupSet;
import model3.Well;
import model3.WellEvent;
import model3.WellInterp;
import util.SBException;
import util.SbugsLink;
import util.status.SbugsStatus;

public class JPanelOrganiserDict
extends JPanel {
    private final FrameOrganiser parent;
    private final DefaultTreeModel treeModel = new DefaultTreeModel(new DictNode(null, null));
    final boolean charts;
    private final ChartManager.TemplateComparator templComparator = new ChartManager.TemplateComparator();
    private SBdb ws;
    private static final String NODE_TAXA = "Taxa";
    private static final String NODE_GENERA = "Genera (independent of taxa)";
    private static final String NODE_EVENTS = "Events";
    private static final String NODE_ANALYSTS = "Analysts";
    private static final String NODE_ABNSCH = "Abundance Schemes";
    private static final String NODE_ENVSCH = "Environment Schemes";
    private static final String NODE_IGDSCH = "Stratigraphic Schemes";
    private static final String NODE_CMPSTD = "Composite Standards";
    private static final String NODE_TXGRP = "Taxon Groups";
    private static final String NODE_TXGRPSET = "Group Sets";
    private static final String NODE_INTERP = "Versions";
    private static final String NODE_LOGDEF = "Wireline Log Headers";
    private static final String NODE_AGECURVE = "Age Curves";
    private static final String CHT_NODE_PANELS = "Panel Templates";
    private static final String CHT_NODE_BLOCKS = "Block Templates";
    private static final String CHT_NODE_CHARTS = "Charts";
    private static final String CHT_NODE_CORR = "Correlation Templates";
    private JMenuItem jMenuItemChartPreview;
    private JMenuItem jMenuItemChartsExclude;
    private JMenuItem jMenuItemChartsSaveAll;
    private JMenuItem jMenuItemMatch;
    private JMenuItem jMenuItemPanelProperties;
    private JPopupMenu jPopupMenuCharts;
    private JPopupMenu jPopupMenuDictMatch;
    private JScrollPane jScrollPane1;
    private JTree jTree;

    JPanelOrganiserDict(FrameOrganiser parent, boolean charts) {
        this.parent = parent;
        this.charts = charts;
        this.initComponents();
        this.jTree.setCellRenderer(new DictNodeRenderer());
    }

    final synchronized void initTreeData(ChartManager wsCM, SBdb ws) {
        System.out.println("Recreating " + (this.charts ? "charts " : "") + "dictionary tree...");
        this.ws = ws;
        ((DictNode)this.treeModel.getRoot()).children = null;
        try {
            if (!this.charts) {
                if (!ws.getUsers().isEmpty()) {
                    DictNode userNode = ((DictNode)this.treeModel.getRoot()).addChild(NODE_ANALYSTS);
                    this.refreshNode(ws, wsCM, userNode, false);
                }
                if (ws.hasInterpsLoaded()) {
                    DictNode interpNode = ((DictNode)this.treeModel.getRoot()).addChild(NODE_INTERP);
                    this.refreshNode(ws, wsCM, interpNode, false);
                }
                if (!ws.getAbundanceSchemeService().getAllAbundanceSchemes().isEmpty()) {
                    DictNode abnSchNode = ((DictNode)this.treeModel.getRoot()).addChild(NODE_ABNSCH);
                    this.refreshNode(ws, wsCM, abnSchNode, false);
                }
                if (!ws.getCompositeStandards().isEmpty()) {
                    DictNode cmpStdNode = ((DictNode)this.treeModel.getRoot()).addChild(NODE_CMPSTD);
                    this.refreshNode(ws, wsCM, cmpStdNode, false);
                }
                if (ws.hasIGDSchemesLoaded()) {
                    DictNode schNode = ((DictNode)this.treeModel.getRoot()).addChild(NODE_IGDSCH);
                    this.refreshNode(ws, wsCM, schNode, false);
                }
                if (!ws.getEnvSchemes().isEmpty()) {
                    DictNode envSchNode = ((DictNode)this.treeModel.getRoot()).addChild(NODE_ENVSCH);
                    this.refreshNode(ws, wsCM, envSchNode, false);
                }
                if (!ws.getAgeCurves().isEmpty()) {
                    DictNode ageCurveNode = ((DictNode)this.treeModel.getRoot()).addChild(NODE_AGECURVE);
                    this.refreshNode(ws, wsCM, ageCurveNode, false);
                }
                if (!ws.getLogDefs().isEmpty()) {
                    DictNode logDefNode = ((DictNode)this.treeModel.getRoot()).addChild(NODE_LOGDEF);
                    this.refreshNode(ws, wsCM, logDefNode, false);
                }
                if (!ws.getTxGroupSets().isEmpty()) {
                    DictNode setNode = ((DictNode)this.treeModel.getRoot()).addChild(NODE_TXGRPSET);
                    this.refreshNode(ws, wsCM, setNode, false);
                }
                if (!ws.getTxGroups().isEmpty()) {
                    DictNode groupNode = ((DictNode)this.treeModel.getRoot()).addChild(NODE_TXGRP);
                    this.refreshNode(ws, wsCM, groupNode, false);
                }
                if (!ws.getEvents().isEmpty()) {
                    DictNode eventNode = ((DictNode)this.treeModel.getRoot()).addChild(NODE_EVENTS);
                    this.refreshNode(ws, wsCM, eventNode, false);
                }
                if (!ws.getIndependentGenera().isEmpty()) {
                    DictNode genusNode = ((DictNode)this.treeModel.getRoot()).addChild(NODE_GENERA);
                    this.refreshNode(ws, wsCM, genusNode, false);
                }
                if (!ws.getTaxa().isEmpty()) {
                    DictNode taxaNode = ((DictNode)this.treeModel.getRoot()).addChild(NODE_TAXA);
                    this.refreshNode(ws, wsCM, taxaNode, false);
                }
            } else if (wsCM != null) {
                List<CorrelationTemplate> corrTempls;
                List<PanelTemplate> panels;
                List<BlockTemplate> blocks;
                List<ChartTemplate> chtTempls = wsCM.getCharts(null);
                if (!chtTempls.isEmpty()) {
                    DictNode chartsNode = ((DictNode)this.treeModel.getRoot()).addChild(CHT_NODE_CHARTS);
                    this.refreshNode(ws, wsCM, chartsNode, false);
                }
                if (!(blocks = wsCM.getBlocks(null, null, true, this.templComparator, true)).isEmpty()) {
                    DictNode blockNode = ((DictNode)this.treeModel.getRoot()).addChild(CHT_NODE_BLOCKS);
                    this.refreshNode(ws, wsCM, blockNode, false);
                }
                if (!(panels = wsCM.getPanels(null, null, true, this.templComparator)).isEmpty()) {
                    DictNode panelNode = ((DictNode)this.treeModel.getRoot()).addChild(CHT_NODE_PANELS);
                    this.refreshNode(ws, wsCM, panelNode, false);
                }
                if (!(corrTempls = wsCM.getCorrTemplates(null, null, true, this.templComparator)).isEmpty()) {
                    DictNode corrNode = ((DictNode)this.treeModel.getRoot()).addChild(CHT_NODE_CORR);
                    this.refreshNode(ws, wsCM, corrNode, false);
                }
            }
        }
        catch (SQLException | SBException sql) {
            throw new RuntimeException("Unexpected SQL Error", sql);
        }
        this.treeModel.nodeStructureChanged((DictNode)this.treeModel.getRoot());
        if (this.jTree != null) {
            for (int i = 0; i < this.jTree.getRowCount(); ++i) {
                this.jTree.expandRow(i);
            }
        }
    }

    public synchronized void refresh(Class dataType, SBdb ws, ChartManager wsCM) throws SQLException, SBException {
        String nodeItem = null;
        if (dataType == Taxon.class) {
            System.out.println("Refreshing taxa node...");
            nodeItem = NODE_TAXA;
        } else if (dataType == Genus.class) {
            System.out.println("Refreshing genera node...");
            nodeItem = NODE_GENERA;
        } else if (dataType == SBEvent.class) {
            System.out.println("Refreshing events node...");
            nodeItem = NODE_EVENTS;
        } else if (dataType == Userdef.class) {
            System.out.println("Refreshing analysts node...");
            nodeItem = NODE_ANALYSTS;
        } else if (dataType == AbundanceScheme.class) {
            System.out.println("Refreshing abundance schemes...");
            nodeItem = NODE_ABNSCH;
        } else if (dataType == EnvScheme.class) {
            System.out.println("Refreshing environment schemes...");
            nodeItem = NODE_ENVSCH;
        } else if (dataType == CompositeStandard.class) {
            System.out.println("Refreshing composite standards...");
            nodeItem = NODE_CMPSTD;
        } else if (dataType == IGDScheme.class) {
            System.out.println("Refreshing stratigraphic schemes...");
            nodeItem = NODE_IGDSCH;
        } else if (dataType == TxGroup.class) {
            System.out.println("Refreshing groups...");
            nodeItem = NODE_TXGRP;
        } else if (dataType == TxGroupSet.class) {
            this.refresh(TxGroup.class, ws, wsCM);
            System.out.println("Refreshing groups sets ...");
            nodeItem = NODE_TXGRPSET;
        } else if (dataType == InterpHdr.class) {
            System.out.println("Refreshing versions...");
            nodeItem = NODE_INTERP;
        } else if (dataType == LogDef.class) {
            System.out.println("Refreshing LogDefs...");
            nodeItem = NODE_LOGDEF;
        } else if (dataType == AgeCurve.class) {
            System.out.println("Refreshing age curves...");
            nodeItem = NODE_AGECURVE;
        }
        if (nodeItem == null) {
            return;
        }
        DictNode parentNode = this.getChildOfRoot(nodeItem);
        if (parentNode == null) {
            return;
        }
        boolean structureChanged = this.refreshNode(ws, wsCM, parentNode, false);
        if (structureChanged) {
            this.treeModel.nodeStructureChanged(parentNode);
        } else {
            for (TreeNode treeNode : parentNode.children) {
                this.treeModel.nodeChanged(treeNode);
            }
        }
    }

    private DictNode getChildOfRoot(String nodeItem) {
        if (((DictNode)this.treeModel.getRoot()).children == null) {
            return null;
        }
        for (DictNode rootChild : ((DictNode)this.treeModel.getRoot()).children) {
            if (!Objects.equals(nodeItem, rootChild.item)) continue;
            return rootChild;
        }
        return null;
    }

    private boolean refreshNode(SBdb ws, ChartManager wsCM, DictNode parent, boolean recreateChildren) throws SQLException, SBException {
        if (recreateChildren) {
            parent.children = null;
        }
        if (parent.item.equals(NODE_TAXA)) {
            if (parent.children != null && ws.getTaxa().size() != parent.children.size()) {
                parent.children = null;
                recreateChildren = true;
            }
            HashSet<Integer> wsSpecIDs = new HashSet<Integer>();
            Iterator<Well> wellIterator = ws.getWellIterator();
            while (wellIterator.hasNext()) {
                Well well = wellIterator.next();
                for (Smpdtl dtl : well.getAnalyses(null, null, 0)) {
                    for (int i = 0; i < dtl.getNOccs(); ++i) {
                        wsSpecIDs.add(dtl.getOccur(i).getTaxon().getSpecID());
                    }
                }
            }
            for (Taxon taxon : ws.getTaxa()) {
                DictNode groupsNode;
                DictNode eventNode;
                boolean occurs;
                DictNode taxonNode = parent.getChildWithItem(taxon);
                if (taxonNode == null) {
                    taxonNode = parent.addChild(taxon);
                }
                if (!(occurs = wsSpecIDs.contains(taxon.getSpecID())) && (eventNode = this.getChildOfRoot(NODE_EVENTS)) != null && eventNode.children != null) {
                    for (DictNode eventChild : this.getChildOfRoot((String)NODE_EVENTS).children) {
                        if (!eventChild.occurs || ((SBEvent)eventChild.item).getTaxon() != taxon) continue;
                        occurs = true;
                        break;
                    }
                }
                if (!occurs && (groupsNode = this.getChildOfRoot(NODE_TXGRP)) != null && groupsNode.children != null) {
                    for (DictNode groupChild : this.getChildOfRoot((String)NODE_TXGRP).children) {
                        if (!groupChild.occurs || !((TxGroup)groupChild.item).isMember(taxon.getSpecID(), 0)) continue;
                        occurs = true;
                        break;
                    }
                }
                if (!occurs && wsCM != null) {
                    occurs = wsCM.hasOccurrences(taxon);
                }
                taxonNode.occurs = occurs;
            }
        } else if (parent.item.equals(NODE_EVENTS)) {
            if (parent.children != null && ws.getEvents().size() != parent.children.size()) {
                parent.children = null;
                recreateChildren = true;
            }
            for (SBEvent event : ws.getEvents()) {
                DictNode evNode = parent.getChildWithItem(event);
                if (evNode == null) {
                    evNode = parent.addChild(event);
                }
                boolean occurs = false;
                DictNode cmpStdNode = this.getChildOfRoot(NODE_CMPSTD);
                if (cmpStdNode != null && cmpStdNode.children != null) {
                    for (DictNode cmpStdChild : this.getChildOfRoot((String)NODE_CMPSTD).children) {
                        if (!cmpStdChild.occurs || !((CompositeStandard)cmpStdChild.item).hasEvent(event.getEvID())) continue;
                        occurs = true;
                        break;
                    }
                }
                if (!occurs) {
                    Iterator<Well> wellIterator = ws.getWellIterator();
                    block8: while (wellIterator.hasNext()) {
                        Well well = wellIterator.next();
                        Iterator<WellInterp> interpIterator = well.getInterpIterator();
                        while (interpIterator.hasNext()) {
                            WellInterp interp = interpIterator.next();
                            for (WellEvent ev : interp.getEvents()) {
                                if (ev.getEvent() != event) continue;
                                occurs = true;
                                break block8;
                            }
                        }
                    }
                }
                evNode.occurs = occurs;
            }
        } else if (parent.item.equals(NODE_ANALYSTS)) {
            for (Userdef user : ws.getUsers()) {
                if (parent.getChildWithItem(user) != null) continue;
                parent.addChild((Object)user).occurs = true;
            }
        } else if (parent.item.equals(NODE_INTERP)) {
            if (parent.children != null && ws.getInterps().size() != parent.children.size()) {
                parent.children = null;
                recreateChildren = true;
            }
            for (InterpHdr interp : ws.getInterps()) {
                DictNode child = parent.getChildWithItem(interp);
                if (child == null) {
                    child = parent.addChild(interp);
                }
                child.occurs = true;
            }
        } else if (parent.item.equals(NODE_ABNSCH)) {
            for (AbundanceScheme sch : ws.getAbundanceSchemeService().getAllAbundanceSchemes()) {
                DictNode child = parent.getChildWithItem(sch);
                if (child == null) {
                    child = parent.addChild(sch);
                }
                child.occurs = ws.getAbundanceSchemeInformationService().hasAbnSchemeOccs(sch.getAbnSchID());
                child.link = ((AbundanceSchemeServiceImpl)ws.getAbundanceSchemeService()).getLinkObject(sch.getAbnSchID());
            }
        } else if (parent.item.equals(NODE_ENVSCH)) {
            for (EnvScheme sch : ws.getEnvSchemes()) {
                DictNode child = parent.getChildWithItem(sch);
                if (child == null) {
                    child = parent.addChild(sch);
                }
                child.occurs = ws.hasEnvSchemeOccs(sch);
            }
        } else if (parent.item.equals(NODE_AGECURVE)) {
            for (AgeCurve curve : ws.getAgeCurves()) {
                DictNode child = parent.getChildWithItem(curve);
                if (child == null) {
                    child = parent.addChild(curve);
                }
                child.occurs = wsCM != null && wsCM.hasDataLoaded() ? wsCM.hasOccurrences(curve) : ws.getnWells(0) == 0;
            }
        } else if (parent.item.equals(NODE_CMPSTD)) {
            for (CompositeStandard std : ws.getCompositeStandards()) {
                DictNode child = parent.getChildWithItem(std);
                if (child == null) {
                    child = parent.addChild(std);
                }
                child.occurs = ws.getnWells(0) == 0 || wsCM.hasOccurrences(std);
            }
        } else if (parent.item.equals(NODE_IGDSCH)) {
            if (parent.children != null && ws.getIGDSchemes().size() != parent.children.size()) {
                parent.children = null;
                Logger.getLogger(JPanelOrganiserDict.class.getName()).log(Level.CONFIG, "Recreating Schemes dictionary tree");
                recreateChildren = true;
            }
            for (int igdType : new int[]{3, 2, 4, 10}) {
                for (IGDScheme sch : ws.getIGDSchemes(igdType)) {
                    DictNode child = parent.getChildWithItem(sch);
                    if (child == null) {
                        child = parent.addChild(sch);
                    }
                    child.occurs = ws.getnWells(0) == 0;
                    Iterator<Well> wellIterator = ws.getWellIterator();
                    block19: while (wellIterator.hasNext()) {
                        Well well = wellIterator.next();
                        Iterator<WellInterp> interpIterator = well.getInterpIterator();
                        while (interpIterator.hasNext()) {
                            WellInterp interp = interpIterator.next();
                            if (igdType != 10) {
                                if (interp.getIGDList(igdType, sch.getID()).isEmpty()) continue;
                                child.occurs = true;
                                break block19;
                            }
                            if (interp.getSQPicks(sch.getID()).isEmpty()) continue;
                            child.occurs = true;
                            break block19;
                        }
                    }
                    if (child.occurs || wsCM == null) continue;
                    child.occurs = wsCM.hasOccurrences(sch);
                }
            }
        } else if (parent.item.equals(NODE_TXGRP)) {
            block21: for (TxGroup grp : ws.getTxGroups()) {
                DictNode grpSetNode;
                DictNode child = parent.getChildWithItem(grp);
                if (child == null) {
                    child = parent.addChild(grp);
                }
                boolean bl = child.occurs = (wsCM == null || !wsCM.hasDataLoaded()) && ws.getnLoadedWells() == 0;
                if (!child.occurs && wsCM != null) {
                    child.occurs = wsCM.hasOccurrences(grp);
                }
                if (child.occurs || (grpSetNode = this.getChildOfRoot(NODE_TXGRPSET)) == null || grpSetNode.children == null) continue;
                for (DictNode setChild : grpSetNode.children) {
                    if (!setChild.occurs || !((TxGroupSet)setChild.item).isGroupMember(grp.getID())) continue;
                    child.occurs = true;
                    continue block21;
                }
            }
        } else if (parent.item.equals(NODE_GENERA)) {
            block23: for (Genus genus : ws.getIndependentGenera()) {
                DictNode child = parent.getChildWithItem(genus);
                if (child == null) {
                    child = parent.addChild(genus);
                }
                child.occurs = false;
                DictNode grpNode = this.getChildOfRoot(NODE_TXGRP);
                if (grpNode == null || grpNode.children == null) continue;
                for (DictNode grpChild : grpNode.children) {
                    if (!grpChild.occurs || !((TxGroup)grpChild.item).isGenusMember(genus.getGenID())) continue;
                    child.occurs = true;
                    continue block23;
                }
            }
        } else if (parent.item.equals(NODE_TXGRPSET)) {
            for (TxGroupSet grpSet : ws.getTxGroupSets()) {
                DictNode child = parent.getChildWithItem(grpSet);
                if (child == null) {
                    child = parent.addChild(grpSet);
                }
                child.occurs = wsCM == null || !wsCM.hasDataLoaded() ? ws.getnLoadedWells() == 0 : wsCM.hasOccurrences(grpSet);
            }
        } else if (parent.item.equals(NODE_LOGDEF)) {
            block26: for (LogDef logDef : ws.getLogDefs()) {
                DictNode child = parent.getChildWithItem(logDef);
                if (child == null) {
                    child = parent.addChild(logDef);
                }
                boolean bl = child.occurs = ws.getnWells(0) == 0;
                if (child.occurs) continue;
                Iterator<Well> wellIterator = ws.getWellIterator();
                while (wellIterator.hasNext()) {
                    Well well = wellIterator.next();
                    if (well.getCurveService().getCurves(logDef.getAbr()).isEmpty()) continue;
                    child.occurs = true;
                    continue block26;
                }
            }
        } else if (parent.item.equals(CHT_NODE_PANELS)) {
            List<PanelTemplate> panels = wsCM.getPanels(null, null, true, this.templComparator);
            for (PanelTemplate templ : panels) {
                DictNode child;
                if (!templ.isVisible() || (child = parent.getChildWithItem(templ)) != null) continue;
                parent.addChild(templ);
            }
        } else if (parent.item.equals(CHT_NODE_BLOCKS)) {
            List<BlockTemplate> blocks = wsCM.getBlocks(null, null, true, this.templComparator, true);
            for (BlockTemplate templ : blocks) {
                DictNode child = parent.getChildWithItem(templ);
                if (child != null) continue;
                parent.addChild(templ);
            }
        } else if (parent.item.equals(CHT_NODE_CHARTS)) {
            List<ChartTemplate> chtTempls = wsCM.getCharts(null);
            for (ChartTemplate templ : chtTempls) {
                DictNode child = parent.getChildWithItem(templ);
                if (child != null) continue;
                parent.addChild(templ);
            }
        } else if (parent.item.equals(CHT_NODE_CORR)) {
            List<CorrelationTemplate> corrTempls = wsCM.getCorrTemplates(null, null, true, this.templComparator);
            for (CorrelationTemplate templ : corrTempls) {
                DictNode child = parent.getChildWithItem(templ);
                if (child != null) continue;
                parent.addChild(templ);
            }
        }
        if (parent.children != null) {
            if (!this.charts) {
                Collections.sort(parent.children);
            }
        } else {
            ((DictNode)this.treeModel.getRoot()).children.remove(parent);
        }
        return recreateChildren;
    }

    private void initComponents() {
        this.jPopupMenuDictMatch = new JPopupMenu();
        this.jMenuItemMatch = new JMenuItem();
        this.jPopupMenuCharts = new JPopupMenu();
        this.jMenuItemPanelProperties = new JMenuItem();
        this.jMenuItemChartsSaveAll = new JMenuItem();
        this.jMenuItemChartPreview = new JMenuItem();
        this.jMenuItemChartsExclude = new JMenuItem();
        this.jScrollPane1 = new JScrollPane();
        this.jTree = new JTree();
        this.jMenuItemMatch.setText("Match...");
        this.jMenuItemMatch.setToolTipText("");
        this.jMenuItemMatch.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelOrganiserDict this$0;
            {
                JPanelOrganiserDict jPanelOrganiserDict = this$0;
                Objects.requireNonNull(jPanelOrganiserDict);
                this.this$0 = jPanelOrganiserDict;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemMatchActionPerformed(evt);
            }
        });
        this.jPopupMenuDictMatch.add(this.jMenuItemMatch);
        this.jMenuItemPanelProperties.setText("Properties...");
        this.jMenuItemPanelProperties.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelOrganiserDict this$0;
            {
                JPanelOrganiserDict jPanelOrganiserDict = this$0;
                Objects.requireNonNull(jPanelOrganiserDict);
                this.this$0 = jPanelOrganiserDict;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemPanelPropertiesActionPerformed(evt);
            }
        });
        this.jPopupMenuCharts.add(this.jMenuItemPanelProperties);
        this.jMenuItemChartsSaveAll.setText("Save all chart data to database");
        this.jMenuItemChartsSaveAll.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelOrganiserDict this$0;
            {
                JPanelOrganiserDict jPanelOrganiserDict = this$0;
                Objects.requireNonNull(jPanelOrganiserDict);
                this.this$0 = jPanelOrganiserDict;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemChartsSaveAllActionPerformed(evt);
            }
        });
        this.jPopupMenuCharts.add(this.jMenuItemChartsSaveAll);
        this.jMenuItemChartPreview.setText("Preview...");
        this.jMenuItemChartPreview.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelOrganiserDict this$0;
            {
                JPanelOrganiserDict jPanelOrganiserDict = this$0;
                Objects.requireNonNull(jPanelOrganiserDict);
                this.this$0 = jPanelOrganiserDict;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemChartPreviewActionPerformed(evt);
            }
        });
        this.jPopupMenuCharts.add(this.jMenuItemChartPreview);
        this.jMenuItemChartsExclude.setText("Exclude");
        this.jMenuItemChartsExclude.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelOrganiserDict this$0;
            {
                JPanelOrganiserDict jPanelOrganiserDict = this$0;
                Objects.requireNonNull(jPanelOrganiserDict);
                this.this$0 = jPanelOrganiserDict;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemChartsExcludeActionPerformed(evt);
            }
        });
        this.jPopupMenuCharts.add(this.jMenuItemChartsExclude);
        this.jScrollPane1.setBorder(null);
        this.jTree.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.jTree.setModel(this.treeModel);
        this.jTree.setRootVisible(false);
        this.jTree.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ JPanelOrganiserDict this$0;
            {
                JPanelOrganiserDict jPanelOrganiserDict = this$0;
                Objects.requireNonNull(jPanelOrganiserDict);
                this.this$0 = jPanelOrganiserDict;
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                this.this$0.jTreeMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                this.this$0.jTreeMouseReleased(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTree);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 333, Short.MAX_VALUE));
    }

    private void jTreeMousePressed(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.doPopup(evt, this.getSelectObject(evt));
        }
    }

    private void jTreeMouseReleased(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.doPopup(evt, this.getSelectObject(evt));
        }
    }

    private void jMenuItemMatchActionPerformed(ActionEvent evt) {
        Object o = this.jTree.getSelectionPath().getLastPathComponent();
        if (!(o instanceof DictNode)) {
            return;
        }
        DictNode node = (DictNode)o;
        if (node.item.equals(NODE_TAXA)) {
            this.parent.matchTaxa(evt);
        } else if (node.item.equals(NODE_EVENTS)) {
            this.parent.matchEvents();
        } else if (node.item.equals(NODE_ANALYSTS)) {
            this.parent.matchAnalysts();
        } else if (node.item instanceof TxGroup) {
            this.parent.matchTxGroup((TxGroup)node.item);
        } else if (node.item instanceof CompositeStandard) {
            this.parent.matchCmpStd((CompositeStandard)node.item);
        } else if (node.item instanceof AbundanceScheme) {
            this.parent.matchAbnScheme((AbundanceScheme)node.item);
        } else if (node.item instanceof EnvScheme) {
            this.parent.matchEnvScheme((EnvScheme)node.item);
        } else if (node.item instanceof IGDScheme) {
            this.parent.matchIGDScheme((IGDScheme)node.item);
        } else if (node.item.equals(NODE_INTERP)) {
            this.parent.matchInterps();
        } else if (node.item instanceof TxGroupSet) {
            this.parent.matchTxGroupSet((TxGroupSet)node.item);
        } else if (node.item.equals(NODE_LOGDEF)) {
            this.parent.matchLogDefs();
        } else if (node.item.equals(NODE_GENERA)) {
            this.parent.matchGenera();
        } else if (node.item.equals(NODE_AGECURVE)) {
            this.parent.matchAgeCurves();
        }
    }

    private void jMenuItemPanelPropertiesActionPerformed(ActionEvent evt) {
        Object o = this.jTree.getSelectionPath().getLastPathComponent();
        if (!(o instanceof DictNode)) {
            return;
        }
        DictNode node = (DictNode)o;
        if (!(node.item instanceof PanelTemplate)) {
            return;
        }
        DialogPanelProperties dialog = new DialogPanelProperties(this.parent, true, this.ws, (PanelTemplate)node.item, null);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }

    private void jMenuItemChartsSaveAllActionPerformed(ActionEvent evt) {
        this.parent.saveChartsInDatabase();
    }

    private void jMenuItemChartPreviewActionPerformed(ActionEvent evt) {
        Object o = this.jTree.getSelectionPath().getLastPathComponent();
        if (!(o instanceof DictNode)) {
            return;
        }
        DictNode node = (DictNode)o;
        if (!(node.item instanceof ChartTemplate)) {
            return;
        }
        this.parent.previewChart(((ChartTemplate)node.item).getID());
    }

    private void jMenuItemChartsExcludeActionPerformed(ActionEvent evt) {
        Object o = this.jTree.getSelectionPath().getLastPathComponent();
        if (!(o instanceof DictNode)) {
            return;
        }
        DictNode node = (DictNode)o;
        if (!(node.item instanceof PanelTemplate)) {
            return;
        }
        this.parent.excludePanel(((PanelTemplate)node.item).getID());
    }

    private synchronized Object getSelectObject(MouseEvent evt) {
        int row = this.jTree.getRowForLocation(evt.getX(), evt.getY());
        if (row < 0) {
            return null;
        }
        this.jTree.setSelectionRow(row);
        return this.jTree.getSelectionPath().getLastPathComponent();
    }

    private synchronized void doPopup(MouseEvent evt, Object selectedNode) {
        if (selectedNode instanceof DictNode) {
            Object item = ((DictNode)selectedNode).item;
            if (!this.charts) {
                if (((DictNode)selectedNode).getParent().item == null && (item.equals(NODE_TAXA) || item.equals(NODE_EVENTS) || item.equals(NODE_GENERA) || item.equals(NODE_ANALYSTS) || item.equals(NODE_INTERP) || item.equals(NODE_LOGDEF)) || item instanceof TxGroup || item instanceof TxGroupSet || item instanceof AbundanceScheme || item instanceof EnvScheme || item instanceof CompositeStandard || item instanceof IGDScheme) {
                    this.jPopupMenuDictMatch.show(evt.getComponent(), evt.getX(), evt.getY());
                }
            } else {
                this.jMenuItemChartPreview.setVisible(item instanceof ChartTemplate);
                this.jMenuItemPanelProperties.setVisible(item instanceof PanelTemplate);
                this.jMenuItemChartsExclude.setVisible(item instanceof PanelTemplate);
                if (item instanceof PanelTemplate || item instanceof ChartTemplate) {
                    this.jPopupMenuCharts.show(evt.getComponent(), evt.getX(), evt.getY());
                }
            }
        }
    }

    private static class DictNode
    implements TreeNode,
    Comparable<DictNode> {
        private final DictNode parent;
        final Object item;
        List<DictNode> children;
        boolean occurs;
        Object link;

        DictNode(Object item, DictNode parent) {
            this.item = item;
            this.parent = parent;
        }

        DictNode addChild(Object childObj) {
            if (this.children == null) {
                this.children = new ArrayList<DictNode>();
            } else {
                for (DictNode n : this.children) {
                    if (n.item != childObj) continue;
                    return null;
                }
            }
            DictNode child = new DictNode(childObj, this);
            this.children.add(child);
            return child;
        }

        @Override
        public int compareTo(DictNode o) {
            if (this.item == null) {
                return 0;
            }
            if (o.item == null) {
                return 1;
            }
            if (this.item instanceof Comparable && o.item instanceof Comparable) {
                return ((Comparable)this.item).compareTo(o.item);
            }
            return this.item.toString().compareTo(o.item.toString());
        }

        DictNode getChildWithItem(Object childItem) {
            if (this.children == null) {
                return null;
            }
            for (DictNode child : this.children) {
                if (child.item != childItem) continue;
                return child;
            }
            return null;
        }

        public String toString() {
            if (this.item == null) {
                return "Workspace";
            }
            return this.item.toString();
        }

        @Override
        public TreeNode getChildAt(int childIndex) {
            return this.children.get(childIndex);
        }

        @Override
        public int getChildCount() {
            return this.children != null ? this.children.size() : 0;
        }

        @Override
        public DictNode getParent() {
            return this.parent;
        }

        @Override
        public int getIndex(TreeNode node) {
            if (this.children != null) {
                return this.children.indexOf(node);
            }
            return -1;
        }

        @Override
        public boolean getAllowsChildren() {
            return true;
        }

        @Override
        public boolean isLeaf() {
            return this.children == null;
        }

        public Enumeration children() {
            return Collections.enumeration(this.children);
        }
    }

    private static class DictNodeRenderer
    extends DefaultTreeCellRenderer {
        private static final Color FG_LINKED = Color.BLACK;
        private static final Color FG_REQUIRESLINK = new Color(50, 210, 50);
        private static final Color FG_NOTREQUIRED = Color.LIGHT_GRAY;
        private static final Color FG_SCHCONFLICT = new Color(153, 0, 153);

        private DictNodeRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Object toString = null;
            Icon icon = null;
            Color fg = Color.BLACK;
            if (value instanceof DictNode) {
                DictNode node = (DictNode)value;
                if (node.item instanceof SbugsLink) {
                    SbugsLink lItem = (SbugsLink)node.item;
                    fg = (lItem instanceof CompositeStandard || lItem instanceof IGDScheme || lItem instanceof TxGroup || lItem instanceof TxGroupSet) && ((SbugsStatus)lItem).getStatus().equals(SbugsStatus.CONFLICT) ? FG_SCHCONFLICT : (!node.occurs ? FG_NOTREQUIRED : (lItem.getLink() != null ? FG_LINKED : FG_REQUIRESLINK));
                    toString = DictNodeRenderer.getLinkString(lItem);
                } else if (node.item instanceof SbugsStatus) {
                    toString = ((SbugsStatus)node.item).statusString();
                } else if (node.item != null && (node.item.equals(JPanelOrganiserDict.NODE_TAXA) || node.item.equals(JPanelOrganiserDict.NODE_EVENTS))) {
                    toString = node.item.toString() + " (" + node.children.size() + ")";
                } else {
                    Object object = node.item;
                    if (object instanceof AbundanceScheme) {
                        AbundanceScheme abundanceScheme = (AbundanceScheme)object;
                        fg = !node.occurs ? FG_NOTREQUIRED : (node.link != null ? FG_LINKED : FG_REQUIRESLINK);
                        toString = DictNodeRenderer.getLinkString(abundanceScheme, node.link);
                    }
                }
                if (node.item instanceof PanelTemplate) {
                    icon = ((PanelTemplate)node.item).getType().getIcon();
                } else if (node.item instanceof BlockTemplate) {
                    icon = ((BlockTemplate)node.item).getType().getIcon();
                } else if (node.item instanceof CorrelationTemplate) {
                    icon = ((CorrelationTemplate)node.item).getType().getIcon();
                }
            }
            if (toString == null) {
                toString = value.toString();
            }
            JLabel label = (JLabel)super.getTreeCellRendererComponent(tree, toString, selected, expanded, leaf, row, hasFocus);
            label.setIcon(icon);
            Font font = label.getFont();
            if (!leaf) {
                label.setFont(font.deriveFont(1));
            } else {
                label.setFont(font.deriveFont(0));
            }
            label.setForeground(fg);
            return label;
        }

        private static String getLinkString(Object wsItem, Object link) {
            Object strg = DictNodeRenderer.getStatusString(wsItem);
            if (link != null) {
                strg = !DictNodeRenderer.getStatusString(link).equalsIgnoreCase((String)strg) ? "\u2794 " + (String)strg + " [\u2794" + DictNodeRenderer.getStatusString(link) + "]" : "\u2794 " + (String)strg;
            }
            return strg;
        }

        private static String getLinkString(SbugsLink iLink) {
            return DictNodeRenderer.getLinkString(iLink, iLink.getLink());
        }

        private static String getStatusString(Object iLink) {
            String string;
            if (iLink instanceof SbugsStatus) {
                SbugsStatus sbugsStatus = (SbugsStatus)iLink;
                string = sbugsStatus.statusString();
            } else {
                string = Objects.toString(iLink);
            }
            return string;
        }
    }
}

