/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.image.TaxonImageService;
import com.stratadata.model3.image.TaxonImageSet;
import com.stratadata.model3.taxon.Taxon;
import com.stratadata.model3.taxon.TaxonQual;
import com.stratadata.model3.well.analysis.Situation;
import com.stratadata.model3.well.analysis.SpeciesType;
import com.stratadata.model3.well.analysis.hdr.AbundanceScheme;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.IOException;
import java.net.URI;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Observable;
import java.util.Observer;
import java.util.Optional;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.undo.UndoableEdit;
import jsbugs.DialogSelectGroup;
import jsbugs.DialogSelectTaxa;
import jsbugs.DialogSpecType;
import jsbugs.DialogTaxon;
import jsbugs.DialogTaxonNotes;
import jsbugs.FrameSamples;
import jsbugs.ITaxonSelectionChangedListener;
import jsbugs.SBList;
import jsbugs.TaxonTransferHandler;
import jsbugs.WebSearch;
import jsbugs.imagegallery.DialogTaxonImages;
import jsbugs.table.TaxonNameRenderer;
import jsbugs.uiutil.ImageTooltip;
import jsbugs.uiutil.icon.IconFactory;
import jsbugs.userconnect.SbugsExceptionHandler;
import jsbugs.userconnect.SbugsSession;
import model3.Lastval;
import model3.SBdb;
import model3.Smpdtl;
import model3.Taxon;
import model3.TaxonOcc;
import model3.TxGroup;
import model3.Well;
import model3.taxa.TaxonListener;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import util.SBException;
import util.SBPermissionException;
import util.SbugsCompoundEdit;
import util.exception.StackError;

public class JPanelPicklist
extends JPanel
implements Observer,
TaxonListener,
TaxonImageService.TaxonImageListener {
    private static final String SELECT_STRING = "<select>";
    private static boolean sampleTotalMessage = false;
    private final FrameSamples parent;
    private final SBdb sbdb;
    private final DefaultListModel picklistModel = new DefaultListModel();
    private final DefaultComboBoxModel abundModel = new DefaultComboBoxModel();
    private final DefaultComboBoxModel specTypeModel = new DefaultComboBoxModel();
    private AbundanceScheme abnScheme = null;
    private Icon cameraOutlineIcon;
    private Icon cameraOutlineIconSelected;
    private Icon cameraOutlineBoldIcon;
    private Icon cameraOutlineBoldIconSelected;
    private Icon taxonReferenceIcon;
    private Icon taxonReferenceIconSelected;
    private List<ITaxonSelectionChangedListener> listeners = null;
    private model3.Taxon selectedTaxon;
    final TreeMap<Integer, Integer> highlightMap = new TreeMap();
    int highlightThreshold = -1;
    private String tempCount = "";
    private boolean changed = false;
    private TxGroup group = null;
    private Boolean groupAutoSave = null;
    private final Map<Integer, TaxonImageSet> images = new HashMap<Integer, TaxonImageSet>();
    private JScrollPane jScrollPanePicklist;
    private JList jListPick;
    private JPanel jPanel13;
    private JLabel jLabel1;
    private JToolBar jToolBar1;
    private JButton jButtonInsertTaxa;
    private JButton jButtonInsertGroup;
    private JButton jButtonInsertWell;
    private JPanel jPanelSort;
    private JRadioButton jRadioButtonCategory;
    private JRadioButton jRadioButtonSpecies;
    private JRadioButton jRadioButtonGenus;
    private JPanel panel1;
    private JToolBar jToolBar3;
    private JButton jButtonTaxonImage;
    private JCheckBox jCheckBoxAbrGenus;
    private JPanel jPanelQualifiers;
    private JRadioButton jRadioButtonNone;
    private JRadioButton jRadioButtonSpp;
    private JRadioButton jRadioButtonGrp;
    private JRadioButton jRadioButtonAff;
    private JRadioButton jRadioButtonCf;
    private JPanel jPanel9;
    private JSpinner jSpinnerCoarse;
    private JLabel jLabelCoarse;
    private JSpinner jSpinnerFine;
    private JLabel jLabelMedium;
    private JLabel jLabelFine;
    private JSpinner jSpinnerMedium;
    private JComboBox jComboBoxAbund;
    private JRadioButton jRadioButtonCoarse;
    private JRadioButton jRadioButtonMedium;
    private JRadioButton jRadioButtonFine;
    private JPanel jPanelSituation;
    private JRadioButton jRadioButtonReworked;
    private JRadioButton jRadioButtonInSitu;
    private JRadioButton jRadioButtonTransported;
    private JRadioButton jRadioButtonCaved;
    private JToggleButton jToggleButtonKeepSituation;
    private JRadioButton jRadioButtonContamination;
    private JPanel jPanelConfidence;
    private JRadioButton jRadioButtonConfident;
    private JRadioButton jRadioButtonQuestionable;
    private JToggleButton jToggleButtonKeepConfidence;
    private JComboBox jComboBoxSpecType;
    private JButton jButtonSelectSpecType;
    private JCheckBox jCheckBoxMarker;
    private JToolBar jToolBar4;
    private JButton jButtonAddToSample;
    private JButton jButtonClearAll;
    private JButton jButtonClearSelected;
    private JButton jButtonRestore;
    private JPopupMenu jPopupMenuPicklist;
    private JMenuItem jMenuItemWeb;
    private JMenuItem menuItemOpenInTaxaDB;
    private JMenuItem jMenuItemURL;
    private JMenuItem jMenuItemImage;
    private JMenuItem jMenuItemRefNotes;
    private JMenuItem jMenuItemEdit;
    private JMenuItem jMenuItemReplaceSyn;
    private JMenuItem jMenuItemRemove;
    private ButtonGroup buttonGroupPickSort;
    private ButtonGroup buttonGroupQualifiers;
    private ButtonGroup buttonGroupSizeFraction;
    private ButtonGroup buttonGroupSituation;
    private ButtonGroup buttonGroupConfidence;

    public JPanelPicklist(FrameSamples parent, SBdb sbdb) {
        this.parent = parent;
        this.sbdb = sbdb;
        this.initComponents();
        this.init();
    }

    void setGroup(TxGroup group) {
        this.group = group;
        group.addObserver(this);
    }

    public void addTaxonChangedListener(ITaxonSelectionChangedListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<ITaxonSelectionChangedListener>();
        }
        this.listeners.add(listener);
    }

    public void notifyTaxonSelectionListeners() {
        if (this.listeners != null) {
            for (ITaxonSelectionChangedListener listener : this.listeners) {
                listener.selectedTaxonChanged(this.selectedTaxon);
            }
        }
    }

    public void removeAllTaxonSelectionListeners() {
        this.listeners = null;
    }

    void removeTaxonSelectionListener(ITaxonSelectionChangedListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void update(Observable obs, Object obj) {
        if (obs.getClass() == TxGroup.class && obs == this.group) {
            SwingUtilities.invokeLater(new Runnable(this){
                final /* synthetic */ JPanelPicklist this$0;
                {
                    JPanelPicklist jPanelPicklist = this$0;
                    Objects.requireNonNull(jPanelPicklist);
                    this.this$0 = jPanelPicklist;
                }

                @Override
                public void run() {
                    try {
                        this.this$0.setTaxa(this.this$0.sbdb.getTxGroupTaxa(this.this$0.group));
                        this.this$0.parent.setPicklistGroupTitle(this.this$0.group);
                    }
                    catch (Exception ex) {
                        StackError.showStackError((String)ex.toString(), (Throwable)ex);
                    }
                    this.this$0.jListPick.repaint();
                }
            });
        } else if (obs.getClass() == SBdb.class && obj instanceof model3.Taxon) {
            SwingUtilities.invokeLater(new Runnable(this){
                final /* synthetic */ JPanelPicklist this$0;
                {
                    JPanelPicklist jPanelPicklist = this$0;
                    Objects.requireNonNull(jPanelPicklist);
                    this.this$0 = jPanelPicklist;
                }

                @Override
                public void run() {
                    try {
                        this.this$0.clearDeleted();
                    }
                    catch (Exception ex) {
                        StackError.showStackError((String)ex.toString(), (Throwable)ex);
                    }
                    this.this$0.jListPick.repaint();
                }
            });
        }
    }

    public void resetSampleTotalMessage() {
        sampleTotalMessage = false;
    }

    void setControls(boolean isCMF, boolean isNumeric) {
        this.jLabelMedium.setText(isCMF ? "Medium:" : "Counts:");
        if (isNumeric) {
            this.jLabelCoarse.setEnabled(isCMF);
            this.jSpinnerCoarse.setEnabled(isCMF);
            this.jLabelFine.setEnabled(isCMF);
            this.jSpinnerFine.setEnabled(isCMF);
            this.jRadioButtonCoarse.setEnabled(isCMF);
            this.jRadioButtonFine.setEnabled(isCMF);
        } else {
            if (this.parent.isNumeric() || this.abundModel.getSize() == 0) {
                this.fillAbundCombo();
            }
            this.jLabelCoarse.setEnabled(false);
            this.jSpinnerCoarse.setEnabled(false);
            this.jLabelFine.setEnabled(false);
            this.jSpinnerFine.setEnabled(false);
            this.jRadioButtonCoarse.setEnabled(false);
            this.jRadioButtonFine.setEnabled(false);
        }
        this.jComboBoxAbund.setEnabled(!isNumeric);
        this.jLabelMedium.setEnabled(isNumeric);
        this.jSpinnerMedium.setEnabled(isNumeric);
        this.jRadioButtonMedium.setEnabled(isNumeric);
    }

    boolean addToSample(boolean fromListClick, boolean isQuestionable) {
        if (!this.parent.occurrencesTabSelected()) {
            JOptionPane.showMessageDialog(this, "Select the Occurrences tab to record sample data", this.parent.getTitle(), 2);
            return true;
        }
        Well well = this.parent.getWellPanel().getWell();
        try {
            if (!well.canWrite(this.sbdb, null)) {
                if (!fromListClick) {
                    JOptionPane.showMessageDialog(this, well.getDeniedReason(this.sbdb, "add occurrences", "well", false), "Add Occurrence", 1);
                }
                return false;
            }
        }
        catch (SQLException sql) {
            SbugsExceptionHandler.showStackError(sql, this.parent);
            return false;
        }
        Smpdtl smpdtl = this.parent.getTableModelOcc().smpdtl;
        if (smpdtl == null) {
            JOptionPane.showMessageDialog(this, "Make a selection from list of analyses", this.parent.getTitle(), 2);
            return true;
        }
        int sampID = smpdtl.getSample().getSampID();
        this.parent.getWellPanel().stopCellEditor();
        TaxonOcc newOcc = null;
        int count = 0;
        int coarse = 0;
        int fine = 0;
        Object subjAbund = null;
        boolean single = false;
        try {
            List<model3.Taxon> taxa;
            if (this.parent.isNumeric()) {
                this.jSpinnerMedium.commitEdit();
                count = Integer.parseInt(String.valueOf(this.jSpinnerMedium.getValue()));
                if (this.jSpinnerCoarse.isEnabled() && this.jSpinnerFine.isEnabled()) {
                    this.jSpinnerCoarse.commitEdit();
                    this.jSpinnerFine.commitEdit();
                    coarse = Integer.parseInt(String.valueOf(this.jSpinnerCoarse.getValue()));
                    fine = Integer.parseInt(String.valueOf(this.jSpinnerFine.getValue()));
                }
                if (!this.tempCount.isEmpty()) {
                    if (this.jRadioButtonCoarse.isSelected()) {
                        coarse = Integer.parseInt(this.tempCount);
                    } else if (this.jRadioButtonFine.isSelected()) {
                        fine = Integer.parseInt(this.tempCount);
                    } else {
                        count = Integer.parseInt(this.tempCount);
                    }
                }
                if (fromListClick && this.tempCount.isEmpty()) {
                    single = true;
                }
            } else {
                AbundanceScheme a;
                subjAbund = String.valueOf(this.jComboBoxAbund.getSelectedItem());
                if (((String)subjAbund).equals(SELECT_STRING)) {
                    subjAbund = "";
                }
                if ((a = this.parent.getAbnScheme()) == null) {
                    JOptionPane.showMessageDialog(this, "No abundance scheme specified", this.parent.getTitle(), 2);
                    return true;
                }
                if (a.getAbnSchID() != Optional.ofNullable(this.abnScheme).map(AbundanceScheme::getAbnSchID).orElse(0).intValue()) {
                    this.fillAbundCombo();
                }
                subjAbund = this.abnScheme.findEntryByName((String)subjAbund).map(AbundanceScheme.AbundanceSchemeEntry::abr).orElse("+");
            }
            if ((taxa = this.getSelectedTaxa()).isEmpty()) {
                JOptionPane.showMessageDialog(this, "No taxa selected.", this.parent.getTitle(), 2);
                return true;
            }
            int specTypeID = ((SpeciesType)this.jComboBoxSpecType.getSelectedItem()).specTypeID();
            for (model3.Taxon taxon : taxa) {
                try {
                    Situation situation = this.getSituationFromRadioButton();
                    boolean questionable = this.jRadioButtonQuestionable.isSelected() || isQuestionable;
                    boolean incremented = false;
                    if (!this.jRadioButtonNone.isSelected()) {
                        boolean found = false;
                        List<model3.Taxon> tlist = model3.Taxon.search(this.sbdb, null, taxon.getCatMnem(), false, taxon.getGenusName(), taxon.getSubGenus(), this.jRadioButtonSpp.isSelected() ? "spp." : taxon.getSpecies(), taxon.getSubSpecies(), "", this.getNull(taxon.getQualifier(0).toString()), this.getNull(taxon.getQualifier(1).toString()), this.getNull(taxon.getQualifier(2).toString()), this.getNull(taxon.getQualifier(2).toString()), this.getNull(taxon.getQualifier(4).toString()), this.getNull(taxon.getQualifier(5).toString()), this.getNull(taxon.getQualifier(6).toString()), this.getNull(taxon.getQualifier(7).toString()));
                        for (model3.Taxon t : tlist) {
                            if (!t.getSubGenus().equalsIgnoreCase(taxon.getSubGenus())) continue;
                            if (this.jRadioButtonSpp.isSelected()) {
                                taxon = t;
                                found = true;
                                break;
                            }
                            if (this.jRadioButtonAff.isSelected() && t.getQ1().hasQual(TaxonQual.AFF)) {
                                taxon = t;
                                found = true;
                                break;
                            }
                            if (this.jRadioButtonCf.isSelected() && t.getQ1().hasQual(TaxonQual.CF)) {
                                taxon = t;
                                found = true;
                                break;
                            }
                            if (!this.jRadioButtonGrp.isSelected() || !t.getQ2().hasQual(TaxonQual.GRP)) continue;
                            taxon = t;
                            found = true;
                            break;
                        }
                        if (!found) {
                            DialogTaxon dialog = new DialogTaxon(this.parent, true, this.sbdb, taxon, true, this.parent.parent.getChartManager());
                            if (this.jRadioButtonSpp.isSelected()) {
                                dialog.setSpecies("spp.");
                            } else if (this.jRadioButtonAff.isSelected()) {
                                dialog.setSq1(TaxonQual.AFF);
                            } else if (this.jRadioButtonCf.isSelected()) {
                                dialog.setSq1(TaxonQual.CF);
                            } else if (this.jRadioButtonGrp.isSelected()) {
                                dialog.setSq2(TaxonQual.GRP);
                            }
                            dialog.setLocationRelativeTo(this);
                            dialog.setVisible(true);
                            if (dialog.taxon == null) {
                                return true;
                            }
                            taxon = dialog.taxon;
                        }
                    }
                    TaxonOcc fss = smpdtl.getFss(taxon, situation, questionable ? (char)'?' : 'P', specTypeID);
                    if (this.parent.isNumeric()) {
                        boolean exceededTotal = false;
                        if (smpdtl.getTotalCount() >= this.parent.getPicklistTotaliser() && this.parent.getPicklistTotaliser() > 0 && (fromListClick || count > 0)) {
                            exceededTotal = true;
                            boolean beeped = false;
                            if (!sampleTotalMessage) {
                                this.getToolkit().beep();
                                beeped = true;
                                JOptionPane.showMessageDialog(this, "Total count reached", "Samples", 1);
                                sampleTotalMessage = true;
                            }
                            if (fss != null && fromListClick) {
                                if (!beeped) {
                                    this.getToolkit().beep();
                                }
                                return true;
                            }
                            this.jSpinnerMedium.setValue(0);
                            this.jSpinnerCoarse.setValue(0);
                            this.jSpinnerFine.setValue(0);
                            count = 0;
                            coarse = 0;
                            fine = 0;
                        }
                        if (fss != null) {
                            if (fss.getSubAbund() != null && fss.getSubAbund().length() > 0 && JOptionPane.showConfirmDialog(this, "Occurrence is already recorded semi-quantitatively.\nClear semi-quantitative abundance?", "Abundance", 0, 3) != 0) {
                                return true;
                            }
                            if (!exceededTotal) {
                                if (count < 0 && fss.getTotalCount() == 0) {
                                    this.getToolkit().beep();
                                    return true;
                                }
                                SbugsCompoundEdit compoundEdit = new SbugsCompoundEdit("increment occurrence");
                                if (count != 0 || single && coarse == 0 && fine == 0) {
                                    int sizeFraction = this.getSelectedSizeFraction();
                                    compoundEdit.addEdit((UndoableEdit)smpdtl.incrementOcc(well.getWellID(), sampID, fss, sizeFraction, single ? 1 : count, true));
                                }
                                if (coarse != 0 && (!single || single && count == 0)) {
                                    compoundEdit.addEdit((UndoableEdit)smpdtl.incrementOcc(well.getWellID(), sampID, fss, 1, single ? 1 : coarse, true));
                                }
                                if (fine != 0 && (!single || single && count == 0)) {
                                    compoundEdit.addEdit((UndoableEdit)smpdtl.incrementOcc(well.getWellID(), sampID, fss, 3, single ? 1 : fine, true));
                                }
                                compoundEdit.end();
                                this.parent.getWellPanel().getUndoSupport().postEdit((UndoableEdit)compoundEdit);
                            }
                            incremented = true;
                            newOcc = fss;
                        }
                    } else if (fss != null) {
                        if (smpdtl.getHeader().getAbnSchID() <= 0) {
                            JOptionPane.showMessageDialog(this.parent, "You must set an abundance scheme for this analyst suite\nbefore recording semi-quantitative data.", "Edit abundance", 2);
                            return true;
                        }
                        AbundanceScheme sch = this.sbdb.getAbundanceSchemeService().findAbundanceScheme(smpdtl.getHeader().getAbnSchID()).orElse(null);
                        if (fss.getTotalCount() > 0 && JOptionPane.showConfirmDialog(this.parent, "You can't mix semi-quantitative and quantitative abundance.\nDelete quantitative data?", "Edit abundance", 0) != 0) {
                            return true;
                        }
                        if (!sch.canIncrementSubjAbund((String)subjAbund)) {
                            this.getToolkit().beep();
                            return true;
                        }
                        this.parent.getWellPanel().getUndoSupport().postEdit(smpdtl.incrementOcc(well.getWellID(), smpdtl.getSample().getSampID(), fss, 0, 1, false));
                        incremented = true;
                    }
                    if (!incremented) {
                        if (fss != null) {
                            JOptionPane.showMessageDialog(this.parent, "An occurrence of " + String.valueOf(fss.getTaxon()) + " already exists in analysis", this.parent.getTitle(), 2);
                            continue;
                        }
                        Smpdtl.OccAddDelete edit = smpdtl.insertOccurrence(new TaxonOcc.Builder(this.sbdb, taxon, this.getSituationFromTaxon(taxon, situation), questionable, specTypeID).count(coarse, count, fine).subjAbund((String)subjAbund).marker(this.jCheckBoxMarker.isSelected()), well.getWellID());
                        this.parent.getWellPanel().getUndoSupport().postEdit((UndoableEdit)((Object)edit));
                        newOcc = edit.getOccurrence();
                    }
                    this.sbdb.commit();
                    smpdtl.notifyObservers();
                }
                catch (SBException e) {
                    StackError.showStackError((String)"Error", (Throwable)e);
                }
            }
            this.sbdb.commit();
        }
        catch (SQLException | ParseException | SBException sqle) {
            SbugsExceptionHandler.showStackError("Error in picklist", sqle, this.parent);
        }
        this.jListPick.setToolTipText(null);
        if (this.parent.getWellPanel().tableModelOcc.pruneUnsaved()) {
            this.parent.getWellPanel().tableModelOcc.fireTableDataChanged();
        }
        smpdtl.notifyObservers();
        this.parent.getWellPanel().setBarren(smpdtl.getBarren());
        this.parent.getWellPanel().setSelectedTaxonOcc(newOcc);
        if (this.parent.playOccSounds()) {
            this.parent.playOccSound();
        }
        return false;
    }

    public int getSelectedSizeFraction() {
        int sizeFraction = 2;
        if (this.jRadioButtonCoarse.isSelected()) {
            sizeFraction = 1;
        } else if (this.jRadioButtonFine.isSelected()) {
            sizeFraction = 3;
        }
        return sizeFraction;
    }

    private Situation getSituationFromRadioButton() {
        if (this.jRadioButtonReworked.isSelected()) {
            return Situation.RW;
        }
        if (this.jRadioButtonCaved.isSelected()) {
            return Situation.CV;
        }
        if (this.jRadioButtonTransported.isSelected()) {
            return Situation.TR;
        }
        if (this.jRadioButtonContamination.isSelected()) {
            return Situation.CN;
        }
        return Situation.INSITU;
    }

    Situation getSituationFromTaxon(model3.Taxon taxon, Situation situation) {
        if (this.parent.deriveCvRw) {
            String comp = taxon.toString(false, false, false).toLowerCase();
            if (comp.contains(" caved ") || comp.startsWith("caved ") || comp.endsWith(" caved") || comp.contains(" cavings")) {
                return Situation.CV;
            }
            if (comp.contains("rework")) {
                return Situation.RW;
            }
        }
        return situation;
    }

    static void addToSample(model3.Taxon taxon, int count, String subjAbund, Situation situation, boolean questionable, FrameSamples parent, SBdb sbdb) throws SBException {
        Smpdtl smpdtl = parent.getTableModelOcc().smpdtl;
        Well well = parent.getWellPanel().getWell();
        try {
            if (!well.canWrite(sbdb, null)) {
                JOptionPane.showMessageDialog(parent, well.getDeniedReason(sbdb, "add occurrences", "well", false), "Add Occurrence", 1);
                return;
            }
        }
        catch (SQLException sql) {
            SbugsExceptionHandler.showStackError(sql, parent);
            return;
        }
        TaxonOcc fss = null;
        if (smpdtl == null) {
            JOptionPane.showMessageDialog(parent, "Make a selection from list of analyses", parent.getTitle(), 2);
            return;
        }
        int sampID = smpdtl.getSample().getSampID();
        try {
            Object edit;
            fss = smpdtl.getFss(taxon, situation, questionable ? (char)'?' : 'P', 0);
            if (fss != null) {
                edit = smpdtl.incrementOcc(well.getWellID(), sampID, fss, 2, count, true);
            } else {
                edit = smpdtl.insertOccurrence(new TaxonOcc.Builder(sbdb, taxon, situation, questionable, 0).count(count).subjAbund(subjAbund), well.getWellID());
                fss = ((Smpdtl.OccAddDelete)((Object)edit)).getOccurrence();
            }
            parent.getWellPanel().getUndoSupport().postEdit((UndoableEdit)edit);
            sbdb.commit();
        }
        catch (SQLException sql) {
            SbugsExceptionHandler.showStackError(sql);
        }
        smpdtl.notifyObservers();
        parent.getWellPanel().setSelectedTaxonOcc(fss);
    }

    boolean addToSamples(List<Smpdtl> smpdtls) {
        Well well = this.parent.getWellPanel().getWell();
        try {
            if (!well.canWrite(this.sbdb, null)) {
                JOptionPane.showMessageDialog(this, well.getDeniedReason(this.sbdb, "add occurrences", "well", false), "Add Occurrence", 1);
                return false;
            }
        }
        catch (SQLException sql) {
            SbugsExceptionHandler.showStackError(sql, this.parent);
            return false;
        }
        this.parent.getWellPanel().stopCellEditor();
        TaxonOcc newOcc = null;
        int count = 0;
        int coarse = 0;
        int fine = 0;
        Object subjAbund = null;
        boolean single = false;
        try {
            if (this.parent.isNumeric()) {
                this.jSpinnerMedium.commitEdit();
                count = Integer.parseInt(String.valueOf(this.jSpinnerMedium.getValue()));
                if (this.jSpinnerCoarse.isEnabled() && this.jSpinnerFine.isEnabled()) {
                    this.jSpinnerCoarse.commitEdit();
                    this.jSpinnerFine.commitEdit();
                    coarse = Integer.parseInt(String.valueOf(this.jSpinnerCoarse.getValue()));
                    fine = Integer.parseInt(String.valueOf(this.jSpinnerFine.getValue()));
                }
                if (!this.tempCount.isEmpty()) {
                    if (this.jRadioButtonCoarse.isSelected()) {
                        coarse = Integer.parseInt(this.tempCount);
                    } else if (this.jRadioButtonFine.isSelected()) {
                        fine = Integer.parseInt(this.tempCount);
                    } else {
                        count = Integer.parseInt(this.tempCount);
                    }
                }
            } else {
                AbundanceScheme a;
                subjAbund = String.valueOf(this.jComboBoxAbund.getSelectedItem());
                if (((String)subjAbund).equals(SELECT_STRING)) {
                    subjAbund = "";
                }
                if ((a = this.parent.getAbnScheme()) == null) {
                    JOptionPane.showMessageDialog(this, "No abundance scheme specified", this.parent.getTitle(), 2);
                    return true;
                }
                if (a.getAbnSchID() != Optional.ofNullable(this.abnScheme).map(AbundanceScheme::getAbnSchID).orElse(0).intValue()) {
                    this.fillAbundCombo();
                }
                subjAbund = this.abnScheme.findEntryByName((String)subjAbund).map(AbundanceScheme.AbundanceSchemeEntry::abr).orElse("+");
            }
            if (this.jListPick.getSelectedValuesList().size() != 1) {
                JOptionPane.showMessageDialog(this, "Select 1 taxon from the list.", this.parent.getTitle(), 2);
                return true;
            }
            model3.Taxon taxon = this.getSelectedTaxon();
            int specTypeID = ((SpeciesType)this.jComboBoxSpecType.getSelectedItem()).specTypeID();
            Situation situation = this.getSituationFromRadioButton();
            boolean questionable = this.jRadioButtonQuestionable.isSelected();
            if (!this.jRadioButtonNone.isSelected()) {
                boolean found = false;
                List<model3.Taxon> tlist = model3.Taxon.search(this.sbdb, null, taxon.getCatMnem(), false, taxon.getGenusName(), taxon.getSubGenus(), this.jRadioButtonSpp.isSelected() ? "spp." : taxon.getSpecies(), taxon.getSubSpecies(), "", this.getNull(taxon.getQualifier(0).toString()), this.getNull(taxon.getQualifier(1).toString()), this.getNull(taxon.getQualifier(2).toString()), this.getNull(taxon.getQualifier(2).toString()), this.getNull(taxon.getQualifier(4).toString()), this.getNull(taxon.getQualifier(5).toString()), this.getNull(taxon.getQualifier(6).toString()), this.getNull(taxon.getQualifier(7).toString()));
                for (model3.Taxon t : tlist) {
                    if (!t.getSubGenus().equalsIgnoreCase(taxon.getSubGenus())) continue;
                    if (this.jRadioButtonSpp.isSelected()) {
                        taxon = t;
                        found = true;
                        break;
                    }
                    if (this.jRadioButtonAff.isSelected() && t.getQ1().hasQual(TaxonQual.AFF)) {
                        taxon = t;
                        found = true;
                        break;
                    }
                    if (this.jRadioButtonCf.isSelected() && t.getQ1().hasQual(TaxonQual.CF)) {
                        taxon = t;
                        found = true;
                        break;
                    }
                    if (!this.jRadioButtonGrp.isSelected() || !t.getQ2().hasQual(TaxonQual.GRP)) continue;
                    taxon = t;
                    found = true;
                    break;
                }
                if (!found) {
                    DialogTaxon dialog = new DialogTaxon(this.parent, true, this.sbdb, taxon, true, this.parent.parent.getChartManager());
                    if (this.jRadioButtonSpp.isSelected()) {
                        dialog.setSpecies("spp.");
                    } else if (this.jRadioButtonAff.isSelected()) {
                        dialog.setSq1(TaxonQual.AFF);
                    } else if (this.jRadioButtonCf.isSelected()) {
                        dialog.setSq1(TaxonQual.CF);
                    } else if (this.jRadioButtonGrp.isSelected()) {
                        dialog.setSq2(TaxonQual.GRP);
                    }
                    dialog.setLocationRelativeTo(this);
                    dialog.setVisible(true);
                    if (dialog.taxon == null) {
                        return true;
                    }
                    taxon = dialog.taxon;
                }
            }
            try {
                for (Smpdtl smpdtl : smpdtls) {
                    TaxonOcc fss = smpdtl.getFss(taxon, situation, questionable ? (char)'?' : 'P', specTypeID);
                    if (fss == null) continue;
                    JOptionPane.showMessageDialog(this.parent, "An occurrence of " + String.valueOf(fss.getTaxon()) + " already exists in analysis: " + smpdtl.getSample().toString(), this.parent.getTitle(), 2);
                    return false;
                }
                if (JOptionPane.showConfirmDialog(this.parent, "Add '" + taxon.toString() + " to these " + smpdtls.size() + " selected analyses?", this.parent.getTitle(), 0, 3) == 1) {
                    return false;
                }
                Smpdtl lastSmpdtl = null;
                for (Smpdtl smpdtl : smpdtls) {
                    Smpdtl.OccAddDelete edit = smpdtl.insertOccurrence(new TaxonOcc.Builder(this.sbdb, taxon, situation, questionable, specTypeID).count(coarse, count, fine).subjAbund((String)subjAbund).marker(this.jCheckBoxMarker.isSelected()), well.getWellID());
                    this.parent.getWellPanel().getUndoSupport().postEdit((UndoableEdit)((Object)edit));
                    newOcc = edit.getOccurrence();
                    this.sbdb.commit();
                    this.parent.getWellPanel().setBarren(smpdtl.getBarren());
                    lastSmpdtl = smpdtl;
                }
                if (lastSmpdtl != null) {
                    lastSmpdtl.notifyObservers();
                }
            }
            catch (SBException e) {
                SbugsExceptionHandler.showStackError(e, this.parent);
            }
            this.sbdb.commit();
        }
        catch (SQLException | ParseException | SBException sqle) {
            SbugsExceptionHandler.showStackError("Error in picklist", sqle, this.parent);
        }
        this.jListPick.setToolTipText(null);
        this.notifyTaxonSelectionListeners();
        return false;
    }

    private String getNull(String strg) {
        if (strg == null) {
            return null;
        }
        if (strg.length() == 0) {
            return null;
        }
        return strg;
    }

    private void fillAbundCombo() {
        this.jComboBoxAbund.removeAllItems();
        this.jComboBoxAbund.addItem(SELECT_STRING);
        try {
            this.abnScheme = this.parent.getAbnScheme();
            if (this.abnScheme == null) {
                this.jComboBoxAbund.setToolTipText("No abundance scheme selected for suite");
                return;
            }
            this.abnScheme.getEntries().forEach(entry -> this.jComboBoxAbund.addItem(entry.entryName()));
            this.jComboBoxAbund.setToolTipText("Scheme: " + this.abnScheme.getName());
            this.jComboBoxAbund.repaint();
        }
        catch (SBException e) {
            this.jComboBoxAbund.setToolTipText("No abundance scheme selected for suite");
            e.printStackTrace();
        }
        catch (SQLException e) {
            SbugsExceptionHandler.showStackError(e, this.parent);
        }
    }

    public void setAbnScheme() throws SBException, SQLException {
        if (!this.parent.isNumeric() && Optional.ofNullable(this.parent.getAbnScheme()).map(AbundanceScheme::getAbnSchID).orElse(0) != Optional.ofNullable(this.abnScheme).map(AbundanceScheme::getAbnSchID).orElse(0)) {
            this.fillAbundCombo();
            this.jComboBoxAbund.setEnabled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clear() {
        this.picklistModel.removeAllElements();
        this.changed = false;
        if (this.group != null) {
            this.parent.renamePicklist(this, "Picklist");
            this.group = null;
        }
        Map<Integer, TaxonImageSet> map = this.images;
        synchronized (map) {
            this.images.clear();
        }
        this.jListPick.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearSelection() {
        List<model3.Taxon> selection = this.getSelectedTaxa();
        if (selection.isEmpty()) {
            JOptionPane.showMessageDialog(this, "No picklist entries selected", this.parent.getTitle(), 1);
            return;
        }
        boolean removeFromGroup = false;
        ArrayList<model3.Taxon> groupRemovals = new ArrayList<model3.Taxon>();
        for (model3.Taxon taxon : selection) {
            taxon.deleteListener(this);
            this.picklistModel.removeElement(taxon);
            Map<Integer, TaxonImageSet> map = this.images;
            synchronized (map) {
                this.images.remove(taxon.getSpecID());
            }
            try {
                if (this.group == null || !this.group.isMember(taxon.getSpecID(), 0) || !removeFromGroup && JOptionPane.showConfirmDialog(this, "Also remove " + (selection.size() > 1 ? "taxa" : "taxon") + " from group '" + this.group.getName() + "'?", this.parent.getTitle(), 0, 3) != 0) continue;
                groupRemovals.add(taxon);
                removeFromGroup = true;
            }
            catch (SQLException e) {
                StackError.showStackError((Exception)e);
            }
        }
        if (this.group != null) {
            try {
                this.group.deleteTaxa(groupRemovals);
                this.sbdb.commit();
            }
            catch (SQLException | SBPermissionException e) {
                StackError.showStackError((Exception)e);
            }
        }
        if (this.picklistModel.isEmpty() && this.group != null) {
            this.group = null;
            this.changed = false;
            this.parent.renamePicklist(this, "Picklist");
        }
        this.jListPick.repaint();
    }

    void clearDeleted() {
        Enumeration en = this.picklistModel.elements();
        Collection<model3.Taxon> taxa = this.sbdb.getTaxa();
        boolean removed = true;
        block0: while (removed) {
            removed = false;
            while (en.hasMoreElements()) {
                model3.Taxon taxon = (model3.Taxon)en.nextElement();
                if (taxa.contains(taxon)) continue;
                taxon.deleteListener(this);
                this.picklistModel.removeElement(taxon);
                removed = true;
                continue block0;
            }
        }
        if (this.picklistModel.isEmpty() && this.group != null) {
            this.group = null;
            this.changed = false;
            this.parent.renamePicklist(this, "Picklist");
        }
        this.jListPick.repaint();
    }

    void saveAsGroup() {
        try {
            DialogSelectGroup dialog = new DialogSelectGroup(this.parent, true, this.sbdb, this.group, true, false);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.selection != null) {
                TxGroup selectedGroup = dialog.selection;
                if (!selectedGroup.canWrite(this.sbdb, null)) {
                    JOptionPane.showMessageDialog(this.parent, "This group is read-only", this.parent.getTitle(), 2);
                    return;
                }
                if (selectedGroup.getSize() > 0) {
                    int opt = JOptionPane.showConfirmDialog(this, "Clear contents of group before adding?", this.parent.getTitle(), 1, 3);
                    if (opt == 2 || opt == -1) {
                        return;
                    }
                    if (opt == 0) {
                        selectedGroup.deleteAllTaxa();
                    }
                }
                LinkedList<model3.Taxon> picklistTaxa = new LinkedList<model3.Taxon>();
                Enumeration en = this.picklistModel.elements();
                while (en.hasMoreElements()) {
                    model3.Taxon taxon = (model3.Taxon)en.nextElement();
                    if (selectedGroup.isMember(taxon.getSpecID(), 0)) continue;
                    picklistTaxa.add(taxon);
                }
                selectedGroup.addTaxa(picklistTaxa);
                this.sbdb.commit();
                this.changed = false;
                this.group = selectedGroup;
            }
        }
        catch (RuntimeException | SQLException | SBPermissionException e) {
            SbugsExceptionHandler.showStackError(e, this.parent);
        }
    }

    void saveGroup() {
        try {
            LinkedList<model3.Taxon> picklistTaxa = new LinkedList<model3.Taxon>();
            Enumeration en = this.picklistModel.elements();
            while (en.hasMoreElements()) {
                model3.Taxon taxon = (model3.Taxon)en.nextElement();
                if (this.group.isMember(taxon.getSpecID(), 0)) continue;
                picklistTaxa.add(taxon);
            }
            this.group.addTaxa(picklistTaxa);
            this.sbdb.commit();
            this.changed = false;
        }
        catch (SQLException | SBPermissionException sql) {
            SbugsExceptionHandler.showStackError(sql, this.parent);
        }
    }

    void setListLayout(int orientation) {
        this.jListPick.setLayoutOrientation(orientation);
        this.jListPick.repaint();
        try {
            Lastval.putInt(this.sbdb, "PICKCOL", orientation);
            this.sbdb.commit();
        }
        catch (SQLException sql) {
            SbugsExceptionHandler.showStackError(sql);
        }
    }

    synchronized void setTaxa(Collection<model3.Taxon> taxa) {
        for (model3.Taxon taxon : taxa) {
            if (this.picklistModel.contains(taxon)) continue;
            this.picklistModel.addElement(taxon);
            taxon.registerListener(this);
        }
        this.refreshImages();
        this.sortPicklist();
    }

    private void init() {
        this.jListPick.setDragEnabled(true);
        this.jListPick.setTransferHandler(new TaxonTransferHandler(this.sbdb, null));
        this.jListPick.setDropTarget(null);
        this.setTransferHandler(new TaxonTransferHandler(this.sbdb, null));
        this.jListPick.setCellRenderer(new PicklistListLabel(this));
        PicklistTooltip picklistTooltip = new PicklistTooltip(this);
        this.jListPick.addMouseMotionListener(picklistTooltip);
        this.jScrollPanePicklist.addMouseWheelListener(picklistTooltip);
        this.sbdb.addObserver(this);
        this.sbdb.getTaxonImageService().addListener((TaxonImageService.TaxonImageListener)this);
        try {
            this.initSpecTypeModel();
            int i = Lastval.getInt(this.sbdb, "PICKCOL");
            this.setListLayout(i);
        }
        catch (SQLException ex) {
            SbugsExceptionHandler.showStackError(ex);
        }
        this.sbdb.getSpeciesTypeService().addListener(() -> {
            try {
                this.initSpecTypeModel();
            }
            catch (SQLException ex) {
                SbugsExceptionHandler.showStackError(ex);
            }
        });
        this.initHiResIcons();
        this.jToolBar1.setFloatable(false);
        this.jToolBar4.setFloatable(false);
        this.jToolBar3.setFloatable(false);
        this.initKeepableButtonPanels();
    }

    private void initHiResIcons() {
        if (SbugsSession.getSession().useHiResIcons()) {
            IconFactory.setButtonIconsInBackground(List.of(new IconFactory.ButtonIconInfo(this.jButtonTaxonImage, "camera.svg", 24), new IconFactory.ButtonIconInfo(this.jButtonInsertTaxa, "findTaxon.svg", 24), new IconFactory.ButtonIconInfo(this.jButtonInsertGroup, "txGroup.svg", 24), new IconFactory.ButtonIconInfo(this.jButtonInsertWell, "FrameJsbugs_jButtonWells.svg", 24), new IconFactory.ButtonIconInfo(this.jButtonClearSelected, "picklist_clearSelected.svg", 24), new IconFactory.ButtonIconInfo(this.jButtonClearAll, "picklist_clearAll.svg", 24), new IconFactory.ButtonIconInfo(this.jButtonRestore, "picklistRestore.svg", 24), new IconFactory.ButtonIconInfo(this.jButtonAddToSample, "picklistAddTaxon.svg", 24), new IconFactory.ButtonIconInfo(this.jToggleButtonKeepConfidence, "linked.svg", 12), new IconFactory.ButtonIconInfo(this.jToggleButtonKeepSituation, "linked.svg", 12)));
            this.cameraOutlineIcon = IconFactory.getIcon("camera_bw.svg", 14);
            this.cameraOutlineIconSelected = IconFactory.getIcon("camera_w.svg", 14);
            this.cameraOutlineBoldIcon = IconFactory.getIcon("camera_bw_bold.svg", 14);
            this.cameraOutlineBoldIconSelected = IconFactory.getIcon("camera_w_bold.svg", 14);
        } else {
            this.cameraOutlineIconSelected = this.cameraOutlineIcon = new ImageIcon(this.getClass().getResource("/resources/icon/cameraSmall_bw.png"));
            this.cameraOutlineBoldIconSelected = this.cameraOutlineBoldIcon = new ImageIcon(this.getClass().getResource("/resources/icon/cameraSmall_bw_bold.png"));
        }
        this.taxonReferenceIcon = IconFactory.getIcon("scroll.svg", 14);
        this.taxonReferenceIconSelected = IconFactory.getIcon("scroll_w.svg", 14);
    }

    private void refreshImages() {
        final HashMap<Integer, TaxonImageSet> refreshedMap = new HashMap<Integer, TaxonImageSet>();
        final HashSet<Integer> additionalEntries = new HashSet<Integer>();
        Enumeration elements = this.picklistModel.elements();
        while (elements.hasMoreElements()) {
            model3.Taxon taxon = (model3.Taxon)elements.nextElement();
            if (!this.images.containsKey(taxon.getSpecID())) {
                additionalEntries.add(taxon.getSpecID());
            }
            refreshedMap.put(taxon.getSpecID(), this.images.get(taxon.getSpecID()));
        }
        SwingWorker worker = new SwingWorker(this){
            final /* synthetic */ JPanelPicklist this$0;
            {
                JPanelPicklist jPanelPicklist = this$0;
                Objects.requireNonNull(jPanelPicklist);
                this.this$0 = jPanelPicklist;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Object doInBackground() throws Exception {
                for (Integer specID : additionalEntries) {
                    refreshedMap.put(specID, this.this$0.getImageSetForTaxon(specID));
                }
                Map<Integer, TaxonImageSet> map = this.this$0.images;
                synchronized (map) {
                    this.this$0.images.clear();
                    this.this$0.images.putAll(refreshedMap);
                }
                return null;
            }

            @Override
            protected void done() {
                this.this$0.jListPick.repaint();
            }
        };
        worker.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void imagesForTaxonUpdated(int specID) {
        Map<Integer, TaxonImageSet> map = this.images;
        synchronized (map) {
            if (this.images.containsKey(specID)) {
                TaxonImageSet imageSet = this.getImageSetForTaxon(specID);
                this.images.put(specID, imageSet);
            }
        }
    }

    private TaxonImageSet getImageSetForTaxon(int specID) {
        TaxonImageSet imageSet = null;
        for (TaxonImageSet im : this.sbdb.getTaxonImageService().getImages(specID)) {
            if (imageSet == null) {
                imageSet = im;
            } else if (!imageSet.isType() && im.isType()) {
                imageSet = im;
            }
            if (imageSet == null || !imageSet.isType()) continue;
            break;
        }
        if (imageSet != null) {
            try {
                Image i = imageSet.getFirstImage(this.sbdb.getImageRecordService(), this.sbdb.getImageLoader(), new Dimension(80, 80));
                imageSet.clearCaches();
                if (i == null) {
                    imageSet = null;
                }
            }
            catch (RuntimeException re) {
                Logger.getLogger(JPanelPicklist.class.getName()).log(Level.WARNING, "Error loading image set with ID:" + imageSet.getImageSetID() + " - " + re.getMessage());
                imageSet = null;
            }
        }
        return imageSet;
    }

    @Override
    public void onTaxonDetailsUpdated(model3.Taxon taxon) {
        this.jListPick.repaint();
    }

    @Override
    public void onTaxonDelete(model3.Taxon taxon) {
        if (this.picklistModel != null) {
            if (this.picklistModel.removeElement(taxon)) {
                this.jListPick.repaint();
            }
            taxon.deleteListener(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jMenuItemReplaceSynActionPerformed() {
        model3.Taxon junior = this.getSelectedTaxon();
        Taxon domainPref = (Taxon)this.sbdb.getSynonymService().getPreferredTerm(this.parent.getSynSchID(), junior.getSpecID(), this.sbdb.getTaxonService()).orElseThrow(IllegalStateException::new);
        try {
            model3.Taxon pref = this.sbdb.getTaxon(domainPref.getSpecID());
            pref.registerListener(this);
            junior.deleteListener(this);
            Map<Integer, TaxonImageSet> map = this.images;
            synchronized (map) {
                this.images.remove(junior.getSpecID());
            }
            this.picklistModel.set(this.jListPick.getSelectedIndex(), pref);
            this.sortPicklist();
            this.jListPick.setSelectedValue(pref, true);
            this.refreshImages();
        }
        catch (SQLException e) {
            SbugsExceptionHandler.showStackError(e, this.parent);
        }
    }

    private void openInTaxaDB(ActionEvent e) {
        model3.Taxon taxon = this.getSelectedTaxon();
        if (taxon != null) {
            this.parent.getParent().openTaxaDBFrame(taxon);
        }
    }

    private void initSpecTypeModel() throws SQLException {
        Object selectedItem = this.specTypeModel.getSelectedItem();
        this.specTypeModel.removeAllElements();
        this.specTypeModel.addAll(this.sbdb.getSpeciesTypeService().getAllSpeciesTypes());
        if (selectedItem != null) {
            this.specTypeModel.setSelectedItem(selectedItem);
        } else {
            this.jComboBoxSpecType.setSelectedIndex(0);
        }
        this.jComboBoxSpecType.repaint();
    }

    private void initComponents() {
        this.jScrollPanePicklist = new JScrollPane();
        this.jListPick = new SBList(false);
        this.jPanel13 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jToolBar1 = new JToolBar();
        this.jButtonInsertTaxa = new JButton();
        this.jButtonInsertGroup = new JButton();
        this.jButtonInsertWell = new JButton();
        this.jPanelSort = new JPanel();
        this.jRadioButtonCategory = new JRadioButton();
        this.jRadioButtonSpecies = new JRadioButton();
        this.jRadioButtonGenus = new JRadioButton();
        this.panel1 = new JPanel();
        this.jToolBar3 = new JToolBar();
        this.jButtonTaxonImage = new JButton();
        this.jCheckBoxAbrGenus = new JCheckBox();
        this.jPanelQualifiers = new JPanel();
        this.jRadioButtonNone = new JRadioButton();
        this.jRadioButtonSpp = new JRadioButton();
        this.jRadioButtonGrp = new JRadioButton();
        this.jRadioButtonAff = new JRadioButton();
        this.jRadioButtonCf = new JRadioButton();
        this.jPanel9 = new JPanel();
        this.jSpinnerCoarse = new JSpinner();
        this.jLabelCoarse = new JLabel();
        this.jSpinnerFine = new JSpinner();
        this.jLabelMedium = new JLabel();
        this.jLabelFine = new JLabel();
        this.jSpinnerMedium = new JSpinner();
        this.jComboBoxAbund = new JComboBox();
        this.jRadioButtonCoarse = new JRadioButton();
        this.jRadioButtonMedium = new JRadioButton();
        this.jRadioButtonFine = new JRadioButton();
        this.jPanelSituation = new JPanel();
        this.jRadioButtonReworked = new JRadioButton();
        this.jRadioButtonInSitu = new JRadioButton();
        this.jRadioButtonTransported = new JRadioButton();
        this.jRadioButtonCaved = new JRadioButton();
        this.jToggleButtonKeepSituation = new JToggleButton();
        this.jRadioButtonContamination = new JRadioButton();
        this.jPanelConfidence = new JPanel();
        this.jRadioButtonConfident = new JRadioButton();
        this.jRadioButtonQuestionable = new JRadioButton();
        this.jToggleButtonKeepConfidence = new JToggleButton();
        this.jComboBoxSpecType = new JComboBox();
        this.jButtonSelectSpecType = new JButton();
        this.jCheckBoxMarker = new JCheckBox();
        this.jToolBar4 = new JToolBar();
        this.jButtonAddToSample = new JButton();
        this.jButtonClearAll = new JButton();
        this.jButtonClearSelected = new JButton();
        this.jButtonRestore = new JButton();
        this.jPopupMenuPicklist = new JPopupMenu();
        this.jMenuItemWeb = new JMenuItem();
        this.menuItemOpenInTaxaDB = new JMenuItem();
        this.jMenuItemURL = new JMenuItem();
        this.jMenuItemImage = new JMenuItem();
        this.jMenuItemRefNotes = new JMenuItem();
        this.jMenuItemEdit = new JMenuItem();
        this.jMenuItemReplaceSyn = new JMenuItem();
        this.jMenuItemRemove = new JMenuItem();
        this.buttonGroupPickSort = new ButtonGroup();
        this.buttonGroupQualifiers = new ButtonGroup();
        this.buttonGroupSizeFraction = new ButtonGroup();
        this.buttonGroupSituation = new ButtonGroup();
        this.buttonGroupConfidence = new ButtonGroup();
        this.setMinimumSize(new Dimension(200, 600));
        this.setLayout((LayoutManager)new MigLayout("insets 0,hidemode 3,gap 5 5", "[grow,fill][160,shrink 0,fill]", "[grow,fill]"));
        this.jScrollPanePicklist.setBorder(new EtchedBorder());
        this.jScrollPanePicklist.setMinimumSize(new Dimension(205, 628));
        this.jListPick.setModel(this.picklistModel);
        this.jListPick.setBorder(new EmptyBorder(0, 2, 0, 2));
        this.jListPick.setLayoutOrientation(1);
        this.jListPick.setVisibleRowCount(0);
        this.jListPick.addMouseMotionListener(new MouseMotionAdapter(this){
            final /* synthetic */ JPanelPicklist this$0;
            {
                JPanelPicklist jPanelPicklist = this$0;
                Objects.requireNonNull(jPanelPicklist);
                this.this$0 = jPanelPicklist;
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                this.this$0.jListPickMouseMoved(e);
            }
        });
        this.jListPick.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ JPanelPicklist this$0;
            {
                JPanelPicklist jPanelPicklist = this$0;
                Objects.requireNonNull(jPanelPicklist);
                this.this$0 = jPanelPicklist;
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                this.this$0.jListPickMouseClicked(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.this$0.jListPickMousePressed(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.this$0.jListPickMouseReleased(e);
            }
        });
        this.jListPick.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ JPanelPicklist this$0;
            {
                JPanelPicklist jPanelPicklist = this$0;
                Objects.requireNonNull(jPanelPicklist);
                this.this$0 = jPanelPicklist;
            }

            @Override
            public void keyPressed(KeyEvent e) {
                this.this$0.jListPickKeyPressed(e);
            }
        });
        this.jListPick.addListSelectionListener(e -> this.jListPickValueChanged(e));
        this.jScrollPanePicklist.setViewportView(this.jListPick);
        this.add((Component)this.jScrollPanePicklist, "pad 5 0 5 0,cell 0 0,growy");
        this.jPanel13.setLayout((LayoutManager)new MigLayout("insets panel,hidemode 3", "rel[80,fill]rel", "[fill][fill][fill][fill][fill][fill][fill][fill]unrel[grow,fill][fill]"));
        this.jLabel1.setForeground(new Color(0x3366CC));
        this.jLabel1.setText("Add taxa to picklist:");
        this.jPanel13.add((Component)this.jLabel1, "cell 0 0");
        this.jToolBar1.setRollover(true);
        this.jButtonInsertTaxa.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/FrameTaxa_FindTaxon.png")));
        this.jButtonInsertTaxa.setToolTipText("Add individual taxa to picklist");
        this.jButtonInsertTaxa.setFocusable(false);
        this.jButtonInsertTaxa.setHorizontalTextPosition(0);
        this.jButtonInsertTaxa.setMargin(new Insets(2, 1, 2, 1));
        this.jButtonInsertTaxa.setVerticalTextPosition(3);
        this.jButtonInsertTaxa.addActionListener(e -> this.jButtonInsertTaxaActionPerformed(e));
        this.jToolBar1.add(this.jButtonInsertTaxa);
        this.jButtonInsertGroup.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/FrameSamples_AddGroup.png")));
        this.jButtonInsertGroup.setToolTipText("Add group to picklist");
        this.jButtonInsertGroup.setFocusable(false);
        this.jButtonInsertGroup.setHorizontalTextPosition(0);
        this.jButtonInsertGroup.setMargin(new Insets(2, 1, 2, 1));
        this.jButtonInsertGroup.setVerticalTextPosition(3);
        this.jButtonInsertGroup.addActionListener(e -> this.jButtonInsertGroupActionPerformed(e));
        this.jToolBar1.add(this.jButtonInsertGroup);
        this.jButtonInsertWell.setIcon(new ImageIcon(this.getClass().getResource("/resources/frameicon/24Wells.png")));
        this.jButtonInsertWell.setToolTipText("Add taxa from a well to picklist");
        this.jButtonInsertWell.setFocusable(false);
        this.jButtonInsertWell.setHorizontalTextPosition(0);
        this.jButtonInsertWell.setMargin(new Insets(2, 1, 2, 1));
        this.jButtonInsertWell.setVerticalTextPosition(3);
        this.jButtonInsertWell.addActionListener(e -> this.jButtonInsertWellActionPerformed(e));
        this.jToolBar1.add(this.jButtonInsertWell);
        this.jPanel13.add((Component)this.jToolBar1, "cell 0 1");
        this.jPanelSort.setBorder(new TitledBorder("Sort"));
        this.jPanelSort.setLayout((LayoutManager)new MigLayout("insets 5 3 5 3,hidemode 3,gap 5 5", "[fill]", "[fill][fill][fill]"));
        this.jRadioButtonCategory.setText("Category");
        this.jRadioButtonCategory.setBorder(BorderFactory.createEmptyBorder());
        this.jRadioButtonCategory.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioButtonCategory.addActionListener(e -> this.jRadioButtonCategoryActionPerformed(e));
        this.jPanelSort.add((Component)this.jRadioButtonCategory, "cell 0 0");
        this.jRadioButtonSpecies.setText("Species");
        this.jRadioButtonSpecies.setBorder(BorderFactory.createEmptyBorder());
        this.jRadioButtonSpecies.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioButtonSpecies.addActionListener(e -> this.jRadioButtonSpeciesActionPerformed(e));
        this.jPanelSort.add((Component)this.jRadioButtonSpecies, "cell 0 1");
        this.jRadioButtonGenus.setSelected(true);
        this.jRadioButtonGenus.setText("Genus");
        this.jRadioButtonGenus.setBorder(BorderFactory.createEmptyBorder());
        this.jRadioButtonGenus.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioButtonGenus.addActionListener(e -> this.jRadioButtonGenusActionPerformed(e));
        this.jPanelSort.add((Component)this.jRadioButtonGenus, "cell 0 2");
        this.jPanel13.add((Component)this.jPanelSort, "cell 0 2");
        this.panel1.setLayout((LayoutManager)new MigLayout("insets panel,hidemode 3", "[fill]", "[][]"));
        this.jToolBar3.setRollover(true);
        this.jButtonTaxonImage.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/camera.png")));
        this.jButtonTaxonImage.setToolTipText("Display image(s) of selected taxon");
        this.jButtonTaxonImage.addActionListener(e -> this.jButtonTaxonImageActionPerformed(e));
        this.jToolBar3.add(this.jButtonTaxonImage);
        this.panel1.add((Component)this.jToolBar3, "cell 0 1");
        this.jCheckBoxAbrGenus.setText("Abr. genus");
        this.jCheckBoxAbrGenus.addActionListener(e -> this.jCheckBoxAbrGenusActionPerformed(e));
        this.panel1.add((Component)this.jCheckBoxAbrGenus, "cell 0 0");
        this.jPanel13.add((Component)this.panel1, "cell 0 2");
        this.jPanelQualifiers.setBorder(new TitledBorder("Qualifiers"));
        this.jPanelQualifiers.setPreferredSize(new Dimension(153, 106));
        this.jPanelQualifiers.setLayout((LayoutManager)new MigLayout("insets 5 3 5 3,hidemode 3,gap 5 5", "[fill]rel[grow,fill]rel", "[fill][fill][fill]"));
        this.jRadioButtonNone.setSelected(true);
        this.jRadioButtonNone.setText("None");
        this.jRadioButtonNone.setBorder(BorderFactory.createEmptyBorder());
        this.jRadioButtonNone.setMargin(new Insets(0, 0, 0, 0));
        this.jPanelQualifiers.add((Component)this.jRadioButtonNone, "cell 0 0");
        this.jRadioButtonSpp.setText("spp.");
        this.jRadioButtonSpp.setBorder(BorderFactory.createEmptyBorder());
        this.jRadioButtonSpp.setMargin(new Insets(0, 0, 0, 0));
        this.jPanelQualifiers.add((Component)this.jRadioButtonSpp, "cell 0 1");
        this.jRadioButtonGrp.setText("grp.");
        this.jRadioButtonGrp.setBorder(BorderFactory.createEmptyBorder());
        this.jRadioButtonGrp.setMargin(new Insets(0, 0, 0, 0));
        this.jPanelQualifiers.add((Component)this.jRadioButtonGrp, "cell 0 2");
        this.jRadioButtonAff.setText("aff.");
        this.jRadioButtonAff.setBorder(BorderFactory.createEmptyBorder());
        this.jRadioButtonAff.setMargin(new Insets(0, 0, 0, 0));
        this.jPanelQualifiers.add((Component)this.jRadioButtonAff, "cell 1 1");
        this.jRadioButtonCf.setText("cf.");
        this.jRadioButtonCf.setBorder(BorderFactory.createEmptyBorder());
        this.jRadioButtonCf.setMargin(new Insets(0, 0, 0, 0));
        this.jPanelQualifiers.add((Component)this.jRadioButtonCf, "cell 1 2");
        this.jPanel13.add((Component)this.jPanelQualifiers, "cell 0 3");
        this.jPanel9.setBorder(new TitledBorder("Abundance"));
        this.jPanel9.setLayout((LayoutManager)new MigLayout("insets 5 3 5 3,hidemode 3,gap 5 5", "[fill][grow,fill]", "[fill][fill][fill]rel[fill]"));
        this.jSpinnerCoarse.setModel(new SpinnerNumberModel(0, 0, 999999, 1));
        this.jSpinnerCoarse.setEnabled(false);
        this.jSpinnerCoarse.addChangeListener(e -> this.jSpinnerCoarseStateChanged(e));
        this.jPanel9.add((Component)this.jSpinnerCoarse, "cell 1 0");
        this.jLabelCoarse.setHorizontalAlignment(11);
        this.jLabelCoarse.setText("Coarse:");
        this.jLabelCoarse.setEnabled(false);
        this.jPanel9.add((Component)this.jLabelCoarse, "cell 0 0");
        this.jSpinnerFine.setModel(new SpinnerNumberModel(0, 0, 999999, 1));
        this.jSpinnerFine.setEnabled(false);
        this.jSpinnerFine.addChangeListener(e -> this.jSpinnerFineStateChanged(e));
        this.jPanel9.add((Component)this.jSpinnerFine, "cell 1 2");
        this.jLabelMedium.setHorizontalAlignment(11);
        this.jLabelMedium.setText("Counts:");
        this.jPanel9.add((Component)this.jLabelMedium, "cell 0 1");
        this.jLabelFine.setHorizontalAlignment(11);
        this.jLabelFine.setText("Fine:");
        this.jLabelFine.setEnabled(false);
        this.jPanel9.add((Component)this.jLabelFine, "cell 0 2");
        this.jSpinnerMedium.setModel(new SpinnerNumberModel(0, 0, 999999, 1));
        this.jSpinnerMedium.addChangeListener(e -> this.jSpinnerMediumStateChanged(e));
        this.jSpinnerMedium.setValue(this.parent.isCMF() ? 0 : 1);
        this.jPanel9.add((Component)this.jSpinnerMedium, "cell 1 1");
        this.jComboBoxAbund.setModel(this.abundModel);
        this.jComboBoxAbund.putClientProperty("JComboBox.isPopDown", Boolean.TRUE);
        this.jPanel9.add((Component)this.jComboBoxAbund, "cell 0 3 2 1");
        this.jRadioButtonCoarse.setEnabled(false);
        this.jPanel9.add((Component)this.jRadioButtonCoarse, "cell 1 0");
        this.jPanel9.add((Component)this.jRadioButtonMedium, "cell 1 1");
        this.jRadioButtonFine.setEnabled(false);
        this.jPanel9.add((Component)this.jRadioButtonFine, "cell 1 2");
        this.jPanel13.add((Component)this.jPanel9, "cell 0 4");
        this.jPanelSituation.setBorder(new TitledBorder("Situation"));
        this.jPanelSituation.setLayout((LayoutManager)new MigLayout("insets 5 3 5 3,hidemode 3,gap 5 5", "[grow,fill]", "[fill][fill][fill][fill][fill]"));
        this.jRadioButtonReworked.setText("Reworked");
        this.jRadioButtonReworked.setBorder(BorderFactory.createEmptyBorder());
        this.jRadioButtonReworked.setMargin(new Insets(0, 0, 0, 0));
        this.jPanelSituation.add((Component)this.jRadioButtonReworked, "cell 0 2");
        this.jRadioButtonInSitu.setSelected(true);
        this.jRadioButtonInSitu.setText("In-situ");
        this.jRadioButtonInSitu.setBorder(BorderFactory.createEmptyBorder());
        this.jRadioButtonInSitu.setMargin(new Insets(0, 0, 0, 0));
        this.jPanelSituation.add((Component)this.jRadioButtonInSitu, "cell 0 0");
        this.jRadioButtonTransported.setText("Transported");
        this.jRadioButtonTransported.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.jPanelSituation.add((Component)this.jRadioButtonTransported, "cell 0 1");
        this.jRadioButtonCaved.setText("Caved");
        this.jRadioButtonCaved.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.jPanelSituation.add((Component)this.jRadioButtonCaved, "cell 0 3");
        this.jToggleButtonKeepSituation.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/linked.png")));
        this.jToggleButtonKeepSituation.setToolTipText("Keep situation settings after picking occurrence");
        this.jToggleButtonKeepSituation.setPreferredSize(new Dimension(25, 18));
        this.jToggleButtonKeepSituation.addActionListener(e -> this.jToggleButtonKeepSituationActionPerformed(e));
        this.jPanelSituation.add((Component)this.jToggleButtonKeepSituation, "cell 0 0,alignx right,growx 0");
        this.jRadioButtonContamination.setText("Contamination");
        this.jRadioButtonContamination.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.jPanelSituation.add((Component)this.jRadioButtonContamination, "cell 0 4");
        this.jPanel13.add((Component)this.jPanelSituation, "cell 0 5");
        this.jPanelConfidence.setBorder(new TitledBorder("Confidence"));
        this.jPanelConfidence.setLayout((LayoutManager)new MigLayout("insets 5 3 5 3,hidemode 3,gap 5 5", "[grow,fill]", "[fill][fill]"));
        this.jRadioButtonConfident.setSelected(true);
        this.jRadioButtonConfident.setText("Confident");
        this.jRadioButtonConfident.setBorder(BorderFactory.createEmptyBorder());
        this.jRadioButtonConfident.setMargin(new Insets(0, 0, 0, 0));
        this.jPanelConfidence.add((Component)this.jRadioButtonConfident, "cell 0 0");
        this.jRadioButtonQuestionable.setText("Questionable");
        this.jRadioButtonQuestionable.setBorder(BorderFactory.createEmptyBorder());
        this.jRadioButtonQuestionable.setMargin(new Insets(0, 0, 0, 0));
        this.jPanelConfidence.add((Component)this.jRadioButtonQuestionable, "cell 0 1");
        this.jToggleButtonKeepConfidence.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/linked.png")));
        this.jToggleButtonKeepConfidence.setPreferredSize(new Dimension(25, 18));
        this.jToggleButtonKeepConfidence.addActionListener(e -> this.jToggleButtonKeepConfidenceActionPerformed(e));
        this.jPanelConfidence.add((Component)this.jToggleButtonKeepConfidence, "cell 0 0,alignx right,growx 0");
        this.jPanel13.add((Component)this.jPanelConfidence, "cell 0 6");
        this.jComboBoxSpecType.setModel(this.specTypeModel);
        this.jComboBoxSpecType.putClientProperty("JComboBox.isPopDown", Boolean.TRUE);
        this.jPanel13.add((Component)this.jComboBoxSpecType, "cell 0 7,growx");
        this.jButtonSelectSpecType.setText("...");
        this.jButtonSelectSpecType.addActionListener(e -> this.jButtonSelectSpecTypeActionPerformed(e));
        this.jButtonSelectSpecType.putClientProperty("JComponent.sizeVariant", "small");
        this.jPanel13.add((Component)this.jButtonSelectSpecType, "cell 0 7");
        this.jCheckBoxMarker.setText("Marker");
        this.jCheckBoxMarker.setToolTipText("Indication of a marker just flags this occurrence in the list");
        this.jCheckBoxMarker.setBorder(BorderFactory.createEmptyBorder());
        this.jCheckBoxMarker.setMargin(new Insets(0, 0, 0, 0));
        this.jPanel13.add((Component)this.jCheckBoxMarker, "cell 0 8,aligny top,growy 0");
        this.jToolBar4.setRollover(true);
        this.jButtonAddToSample.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/FrameSamples_AddTaxon.png")));
        this.jButtonAddToSample.setToolTipText("<html>Add selected taxon to analysis<br>and restore default settings</html>");
        this.jButtonAddToSample.setHorizontalTextPosition(0);
        this.jButtonAddToSample.setVerticalTextPosition(3);
        this.jButtonAddToSample.addActionListener(e -> this.jButtonAddToSampleActionPerformed(e));
        this.jToolBar4.add(this.jButtonAddToSample);
        this.jToolBar4.addSeparator();
        this.jButtonClearAll.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/FrameSamples_ClearAll.png")));
        this.jButtonClearAll.setToolTipText("Clear picklist");
        this.jButtonClearAll.setHorizontalTextPosition(0);
        this.jButtonClearAll.setVerticalTextPosition(3);
        this.jButtonClearAll.addActionListener(e -> this.jButtonClearAllActionPerformed(e));
        this.jToolBar4.add(this.jButtonClearAll);
        this.jButtonClearSelected.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/FrameSamples_ClearSelected.png")));
        this.jButtonClearSelected.setToolTipText("Clear selected items from the picklist");
        this.jButtonClearSelected.setHorizontalTextPosition(0);
        this.jButtonClearSelected.setVerticalTextPosition(3);
        this.jButtonClearSelected.addActionListener(e -> this.jButtonClearSelectedActionPerformed(e));
        this.jToolBar4.add(this.jButtonClearSelected);
        this.jButtonRestore.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/FrameSamples_Restore.png")));
        this.jButtonRestore.setToolTipText("Restore default settings");
        this.jButtonRestore.setHorizontalTextPosition(0);
        this.jButtonRestore.setVerticalTextPosition(3);
        this.jButtonRestore.addActionListener(e -> this.jButtonRestoreActionPerformed(e));
        this.jToolBar4.add(this.jButtonRestore);
        this.jPanel13.add((Component)this.jToolBar4, "cell 0 9");
        this.add((Component)this.jPanel13, "cell 1 0");
        this.jMenuItemWeb.setText("Search web...");
        this.jMenuItemWeb.addActionListener(e -> this.jMenuItemWebActionPerformed(e));
        this.jPopupMenuPicklist.add(this.jMenuItemWeb);
        this.menuItemOpenInTaxaDB.setText("Open in Taxonomic Database module ...");
        this.menuItemOpenInTaxaDB.addActionListener(e -> this.openInTaxaDB(e));
        this.jPopupMenuPicklist.add(this.menuItemOpenInTaxaDB);
        this.jMenuItemURL.setText("Go to URL...");
        this.jMenuItemURL.addActionListener(e -> this.jMenuItemURLActionPerformed(e));
        this.jPopupMenuPicklist.add(this.jMenuItemURL);
        this.jMenuItemImage.setText("Image...");
        this.jMenuItemImage.addActionListener(e -> this.jMenuItemImageActionPerformed(e));
        this.jPopupMenuPicklist.add(this.jMenuItemImage);
        this.jMenuItemRefNotes.setText("References and notes...");
        this.jMenuItemRefNotes.addActionListener(e -> this.jMenuItemRefNotesActionPerformed(e));
        this.jPopupMenuPicklist.add(this.jMenuItemRefNotes);
        this.jMenuItemEdit.setText("Edit...");
        this.jMenuItemEdit.addActionListener(e -> this.jMenuItemEditActionPerformed(e));
        this.jPopupMenuPicklist.add(this.jMenuItemEdit);
        this.jMenuItemReplaceSyn.setText("Replace with preferred term");
        this.jMenuItemReplaceSyn.addActionListener(e -> this.jMenuItemReplaceSynActionPerformed());
        this.jPopupMenuPicklist.add(this.jMenuItemReplaceSyn);
        this.jMenuItemRemove.setText("Remove from picklist");
        this.jMenuItemRemove.addActionListener(e -> this.jMenuItemRemoveActionPerformed(e));
        this.jPopupMenuPicklist.add(this.jMenuItemRemove);
        this.buttonGroupPickSort.add(this.jRadioButtonCategory);
        this.buttonGroupPickSort.add(this.jRadioButtonSpecies);
        this.buttonGroupPickSort.add(this.jRadioButtonGenus);
        this.buttonGroupQualifiers.add(this.jRadioButtonNone);
        this.buttonGroupQualifiers.add(this.jRadioButtonSpp);
        this.buttonGroupQualifiers.add(this.jRadioButtonGrp);
        this.buttonGroupQualifiers.add(this.jRadioButtonAff);
        this.buttonGroupQualifiers.add(this.jRadioButtonCf);
        this.buttonGroupSizeFraction.add(this.jRadioButtonCoarse);
        this.buttonGroupSizeFraction.add(this.jRadioButtonMedium);
        this.buttonGroupSizeFraction.add(this.jRadioButtonFine);
        this.buttonGroupSituation.add(this.jRadioButtonReworked);
        this.buttonGroupSituation.add(this.jRadioButtonInSitu);
        this.buttonGroupSituation.add(this.jRadioButtonTransported);
        this.buttonGroupSituation.add(this.jRadioButtonCaved);
        this.buttonGroupSituation.add(this.jRadioButtonContamination);
        this.buttonGroupConfidence.add(this.jRadioButtonConfident);
        this.buttonGroupConfidence.add(this.jRadioButtonQuestionable);
    }

    private model3.Taxon getSelectedTaxon() {
        return (model3.Taxon)this.jListPick.getSelectedValue();
    }

    private List<model3.Taxon> getSelectedTaxa() {
        return this.jListPick.getSelectedValuesList().stream().map(model3.Taxon.class::cast).toList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void insertGroup() {
        try {
            DialogSelectGroup dialog = new DialogSelectGroup(this.parent, true, this.sbdb, null, false, true);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.multiSelection != null) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                if (dialog.multiSelection.size() == 1) {
                    this.setGroup(dialog.selection);
                    String title = this.picklistModel.isEmpty() && !this.changed ? this.group.getName() : "Picklist";
                    this.parent.renamePicklist(this, title);
                }
                for (TxGroup txGroup : dialog.multiSelection) {
                    this.setTaxa(this.sbdb.getTxGroupTaxa(txGroup));
                }
            }
            this.parent.setAlwaysOnTop(true);
            this.parent.setAlwaysOnTop(false);
        }
        catch (RuntimeException | SQLException ex) {
            SbugsExceptionHandler.showStackError(ex, this.parent);
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    void addTaxonPick() {
        model3.Taxon selectedTaxon = this.getSelectedTaxon();
        Taxon taxon = selectedTaxon != null ? selectedTaxon.getTaxonCopy() : null;
        try {
            final DialogSelectTaxa dialog = new DialogSelectTaxa(this.parent, true, this.sbdb, this.parent.getSynSchID(), false, taxon);
            dialog.setLocationRelativeTo(this);
            dialog.setAlwaysOnTop(true);
            dialog.setVisible(true);
            if (!dialog.getSelectedItems().isEmpty()) {
                ArrayList<model3.Taxon> selected = new ArrayList<model3.Taxon>();
                for (Taxon t : dialog.getSelectedItems()) {
                    selected.add(this.sbdb.getTaxon(t.getSpecID()));
                }
                for (model3.Taxon tx : selected) {
                    if (this.picklistModel.contains(tx)) continue;
                    this.picklistModel.addElement(tx);
                    tx.registerListener(this);
                }
                if (this.getGroupAutoSave()) {
                    this.saveGroup();
                } else {
                    this.changed = true;
                }
                SwingUtilities.invokeLater(new Runnable(){
                    final /* synthetic */ JPanelPicklist this$0;
                    {
                        JPanelPicklist jPanelPicklist = this$0;
                        Objects.requireNonNull(jPanelPicklist);
                        this.this$0 = jPanelPicklist;
                    }

                    @Override
                    public void run() {
                        this.this$0.sortPicklist();
                        int[] selection = new int[dialog.getSelectedItems().size()];
                        int i = 0;
                        ArrayList<model3.Taxon> selected = new ArrayList<model3.Taxon>();
                        try {
                            for (Taxon taxon : dialog.getSelectedItems()) {
                                selected.add(this.this$0.sbdb.getTaxon(taxon.getSpecID()));
                            }
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                        for (model3.Taxon taxon : selected) {
                            selection[i] = this.this$0.picklistModel.indexOf(taxon);
                            ++i;
                        }
                        this.this$0.jListPick.setSelectedIndices(selection);
                        this.this$0.jListPick.scrollRectToVisible(this.this$0.jListPick.getCellBounds(selection[0], selection[selection.length - 1]));
                    }
                });
                this.refreshImages();
            }
        }
        catch (RuntimeException | SQLException ex) {
            SbugsExceptionHandler.showStackError(ex, this.parent);
        }
    }

    boolean getGroupAutoSave() {
        if (this.group != null && !this.changed) {
            if (this.groupAutoSave == null) {
                int opt = JOptionPane.showConfirmDialog(this.parent, "Do you want to update your picklist group: " + this.group.getName() + " with all new taxa as they are added to the list?", "Picklist", 0);
                this.groupAutoSave = opt == 0;
            }
        } else {
            return false;
        }
        return this.groupAutoSave;
    }

    boolean isUnsaved() {
        return this.picklistModel.size() > 0 && this.changed;
    }

    int getGroupID() {
        if (this.group != null) {
            return this.group.getID();
        }
        return 0;
    }

    private void jListPickMouseClicked(MouseEvent evt) {
        this.parent.getWellPanel().stopCellEditor();
        if ((this.parent.isMultiClick() && evt.getClickCount() > 1 || !this.parent.isMultiClick() && evt.getClickCount() == 2) && evt.getButton() == 1) {
            boolean added = this.addToSample(true, false);
            if (!added && !this.parent.isNumeric()) {
                this.restorePicklist();
            } else {
                if (!this.keepSituation()) {
                    this.jRadioButtonInSitu.setSelected(true);
                }
                if (!this.keepConfidence()) {
                    this.jRadioButtonConfident.setSelected(true);
                }
            }
        }
        this.tempCount = "";
    }

    private boolean keepSituation() {
        return this.jToggleButtonKeepSituation.isSelected();
    }

    private boolean keepConfidence() {
        return this.jToggleButtonKeepConfidence.isSelected();
    }

    private void jRadioButtonCategoryActionPerformed(ActionEvent evt) {
        this.sortPicklist(Taxon.SortOrder.SORT_CATEGORY);
    }

    private void jRadioButtonSpeciesActionPerformed(ActionEvent evt) {
        this.sortPicklist(Taxon.SortOrder.SORT_SPECIES);
    }

    private void jRadioButtonGenusActionPerformed(ActionEvent evt) {
        this.sortPicklist(Taxon.SortOrder.SORT_GENUS);
    }

    private void jButtonInsertTaxaActionPerformed(ActionEvent evt) {
        this.addTaxonPick();
    }

    private void jButtonInsertGroupActionPerformed(ActionEvent evt) {
        boolean empty = this.picklistModel.isEmpty();
        this.insertGroup();
        if (!empty) {
            this.changed = true;
        }
    }

    private void jButtonInsertWellActionPerformed(ActionEvent evt) {
        this.parent.insertWell(this);
        this.changed = true;
    }

    private void jButtonAddToSampleActionPerformed(ActionEvent evt) {
        List<Smpdtl> smpdtls = this.parent.getSelectedSmpdtls();
        if (smpdtls != null ? !this.addToSamples(smpdtls) : this.addToSample(false, false)) {
            return;
        }
        this.restorePicklist();
    }

    void restorePicklist() {
        this.jRadioButtonNone.setSelected(true);
        if (!this.keepSituation()) {
            this.jRadioButtonInSitu.setSelected(true);
        }
        this.jCheckBoxMarker.setSelected(false);
        if (!this.keepConfidence()) {
            this.jRadioButtonConfident.setSelected(true);
        }
        if (this.parent.isNumeric()) {
            if (this.parent.isCMF()) {
                if (this.jRadioButtonCoarse.isSelected()) {
                    this.jSpinnerCoarse.setValue(1);
                    this.jSpinnerFine.setValue(0);
                    this.jSpinnerMedium.setValue(0);
                } else if (this.jRadioButtonFine.isSelected()) {
                    this.jSpinnerFine.setValue(1);
                    this.jSpinnerCoarse.setValue(0);
                    this.jSpinnerMedium.setValue(0);
                } else {
                    this.jSpinnerMedium.setValue(1);
                    this.jSpinnerCoarse.setValue(0);
                    this.jSpinnerFine.setValue(0);
                }
            } else {
                this.jSpinnerMedium.setValue(1);
                this.jRadioButtonMedium.setSelected(true);
            }
        } else {
            this.jComboBoxAbund.setSelectedIndex(this.abundModel.getSize() > 1 ? 1 : 0);
        }
        this.jComboBoxSpecType.setSelectedIndex(0);
    }

    private void jButtonRestoreActionPerformed(ActionEvent evt) {
        this.restorePicklist();
    }

    private void jButtonClearSelectedActionPerformed(ActionEvent evt) {
        this.clearSelection();
        this.changed = !this.picklistModel.isEmpty();
    }

    private void jButtonClearAllActionPerformed(ActionEvent evt) {
        this.clear();
        this.changed = false;
    }

    private void jButtonTaxonImageActionPerformed(ActionEvent evt) {
        this.showImage();
    }

    private void showImage() {
        model3.Taxon taxon = this.getSelectedTaxon();
        if (taxon == null) {
            JOptionPane.showMessageDialog(this, "No taxa selected.", this.parent.getTitle(), 2);
            return;
        }
        try {
            DialogTaxonImages dialog = DialogTaxonImages.imageGalleryDialogForTaxon(this.parent, taxon, this.sbdb);
            dialog.enableAnalysisSelection();
            dialog.setLocationRelativeTo(this.jButtonTaxonImage);
            dialog.setVisible(true);
            if (dialog.getSelectedAnalysis() != null) {
                this.parent.parent.setSamplesSmpdtl(dialog.getSelectedAnalysis().well(), dialog.getSelectedAnalysis().smpdtl());
            }
        }
        catch (RuntimeException | SQLException | SBException ex) {
            SbugsExceptionHandler.showStackError(ex, this.parent);
        }
    }

    private void jButtonSelectSpecTypeActionPerformed(ActionEvent evt) {
        try {
            DialogSpecType dialog = new DialogSpecType((Frame)this.parent, true, this.sbdb);
            dialog.setLocationRelativeTo(this.jButtonSelectSpecType);
            dialog.setVisible(true);
            this.initSpecTypeModel();
        }
        catch (SQLException sql) {
            SbugsExceptionHandler.showStackError(sql, this.parent);
        }
    }

    private void jListPickValueChanged(ListSelectionEvent evt) {
        this.tempCount = "";
        model3.Taxon t = this.getSelectedTaxon();
        if (this.selectedTaxon == null || !this.selectedTaxon.equals(t)) {
            this.selectedTaxon = t;
            this.notifyTaxonSelectionListeners();
        }
    }

    private void jListPickKeyPressed(KeyEvent evt) {
        this.parent.getWellPanel().stopCellEditor();
        switch (evt.getKeyCode()) {
            case 45: 
            case 109: {
                this.tempCount = "-1";
            }
            case 10: {
                this.addToSample(true, false);
                this.tempCount = "";
                if (!this.keepSituation()) {
                    this.jRadioButtonInSitu.setSelected(true);
                }
                if (!this.keepConfidence()) {
                    this.jRadioButtonConfident.setSelected(true);
                }
                this.jCheckBoxMarker.setSelected(false);
                return;
            }
            case 8: {
                if (this.tempCount.length() > 0) {
                    if (this.tempCount.length() == 1) {
                        this.tempCount = "";
                        this.jListPick.setToolTipText(null);
                    } else {
                        this.tempCount = this.tempCount.substring(0, this.tempCount.length() - 1);
                        if (Integer.parseInt(this.tempCount) > 0) {
                            this.jListPick.setToolTipText(this.tempCount);
                        } else {
                            this.jListPick.setToolTipText(null);
                        }
                    }
                }
                return;
            }
        }
        char c = evt.getKeyChar();
        if (c == '\uffff') {
            return;
        }
        if (c >= '0' && c <= '9') {
            if (this.tempCount.isEmpty() || Integer.parseInt(this.tempCount) <= 0) {
                this.tempCount = Character.toString(c);
            } else if (this.tempCount.length() >= 6) {
                this.getToolkit().beep();
            } else {
                this.tempCount = this.tempCount + Character.toString(c);
            }
        } else if (c == '+') {
            this.tempCount = "0";
        } else if (c == '?' || c == '/') {
            if (this.jRadioButtonQuestionable.isSelected()) {
                this.jRadioButtonConfident.setSelected(true);
            } else {
                this.jRadioButtonQuestionable.setSelected(true);
            }
        } else if (Character.toLowerCase(c) == 'r' && evt.isAltDown()) {
            if (this.jRadioButtonReworked.isSelected()) {
                this.jRadioButtonInSitu.setSelected(true);
            } else {
                this.jRadioButtonReworked.setSelected(true);
            }
        } else if (Character.toLowerCase(c) == 'i' && evt.isAltDown()) {
            this.jRadioButtonInSitu.setSelected(true);
        } else if (Character.toLowerCase(c) == 'c' && evt.isAltDown()) {
            if (this.jRadioButtonCaved.isSelected()) {
                this.jRadioButtonInSitu.setSelected(true);
            } else {
                this.jRadioButtonCaved.setSelected(true);
            }
        } else if (Character.toLowerCase(c) == 't' && evt.isAltDown()) {
            if (this.jRadioButtonTransported.isSelected()) {
                this.jRadioButtonInSitu.setSelected(true);
            } else {
                this.jRadioButtonTransported.setSelected(true);
            }
        } else if (Character.toLowerCase(c) == 'm' && evt.isAltDown()) {
            this.jCheckBoxMarker.setSelected(!this.jCheckBoxMarker.isSelected());
        }
        if (this.tempCount.length() > 0 && !this.tempCount.equals("0")) {
            this.jListPick.setToolTipText((this.jRadioButtonQuestionable.isSelected() ? "?" : "") + (this.jRadioButtonTransported.isSelected() ? "Tr" : "") + (this.jRadioButtonReworked.isSelected() ? "Rw" : "") + (this.jRadioButtonCaved.isSelected() ? "Cv" : "") + this.tempCount);
        } else {
            this.jListPick.setToolTipText(null);
        }
    }

    private void jMenuItemURLActionPerformed(ActionEvent evt) {
        model3.Taxon taxon = this.getSelectedTaxon();
        try {
            String url = taxon.getURL();
            if (url == null || url.isEmpty()) {
                return;
            }
            Desktop.getDesktop().browse(URI.create(url));
        }
        catch (IOException sql) {
            SbugsExceptionHandler.showStackError(sql, this.parent);
        }
    }

    private void jListPickMouseReleased(MouseEvent evt) {
        this.evaluatePopup(evt);
    }

    private void jMenuItemWebActionPerformed(ActionEvent evt) {
        model3.Taxon taxon = this.getSelectedTaxon();
        try {
            WebSearch webSearch = new WebSearch();
            String taxonName = taxon.toString(false, false);
            Desktop.getDesktop().browse(URI.create(webSearch.getURL(this.sbdb, taxonName)));
        }
        catch (IOException | SQLException e) {
            SbugsExceptionHandler.showStackError(e, this.parent);
        }
    }

    private void jListPickMouseMoved(MouseEvent evt) {
        int index = this.jListPick.locationToIndex(evt.getPoint());
        Object ttt = null;
        if (index > -1) {
            model3.Taxon taxon = (model3.Taxon)this.jListPick.getModel().getElementAt(index);
            if (taxon != null) {
                ttt = TaxonNameRenderer.getRefNotesTooltipHtmlFragment(taxon.getReference(), taxon.getNotes());
                if (this.jCheckBoxAbrGenus.isSelected()) {
                    ttt = "<strong>" + StringEscapeUtils.escapeXml11((String)taxon.toString(true)) + "</strong>" + (String)(ttt != null ? "<br>" + (String)ttt : "");
                }
                if (this.parent.getSynSchID() > 0) {
                    Taxon preferredTerm;
                    List synonyms = this.sbdb.getSynonymService().getSynonyms(this.parent.getSynSchID(), taxon.getSpecID(), this.sbdb.getTaxonService());
                    if (!synonyms.isEmpty()) {
                        ttt = (String)(ttt != null ? (String)ttt + "<br>" : "") + "<strong>Synonyms:</strong> " + StringEscapeUtils.escapeHtml4((String)StringUtils.join((Iterable)synonyms, (String)", "));
                    }
                    if ((preferredTerm = (Taxon)this.sbdb.getSynonymService().getPreferredTerm(this.parent.getSynSchID(), taxon.getSpecID(), this.sbdb.getTaxonService()).orElse(null)) != null) {
                        ttt = (String)(ttt != null ? (String)ttt + "<br>" : "") + "<strong>Preferred:</strong> " + StringEscapeUtils.escapeHtml4((String)preferredTerm.toString(true));
                    }
                }
                if (ttt != null) {
                    ttt = "<html>" + (String)ttt + "</html>";
                }
            }
            this.jListPick.setToolTipText((String)ttt);
        }
    }

    private void jCheckBoxAbrGenusActionPerformed(ActionEvent evt) {
        this.jListPick.setToolTipText(null);
        this.jListPick.setVisibleRowCount(-1);
        this.jListPick.repaint();
    }

    private void jMenuItemRefNotesActionPerformed(ActionEvent evt) {
        model3.Taxon taxon = this.getSelectedTaxon();
        if (taxon == null) {
            JOptionPane.showMessageDialog(this, "No taxon selected", this.parent.getTitle(), 2);
            return;
        }
        DialogTaxonNotes dialog = new DialogTaxonNotes(this.parent, true, this.sbdb.getTaxonService(), taxon.getTaxonCopy());
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }

    private void jSpinnerCoarseStateChanged(ChangeEvent evt) {
        if ((Integer)this.jSpinnerCoarse.getValue() > 0) {
            this.jRadioButtonCoarse.setSelected(true);
        }
    }

    private void jSpinnerMediumStateChanged(ChangeEvent evt) {
        if ((Integer)this.jSpinnerMedium.getValue() > 0) {
            this.jRadioButtonMedium.setSelected(true);
        }
    }

    private void jSpinnerFineStateChanged(ChangeEvent evt) {
        if ((Integer)this.jSpinnerFine.getValue() > 0) {
            this.jRadioButtonFine.setSelected(true);
        }
    }

    private void jMenuItemRemoveActionPerformed(ActionEvent evt) {
        if (this.jListPick.getSelectedIndices().length != 1) {
            JOptionPane.showMessageDialog(this, "Select one entry to remove", this.parent.getTitle(), 1);
            return;
        }
        this.clearSelection();
    }

    private void jMenuItemEditActionPerformed(ActionEvent evt) {
        if (this.jListPick.getSelectedIndices().length != 1) {
            JOptionPane.showMessageDialog(this, "Select one entry to edit", this.parent.getTitle(), 1);
            return;
        }
        model3.Taxon taxon = this.getSelectedTaxon();
        DialogTaxon dialog = new DialogTaxon(this.parent, true, this.sbdb, taxon, false, this.parent.parent.getChartManager());
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        taxon.notifyListeners();
        this.jListPick.repaint();
    }

    private void jListPickMousePressed(MouseEvent evt) {
        this.evaluatePopup(evt);
    }

    private void jToggleButtonKeepSituationActionPerformed(ActionEvent evt) {
        TitledBorder b = (TitledBorder)this.jPanelSituation.getBorder();
        b.setTitleFont(b.getTitleFont().deriveFont(this.keepSituation() ? 1 : 0));
        this.setSituationButtonFont();
    }

    private void jToggleButtonKeepConfidenceActionPerformed(ActionEvent evt) {
        TitledBorder b = (TitledBorder)this.jPanelConfidence.getBorder();
        b.setTitleFont(b.getTitleFont().deriveFont(this.keepConfidence() ? 1 : 0));
        this.setConfidenceButtonFont();
    }

    private void jMenuItemImageActionPerformed(ActionEvent evt) {
        this.showImage();
    }

    private void setSituationButtonFont() {
        this.jRadioButtonTransported.setFont(this.jRadioButtonTransported.getFont().deriveFont(this.keepSituation() && this.getSituationFromRadioButton() == Situation.TR ? 1 : 0));
        this.jRadioButtonReworked.setFont(this.jRadioButtonReworked.getFont().deriveFont(this.keepSituation() && this.getSituationFromRadioButton() == Situation.RW ? 1 : 0));
        this.jRadioButtonCaved.setFont(this.jRadioButtonCaved.getFont().deriveFont(this.keepSituation() && this.getSituationFromRadioButton() == Situation.CV ? 1 : 0));
        this.jPanelSituation.repaint();
    }

    private void setConfidenceButtonFont() {
        this.jRadioButtonQuestionable.setFont(this.jRadioButtonQuestionable.getFont().deriveFont(this.keepConfidence() && !this.jRadioButtonConfident.isSelected() ? 1 : 0));
        this.jPanelConfidence.repaint();
    }

    private void initKeepableButtonPanels() {
        ChangeListener confidenceListener = e -> this.setConfidenceButtonFont();
        this.jRadioButtonConfident.addChangeListener(confidenceListener);
        this.jRadioButtonQuestionable.addChangeListener(confidenceListener);
        ChangeListener situationListener = e -> this.setSituationButtonFont();
        this.jRadioButtonTransported.addChangeListener(situationListener);
        this.jRadioButtonReworked.addChangeListener(situationListener);
        this.jRadioButtonCaved.addChangeListener(situationListener);
    }

    private void evaluatePopup(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            model3.Taxon t;
            this.jListPick.setSelectedIndex(this.jListPick.locationToIndex(evt.getPoint()));
            if (this.jListPick.getSelectedIndex() >= 0 && (t = this.getSelectedTaxon()) != null) {
                this.jMenuItemURL.setEnabled(this.getSelectedTaxon().getURL() != null && !this.getSelectedTaxon().getURL().isEmpty());
                boolean isJuniorSynonym = this.parent.getSynSchID() > 0 && this.sbdb.getSynonymService().getPreferredTerm(this.parent.getSynSchID(), t.getSpecID(), this.sbdb.getTaxonService()).isPresent();
                this.jMenuItemReplaceSyn.setEnabled(isJuniorSynonym);
                this.jPopupMenuPicklist.show(this.jListPick, evt.getX(), evt.getY());
            }
        }
    }

    private void sortPicklist() {
        if (this.jRadioButtonGenus.isSelected()) {
            this.sortPicklist(Taxon.SortOrder.SORT_GENUS);
        } else if (this.jRadioButtonSpecies.isSelected()) {
            this.sortPicklist(Taxon.SortOrder.SORT_SPECIES);
        } else {
            this.sortPicklist(Taxon.SortOrder.SORT_CATEGORY);
        }
    }

    private void sortPicklist(Taxon.SortOrder order) {
        LinkedList<model3.Taxon> picklist = new LinkedList<model3.Taxon>();
        Enumeration en = this.picklistModel.elements();
        while (en.hasMoreElements()) {
            picklist.add((model3.Taxon)en.nextElement());
        }
        model3.Taxon.sort(picklist, order);
        this.picklistModel.clear();
        for (model3.Taxon t : picklist) {
            this.picklistModel.addElement(t);
        }
        this.jListPick.repaint();
    }

    static boolean getSampleTotalMessage() {
        return sampleTotalMessage;
    }

    static void setSampleTotalMessage() {
        sampleTotalMessage = true;
    }

    void repaintList() {
        this.jListPick.repaint();
    }

    private class PicklistListLabel
    extends JPanel
    implements ListCellRenderer {
        JLabel textLabel;
        JLabel imageIconLabel;
        JLabel referenceIconLabel;
        final /* synthetic */ JPanelPicklist this$0;

        private PicklistListLabel(JPanelPicklist jPanelPicklist) {
            JPanelPicklist jPanelPicklist2 = jPanelPicklist;
            Objects.requireNonNull(jPanelPicklist2);
            this.this$0 = jPanelPicklist2;
            this.textLabel = new JLabel();
            this.imageIconLabel = new JLabel();
            this.referenceIconLabel = new JLabel();
            this.setOpaque(true);
            this.setLayout(new BoxLayout(this, 2));
            this.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(this.textLabel.getPreferredSize().width + this.imageIconLabel.getPreferredSize().width + 10, super.getPreferredSize().height);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (this.textLabel.getFont().getStyle() != 0) {
                this.textLabel.setFont(this.textLabel.getFont().deriveFont(0));
            }
            this.imageIconLabel.setIcon(null);
            this.referenceIconLabel.setIcon(null);
            this.textLabel.setText(Objects.toString(value, ""));
            if (value instanceof model3.Taxon) {
                boolean hasRefsAndNotes;
                model3.Taxon taxon = (model3.Taxon)value;
                if (this.this$0.jCheckBoxAbrGenus.isSelected()) {
                    this.textLabel.setText(taxon.toGenString(true, model3.Taxon.includeCategoryInString));
                } else {
                    this.textLabel.setText(taxon.toString());
                }
                boolean bl = hasRefsAndNotes = StringUtils.isNotBlank((CharSequence)taxon.getReference()) || StringUtils.isNotBlank((CharSequence)taxon.getNotes());
                this.referenceIconLabel.setIcon(hasRefsAndNotes ? (isSelected ? this.this$0.taxonReferenceIconSelected : this.this$0.taxonReferenceIcon) : null);
                try {
                    boolean isJuniorSynonym;
                    boolean highlight;
                    Map<Integer, TaxonImageSet> map = this.this$0.images;
                    synchronized (map) {
                        TaxonImageSet imageSet = this.this$0.images.get(taxon.getSpecID());
                        if (imageSet != null && imageSet.isType()) {
                            this.imageIconLabel.setIcon(isSelected ? this.this$0.cameraOutlineBoldIconSelected : this.this$0.cameraOutlineBoldIcon);
                        } else if (imageSet != null) {
                            this.imageIconLabel.setIcon(isSelected ? this.this$0.cameraOutlineIconSelected : this.this$0.cameraOutlineIcon);
                        }
                    }
                    Integer nOccs = this.this$0.highlightMap.get(taxon.getSpecID());
                    boolean bl2 = highlight = this.this$0.highlightThreshold >= 0 && nOccs != null && nOccs >= this.this$0.highlightThreshold;
                    if (highlight) {
                        this.textLabel.setFont(this.textLabel.getFont().deriveFont(1));
                    }
                    boolean bl3 = isJuniorSynonym = this.this$0.parent.getSynSchID() > 0 && this.this$0.sbdb.getSynonymService().getPreferredTerm(this.this$0.parent.getSynSchID(), taxon.getSpecID(), this.this$0.sbdb.getTaxonService()).isPresent();
                    if (isJuniorSynonym) {
                        this.textLabel.setForeground(isSelected ? list.getSelectionForeground() : (highlight ? Color.cyan : Color.lightGray));
                    } else {
                        this.textLabel.setForeground(isSelected ? list.getSelectionForeground() : (highlight ? Color.BLUE : list.getForeground()));
                    }
                }
                catch (RuntimeException ex) {
                    ex.printStackTrace();
                }
            }
            this.removeAll();
            this.add(this.textLabel);
            this.add(Box.createHorizontalStrut(3));
            if (this.referenceIconLabel.getIcon() != null) {
                this.add(Box.createHorizontalStrut(5));
                this.add(this.referenceIconLabel);
            }
            if (this.imageIconLabel.getIcon() != null) {
                this.add(Box.createHorizontalStrut(5));
                this.add(this.imageIconLabel);
            }
            this.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
            return this;
        }
    }

    private class PicklistTooltip
    extends ImageTooltip {
        final /* synthetic */ JPanelPicklist this$0;

        PicklistTooltip(JPanelPicklist jPanelPicklist) {
            JPanelPicklist jPanelPicklist2 = jPanelPicklist;
            Objects.requireNonNull(jPanelPicklist2);
            this.this$0 = jPanelPicklist2;
            super(jPanelPicklist.jScrollPanePicklist);
        }

        @Override
        protected void refreshBalloonTip(Point p) {
            Image loadedImage;
            model3.Taxon taxon;
            TaxonImageSet imageSet;
            ImageIcon image = null;
            Point positionerLocation = new Point();
            int index = this.this$0.jListPick.locationToIndex(p);
            if (index > -1 && Arrays.stream(this.this$0.jListPick.getSelectedIndices()).anyMatch(i -> i == index) && (imageSet = this.this$0.images.get((taxon = (model3.Taxon)this.this$0.jListPick.getModel().getElementAt(index)).getSpecID())) != null && (loadedImage = imageSet.getFirstImage(this.this$0.sbdb.getImageRecordService(), this.this$0.sbdb.getImageLoader(), new Dimension(80, 80))) != null) {
                image = new ImageIcon(loadedImage);
                Rectangle cellBounds = this.this$0.jListPick.getCellBounds(index, index);
                Point cellOrigin = cellBounds.getLocation();
                SwingUtilities.convertPointToScreen(cellOrigin, this.this$0.jListPick);
                Component listCellRendererComponent = this.this$0.jListPick.getCellRenderer().getListCellRendererComponent(this.this$0.jListPick, taxon, index, false, false);
                positionerLocation.x = cellOrigin.x + listCellRendererComponent.getPreferredSize().width + 6 - this.this$0.jScrollPanePicklist.getLocationOnScreen().x;
                positionerLocation.y = cellOrigin.y - this.this$0.jScrollPanePicklist.getLocationOnScreen().y;
            }
            super.updateTip(image, positionerLocation);
        }
    }
}

