/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Rectangle2D;
import javax.swing.undo.UndoManager;
import jsbchart.block.ChartBlock;
import jsbchart.core.Chart;
import jsbchart.panel.SBPanel;
import jsbugs.ChartJPanel;
import jsbugs.GUI;
import jsbugs.chart.component.ChartToolTipUtils;
import jsbugs.chart.component.JScrollPaneChartBase;

public class JScrollPaneChart
extends JScrollPaneChartBase {
    private final ChartJPanel header;
    private final ChartJPanel rHeader;
    private final ChartJPanel corner;

    public JScrollPaneChart(ChartJPanel view) {
        this(view, new ChartJPanel(view.chart));
    }

    public JScrollPaneChart(ChartJPanel view, ChartJPanel rowHeader) {
        super(view);
        this.header = new ChartJPanel(view.chart);
        this.header.setChartMode(true, Chart.Mode.HEADER_ONLY);
        this.header.lockHorzMode();
        this.rHeader = rowHeader;
        rowHeader.setChart(view.chart);
        rowHeader.setChartMode(false, Chart.Mode.HEADER_ONLY);
        rowHeader.lockVertMode();
        this.corner = new ChartJPanel(view.chart);
        this.corner.setChartMode(true, Chart.Mode.HEADER_ONLY);
        this.corner.setChartMode(false, Chart.Mode.HEADER_ONLY);
        this.corner.lockHorzMode();
        this.corner.lockVertMode();
        this.setCorner("UPPER_LEFT_CORNER", this.corner);
        this.init();
    }

    @Override
    public void terminate() {
        super.terminate();
        this.header.terminate();
        this.rHeader.terminate();
        this.corner.terminate();
    }

    private void init() {
        this.initListeners();
    }

    @Override
    public void addJPanelMouseMotionListener(MouseMotionListener l) {
        this.view.addMouseMotionListener(l);
        this.header.addMouseMotionListener(l);
        this.rHeader.addMouseMotionListener(l);
    }

    @Override
    public void addJPanelMouseListener(MouseListener l) {
        this.view.addMouseListener(l);
        this.header.addMouseListener(l);
        this.rHeader.addMouseListener(l);
    }

    @Override
    public void addJPanelMouseWheelListener(MouseWheelListener l) {
        this.view.addMouseWheelListener(l);
        this.header.addMouseWheelListener(l);
        this.rHeader.addMouseWheelListener(l);
    }

    @Override
    public void drawXHair(MouseEvent evt) {
        this.view.drawCrosshair(evt, true, this.getEvtOrigin(evt));
        this.header.drawCrosshair(evt, false, this.getEvtOrigin(evt));
        this.rHeader.drawCrosshair(evt, false, this.getEvtOrigin(evt));
    }

    private ChartJPanel.EvtOrigin getEvtOrigin(MouseEvent evt) {
        if (evt == null) {
            return null;
        }
        if (evt.getSource() == this.view) {
            return ChartJPanel.EvtOrigin.VIEW;
        }
        if (evt.getSource() == this.header) {
            return ChartJPanel.EvtOrigin.COLUMN_HEADER;
        }
        if (evt.getSource() == this.rHeader) {
            return ChartJPanel.EvtOrigin.ROW_HEADER;
        }
        return null;
    }

    public void setPanelsToExpectChange() {
        for (ChartBlock block : this.corner.chart.getChartBlocks()) {
            for (SBPanel panel : block.getPanels()) {
                panel.setExpectingUrgentChange();
            }
        }
    }

    public void setPanelsToNotExpectChange() {
        for (ChartBlock block : this.corner.chart.getChartBlocks()) {
            for (SBPanel panel : block.getPanels()) {
                panel.setDontExpectingUrgentChange();
            }
        }
    }

    public void setHeader(boolean colHeader, boolean display) {
        ChartJPanel h = colHeader ? this.header : this.rHeader;
        ChartJPanel other = colHeader ? this.rHeader : this.header;
        h.setChart(this.view.chart);
        if (!display) {
            if (colHeader) {
                this.setColumnHeaderView(null);
            } else {
                this.setRowHeaderView(null);
            }
            this.view.setChartMode(colHeader, Chart.Mode.NORMAL);
            other.setChartMode(colHeader, Chart.Mode.NORMAL);
            this.view.setSize();
            return;
        }
        if (colHeader) {
            int headerWidth = (int)this.getViewport().getViewSize().getWidth();
            int headerHeight = (int)(h.chart.getHeaderHeight() * 2.8346457f * h.getZoom()) + 1;
            h.setPreferredSize(new Dimension(headerWidth, headerHeight));
            this.setColumnHeaderView(this.header);
        } else {
            int headerWidth = (int)(h.chart.getRowHeaderWidth() * 2.8346457f * h.getZoom()) + 1;
            int headerHeight = (int)this.getViewport().getViewSize().getHeight();
            h.setPreferredSize(new Dimension(headerWidth, headerHeight));
            this.setRowHeaderView(this.rHeader);
        }
        this.view.setChartMode(colHeader, Chart.Mode.NO_HEADER);
        other.setChartMode(colHeader, Chart.Mode.NO_HEADER);
        this.view.setSize();
    }

    @Override
    public void setColumnHeaderView(Component comp) {
        assert (comp == null || comp == this.header);
        super.setColumnHeaderView(comp);
    }

    @Override
    public void setRowHeaderView(Component comp) {
        assert (comp == null || comp == this.rHeader);
        super.setRowHeaderView(comp);
    }

    void registerDragRecognizer(DragGestureListener listener) {
        new DragSource().createDefaultDragGestureRecognizer(this.view, 1, listener);
        new DragSource().createDefaultDragGestureRecognizer(this.header, 1, listener);
        new DragSource().createDefaultDragGestureRecognizer(this.rHeader, 1, listener);
    }

    @Override
    public void zoom(boolean in) {
        if (in) {
            this.view.getZoomManager().zoomIn();
            this.header.getZoomManager().zoomIn();
            this.rHeader.getZoomManager().zoomIn();
            this.corner.getZoomManager().zoomIn();
        } else {
            this.view.getZoomManager().zoomOut();
            this.header.getZoomManager().zoomOut();
            this.rHeader.getZoomManager().zoomOut();
            this.corner.getZoomManager().zoomOut();
        }
    }

    @Override
    public void zoomAt(boolean in, int x, int y) {
        if (in) {
            this.view.getZoomManager().zoomInAt(x, y);
            this.header.getZoomManager().zoomIn();
            this.rHeader.getZoomManager().zoomIn();
            this.corner.getZoomManager().zoomIn();
        } else {
            this.view.getZoomManager().zoomOutAt(x, y);
            this.header.getZoomManager().zoomOut();
            this.rHeader.getZoomManager().zoomOut();
            this.corner.getZoomManager().zoomOut();
        }
    }

    @Override
    public void zoomToNatural() {
        this.view.getZoomManager().resetZoom();
        this.header.getZoomManager().resetZoom();
        this.rHeader.getZoomManager().resetZoom();
        this.corner.getZoomManager().resetZoom();
    }

    @Override
    public void fitToScreen() {
        super.fitToScreen();
        this.header.getZoomManager().setZoom(this.view.getZoom());
        this.rHeader.getZoomManager().setZoom(this.view.getZoom());
        this.corner.getZoomManager().setZoom(this.view.getZoom());
    }

    @Override
    public void zoomToRect(Rectangle2D.Float rect) {
        this.view.getZoomManager().zoomToRect(rect);
        this.header.getZoomManager().setZoom(this.view.getZoom());
        this.rHeader.getZoomManager().setZoom(this.view.getZoom());
        this.corner.getZoomManager().setZoom(this.view.getZoom());
    }

    public boolean hasHeader() {
        return this.view.getMode(true) == Chart.Mode.NO_HEADER;
    }

    public boolean hasRowHeader() {
        return this.view.getMode(false) == Chart.Mode.NO_HEADER;
    }

    @Override
    protected void setToolTipText(MouseEvent evt) {
        if (evt.getComponent() == this.header) {
            this.header.setToolTipText(this.header.getTooltip(evt));
        } else if (evt.getComponent() == this.rHeader) {
            this.rHeader.setToolTipText(this.rHeader.getTooltip(evt));
        } else {
            this.view.setToolTipText(this.view.getTooltip(evt));
        }
    }

    Object getObject(MouseEvent evt) {
        if (evt.getComponent() == this.header) {
            return this.header.getObject(evt);
        }
        if (evt.getComponent() == this.rHeader) {
            return this.rHeader.getObject(evt);
        }
        return this.view.getObject(evt);
    }

    Object getObject(DragGestureEvent dge) {
        if (dge.getComponent() == this.header) {
            return this.header.getObject(dge.getDragOrigin());
        }
        if (dge.getComponent() == this.rHeader) {
            return this.rHeader.getObject(dge.getDragOrigin());
        }
        return this.view.getObject(dge.getDragOrigin());
    }

    @Override
    public void refreshView() {
        if (this.view.chart.calcChartSize()) {
            GUI.setScrollPaneSize(this.view, this.view.getZoom(), 1.25f);
            if (this.hasHeader()) {
                GUI.setScrollPaneSize(this.header, this.header.getZoom(), 1.25f);
            }
            if (this.hasRowHeader()) {
                GUI.setScrollPaneSize(this.rHeader, this.rHeader.getZoom(), 1.25f);
            }
        }
        this.view.setBackground(this.view.chart.getProperties().background);
        this.header.setBackground(this.header.chart.getProperties().background);
        this.rHeader.setBackground(this.rHeader.chart.getProperties().background);
    }

    public UndoManager getUndoManager() {
        return this.view.getUndoManager();
    }

    @Override
    public void decommissionMagnifier() {
        super.decommissionMagnifier();
        for (ChartJPanel chartJPanel : new ChartJPanel[]{this.header, this.rHeader}) {
            ChartToolTipUtils.removeListeners(chartJPanel);
        }
    }
}

