/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.util.Iterator;
import java.util.function.Consumer;
import javax.swing.JOptionPane;
import jsbugs.JPanelWell;
import jsbugs.uiutil.SBTabbedPane;
import model3.Well;
import model3.WellInterp;

public class JTabbedPaneWell
extends SBTabbedPane {
    private Consumer<JPanelWell> preRemoveHook = null;

    public void setPreRemoveHook(Consumer<JPanelWell> preRemoveHook) {
        this.preRemoveHook = preRemoveHook;
    }

    void insertTab(JPanelWell wellPanel, boolean isLogging) {
        int index = 0;
        for (int i = 0; i < this.getComponentCount(); ++i) {
            JPanelWell comp = this.getComponentAt(i);
            if (wellPanel.getWell().getWellName().compareTo(comp.getWell().getWellName()) < 0 || wellPanel.getWell().getWellName().compareTo(comp.getWell().getWellName()) == 0 && wellPanel.getWell().getWellCode().compareTo(comp.getWell().getWellCode()) < 0) break;
            ++index;
        }
        String tabTooltip = "<html>" + wellPanel.getWell().getWellName() + "<br>(" + wellPanel.getWell().getWellCode() + ")</html>";
        this.insertTab(wellPanel.getTabTitle(), null, wellPanel, tabTooltip, index);
        this.setSelectedComponent(wellPanel);
        wellPanel.tableModelOcc.setLogging(isLogging, wellPanel.getOccTable());
    }

    @Override
    public boolean closeTabAt(int index, boolean force) {
        if (this.getTabCount() == 1 && !force) {
            JOptionPane.showMessageDialog(null, "Cannot remove - there is only one well tab.", "Close Well", 2);
            return false;
        }
        if (this.preRemoveHook != null) {
            JPanelWell panel = this.getComponentAt(index);
            this.preRemoveHook.accept(panel);
        }
        JPanelWell wellPanel = this.getComponentAt(index);
        wellPanel.removeChart();
        wellPanel.closeOverlayServer();
        wellPanel.well.deleteObserver(wellPanel);
        Iterator<WellInterp> interpIterator = wellPanel.well.getInterpIterator();
        while (interpIterator.hasNext()) {
            WellInterp interp = interpIterator.next();
            interp.deleteObserver(wellPanel);
            interp.deleteObserver(wellPanel.jPanelInterpretations);
        }
        wellPanel.terminate();
        this.remove(wellPanel);
        return true;
    }

    public boolean removeWell(Well well) {
        int indexOfWell = -1;
        for (int i = 0; i < this.getTabCount(); ++i) {
            JPanelWell wellPanel = this.getComponentAt(i);
            if (wellPanel.getWell().getWellID() != well.getWellID()) continue;
            indexOfWell = i;
            break;
        }
        if (indexOfWell > -1) {
            this.removeTabAt(indexOfWell);
            return true;
        }
        return false;
    }

    @Override
    public JPanelWell getComponentAt(int index) {
        return (JPanelWell)super.getComponentAt(index);
    }
}

