/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Objects;
import java.util.Observable;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.border.Border;
import jsbugs.LithologyCellRenderer;
import jsbugs.LithologyTransferHandler;
import model3.Lithology;

public class LithologyJPanel
extends JPanel
implements DragGestureListener {
    final SelectedLithology selected = new SelectedLithology(this);
    static final int CELL_WIDTH = 50;
    static final int CELL_HEIGHT = 30;
    static final int MARGIN = 3;
    static final Border SELECTED_BORDER = BorderFactory.createMatteBorder(3, 3, 3, 3, Color.RED);
    static final Border EMPTY_BORDER = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2), BorderFactory.createMatteBorder(1, 1, 1, 1, Color.GRAY));
    private LithologyContainer selectedContainer;

    LithologyJPanel(List<Lithology> liths) {
        super(new FlowLayout(0, 0, 0));
        this.addLithologies(liths);
        this.setTransferHandler(new LithologyTransferHandler());
        DragSource ds = new DragSource();
        ds.createDefaultDragGestureRecognizer(this, 0x40000000, this);
        this.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ LithologyJPanel this$0;
            {
                LithologyJPanel lithologyJPanel = this$0;
                Objects.requireNonNull(lithologyJPanel);
                this.this$0 = lithologyJPanel;
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                this.this$0.mClicked(evt);
            }
        });
    }

    private void addLithologies(List<Lithology> liths) {
        this.removeAll();
        for (Lithology lith : liths) {
            LithologyCellRenderer lcr = new LithologyCellRenderer();
            lcr.setPreferredSize(new Dimension(50, 30));
            lcr.lithology = lith;
            LithologyContainer container = new LithologyContainer(this, lcr);
            container.setBorder(EMPTY_BORDER);
            this.add(container);
        }
    }

    @Override
    public Component add(Component comp) {
        if (comp instanceof LithologyContainer) {
            return super.add(comp);
        }
        return null;
    }

    @Override
    public void setPreferredSize(Dimension d) {
        double width = d.getWidth();
        double height = 0.0;
        double rowWidth = 0.0;
        for (Component c : this.getComponents()) {
            if (rowWidth + (double)c.getPreferredSize().width > width) {
                height += (double)c.getPreferredSize().height;
                rowWidth = 0.0;
            }
            rowWidth += (double)c.getPreferredSize().width;
        }
        if (rowWidth > 0.0) {
            height += 36.0;
        }
        super.setPreferredSize(new Dimension(200, (int)height));
    }

    private void mClicked(MouseEvent evt) {
        Component c = this.getComponentAt(evt.getPoint());
        if (c instanceof LithologyContainer) {
            LithologyContainer cont = (LithologyContainer)c;
            if (this.selectedContainer != null) {
                this.selectedContainer.setBorder(EMPTY_BORDER);
            }
            cont.setBorder(SELECTED_BORDER);
            this.selectedContainer = cont;
            LithologyCellRenderer r = cont.lcr;
            this.selected.setLithology(r.lithology);
            this.selected.notifyObservers();
        }
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dge) {
        LithologyTransferHandler h = (LithologyTransferHandler)this.getTransferHandler();
        dge.startDrag(null, h.createTransferable(this));
    }

    class SelectedLithology
    extends Observable {
        private Lithology selected;

        SelectedLithology(LithologyJPanel this$0) {
            Objects.requireNonNull(this$0);
        }

        void setLithology(Lithology l) {
            if (this.selected != l) {
                this.selected = l;
                this.setChanged();
            }
        }

        Lithology getLithology() {
            return this.selected;
        }
    }

    private class LithologyContainer
    extends JPanel {
        LithologyCellRenderer lcr;
        final /* synthetic */ LithologyJPanel this$0;

        LithologyContainer(LithologyJPanel lithologyJPanel, LithologyCellRenderer lcr) {
            LithologyJPanel lithologyJPanel2 = lithologyJPanel;
            Objects.requireNonNull(lithologyJPanel2);
            this.this$0 = lithologyJPanel2;
            super(new FlowLayout(0, 0, 0));
            this.lcr = lcr;
            super.add(lcr);
        }

        @Override
        public Component add(Component comp) {
            return null;
        }
    }
}

